#!perl

use strict;
use warnings;

use Test::More tests => 220;

use Math::BigInt;

while (<DATA>) {
    s/#.*$//;                   # remove comments
    s/\s+$//;                   # remove trailing whitespace
    next unless length;         # skip empty lines

    my ($x_str, $expected) = split /:/;
    my ($x, $str);

    {
        my $test = qq|\$x = Math::BigInt -> new("$x_str");|
                 . qq| \$str = \$x -> bnstr();|;

        note "\n$test\n\n";
        eval $test;

        is($str, $expected, qq|input value is "$x_str"|);
        is($x,   $x_str, "input object is unmodified");
    }

}

__DATA__

NaN:NaN

inf:inf
-inf:-inf

0:0e+0

# positive numbers

1:1e+0
10:1e+1
100:1e+2
1000:1e+3
10000:1e+4
100000:1e+5
1000000:1e+6
10000000:1e+7
100000000:1e+8
1000000000:1e+9
10000000000:1e+10
100000000000:1e+11
1000000000000:1e+12

12:1.2e+1
120:1.2e+2
1200:1.2e+3
12000:1.2e+4
120000:1.2e+5
1200000:1.2e+6
12000000:1.2e+7
120000000:1.2e+8
1200000000:1.2e+9
12000000000:1.2e+10
120000000000:1.2e+11
1200000000000:1.2e+12

123:1.23e+2
1230:1.23e+3
12300:1.23e+4
123000:1.23e+5
1230000:1.23e+6
12300000:1.23e+7
123000000:1.23e+8
1230000000:1.23e+9
12300000000:1.23e+10
123000000000:1.23e+11
1230000000000:1.23e+12

1234:1.234e+3
12340:1.234e+4
123400:1.234e+5
1234000:1.234e+6
12340000:1.234e+7
123400000:1.234e+8
1234000000:1.234e+9
12340000000:1.234e+10
123400000000:1.234e+11
1234000000000:1.234e+12

3:3e+0
31:3.1e+1
314:3.14e+2
3141:3.141e+3
31415:3.1415e+4
314159:3.14159e+5
3141592:3.141592e+6

# negative numbers

-1:-1e+0
-10:-1e+1
-100:-1e+2
-1000:-1e+3
-10000:-1e+4
-100000:-1e+5
-1000000:-1e+6
-10000000:-1e+7
-100000000:-1e+8
-1000000000:-1e+9
-10000000000:-1e+10
-100000000000:-1e+11
-1000000000000:-1e+12

-12:-1.2e+1
-120:-1.2e+2
-1200:-1.2e+3
-12000:-1.2e+4
-120000:-1.2e+5
-1200000:-1.2e+6
-12000000:-1.2e+7
-120000000:-1.2e+8
-1200000000:-1.2e+9
-12000000000:-1.2e+10
-120000000000:-1.2e+11
-1200000000000:-1.2e+12

-123:-1.23e+2
-1230:-1.23e+3
-12300:-1.23e+4
-123000:-1.23e+5
-1230000:-1.23e+6
-12300000:-1.23e+7
-123000000:-1.23e+8
-1230000000:-1.23e+9
-12300000000:-1.23e+10
-123000000000:-1.23e+11
-1230000000000:-1.23e+12

-1234:-1.234e+3
-12340:-1.234e+4
-123400:-1.234e+5
-1234000:-1.234e+6
-12340000:-1.234e+7
-123400000:-1.234e+8
-1234000000:-1.234e+9
-12340000000:-1.234e+10
-123400000000:-1.234e+11
-1234000000000:-1.234e+12

-3:-3e+0
-31:-3.1e+1
-314:-3.14e+2
-3141:-3.141e+3
-31415:-3.1415e+4
-314159:-3.14159e+5
-3141592:-3.141592e+6
