#
# Copyright (C) 1997 Ken MacLeod
# See the file COPYING for distribution terms.
#
# $Id: SPGroveBuilder.pm,v 1.1.1.1 1998/01/17 23:47:37 ken Exp $
#

package SGML::SPGroveBuilder;

require Exporter;
require DynaLoader;

@ISA = qw(Exporter DynaLoader);

$VERSION = '2.01';

bootstrap SGML::SPGroveBuilder $VERSION;

1;
__END__

=head1 NAME

SGML::SPGrove - load an SGML, XML, or HTML document

=head1 SYNOPSIS

  use SGML::SPGroveBuilder;
  $grove = SGML::SPGroveBuilder->new ($sysid);
  $root = $grove->root;
  $errors = $grove->errors;
  $entities = $grove->entities;
  $notations = $grove->notations;

  Other grove methods defined by SGML::Grove:

  $grove->as_string([$context, ...]);

  $grove->iter;

  $grove->accept($visitor, ...);
  $grove->accept_gi($visitor, ...);
  $grove->children_accept($visitor, ...);
  $grove->children_accept_gi($visitor, ...);

=head1 DESCRIPTION

C<new> loads an SGML, XML, or HTML document instance from C<$sysid>
using James Clark's SGML Parser (SP), returning a ``grove'' that
contains the root, or top, element of the document, an array of any
warnings or errors that may have been generated while parsing the
document, and arrays of notations and entities used within the
document.

C<$sysid> is most often the file name of the SGML instance to be
parsed, but can be any of the ids described in ``System Identifiers''
in SP's documentation.  For example, C<$sysid> can also be a URL,
`C<->' for standard input, a literal string
("C<E<lt>LITERALE<gt>$scalar>"), or a formal system identifier.

C<$grove-E<gt>root> returns the C<SGML::Element> of the outermost
element of the document.

C<$grove-E<gt>errors> returns a reference to an array containing any
errors generated by SP or SGML::SPGroveBuilder while parsing the
document or building the grove.

C<$grove-E<gt>entities> returns a reference to a hash containing any
entities referenced in this grove (as opposed to entities that may
have been declared but not used).

C<$grove-E<gt>notations> returns a reference to an array containing
any notations referenced in this grove.

Refer to SGML::Grove for details of C<as_string>, C<iter>, C<accept>,
C<accept_gi>, C<children_accept>, C<children_accept_gi>.

=head1 AUTHOR

Ken MacLeod, ken@bitsko.slc.ut.us

=head1 SEE ALSO

perl(1), SGML::Grove(3)
<http://www.jclark.com/sp/>
<http://www.jclark.com/sp/sysid.htm>

=cut
