# Generated by default/object.tt
package Paws::CloudFront::TestResult;
  use Moose;
  has ComputeUtilization => (is => 'ro', isa => 'Str');
  has FunctionErrorMessage => (is => 'ro', isa => 'Str');
  has FunctionExecutionLogs => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has FunctionOutput => (is => 'ro', isa => 'Str');
  has FunctionSummary => (is => 'ro', isa => 'Paws::CloudFront::FunctionSummary');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::TestResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::TestResult object:

  $service_obj->Method(Att1 => { ComputeUtilization => $value, ..., FunctionSummary => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::TestResult object:

  $result = $service_obj->Method(...);
  $result->Att1->ComputeUtilization

=head1 DESCRIPTION

Contains the result of testing a CloudFront function with
C<TestFunction>.

=head1 ATTRIBUTES


=head2 ComputeUtilization => Str

The amount of time that the function took to run as a percentage of the
maximum allowed time. For example, a compute utilization of 35 means
that the function completed in 35% of the maximum allowed time.


=head2 FunctionErrorMessage => Str

If the result of testing the function was an error, this field contains
the error message.


=head2 FunctionExecutionLogs => ArrayRef[Str|Undef]

Contains the log lines that the function wrote (if any) when running
the test.


=head2 FunctionOutput => Str

The event object returned by the function. For more information about
the structure of the event object, see Event object structure
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html)
in the I<Amazon CloudFront Developer Guide>.


=head2 FunctionSummary => L<Paws::CloudFront::FunctionSummary>

Contains configuration information and metadata about the CloudFront
function that was tested.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

