# Generated by default/object.tt
package Paws::NetworkFirewall::ActionDefinition;
  use Moose;
  has PublishMetricAction => (is => 'ro', isa => 'Paws::NetworkFirewall::PublishMetricAction');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::ActionDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::ActionDefinition object:

  $service_obj->Method(Att1 => { PublishMetricAction => $value, ..., PublishMetricAction => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::ActionDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->PublishMetricAction

=head1 DESCRIPTION

A custom action to use in stateless rule actions settings. This is used
in CustomAction.

=head1 ATTRIBUTES


=head2 PublishMetricAction => L<Paws::NetworkFirewall::PublishMetricAction>

Stateless inspection criteria that publishes the specified metrics to
Amazon CloudWatch for the matching packet. This setting defines a
CloudWatch dimension value to be published.

You can pair this custom action with any of the standard stateless rule
actions. For example, you could pair this in a rule action with the
standard action that forwards the packet for stateful inspection. Then,
when a packet matches the rule, Network Firewall publishes metrics for
the packet and forwards it.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

