# Generated by default/object.tt
package Paws::AuditManager::Settings;
  use Moose;
  has DefaultAssessmentReportsDestination => (is => 'ro', isa => 'Paws::AuditManager::AssessmentReportsDestination', request_name => 'defaultAssessmentReportsDestination', traits => ['NameInRequest']);
  has DefaultProcessOwners => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::Role]', request_name => 'defaultProcessOwners', traits => ['NameInRequest']);
  has IsAwsOrgEnabled => (is => 'ro', isa => 'Bool', request_name => 'isAwsOrgEnabled', traits => ['NameInRequest']);
  has KmsKey => (is => 'ro', isa => 'Str', request_name => 'kmsKey', traits => ['NameInRequest']);
  has SnsTopic => (is => 'ro', isa => 'Str', request_name => 'snsTopic', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Settings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Settings object:

  $service_obj->Method(Att1 => { DefaultAssessmentReportsDestination => $value, ..., SnsTopic => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Settings object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultAssessmentReportsDestination

=head1 DESCRIPTION

The settings object that holds all supported AWS Audit Manager
settings.

=head1 ATTRIBUTES


=head2 DefaultAssessmentReportsDestination => L<Paws::AuditManager::AssessmentReportsDestination>

The default storage destination for assessment reports.


=head2 DefaultProcessOwners => ArrayRef[L<Paws::AuditManager::Role>]

The designated default audit owners.


=head2 IsAwsOrgEnabled => Bool

Specifies whether AWS Organizations is enabled.


=head2 KmsKey => Str

The AWS KMS key details.


=head2 SnsTopic => Str

The designated Amazon Simple Notification Service (Amazon SNS) topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

