# Generated by default/object.tt
package Paws::Glue::TransformEncryption;
  use Moose;
  has MlUserDataEncryption => (is => 'ro', isa => 'Paws::Glue::MLUserDataEncryption');
  has TaskRunSecurityConfigurationName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::TransformEncryption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::TransformEncryption object:

  $service_obj->Method(Att1 => { MlUserDataEncryption => $value, ..., TaskRunSecurityConfigurationName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::TransformEncryption object:

  $result = $service_obj->Method(...);
  $result->Att1->MlUserDataEncryption

=head1 DESCRIPTION

The encryption-at-rest settings of the transform that apply to
accessing user data. Machine learning transforms can access user data
encrypted in Amazon S3 using KMS.

Additionally, imported labels and trained transforms can now be
encrypted using a customer provided KMS key.

=head1 ATTRIBUTES


=head2 MlUserDataEncryption => L<Paws::Glue::MLUserDataEncryption>

An C<MLUserDataEncryption> object containing the encryption mode and
customer-provided KMS key ID.


=head2 TaskRunSecurityConfigurationName => Str

The name of the security configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

