# Generated by default/object.tt
package Paws::SageMaker::AppImageConfigDetails;
  use Moose;
  has AppImageConfigArn => (is => 'ro', isa => 'Str');
  has AppImageConfigName => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has KernelGatewayImageConfig => (is => 'ro', isa => 'Paws::SageMaker::KernelGatewayImageConfig');
  has LastModifiedTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::AppImageConfigDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::AppImageConfigDetails object:

  $service_obj->Method(Att1 => { AppImageConfigArn => $value, ..., LastModifiedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::AppImageConfigDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AppImageConfigArn

=head1 DESCRIPTION

The configuration for running a SageMaker image as a KernelGateway app.

=head1 ATTRIBUTES


=head2 AppImageConfigArn => Str

The Amazon Resource Name (ARN) of the AppImageConfig.


=head2 AppImageConfigName => Str

The name of the AppImageConfig. Must be unique to your account.


=head2 CreationTime => Str

When the AppImageConfig was created.


=head2 KernelGatewayImageConfig => L<Paws::SageMaker::KernelGatewayImageConfig>

The configuration for the file system and kernels in the SageMaker
image.


=head2 LastModifiedTime => Str

When the AppImageConfig was last modified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

