# Generated by default/object.tt
package Paws::CloudWatchEvents::PlacementStrategy;
  use Moose;
  has Field => (is => 'ro', isa => 'Str', request_name => 'field', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::PlacementStrategy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::PlacementStrategy object:

  $service_obj->Method(Att1 => { Field => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::PlacementStrategy object:

  $result = $service_obj->Method(...);
  $result->Att1->Field

=head1 DESCRIPTION

The task placement strategy for a task or service. To learn more, see
Task Placement Strategies
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html)
in the Amazon Elastic Container Service Developer Guide.

=head1 ATTRIBUTES


=head2 Field => Str

The field to apply the placement strategy against. For the spread
placement strategy, valid values are instanceId (or host, which has the
same effect), or any platform or custom attribute that is applied to a
container instance, such as attribute:ecs.availability-zone. For the
binpack placement strategy, valid values are cpu and memory. For the
random placement strategy, this field is not used.


=head2 Type => Str

The type of placement strategy. The random placement strategy randomly
places tasks on available candidates. The spread placement strategy
spreads placement across available candidates evenly based on the field
parameter. The binpack strategy places tasks on available candidates
that have the least available amount of the resource that is specified
with the field parameter. For example, if you binpack on memory, a task
is placed on the instance with the least amount of remaining memory
(but still enough to run the task).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

