# Generated by default/object.tt
package Paws::CostExplorer::AnomalySubscription;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has Frequency => (is => 'ro', isa => 'Str', required => 1);
  has MonitorArnList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Subscribers => (is => 'ro', isa => 'ArrayRef[Paws::CostExplorer::Subscriber]', required => 1);
  has SubscriptionArn => (is => 'ro', isa => 'Str');
  has SubscriptionName => (is => 'ro', isa => 'Str', required => 1);
  has Threshold => (is => 'ro', isa => 'Num', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::AnomalySubscription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::AnomalySubscription object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Threshold => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::AnomalySubscription object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

The association between a monitor, threshold, and list of subscribers
used to deliver notifications about anomalies detected by a monitor
that exceeds a threshold. The content consists of the detailed metadata
and the current status of the C<AnomalySubscription> object.

=head1 ATTRIBUTES


=head2 AccountId => Str

Your unique account identifier.


=head2 B<REQUIRED> Frequency => Str

The frequency at which anomaly reports are sent over email.


=head2 B<REQUIRED> MonitorArnList => ArrayRef[Str|Undef]

A list of cost anomaly monitors.


=head2 B<REQUIRED> Subscribers => ArrayRef[L<Paws::CostExplorer::Subscriber>]

A list of subscribers to notify.


=head2 SubscriptionArn => Str

The C<AnomalySubscription> Amazon Resource Name (ARN).


=head2 B<REQUIRED> SubscriptionName => Str

The name for the subscription.


=head2 B<REQUIRED> Threshold => Num

The dollar value that triggers a notification if the threshold is
exceeded.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

