#!/usr/bin/perl
use strict;
use lib './lib';
use Web::Authenticate::User::Storage::Handler::SQL;
use Web::Authenticate::Session::Storage::Handler::SQL;
use Web::Authenticate::User;
use Web::Authenticate::Session::Handler;
use Web::Authenticate;
use DBIx::Raw;
use Web::Authenticate::User::CredentialVerifier::LengthCredentialVerifier;

        my $dbix_raw = DBIx::Raw->new(dsn => 'dbi:mysql:test:127.0.0.1:3306', user => 'root', password => 'forget1');
        my $user_sh = Web::Authenticate::User::Storage::Handler::SQL->new(dbix_raw => $dbix_raw, columns => [qw/age is_admin/]);
        my $storage_handler = Web::Authenticate::Session::Storage::Handler::SQL->new(dbix_raw => $dbix_raw, columns => [qw/session_data/], user_storage_handler => $user_sh);
        my $session_handler = Web::Authenticate::Session::Handler->new(session_storage_handler => $storage_handler);
        my $web_authenticate = Web::Authenticate->new(
            user_storage_handler => $user_sh,
            session_handler => $session_handler,
            after_login_url => 'http://localhost/logged_in.cgi',
            after_logout_url => 'http://127.0.0.1/',
            login_url => 'http://localhost/login.cgi',
        );  

my $length = Web::Authenticate::User::CredentialVerifier::LengthCredentialVerifier->new(min_length => -2, max_length => -4);

my $result = $web_authenticate->create_user(username =>'yo', password =>'ab', user_values => {is_admin => 1}, username_verifiers => [$length], password_verifiers => [$length]);

        if ($result->success) {
            print "Success\n";
            exit;
        }

        print "username errors: \n";
        for my $verifier (@{$result->failed_username_verifiers}) {
            print "\t" . $verifier->error_msg . "\n";
        }

        print "password errors: \n";
        for my $verifier (@{$result->failed_password_verifiers}) {
            print "\t" . $verifier->error_msg . "\n";
        }


exit;


my $user = Web::Authenticate::User->new(id => 1, row => {});
#$storage_handler->invalidate_user_sessions($user);
#exit;
my $session = $storage_handler->store_session($user, 'session_id', 1234, {session_data =>'session_data'});
exit;
#
#
#$storage_handler->update_expires('session_id', '12345');
#exit;
#my $session = $storage_handler->load_session('yo');
my $session = $storage_handler->delete_session('Z2G5Sv1qMvbQK6gXQT7KBS7Da5PDQi70xEq9LRvQ5Vq');

print $session->id;
print "\n";

print $session->expires;
print "\n";

print $session->user->id;
print "\n";

print $session->user->row->{age};
print "\n";

print $session->row->{session_data};
print "\n";
