# /=====================================================================\ #
# | NNexus Autolinker                                                   | #
# | Indexing Plug-in, Wikipedia.org domain                              | #
# |=====================================================================| #
# | Part of the Planetary project: http://trac.mathweb.org/planetary    | #
# |  Research software, produced as part of work done by:               | #
# |  the KWARC group at Jacobs University                               | #
# | Copyright (c) 2012                                                  | #
# | Released under the MIT License (MIT)                                | #
# |---------------------------------------------------------------------| #
# | Adapted from the original NNexus code by                            | #
# |                                  James Gardner and Aaron Krowne     | #
# |---------------------------------------------------------------------| #
# | Deyan Ginev <d.ginev@jacobs-university.de>                  #_#     | #
# | http://kwarc.info/people/dginev                            (o o)    | #
# \=========================================================ooo==U==ooo=/ #
package NNexus::Index::Wikipedia::Lists;

use warnings;
use strict;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw($wiki_category_blacklist $wiki_category_whitelist);

# 0. Special Blacklist for Wikipedia categories:
our $wiki_category_blacklist = {map {$_=>1}
qw(Pattern_matching Computer_algebra_systems Data_mining_and_machine_learning_software
Audio_editors Digital_signal_processors Image_processing Speech_processing
Speech_recognition Video_processing Voice_technology File_sharing_networks
Computer-aided_design Geographic_information_systems Graph_drawing Researchers_in_geometric_algorithms
Numerical_software Pattern_matching_programming_languages String_matching_algorithms
Molecular_dynamics Internet_search_algorithms Statistical_software Buildings_and_structures_by_shape
Numerology Telephone_numbers Audio_codecs MP3 Video_codecs Broken_block_ciphers Broken_stream_ciphers
Ciphers OS_X_audio_editors Digital_audio_workstation_software Computer_vision
Digital_photography Graphics_file_formats Medical_imaging Speech_processing_software 
Speech_synthesis Video_compression BitTorrent Distributed_data_storage Gnutella
CAD_file_formats Computer-aided_design_software Earth_sciences_graphics_software Geocodes
GIS_file_formats GIS_software OpenStreetMap Geographic_information_systems_organizations
Web_mapping Graph_drawing_software Data_analysis_software Econometrics_software Free_statistical_software
Plotting_software Statistical_programming_languages Time_series_software Basilicas
Cubic_buildings Domes Octagonal_buildings Pyramids Rotundas Round_barns Towers Twisted_buildings_and_structures
Top_lists Bible_code Telephone_numbers_by_country North_American_Numbering_Plan Telephone_directory_publishing_companies
Telephone_number_stubs Digital_audio_players Video_conversion_software Classical_ciphers Block_ciphers
Stream_ciphers Uncracked_codes_and_ciphers Ableton_Live
Applications_of_computer_vision Computer_vision_research_infrastructure Digital_cameras
Image_sensors Photo_software Adobe_Flash Contrast_agents Electrophysiology Magnetic_resonance_imaging
Medical_photography_and_illustration Nuclear_medicine Radiography Speech_synthesis_software
BitTorrent_clients BitTorrent_websites Cloud_storage Distributed_data_storage_systems Free_computer-aided_design_software
Electronic_design_automation_software Virtual_globes Geolocation ISO_3166 Lists_of_postal_codes
Nomenclature_of_Territorial_Units_for_Statistics Spatial_databases Web_Map_Services
Fortran R_(programming_language) Spreadsheet_software Data_visualization_software Light
Radiation Sound Water_waves Twelve-tone_and_serial_composers Ecclesiastical_basilicas Secular_basilicas
Aqueducts Arch_bridges Bridge-tunnels Cable-stayed_bridges Covered_bridges Girder_bridges
Moveable_bridges Navigable_aqueducts Skew_bridges Suspension_bridges Swing_bridges Truss_bridges
Viaducts Astronomical_observatories Covered_stadiums Geologic_domes Mosques Planetaria Octagonal_buildings_in_Canada
Octagon_houses Octagonal_buildings_in_the_United_States Ziggurats Round_barns_in_the_United_States Towers_by_country
Bell_towers Chimneys Clock_towers Communication_towers Defunct_towers Fictional_towers Fire_lookout_towers
Guyed_masts Lighthouses Observation_towers Peel_towers Skyscrapers Tower_mills Water_towers Mast_stubs
Molecular_topology Graph_description_languages Mathematical_chemistry Algorithm_description_languages
Digital_signal_processing Advanced_Access_Content_System
Error_detection_and_correction Computational_physics Pseudorandom_number_generators Algorithms_on_strings
String_data_structures Gyroscopes Vestibular_system Balloons Dualism Dimensional_instruments Nothing Phenomena
Space Spacetime Structure Time Tactical_formations Statistical_data_types Rotating_machines Torque Rubik%27s_Cube
Balloons_(aircraft) Consciousness%E2%80%93matter_dualism Dichotomies Duos Technical_drawing Darkness Hesychasm
Silence Vacuum Action Cultural_trends Earliest_phenomena Events Evolution Hazards Human_development Illusions
Industrial_processes Life Motion  Periodic_phenomena Physical_phenomena Thermodynamic_processes Length Navigation
Outer_space Places Abstraction Anatomy Chaos Components Conceptual_distinctions Design Geography Mental_structures
Musical_form Objects Organizations Rhythm Skeletal_system Society Statics Systems General_relativity Special_relativity
Time_by_country Causality Cosmology Daylight_saving_time Future Horology Interregnums Time_management Nostalgia
Philosophy_of_time Power_(physics) Time_in_religion Time_travel Timekeeping Time_zones Epidemiology Official_statistics
Quality_control X-ray_scattering Carousels Engines Rotary_engines Lathes Turbines Wheels Balloon-borne_experiments
Ballooning Equal_temperaments Spiritualism Vitalism Mind%E2%80%93body_problem Art_duos Criminal_duos Entertainer_duos
Fictional_duos Filmmaking_duos Married_couples Sibling_duos Sports_duos Writing_duos Deafness Silent_film Mime
Behavior Creativity Determinism Fictional_activities Free_will Intention Motivation Planning Prevention Skills Fads
Fashion Public_opinion Style Inventions Lists_of_events Fictional_events Accidents Cancelled_projects_and_events
Causes_of_events Conflicts Controversies  Current_events Disasters  Hoaxes News Organized_events Recurring_events
Biological_evolution Memetics Sociocultural_evolution Stellar_evolution Fire Hazardous_motor_vehicle_activities
Natural_hazards Warning_systems Adolescence Adulthood Ageing Childhood Death Developmental_disabilities Infancy
Parenting Personal_development Developmental_psychology Youth Magic_(illusion) Optical_illusions Abrasive_blasting
Chemical_processes Coatings Combustion_engineering Food_processing Furnaces Glass_forming Industrial_machinery
Joining Machining Metallurgical_processes Packaging Papermaking Photographic_processes Printing_processes
Kinematics Human_height Handedness Wave_farms_in_Denmark Wave_farms_in_the_United_Kingdom
Crystallography Acceleration Linkages Mechanisms Robot_kinematics African_Pygmies Dwarfism
People_with_gigantism Growth_disorders Growth_hormones Density Compositions_for_piano_left-hand_and_orchestra
Transformation_in_fiction Bermuda_Triangle Fictional_shapeshifters Metamorphoses_in_Greek_mythology 
Wave_power Wave_farms Celestial_coordinate_system Dimers_(chemistry) Fictional_cubes Graph_databases Hemispheres
Majority Monte_Carlo_software Natural_phenol_dimers Resource_Description_Framework Fictional_family_trees Family_trees
Bible_genealogy Films_about_mathematics Mathematical_humor Mathematics_and_art Mathematics_and_mysticism 
Mathematics-related_topics_in_popular_culture Mathematics_organizations Square_One_Television Actuarial_firms Actuaries
Computational_astronomy Cheminformatics Computational_biology Computational_chemistry Computational_fluid_dynamics
Computational_neuroscience E-Science Computational_linguistics Computational_number_theory
Numerical_climate_and_weather_models Scientific_computing_researchers Cryptography_lists_and_comparisons
Applications_of_cryptography Cryptographic_attacks Cryptography_contests Cryptographers Disk_encryption
Cryptologic_education Cryptographic_hardware History_of_cryptography Key_management Kleptography
Cryptography_law Cryptography_organizations Mathematical_tools Cryptographic_protocols Cryptographic_software
Cryptography_standards Steganography Artificial_intelligence Biomedical_cybernetics Bionics Cyberneticists
Cyborgs Neural_networks Semiotics Superorganisms Financial_ratios Fixed_income_analysis Interest_rates
Biological_theorems Theoretical_biologists Musical_tuning Computer_performance Audio_electronics
Signal_processing_metrics Radar_signal_processing Transducers Cryptography_in_fiction Fictional_dimensions
Mathematics_education_reform Schools_of_mathematics Mathematics_education_television_series
Mechanical_puzzles Game_artificial_intelligence Books_about_game_theory Ballistics_experts
Bioinformaticians Biostatisticians Geodesists MathML TeX Troff Philosophy_of_artificial_intelligence
Unified_Modeling_Language Casio_calculators Graphing_calculators HP_calculators Mechanical_calculators
Programmable_calculators Sinclair_calculators Texas_Instruments_calculators
Comparisons_of_mathematical_software Formal_methods_tools Formula_editors Free_mathematics_software
Interactive_geometry_software Programming_language_theory_stubs Digital_organisms Artificial_life_models Researchers_of_artificial_life
Virtual_pets Computer_access_control_protocols Authentication_protocols Key-agreement_protocols Secure_Shell
Zero-knowledge_protocols Certificate_authorities Cryptography_conferences Anonymity_networks Cryptanalytic_software
PGP Tor_(anonymity_network) Digital_rights_management_standards Artificial_intelligence_applications Artificial_immune_systems
Artificial_intelligence_associations Automated_planning_and_scheduling Chatterbots Cognitive_architecture 
Artificial_intelligence_conferences Artificial_intelligence_in_fiction Gene_expression_programming History_of_artificial_intelligence 
Human%E2%80%93computer_interaction Intelligent_software_assistants Artificial_intelligence_laboratories Logic_programming Multi-agent_systems 
Robotics Robots Biocybernetics Homeostasis Human_homeostasis Air_traffic_control_systems Applications_of_control_engineering Automation 
Control_devices Cyborgs_in_fiction Emergent_gameplay Neural_network_software Social_networks Wikis Mathematics-related_lists Mathematics_portal
Mathematics_and_culture Mathematicians
Mathematics_and_culture
Featured_articles_on_Mathematics_Portal
History_of_mathematics_journals
Fictional_mathematicians
Mathematics_and_mysticism
Mathematical_software
Mathematics_competition_stubs
Actuarial_firms
Actuaries
Applications_of_cryptography
Cryptographic_attacks
Cryptography_contests
Disk_encryption
Cryptologic_education
Cryptographic_hardware
Key_management
Cryptography_law
Cryptography_organizations
Cryptographic_protocols
Cryptography_publications
Cryptographic_software
Cryptography_standards
Cyborgs
Semiotics
Superorganisms
Theoretical_biologists
Musical_tuning
Computer_performance
Management_science
Audio_electronics
Game_artificial_intelligence
Auctioneering
Nyaya
Biographies_and_autobiographies_of_mathematicians
Error_detection_and_correction
Consensus
Filibuster
Quorum
Actuaries_by_nationality
Mathematical_OpenType_typefaces
Philosophy_of_artificial_intelligence
Unified_Modeling_Language
Casio_calculators
Graphing_calculators
HP_calculators
Mechanical_calculators
Programmable_calculators
Sharp_Corporation_calculators
Sinclair_calculators
Texas_Instruments_calculators
Programming_language_theory_stubs
Digital_organisms
Virtual_pets
Chemistry_software
Computational_chemistry_software
Monte_Carlo_particle_physics_software
Lexical_databases
Linguistic_research_software
Computational_linguistics_researchers
Translation_databases
Word-sense_disambiguation
Advanced_Access_Content_System
Cryptographically_secure_pseudorandom_number_generators
Bletchley_Park
Code_talkers
Rotor_machines
Signals_intelligence_of_World_War_I
Signals_intelligence_of_World_War_II
Venona_project
Certificate_authorities
Quantum_cryptography_protocols
Artificial_intelligence_applications
Artificial_immune_systems
Artificial_intelligence_associations
Chatterbots
Cognitive_architecture
Computer_vision
Artificial_intelligence_conferences
Artificial_intelligence_in_fiction
Human%E2%80%93computer_interaction
Intelligent_software_assistants
Knowledge_engineering
Artificial_intelligence_laboratories
Artificial_intelligence_publications
Artificial_intelligence_researchers
Robots
Artificial_intelligence_stubs
Neural_network_software
Biocybernetics
Homeostasis
Human_homeostasis
Air_traffic_control_systems
Applications_of_control_engineering
Automation
Control_devices
Social_networks
Wikis
Systems_ecology
Industrial_ecology
Systems_theory_stubs
Experimental_economics
Federal_Reserve
Interbank_offered_rates
Biodiversity
Epidemiology
Evidence-based_medicine
Biostatistics_journals
Warp_drive_theory
Gases
Acoustic_fingerprinting
Acoustical_engineers
Acoustical_Society_of_America
Acousticians
Acoustics_software
Psychoacoustics
Cognitive_biases
Decision_theory_paradoxes
Decision-making_software
Foreign_policy
Negotiation
Policy
Voting
Simulation_games
Neutral_buoyancy_training
Simulation_software
Audio_editors
Digital_signal_processors
Pitch_modification_software
Speech_processing
Video_processing
Voice_technology
Computer_graphic_artifacts
Digital_photography
Graphics_file_formats
Image_processing_software
Medical_imaging
Noise_pollution
Actuators
Audio_transducers
Battery_(electricity)
Electrical_generators
Light-emitting_diodes
Optical_diodes
Piezoelectric_materials
Pyroelectric_materials
Sensors
Network_performance
Regular_guitar-tunings
Character_encoding
Planetary_systems
Star_systems
Universe
Electromagnetic_radiation
Induction_heating
Light
Professorships_in_thermodynamics
Psychrometrics
Anticyclones
European_windstorms
Planetary_spots
Spiral_galaxies
Tornado
Tropical_cyclones
Types_of_cyclone
Whirlpools
Radiation
Shock_waves
Water_waves
Military_strategy
Sports_strategy
Strategic_management
Computer-aided_design
Geographic_information_systems
Graph_drawing
Gyroscopes
Vestibular_system
Resource_Description_Framework
Graph_drawing_people
Theorem_proving_software_systems
Set_theoretic_programming_languages
Statistical_charts_and_diagrams
Statistical_data_agreements
Statistical_data_coding
Data_collection
Statistical_data_sets
Design_of_experiments
Fields_of_application_of_statistics
Cryptography_in_fiction
Cellular_automata_in_popular_culture
Cellular_automaton_software
Mathematical_Olympiads_in_India
Pi-related_software
Jansenists
Syllogism
Structured_English
Applied_data_mining
Data_miners
Data_mining_and_machine_learning_software
File_sharing_networks
Automatic_memory_management
Pattern_matching_programming_languages
Computational_statistics_journals
Statistical_databases
British_actuaries
Canadian_actuaries
Danish_actuaries
Russian_geodesists
BibTeX
TeX_editors
Free_TeX_software
Linux_TeX_software
TeX_software_for_OS_X
TeX_software_for_Windows
Hex_editors
Social_constructionism
Hardware_verification_languages
Monte_Carlo_software
Numerical_libraries
Numerical_analysis_software_for_Linux
Numerical_analysis_software_for_OS_X
Numerical_analysis_software_for_Windows
Numerical_programming_languages
Uncertainty_propagation_software
Metalworking_measuring_instruments
Woodworking_measuring_instruments
Darkness
Death
Hesychasm
Nihilism
Nonexistent_people
Silence
Vacuum
Whitespace
Zero
Action
Cultural_trends
Earliest_phenomena
Events
Evolution
Hazards
Human_development
Illusions
Industrial_processes
Life
Motion
Space_images
Outer_space
Personal_cameras_and_photography_in_space
Places
Space_portal
Anatomy
Buildings_and_structures
Components
Conceptual_distinctions
Design
Geography
Hierarchy
Mental_structures
Musical_form
Objects
Organizations
Patterns
Rhythm_and_meter
Society
Statics
Systems
Wikipedia_books_on_structure
Time_by_country
Causality
Cosmology
Daylight_saving_time
Future
Horology
Interregnums
Time_management
Time_measurement_systems
Nostalgia
Orders_of_magnitude_(time)
Past
Philosophy_of_time
Time_in_religion
Time_travel
Timekeeping
Computer_algebra_system_software_for_Linux
Computer_algebra_system_software_for_OS_X
Computer_algebra_system_software_for_Windows
Free_computer_algebra_systems
Virtual_baby_video_games
Astronomical_catalogues
Biobanks
Bioinformatics_companies
Bioinformatics_software
Biological_sequence_format
Biomedical_informatics_journals
Biorepositories
Biological_databases
Metagenomics_software
Omics
Bioinformatics_organizations
Phylogenetics
Structural_bioinformatics
Bioinformatics_stubs
Molecular_dynamics_software
Theoretical_chemists
Brain%E2%80%93computer_interfacing
Neuroprosthetics
Evaluation_of_machine_translation
Machine_translation_software_for_Linux
Translation_software
Corpus_linguistics
Natural_language_processing_software
Tasks_of_natural_language_processing
Devices_capable_of_speech_recognition
Speech_recognition_software
Digital_signature_schemes
Public-key_encryption_schemes
Zero-knowledge_protocols
EMV
NIST_hash_function_competition
Authenticated-encryption_schemes
Message_authentication_codes
Advanced_Encryption_Standard
Fictional_languages
Cipher-machine_cryptographers
Government_Communications_Headquarters_cryptographers
Undeciphered_writing_systems
Belief_revision
Knowledge_representation_languages
Knowledge_representation_software
Mereology
Microformats
Minimum_Information_Standards
Semantic_desktop
Thesauri
Constraint_programming
Inductive_logic_programming
Logic_programming_languages
Logic_programming_researchers
Applied_machine_learning
Datasets_in_machine_learning
Agent-oriented_programming_languages
Botnets
Attention
Dispute_resolution
Expert_systems
Imagination
Methodology
Planning
Stack_Exchange_network
Robotics_by_company
Robotics_by_country
Adaptable_robotics
Agricultural_robotics
Android_(robot)
Robot_architectures
Articulated_robotics
Entertainment_robotics
Robotics_events
Robotics_hardware
Home_automation
Industrial_robotics
Laws_of_robotics
Robotics_lists
Robotic_manipulation
Medical_robotics
Military_robotics
Multi-robot_systems
Robotics_organizations
Physical_computing
Robotics_projects
Robot_machine_art
Roboticists
Robotics_software
Robot_sports
Robotics_templates
Wireless_robotics
Works_about_robotics
Robotics_stubs
Machinima
Complex_systems_scientists
Systems_journals
Autonomy
Devolution_in_the_United_Kingdom
Fiscal_federalism
Regionalism_(politics)
Water_privatization
Configuration_management
Failure
Process_management
Reliability_engineering
Safety_engineering
Software_engineering
Systems_architecture
Systems_engineers
Systems_Modeling_Language
Technology_systems
Warning_systems
Systems_scientists_by_nationality
Systems_ecologists
Systems_biologists
Systems_psychologists
Women_systems_scientists
Business_continuity_and_disaster_recovery
Quality_management
Free_Bayesian_statistics_software
Economic_forecasting
Econometrics_journals
Econometrics_software
Economic_databases
Economic_classification_systems
Economic_globalization_indices
Economic_indicators
Measurements_and_definitions_of_poverty
Cohort_studies
Public_choice_theory
Bills_(government_debt)
Bonds_(finance)
Notes_(finance)
Medical_data_sets
Cryobiology
Black_holes
Effects_of_gravitation
Faster-than-light_travel
Gravitational_lensing
Gravitational_waves
Gravitational-wave_astronomy
Tests_of_general_relativity
Aether_theories
Minkowski_spacetime
Overtone_flutes
Accident_analysis
Reliability_analysis
Risk_analysis_methodologies
Safety_analysis
Utilitarianism
Sequential_experiments
Transistor_modeling
HI-SEAS
Synthetic_human-made_environment
Synthetic_natural_environment
American_operations_researchers
Belgian_operations_researchers
British_operations_researchers
Canadian_operations_researchers
Dutch_operations_researchers
Hungarian_operations_researchers
Indian_operations_researchers
Israeli_operations_researchers
Turkish_operations_researchers
Biosimulation_software
Seasonality
Time_series_software
Wireless_tuning_and_filtering
Active_noise_control_mobile_phones
Minesweeper_(video_game)
Parser_generators
Actor_model
Applicative_computing_systems
Educational_abstract_machines
Persistence
Register_machines
Stack_machines
Software_metrics
Static_program_analysis
Archive_formats
Codecs
Data_compression_software
Compression_file_systems
Video_compression
File_comparison_tools
Fictional_cubes
Bermuda_Triangle
Images_of_geometric_stars
Balloons
Bubbles
Images_of_elliptic_functions
Astronomical_catalogues_of_galaxies
Lists_of_galaxies
Active_galaxies
Barred_galaxies
Galaxy_clusters
Dark_galaxies
Distant_galaxies
Dwarf_galaxies
Elliptical_galaxies
Galaxies_in_fiction
Field_galaxies
Galaxy_filaments
Hypothetical_galaxies
Galaxy_images
Interacting_galaxies
Irregular_galaxies
Lenticular_galaxies
Low_surface_brightness_galaxies
Milky_Way_Galaxy
Galaxy_morphological_types
Overlapping_galaxies
Peculiar_galaxies
Polar-ring_galaxies
Ring_galaxies
Starburst_galaxies
Galaxy_superclusters
Supermassive_black_holes
Galaxy_stubs
Electric_motors
Electromagnetic_coils
Magnetic_propulsion_devices
Transformers_(electrical)
Cooling_technology
Cryogenics
Drying
Acid-base_chemistry
PH_indicators
Clouds
Hydrates
Liquid_water
Precipitation
Snow
Water_ice
Water_in_gas
Climate
Cold
Thermal_protection
Temperature_control
Thermometers
Thermoregulation
Nuclear_fusion
Thermodynamic_cycles
State_functions
Computer_olympiads
Draughts
Janggi
Mancala
Renju
Shogi
Xiangqi
Military_tactics
Protest_tactics
Revolutionary_tactics
Sports_tactics
Free_interactive_geometry_software
Clipping_(computer_graphics)
Organism_size
Sizes_in_clothing
Geographical_centres
Center_of_population
Equal_temperaments
Tritones
Rotating_machines
Constructible_universe
Family_trees
Generic_programming
Data_types
Winners_of_the_Guy_Medal
Winners_of_the_Shewhart_Medal
Winners_of_the_Wilks_Memorial_Award
Data_analysis_software
Network_analyzers
Categorical_data
Missing_data
Official_statistics
Quality_control
Measurement_of_biodiversity
Educational_rankings
International_rankings
Sports_rankings
University_and_college_rankings
Free_statistical_software
Plotting_software
Statistical_programming_languages
Statistical_survey_software
Summary_statistics_for_categorical_data
Summary_statistics_for_contingency_tables
Survey_methodologists
Questionnaire_construction
Surveys
DC_Comics_dimensions
Dungeons_%26_Dragons_planes_of_existence
Fictional_beings_from_parallel_universes
Marvel_Comics_dimensions
Mirror_Universe_(Star_Trek)
Sudoku_competitions
Shunting_puzzle_templates
Jigsaw_puzzle_manufacturers
Rubik%27s_Cube_permutations
Speedcubers
1950s_software
1960s_software
1990s_software
2000_software
20th-century_video_games
2000s_software
Hacking_in_the_2010s
2010s_software
21st-century_video_games
MP3
Video_codecs
Basilicas
Bridges_by_structural_type
Decagonal_buildings
Domes
Hexagonal_buildings
Hyperboloid_structures
Octagonal_buildings
Pyramids
Rotundas
Round_and_octagonal_synagogues
Round_barns
Towers
Twisted_buildings_and_structures
Bible_code
Numerologists
Seven_in_the_Book_of_Revelation
Six_in_the_Book_of_Revelation
Superstitions_about_numbers
Triskaidekaphobia
Telephone_numbers_by_country
Emergency_telephone_numbers
North_American_Numbering_Plan
Telephone_directory_publishing_companies
Three-digit_telephone_numbers
Area_code_stubs
Telephone_number_stubs
National_Security_Agency_cryptographers
Signals_Intelligence_Service_cryptographers
American_actuaries
American_demographers
Fellows_of_the_American_Statistical_Association
Stanford_University_Department_of_Statistics_faculty
British_demographers
Members_of_HM_Government_Statistical_Service
Presidents_of_the_Royal_Statistical_Society
Rothamsted_statisticians
Presidents_of_the_Statistical_Society_of_Canada
French_actuaries
Government_Statisticians_of_New_Zealand
Norwegian_actuaries
Norwegian_demographers
Pakistani_actuaries
Imperial_Russian_statisticians
Swedish_actuaries
Kepler_(spacecraft)
Baseball_statisticians
Demographers
Pollsters
Psychometricians
Statistical_geneticists
Time_zones
Propositions
Constructivist_architects
Standards
Wikipedia_books_on_formal_sciences
Finite_element_software_for_Linux
Business_cycle
Chronobiology
Day
Locusts
Menstrual_cycle
Orbits
Phases_of_the_Moon
Recurring_events
Seasons
Solar_cycles
Earth_phenomena
Electrical_phenomena
Ionization
Optical_phenomena
Stellar_phenomena
Weather
Acceleration
Lists_by_length
Aids_to_navigation
Navigational_equipment
Geolocation
Maps
Northern_pole_stars
Orienteering
Polynesian_navigation
Rally_co-drivers
Robot_navigation
Route_planning_software
Southern_pole_stars
Abstract_art
Classification
Conceptual_systems
Identity
Philosophy
Unknown_content
Wikipedia_books_on_abstraction
Collation
Electric_power
Human_power
Nuclear_power
Power_control
Pulsed_power
Steam_power
Decades
Millennia
Months
Night
Years
Speed_cameras
Biological_processes
Biological_systems
Phenomics
Data_Encryption_Standard
Block_ciphers
Free_ciphers
Stream_ciphers
Dice_building_games
Argument_maps
Biomes
Ecoregions
Ecosystems
Ecozones
Flynn%27s_taxonomy
Geocodes
Geographic_taxonomies
Hertzsprung%E2%80%93Russell_classifications
K%C3%B6ppen_climate_classifications
Language_classification
Library_cataloging_and_classification
Medical_classification
Morphology
Nursing_classification
Patent_classifications
Periodic_table
Pharmacological_classification_systems
Protein_classification
Rail_transport_classification_systems
Rating_systems
Rock_mass_classification
Stock_market_indices
Systems_of_taxonomy_by_organism
Taxonomy
UNESCO_nomenclature
Wine_classification
Ontology_editors
Ontology_languages
Ontology_learning_(computer_science)
Semantic_Web_companies
Domain-specific_knowledge_representation_languages
Folksonomy
Semantic_HTML
Semantic_wikis
Triplestores
Wikipedia_books_on_Semantic_Web
Financial_markets_software
Business_analysis
Analytical_chemistry
Computer_network_analysis
Criticism
Discourse_analysis
Intelligence_analysis
Media_analysis
Medical_diagnosis
Musical_analysis
Psychoanalysis
Reasoning
Semiconductor_analysis
Software_analysis_patterns
Technical_analysis
Transactional_analysis
Valuation_(finance)
Razors_(philosophy)
Rules_of_thumb
Experimental_social_sciences
Experiments
Science_experiments
History_of_scientific_method
Hypotheses
Protoscience
Qualitative_research
Quantitative_research
Scientific_observation
Tests
Types_of_scientific_fallacy
Robotics_by_century
Years_in_robotics
Historical_robots
Robotic_sensing
Image_impedance_filters
Network_synthesis_filters
Computer_security
Locksmithing
Perimeter_security
Prisons
Secure_communication
Security_technology
Microeconometricians
Time_series_econometricians
Bond_market_indices
Environmental_indices
Globalization-related_indices
Human_Development_Index
Price_indices
Quality_of_life
Real_estate_indices
Bioelectromagnetic-based_therapies
Electric_and_magnetic_fields_in_matter
Electrochemistry
Electromagnetic_brakes_and_clutches
Electrostatics
Magnetohydrodynamics
Superconductivity
Electromagnetism_stubs
Images_of_polyhedral_nets
Polyhedra_infobox_templates
Tetris_clones
Kaaba
Hemispheres_of_the_Earth
Double_spiral_staircases
Spacecraft_attitude_control
Computer_graphics_data_structures
Second_Viennese_School
Severe_weather_and_convection
Heat_exchangers
Fictional_characters_with_fire_or_heat_abilities
Fire
Insulators
Refractory_materials
Small-angle_scattering
X-ray_scattering
Interferometry
Wave_farms
Chess_by_continent
Chess_by_country
Chess_automatons
Chess_boxing
Chess_competitions
Computer_chess
Correspondence_chess
Chess_equipment
Chess_games
History_of_chess
Chess-related_lists
Chess_organizations
Chess_people
Chess_pieces
Chess_places
Chess_players
Chess_problems
Chess_publications
Chess_rating_systems
Chess_rivalries
Chess_terminology
Chess_titles
Chess_variants
Women%27s_chess
Works_about_chess
Chess_stubs
Go_competitions
Computer_Go
Go_games
History_of_go
Go_organizations
Go_players
Go_researchers
Go_rules
Go_software
Years_in_go
Go_stubs
Go_templates
Crystallography
Mechanisms
Ray_tracing_(graphics)
Lists_by_area
Units_of_area
Density
Volumetric_instruments
Roman_tactical_formations
Tactical_formations_of_the_Napoleonic_Wars
Compositions_for_piano_left-hand_and_orchestra
Handedness_in_baseball
Southpaw_boxers
Tree_programming_languages
Auditing
Aviation_risks
Crisis
Deception
Financial_risk
Gambling
Insurance
Liability
Risk_management
Risk_factors
Analytics
Mechanism_design
Business_of_visual_arts
Concentration_of_media_ownership
Economics_of_intellectual_property
Information_economists
Information_economy
Intellectual_property_law
Mass_media_rivalries
Music_industry
Works_about_information_economics
Chauvinism
Conflict_of_interest
Media_bias
Social_stigma
National_agencies_responsible_for_GDP_measurement
Office_for_National_Statistics
Indian_Statistical_Institute
United_States_Census_Bureau
1947_software
Programming_languages_created_in_the_1940s
1951_software
1952_software
1953_software
1954_software
1958_software
1959_software
1962_software
1964_software
1966_software
1967_software
1968_software
1969_software
1970_software
1971_software
1972_software
1973_software
1974_software
1975_software
1976_software
1977_software
1978_software
1979_software
Programming_languages_created_in_the_1970s
1980_software
1981_software
1982_software
1983_software
1984_software
1985_software
1986_software
1987_software
1988_software
1989_software
Programming_languages_created_in_the_1980s
1990_software
1991_software
1992_software
1993_software
1994_software
1995_software
1996_software
1997_software
1998_software
1999_software
Programming_languages_created_in_the_1950s
Programming_languages_created_in_the_1960s
Programming_languages_created_in_the_1990s
2001_software
2002_software
2003_software
2004_software
2005_software
2006_software
2007_software
2008_software
2009_software
2010_software
2011_software
2012_software
2013_software
2014_software
Transaction_processing
Transactional_memory
SyncML
Audio_format_converters
Free_audio_codecs
Speech_codecs
Dichotomies
Dimers_(chemistry)
Duos
Trimers_(chemistry)
Tetramers_(chemistry)
Top_book_lists
Top_film_lists
Lists_of_bestsellers
Lists_of_mountains_by_elevation
Lists_of_mountains_by_isolation
Lists_of_mountains_by_prominence
Lists_of_newspapers_by_circulation
Time_(magazine)_100_Lists
Top_people_lists
Record_charts
Top_sports_lists
Top_television_lists
World_records
Galileo_affair
Galilei_family
Logic_portal
Logic_stubs
Climate_modeling
Enterprise_modelling
Scientific_simulation_software
Software_modeling_language
Software_modeling_tools
Specific_models
Specification_languages
Conformity
Systems_science_literature
Systems_sciences_organizations
Systems_psychology
Energy
Aeronautical_navigation_systems
Altitudes_in_aviation
Flight_computers
Airspeed
Idiophones
Membranophones
Chordophones
Aerophones
Electronic_musical_instruments
Hornbostel-Sachs_number_templates
Lists_of_musical_instruments_by_Hornbostel-Sachs_number
Social_science_methodology
Storm_chasing
Systematic_review
Biological_techniques_and_tools
Electroanalytical_methods
Exoplanets_detected_by_method
Laboratory_techniques
Neutron-related_techniques
Synchrotron-related_techniques
Robots_by_method_of_locomotion
Authentication_methods
Computer_access_control
Guardhouses
Identification
Dielectrics
Electric_arcs
Electric_charge
Electric_current
Electrical_breakdown
Electrification
Deaths_by_electrocution
Electrodes
Electron
Electronics
Electrotherapy
Fictional_characters_with_electric_or_magnetic_abilities
Firelighting_using_electricity
Electric_fish
Electrical_meters
People_associated_with_electricity
Electrical_safety
Electrical_systems
Electro_mechanical_engineering
Electrochemical_engineering
Electronic_engineering
Power_engineering
Audio_engineering
Automotive_electrics
Electrical_engineering_awards
Electrical_engineering_books
Electrical_circuits
Electrical_components
Electrical_enclosures
Electrical_engineering_companies
Electrical_engineers
Electrical_equipment
Electrical_equipment_manufacturers
Electrical_parameters
Electrical_power_control
Electrical_power_conversion
Electrical_tests
Gearless_electric_drive
History_of_electrical_engineering
Power_standards
Telecommunications_engineering
Magnetic_devices
Ferromagnetic_materials
Geomagnetism
Levitation
Magnetars
Magnetic_circuits
Magnetic_monopoles
Magnetic_ordering
Magneticians
Magnetoception
Magnetostatics
Types_of_magnets
X-ray_computed_tomography
Dividends
Censuses_in_Mexico
Programming_languages_created_in_1957
Galilean_moons
Connotation
Dilemmas
Interpretation_(philosophy)
Latin_logical_phrases
Logical_consequence
Relevance_fallacies
Critical_thinking
Dialectic
Philosophy_of_language
Meaning_(philosophy_of_language)
3D_computer_graphics
Anti-aliasing
ASCII_art
Color_depths
Demo_effects
Graphics_hardware
Layout_(computing)
Computer_graphics_organizations
Pointing_devices
Procedural_generation
Computer_graphics_professionals
SGI_graphics
Shading
Graphics_software
Graphics_standards
Stereoscopy
Computer_graphic_techniques
Texture_filtering
Texture_mapping
Vector_graphics
Video_game_graphics
Visual_programming_languages
Video_games_by_graphical_style
Computer_graphics_stubs
Building_information_modeling
Data_modeling_diagrams
Data_modeling_languages
Data_modeling_tools
Database_constraints
Database_models
Hydrography_by_country
Bodies_of_water
Exclusive_economic_zones
Hydrographers
Hydrography_navigational_boxes
Limnology
Oceanography
Cartography
Charts
Diagrams
Graphs_(images)
Infographics_images
Information_graphic_designers
Nutritional_advice_pyramids
Pictograms
Signage
Symbols
Molecular_modelling_software
Chemical_formulas
Computer_languages
Dance_notation
Encodings
Musical_notation
Writing_systems
Australia%27s_big_things
Scale_model_collections
Construction_toys
Dioramas
Dolls
Dummies_and_mannequins
Model_aircraft
Model_boats
Toy_cars_and_trucks
Model_horses
Model_manufacturers
Miniature_parks
Rail_transport_modelling
Model_rocketry
Radio_control
Scale_model_scales
Solar_System_models
Biology_laws
Astrophysics_theories
Biology_theories
Chemistry_theories
Communication_theory
Ecological_theories
Economic_theories
Geology_theories
Obsolete_scientific_theories
Political_science_theories
Psychological_theories
Sociological_theories
Solar_System_dynamic_theories
TRIZ
Astronomical_spectroscopy
Chromism
Emission_spectroscopy
Fluorescence
Molecular_vibration
M%C3%B6ssbauer_spectroscopy
Nuclear_magnetic_resonance
Raman_spectroscopy
Spectrographs
Spectrometers
Spectroscopists
Economics_paradoxes
Identity_paradoxes
Physical_paradoxes
Self-referential_paradoxes
Knowledge
Theories_of_truth
Quantificational_fallacies
Syllogistic_fallacies
Causal_fallacies
Verbal_fallacies
Conditional_constructs
Definitions
Vienna_Circle
Alternate_reality
Impossible_objects
Possible_worlds
Books_in_semantics
Grammatical_cases
General_semantics
Homonymy
Lexical_semantics
Mondegreens
Grammatical_moods
Nonsense
Phonaesthetics
Puns
Semanticists
Sentences_by_type
Thematic_roles
Types_of_words
Semantic_units
Optical_illusions
Data_visualization_software
Visualization_experts
Dark_matter
Theoretical_physicists
Anomalies_in_physics
Wormholes_in_fiction
Metrication_by_country
Metrication_opposition
Nuclear_interdisciplinary_topics
Isotopes
Nuclear_physics_journals
Nuclear_chemistry
Nuclear_energy
Nuclear_physicists
Nucleons
Nucleosynthesis
Radioactivity
Nuclear_technology
Nuclear_and_atomic_physics_stubs
Quantum_gravity_physicists
Lasers
Spintronics
High-temperature_superconductors
Quark_stars
Chemical_elements
Molecules
Neutron_scattering
Scattering_theory
Hypothetical_elementary_particles
Hypothetical_nuclei
Onium
Neutrino_astronomy
Neutrino_experiments
Neutrino_observatories
Numerical_software
Mathematical_optimization_software
Interactive_geometry_software
Probabilistic_software
Statistical_software
20th-century_software
21st-century_software
Finite_element_software
Agent-based_software
Regression_and_curve_fitting_software
1940s_software
1970s_software
1980s_software
1957_software
MathML
TeX
Statistical_awards)};
# Commas tip off Perl's warnings, treat separately:
$wiki_category_blacklist->{'Length,_distance,_or_range_measuring_devices'} = 1;
$wiki_category_blacklist->{'Tone,_EQ_and_filter'} = 1;
$wiki_category_blacklist->{'Heating,_ventilating,_and_air_conditioning'} = 1;


# 0. Special Blacklist for Wikipedia categories:
our $wiki_category_whitelist = { map {$_=>1}
qw(
Mathematics_portal
Mathematics-related_lists
Mathematical_examples
Applied_mathematics
Elementary_mathematics
Fields_of_mathematics
History_of_mathematics
Mathematics_literature
Mathematical_concepts
Mathematicians
Mathematical_notation
Philosophy_of_mathematics
Mathematical_problem_solving
Redirects_from_mathematical_symbols_or_equations
Mathematical_terminology
Mathematical_tools
Mathematics_stubs
Glossaries_of_mathematics
Lists_of_mathematicians
Lists_of_things_named_after_mathematicians
Statistics-related_lists
Actuarial_science
Computational_science
Cryptography
Cybernetics
Mathematical_economics
Mathematical_finance
Mathematical_and_theoretical_biology
Mathematical_chemistry
Mathematical_physics
Mathematics_in_medicine
Mathematics_of_music
Operations_research
Probability_theory
Signal_processing
Theoretical_computer_science
Applied_mathematics_stubs
Elementary_algebra
Elementary_arithmetic
Elementary_geometry
Elementary_number_theory
Algebra
Mathematical_analysis
Arithmetic
Calculus
Combinatorics
Discrete_mathematics
Dynamical_systems
Experimental_mathematics
Game_theory
Geometry
Graph_theory
Mathematical_logic
Mathematics_of_infinitesimals
Number_theory
Order_theory
Probability_and_statistics
Recreational_mathematics
Representation_theory
Topology
Mathematics_by_culture
Mathematics_by_period
History_of_algebra
History_of_calculus
History_of_computer_science
History_of_geometry
Hilbert%27s_problems
Historians_of_mathematics
Historiography_of_mathematics
History_of_logic
Mathematics_manuscripts
Mathematical_problems
History_of_statistics
Mathematics_timelines
Mathematics_books
Mathematics_journals
Logic_literature
Nicolas_Bourbaki
Mathematics_papers
Mathematics_writers
Mathematics_literature_stubs
Algorithms
Mathematical_axioms
Majority
Mathematical_objects
Mathematical_structures
Mathematical_principles
Mathematical_relations
Basic_concepts_in_set_theory
Mathematicians_by_nationality
Ancient_mathematicians
Mathematicians_by_century
Mathematicians_by_field
Medieval_mathematicians
Amateur_mathematicians
Benedictine_mathematicians
Fellows_of_the_American_Mathematical_Society
Fields_Medalists
Mathematicians_who_died_in_the_Holocaust
Mental_calculators
Pseudonymous_mathematicians
Second_Wranglers
Senior_Wranglers
Mathematicians_who_committed_suicide
Tarski_lecturers
Women_mathematicians
Mathematician_stubs
Coordinate_systems
Mathematical_markup_languages
Mathematical_symbols
Numeral_systems
Mathematical_typefaces
Z_notation
Mathematics_paradoxes
Philosophers_of_mathematics
Philosophy_of_computer_science
Structuralism_(philosophy_of_mathematics)
Theories_of_deduction
Mathematical_proofs
Mathematical_modeling
Numerical_analysis
Mathematical_theorems
Dimension
Formal_methods_terminology
Calculators
Mathematical_tables
Cryptography_stubs
Algebra_stubs
Mathematical_analysis_stubs
Category_theory_stubs
Combinatorics_stubs
Geometry_stubs
Mathematics_journal_stubs
Mathematical_logic_stubs
Number_theory_stubs
Number_stubs
Probability_stubs
Statistics_stubs
Topology_stubs
Computer_algebra
Artificial_life
Computational_astronomy
Cheminformatics
Computational_biology
Computational_chemistry
Computational_fluid_dynamics
Computational_neuroscience
Computational_physics
E-Science
Computational_linguistics
Computational_number_theory
Numerical_climate_and_weather_models
Scientific_computing_researchers
Cryptography_lists_and_comparisons
Cryptographic_algorithms
Classical_cryptography
Cryptographers
History_of_cryptography
Kleptography
Post-quantum_cryptography
Cryptographic_primitives
Public-key_cryptography
Quantum_cryptography
Randomness
Steganography
Symmetric-key_cryptography
Theory_of_cryptography
Artificial_intelligence
Artificial_neural_networks
Biomedical_cybernetics
Bionics
Control_engineering
Control_theory
Cyberneticists
Emergence
Self-organization
Systems_theory
Computational_economics
Convexity_in_economics
General_equilibrium_and_disequilibrium
Mathematical_and_quantitative_methods_(economics)
Financial_ratios
Fixed_income_analysis
Interest
Interest_rates
Monte_Carlo_methods_in_finance
Portfolio_theories
Short-rate_models
Biostatistics
Biological_theorems
Theorems_in_mathematical_physics
Chaos_theory
Equations_of_physics
Geodesic_(mathematics)
Lorentzian_manifolds
Mathematical_methods_in_general_relativity
Mathematical_quantization
Random_matrices
Schr%C3%B6dinger_equation
Spinors
Statistical_mechanics
Theory_of_relativity
Acoustics
Musical_set_theory
Decision_theory
Engineering_statistics
John_von_Neumann_Theory_Prize_winners
Linear_programming
Mathematical_optimization
Modeling_and_simulation
Network_flow
Network_theory
Operations_researchers
Queueing_theory
Scheduling_(computing)
Simulation
Travelling_salesman_problem
Algebra_of_random_variables
Central_limit_theorem
Dempster%E2%80%93Shafer_theory
Ergodic_theory
Exotic_probabilities
Large_deviations_theory
Probabilistic_inequalities
Probability_interpretations
Probability_journals
Probability_theorems
Probability_theorists
Probability_theory_paradoxes
Stochastic_algorithms
Stochastic_processes
Theory_of_probability_distributions
Detection_theory
Digital_signal_processing
Estimation_theory
Signal_processing_filter
Frequency_domain_analysis
Image_processing
Signal_processing_metrics
Noise
Radar_signal_processing
Signal_estimation
Time_domain_analysis
Time%E2%80%93frequency_analysis
Transducers
Transient_response_characteristics
Wavelets
Signal_processing_stubs
Computational_complexity_theory
Computational_learning_theory
Evolutionary_computation
Formal_languages
Formal_methods
Information_theory
Logic_in_computer_science
Mathematical_theorems_in_theoretical_computer_science
Mathematics_of_computing
Natural_computation
Pseudorandomness
Quantum_information_science
Rewriting_systems
Theoretical_computer_science_conferences
Theoretical_computer_scientists
Theory_of_computation
Unsolved_problems_in_computer_science
Theoretical_computer_science_stubs
Fractions
Means
Parity
Angle
Elementary_shapes
Euclidean_plane_geometry
Trigonometry
Elementary_geometry_stubs
Algebraists
Theorems_in_algebra
Abstract_algebra
Algebraic_graph_theory
Linear_algebra
Mathematical_identities
Polynomials
Symmetric_functions
Universal_algebra
Variables
Mathematical_analysts
Theorems_in_analysis
Algebraic_analysis
Analytic_number_theory
Asymptotic_analysis
Asymptotic_geometric_analysis
Calculus_of_variations
Complex_analysis
Computable_analysis
Differential_geometry
Differential_operators
Differential_topology
Finite_differences
Fixed_points_(mathematics)
Fourier_analysis
Fractals
Functional_analysis
Functional_equations
Functions_and_mappings
Harmonic_analysis
Limits_(mathematics)
Measure_theory
Microlocal_analysis
Non-classical_analysis
Non-standard_analysis
Norms_(mathematics)
Perturbation_theory
Real_analysis
Sequences_and_series
Binary_arithmetic
Computer_arithmetic
Division
Formal_theories_of_arithmetic
Mental_calculation
Multiplication
Ratios
Differential_calculus
Fractional_calculus
Integral_calculus
Mathematical_series
Multivariable_calculus
Non-Newtonian_calculus
Theorems_in_calculus
Theorems_in_combinatorics
Additive_combinatorics
Algebraic_combinatorics
Combinatorial_algorithms
Combinatorial_game_theory
Combinatorialists
Combinatorics_on_words
Design_theory
Enumerative_combinatorics
Factorial_and_binomial_topics
Incidence_geometry
Integer_sequences
Matroid_theory
Permutations
Q-analogs
Ramsey_theory
Set_families
Sieve_theory
Sparse_matrices
Special_functions
Sumsets
Coding_theory
Discrete_geometry
Theorems_in_discrete_mathematics
Astronomical_dynamical_systems
Bifurcation_theory
Chaotic_maps
Complex_dynamics
Critical_phenomena
Electrodynamics
Entropy
Entropy_and_information
Hamiltonian_mechanics
Limit_sets
Non-equilibrium_thermodynamics
Nonlinear_systems
Oscillation
Random_dynamical_systems
Stability_theory
Symbolic_dynamics
Theorems_in_dynamical_systems
Thermodynamic_systems
Thermodynamics
Topological_dynamics
Vortices
Waves
Bargaining_theory
Books_about_game_theory
Chess_theory
Cooperative_games
Evolutionary_game_theory
Fair_division
Game_theorists
Games_(probability)
Go_openings
Non-cooperative_games
Poker_strategy
Strategy
Topological_games
Geometers
Theorems_in_geometry
Algebraic_geometry
Analytic_geometry
Classical_geometry
Geometry_in_computer_vision
Conformal_geometry
Convex_geometry
Duality_theories
Geometric_algorithms
Geometric_graph_theory
Geometric_measurement
Geometric_objects
Homogeneous_spaces
Integral_geometry
Inversive_geometry
Metric_geometry
Molecular_geometry
Multi-dimensional_geometry
Noncommutative_geometry
Orientation
Projective_geometry
Symmetry
Technical_drawing
Transformation_(function)
Graph_coloring
Computational_problems_in_graph_theory
Graph_connectivity
Graph_data_structures
Graph_databases
Graph_enumeration
Extensions_and_generalizations_of_graphs
Extremal_graph_theory
Graph_description_languages
Graph_minor_theory
Graphs
Graph_invariants
Matching
Graph_theory_objects
Graph_operations
Random_graphs
Graph_rewriting
Theorems_in_graph_theory
Graph_theorists
Topological_graph_theory
Algebraic_logic
Automated_theorem_proving
Boolean_algebra
Logical_calculi
Categorical_logic
Classical_logic
Computability_theory
Constructivism_(mathematics)
Forcing_(mathematics)
Formal_systems
Mathematical_logic_hierarchies
Independence_results
Mathematical_induction
Large-scale_mathematical_formalization_projects
Mathematical_logicians
Modal_logic
Model_theory
Non-classical_logic
Mathematical_logic_organizations
Proof_theory
Quantification
Recursion
Set_theory
Substitution_(logic)
Theorems_in_the_foundations_of_mathematics
Type_theory
Theorems_in_number_theory
Algebraic_number_theory
Arithmetic_functions
Continued_fractions
Diophantine_approximation
Diophantine_equations
Geometry_of_numbers
Langlands_program
Lattice_points
Modular_arithmetic
Modular_forms
Multiplicative_functions
Number_theorists
Prime_numbers
Quadratic_forms
Closure_operators
Domain_theory
Lattice_theory
Optimization_of_ordered_sets
Ordered_algebraic_structures
Ordered_groups
Ordinal_numbers
Sorting_algorithms
Wellfoundedness
Probability
Statistics
Mathematics_fiction_books
Cellular_automata
Latin_squares
Logic_puzzles
Magic_squares
Mathematical_chess_problems
Mathematical_games
Mechanical_puzzles
Recreational_mathematicians
Tiling_puzzles
Theorems_in_representation_theory
Algebras
Clifford_algebras
Invariant_subspaces
Invariant_theory
Module_theory
Representation_theory_of_groups
Representation_theory_of_Lie_algebras
Algebraic_topology
Compactification
Computational_topology
Continuous_mappings
Fiber_bundles
General_topology
Geometric_topology
Homeomorphisms
Low-dimensional_topology
Manifolds
Molecular_topology
Network_topology
Sheaf_theory
Theorems_in_topology
Topological_algebra
Topologists
Trees_(topology)
Uniform_spaces
Algerian_mathematics
Aztec_mathematics
Babylonian_mathematics
Chinese_mathematics
Egyptian_mathematics
Greek_mathematics
Indian_mathematics
Islamic_mathematics
Japanese_mathematics
Korean_mathematics
Medieval_European_mathematics
Polish_mathematics
Roman_mathematics
Mathematics_of_ancient_history
Medieval_mathematics
20th_century_in_computer_science
21st_century_in_computer_science
Golden_ratio
Pi
Buddhist_logic
Jansenism
School_of_Names
Term_logic
Ancient_Greek_mathematical_works
Mathematical_works_of_medieval_Islam
Computational_problems
Named_probability_problems
Packing_problem
Unsolved_problems_in_mathematics
Cryptography_books
Encyclopedias_of_mathematics
History_books_about_mathematics
Logic_books
Series_of_mathematics_books
Statistics_books
Mathematics_textbooks
Cryptography_journals
Mathematics_education_journals
Publications_of_the_American_Mathematical_Society
Logic_journals
Algorithm_description_languages
Anti-aliasing_algorithms
Approximation_algorithms
Bioinformatics_algorithms
Calendar_algorithms
Checksum_algorithms
Classification_algorithms
Compression_algorithms
Computer_arithmetic_algorithms
Concurrent_algorithms
Data_clustering_algorithms
Data_mining
Database_algorithms
Distributed_algorithms
Evolutionary_algorithms
External_memory_algorithms
Computational_group_theory
Heuristic_algorithms
Machine_learning_algorithms
Memory_management_algorithms
Networking_algorithms
Online_algorithms
Optimization_algorithms_and_methods
Pattern_matching
Pseudo-polynomial_time_algorithms
Pseudorandom_number_generators
Quantum_algorithms
Randomized_algorithms
Root-finding_algorithms
Routing_algorithms
Scheduling_algorithms
Search_algorithms
Selection_algorithms
Statistical_algorithms
Computational_statistics
Algorithms_on_strings
Unicode_algorithms
Axiomatics_of_Euclidean_geometry
Axioms_of_modal_logic
Axioms_of_set_theory
Equations
Geometric_shapes
Infinity
Matrices
Numbers
Topological_spaces
Algebraic_structures
Category_theory
Approximations
Inequalities
Recurrence_relations
Relational_algebra
Basic_concepts_in_infinite_set_theory
Graphical_concepts_in_set_theory
Cryptographers_by_nationality
Logicians_by_nationality
Statisticians_by_nationality
African_mathematicians
18th-century_mathematicians_by_nationality
19th-century_mathematicians_by_nationality
20th-century_mathematicians_by_nationality
21st-century_mathematicians_by_nationality
Albanian_mathematicians
Algerian_mathematicians
American_mathematicians
Arab_mathematicians
Argentine_mathematicians
Armenian_mathematicians
Australian_mathematicians
Austrian_mathematicians
Azerbaijani_mathematicians
Bangladeshi_mathematicians
Basque_mathematicians
Belarusian_mathematicians
Belgian_mathematicians
Bengali_mathematicians
Bosnia_and_Herzegovina_mathematicians
Brazilian_mathematicians
British_mathematicians
Bulgarian_mathematicians
Cameroonian_mathematicians
Canadian_mathematicians
Carniolan_mathematicians
Chilean_mathematicians
Chinese_mathematicians
Colombian_mathematicians
Croatian_mathematicians
Cuban_mathematicians
Czech_mathematicians
Czechoslovak_mathematicians
Danish_mathematicians
Dutch_mathematicians
Egyptian_mathematicians
English_mathematicians
Estonian_mathematicians
Finnish_mathematicians
French_mathematicians
Mathematicians_from_Georgia_(country)
German_mathematicians
Greek_mathematicians
Hong_Kong_mathematicians
Hungarian_mathematicians
Icelandic_mathematicians
Indian_mathematicians
Iranian_mathematicians
Iraqi_mathematicians
Irish_mathematicians
Israeli_mathematicians
Italian_mathematicians
Japanese_mathematicians
Kenyan_mathematicians
Korean_mathematicians
Kurdish_mathematicians
Latvian_mathematicians
Lithuanian_mathematicians
Maldivian_mathematicians
Maltese_mathematicians
Mexican_mathematicians
Moldovan_mathematicians
Moroccan_mathematicians
Namibian_mathematicians
New_Zealand_mathematicians
Nigerian_mathematicians
Norwegian_mathematicians
Ottoman_mathematicians
Pakistani_mathematicians
Palestinian_mathematicians
Persian_mathematicians
Polish_mathematicians
Portuguese_mathematicians
Romanian_mathematicians
Russian_mathematicians
Scottish_mathematicians
Serbian_mathematicians
Singaporean_mathematicians
Slovak_mathematicians
Slovenian_mathematicians
South_African_mathematicians
South_Korean_mathematicians
Soviet_mathematicians
Spanish_mathematicians
Sri_Lankan_mathematicians
Sudanese_mathematicians
Swedish_mathematicians
Swiss_mathematicians
Syrian_mathematicians
Taiwanese_mathematicians
Tanzanian_mathematicians
Tunisian_mathematicians
Turkish_mathematicians
Ukrainian_mathematicians
Uruguayan_mathematicians
Venezuelan_mathematicians
Vietnamese_mathematicians
Welsh_mathematicians
5th-century_mathematicians
Ancient_Chinese_mathematicians
Ancient_Greek_mathematicians
Ancient_Indian_mathematicians
6th-century_mathematicians
7th-century_mathematicians
8th-century_mathematicians
9th-century_mathematicians
10th-century_mathematicians
11th-century_mathematicians
12th-century_mathematicians
13th-century_mathematicians
14th-century_mathematicians
15th-century_mathematicians
16th-century_mathematicians
17th-century_mathematicians
18th-century_mathematicians
19th-century_mathematicians
20th-century_mathematicians
21st-century_mathematicians
Italian_mathematicians_by_century
Algebraic_geometers
Ballistics_experts
Bioinformaticians
Biostatisticians
Coding_theorists
Computability_theorists
Differential_geometers
Mathematical_ecologists
Mathematical_economists
Mathematics_educators
Geodesists
Group_theorists
Information_theorists
Lattice_theorists
Model_theorists
Monte_Carlo_methodologists
Numerical_analysts
PDE_theorists
Mathematical_physicists
Proof_theorists
Queueing_theorists
Set_theorists
Statisticians
Medieval_Arab_mathematicians
Medieval_Chinese_mathematicians
Medieval_Egyptian_mathematicians
Medieval_English_mathematicians
Medieval_French_mathematicians
Medieval_German_mathematicians
Medieval_Indian_mathematicians
Medieval_Iraqi_mathematicians
Mathematicians_of_medieval_Islam
Medieval_Italian_mathematicians
Medieval_Jewish_mathematicians
Medieval_Persian_mathematicians
Medieval_Spanish_mathematicians
Medieval_Syrian_mathematicians
Medieval_Tunisian_mathematicians
Medieval_Turkic_mathematicians
Mathematicians_who_died_in_Nazi_concentration_camps
Cryptographer_stubs
Statistician_stubs
Asian_mathematician_stubs
European_mathematician_stubs
American_mathematician_stubs
Cartographic_projections
Celestial_coordinate_system
Coordinate_charts_in_general_relativity
Coordinate_systems_in_differential_geometry
Frames_of_reference
Geographic_coordinate_systems
Troff
Logic_symbols
Pythagorean_symbols
Counting_instruments
Finger_counting
Hexadecimal_numeral_system
Numerals
Positional_numeral_systems
Paradoxes_of_set_theory
Statistical_paradoxes
Pythagoreans
Constructivism
Formalism_(deductive)
Intuitionism
Article_proofs
Articles_containing_proofs
Proof_techniques
Proof_without_words
Econometric_models
Formal_specification_languages
Probability_distributions
Approximation_theory
FFT_algorithms
First_order_methods
Numerical_integration_(quadrature)
Interpolation
Iterative_methods
Mesh_generation
Monte_Carlo_methods
Numerical_differential_equations
Numerical_linear_algebra
Structural_analysis
Fundamental_theorems
Lemmas
Theorems_in_propositional_logic
Statistical_theorems
Dimension_reduction
Dimension_theory
Dimensional_analysis
Dimensional_instruments
Nothing
Phenomena
Space
Spacetime
Structure
Time
Abstract_algebra_stubs
Linear_algebra_stubs
Differential_geometry_stubs
Polychora_stubs
Polyhedron_stubs
Set_theory_stubs
Econometrics_stubs
Knot_theory_stubs
Computer_algebra_systems
Artificial_life_models
Researchers_of_artificial_life
Virtual_babies
Astronomical_databases
Virtual_observatories
Chemical_databases
Bioinformatics
Fellows_of_the_International_Society_for_Computational_Biology
Electronic_structure_methods
Force_fields
Molecular_dynamics
Quantum_chemistry
Turbulence_models
Neural_coding
Neurotechnology
Language_modeling
Machine_translation
Natural_language_generation
Natural_language_parsing
Natural_language_processing
Phonetic_algorithms
Speech_recognition
Number_theoretic_algorithms
Atmospheric_dispersion_modeling
Asymmetric-key_algorithms
Broken_cryptography_algorithms
Cryptanalytic_algorithms
Cryptographic_hash_functions
Information-theoretically_secure_algorithms
Integer_factorization_algorithms
Primality_tests
Symmetric-key_algorithms
Type_1_encryption_algorithms
Type_2_encryption_algorithms
Type_3_encryption_algorithms
Classical_ciphers
Modern_cryptographers
Pre-19th-century_cryptographers
Pre-computer_cryptographers
Recreational_cryptographers
Biuro_Szyfr%C3%B3w
Uncracked_codes_and_ciphers
Code-based_cryptography
Hash-based_cryptography
Lattice-based_cryptography
Multivariate_cryptography
Computational_hardness_assumptions
Random_number_generation
Elliptic_curve_cryptography
Identity-based_cryptography
Pairing-based_cryptography
Card_shuffling
Chaos
Cut_(cards)
Dice
Probabilistic_complexity_theory
Probabilistic_data_structures
Quasirandomness
Random_selection
Random_text_generation
Statistical_randomness
Automated_planning_and_scheduling
History_of_artificial_intelligence
Knowledge_representation
Logic_programming
Machine_learning
Multi-agent_systems
Problem_solving
Robotics
Rule_engines
Turing_tests
Classical_control
Control_theorists
Control_theory_publications
Filter_theory
Motion_control
Nonlinear_control
Optimal_control
Richard_E._Bellman_Control_Heritage_Award_recipients
Servomechanisms
Stochastic_control
Variational_analysis
Women_cyberneticists
Emergent_gameplay
Systems_analysis
Systems_theory_books
Complex_systems_theory
Decentralization
Systems_engineering
Holism
Systems_scientists
Systems_thinking
Bayesian_statistics
Econometrics
Economic_data
Economics_models
Geometric_transversal_theory
Hypothesis_testing
Panel_data
Rational_choice_theory
Simultaneous_equation_methods_(econometrics)
Single-equation_methods_(econometrics)
Interest-bearing_instruments
Medical_statistics
Pharmaceutical_statistics
Statistical_mechanics_theorems
Theorems_in_general_relativity
Theorems_in_quantum_physics
Chaos_theorists
Dirac_equation
Equations_of_fluid_dynamics
Equations_of_state
Maxwell%27s_equations
Tensors_in_general_relativity
Variational_formalism_of_general_relativity
Quantum_groups
Particle_statistics
Partition_functions
Statistical_ensembles
Statistical_field_theories
Thermodynamic_entropy
Lattice_models
Phase_transitions
Philosophy_of_thermal_and_statistical_physics
Renormalization_group
Spin_models
General_relativity
Relativists
Special_relativity
Relativity_stubs
Harmonic_series
Sound_measurements
Units_of_sound
Diatonic_set_theory
Bayesian_econometricians
Decision_trees
Loss_functions
Optimal_decisions
Prospect_theory
Risk_analysis
Utility
Polyhedra
Combinatorial_optimization
Convex_analysis
Convex_optimization
Decomposition_methods
Generalized_convexity
Optimization_in_vector_spaces
Pseudoconvex_minimization
Regression_analysis
Relaxation_(approximation)
Stochastic_optimization
Electronic_device_modeling
Human_spaceflight_analogs
Synthetic_environment
Network_analysis
Operations_researchers_by_nationality
Variational_analysts
Disk_scheduling_algorithms
Poisson_processes
Queue_management
Single_queueing_nodes
Job_scheduling
Biosimulation
Cosmological_Simulation
Real-time_simulation
Web-based_simulation
Free_probability_theory
Empirical_process
Hidden_stochastic_models
Long-memory_processes
Markov_processes
Martingale_theory
Point_processes
Spatial_processes
Stochastic_calculus
Stochastic_differential_equations
Stochastic_models
Stochastic_simulation
Time_series_analysis
Time_series_models
Variants_of_random_walks
Covariance_and_correlation
Functions_related_to_probability_distributions
Estimation_for_specific_distributions
Estimation_for_specific_parameters
Fitting_probability_distributions
Informal_estimation
Least_squares
M-estimators
Point_estimation_performance
U-statistics
Electronic_filter_applications
Electronic_filter_topology
Feature_detection
Image_compression
Image_noise_reduction_techniques
Image_segmentation
Mathematical_morphology
Noise_reduction
Biorthogonal_wavelets
Continuous_wavelets
Orthogonal_wavelets
Analysis_of_algorithms
Circuit_complexity
Complexity_classes
Computational_resources
Descriptive_complexity
NP-complete_problems
Parameterized_complexity
Quantum_complexity_theory
Strongly_NP-complete_problems
Structural_complexity_theory
Theorems_in_computational_complexity_theory
Interactive_evolutionary_computation
Dependently_typed_languages
Formal_theories
Grammar_frameworks
Parsing
Problems_on_strings
Abstract_data_types
Model_checking
Models_of_computation
Formal_methods_organizations
Formal_methods_people
Program_analysis
Program_logic
Formal_methods_publications
Satisfiability_problems
Formal_specification
Formal_methods_tools
Turing_machine
Formal_methods_stubs
Algorithmic_information_theory
Data_compression
Data_differencing
Measures_of_complexity
Quantum_information_theory
String_similarity_measures
Units_of_information
Combinatory_logic
Denotational_semantics
Logic_gates
Quantum_gates
Linear_logic
Logic_conferences
Logic_families
Programming_language_semantics
Temporal_logic
Unification_(computer_science)
Quantum_measurement
Abstract_machines
Term-rewriting_programming_languages
Researchers_in_geometric_algorithms
Automata_theory
Hypercomputation
Egyptian_fractions
Rational_functions
Units_of_angle
Circles
Cubes
Spheres
Triangles
Arbelos
Arithmetic_problems_of_plane_geometry
Compass_and_straightedge_constructions
Polygons
Tessellation
Triangle_geometry
Spherical_trigonometry
Theorems_in_linear_algebra
Theorems_in_abstract_algebra
Morphisms
Binary_operations
Ternary_operations
Commutative_algebra
Differential_algebra
Galois_theory
Group_theory
Homological_algebra
Hypercomplex_numbers
Process_calculi
Ring_theory
Semigroup_theory
Cayley_graphs
Regular_graphs
Determinants
Linear_operators
Matrix_theory
Multilinear_algebra
Singular_value_decomposition
Spectral_theory
Super_linear_algebra
Topological_vector_spaces
Vector_spaces
Vectors
Generating_functions
Homogeneous_polynomials
Orthogonal_polynomials
Hidden_variables
Variable_(computer_programming)
Approximation_theorists
Functional_analysts
Measure_theorists
Theorems_in_analytic_number_theory
Theorems_in_approximation_theory
Theorems_in_complex_analysis
Fixed-point_theorems
Theorems_in_functional_analysis
Theorems_in_harmonic_analysis
Theorems_in_measure_theory
Theorems_in_real_analysis
Tauberian_theorems
Additive_number_theory
Elliptic_functions
Gamma_and_related_functions
Zeta_and_L-functions
Asymptotic_statistical_theory
Geometric_flow
Minimal_surfaces
Morse_theory
Variational_principles
Analytic_functions
Complex_numbers
Conformal_mapping
Convergence_(mathematics)
Hardy_spaces
Meromorphic_functions
Potential_theory
Several_complex_variables
Theorems_in_differential_geometry
Characteristic_classes
Connection_(mathematics)
Curvature_(mathematics)
Curves
Differential_geometry_of_surfaces
Finsler_geometry
Lie_groupoids
Lie_groups
Riemannian_geometry
Singularity_theory
Smooth_functions
Smooth_manifolds
Symplectic_geometry
Systolic_geometry
Tensors
Theorems_in_differential_topology
Contact_geometry
Diffeomorphisms
Differential_forms
Foliations
Symplectic_topology
Fourier_series
Theorems_in_Fourier_analysis
Fractal_curves
Images_of_fractals
Banach_algebras
Convex_hulls
F-spaces
Function_spaces
Integral_equations
Integral_representations
Integral_transforms
Metric_linear_spaces
Metric_spaces
Nonlinear_functional_analysis
Operator_theory
Sequence_spaces
Topology_of_function_spaces
Functional_calculus
Euclidean_symmetries
Functors
Graphical_projections
Group_automorphisms
Transforms
Types_of_functions
Automorphic_forms
Singular_integrals
Topological_groups
Unitary_representation_theory
Limits_(category_theory)
Definitions_of_mathematical_integration
Measures_(measure_theory)
Measures_(set_theory)
Normed_spaces
Orbital_perturbations
Lipschitz_maps
Real_numbers
Addition_chains
String_(computer_science)
Summability_methods
Binary_logic
Bit_data_structures
Adders
Data_unit
Engineering_ratios
Rational_numbers
Statistical_ratios
Differential_equations
Differentiation_rules
Generalizations_of_the_derivative
Integrals
Arithmetic_series
Convergence_tests
Divergent_series
Geometric_series
Summability_theory
Partial_differential_equations
Potentials
Vector_calculus
Additive_combinatorialists
Polyhedral_combinatorics
Computational_geometry
Exchange_algorithms
Graph_algorithms
Combinatorial_game_theorists
Binary_sequences
Permutation_patterns
Configurations
Base-dependent_integer_sequences
Fibonacci_numbers
Figurate_numbers
Pseudoprimes
Triangles_of_numbers
Oriented_matroids
Braids
Permutation_groups
Serialism
Simplicial_sets
Elementary_special_functions
Hypergeometric_functions
Special_hypergeometric_functions
Theta_functions
Digital_geometry
Finite_geometry
Mathematics_of_rigidity
Theorems_in_discrete_geometry
Triangulation_(geometry)
Galaxies
Scale-invariant_systems
Electromagnetic_components
Quantum_electrodynamics
Quantum_mechanical_entropy
Transport_phenomena
Oscillators
Branches_of_thermodynamics
Calorimetry
Chemical_thermodynamics
Dimensionless_numbers_of_thermodynamics
Energetics
Engineering_thermodynamics
Enthalpy
Equilibrium_chemistry
Forms_of_water
Gas_laws
Heat_conduction
History_of_thermodynamics
Laws_of_thermodynamics
Temperature
Units_of_temperature
Thermochemistry
Thermodynamic_equations
Thermodynamic_free_energy
Thermodynamic_models
Thermodynamic_processes
Thermodynamic_properties
Thermodynamicists
Thermodynamics_literature
Thermodynamics_stubs
Wave_mechanics
Waveforms
Waves_in_plasmas
Chess_checkmates
Chess_endgames
Chess_notation
Chess_openings
Chess_rules
Chess_strategy
Chess_tactics
Chess_theoreticians
Chess_traps
Supermodular_functions
Betting_systems
Bridge_probabilities
Coin_flipping
Poker_probability
Fuseki
Joseki
Abstract_strategy_games
Tactics
Geometric_inequalities
Theorems_in_algebraic_geometry
Theorems_in_complex_geometry
Theorems_in_convex_geometry
Theorems_in_plane_geometry
Theorems_in_projective_geometry
Algebraic_curves
Algebraic_varieties
Birational_geometry
Cohomology_theories
Diophantine_geometry
Intersection_theory
Localization_(mathematics)
Moduli_theory
Real_algebraic_geometry
Scheme_theory
Structures_on_manifolds
Topological_methods_of_algebraic_geometry
Conic_sections
Affine_geometry
Euclidean_geometry
Hyperbolic_geometry
Non-Euclidean_geometry
Spherical_geometry
Riemann_surfaces
Polytopes
Adjoint_functors
Coalgebras
Self-dual_polyhedra
Computer_graphics_algorithms
Geometric_graphs
Planar_graphs
Size
Algebraic_homogeneous_spaces
Topology_of_homogeneous_spaces
Geometric_group_theory
Statistical_distance_measures
Four-dimensional_geometry
Real_object_ordering
Projective_polyhedra
Chirality
Conservation_laws
Geometric_centers
Group_actions
Musical_symmetry
Palindromes
Rotational_symmetry
Scaling_symmetries
Supersymmetry
Descriptive_geometry
Methods_of_representation
Rotation
4-chromatic_graphs
Perfect_graphs
Directed_graphs
Hypergraphs
Application-specific_graphs
Graph_families
Individual_graphs
Infinite_graphs
Music_diagrams
Hamiltonian_paths_and_cycles
Graph_products
Logical_connectives
Normal_forms_(logic)
Lambda_calculus
Topos_theory
Predicate_logic
Propositional_calculus
Effective_descriptive_set_theory
Rules_of_inference
Systems_of_formal_logic
Systems_of_set_theory
Hierarchy_of_functions
Modal_logicians
Finite_model_theory
Inner_model_theory
Many-valued_logic
Paraconsistent_logic
Substructural_logic
Methods_of_proof
Recursion_schemes
Cardinal_numbers
Descriptive_set_theory
Determinacy
Set-theoretic_universes
Trees_(set_theory)
Urelements
Polymorphism_(computer_science)
Type_inference
Type_systems
Theorems_in_algebraic_number_theory
Fermat%27s_Last_Theorem
Theorems_about_prime_numbers
Algebraic_numbers
Class_field_theory
Cyclotomic_fields
Finite_fields
Arithmetic_problems_of_solid_geometry
Quadratic_residue
Moonshine_theory
Divisor_function
Classes_of_prime_numbers
Conjectures_about_prime_numbers
Hilbert_space
Quadrics
Surgery_theory
Comparison_sorts
Online_sorts
Stable_sorts
Applied_probability
Probabilistic_arguments
Probabilistic_models
Probability_assessment
Probability_bounds_analysis
Probability_fallacies
Data_analysis
Statistical_data_types
Statistical_dependence
Statistical_deviation_and_dispersion
Statistics_education
Ethics_and_statistics
Statistical_inference
Statistical_intervals
Statistics_journals
Statistical_laws
Laymen_and_statistics
Logic_and_statistics
Meta-analysis
Statistical_methods
Misuse_of_statistics
Statistical_models
Multivariate_statistics
Non-parametric_statistics
Observational_study
Statistical_organizations
Parametric_statistics
Statistical_principles
Rankings
Robust_statistics
Sampling_(statistics)
Spatial_data_analysis
Summary_statistics
Survey_methodology
Survival_analysis
Statistical_terminology
Statistical_tests
Statistical_theory
Uncertainty_of_numbers
Fictional_dimensions
Cellular_automatists
Cellular_automaton_patterns
Cellular_automaton_rules
Sudoku
Nonograms
Shunting_puzzles
Jigsaw_puzzles
Mechanical_puzzle_cubes
Rubik%27s_Cube
Polyforms
Bialgebras
Diagram_algebras
Hopf_algebras
Non-associative_algebras
Operator_algebras
Quaternions
Geometric_algebra
Representation_theory_of_algebraic_groups
Representation_theory_of_finite_groups
Representation_theory_of_Lie_groups
Theorems_in_algebraic_topology
Digital_topology
Homology_theory
Homotopy_theory
K-theory
Knot_theory
Topology_of_Lie_groups
Maps_of_manifolds
Vector_bundles
Continuum_theory
Separation_axioms
3-manifolds
4-manifolds
Braid_groups
Complex_manifolds
Generalized_manifolds
Integration_on_manifolds
Riemannian_manifolds
Surfaces
Geometry_of_divisors
Compactness_theorems
Trees_(graph_theory)
Chinese_mathematical_discoveries
Kerala_school
Mathematics_education_in_India
1930s_in_computer_science
1940s_in_computer_science
1950s_in_computer_science
1960s_in_computer_science
1970s_in_computer_science
1980s_in_computer_science
1990s_in_computer_science
2000s_in_computer_science
2010s_in_computer_science
Pi_algorithms
Immediate_inference
Distributed_computing_problems
NL-complete_problems
NP-hard_problems
P-complete_problems
Polynomial-time_problems
PSPACE-complete_problems
Circle_packing
Sphere_packing
Conjectures
Millennium_Prize_Problems
Genetic_algorithms
Sequence_alignment_algorithms
Substring_indices
Ensemble_learning
Lossless_compression_algorithms
Lossy_compression_algorithms
Concurrency_control_algorithms
Cluster_analysis
Join_algorithms
Agreement_algorithms
Termination_algorithms
Gene_expression_programming
Genetic_programming
Dynamic_programming
Gradient_methods
Regular_expressions
String_matching_algorithms
Hashing
Internet_search_algorithms
Markov_chain_Monte_Carlo
Non-uniform_random_numbers
Variance_reduction
Parsing_algorithms
String_collation_algorithms
Axiom_of_choice
Conservation_equations
Electrochemical_equations
Exact_solutions_in_general_relativity
Buildings_and_structures_by_shape
Dot_patterns
Large_cardinals
Paradoxes_of_infinity
Supertasks
Mathematical_constants
Integers
Irrational_numbers
Large_numbers
Number-related_lists
Numerology
Separation_numbers
Telephone_numbers
Topologies_on_the_set_of_positive_integers
Properties_of_topological_spaces
Finite_groups
Non-associative_algebra
Properties_of_groups
Additive_categories
Category_theorists
Category-theoretic_categories
Closed_categories
Dagger_categories
Free_algebraic_structures
Higher_category_theory
Monoidal_categories
Objects_(category_theory)
Statistical_approximations
Statistical_inequalities
Paradoxes_of_naive_set_theory
American_cryptographers
Australian_cryptographers
Austrian_cryptographers
British_cryptographers
Cypriot_cryptographers
Dutch_cryptographers
Egyptian_cryptographers
French_cryptographers
German_cryptographers
Indian_cryptographers
Irish_cryptographers
Israeli_cryptographers
Italian_cryptographers
Pakistani_cryptographers
Polish_cryptographers
Russian_cryptographers
Swiss_cryptographers
American_logicians
Australian_logicians
Austrian_logicians
Belgian_logicians
Brazilian_logicians
British_logicians
Bulgarian_logicians
Chinese_logicians
Czech_logicians
Dutch_logicians
English_logicians
French_logicians
German_logicians
Greek_logicians
Hungarian_logicians
Icelandic_logicians
Indian_logicians
Irish_logicians
Italian_logicians
Japanese_logicians
Maltese_logicians
New_Zealand_logicians
Norwegian_logicians
Pakistani_logicians
Polish_logicians
Romanian_logicians
Russian_logicians
Scottish_logicians
Swedish_logicians
Turkish_logicians
American_statisticians
Australian_statisticians
Austrian_statisticians
Bangladeshi_statisticians
Belarusian_statisticians
Belgian_statisticians
Brazilian_statisticians
British_statisticians
Bulgarian_statisticians
Canadian_statisticians
Chinese_statisticians
Czech_statisticians
Danish_statisticians
Dutch_statisticians
Finnish_statisticians
French_statisticians
Statisticians_from_Georgia_(country)
German_statisticians
Greek_statisticians
Hungarian_statisticians
Indian_statisticians
Indonesian_statisticians
Irish_statisticians
Israeli_statisticians
Italian_statisticians
Japanese_statisticians
New_Zealand_statisticians
Norwegian_statisticians
Pakistani_statisticians
Polish_statisticians
Romanian_statisticians
Russian_statisticians
Serbian_statisticians
Singaporean_statisticians
South_African_statisticians
Swedish_statisticians
Swiss_statisticians
Taiwanese_statisticians
18th-century_British_mathematicians
18th-century_French_mathematicians
18th-century_German_mathematicians
18th-century_Italian_mathematicians
18th-century_Russian_mathematicians
18th-century_Swiss_mathematicians
19th-century_American_mathematicians
19th-century_British_mathematicians
19th-century_English_mathematicians
19th-century_French_mathematicians
19th-century_German_mathematicians
19th-century_Italian_mathematicians
19th-century_Lithuanian_mathematicians
19th-century_Polish_mathematicians
19th-century_Russian_mathematicians
19th-century_Swiss_mathematicians
20th-century_American_mathematicians
20th-century_British_mathematicians
20th-century_Italian_mathematicians
20th-century_Russian_mathematicians
21st-century_American_mathematicians
21st-century_Italian_mathematicians
African-American_mathematicians
Hollis_Chair_of_Mathematics_and_Natural_Philosophy
American_information_theorists
Stanford_University_Department_of_Mathematics_faculty
Argentine_information_theorists
Mathematicians_from_Melbourne
Austrian_information_theorists
Presidents_of_the_Associa%C3%A7%C3%A3o_Brasileira_de_Estat%C3%ADstica
Mathematicians_from_Northern_Ireland
Fellows_of_the_Institute_of_Mathematics_and_its_Applications
British_information_theorists
Presidents_of_the_London_Mathematical_Society
British_mathematician_stubs
16th-century_English_mathematicians
17th-century_English_mathematicians
18th-century_English_mathematicians
Cambridge_mathematicians
Mathematicians_from_Kingston_upon_Hull
English_statisticians
17th-century_French_mathematicians
French_information_theorists
French_mathematician_stubs
Carl_Friedrich_Gauss
German_information_theorists
German_mathematician_stubs
Israeli_information_theorists
Italian_mathematicians_by_location
Italian_information_theorists
Italian_mathematician_stubs
Japanese_information_theorists
Niels_Henrik_Abel
Pakistani_information_theorists
Polish_mathematician_stubs
Imperial_Russian_mathematicians
Russian_information_theorists
Russian_mathematician_stubs
Scottish_statisticians
Sri_Lankan_Tamil_mathematicians
Swedish_information_theorists
Welsh_statisticians
Ancient_Greek_logicians
12th-century_mathematicians_by_nationality
13th-century_mathematicians_by_nationality
14th-century_mathematicians_by_nationality
15th-century_mathematicians_by_nationality
16th-century_mathematicians_by_nationality
Nicolaus_Copernicus
Johannes_Kepler
17th-century_mathematicians_by_nationality
Gottfried_Leibniz
Bertrand_Russell
12th-century_Italian_mathematicians
13th-century_Italian_mathematicians
14th-century_Italian_mathematicians
15th-century_Italian_mathematicians
16th-century_Italian_mathematicians
17th-century_Italian_mathematicians
Fellows_of_the_Econometric_Society
General_equilibrium_theorists
Statistics_educators
Croatian_geodesists
Finnish_geodesists
Norwegian_geodesists
Polish_geodesists
Information_theorists_by_nationality
People_associated_with_the_finite_element_method
Bayesian_statisticians
Elected_Members_of_the_International_Statistical_Institute
Presidents_of_statistical_organizations
Statisticians_by_field
Brahmagupta
Mathematicians_who_worked_on_Islamic_inheritance
Scientists_who_worked_on_Qibla_determination
Equal-area_projections
Equidistant_projections
Images_of_map_projections
Astronomical_epochs
Horizontal_coordinate_system
Time_scales
Logic_symbol_templates
Logical_expressions
Units_of_amount
Non-standard_positional_numeral_systems
Pythagoreans_of_Magna_Graecia
Neo-Pythagoreans
Constructivist_architecture
Constructivism_(art)
Constructivism_(psychological_school)
Formal_sciences
Petri_nets
Synchronous_programming_languages
Characterization_of_probability_distributions
Compound_distributions
Conjugate_prior_distributions
Continuous_distributions
Discrete_distributions
Distributions_with_conjugate_priors
Exponential_family_distributions
Infinitely_divisible_probability_distributions
Multivariate_discrete_distributions
Probability_distributions_with_non-finite_variance
Stable_distributions
Systems_of_probability_distributions
Tails_of_probability_distributions
Types_of_probability_distributions
Multivariate_interpolation
Splines
Relaxation_(iterative_methods)
Mesh_generators
Quantum_Monte_Carlo
Domain_decomposition_methods
Finite_element_method
Runge%E2%80%93Kutta_methods
Matrix_decompositions
Covering_lemmas
Dimensionless_numbers
Natural_units
Periodic_phenomena
Physical_phenomena
Scientific_phenomena
Length
Navigation
Abstraction
Mathematics
Ordering
Power_(physics)
Units_of_time
Velocity
Microarrays
Neuroinformatics
Systems_biology
Density_functional_theory
Post-Hartree%E2%80%93Fock_methods
Quantum_numbers
Semiempirical_quantum_chemistry_methods
Statistical_natural_language_processing
Broken_block_ciphers
Broken_hash_functions
Broken_stream_ciphers
Key_derivation_functions
Ciphers
Public-key_cryptographers
Dice_games
Probabilistic_complexity_classes
Researchers_in_stochastics
Argument_mapping
Classification_systems
Dewey_Decimal_Classification
Grouping
Knowledge_bases
Ontology_(information_science)
Semantic_Web
Bayesian_networks
Kernel_methods_for_machine_learning
Latent_variable_models
Learning_in_computer_vision
Log-linear_models
Markov_models
Machine_learning_researchers
Structured_prediction
Support_vector_machines
Agent-based_programming_languages
Analysis
Heuristics
Scientific_method
History_of_robotics
3D_printing
BEAM_robotics
Robotic_concepts
Robot_control
Machine_vision
Filter_frequency_response
Linear_filters
Nonlinear_filters
Servos_(radio_control)
Complexity_economics
Security_engineering
Theory_of_constraints
Applications_of_Bayesian_inference
Bayesian_inference
Non-parametric_Bayesian_methods
Choice_modelling
Cross-sectional_analysis
Econometricians
Economics_curves
Regression_with_time_series_structure
Index_numbers
Multiple_comparisons
Bose%E2%80%93Einstein_statistics
Fermi%E2%80%93Dirac_statistics
Maxwell%E2%80%93Boltzmann_statistics
Parastatistics
Particle_distributions
Quantum_Lattice_models
Threshold_temperatures
Electromagnetism
Catalan_solids
Chiral_polyhedra
Polyhedral_compounds
Deltahedra
Johnson_solids
Nonconvex_polyhedra
Prismatoid_polyhedra
Pseudo-uniform_polyhedra
Pyramids_and_bipyramids
Space-filling_polyhedra
Polyhedral_stellation
Toroidal_polyhedra
Uniform_polyhedra
Zonohedra
Images_of_polyhedra
Polyhedra_templates
Pseudoconvex_functions
Pseudolinear_minimization
Generalized_linear_models
Nonparametric_regression
Statistical_outliers
Regression_diagnostics
Regression_variable_selection
Robust_regression
Hidden_Markov_models
Multivariate_time_series_analysis
Nonlinear_time_series_analysis
Texture_compression
SAT_solvers
SMT_solvers
Tetris
Weakly_NP-complete_problems
Construction_grammar
Syntactic_transformation
Priority_queues
Model_checkers
Automata_(computation)
Members_of_Oxford_University_Department_of_Computer_Science
Compiler_optimizations
Control-flow_analysis
Data-flow_analysis
Axiomatic_semantics
Operational_semantics
Hidden_variable_theory
Interpretations_of_quantum_mechanics
Partial_fractions
Circle_of_fifths
Cubic_buildings
Cubic_sculpture
Hemispheres
Quadrilaterals
Aperiodic_sets_of_tiles
Girih
Honeycombs_(geometry)
Triangle_centers
Theorems_in_group_theory
Isomorphism_theorems
Morphisms_of_schemes
Bilinear_operators
Abelian_group_theory
Algebraic_groups
Combinatorial_group_theory
Coxeter_groups
Functional_subgroups
Infinite_group_theory
Nilpotent_groups
P-groups
Reflection_groups
Solvable_groups
Subgroup_properties
Subgroup_series
Spectral_sequences
Octonions
Field_theory
Finite_rings
Ideals
Linear_operators_in_calculus
Unitary_operators
Matrix_normal_forms
Bilinear_forms
Fr%C3%A9chet_spaces
Sobolev_spaces
Operator_theorists
Elliptic_curves
Harmonic_functions
Subharmonic_functions
Boundary_conditions
Theorems_in_Riemannian_geometry
Helices
Parabolas
Spirals
Images_of_curves
Lie_algebras
Rotation_in_three_dimensions
Hodge_theory
Metric_tensors
C*-algebras
Von_Neumann_algebras
Convex_hull_algorithms
Fredholm_theory
Isometric_operators
Representable_functors
Perspective_projection
Discrete_transforms
Gaussian_function
Generalized_functions
Inverse_functions
Discrete_groups
Banach_spaces
Constants
Sets_of_real_numbers
String_data_structures
Ordinary_differential_equations
Differential_systems
Elliptic_partial_differential_equations
Exactly_solvable_models
Hyperbolic_partial_differential_equations
Integrable_systems
Nonlinear_Partial_differential_equations
Parabolic_partial_differential_equations
Solitons
Geometric_data_structures
Spanning_tree
Pandigital_numbers
Serial_compositions
Twelve-tone_and_serial_composers
Exponentials
Logarithms
Convection
Diffusion
Heat_transfer
Atmospheric_thermodynamics
Chemical_engineering_thermodynamics
Diffraction
Doppler_effects
Interference
Wave_power
Chess
Go_(game)
Sextic_curves
Toric_sections
Algebraic_surfaces
Threefolds
Differential_structures
Euclidean_solid_geometry
Geometric_dissection
Kinematics
Kleinian_groups
Polychora
5-polytopes
6-polytopes
7-polytopes
8-polytopes
9-polytopes
10-polytopes
Global_illumination_algorithms
Area
Volume
Clustering_criteria
F-divergences
Tactical_formations
Handedness
Knot_chirality
Binary_polyhedral_groups
Rolling-element_bearings
Torque
Causal_diagrams
Graphical_models
Trees_(data_structures)
Intersection_classes_of_graphs
Parametric_families_of_graphs
Propositional_fallacies
Fuzzy_logic
Risk
Analysis_of_variance
Estimation_of_densities
Exploratory_data_analysis
Financial_data_analysis
Resampling_(statistics)
Sensitivity_analysis
Cohort_study_methods
Directional_statistics
Extreme_value_data
Statistical_genetics
Geostatistics
Statistical_classification
Inter-rater_reliability
Scale_statistics
Algorithmic_inference
Causal_inference
Statistical_forecasting
Model_selection
Asymmetric_information
Economics_of_uncertainty
Effect_size
Information_economics
Validity_(statistics)
Sequential_methods
Bias
Population_models
Semi-parametric_models
Structural_equation_models
Comparison_of_assessments
Factor_analysis
Multivariate_continuous_distributions
Institute_of_Mathematical_Statistics
International_Statistical_Institute
National_statistical_services
Statistical_organisations_in_India
Statistical_service_organizations
Statistical_organisations_in_the_United_Kingdom
Statistical_organizations_in_the_United_States
Ranking_functions
Sampling_techniques
Clustering
Normality_tests
Change_detection
Historical_treatment_of_quaternions
Algebraic_K-theory
Knot_invariants
Knot_operations
Knots_and_links
Complex_surfaces
Torus_knots_and_links
Images_of_surfaces
1934_in_computer_science
1936_in_computer_science
1937_in_computer_science
1947_in_computer_science
1951_in_computer_science
1952_in_computer_science
1953_in_computer_science
1954_in_computer_science
1955_in_computer_science
1956_in_computer_science
1957_in_computer_science
1958_in_computer_science
1959_in_computer_science
1960_in_computer_science
1962_in_computer_science
1964_in_computer_science
1965_in_computer_science
1966_in_computer_science
1967_in_computer_science
1968_in_computer_science
1969_in_computer_science
1970_in_computer_science
1971_in_computer_science
1972_in_computer_science
1973_in_computer_science
1974_in_computer_science
1975_in_computer_science
1976_in_computer_science
1977_in_computer_science
1978_in_computer_science
1979_in_computer_science
1980_in_computer_science
1981_in_computer_science
1982_in_computer_science
1983_in_computer_science
1984_in_computer_science
1985_in_computer_science
1986_in_computer_science
1987_in_computer_science
1988_in_computer_science
1989_in_computer_science
1990_in_computer_science
1991_in_computer_science
1992_in_computer_science
1993_in_computer_science
1994_in_computer_science
1995_in_computer_science
1996_in_computer_science
1997_in_computer_science
1998_in_computer_science
1999_in_computer_science
Programming_languages_created_in_the_20th_century
2000_in_computer_science
2001_in_computer_science
2002_in_computer_science
2003_in_computer_science
2004_in_computer_science
2005_in_computer_science
2006_in_computer_science
2007_in_computer_science
2008_in_computer_science
2009_in_computer_science
2010_in_computer_science
2011_in_computer_science
2012_in_computer_science
2013_in_computer_science
2014_in_computer_science
Concurrency_control
Data_synchronization
Disproved_conjectures
Lossless_audio_codecs
Audio_codecs
Hash_functions
Link_analysis
E_(mathematical_constant)
One
2_(number)
3_(number)
4_(number)
Large_integers
Transcendental_numbers
Top_lists
Compactness_(mathematics)
Finite_reflection_groups
Sporadic_groups
Isaac_Newton
Members_of_the_Department_of_Applied_Mathematics_and_Theoretical_Physics
Lucasian_Professors_of_Mathematics
Members_of_the_Department_of_Pure_Mathematics_and_Mathematical_Statistics
Ren%C3%A9_Descartes
Blaise_Pascal
Sicilian_mathematicians
Abel_Prize_laureates
Works_by_Nicolaus_Copernicus
Kepler%E2%80%93Poinsot_polyhedra
Works_by_Johannes_Kepler
Leibniz_Prize_winners
Works_by_Gottfried_Leibniz
Works_by_Bertrand_Russell
Galileo_Galilei
Presidents_of_the_Econometric_Society
Presidents_of_the_International_Statistical_Institute
Presidents_of_the_Institute_of_Mathematical_Statistics
Presidents_of_the_American_Statistical_Association
Theorems
Logic
Scientific_modeling
Systems_science
Generalized_hyperbolic_distributions
Normal_distribution
FEM_elements
Dimensionless_numbers_of_chemistry
Dimensionless_numbers_of_fluid_mechanics
Energy_(physics)
Orders_of_magnitude_(length)
Units_of_length
Air_navigation
Celestial_navigation
History_of_navigation
Inductive_reasoning
Units_of_power
Units_of_velocity
Hornbostel-Sachs
Markov_networks
Research_methods
Scientific_techniques
Robot_kinematics
Robot_locomotion
Access_control
Electricity
Electrical_engineering
Magnetism
Units_in_electromagnetism
Stellation_diagrams
Archimedean_solids
Quasiregular_polyhedra
Regular_polyhedra
Abelian_varieties
Field_extensions
Formally_real_field
Real_closed_field
Prime_ideals
Properties_of_Lie_algebras
Precession
Inverse_problems
Physical_constants
R-tree
Power_laws
Logarithmic_scales_of_measurement
Spiric_sections
Linkages
Orders_of_magnitude_(volume)
Units_of_volume
Amphichiral_knots_and_links
Chiral_knots_and_links
Invertible_knots_and_links
Units_of_torque
B-tree
Binary_trees
Heaps_(data_structures)
Fundamental_analysis
Fellows_of_the_Institute_of_Mathematical_Statistics
Australian_Bureau_of_Statistics
Federal_Statistical_System_of_the_United_States
INEGI
National_statistical_services_of_Europe
Royal_Statistical_Society
American_Statistical_Association
Bureau_of_Labor_Statistics
Knots_and_links_by_Arf_invariant
Knots_and_links_by_braid_length
Knots_and_links_by_braid_number
Knots_and_links_by_bridge_number
Knots_and_links_by_crosscap_number
Knots_and_links_by_crossing_number
Knots_and_links_by_genus
Knots_and_links_by_hyperbolic_volume
Knots_and_links_by_stick_number
Knots_and_links_by_tunnel_number
Knots_and_links_by_unknotting_number
Links_by_linking_number
Non-tricolorable_knots_and_links
Tricolorable_knots_and_links
Knots_(knot_theory)
Links_(knot_theory)
Hyperbolic_knots_and_links
Satellite_knots_and_links
Alternating_knots_and_links
Fibered_knots_and_links
Non-alternating_knots_and_links
Pretzel_knots_and_links
Unfibered_knots_and_links
Works_by_Isaac_Newton
Descartes_scholars
Works_by_Ren%C3%A9_Descartes
Works_by_Blaise_Pascal
Books_by_Bertrand_Russell
Essays_by_Bertrand_Russell
Discoveries_by_Galileo_Galilei
Works_by_Galileo_Galilei
Economics_theorems
Metatheorems
Physics_theorems
Concepts_in_logic
Logic_organizations
Logical_fallacies
Logicians
Metalogic
Philosophical_logic
Philosophy_of_logic
Syntax_(logic)
Wikipedia_books_on_logic
Cognitive_modeling
Computer_graphics
Data_modeling
Hydrography
Infographics
Molecular_modelling
Notation
Scale_modeling
Scientific_laws
Scientific_theories
Inductive_fallacies
Infrared_spectroscopy
Spectroscopy
Quantum_magnetism
Units_of_electrical_capacitance
Units_of_electrical_conductance
Units_of_electrical_inductance
Units_of_electrical_potential
Units_of_electrical_resistance
Units_of_magnetic_field
Units_of_magnetic_flux
Units_of_magnetic_induction
Platonic_solids
Critical_exponents_(phase_transitions)
Fundamental_constants
Crankshafts
Hinges
Fully_amphichiral_knots_and_links
Reversible_knots_and_links
Fellows_of_the_Royal_Statistical_Society
Reports_of_the_Bureau_of_Labor_Statistics
0_Arf_invariant_knots_and_links
1_Arf_invariant_knots_and_links
2_braid_length_knots_and_links
3_braid_length_knots_and_links
4_braid_length_knots_and_links
5_braid_length_knots_and_links
6_braid_length_knots_and_links
7_braid_length_knots_and_links
8_braid_length_knots_and_links
9_braid_length_knots_and_links
10_braid_length_knots_and_links
2_braid_number_knots_and_links
3_braid_number_knots_and_links
4_braid_number_knots_and_links
0_bridge_number_knots_and_links
2_bridge_number_knots_and_links
3_bridge_number_knots_and_links
1_crosscap_number_knots_and_links
2_crosscap_number_knots_and_links
3_crosscap_number_knots_and_links
4_crosscap_number_knots_and_links
0_crossing_number_knots_and_links
2_crossing_number_knots_and_links
3_crossing_number_knots_and_links
4_crossing_number_knots_and_links
5_crossing_number_knots_and_links
6_crossing_number_knots_and_links
7_crossing_number_knots_and_links
8_crossing_number_knots_and_links
10_crossing_number_knots_and_links
12_crossing_number_knots_and_links
0_genus_knots_and_links
1_genus_knots_and_links
2_genus_knots_and_links
3_genus_knots_and_links
4_genus_knots_and_links
2.82812_hyperbolic_volume_knots_and_links
Non-hyperbolic_knots_and_links
10_stick_number_knots_and_links
11_stick_number_knots_and_links
3_stick_number_knots_and_links
6_stick_number_knots_and_links
7_stick_number_knots_and_links
8_stick_number_knots_and_links
9_stick_number_knots_and_links
0_tunnel_number_knots_and_links
1_tunnel_number_knots_and_links
0_unknotting_number_knots_and_links
1_unknotting_number_knots_and_links
2_unknotting_number_knots_and_links
3_unknotting_number_knots_and_links
4_unknotting_number_knots_and_links
5_unknotting_number_knots_and_links
0_linking_number_links
1_linking_number_links
Prime_knots
Slice_knots_and_links
Composite_knots_and_links
Books_by_Isaac_Newton
Books_by_Galileo_Galilei
Essays_by_Galileo_Galilei
Circuit_theorems
Logical_truth
Necessity
Paradoxes
Truth
Formal_fallacies
Informal_fallacies
Conditionals
Definition
Logical_positivism
Necessity_and_sufficiency
Possibility
Semantics
Ambiguity
Visualization_(graphic)
Systems_of_units
Theoretical_physics
Twist_knots
Centimetre%E2%80%93gram%E2%80%93second_system_of_units
Customary_units_in_India
Customary_units_of_measurement
Imperial_units
International_System_of_Units
Non-SI_metric_units
Ideal_gas
Quantum_field_theory
Quantum_mechanics
Quantum_models
String_theory
Theories_of_gravitation
Thought_experiments_in_physics
Wormhole_theory
Chinese_units_in_Hong_Kong
Cooking_weights_and_measures
Customary_units_of_measurement_in_the_United_States
Human-based_units_of_measurement
Metrication
Metric_prefixes
SI_units
Antimatter
Conformal_field_theory
Electroweak_theory
Gauge_theories
Quantum_chromodynamics
Quantum_gravity
Standard_Model
Atomic_physics
Foundational_quantum_physics
Mesoscopic_physics
Nuclear_physics
Pauli_exclusion_principle
Quantum_physicists
Quantum_electronics
Quantum_optics
Quantum_phases
Quantum_states
Thought_experiments_in_quantum_mechanics
Quantum_physics_stubs
String_theorists
String_theory_books
String_theory_stubs
Metricated_units
SI_base_units
SI_derived_units
Hadrons
Quark_matter
Quarks
Loop_quantum_gravity
Atoms
Scattering
Cold_fusion
Exotic_atoms
Subatomic_particles
Laser_science
Quasiparticles
Schr%C3%B6dinger%27s_cat
Baryons
Mesons
Bosons
Fermions
Tachyons
Gauge_bosons
Leptons
Gluons
Neutrinos)};

$wiki_category_whitelist->{'Information,_knowledge,_and_uncertainty'} = 1;

1;