#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'hewlett-packard/c0302a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c0302a',
            MAC          => '00:25:b3:fa:8f:83',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c0302a',
            MAC          => '00:25:b3:fa:8f:83',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS311977',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311977,FN:MB14HZB,SVCID:20055,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c0302a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                IPS          => {
                    IP => [
                        '128.93.22.19',
                    ],
                },
                UPTIME       => '(3731317) 10:21:53.17',
            },
            PAGECOUNTERS => {
                TOTAL      => '57',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15135176',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15211522',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.19',
                        MAC              => '00:25:b3:fa:8f:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '468693900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2643170',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311977,FN:MB14HZB,SVCID:20055,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c0302a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS311977',
                IPS          => {
                    IP => [
                        '128.93.22.19',
                    ],
                },
                UPTIME       => '(3731317) 10:21:53.17',
            },
            CARTRIDGES => {
                TONERBLACK       => '50',
                TONERCYAN        => '25',
                TONERMAGENTA     => '50',
                TONERYELLOW      => '50',
            },
            PAGECOUNTERS => {
                BLACK      => '2',
                COLOR      => '55',
                RECTOVERSO => '8',
                TOTAL      => '57',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15135176',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15211522',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.19',
                        MAC              => '00:25:b3:fa:8f:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '468693900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2643170',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c202a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1C202a',
            MAC          => '00:25:b3:fa:8f:69',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1C202a',
            MAC          => '00:25:b3:fa:8f:69',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS311991',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311991,FN:MB14HYJ,SVCID:20048,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C202a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                IPS          => {
                    IP => [
                        '128.93.22.236',
                    ],
                },
                UPTIME       => '(127613450) 14 days, 18:28:54.50',
            },
            PAGECOUNTERS => {
                TOTAL      => '2026',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '461172803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459898940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.236',
                        MAC              => '00:25:b3:fa:8f:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '472915891',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26628688',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311991,FN:MB14HYJ,SVCID:20048,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C202a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS311991',
                IPS          => {
                    IP => [
                        '128.93.22.236',
                    ],
                },
                UPTIME       => '(127613450) 14 days, 18:28:54.50',
            },
            CARTRIDGES => {
                TONERBLACK       => '53',
                TONERCYAN        => '97',
                TONERMAGENTA     => '88',
                TONERYELLOW      => '92',
            },
            PAGECOUNTERS => {
                BLACK      => '238',
                COLOR      => '1788',
                RECTOVERSO => '1',
                TOTAL      => '2026',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '461172803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459898940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.236',
                        MAC              => '00:25:b3:fa:8f:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '472915891',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26628688',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c203a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1c203a',
            MAC          => '00:25:b3:fa:8f:cc',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1c203a',
            MAC          => '00:25:b3:fa:8f:cc',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS311990',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311990,FN:MB14J1J,SVCID:20034,PID:c1c203a',
                NAME         => 'c1c203a',
                MEMORY       => '64',
                LOCATION     => 'c1c203a',
                IPS          => {
                    IP => [
                        '128.93.22.87',
                    ],
                },
                UPTIME       => '(79171032) 9 days, 3:55:10.32',
            },
            PAGECOUNTERS => {
                TOTAL      => '1019',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '286476140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '321945244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.87',
                        MAC              => '00:25:b3:fa:8f:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '3617972664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10805204',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311990,FN:MB14J1J,SVCID:20034,PID:c1c203a',
                NAME         => 'c1c203a',
                MEMORY       => '64',
                LOCATION     => 'c1c203a',
                SERIAL       => 'CNHS311990',
                IPS          => {
                    IP => [
                        '128.93.22.87',
                    ],
                },
                UPTIME       => '(79171032) 9 days, 3:55:10.32',
            },
            CARTRIDGES => {
                TONERBLACK       => '58',
                TONERCYAN        => '59',
                TONERMAGENTA     => '48',
                TONERYELLOW      => '63',
            },
            PAGECOUNTERS => {
                BLACK      => '13',
                COLOR      => '1006',
                RECTOVERSO => '5',
                TOTAL      => '1019',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '286476140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '321945244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.87',
                        MAC              => '00:25:b3:fa:8f:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '3617972664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10805204',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c205a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPIFA9F1C',
            MAC          => '00:25:b3:fa:9f:1c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPIFA9F1C',
            MAC          => '00:25:b3:fa:9f:1c',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS311979',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311979,FN:MB14J3Z,SVCID:20045,PID:c1c205a',
                NAME         => 'NPIFA9F1C',
                MEMORY       => '64',
                LOCATION     => 'c1c205a',
                IPS          => {
                    IP => [
                        '128.93.22.225',
                    ],
                },
                UPTIME       => '(3023313454) 349 days, 22:05:34.54',
            },
            PAGECOUNTERS => {
                TOTAL      => '1016',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2236119563',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2235897962',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.225',
                        MAC              => '00:25:b3:fa:9f:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(286315045) 33 days, 3:19:10.45',
                        IFINOCTETS       => '1769857822',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1974950967',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311979,FN:MB14J3Z,SVCID:20045,PID:c1c205a',
                NAME         => 'NPIFA9F1C',
                MEMORY       => '64',
                LOCATION     => 'c1c205a',
                SERIAL       => 'CNHS311979',
                IPS          => {
                    IP => [
                        '128.93.22.225',
                    ],
                },
                UPTIME       => '(3023313454) 349 days, 22:05:34.54',
            },
            CARTRIDGES => {
                TONERBLACK       => '68',
                TONERCYAN        => '95',
                TONERMAGENTA     => '96',
                TONERYELLOW      => '97',
            },
            PAGECOUNTERS => {
                BLACK      => '156',
                COLOR      => '860',
                RECTOVERSO => '257',
                TOTAL      => '1016',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2236119563',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2235897962',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.225',
                        MAC              => '00:25:b3:fa:9f:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(286315045) 33 days, 3:19:10.45',
                        IFINOCTETS       => '1769857822',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1974950967',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c206a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1C206a',
            MAC          => '00:25:b3:fa:9f:e6',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'c1C206a',
            MAC          => '00:25:b3:fa:9f:e6',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS312016',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS312016,FN:MB14JA3,SVCID:20045,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C206a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                IPS          => {
                    IP => [
                        '128.93.22.224',
                    ],
                },
                UPTIME       => '(2665726) 7:24:17.26',
            },
            PAGECOUNTERS => {
                TOTAL      => '0',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9602930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9591687',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.224',
                        MAC              => '00:25:b3:fa:9f:e6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '419831787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1072100',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS312016,FN:MB14JA3,SVCID:20045,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C206a',
                MEMORY       => '64',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS312016',
                IPS          => {
                    IP => [
                        '128.93.22.224',
                    ],
                },
                UPTIME       => '(2665726) 7:24:17.26',
            },
            CARTRIDGES => {
                TONERBLACK       => '91',
                TONERCYAN        => '92',
                TONERMAGENTA     => '91',
                TONERYELLOW      => '93',
            },
            PAGECOUNTERS => {
                BLACK      => '0',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '0',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9602930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9591687',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.224',
                        MAC              => '00:25:b3:fa:9f:e6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '419831787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1072100',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c2406a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'NPIE6C1AF',
            MAC          => '00:1b:78:e6:c1:af',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'NPIE6C1AF',
            MAC          => '00:1b:78:e6:c1:af',
            MODELSNMP    => 'Printer0248',
            FIRMWARE     => undef,
            SERIAL       => 'SG7B302EAD',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C1AF',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '128.93.22.214',
                    ],
                },
                UPTIME       => '(315536000) 36 days, 12:29:20.00',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '35',
                CARTRIDGEMAGENTA => '35',
                CARTRIDGEYELLOW  => '35',
            },
            PAGECOUNTERS => {
                TOTAL      => '2978',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.214',
                        MAC              => '00:1b:78:e6:c1:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '3188012392',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '157851660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '670842604',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36631382',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C1AF',
                MEMORY       => '96',
                SERIAL       => 'SG7B302EAD',
                IPS          => {
                    IP => [
                        '128.93.22.214',
                    ],
                },
                UPTIME       => '(315536000) 36 days, 12:29:20.00',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '35',
                CARTRIDGEMAGENTA => '35',
                CARTRIDGEYELLOW  => '35',
            },
            PAGECOUNTERS => {
                TOTAL      => '2978',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.214',
                        MAC              => '00:1b:78:e6:c1:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '3188012392',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '157851660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '670842604',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36631382',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c2407a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'NPIE6C19A',
            MAC          => '00:1b:78:e6:c1:9a',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'NPIE6C19A',
            MAC          => '00:1b:78:e6:c1:9a',
            MODELSNMP    => 'Printer0248',
            FIRMWARE     => undef,
            SERIAL       => 'SG7B302E92',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C19A',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '128.93.22.129',
                    ],
                },
                UPTIME       => '(15951321) 1 day, 20:18:33.21',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '13',
                CARTRIDGECYAN    => '27',
                CARTRIDGEMAGENTA => '34',
                CARTRIDGEYELLOW  => '34',
            },
            PAGECOUNTERS => {
                TOTAL      => '360',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.129',
                        MAC              => '00:1b:78:e6:c1:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008614593) 463 days, 23:02:25.93',
                        IFINOCTETS       => '2901678960',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284193866',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C19A',
                MEMORY       => '96',
                SERIAL       => 'SG7B302E92',
                IPS          => {
                    IP => [
                        '128.93.22.129',
                    ],
                },
                UPTIME       => '(15951321) 1 day, 20:18:33.21',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '13',
                CARTRIDGECYAN    => '27',
                CARTRIDGEMAGENTA => '34',
                CARTRIDGEYELLOW  => '34',
            },
            PAGECOUNTERS => {
                TOTAL      => '360',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.129',
                        MAC              => '00:1b:78:e6:c1:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008614593) 463 days, 23:02:25.93',
                        IFINOCTETS       => '2901678960',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284193866',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/Inkjet_2800.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'HPIJ2800-02',
            MAC          => '00:11:0a:f5:cc:dc',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'HPIJ2800-02',
            MAC          => '00:11:0a:f5:cc:dc',
            MODELSNMP    => 'Printer0248',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-02',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '10.104.102.194',
                    ],
                },
                UPTIME       => '(45821440) 5 days, 7:16:54.40',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '12',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '29',
                CARTRIDGEYELLOW  => '33',
            },
            PAGECOUNTERS => {
                TOTAL      => '24724',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.102.194',
                        MAC              => '00:11:0a:f5:cc:dc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3338251014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14894593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3337864481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14683822',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-02',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '10.104.102.194',
                    ],
                },
                UPTIME       => '(45821440) 5 days, 7:16:54.40',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '12',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '29',
                CARTRIDGEYELLOW  => '33',
            },
            PAGECOUNTERS => {
                TOTAL      => '24724',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.102.194',
                        MAC              => '00:11:0a:f5:cc:dc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3338251014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14894593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3337864481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14683822',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/Inkjet_2800.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'HPIJ2800-01',
            MAC          => '00:11:0a:f5:1a:cc',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Business Inkjet 2800',
            SNMPHOSTNAME => 'HPIJ2800-01',
            MAC          => '00:11:0a:f5:1a:cc',
            MODELSNMP    => 'Printer0248',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-01',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '10.104.109.230',
                    ],
                },
                UPTIME       => '(85884840) 9 days, 22:34:08.40',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '10',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '32',
                CARTRIDGEYELLOW  => '27',
            },
            PAGECOUNTERS => {
                TOTAL      => '24304',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.109.230',
                        MAC              => '00:11:0a:f5:1a:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(52250) 0:08:42.50',
                        IFINOCTETS       => '47343424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '685530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-01',
                MEMORY       => '96',
                IPS          => {
                    IP => [
                        '10.104.109.230',
                    ],
                },
                UPTIME       => '(85884840) 9 days, 22:34:08.40',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '10',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '32',
                CARTRIDGEYELLOW  => '27',
            },
            PAGECOUNTERS => {
                TOTAL      => '24304',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.109.230',
                        MAC              => '00:11:0a:f5:1a:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(52250) 0:08:42.50',
                        IFINOCTETS       => '47343424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '685530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l0214a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'l0214a',
            MAC          => '00:17:08:91:95:e4',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'l0214a',
            MAC          => '00:17:08:91:95:e4',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l0214a',
                IPS          => {
                    IP => [
                        '128.93.22.125',
                    ],
                },
                UPTIME       => '(27930670) 3 days, 5:35:06.70',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.125',
                        MAC              => '00:17:08:91:95:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4231070113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '358458889',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l0214a',
                IPS          => {
                    IP => [
                        '128.93.22.125',
                    ],
                },
                UPTIME       => '(27930670) 3 days, 5:35:06.70',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.125',
                        MAC              => '00:17:08:91:95:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4231070113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '358458889',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l0700a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI934D66',
            MAC          => '00:17:a4:93:4d:66',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI934D66',
            MAC          => '00:17:a4:93:4d:66',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D66',
                IPS          => {
                    IP => [
                        '128.93.22.1',
                    ],
                },
                UPTIME       => '(40406032) 4 days, 16:14:20.32',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.1',
                        MAC              => '00:17:a4:93:4d:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2697548956',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2323517464',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D66',
                IPS          => {
                    IP => [
                        '128.93.22.1',
                    ],
                },
                UPTIME       => '(40406032) 4 days, 16:14:20.32',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.1',
                        MAC              => '00:17:a4:93:4d:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2697548956',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2323517464',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l1803a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI9195E8',
            MAC          => '00:17:08:91:95:e8',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI9195E8',
            MAC          => '00:17:08:91:95:e8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI9195E8',
                IPS          => {
                    IP => [
                        '128.93.22.78',
                    ],
                },
                UPTIME       => '(4016837) 11:09:28.37',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.78',
                        MAC              => '00:17:08:91:95:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '518877292',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '326948288',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI9195E8',
                IPS          => {
                    IP => [
                        '128.93.22.78',
                    ],
                },
                UPTIME       => '(4016837) 11:09:28.37',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.78',
                        MAC              => '00:17:08:91:95:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '518877292',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '326948288',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l1b110a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI810884',
            MAC          => '00:1b:78:21:ef:df',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI810884',
            MAC          => '00:1b:78:21:ef:df',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI810884',
                IPS          => {
                    IP => [
                        '128.93.22.101',
                    ],
                },
                UPTIME       => '(13141846) 1 day, 12:30:18.46',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.101',
                        MAC              => '00:1b:78:21:ef:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2493348234',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '107189645',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI810884',
                IPS          => {
                    IP => [
                        '128.93.22.101',
                    ],
                },
                UPTIME       => '(13141846) 1 day, 12:30:18.46',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.101',
                        MAC              => '00:1b:78:21:ef:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2493348234',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '107189645',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l2520a.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI934D6D',
            MAC          => '00:17:a4:93:4d:6d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
            SNMPHOSTNAME => 'NPI934D6D',
            MAC          => '00:17:a4:93:4d:6d',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D6D',
                IPS          => {
                    IP => [
                        '128.93.10.40',
                    ],
                },
                UPTIME       => '(3561333) 9:53:33.33',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.10.40',
                        MAC              => '00:17:a4:93:4d:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2266764957',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '119345262',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D6D',
                IPS          => {
                    IP => [
                        '128.93.10.40',
                    ],
                },
                UPTIME       => '(3561333) 9:53:33.33',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.10.40',
                        MAC              => '00:17:a4:93:4d:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2266764957',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '119345262',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_100_colorMFP_M175nw.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 100 colorMFP M175nw',
            SNMPHOSTNAME => 'NPIF6FA4A',
            MAC          => 'b4:b5:2f:f6:fa:4a',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 100 colorMFP M175nw',
            SNMPHOSTNAME => 'NPIF6FA4A',
            MAC          => 'b4:b5:2f:f6:fa:4a',
            MODELSNMP    => 'Printer0718',
            FIRMWARE     => undef,
            SERIAL       => 'NPIF6FA4A',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 100 colorMFP M175nw',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNC9D8R0DX,FN:RN32CK3,SVCID:22288,PID:HP LaserJet 100 colorMFP M175nw',
                NAME         => 'NPIF6FA4A',
            },
            PAGECOUNTERS => {
                TOTAL      => '367',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '569120555',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568555646',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(227607) 0:37:56.07',
                        IFINOCTETS       => '376926321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10253796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'wifi0',
                        IFDESCR          => 'wifi0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(290) 0:00:02.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'wifiUAP',
                        IFDESCR          => 'wifiUAP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 100 colorMFP M175nw',
                COMMENTS     => 'HP LaserJet 100 colorMFP M175nw',
                NAME         => 'NPIF6FA4A',
                SERIAL       => 'NPIF6FA4A',
            },
            CARTRIDGES => {
                TONERBLACK       => '31',
                TONERCYAN        => '83',
                TONERMAGENTA     => '82',
                TONERYELLOW      => '82',
                DRUMBLACK        => '96',
            },
            PAGECOUNTERS => {
                TOTAL      => '367',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '569120555',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568555646',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(227607) 0:37:56.07',
                        IFINOCTETS       => '376926321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10253796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'wifi0',
                        IFDESCR          => 'wifi0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(290) 0:00:02.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'wifiUAP',
                        IFDESCR          => 'wifiUAP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1300n.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1300n',
            SNMPHOSTNAME => 'impbe94',
            MAC          => '00:0e:7f:33:34:ba',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1300n',
            SNMPHOSTNAME => 'impbe94',
            MAC          => '00:0e:7f:33:34:ba',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1300n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14,CIDATE 09/24/2003',
                NAME         => 'impbe94',
            },
            PAGECOUNTERS => {
                TOTAL      => '49530',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0e:7f:33:34:ba',
                        IFLASTCHANGE     => '(2147640540) 248 days, 13:40:05.40',
                        IFINOCTETS       => '138463765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1669632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '24',
                        IFSPEED          => '2149807168',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(256) 0:00:02.56',
                        IFINOCTETS       => '2154227664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2422572804',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1300n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14,CIDATE 09/24/2003',
                NAME         => 'impbe94',
            },
            PAGECOUNTERS => {
                TOTAL      => '49530',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0e:7f:33:34:ba',
                        IFLASTCHANGE     => '(2147640540) 248 days, 13:40:05.40',
                        IFINOCTETS       => '138463765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1669632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '24',
                        IFSPEED          => '2149807168',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(256) 0:00:02.56',
                        IFINOCTETS       => '2154227664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2422572804',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPI61044B',
            MAC          => '00:14:38:61:04:4b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPI61044B',
            MAC          => '00:14:38:61:04:4b',
            MODELSNMP    => 'Printer0606',
            FIRMWARE     => undef,
            SERIAL       => 'CNHW59NG6N',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI61044B',
            },
            PAGECOUNTERS => {
                TOTAL      => '33545',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:61:04:4b',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '1398049413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5988998',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154273388) 249 days, 8:05:33.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI61044B',
                SERIAL       => 'CNHW59NG6N',
            },
            CARTRIDGES => {
                TONERBLACK       => '0',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1935',
                TOTAL      => '33545',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:61:04:4b',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '1398049413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5988998',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154273388) 249 days, 8:05:33.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPI9A3FC7',
            MAC          => '00:14:38:9a:3f:c7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPI9A3FC7',
            MAC          => '00:14:38:9a:3f:c7',
            MODELSNMP    => 'Printer0606',
            FIRMWARE     => undef,
            SERIAL       => 'CNHW625K6Z',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI9A3FC7',
            },
            PAGECOUNTERS => {
                TOTAL      => '45790',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:9a:3f:c7',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '64787538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304811',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154316712) 249 days, 8:12:47.12',
                        IFINOCTETS       => '2148589888',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2423914616',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI9A3FC7',
                SERIAL       => 'CNHW625K6Z',
            },
            CARTRIDGES => {
                TONERBLACK       => '92',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '2685',
                TOTAL      => '45790',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:9a:3f:c7',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '64787538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304811',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154316712) 249 days, 8:12:47.12',
                        IFINOCTETS       => '2148589888',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2423914616',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPIC68F5E',
            MAC          => '00:11:85:c6:8f:5e',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 1320 series',
            SNMPHOSTNAME => 'NPIC68F5E',
            MAC          => '00:11:85:c6:8f:5e',
            MODELSNMP    => 'Printer0606',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW49FHC4',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPIC68F5E',
            },
            PAGECOUNTERS => {
                TOTAL      => '5868',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:c6:8f:5e',
                        IFLASTCHANGE     => '(4) 0:00:00.04',
                        IFINOCTETS       => '1057001886',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9279619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '60',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2422553824) 280 days, 9:18:58.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPIC68F5E',
                SERIAL       => 'CNBW49FHC4',
            },
            CARTRIDGES => {
                TONERBLACK       => '34',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '258',
                TOTAL      => '5868',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:c6:8f:5e',
                        IFLASTCHANGE     => '(4) 0:00:00.04',
                        IFINOCTETS       => '1057001886',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9279619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '60',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2422553824) 280 days, 9:18:58.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
            },
            PAGECOUNTERS => {
                TOTAL      => '65436',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '940032733',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8567174',
                        IFOUTERRORS      => '16',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
            },
            PAGECOUNTERS => {
                TOTAL      => '65436',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '940032733',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8567174',
                        IFOUTERRORS      => '16',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
            },
            PAGECOUNTERS => {
                TOTAL      => '65516',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '929364745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6619438',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
            },
            PAGECOUNTERS => {
                TOTAL      => '65516',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '929364745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6619438',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:0d:aa:c6',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:0d:aa:c6',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.63',
                    ],
                },
                UPTIME       => '(319831420) 37 days, 0:25:14.20',
            },
            PAGECOUNTERS => {
                TOTAL      => '27649',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.63',
                        MAC              => '00:30:c1:0d:aa:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3098738609',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6907034',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.63',
                    ],
                },
                UPTIME       => '(319831420) 37 days, 0:25:14.20',
            },
            PAGECOUNTERS => {
                TOTAL      => '27649',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.63',
                        MAC              => '00:30:c1:0d:aa:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3098738609',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6907034',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:10:83:54:d6:08',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:10:83:54:d6:08',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.61',
                    ],
                },
                UPTIME       => '(165740930) 19 days, 4:23:29.30',
            },
            PAGECOUNTERS => {
                TOTAL      => '46041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.61',
                        MAC              => '00:10:83:54:d6:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2570180872',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1315699',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.61',
                    ],
                },
                UPTIME       => '(165740930) 19 days, 4:23:29.30',
            },
            PAGECOUNTERS => {
                TOTAL      => '46041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.61',
                        MAC              => '00:10:83:54:d6:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2570180872',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1315699',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            SNMPHOSTNAME => 'l1618a',
            MAC          => '00:0e:7f:ea:e1:b7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            SNMPHOSTNAME => 'l1618a',
            MAC          => '00:0e:7f:ea:e1:b7',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06,CIDATE 04/27/2004',
                NAME         => 'l1618a',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.29',
                    ],
                },
                UPTIME       => '(13841080) 1 day, 14:26:50.80',
            },
            PAGECOUNTERS => {
                TOTAL      => '3846',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.29',
                        MAC              => '00:0e:7f:ea:e1:b7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3003827766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '155057491',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '78520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06,CIDATE 04/27/2004',
                NAME         => 'l1618a',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.29',
                    ],
                },
                UPTIME       => '(13841080) 1 day, 14:26:50.80',
            },
            PAGECOUNTERS => {
                TOTAL      => '3846',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.29',
                        MAC              => '00:0e:7f:ea:e1:b7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3003827766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '155057491',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '78520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.06.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:c3:be:cf',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2100 Series',
            MAC          => '00:30:c1:c3:be:cf',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.144',
                    ],
                },
                UPTIME       => '(20422550) 2 days, 8:43:45.50',
            },
            PAGECOUNTERS => {
                TOTAL      => '15352',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.144',
                        MAC              => '00:30:c1:c3:be:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1489429781',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                MEMORY       => '8',
                IPS          => {
                    IP => [
                        '128.93.22.144',
                    ],
                },
                UPTIME       => '(20422550) 2 days, 8:43:45.50',
            },
            PAGECOUNTERS => {
                TOTAL      => '15352',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.144',
                        MAC              => '00:30:c1:c3:be:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1489429781',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2200.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2200',
            MAC          => '00:30:c1:01:1e:68',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 2200',
            MAC          => '00:30:c1:01:1e:68',
            MODELSNMP    => 'Printer0391',
            FIRMWARE     => undef,
            SERIAL       => 'FRFRH43314',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                MEMORY       => '16',
                IPS          => {
                    IP => [
                        '128.93.22.20',
                    ],
                },
                UPTIME       => '(745729650) 86 days, 7:28:16.50',
            },
            PAGECOUNTERS => {
                TOTAL      => '38972',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.20',
                        MAC              => '00:30:c1:01:1e:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3553593205',
                        IFINERRORS       => '942585',
                        IFOUTOCTETS      => '17502829',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 2200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                MEMORY       => '16',
                SERIAL       => 'FRFRH43314',
                IPS          => {
                    IP => [
                        '128.93.22.20',
                    ],
                },
                UPTIME       => '(745729650) 86 days, 7:28:16.50',
            },
            CARTRIDGES => {
                TONERBLACK       => '100',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '12873',
                TOTAL      => '38972',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.20',
                        MAC              => '00:30:c1:01:1e:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3553593205',
                        IFINERRORS       => '942585',
                        IFOUTOCTETS      => '17502829',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2300.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 2300 series',
            SNMPHOSTNAME => 'NPIA1D034',
            MAC          => '00:01:e6:a1:d0:34',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 2300 series',
            SNMPHOSTNAME => 'NPIA1D034',
            MAC          => '00:01:e6:a1:d0:34',
            MODELSNMP    => 'Printer0385',
            FIRMWARE     => undef,
            SERIAL       => 'CNCDF57941',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08,CIDATE 02/26/2003',
                NAME         => 'NPIA1D034',
                MEMORY       => '48',
                IPS          => {
                    IP => [
                        '128.93.22.126',
                    ],
                },
                UPTIME       => '(313714810) 36 days, 7:25:48.10',
            },
            PAGECOUNTERS => {
                TOTAL      => '23551',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.126',
                        MAC              => '00:01:e6:a1:d0:34',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008588496) 463 days, 22:58:04.96',
                        IFINOCTETS       => '2184590033',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '313870484',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08,CIDATE 02/26/2003',
                NAME         => 'NPIA1D034',
                MEMORY       => '48',
                SERIAL       => 'CNCDF57941',
                IPS          => {
                    IP => [
                        '128.93.22.126',
                    ],
                },
                UPTIME       => '(313714810) 36 days, 7:25:48.10',
            },
            CARTRIDGES => {
                TONERBLACK       => '94',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '2066',
                TOTAL      => '23551',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.126',
                        MAC              => '00:01:e6:a1:d0:34',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008588496) 463 days, 22:58:04.96',
                        IFINOCTETS       => '2184590033',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '313870484',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2300.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 2300 series',
            MAC          => '00:30:c1:60:c8:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 2300 series',
            MAC          => '00:30:c1:60:c8:5b',
            MODELSNMP    => 'Printer0385',
            FIRMWARE     => undef,
            SERIAL       => 'CNCHM24955',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '48',
                IPS          => {
                    IP => [
                        '128.93.22.66',
                    ],
                },
                UPTIME       => '(3052880) 8:28:48.80',
            },
            PAGECOUNTERS => {
                TOTAL      => '17090',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.66',
                        MAC              => '00:30:c1:60:c8:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '260181495',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '522299',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                MEMORY       => '48',
                SERIAL       => 'CNCHM24955',
                IPS          => {
                    IP => [
                        '128.93.22.66',
                    ],
                },
                UPTIME       => '(3052880) 8:28:48.80',
            },
            CARTRIDGES => {
                TONERBLACK       => '1',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '219',
                TOTAL      => '17090',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.66',
                        MAC              => '00:30:c1:60:c8:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '260181495',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '522299',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2600n.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet 2600n',
            SNMPHOSTNAME => 'NPI1864A0',
            MAC          => '00:1a:4b:18:64:a0',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet 2600n',
            SNMPHOSTNAME => 'NPI1864A0',
            MAC          => '00:1a:4b:18:64:a0',
            MODELSNMP    => 'Printer0093',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet 2600n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'NPI1864A0',
            },
            CARTRIDGES => {
                TONERBLACK       => '72',
                TONERCYAN        => '82',
                TONERMAGENTA     => '87',
                TONERYELLOW      => '65',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:4b:18:64:a0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '323501189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1322669',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet 2600n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'NPI1864A0',
            },
            CARTRIDGES => {
                TONERBLACK       => '72',
                TONERCYAN        => '82',
                TONERMAGENTA     => '87',
                TONERYELLOW      => '65',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:4b:18:64:a0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '323501189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1322669',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_3600.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet 3600',
            SNMPHOSTNAME => 'NPI6F72C5',
            MAC          => '00:1b:78:6f:72:c5',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet 3600',
            SNMPHOSTNAME => 'NPI6F72C5',
            MAC          => '00:1b:78:6f:72:c5',
            MODELSNMP    => 'Printer0390',
            FIRMWARE     => undef,
            SERIAL       => 'CNXJD65169',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet 3600',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31,CIDATE 06/17/2005',
                NAME         => 'NPI6F72C5',
            },
            PAGECOUNTERS => {
                TOTAL      => '11012',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:6f:72:c5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '127624321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '612088',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '24',
                        IFSPEED          => '1',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(5917) 0:00:59.17',
                        IFINOCTETS       => '611022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet 3600',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31,CIDATE 06/17/2005',
                NAME         => 'NPI6F72C5',
                SERIAL       => 'CNXJD65169',
            },
            CARTRIDGES => {
                TONERBLACK       => '63',
                TONERCYAN        => '44',
                TONERMAGENTA     => '46',
                TONERYELLOW      => '45',
            },
            PAGECOUNTERS => {
                COLOR      => '9946',
                TOTAL      => '11012',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:6f:72:c5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '127624321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '612088',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '24',
                        IFSPEED          => '1',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(5917) 0:00:59.17',
                        IFINOCTETS       => '611022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4000.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4000 Series',
            SNMPHOSTNAME => 'inspiron8',
            MAC          => '00:60:b0:91:3d:9d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4000 Series',
            SNMPHOSTNAME => 'inspiron8',
            MAC          => '00:60:b0:91:3d:9d',
            MODELSNMP    => 'Printer0391',
            FIRMWARE     => undef,
            SERIAL       => 'NLEW064384',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4000 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                NAME         => 'inspiron8',
                LOCATION     => 'lwcompta',
            },
            PAGECOUNTERS => {
                TOTAL      => '20653',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:60:b0:91:3d:9d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2393162823',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75803829',
                        IFOUTERRORS      => '321',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4000 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                NAME         => 'inspiron8',
                LOCATION     => 'lwcompta',
                SERIAL       => 'NLEW064384',
            },
            CARTRIDGES => {
                TONERBLACK       => '100',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '152',
                TOTAL      => '20653',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:60:b0:91:3d:9d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2393162823',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75803829',
                        IFOUTERRORS      => '321',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_400_color_M451dn.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 400 color M451dn',
            SNMPHOSTNAME => 'NPIF67498',
            MAC          => 'b4:b5:2f:f6:74:98',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 400 color M451dn',
            SNMPHOSTNAME => 'NPIF67498',
            MAC          => 'b4:b5:2f:f6:74:98',
            MODELSNMP    => 'Printer0730',
            FIRMWARE     => undef,
            SERIAL       => 'CNCF300725',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 400 color M451dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCF300725,FN:Q5132YG,SVCID:22330,PID:HP LaserJet 400 color M451dn',
                NAME         => 'NPIF67498',
            },
            PAGECOUNTERS => {
                TOTAL      => '541',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1544097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1544097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:74:98',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '407432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128595',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 400 color M451dn',
                COMMENTS     => 'HP LaserJet 400 color M451dn',
                NAME         => 'NPIF67498',
                SERIAL       => 'CNCF300725',
            },
            CARTRIDGES => {
                TONERBLACK       => '53',
                TONERCYAN        => '68',
                TONERMAGENTA     => '73',
            },
            PAGECOUNTERS => {
                COLOR      => '507',
                RECTOVERSO => '0',
                TOTAL      => '541',
                PRINTTOTAL => '541',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1544097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1544097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:74:98',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '407432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128595',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4050.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4050 Series ',
            SNMPHOSTNAME => 'imprimanteBR',
            MAC          => '00:30:c1:8c:d5:6c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4050 Series ',
            SNMPHOSTNAME => 'imprimanteBR',
            MAC          => '00:30:c1:8c:d5:6c',
            MODELSNMP    => 'Printer0615',
            FIRMWARE     => undef,
            SERIAL       => 'NL7N093250',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                NAME         => 'imprimanteBR',
                LOCATION     => 'impbe93',
            },
            PAGECOUNTERS => {
                TOTAL      => '252311',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8c:d5:6c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '343388846',
                        IFINERRORS       => '10',
                        IFOUTOCTETS      => '7245532',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP LaserJet 4050 Series ',
                NAME         => 'imprimanteBR',
                LOCATION     => 'impbe93',
                SERIAL       => 'NL7N093250',
            },
            CARTRIDGES => {
                TONERBLACK       => '0',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '0',
                TOTAL      => '252311',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8c:d5:6c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '343388846',
                        IFINERRORS       => '10',
                        IFOUTOCTETS      => '7245532',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4050.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4050 Series ',
            MAC          => '00:10:83:ba:17:ce',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 4050 Series ',
            MAC          => '00:10:83:ba:17:ce',
            MODELSNMP    => 'Printer0615',
            FIRMWARE     => undef,
            SERIAL       => 'NL7V061384',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                MEMORY       => '16',
                IPS          => {
                    IP => [
                        '128.93.22.64',
                    ],
                },
                UPTIME       => '(130640030) 15 days, 2:53:20.30',
            },
            PAGECOUNTERS => {
                TOTAL      => '243041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.64',
                        MAC              => '00:10:83:ba:17:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15339819',
                        IFINERRORS       => '124290',
                        IFOUTOCTETS      => '5833586',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP LaserJet 4050 Series ',
                MEMORY       => '16',
                SERIAL       => 'NL7V061384',
                IPS          => {
                    IP => [
                        '128.93.22.64',
                    ],
                },
                UPTIME       => '(130640030) 15 days, 2:53:20.30',
            },
            CARTRIDGES => {
                TONERBLACK       => '0',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '57131',
                TOTAL      => '243041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:10:83:ba:17:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15339819',
                        IFINERRORS       => '124290',
                        IFOUTOCTETS      => '5833586',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4200.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4200',
            SNMPHOSTNAME => 'IMP41200n0',
            MAC          => '00:01:e6:a1:a7:81',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4200',
            SNMPHOSTNAME => 'IMP41200n0',
            MAC          => '00:01:e6:a1:a7:81',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFX305387',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09,CIDATE 07/24/2003',
                NAME         => 'IMP41200n0',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '71',
            },
            PAGECOUNTERS => {
                TOTAL      => '60803',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:e6:a1:a7:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '17795405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2549445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09,CIDATE 07/24/2003',
                NAME         => 'IMP41200n0',
                SERIAL       => 'CNFX305387',
            },
            CARTRIDGES => {
                TONERBLACK       => '95',
                MAINTENANCEKIT   => '71',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '0',
                TOTAL      => '60803',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:e6:a1:a7:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '17795405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2549445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'impKirat',
            MAC          => '00:11:85:d9:f6:c7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'impKirat',
            MAC          => '00:11:85:d9:f6:c7',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNCXG01622',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43,CIDATE 06/23/2004',
                NAME         => 'impKirat',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '56',
            },
            PAGECOUNTERS => {
                TOTAL      => '99802',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:d9:f6:c7',
                        IFLASTCHANGE     => '(1384596280) 160 days, 6:06:02.80',
                        IFINOCTETS       => '3616354',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244332',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '24',
                        IFSPEED          => '1384596280',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376930680',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381269328',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43,CIDATE 06/23/2004',
                NAME         => 'impKirat',
                SERIAL       => 'CNCXG01622',
            },
            CARTRIDGES => {
                TONERBLACK       => '52',
                MAINTENANCEKIT   => '56',
            },
            PAGECOUNTERS => {
                TOTAL      => '99802',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:d9:f6:c7',
                        IFLASTCHANGE     => '(1384596280) 160 days, 6:06:02.80',
                        IFINOCTETS       => '3616354',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244332',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '24',
                        IFSPEED          => '1384596280',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376930680',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381269328',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l0812a',
            MAC          => '00:14:38:df:a5:30',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l0812a',
            MAC          => '00:14:38:df:a5:30',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXH84872',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l0812a',
                MEMORY       => '256',
                IPS          => {
                    IP => [
                        '128.93.22.88',
                    ],
                },
                UPTIME       => '(22322645) 2 days, 14:00:26.45',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '73',
            },
            PAGECOUNTERS => {
                TOTAL      => '60480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.88',
                        MAC              => '00:14:38:df:a5:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384198996) 160 days, 4:59:49.96',
                        IFINOCTETS       => '2049027686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '81883590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384198996',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l0812a',
                MEMORY       => '256',
                SERIAL       => 'CNHXH84872',
                IPS          => {
                    IP => [
                        '128.93.22.88',
                    ],
                },
                UPTIME       => '(22322645) 2 days, 14:00:26.45',
            },
            CARTRIDGES => {
                TONERBLACK       => '86',
                MAINTENANCEKIT   => '73',
            },
            PAGECOUNTERS => {
                TOTAL      => '60480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.88',
                        MAC              => '00:14:38:df:a5:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384198996) 160 days, 4:59:49.96',
                        IFINOCTETS       => '2049027686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '81883590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384198996',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA2B02',
            MAC          => '00:23:7d:7e:a1:31',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA2B02',
            MAC          => '00:23:7d:7e:a1:31',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXG83836',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'NPIEA2B02',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.8.82',
                    ],
                },
                UPTIME       => '(22683627) 2 days, 15:00:36.27',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '25',
            },
            PAGECOUNTERS => {
                TOTAL      => '167089',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.8.82',
                        MAC              => '00:23:7d:7e:a1:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384190036) 160 days, 4:58:20.36',
                        IFINOCTETS       => '2308962248',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34234855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384190036',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'NPIEA2B02',
                MEMORY       => '208',
                SERIAL       => 'CNHXG83836',
                IPS          => {
                    IP => [
                        '128.93.8.82',
                    ],
                },
                UPTIME       => '(22683627) 2 days, 15:00:36.27',
            },
            CARTRIDGES => {
                TONERBLACK       => '61',
                MAINTENANCEKIT   => '25',
            },
            PAGECOUNTERS => {
                TOTAL      => '167089',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.8.82',
                        MAC              => '00:23:7d:7e:a1:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384190036) 160 days, 4:58:20.36',
                        IFINOCTETS       => '2308962248',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34234855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384190036',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA3BFC',
            MAC          => '00:14:38:ea:3b:fc',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA3BFC',
            MAC          => '00:14:38:ea:3b:fc',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXB71032',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEA3BFC',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.22.90',
                    ],
                },
                UPTIME       => '(23418928) 2 days, 17:03:09.28',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '41',
            },
            PAGECOUNTERS => {
                TOTAL      => '131919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.90',
                        MAC              => '00:14:38:ea:3b:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384200904) 160 days, 5:00:09.04',
                        IFINOCTETS       => '1437804814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65704274',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384200904',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEA3BFC',
                MEMORY       => '208',
                SERIAL       => 'CNHXB71032',
                IPS          => {
                    IP => [
                        '128.93.22.90',
                    ],
                },
                UPTIME       => '(23418928) 2 days, 17:03:09.28',
            },
            CARTRIDGES => {
                TONERBLACK       => '25',
                MAINTENANCEKIT   => '41',
            },
            PAGECOUNTERS => {
                TOTAL      => '131919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.90',
                        MAC              => '00:14:38:ea:3b:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384200904) 160 days, 5:00:09.04',
                        IFINOCTETS       => '1437804814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65704274',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384200904',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l1310a',
            MAC          => '00:14:38:ea:2b:c4',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l1310a',
            MAC          => '00:14:38:ea:2b:c4',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXC68053',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1310a',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.13.25',
                    ],
                },
                UPTIME       => '(23191049) 2 days, 16:25:10.49',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '55',
            },
            PAGECOUNTERS => {
                TOTAL      => '101394',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.13.25',
                        MAC              => '00:14:38:ea:2b:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384213080) 160 days, 5:02:10.80',
                        IFINOCTETS       => '650567085',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5895937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384213080',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1310a',
                MEMORY       => '208',
                SERIAL       => 'CNHXC68053',
                IPS          => {
                    IP => [
                        '128.93.13.25',
                    ],
                },
                UPTIME       => '(23191049) 2 days, 16:25:10.49',
            },
            CARTRIDGES => {
                TONERBLACK       => '23',
                MAINTENANCEKIT   => '55',
            },
            PAGECOUNTERS => {
                TOTAL      => '101394',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.13.25',
                        MAC              => '00:14:38:ea:2b:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384213080) 160 days, 5:02:10.80',
                        IFINOCTETS       => '650567085',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5895937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384213080',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.06.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l1439a',
            MAC          => '00:14:38:e2:12:d8',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l1439a',
            MAC          => '00:14:38:e2:12:d8',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXH84870',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1439a',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.22.59',
                    ],
                },
                UPTIME       => '(22810882) 2 days, 15:21:48.82',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                TOTAL      => '27635',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.59',
                        MAC              => '00:14:38:e2:12:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384218412) 160 days, 5:03:04.12',
                        IFINOCTETS       => '1621092006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '24563627',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384218412',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1439a',
                MEMORY       => '208',
                SERIAL       => 'CNHXH84870',
                IPS          => {
                    IP => [
                        '128.93.22.59',
                    ],
                },
                UPTIME       => '(22810882) 2 days, 15:21:48.82',
            },
            CARTRIDGES => {
                TONERBLACK       => '84',
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                TOTAL      => '27635',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.59',
                        MAC              => '00:14:38:e2:12:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384218412) 160 days, 5:03:04.12',
                        IFINOCTETS       => '1621092006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '24563627',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384218412',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.07.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l2007a',
            MAC          => '00:1b:78:28:26:cb',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'l2007a',
            MAC          => '00:1b:78:28:26:cb',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXB68748',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'l2007a',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.22.41',
                    ],
                },
                UPTIME       => '(23402944) 2 days, 17:00:29.44',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '57',
            },
            PAGECOUNTERS => {
                TOTAL      => '95148',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.41',
                        MAC              => '00:1b:78:28:26:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384192000) 160 days, 4:58:40.00',
                        IFINOCTETS       => '2265964061',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5440024',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384192000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'l2007a',
                MEMORY       => '208',
                SERIAL       => 'CNHXB68748',
                IPS          => {
                    IP => [
                        '128.93.22.41',
                    ],
                },
                UPTIME       => '(23402944) 2 days, 17:00:29.44',
            },
            CARTRIDGES => {
                TONERBLACK       => '58',
                MAINTENANCEKIT   => '57',
            },
            PAGECOUNTERS => {
                TOTAL      => '95148',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.41',
                        MAC              => '00:1b:78:28:26:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384192000) 160 days, 4:58:40.00',
                        IFINOCTETS       => '2265964061',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5440024',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384192000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.08.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEAFA59',
            MAC          => '00:14:38:ea:fa:59',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEAFA59',
            MAC          => '00:14:38:ea:fa:59',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXB71050',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEAFA59',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.22.123',
                    ],
                },
                UPTIME       => '(22641038) 2 days, 14:53:30.38',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '53',
            },
            PAGECOUNTERS => {
                TOTAL      => '104887',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.123',
                        MAC              => '00:14:38:ea:fa:59',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384170484) 160 days, 4:55:04.84',
                        IFINOCTETS       => '1860424481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '87024832',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384170124',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEAFA59',
                MEMORY       => '208',
                SERIAL       => 'CNHXB71050',
                IPS          => {
                    IP => [
                        '128.93.22.123',
                    ],
                },
                UPTIME       => '(22641038) 2 days, 14:53:30.38',
            },
            CARTRIDGES => {
                TONERBLACK       => '5',
                MAINTENANCEKIT   => '53',
            },
            PAGECOUNTERS => {
                TOTAL      => '104887',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.123',
                        MAC              => '00:14:38:ea:fa:59',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384170484) 160 days, 4:55:04.84',
                        IFINOCTETS       => '1860424481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '87024832',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384170124',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.09.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA8E82',
            MAC          => '00:23:7d:81:22:f7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'NPIEA8E82',
            MAC          => '00:23:7d:81:22:f7',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXJ45092',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19,CIDATE 12/17/2008',
                NAME         => 'NPIEA8E82',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.10.59',
                    ],
                },
                UPTIME       => '(1097769844) 127 days, 1:21:38.44',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '81',
            },
            PAGECOUNTERS => {
                TOTAL      => '41756',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.10.59',
                        MAC              => '00:23:7d:81:22:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2163459797',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232877851',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19,CIDATE 12/17/2008',
                NAME         => 'NPIEA8E82',
                MEMORY       => '208',
                SERIAL       => 'CNHXJ45092',
                IPS          => {
                    IP => [
                        '128.93.10.59',
                    ],
                },
                UPTIME       => '(1097769844) 127 days, 1:21:38.44',
            },
            CARTRIDGES => {
                TONERBLACK       => '83',
                MAINTENANCEKIT   => '81',
            },
            PAGECOUNTERS => {
                TOTAL      => '41756',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.10.59',
                        MAC              => '00:23:7d:81:22:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2163459797',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232877851',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250dtn.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'L3000A',
            MAC          => '00:14:38:e2:12:5f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp LaserJet 4250',
            SNMPHOSTNAME => 'L3000A',
            MAC          => '00:14:38:e2:12:5f',
            MODELSNMP    => 'Printer0078',
            FIRMWARE     => undef,
            SERIAL       => 'CNHXC65951',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25,CIDATE 01/09/2012',
                NAME         => 'L3000A',
                MEMORY       => '208',
                IPS          => {
                    IP => [
                        '128.93.22.79',
                    ],
                },
                UPTIME       => '(2286542) 6:21:05.42',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '86',
            },
            PAGECOUNTERS => {
                TOTAL      => '30844',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.22.79',
                        MAC              => '00:14:38:e2:12:5f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '680237212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2461952',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25,CIDATE 01/09/2012',
                NAME         => 'L3000A',
                MEMORY       => '208',
                SERIAL       => 'CNHXC65951',
                IPS          => {
                    IP => [
                        '128.93.22.79',
                    ],
                },
                UPTIME       => '(2286542) 6:21:05.42',
            },
            CARTRIDGES => {
                TONERBLACK       => '24',
                MAINTENANCEKIT   => '86',
            },
            PAGECOUNTERS => {
                TOTAL      => '30844',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.22.79',
                        MAC              => '00:14:38:e2:12:5f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '680237212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2461952',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_500.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 500 color M551',
            SNMPHOSTNAME => 'NPI419F6E',
            MAC          => '2c:76:8a:41:9f:6e',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 500 color M551',
            SNMPHOSTNAME => 'NPI419F6E',
            MAC          => '2c:76:8a:41:9f:6e',
            MODELSNMP    => 'Printer0628',
            FIRMWARE     => undef,
            SERIAL       => 'SE00V4T',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 500 color M551',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114,CIDATE 11/17/2011',
                NAME         => 'NPI419F6E',
            },
            PAGECOUNTERS => {
                TOTAL      => '8514',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:76:8a:41:9f:6e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143357783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9194670',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 500 color M551',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114,CIDATE 11/17/2011',
                NAME         => 'NPI419F6E',
                SERIAL       => 'SE00V4T',
            },
            PAGECOUNTERS => {
                BLACK      => '1685',
                COLOR      => '6601',
                TOTAL      => '8514',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:76:8a:41:9f:6e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143357783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9194670',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_5550.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp color LaserJet 5550 ',
            SNMPHOSTNAME => 'IDD116',
            MAC          => '00:1b:78:f0:f4:47',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'hp color LaserJet 5550 ',
            SNMPHOSTNAME => 'IDD116',
            MAC          => '00:1b:78:f0:f4:47',
            MODELSNMP    => 'Printer0614',
            FIRMWARE     => undef,
            SERIAL       => 'SG96304AD8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp color LaserJet 5550 ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'IDD116',
            },
            PAGECOUNTERS => {
                TOTAL      => '194821',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:f0:f4:47',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '188114366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3722494',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '2149727364',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2148908512) 248 days, 17:11:25.12',
                        IFINOCTETS       => '8',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'hp color LaserJet 5550 ',
                COMMENTS     => 'hp color LaserJet 5550 ',
                NAME         => 'IDD116',
                SERIAL       => 'SG96304AD8',
            },
            CARTRIDGES => {
                TONERBLACK       => '12',
                TONERCYAN        => '95',
                TONERMAGENTA     => '95',
                TONERYELLOW      => '96',
            },
            PAGECOUNTERS => {
                BLACK      => '102279',
                COLOR      => '92447',
                RECTOVERSO => '0',
                TOTAL      => '194821',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:f0:f4:47',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '188114366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3722494',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '2149727364',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2148908512) 248 days, 17:11:25.12',
                        IFINOCTETS       => '8',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_600.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 600 M603',
            SNMPHOSTNAME => 'lj1',
            MAC          => 'e8:39:35:90:92:1f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 600 M603',
            SNMPHOSTNAME => 'lj1',
            MAC          => 'e8:39:35:90:92:1f',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj1',
            },
            PAGECOUNTERS => {
                TOTAL      => '26784',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:92:1f',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2054925461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15908767',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj1',
            },
            PAGECOUNTERS => {
                TOTAL      => '26784',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:92:1f',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2054925461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15908767',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_600.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 600 M603',
            SNMPHOSTNAME => 'lj2',
            MAC          => 'e8:39:35:90:22:ac',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet 600 M603',
            SNMPHOSTNAME => 'lj2',
            MAC          => 'e8:39:35:90:22:ac',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj2',
            },
            PAGECOUNTERS => {
                TOTAL      => '51894',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:22:ac',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '421318194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3953117',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj2',
            },
            PAGECOUNTERS => {
                TOTAL      => '51894',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:22:ac',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '421318194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3953117',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM1312nfi_MFP.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM1312nfi MFP',
            SNMPHOSTNAME => 'NPI271E90',
            MAC          => '00:1f:29:27:1e:90',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM1312nfi MFP',
            SNMPHOSTNAME => 'NPI271E90',
            MAC          => '00:1f:29:27:1e:90',
            MODELSNMP    => 'Printer0396',
            FIRMWARE     => undef,
            SERIAL       => 'CNB885QNXP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM1312nfi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNB885QNXP,FN:NL106CH,SVCID:18334,PID:HP Color LaserJet CM1312nfi MFP',
                NAME         => 'NPI271E90',
                LOCATION     => 'HP Color LaserJet CM1312nfi MFP',
            },
            PAGECOUNTERS => {
                TOTAL      => '20179',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9886098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9684604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:27:1e:90',
                        IFLASTCHANGE     => '(517) 0:00:05.17',
                        IFINOCTETS       => '16842599',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '849706',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM1312nfi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNB885QNXP,FN:NL106CH,SVCID:18334,PID:HP Color LaserJet CM1312nfi MFP',
                NAME         => 'NPI271E90',
                LOCATION     => 'HP Color LaserJet CM1312nfi MFP',
                SERIAL       => 'CNB885QNXP',
            },
            CARTRIDGES => {
                TONERBLACK       => '68',
                TONERCYAN        => '35',
                TONERMAGENTA     => '89',
                TONERYELLOW      => '59',
            },
            PAGECOUNTERS => {
                TOTAL      => '20179',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9886098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9684604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:27:1e:90',
                        IFLASTCHANGE     => '(517) 0:00:05.17',
                        IFINOCTETS       => '16842599',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '849706',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM1415fn.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet CM1415fn',
            SNMPHOSTNAME => 'B536-lwc237-Fax',
            MAC          => '68:b5:99:ad:61:8e',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet CM1415fn',
            SNMPHOSTNAME => 'B536-lwc237-Fax',
            MAC          => '68:b5:99:ad:61:8e',
            MODELSNMP    => 'Printer0575',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet CM1415fn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNF8BC11FK,FN:QD30T49,SVCID:21055,PID:HP LaserJet CM1415fn',
                NAME         => 'B536-lwc237-Fax',
            },
            PAGECOUNTERS => {
                TOTAL      => '5480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143008520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142942976',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '68:b5:99:ad:61:8e',
                        IFLASTCHANGE     => '(364754) 1:00:47.54',
                        IFINOCTETS       => '71548687',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356768881',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet CM1415fn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNF8BC11FK,FN:QD30T49,SVCID:21055,PID:HP LaserJet CM1415fn',
                NAME         => 'B536-lwc237-Fax',
            },
            CARTRIDGES => {
                TONERBLACK       => '25',
                TONERCYAN        => '35',
                TONERMAGENTA     => '31',
                TONERYELLOW      => '33',
            },
            PAGECOUNTERS => {
                BLACK      => '760',
                COLOR      => '4720',
                RECTOVERSO => '0',
                TOTAL      => '5480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143008520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142942976',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '68:b5:99:ad:61:8e',
                        IFLASTCHANGE     => '(364754) 1:00:47.54',
                        IFINOCTETS       => '71548687',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356768881',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI7F5D71',
            MAC          => '00:23:7d:7f:5d:71',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI7F5D71',
            MAC          => '00:23:7d:7f:5d:71',
            MODELSNMP    => 'Printer0550',
            FIRMWARE     => undef,
            SERIAL       => 'CNFN9BYG41',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            },
            PAGECOUNTERS => {
                TOTAL      => '25632',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '368171197',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366212613',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(512) 0:00:05.12',
                        IFINOCTETS       => '293534493',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '39257355',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNFN9BYG41',
            },
            CARTRIDGES => {
                TONERBLACK       => '43',
                TONERCYAN        => '46',
                TONERMAGENTA     => '41',
                TONERYELLOW      => '18',
            },
            PAGECOUNTERS => {
                TOTAL      => '25632',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '368171197',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366212613',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(512) 0:00:05.12',
                        IFINOCTETS       => '293534493',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '39257355',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI7F5D71',
            MAC          => '00:23:7d:7f:5d:71',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI7F5D71',
            MAC          => '00:23:7d:7f:5d:71',
            MODELSNMP    => 'Printer0550',
            FIRMWARE     => undef,
            SERIAL       => 'CNFN9BYG41',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            },
            PAGECOUNTERS => {
                TOTAL      => '21862',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '784368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '454091',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '175629',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNFN9BYG41',
            },
            CARTRIDGES => {
                TONERBLACK       => '46',
                TONERCYAN        => '52',
                TONERMAGENTA     => '46',
                TONERYELLOW      => '15',
            },
            PAGECOUNTERS => {
                TOTAL      => '21862',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '784368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '454091',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '175629',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI828833',
            MAC          => '00:23:7d:82:88:33',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320fxi MFP',
            SNMPHOSTNAME => 'NPI828833',
            MAC          => '00:23:7d:82:88:33',
            MODELSNMP    => 'Printer0550',
            FIRMWARE     => undef,
            SERIAL       => 'CNDN99YG0D',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNDN99YG0D,FN:NN40AH0,SVCID:19312,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI828833',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            },
            PAGECOUNTERS => {
                TOTAL      => '7308',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '254579996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '254171744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:82:88:33',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '342647146',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '73067033',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNDN99YG0D,FN:NN40AH0,SVCID:19312,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI828833',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNDN99YG0D',
            },
            CARTRIDGES => {
                TONERBLACK       => '31',
                TONERCYAN        => '96',
                TONERMAGENTA     => '87',
                TONERYELLOW      => '17',
            },
            PAGECOUNTERS => {
                TOTAL      => '7308',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '254579996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '254171744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:82:88:33',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '342647146',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '73067033',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320nf_MFP.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320nf MFP',
            SNMPHOSTNAME => 'NPIB302A7',
            MAC          => '3c:4a:92:b3:02:a7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CM2320nf MFP',
            SNMPHOSTNAME => 'NPIB302A7',
            MAC          => '3c:4a:92:b3:02:a7',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNFTBDZ0FN',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320nf MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFTBDZ0FN,FN:PT60J59,SVCID:21046,PID:HP Color LaserJet CM2320nf MFP',
                NAME         => 'NPIB302A7',
                LOCATION     => 'HP Color LaserJet CM2320nf MFP',
            },
            PAGECOUNTERS => {
                TOTAL      => '930',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '447698759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447698281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:b3:02:a7',
                        IFLASTCHANGE     => '(609) 0:00:06.09',
                        IFINOCTETS       => '66621082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2067624',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CM2320nf MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFTBDZ0FN,FN:PT60J59,SVCID:21046,PID:HP Color LaserJet CM2320nf MFP',
                NAME         => 'NPIB302A7',
                LOCATION     => 'HP Color LaserJet CM2320nf MFP',
                SERIAL       => 'CNFTBDZ0FN',
            },
            CARTRIDGES => {
                TONERBLACK       => '23',
                TONERCYAN        => '50',
                TONERMAGENTA     => '55',
                TONERYELLOW      => '56',
            },
            PAGECOUNTERS => {
                BLACK      => '141',
                COLOR      => '789',
                RECTOVERSO => '0',
                TOTAL      => '930',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '447698759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447698281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:b3:02:a7',
                        IFLASTCHANGE     => '(609) 0:00:06.09',
                        IFINOCTETS       => '66621082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2067624',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP1025nw.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet CP1025nw',
            SNMPHOSTNAME => 'NPIA6032E',
            MAC          => '78:e7:d1:a6:03:2e',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet CP1025nw',
            SNMPHOSTNAME => 'NPIA6032E',
            MAC          => '78:e7:d1:a6:03:2e',
            MODELSNMP    => 'Printer0532',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet CP1025nw',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                CONTACT      => ' ',
                NAME         => 'NPIA6032E',
                LOCATION     => ' ',
            },
            PAGECOUNTERS => {
                TOTAL      => '402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:e7:d1:a6:03:2e',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '33595273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1357116',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet CP1025nw',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                CONTACT      => ' ',
                NAME         => 'NPIA6032E',
                LOCATION     => ' ',
            },
            PAGECOUNTERS => {
                BLACK      => '91',
                TOTAL      => '402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:e7:d1:a6:03:2e',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '33595273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1357116',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025dn.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPI2AD743',
            MAC          => '00:1f:29:2a:d7:43',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPI2AD743',
            MAC          => '00:1f:29:2a:d7:43',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNCSF01053',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCSF01053,FN:MB01ZGH,SVCID:18347,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPI2AD743',
                LOCATION     => 'HP Color LaserJet CP2025dn',
            },
            PAGECOUNTERS => {
                TOTAL      => '31747',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '803165203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801066149',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:2a:d7:43',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '575687995',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8880062',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCSF01053,FN:MB01ZGH,SVCID:18347,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPI2AD743',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNCSF01053',
            },
            CARTRIDGES => {
                TONERBLACK       => '19',
                TONERCYAN        => '34',
                TONERMAGENTA     => '18',
                TONERYELLOW      => '34',
            },
            PAGECOUNTERS => {
                BLACK      => '9817',
                COLOR      => '21930',
                RECTOVERSO => '2584',
                TOTAL      => '31747',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '803165203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801066149',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:2a:d7:43',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '575687995',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8880062',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025dn.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPIC3D5FF',
            MAC          => 'b4:99:ba:c3:d5:ff',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025dn',
            SNMPHOSTNAME => 'NPIC3D5FF',
            MAC          => 'b4:99:ba:c3:d5:ff',
            MODELSNMP    => 'Printer0414',
            FIRMWARE     => undef,
            SERIAL       => 'CNHS437790',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS437790,FN:MB27295,SVCID:22039,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPIC3D5FF',
                LOCATION     => 'HP Color LaserJet CP2025dn',
            },
            PAGECOUNTERS => {
                TOTAL      => '8699',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '392477023',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '416180804',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:99:ba:c3:d5:ff',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '247854787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17527357',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS437790,FN:MB27295,SVCID:22039,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPIC3D5FF',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS437790',
            },
            CARTRIDGES => {
                TONERBLACK       => '89',
                TONERCYAN        => '48',
                TONERMAGENTA     => '33',
                TONERYELLOW      => '24',
            },
            PAGECOUNTERS => {
                BLACK      => '1198',
                COLOR      => '7501',
                RECTOVERSO => '1',
                TOTAL      => '8699',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '392477023',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '416180804',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:99:ba:c3:d5:ff',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '247854787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17527357',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI117008',
            MAC          => '2c:27:d7:11:70:08',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI117008',
            MAC          => '2c:27:d7:11:70:08',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNHSP65440',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSP65440,FN:MB303HX,SVCID:21236,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI117008',
                LOCATION     => 'HP Color LaserJet CP2025n',
            },
            PAGECOUNTERS => {
                TOTAL      => '3454',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3229787810',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228564584',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:11:70:08',
                        IFLASTCHANGE     => '(278502387) 32 days, 5:37:03.87',
                        IFINOCTETS       => '3962571861',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '80583527',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSP65440,FN:MB303HX,SVCID:21236,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI117008',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNHSP65440',
            },
            CARTRIDGES => {
                TONERBLACK       => '41',
                TONERCYAN        => '72',
                TONERMAGENTA     => '85',
                TONERYELLOW      => '87',
            },
            PAGECOUNTERS => {
                BLACK      => '1145',
                COLOR      => '2309',
                RECTOVERSO => '0',
                TOTAL      => '3454',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3229787810',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228564584',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:11:70:08',
                        IFLASTCHANGE     => '(278502387) 32 days, 5:37:03.87',
                        IFINOCTETS       => '3962571861',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '80583527',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI84C481',
            MAC          => '00:21:5a:84:c4:81',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI84C481',
            MAC          => '00:21:5a:84:c4:81',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNCS404796',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
            },
            PAGECOUNTERS => {
                TOTAL      => '14722',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3603654689',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3603294840',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '1951645626',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42454155',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS404796',
            },
            CARTRIDGES => {
                TONERBLACK       => '31',
                TONERCYAN        => '69',
                TONERMAGENTA     => '32',
                TONERYELLOW      => '77',
            },
            PAGECOUNTERS => {
                BLACK      => '3459',
                COLOR      => '11263',
                RECTOVERSO => '0',
                TOTAL      => '14722',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3603654689',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3603294840',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '1951645626',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42454155',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI84C481',
            MAC          => '00:21:5a:84:c4:81',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI84C481',
            MAC          => '00:21:5a:84:c4:81',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNCS404796',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
            },
            PAGECOUNTERS => {
                TOTAL      => '16627',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3616912763',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3616622374',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '2925586477',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50103223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS404796',
            },
            CARTRIDGES => {
                TONERBLACK       => '83',
                TONERCYAN        => '33',
                TONERMAGENTA     => '93',
                TONERYELLOW      => '50',
            },
            PAGECOUNTERS => {
                BLACK      => '3896',
                COLOR      => '12731',
                RECTOVERSO => '0',
                TOTAL      => '16627',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3616912763',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3616622374',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '2925586477',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50103223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI81E3A7',
            MAC          => '00:21:5a:81:e3:a7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI81E3A7',
            MAC          => '00:21:5a:81:e3:a7',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNCS212370',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS212370,FN:MB03SY2,SVCID:19127,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI81E3A7',
                LOCATION     => 'HP Color LaserJet CP2025n',
            },
            PAGECOUNTERS => {
                TOTAL      => '21956',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '380316273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380139218',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:81:e3:a7',
                        IFLASTCHANGE     => '(605) 0:00:06.05',
                        IFINOCTETS       => '112601870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3560969',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS212370,FN:MB03SY2,SVCID:19127,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI81E3A7',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS212370',
            },
            CARTRIDGES => {
                TONERBLACK       => '41',
                TONERCYAN        => '93',
                TONERMAGENTA     => '47',
                TONERYELLOW      => '63',
            },
            PAGECOUNTERS => {
                BLACK      => '5506',
                COLOR      => '16450',
                RECTOVERSO => '0',
                TOTAL      => '21956',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '380316273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380139218',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:81:e3:a7',
                        IFLASTCHANGE     => '(605) 0:00:06.05',
                        IFINOCTETS       => '112601870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3560969',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI8FA1DD',
            MAC          => '78:ac:c0:8f:a1:dd',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP2025n',
            SNMPHOSTNAME => 'NPI8FA1DD',
            MAC          => '78:ac:c0:8f:a1:dd',
            MODELSNMP    => 'Printer0393',
            FIRMWARE     => undef,
            SERIAL       => 'CNHSN58554',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSN58554,FN:MB258FW,SVCID:21095,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI8FA1DD',
                LOCATION     => 'HP Color LaserJet CP2025n',
            },
            PAGECOUNTERS => {
                TOTAL      => '9601',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8463955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8809286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:ac:c0:8f:a1:dd',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '4563808',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '529251',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSN58554,FN:MB258FW,SVCID:21095,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI8FA1DD',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNHSN58554',
            },
            CARTRIDGES => {
                TONERBLACK       => '55',
                TONERCYAN        => '18',
                TONERMAGENTA     => '23',
                TONERYELLOW      => '29',
            },
            PAGECOUNTERS => {
                BLACK      => '3843',
                COLOR      => '5758',
                RECTOVERSO => '0',
                TOTAL      => '9601',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8463955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8809286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:ac:c0:8f:a1:dd',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '4563808',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '529251',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'NPI85A57D',
            MAC          => '00:23:7d:85:a5:7d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'NPI85A57D',
            MAC          => '00:23:7d:85:a5:7d',
            MODELSNMP    => 'Printer0388',
            FIRMWARE     => undef,
            SERIAL       => 'CNCT98DGJY',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67,CIDATE 06/17/2008',
                NAME         => 'NPI85A57D',
            },
            PAGECOUNTERS => {
                TOTAL      => '16740',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:85:a5:7d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '695289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '535873',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67,CIDATE 06/17/2008',
                NAME         => 'NPI85A57D',
                SERIAL       => 'CNCT98DGJY',
            },
            CARTRIDGES => {
                TONERBLACK       => '67',
                TONERCYAN        => '39',
                TONERMAGENTA     => '21',
                TONERYELLOW      => '30',
            },
            PAGECOUNTERS => {
                BLACK      => '7603',
                COLOR      => '9127',
                RECTOVERSO => '0',
                TOTAL      => '16740',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:85:a5:7d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '695289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '535873',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'Corinne',
            MAC          => 'd4:85:64:3d:ac:2e',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'Corinne',
            MAC          => 'd4:85:64:3d:ac:2e',
            MODELSNMP    => 'Printer0388',
            FIRMWARE     => undef,
            SERIAL       => 'CNCTB9PHWG',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'Corinne',
            },
            PAGECOUNTERS => {
                TOTAL      => '19183',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'd4:85:64:3d:ac:2e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9335102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '762709',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'Corinne',
                SERIAL       => 'CNCTB9PHWG',
            },
            CARTRIDGES => {
                TONERBLACK       => '53',
                TONERCYAN        => '21',
                TONERMAGENTA     => '97',
                TONERYELLOW      => '8',
            },
            PAGECOUNTERS => {
                BLACK      => '7256',
                COLOR      => '11905',
                RECTOVERSO => '49',
                TOTAL      => '19183',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'd4:85:64:3d:ac:2e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9335102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '762709',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'nerium',
            MAC          => 'd4:85:64:40:4d:93',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP3525',
            SNMPHOSTNAME => 'nerium',
            MAC          => 'd4:85:64:40:4d:93',
            MODELSNMP    => 'Printer0388',
            FIRMWARE     => undef,
            SERIAL       => 'CBAFTBDG66',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'nerium',
                MEMORY       => '384',
                IPS          => {
                    IP => [
                        '192.168.1.41',
                    ],
                },
                UPTIME       => '(457735283) 52 days, 23:29:12.83',
            },
            PAGECOUNTERS => {
                TOTAL      => '16808',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.41',
                        MAC              => 'd4:85:64:40:4d:93',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3638074715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167843585',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'nerium',
                MEMORY       => '384',
                SERIAL       => 'CBAFTBDG66',
                IPS          => {
                    IP => [
                        '192.168.1.41',
                    ],
                },
                UPTIME       => '(457735283) 52 days, 23:29:12.83',
            },
            CARTRIDGES => {
                TONERBLACK       => '7',
                TONERCYAN        => '52',
                TONERMAGENTA     => '60',
                TONERYELLOW      => '84',
            },
            PAGECOUNTERS => {
                TOTAL      => '16808',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.41',
                        MAC              => 'd4:85:64:40:4d:93',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3638074715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167843585',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP4520.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP4520 Series',
            SNMPHOSTNAME => 'NPI10DB2C',
            MAC          => '2c:27:d7:10:db:2c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP Color LaserJet CP4520 Series',
            SNMPHOSTNAME => 'NPI10DB2C',
            MAC          => '2c:27:d7:10:db:2c',
            MODELSNMP    => 'Printer0639',
            FIRMWARE     => undef,
            SERIAL       => 'JPCTC8M0LJ',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP4520 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99,CIDATE 11/26/2010',
                NAME         => 'NPI10DB2C',
            },
            PAGECOUNTERS => {
                TOTAL      => '14604',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:10:db:2c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2342375615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '43069516',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP Color LaserJet CP4520 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99,CIDATE 11/26/2010',
                NAME         => 'NPI10DB2C',
                SERIAL       => 'JPCTC8M0LJ',
            },
            CARTRIDGES => {
                TONERCYAN        => '47',
                TONERMAGENTA     => '44',
                TONERYELLOW      => '50',
            },
            PAGECOUNTERS => {
                BLACK      => '8881',
                PRINTBLACK => '8765',
                COLOR      => '5839',
                PRINTCOLOR => '5839',
                TOTAL      => '14604',
                PRINTTOTAL => '14610',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:10:db:2c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2342375615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '43069516',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_M1217nfw.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet Professional M1217nfw MFP',
            SNMPHOSTNAME => 'l2407a',
            MAC          => '10:60:4b:19:a6:51',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet Professional M1217nfw MFP',
            SNMPHOSTNAME => 'l2407a',
            MAC          => '10:60:4b:19:a6:51',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet Professional M1217nfw MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                CONTACT      => ' ',
                NAME         => 'l2407a',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '128.93.22.58',
                        '192.168.223.1',
                    ],
                },
                UPTIME       => '(261657629) 30 days, 6:49:36.29',
            },
            PAGECOUNTERS => {
                TOTAL      => '919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.58',
                        MAC              => '10:60:4b:19:a6:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380) 0:00:03.80',
                        IFINOCTETS       => '1332770858',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '59043597',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'uAP_drvr',
                        IFDESCR          => 'uAP_drvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.223.1',
                        MAC              => '84:4b:f5:84:07:a2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28) 0:00:00.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '1',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet Professional M1217nfw MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                CONTACT      => ' ',
                NAME         => 'l2407a',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '128.93.22.58',
                        '192.168.223.1',
                    ],
                },
                UPTIME       => '(261657629) 30 days, 6:49:36.29',
            },
            PAGECOUNTERS => {
                TOTAL      => '919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.58',
                        MAC              => '10:60:4b:19:a6:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380) 0:00:03.80',
                        IFINOCTETS       => '1332770858',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '59043597',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'uAP_drvr',
                        IFDESCR          => 'uAP_drvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.223.1',
                        MAC              => '84:4b:f5:84:07:a2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28) 0:00:00.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '1',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI83EC85',
            MAC          => '00:21:5a:83:ec:85',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI83EC85',
            MAC          => '00:21:5a:83:ec:85',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW898043',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
            },
            PAGECOUNTERS => {
                TOTAL      => '36596',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1081446700',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1081457348',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '2857680319',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '398641223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW898043',
            },
            CARTRIDGES => {
                TONERBLACK       => '44',
            },
            PAGECOUNTERS => {
                BLACK      => '36596',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '36596',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1081446700',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1081457348',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '2857680319',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '398641223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI13EE63',
            MAC          => '00:1b:78:13:ee:63',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI13EE63',
            MAC          => '00:1b:78:13:ee:63',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW7BQ7BS',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7BQ7BS,FN:JK44SRD,SVCID:18021,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI13EE63',
                LOCATION     => 'Boise, ID, USA',
            },
            PAGECOUNTERS => {
                TOTAL      => '25333',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '31512183',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '31512183',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:13:ee:63',
                        IFLASTCHANGE     => '(699) 0:00:06.99',
                        IFINOCTETS       => '91830571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1268509',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7BQ7BS,FN:JK44SRD,SVCID:18021,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI13EE63',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW7BQ7BS',
            },
            CARTRIDGES => {
                TONERBLACK       => '59',
            },
            PAGECOUNTERS => {
                BLACK      => '25333',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '25333',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '31512183',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '31512183',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:13:ee:63',
                        IFLASTCHANGE     => '(699) 0:00:06.99',
                        IFINOCTETS       => '91830571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1268509',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI83EC85',
            MAC          => '00:21:5a:83:ec:85',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI83EC85',
            MAC          => '00:21:5a:83:ec:85',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW898043',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
            },
            PAGECOUNTERS => {
                TOTAL      => '36301',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '340834617',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '340834617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '141025151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1679896',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW898043',
            },
            CARTRIDGES => {
                TONERBLACK       => '50',
            },
            PAGECOUNTERS => {
                BLACK      => '36301',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '36301',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '340834617',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '340834617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '141025151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1679896',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI2BAB3D',
            MAC          => '00:1f:29:2b:ab:3d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI2BAB3D',
            MAC          => '00:1f:29:2b:ab:3d',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW87R2XX',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW87R2XX,FN:JK5BJMX,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI2BAB3D',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.213',
                    ],
                },
                UPTIME       => '(200046302) 23 days, 3:41:03.02',
            },
            PAGECOUNTERS => {
                TOTAL      => '129336',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '578298200',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '578302190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.213',
                        MAC              => '00:1f:29:2b:ab:3d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '1659255782',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33116153',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW87R2XX,FN:JK5BJMX,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI2BAB3D',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW87R2XX',
                IPS          => {
                    IP => [
                        '128.93.22.213',
                    ],
                },
                UPTIME       => '(200046302) 23 days, 3:41:03.02',
            },
            CARTRIDGES => {
                TONERBLACK       => '65',
            },
            PAGECOUNTERS => {
                BLACK      => '129336',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '129336',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '578298200',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '578302190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.213',
                        MAC              => '00:1f:29:2b:ab:3d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '1659255782',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33116153',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8CA86F',
            MAC          => '00:17:08:8c:a8:6f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8CA86F',
            MAC          => '00:17:08:8c:a8:6f',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW6DW3R8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW3R8,FN:JK151HQ,SVCID:00000,PID:l0713a',
                NAME         => 'NPI8CA86F',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.14',
                    ],
                },
                UPTIME       => '(180819074) 20 days, 22:16:30.74',
            },
            PAGECOUNTERS => {
                TOTAL      => '45078',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '513466755',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '513471955',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.14',
                        MAC              => '00:17:08:8c:a8:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1603) 0:00:16.03',
                        IFINOCTETS       => '4284098790',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42529924',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW3R8,FN:JK151HQ,SVCID:00000,PID:l0713a',
                NAME         => 'NPI8CA86F',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW6DW3R8',
                IPS          => {
                    IP => [
                        '128.93.22.14',
                    ],
                },
                UPTIME       => '(180819074) 20 days, 22:16:30.74',
            },
            CARTRIDGES => {
                TONERBLACK       => '18',
            },
            PAGECOUNTERS => {
                BLACK      => '45078',
                COLOR      => '0',
                RECTOVERSO => '20379',
                TOTAL      => '45078',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '513466755',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '513471955',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.14',
                        MAC              => '00:17:08:8c:a8:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1603) 0:00:16.03',
                        IFINOCTETS       => '4284098790',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42529924',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.06.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8E6910',
            MAC          => '00:17:08:8e:69:10',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8E6910',
            MAC          => '00:17:08:8e:69:10',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW7171V8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7171V8,FN:JK15ESY,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI8E6910',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.22',
                    ],
                },
                UPTIME       => '(138093688) 15 days, 23:35:36.88',
            },
            PAGECOUNTERS => {
                TOTAL      => '16610',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '387932396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '387939313',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.22',
                        MAC              => '00:17:08:8e:69:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1601) 0:00:16.01',
                        IFINOCTETS       => '84810818',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '18961108',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7171V8,FN:JK15ESY,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI8E6910',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW7171V8',
                IPS          => {
                    IP => [
                        '128.93.22.22',
                    ],
                },
                UPTIME       => '(138093688) 15 days, 23:35:36.88',
            },
            CARTRIDGES => {
                TONERBLACK       => '46',
            },
            PAGECOUNTERS => {
                BLACK      => '16610',
                COLOR      => '0',
                RECTOVERSO => '423',
                TOTAL      => '16610',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '387932396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '387939313',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.22',
                        MAC              => '00:17:08:8e:69:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1601) 0:00:16.01',
                        IFINOCTETS       => '84810818',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '18961108',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.07.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8C980D',
            MAC          => '00:17:08:8c:98:0d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI8C980D',
            MAC          => '00:17:08:8c:98:0d',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW6DW37G',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW37G,FN:JK15170,SVCID:00000,PID:l2405a',
                NAME         => 'NPI8C980D',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.122',
                    ],
                },
                UPTIME       => '(71190989) 8 days, 5:45:09.89',
            },
            PAGECOUNTERS => {
                TOTAL      => '5943',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '199794226',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '199797652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.122',
                        MAC              => '00:17:08:8c:98:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1702) 0:00:17.02',
                        IFINOCTETS       => '1621136760',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4321189',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW37G,FN:JK15170,SVCID:00000,PID:l2405a',
                NAME         => 'NPI8C980D',
                MEMORY       => '159',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW6DW37G',
                IPS          => {
                    IP => [
                        '128.93.22.122',
                    ],
                },
                UPTIME       => '(71190989) 8 days, 5:45:09.89',
            },
            CARTRIDGES => {
                TONERBLACK       => '32',
            },
            PAGECOUNTERS => {
                BLACK      => '5943',
                COLOR      => '0',
                RECTOVERSO => '930',
                TOTAL      => '5943',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '199794226',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '199797652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.122',
                        MAC              => '00:17:08:8c:98:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1702) 0:00:17.02',
                        IFINOCTETS       => '1621136760',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4321189',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.08.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI7954CF',
            MAC          => '00:23:7d:79:54:cf',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI7954CF',
            MAC          => '00:23:7d:79:54:cf',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW76W0B8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW76W0B8,FN:JK62250,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI7954CF',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.220',
                    ],
                },
                UPTIME       => '(59927764) 6 days, 22:27:57.64',
            },
            PAGECOUNTERS => {
                TOTAL      => '96192',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '170980525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '170990271',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.220',
                        MAC              => '00:23:7d:79:54:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '593649816',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5505762',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW76W0B8,FN:JK62250,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI7954CF',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW76W0B8',
                IPS          => {
                    IP => [
                        '128.93.22.220',
                    ],
                },
                UPTIME       => '(59927764) 6 days, 22:27:57.64',
            },
            CARTRIDGES => {
                TONERBLACK       => '66',
            },
            PAGECOUNTERS => {
                BLACK      => '96192',
                COLOR      => '0',
                RECTOVERSO => '620',
                TOTAL      => '96192',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '170980525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '170990271',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.220',
                        MAC              => '00:23:7d:79:54:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '593649816',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5505762',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.09.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI156F54',
            MAC          => '00:1a:4b:15:6f:54',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI156F54',
            MAC          => '00:1a:4b:15:6f:54',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW74K7GP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW74K7GP,FN:JK306JC,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI156F54',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.197',
                    ],
                },
                UPTIME       => '(2901531) 8:03:35.31',
            },
            PAGECOUNTERS => {
                TOTAL      => '30412',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8480431',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8482160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.197',
                        MAC              => '00:1a:4b:15:6f:54',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '371591459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581750',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW74K7GP,FN:JK306JC,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI156F54',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW74K7GP',
                IPS          => {
                    IP => [
                        '128.93.22.197',
                    ],
                },
                UPTIME       => '(2901531) 8:03:35.31',
            },
            CARTRIDGES => {
                TONERBLACK       => '90',
            },
            PAGECOUNTERS => {
                BLACK      => '30412',
                COLOR      => '0',
                RECTOVERSO => '65',
                TOTAL      => '30412',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8480431',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8482160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.197',
                        MAC              => '00:1a:4b:15:6f:54',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '371591459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581750',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.10.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI166E31',
            MAC          => '00:1f:29:16:6e:31',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2015 Series',
            SNMPHOSTNAME => 'NPI166E31',
            MAC          => '00:1f:29:16:6e:31',
            MODELSNMP    => 'Printer0394',
            FIRMWARE     => undef,
            SERIAL       => 'CNBW84P402',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW84P402,FN:JK54RBG,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI166E31',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                IPS          => {
                    IP => [
                        '128.93.22.233',
                    ],
                },
                UPTIME       => '(2821021) 7:50:10.21',
            },
            PAGECOUNTERS => {
                TOTAL      => '8880',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8515210',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8523142',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.233',
                        MAC              => '00:1f:29:16:6e:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '339332088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '497134',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW84P402,FN:JK54RBG,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI166E31',
                MEMORY       => '95',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW84P402',
                IPS          => {
                    IP => [
                        '128.93.22.233',
                    ],
                },
                UPTIME       => '(2821021) 7:50:10.21',
            },
            CARTRIDGES => {
                TONERBLACK       => '33',
            },
            PAGECOUNTERS => {
                BLACK      => '8880',
                COLOR      => '0',
                RECTOVERSO => '2115',
                TOTAL      => '8880',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8515210',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8523142',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.233',
                        MAC              => '00:1f:29:16:6e:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '339332088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '497134',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI7E0932',
            MAC          => '00:21:5a:7e:09:32',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI7E0932',
            MAC          => '00:21:5a:7e:09:32',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',
                NAME         => 'NPI7E0932',
            },
            PAGECOUNTERS => {
                TOTAL      => '30965',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7e:09:32',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2219679339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123773898',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI7E0932',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '6',
            },
            PAGECOUNTERS => {
                BLACK      => '30965',
                PRINTBLACK => '30965',
                COLOR      => '0',
                RECTOVERSO => '433',
                TOTAL      => '30965',
                PRINTTOTAL => '30965',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7e:09:32',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2219679339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123773898',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI8DDF43',
            MAC          => '00:21:5a:8d:df:43',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI8DDF43',
            MAC          => '00:21:5a:8d:df:43',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',
                NAME         => 'NPI8DDF43',
            },
            PAGECOUNTERS => {
                TOTAL      => '36105',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:df:43',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '200058917',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1869715',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI8DDF43',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '88',
            },
            PAGECOUNTERS => {
                BLACK      => '36105',
                PRINTBLACK => '36105',
                COLOR      => '0',
                RECTOVERSO => '8379',
                TOTAL      => '36105',
                PRINTTOTAL => '36105',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:df:43',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '200058917',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1869715',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI830993',
            MAC          => '00:23:7d:83:09:93',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI830993',
            MAC          => '00:23:7d:83:09:93',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI830993',
            },
            PAGECOUNTERS => {
                TOTAL      => '3837',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:09:93',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '683787528',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4718265',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI830993',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '32',
            },
            PAGECOUNTERS => {
                BLACK      => '3837',
                PRINTBLACK => '3837',
                COLOR      => '0',
                RECTOVERSO => '62',
                TOTAL      => '3837',
                PRINTTOTAL => '3837',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:09:93',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '683787528',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4718265',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI83E8D5',
            MAC          => '00:23:7d:83:e8:d5',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI83E8D5',
            MAC          => '00:23:7d:83:e8:d5',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI83E8D5',
            },
            PAGECOUNTERS => {
                TOTAL      => '11057',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:e8:d5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3240054009',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6629940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI83E8D5',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '45',
            },
            PAGECOUNTERS => {
                BLACK      => '11057',
                PRINTBLACK => '11057',
                COLOR      => '0',
                RECTOVERSO => '5297',
                TOTAL      => '11057',
                PRINTTOTAL => '11057',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:e8:d5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3240054009',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6629940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI886B5B',
            MAC          => '00:23:7d:88:6b:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI886B5B',
            MAC          => '00:23:7d:88:6b:5b',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI886B5B',
            },
            PAGECOUNTERS => {
                TOTAL      => '19402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '226525511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5925070',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI886B5B',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '56',
            },
            PAGECOUNTERS => {
                BLACK      => '19402',
                PRINTBLACK => '19402',
                COLOR      => '0',
                RECTOVERSO => '3761',
                TOTAL      => '19402',
                PRINTTOTAL => '19402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '226525511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5925070',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.06.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI886B5B',
            MAC          => '00:23:7d:88:6b:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI886B5B',
            MAC          => '00:23:7d:88:6b:5b',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI886B5B',
            },
            PAGECOUNTERS => {
                TOTAL      => '17861',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '561048360',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14426521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI886B5B',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '78',
            },
            PAGECOUNTERS => {
                BLACK      => '17861',
                PRINTBLACK => '17861',
                COLOR      => '0',
                RECTOVERSO => '3192',
                TOTAL      => '17861',
                PRINTTOTAL => '17861',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '561048360',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14426521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.07.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI80BDD9',
            MAC          => '1c:c1:de:80:bd:d9',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPI80BDD9',
            MAC          => '1c:c1:de:80:bd:d9',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPI80BDD9',
            },
            PAGECOUNTERS => {
                TOTAL      => '5696',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:80:bd:d9',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1574260753',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '44021940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPI80BDD9',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '46',
            },
            PAGECOUNTERS => {
                BLACK      => '5696',
                PRINTBLACK => '5696',
                COLOR      => '0',
                RECTOVERSO => '1843',
                TOTAL      => '5696',
                PRINTTOTAL => '5696',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:80:bd:d9',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1574260753',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '44021940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.08.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPICB3982',
            MAC          => '1c:c1:de:cb:39:82',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPICB3982',
            MAC          => '1c:c1:de:cb:39:82',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPICB3982',
            },
            PAGECOUNTERS => {
                TOTAL      => '26922',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:39:82',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '37368958',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '218905',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPICB3982',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '38',
            },
            PAGECOUNTERS => {
                BLACK      => '26922',
                PRINTBLACK => '26922',
                COLOR      => '0',
                RECTOVERSO => '6952',
                TOTAL      => '26922',
                PRINTTOTAL => '26922',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:39:82',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '37368958',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '218905',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.09.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIC08394',
            MAC          => '3c:4a:92:c0:83:94',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIC08394',
            MAC          => '3c:4a:92:c0:83:94',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPIC08394',
            },
            PAGECOUNTERS => {
                TOTAL      => '4047',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:c0:83:94',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1911576981',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48854545',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPIC08394',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '20',
            },
            PAGECOUNTERS => {
                BLACK      => '4047',
                PRINTBLACK => '4047',
                COLOR      => '0',
                RECTOVERSO => '50',
                TOTAL      => '4047',
                PRINTTOTAL => '4047',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:c0:83:94',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1911576981',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48854545',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.10.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPICBD8B1',
            MAC          => '1c:c1:de:cb:d8:b1',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPICBD8B1',
            MAC          => '1c:c1:de:cb:d8:b1',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPICBD8B1',
            },
            PAGECOUNTERS => {
                TOTAL      => '4944',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:d8:b1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2220813285',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '51880468',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPICBD8B1',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '40',
            },
            PAGECOUNTERS => {
                BLACK      => '4944',
                PRINTBLACK => '4944',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '4944',
                PRINTTOTAL => '4944',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:d8:b1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2220813285',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '51880468',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.11.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIB979A2',
            MAC          => '08:2e:5f:b9:79:a2',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIB979A2',
            MAC          => '08:2e:5f:b9:79:a2',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 07/12/2010',
                NAME         => 'NPIB979A2',
            },
            PAGECOUNTERS => {
                TOTAL      => '4339',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '08:2e:5f:b9:79:a2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '861281403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4972936',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPIB979A2',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '0',
            },
            PAGECOUNTERS => {
                BLACK      => '4339',
                PRINTBLACK => '4339',
                COLOR      => '0',
                RECTOVERSO => '498',
                TOTAL      => '4339',
                PRINTTOTAL => '4339',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '08:2e:5f:b9:79:a2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '861281403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4972936',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.12.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIC93D6D',
            MAC          => '1c:c1:de:c9:3d:6d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIC93D6D',
            MAC          => '1c:c1:de:c9:3d:6d',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPIC93D6D',
            },
            PAGECOUNTERS => {
                TOTAL      => '89242',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:c9:3d:6d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '20375229',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380785',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPIC93D6D',
                SERIAL       => '20040201',
            },
            CARTRIDGES => {
                TONERBLACK       => '68',
            },
            PAGECOUNTERS => {
                BLACK      => '89242',
                PRINTBLACK => '89242',
                COLOR      => '0',
                RECTOVERSO => '1789',
                TOTAL      => '89242',
                PRINTTOTAL => '89242',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:c9:3d:6d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '20375229',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380785',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.13.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'l1019a',
            MAC          => '00:25:b3:eb:ea:20',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'l1019a',
            MAC          => '00:25:b3:eb:ea:20',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'l1019a',
                MEMORY       => '128',
                IPS          => {
                    IP => [
                        '128.93.22.7',
                    ],
                },
                UPTIME       => '(20267234) 2 days, 8:17:52.34',
            },
            PAGECOUNTERS => {
                TOTAL      => '3515',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.7',
                        MAC              => '00:25:b3:eb:ea:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1045360896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '66590530',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'l1019a',
                MEMORY       => '128',
                SERIAL       => '20040201',
                IPS          => {
                    IP => [
                        '128.93.22.7',
                    ],
                },
                UPTIME       => '(20267234) 2 days, 8:17:52.34',
            },
            CARTRIDGES => {
                TONERBLACK       => '74',
            },
            PAGECOUNTERS => {
                BLACK      => '3515',
                PRINTBLACK => '3515',
                COLOR      => '0',
                RECTOVERSO => '0',
                TOTAL      => '3515',
                PRINTTOTAL => '3515',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:eb:ea:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1045360896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '66590530',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.14.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIEB8A8F',
            MAC          => '00:25:b3:eb:8a:8f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIEB8A8F',
            MAC          => '00:25:b3:eb:8a:8f',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPIEB8A8F',
                MEMORY       => '128',
                IPS          => {
                    IP => [
                        '128.93.22.238',
                    ],
                },
                UPTIME       => '(3967795) 11:01:17.95',
            },
            PAGECOUNTERS => {
                TOTAL      => '11344',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.238',
                        MAC              => '00:25:b3:eb:8a:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2831933549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92564533',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPIEB8A8F',
                MEMORY       => '128',
                SERIAL       => '20040201',
                IPS          => {
                    IP => [
                        '128.93.22.238',
                    ],
                },
                UPTIME       => '(3967795) 11:01:17.95',
            },
            CARTRIDGES => {
                TONERBLACK       => '66',
            },
            PAGECOUNTERS => {
                BLACK      => '11344',
                PRINTBLACK => '11344',
                COLOR      => '0',
                RECTOVERSO => '2389',
                TOTAL      => '11344',
                PRINTTOTAL => '11344',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:eb:8a:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2831933549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92564533',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.15.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'l1a220a',
            MAC          => '00:25:b3:eb:7a:c7',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'l1a220a',
            MAC          => '00:25:b3:eb:7a:c7',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'l1a220a',
                MEMORY       => '128',
                IPS          => {
                    IP => [
                        '128.93.22.113',
                    ],
                },
                UPTIME       => '(19326743) 2 days, 5:41:07.43',
            },
            PAGECOUNTERS => {
                TOTAL      => '22937',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.113',
                        MAC              => '00:25:b3:eb:7a:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2309963329',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '21666979',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'l1a220a',
                MEMORY       => '128',
                SERIAL       => '20040201',
                IPS          => {
                    IP => [
                        '128.93.22.113',
                    ],
                },
                UPTIME       => '(19326743) 2 days, 5:41:07.43',
            },
            CARTRIDGES => {
                TONERBLACK       => '2',
            },
            PAGECOUNTERS => {
                BLACK      => '22937',
                PRINTBLACK => '22937',
                COLOR      => '0',
                RECTOVERSO => '6832',
                TOTAL      => '22937',
                PRINTTOTAL => '22937',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:eb:7a:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2309963329',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '21666979',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.16.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIEB4B44',
            MAC          => '00:25:b3:eb:4b:44',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P2055dn',
            SNMPHOSTNAME => 'NPIEB4B44',
            MAC          => '00:25:b3:eb:4b:44',
            MODELSNMP    => 'Printer0611',
            FIRMWARE     => undef,
            SERIAL       => '20040201',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPIEB4B44',
                MEMORY       => '128',
                IPS          => {
                    IP => [
                        '128.93.22.57',
                    ],
                },
                UPTIME       => '(22020083) 2 days, 13:10:00.83',
            },
            PAGECOUNTERS => {
                TOTAL      => '4878',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.57',
                        MAC              => '00:25:b3:eb:4b:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3419623381',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65027106',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP LaserJet P2055dn',
                NAME         => 'NPIEB4B44',
                MEMORY       => '128',
                SERIAL       => '20040201',
                IPS          => {
                    IP => [
                        '128.93.22.57',
                    ],
                },
                UPTIME       => '(22020083) 2 days, 13:10:00.83',
            },
            CARTRIDGES => {
                TONERBLACK       => '60',
            },
            PAGECOUNTERS => {
                BLACK      => '4878',
                PRINTBLACK => '4878',
                COLOR      => '0',
                RECTOVERSO => '504',
                TOTAL      => '4878',
                PRINTTOTAL => '4878',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:eb:4b:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3419623381',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65027106',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI7A5E2D',
            MAC          => '00:21:5a:7a:5e:2d',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI7A5E2D',
            MAC          => '00:21:5a:7a:5e:2d',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNH1R06635',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI7A5E2D',
            },
            PAGECOUNTERS => {
                TOTAL      => '20979',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7a:5e:2d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '145086685',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2444081',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313441',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI7A5E2D',
                SERIAL       => 'CNH1R06635',
            },
            CARTRIDGES => {
                TONERBLACK       => '32',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '0',
                TOTAL      => '20979',
                PRINTTOTAL => '20949',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7a:5e:2d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '145086685',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2444081',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI91B509',
            MAC          => '00:17:08:91:b5:09',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI91B509',
            MAC          => '00:17:08:91:b5:09',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG38S',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI91B509',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.22.92',
                    ],
                },
                UPTIME       => '(22362085) 2 days, 14:07:00.85',
            },
            PAGECOUNTERS => {
                TOTAL      => '150',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.92',
                        MAC              => '00:17:08:91:b5:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4178582359',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115945591',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI91B509',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG38S',
                IPS          => {
                    IP => [
                        '128.93.22.92',
                    ],
                },
                UPTIME       => '(22362085) 2 days, 14:07:00.85',
            },
            CARTRIDGES => {
                TONERBLACK       => '98',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1',
                TOTAL      => '150',
                PRINTTOTAL => '150',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:08:91:b5:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4178582359',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115945591',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI947D4C',
            MAC          => '00:17:a4:94:7d:4c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI947D4C',
            MAC          => '00:17:a4:94:7d:4c',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DF0WL',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI947D4C',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.5.49',
                    ],
                },
                UPTIME       => '(21658724) 2 days, 12:09:47.24',
            },
            PAGECOUNTERS => {
                TOTAL      => '13322',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.5.49',
                        MAC              => '00:17:a4:94:7d:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3089015758',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75450885',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI947D4C',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DF0WL',
                IPS          => {
                    IP => [
                        '128.93.5.49',
                    ],
                },
                UPTIME       => '(21658724) 2 days, 12:09:47.24',
            },
            CARTRIDGES => {
                TONERBLACK       => '10',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1',
                TOTAL      => '13322',
                PRINTTOTAL => '13324',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:94:7d:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3089015758',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75450885',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'L0420a',
            MAC          => '00:17:a4:93:4d:9f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'L0420a',
            MAC          => '00:17:a4:93:4d:9f',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG39Q',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'L0420a',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.4.22',
                    ],
                },
                UPTIME       => '(37718618) 4 days, 8:46:26.18',
            },
            PAGECOUNTERS => {
                TOTAL      => '13193',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.4.22',
                        MAC              => '00:17:a4:93:4d:9f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2307684777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108781795',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'L0420a',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG39Q',
                IPS          => {
                    IP => [
                        '128.93.4.22',
                    ],
                },
                UPTIME       => '(37718618) 4 days, 8:46:26.18',
            },
            CARTRIDGES => {
                TONERBLACK       => '70',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '566',
                TOTAL      => '13193',
                PRINTTOTAL => '13193',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:4d:9f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2307684777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108781795',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l0500a',
            MAC          => '00:17:08:91:95:dd',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l0500a',
            MAC          => '00:17:08:91:95:dd',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG38L',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l0500a',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.22.198',
                    ],
                },
                UPTIME       => '(11522734) 1 day, 8:00:27.34',
            },
            PAGECOUNTERS => {
                TOTAL      => '15802',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.198',
                        MAC              => '00:17:08:91:95:dd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '496490610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7579572',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'l0500a',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG38L',
                IPS          => {
                    IP => [
                        '128.93.22.198',
                    ],
                },
                UPTIME       => '(11522734) 1 day, 8:00:27.34',
            },
            CARTRIDGES => {
                TONERBLACK       => '36',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '105',
                TOTAL      => '15802',
                PRINTTOTAL => '15807',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:08:91:95:dd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '496490610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7579572',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.06.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D69',
            MAC          => '00:17:a4:93:4d:69',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D69',
            MAC          => '00:17:a4:93:4d:69',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG3DP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D69',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.31.3',
                    ],
                },
                UPTIME       => '(29663349) 3 days, 10:23:53.49',
            },
            PAGECOUNTERS => {
                TOTAL      => '53058',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.31.3',
                        MAC              => '00:17:a4:93:4d:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2931305839',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92945383',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI934D69',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG3DP',
                IPS          => {
                    IP => [
                        '128.93.31.3',
                    ],
                },
                UPTIME       => '(29663349) 3 days, 10:23:53.49',
            },
            CARTRIDGES => {
                TONERBLACK       => '95',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1',
                TOTAL      => '53058',
                PRINTTOTAL => '53053',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:4d:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2931305839',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92945383',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.07.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D9C',
            MAC          => '00:17:a4:93:4d:9c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D9C',
            MAC          => '00:17:a4:93:4d:9c',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG37P',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D9C',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.17.16',
                    ],
                },
                UPTIME       => '(30521576) 3 days, 12:46:55.76',
            },
            PAGECOUNTERS => {
                TOTAL      => '130481',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.17.16',
                        MAC              => '00:17:a4:93:4d:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2225730103',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154536764',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI934D9C',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG37P',
                IPS          => {
                    IP => [
                        '128.93.17.16',
                    ],
                },
                UPTIME       => '(30521576) 3 days, 12:46:55.76',
            },
            CARTRIDGES => {
                TONERBLACK       => '41',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '21',
                TOTAL      => '130481',
                PRINTTOTAL => '130480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:4d:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2225730103',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154536764',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.08.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI917343',
            MAC          => '00:17:08:91:73:43',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI917343',
            MAC          => '00:17:08:91:73:43',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG1MH',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI917343',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.18.47',
                    ],
                },
                UPTIME       => '(33056147) 3 days, 19:49:21.47',
            },
            PAGECOUNTERS => {
                TOTAL      => '45068',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.18.47',
                        MAC              => '00:17:08:91:73:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4294835122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232767636',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI917343',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG1MH',
                IPS          => {
                    IP => [
                        '128.93.18.47',
                    ],
                },
                UPTIME       => '(33056147) 3 days, 19:49:21.47',
            },
            CARTRIDGES => {
                TONERBLACK       => '94',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '814',
                TOTAL      => '45068',
                PRINTTOTAL => '45077',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:08:91:73:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4294835122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232767636',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.09.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l1B220a',
            MAC          => '00:17:a4:93:df:9c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l1B220a',
            MAC          => '00:17:a4:93:df:9c',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG1LP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l1B220a',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.22.102',
                    ],
                },
                UPTIME       => '(31793654) 3 days, 16:18:56.54',
            },
            PAGECOUNTERS => {
                TOTAL      => '11075',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.102',
                        MAC              => '00:17:a4:93:df:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3954235628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118033695',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'l1B220a',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG1LP',
                IPS          => {
                    IP => [
                        '128.93.22.102',
                    ],
                },
                UPTIME       => '(31793654) 3 days, 16:18:56.54',
            },
            CARTRIDGES => {
                TONERBLACK       => '95',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '12',
                TOTAL      => '11075',
                PRINTTOTAL => '11083',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:df:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3954235628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118033695',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.10.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI824876',
            MAC          => '00:17:08:82:48:76',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI824876',
            MAC          => '00:17:08:82:48:76',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DF0XF',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI824876',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.9.35',
                    ],
                },
                UPTIME       => '(15263036) 1 day, 18:23:50.36',
            },
            PAGECOUNTERS => {
                TOTAL      => '17190',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.9.35',
                        MAC              => '00:17:08:82:48:76',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1478912108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2882335238',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI824876',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DF0XF',
                IPS          => {
                    IP => [
                        '128.93.9.35',
                    ],
                },
                UPTIME       => '(15263036) 1 day, 18:23:50.36',
            },
            CARTRIDGES => {
                TONERBLACK       => '77',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1',
                TOTAL      => '17190',
                PRINTTOTAL => '17204',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:08:82:48:76',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1478912108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2882335238',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.11.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D5B',
            MAC          => '00:17:a4:93:4d:5b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI934D5B',
            MAC          => '00:17:a4:93:4d:5b',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG394',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D5B',
                MEMORY       => '192',
                IPS          => {
                    IP => [
                        '128.93.22.13',
                    ],
                },
                UPTIME       => '(11824269) 1 day, 8:50:42.69',
            },
            PAGECOUNTERS => {
                TOTAL      => '100795',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.13',
                        MAC              => '00:17:a4:93:4d:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1379448828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '41043399',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI934D5B',
                MEMORY       => '192',
                SERIAL       => 'CNFW6DG394',
                IPS          => {
                    IP => [
                        '128.93.22.13',
                    ],
                },
                UPTIME       => '(11824269) 1 day, 8:50:42.69',
            },
            CARTRIDGES => {
                TONERBLACK       => '11',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '1',
                TOTAL      => '100795',
                PRINTTOTAL => '100796',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:4d:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1379448828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '41043399',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.12.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI939CBD',
            MAC          => '00:17:a4:93:a7:56',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'NPI939CBD',
            MAC          => '00:17:a4:93:a7:56',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG1NP',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60,CIDATE 03/04/2012',
                NAME         => 'NPI939CBD',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.22.111',
                    ],
                },
                UPTIME       => '(745416056) 86 days, 6:36:00.56',
            },
            PAGECOUNTERS => {
                TOTAL      => '65082',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.111',
                        MAC              => '00:17:a4:93:a7:56',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '507317169',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165546197',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'NPI939CBD',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG1NP',
                IPS          => {
                    IP => [
                        '128.93.22.111',
                    ],
                },
                UPTIME       => '(745416056) 86 days, 6:36:00.56',
            },
            CARTRIDGES => {
                TONERBLACK       => '88',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '22',
                TOTAL      => '65082',
                PRINTTOTAL => '65087',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:93:a7:56',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '507317169',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165546197',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.13.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l2427a',
            MAC          => '00:17:a4:94:a6:1f',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3005',
            SNMPHOSTNAME => 'l2427a',
            MAC          => '00:17:a4:94:a6:1f',
            MODELSNMP    => 'Printer0612',
            FIRMWARE     => undef,
            SERIAL       => 'CNFW6DG1M8',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l2427a',
                MEMORY       => '320',
                IPS          => {
                    IP => [
                        '128.93.22.132',
                    ],
                },
                UPTIME       => '(35620617) 4 days, 2:56:46.17',
            },
            PAGECOUNTERS => {
                TOTAL      => '5385',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.132',
                        MAC              => '00:17:a4:94:a6:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2818547819',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '302246316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => '0x0115513738313541',
                COMMENTS     => 'HP LaserJet P3005',
                NAME         => 'l2427a',
                MEMORY       => '320',
                SERIAL       => 'CNFW6DG1M8',
                IPS          => {
                    IP => [
                        '128.93.22.132',
                    ],
                },
                UPTIME       => '(35620617) 4 days, 2:56:46.17',
            },
            CARTRIDGES => {
                TONERBLACK       => '53',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '7',
                TOTAL      => '5385',
                PRINTTOTAL => '5388',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:17:a4:94:a6:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2818547819',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '302246316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3010.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3010 Series',
            SNMPHOSTNAME => 'NPI013B81',
            MAC          => '00:9c:02:01:3b:81',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3010 Series',
            SNMPHOSTNAME => 'NPI013B81',
            MAC          => '00:9c:02:01:3b:81',
            MODELSNMP    => 'Printer0402',
            FIRMWARE     => undef,
            SERIAL       => 'VNBQD3C0BF',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',
                NAME         => 'NPI013B81',
            },
            PAGECOUNTERS => {
                TOTAL      => '15265',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66753796',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1745120',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP LaserJet P3010 Series',
                NAME         => 'NPI013B81',
                SERIAL       => 'VNBQD3C0BF',
            },
            CARTRIDGES => {
                TONERBLACK       => '84',
            },
            PAGECOUNTERS => {
                BLACK      => '15265',
                RECTOVERSO => '74',
                TOTAL      => '15265',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66753796',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1745120',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3010.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3010 Series',
            SNMPHOSTNAME => 'NPI013B81',
            MAC          => '00:9c:02:01:3b:81',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P3010 Series',
            SNMPHOSTNAME => 'NPI013B81',
            MAC          => '00:9c:02:01:3b:81',
            MODELSNMP    => 'Printer0402',
            FIRMWARE     => undef,
            SERIAL       => 'VNBQD3C0BF',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',
                NAME         => 'NPI013B81',
            },
            PAGECOUNTERS => {
                TOTAL      => '6386',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '985600239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750126',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP LaserJet P3010 Series',
                NAME         => 'NPI013B81',
                SERIAL       => 'VNBQD3C0BF',
            },
            CARTRIDGES => {
                TONERBLACK       => '1',
            },
            PAGECOUNTERS => {
                BLACK      => '6386',
                RECTOVERSO => '772',
                TOTAL      => '6386',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '985600239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750126',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4014.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4014',
            SNMPHOSTNAME => 'NPIFFF0F2',
            MAC          => '18:a9:05:ff:f0:f2',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4014',
            SNMPHOSTNAME => 'NPIFFF0F2',
            MAC          => '18:a9:05:ff:f0:f2',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFX409800',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4014',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIFFF0F2',
                MEMORY       => '384',
                IPS          => {
                    IP => [
                        '10.75.13.175',
                    ],
                },
                UPTIME       => '(705273859) 81 days, 15:05:38.59',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '32',
            },
            PAGECOUNTERS => {
                TOTAL      => '151735',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.75.13.175',
                        MAC              => '18:a9:05:ff:f0:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1102701832',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142816478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4014',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIFFF0F2',
                MEMORY       => '384',
                SERIAL       => 'CNFX409800',
                IPS          => {
                    IP => [
                        '10.75.13.175',
                    ],
                },
                UPTIME       => '(705273859) 81 days, 15:05:38.59',
            },
            CARTRIDGES => {
                TONERBLACK       => '18',
                MAINTENANCEKIT   => '32',
            },
            PAGECOUNTERS => {
                TOTAL      => '151735',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.75.13.175',
                        MAC              => '18:a9:05:ff:f0:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1102701832',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142816478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.01.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'LJ30000000000000000000----------',
            MAC          => '00:21:5a:8f:ea:2b',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'LJ30000000000000000000----------',
            MAC          => '00:21:5a:8f:ea:2b',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFY417951',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'LJ30000000000000000000----------',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                TOTAL      => '27320',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8f:ea:2b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '42955297',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1263745',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'LJ30000000000000000000----------',
                SERIAL       => 'CNFY417951',
            },
            CARTRIDGES => {
                TONERBLACK       => '100',
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '26',
                TOTAL      => '27320',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8f:ea:2b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '42955297',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1263745',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.02.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI8D9896',
            MAC          => '00:21:5a:8d:98:96',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI8D9896',
            MAC          => '00:21:5a:8d:98:96',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFY409032',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'NPI8D9896',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '61',
            },
            PAGECOUNTERS => {
                TOTAL      => '86390',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:98:96',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '197354717',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10744976',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'NPI8D9896',
                SERIAL       => 'CNFY409032',
            },
            CARTRIDGES => {
                TONERBLACK       => '64',
                MAINTENANCEKIT   => '61',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '26',
                TOTAL      => '86390',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:98:96',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '197354717',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10744976',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.03.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI22C87C',
            MAC          => '00:1f:29:22:c8:7c',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI22C87C',
            MAC          => '00:1f:29:22:c8:7c',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFY213364',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35,CIDATE 09/18/2007',
                NAME         => 'NPI22C87C',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '79',
            },
            PAGECOUNTERS => {
                TOTAL      => '47319',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:22:c8:7c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '316207723',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11488728',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35,CIDATE 09/18/2007',
                NAME         => 'NPI22C87C',
                SERIAL       => 'CNFY213364',
            },
            CARTRIDGES => {
                TONERBLACK       => '34',
                MAINTENANCEKIT   => '79',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '52',
                TOTAL      => '47319',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:22:c8:7c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '316207723',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11488728',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.04.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI9706DE',
            MAC          => '00:21:5a:97:06:de',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPI9706DE',
            MAC          => '00:21:5a:97:06:de',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFY183496',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40,CIDATE 02/24/2009',
                NAME         => 'NPI9706DE',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '5',
            },
            PAGECOUNTERS => {
                TOTAL      => '212761',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:97:06:de',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '267130694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5406422',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40,CIDATE 02/24/2009',
                NAME         => 'NPI9706DE',
                SERIAL       => 'CNFY183496',
            },
            CARTRIDGES => {
                TONERBLACK       => '1',
                MAINTENANCEKIT   => '5',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '4',
                TOTAL      => '212761',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:97:06:de',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '267130694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5406422',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.05.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPIEADBFB',
            MAC          => '00:25:b3:ea:db:fb',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'HP LaserJet P4015',
            SNMPHOSTNAME => 'NPIEADBFB',
            MAC          => '00:25:b3:ea:db:fb',
            MODELSNMP    => 'Printer0386',
            FIRMWARE     => undef,
            SERIAL       => 'CNFY349204',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIEADBFB',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '0',
            },
            PAGECOUNTERS => {
                TOTAL      => '266350',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:ea:db:fb',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4240914294',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37809478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIEADBFB',
                SERIAL       => 'CNFY349204',
            },
            CARTRIDGES => {
                TONERBLACK       => '32',
                MAINTENANCEKIT   => '0',
            },
            PAGECOUNTERS => {
                RECTOVERSO => '2096',
                TOTAL      => '266350',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:ea:db:fb',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4240914294',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37809478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/OfficeJet_Pro_8600.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'Officejet Pro 8600 N911g',
            SNMPHOSTNAME => 'HP8C0C51',
            MAC          => 'ec:9a:74:8c:0c:51',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'Officejet Pro 8600 N911g',
            SNMPHOSTNAME => 'HP8C0C51',
            MAC          => 'ec:9a:74:8c:0c:51',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'Officejet Pro 8600 N911g',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP8C0C51',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'ec:9a:74:8c:0c:51',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '22514039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4313921',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => 'Officejet Pro 8600 N911g',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP8C0C51',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'ec:9a:74:8c:0c:51',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '22514039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4313921',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/OfficeJet_Pro_K5400.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'Officejet Pro K5400',
            SNMPHOSTNAME => 'HP560332',
            MAC          => '00:21:5a:56:03:32',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'PRINTER',
            DESCRIPTION  => 'Officejet Pro K5400',
            SNMPHOSTNAME => 'HP560332',
            MAC          => '00:21:5a:56:03:32',
            MODELSNMP    => 'Printer0285',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP560332',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '290',
                CARTRIDGEMAGENTA => '20',
                CARTRIDGEYELLOW  => '6',
            },
            PAGECOUNTERS => {
                TOTAL      => '10947',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:56:03:32',
                        IFLASTCHANGE     => '(18259) 0:03:02.59',
                        IFINOCTETS       => '201446672',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2340353',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'PRINTER',
                MODEL        => undef,
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP560332',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '290',
                CARTRIDGEMAGENTA => '20',
                CARTRIDGEYELLOW  => '6',
            },
            PAGECOUNTERS => {
                TOTAL      => '10947',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:56:03:32',
                        IFLASTCHANGE     => '(18259) 0:03:02.59',
                        IFINOCTETS       => '201446672',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2340353',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J4899B.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',
            MAC          => '00:18:fe:aa:a9:80',
            MODEL        => 'ProCurve 2650 (J4899B)',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',
            MAC          => '00:18:fe:aa:a9:80',
            MODEL        => 'ProCurve 2650 (J4899B)',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'NETWORKING',
                MODEL        => 'ProCurve 2650 (J4899B)',
                COMMENTS     => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',
                LOCATION     => 'GN1 NORD',
                SERIAL       => 'CN638SD146',
                MAC          => '00:18:fe:aa:a9:80',
                UPTIME       => '(326711768) 37 days, 19:31:57.68',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325708419) 37 days, 16:44:44.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '123393802',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1178060406',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:1f:af:11:ad:05',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307) 0:00:03.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310) 0:00:03.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(313) 0:00:03.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(233221046) 26 days, 23:50:10.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4162377762',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897936844',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:27:08',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(309118271) 35 days, 18:39:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189910214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2494689870',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:d2:e1:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326114651) 37 days, 17:52:26.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '711865552',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1398064590',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:87',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320003709) 37 days, 0:53:57.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2137496082',
                        IFINERRORS       => '8',
                        IFOUTOCTETS      => '1773076632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '9',
                        IFDESCR          => '9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266412504) 30 days, 20:02:05.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '298804026',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2951433643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f1:a9:19',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '10',
                        IFDESCR          => '10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326055436) 37 days, 17:42:34.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1922613693',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3623722166',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b8:ca:3a:9e:0e:ba',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '11',
                        IFDESCR          => '11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(330) 0:00:03.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '12',
                        IFDESCR          => '12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326090196) 37 days, 17:48:21.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1851063579',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608324661',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:90:8f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '13',
                        IFDESCR          => '13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267562859) 30 days, 23:13:48.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62240934',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '156103471',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '14',
                        IFDESCR          => '14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325838476) 37 days, 17:06:24.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1467418408',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3058761840',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:e4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '15',
                        IFDESCR          => '15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325742991) 37 days, 16:50:29.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1133183098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '337480167',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:1d:9e:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '16',
                        IFDESCR          => '16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(342) 0:00:03.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '17',
                        IFDESCR          => '17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345) 0:00:03.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '18',
                        IFDESCR          => '18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ee',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324003639) 37 days, 12:00:36.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '620306769',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1818680410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '19',
                        IFDESCR          => '19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326076719) 37 days, 17:46:07.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2099298807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3614765732',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:89:90',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '20',
                        IFDESCR          => '20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(352) 0:00:03.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '21',
                        IFDESCR          => '21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320728619) 37 days, 2:54:46.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1408247717',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3537276662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '22',
                        IFDESCR          => '22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(357) 0:00:03.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '23',
                        IFDESCR          => '23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(957) 0:00:09.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8380738',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2602806252',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:29:2b:70:ee',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '24',
                        IFDESCR          => '24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(363) 0:00:03.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '25',
                        IFDESCR          => '25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326687479) 37 days, 19:27:54.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '504181874',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1396148995',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:20:66:0e:41:10',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '26',
                        IFDESCR          => '26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(367) 0:00:03.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '27',
                        IFDESCR          => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(370) 0:00:03.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '28',
                        IFDESCR          => '28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682) 0:00:06.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '133988139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2866297811',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f0:b8:ab',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '29',
                        IFDESCR          => '29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(375) 0:00:03.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '30',
                        IFDESCR          => '30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326034919) 37 days, 17:39:09.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1474386320',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2662357185',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:22:19:1a:f0:bf',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '31',
                        IFDESCR          => '31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(136795971) 15 days, 19:59:19.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '68207546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3624571169',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f2:17:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '32',
                        IFDESCR          => '32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(382) 0:00:03.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '33',
                        IFDESCR          => '33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385) 0:00:03.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '34',
                        IFDESCR          => '34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387) 0:00:03.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '35',
                        IFDESCR          => '35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(390) 0:00:03.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '36',
                        IFDESCR          => '36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(392) 0:00:03.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '37',
                        IFDESCR          => '37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395) 0:00:03.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '38',
                        IFDESCR          => '38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397) 0:00:03.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '39',
                        IFDESCR          => '39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '40',
                        IFDESCR          => '40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(402) 0:00:04.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '41',
                        IFDESCR          => '41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325675884) 37 days, 16:39:18.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '657077543',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1846663321',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:61',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '42',
                        IFDESCR          => '42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407) 0:00:04.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '43',
                        IFDESCR          => '43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320674639) 37 days, 2:45:46.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993249638',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1189581752',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '44',
                        IFDESCR          => '44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(412) 0:00:04.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '45',
                        IFDESCR          => '45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(306732846) 35 days, 12:02:08.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1401591598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1719040774',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:48',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '46',
                        IFDESCR          => '46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(418) 0:00:04.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '47',
                        IFDESCR          => '47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(420) 0:00:04.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '48',
                        IFDESCR          => '48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422) 0:00:04.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '49',
                        IFDESCR          => '49',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(960) 0:00:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '496630524',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1792848570',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:b7:91:c9',
                                    '00:00:74:b7:3c:bb',
                                    '00:00:74:b7:3e:9b',
                                    '00:00:74:cc:5e:5c',
                                    '00:00:74:d2:9b:3a',
                                    '00:00:74:ee:c7:ee',
                                    '00:00:74:ee:c8:3f',
                                    '00:00:74:ee:d3:7d',
                                    '00:00:74:ee:d3:51',
                                    '00:00:74:f1:1c:3b',
                                    '00:00:74:f2:36:4c',
                                    '00:00:85:8b:a7:3d',
                                    '00:00:85:95:5f:85',
                                    '00:00:85:dc:86:7a',
                                    '00:00:85:dc:04:91',
                                    '00:00:85:de:04:93',
                                    '00:00:aa:fa:18:d1',
                                    '00:01:96:38:a8:40',
                                    '00:0a:b0:03:36:9d',
                                    '00:64:40:0b:65:82',
                                    '00:0d:54:a9:3f:06',
                                    '00:0d:54:f7:85:c6',
                                    '00:0d:54:f7:85:18',
                                    '00:0d:54:f7:86:0b',
                                    '00:0d:54:f7:86:34',
                                    '00:0d:54:f7:88:20',
                                    '00:0d:54:3c:db:72',
                                    '00:88:65:a9:62:0c',
                                    '00:88:65:c0:73:f6',
                                    '00:88:65:35:2e:68',
                                    '00:88:65:3a:bf:72',
                                    '00:0e:6a:d1:51:ae',
                                    '00:0e:6a:d1:56:0f',
                                    '00:0e:6a:d3:18:72',
                                    '00:0e:6a:d5:b9:b2',
                                    '00:0e:6a:d5:b9:e5',
                                    '00:0e:6a:d5:b9:54',
                                    '00:0e:6a:d5:ba:53',
                                    '00:0e:6a:d5:bb:ef',
                                    '00:0e:6a:d5:bc:13',
                                    '00:90:27:dc:55:2d',
                                    '00:0f:cb:a6:ee:dd',
                                    '00:0f:cb:a6:ee:f8',
                                    '00:10:18:96:9e:76',
                                    '00:10:18:9d:82:30',
                                    '00:11:24:bf:c9:63',
                                    '00:12:79:e0:fb:4c',
                                    '00:12:a9:07:0d:bd',
                                    '00:12:a9:07:0d:c9',
                                    '00:12:a9:07:0d:cb',
                                    '00:12:a9:07:0d:cf',
                                    '00:12:a9:07:0d:de',
                                    '00:12:f2:7e:89:40',
                                    '00:bd:3a:ee:2a:aa',
                                    '00:13:72:12:52:92',
                                    '00:13:02:6b:a5:a5',
                                    '00:13:02:7d:a1:ab',
                                    '00:13:ce:f1:a3:6d',
                                    '00:c6:10:c5:1e:cc',
                                    '00:c6:10:36:59:63',
                                    '00:14:7c:46:65:be',
                                    '00:14:7c:46:66:86',
                                    '00:14:7c:46:66:0f',
                                    '00:14:7c:46:66:63',
                                    '00:14:f1:b6:ee:00',
                                    '00:14:38:a1:6f:15',
                                    '00:14:38:e5:de:fd',
                                    '00:15:99:5d:fa:14',
                                    '00:15:c5:5f:c7:0e',
                                    '00:15:17:48:78:8e',
                                    '00:db:df:21:e1:25',
                                    '00:16:b6:a0:4d:1b',
                                    '00:16:3e:01:00:01',
                                    '00:16:3e:74:af:0a',
                                    '00:16:3e:77:23:ab',
                                    '00:16:3e:11:9f:23',
                                    '00:16:3e:d0:24:62',
                                    '00:16:3e:1f:98:f8',
                                    '00:16:3e:25:14:e1',
                                    '00:16:3e:44:9f:e7',
                                    '00:16:3e:53:3f:51',
                                    '00:16:3e:5e:eb:74',
                                    '00:16:44:84:17:25',
                                    '00:e0:d8:16:96:a7',
                                    '00:17:c4:99:66:a7',
                                    '00:17:c4:23:03:09',
                                    '00:17:c4:41:83:f5',
                                    '00:17:08:89:8d:fe',
                                    '00:18:8b:6e:42:0a',
                                    '00:18:8b:71:dd:45',
                                    '00:18:8b:71:dd:52',
                                    '00:18:8b:71:df:1d',
                                    '00:18:8b:cf:87:6a',
                                    '00:18:8b:17:4f:8a',
                                    '00:18:8b:f7:b5:a3',
                                    '00:18:8b:f7:dd:4c',
                                    '00:18:f3:ed:a2:46',
                                    '00:18:fe:a3:2e:d5',
                                    '00:18:fe:a8:28:00',
                                    '00:18:fe:aa:67:00',
                                    '00:18:fe:aa:68:80',
                                    '00:18:fe:aa:69:00',
                                    '00:18:fe:aa:69:80',
                                    '00:18:fe:aa:72:00',
                                    '00:18:fe:aa:77:00',
                                    '00:18:fe:aa:77:80',
                                    '00:18:fe:aa:79:80',
                                    '00:18:fe:aa:a8:80',
                                    '00:18:fe:aa:a9:00',
                                    '00:18:fe:aa:c2:80',
                                    '00:18:fe:aa:c8:80',
                                    '00:18:fe:aa:d8:00',
                                    '00:18:fe:aa:d8:4e',
                                    '00:18:fe:aa:e8:80',
                                    '00:18:fe:aa:e9:00',
                                    '00:18:fe:aa:27:00',
                                    '00:18:fe:aa:49:80',
                                    '00:18:fe:aa:51:00',
                                    '00:18:fe:aa:59:00',
                                    '00:18:fe:aa:09:00',
                                    '00:19:b9:f0:a2:43',
                                    '00:19:b9:05:b8:d8',
                                    '00:19:bb:99:c9:c0',
                                    '00:19:bb:99:2a:c0',
                                    '00:19:e3:06:f1:59',
                                    '00:1a:73:5e:aa:83',
                                    '00:1a:80:d6:fe:65',
                                    '00:1a:a0:de:41:69',
                                    '00:1a:a0:e0:fb:73',
                                    '00:1a:a0:e9:01:33',
                                    '00:1a:a0:e9:78:66',
                                    '00:1a:a0:e9:04:98',
                                    '00:1a:a0:eb:0f:1e',
                                    '00:1a:a0:3e:29:0b',
                                    '00:1a:4b:10:d8:76',
                                    '00:1a:4b:28:fa:49',
                                    '00:1b:77:3e:71:77',
                                    '00:1b:78:18:cc:80',
                                    '00:1b:8b:a3:f9:b8',
                                    '00:1b:b1:af:e0:d8',
                                    '00:1b:b1:4e:5c:9e',
                                    '00:1b:21:2c:7b:6d',
                                    '00:1b:3f:77:2a:00',
                                    '00:1c:b3:7c:67:bf',
                                    '00:1c:bf:9d:90:e4',
                                    '00:1c:2e:90:16:00',
                                    '00:1c:2e:bb:89:00',
                                    '00:1d:a1:ef:e3:f6',
                                    '00:1d:a1:ef:e4:26',
                                    '00:1d:a1:ef:e5:78',
                                    '00:1d:a2:80:b9:30',
                                    '00:1d:b3:06:47:c0',
                                    '00:1d:b3:58:8f:00',
                                    '00:1d:b3:58:cf:80',
                                    '00:1d:b3:59:b1:80',
                                    '00:1d:b3:59:f1:00',
                                    '00:1d:b3:60:bb:00',
                                    '00:1d:b3:61:71:00',
                                    '00:1d:e5:55:16:80',
                                    '00:1d:e5:55:17:ae',
                                    '00:1d:09:65:e0:37',
                                    '00:1d:09:2c:f3:07',
                                    '00:1e:68:9b:3e:d3',
                                    '00:1e:0b:12:9b:42',
                                    '00:1e:0b:17:21:01',
                                    '00:1e:0b:18:74:4f',
                                    '00:1e:7a:bd:de:fa',
                                    '00:1e:8f:da:53:d1',
                                    '00:1e:c2:b2:9a:80',
                                    '00:1e:c9:64:17:e9',
                                    '00:1e:c9:64:4e:12',
                                    '00:1e:c9:7f:94:72',
                                    '00:1e:c9:7f:19:9d',
                                    '00:1e:c9:7f:19:c8',
                                    '00:1e:c9:40:76:11',
                                    '00:1e:c9:45:14:08',
                                    '00:1e:c9:48:b4:36',
                                    '00:1e:c9:4a:b7:ac',
                                    '00:1e:c9:63:b4:d7',
                                    '00:1e:c9:63:bc:38',
                                    '00:1e:c9:63:e9:c0',
                                    '00:1e:4f:f4:e5:fe',
                                    '00:1e:4f:f4:e6:22',
                                    '00:1e:4f:35:db:a8',
                                    '00:1e:4f:35:db:aa',
                                    '00:1e:52:ac:bf:43',
                                    '00:1f:e1:89:8e:6b',
                                    '00:1f:28:4f:ee:00',
                                    '00:1f:29:1b:ab:21',
                                    '00:1f:29:1e:7f:2a',
                                    '00:1f:29:31:8f:c8',
                                    '00:1f:3c:2e:40:5e',
                                    '00:1f:5b:b7:74:e2',
                                    '00:20:85:fb:43:4e',
                                    '00:21:00:30:5b:33',
                                    '00:21:6a:8b:22:7a',
                                    '00:21:6a:c1:7e:84',
                                    '00:21:70:0d:2a:c3',
                                    '00:21:70:9f:b3:f2',
                                    '00:21:70:1c:12:47',
                                    '00:21:70:46:e1:07',
                                    '00:21:70:46:f2:09',
                                    '00:21:70:46:f5:33',
                                    '00:21:70:46:f9:26',
                                    '00:21:70:46:fc:9a',
                                    '00:21:9b:6e:69:6f',
                                    '00:21:9b:71:aa:ee',
                                    '00:21:9b:79:44:c8',
                                    '00:21:9b:79:47:91',
                                    '00:21:9b:79:4a:19',
                                    '00:21:9b:5b:5b:66',
                                    '00:21:b7:6c:79:c1',
                                    '00:21:b7:6c:49:bf',
                                    '00:21:b7:70:ac:f7',
                                    '00:21:b7:96:a7:46',
                                    '00:21:b7:a2:60:1f',
                                    '00:21:b7:aa:dc:fa',
                                    '00:21:b7:12:ff:37',
                                    '00:21:b7:ba:7d:72',
                                    '00:21:b7:02:25:ff',
                                    '00:21:b7:02:61:1d',
                                    '00:21:b7:cc:2d:de',
                                    '00:21:b7:dc:20:0d',
                                    '00:21:b7:dc:20:13',
                                    '00:21:b7:fa:44:0e',
                                    '00:21:b7:fc:c8:a4',
                                    '00:21:b7:22:9e:df',
                                    '00:21:b7:2a:89:37',
                                    '00:21:b7:2c:be:98',
                                    '00:21:b7:42:a3:26',
                                    '00:21:b7:5c:7c:d7',
                                    '00:21:b7:5c:c2:51',
                                    '00:21:b7:5c:02:90',
                                    '00:21:5a:90:d5:99',
                                    '00:21:5c:73:77:25',
                                    '00:21:5d:be:fe:94',
                                    '00:21:5d:c9:bd:64',
                                    '00:21:5d:1c:4a:52',
                                    '00:21:5d:2d:91:ba',
                                    '00:21:63:c4:6f:da',
                                    '00:22:19:8b:f7:c9',
                                    '00:22:19:11:c7:13',
                                    '00:22:19:cc:f5:2c',
                                    '00:22:19:23:d5:65',
                                    '00:22:19:23:d5:97',
                                    '00:22:19:31:b7:ad',
                                    '00:22:19:31:b7:36',
                                    '00:22:19:31:b8:be',
                                    '00:22:19:31:b8:cf',
                                    '00:22:fa:13:86:06',
                                    '00:22:fa:4a:ec:70',
                                    '00:22:fb:6d:aa:08',
                                    '00:22:fb:5f:22:1c',
                                    '00:22:41:f9:f4:38',
                                    '00:22:41:31:4a:77',
                                    '00:23:6c:91:7b:bf',
                                    '00:23:6c:9a:ea:9b',
                                    '00:23:6c:d3:a3:8c',
                                    '00:23:7d:6e:ff:53',
                                    '00:23:7d:81:ba:1c',
                                    '00:23:7d:87:2e:11',
                                    '00:23:7d:89:44:e3',
                                    '00:23:7d:8e:7f:9f',
                                    '00:23:ae:71:bf:7c',
                                    '00:23:ae:71:bf:1c',
                                    '00:23:ae:71:bf:2a',
                                    '00:23:ae:71:c0:7b',
                                    '00:23:ae:71:c0:37',
                                    '00:23:ae:71:c3:96',
                                    '00:23:ae:71:c3:07',
                                    '00:23:ae:74:6b:2c',
                                    '00:23:ae:74:72:a7',
                                    '00:23:ae:74:7b:b2',
                                    '00:23:ae:74:7c:17',
                                    '00:23:ae:74:7f:e0',
                                    '00:23:ae:74:7f:f0',
                                    '00:23:ae:74:7f:fd',
                                    '00:23:ae:74:80:a0',
                                    '00:23:ae:74:82:5f',
                                    '00:23:ae:74:aa:0f',
                                    '00:23:ae:79:fb:c5',
                                    '00:23:ae:7a:02:3c',
                                    '00:23:ae:7c:33:9c',
                                    '00:23:ae:ad:29:63',
                                    '00:23:ae:ad:32:87',
                                    '00:23:ae:f8:62:4e',
                                    '00:23:ae:fb:fb:80',
                                    '00:23:ae:fe:17:74',
                                    '00:23:12:11:2b:46',
                                    '00:23:12:22:19:6b',
                                    '00:23:12:08:18:65',
                                    '00:23:32:b4:01:5e',
                                    '00:23:4d:5c:6f:0b',
                                    '00:24:d2:69:76:91',
                                    '00:24:d2:df:af:82',
                                    '00:24:d6:2d:d8:6c',
                                    '00:24:d6:37:73:0c',
                                    '00:24:d7:71:7f:d4',
                                    '00:24:d7:71:63:14',
                                    '00:24:d7:76:f8:40',
                                    '00:24:e8:0c:22:2f',
                                    '00:24:e8:0c:23:a9',
                                    '00:24:e8:0c:23:ba',
                                    '00:24:e8:aa:e3:3e',
                                    '00:24:e8:ab:9b:0e',
                                    '00:24:e8:1b:cc:70',
                                    '00:24:e8:1b:d3:45',
                                    '00:24:e8:1d:9d:6a',
                                    '00:24:e8:1d:9e:e6',
                                    '00:24:e8:1d:9f:fc',
                                    '00:24:e8:36:20:15',
                                    '00:24:e8:46:d9:55',
                                    '00:24:e8:46:da:27',
                                    '00:24:e8:48:e5:97',
                                    '00:24:e8:48:e5:9f',
                                    '00:24:21:6d:5f:20',
                                    '00:25:00:ef:60:94',
                                    '00:25:00:42:a0:83',
                                    '00:25:64:b8:35:b6',
                                    '00:25:64:b8:35:d4',
                                    '00:25:64:e8:8c:be',
                                    '00:25:64:e8:8d:9f',
                                    '00:25:64:e8:8f:b3',
                                    '00:25:64:e8:90:4f',
                                    '00:25:64:e8:91:e7',
                                    '00:25:64:e8:91:33',
                                    '00:25:b3:f1:68:bd',
                                    '00:25:45:22:89:34',
                                    '00:25:45:22:a4:22',
                                    '00:25:4b:8b:46:e6',
                                    '00:25:4b:fc:95:cf',
                                    '00:26:0b:62:87:8c',
                                    '00:26:0b:62:87:ae',
                                    '00:26:0b:62:87:ee',
                                    '00:26:0b:62:88:14',
                                    '00:26:0b:62:88:06',
                                    '00:26:0b:62:88:08',
                                    '00:26:0b:62:8a:9a',
                                    '00:26:0b:62:8a:da',
                                    '00:26:0b:62:8b:fa',
                                    '00:26:0b:62:8b:1a',
                                    '00:26:0b:62:8b:34',
                                    '00:26:0b:62:8c:82',
                                    '00:26:0b:62:8c:a0',
                                    '00:26:0b:62:8c:a4',
                                    '00:26:0b:62:8c:c8',
                                    '00:26:0b:62:8d:78',
                                    '00:26:0b:62:8d:98',
                                    '00:26:0b:62:8d:c2',
                                    '00:26:0b:62:8d:4e',
                                    '00:26:0b:62:b1:80',
                                    '00:26:0b:62:50:7e',
                                    '00:26:0b:62:50:4e',
                                    '00:26:73:0e:e8:17',
                                    '00:26:73:12:13:52',
                                    '00:26:73:13:dc:e7',
                                    '00:26:73:13:ec:5e',
                                    '00:26:73:1e:01:98',
                                    '00:26:73:27:27:05',
                                    '00:26:73:29:4a:8e',
                                    '00:26:73:2b:79:86',
                                    '00:26:73:2b:79:9f',
                                    '00:26:73:2b:a6:a2',
                                    '00:26:73:31:74:b8',
                                    '00:26:73:31:74:cb',
                                    '00:26:73:31:74:e3',
                                    '00:26:73:33:7a:bf',
                                    '00:26:73:45:e9:76',
                                    '00:26:73:4a:0d:e4',
                                    '00:26:73:4a:22:fd',
                                    '00:26:b0:da:16:ba',
                                    '00:26:b6:3e:b5:e5',
                                    '00:26:b9:85:dd:7e',
                                    '00:26:bb:13:1d:b1',
                                    '00:26:bb:1d:83:4c',
                                    '00:26:bb:03:b5:bd',
                                    '00:26:bb:04:06:07',
                                    '00:26:bb:06:51:16',
                                    '00:26:cb:10:0c:50',
                                    '00:26:cb:10:40:30',
                                    '00:26:cb:10:41:50',
                                    '00:26:cb:10:42:80',
                                    '00:26:cb:11:1a:80',
                                    '00:26:cb:11:05:00',
                                    '00:26:cb:b8:bf:f0',
                                    '00:26:cb:1b:c0:60',
                                    '00:26:cb:1d:7a:f0',
                                    '00:26:cb:1d:7c:e0',
                                    '00:26:cb:1d:7d:c0',
                                    '00:26:cb:1d:92:30',
                                    '00:26:cb:1d:97:00',
                                    '00:26:cb:1d:9d:20',
                                    '00:26:cb:1d:a3:70',
                                    '00:26:cb:1d:ab:30',
                                    '00:26:08:e1:6b:31',
                                    '00:26:08:e4:35:06',
                                    '00:26:5e:70:43:c6',
                                    '00:27:10:e0:5e:48',
                                    '00:04:00:16:38:9f',
                                    '00:04:00:f6:22:6c',
                                    '00:30:c1:c2:49:45',
                                    '00:30:c1:02:60:bd',
                                    '00:05:1e:0d:38:23',
                                    '00:37:6d:da:f6:3a',
                                    '00:08:14:00:37:aa',
                                    '00:50:b6:5b:11:ef',
                                    '00:50:c2:d0:ff:51',
                                    '00:50:56:b2:3a:42',
                                    '00:60:9f:80:00:59',
                                    '00:60:9f:80:06:14',
                                    '68:9c:5e:2c:12:08',
                                    '68:a3:c4:43:57:70',
                                    '68:a8:6d:0b:74:e2',
                                    '68:a8:6d:23:a6:b0',
                                    '68:a8:6d:23:b5:b2',
                                    '68:a8:6d:4a:c5:b2',
                                    '68:5d:43:57:d9:9c',
                                    '6c:71:d9:6b:02:0a',
                                    '6c:71:d9:70:5f:32',
                                    '6c:71:d9:7f:fb:36',
                                    '6c:3e:6d:74:05:1e',
                                    '70:71:bc:b9:30:15',
                                    '70:aa:b2:76:bd:b6',
                                    '70:f3:95:e7:7c:65',
                                    '70:f9:27:c7:a9:a3',
                                    '70:56:81:93:45:c9',
                                    '70:56:81:ab:56:db',
                                    '74:de:2b:2b:c1:69',
                                    '74:e1:b6:7d:d2:cb',
                                    '74:f0:6d:0a:1e:cd',
                                    '74:f0:6d:51:c4:34',
                                    '74:2f:68:8c:32:8d',
                                    '74:2f:68:ed:13:f8',
                                    '74:2f:68:2e:09:19',
                                    '74:2f:68:53:0a:13',
                                    '74:45:8a:67:6d:ad',
                                    '74:45:8a:53:cf:6d',
                                    '0c:84:dc:9d:f6:4f',
                                    '0c:ee:e6:d5:ce:b4',
                                    '78:92:9c:95:38:a6',
                                    '78:92:9c:22:1e:e4',
                                    '78:92:9c:3d:6b:ba',
                                    '78:ac:c0:77:93:00',
                                    '78:ac:c0:8f:63:b9',
                                    '78:ca:39:ae:e4:58',
                                    '78:e4:00:0b:f5:4a',
                                    '78:e4:00:f4:ee:16',
                                    '78:1f:db:ac:93:66',
                                    '78:2b:cb:85:ff:81',
                                    '78:2b:cb:85:ff:9c',
                                    '78:2b:cb:86:19:d9',
                                    '78:2b:cb:86:1b:11',
                                    '78:2b:cb:86:08:26',
                                    '78:2b:cb:86:57:0b',
                                    '78:2b:cb:98:c4:88',
                                    '78:2b:cb:98:c5:e9',
                                    '78:2b:cb:98:c6:ae',
                                    '78:2b:cb:98:c6:e9',
                                    '78:2b:cb:98:c6:fd',
                                    '78:2b:cb:98:c7:80',
                                    '78:2b:cb:98:e9:31',
                                    '78:2b:cb:98:24:86',
                                    '78:2b:cb:9a:15:14',
                                    '78:2b:cb:9a:18:8c',
                                    '78:2b:cb:9e:86:a7',
                                    '78:2b:cb:9e:95:9d',
                                    '78:2b:cb:9e:cb:3c',
                                    '7c:d1:c3:97:e5:c4',
                                    '7c:d1:c3:9b:96:be',
                                    '7c:e9:d3:7e:cf:09',
                                    '7c:e9:d3:8c:07:d4',
                                    '84:7a:88:81:81:b1',
                                    '84:8f:69:d7:1b:2c',
                                    '84:a6:c8:da:1d:cb',
                                    '84:fc:fe:cd:52:43',
                                    '84:2b:2b:96:67:09',
                                    '84:2b:2b:96:73:ec',
                                    '84:2b:2b:9a:69:e0',
                                    '84:2b:2b:9b:d3:e1',
                                    '84:2b:2b:aa:4c:be',
                                    '84:2b:2b:bb:34:bb',
                                    '84:2b:2b:bb:4e:74',
                                    '84:2b:2b:bb:4e:25',
                                    '84:2b:2b:60:0e:cb',
                                    '84:3a:4b:7d:02:38',
                                    '84:4b:f5:16:e2:99',
                                    '84:4b:f5:29:b0:bb',
                                    '88:c6:63:69:1c:36',
                                    '88:c6:63:f3:55:cc',
                                    '88:1f:a1:0f:74:46',
                                    '88:1f:a1:18:dd:1a',
                                    '88:30:8a:25:a8:88',
                                    '88:53:95:d3:23:4e',
                                    '88:53:d4:27:c9:ff',
                                    '8c:2d:aa:45:3e:c7',
                                    '90:84:0d:9a:91:8f',
                                    '90:84:0d:53:b7:8b',
                                    '90:b1:1c:7d:98:0d',
                                    '90:b1:1c:7d:98:bb',
                                    '90:b1:1c:7d:98:5b',
                                    '90:b1:1c:7d:9b:8a',
                                    '90:b1:1c:7e:0d:9a',
                                    '90:b1:1c:7e:0d:aa',
                                    '90:b1:1c:82:f9:9f',
                                    '90:b1:1c:a5:18:cf',
                                    '90:b1:1c:a5:1e:37',
                                    '90:b1:1c:4f:24:5d',
                                    '90:18:7c:1b:c3:e8',
                                    '90:18:7c:37:c2:1f',
                                    '90:18:7c:5f:7d:c3',
                                    '90:21:55:63:5a:5b',
                                    '90:27:e4:fe:d9:4e',
                                    '90:4c:e5:8a:67:07',
                                    '90:4c:e5:1b:9c:05',
                                    '94:71:ac:f9:d0:8a',
                                    '98:0c:82:8c:8d:a9',
                                    '98:0c:82:56:2c:50',
                                    '98:d6:bb:cb:58:e8',
                                    '98:d6:f7:5d:fe:8b',
                                    '98:fe:94:06:52:96',
                                    '98:fe:94:3f:b9:36',
                                    '98:fe:94:41:ce:64',
                                    '98:fe:94:49:ea:04',
                                    '98:4b:e1:39:9e:a9',
                                    '9c:04:eb:1d:8f:33',
                                    '9c:2a:70:23:55:cd',
                                    '9c:2a:70:25:52:d9',
                                    '10:68:3f:85:31:4e',
                                    '10:68:3f:e7:e2:0c',
                                    '10:0b:a9:50:e2:f0',
                                    '10:0b:a9:52:72:94',
                                    '10:0b:a9:52:72:c0',
                                    '10:93:e9:0e:a4:78',
                                    '10:93:e9:04:7d:3c',
                                    '10:9a:dd:27:8d:8b',
                                    '10:9a:dd:44:a9:fe',
                                    '10:dd:b1:ee:a7:93',
                                    '10:1c:0c:28:32:91',
                                    '10:40:f3:7c:30:6a',
                                    '10:40:f3:86:62:02',
                                    '10:40:f3:98:36:56',
                                    '10:40:f3:f0:20:78',
                                    'a0:6c:ec:6f:ea:16',
                                    'a0:82:1f:6c:55:99',
                                    'a0:f3:c1:09:1c:30',
                                    'a0:f4:50:ef:81:cf',
                                    'a0:42:3f:01:97:7d',
                                    'a4:67:06:ba:8c:55',
                                    'a4:67:06:54:b2:27',
                                    'a4:ba:db:f6:ab:b8',
                                    'a4:ba:db:f6:ad:cf',
                                    'a4:ba:db:f6:ae:86',
                                    'a4:ba:db:f6:ae:9a',
                                    'a4:ba:db:f6:ae:b6',
                                    'a4:ba:db:f6:ae:f2',
                                    'a4:ba:db:f6:ae:40',
                                    'a4:ba:db:f6:af:ea',
                                    'a4:ba:db:f6:b0:82',
                                    'a4:ba:db:f6:b1:3d',
                                    'a4:ba:db:f7:bb:ce',
                                    'a4:ba:db:f7:bc:78',
                                    'a4:ba:db:f8:0f:54',
                                    'a4:ba:db:f8:10:ec',
                                    'a4:ba:db:f8:12:a8',
                                    'a4:ba:db:f8:13:e4',
                                    'a4:d1:d2:0a:da:a0',
                                    'a4:17:31:1a:fc:df',
                                    'a4:17:31:09:9c:a7',
                                    'a8:20:66:30:f6:5e',
                                    'a8:20:66:4f:de:c7',
                                    'ac:72:89:77:a9:4d',
                                    'ac:3c:0b:de:42:e0',
                                    'b0:65:bd:0b:a3:92',
                                    'b0:65:bd:72:07:1b',
                                    'b0:65:bd:54:d3:71',
                                    'b4:74:9f:ae:f1:1f',
                                    'b4:99:ba:d7:54:30',
                                    'b4:f0:ab:7e:bb:14',
                                    'b4:07:f9:d5:f8:d6',
                                    'b8:76:3f:26:05:a9',
                                    'b8:78:2e:84:9b:56',
                                    'b8:8d:12:00:2a:d6',
                                    'b8:8d:12:13:7d:80',
                                    'b8:8d:12:14:c3:26',
                                    'b8:8d:12:1b:df:e0',
                                    'b8:8d:12:1b:e0:62',
                                    'b8:8d:12:1b:e1:f0',
                                    'b8:8d:12:39:81:52',
                                    'b8:8d:12:39:56:7e',
                                    'b8:8d:12:08:0f:e0',
                                    'b8:8d:12:55:95:da',
                                    'b8:ac:6f:81:b0:c8',
                                    'b8:ac:6f:0d:4a:d9',
                                    'b8:ac:6f:91:b2:e8',
                                    'b8:ac:6f:91:b4:c3',
                                    'b8:ac:6f:91:b4:c5',
                                    'b8:ac:6f:92:91:9f',
                                    'b8:ac:6f:95:b9:4f',
                                    'b8:ac:6f:a1:a4:04',
                                    'b8:ac:6f:44:5c:b3',
                                    'b8:ca:3a:8c:71:cd',
                                    'b8:ca:3a:9e:65:2b',
                                    'b8:ca:3a:9e:0e:ab',
                                    'b8:ca:3a:9e:0e:b3',
                                    'b8:ca:3a:9e:0e:d6',
                                    'b8:ca:3a:9e:0e:04',
                                    'b8:ca:3a:9e:0e:52',
                                    'b8:ca:3a:9e:0e:53',
                                    'b8:ca:3a:9e:13:f7',
                                    'b8:ca:3a:9e:ce:6d',
                                    'b8:ca:3a:9e:44:3d',
                                    'b8:ca:3a:9e:46:89',
                                    'b8:ca:3a:9e:46:41',
                                    'b8:ca:3a:9e:49:ad',
                                    'b8:ca:3a:9e:49:4e',
                                    'b8:ca:3a:9e:4a:10',
                                    'b8:ca:3a:d3:6f:8f',
                                    'bc:72:b1:78:df:3a',
                                    'bc:cf:cc:ca:d7:a6',
                                    'bc:30:5b:e0:17:78',
                                    'bc:30:5b:e0:17:9f',
                                    'bc:30:5b:e6:a6:28',
                                    'bc:3b:af:0e:e5:a1',
                                    'c0:65:99:8d:d6:03',
                                    'c0:65:99:8e:4f:0b',
                                    'c0:18:85:bb:e1:e3',
                                    'c4:0a:cb:65:9c:30',
                                    'c4:0a:cb:65:b7:60',
                                    'c4:0a:cb:65:f0:20',
                                    'c4:0a:cb:a4:1c:c0',
                                    'c4:0a:cb:b2:2d:d0',
                                    'c4:0a:cb:24:6f:f0',
                                    'c4:0a:cb:24:70:00',
                                    'c4:0a:cb:24:73:80',
                                    'c4:0a:cb:24:43:10',
                                    'c4:0a:cb:24:47:80',
                                    'c4:0a:cb:24:47:60',
                                    'c4:0a:cb:24:4b:90',
                                    'c4:0a:cb:24:54:80',
                                    'c4:0a:cb:2c:0d:30',
                                    'c4:0a:cb:2c:03:c0',
                                    'c4:0a:cb:2c:2a:e0',
                                    'c4:0a:cb:2c:09:c0',
                                    'c4:64:13:0f:8b:03',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:96',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:c2:ce:31',
                                    'c4:64:13:2b:f2:25',
                                    'c4:6a:b7:6b:ee:fe',
                                    'c4:85:08:31:52:6d',
                                    'c4:17:fe:a6:ed:b7',
                                    'c4:46:19:1b:8f:48',
                                    '14:8f:c6:be:89:49',
                                    '14:10:9f:d0:cb:3b',
                                    '14:10:9f:dd:04:cf',
                                    '14:10:9f:e5:1c:4b',
                                    '14:10:9f:e9:eb:e2',
                                    '14:10:9f:f2:ac:e0',
                                    '14:10:9f:f4:0d:1e',
                                    '14:fe:b5:f0:9f:57',
                                    '14:fe:b5:f0:9f:5e',
                                    '14:5a:05:c9:ab:98',
                                    '14:5a:05:21:20:b6',
                                    'c8:bc:c8:d9:63:1a',
                                    'c8:bc:c8:eb:e0:ea',
                                    'c8:e0:eb:e1:ee:02',
                                    'c8:f7:33:a6:6b:e3',
                                    'c8:19:f7:ee:b7:95',
                                    'c8:2a:14:3e:9a:19',
                                    'cc:78:5f:68:90:6e',
                                    'cc:af:78:cf:c1:49',
                                    'cc:52:af:5e:a7:dc',
                                    'd0:b3:3f:68:0c:80',
                                    'd0:b3:3f:68:10:d6',
                                    'd0:b3:3f:7e:e3:7a',
                                    'd0:b3:3f:9a:c2:69',
                                    'd0:b3:3f:a6:b5:70',
                                    'd0:b3:3f:f5:ba:88',
                                    'd0:df:9a:5b:b3:55',
                                    'd0:23:db:31:af:58',
                                    'd0:57:85:57:c0:99',
                                    'd4:85:64:14:42:10',
                                    'd4:85:64:3c:ac:e5',
                                    'd4:9a:20:72:73:0d',
                                    'd4:9a:20:57:16:45',
                                    'd4:a0:2a:10:38:c0',
                                    'd4:ae:52:ba:a2:64',
                                    'd4:ae:52:ba:a2:6d',
                                    'd4:ae:52:bc:06:c0',
                                    'd4:be:d9:8f:25:83',
                                    'd4:be:d9:91:ef:17',
                                    'd4:be:d9:91:ef:36',
                                    'd4:be:d9:91:f1:6a',
                                    'd4:be:d9:91:25:c4',
                                    'd4:be:d9:91:25:fb',
                                    'd4:be:d9:91:25:fd',
                                    'd4:be:d9:91:26:01',
                                    'd4:be:d9:91:26:85',
                                    'd4:be:d9:91:26:91',
                                    'd4:be:d9:91:26:9f',
                                    'd4:be:d9:91:26:f2',
                                    'd4:be:d9:91:26:fe',
                                    'd4:be:d9:91:26:22',
                                    'd4:be:d9:91:26:04',
                                    'd4:be:d9:91:26:2d',
                                    'd4:be:d9:91:27:02',
                                    'd4:be:d9:92:00:fd',
                                    'd4:be:d9:92:02:87',
                                    'd4:be:d9:92:02:95',
                                    'd4:be:d9:97:d4:24',
                                    'd4:be:d9:18:19:98',
                                    'd4:be:d9:18:1b:5a',
                                    'd8:9e:3f:b8:4a:0a',
                                    'd8:9e:3f:36:3d:db',
                                    'd8:24:bd:d5:1c:b0',
                                    'd8:24:bd:d5:2d:c0',
                                    'd8:24:bd:d5:2e:50',
                                    'd8:24:bd:d5:33:f0',
                                    'd8:24:bd:d5:40:a0',
                                    'd8:24:bd:d5:40:50',
                                    'd8:24:bd:d5:41:80',
                                    'd8:24:bd:d5:44:d0',
                                    'd8:24:bd:d5:4a:c0',
                                    'd8:24:bd:d5:4c:10',
                                    'd8:24:bd:d5:4c:20',
                                    'd8:24:bd:d5:4f:e0',
                                    'd8:24:bd:d5:50:30',
                                    'd8:24:bd:d5:51:b0',
                                    'd8:24:bd:d5:52:c0',
                                    'd8:24:bd:d5:55:50',
                                    'd8:24:bd:d5:58:40',
                                    'd8:24:bd:d5:5f:50',
                                    'd8:24:bd:d5:60:b0',
                                    'd8:24:bd:d5:63:60',
                                    'd8:24:bd:e8:d0:b0',
                                    'd8:24:bd:e8:d4:10',
                                    'd8:24:bd:e8:e0:e0',
                                    'd8:24:bd:e8:f2:60',
                                    'd8:24:bd:e8:f5:60',
                                    'd8:24:bd:e8:f7:a0',
                                    'd8:24:bd:e8:f9:70',
                                    'd8:24:bd:e9:0a:00',
                                    'd8:24:bd:e9:0b:70',
                                    'd8:24:bd:e9:0d:30',
                                    'd8:24:bd:e9:11:50',
                                    'd8:24:bd:e9:14:b0',
                                    'd8:24:bd:e9:18:a0',
                                    'd8:24:bd:e9:f5:80',
                                    'd8:24:bd:e9:f5:b0',
                                    'd8:30:62:c4:da:ec',
                                    'd8:30:62:5e:1c:19',
                                    'd8:30:62:61:b9:18',
                                    'd8:57:ef:37:44:bb',
                                    'dc:85:de:0f:d2:25',
                                    'dc:85:de:25:37:12',
                                    'e0:b9:a5:ac:e6:6b',
                                    'e0:f8:47:10:85:1a',
                                    'e0:f8:47:a4:84:96',
                                    'e0:f8:47:19:58:32',
                                    'e0:f8:47:40:f9:de',
                                    'e0:f8:47:5f:8f:0a',
                                    'e4:ce:8f:0c:a2:96',
                                    'e4:ce:8f:0f:7c:c8',
                                    'e4:ce:8f:a7:c3:33',
                                    'e4:ce:8f:b8:af:50',
                                    'e4:ce:8f:20:49:5a',
                                    'e4:ce:8f:36:81:40',
                                    'e4:ce:8f:36:60:0c',
                                    'e4:ce:8f:3c:b3:b6',
                                    'e4:d5:3d:68:e0:02',
                                    'e4:d5:3d:96:42:3a',
                                    'e8:99:c4:b6:37:20',
                                    'e8:cb:a1:ff:5a:9d',
                                    'e8:39:df:95:9d:22',
                                    'e8:06:88:a4:22:6f',
                                    'ec:85:2f:a5:dc:13',
                                    'ec:89:f5:60:fa:e2',
                                    'ec:35:86:5f:04:a8',
                                    'ec:55:f9:36:17:22',
                                    '18:00:2d:98:e2:a8',
                                    '18:03:73:0a:88:55',
                                    '18:03:73:0a:20:57',
                                    '18:03:73:0b:57:7b',
                                    '18:03:73:b2:be:86',
                                    '18:03:73:bb:68:8f',
                                    '18:03:73:bb:6a:6c',
                                    '18:03:73:bb:6a:39',
                                    '18:03:73:bb:6b:a1',
                                    '18:03:73:bb:6b:ff',
                                    '18:03:73:bb:6b:36',
                                    '18:03:73:bb:6c:85',
                                    '18:03:73:bb:6c:9d',
                                    '18:03:73:bb:6c:b1',
                                    '18:03:73:bb:6c:c9',
                                    '18:03:73:bb:6e:c2',
                                    '18:03:73:bb:54:78',
                                    '18:03:73:cd:8c:a1',
                                    '18:03:73:cd:1b:14',
                                    '18:03:73:ce:2e:25',
                                    '18:03:73:18:e4:bb',
                                    '18:03:73:18:ec:a2',
                                    '18:03:73:18:ef:2a',
                                    '18:03:73:18:f5:57',
                                    '18:03:73:18:f6:ea',
                                    '18:03:73:18:fb:35',
                                    '18:03:73:19:46:0d',
                                    '18:03:73:3d:45:00',
                                    '18:03:73:46:87:5e',
                                    '18:03:73:09:65:56',
                                    '18:03:73:09:d0:a2',
                                    '18:03:73:09:d3:63',
                                    '18:03:73:09:31:ac',
                                    '18:03:73:09:32:88',
                                    '18:3f:47:54:e4:2c',
                                    '18:46:17:e7:4b:ea',
                                    'f0:6b:ca:1b:25:d4',
                                    'f0:b4:79:14:db:4e',
                                    'f0:b4:79:1d:7b:ad',
                                    'f0:cb:a1:6b:66:18',
                                    'f0:5a:09:e1:f0:49',
                                    'f0:62:81:75:ca:00',
                                    'f4:ce:46:33:ed:e2',
                                    'f4:ce:46:33:3a:01',
                                    'f4:ce:46:34:f5:44',
                                    'f4:ce:46:34:26:cf',
                                    'f4:ce:46:42:03:84',
                                    'f4:ce:46:43:e2:e4',
                                    'f4:ce:46:4c:20:7b',
                                    'f4:f1:5a:0c:75:af',
                                    'f4:f1:5a:92:61:1a',
                                    'f4:f1:5a:bd:41:76',
                                    'f4:f1:5a:c4:88:86',
                                    'f8:0c:f3:1b:ee:c9',
                                    'f8:a4:5f:17:bd:d6',
                                    'f8:1e:df:8b:7b:b8',
                                    'f8:1e:df:9a:fc:67',
                                    'f8:1e:df:9c:0c:43',
                                    'f8:1e:df:ad:af:1a',
                                    'f8:1e:df:dc:cb:28',
                                    'f8:1e:df:dc:da:84',
                                    'f8:1e:df:e5:f9:32',
                                    'f8:1e:df:e9:e5:b7',
                                    'f8:1e:df:ed:c7:48',
                                    '1c:65:9d:76:63:5f',
                                    '1c:b0:94:a3:4b:ea',
                                    '20:64:32:89:4c:4c',
                                    '20:10:7a:93:e3:e4',
                                    '20:10:7a:43:a8:46',
                                    '20:c9:d0:7e:a4:f7',
                                    '20:c9:d0:87:f6:77',
                                    '20:c9:d0:c2:96:3d',
                                    '20:c9:d0:c3:a2:f5',
                                    '20:c9:d0:d5:2a:6b',
                                    '20:c9:d0:d9:b6:85',
                                    '20:c9:d0:da:b1:01',
                                    '20:c9:d0:de:87:47',
                                    '20:c9:d0:e1:3f:7d',
                                    '20:c9:d0:42:c5:63',
                                    '20:c9:d0:49:16:05',
                                    '24:77:03:bb:f0:50',
                                    '24:77:03:13:1f:b8',
                                    '24:77:03:c1:ac:14',
                                    '24:77:03:15:41:a0',
                                    '24:77:03:23:c1:18',
                                    '24:77:03:2c:75:68',
                                    '24:77:03:2c:85:d8',
                                    '24:be:05:ed:96:ec',
                                    '24:fd:52:79:06:ef',
                                    '04:0c:ce:88:1b:23',
                                    '04:0c:ce:d8:a3:a2',
                                    '04:e5:36:40:91:fa',
                                    '04:f7:e4:77:b8:bd',
                                    '04:1e:64:08:e2:f7',
                                    '04:46:65:87:9a:a1',
                                    '04:54:53:a1:da:3c',
                                    '28:6a:ba:c8:45:28',
                                    '28:94:0f:db:59:1d',
                                    '28:cf:da:de:63:52',
                                    '28:cf:da:e7:ed:34',
                                    '28:cf:da:e7:4e:94',
                                    '28:cf:da:3d:93:d2',
                                    '28:cf:e9:65:17:cf',
                                    '28:cf:e9:13:4d:57',
                                    '28:cf:e9:15:25:6b',
                                    '28:cf:e9:55:b4:1d',
                                    '28:cf:e9:5c:1a:4f',
                                    '28:e0:2c:02:b8:f7',
                                    '28:37:37:19:5f:40',
                                    '28:37:37:1c:2e:3e',
                                    '2c:41:38:9a:b7:43',
                                    '30:85:a9:07:fa:4b',
                                    '30:f7:c5:eb:49:a7',
                                    '34:15:9e:8a:d8:c9',
                                    '34:15:9e:91:2f:cc',
                                    '34:51:c9:c6:a6:55',
                                    '38:aa:3c:ef:c1:1c',
                                    '38:60:77:be:eb:0b',
                                    '3c:07:54:0f:f0:bb',
                                    '3c:07:54:23:69:6a',
                                    '40:6c:8f:3b:66:a7',
                                    '40:b3:95:8d:19:cc',
                                    '40:b3:95:e7:9e:c3',
                                    '40:b3:95:4d:8e:c1',
                                    '40:f3:08:22:19:2a',
                                    '40:fc:89:8f:61:63',
                                    '40:25:c2:c9:5d:04',
                                    '40:30:04:4b:a3:ff',
                                    '44:6d:57:2a:bb:d6',
                                    '44:1e:a1:7a:43:c0',
                                    '44:2a:60:a4:4d:e0',
                                    '48:5d:60:f9:18:29',
                                    '48:60:bc:95:df:6b',
                                    '48:60:bc:b1:75:76',
                                    '4c:80:93:3b:21:6c',
                                    '4c:8b:ef:a8:82:51',
                                    '4c:8d:79:e3:46:e2',
                                    '4c:8d:79:e6:cb:8a',
                                    '4c:8d:79:f2:47:f6',
                                    '4c:0f:6e:d9:d8:14',
                                    '4c:b1:99:c9:43:1c',
                                    '4c:ed:de:75:a0:29',
                                    '4c:ed:de:a3:ec:23',
                                    '08:00:27:3d:ca:12',
                                    '08:00:37:87:9a:1a',
                                    '08:00:37:2a:22:7a',
                                    '08:70:45:2a:5e:1a',
                                    '08:11:96:97:74:b4',
                                    '08:ed:b9:ba:81:f9',
                                    '08:ed:b9:06:34:2d',
                                    '08:ed:b9:3d:00:5c',
                                    '08:ed:b9:48:10:69',
                                    '08:ed:b9:4c:52:8b',
                                    '08:3e:8e:85:c8:65',
                                    '08:3e:8e:4b:dc:0b',
                                    '50:01:bb:cf:83:23',
                                    '50:63:13:c3:9e:07',
                                    '54:26:96:cf:53:1b',
                                    '5c:96:9d:89:d9:b9',
                                    '5c:ac:4c:16:01:7a',
                                    '5c:f9:dd:d6:35:d9',
                                    '5c:f9:dd:d6:36:0b',
                                    '5c:26:0a:70:51:c1',
                                    '5c:26:0a:81:07:6d',
                                    '5c:26:0a:81:07:77',
                                    '5c:26:0a:20:85:1a',
                                    '60:c5:47:8d:c6:ea',
                                    '60:c5:47:96:82:60',
                                    '60:d8:19:a7:0c:c2',
                                    '60:d8:19:58:fc:43',
                                    '60:fb:42:f8:fd:1c',
                                    '60:21:c0:12:21:9f',
                                    '60:33:4b:0e:00:81',
                                    '60:33:4b:1c:6d:af',
                                    '60:36:dd:8b:7f:c7',
                                    '60:36:dd:a5:dc:50',
                                    '60:36:dd:08:e9:7c',
                                    'd4:be:d9:91:26:5c',
                                    '24:fd:52:49:0e:5c',
                                    '5c:96:9d:7c:91:95',
                                    '00:24:36:e8:d2:76',
                                    '68:a8:6d:34:8f:c4',
                                    '60:36:dd:94:3e:00',
                                    '00:21:70:9f:b3:50',
                                    '70:73:cb:10:07:3c',
                                    '24:77:03:65:c2:50',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '50',
                        IFDESCR          => '50',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424) 0:00:04.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5672) 0:00:56.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5693) 0:00:56.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3868) 0:00:38.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3889) 0:00:38.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3908) 0:00:39.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3926) 0:00:39.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3948) 0:00:39.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3966) 0:00:39.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(930) 0:00:09.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5667) 0:00:56.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3985) 0:00:39.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4006) 0:00:40.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4025) 0:00:40.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4043) 0:00:40.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4066) 0:00:40.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4085) 0:00:40.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4143) 0:00:41.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4738) 0:00:47.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4162) 0:00:41.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4183) 0:00:41.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4202) 0:00:42.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5713) 0:00:57.13',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4757) 0:00:47.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4780) 0:00:47.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4799) 0:00:47.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4220) 0:00:42.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4818) 0:00:48.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5733) 0:00:57.33',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4261) 0:00:42.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4279) 0:00:42.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4301) 0:00:43.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4320) 0:00:43.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4338) 0:00:43.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4360) 0:00:43.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4379) 0:00:43.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4398) 0:00:43.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4419) 0:00:44.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4438) 0:00:44.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4457) 0:00:44.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4497) 0:00:44.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '114',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4840) 0:00:48.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '115',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4516) 0:00:45.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '118',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4860) 0:00:48.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '119',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4879) 0:00:48.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '120',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4901) 0:00:49.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '122',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4538) 0:00:45.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '123',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4920) 0:00:49.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '125',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '126',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '127',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '128',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '129',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4938) 0:00:49.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '130',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5646) 0:00:56.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '131',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5736) 0:00:57.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '133',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4960) 0:00:49.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4979) 0:00:49.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4998) 0:00:49.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5020) 0:00:50.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5039) 0:00:50.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4696) 0:00:46.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4577) 0:00:45.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4599) 0:00:45.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5058) 0:00:50.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5082) 0:00:50.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '150',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5101) 0:00:51.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '151',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5120) 0:00:51.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '154',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5142) 0:00:51.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '156',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5161) 0:00:51.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '158',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5181) 0:00:51.81',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '160',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5203) 0:00:52.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '162',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5222) 0:00:52.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '163',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5242) 0:00:52.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '164',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5263) 0:00:52.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5282) 0:00:52.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '184',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5737) 0:00:57.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '188',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5301) 0:00:53.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '196',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5324) 0:00:53.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '198',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5343) 0:00:53.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '256',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5362) 0:00:53.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '260',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '262',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4719) 0:00:47.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '263',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5384) 0:00:53.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '264',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5403) 0:00:54.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '266',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5422) 0:00:54.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '270',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5444) 0:00:54.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '272',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5463) 0:00:54.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259336383) 30 days, 0:22:43.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '302',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '306',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '312',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5482) 0:00:54.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '315',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5504) 0:00:55.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '316',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5523) 0:00:55.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '317',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5543) 0:00:55.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '362',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4637) 0:00:46.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '363',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4659) 0:00:46.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '364',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '662',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4677) 0:00:46.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '668',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5565) 0:00:55.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '672',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5585) 0:00:55.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '676',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5604) 0:00:56.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '677',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '908',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5626) 0:00:56.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4158',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'NETWORKING',
                MODEL        => 'ProCurve 2650 (J4899B)',
                COMMENTS     => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',
                LOCATION     => 'GN1 NORD',
                SERIAL       => 'CN638SD146',
                MAC          => '00:18:fe:aa:a9:80',
                UPTIME       => '(326711768) 37 days, 19:31:57.68',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325708419) 37 days, 16:44:44.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '123393802',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1178060406',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:1f:af:11:ad:05',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307) 0:00:03.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310) 0:00:03.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(313) 0:00:03.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(233221046) 26 days, 23:50:10.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4162377762',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897936844',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:27:08',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(309118271) 35 days, 18:39:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189910214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2494689870',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:d2:e1:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326114651) 37 days, 17:52:26.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '711865552',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1398064590',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:87',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320003709) 37 days, 0:53:57.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2137496082',
                        IFINERRORS       => '8',
                        IFOUTOCTETS      => '1773076632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '9',
                        IFDESCR          => '9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266412504) 30 days, 20:02:05.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '298804026',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2951433643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f1:a9:19',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '10',
                        IFDESCR          => '10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326055436) 37 days, 17:42:34.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1922613693',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3623722166',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b8:ca:3a:9e:0e:ba',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '11',
                        IFDESCR          => '11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(330) 0:00:03.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '12',
                        IFDESCR          => '12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326090196) 37 days, 17:48:21.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1851063579',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608324661',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:90:8f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '13',
                        IFDESCR          => '13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267562859) 30 days, 23:13:48.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62240934',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '156103471',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '14',
                        IFDESCR          => '14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325838476) 37 days, 17:06:24.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1467418408',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3058761840',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:e4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '15',
                        IFDESCR          => '15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325742991) 37 days, 16:50:29.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1133183098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '337480167',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:1d:9e:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '16',
                        IFDESCR          => '16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(342) 0:00:03.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '17',
                        IFDESCR          => '17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345) 0:00:03.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '18',
                        IFDESCR          => '18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ee',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324003639) 37 days, 12:00:36.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '620306769',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1818680410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '19',
                        IFDESCR          => '19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326076719) 37 days, 17:46:07.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2099298807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3614765732',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:89:90',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '20',
                        IFDESCR          => '20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(352) 0:00:03.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '21',
                        IFDESCR          => '21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320728619) 37 days, 2:54:46.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1408247717',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3537276662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '22',
                        IFDESCR          => '22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(357) 0:00:03.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '23',
                        IFDESCR          => '23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(957) 0:00:09.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8380738',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2602806252',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:29:2b:70:ee',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '24',
                        IFDESCR          => '24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(363) 0:00:03.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '25',
                        IFDESCR          => '25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326687479) 37 days, 19:27:54.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '504181874',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1396148995',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:20:66:0e:41:10',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '26',
                        IFDESCR          => '26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(367) 0:00:03.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '27',
                        IFDESCR          => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(370) 0:00:03.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '28',
                        IFDESCR          => '28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682) 0:00:06.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '133988139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2866297811',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f0:b8:ab',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '29',
                        IFDESCR          => '29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(375) 0:00:03.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '30',
                        IFDESCR          => '30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326034919) 37 days, 17:39:09.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1474386320',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2662357185',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:22:19:1a:f0:bf',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '31',
                        IFDESCR          => '31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(136795971) 15 days, 19:59:19.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '68207546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3624571169',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f2:17:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '32',
                        IFDESCR          => '32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(382) 0:00:03.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '33',
                        IFDESCR          => '33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385) 0:00:03.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '34',
                        IFDESCR          => '34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387) 0:00:03.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '35',
                        IFDESCR          => '35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(390) 0:00:03.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '36',
                        IFDESCR          => '36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(392) 0:00:03.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '37',
                        IFDESCR          => '37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395) 0:00:03.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '38',
                        IFDESCR          => '38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397) 0:00:03.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '39',
                        IFDESCR          => '39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '40',
                        IFDESCR          => '40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(402) 0:00:04.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '41',
                        IFDESCR          => '41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325675884) 37 days, 16:39:18.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '657077543',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1846663321',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:61',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '42',
                        IFDESCR          => '42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407) 0:00:04.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '43',
                        IFDESCR          => '43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320674639) 37 days, 2:45:46.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993249638',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1189581752',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '44',
                        IFDESCR          => '44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(412) 0:00:04.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '45',
                        IFDESCR          => '45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(306732846) 35 days, 12:02:08.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1401591598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1719040774',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:48',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '46',
                        IFDESCR          => '46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(418) 0:00:04.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '47',
                        IFDESCR          => '47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(420) 0:00:04.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '48',
                        IFDESCR          => '48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422) 0:00:04.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '49',
                        IFDESCR          => '49',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(960) 0:00:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '496630524',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1792848570',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:b7:91:c9',
                                    '00:00:74:b7:3c:bb',
                                    '00:00:74:b7:3e:9b',
                                    '00:00:74:cc:5e:5c',
                                    '00:00:74:d2:9b:3a',
                                    '00:00:74:ee:c7:ee',
                                    '00:00:74:ee:c8:3f',
                                    '00:00:74:ee:d3:7d',
                                    '00:00:74:ee:d3:51',
                                    '00:00:74:f1:1c:3b',
                                    '00:00:74:f2:36:4c',
                                    '00:00:85:8b:a7:3d',
                                    '00:00:85:95:5f:85',
                                    '00:00:85:dc:86:7a',
                                    '00:00:85:dc:04:91',
                                    '00:00:85:de:04:93',
                                    '00:00:aa:fa:18:d1',
                                    '00:01:96:38:a8:40',
                                    '00:0a:b0:03:36:9d',
                                    '00:64:40:0b:65:82',
                                    '00:0d:54:a9:3f:06',
                                    '00:0d:54:f7:85:c6',
                                    '00:0d:54:f7:85:18',
                                    '00:0d:54:f7:86:0b',
                                    '00:0d:54:f7:86:34',
                                    '00:0d:54:f7:88:20',
                                    '00:0d:54:3c:db:72',
                                    '00:88:65:a9:62:0c',
                                    '00:88:65:c0:73:f6',
                                    '00:88:65:35:2e:68',
                                    '00:88:65:3a:bf:72',
                                    '00:0e:6a:d1:51:ae',
                                    '00:0e:6a:d1:56:0f',
                                    '00:0e:6a:d3:18:72',
                                    '00:0e:6a:d5:b9:b2',
                                    '00:0e:6a:d5:b9:e5',
                                    '00:0e:6a:d5:b9:54',
                                    '00:0e:6a:d5:ba:53',
                                    '00:0e:6a:d5:bb:ef',
                                    '00:0e:6a:d5:bc:13',
                                    '00:90:27:dc:55:2d',
                                    '00:0f:cb:a6:ee:dd',
                                    '00:0f:cb:a6:ee:f8',
                                    '00:10:18:96:9e:76',
                                    '00:10:18:9d:82:30',
                                    '00:11:24:bf:c9:63',
                                    '00:12:79:e0:fb:4c',
                                    '00:12:a9:07:0d:bd',
                                    '00:12:a9:07:0d:c9',
                                    '00:12:a9:07:0d:cb',
                                    '00:12:a9:07:0d:cf',
                                    '00:12:a9:07:0d:de',
                                    '00:12:f2:7e:89:40',
                                    '00:bd:3a:ee:2a:aa',
                                    '00:13:72:12:52:92',
                                    '00:13:02:6b:a5:a5',
                                    '00:13:02:7d:a1:ab',
                                    '00:13:ce:f1:a3:6d',
                                    '00:c6:10:c5:1e:cc',
                                    '00:c6:10:36:59:63',
                                    '00:14:7c:46:65:be',
                                    '00:14:7c:46:66:86',
                                    '00:14:7c:46:66:0f',
                                    '00:14:7c:46:66:63',
                                    '00:14:f1:b6:ee:00',
                                    '00:14:38:a1:6f:15',
                                    '00:14:38:e5:de:fd',
                                    '00:15:99:5d:fa:14',
                                    '00:15:c5:5f:c7:0e',
                                    '00:15:17:48:78:8e',
                                    '00:db:df:21:e1:25',
                                    '00:16:b6:a0:4d:1b',
                                    '00:16:3e:01:00:01',
                                    '00:16:3e:74:af:0a',
                                    '00:16:3e:77:23:ab',
                                    '00:16:3e:11:9f:23',
                                    '00:16:3e:d0:24:62',
                                    '00:16:3e:1f:98:f8',
                                    '00:16:3e:25:14:e1',
                                    '00:16:3e:44:9f:e7',
                                    '00:16:3e:53:3f:51',
                                    '00:16:3e:5e:eb:74',
                                    '00:16:44:84:17:25',
                                    '00:e0:d8:16:96:a7',
                                    '00:17:c4:99:66:a7',
                                    '00:17:c4:23:03:09',
                                    '00:17:c4:41:83:f5',
                                    '00:17:08:89:8d:fe',
                                    '00:18:8b:6e:42:0a',
                                    '00:18:8b:71:dd:45',
                                    '00:18:8b:71:dd:52',
                                    '00:18:8b:71:df:1d',
                                    '00:18:8b:cf:87:6a',
                                    '00:18:8b:17:4f:8a',
                                    '00:18:8b:f7:b5:a3',
                                    '00:18:8b:f7:dd:4c',
                                    '00:18:f3:ed:a2:46',
                                    '00:18:fe:a3:2e:d5',
                                    '00:18:fe:a8:28:00',
                                    '00:18:fe:aa:67:00',
                                    '00:18:fe:aa:68:80',
                                    '00:18:fe:aa:69:00',
                                    '00:18:fe:aa:69:80',
                                    '00:18:fe:aa:72:00',
                                    '00:18:fe:aa:77:00',
                                    '00:18:fe:aa:77:80',
                                    '00:18:fe:aa:79:80',
                                    '00:18:fe:aa:a8:80',
                                    '00:18:fe:aa:a9:00',
                                    '00:18:fe:aa:c2:80',
                                    '00:18:fe:aa:c8:80',
                                    '00:18:fe:aa:d8:00',
                                    '00:18:fe:aa:d8:4e',
                                    '00:18:fe:aa:e8:80',
                                    '00:18:fe:aa:e9:00',
                                    '00:18:fe:aa:27:00',
                                    '00:18:fe:aa:49:80',
                                    '00:18:fe:aa:51:00',
                                    '00:18:fe:aa:59:00',
                                    '00:18:fe:aa:09:00',
                                    '00:19:b9:f0:a2:43',
                                    '00:19:b9:05:b8:d8',
                                    '00:19:bb:99:c9:c0',
                                    '00:19:bb:99:2a:c0',
                                    '00:19:e3:06:f1:59',
                                    '00:1a:73:5e:aa:83',
                                    '00:1a:80:d6:fe:65',
                                    '00:1a:a0:de:41:69',
                                    '00:1a:a0:e0:fb:73',
                                    '00:1a:a0:e9:01:33',
                                    '00:1a:a0:e9:78:66',
                                    '00:1a:a0:e9:04:98',
                                    '00:1a:a0:eb:0f:1e',
                                    '00:1a:a0:3e:29:0b',
                                    '00:1a:4b:10:d8:76',
                                    '00:1a:4b:28:fa:49',
                                    '00:1b:77:3e:71:77',
                                    '00:1b:78:18:cc:80',
                                    '00:1b:8b:a3:f9:b8',
                                    '00:1b:b1:af:e0:d8',
                                    '00:1b:b1:4e:5c:9e',
                                    '00:1b:21:2c:7b:6d',
                                    '00:1b:3f:77:2a:00',
                                    '00:1c:b3:7c:67:bf',
                                    '00:1c:bf:9d:90:e4',
                                    '00:1c:2e:90:16:00',
                                    '00:1c:2e:bb:89:00',
                                    '00:1d:a1:ef:e3:f6',
                                    '00:1d:a1:ef:e4:26',
                                    '00:1d:a1:ef:e5:78',
                                    '00:1d:a2:80:b9:30',
                                    '00:1d:b3:06:47:c0',
                                    '00:1d:b3:58:8f:00',
                                    '00:1d:b3:58:cf:80',
                                    '00:1d:b3:59:b1:80',
                                    '00:1d:b3:59:f1:00',
                                    '00:1d:b3:60:bb:00',
                                    '00:1d:b3:61:71:00',
                                    '00:1d:e5:55:16:80',
                                    '00:1d:e5:55:17:ae',
                                    '00:1d:09:65:e0:37',
                                    '00:1d:09:2c:f3:07',
                                    '00:1e:68:9b:3e:d3',
                                    '00:1e:0b:12:9b:42',
                                    '00:1e:0b:17:21:01',
                                    '00:1e:0b:18:74:4f',
                                    '00:1e:7a:bd:de:fa',
                                    '00:1e:8f:da:53:d1',
                                    '00:1e:c2:b2:9a:80',
                                    '00:1e:c9:64:17:e9',
                                    '00:1e:c9:64:4e:12',
                                    '00:1e:c9:7f:94:72',
                                    '00:1e:c9:7f:19:9d',
                                    '00:1e:c9:7f:19:c8',
                                    '00:1e:c9:40:76:11',
                                    '00:1e:c9:45:14:08',
                                    '00:1e:c9:48:b4:36',
                                    '00:1e:c9:4a:b7:ac',
                                    '00:1e:c9:63:b4:d7',
                                    '00:1e:c9:63:bc:38',
                                    '00:1e:c9:63:e9:c0',
                                    '00:1e:4f:f4:e5:fe',
                                    '00:1e:4f:f4:e6:22',
                                    '00:1e:4f:35:db:a8',
                                    '00:1e:4f:35:db:aa',
                                    '00:1e:52:ac:bf:43',
                                    '00:1f:e1:89:8e:6b',
                                    '00:1f:28:4f:ee:00',
                                    '00:1f:29:1b:ab:21',
                                    '00:1f:29:1e:7f:2a',
                                    '00:1f:29:31:8f:c8',
                                    '00:1f:3c:2e:40:5e',
                                    '00:1f:5b:b7:74:e2',
                                    '00:20:85:fb:43:4e',
                                    '00:21:00:30:5b:33',
                                    '00:21:6a:8b:22:7a',
                                    '00:21:6a:c1:7e:84',
                                    '00:21:70:0d:2a:c3',
                                    '00:21:70:9f:b3:f2',
                                    '00:21:70:1c:12:47',
                                    '00:21:70:46:e1:07',
                                    '00:21:70:46:f2:09',
                                    '00:21:70:46:f5:33',
                                    '00:21:70:46:f9:26',
                                    '00:21:70:46:fc:9a',
                                    '00:21:9b:6e:69:6f',
                                    '00:21:9b:71:aa:ee',
                                    '00:21:9b:79:44:c8',
                                    '00:21:9b:79:47:91',
                                    '00:21:9b:79:4a:19',
                                    '00:21:9b:5b:5b:66',
                                    '00:21:b7:6c:79:c1',
                                    '00:21:b7:6c:49:bf',
                                    '00:21:b7:70:ac:f7',
                                    '00:21:b7:96:a7:46',
                                    '00:21:b7:a2:60:1f',
                                    '00:21:b7:aa:dc:fa',
                                    '00:21:b7:12:ff:37',
                                    '00:21:b7:ba:7d:72',
                                    '00:21:b7:02:25:ff',
                                    '00:21:b7:02:61:1d',
                                    '00:21:b7:cc:2d:de',
                                    '00:21:b7:dc:20:0d',
                                    '00:21:b7:dc:20:13',
                                    '00:21:b7:fa:44:0e',
                                    '00:21:b7:fc:c8:a4',
                                    '00:21:b7:22:9e:df',
                                    '00:21:b7:2a:89:37',
                                    '00:21:b7:2c:be:98',
                                    '00:21:b7:42:a3:26',
                                    '00:21:b7:5c:7c:d7',
                                    '00:21:b7:5c:c2:51',
                                    '00:21:b7:5c:02:90',
                                    '00:21:5a:90:d5:99',
                                    '00:21:5c:73:77:25',
                                    '00:21:5d:be:fe:94',
                                    '00:21:5d:c9:bd:64',
                                    '00:21:5d:1c:4a:52',
                                    '00:21:5d:2d:91:ba',
                                    '00:21:63:c4:6f:da',
                                    '00:22:19:8b:f7:c9',
                                    '00:22:19:11:c7:13',
                                    '00:22:19:cc:f5:2c',
                                    '00:22:19:23:d5:65',
                                    '00:22:19:23:d5:97',
                                    '00:22:19:31:b7:ad',
                                    '00:22:19:31:b7:36',
                                    '00:22:19:31:b8:be',
                                    '00:22:19:31:b8:cf',
                                    '00:22:fa:13:86:06',
                                    '00:22:fa:4a:ec:70',
                                    '00:22:fb:6d:aa:08',
                                    '00:22:fb:5f:22:1c',
                                    '00:22:41:f9:f4:38',
                                    '00:22:41:31:4a:77',
                                    '00:23:6c:91:7b:bf',
                                    '00:23:6c:9a:ea:9b',
                                    '00:23:6c:d3:a3:8c',
                                    '00:23:7d:6e:ff:53',
                                    '00:23:7d:81:ba:1c',
                                    '00:23:7d:87:2e:11',
                                    '00:23:7d:89:44:e3',
                                    '00:23:7d:8e:7f:9f',
                                    '00:23:ae:71:bf:7c',
                                    '00:23:ae:71:bf:1c',
                                    '00:23:ae:71:bf:2a',
                                    '00:23:ae:71:c0:7b',
                                    '00:23:ae:71:c0:37',
                                    '00:23:ae:71:c3:96',
                                    '00:23:ae:71:c3:07',
                                    '00:23:ae:74:6b:2c',
                                    '00:23:ae:74:72:a7',
                                    '00:23:ae:74:7b:b2',
                                    '00:23:ae:74:7c:17',
                                    '00:23:ae:74:7f:e0',
                                    '00:23:ae:74:7f:f0',
                                    '00:23:ae:74:7f:fd',
                                    '00:23:ae:74:80:a0',
                                    '00:23:ae:74:82:5f',
                                    '00:23:ae:74:aa:0f',
                                    '00:23:ae:79:fb:c5',
                                    '00:23:ae:7a:02:3c',
                                    '00:23:ae:7c:33:9c',
                                    '00:23:ae:ad:29:63',
                                    '00:23:ae:ad:32:87',
                                    '00:23:ae:f8:62:4e',
                                    '00:23:ae:fb:fb:80',
                                    '00:23:ae:fe:17:74',
                                    '00:23:12:11:2b:46',
                                    '00:23:12:22:19:6b',
                                    '00:23:12:08:18:65',
                                    '00:23:32:b4:01:5e',
                                    '00:23:4d:5c:6f:0b',
                                    '00:24:d2:69:76:91',
                                    '00:24:d2:df:af:82',
                                    '00:24:d6:2d:d8:6c',
                                    '00:24:d6:37:73:0c',
                                    '00:24:d7:71:7f:d4',
                                    '00:24:d7:71:63:14',
                                    '00:24:d7:76:f8:40',
                                    '00:24:e8:0c:22:2f',
                                    '00:24:e8:0c:23:a9',
                                    '00:24:e8:0c:23:ba',
                                    '00:24:e8:aa:e3:3e',
                                    '00:24:e8:ab:9b:0e',
                                    '00:24:e8:1b:cc:70',
                                    '00:24:e8:1b:d3:45',
                                    '00:24:e8:1d:9d:6a',
                                    '00:24:e8:1d:9e:e6',
                                    '00:24:e8:1d:9f:fc',
                                    '00:24:e8:36:20:15',
                                    '00:24:e8:46:d9:55',
                                    '00:24:e8:46:da:27',
                                    '00:24:e8:48:e5:97',
                                    '00:24:e8:48:e5:9f',
                                    '00:24:21:6d:5f:20',
                                    '00:25:00:ef:60:94',
                                    '00:25:00:42:a0:83',
                                    '00:25:64:b8:35:b6',
                                    '00:25:64:b8:35:d4',
                                    '00:25:64:e8:8c:be',
                                    '00:25:64:e8:8d:9f',
                                    '00:25:64:e8:8f:b3',
                                    '00:25:64:e8:90:4f',
                                    '00:25:64:e8:91:e7',
                                    '00:25:64:e8:91:33',
                                    '00:25:b3:f1:68:bd',
                                    '00:25:45:22:89:34',
                                    '00:25:45:22:a4:22',
                                    '00:25:4b:8b:46:e6',
                                    '00:25:4b:fc:95:cf',
                                    '00:26:0b:62:87:8c',
                                    '00:26:0b:62:87:ae',
                                    '00:26:0b:62:87:ee',
                                    '00:26:0b:62:88:14',
                                    '00:26:0b:62:88:06',
                                    '00:26:0b:62:88:08',
                                    '00:26:0b:62:8a:9a',
                                    '00:26:0b:62:8a:da',
                                    '00:26:0b:62:8b:fa',
                                    '00:26:0b:62:8b:1a',
                                    '00:26:0b:62:8b:34',
                                    '00:26:0b:62:8c:82',
                                    '00:26:0b:62:8c:a0',
                                    '00:26:0b:62:8c:a4',
                                    '00:26:0b:62:8c:c8',
                                    '00:26:0b:62:8d:78',
                                    '00:26:0b:62:8d:98',
                                    '00:26:0b:62:8d:c2',
                                    '00:26:0b:62:8d:4e',
                                    '00:26:0b:62:b1:80',
                                    '00:26:0b:62:50:7e',
                                    '00:26:0b:62:50:4e',
                                    '00:26:73:0e:e8:17',
                                    '00:26:73:12:13:52',
                                    '00:26:73:13:dc:e7',
                                    '00:26:73:13:ec:5e',
                                    '00:26:73:1e:01:98',
                                    '00:26:73:27:27:05',
                                    '00:26:73:29:4a:8e',
                                    '00:26:73:2b:79:86',
                                    '00:26:73:2b:79:9f',
                                    '00:26:73:2b:a6:a2',
                                    '00:26:73:31:74:b8',
                                    '00:26:73:31:74:cb',
                                    '00:26:73:31:74:e3',
                                    '00:26:73:33:7a:bf',
                                    '00:26:73:45:e9:76',
                                    '00:26:73:4a:0d:e4',
                                    '00:26:73:4a:22:fd',
                                    '00:26:b0:da:16:ba',
                                    '00:26:b6:3e:b5:e5',
                                    '00:26:b9:85:dd:7e',
                                    '00:26:bb:13:1d:b1',
                                    '00:26:bb:1d:83:4c',
                                    '00:26:bb:03:b5:bd',
                                    '00:26:bb:04:06:07',
                                    '00:26:bb:06:51:16',
                                    '00:26:cb:10:0c:50',
                                    '00:26:cb:10:40:30',
                                    '00:26:cb:10:41:50',
                                    '00:26:cb:10:42:80',
                                    '00:26:cb:11:1a:80',
                                    '00:26:cb:11:05:00',
                                    '00:26:cb:b8:bf:f0',
                                    '00:26:cb:1b:c0:60',
                                    '00:26:cb:1d:7a:f0',
                                    '00:26:cb:1d:7c:e0',
                                    '00:26:cb:1d:7d:c0',
                                    '00:26:cb:1d:92:30',
                                    '00:26:cb:1d:97:00',
                                    '00:26:cb:1d:9d:20',
                                    '00:26:cb:1d:a3:70',
                                    '00:26:cb:1d:ab:30',
                                    '00:26:08:e1:6b:31',
                                    '00:26:08:e4:35:06',
                                    '00:26:5e:70:43:c6',
                                    '00:27:10:e0:5e:48',
                                    '00:04:00:16:38:9f',
                                    '00:04:00:f6:22:6c',
                                    '00:30:c1:c2:49:45',
                                    '00:30:c1:02:60:bd',
                                    '00:05:1e:0d:38:23',
                                    '00:37:6d:da:f6:3a',
                                    '00:08:14:00:37:aa',
                                    '00:50:b6:5b:11:ef',
                                    '00:50:c2:d0:ff:51',
                                    '00:50:56:b2:3a:42',
                                    '00:60:9f:80:00:59',
                                    '00:60:9f:80:06:14',
                                    '68:9c:5e:2c:12:08',
                                    '68:a3:c4:43:57:70',
                                    '68:a8:6d:0b:74:e2',
                                    '68:a8:6d:23:a6:b0',
                                    '68:a8:6d:23:b5:b2',
                                    '68:a8:6d:4a:c5:b2',
                                    '68:5d:43:57:d9:9c',
                                    '6c:71:d9:6b:02:0a',
                                    '6c:71:d9:70:5f:32',
                                    '6c:71:d9:7f:fb:36',
                                    '6c:3e:6d:74:05:1e',
                                    '70:71:bc:b9:30:15',
                                    '70:aa:b2:76:bd:b6',
                                    '70:f3:95:e7:7c:65',
                                    '70:f9:27:c7:a9:a3',
                                    '70:56:81:93:45:c9',
                                    '70:56:81:ab:56:db',
                                    '74:de:2b:2b:c1:69',
                                    '74:e1:b6:7d:d2:cb',
                                    '74:f0:6d:0a:1e:cd',
                                    '74:f0:6d:51:c4:34',
                                    '74:2f:68:8c:32:8d',
                                    '74:2f:68:ed:13:f8',
                                    '74:2f:68:2e:09:19',
                                    '74:2f:68:53:0a:13',
                                    '74:45:8a:67:6d:ad',
                                    '74:45:8a:53:cf:6d',
                                    '0c:84:dc:9d:f6:4f',
                                    '0c:ee:e6:d5:ce:b4',
                                    '78:92:9c:95:38:a6',
                                    '78:92:9c:22:1e:e4',
                                    '78:92:9c:3d:6b:ba',
                                    '78:ac:c0:77:93:00',
                                    '78:ac:c0:8f:63:b9',
                                    '78:ca:39:ae:e4:58',
                                    '78:e4:00:0b:f5:4a',
                                    '78:e4:00:f4:ee:16',
                                    '78:1f:db:ac:93:66',
                                    '78:2b:cb:85:ff:81',
                                    '78:2b:cb:85:ff:9c',
                                    '78:2b:cb:86:19:d9',
                                    '78:2b:cb:86:1b:11',
                                    '78:2b:cb:86:08:26',
                                    '78:2b:cb:86:57:0b',
                                    '78:2b:cb:98:c4:88',
                                    '78:2b:cb:98:c5:e9',
                                    '78:2b:cb:98:c6:ae',
                                    '78:2b:cb:98:c6:e9',
                                    '78:2b:cb:98:c6:fd',
                                    '78:2b:cb:98:c7:80',
                                    '78:2b:cb:98:e9:31',
                                    '78:2b:cb:98:24:86',
                                    '78:2b:cb:9a:15:14',
                                    '78:2b:cb:9a:18:8c',
                                    '78:2b:cb:9e:86:a7',
                                    '78:2b:cb:9e:95:9d',
                                    '78:2b:cb:9e:cb:3c',
                                    '7c:d1:c3:97:e5:c4',
                                    '7c:d1:c3:9b:96:be',
                                    '7c:e9:d3:7e:cf:09',
                                    '7c:e9:d3:8c:07:d4',
                                    '84:7a:88:81:81:b1',
                                    '84:8f:69:d7:1b:2c',
                                    '84:a6:c8:da:1d:cb',
                                    '84:fc:fe:cd:52:43',
                                    '84:2b:2b:96:67:09',
                                    '84:2b:2b:96:73:ec',
                                    '84:2b:2b:9a:69:e0',
                                    '84:2b:2b:9b:d3:e1',
                                    '84:2b:2b:aa:4c:be',
                                    '84:2b:2b:bb:34:bb',
                                    '84:2b:2b:bb:4e:74',
                                    '84:2b:2b:bb:4e:25',
                                    '84:2b:2b:60:0e:cb',
                                    '84:3a:4b:7d:02:38',
                                    '84:4b:f5:16:e2:99',
                                    '84:4b:f5:29:b0:bb',
                                    '88:c6:63:69:1c:36',
                                    '88:c6:63:f3:55:cc',
                                    '88:1f:a1:0f:74:46',
                                    '88:1f:a1:18:dd:1a',
                                    '88:30:8a:25:a8:88',
                                    '88:53:95:d3:23:4e',
                                    '88:53:d4:27:c9:ff',
                                    '8c:2d:aa:45:3e:c7',
                                    '90:84:0d:9a:91:8f',
                                    '90:84:0d:53:b7:8b',
                                    '90:b1:1c:7d:98:0d',
                                    '90:b1:1c:7d:98:bb',
                                    '90:b1:1c:7d:98:5b',
                                    '90:b1:1c:7d:9b:8a',
                                    '90:b1:1c:7e:0d:9a',
                                    '90:b1:1c:7e:0d:aa',
                                    '90:b1:1c:82:f9:9f',
                                    '90:b1:1c:a5:18:cf',
                                    '90:b1:1c:a5:1e:37',
                                    '90:b1:1c:4f:24:5d',
                                    '90:18:7c:1b:c3:e8',
                                    '90:18:7c:37:c2:1f',
                                    '90:18:7c:5f:7d:c3',
                                    '90:21:55:63:5a:5b',
                                    '90:27:e4:fe:d9:4e',
                                    '90:4c:e5:8a:67:07',
                                    '90:4c:e5:1b:9c:05',
                                    '94:71:ac:f9:d0:8a',
                                    '98:0c:82:8c:8d:a9',
                                    '98:0c:82:56:2c:50',
                                    '98:d6:bb:cb:58:e8',
                                    '98:d6:f7:5d:fe:8b',
                                    '98:fe:94:06:52:96',
                                    '98:fe:94:3f:b9:36',
                                    '98:fe:94:41:ce:64',
                                    '98:fe:94:49:ea:04',
                                    '98:4b:e1:39:9e:a9',
                                    '9c:04:eb:1d:8f:33',
                                    '9c:2a:70:23:55:cd',
                                    '9c:2a:70:25:52:d9',
                                    '10:68:3f:85:31:4e',
                                    '10:68:3f:e7:e2:0c',
                                    '10:0b:a9:50:e2:f0',
                                    '10:0b:a9:52:72:94',
                                    '10:0b:a9:52:72:c0',
                                    '10:93:e9:0e:a4:78',
                                    '10:93:e9:04:7d:3c',
                                    '10:9a:dd:27:8d:8b',
                                    '10:9a:dd:44:a9:fe',
                                    '10:dd:b1:ee:a7:93',
                                    '10:1c:0c:28:32:91',
                                    '10:40:f3:7c:30:6a',
                                    '10:40:f3:86:62:02',
                                    '10:40:f3:98:36:56',
                                    '10:40:f3:f0:20:78',
                                    'a0:6c:ec:6f:ea:16',
                                    'a0:82:1f:6c:55:99',
                                    'a0:f3:c1:09:1c:30',
                                    'a0:f4:50:ef:81:cf',
                                    'a0:42:3f:01:97:7d',
                                    'a4:67:06:ba:8c:55',
                                    'a4:67:06:54:b2:27',
                                    'a4:ba:db:f6:ab:b8',
                                    'a4:ba:db:f6:ad:cf',
                                    'a4:ba:db:f6:ae:86',
                                    'a4:ba:db:f6:ae:9a',
                                    'a4:ba:db:f6:ae:b6',
                                    'a4:ba:db:f6:ae:f2',
                                    'a4:ba:db:f6:ae:40',
                                    'a4:ba:db:f6:af:ea',
                                    'a4:ba:db:f6:b0:82',
                                    'a4:ba:db:f6:b1:3d',
                                    'a4:ba:db:f7:bb:ce',
                                    'a4:ba:db:f7:bc:78',
                                    'a4:ba:db:f8:0f:54',
                                    'a4:ba:db:f8:10:ec',
                                    'a4:ba:db:f8:12:a8',
                                    'a4:ba:db:f8:13:e4',
                                    'a4:d1:d2:0a:da:a0',
                                    'a4:17:31:1a:fc:df',
                                    'a4:17:31:09:9c:a7',
                                    'a8:20:66:30:f6:5e',
                                    'a8:20:66:4f:de:c7',
                                    'ac:72:89:77:a9:4d',
                                    'ac:3c:0b:de:42:e0',
                                    'b0:65:bd:0b:a3:92',
                                    'b0:65:bd:72:07:1b',
                                    'b0:65:bd:54:d3:71',
                                    'b4:74:9f:ae:f1:1f',
                                    'b4:99:ba:d7:54:30',
                                    'b4:f0:ab:7e:bb:14',
                                    'b4:07:f9:d5:f8:d6',
                                    'b8:76:3f:26:05:a9',
                                    'b8:78:2e:84:9b:56',
                                    'b8:8d:12:00:2a:d6',
                                    'b8:8d:12:13:7d:80',
                                    'b8:8d:12:14:c3:26',
                                    'b8:8d:12:1b:df:e0',
                                    'b8:8d:12:1b:e0:62',
                                    'b8:8d:12:1b:e1:f0',
                                    'b8:8d:12:39:81:52',
                                    'b8:8d:12:39:56:7e',
                                    'b8:8d:12:08:0f:e0',
                                    'b8:8d:12:55:95:da',
                                    'b8:ac:6f:81:b0:c8',
                                    'b8:ac:6f:0d:4a:d9',
                                    'b8:ac:6f:91:b2:e8',
                                    'b8:ac:6f:91:b4:c3',
                                    'b8:ac:6f:91:b4:c5',
                                    'b8:ac:6f:92:91:9f',
                                    'b8:ac:6f:95:b9:4f',
                                    'b8:ac:6f:a1:a4:04',
                                    'b8:ac:6f:44:5c:b3',
                                    'b8:ca:3a:8c:71:cd',
                                    'b8:ca:3a:9e:65:2b',
                                    'b8:ca:3a:9e:0e:ab',
                                    'b8:ca:3a:9e:0e:b3',
                                    'b8:ca:3a:9e:0e:d6',
                                    'b8:ca:3a:9e:0e:04',
                                    'b8:ca:3a:9e:0e:52',
                                    'b8:ca:3a:9e:0e:53',
                                    'b8:ca:3a:9e:13:f7',
                                    'b8:ca:3a:9e:ce:6d',
                                    'b8:ca:3a:9e:44:3d',
                                    'b8:ca:3a:9e:46:89',
                                    'b8:ca:3a:9e:46:41',
                                    'b8:ca:3a:9e:49:ad',
                                    'b8:ca:3a:9e:49:4e',
                                    'b8:ca:3a:9e:4a:10',
                                    'b8:ca:3a:d3:6f:8f',
                                    'bc:72:b1:78:df:3a',
                                    'bc:cf:cc:ca:d7:a6',
                                    'bc:30:5b:e0:17:78',
                                    'bc:30:5b:e0:17:9f',
                                    'bc:30:5b:e6:a6:28',
                                    'bc:3b:af:0e:e5:a1',
                                    'c0:65:99:8d:d6:03',
                                    'c0:65:99:8e:4f:0b',
                                    'c0:18:85:bb:e1:e3',
                                    'c4:0a:cb:65:9c:30',
                                    'c4:0a:cb:65:b7:60',
                                    'c4:0a:cb:65:f0:20',
                                    'c4:0a:cb:a4:1c:c0',
                                    'c4:0a:cb:b2:2d:d0',
                                    'c4:0a:cb:24:6f:f0',
                                    'c4:0a:cb:24:70:00',
                                    'c4:0a:cb:24:73:80',
                                    'c4:0a:cb:24:43:10',
                                    'c4:0a:cb:24:47:80',
                                    'c4:0a:cb:24:47:60',
                                    'c4:0a:cb:24:4b:90',
                                    'c4:0a:cb:24:54:80',
                                    'c4:0a:cb:2c:0d:30',
                                    'c4:0a:cb:2c:03:c0',
                                    'c4:0a:cb:2c:2a:e0',
                                    'c4:0a:cb:2c:09:c0',
                                    'c4:64:13:0f:8b:03',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:96',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:c2:ce:31',
                                    'c4:64:13:2b:f2:25',
                                    'c4:6a:b7:6b:ee:fe',
                                    'c4:85:08:31:52:6d',
                                    'c4:17:fe:a6:ed:b7',
                                    'c4:46:19:1b:8f:48',
                                    '14:8f:c6:be:89:49',
                                    '14:10:9f:d0:cb:3b',
                                    '14:10:9f:dd:04:cf',
                                    '14:10:9f:e5:1c:4b',
                                    '14:10:9f:e9:eb:e2',
                                    '14:10:9f:f2:ac:e0',
                                    '14:10:9f:f4:0d:1e',
                                    '14:fe:b5:f0:9f:57',
                                    '14:fe:b5:f0:9f:5e',
                                    '14:5a:05:c9:ab:98',
                                    '14:5a:05:21:20:b6',
                                    'c8:bc:c8:d9:63:1a',
                                    'c8:bc:c8:eb:e0:ea',
                                    'c8:e0:eb:e1:ee:02',
                                    'c8:f7:33:a6:6b:e3',
                                    'c8:19:f7:ee:b7:95',
                                    'c8:2a:14:3e:9a:19',
                                    'cc:78:5f:68:90:6e',
                                    'cc:af:78:cf:c1:49',
                                    'cc:52:af:5e:a7:dc',
                                    'd0:b3:3f:68:0c:80',
                                    'd0:b3:3f:68:10:d6',
                                    'd0:b3:3f:7e:e3:7a',
                                    'd0:b3:3f:9a:c2:69',
                                    'd0:b3:3f:a6:b5:70',
                                    'd0:b3:3f:f5:ba:88',
                                    'd0:df:9a:5b:b3:55',
                                    'd0:23:db:31:af:58',
                                    'd0:57:85:57:c0:99',
                                    'd4:85:64:14:42:10',
                                    'd4:85:64:3c:ac:e5',
                                    'd4:9a:20:72:73:0d',
                                    'd4:9a:20:57:16:45',
                                    'd4:a0:2a:10:38:c0',
                                    'd4:ae:52:ba:a2:64',
                                    'd4:ae:52:ba:a2:6d',
                                    'd4:ae:52:bc:06:c0',
                                    'd4:be:d9:8f:25:83',
                                    'd4:be:d9:91:ef:17',
                                    'd4:be:d9:91:ef:36',
                                    'd4:be:d9:91:f1:6a',
                                    'd4:be:d9:91:25:c4',
                                    'd4:be:d9:91:25:fb',
                                    'd4:be:d9:91:25:fd',
                                    'd4:be:d9:91:26:01',
                                    'd4:be:d9:91:26:85',
                                    'd4:be:d9:91:26:91',
                                    'd4:be:d9:91:26:9f',
                                    'd4:be:d9:91:26:f2',
                                    'd4:be:d9:91:26:fe',
                                    'd4:be:d9:91:26:22',
                                    'd4:be:d9:91:26:04',
                                    'd4:be:d9:91:26:2d',
                                    'd4:be:d9:91:27:02',
                                    'd4:be:d9:92:00:fd',
                                    'd4:be:d9:92:02:87',
                                    'd4:be:d9:92:02:95',
                                    'd4:be:d9:97:d4:24',
                                    'd4:be:d9:18:19:98',
                                    'd4:be:d9:18:1b:5a',
                                    'd8:9e:3f:b8:4a:0a',
                                    'd8:9e:3f:36:3d:db',
                                    'd8:24:bd:d5:1c:b0',
                                    'd8:24:bd:d5:2d:c0',
                                    'd8:24:bd:d5:2e:50',
                                    'd8:24:bd:d5:33:f0',
                                    'd8:24:bd:d5:40:a0',
                                    'd8:24:bd:d5:40:50',
                                    'd8:24:bd:d5:41:80',
                                    'd8:24:bd:d5:44:d0',
                                    'd8:24:bd:d5:4a:c0',
                                    'd8:24:bd:d5:4c:10',
                                    'd8:24:bd:d5:4c:20',
                                    'd8:24:bd:d5:4f:e0',
                                    'd8:24:bd:d5:50:30',
                                    'd8:24:bd:d5:51:b0',
                                    'd8:24:bd:d5:52:c0',
                                    'd8:24:bd:d5:55:50',
                                    'd8:24:bd:d5:58:40',
                                    'd8:24:bd:d5:5f:50',
                                    'd8:24:bd:d5:60:b0',
                                    'd8:24:bd:d5:63:60',
                                    'd8:24:bd:e8:d0:b0',
                                    'd8:24:bd:e8:d4:10',
                                    'd8:24:bd:e8:e0:e0',
                                    'd8:24:bd:e8:f2:60',
                                    'd8:24:bd:e8:f5:60',
                                    'd8:24:bd:e8:f7:a0',
                                    'd8:24:bd:e8:f9:70',
                                    'd8:24:bd:e9:0a:00',
                                    'd8:24:bd:e9:0b:70',
                                    'd8:24:bd:e9:0d:30',
                                    'd8:24:bd:e9:11:50',
                                    'd8:24:bd:e9:14:b0',
                                    'd8:24:bd:e9:18:a0',
                                    'd8:24:bd:e9:f5:80',
                                    'd8:24:bd:e9:f5:b0',
                                    'd8:30:62:c4:da:ec',
                                    'd8:30:62:5e:1c:19',
                                    'd8:30:62:61:b9:18',
                                    'd8:57:ef:37:44:bb',
                                    'dc:85:de:0f:d2:25',
                                    'dc:85:de:25:37:12',
                                    'e0:b9:a5:ac:e6:6b',
                                    'e0:f8:47:10:85:1a',
                                    'e0:f8:47:a4:84:96',
                                    'e0:f8:47:19:58:32',
                                    'e0:f8:47:40:f9:de',
                                    'e0:f8:47:5f:8f:0a',
                                    'e4:ce:8f:0c:a2:96',
                                    'e4:ce:8f:0f:7c:c8',
                                    'e4:ce:8f:a7:c3:33',
                                    'e4:ce:8f:b8:af:50',
                                    'e4:ce:8f:20:49:5a',
                                    'e4:ce:8f:36:81:40',
                                    'e4:ce:8f:36:60:0c',
                                    'e4:ce:8f:3c:b3:b6',
                                    'e4:d5:3d:68:e0:02',
                                    'e4:d5:3d:96:42:3a',
                                    'e8:99:c4:b6:37:20',
                                    'e8:cb:a1:ff:5a:9d',
                                    'e8:39:df:95:9d:22',
                                    'e8:06:88:a4:22:6f',
                                    'ec:85:2f:a5:dc:13',
                                    'ec:89:f5:60:fa:e2',
                                    'ec:35:86:5f:04:a8',
                                    'ec:55:f9:36:17:22',
                                    '18:00:2d:98:e2:a8',
                                    '18:03:73:0a:88:55',
                                    '18:03:73:0a:20:57',
                                    '18:03:73:0b:57:7b',
                                    '18:03:73:b2:be:86',
                                    '18:03:73:bb:68:8f',
                                    '18:03:73:bb:6a:6c',
                                    '18:03:73:bb:6a:39',
                                    '18:03:73:bb:6b:a1',
                                    '18:03:73:bb:6b:ff',
                                    '18:03:73:bb:6b:36',
                                    '18:03:73:bb:6c:85',
                                    '18:03:73:bb:6c:9d',
                                    '18:03:73:bb:6c:b1',
                                    '18:03:73:bb:6c:c9',
                                    '18:03:73:bb:6e:c2',
                                    '18:03:73:bb:54:78',
                                    '18:03:73:cd:8c:a1',
                                    '18:03:73:cd:1b:14',
                                    '18:03:73:ce:2e:25',
                                    '18:03:73:18:e4:bb',
                                    '18:03:73:18:ec:a2',
                                    '18:03:73:18:ef:2a',
                                    '18:03:73:18:f5:57',
                                    '18:03:73:18:f6:ea',
                                    '18:03:73:18:fb:35',
                                    '18:03:73:19:46:0d',
                                    '18:03:73:3d:45:00',
                                    '18:03:73:46:87:5e',
                                    '18:03:73:09:65:56',
                                    '18:03:73:09:d0:a2',
                                    '18:03:73:09:d3:63',
                                    '18:03:73:09:31:ac',
                                    '18:03:73:09:32:88',
                                    '18:3f:47:54:e4:2c',
                                    '18:46:17:e7:4b:ea',
                                    'f0:6b:ca:1b:25:d4',
                                    'f0:b4:79:14:db:4e',
                                    'f0:b4:79:1d:7b:ad',
                                    'f0:cb:a1:6b:66:18',
                                    'f0:5a:09:e1:f0:49',
                                    'f0:62:81:75:ca:00',
                                    'f4:ce:46:33:ed:e2',
                                    'f4:ce:46:33:3a:01',
                                    'f4:ce:46:34:f5:44',
                                    'f4:ce:46:34:26:cf',
                                    'f4:ce:46:42:03:84',
                                    'f4:ce:46:43:e2:e4',
                                    'f4:ce:46:4c:20:7b',
                                    'f4:f1:5a:0c:75:af',
                                    'f4:f1:5a:92:61:1a',
                                    'f4:f1:5a:bd:41:76',
                                    'f4:f1:5a:c4:88:86',
                                    'f8:0c:f3:1b:ee:c9',
                                    'f8:a4:5f:17:bd:d6',
                                    'f8:1e:df:8b:7b:b8',
                                    'f8:1e:df:9a:fc:67',
                                    'f8:1e:df:9c:0c:43',
                                    'f8:1e:df:ad:af:1a',
                                    'f8:1e:df:dc:cb:28',
                                    'f8:1e:df:dc:da:84',
                                    'f8:1e:df:e5:f9:32',
                                    'f8:1e:df:e9:e5:b7',
                                    'f8:1e:df:ed:c7:48',
                                    '1c:65:9d:76:63:5f',
                                    '1c:b0:94:a3:4b:ea',
                                    '20:64:32:89:4c:4c',
                                    '20:10:7a:93:e3:e4',
                                    '20:10:7a:43:a8:46',
                                    '20:c9:d0:7e:a4:f7',
                                    '20:c9:d0:87:f6:77',
                                    '20:c9:d0:c2:96:3d',
                                    '20:c9:d0:c3:a2:f5',
                                    '20:c9:d0:d5:2a:6b',
                                    '20:c9:d0:d9:b6:85',
                                    '20:c9:d0:da:b1:01',
                                    '20:c9:d0:de:87:47',
                                    '20:c9:d0:e1:3f:7d',
                                    '20:c9:d0:42:c5:63',
                                    '20:c9:d0:49:16:05',
                                    '24:77:03:bb:f0:50',
                                    '24:77:03:13:1f:b8',
                                    '24:77:03:c1:ac:14',
                                    '24:77:03:15:41:a0',
                                    '24:77:03:23:c1:18',
                                    '24:77:03:2c:75:68',
                                    '24:77:03:2c:85:d8',
                                    '24:be:05:ed:96:ec',
                                    '24:fd:52:79:06:ef',
                                    '04:0c:ce:88:1b:23',
                                    '04:0c:ce:d8:a3:a2',
                                    '04:e5:36:40:91:fa',
                                    '04:f7:e4:77:b8:bd',
                                    '04:1e:64:08:e2:f7',
                                    '04:46:65:87:9a:a1',
                                    '04:54:53:a1:da:3c',
                                    '28:6a:ba:c8:45:28',
                                    '28:94:0f:db:59:1d',
                                    '28:cf:da:de:63:52',
                                    '28:cf:da:e7:ed:34',
                                    '28:cf:da:e7:4e:94',
                                    '28:cf:da:3d:93:d2',
                                    '28:cf:e9:65:17:cf',
                                    '28:cf:e9:13:4d:57',
                                    '28:cf:e9:15:25:6b',
                                    '28:cf:e9:55:b4:1d',
                                    '28:cf:e9:5c:1a:4f',
                                    '28:e0:2c:02:b8:f7',
                                    '28:37:37:19:5f:40',
                                    '28:37:37:1c:2e:3e',
                                    '2c:41:38:9a:b7:43',
                                    '30:85:a9:07:fa:4b',
                                    '30:f7:c5:eb:49:a7',
                                    '34:15:9e:8a:d8:c9',
                                    '34:15:9e:91:2f:cc',
                                    '34:51:c9:c6:a6:55',
                                    '38:aa:3c:ef:c1:1c',
                                    '38:60:77:be:eb:0b',
                                    '3c:07:54:0f:f0:bb',
                                    '3c:07:54:23:69:6a',
                                    '40:6c:8f:3b:66:a7',
                                    '40:b3:95:8d:19:cc',
                                    '40:b3:95:e7:9e:c3',
                                    '40:b3:95:4d:8e:c1',
                                    '40:f3:08:22:19:2a',
                                    '40:fc:89:8f:61:63',
                                    '40:25:c2:c9:5d:04',
                                    '40:30:04:4b:a3:ff',
                                    '44:6d:57:2a:bb:d6',
                                    '44:1e:a1:7a:43:c0',
                                    '44:2a:60:a4:4d:e0',
                                    '48:5d:60:f9:18:29',
                                    '48:60:bc:95:df:6b',
                                    '48:60:bc:b1:75:76',
                                    '4c:80:93:3b:21:6c',
                                    '4c:8b:ef:a8:82:51',
                                    '4c:8d:79:e3:46:e2',
                                    '4c:8d:79:e6:cb:8a',
                                    '4c:8d:79:f2:47:f6',
                                    '4c:0f:6e:d9:d8:14',
                                    '4c:b1:99:c9:43:1c',
                                    '4c:ed:de:75:a0:29',
                                    '4c:ed:de:a3:ec:23',
                                    '08:00:27:3d:ca:12',
                                    '08:00:37:87:9a:1a',
                                    '08:00:37:2a:22:7a',
                                    '08:70:45:2a:5e:1a',
                                    '08:11:96:97:74:b4',
                                    '08:ed:b9:ba:81:f9',
                                    '08:ed:b9:06:34:2d',
                                    '08:ed:b9:3d:00:5c',
                                    '08:ed:b9:48:10:69',
                                    '08:ed:b9:4c:52:8b',
                                    '08:3e:8e:85:c8:65',
                                    '08:3e:8e:4b:dc:0b',
                                    '50:01:bb:cf:83:23',
                                    '50:63:13:c3:9e:07',
                                    '54:26:96:cf:53:1b',
                                    '5c:96:9d:89:d9:b9',
                                    '5c:ac:4c:16:01:7a',
                                    '5c:f9:dd:d6:35:d9',
                                    '5c:f9:dd:d6:36:0b',
                                    '5c:26:0a:70:51:c1',
                                    '5c:26:0a:81:07:6d',
                                    '5c:26:0a:81:07:77',
                                    '5c:26:0a:20:85:1a',
                                    '60:c5:47:8d:c6:ea',
                                    '60:c5:47:96:82:60',
                                    '60:d8:19:a7:0c:c2',
                                    '60:d8:19:58:fc:43',
                                    '60:fb:42:f8:fd:1c',
                                    '60:21:c0:12:21:9f',
                                    '60:33:4b:0e:00:81',
                                    '60:33:4b:1c:6d:af',
                                    '60:36:dd:8b:7f:c7',
                                    '60:36:dd:a5:dc:50',
                                    '60:36:dd:08:e9:7c',
                                    'd4:be:d9:91:26:5c',
                                    '24:fd:52:49:0e:5c',
                                    '5c:96:9d:7c:91:95',
                                    '00:24:36:e8:d2:76',
                                    '68:a8:6d:34:8f:c4',
                                    '60:36:dd:94:3e:00',
                                    '00:21:70:9f:b3:50',
                                    '70:73:cb:10:07:3c',
                                    '24:77:03:65:c2:50',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '50',
                        IFDESCR          => '50',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424) 0:00:04.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5672) 0:00:56.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5693) 0:00:56.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3868) 0:00:38.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3889) 0:00:38.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3908) 0:00:39.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3926) 0:00:39.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3948) 0:00:39.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3966) 0:00:39.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(930) 0:00:09.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5667) 0:00:56.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3985) 0:00:39.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4006) 0:00:40.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4025) 0:00:40.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4043) 0:00:40.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4066) 0:00:40.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4085) 0:00:40.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4143) 0:00:41.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4738) 0:00:47.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4162) 0:00:41.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4183) 0:00:41.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4202) 0:00:42.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5713) 0:00:57.13',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4757) 0:00:47.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4780) 0:00:47.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4799) 0:00:47.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4220) 0:00:42.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4818) 0:00:48.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5733) 0:00:57.33',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4261) 0:00:42.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4279) 0:00:42.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4301) 0:00:43.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4320) 0:00:43.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4338) 0:00:43.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4360) 0:00:43.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4379) 0:00:43.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4398) 0:00:43.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4419) 0:00:44.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4438) 0:00:44.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4457) 0:00:44.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4497) 0:00:44.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '114',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4840) 0:00:48.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '115',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4516) 0:00:45.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '118',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4860) 0:00:48.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '119',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4879) 0:00:48.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '120',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4901) 0:00:49.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '122',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4538) 0:00:45.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '123',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4920) 0:00:49.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '125',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '126',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '127',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '128',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '129',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4938) 0:00:49.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '130',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5646) 0:00:56.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '131',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5736) 0:00:57.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '133',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4960) 0:00:49.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4979) 0:00:49.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4998) 0:00:49.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5020) 0:00:50.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5039) 0:00:50.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4696) 0:00:46.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4577) 0:00:45.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4599) 0:00:45.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5058) 0:00:50.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5082) 0:00:50.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '150',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5101) 0:00:51.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '151',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5120) 0:00:51.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '154',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5142) 0:00:51.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '156',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5161) 0:00:51.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '158',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5181) 0:00:51.81',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '160',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5203) 0:00:52.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '162',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5222) 0:00:52.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '163',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5242) 0:00:52.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '164',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5263) 0:00:52.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5282) 0:00:52.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '184',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5737) 0:00:57.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '188',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5301) 0:00:53.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '196',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5324) 0:00:53.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '198',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5343) 0:00:53.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '256',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5362) 0:00:53.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '260',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '262',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4719) 0:00:47.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '263',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5384) 0:00:53.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '264',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5403) 0:00:54.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '266',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5422) 0:00:54.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '270',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5444) 0:00:54.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '272',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5463) 0:00:54.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259336383) 30 days, 0:22:43.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '302',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '306',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '312',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5482) 0:00:54.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '315',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5504) 0:00:55.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '316',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5523) 0:00:55.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '317',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5543) 0:00:55.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '362',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4637) 0:00:46.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '363',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4659) 0:00:46.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '364',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '662',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4677) 0:00:46.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '668',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5565) 0:00:55.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '672',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5585) 0:00:55.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '676',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5604) 0:00:56.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '677',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '908',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5626) 0:00:56.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4158',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J4899C.walk' => [
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ProCurve J4899C Switch 2650, revision H.10.108, ROM H.08.05 (/sw/code/build/fish)',
            MAC          => '00:1d:b3:58:cf:80',
            MODEL        => 'ProCurve 2650 (J4899C)',
        },
        {
            MANUFACTURER => 'Hewlett-Packard',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ProCurve J4899C Switch 2650, revision H.10.108, ROM H.08.05 (/sw/code/build/fish)',
            MAC          => '00:1d:b3:58:cf:80',
            MODEL        => 'ProCurve 2650 (J4899C)',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Hewlett-Packard',
                TYPE         => 'NETWORKING',
                MODEL        => 'ProCurve 2650 (J4899C)',
                COMMENTS     => 'ProCurve J4899C Switch 2650, revision H.10.108, ROM H.08.05 (/sw/code/build/fish)',
                SERIAL       => 'CN830FX04U',
                MAC          => '00:1d:b3:58:cf:80',
                UPTIME       => '(326690861) 37 days, 19:28:28.61',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(231) 0:00:02.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(232) 0:00:02.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(191005471) 22 days, 2:34:14.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '488406426',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(237) 0:00:02.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302437849) 35 days, 0:06:18.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69862514',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2697883774',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:b7:aa:dc:fa',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320362949) 37 days, 1:53:49.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '982820631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '671556436',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245) 0:00:02.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(247) 0:00:02.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
              