/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;

public class CorefCluster
implements Serializable {
    private static final long serialVersionUID = 8655265337578515592L;
    protected Set<Mention> corefMentions;
    protected int clusterID;
    protected Set<Dictionaries.Number> numbers;
    protected Set<Dictionaries.Gender> genders;
    protected Set<Dictionaries.Animacy> animacies;
    protected Set<String> nerStrings;
    protected Set<String> heads;
    public Set<String> words;
    protected Mention firstMention;
    protected Mention representative;

    public int getClusterID() {
        return this.clusterID;
    }

    public Set<Mention> getCorefMentions() {
        return this.corefMentions;
    }

    public Mention getFirstMention() {
        return this.firstMention;
    }

    public Mention getRepresentativeMention() {
        return this.representative;
    }

    public CorefCluster(int ID) {
        this.clusterID = ID;
        this.corefMentions = new HashSet<Mention>();
        this.numbers = EnumSet.noneOf(Dictionaries.Number.class);
        this.genders = EnumSet.noneOf(Dictionaries.Gender.class);
        this.animacies = EnumSet.noneOf(Dictionaries.Animacy.class);
        this.nerStrings = new HashSet<String>();
        this.heads = new HashSet<String>();
        this.words = new HashSet<String>();
        this.firstMention = null;
        this.representative = null;
    }

    public CorefCluster() {
        this(-1);
    }

    public CorefCluster(int ID, Set<Mention> mentions) {
        this(ID);
        this.corefMentions.addAll(mentions);
        for (Mention m : mentions) {
            this.animacies.add(m.animacy);
            this.genders.add(m.gender);
            this.numbers.add(m.number);
            this.nerStrings.add(m.nerString);
            this.heads.add(m.headString);
            if (!m.isPronominal()) {
                for (CoreLabel w : m.originalSpan) {
                    this.words.add(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
                }
            }
            if (this.firstMention == null) {
                this.firstMention = m;
                continue;
            }
            if (!m.appearEarlierThan(this.firstMention)) continue;
            this.firstMention = m;
        }
        this.representative = this.firstMention;
        for (Mention m : mentions) {
            if (!m.moreRepresentativeThan(this.representative)) continue;
            this.representative = m;
        }
    }

    public static void mergeClusters(CorefCluster to, CorefCluster from) {
        int toID = to.clusterID;
        for (Mention m : from.corefMentions) {
            m.corefClusterID = toID;
        }
        to.numbers.addAll(from.numbers);
        if (to.numbers.size() > 1 && to.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            to.numbers.remove((Object)Dictionaries.Number.UNKNOWN);
        }
        to.genders.addAll(from.genders);
        if (to.genders.size() > 1 && to.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
            to.genders.remove((Object)Dictionaries.Gender.UNKNOWN);
        }
        to.animacies.addAll(from.animacies);
        if (to.animacies.size() > 1 && to.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            to.animacies.remove((Object)Dictionaries.Animacy.UNKNOWN);
        }
        to.nerStrings.addAll(from.nerStrings);
        if (to.nerStrings.size() > 1 && to.nerStrings.contains("O")) {
            to.nerStrings.remove("O");
        }
        if (to.nerStrings.size() > 1 && to.nerStrings.contains("MISC")) {
            to.nerStrings.remove("MISC");
        }
        to.heads.addAll(from.heads);
        to.corefMentions.addAll(from.corefMentions);
        to.words.addAll(from.words);
        if (from.firstMention.appearEarlierThan(to.firstMention) && !from.firstMention.isPronominal()) {
            to.firstMention = from.firstMention;
        }
        if (from.representative.moreRepresentativeThan(to.representative)) {
            to.representative = from.representative;
        }
        SieveCoreferenceSystem.logger.finer("merge clusters: " + toID + " += " + from.clusterID);
    }

    public static boolean personDisagree(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict) {
        boolean disagree = false;
        for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention ant : potentialAntecedent.getCorefMentions()) {
                if (!Mention.personDisagree(document, m, ant, dict)) continue;
                disagree = true;
            }
        }
        return disagree;
    }

    public static boolean wordsIncluded(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant) {
        HashSet<String> wordsExceptStopWords = new HashSet<String>(mentionCluster.words);
        wordsExceptStopWords.removeAll(Arrays.asList("the", "this", "mr.", "miss", "mrs.", "dr.", "ms.", "inc.", "ltd.", "corp.", "'s"));
        wordsExceptStopWords.remove(mention.headString.toLowerCase());
        return potentialAntecedent.words.containsAll(wordsExceptStopWords);
    }

    public static boolean haveIncompatibleModifier(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        for (Mention m : mentionCluster.corefMentions) {
            for (Mention ant : potentialAntecedent.corefMentions) {
                if (!m.haveIncompatibleModifier(ant)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRoleAppositive(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2, Dictionaries dict) {
        if (!CorefCluster.attributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        return m1.isRoleAppositive(m2, dict) || m2.isRoleAppositive(m1, dict);
    }

    public static boolean isRelativePronoun(Mention m1, Mention m2) {
        return m1.isRelativePronoun(m2) || m2.isRelativePronoun(m1);
    }

    public static boolean isAcronym(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        for (Mention m : mentionCluster.corefMentions) {
            if (m.isPronominal()) continue;
            for (Mention ant : potentialAntecedent.corefMentions) {
                if (!m.isAcronym(ant) && !ant.isAcronym(m)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPredicateNominatives(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2) {
        if (!CorefCluster.attributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (m1.startIndex <= m2.startIndex && m1.endIndex >= m2.endIndex || m1.startIndex >= m2.startIndex && m1.endIndex <= m2.endIndex) {
            return false;
        }
        return m1.isPredicateNominatives(m2) || m2.isPredicateNominatives(m1);
    }

    public static boolean isApposition(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m1, Mention m2) {
        if (!CorefCluster.attributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (m1.mentionType == Dictionaries.MentionType.PROPER && m2.mentionType == Dictionaries.MentionType.PROPER) {
            return false;
        }
        if (m1.nerString.equals("LOCATION")) {
            return false;
        }
        return m1.isApposition(m2) || m2.isApposition(m1);
    }

    public static boolean attributesAgree(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        boolean hasExtraAnt = false;
        boolean hasExtraThis = false;
        if (!mentionCluster.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            for (Dictionaries.Number n : potentialAntecedent.numbers) {
                if (n == Dictionaries.Number.UNKNOWN || mentionCluster.numbers.contains((Object)n)) continue;
                hasExtraAnt = true;
            }
        }
        if (!potentialAntecedent.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            for (Dictionaries.Number n : mentionCluster.numbers) {
                if (n == Dictionaries.Number.UNKNOWN || potentialAntecedent.numbers.contains((Object)n)) continue;
                hasExtraThis = true;
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!mentionCluster.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
            for (Dictionaries.Gender g : potentialAntecedent.genders) {
                if (g == Dictionaries.Gender.UNKNOWN || mentionCluster.genders.contains((Object)g)) continue;
                hasExtraAnt = true;
            }
        }
        if (!potentialAntecedent.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
            for (Dictionaries.Gender g : mentionCluster.genders) {
                if (g == Dictionaries.Gender.UNKNOWN || potentialAntecedent.genders.contains((Object)g)) continue;
                hasExtraThis = true;
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!mentionCluster.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            for (Dictionaries.Animacy a : potentialAntecedent.animacies) {
                if (a == Dictionaries.Animacy.UNKNOWN || mentionCluster.animacies.contains((Object)a)) continue;
                hasExtraAnt = true;
            }
        }
        if (!potentialAntecedent.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            for (Dictionaries.Animacy a : mentionCluster.animacies) {
                if (a == Dictionaries.Animacy.UNKNOWN || potentialAntecedent.animacies.contains((Object)a)) continue;
                hasExtraThis = true;
            }
        }
        if (hasExtraAnt && hasExtraThis) {
            return false;
        }
        hasExtraAnt = false;
        hasExtraThis = false;
        if (!mentionCluster.nerStrings.contains("O") && !mentionCluster.nerStrings.contains("MISC")) {
            for (String ne : potentialAntecedent.nerStrings) {
                if (ne.equals("O") || ne.equals("MISC") || mentionCluster.nerStrings.contains(ne)) continue;
                hasExtraAnt = true;
            }
        }
        if (!potentialAntecedent.nerStrings.contains("O") && !potentialAntecedent.nerStrings.contains("MISC")) {
            for (String ne : mentionCluster.nerStrings) {
                if (ne.equals("O") || ne.equals("MISC") || potentialAntecedent.nerStrings.contains(ne)) continue;
                hasExtraThis = true;
            }
        }
        return !hasExtraAnt || !hasExtraThis;
    }

    public static boolean relaxedHeadsAgreeBetweenMentions(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m, Mention ant) {
        if (m.isPronominal() || ant.isPronominal()) {
            return false;
        }
        return m.headsAgree(ant);
    }

    public static boolean headsAgree(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention m, Mention ant, Dictionaries dict) {
        boolean headAgree = false;
        if (m.isPronominal() || ant.isPronominal() || dict.allPronouns.contains(m.spanToString().toLowerCase()) || dict.allPronouns.contains(ant.spanToString().toLowerCase())) {
            return false;
        }
        for (Mention a : potentialAntecedent.corefMentions) {
            if (!a.headString.equals(m.headString)) continue;
            headAgree = true;
        }
        return headAgree;
    }

    public static boolean exactStringMatch(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict, Set<Mention> roleSet) {
        boolean matched = false;
        for (Mention m : mentionCluster.corefMentions) {
            if (roleSet.contains(m)) {
                return false;
            }
            for (Mention ant : potentialAntecedent.corefMentions) {
                String mSpan = m.spanToString().toLowerCase();
                String antSpan = ant.spanToString().toLowerCase();
                if (m.isPronominal() || ant.isPronominal() || dict.allPronouns.contains(mSpan) || dict.allPronouns.contains(antSpan)) continue;
                if (mSpan.equals(antSpan)) {
                    matched = true;
                }
                if (!mSpan.equals(antSpan + " 's") && !antSpan.equals(mSpan + " 's")) continue;
                matched = true;
            }
        }
        return matched;
    }

    public static boolean relaxedExactStringMatch(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant, Dictionaries dict, Set<Mention> roleSet) {
        if (roleSet.contains(mention)) {
            return false;
        }
        if (mention.isPronominal() || ant.isPronominal() || dict.allPronouns.contains(mention.spanToString().toLowerCase()) || dict.allPronouns.contains(ant.spanToString().toLowerCase())) {
            return false;
        }
        String mentionSpan = mention.removePhraseAfterHead();
        String antSpan = ant.removePhraseAfterHead();
        if (mentionSpan.equals("") || antSpan.equals("")) {
            return false;
        }
        return mentionSpan.equals(antSpan) || mentionSpan.equals(antSpan + " 's") || antSpan.equals(mentionSpan + " 's");
    }

    public void printCorefCluster(Logger logger) {
        logger.finer("Cluster ID: " + this.clusterID + "\tNumbers: " + this.numbers + "\tGenders: " + this.genders + "\tanimacies: " + this.animacies);
        logger.finer("NE: " + this.nerStrings + "\tfirst Mention's ID: " + this.firstMention.mentionID + "\tHeads: " + this.heads + "\twords: " + this.words);
        TreeMap<Integer, Mention> forSortedPrint = new TreeMap<Integer, Mention>();
        for (Mention m : this.corefMentions) {
            forSortedPrint.put(m.mentionID, m);
        }
        for (Mention m : forSortedPrint.values()) {
            if (m.goldCorefClusterID == -1) {
                logger.finer("mention-> id:" + m.mentionID + "\toriginalRef: " + m.originalRef + "\t" + m.spanToString() + "\tsentNum: " + m.sentNum + "\tstartIndex: " + m.startIndex);
                continue;
            }
            logger.finer("mention-> id:" + m.mentionID + "\toriginalClusterID: " + m.goldCorefClusterID + "\t" + m.spanToString() + "\tsentNum: " + m.sentNum + "\tstartIndex: " + m.startIndex + "\toriginalRef: " + m.originalRef + "\tType: " + (Object)((Object)m.mentionType));
        }
    }

    public boolean isSinglePronounCluster(Dictionaries dict) {
        if (this.corefMentions.size() > 1) {
            return false;
        }
        for (Mention m : this.corefMentions) {
            if (!m.isPronominal() && !dict.allPronouns.contains(m.spanToString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean bothHaveProper(CorefCluster mentionCluster, CorefCluster potentialAntecedent) {
        boolean mentionClusterHaveProper = false;
        boolean potentialAntecedentHaveProper = false;
        for (Mention m : mentionCluster.corefMentions) {
            if (m.mentionType != Dictionaries.MentionType.PROPER) continue;
            mentionClusterHaveProper = true;
        }
        for (Mention a : potentialAntecedent.corefMentions) {
            if (a.mentionType != Dictionaries.MentionType.PROPER) continue;
            potentialAntecedentHaveProper = true;
        }
        return mentionClusterHaveProper && potentialAntecedentHaveProper;
    }

    public static boolean sameProperHeadLastWord(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention, Mention ant) {
        for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention a : potentialAntecedent.getCorefMentions()) {
                if (!Mention.sameProperHeadLastWord(m, a)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean alias(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Semantics semantics, Dictionaries dict) throws Exception {
        Mention mention = mentionCluster.getRepresentativeMention();
        Mention antecedent = potentialAntecedent.getRepresentativeMention();
        if (mention.mentionType != Dictionaries.MentionType.PROPER || antecedent.mentionType != Dictionaries.MentionType.PROPER) {
            return false;
        }
        Method meth = semantics.wordnet.getClass().getMethod("alias", Mention.class, Mention.class);
        return (Boolean)meth.invoke(semantics.wordnet, mention, antecedent) != false;
    }

    public static boolean iWithini(CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict) {
        for (Mention m : mentionCluster.getCorefMentions()) {
            for (Mention a : potentialAntecedent.getCorefMentions()) {
                if (!Mention.iWithini(m, a, dict)) continue;
                return true;
            }
        }
        return false;
    }
}

