/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.util.MutableDouble;
import java.io.DataInputStream;
import java.text.NumberFormat;

public class LambdaSolveTagger
extends LambdaSolve {
    LambdaSolveTagger(Problem p1, double eps1, double nerr1, byte[][] fnumArr) {
        this.p = p1;
        this.eps = eps1;
        this.newtonerr = nerr1;
        this.lambda = new double[p1.fSize];
        this.lambda_converged = new boolean[p1.fSize];
        this.probConds = new double[p1.data.xSize][p1.data.ySize];
        this.fnumArr = fnumArr;
        this.zlambda = new double[p1.data.xSize];
        this.ftildeArr = new double[this.p.fSize];
        this.initCondsZlambdaEtc();
    }

    LambdaSolveTagger(String filename) {
        this.readL(filename);
    }

    LambdaSolveTagger(DataInputStream dataStream) {
        this.lambda = LambdaSolveTagger.read_lambdas(dataStream);
    }

    void initCondsZlambdaEtc() {
        int x;
        for (x = 0; x < this.p.data.xSize; ++x) {
            for (int y = 0; y < this.p.data.ySize; ++y) {
                this.probConds[x][y] = 1.0 / (double)this.p.data.ySize;
            }
        }
        System.err.println(" pcond initialized ");
        for (x = 0; x < this.p.data.xSize; ++x) {
            this.zlambda[x] = this.p.data.ySize;
        }
        System.err.println(" zlambda initialized ");
        for (int i = 0; i < this.p.fSize; ++i) {
            this.ftildeArr[i] = this.p.functions.get(i).ftilde();
            if (this.ftildeArr[i] != 0.0) continue;
            System.err.println(" Empirical expectation 0 for feature " + i);
        }
        System.err.println(" ftildeArr initialized ");
    }

    boolean iterate(int index, double err2, MutableDouble ret) {
        double deltaL = 0.0;
        deltaL = this.newton(deltaL, index, err2);
        this.lambda[index] = this.lambda[index] + deltaL;
        if (deltaL != deltaL) {
            System.err.println(" NaN " + index + ' ' + deltaL);
        }
        ret.set(deltaL);
        return Math.abs(deltaL) >= this.eps;
    }

    double newton(double lambda0, int index, double err2) {
        double gVal;
        double lambdaN = lambda0;
        int i = 0;
        do {
            ++i;
            double lambdaP = lambdaN;
            double gPrimeVal = this.gprime(lambdaP, index);
            if (gPrimeVal != gPrimeVal) {
                System.err.println("gPrime of " + lambdaP + ' ' + index + " is NaN " + gPrimeVal);
            }
            gVal = this.g(lambdaP, index);
            if (gPrimeVal == 0.0) {
                return 0.0;
            }
            lambdaN = lambdaP - gVal / gPrimeVal;
            if (lambdaN != lambdaN) {
                System.err.println("the division of " + gVal + ' ' + gPrimeVal + ' ' + index + " is NaN " + lambdaN);
                return 0.0;
            }
            if (!(Math.abs(lambdaN - lambdaP) < err2)) continue;
            return lambdaN;
        } while (i <= 100);
        if (Math.abs(gVal) > 1.0) {
            return 0.0;
        }
        return lambdaN;
    }

    void updateConds(int index, double deltaL) {
        int yTag = ((TaggerFeature)this.p.functions.get(index)).getYTag();
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            double s = 0.0;
            int x = this.p.functions.get(index).getX(i);
            double zlambdaX = this.zlambda[x] + this.pcond(yTag, x) * this.zlambda[x] * (Math.exp(deltaL) - 1.0);
            for (int y = 0; y < this.p.data.ySize; ++y) {
                this.probConds[x][y] = this.probConds[x][y] * this.zlambda[x] / zlambdaX;
                s += this.probConds[x][y];
            }
            s -= this.probConds[x][yTag];
            this.probConds[x][yTag] = this.probConds[x][yTag] * Math.exp(deltaL);
            s += this.probConds[x][yTag];
            this.zlambda[x] = zlambdaX;
        }
    }

    double g(double lambdaP, int index) {
        double s = 0.0;
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            int y = ((TaggerFeature)this.p.functions.get(index)).getYTag();
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * 1.0 * Math.exp(lambdaP * this.fnum(x, y));
        }
        return s -= this.ftildeArr[index];
    }

    double gprime(double lambdaP, int index) {
        double s = 0.0;
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            int y = ((TaggerFeature)this.p.functions.get(index)).getYTag();
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * 1.0 * Math.exp(lambdaP * this.fnum(x, y)) * this.fnum(x, y);
        }
        return s;
    }

    double fExpected(Feature f) {
        TaggerFeature tF = (TaggerFeature)f;
        double s = 0.0;
        int y = tF.getYTag();
        for (int i = 0; i < f.len(); ++i) {
            int x = tF.getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x);
        }
        return s;
    }

    @Override
    public boolean checkCorrectness() {
        System.err.println("Checking model correctness; x size " + this.p.data.xSize + ' ' + ", ysize " + this.p.data.ySize);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        boolean flag = true;
        for (int f = 0; f < this.lambda.length; ++f) {
            if (!(Math.abs(this.lambda[f]) > 100.0)) continue;
            System.err.println(" Lambda too big " + this.lambda[f]);
            System.err.println(" empirical " + this.ftildeArr[f] + " expected " + this.fExpected(this.p.functions.get(f)));
        }
        for (int i = 0; i < this.ftildeArr.length; ++i) {
            double exp = Math.abs(this.ftildeArr[i] - this.fExpected(this.p.functions.get(i)));
            if (!(exp > 0.001)) continue;
            flag = false;
            System.err.println("Constraint " + i + " not satisfied emp " + nf.format(this.ftildeArr[i]) + " exp " + nf.format(this.fExpected(this.p.functions.get(i))) + " diff " + nf.format(exp) + " lambda " + nf.format(this.lambda[i]));
        }
        for (int x = 0; x < this.p.data.xSize; ++x) {
            int y;
            double s = 0.0;
            for (y = 0; y < this.p.data.ySize; ++y) {
                s += this.probConds[x][y];
            }
            if (!(Math.abs(s - 1.0) > 1.0E-4)) continue;
            for (y = 0; y < this.p.data.ySize; ++y) {
                System.err.println(y + " : " + this.probConds[x][y]);
            }
            System.err.println("probabilities do not sum to one " + x + ' ' + (float)s);
        }
        return flag;
    }

    double ZAlfa(double alfa, Feature f, int x) {
        double s = 0.0;
        for (int y = 0; y < this.p.data.ySize; ++y) {
            s += this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
        }
        return s;
    }
}

