/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.meanSquareOCR;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.meanSquareOCR.TrainingImageSpec;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainingImageSelector
extends JPanel {
    public static final long serialVersionUID = 0L;
    private JPanel trainingPanel;
    private JPanel targetPanel;
    private JTextField targetImage;
    private ArrayList<JTextField> trainingImageLocs = new ArrayList();
    private final ArrayList<JTextField> startCharVals = new ArrayList();
    private final ArrayList<JTextField> endCharVals = new ArrayList();
    private static final Logger LOG = Logger.getLogger(TrainingImageSelector.class.getName());

    public TrainingImageSelector() {
        this.setupPanel();
    }

    public void addTrainingImage() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Training Image"));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel firstPanel = new JPanel();
        firstPanel.setLayout(new FlowLayout());
        JLabel label = new JLabel("Select Image: ");
        firstPanel.add(label);
        JTextField trainImageLoc = new JTextField(40);
        firstPanel.add(trainImageLoc);
        this.trainingImageLocs.add(trainImageLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getSelectTrainingImageListener(trainImageLoc));
        firstPanel.add(button);
        panel.add(firstPanel);
        JPanel secondPanel = new JPanel();
        secondPanel.setLayout(new FlowLayout());
        JLabel startChar = new JLabel("Start Char: ");
        secondPanel.add(startChar);
        JTextField startCharField = new JTextField(2);
        secondPanel.add(startCharField);
        this.startCharVals.add(startCharField);
        JLabel endChar = new JLabel("End Char: ");
        secondPanel.add(endChar);
        JTextField endCharField = new JTextField(2);
        secondPanel.add(endCharField);
        this.endCharVals.add(endCharField);
        panel.add(secondPanel);
        this.trainingPanel.add(panel);
    }

    public void removeTraningImage() {
        int compCount = this.trainingPanel.getComponentCount();
        if (compCount > 1) {
            this.trainingPanel.remove(this.trainingPanel.getComponentCount() - 1);
            this.trainingImageLocs.remove(this.trainingImageLocs.size() - 1);
            this.startCharVals.remove(this.startCharVals.size() - 1);
            this.endCharVals.remove(this.endCharVals.size() - 1);
        }
    }

    public boolean isTraningImagesValid() {
        String currStr;
        for (JTextField imageLoc : this.trainingImageLocs) {
            File currFile = new File(imageLoc.getText());
            if (currFile.exists()) continue;
            return false;
        }
        for (JTextField startChar : this.startCharVals) {
            currStr = startChar.getText();
            if (currStr.length() == 1) continue;
            return false;
        }
        for (JTextField startChar : this.endCharVals) {
            currStr = startChar.getText();
            if (currStr.length() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isTargetImageValid() {
        File currFile = new File(this.getTargetImageLoc());
        return currFile.exists();
    }

    public ArrayList<TrainingImageSpec> getTrainingImages() {
        ArrayList<TrainingImageSpec> images = new ArrayList<TrainingImageSpec>();
        for (int i = 0; i < this.trainingImageLocs.size(); ++i) {
            String trainingImageLoc = this.trainingImageLocs.get(i).getText();
            char startChar = this.startCharVals.get(i).getText().charAt(0);
            char endChar = this.endCharVals.get(i).getText().charAt(0);
            TrainingImageSpec newImage = new TrainingImageSpec();
            newImage.setFileLocation(trainingImageLoc);
            newImage.setCharRange(new CharacterRange(startChar, endChar));
            images.add(newImage);
        }
        return images;
    }

    public String getTargetImageLoc() {
        return this.targetImage.getText();
    }

    private void setupPanel() {
        this.setLayout(new FlowLayout(2));
        this.trainingPanel = this.getTrainingPanel();
        this.targetPanel = this.getTargetPanel();
        this.add(this.trainingPanel);
        this.add(this.targetPanel);
        this.addTrainingImage();
    }

    private JPanel getTrainingPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    private JPanel getTargetPanel() {
        JPanel targPanel = new JPanel();
        targPanel.setBorder(new TitledBorder("Target Image"));
        targPanel.setLayout(new FlowLayout());
        JLabel label = new JLabel("Select Image: ");
        targPanel.add(label);
        this.targetImage = new JTextField(40);
        targPanel.add(this.targetImage);
        JButton button = new JButton("Select");
        button.addActionListener(this.getImageTargetAction());
        targPanel.add(button);
        return targPanel;
    }

    private ActionListener getImageTargetAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    TrainingImageSelector.this.targetImage.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }

    private ActionListener getSelectTrainingImageListener(final JTextField trainImageLoc) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    trainImageLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

