/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.JaiI18N;
import javax.media.jai.LookupTableJAI;

public class ColorCube
extends LookupTableJAI {
    public static final ColorCube BYTE_496 = ColorCube.createColorCube(0, 38, new int[]{4, 9, 6});
    public static final ColorCube BYTE_855 = ColorCube.createColorCube(0, 54, new int[]{8, 5, 5});
    private int[] dimension;
    private int[] dimsLessOne;
    private int[] multipliers;
    private int adjustedOffset;
    private int dataType;
    private int numBands;

    public static ColorCube createColorCube(int n, int n2, int[] nArray) {
        ColorCube colorCube;
        switch (n) {
            case 0: {
                colorCube = ColorCube.createColorCubeByte(n2, nArray);
                break;
            }
            case 2: {
                colorCube = ColorCube.createColorCubeShort(n2, nArray);
                break;
            }
            case 1: {
                colorCube = ColorCube.createColorCubeUShort(n2, nArray);
                break;
            }
            case 3: {
                colorCube = ColorCube.createColorCubeInt(n2, nArray);
                break;
            }
            case 4: {
                colorCube = ColorCube.createColorCubeFloat(n2, nArray);
                break;
            }
            case 5: {
                colorCube = ColorCube.createColorCubeDouble(n2, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube0"));
            }
        }
        return colorCube;
    }

    public static ColorCube createColorCube(int n, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return ColorCube.createColorCube(n, 0, nArray);
    }

    private static ColorCube createColorCubeByte(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayByte(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayShort(n, nArray), n, false);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeUShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayUShort(n, nArray), n, true);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeInt(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayInt(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeFloat(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayFloat(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeDouble(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayDouble(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static Object createDataArray(int n, int n2, int[] nArray) {
        Object object;
        double d;
        double d2;
        int n3 = nArray.length;
        if (n3 == 0) {
            throw new RuntimeException(JaiI18N.getString("ColorCube1"));
        }
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] == 0) {
                throw new RuntimeException(JaiI18N.getString("ColorCube2"));
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n5] = Math.abs(nArray[n5]);
            ++n5;
        }
        double d3 = nArray2[0];
        int n6 = 1;
        while (n6 < n3) {
            d3 *= (double)nArray2[n6];
            ++n6;
        }
        if (d3 > 2.147483647E9) {
            throw new RuntimeException(JaiI18N.getString("ColorCube3"));
        }
        int n7 = (int)d3;
        switch (n) {
            case 0: {
                d2 = 0.0;
                d = 255.0;
                object = new byte[n3][n7];
                break;
            }
            case 2: {
                d2 = -32768.0;
                d = 32767.0;
                object = new short[n3][n7];
                break;
            }
            case 1: {
                d2 = 0.0;
                d = 65535.0;
                object = new short[n3][n7];
                break;
            }
            case 3: {
                d2 = -2.147483648E9;
                d = 2.147483647E9;
                object = new int[n3][n7];
                break;
            }
            case 4: {
                d2 = -3.4028234663852886E38;
                d = 3.4028234663852886E38;
                object = new float[n3][n7];
                break;
            }
            case 5: {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
                object = new double[n3][n7];
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube7"));
            }
        }
        if ((double)(n7 + n2) > d) {
            throw new RuntimeException(JaiI18N.getString("ColorCube4"));
        }
        int[] nArray3 = new int[n3];
        nArray3[0] = 1;
        int n8 = 1;
        while (n8 < n3) {
            nArray3[n8] = nArray3[n8 - 1] * nArray2[n8 - 1];
            ++n8;
        }
        int n9 = 0;
        while (n9 < n3) {
            double d4;
            int n10 = nArray2[n9];
            double d5 = n10 == 1 ? 0.0 : (n == 4 || n == 5 ? 1.0 / (double)(n10 - 1) : (d - d2) / (double)(n10 - 1));
            if (nArray[n9] < 0) {
                d5 = -d5;
                d4 = d;
            } else {
                d4 = d2;
            }
            int n11 = nArray3[n9];
            switch (n) {
                case 0: {
                    Object object2 = object;
                    int n12 = 0;
                    while (n12 < n7) {
                        double d6 = d4;
                        int n13 = 0;
                        while (n13 < n10) {
                            int n14 = 0;
                            while (n14 < n11) {
                                object2[n9][n12] = (byte)((int)(d6 + 0.5) & 0xFF);
                                ++n12;
                                ++n14;
                            }
                            d6 += d5;
                            ++n13;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = object;
                    int n12 = 0;
                    while (n12 < n7) {
                        double d7 = d4;
                        int n15 = 0;
                        while (n15 < n10) {
                            int n16 = 0;
                            while (n16 < n11) {
                                sArray[n9][n12] = (short)(d7 + 0.5);
                                ++n12;
                                ++n16;
                            }
                            d7 += d5;
                            ++n15;
                        }
                    }
                    break;
                }
                case 3: {
                    int n17;
                    int[][] nArray4 = object;
                    int n12 = 0;
                    while (n12 < n7) {
                        double d8 = d4;
                        int n18 = 0;
                        while (n18 < n10) {
                            n17 = 0;
                            while (n17 < n11) {
                                nArray4[n9][n12] = (int)(d8 + 0.5);
                                ++n12;
                                ++n17;
                            }
                            d8 += d5;
                            ++n18;
                        }
                    }
                    break;
                }
                case 4: {
                    int n19;
                    int n17;
                    float[][] fArray = object;
                    int n12 = 0;
                    while (n12 < n7) {
                        double d9 = d4;
                        n17 = 0;
                        while (n17 < n10) {
                            n19 = 0;
                            while (n19 < n11) {
                                fArray[n9][n12] = (float)d9;
                                ++n12;
                                ++n19;
                            }
                            d9 += d5;
                            ++n17;
                        }
                    }
                    break;
                }
                case 5: {
                    int n19;
                    double[][] dArray = object;
                    int n12 = 0;
                    while (n12 < n7) {
                        double d10 = d4;
                        n19 = 0;
                        while (n19 < n10) {
                            int n20 = 0;
                            while (n20 < n11) {
                                dArray[n9][n12] = d10;
                                ++n12;
                                ++n20;
                            }
                            d10 += d5;
                            ++n19;
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("ColorCube5"));
                }
            }
            ++n9;
        }
        return object;
    }

    private static byte[][] createDataArrayByte(int n, int[] nArray) {
        return (byte[][])ColorCube.createDataArray(0, n, nArray);
    }

    private static short[][] createDataArrayShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(2, n, nArray);
    }

    private static short[][] createDataArrayUShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(1, n, nArray);
    }

    private static int[][] createDataArrayInt(int n, int[] nArray) {
        return (int[][])ColorCube.createDataArray(3, n, nArray);
    }

    private static float[][] createDataArrayFloat(int n, int[] nArray) {
        return (float[][])ColorCube.createDataArray(4, n, nArray);
    }

    private static double[][] createDataArrayDouble(int n, int[] nArray) {
        return (double[][])ColorCube.createDataArray(5, n, nArray);
    }

    protected ColorCube(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ColorCube(short[][] sArray, int n, boolean bl) {
        super(sArray, n, bl);
    }

    protected ColorCube(int[][] nArray, int n) {
        super(nArray, n);
    }

    protected ColorCube(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ColorCube(double[][] dArray, int n) {
        super(dArray, n);
    }

    private void initFields(int n, int[] nArray) {
        this.dimension = nArray;
        this.multipliers = new int[nArray.length];
        this.dimsLessOne = new int[nArray.length];
        this.multipliers[0] = 1;
        int n2 = 1;
        while (n2 < this.multipliers.length) {
            this.multipliers[n2] = this.multipliers[n2 - 1] * Math.abs(nArray[n2 - 1]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.multipliers.length) {
            if (nArray[n3] < 0) {
                this.multipliers[n3] = -this.multipliers[n3];
            }
            this.dimsLessOne[n3] = Math.abs(nArray[n3]) - 1;
            ++n3;
        }
        this.adjustedOffset = n;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] > 1 && this.multipliers[n4] < 0) {
                this.adjustedOffset += Math.abs(this.multipliers[n4]) * this.dimsLessOne[n4];
            }
            ++n4;
        }
        this.dataType = this.getDataType();
        this.numBands = this.getNumBands();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public int[] getDimsLessOne() {
        return this.dimsLessOne;
    }

    public int[] getMultipliers() {
        return this.multipliers;
    }

    public int getAdjustedOffset() {
        return this.adjustedOffset;
    }

    public int findNearestEntry(float[] fArray) {
        int n = -1;
        n = this.adjustedOffset;
        switch (this.dataType) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numBands) {
                    int n3 = (int)(fArray[n2] * (float)this.dimsLessOne[n2]);
                    if ((n3 & 0xFF) > 127) {
                        n3 += 256;
                    }
                    n += (n3 >> 8) * this.multipliers[n2];
                    ++n2;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numBands) {
                    int n5 = (int)(fArray[n4] - -32768.0f) * this.dimsLessOne[n4];
                    if ((n5 & 0xFFFF) > Short.MAX_VALUE) {
                        n5 += 65536;
                    }
                    n += (n5 >> 16) * this.multipliers[n4];
                    ++n4;
                }
                break;
            }
            case 1: {
                int n6 = 0;
                while (n6 < this.numBands) {
                    int n7 = (int)(fArray[n6] * (float)this.dimsLessOne[n6]);
                    if ((n7 & 0xFFFF) > Short.MAX_VALUE) {
                        n7 += 65536;
                    }
                    n += (n7 >> 16) * this.multipliers[n6];
                    ++n6;
                }
                break;
            }
            case 3: {
                int n8 = 0;
                while (n8 < this.numBands) {
                    long l = (long)((fArray[n8] - -2.1474836E9f) * (float)this.dimsLessOne[n8]);
                    if (l > Integer.MAX_VALUE) {
                        l += 0L;
                    }
                    n += (int)(l >> 32) * this.multipliers[n8];
                    ++n8;
                }
                break;
            }
            case 4: {
                int n9 = 0;
                while (n9 < this.numBands) {
                    float f = fArray[n9] * (float)this.dimsLessOne[n9];
                    int n10 = (int)f;
                    if (f - (float)n10 >= 0.5f) {
                        ++n10;
                    }
                    n += n10 * this.multipliers[n9];
                    ++n9;
                }
                break;
            }
            case 5: {
                int n11 = 0;
                while (n11 < this.numBands) {
                    double d = fArray[n11] * (float)this.dimsLessOne[n11];
                    int n12 = (int)d;
                    if (d - (double)n12 >= 0.5) {
                        ++n12;
                    }
                    n += n12 * this.multipliers[n11];
                    ++n11;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube6"));
            }
        }
        return n;
    }
}

