/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.apache.poi.xslf.usermodel.RenderableShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBackgroundFillStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackgroundProperties;

public class XSLFBackground
extends XSLFSimpleShape {
    XSLFBackground(CTBackground shape, XSLFSheet sheet) {
        super(shape, sheet);
    }

    public Rectangle2D getAnchor() {
        Dimension pg = this.getSheet().getSlideShow().getPageSize();
        return new Rectangle2D.Double(0.0, 0.0, pg.getWidth(), pg.getHeight());
    }

    public void draw(Graphics2D graphics) {
        Rectangle2D anchor = this.getAnchor();
        Paint fill = this.getPaint(graphics);
        if (fill != null) {
            graphics.setPaint(fill);
            graphics.fill(anchor);
        }
    }

    Paint getPaint(Graphics2D graphics) {
        RenderableShape rShape = new RenderableShape(this);
        Paint fill = null;
        CTBackground bg = (CTBackground)this.getXmlObject();
        if (bg.isSetBgPr()) {
            CTBackgroundProperties spPr = bg.getBgPr();
            fill = rShape.getPaint(graphics, spPr, null);
        } else if (bg.isSetBgRef()) {
            CTStyleMatrixReference bgRef = bg.getBgRef();
            CTSchemeColor phClr = bgRef.getSchemeClr();
            int idx = (int)bgRef.getIdx() - 1001;
            XSLFTheme theme = this.getSheet().getTheme();
            CTBackgroundFillStyleList bgStyles = theme.getXmlObject().getThemeElements().getFmtScheme().getBgFillStyleLst();
            XmlObject bgStyle = bgStyles.selectPath("*")[idx];
            fill = rShape.selectPaint(graphics, bgStyle, phClr, theme.getPackagePart());
        }
        return fill;
    }

    public Color getFillColor() {
        Paint p = this.getPaint(null);
        if (p instanceof Color) {
            return (Color)p;
        }
        return null;
    }

    CTTransform2D getXfrm() {
        return CTTransform2D.Factory.newInstance();
    }
}

