/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.simr.LcsrMatching;
import gma.util.StringUtil;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestLcsrMatching
extends TestCase {
    private LcsrMatching matching = null;
    static /* synthetic */ Class class$gma$simr$TestLcsrMatching;

    public TestLcsrMatching(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.put("lcsrThreshold", "0.71");
        properties.put("minimumWordLength", "4");
        this.matching = new LcsrMatching();
        this.matching.setProperties(properties);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testComputeLcs() throws Exception {
        Byte nextItem;
        int i;
        String wordForMatch = "olivier";
        String wordToMatch = "olive";
        ArrayList<Byte> listForMatch = new ArrayList<Byte>();
        ArrayList<Byte> listToMatch = new ArrayList<Byte>();
        for (i = 0; i < wordForMatch.length(); ++i) {
            nextItem = new Byte((byte)wordForMatch.charAt(i));
            listForMatch.add(nextItem);
        }
        for (i = 0; i < wordToMatch.length(); ++i) {
            nextItem = new Byte((byte)wordToMatch.charAt(i));
            listToMatch.add(nextItem);
        }
        int lcsLength = this.matching.computeLcs(listForMatch, listToMatch);
        TestLcsrMatching.assertEquals(lcsLength, 5);
    }

    public void testIsMatch() throws Exception {
        int i;
        Byte nextItem;
        int i2;
        ArrayList<Byte> listForMatch = new ArrayList<Byte>();
        ArrayList<Byte> listToMatch = new ArrayList<Byte>();
        String wordForMatch = StringUtil.norm("proph\u00e8tes");
        String wordToMatch = StringUtil.norm("prophets");
        for (i2 = 0; i2 < wordForMatch.length(); ++i2) {
            nextItem = new Byte((byte)wordForMatch.charAt(i2));
            listForMatch.add(nextItem);
        }
        for (i2 = 0; i2 < wordToMatch.length(); ++i2) {
            nextItem = new Byte((byte)wordToMatch.charAt(i2));
            listToMatch.add(nextItem);
        }
        boolean result = this.matching.isMatch(listForMatch, listToMatch, true);
        TestLcsrMatching.assertEquals(result, true);
        wordForMatch = StringUtil.norm("Th\u00e9man");
        wordToMatch = StringUtil.norm("Teman");
        listForMatch = new ArrayList();
        listToMatch = new ArrayList();
        for (i = 0; i < wordForMatch.length(); ++i) {
            nextItem = new Byte((byte)wordForMatch.charAt(i));
            listForMatch.add(nextItem);
        }
        for (i = 0; i < wordToMatch.length(); ++i) {
            nextItem = new Byte((byte)wordToMatch.charAt(i));
            listToMatch.add(nextItem);
        }
        result = this.matching.isMatch(listForMatch, listToMatch, true);
        TestLcsrMatching.assertEquals(result, true);
        wordForMatch = StringUtil.norm("Nonsense");
        wordToMatch = StringUtil.norm("Noise");
        listForMatch = new ArrayList();
        listToMatch = new ArrayList();
        for (i = 0; i < wordForMatch.length(); ++i) {
            nextItem = new Byte((byte)wordForMatch.charAt(i));
            listForMatch.add(nextItem);
        }
        for (i = 0; i < wordToMatch.length(); ++i) {
            nextItem = new Byte((byte)wordToMatch.charAt(i));
            listToMatch.add(nextItem);
        }
        result = this.matching.isMatch(listForMatch, listToMatch, true);
        TestLcsrMatching.assertEquals(result, false);
    }

    public static void main(String[] args) {
        TestSuite mySuite = new TestSuite(class$gma$simr$TestLcsrMatching == null ? (class$gma$simr$TestLcsrMatching = TestLcsrMatching.class$("gma.simr.TestLcsrMatching")) : class$gma$simr$TestLcsrMatching);
        TestRunner.run((Test)mySuite);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

