/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.map;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.FeatureMapFunction;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.MultipleFeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFeature
implements FeatureMapFunction {
    protected FeatureFunction parentFeature;
    protected MultipleFeatureValue multipleFeatureValue;
    protected SymbolTableHandler tableHandler;
    protected SymbolTable table;
    protected String separators;
    protected Pattern separatorsPattern;

    public SplitFeature(SymbolTableHandler tableHandler) throws MaltChainedException {
        this.setTableHandler(tableHandler);
        this.multipleFeatureValue = new MultipleFeatureValue(this);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 2) {
            throw new FeatureException("Could not initialize SplitFeature: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof FeatureFunction)) {
            throw new FeatureException("Could not initialize SplitFeature: the first argument is not a feature. ");
        }
        if (!(arguments[1] instanceof String)) {
            throw new FeatureException("Could not initialize SplitFeature: the second argument is not a string. ");
        }
        this.setParentFeature((FeatureFunction)arguments[0]);
        this.setSeparators((String)arguments[1]);
        this.setSymbolTable(this.tableHandler.addSymbolTable("SPLIT_" + this.parentFeature.getSymbolTable().getName(), this.parentFeature.getSymbolTable()));
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{FeatureFunction.class, String.class};
        return paramTypes;
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.multipleFeatureValue;
    }

    @Override
    public String getSymbol(int code) throws MaltChainedException {
        return this.table.getSymbolCodeToString(code);
    }

    @Override
    public int getCode(String symbol) throws MaltChainedException {
        return this.table.getSymbolStringToCode(symbol);
    }

    @Override
    public void update() throws MaltChainedException {
        this.multipleFeatureValue.reset();
        this.parentFeature.update();
        FeatureValue value = this.parentFeature.getFeatureValue();
        if (value instanceof SingleFeatureValue) {
            String symbol = ((SingleFeatureValue)value).getSymbol();
            if (value.isNullValue()) {
                this.multipleFeatureValue.addFeatureValue(this.parentFeature.getSymbolTable().getSymbolStringToCode(symbol), symbol, true);
                this.multipleFeatureValue.setNullValue(true);
            } else {
                String[] items;
                try {
                    items = this.separatorsPattern.split(symbol);
                }
                catch (PatternSyntaxException e) {
                    throw new FeatureException("The split feature '" + this.toString() + "' could not split the value using the following separators '" + this.separators + "'", e);
                }
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].length() <= 0) continue;
                    this.multipleFeatureValue.addFeatureValue(this.table.addSymbol(items[i]), items[i], this.table.getKnown(items[i]));
                }
                this.multipleFeatureValue.setNullValue(false);
            }
        } else if (value instanceof MultipleFeatureValue) {
            if (((MultipleFeatureValue)value).isNullValue()) {
                this.multipleFeatureValue.addFeatureValue(this.parentFeature.getSymbolTable().getSymbolStringToCode(((MultipleFeatureValue)value).getFirstSymbol()), ((MultipleFeatureValue)value).getFirstSymbol(), true);
                this.multipleFeatureValue.setNullValue(true);
            } else {
                for (String symbol : ((MultipleFeatureValue)value).getSymbols()) {
                    String[] items;
                    try {
                        items = this.separatorsPattern.split(symbol);
                    }
                    catch (PatternSyntaxException e) {
                        throw new FeatureException("The split feature '" + this.toString() + "' could not split the value using the following separators '" + this.separators + "'", e);
                    }
                    for (int i = 0; i < items.length; ++i) {
                        this.multipleFeatureValue.addFeatureValue(this.table.addSymbol(items[i]), items[i], this.table.getKnown(items[i]));
                    }
                    this.multipleFeatureValue.setNullValue(false);
                }
            }
        }
    }

    @Override
    public void updateCardinality() throws MaltChainedException {
        this.parentFeature.updateCardinality();
        this.multipleFeatureValue.setCardinality(this.table.getValueCounter());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public FeatureFunction getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(FeatureFunction parentFeature) {
        this.parentFeature = parentFeature;
    }

    public String getSeparators() {
        return this.separators;
    }

    public void setSeparators(String separators) {
        this.separators = separators;
        this.separatorsPattern = Pattern.compile(separators);
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Split(");
        sb.append(this.parentFeature.toString());
        sb.append(", ");
        sb.append(this.separators);
        sb.append(')');
        return sb.toString();
    }
}

