/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.covington;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.ParsingException;
import org.maltparser.parser.algorithm.covington.CovingtonConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovingtonAddressFunction
extends AddressFunction {
    protected String subFunctionName;
    protected CovingtonSubFunction subFunction;
    protected Algorithm parsingAlgorithm;
    protected int index;

    public CovingtonAddressFunction(String subFunctionName, Algorithm parsingAlgorithm) {
        this.setSubFunctionName(subFunctionName);
        this.setAlgorithm(parsingAlgorithm);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1) {
            throw new ParsingException("Could not initialize " + this.getClass().getName() + ": number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof Integer)) {
            throw new ParsingException("Could not initialize " + this.getClass().getName() + ": the first argument is not an integer. ");
        }
        this.setIndex((Integer)arguments[0]);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{Integer.class};
        return paramTypes;
    }

    @Override
    public void update() throws MaltChainedException {
        this.update((CovingtonConfig)this.parsingAlgorithm.getCurrentParserConfiguration());
    }

    @Override
    public void update(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1 || !(arguments[0] instanceof CovingtonConfig)) {
            throw new ParsingException("Number of arguments to the Covington address function is not correct. ");
        }
        this.update((CovingtonConfig)arguments[0]);
    }

    private void update(CovingtonConfig config) throws MaltChainedException {
        if (this.subFunction == CovingtonSubFunction.LEFT) {
            this.address.setAddress(config.getLeftNode(this.index));
        } else if (this.subFunction == CovingtonSubFunction.RIGHT) {
            this.address.setAddress(config.getRightNode(this.index));
        } else if (this.subFunction == CovingtonSubFunction.LEFTCONTEXT) {
            this.address.setAddress(config.getLeftContextNode(this.index));
        } else if (this.subFunction == CovingtonSubFunction.RIGHTCONTEXT) {
            this.address.setAddress(config.getRightContextNode(this.index));
        } else {
            this.address.setAddress(null);
        }
    }

    public String getSubFunctionName() {
        return this.subFunctionName;
    }

    public void setSubFunctionName(String subFunctionName) {
        this.subFunctionName = subFunctionName;
        this.subFunction = CovingtonSubFunction.valueOf(subFunctionName.toUpperCase());
    }

    public CovingtonSubFunction getSubFunction() {
        return this.subFunction;
    }

    @Override
    public AddressValue getAddressValue() {
        return this.address;
    }

    public Algorithm getParsingAlgorithm() {
        return this.parsingAlgorithm;
    }

    public void setAlgorithm(Algorithm parsingAlgorithm) {
        this.parsingAlgorithm = parsingAlgorithm;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CovingtonAddressFunction other = (CovingtonAddressFunction)obj;
        if (this.index != other.index) {
            return false;
        }
        if (this.parsingAlgorithm == null ? other.parsingAlgorithm != null : !this.parsingAlgorithm.equals(other.parsingAlgorithm)) {
            return false;
        }
        return !(this.subFunction == null ? other.subFunction != null : !this.subFunction.equals((Object)other.subFunction));
    }

    @Override
    public String toString() {
        return this.subFunctionName + "[" + this.index + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CovingtonSubFunction {
        LEFT,
        RIGHT,
        LEFTCONTEXT,
        RIGHTCONTEXT;

    }
}

