# Generated by default/object.tt
package Paws::EMRContainers::ContainerProvider;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has Info => (is => 'ro', isa => 'Paws::EMRContainers::ContainerInfo', request_name => 'info', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMRContainers::ContainerProvider

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMRContainers::ContainerProvider object:

  $service_obj->Method(Att1 => { Id => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMRContainers::ContainerProvider object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

The information about the container provider.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The ID of the container cluster.


=head2 Info => L<Paws::EMRContainers::ContainerInfo>

The information about the container cluster.


=head2 B<REQUIRED> Type => Str

The type of the container provider. EKS is the only supported type as
of now.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMRContainers>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

