# This Makefile.PL for CXC-PDL-Bin1D was generated by
# inc::MyMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use PDL::Core::Dev;
use File::Spec::Functions qw( catfile );
our @dirh = qw( lib CXC PDL );
our @pprec = ( catfile( @dirh, 'Bin1D.pd' ), 'Bin1D', 'CXC::PDL::Bin1D' );

our @deps = map { catfile( @dirh, $_ ) } qw(
  bin_adaptive_snr.c
  bin_adaptive_snr.pl
  bin_on_index.c
  bin_on_index.pl
);

my %PDL_WriteMakefileArgs = (
    pdlpp_stdargs( \@pprec ),
    NO_MYMETA => 0,
    PM        => {
        catfile( @dirh, 'Bin1D', 'Utils.pm' ) =>
          catfile( '$(INST_LIB)', 'CXC', 'PDL', 'Bin1D', 'Utils.pm' ),
        'Bin1D.pm' => catfile( '$(INST_LIB)', 'CXC', 'PDL', 'Bin1D.pm'),
    },
);

my %WriteMakefileArgs = (
  "ABSTRACT" => "one dimensional binning functions",
  "AUTHOR" => "Diab Jerius <djerius\@cpan.org>",
  "BUILD_REQUIRES" => {
    "String::Interpolate::RE" => "0.09",
    "Text::Template::LocalVars" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "PDL" => "2.017"
  },
  "DISTNAME" => "CXC-PDL-Bin1D",
  "LICENSE" => "gpl",
  "NAME" => "CXC::PDL::Bin1D",
  "PREREQ_PM" => {
    "Hash::Wrap" => "0.13",
    "PDL" => "2.017",
    "Type::Params" => "1.003",
    "Types::Common::Numeric" => 0,
    "Types::PDL" => "0.03",
    "Types::Standard" => 0,
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Class::Tiny" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Hash::Wrap" => "0.13",
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Math::BigFloat" => 0,
    "PDL" => "2.017",
    "Safe::Isa" => 0,
    "Set::Product" => 0,
    "Test2::Tools::PDL" => "0.0004",
    "Test2::V0" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.27",
  "test" => {
    "TESTS" => "t/*.t t/Bin1D/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %PDL_WriteMakefileArgs,
);

my %FallbackPrereqs = (
  "Class::Tiny" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "Hash::Wrap" => "0.13",
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Math::BigFloat" => 0,
  "PDL" => "2.017",
  "Safe::Isa" => 0,
  "Set::Product" => 0,
  "String::Interpolate::RE" => "0.09",
  "Test2::Tools::PDL" => "0.0004",
  "Test2::V0" => 0,
  "Test::More" => 0,
  "Text::Template::LocalVars" => 0,
  "Type::Params" => "1.003",
  "Types::Common::Numeric" => 0,
  "Types::PDL" => "0.03",
  "Types::Standard" => 0,
  "namespace::clean" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub MY::postamble {
    my $postamble = pdlpp_postamble( \@pprec );
    # make Bin1D.pm depend upon all of its included files
    $postamble =~ s/^(Bin1D.pm:.*)/$1 @{[ join q[ ], @deps]}/m;
    return $postamble;
};
