# Generated by default/object.tt
package Paws::Quicksight::CredentialPair;
  use Moose;
  has AlternateDataSourceParameters => (is => 'ro', isa => 'ArrayRef[Paws::Quicksight::DataSourceParameters]');
  has Password => (is => 'ro', isa => 'Str', required => 1);
  has Username => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::CredentialPair

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::CredentialPair object:

  $service_obj->Method(Att1 => { AlternateDataSourceParameters => $value, ..., Username => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::CredentialPair object:

  $result = $service_obj->Method(...);
  $result->Att1->AlternateDataSourceParameters

=head1 DESCRIPTION

The combination of user name and password that are used as credentials.

=head1 ATTRIBUTES


=head2 AlternateDataSourceParameters => ArrayRef[L<Paws::Quicksight::DataSourceParameters>]

A set of alternate data source parameters that you want to share for
these credentials. The credentials are applied in tandem with the data
source parameters when you copy a data source by using a create or
update request. The API operation compares the C<DataSourceParameters>
structure that's in the request with the structures in the
C<AlternateDataSourceParameters> allow list. If the structures are an
exact match, the request is allowed to use the new data source with the
existing credentials. If the C<AlternateDataSourceParameters> list is
null, the C<DataSourceParameters> originally used with these
C<Credentials> is automatically allowed.


=head2 B<REQUIRED> Password => Str

Password.


=head2 B<REQUIRED> Username => Str

User name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

