# Generated by default/object.tt
package Paws::Rekognition::ProtectiveEquipmentPerson;
  use Moose;
  has BodyParts => (is => 'ro', isa => 'ArrayRef[Paws::Rekognition::ProtectiveEquipmentBodyPart]');
  has BoundingBox => (is => 'ro', isa => 'Paws::Rekognition::BoundingBox');
  has Confidence => (is => 'ro', isa => 'Num');
  has Id => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::ProtectiveEquipmentPerson

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::ProtectiveEquipmentPerson object:

  $service_obj->Method(Att1 => { BodyParts => $value, ..., Id => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::ProtectiveEquipmentPerson object:

  $result = $service_obj->Method(...);
  $result->Att1->BodyParts

=head1 DESCRIPTION

A person detected by a call to DetectProtectiveEquipment. The API
returns all persons detected in the input image in an array of
C<ProtectiveEquipmentPerson> objects.

=head1 ATTRIBUTES


=head2 BodyParts => ArrayRef[L<Paws::Rekognition::ProtectiveEquipmentBodyPart>]

An array of body parts detected on a person's body (including body
parts without PPE).


=head2 BoundingBox => L<Paws::Rekognition::BoundingBox>

A bounding box around the detected person.


=head2 Confidence => Num

The confidence that Amazon Rekognition has that the bounding box
contains a person.


=head2 Id => Int

The identifier for the detected person. The identifier is only unique
for a single call to C<DetectProtectiveEquipment>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

