# Generated by default/object.tt
package Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate;
  use Moose;
  has CertificateChain => (is => 'ro', isa => 'Str', request_name => 'certificateChain', traits => ['NameInRequest'], required => 1);
  has PrivateKey => (is => 'ro', isa => 'Str', request_name => 'privateKey', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate object:

  $service_obj->Method(Att1 => { CertificateChain => $value, ..., PrivateKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::VirtualGatewayListenerTlsFileCertificate object:

  $result = $service_obj->Method(...);
  $result->Att1->CertificateChain

=head1 DESCRIPTION

An object that represents a local file certificate. The certificate
must meet specific requirements and you must have proxy authorization
enabled. For more information, see Transport Layer Security (TLS)
(https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites).

=head1 ATTRIBUTES


=head2 B<REQUIRED> CertificateChain => Str

The certificate chain for the certificate.


=head2 B<REQUIRED> PrivateKey => Str

The private key for a certificate stored on the file system of the mesh
endpoint that the proxy is running on.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

