# Generated by default/object.tt
package Paws::IoT::KafkaAction;
  use Moose;
  has ClientProperties => (is => 'ro', isa => 'Paws::IoT::ClientProperties', request_name => 'clientProperties', traits => ['NameInRequest'], required => 1);
  has DestinationArn => (is => 'ro', isa => 'Str', request_name => 'destinationArn', traits => ['NameInRequest'], required => 1);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Partition => (is => 'ro', isa => 'Str', request_name => 'partition', traits => ['NameInRequest']);
  has Topic => (is => 'ro', isa => 'Str', request_name => 'topic', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::KafkaAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::KafkaAction object:

  $service_obj->Method(Att1 => { ClientProperties => $value, ..., Topic => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::KafkaAction object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientProperties

=head1 DESCRIPTION

Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon
MSK) or self-managed Apache Kafka cluster.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ClientProperties => L<Paws::IoT::ClientProperties>

Properties of the Apache Kafka producer client.


=head2 B<REQUIRED> DestinationArn => Str

The ARN of Kafka action's VPC C<TopicRuleDestination>.


=head2 Key => Str

The Kafka message key.


=head2 Partition => Str

The Kafka message partition.


=head2 B<REQUIRED> Topic => Str

The Kafka topic for messages to be sent to the Kafka broker.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

