# Generated by default/object.tt
package Paws::FMS::ResourceViolation;
  use Moose;
  has AwsEc2InstanceViolation => (is => 'ro', isa => 'Paws::FMS::AwsEc2InstanceViolation');
  has AwsEc2NetworkInterfaceViolation => (is => 'ro', isa => 'Paws::FMS::AwsEc2NetworkInterfaceViolation');
  has AwsVPCSecurityGroupViolation => (is => 'ro', isa => 'Paws::FMS::AwsVPCSecurityGroupViolation');
  has DnsDuplicateRuleGroupViolation => (is => 'ro', isa => 'Paws::FMS::DnsDuplicateRuleGroupViolation');
  has DnsRuleGroupLimitExceededViolation => (is => 'ro', isa => 'Paws::FMS::DnsRuleGroupLimitExceededViolation');
  has DnsRuleGroupPriorityConflictViolation => (is => 'ro', isa => 'Paws::FMS::DnsRuleGroupPriorityConflictViolation');
  has NetworkFirewallMissingExpectedRTViolation => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallMissingExpectedRTViolation');
  has NetworkFirewallMissingFirewallViolation => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallMissingFirewallViolation');
  has NetworkFirewallMissingSubnetViolation => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallMissingSubnetViolation');
  has NetworkFirewallPolicyModifiedViolation => (is => 'ro', isa => 'Paws::FMS::NetworkFirewallPolicyModifiedViolation');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FMS::ResourceViolation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FMS::ResourceViolation object:

  $service_obj->Method(Att1 => { AwsEc2InstanceViolation => $value, ..., NetworkFirewallPolicyModifiedViolation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FMS::ResourceViolation object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsEc2InstanceViolation

=head1 DESCRIPTION

Violation detail based on resource type.

=head1 ATTRIBUTES


=head2 AwsEc2InstanceViolation => L<Paws::FMS::AwsEc2InstanceViolation>

Violation details for an EC2 instance.


=head2 AwsEc2NetworkInterfaceViolation => L<Paws::FMS::AwsEc2NetworkInterfaceViolation>

Violation details for network interface.


=head2 AwsVPCSecurityGroupViolation => L<Paws::FMS::AwsVPCSecurityGroupViolation>

Violation details for security groups.


=head2 DnsDuplicateRuleGroupViolation => L<Paws::FMS::DnsDuplicateRuleGroupViolation>

Violation detail for a DNS Firewall policy that indicates that a rule
group that Firewall Manager tried to associate with a VPC is already
associated with the VPC and can't be associated again.


=head2 DnsRuleGroupLimitExceededViolation => L<Paws::FMS::DnsRuleGroupLimitExceededViolation>

Violation details for a DNS Firewall policy that indicates that the VPC
reached the limit for associated DNS Firewall rule groups. Firewall
Manager tried to associate another rule group with the VPC and failed.


=head2 DnsRuleGroupPriorityConflictViolation => L<Paws::FMS::DnsRuleGroupPriorityConflictViolation>

Violation detail for a DNS Firewall policy that indicates that a rule
group that Firewall Manager tried to associate with a VPC has the same
priority as a rule group that's already associated.


=head2 NetworkFirewallMissingExpectedRTViolation => L<Paws::FMS::NetworkFirewallMissingExpectedRTViolation>

Violation detail for an Network Firewall policy that indicates that a
subnet is not associated with the expected Firewall Manager managed
route table.


=head2 NetworkFirewallMissingFirewallViolation => L<Paws::FMS::NetworkFirewallMissingFirewallViolation>

Violation detail for an Network Firewall policy that indicates that a
subnet has no Firewall Manager managed firewall in its VPC.


=head2 NetworkFirewallMissingSubnetViolation => L<Paws::FMS::NetworkFirewallMissingSubnetViolation>

Violation detail for an Network Firewall policy that indicates that an
Availability Zone is missing the expected Firewall Manager managed
subnet.


=head2 NetworkFirewallPolicyModifiedViolation => L<Paws::FMS::NetworkFirewallPolicyModifiedViolation>

Violation detail for an Network Firewall policy that indicates that a
firewall policy in an individual account has been modified in a way
that makes it noncompliant. For example, the individual account owner
might have deleted a rule group, changed the priority of a stateless
rule group, or changed a policy default action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

