package Shipment::UPS::WSDL::ShipTypes::BillReceiverType;
$Shipment::UPS::WSDL::ShipTypes::BillReceiverType::VERSION = '3.02';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %AccountNumber_of : ATTR(:get<AccountNumber>);
    my %Address_of : ATTR(:get<Address>);

    __PACKAGE__->_factory(
        [   qw(        AccountNumber
              Address

              )
        ],
        {   'AccountNumber' => \%AccountNumber_of,
            'Address'       => \%Address_of,
        },
        {   'AccountNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Address' =>
              'Shipment::UPS::WSDL::ShipTypes::BillReceiverAddressType',
        },
        {

            'AccountNumber' => 'AccountNumber',
            'Address'       => 'Address',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::BillReceiverType

=head1 VERSION

version 3.02

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
BillReceiverType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AccountNumber (min/maxOccurs: 1/1)

=item * Address (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::BillReceiverType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::ShipTypes::BillReceiverType
   AccountNumber =>  $some_value, # string
   Address =>  { # Shipment::UPS::WSDL::ShipTypes::BillReceiverAddressType
     PostalCode =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
