package Shipment::Purolator::WSDLV2::Types::GetFullEstimateResponseContainer;
$Shipment::Purolator::WSDLV2::Types::GetFullEstimateResponseContainer::VERSION = '3.10';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://purolator.com/pws/datatypes/v2' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Shipment::Purolator::WSDLV2::Types::ResponseContainer);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ResponseInformation_of :ATTR(:get<ResponseInformation>);
my %ShipmentEstimates_of :ATTR(:get<ShipmentEstimates>);
my %ReturnShipmentEstimates_of :ATTR(:get<ReturnShipmentEstimates>);

__PACKAGE__->_factory(
    [ qw(        ResponseInformation
        ShipmentEstimates
        ReturnShipmentEstimates

    ) ],
    {
        'ResponseInformation' => \%ResponseInformation_of,
        'ShipmentEstimates' => \%ShipmentEstimates_of,
        'ReturnShipmentEstimates' => \%ReturnShipmentEstimates_of,
    },
    {
        'ResponseInformation' => 'Shipment::Purolator::WSDLV2::Types::ResponseInformation',
        'ShipmentEstimates' => 'Shipment::Purolator::WSDLV2::Types::ArrayOfShipmentEstimate',
        'ReturnShipmentEstimates' => 'Shipment::Purolator::WSDLV2::Types::ArrayOfShipmentEstimate',
    },
    {

        'ResponseInformation' => 'ResponseInformation',
        'ShipmentEstimates' => 'ShipmentEstimates',
        'ReturnShipmentEstimates' => 'ReturnShipmentEstimates',
    }
);

} # end BLOCK







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::Purolator::WSDLV2::Types::GetFullEstimateResponseContainer

=head1 VERSION

version 3.10

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GetFullEstimateResponseContainer from the namespace http://purolator.com/pws/datatypes/v2.

GetFullEstimateResponse

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ShipmentEstimates (min/maxOccurs: 0/1)

=item * ReturnShipmentEstimates (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::Purolator::WSDLV2::Types::GetFullEstimateResponseContainer

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::Purolator::WSDLV2::Types::GetFullEstimateResponseContainer
   ShipmentEstimates =>  { # Shipment::Purolator::WSDLV2::Types::ArrayOfShipmentEstimate
     ShipmentEstimate =>  { # Shipment::Purolator::WSDLV2::Types::ShipmentEstimate
       ServiceID =>  $some_value, # string
       ShipmentDate =>  $some_value, # string
       ExpectedDeliveryDate =>  $some_value, # string
       EstimatedTransitDays =>  $some_value, # int
       BasePrice =>  $some_value, # decimal
       Surcharges =>  { # Shipment::Purolator::WSDLV2::Types::ArrayOfSurcharge
         Surcharge =>  { # Shipment::Purolator::WSDLV2::Types::Surcharge
           Amount =>  $some_value, # decimal
           Type =>  $some_value, # string
           Description =>  $some_value, # string
         },
       },
       Taxes =>  { # Shipment::Purolator::WSDLV2::Types::ArrayOfTax
         Tax =>  { # Shipment::Purolator::WSDLV2::Types::Tax
           Amount =>  $some_value, # decimal
           Type =>  $some_value, # string
           Description =>  $some_value, # string
         },
       },
       OptionPrices =>  { # Shipment::Purolator::WSDLV2::Types::ArrayOfOptionPrice
         OptionPrice =>  { # Shipment::Purolator::WSDLV2::Types::OptionPrice
           Amount =>  $some_value, # decimal
           ID =>  $some_value, # string
           Description =>  $some_value, # string
         },
       },
       TotalPrice =>  $some_value, # decimal
     },
   },
   ReturnShipmentEstimates => {}, # Shipment::Purolator::WSDLV2::Types::ArrayOfShipmentEstimate
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
