package Net::Async::Graphite::Async;

our $VERSION = '0.1_1';

=head1 NAME

Net::Async::Graphite::Async - The IO::Async loop.

=head1 SYNOPSIS

    with 'Net::Async::Graphite::Async';

=head1 DESCRIPTION

Don't use this module directly, use L<Net::Async::Graphite> and create
objects using its C<new> method in the normal way. Those objects will
include the functionality documented here.

This role brings the capacity to interact with the main
L<IO::Async::Loop> object.

=head1 BUGS

This is probably pointless and should at least be renamed.

=cut

use v5.14;
use strictures 2;
use Moo::Role;
use Carp;

use IO::Async::Loop;
use namespace::clean;

=head1 ROLE

This role is probably pointless now that this module isn't part of a
larger project.

=head1 ATTRIBUTES

=over

=item _loop (read-only)

An internal reference to the L<IO::Async> loop.

=cut

has _loop => is => lazy => init_arg => undef, builder => sub {
  IO::Async::Loop->new;
};

1;

=back

=head1 SEE ALSO

L<Net::Async::Graphite>

L<IO::Async>

L<Moo>

=head1 AUTHOR

Matthew King <matthew.king@cloudbeds.com>

=cut
