#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::Tools::Hardware;
use FusionInventory::Test::Hardware;

my %tests = (
    'nortel/4548GT-PWR.walk' => [
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Ethernet Routing Switch 4548GT-PWR    HW:06       FW:5.2.0.3   SW:v5.2.0.008 BN:08 (c) Nortel Networks',
            SNMPHOSTNAME => '4548_DOULEUR',
            MAC          => 'e8:05:6d:27:5c:02',
            MODEL        => 'Ethernet Routing Switch 4548GT-PWR',
        },
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Ethernet Routing Switch 4548GT-PWR    HW:06       FW:5.2.0.3   SW:v5.2.0.008 BN:08 (c) Nortel Networks',
            SNMPHOSTNAME => '4548_DOULEUR',
            MAC          => 'e8:05:6d:27:5c:02',
            MODEL        => 'Ethernet Routing Switch 4548GT-PWR',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Nortel',
                TYPE         => 'NETWORKING',
                MODEL        => 'Ethernet Routing Switch 4548GT-PWR',
                COMMENTS     => 'Ethernet Routing Switch 4548GT-PWR    HW:06       FW:5.2.0.3   SW:v5.2.0.008 BN:08 (c) Nortel Networks',
                CONTACT      => 'Service Informatique',
                NAME         => '4548_DOULEUR',
                LOCATION     => 'Tour B - 1er - DOULEUR',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 1  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 1  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 2  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 2  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 3  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 3  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 4  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 4  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 5  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 5  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 6  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 6  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 7  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 7  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 8  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 8  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 9  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 9  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 10  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 10  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 11  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 11  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(113548719) 13 days, 3:24:47.19',
                        IFINOCTETS       => '8387793',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1051638929',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:b7:fc:0b:4a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 12  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 12  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(131943444) 15 days, 6:30:34.44',
                        IFINOCTETS       => '35650992',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1402372525',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:dd:26:5b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 13  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 13  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 14  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 14  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 15  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 15  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 16  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 16  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 17  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 17  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 18  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 18  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 19  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 19  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 20  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 20  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 21  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 21  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(16230) 0:02:42.30',
                        IFINOCTETS       => '711456473',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1483892414',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0f:fe:58:b5:78',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 22  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 22  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 23  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 23  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(114521519) 13 days, 6:06:55.19',
                        IFINOCTETS       => '1048462064',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3306682979',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:1a:64:3a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 24  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 24  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(134346744) 15 days, 13:11:07.44',
                        IFINOCTETS       => '585419140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2250499601',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 25  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 25  ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(133838350) 15 days, 11:46:23.50',
                        IFINOCTETS       => '962346553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3360469774',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 26  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 26  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(113678775) 13 days, 3:46:27.75',
                        IFINOCTETS       => '712651549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3578746593',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0f:fe:78:7e:a1',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 27  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 27  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 28  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 28  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 29  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 29  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 30  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 30  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 31  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 31  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 32  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 32  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 33  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 33  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 34  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 34  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 35  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 35  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(134593525) 15 days, 13:52:15.25',
                        IFINOCTETS       => '23245253',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '603867627',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 36  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 36  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 37  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 37  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(134141850) 15 days, 12:36:58.50',
                        IFINOCTETS       => '3032883969',
                        IFINERRORS       => '48',
                        IFOUTOCTETS      => '198684286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 38  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 38  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(79183975) 9 days, 3:57:19.75',
                        IFINOCTETS       => '8094681',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1215255295',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 39  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 39  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 40  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 40  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 41  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 41  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 42  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 42  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 43  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 43  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 44  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 44  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 45  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 45  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 46  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 46  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 47  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 47  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(14471) 0:02:24.71',
                        IFINOCTETS       => '1801559026',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1325560369',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:7e:8c:ef',
                                    '00:00:0c:07:ac:65',
                                    '00:00:aa:c3:a5:ff',
                                    '00:00:aa:c3:a6:ec',
                                    '00:00:aa:c3:a7:2d',
                                    '00:00:aa:c3:ad:7b',
                                    '00:00:aa:c3:ae:9d',
                                    '00:00:aa:c3:ae:5a',
                                    '00:00:aa:d0:24:ae',
                                    '00:00:aa:d5:b6:2e',
                                    '00:00:aa:d7:e0:f6',
                                    '00:00:aa:d7:e0:56',
                                    '00:00:5e:00:01:01',
                                    '00:00:5e:00:01:0d',
                                    '00:00:5e:00:01:86',
                                    '00:00:5e:00:01:11',
                                    '00:00:5e:00:01:19',
                                    '00:00:5e:00:01:1a',
                                    '00:00:5e:00:01:28',
                                    '00:00:5e:00:01:2c',
                                    '00:01:6f:02:02:d4',
                                    '00:01:da:f0:e2:2d',
                                    '00:01:03:07:9e:8d',
                                    '00:01:29:04:ac:ea',
                                    '00:0b:cd:1b:5f:53',
                                    '00:80:64:48:08:c9',
                                    '00:80:77:93:bc:68',
                                    '00:80:77:93:bc:6e',
                                    '00:80:77:93:bc:75',
                                    '00:80:77:93:bc:7b',
                                    '00:80:77:93:bc:16',
                                    '00:80:77:93:bc:21',
                                    '00:80:77:93:bc:41',
                                    '00:80:77:93:bc:42',
                                    '00:80:77:93:bc:46',
                                    '00:80:77:93:bc:59',
                                    '00:80:77:93:bc:5a',
                                    '00:80:77:93:bc:5d',
                                    '00:80:77:93:bd:ad',
                                    '00:80:77:93:bd:bd',
                                    '00:80:77:93:bd:c3',
                                    '00:80:77:93:bf:0b',
                                    '00:80:77:93:bf:a6',
                                    '00:80:77:94:0c:35',
                                    '00:80:77:94:0d:d3',
                                    '00:80:77:94:0d:e8',
                                    '00:80:77:94:0e:69',
                                    '00:80:77:94:0e:6b',
                                    '00:80:77:94:0e:c7',
                                    '00:80:77:94:0e:ca',
                                    '00:80:77:94:0e:dd',
                                    '00:80:77:94:0f:ee',
                                    '00:80:77:94:0f:40',
                                    '00:80:77:94:10:76',
                                    '00:80:77:94:10:83',
                                    '00:80:77:94:10:89',
                                    '00:80:77:94:10:92',
                                    '00:80:77:94:2e:d6',
                                    '00:80:77:94:2f:74',
                                    '00:80:77:94:2f:7b',
                                    '00:80:77:94:2f:85',
                                    '00:80:77:94:2f:89',
                                    '00:80:77:94:2f:9c',
                                    '00:80:77:94:2f:ea',
                                    '00:80:77:94:2f:50',
                                    '00:80:77:94:30:e4',
                                    '00:80:77:94:30:18',
                                    '00:80:77:94:30:f6',
                                    '00:80:77:94:31:c8',
                                    '00:80:77:e7:12:65',
                                    '00:80:77:e7:20:ae',
                                    '00:80:77:e7:20:63',
                                    '00:80:77:e7:21:64',
                                    '00:80:77:e7:21:74',
                                    '00:80:77:e7:21:96',
                                    '00:80:77:e7:21:cd',
                                    '00:80:77:e7:21:db',
                                    '00:80:77:e7:21:e3',
                                    '00:80:77:e7:21:3a',
                                    '00:80:77:e7:21:5f',
                                    '00:80:77:e7:43:c2',
                                    '00:80:77:e7:43:ec',
                                    '00:80:77:e7:44:71',
                                    '00:80:77:e7:44:df',
                                    '00:80:77:e7:45:3c',
                                    '00:80:77:e7:47:72',
                                    '00:80:77:38:d2:11',
                                    '00:80:77:39:71:ce',
                                    '00:80:77:39:53:5b',
                                    '00:80:77:39:58:01',
                                    '00:80:77:39:58:6b',
                                    '00:80:77:39:59:56',
                                    '00:80:77:3c:2a:74',
                                    '00:80:91:7d:ab:25',
                                    '00:80:42:12:3d:80',
                                    '00:0e:0c:72:6e:12',
                                    '00:0e:0c:38:75:38',
                                    '00:0e:7f:ac:86:c0',
                                    '00:0e:7f:ac:8e:7d',
                                    '00:0e:7f:ac:1d:cc',
                                    '00:0e:7f:ac:1d:d4',
                                    '00:0e:7f:af:4d:c8',
                                    '00:0e:7f:b1:46:c1',
                                    '00:90:e8:04:8f:0c',
                                    '00:0f:cd:c2:05:00',
                                    '00:0f:fe:78:74:a7',
                                    '00:0f:fe:78:74:1f',
                                    '00:0f:fe:78:7e:93',
                                    '00:0f:fe:79:45:1c',
                                    '00:0f:fe:7c:a0:a7',
                                    '00:0f:fe:7c:a3:0b',
                                    '00:0f:fe:58:d3:f6',
                                    '00:0f:fe:58:d5:4a',
                                    '00:0f:fe:58:f6:76',
                                    '00:0f:fe:58:f9:7a',
                                    '00:0f:20:79:bf:d3',
                                    '00:0f:20:79:bf:5d',
                                    '00:10:18:10:0e:26',
                                    '00:10:18:10:26:74',
                                    '00:a0:98:0f:88:5a',
                                    '00:a0:98:10:19:04',
                                    '00:a0:98:10:4a:1a',
                                    '00:11:0a:36:c9:29',
                                    '00:11:85:81:50:82',
                                    '00:11:85:bc:24:43',
                                    '00:11:85:bc:2f:09',
                                    '00:11:43:b5:0d:42',
                                    '00:11:43:ba:a9:ac',
                                    '00:11:43:bb:9f:d1',
                                    '00:12:79:ce:9d:68',
                                    '00:c0:b7:6f:5f:06',
                                    '00:c0:b7:71:94:cb',
                                    '00:c0:b7:7a:e8:84',
                                    '00:02:a5:45:9f:b1',
                                    '00:02:a5:46:2c:6b',
                                    '00:14:0b:80:4f:17',
                                    '00:14:22:59:0d:91',
                                    '00:14:38:eb:34:a4',
                                    '00:14:38:eb:44:15',
                                    '00:14:5e:e1:bc:24',
                                    '00:14:5e:e1:c7:a2',
                                    '00:15:99:6b:1f:d4',
                                    '00:15:99:79:17:ea',
                                    '00:15:99:79:18:57',
                                    '00:15:99:79:31:96',
                                    '00:15:99:d7:21:eb',
                                    '00:15:99:d7:21:5e',
                                    '00:15:17:ca:48:73',
                                    '00:15:17:27:2c:0a',
                                    '00:15:17:51:af:e7',
                                    '00:15:60:95:7a:ea',
                                    '00:15:60:10:a5:3f',
                                    '00:16:17:64:0a:62',
                                    '00:16:ec:6e:5c:87',
                                    '00:e0:81:b6:58:ce',
                                    '00:e0:db:0a:00:d9',
                                    '00:e0:f4:21:3e:8e',
                                    '00:e0:f4:21:3e:ba',
                                    '00:e0:27:08:03:fb',
                                    '00:17:0e:25:3b:1a',
                                    '00:17:c5:ca:d1:21',
                                    '00:19:99:68:b1:00',
                                    '00:19:99:6d:73:17',
                                    '00:19:99:16:d9:27',
                                    '00:19:bb:55:ee:cb',
                                    '00:19:d1:86:00:5f',
                                    '00:1a:4b:1a:88:d5',
                                    '00:1a:4b:1a:88:e9',
                                    '00:1a:4b:1a:98:67',
                                    '00:1a:4b:1a:a8:90',
                                    '00:1a:4b:1a:b8:f1',
                                    '00:1a:4b:26:a2:e3',
                                    '00:1b:78:7b:fe:f0',
                                    '00:1b:8b:a4:3d:fe',
                                    '00:1b:8b:a4:3e:a9',
                                    '00:1b:8b:a4:3f:a2',
                                    '00:1b:8b:a4:3f:b8',
                                    '00:1b:8b:a4:3f:4e',
                                    '00:1b:8b:a4:40:04',
                                    '00:1b:8b:a4:46:35',
                                    '00:1b:8b:a4:46:54',
                                    '00:1b:a9:93:d7:0e',
                                    '00:1b:a9:93:d7:22',
                                    '00:1b:a9:93:d7:38',
                                    '00:1b:a9:f0:64:ef',
                                    '00:1b:a9:30:01:06',
                                    '00:1b:a9:56:d0:cd',
                                    '00:1b:a9:56:d1:9e',
                                    '00:1b:a9:56:d1:b2',
                                    '00:1b:a9:56:d1:bd',
                                    '00:1b:a9:56:d1:cf',
                                    '00:1b:a9:56:d2:65',
                                    '00:1b:a9:60:ca:c5',
                                    '00:1b:a9:60:ca:ca',
                                    '00:1b:a9:60:ca:cd',
                                    '00:1b:bf:a5:eb:1b',
                                    '00:1c:c0:6e:14:ec',
                                    '00:1c:c0:4d:b1:a5',
                                    '00:1c:23:e3:0c:c7',
                                    '00:1d:70:fa:4f:ae',
                                    '00:1d:70:fa:50:be',
                                    '00:1d:70:fa:50:18',
                                    '00:1d:70:30:00:a0',
                                    '00:1d:92:e4:b9:f6',
                                    '00:1e:0b:da:38:92',
                                    '00:1e:0b:da:38:94',
                                    '00:1e:bd:1f:87:98',
                                    '00:1e:bd:1f:8d:18',
                                    '00:1e:58:9a:87:4e',
                                    '00:1f:c6:3b:c9:64',
                                    '00:1f:ca:88:eb:c4',
                                    '00:1f:ca:88:eb:c6',
                                    '00:1f:ca:2a:25:72',
                                    '00:1f:29:d9:d2:74',
                                    '00:1f:29:d9:d4:19',
                                    '00:20:6b:66:34:dc',
                                    '00:20:6b:cb:77:2e',
                                    '00:20:6b:cb:7e:b0',
                                    '00:20:6b:cb:8a:00',
                                    '00:20:6b:cb:8a:69',
                                    '00:20:6b:cb:8a:84',
                                    '00:20:6b:cb:8a:db',
                                    '00:20:6b:cb:8a:54',
                                    '00:20:6b:cb:8b:6b',
                                    '00:20:6b:cb:8b:ab',
                                    '00:20:6b:cb:8b:07',
                                    '00:20:6b:cb:8c:6a',
                                    '00:20:6b:cb:8c:bc',
                                    '00:20:6b:cb:8c:c0',
                                    '00:20:6b:cb:8c:e1',
                                    '00:20:6b:cb:8c:e4',
                                    '00:20:6b:cb:8c:e7',
                                    '00:20:6b:cb:8c:f0',
                                    '00:20:6b:cb:8d:01',
                                    '00:20:6b:cb:8d:06',
                                    '00:20:6b:cb:8f:cd',
                                    '00:20:6b:cb:8f:d2',
                                    '00:20:6b:cb:90:53',
                                    '00:20:6b:dc:f9:a8',
                                    '00:20:6b:dc:f9:b7',
                                    '00:20:6b:dc:fa:f6',
                                    '00:20:6b:dc:fa:03',
                                    '00:20:6b:dc:fa:05',
                                    '00:20:6b:dc:fb:d8',
                                    '00:20:6b:dc:fb:db',
                                    '00:20:6b:dc:fb:de',
                                    '00:20:6b:dd:21:91',
                                    '00:20:6b:dd:21:95',
                                    '00:20:6b:dd:21:9b',
                                    '00:20:6b:dd:23:00',
                                    '00:20:6b:dd:2c:ee',
                                    '00:20:6b:dd:08:b3',
                                    '00:20:6b:dd:08:5a',
                                    '00:20:6b:dd:55:f5',
                                    '00:20:6b:dd:09:1d',
                                    '00:20:4a:64:25:c5',
                                    '00:20:4a:64:26:3f',
                                    '00:20:4a:67:47:33',
                                    '00:20:4a:04:6f:b3',
                                    '00:21:70:ea:58:35',
                                    '00:21:70:f9:76:0f',
                                    '00:21:85:01:9d:f9',
                                    '00:21:b7:70:6b:3f',
                                    '00:21:b7:70:7d:66',
                                    '00:21:b7:70:7d:63',
                                    '00:21:b7:70:bb:82',
                                    '00:21:b7:70:bb:98',
                                    '00:21:b7:70:bb:aa',
                                    '00:21:b7:70:bb:da',
                                    '00:21:b7:70:c3:37',
                                    '00:21:b7:70:db:ed',
                                    '00:21:b7:70:db:4d',
                                    '00:21:b7:70:3b:a8',
                                    '00:21:b7:70:3b:28',
                                    '00:21:b7:70:3b:56',
                                    '00:21:b7:80:6b:2e',
                                    '00:21:b7:a8:a4:89',
                                    '00:21:b7:a8:a4:8e',
                                    '00:21:b7:a8:a4:11',
                                    '00:21:b7:a8:a4:b5',
                                    '00:21:b7:a8:a4:be',
                                    '00:21:b7:a8:a4:ca',
                                    '00:21:b7:a8:a4:e6',
                                    '00:21:b7:a8:a4:e9',
                                    '00:21:b7:a8:a4:fa',
                                    '00:21:b7:a8:a4:25',
                                    '00:21:b7:a8:a4:5d',
                                    '00:21:b7:a8:e4:99',
                                    '00:21:b7:a8:e4:2d',
                                    '00:21:b7:a8:e4:43',
                                    '00:21:b7:a8:e4:63',
                                    '00:21:b7:a8:24:6b',
                                    '00:21:b7:a8:24:77',
                                    '00:21:b7:a8:24:7b',
                                    '00:21:b7:c0:20:b8',
                                    '00:21:b7:02:9c:ac',
                                    '00:21:b7:02:1c:f7',
                                    '00:21:b7:d8:f0:8a',
                                    '00:21:b7:e4:a4:3b',
                                    '00:21:b7:e4:b4:84',
                                    '00:21:b7:fc:0b:70',
                                    '00:21:b7:fc:0b:a2',
                                    '00:21:b7:fc:0b:b0',
                                    '00:21:b7:fc:0b:f1',
                                    '00:21:b7:fc:0b:f9',
                                    '00:21:b7:fc:b3:bd',
                                    '00:21:b7:fc:b3:dd',
                                    '00:21:b7:fc:b3:3d',
                                    '00:21:b7:fc:f3:79',
                                    '00:21:b7:fc:f3:c1',
                                    '00:21:b7:40:27:95',
                                    '00:21:b7:40:27:a3',
                                    '00:21:b7:44:5e:87',
                                    '00:21:b7:44:5e:d3',
                                    '00:21:b7:44:5e:3b',
                                    '00:21:b7:44:5e:07',
                                    '00:21:b7:58:67:8a',
                                    '00:21:b7:58:67:9a',
                                    '00:21:b7:58:67:be',
                                    '00:21:b7:58:67:c9',
                                    '00:21:b7:58:67:d9',
                                    '00:21:b7:58:67:19',
                                    '00:21:b7:58:67:22',
                                    '00:21:b7:58:67:05',
                                    '00:21:b7:58:a7:7a',
                                    '00:21:b7:58:a7:ce',
                                    '00:21:b7:58:c7:97',
                                    '00:21:b7:58:23:45',
                                    '00:21:b7:58:27:0b',
                                    '00:21:b7:58:27:77',
                                    '00:21:b7:58:27:84',
                                    '00:21:b7:58:27:cb',
                                    '00:21:b7:58:27:33',
                                    '00:21:b7:60:8d:b4',
                                    '00:21:62:b3:6c:40',
                                    '00:21:62:b3:54:40',
                                    '00:21:62:b4:34:40',
                                    '00:21:62:b5:ac:40',
                                    '00:21:62:b6:84:40',
                                    '00:21:62:b6:e4:40',
                                    '00:21:62:b6:fc:40',
                                    '00:21:62:b6:24:40',
                                    '00:21:62:b6:48:40',
                                    '00:21:62:b7:0c:40',
                                    '00:21:62:b7:d8:40',
                                    '00:21:62:b7:1c:40',
                                    '00:22:00:92:79:01',
                                    '00:22:00:92:52:01',
                                    '00:22:90:72:d4:98',
                                    '00:22:90:5d:61:a2',
                                    '00:23:ae:aa:72:29',
                                    '00:23:ae:aa:e3:a6',
                                    '00:23:ae:ab:79:07',
                                    '00:23:ae:ab:7a:a0',
                                    '00:23:ae:ab:7d:0b',
                                    '00:23:ae:ab:7e:e2',
                                    '00:23:ae:ab:7e:e8',
                                    '00:23:ae:ac:12:9c',
                                    '00:23:04:7d:bb:8b',
                                    '00:23:04:7d:06:eb',
                                    '00:23:04:eb:8a:fe',
                                    '00:23:04:eb:8f:66',
                                    '00:23:04:eb:8f:9e',
                                    '00:23:04:eb:8f:a2',
                                    '00:23:04:eb:8f:aa',
                                    '00:23:04:eb:8f:c4',
                                    '00:23:04:eb:8f:c6',
                                    '00:23:04:eb:8f:cc',
                                    '00:23:04:eb:8f:d0',
                                    '00:23:04:eb:8f:d6',
                                    '00:23:04:eb:8f:da',
                                    '00:23:04:eb:8f:e6',
                                    '00:23:04:eb:8f:e8',
                                    '00:23:04:eb:8f:ec',
                                    '00:23:04:eb:8f:fa',
                                    '00:23:04:eb:8f:42',
                                    '00:23:04:eb:90:64',
                                    '00:23:04:eb:90:6c',
                                    '00:23:04:eb:90:6e',
                                    '00:23:04:eb:90:82',
                                    '00:23:04:eb:90:96',
                                    '00:23:04:eb:90:a2',
                                    '00:23:04:eb:90:ac',
                                    '00:23:04:eb:90:b0',
                                    '00:23:04:eb:90:be',
                                    '00:23:04:eb:90:c4',
                                    '00:23:04:eb:90:14',
                                    '00:23:04:eb:90:ec',
                                    '00:23:04:eb:90:fc',
                                    '00:23:04:eb:90:2a',
                                    '00:23:04:eb:90:3e',
                                    '00:23:04:eb:90:4e',
                                    '00:23:04:eb:90:5a',
                                    '00:23:04:eb:90:5e',
                                    '00:24:01:d4:1b:93',
                                    '00:24:8c:9b:81:4c',
                                    '00:24:c4:e6:8c:4b',
                                    '00:24:43:30:5c:40',
                                    '00:25:64:b1:25:4c',
                                    '00:25:64:b1:42:9b',
                                    '00:25:64:b1:48:a4',
                                    '00:25:64:b1:4b:11',
                                    '00:25:84:6e:4d:3c',
                                    '00:25:84:eb:3c:8a',
                                    '00:25:45:06:2a:22',
                                    '00:25:45:06:30:96',
                                    '00:25:45:06:31:96',
                                    '00:25:45:06:31:ba',
                                    '00:25:45:06:31:bc',
                                    '00:25:45:06:31:c2',
                                    '00:25:45:06:31:ca',
                                    '00:25:45:06:31:d2',
                                    '00:25:45:06:31:d6',
                                    '00:25:45:06:31:d8',
                                    '00:25:45:06:31:da',
                                    '00:25:45:06:31:e0',
                                    '00:25:45:06:31:e6',
                                    '00:25:45:06:31:ec',
                                    '00:25:45:06:31:fa',
                                    '00:25:45:06:31:1a',
                                    '00:25:45:06:31:50',
                                    '00:25:45:06:31:5e',
                                    '00:25:45:06:32:00',
                                    '00:25:45:06:32:64',
                                    '00:25:45:06:32:6a',
                                    '00:25:45:06:32:72',
                                    '00:25:45:06:32:74',
                                    '00:25:45:06:32:7a',
                                    '00:25:45:06:32:7c',
                                    '00:25:45:06:32:7e',
                                    '00:25:45:06:32:86',
                                    '00:25:45:06:32:92',
                                    '00:25:45:06:32:98',
                                    '00:25:45:06:32:9e',
                                    '00:25:45:06:32:10',
                                    '00:25:45:06:32:a0',
                                    '00:25:45:06:32:a2',
                                    '00:25:45:06:32:ac',
                                    '00:25:45:06:32:b2',
                                    '00:25:45:06:32:12',
                                    '00:25:45:06:32:b8',
                                    '00:25:45:06:32:bc',
                                    '00:25:45:06:32:c0',
                                    '00:25:45:06:32:c4',
                                    '00:25:45:06:32:02',
                                    '00:25:45:06:32:ce',
                                    '00:25:45:06:32:16',
                                    '00:25:45:06:32:e0',
                                    '00:25:45:06:32:e2',
                                    '00:25:45:06:32:e8',
                                    '00:25:45:06:32:ea',
                                    '00:25:45:06:32:f0',
                                    '00:25:45:06:32:fc',
                                    '00:25:45:06:32:1c',
                                    '00:25:45:06:32:1e',
                                    '00:25:45:06:32:22',
                                    '00:25:45:06:32:04',
                                    '00:25:45:06:32:2c',
                                    '00:25:45:06:32:2e',
                                    '00:25:45:06:32:30',
                                    '00:25:45:06:32:38',
                                    '00:25:45:06:32:3a',
                                    '00:25:45:06:32:3c',
                                    '00:25:45:06:32:3e',
                                    '00:25:45:06:32:44',
                                    '00:25:45:06:32:46',
                                    '00:25:45:06:32:08',
                                    '00:25:45:06:32:58',
                                    '00:25:45:06:32:5a',
                                    '00:25:45:06:32:60',
                                    '00:25:45:06:33:6e',
                                    '00:25:45:06:33:94',
                                    '00:25:45:06:33:96',
                                    '00:25:45:06:33:9e',
                                    '00:25:45:06:33:b0',
                                    '00:25:45:06:33:b4',
                                    '00:25:45:06:33:b6',
                                    '00:25:45:06:33:ba',
                                    '00:25:45:06:33:14',
                                    '00:25:45:06:33:c8',
                                    '00:25:45:06:33:ca',
                                    '00:25:45:06:33:ea',
                                    '00:25:45:06:33:ee',
                                    '00:25:45:06:33:18',
                                    '00:25:45:06:33:f0',
                                    '00:25:45:06:33:fe',
                                    '00:25:45:06:33:1a',
                                    '00:25:45:06:33:22',
                                    '00:25:45:06:33:24',
                                    '00:25:45:06:33:26',
                                    '00:25:45:06:33:28',
                                    '00:25:45:06:33:38',
                                    '00:25:45:06:33:40',
                                    '00:25:45:06:33:4a',
                                    '00:25:45:06:33:4c',
                                    '00:25:45:06:34:00',
                                    '00:25:45:06:34:70',
                                    '00:25:45:06:34:78',
                                    '00:25:45:06:34:02',
                                    '00:25:45:06:34:16',
                                    '00:25:45:06:34:22',
                                    '00:25:45:06:34:40',
                                    '00:25:45:06:34:08',
                                    '00:25:45:06:35:aa',
                                    '00:25:45:06:35:b0',
                                    '00:25:45:06:35:b4',
                                    '00:25:45:06:35:b8',
                                    '00:25:45:06:35:c6',
                                    '00:25:45:06:35:d4',
                                    '00:25:45:06:35:e4',
                                    '00:25:45:06:35:e6',
                                    '00:25:45:06:35:ee',
                                    '00:25:45:06:35:f6',
                                    '00:25:45:06:35:fe',
                                    '00:25:45:06:36:88',
                                    '00:25:45:06:36:28',
                                    '00:25:45:06:36:32',
                                    '00:26:0b:90:23:0e',
                                    '00:26:18:c1:73:fe',
                                    '00:27:0d:de:ac:cb',
                                    '00:27:0d:de:ad:2b',
                                    '00:27:0d:de:d8:27',
                                    '00:27:0d:de:fd:47',
                                    '00:04:00:9e:57:bf',
                                    '00:04:00:9e:5a:0e',
                                    '00:04:00:be:8c:09',
                                    '00:04:00:c7:d9:11',
                                    '00:04:00:c7:39:b0',
                                    '00:04:00:ce:42:eb',
                                    '00:04:00:de:91:e5',
                                    '00:04:00:de:97:35',
                                    '00:04:00:de:bb:64',
                                    '00:04:00:de:5a:24',
                                    '00:04:00:ee:a1:5f',
                                    '00:04:00:ee:b5:66',
                                    '00:04:00:1e:f4:00',
                                    '00:04:00:2c:3c:f4',
                                    '00:04:00:3e:70:a6',
                                    '00:04:00:3e:f0:90',
                                    '00:04:00:4e:00:c3',
                                    '00:04:00:4e:80:e6',
                                    '00:04:00:4e:cd:0e',
                                    '00:04:00:4e:cd:99',
                                    '00:04:00:4e:4d:57',
                                    '00:04:61:69:33:f4',
                                    '00:30:d3:0c:87:68',
                                    '00:30:05:a9:96:0f',
                                    '00:30:05:52:96:ed',
                                    '00:30:48:61:53:7a',
                                    '00:07:e9:76:89:84',
                                    '00:07:5f:50:16:8f',
                                    '00:08:02:91:7e:90',
                                    '00:08:02:91:81:5e',
                                    '00:08:02:91:83:41',
                                    '00:08:02:91:86:d1',
                                    '00:08:02:91:87:24',
                                    '00:50:56:7f:05:39',
                                    '00:50:56:81:0e:8e',
                                    '00:50:56:85:00:f0',
                                    '00:50:56:85:64:f6',
                                    '00:50:56:85:6d:ef',
                                    '00:50:56:85:0c:46',
                                    '00:50:56:85:7c:ae',
                                    '00:50:56:85:1b:64',
                                    '00:50:56:85:04:8b',
                                    '00:50:56:85:51:f3',
                                    '00:50:56:85:59:be',
                                    '00:50:56:b7:00:24',
                                    '00:50:56:b7:78:e3',
                                    '00:50:56:4d:df:0b',
                                    '00:60:6d:93:c7:25',
                                    '00:60:6d:1d:70:f8',
                                    '00:60:6d:1d:72:c4',
                                    '00:60:ef:0d:e4:67',
                                    '00:60:ef:0d:e4:60',
                                    '00:60:ef:07:4a:e6',
                                    '00:60:ef:07:4a:e7',
                                    '00:60:ef:07:63:cd',
                                    '00:60:ef:07:63:d1',
                                    '00:60:fb:69:38:b9',
                                    '00:60:fb:69:3d:b1',
                                    '68:b5:99:aa:65:2c',
                                    '68:05:ca:16:21:d8',
                                    '74:27:ea:35:0a:c6',
                                    '74:46:a0:90:f3:26',
                                    '78:ac:c0:ad:1e:da',
                                    '78:e7:d1:d6:ca:ca',
                                    '84:2b:2b:9b:b9:7b',
                                    '84:2b:2b:9b:d0:82',
                                    '84:2b:2b:9b:26:26',
                                    '84:2b:2b:a9:bb:55',
                                    '84:2b:2b:57:d1:19',
                                    '90:fb:5b:ab:d0:64',
                                    '90:fb:5b:ab:d2:00',
                                    '90:fb:5b:ab:d2:0a',
                                    '90:fb:5b:ab:d2:0e',
                                    '90:fb:5b:ab:d2:0f',
                                    '90:fb:5b:ab:d2:02',
                                    '90:fb:5b:ab:d2:17',
                                    '90:fb:5b:ab:d2:3c',
                                    '90:fb:5b:ab:d2:09',
                                    '90:fb:5b:b2:20:64',
                                    '90:fb:5b:b2:22:00',
                                    '90:fb:5b:b2:22:0d',
                                    '90:fb:5b:b2:22:0e',
                                    '90:fb:5b:b2:22:02',
                                    '90:fb:5b:b2:22:16',
                                    '90:fb:5b:b2:22:3c',
                                    '90:fb:5b:b2:22:07',
                                    '90:fb:5b:b2:22:09',
                                    '98:d8:8c:d7:28:40',
                                    'b4:b0:17:36:00:40',
                                    'b4:b5:2f:ba:24:7d',
                                    'b8:ac:6f:4e:39:bd',
                                    'b8:ac:6f:4e:3e:38',
                                    'b8:ac:6f:4e:40:31',
                                    'b8:ac:6f:4e:46:3d',
                                    'bc:30:5b:b5:4d:b3',
                                    'c4:7d:4f:88:df:c6',
                                    'c4:7d:4f:88:df:d0',
                                    'c4:7d:4f:88:df:e6',
                                    'c4:7d:4f:88:df:30',
                                    'c4:7d:4f:88:df:52',
                                    'c4:7d:4f:88:e0:6c',
                                    'c4:7d:4f:88:e0:6e',
                                    'c4:7d:4f:88:e0:84',
                                    'c4:7d:4f:88:e0:16',
                                    'c4:7d:4f:88:e0:46',
                                    'c4:7d:4f:88:e0:4a',
                                    'c4:7d:4f:88:e0:4c',
                                    'c4:7d:4f:88:e0:5c',
                                    'c4:7d:4f:e0:bf:98',
                                    'c4:7d:4f:e0:c3:c2',
                                    'c4:7d:4f:e0:c4:ca',
                                    'c4:7d:4f:e0:c4:dc',
                                    'c4:7d:4f:e0:c5:6e',
                                    'c4:7d:4f:e0:c5:70',
                                    'c4:7d:4f:e0:c5:72',
                                    'c4:7d:4f:e0:c5:76',
                                    'c4:7d:4f:e0:c5:80',
                                    'c4:7d:4f:e0:c5:82',
                                    'c4:7d:4f:e0:c5:84',
                                    'c4:7d:4f:e0:c5:88',
                                    'c4:7d:4f:e0:c5:8a',
                                    'c4:7d:4f:e0:c5:8e',
                                    'c4:7d:4f:e0:c5:9c',
                                    'c4:7d:4f:e0:c5:9e',
                                    'c4:7d:4f:e0:c5:b0',
                                    'c4:7d:4f:e0:c5:b8',
                                    'c4:7d:4f:e0:c5:ba',
                                    'c4:7d:4f:e0:c5:c0',
                                    'c4:7d:4f:e0:c5:c6',
                                    'c4:7d:4f:e0:c5:e4',
                                    'c4:7d:4f:e0:c5:1a',
                                    'c4:7d:4f:e0:c5:1c',
                                    'c4:7d:4f:e0:c5:3e',
                                    'c4:7d:4f:e0:c5:44',
                                    'c4:7d:4f:e0:c5:50',
                                    'c4:7d:4f:e0:c5:52',
                                    'c4:7d:4f:e0:c5:54',
                                    'c4:7d:4f:e0:c5:60',
                                    'c4:7d:4f:e0:c5:62',
                                    'c4:7d:4f:e0:c6:72',
                                    'c4:7d:4f:e0:c6:74',
                                    'c4:7d:4f:e0:c6:12',
                                    'c4:7d:4f:e0:c6:14',
                                    'c4:7d:4f:e0:c6:fe',
                                    'c4:7d:4f:e0:c6:1a',
                                    'c4:7d:4f:e0:c6:26',
                                    'c4:7d:4f:e0:c6:06',
                                    'c4:7d:4f:e0:c6:5c',
                                    'c4:7d:4f:e0:c7:72',
                                    'c4:7d:4f:e0:c7:76',
                                    'c4:7d:4f:e0:c7:7e',
                                    'c4:7d:4f:e0:c7:80',
                                    'c4:7d:4f:e0:c7:8c',
                                    'c4:7d:4f:e0:c7:92',
                                    'c4:7d:4f:e0:c7:a4',
                                    'c4:7d:4f:e0:c7:ae',
                                    'c4:7d:4f:e0:c7:b0',
                                    'c4:7d:4f:e0:c7:b4',
                                    'c4:7d:4f:e0:c7:38',
                                    'c4:7d:4f:e0:c7:52',
                                    'c4:7d:4f:e0:c7:5c',
                                    'c4:7d:4f:e0:c7:62',
                                    '02:60:cf:21:a0:0b',
                                    'cc:ef:48:4c:9b:d4',
                                    'cc:ef:48:4c:9b:e6',
                                    'd0:67:e5:13:46:88',
                                    'd0:67:e5:17:96:77',
                                    'd0:67:e5:19:af:17',
                                    'd0:67:e5:19:c2:ca',
                                    'd0:67:e5:19:c7:7c',
                                    'd0:67:e5:19:c9:e0',
                                    'd0:67:e5:19:ce:00',
                                    'd0:67:e5:1a:5e:7e',
                                    'd4:be:d9:d1:ff:b0',
                                    'd4:be:d9:d6:71:4b',
                                    'd4:3d:7e:5e:54:10',
                                    'd8:d3:85:7f:9d:d1',
                                    'e4:1f:13:64:0d:0c',
                                    'e8:05:6d:12:6c:40',
                                    'e8:05:6d:12:9c:40',
                                    'e8:05:6d:26:90:40',
                                    'e8:05:6d:26:9c:40',
                                    'e8:05:6d:26:ac:40',
                                    'e8:05:6d:26:cc:40',
                                    'e8:05:6d:27:b0:40',
                                    'e8:05:6d:27:c4:40',
                                    'e8:05:6d:28:94:40',
                                    'e8:05:6d:28:a0:40',
                                    'e8:05:6d:28:b0:40',
                                    'e8:05:6d:28:b8:40',
                                    'e8:05:6d:2a:78:40',
                                    'e8:05:6d:2a:f8:40',
                                    'e8:05:6d:2b:78:40',
                                    'e8:05:6d:2b:90:40',
                                    'e8:05:6d:2b:98:40',
                                    'e8:05:6d:2b:b4:01',
                                    'e8:05:6d:2b:cc:40',
                                    'e8:05:6d:2b:2c:40',
                                    'e8:05:6d:2b:50:40',
                                    'e8:05:6d:33:90:40',
                                    'e8:05:6d:33:14:40',
                                    'e8:05:6d:33:fc:40',
                                    'e8:05:6d:33:2c:40',
                                    'e8:05:6d:33:34:40',
                                    'e8:05:6d:33:40:40',
                                    'e8:05:6d:34:78:40',
                                    'e8:05:6d:34:c8:40',
                                    'e8:05:6d:34:e8:40',
                                    'e8:05:6d:34:18:40',
                                    'e8:05:6d:34:44:40',
                                    'e8:05:6d:34:5c:40',
                                    'e8:05:6d:35:10:40',
                                    'e8:05:6d:35:30:40',
                                    'e8:05:6d:5a:e0:40',
                                    'e8:05:6d:5c:b4:40',
                                    'f0:4d:a2:33:42:8e',
                                    'f0:4d:a2:36:b6:88',
                                    'f0:4d:a2:36:bb:05',
                                    'fc:83:99:c9:a4:40',
                                    'fc:a8:41:69:18:40',
                                    '20:cf:30:1b:d6:dd',
                                    '2c:41:38:06:01:70',
                                    '3c:b1:5b:c2:a0:01',
                                    '40:2c:f4:e9:88:a4',
                                    '44:32:2a:6b:d4:40',
                                    '08:00:20:ad:45:8c',
                                    '08:2e:5f:1c:93:34',
                                    '5c:e2:86:8e:68:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 48  ',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - Port 48  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => 'e8:05:6d:27:5c:00',
                        IFLASTCHANGE     => '(14521) 0:02:25.21',
                        IFINOCTETS       => '2159441783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2005702186',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8193',
                        IFNAME           => 'Nortel <unknown> Ethernet Switch Module - Cascade Module Port 2',
                        IFDESCR          => 'Nortel <unknown> Ethernet Switch Module - Cascade Module Port 2',
                        IFTYPE           => '54',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(14676) 0:02:26.76',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 1',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 1',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 13',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 13',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(67) 0:00:00.67',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 17',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 17',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(65) 0:00:00.65',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 25',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 25',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(56) 0:00:00.56',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 26',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 26',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(58) 0:00:00.58',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 40',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 40',
                        IFTYPE           => '136',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => 'e8:05:6d:27:5c:40',
                        IFLASTCHANGE     => '(60) 0:00:00.60',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 44',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 44',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(61) 0:00:00.61',
                    },
                    {
                        IFNUMBER         => '10134',
                        IFNAME           => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 134',
                        IFDESCR          => 'Nortel Ethernet Routing Switch 4548GT PWR Module - VLAN 134',
                        IFTYPE           => '135',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:00:00:00:00:00',
                        IFLASTCHANGE     => '(63) 0:00:00.63',
                    },
                ]
            },
        }
    ],
    'nortel/baystack_470.01.walk' => [
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2',
            SNMPHOSTNAME => 'Bay470',
            MAC          => '00:15:40:94:75:a2',
            MODEL        => 'Baystack 470 24T',
        },
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2',
            SNMPHOSTNAME => 'Bay470',
            MAC          => '00:15:40:94:75:a2',
            MODELSNMP    => 'Networking2050',
            MODEL        => 'Baystack 470 24T',
            FIRMWARE     => undef,
            SERIAL       => 'SACC170NLH',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Nortel',
                TYPE         => 'NETWORKING',
                MODEL        => 'Baystack 470 24T',
                COMMENTS     => 'BayStack 470 - 24T           HW:06       FW:3.0.0.5   SW:v3.1.2.06 ISVN:2',
                NAME         => 'Bay470',
                LOCATION     => 'Dost 111',
                SERIAL       => 'SACC170NLH',
                IPS          => {
                    IP => [
                        '10.97.9.231',
                    ],
                },
                MAC          => '00:15:40:94:75:a2',
                UPTIME       => '(78352234) 9 days, 1:38:42.34',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'ifc1 (Slot: 1 Port: 1)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 1  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        IP               => '10.97.9.231',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'ifc2 (Slot: 1 Port: 2)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 2  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'ifc3 (Slot: 1 Port: 3)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 3  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'ifc4 (Slot: 1 Port: 4)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 4  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'ifc5 (Slot: 1 Port: 5)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 5  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'ifc6 (Slot: 1 Port: 6)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 6  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'ifc7 (Slot: 1 Port: 7)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 7  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'ifc8 (Slot: 1 Port: 8)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 8  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ifc9 (Slot: 1 Port: 9)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 9  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'ifc10 (Slot: 1 Port: 10)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 10  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'ifc11 (Slot: 1 Port: 11)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 11  ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(77308621) 8 days, 22:44:46.21',
                        IFINOCTETS       => '1290906485',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3179345836',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'ifc12 (Slot: 1 Port: 12)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 12  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(76741116) 8 days, 21:10:11.16',
                        IFINOCTETS       => '108574',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '77060062',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'ifc13 (Slot: 1 Port: 13)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 13  ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(70532885) 8 days, 3:55:28.85',
                        IFINOCTETS       => '15996094',
                        IFINERRORS       => '26',
                        IFOUTOCTETS      => '307895726',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'ifc14 (Slot: 1 Port: 14)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 14  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'ifc15 (Slot: 1 Port: 15)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 15  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(76338315) 8 days, 20:03:03.15',
                        IFINOCTETS       => '177031254',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '424051585',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:b9:23:05:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'ifc16 (Slot: 1 Port: 16)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 16  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'ifc17 (Slot: 1 Port: 17)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 17  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(75891715) 8 days, 18:48:37.15',
                        IFINOCTETS       => '75037757',
                        IFINERRORS       => '37',
                        IFOUTOCTETS      => '261500106',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:81:1d:86:d0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'ifc18 (Slot: 1 Port: 18)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 18  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'ifc19 (Slot: 1 Port: 19)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 19  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(775692) 2:09:16.92',
                        IFINOCTETS       => '1569595',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4611271',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'ifc20 (Slot: 1 Port: 20)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 20  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'ifc21 (Slot: 1 Port: 21)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 21  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'ifc22 (Slot: 1 Port: 22)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 22  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'ifc23 (Slot: 1 Port: 23)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 23  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'ifc24 (Slot: 1 Port: 24)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 24  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'ifc25 (Slot: 1 Port: 25)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 25  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(13836) 0:02:18.36',
                        IFINOCTETS       => '254286165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1628279966',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:5e:00:01:01',
                                    '00:00:5e:00:01:77',
                                    '00:01:e6:9b:c1:94',
                                    '00:01:e6:9d:45:68',
                                    '00:0a:5e:54:54:3d',
                                    '00:0b:cd:69:12:dd',
                                    '00:0b:cd:cb:fb:74',
                                    '00:0b:cd:cc:0e:aa',
                                    '00:0b:cd:cc:08:38',
                                    '00:0b:cd:ee:8a:07',
                                    '00:0c:85:53:7f:99',
                                    '00:0c:85:53:86:99',
                                    '00:0c:30:68:63:41',
                                    '00:0d:88:11:76:a9',
                                    '00:0d:9d:d8:e8:97',
                                    '00:0d:9d:4d:f0:09',
                                    '00:0e:7f:fd:88:af',
                                    '00:0e:7f:fd:59:df',
                                    '00:0e:7f:21:cd:5e',
                                    '00:0e:7f:2b:64:13',
                                    '00:0e:7f:2c:f8:89',
                                    '00:0f:fe:74:4d:d9',
                                    '00:0f:1f:8d:3b:33',
                                    '00:0f:20:6d:d0:e5',
                                    '00:11:43:2b:0d:4b',
                                    '00:11:58:9b:2f:30',
                                    '00:12:79:d3:5d:55',
                                    '00:12:3f:2b:c3:be',
                                    '00:12:3f:44:05:b0',
                                    '00:12:3f:46:7b:22',
                                    '00:12:3f:47:f7:d3',
                                    '00:12:3f:47:36:ad',
                                    '00:12:3f:47:41:4d',
                                    '00:12:3f:47:53:3e',
                                    '00:12:3f:47:57:2b',
                                    '00:12:3f:47:5d:5c',
                                    '00:12:3f:47:5e:87',
                                    '00:12:3f:47:5e:2f',
                                    '00:12:3f:47:5f:e6',
                                    '00:12:3f:47:61:a3',
                                    '00:12:3f:48:1f:1b',
                                    '00:12:3f:48:4e:89',
                                    '00:12:3f:4a:86:03',
                                    '00:12:3f:4a:90:18',
                                    '00:12:3f:4a:96:51',
                                    '00:13:65:54:82:00',
                                    '00:13:65:54:82:0e',
                                    '00:13:72:77:f9:c0',
                                    '00:13:72:7d:96:dd',
                                    '00:13:21:6b:8c:c1',
                                    '00:13:21:6b:48:3e',
                                    '00:13:21:6b:48:3f',
                                    '00:13:21:07:79:78',
                                    '00:c0:ff:08:25:ba',
                                    '00:02:a5:44:17:c7',
                                    '00:02:a5:44:17:2c',
                                    '00:02:a5:44:18:a4',
                                    '00:02:a5:44:19:0a',
                                    '00:02:a5:44:19:54',
                                    '00:14:0d:2e:32:00',
                                    '00:14:0d:2e:32:0e',
                                    '00:14:c7:8c:00:00',
                                    '00:14:fd:12:f0:12',
                                    '00:14:22:2d:f3:e9',
                                    '00:14:22:2d:f6:7b',
                                    '00:14:22:2d:f7:6a',
                                    '00:14:22:2e:8d:62',
                                    '00:14:22:2e:8e:a0',
                                    '00:14:22:2e:10:69',
                                    '00:14:22:2e:10:be',
                                    '00:14:22:2e:10:1d',
                                    '00:14:22:2e:a8:3d',
                                    '00:14:22:2e:c7:bd',
                                    '00:14:22:2e:c9:3f',
                                    '00:14:38:bf:57:bf',
                                    '00:14:38:c4:65:8e',
                                    '00:14:38:c4:65:8f',
                                    '00:14:38:4c:33:90',
                                    '00:14:38:4f:8a:3e',
                                    '00:14:38:50:23:54',
                                    '00:14:4f:66:ef:e6',
                                    '00:14:4f:66:ef:4c',
                                    '00:14:4f:41:48:5c',
                                    '00:14:4f:41:48:5d',
                                    '00:15:e8:d1:1f:81',
                                    '00:15:5d:01:b7:01',
                                    '00:15:5d:01:b7:02',
                                    '00:15:5d:01:b7:03',
                                    '00:15:5d:01:b7:04',
                                    '00:15:5d:01:34:0f',
                                    '00:15:5d:01:34:11',
                                    '00:15:5d:01:34:12',
                                    '00:15:5d:01:34:08',
                                    '00:15:5d:07:46:0b',
                                    '00:15:5d:07:46:0f',
                                    '00:15:5d:07:46:10',
                                    '00:15:5d:07:46:13',
                                    '00:15:5d:07:46:04',
                                    '00:15:5d:07:46:08',
                                    '00:16:35:7f:e6:df',
                                    '00:16:35:81:4a:15',
                                    '00:17:a4:0e:7c:9a',
                                    '00:19:b9:20:dd:2f',
                                    '00:19:b9:20:e1:f7',
                                    '00:19:b9:20:e5:f4',
                                    '00:19:b9:20:e6:40',
                                    '00:03:ba:01:78:14',
                                    '00:03:ba:9b:5b:c5',
                                    '00:03:ba:a8:df:9d',
                                    '00:03:ba:43:f2:51',
                                    '00:03:ba:49:1a:e3',
                                    '00:03:ba:49:1a:e4',
                                    '00:20:a7:01:6b:01',
                                    '00:20:a7:01:98:21',
                                    '00:21:5a:7b:cf:97',
                                    '00:21:5a:5b:dd:fa',
                                    '00:22:64:a9:2f:3c',
                                    '00:22:64:b2:21:b8',
                                    '00:22:64:19:9e:5e',
                                    '00:22:64:19:d8:42',
                                    '00:22:64:2f:da:76',
                                    '00:22:64:2f:da:87',
                                    '00:22:67:89:6c:00',
                                    '00:23:ae:91:04:a8',
                                    '00:23:ae:91:09:61',
                                    '00:24:81:17:1f:bc',
                                    '00:24:81:1d:88:47',
                                    '00:24:8c:1d:64:bb',
                                    '00:24:8c:1d:69:ee',
                                    '00:24:8c:1d:6f:cb',
                                    '00:24:8c:1d:70:3b',
                                    '00:24:8c:1d:70:3c',
                                    '00:24:8c:1d:61:ff',
                                    '00:24:8c:1d:63:24',
                                    '00:24:8c:1d:63:3a',
                                    '00:25:64:9b:81:14',
                                    '00:25:64:9b:82:68',
                                    '00:25:64:9b:88:7f',
                                    '00:25:64:9b:88:3b',
                                    '00:25:64:9b:89:29',
                                    '00:04:dc:46:e5:81',
                                    '00:30:6e:f3:87:7c',
                                    '00:07:32:0f:9c:d5',
                                    '00:09:97:8c:98:60',
                                    '00:60:16:01:2a:d4',
                                    '64:31:50:22:19:52',
                                    '68:b5:99:cb:03:da',
                                    '68:b5:99:cb:63:8a',
                                    '68:b5:99:cb:63:96',
                                    '68:b5:99:cb:63:a8',
                                    '68:b5:99:cb:63:d6',
                                    '68:b5:99:cb:63:de',
                                    'b8:ac:6f:37:8e:cd',
                                    'b8:ac:6f:37:90:58',
                                    'b8:ac:6f:37:99:bb',
                                    'b8:ac:6f:37:9d:02',
                                    'e0:26:36:83:30:40',
                                    '18:a9:05:59:c1:90',
                                    '18:a9:05:59:c1:92',
                                    '44:1e:a1:46:89:6a',
                                    '08:17:f4:3a:fe:00',
                                    '08:17:f4:3b:a6:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'ifc26 (Slot: 1 Port: 26)',
                        IFDESCR          => 'Nortel Networks <unknown> Ethernet Switch Module - Port 26  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:15:40:94:75:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(55) 0:00:00.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
    'nortel/baystack_470.02.walk' => [
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
            SNMPHOSTNAME => '470_99_OBS',
            MAC          => '00:1d:af:ea:a0:e2',
            MODEL        => 'Baystack 470 24T',
        },
        {
            MANUFACTURER => 'Nortel',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
            SNMPHOSTNAME => '470_99_OBS',
            MAC          => '00:1d:af:ea:a0:e2',
            MODELSNMP    => 'Networking0316',
            MODEL        => 'Baystack 470 24T',
            FIRMWARE     => undef,
            SERIAL       => 'LBNNTMJX5809LW',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Nortel',
                TYPE         => 'NETWORKING',
                MODEL        => 'Baystack 470 24T',
                COMMENTS     => 'Ethernet Switch 470-24T      HW:34       FW:3.6.0.6   SW:v3.6.2.04 BN:4 ISVN:2 (c) Nortel Networks',
                CONTACT      => 'OBS',
                NAME         => '470_99_OBS',
                LOCATION     => 'Salle Informatique',
                SERIAL       => 'LBNNTMJX5809LW',
                MAC          => '00:1d:af:ea:a0:e2',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 1  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(13930) 0:02:19.30',
                        IFINOCTETS       => '1111832468',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3597292020',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:12:ef:41:30:bb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 2  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(10880) 0:01:48.80',
                        IFINOCTETS       => '1924076684',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '103236673',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:12:ef:41:30:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 3  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(81099) 0:13:30.99',
                        IFINOCTETS       => '3571167735',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1137599330',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0d:b4:02:20:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 4  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(60244953) 6 days, 23:20:49.53',
                        IFINOCTETS       => '1264',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26786780',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 5  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(7005250) 19:27:32.50',
                        IFINOCTETS       => '76955793',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1950190804',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:30:48:96:81:51',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 6  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(60246350) 6 days, 23:21:03.50',
                        IFINOCTETS       => '156912',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26419930',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 7  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(81149) 0:13:31.49',
                        IFINOCTETS       => '590382976',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '523818070',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0d:b4:02:20:0d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 8  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(60245003) 6 days, 23:20:50.03',
                        IFINOCTETS       => '5696',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26659895',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 9  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(28) 0:00:00.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 10  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(29) 0:00:00.29',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 11  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(81199) 0:13:31.99',
                        IFINOCTETS       => '256',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4354176',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 12  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(60245053) 6 days, 23:20:50.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4356864',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 13  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(29) 0:00:00.29',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 14  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 15  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 16  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 17  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 18  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 19  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 20  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 21  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(30) 0:00:00.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 22  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(31) 0:00:00.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 23  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(13430) 0:02:14.30',
                        IFINOCTETS       => '2065851792',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '849934883',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:85:be:8a:c8',
                                    '00:00:85:be:96:38',
                                    '00:00:85:be:96:47',
                                    '00:00:85:e0:6a:f4',
                                    '00:00:bc:38:70:92',
                                    '00:00:5e:00:01:05',
                                    '00:01:02:a2:ee:10',
                                    '00:01:02:a2:f0:72',
                                    '00:01:02:13:9a:a2',
                                    '00:01:e6:76:fb:4f',
                                    '00:01:e6:89:f3:c2',
                                    '00:01:e6:8c:ba:7f',
                                    '00:01:e6:60:db:f0',
                                    '00:01:03:0c:c5:1b',
                                    '00:01:03:11:cc:c4',
                                    '00:01:29:14:3a:88',
                                    '00:01:05:03:b7:3e',
                                    '00:01:05:03:b7:50',
                                    '00:01:05:04:94:2e',
                                    '00:01:05:04:94:4a',
                                    '00:0a:e4:c1:87:70',
                                    '00:0a:e4:c1:87:7b',
                                    '00:0a:e4:c1:8c:ec',
                                    '00:0a:e4:2e:94:fe',
                                    '00:0a:e4:39:52:09',
                                    '00:0b:cd:70:8f:ae',
                                    '00:0e:0c:eb:13:4e',
                                    '00:0e:7f:6b:6e:6f',
                                    '00:0e:7f:e0:f7:96',
                                    '00:0e:7f:f9:e5:4a',
                                    '00:0e:7f:fa:18:cc',
                                    '00:0e:7f:fa:18:d0',
                                    '00:0e:7f:fa:1a:98',
                                    '00:0e:7f:fb:90:f2',
                                    '00:0e:7f:fc:b4:cf',
                                    '00:0e:7f:fc:c3:65',
                                    '00:0e:7f:fc:c3:dc',
                                    '00:0e:7f:fc:c3:3e',
                                    '00:0e:7f:fc:cc:e8',
                                    '00:0e:7f:fc:cd:4c',
                                    '00:0e:7f:28:dd:c2',
                                    '00:0e:7f:2a:59:76',
                                    '00:0e:8c:a8:dd:26',
                                    '00:0e:8c:a9:45:db',
                                    '00:0e:8c:c5:03:77',
                                    '00:90:27:78:fb:a2',
                                    '00:0f:fe:4f:0d:4a',
                                    '00:0f:20:fa:c3:79',
                                    '00:0f:20:fa:c3:80',
                                    '00:0f:20:fa:c4:03',
                                    '00:0f:20:fa:cc:23',
                                    '00:0f:20:fa:cc:35',
                                    '00:0f:20:fa:cc:43',
                                    '00:0f:20:fa:cc:48',
                                    '00:0f:20:fa:2c:d9',
                                    '00:0f:20:2c:64:34',
                                    '00:0f:20:2c:65:0b',
                                    '00:0f:20:2c:72:c9',
                                    '00:0f:20:2c:ad:b0',
                                    '00:0f:20:2c:49:8d',
                                    '00:0f:20:2c:63:df',
                                    '00:10:70:00:16:09',
                                    '00:10:70:00:2e:d0',
                                    '00:10:70:00:59:b1',
                                    '00:10:70:03:0c:02',
                                    '00:10:70:03:1e:fe',
                                    '00:10:70:03:28:f2',
                                    '00:10:70:04:10:fa',
                                    '00:10:70:04:13:1e',
                                    '00:10:70:04:22:b0',
                                    '00:10:70:04:33:79',
                                    '00:10:70:04:36:44',
                                    '00:10:70:05:0c:da',
                                    '00:10:70:05:33:d3',
                                    '00:10:70:05:4c:5e',
                                    '00:10:5a:d6:58:e8',
                                    '00:10:5a:de:08:29',
                                    '00:a0:24:ac:53:d2',
                                    '00:a0:24:19:ff:fb',
                                    '00:11:0a:3a:b3:72',
                                    '00:11:0a:3a:b3:44',
                                    '00:11:0a:3b:77:1e',
                                    '00:11:0a:3b:9c:b4',
                                    '00:11:0a:3b:a2:d4',
                                    '00:11:0a:3b:a3:42',
                                    '00:11:85:73:a1:fa',
                                    '00:11:85:73:b4:30',
                                    '00:11:85:73:b8:7a',
                                    '00:12:ef:21:de:e9',
                                    '00:c0:eb:09:65:bc',
                                    '00:c0:eb:09:65:15',
                                    '00:c0:ee:6a:d4:8b',
                                    '00:c0:ee:6a:d4:93',
                                    '00:c0:ee:6b:3e:aa',
                                    '00:c0:ee:6b:3e:c0',
                                    '00:c0:ee:6b:3e:c6',
                                    '00:c0:ee:6b:3e:c8',
                                    '00:c0:ee:6b:3e:c9',
                                    '00:c0:ee:6b:3e:cc',
                                    '00:c0:ee:6b:3e:d6',
                                    '00:c0:ee:6b:3e:d7',
                                    '00:c0:ee:78:3b:6e',
                                    '00:c0:ee:78:3b:4f',
                                    '00:c0:ee:78:3b:54',
                                    '00:c0:ee:49:97:4d',
                                    '00:c0:ee:58:93:53',
                                    '00:c0:ee:58:95:8b',
                                    '00:c0:ee:58:99:46',
                                    '00:c0:ee:58:c0:f6',
                                    '00:c0:ee:5a:48:6f',
                                    '00:02:3f:36:9c:2e',
                                    '00:14:38:e4:08:72',
                                    '00:d0:b7:47:a9:c1',
                                    '00:15:60:04:5f:02',
                                    '00:16:d3:b5:f0:fc',
                                    '00:16:d3:b5:f1:e2',
                                    '00:16:d3:b5:5d:bc',
                                    '00:16:d3:ca:b6:54',
                                    '00:16:d3:29:17:2c',
                                    '00:16:d3:29:06:db',
                                    '00:16:d3:29:47:31',
                                    '00:16:d3:2a:b1:c1',
                                    '00:16:d3:2a:b2:7b',
                                    '00:16:17:7e:90:2c',
                                    '00:16:17:c5:d8:e2',
                                    '00:16:17:c5:d9:6b',
                                    '00:16:17:c5:d9:9b',
                                    '00:16:17:c5:d9:a0',
                                    '00:16:17:c5:d9:03',
                                    '00:16:17:c5:d9:35',
                                    '00:16:17:c5:e4:64',
                                    '00:16:17:c6:a4:ee',
                                    '00:16:17:c6:a9:dc',
                                    '00:16:17:c6:aa:1f',
                                    '00:16:17:c6:aa:2d',
                                    '00:16:17:c6:b7:36',
                                    '00:16:17:c6:c3:a1',
                                    '00:16:17:c6:c3:aa',
                                    '00:16:17:c7:6b:69',
                                    '00:16:17:c7:19:01',
                                    '00:16:35:ad:a3:a0',
                                    '00:16:35:ad:dc:d5',
                                    '00:16:35:ae:7c:ce',
                                    '00:16:35:ae:95:91',
                                    '00:16:35:ae:96:2d',
                                    '00:17:a4:44:8a:c3',
                                    '00:17:23:0d:d5:7d',
                                    '00:17:42:42:3f:6c',
                                    '00:17:42:42:3f:52',
                                    '00:17:08:7c:8a:ca',
                                    '00:19:0f:00:f0:92',
                                    '00:19:99:00:2b:b9',
                                    '00:19:d1:55:31:03',
                                    '00:19:5b:2e:d3:38',
                                    '00:19:5b:2e:d3:3c',
                                    '00:19:5b:31:7f:d0',
                                    '00:19:5b:31:7f:d1',
                                    '00:1a:6b:6b:6b:0f',
                                    '00:1a:6b:6d:7f:63',
                                    '00:1a:6b:6d:c4:0d',
                                    '00:1a:4b:46:70:1f',
                                    '00:1a:4b:46:7f:5c',
                                    '00:1a:4b:46:81:ee',
                                    '00:1a:4b:46:83:2e',
                                    '00:1a:4b:46:60:61',
                                    '00:1a:4b:47:4c:f0',
                                    '00:1a:4b:47:54:f8',
                                    '00:1a:4b:47:54:39',
                                    '00:1a:4b:47:55:5e',
                                    '00:1a:4b:47:57:ff',
                                    '00:1a:4b:47:59:b5',
                                    '00:1a:4d:5a:63:75',
                                    '00:1b:78:b6:94:34',
                                    '00:1b:78:b6:97:84',
                                    '00:1b:78:b6:97:97',
                                    '00:1b:78:b6:97:aa',
                                    '00:1b:78:b6:97:c0',
                                    '00:1b:78:b6:97:d5',
                                    '00:1b:78:b6:98:f9',
                                    '00:1b:78:b6:99:b1',
                                    '00:1b:78:b6:99:d8',
                                    '00:1b:78:b6:99:5a',
                                    '00:1b:78:b6:be:77',
                                    '00:1b:78:b6:be:9b',
                                    '00:1b:78:b6:be:df',
                                    '00:1b:78:b6:be:f5',
                                    '00:1b:78:b6:c0:a8',
                                    '00:1b:78:b6:56:43',
                                    '00:1b:78:22:33:29',
                                    '00:1b:78:22:46:84',
                                    '00:1b:21:0d:a7:88',
                                    '00:1c:c4:d8:84:dc',
                                    '00:1c:c4:d8:c3:60',
                                    '00:1c:c4:de:9c:e2',
                                    '00:1c:c4:e2:e5:ae',
                                    '00:1c:c4:1a:64:82',
                                    '00:1c:c4:1a:34:14',
                                    '00:1c:c4:1a:34:53',
                                    '00:1c:c4:1a:5a:05',
                                    '00:1c:c4:1a:63:6b',
                                    '00:1c:c4:1a:63:5a',
                                    '00:1c:c4:5d:c8:f4',
                                    '00:1c:c4:60:39:8a',
                                    '00:1c:c4:63:e5:0d',
                                    '00:1c:eb:33:58:40',
                                    '00:1c:eb:33:58:41',
                                    '00:1c:eb:33:58:42',
                                    '00:1c:eb:33:58:43',
                                    '00:1c:eb:33:58:49',
                                    '00:1c:25:99:86:c4',
                                    '00:1c:25:99:86:16',
                                    '00:1c:25:99:86:19',
                                    '00:1c:25:99:86:20',
                                    '00:1c:25:99:87:32',
                                    '00:1c:25:99:87:34',
                                    '00:1c:25:a1:2e:ec',
                                    '00:1d:72:84:c3:66',
                                    '00:1d:72:8a:46:f2',
                                    '00:1d:92:e2:8e:8a',
                                    '00:1d:92:e4:05:ee',
                                    '00:1d:92:e4:05:ef',
                                    '00:1d:92:e4:05:fd',
                                    '00:03:47:ad:d7:21',
                                    '00:03:47:ad:d8:b5',
                                    '00:1e:0b:a6:3a:39',
                                    '00:1e:58:a8:13:3c',
                                    '00:1e:58:a8:13:3d',
                                    '00:1e:58:a8:13:3e',
                                    '00:1e:58:a8:15:a6',
                                    '00:1f:16:0e:c6:71',
                                    '00:1f:16:0e:db:37',
                                    '00:1f:16:0e:db:3d',
                                    '00:1f:16:17:ae:51',
                                    '00:1f:16:29:c2:88',
                                    '00:1f:16:29:c2:1b',
                                    '00:1f:16:29:c3:23',
                                    '00:1f:16:29:c3:40',
                                    '00:1f:16:29:c3:60',
                                    '00:1f:16:29:60:0b',
                                    '00:21:85:01:7c:14',
                                    '00:21:85:01:dc:7d',
                                    '00:21:85:01:dc:7e',
                                    '00:21:85:01:dc:1f',
                                    '00:21:85:01:dc:22',
                                    '00:21:85:01:dc:29',
                                    '00:21:85:01:dc:41',
                                    '00:21:85:01:dc:47',
                                    '00:21:5a:1c:45:fb',
                                    '00:23:7d:87:51:a4',
                                    '00:23:7d:2b:fe:21',
                                    '00:23:ae:92:70:87',
                                    '00:23:ae:ae:2c:a6',
                                    '00:24:81:c7:ed:40',
                                    '00:24:81:c7:ed:51',
                                    '00:24:81:e9:e3:66',
                                    '00:24:81:e9:e3:74',
                                    '00:24:81:e9:e3:87',
                                    '00:24:81:e9:e3:8a',
                                    '00:24:81:e9:e3:93',
                                    '00:24:81:e9:e3:98',
                                    '00:24:81:e9:e3:cf',
                                    '00:24:81:e9:e3:d2',
                                    '00:24:81:e9:e3:d6',
                                    '00:24:81:e9:e3:de',
                                    '00:24:81:e9:e3:3e',
                                    '00:24:81:e9:e3:41',
                                    '00:24:81:e9:e3:43',
                                    '00:24:81:e9:e3:45',
                                    '00:24:81:e9:e3:57',
                                    '00:24:81:e9:e3:5c',
                                    '00:24:81:ea:d9:02',
                                    '00:24:81:ea:da:6e',
                                    '00:24:81:ea:da:74',
                                    '00:24:81:ea:da:79',
                                    '00:24:81:ea:da:81',
                                    '00:24:81:ea:da:8f',
                                    '00:24:81:ea:da:91',
                                    '00:24:81:ea:da:92',
                                    '00:24:81:ea:da:a7',
                                    '00:24:81:ea:da:c9',
                                    '00:24:81:ea:da:cd',
                                    '00:24:81:ea:da:ce',
                                    '00:24:81:ea:da:d8',
                                    '00:24:81:ea:da:f7',
                                    '00:24:81:ea:da:fc',
                                    '00:24:81:f3:f4:cd',
                                    '00:24:81:f3:f5:1d',
                                    '00:24:81:f3:f5:1e',
                                    '00:24:81:f3:f5:25',
                                    '00:24:81:06:de:4e',
                                    '00:24:e8:b1:57:56',
                                    '00:24:e8:b2:8c:74',
                                    '00:24:e8:b2:8c:ab',
                                    '00:24:e8:b2:8d:78',
                                    '00:24:e8:b2:8d:3b',
                                    '00:24:1d:c2:92:68',
                                    '00:24:1d:c2:16:bc',
                                    '00:25:b3:0a:44:c4',
                                    '00:25:b3:0a:44:cf',
                                    '00:25:b3:0a:44:d5',
                                    '00:26:6c:94:01:4f',
                                    '00:26:55:4a:a3:2a',
                                    '00:27:19:c7:47:69',
                                    '00:27:19:c7:47:6a',
                                    '00:27:19:c7:47:6b',
                                    '00:27:19:c7:47:81',
                                    '00:27:19:c7:47:94',
                                    '00:27:19:c7:47:62',
                                    '00:04:75:52:5e:8b',
                                    '00:04:23:13:b3:13',
                                    '00:04:23:13:b6:e2',
                                    '00:04:23:13:d8:a7',
                                    '00:04:23:13:d8:cb',
                                    '00:04:23:13:dd:9e',
                                    '00:04:23:13:dd:a8',
                                    '00:04:23:13:dd:b1',
                                    '00:04:23:13:dd:d6',
                                    '00:04:23:13:dd:da',
                                    '00:04:23:13:e4:e4',
                                    '00:04:23:13:e5:56',
                                    '00:04:23:13:ea:16',
                                    '00:04:23:13:ed:45',
                                    '00:04:23:1b:0b:04',
                                    '00:04:23:1b:8b:6e',
                                    '00:04:23:1b:8b:63',
                                    '00:04:23:1b:0e:0a',
                                    '00:04:23:1b:8c:66',
                                    '00:04:23:1b:8c:0b',
                                    '00:04:23:1b:8c:95',
                                    '00:04:23:1b:8c:1b',
                                    '00:04:23:1b:8d:89',
                                    '00:04:23:1b:8d:b0',
                                    '00:04:23:1b:8d:c8',
                                    '00:04:23:1b:8e:47',
                                    '00:04:23:1b:8e:4b',
                                    '00:04:23:1b:8e:5b',
                                    '00:04:23:1b:4e:b0',
                                    '00:04:23:1b:4e:48',
                                    '00:04:23:1b:4e:55',
                                    '00:04:23:1b:4f:72',
                                    '00:04:23:1b:4f:36',
                                    '00:30:6e:f4:89:ee',
                                    '00:30:6e:06:0a:de',
                                    '00:30:6e:06:79:e1',
                                    '00:30:6e:4b:10:04',
                                    '00:30:6e:4b:13:c4',
                                    '00:30:05:99:eb:c6',
                                    '00:30:05:99:eb:de',
                                    '00:30:05:9a:f2:fb',
                                    '00:30:05:cd:ce:82',
                                    '00:30:05:cd:ce:93',
                                    '00:30:05:fb:9b:94',
                                    '00:30:05:46:44:7a',
                                    '00:30:05:46:44:f8',
                                    '00:30:05:5e:36:74',
                                    '00:05:5d:f5:05:61',
                                    '00:40:ca:a1:70:2f',
                                    '00:07:4d:37:6d:1d',
                                    '00:07:4d:37:6d:63',
                                    '00:08:9b:1b:43:2c',
                                    '00:50:04:38:f5:14',
                                    '00:50:56:73:2e:47',
                                    '00:50:56:73:33:76',
                                    '00:50:56:93:66:b2',
                                    '00:50:56:93:6f:58',
                                    '00:50:56:93:70:e3',
                                    '00:50:56:93:7b:9f',
                                    '00:50:56:93:7c:21',
                                    '00:50:56:93:0e:63',
                                    '00:50:56:93:10:f7',
                                    '00:50:56:93:22:b7',
                                    '00:50:56:93:26:6f',
                                    '00:50:56:93:36:e8',
                                    '00:50:56:93:39:2f',
                                    '00:50:56:93:3c:e6',
                                    '00:50:56:93:40:3e',
                                    '00:50:56:93:4a:6b',
                                    '00:50:56:93:4a:78',
                                    '00:50:56:93:56:0a',
                                    '00:50:56:93:59:77',
                                    '00:50:56:93:09:8f',
                                    '00:50:56:93:5b:97',
                                    '00:50:56:93:5f:70',
                                    '00:50:56:93:62:30',
                                    '00:60:97:bd:43:e1',
                                    '00:60:08:62:9d:6b',
                                    '84:2b:2b:ba:d4:9a',
                                    '94:0c:6d:80:06:99',
                                    'b8:ac:6f:48:c8:f1',
                                    'e8:be:81:1c:29:a3',
                                    '3c:4a:92:42:64:61',
                                    '40:61:86:0d:0a:a9',
                                    '08:00:06:8f:a5:84',
                                    '08:00:06:8f:a5:85',
                                    '08:00:06:8f:a5:89',
                                    '08:00:06:8f:a5:8b',
                                    '08:00:06:8f:a5:95',
                                    '08:00:06:8f:a5:17',
                                    '08:00:06:8f:a5:06',
                                    '08:00:06:8f:b4:d0',
                                    '08:00:06:8f:b4:dc',
                                    '08:00:06:8f:b4:dd',
                                    '08:00:06:8f:b4:e6',
                                    '08:00:06:8f:b4:e9',
                                    '08:00:06:8f:b4:f1',
                                    '08:00:06:8f:b5:ee',
                                    '08:00:06:8f:b5:f5',
                                    '08:00:06:8f:b5:fb',
                                    '58:55:ca:f0:90:ad',
                                    '5c:0e:8b:13:13:dd',
                                    '5c:0e:8b:13:c5:b9',
                                    '5c:0e:8b:13:c5:1d',
                                    '5c:0e:8b:13:07:5b',
                                    '5c:0e:8b:18:36:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 24  ',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(13580) 0:02:15.80',
                        IFINOCTETS       => '1377356854',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12624866',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:eb:33:58:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 25  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(31) 0:00:00.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFDESCR          => 'Nortel Ethernet Switch 470-24T Module - Port 26  ',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:af:ea:a0:e0',
                        IFLASTCHANGE     => '(31) 0:00:00.31',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        }
    ],
);

setPlan(scalar keys %tests);

my $dictionary = getDictionnary();
my $index      = getIndex();

foreach my $test (sort keys %tests) {
    my $snmp  = getSNMP($test);
    my $model = getModel($index, $tests{$test}->[1]->{MODELSNMP});

    my %device0 = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(\%device0, $tests{$test}->[0], "$test: base stage");

    my %device1 = getDeviceInfo(
        snmp       => $snmp,
        dictionary => $dictionary,
        datadir    => './share'
    );
    cmp_deeply(\%device1, $tests{$test}->[1], "$test: base + dictionnary stage");

    my $device3 = getDeviceFullInfo(
        snmp    => $snmp,
        model   => $model,
        datadir => './share'
    );
    cmp_deeply($device3, $tests{$test}->[2], "$test: base + model stage");
}
