# Generated by default/object.tt
package Paws::ECRPublic::ReferencedImageDetail;
  use Moose;
  has ArtifactMediaType => (is => 'ro', isa => 'Str', request_name => 'artifactMediaType', traits => ['NameInRequest']);
  has ImageDigest => (is => 'ro', isa => 'Str', request_name => 'imageDigest', traits => ['NameInRequest']);
  has ImageManifestMediaType => (is => 'ro', isa => 'Str', request_name => 'imageManifestMediaType', traits => ['NameInRequest']);
  has ImagePushedAt => (is => 'ro', isa => 'Str', request_name => 'imagePushedAt', traits => ['NameInRequest']);
  has ImageSizeInBytes => (is => 'ro', isa => 'Int', request_name => 'imageSizeInBytes', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECRPublic::ReferencedImageDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECRPublic::ReferencedImageDetail object:

  $service_obj->Method(Att1 => { ArtifactMediaType => $value, ..., ImageSizeInBytes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECRPublic::ReferencedImageDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->ArtifactMediaType

=head1 DESCRIPTION

An object that describes the image tag details returned by a
DescribeImageTags action.

=head1 ATTRIBUTES


=head2 ArtifactMediaType => Str

The artifact media type of the image.


=head2 ImageDigest => Str

The C<sha256> digest of the image manifest.


=head2 ImageManifestMediaType => Str

The media type of the image manifest.


=head2 ImagePushedAt => Str

The date and time, expressed in standard JavaScript date format, at
which the current image tag was pushed to the repository.


=head2 ImageSizeInBytes => Int

The size, in bytes, of the image in the repository.

If the image is a manifest list, this will be the max size of all
manifests in the list.

Beginning with Docker version 1.9, the Docker client compresses image
layers before pushing them to a V2 Docker registry. The output of the
C<docker images> command shows the uncompressed image size, so it may
return a larger image size than the image sizes returned by
DescribeImages.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECRPublic>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

