#!/usr/bin/perl
use utf8; # encoding="utf-8"
use strict;
no  warnings;

my $NAME = [
	qr/Aleksandar/,
	qr/Aleksandr Guidrevitch/,
	qr/Alex$/,
	qr/Alex Noso/,
	qr/Alex Prota/,
	qr/Alexe[iy]/,
	qr/Anatoly/,
	qr/Andre[iy]/,
	qr/Andrew (?:Maltsev|Shitov|V\. Ma)/,
	qr/Anton\b/,
	qr/Artur Penttinen/,
	qr/Boris Sukholitko/,
	qr/Denis \w+[oe]v\b/,
	qr/Denis S/,
	qr/Dmitr[iy]/,
	qr/Egor/,
	qr/Eugen Konkov/,
	qr/Eugen Sob/,
	qr/Gregory (?:A|Be)/,
	qr/Igor/,
	qr/Ilya/,
	qr/Ivan/,
	qr/Kirill/,
	qr/Maxim\b/,
	qr/Mishka/,
	qr/Mons Anderson/,
	qr/Nic?kolay/,
	qr/Oleg/,
	qr/Pavel/,
	qr/Ruslan/,
	qr/Serge[iy]/,
	qr/Timur/,
	qr/Vadim/,
	qr/Victor (?:M|\w+[oe]v\b)/,
	qr/Vladimir/,
	qr/Vladislav/,
	qr/Walery/,
	qr/Yur[iy]/,
	qr/Zaha/,
	qr/Zoffix/,
	
	qr/[а-я]+/,
];

#~ use LWP::UserAgent; # for real data

print
	# for module
	map  { sprintf "%-9s => '%s',\n", grep { defined } @$_{'pause', 'name'} }
	sort { $a->{'pause'} cmp $b->{'pause'} }
	grep { $_->{'author'} }
	
	#~ # for list
	#~ map  { join("\t", grep { defined } @$_{'id', 'name', 'pause', 'author', 'email', 'url'}), "\n" }
	
	# exclude
	grep { $_->{'pause'} !~ /^AXS|MOO|ICHLADIL|IZUT|IKETRIS|IVANS|ITUB|IVANWILLS|IVANWONG|PAVELH|INITDOTD|RUSSOZ$/ }
	
	grep {
		my $name = $_->{'name'};
		scalar grep { $name =~ /$_/ } @$NAME;
	}
	map  {
		my($url,  $name ) = $_->[ 1] =~ /<a href="([^"]+)">([^<]+)/; $name  ||= $_->[ 1]; $name =~ s/\s+$//;
		my($url2, $pause) = $_->[-1] =~ /<a href="([^"]+)">([^<]+)/; $pause ||= $_->[-1];
		
		+{
			'id'     => $_->[0],
			'name'   => $name,
			'url'    => $url,
			'email'  => $_->[2],
			'pause'  => $pause,
			'author' => $url2 ? 1 : 0,
		};
	}
	map  {
		[m{^ (\d+)\. \s ([^<]+ | <a.*?/a> | \s) .*? <a \s href="mailto:([^"]*)" .* -- \s+ (.*) $}x]
	}
	map  { split m{\s*<br />\s*} }
	grep { utf8::decode($_);1 }
	map  { $_->is_success ? $_->content =~ m{Archives</a></h3>(.*)<h3><a id="mailinglists"}s : () }
	LWP::UserAgent->new('timeout' => 15)->get('http://pause.perl.org/pause/query?ACTION=who_is')
;

package LWP::UserAgent; # for cache :)
use strict;

use HTTP::Request;
use HTTP::Response;

sub new { bless { @_ }, __PACKAGE__ }
sub get {
	my $self = shift;
	$_->request(HTTP::Request->new('GET', shift)), return $_ for HTTP::Response->new(200, 'OK', undef, do { local $/; <main::DATA> });
}

1;

__END__
2008-02-06 16:58
<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE html
                 PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
                 "DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><title>PAUSE: who_is</title>
<link rel="shortcut icon" href="/pause/pause_favicon.jpg" type="image/jpeg" />
<link rel="stylesheet" type="text/css" href="/pause/pause.css" title="pause"/>
</head><body bgcolor="white" link="#0000CC" vlink="#0000BB"
 alink="#FF0000" text="#000000"><table width="100%" border="0"
 cellpadding="0" cellspacing="0"><tr><td valign="middle"><a href="authenquery"><img src="/pause/pause2.jpg"
 border="0" alt="PAUSE Logo"
 width="177" height="43" align="left" /></a></td><td nowrap="nowrap"><h4
  style="margin: 0 0 0 0; padding: 0 1em;">The Perl Authors Upload
  Server</h4></td><td align="right" style="width: 100%;"></td></tr></table><br /><form
 action="http://pause.perl.org/pause/query"
 enctype="application/x-www-form-urlencoded"
 method="get"><table border="0" cellpadding="1"><tr><td valign="top"><table width="155" cellspacing="1" cellpadding="0"><tr><td class="menuitem"><a class="menuitem" href="https://pause.perl.org/pause/authenquery">Login</a></td></tr>
<tr><td class="menuheading" colspan="2"><b>Public menu</b></td></tr><tr><td class="menuitem"><a class="menuitem" href="query?ACTION=request_id">Request PAUSE account</a></td><td class="menupointer"></td></tr>
<tr><td class="menuitem"><a class="menuitem" href="query?ACTION=mailpw">Forgot Password?</a></td><td class="menupointer"></td></tr>
<tr><td class="menuitem"><a class="menuitem" href="query?ACTION=pause_04about">About PAUSE</a></td><td class="menupointer"></td></tr>
<tr><td class="menuitem"><a class="menuitem" href="query?ACTION=pause_04imprint">Imprint/Impressum</a></td><td class="menupointer"></td></tr>
<tr><td class="menuitem"><a class="menuitem" href="query?ACTION=pause_05news">PAUSE News</a></td><td class="menupointer"></td></tr>

<tr><td class="menuitem"><a class="menuitem" href="query?ACTION=pause_06history">PAUSE History</a></td><td class="menupointer"></td></tr>
<tr><td class="activemenu"><a class="activemenu" href="query?ACTION=who_is">&gt; Who is Who (long)</a></td><td class="menupointer"></td></tr>
</table>
</td><td valign="top" bgcolor="red"
>&nbsp;</td><td valign="top">
<h2 class="firstheader">Who is Who (long)</h2>
<h3>People, <a href="#mailinglists">Mailinglists</a> And
	       <a href="#mlarchives">Mailinglist Archives</a></h3>1.   <a href="mailto:">&lt;&gt;</a> -- AFOXSON<br />

2.   <a href="mailto:moe334578-pause@yahoo.com">&lt;moe334578-pause@yahoo.com&gt;</a> -- YOHAMED<br />
3.   <a href="mailto:">&lt;&gt;</a> -- DREAMG<br />
4.   <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEXMEC">TEXMEC</a><br />
5. <a href="www.alanstephens.pwp.blueyonder.co.uk"></a>  <a href="mailto:">&lt;&gt;</a> -- ALANSTEP<br />

6.   <a href="mailto:">&lt;&gt;</a> -- PGASKILL<br />
7. <a href="http://groovis.net"></a>  <a href="mailto:groovis@groovis.net">&lt;groovis@groovis.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GROOVIS">GROOVIS</a><br />
8.   <a href="mailto:">&lt;&gt;</a> -- DUCKYYAZY<br />
9. ---to be removed---  <a href="mailto:goosefish@cpan.org">&lt;goosefish@cpan.org&gt;</a> -- GOOSEFISH<br />

10. <a href="www.symonds.net/~bhuvan/">A. Bhuvaneswaran</a>  <a href="mailto:bhuvanbk@yahoo.com">&lt;bhuvanbk@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHUVAN">BHUVAN</a><br />
11. A. PREM ANAND  <a href="mailto:prem_and@rediffmail.com,prem@ncbs.res.in">&lt;prem_and@rediffmail.com,prem@ncbs.res.in&gt;</a> -- BIOPREM<br />
12. <a href="http://www.unur.com/">A. Sinan Ünür</a>  <a href="mailto:nanis@runu.moc.invalid">&lt;nanis@runu.moc.invalid&gt;</a> -- NANIS<br />

13. <a href="adarshtp.googlepages.com">ADARSH TP</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ADARSHTP<br />
14. ADong  <a href="mailto:dxluo83@gmail.com">&lt;dxluo83@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADONG">ADONG</a><br />
15. AMR  <a href="mailto:">&lt;&gt;</a> -- ARIE<br />

16. Aamer Akhter  <a href="mailto:aakhter@gmail.com">&lt;aakhter@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AAKHTER">AAKHTER</a><br />
17. Aankhola Encorporated  <a href="mailto:aankhen-spamtrap@gmail.com">&lt;aankhen-spamtrap@gmail.com&gt;</a> -- AANKHEN<br />
18. <a href="http://aare.myrien.com/">Aare Vesi</a>  <a href="mailto:aare.cpan at myrien.com">&lt;aare.cpan at myrien.com&gt;</a> -- AARE<br />

19. Aaron Brown  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERFSONAR">PERFSONAR</a><br />
20. Aaron Coburn  <a href="mailto:acoburn@cpan.org">&lt;acoburn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACOBURN">ACOBURN</a><br />
21. <a href="http://www.analogrithems.com">Aaron Collins</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANALOG">ANALOG</a><br />

22. <a href="http://www.aconaway.com">Aaron Conaway</a>  <a href="mailto:kraken@cpan.org">&lt;kraken@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAKEN">KRAKEN</a><br />
23. Aaron Craig  <a href="mailto:aaron.craig@spacespa.it">&lt;aaron.craig@spacespa.it&gt;</a> -- ACRAIG<br />
24. Aaron Crane  <a href="mailto:cpan@aaroncrane.co.uk">&lt;cpan@aaroncrane.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARC">ARC</a><br />

25. <a href="http://superdupergames.org">Aaron Dalton</a>  <a href="mailto:aaron@daltons.ca">&lt;aaron@daltons.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACDALTON">ACDALTON</a><br />
26. <a href="http://www.silicongraffiti.com">Aaron Hawryluk</a>  <a href="mailto:aaron@silicongraffiti.com">&lt;aaron@silicongraffiti.com&gt;</a> -- ZOMBITHRD<br />
27. Aaron J. Mackey  <a href="mailto:amackey@virginia.edu">&lt;amackey@virginia.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMACKEY">AMACKEY</a><br />

28. <a href="http://www.aarontrevena.co.uk">Aaron James Trevena</a>  <a href="mailto:aaron-dot-trevena-at-gmail-dot-com">&lt;aaron-dot-trevena-at-gmail-dot-com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEEJAY">TEEJAY</a><br />
29. Aaron Johnson  <a href="mailto:aaronjjohnson@gmail.com">&lt;aaronjjohnson@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AARONJJ">AARONJJ</a><br />
30. <a href="http://www.dancygier.com">Aaron K Dancygier</a>  <a href="mailto:aaron@dancygier.com">&lt;aaron@dancygier.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AAKD">AAKD</a><br />

31. <a href="http:/www.sulfericacid.com">Aaron Lee Anderson</a>  <a href="mailto:sulfericacid@qwest.net">&lt;sulfericacid@qwest.net&gt;</a> -- SULFERIC<br />
32. Aaron Meyer  <a href="mailto:meyeaard@meyertech.net">&lt;meyeaard@meyertech.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEYEAARD">MEYEAARD</a><br />
33. Aaron Mitti  <a href="mailto:mitti@cpan.org">&lt;mitti@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MITTI">MITTI</a><br />

34. Aaron Scarisbrick  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AARONSCA">AARONSCA</a><br />
35. Aaron Schlaegel  <a href="mailto:aaron@iprosa.com">&lt;aaron@iprosa.com&gt;</a> -- SCHLAEGEL<br />
36. Aaron Sherman  <a href="mailto:ajs@ajs.com">&lt;ajs@ajs.com&gt;</a> -- ASHER<br />
37. <a href="http://aaronsokoloski.com">Aaron Sokoloski</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ASOKO<br />

38. <a href="http://www.aaronland.net">Aaron Straup Cope</a>  <a href="mailto:ascope@cpan.org">&lt;ascope@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASCOPE">ASCOPE</a><br />
39. <a href="http://www.uni.edu/~prefect/">Aaron Thompson</a>  <a href="mailto:aaron.thompson_DONT_WANT_SPAM@uni.edu">&lt;aaron.thompson_DONT_WANT_SPAM@uni.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PREFECT">PREFECT</a><br />
40. Aaron Wigley  <a href="mailto:aaron.wigley@rea-group.com">&lt;aaron.wigley@rea-group.com&gt;</a> -- WIGS<br />

41. Abdulaziz Ghuloum  <a href="mailto:aghuloum@cs.indiana.edu">&lt;aghuloum@cs.indiana.edu&gt;</a> -- AGHULOUM<br />
42. <a href="http://ulas.sixbit.org">Abdullah Ulas</a>  <a href="mailto:">&lt;&gt;</a> -- ULAS<br />
43. <a href="http://www.Test-Smoke.org/">Abe Timmerman</a>  <a href="mailto:abeltje@cpan.org">&lt;abeltje@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABELTJE">ABELTJE</a><br />

44. <a href="http://www.deeproot.co.in">Abhas Abhinav</a>  <a href="mailto:abhas@deeproot.co.in">&lt;abhas@deeproot.co.in&gt;</a> -- ABHAS<br />
45. <a href="http://www.cs.indiana.edu/~amahabal/">Abhijit Mahabal</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMAHABAL">AMAHABAL</a><br />
46. <a href="http://ams.wiw.org">Abhijit Menon-Sen</a>  <a href="mailto:ams@wiw.org">&lt;ams@wiw.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMS">AMS</a><br />

47. Abhinav Dhar  <a href="mailto:abhidharnoida@yahoo.com">&lt;abhidharnoida@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABHIDHAR">ABHIDHAR</a><br />
48. Abhinay Singh  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ABHISINGH<br />
49. <a href="http://www.ejain.com">Abhishek Jain</a>  <a href="mailto:subs@ejain.com">&lt;subs@ejain.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOYALI">GOYALI</a><br />

50. Abhishek Jindal  <a href="mailto:abhishekjdl@yahoo.com">&lt;abhishekjdl@yahoo.com&gt;</a> -- ABHISHEK<br />
51. <a href="http://www.abigail.be/">Abigail</a>  <a href="mailto:$cpan$@abigail.be">&lt;$cpan$@abigail.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABIGAIL">ABIGAIL</a><br />
52. <a href="http://dajoba.com">Abraham Ingersoll</a>  <a href="mailto:abe@dajoba.com">&lt;abe@dajoba.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABEROHAM">ABEROHAM</a><br />

53. Abram Terger  <a href="mailto:aaron@cpan.org">&lt;aaron@cpan.org&gt;</a> -- AARON<br />
54. <a href="http://studentmasjid.com">Abu Rasheed</a>  <a href="mailto:aburasheed@studentmasjid.com">&lt;aburasheed@studentmasjid.com&gt;</a> -- SUNNAH<br />
55. Aby Paul  <a href="mailto:apaul@novell.com">&lt;apaul@novell.com&gt;</a> -- ABYPAUL<br />

56. <a href="http://www.xray.mpe.mpg.de/~ach/">Achim Bohnet</a>  <a href="mailto:ach@mpe.mpg.de">&lt;ach@mpe.mpg.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACH">ACH</a><br />
57. <a href="http://perlgssapi.sourceforge.net/">Achim Grolms</a>  <a href="mailto:pause@grolmsnet.de">&lt;pause@grolmsnet.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGROLMS">AGROLMS</a><br />
58. <a href="http://www.ActiveState.com">ActiveState development team</a>  <a href="mailto:dev@ActiveState.com">&lt;dev@ActiveState.com&gt;</a> -- ASTEAM<br />

59. <a href="http://www.doctorlicense.com">Adam Arakelian</a>  <a href="mailto:adam.arakelian@verizon.net">&lt;adam.arakelian@verizon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAM">ADAM</a><br />
60. <a href="http://www.cypherspace.org/adam/">Adam Back</a>  <a href="mailto:adam@cypherspace.org">&lt;adam@cypherspace.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAMBACK">ADAMBACK</a><br />
61. <a href="http://starfighter.tumblr.com/">Adam Blinkinsop</a>  <a href="mailto:blinks@acm.org">&lt;blinks@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPACEMAN">SPACEMAN</a><br />

62. <a href="http://www.npjh.com">Adam Flott</a>  <a href="mailto:adam@npjh.com">&lt;adam@npjh.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFLOTT">AFLOTT</a><br />
63. <a href="http://konscia.com/">Adam Foust</a>  <a href="mailto:agf@cpan.org">&lt;agf@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGF">AGF</a><br />
64. Adam Gent  <a href="mailto:a.l.gent@cs.cf.ac.uk">&lt;a.l.gent@cs.cf.ac.uk&gt;</a> -- ADAMGENT<br />

65. <a href="www.adam-griffiths.co.uk">Adam Griffiths</a>  <a href="mailto:public@adam-griffiths.co.uk">&lt;public@adam-griffiths.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADZZ">ADZZ</a><br />
66. <a href="http://battleaxe.net">Adam Israel</a>  <a href="mailto:adam@battleaxe.net">&lt;adam@battleaxe.net&gt;</a> -- STONE<br />
67. Adam J. Foxson  <a href="mailto:afoxson@pobox.com">&lt;afoxson@pobox.com&gt;</a> -- FOX<br />

68. Adam J. Foxson  <a href="mailto:fhoxh at pobox dot com">&lt;fhoxh at pobox dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FH/FHOXH">FHOXH</a><br />
69. <a href="www.adkap.com">Adam J. Kaplan ☺</a>  <a href="mailto:akaplan@cpan[nospam].org">&lt;akaplan@cpan[nospam].org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKAPLAN">AKAPLAN</a><br />
70. Adam Jacob  <a href="mailto:holoway@cpan.org">&lt;holoway@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLOWAY">HOLOWAY</a><br />

71. <a href="http://www.iredale.net/">Adam John Trickett</a>  <a href="mailto:atrickett@cpan.org">&lt;atrickett@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATRICKETT">ATRICKETT</a><br />
72. <a href="http://ali.as/">Adam Kennedy</a>  <a href="mailto:adamk@cpan.org">&lt;adamk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAMK">ADAMK</a><br />
73. <a href="www.AdamMarquis.com">Adam Marquis</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AMARQUIS<br />

74. <a href="http://adammonsen.com/">Adam Monsen</a>  <a href="mailto:amonsen@cpan.org">&lt;amonsen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMONSEN">AMONSEN</a><br />
75. Adam Paynter  <a href="mailto:adapay@cpan.org">&lt;adapay@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAPAY">ADAPAY</a><br />
76. Adam Prime  <a href="mailto:adam.prime@utoronto.ca">&lt;adam.prime@utoronto.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APRIME">APRIME</a><br />

77. Adam Rich  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARICH">ARICH</a><br />
78. <a href="http://www.io.com/~johannz">Adam Rinehart</a>  <a href="mailto:">&lt;&gt;</a> -- JOHANNZ<br />
79. Adam Risi  <a href="mailto:ajrisi@gmail.com">&lt;ajrisi@gmail.com&gt;</a> -- ARISI<br />
80. Adam Roth  <a href="mailto:adamjroth@gmail.com">&lt;adamjroth@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/AROTH">AROTH</a><br />

81. Adam Sandberg Ericsson  <a href="mailto:popz.2k@gmail.com">&lt;popz.2k@gmail.com&gt;</a> -- POPZ<br />
82. <a href="http://adamspiers.org/">Adam Spiers</a>  <a href="mailto:cpan@adamCUT-HEREspiers.org">&lt;cpan@adamCUT-HEREspiers.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPIERS">ASPIERS</a><br />
83. <a href="http://ace4it.com">Adam Stubbs</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASTUBBS">ASTUBBS</a><br />

84. <a href="http://talsma.ca">Adam Talsma</a>  <a href="mailto:adamNO@SPAMtalsma.PLEASEca">&lt;adamNO@SPAMtalsma.PLEASEca&gt;</a> -- TALSMACA<br />
85. Adam Thomason  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATHOMASON">ATHOMASON</a><br />
86. Adam Tistler  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ATISTLER<br />

87. <a href="http://ipwebdev.com/weblog/">Adam Wendt</a>  <a href="mailto:adam@ipwebdev.com">&lt;adam@ipwebdev.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWENDT">AWENDT</a><br />
88. Adam Worrall  <a href="mailto:adam-pause@worrall.cc">&lt;adam-pause@worrall.cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WORRALL">WORRALL</a><br />
89. Adekunle Olonoh  <a href="mailto:koolade@users.sourceforge.net">&lt;koolade@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADEO">ADEO</a><br />

90. Adeola Awoyemi  <a href="mailto:adeola@fotango.com">&lt;adeola@fotango.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADEOLA">ADEOLA</a><br />
91. <a href="http://adiraj.org/">Adi Fairbank</a>  <a href="mailto:adiraj@cpan.org">&lt;adiraj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADIRAJ">ADIRAJ</a><br />
92. <a href="http://www.alevin.com/weblog">Adina Levin</a>  <a href="mailto:alevin@alevin.com">&lt;alevin@alevin.com&gt;</a> -- ALEVIN<br />

93. Aditya Wasudeo  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ADITYA<br />
94. <a href="http://www.centipaid.com">Adonis El Fakih</a>  <a href="mailto:aelfakih@cpan.org">&lt;aelfakih@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AELFAKIH">AELFAKIH</a><br />
95. Adrabi Abderrahim  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LOVEX<br />

96. Adrian Arnautu  <a href="mailto:a_arnautu@yahoo.com">&lt;a_arnautu@yahoo.com&gt;</a> -- ADRIANA<br />
97. <a href="http://www.mirapoint.com">Adrian Hall</a>  <a href="mailto:adrianhall@mirapoint.com">&lt;adrianhall@mirapoint.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHALL">AHALL</a><br />
98. <a href="http://web.warhound.org/">Adrian Hosey</a>  <a href="mailto:alh@warhound.org">&lt;alh@warhound.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHOSEY">AHOSEY</a><br />

99. <a href="http://www.quietstars.com/perl/">Adrian Howard</a>  <a href="mailto:adrianh@quietstars.com">&lt;adrianh@quietstars.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADIE">ADIE</a><br />
100. <a href="http://transpero.net">Adrian McMenamin</a>  <a href="mailto:adrian@mcmen.demon.co.uk">&lt;adrian@mcmen.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACMCMEN">ACMCMEN</a><br />
101. Adrian Mugnolo  <a href="mailto:adrian@mugnolo.com">&lt;adrian@mugnolo.com&gt;</a> -- AMUGNOLO<br />

102. Adrian Priscak  <a href="mailto:apriscak@gmail.com">&lt;apriscak@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APRISCAK">APRISCAK</a><br />
103. Adrian Witas  <a href="mailto:adrian@webapp.strefa.pl">&lt;adrian@webapp.strefa.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADRIANWIT">ADRIANWIT</a><br />
104. <a href="http://www.ferreira.triang.net">Adriano Ferreira</a>  <a href="mailto:ferreira@cpan.org">&lt;ferreira@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FERREIRA">FERREIRA</a><br />

105. <a href="http://users.ox.ac.uk/~linc1775/">Ahamarshan JN</a>  <a href="mailto:gene@gpse.org">&lt;gene@gpse.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASHGENE">ASHGENE</a><br />
106. <a href="http://www.anvari.org/">Ahmad Anvari</a>  <a href="mailto:ahmad at morva dot net">&lt;ahmad at morva dot net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHMAD">AHMAD</a><br />
107. <a href="http://www.mewsoft.com">Ahmed Amin Elsheshtawy</a>  <a href="mailto:support@mewsoft.com">&lt;support@mewsoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEWSOFT">MEWSOFT</a><br />

108. Aidan Mountford  <a href="mailto:aidan@oz.to">&lt;aidan@oz.to&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AI/AIDAN">AIDAN</a><br />
109. <a href="http://www.aijazansari.com">Aijaz Ansari</a>  <a href="mailto:enoor@cpan.org">&lt;enoor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENOOR">ENOOR</a><br />
110. <a href="http://www.airwave.com/">AirWave Wireless</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AI/AIRWAVE">AIRWAVE</a><br />

111. Akihito Takeda  <a href="mailto:takeda.akihito@gmail.com">&lt;takeda.akihito@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKIHITO">AKIHITO</a><br />
112. <a href="http://poccori.com/">Akiko Yokoyama</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ACOTIE<br />
113. Akimov Alexey  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKIMOV">AKIMOV</a><br />

114. Akira HIROSE  <a href="mailto:ahirose+cpan@gmail.com">&lt;ahirose+cpan@gmail.com&gt;</a> -- AHIROSE<br />
115. <a href="http://www.hangai.net">Akira Hangai</a>  <a href="mailto:akira@hangai.net">&lt;akira@hangai.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKIRA">AKIRA</a><br />
116. Akira Horimoto  <a href="mailto:emperor.kurt@gmail.com">&lt;emperor.kurt@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLLY">HOLLY</a><br />

117. Al Nguyen  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANGUYEN">ANGUYEN</a><br />
118. Al Nikolov  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLOWN">CLOWN</a><br />
119. Ala Qumsieh  <a href="mailto:aqumsieh@cpan.org">&lt;aqumsieh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AQ/AQUMSIEH">AQUMSIEH</a><br />
120. Alagarsamy  <a href="mailto:samy@cpan.org">&lt;samy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMY">SAMY</a><br />

121. <a href="http://www.alianwebserver.com">Alain Barbet</a>  <a href="mailto:alian@alianwebserver.com">&lt;alian@alianwebserver.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALIAN">ALIAN</a><br />
122. <a href="http://www.alain.knaff.lu">Alain Knaff</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALKNAFF">ALKNAFF</a><br />
123. Alain Williams  <a href="mailto:addw@phcomp.co.uk">&lt;addw@phcomp.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADDW">ADDW</a><br />

124. Alan Barclay  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABARCLAY">ABARCLAY</a><br />
125. <a href="http://eatabrick.org/">Alan Berndt</a>  <a href="mailto:aberndt@cpan.org">&lt;aberndt@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABERNDT">ABERNDT</a><br />
126. Alan Burlison  <a href="mailto:Alan.Burlison@UK.Sun.COM">&lt;Alan.Burlison@UK.Sun.COM&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABURLISON">ABURLISON</a><br />

127. Alan Champion  <a href="mailto:A.Champion@gre.ac.uk">&lt;A.Champion@gre.ac.uk&gt;</a> -- ALANC<br />
128. Alan Citterman  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALANCITT">ALANCITT</a><br />
129. <a href="http://adickey.addr.com/">Alan Dickey</a>  <a href="mailto:afdickey@intac.com">&lt;afdickey@intac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALDICKEY">ALDICKEY</a><br />

130. <a href="http://aederhaag.home.comcast.net/">Alan E Derhaag</a>  <a href="mailto:aederhaag@comcast.net">&lt;aederhaag@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DERHAAG">DERHAAG</a><br />
131. <a href="aom.pace.edu/aeisner">Alan Eisner</a>  <a href="mailto:aeisner@pace.edu">&lt;aeisner@pace.edu&gt;</a> -- AEISNER<br />
132. Alan Ferrency  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FERRENCY">FERRENCY</a><br />

133. Alan G. Stewart  <a href="mailto:astewart1@cox.net">&lt;astewart1@cox.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASTEWART">ASTEWART</a><br />
134. <a href="http://alanhaggai.org">Alan Haggai Alavi</a>  <a href="mailto:alanhaggai@alanhaggai.org">&lt;alanhaggai@alanhaggai.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAGGAI">HAGGAI</a><br />
135. <a href="http://www.afco.demon.co.uk/">Alan J. Fry</a>  <a href="mailto:afj@afco.demon.co.uk">&lt;afj@afco.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJFRY">AJFRY</a><br />

136. <a href="http://www.ajackson.org/">Alan K. Jackson</a>  <a href="mailto:alanj@ajackson.org">&lt;alanj@ajackson.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJACKSON">AJACKSON</a><br />
137. Alan K. Stebbens  <a href="mailto:aks@stebbens.org">&lt;aks@stebbens.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKSTE">AKSTE</a><br />
138. <a href="http://consoleninja.net">Alan Kasindorf</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DORMANDO">DORMANDO</a><br />

139. Alan Pownall  <a href="mailto:alpow@gotadsl.co.uk">&lt;alpow@gotadsl.co.uk&gt;</a> -- ALPOW<br />
140. Alan Scheinine  <a href="mailto:scheinin@crs4.it">&lt;scheinin@crs4.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALSCH">ALSCH</a><br />
141. <a href="http://araw.mede.uic.edu/~alansz">Alan Schwartz</a>  <a href="mailto:alansz@uic.edu">&lt;alansz@uic.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALANSZ">ALANSZ</a><br />

142. <a href="http://www.harleypig.com">Alan Young</a>  <a href="mailto:alansyoungiii@gmail.com">&lt;alansyoungiii@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AY/AYOUNG">AYOUNG</a><br />
143. <a href="http://www.astro.ex.ac.uk/people/aa/">Alasdair Allan</a>  <a href="mailto:aa@astro.ex.ac.uk">&lt;aa@astro.ex.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AALLAN">AALLAN</a><br />
144. <a href="http://wWwWwW.cCeEsStTeErR.de">Albert Cester</a>  <a href="mailto:aAlLbBeErRtT.cCeEsStTeErR@web.de">&lt;aAlLbBeErRtT.cCeEsStTeErR@web.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACESTER">ACESTER</a><br />

145. <a href="http://avatar.deva.net/">Albert K. T. Hui</a>  <a href="mailto:avatar@deva.net">&lt;avatar@deva.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVATAR">AVATAR</a><br />
146. Albert Michauer  <a href="mailto:abuse@mail.ru">&lt;abuse@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMICHAUER">AMICHAUER</a><br />
147. <a href="http://www.tobert.org">Albert P Tobey</a>  <a href="mailto:tobeya@cpan.org">&lt;tobeya@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBEYA">TOBEYA</a><br />

148. <a href="http://alfarrabio.di.uminho.pt/~albie">Alberto Manuel Brandão Simões</a>  <a href="mailto:albie@alfarrabio.di.uminho.pt">&lt;albie@alfarrabio.di.uminho.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMBS">AMBS</a><br />
149. Alberto Montero Asenjo  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AMONTERO<br />
150. <a href="http://reggiori.webweaving.org/">Alberto Reggiori</a>  <a href="mailto:areggiori@webweaving.org">&lt;areggiori@webweaving.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/AREGGIORI">AREGGIORI</a><br />

151. <a href="http://www.linkedin.com/in/alceufreitasjr">Alceu Rodrigues de Freitas Junior</a>  <a href="mailto:arfreitas@cpan.org">&lt;arfreitas@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARFREITAS">ARFREITAS</a><br />
152. <a href="http://dada.perl.it">Aldo Calpini</a>  <a href="mailto:dada@perl.it">&lt;dada@perl.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACALPINI">ACALPINI</a><br />
153. Aldo LeTellier  <a href="mailto:aletellier@epsiloninteractive.com">&lt;aletellier@epsiloninteractive.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALET">ALET</a><br />

154. <a href="http://www.msg.com.mx/~amedina">Alejandro Escalante Medina</a>  <a href="mailto:amedina@msg.com.mx">&lt;amedina@msg.com.mx&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMEDINA">AMEDINA</a><br />
155. <a href="http://bachue.com/alejo">Alejandro Forero Cuervo</a>  <a href="mailto:bachue@bachue.com">&lt;bachue@bachue.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AZ/AZUL">AZUL</a><br />
156. <a href="http://mogaal.com">Alejandro Garrido Mota</a>  <a href="mailto:mogaal@cpan.org">&lt;mogaal@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOGAAL">MOGAAL</a><br />

157. <a href="http://www.corcaribe.com">Alejandro Imass</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AI/AIMASS">AIMASS</a><br />
158. <a href="http://www.bsdcoders.org/~alex">Alejandro Juarez</a>  <a href="mailto:alex@bsdcoders.org">&lt;alex@bsdcoders.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALECS">ALECS</a><br />
159. <a href="http://www.techcode.net">Aleksandar Petrović</a>  <a href="mailto:">&lt;&gt;</a> -- TECHCODE<br />

160. <a href="http://olo.org.pl">Aleksander Adamowski</a>  <a href="mailto:cpan@olo.org.pl">&lt;cpan@olo.org.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAMOWSKI">ADAMOWSKI</a><br />
161. Aleksandr Guidrevitch  <a href="mailto:pillgrim@mail.ru">&lt;pillgrim@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALGDR">ALGDR</a><br />
162. Aleksey Surikov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSURI">KSURI</a><br />

163. <a href="http://www.orion.it/~alf/">Alessandro Forghieri</a>  <a href="mailto:alf@cerline.com">&lt;alf@cerline.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALFO">ALFO</a><br />
164. Alessandro Gatti  <a href="mailto:">&lt;&gt;</a> -- AGATTI<br />
165. <a href="http://www.dlevel.com/blogs/alex">Alessandro Iob</a>  <a href="mailto:alessandro.iob@gmail.com">&lt;alessandro.iob@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXIOB">ALEXIOB</a><br />

166. <a href="http://alex.primafila.net">Alessandro Ranellucci</a>  <a href="mailto:aar@cpan.org">&lt;aar@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AAR">AAR</a><br />
167. Alessandro Zummo  <a href="mailto:azummo-cpan@towertech.it">&lt;azummo-cpan@towertech.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZU/ZUMMO">ZUMMO</a><br />
168. Alex  <a href="mailto:a_x_s_@_a_r_b_o_r_n_e_t_._o_r_g">&lt;a_x_s_@_a_r_b_o_r_n_e_t_._o_r_g&gt;</a> -- AXS<br />

169. Alex  <a href="mailto:yak@nm.ru">&lt;yak@nm.ru&gt;</a> -- YAKWOO<br />
170. Alex  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLCGI">PLCGI</a><br />
171. Alex A.  <a href="mailto:talex@cpan.org">&lt;talex@cpan.org&gt;</a> -- TALEX<br />
172. Alex Ayars  <a href="mailto:sounds like paws at n o d e k i t dot o r g">&lt;sounds like paws at n o d e k i t dot o r g&gt;</a> -- AAYARS<br />

173. <a href="http://kaoru.slackwise.net/">Alex Balhatchet</a>  <a href="mailto:kaoru@slackwise.net">&lt;kaoru@slackwise.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAORU">KAORU</a><br />
174. Alex Boutov  <a href="mailto:">&lt;&gt;</a> -- ABOUTOV<br />
175. Alex Bowley  <a href="mailto:kilinrax [at] cpan [dot] org">&lt;kilinrax [at] cpan [dot] org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KILINRAX">KILINRAX</a><br />

176. <a href="http://www.supremacyllc.com/">Alex Corral</a>  <a href="mailto:alex@precharge.com">&lt;alex@precharge.com&gt;</a> -- ALEXPRECH<br />
177. <a href="http://www.widgetworks.com">Alex Crain</a>  <a href="mailto:wworks@widgetworks.com">&lt;wworks@widgetworks.com&gt;</a> -- WWORKS<br />
178. <a href="http://www.guruperl.net">Alex Danoff</a>  <a href="mailto:guruperl@cpan.org">&lt;guruperl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GURUPERL">GURUPERL</a><br />

179. Alex Davies  <a href="mailto:alex.davies@talktalk.net">&lt;alex.davies@talktalk.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAVIES">ADAVIES</a><br />
180. <a href="http://powerman.name/">Alex Efros</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POWERMAN">POWERMAN</a><br />
181. <a href="http://www.saude-eletronica.com.br/webmaster/">Alex Falcao</a>  <a href="mailto:alexjfalcao@hotmail.com">&lt;alexjfalcao@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FALCAO">FALCAO</a><br />

182. <a href="http://alexfrancis.org.uk">Alex Francis</a>  <a href="mailto:alex@alexfrancis.org.uk">&lt;alex@alexfrancis.org.uk&gt;</a> -- ALEXF<br />
183. Alex Gallichotte  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AGALLI<br />
184. <a href="http://the.earth.li/~alex/">Alex Gough</a>  <a href="mailto:alex@earth.li">&lt;alex@earth.li&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJGOUGH">AJGOUGH</a><br />

185. <a href="http://www.hornby.org.uk/">Alex Hornby</a>  <a href="mailto:alex (at) hornby.org.uk">&lt;alex (at) hornby.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHORNBY">AHORNBY</a><br />
186. Alex Izvorski  <a href="mailto:aizvorski@cpan.org">&lt;aizvorski@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AI/AIZVORSKI">AIZVORSKI</a><br />
187. <a href="http://innenin.blogspot.com/">Alex J. Avriette</a>  <a href="mailto:avriette@gmail.com">&lt;avriette@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEX">ALEX</a><br />

188. Alex J. G. Burzyński  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AJGB<br />
189. <a href="http://www.twoshortplanks.com/alex/sigs/">Alex Knowles</a>  <a href="mailto:aknowles@uk.yahoo-inc.com">&lt;aknowles@uk.yahoo-inc.com&gt;</a> -- KNOWLES<br />
190. <a href="http://www.lingua-systems.com/">Alex Linke</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALINKE">ALINKE</a><br />

191. <a href="www.alexlomas.com">Alex Lomas</a>  <a href="mailto:alexlomas at cpan dot org">&lt;alexlomas at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXLOMAS">ALEXLOMAS</a><br />
192. Alex Manoussakis  <a href="mailto:alx@cpan.org">&lt;alx@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALX">ALX</a><br />
193. <a href="http://www.slab.org/alex/">Alex McLean</a>  <a href="mailto:foochre@slab.org">&lt;foochre@slab.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FOOCHRE">FOOCHRE</a><br />

194. <a href="http://yaxu.org/">Alex McLean</a>  <a href="mailto:cpan@mail.slab.org">&lt;cpan@mail.slab.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YA/YAXU">YAXU</a><br />
195. <a href="http://www.owal.co.uk">Alex McLintock</a>  <a href="mailto:alex at owal dot co dot uk">&lt;alex at owal dot co dot uk&gt;</a> -- ALEXMC<br />
196. <a href="http://alexm.org/">Alex Muntada</a>  <a href="mailto:alexm@cpan.org">&lt;alexm@cpan.org&gt;</a> -- ALEXM<br />

197. <a href="http://noptr.com">Alex Nunes</a>  <a href="mailto:cpan@noptr.com">&lt;cpan@noptr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANUNES">ANUNES</a><br />
198. <a href="http://www.cpio.org/~grimoire/">Alex Page</a>  <a href="mailto:grimoire@corinne.cpio.org">&lt;grimoire@corinne.cpio.org&gt;</a> -- GRIMOIRE<br />
199. <a href="www.taskforce-1.com">Alex Pavlovic</a>  <a href="mailto:alexp@cpan.org">&lt;alexp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXP">ALEXP</a><br />

200. <a href="http://sourceforge.net/projects/asnmtap">Alex Peeters</a>  <a href="mailto:alex.peeters@citap.be">&lt;alex.peeters@citap.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASNMTAP">ASNMTAP</a><br />
201. <a href="http://www.formenos.org/">Alex Pilosov</a>  <a href="mailto:alex@pilosoft.com">&lt;alex@pilosoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APILOS">APILOS</a><br />
202. Alex Pleiner  <a href="mailto:alex-cpan.ext2@zeitform.de">&lt;alex-cpan.ext2@zeitform.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APLEINER">APLEINER</a><br />

203. <a href="http://bkmks.com">Alex Protasenko</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SASHA">SASHA</a><br />
204. Alex Rak  <a href="mailto:arak@cpan.org">&lt;arak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARAK">ARAK</a><br />
205. Alex Robinson  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SG/SGP">SGP</a><br />

206. <a href="http://www.alphacomplex.info">Alex Sayle</a>  <a href="mailto:alexs@alphacomplex.info">&lt;alexs@alphacomplex.info&gt;</a> -- ALEXS<br />
207. <a href="http://synthcode.com">Alex Shinn</a>  <a href="mailto:foof@synthcode.com">&lt;foof@synthcode.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FOOF">FOOF</a><br />
208. Alex Soukhotine  <a href="mailto:htmaniac@mail.ru">&lt;htmaniac@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXEVIL">ALEXEVIL</a><br />

209. Alex Taler  <a href="mailto:dissent@cpan.org">&lt;dissent@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DISSENT">DISSENT</a><br />
210. <a href="http://petrified.cic.net/~altitude">Alex Tang</a>  <a href="mailto:altitude@cic.net">&lt;altitude@cic.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALTITUDE">ALTITUDE</a><br />
211. <a href="http://chmrr.net/">Alex Vandiver</a>  <a href="mailto:alexmv+pause@mit.edu">&lt;alexmv+pause@mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXMV">ALEXMV</a><br />

212. <a href="http://www.geekfarm.org/wu/muse/WebHome.html">Alex White</a>  <a href="mailto:VVu@geekfarm.org">&lt;VVu@geekfarm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VV/VVU">VVU</a><br />
213. Alex White  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AWHITE<br />
214. Alexander  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KASHA">KASHA</a><br />

215. Alexander Anderson  <a href="mailto:a.anderson@utoronto.ca">&lt;a.anderson@utoronto.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDALE">ANDALE</a><br />
216. Alexander Christian Westholm  <a href="mailto:awestholm@verizon.net">&lt;awestholm@verizon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWESTHOLM">AWESTHOLM</a><br />
217. Alexander David P  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALPO">ALPO</a><br />

218. <a href="http://preferans.de">Alexander Farber</a>  <a href="mailto:farber@cpan.org">&lt;farber@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FARBER">FARBER</a><br />
219. <a href="http://vivien.franken.de/">Alexander Goller</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DECAY">DECAY</a><br />
220. <a href="http://www.cronossystems.com">Alexander Golomshtok</a>  <a href="mailto:agolomsh@cronossystems.com">&lt;agolomsh@cronossystems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGOLOMSH">AGOLOMSH</a><br />

221. Alexander Haderer  <a href="mailto:alexander.haderer@loescap.de">&lt;alexander.haderer@loescap.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFRIKA">AFRIKA</a><br />
222. <a href="http://abraxxa.zorro.at">Alexander Hartmaier</a>  <a href="mailto:abraxxa@cpan.org">&lt;abraxxa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABRAXXA">ABRAXXA</a><br />
223. Alexander Jung  <a href="mailto:alexander.w.jung@gmail.com">&lt;alexander.w.jung@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJUNG">AJUNG</a><br />

224. Alexander Karelas  <a href="mailto:karjala@karjala.org">&lt;karjala@karjala.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARJALA">KARJALA</a><br />
225. <a href="http://www.shiftordie.de">Alexander Klink</a>  <a href="mailto:alech@cpan.org">&lt;alech@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALECH">ALECH</a><br />
226. <a href="http://blogs.sun.com/akolb">Alexander Kolbasov</a>  <a href="mailto:alexander.kolbasov@sun.com">&lt;alexander.kolbasov@sun.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKOLB">AKOLB</a><br />

227. Alexander Korolyoff  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KILORK">KILORK</a><br />
228. Alexander Kühne  <a href="mailto:alexk@cpan.org">&lt;alexk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXK">ALEXK</a><br />
229. <a href="http://aml.rulezz.ru">Alexander Lourier</a>  <a href="mailto:aml@rulezz.ru">&lt;aml@rulezz.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AML">AML</a><br />

230. Alexander N. Skovpen  <a href="mailto:green@gelf.no-ip.org">&lt;green@gelf.no-ip.org&gt;</a> -- ANS<br />
231. <a href="http://zowers.narod.ru/">Alexander Petrov</a>  <a href="mailto:zowers@mail.ru">&lt;zowers@mail.ru&gt;</a> -- ZOWERS<br />
232. <a href="http://www.spiegelrichtig.de">Alexander Schober</a>  <a href="mailto:a.d.j.schober@t-online.de">&lt;a.d.j.schober@t-online.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIRROROK">MIRROROK</a><br />

233. <a href="http://code.anapraxis.net">Alexander Scouras</a>  <a href="mailto:alexscouras@hotmail.com">&lt;alexscouras@hotmail.com&gt;</a> -- LEXICON<br />
234. <a href="http://iclub.nsu.ru/~celf/">Alexander Soudakov</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CY/CYGA">CYGA</a><br />
235. Alexander Sousa  <a href="mailto:alexandersousa@gmail.com">&lt;alexandersousa@gmail.com&gt;</a> -- XANDRE<br />

236. <a href="http://www.d2rk.com">Alexander Sviridenko</a>  <a href="mailto:mail@d2rk.com">&lt;mail@d2rk.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEARL">PEARL</a><br />
237. Alexander Temerev  <a href="mailto:sorhed@gmail.com">&lt;sorhed@gmail.com&gt;</a> -- SORHED<br />
238. Alexander Vogel  <a href="mailto:avoge@cpan.org">&lt;avoge@cpan.org&gt;</a> -- AVOGE<br />

239. Alexander Voishchev  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VO/VOISCHEV">VOISCHEV</a><br />
240. <a href="http://snafu.priv.at/">Alexander Zangerl</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALPHAZULU">ALPHAZULU</a><br />
241. <a href="www.nowhere.ru">Alexander mcLander</a>  <a href="mailto:alex@nowhere.ru">&lt;alex@nowhere.ru&gt;</a> -- MCLANDER<br />

242. <a href="http://chorny.net">Alexandr Ciornii</a>  <a href="mailto:alexchorny@gmail.com">&lt;alexchorny@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHORNY">CHORNY</a><br />
243. <a href="http://www.nikosoft.net/">Alexandre Aufrere</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AAU">AAU</a><br />
244. <a href="http://perso.ens-lyon.fr/alexandre.buisse">Alexandre Buisse</a>  <a href="mailto:Nattfodd@gmail.com">&lt;Nattfodd@gmail.com&gt;</a> -- NATTFODD<br />

245. <a href="http://www.foo.be/">Alexandre Dulaunoy</a>  <a href="mailto:adulau@foo.be">&lt;adulau@foo.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADULAU">ADULAU</a><br />
246. Alexandre Gattiker  <a href="mailto:">&lt;&gt;</a> -- AGATT<br />
247. Alexandre Jousset  <a href="mailto:REMOVE.cpan&lt;_at_&gt;gtmp.org.REMOVE">&lt;REMOVE.cpan&lt;_at_&gt;gtmp.org.REMOVE&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIDNITE">MIDNITE</a><br />

248. <a href="http://quintal.dyndns.org">Alexandre Martins de Carvalho</a>  <a href="mailto:amcarvalho@bragatel.pt">&lt;amcarvalho@bragatel.pt&gt;</a> -- ACARVALHO<br />
249. Alexandre Masselot  <a href="mailto:alexandre.masselot@genebio.com">&lt;alexandre.masselot@genebio.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXMASS">ALEXMASS</a><br />
250. <a href="http://www.vtt.co.jp/staff/sorokin/">Alexandre Sorokine</a>  <a href="mailto:srk@users.sourceforge.net">&lt;srk@users.sourceforge.net&gt;</a> -- SORO<br />

251. Alexandru Palade  <a href="mailto:alexandru [.] palade [funny-a] psrk [.] com">&lt;alexandru [.] palade [funny-a] psrk [.] com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APALADE">APALADE</a><br />
252. <a href="www.opener.asia">Alexe</a>  <a href="mailto:alexe.cn@gmail.com">&lt;alexe.cn@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXE">ALEXE</a><br />
253. <a href="http://www.bible.ru/">Alexei Rudenko</a>  <a href="mailto:rudenko@bible.ru">&lt;rudenko@bible.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUDENKO">RUDENKO</a><br />

254. <a href="http://russoz.wordpress.com">Alexei Znamensky</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUSSOZ">RUSSOZ</a><br />
255. <a href="http://alexandrov.me/">Alexey Alexandrov</a>  <a href="mailto:swined@cpan.org">&lt;swined@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWINED">SWINED</a><br />
256. Alexey E.Manokhin  <a href="mailto:alexey.manokhin@mail.ru">&lt;alexey.manokhin@mail.ru&gt;</a> -- AMANOKHIN<br />

257. Alexey Khobov  <a href="mailto:akhobov@yahoo.com">&lt;akhobov@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKHOBOV">AKHOBOV</a><br />
258. Alexey Klimkin  <a href="mailto:klimkin at cpan.org">&lt;klimkin at cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KL/KLIMKIN">KLIMKIN</a><br />
259. <a href="http://kovyrin.info/">Alexey Kovyrin</a>  <a href="mailto:kovyrin@gmail.com">&lt;kovyrin@gmail.com&gt;</a> -- SCOUNDREL<br />

260. Alexey Kravchuk  <a href="mailto:ak2@smr.ru">&lt;ak2@smr.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKR">AKR</a><br />
261. Alexey Radkov  <a href="mailto:alexey.radkov@gmail.com">&lt;alexey.radkov@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RADKOV">RADKOV</a><br />
262. <a href="http://swaj.net">Alexey Semenoff</a>  <a href="mailto:swaj@swaj.net">&lt;swaj@swaj.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWAJ">SWAJ</a><br />

263. Alexey Sharafutdinov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASVBR">ASVBR</a><br />
264. Alexey Stroganov  <a href="mailto:alexey.stroganov@gmail.com">&lt;alexey.stroganov@gmail.com&gt;</a> -- RANGER<br />
265. <a href="http://alexeyt.freeshell.org/">Alexey Toptygin</a>  <a href="mailto:alexeyt@cpan.org">&lt;alexeyt@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALEXEYT">ALEXEYT</a><br />

266. Alexey Tourbin  <a href="mailto:at@altlinux.org">&lt;at@altlinux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATOURBIN">ATOURBIN</a><br />
267. <a href="http://qtpl.sf.net/">Alexey V. Presnyakov</a>  <a href="mailto:alexey_pres@users.sourceforge.net">&lt;alexey_pres@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVP">AVP</a><br />
268. Alexey Zinger  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AZINGER<br />

269. <a href="http://www.sukria.net/en">Alexis Sukrieh</a>  <a href="mailto:sukria@sukria.net">&lt;sukria@sukria.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUKRIA">SUKRIA</a><br />
270. <a href="http://www.slac.stanford.edu/~alfw">Alf Wachsmann</a>  <a href="mailto:alfw@slac.stanford.edu">&lt;alfw@slac.stanford.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALFW">ALFW</a><br />
271. <a href="http://rental-property.co.nz">Alfie John</a>  <a href="mailto:cpan@share-house.com.au">&lt;cpan@share-house.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALFIE">ALFIE</a><br />

272. Alfred Anzlovar  <a href="mailto:alfred.anzlovar@logon.si">&lt;alfred.anzlovar@logon.si&gt;</a> -- AANZLOVAR<br />
273. Alfred Reibenschuh  <a href="mailto:alfredreibenschuh@gmx.net">&lt;alfredreibenschuh@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/AREIBENS">AREIBENS</a><br />
274. <a href="http://www.perl.lt">Algirdas Rokas</a>  <a href="mailto:kyoshu@cpan.org">&lt;kyoshu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYOSHU">KYOSHU</a><br />

275. <a href="http://www.hodgers.com/ali">Ali Craigmile</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALIC">ALIC</a><br />
276. Ali Işık  <a href="mailto:fenLisesi ! gmail">&lt;fenLisesi ! gmail&gt;</a> -- LEPTON<br />
277. <a href="http://ali.dnsalias.com">Ali Mohamad Ali</a>  <a href="mailto:ali@ali.dnsalias.com">&lt;ali@ali.dnsalias.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALI">ALI</a><br />

278. <a href="http://www.zdo.com/">Ali Onur Cinar</a>  <a href="mailto:root@zdo.com">&lt;root@zdo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AO/AOCINAR">AOCINAR</a><br />
279. Alin Iacob  <a href="mailto:alin@cpan.org">&lt;alin@cpan.org&gt;</a> -- ALIN<br />
280. Alireza Aghamohammadi  <a href="mailto:aghamohammadi@hotmail.com">&lt;aghamohammadi@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VIGREP">VIGREP</a><br />

281. Alistair Cunningham  <a href="mailto:ac212@debian.org">&lt;ac212@debian.org&gt;</a> -- ALISTAIRC<br />
282. <a href="http://www.alizta.com/">Alistair Francis</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALIZTA">ALIZTA</a><br />
283. <a href="http://www.cybaea.com/">Allan Engelhardt</a>  <a href="mailto:allane@cybaea.com">&lt;allane@cybaea.com&gt;</a> -- CYBAEA<br />

284. <a href="http://afields.ca">Allan Fields</a>  <a href="mailto:perl@afields.ca">&lt;perl@afields.ca&gt;</a> -- AFIELDS<br />
285. Allan Juul  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAMBRETTA<br />
286. Allan Paul Kelly  <a href="mailto:allankelly@eh42.com">&lt;allankelly@eh42.com&gt;</a> -- APKELLY<br />

287. <a href="http://www.perlmonks.org/?node_id=404137">Allan Rene Dystrup Nielsen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ADY<br />
288. Allard Hoeve  <a href="mailto:hoeve@cpan.org">&lt;hoeve@cpan.org&gt;</a> -- HOEVE<br />
289. <a href="http://achen.cjas.org/">Allen Chen</a>  <a href="mailto:aec1@cornell.edu">&lt;aec1@cornell.edu&gt;</a> -- ALLENCHEN<br />

290. <a href="http://www.wooly.org/~allenday">Allen Day</a>  <a href="mailto:allenday@cpan.org">&lt;allenday@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALLENDAY">ALLENDAY</a><br />
291. <a href="http://code.mincus.com">Allen Holman</a>  <a href="mailto:mincus@cpan.org">&lt;mincus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MINCUS">MINCUS</a><br />
292. <a href="http://cesario.rutgers.edu/easmith/computers/index.html#perl">Allen Smith</a>  <a href="mailto:actual@spamcop.net">&lt;actual@spamcop.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALLENS">ALLENS</a><br />

293. <a href="http://www.symbolstone.org">Alligator Descartes</a>  <a href="mailto:descarte@symbolstone.org">&lt;descarte@symbolstone.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADESC">ADESC</a><br />
294. <a href="http://www.lohutok.net">Allison Randal</a>  <a href="mailto:allison@perl.org">&lt;allison@perl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARANDAL">ARANDAL</a><br />
295. <a href="http://8ln.org">Alon Altman</a>  <a href="mailto:pause@8ln.org">&lt;pause@8ln.org&gt;</a> -- EPSALON<br />

296. <a href="http://www.perl-blog.de/">Alvar C.H. Freude</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ALVAR<br />
297. Alvaro Livraghi  <a href="mailto:alvarol@cpan.org">&lt;alvarol@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALVAROL">ALVAROL</a><br />
298. <a href="http://www-ti.informatik.uni-tuebingen.de/~subraman">Amarendran R. Subramanian</a>  <a href="mailto:subraman@informatik.uni-tuebingen.de">&lt;subraman@informatik.uni-tuebingen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMAR">AMAR</a><br />

299. <a href="http://developer.amazonwebservices.com">Amazon Web Services team</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AWS<br />
300. <a href="http://www.amias.org.uk/">Amias Channer</a>  <a href="mailto:cpan@amiasDOTorg.uk">&lt;cpan@amiasDOTorg.uk&gt;</a> -- AMIAS<br />
301. <a href="http://home.comcast.net/~amirkarger">Amir Karger</a>  <a href="mailto:amirkargerweb@yahoo.com">&lt;amirkargerweb@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKARGER">AKARGER</a><br />

302. <a href="http://www.gentoo.org.il">Amit Sides</a>  <a href="mailto:amit.sides@gmail.com">&lt;amit.sides@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMITSIDES">AMITSIDES</a><br />
303. Amos Shapira  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMOSS">AMOSS</a><br />
304. <a href="http://www.cs.pitt.edu/~amruta">Amruta Purandare</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMRUTA">AMRUTA</a><br />

305. <a href="http://www.cs.cmu.edu/~anaghak/">Anagha K Kulkarni</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANAGHAKK">ANAGHAKK</a><br />
306. <a href="http://www.cs.virginia.edu/~an4m/">Anand Natrajan</a>  <a href="mailto:anand@virginia.edu">&lt;anand@virginia.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANATRA">ANATRA</a><br />
307. Anand Vallabhajosula  <a href="mailto:avallabh@gmail.com">&lt;avallabh@gmail.com&gt;</a> -- AVALLABH<br />

308. <a href="http://www.7a69ezine.org">Anarion</a>  <a href="mailto:anarion@7a69ezine.org">&lt;anarion@7a69ezine.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANARION">ANARION</a><br />
309. Anastasi Thomas  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ATHOMAS<br />
310. <a href="http://tolikus.hq.aaanet.ru:8080">Anatoly K. Lasareff</a>  <a href="mailto:tolik@aaanet.ru">&lt;tolik@aaanet.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOLIKL">TOLIKL</a><br />

311. Anatoly Vorobey  <a href="mailto:avorobey@pobox.com">&lt;avorobey@pobox.com&gt;</a> -- AVOROBEY<br />
312. Anbalagan Pugaleesan  <a href="mailto:anbu78@gmail.com">&lt;anbu78@gmail.com&gt;</a> -- ANBU<br />
313. <a href="http://www.it.lth.se/anders/">Anders Ardö</a>  <a href="mailto:Anders.Ardo@it.lth.se">&lt;Anders.Ardo@it.lth.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AARDO">AARDO</a><br />

314. <a href="http://www.andersjohnson.com/home.html">Anders Johnson</a>  <a href="mailto:anders@ieee.org">&lt;anders@ieee.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDERS">ANDERS</a><br />
315. <a href="http://www.andersberle.com/">Anders Nor Berle</a>  <a href="mailto:berle@cpan.org">&lt;berle@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BERLE">BERLE</a><br />
316. <a href="http://www.indexdata.dk/">Anders Sonderberg Mortensen</a>  <a href="mailto:sondberg@indexdata.dk">&lt;sondberg@indexdata.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SONDBERG">SONDBERG</a><br />

317. <a href="http://www.jss.hu">Andras Jeszenszky</a>  <a href="mailto:too.many.spam@jsi.hu">&lt;too.many.spam@jsi.hu&gt;</a> -- ANDREWJSI<br />
318. <a href="http://www.byredox.com">Andre</a>  <a href="mailto:redox@terra.com.br">&lt;redox@terra.com.br&gt;</a> -- REDOX<br />
319. Andre Boeddecker  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ABOL<br />

320. Andre Guimaraes  <a href="mailto:aguimaraes@email.com.br">&lt;aguimaraes@email.com.br&gt;</a> -- AGUIMARA<br />
321. <a href="http://cs.vu.nl/~merzky">Andre Merzky</a>  <a href="mailto:andre@merzky.net">&lt;andre@merzky.net&gt;</a> -- AMERZKY<br />
322. Andre Rodrigues Viegas  <a href="mailto:andre@writeme.com.br">&lt;andre@writeme.com.br&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARVIEGAS">ARVIEGAS</a><br />

323. <a href="http://sundale.net">Andre Yelistratov</a>  <a href="mailto:swampfox@cpan.org">&lt;swampfox@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWAMPFOX">SWAMPFOX</a><br />
324. <a href="http://www.qitty.net">Andrea Benazzo</a>  <a href="mailto:andy@qitty.net">&lt;andy@qitty.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENAZZO">BENAZZO</a><br />
325. Andrea Di Pippo  <a href="mailto:andrea.dipalma@gmail.com">&lt;andrea.dipalma@gmail.com&gt;</a> -- ADIPALMA<br />

326. Andrea Gnerre  <a href="mailto:andreg@itcom.it">&lt;andreg@itcom.it&gt;</a> -- ANDREGNEX<br />
327. <a href="http://www.xant.net">Andrea Guzzo</a>  <a href="mailto:xant@cpan.org">&lt;xant@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XA/XANT">XANT</a><br />
328. Andrea Holstein  <a href="mailto:andrea_holsten@yahoo.de">&lt;andrea_holsten@yahoo.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLSTEN">HOLSTEN</a><br />

329. Andrea Nall  <a href="mailto:anall@cpan.org">&lt;anall@cpan.org&gt;</a> -- ANALL<br />
330. <a href="http://www.geocities.com/RainForest/9626">Andrea Spinelli</a>  <a href="mailto:aspinelli@imteam.it">&lt;aspinelli@imteam.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPINELLI">ASPINELLI</a><br />
331. <a href="http://www.sys-network.de">Andreas 'ac0v' Specht</a>  <a href="mailto:ac0v@sys-network.de">&lt;ac0v@sys-network.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACID">ACID</a><br />

332. Andreas Brey  <a href="mailto:abrey@gmx.net">&lt;abrey@gmx.net&gt;</a> -- ABREY<br />
333. Andreas Faafeng  <a href="mailto:aff@cpan.org">&lt;aff@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFF">AFF</a><br />
334. Andreas Ferber  <a href="mailto:aferber@cpan.org">&lt;aferber@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFERBER">AFERBER</a><br />

335. <a href="http://www.informatik.hu-berlin.de/~fitzner">Andreas Fitzner</a>  <a href="mailto:andreas.fitzner@fv-berlin.de">&lt;andreas.fitzner@fv-berlin.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FITZNER">FITZNER</a><br />
336. <a href="http://andreas-grimme.gmxhome.de/">Andreas Grimme</a>  <a href="mailto:">&lt;&gt;</a> -- AGRIMME<br />
337. Andreas J. König  <a href="mailto:andreas.koenig@anima.de">&lt;andreas.koenig@anima.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDK">ANDK</a><br />

338. <a href="http://www.furry.de/tabalon/">Andreas Jaekel</a>  <a href="mailto:tabalon@furry.de">&lt;tabalon@furry.de&gt;</a> -- AJAEKEL<br />
339. Andreas Kryger Jensen  <a href="mailto:xylofonius at hotpop dot com">&lt;xylofonius at hotpop dot com&gt;</a> -- XYLOS<br />
340. Andreas Mager  <a href="mailto:quattro@cpan.org">&lt;quattro@cpan.org&gt;</a> -- QUATTRO<br />

341. <a href="http://www.amahnke.de">Andreas Mahnke</a>  <a href="mailto:Andreas_Mahnke@web.de">&lt;Andreas_Mahnke@web.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAHNKONG">MAHNKONG</a><br />
342. Andreas Marcel Riechert  <a href="mailto:amr@cpan.org">&lt;amr@cpan.org&gt;</a> -- AMR<br />
343. Andreas Marienborg  <a href="mailto:omega@palle.net">&lt;omega@palle.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREMAR">ANDREMAR</a><br />

344. Andreas Scherbaum  <a href="mailto:ads-cpan@ufp.de">&lt;ads-cpan@ufp.de&gt;</a> -- ASCHERBAU<br />
345. Andreas Scherbaum  <a href="mailto:ads-cpan@wars-nicht.de">&lt;ads-cpan@wars-nicht.de&gt;</a> -- SCHERBAUM<br />
346. <a href="http://schipplock.de">Andreas Schipplock</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AVARUS<br />

347. Andreas Schuster  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SCHUSTER<br />
348. <a href="http://www.visualco.de">Andreas Spindler</a>  <a href="mailto:info@visualco.de">&lt;info@visualco.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPINDLER">ASPINDLER</a><br />
349. Andreas Stiller  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASTILLER">ASTILLER</a><br />

350. <a href="http://andreidreamer.com">Andrei Kozovski</a>  <a href="mailto:andrei@cpan.org">&lt;andrei@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREI">ANDREI</a><br />
351. <a href="http://www.andrein.com/">Andrei Nossov</a>  <a href="mailto:andrein@andrein.com">&lt;andrein@andrein.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREIN">ANDREIN</a><br />
352. <a href="http://ctpp.havoc.ru">Andrei V. Shetuhin</a>  <a href="mailto:slonik-v-domene@mail.ru">&lt;slonik-v-domene@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STELLAR">STELLAR</a><br />

353. <a href="http://www.ank.com.ar">Andres Kievsky</a>  <a href="mailto:ank@ank.com.ar">&lt;ank@ank.com.ar&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANK">ANK</a><br />
354. <a href="http://uzdesign.com">Andrew</a>  <a href="mailto:andrew@uzdesign.com">&lt;andrew@uzdesign.com&gt;</a> -- XAOS<br />
355. <a href="http://www.andrewmoore.com/">Andrew  Moore</a>  <a href="mailto:amoore@cpan.org">&lt;amoore@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMOORE">AMOORE</a><br />

356. Andrew A. Chen  <a href="mailto:achen-cpan@divo.net">&lt;achen-cpan@divo.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACHEN">ACHEN</a><br />
357. <a href="http://www.an.kiev.ua/">Andrew Alexandre Novikov</a>  <a href="mailto:perl@an.kiev.ua">&lt;perl@an.kiev.ua&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREWN">ANDREWN</a><br />
358. <a href="http://www.ooblick.com/">Andrew Arensburger</a>  <a href="mailto:arensb+pause@ooblick.com">&lt;arensb+pause@ooblick.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARENSB">ARENSB</a><br />

359. Andrew Boag  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BOAG<br />
360. Andrew Brosnan  <a href="mailto:andrew@broscom.com">&lt;andrew@broscom.com&gt;</a> -- ABROSNAN<br />
361. Andrew Brown  <a href="mailto:andy75@hotmail.com">&lt;andy75@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDYB">ANDYB</a><br />
362. Andrew Burke  <a href="mailto:aburke@bitflood.org">&lt;aburke@bitflood.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABURKE">ABURKE</a><br />

363. <a href="http://www.piffle.org/">Andrew Chadwick</a>  <a href="mailto:and-x-rewc@pi-y-ffle.org.z">&lt;and-x-rewc@pi-y-ffle.org.z&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREWC">ANDREWC</a><br />
364. <a href="http://www.geocities.com/ahammau">Andrew Clarke</a>  <a href="mailto:ahamm@programmer.net">&lt;ahamm@programmer.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHAMM">AHAMM</a><br />
365. <a href="www.idoimaging.com">Andrew Crabb</a>  <a href="mailto:andy@idoimaging.com">&lt;andy@idoimaging.com&gt;</a> -- ACRABB<br />

366. <a href="http://www.cognimetric.com/acrawford">Andrew Crawford</a>  <a href="mailto:acrawford@cpan.org">&lt;acrawford@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACRAWFORD">ACRAWFORD</a><br />
367. <a href="http://geocities.com/andrew_d_allen/">Andrew D. Allen</a>  <a href="mailto:andrew_d_allen@hotmail.com">&lt;andrew_d_allen@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALLEN">ALLEN</a><br />
368. <a href="http://frdcsa.org/~andrewdo">Andrew Dougherty</a>  <a href="mailto:andrewdo@frdcsa.org">&lt;andrewdo@frdcsa.org&gt;</a> -- ANDREWD<br />

369. Andrew E Page  <a href="mailto:andrew.e.page@gmail.com">&lt;andrew.e.page@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AEPAGE">AEPAGE</a><br />
370. <a href="http://www.andreweland.org">Andrew Eland</a>  <a href="mailto:put-andrew-here@andreweland.org">&lt;put-andrew-here@andreweland.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AELAND">AELAND</a><br />
371. <a href="http://www.wetware.com/drieux/">Andrew F. Hampe</a>  <a href="mailto:drieux@wetware.com">&lt;drieux@wetware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRIEUX">DRIEUX</a><br />

372. <a href="http://www.andrew.findlay.org/">Andrew Findlay</a>  <a href="mailto:andrew.findlay@skills-1st.co.uk">&lt;andrew.findlay@skills-1st.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFINDLAY">AFINDLAY</a><br />
373. Andrew Flerchinger  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICRF">ICRF</a><br />
374. Andrew Flint  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARNHEMCR">ARNHEMCR</a><br />

375. <a href="http://andrew-ford.com/">Andrew Ford</a>  <a href="mailto:A.Ford@ford-mason.co.uk">&lt;A.Ford@ford-mason.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREWF">ANDREWF</a><br />
376. <a href="http://openbsd.somedomain.net">Andrew Fresh</a>  <a href="mailto:andrew@cpan.org">&lt;andrew@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREW">ANDREW</a><br />
377. <a href="http://www.article7.co.uk/">Andrew Green</a>  <a href="mailto:andrew@article7.co.uk">&lt;andrew@article7.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARTICLE">ARTICLE</a><br />

378. <a href="http://grom.host.ru/">Andrew Gromozdin</a>  <a href="mailto:andygrom@zenon.net">&lt;andygrom@zenon.net&gt;</a> -- ANDYGROM<br />
379. <a href="http://www.hicox.com">Andrew Hicox</a>  <a href="mailto:andrew@hicox.com">&lt;andrew@hicox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHICOX">AHICOX</a><br />
380. <a href="http://www.zeuscat.com/andrew/">Andrew Ho</a>  <a href="mailto:andrew@zeuscat.com">&lt;andrew@zeuscat.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREWHO">ANDREWHO</a><br />

381. Andrew Hoying  <a href="mailto:ahoying@cpan.org">&lt;ahoying@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHOYING">AHOYING</a><br />
382. <a href="http://andrew.bromage.org/">Andrew J. Bromage</a>  <a href="mailto:ajb@spamcop.net">&lt;ajb@spamcop.net&gt;</a> -- BROMAGE<br />
383. <a href="https://itso.iu.edu/ajk/">Andrew J. Korty</a>  <a href="mailto:korty@cpan.org">&lt;korty@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KORTY">KORTY</a><br />

384. Andrew J. Savige  <a href="mailto:asavige@cpan.org">&lt;asavige@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASAVIGE">ASAVIGE</a><br />
385. <a href="http://it.toolbox.com/people/lajandy">Andrew Johnson</a>  <a href="mailto:lajandy at cpan.org">&lt;lajandy at cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAJANDY">LAJANDY</a><br />
386. <a href="http://www.voicent.com">Andrew Kerns</a>  <a href="mailto:andrew@voicent.com">&lt;andrew@voicent.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDREWIK">ANDREWIK</a><br />

387. <a href="http://ubermonkey.net">Andrew Kirkpatrick</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SPACEBAT<br />
388. <a href="http://www.siaris.net/">Andrew L. Johnson</a>  <a href="mailto:andrew-johnson@shaw.ca">&lt;andrew-johnson@shaw.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJOHNSON">AJOHNSON</a><br />
389. <a href="http://www.alaroy.com">Andrew LaRoy</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAROY<br />

390. Andrew Langmead  <a href="mailto:aml@world.std.com">&lt;aml@world.std.com&gt;</a> -- LANGMEAD<br />
391. Andrew Lee  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AFIACRE<br />
392. Andrew Leung  <a href="mailto:aleunpkc@hotmail.com">&lt;aleunpkc@hotmail.com&gt;</a> -- LEUNGA<br />
393. Andrew M. Garland  <a href="mailto:amgarland-at-cpan.org">&lt;amgarland-at-cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMGARLAND">AMGARLAND</a><br />

394. <a href="http://www.whistlinglemons.com">Andrew M. Pressel</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PRESSEL<br />
395. <a href="http://www.fysh.org/~zefram/">Andrew Main (Zefram)</a>  <a href="mailto:zefram@fysh.org">&lt;zefram@fysh.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZEFRAM">ZEFRAM</a><br />
396. <a href="http://www.buck2k.com">Andrew Malone Melo</a>  <a href="mailto:cpan@world-of-frags.com">&lt;cpan@world-of-frags.com&gt;</a> -- BUCKY<br />

397. <a href="http://ejelta.com/">Andrew Maltsev</a>  <a href="mailto:am@ejelta.com">&lt;am@ejelta.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMALTSEV">AMALTSEV</a><br />
398. <a href="http://www.txm.net/">Andrew McGregor</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCGREGOR">MCGREGOR</a><br />
399. <a href="http:/www.scoop.co.nz/">Andrew McNaughton</a>  <a href="mailto:andrew@scoop.co.nz">&lt;andrew@scoop.co.nz&gt;</a> -- AMCN<br />

400. Andrew Molloy  <a href="mailto:amolloy@kaizolabs.com">&lt;amolloy@kaizolabs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMOLLOY">AMOLLOY</a><br />
401. Andrew OBrien  <a href="mailto:">&lt;&gt;</a> -- ANDREWO<br />
402. <a href="www.och.cc">Andrew Och</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AOCH<br />

403. Andrew P. J. Gierth  <a href="mailto:andrew@tao11.riddles.org.uk">&lt;andrew@tao11.riddles.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGIERTH">AGIERTH</a><br />
404. <a href="www.dragonstaff.com">Andrew Payne</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNAFUFANS">SNAFUFANS</a><br />
405. <a href="http://www.emporiumbooks.com.au">Andrew Punch</a>  <a href="mailto:andrewpunch at emporiumbooks dot com dot au">&lt;andrewpunch at emporiumbooks dot com dot au&gt;</a> -- TEAMBOB<br />

406. Andrew Robertson  <a href="mailto:critter_75075@yahoo.com">&lt;critter_75075@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAFFIEND">CAFFIEND</a><br />
407. Andrew Rodland  <a href="mailto:ARODLAND@cpan.org">&lt;ARODLAND@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARODLAND">ARODLAND</a><br />
408. Andrew S. Kennedy  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHAMROCK">SHAMROCK</a><br />

409. Andrew Schamp  <a href="mailto:andy@schamp.net">&lt;andy@schamp.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASCHAMP">ASCHAMP</a><br />
410. Andrew Sherrod  <a href="mailto:yaldabaoth@geocities.com">&lt;yaldabaoth@geocities.com&gt;</a> -- ASHERROD<br />
411. Andrew Shitov  <a href="mailto:andy@shitov.ru">&lt;andy@shitov.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDY">ANDY</a><br />

412. <a href="http://www.zpok.demon.co.uk/">Andrew Simmons</a>  <a href="mailto:andrew@zpok.demon.co.uk">&lt;andrew@zpok.demon.co.uk&gt;</a> -- SIMMONSA<br />
413. <a href="http://webdyne.org/">Andrew Speer</a>  <a href="mailto:andrew.speer@isolutions.com.au">&lt;andrew.speer@isolutions.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPEER">ASPEER</a><br />
414. <a href="http://www.cs.uml.edu/~astanley/">Andrew Stanley</a>  <a href="mailto:astanley@cs.uml.edu">&lt;astanley@cs.uml.edu&gt;</a> -- ASTANLEY<br />

415. <a href="http://andrew.sterling.hanenkamp.com/">Andrew Sterling Hanenkamp</a>  <a href="mailto:hanenkamp@cpan.org">&lt;hanenkamp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANENKAMP">HANENKAMP</a><br />
416. Andrew Stewart Williams  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASW">ASW</a><br />
417. <a href="http://www.mentalcode.com">Andrew Strader</a>  <a href="mailto:strader@cpan.org">&lt;strader@cpan.org&gt;</a> -- STRADER<br />

418. Andrew Strebkov  <a href="mailto:pause03@flight.us">&lt;pause03@flight.us&gt;</a> -- ASTRB<br />
419. Andrew Stribblehill  <a href="mailto:ads@wompom.org">&lt;ads@wompom.org&gt;</a> -- STRIB<br />
420. Andrew Stringer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ANDREWS<br />
421. <a href="http://perlocity.org/~yDNA/">Andrew Sweger</a>  <a href="mailto:yDNA@perlocity.org">&lt;yDNA@perlocity.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YD/YDNA">YDNA</a><br />

422. <a href="http://turner.mikomi.org/">Andrew Turner</a>  <a href="mailto:turner@mikomi.org">&lt;turner@mikomi.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TU/TURNERA">TURNERA</a><br />
423. <a href="http://www.tutolmin.com/">Andrew Tutolmin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TUTOLMIN<br />
424. <a href="http://makarov.arkhangelsk.ru">Andrew V. Makarow</a>  <a href="mailto:makarow@mail.com">&lt;makarow@mail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAKAROW">MAKAROW</a><br />

425. Andrew V. Purshottam  <a href="mailto:andy@taylors.org">&lt;andy@taylors.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDYPUR">ANDYPUR</a><br />
426. Andrew Westrate  <a href="mailto:westrate at cpan dot org">&lt;westrate at cpan dot org&gt;</a> -- WESTRATE<br />
427. Andrew Whitworth  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WKNIGHT<br />
428. Andrew Wilcox  <a href="mailto:andrew_wilcox@gwi.net">&lt;andrew_wilcox@gwi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMW">AMW</a><br />

429. <a href="http://www.awgibbs.com">Andrew William Gibbs</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWGIBBS">AWGIBBS</a><br />
430. Andrew Wilson  <a href="mailto:andrew@rivendale.net">&lt;andrew@rivendale.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NU/NUANCE">NUANCE</a><br />
431. <a href="http://www.ivarch.com/">Andrew Wood</a>  <a href="mailto:andrew dot wood at ivarch dot com">&lt;andrew dot wood at ivarch dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJWOOD">AJWOOD</a><br />

432. <a href="http://www.dilex.net">Andrew Wyllie</a>  <a href="mailto:awyllie@dilex.net">&lt;awyllie@dilex.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WY/WYLLIE">WYLLIE</a><br />
433. Andrew Yates  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AY/AYATES">AYATES</a><br />
434. Andrew Zhilenko  <a href="mailto:andrew@ti.cz">&lt;andrew@ti.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANOWAR">MANOWAR</a><br />

435. <a href="www.idesign.kiev.ua">Andrey Mykhaylov</a>  <a href="mailto:mia@interfax.kiev.ua">&lt;mia@interfax.kiev.ua&gt;</a> -- VECTOR<br />
436. Andrey Smorodin  <a href="mailto:smorodin2001@yahoo.com">&lt;smorodin2001@yahoo.com&gt;</a> -- SAV<br />
437. Andrey Yakovlev  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- VVD<br />

438. Andrian Zubko  <a href="mailto:ondr@mail.ru">&lt;ondr@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/ON/ONDR">ONDR</a><br />
439. <a href="http://open-sendmail.source-forge.net/">Andrzej Adam Filip</a>  <a href="mailto:anfi@onet.eu">&lt;anfi@onet.eu&gt;</a> -- ANFI<br />
440. <a href="http://www.dns.net/andras/">András Salamon</a>  <a href="mailto:azs@cpan.org">&lt;azs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AZ/AZS">AZS</a><br />

441. <a href="http://perl.problemlos.ch/">André Bonhôte</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANBON">ANBON</a><br />
442. Andy Adler  <a href="mailto:adler@ncf.ca">&lt;adler@ncf.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AADLER">AADLER</a><br />
443. <a href="http://hexten.net">Andy Armstrong</a>  <a href="mailto:andy@hexten.net">&lt;andy@hexten.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDYA">ANDYA</a><br />

444. Andy Brezinsky  <a href="mailto:abrezinsky@brevient.com">&lt;abrezinsky@brevient.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABREZINS">ABREZINS</a><br />
445. <a href="http://vampiresoftware.blogspot.com/">Andy Brown</a>  <a href="mailto:andyb@operamail.com">&lt;andyb@operamail.com&gt;</a> -- SETITESUK<br />
446. <a href="http://www.kerrupt.com">Andy Dixon</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJDIXON">AJDIXON</a><br />

447. <a href="http://www.lafayette.edu/~doughera/index.html">Andy Dougherty</a>  <a href="mailto:doughera@lafayette.edu">&lt;doughera@lafayette.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDYD">ANDYD</a><br />
448. Andy Duncan  <a href="mailto:andy_j_duncan@yahoo.com">&lt;andy_j_duncan@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANDYDUNC">ANDYDUNC</a><br />
449. <a href="http://www.moil.demon.co.uk/cmenu/index.html">Andy Ferguson</a>  <a href="mailto:cmenu@afccommercial.co.uk">&lt;cmenu@afccommercial.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DREWF">DREWF</a><br />

450. <a href="http://www.finkenstadt.com/andy/">Andy Finkenstadt</a>  <a href="mailto:andy@finkenstadt.com">&lt;andy@finkenstadt.com&gt;</a> -- KAHUNA<br />
451. <a href="http://www.cs.wisc.edu/~glew/glew.html">Andy Glew</a>  <a href="mailto:glew@cs.wisc.edu">&lt;glew@cs.wisc.edu&gt;</a> -- ANDYGLEW<br />
452. Andy Grundman  <a href="mailto:andy@hybridized.org">&lt;andy@hybridized.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGRUNDMA">AGRUNDMA</a><br />

453. <a href="http://perlmonks.org/?node=naChoZ">Andy Harrison</a>  <a href="mailto:{ domain =&gt; 'gmail', user =&gt; 'aharrison', tld =&gt; 'com' }">&lt;{ domain =&gt; 'gmail', user =&gt; 'aharrison', tld =&gt; 'com' }&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHARRISON">AHARRISON</a><br />
454. <a href="http://www.andyjohn.com/perl">Andy John</a>  <a href="mailto:andyj@andyjohn.com">&lt;andyj@andyjohn.com&gt;</a> -- ANDYJ<br />

455. <a href="http://www.mopoke.co.uk/">Andy Kelk</a>  <a href="mailto:cpan@mopoke.co.uk">&lt;cpan@mopoke.co.uk&gt;</a> -- MOPOKE<br />
456. <a href="http://www.petdance.com">Andy Lester</a>  <a href="mailto:andy@petdance.com">&lt;andy@petdance.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETDANCE">PETDANCE</a><br />
457. <a href="neverintheoffice.net">Andy Mendelsohn</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ANDMEN<br />

458. Andy Murren  <a href="mailto:amurren@cpan.org">&lt;amurren@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMURREN">AMURREN</a><br />
459. Andy Orr  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AO/AORR">AORR</a><br />
460. Andy Palmer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ANDYP<br />
461. Andy Pritchard  <a href="mailto:andy at the-pritchards dot com">&lt;andy at the-pritchards dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NINJA">NINJA</a><br />

462. <a href="http://www.journeyman.net/">Andy Settle</a>  <a href="mailto:andy.settle@usa.net">&lt;andy.settle@usa.net&gt;</a> -- ICENI<br />
463. Andy Sharples  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SHARPLESA<br />
464. <a href="http://andys.org.uk/">Andy Smith</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEH">MEH</a><br />

465. Andy Walker  <a href="mailto:andrew_robert_walker@yahoo.co.uk">&lt;andrew_robert_walker@yahoo.co.uk&gt;</a> -- ANDYW<br />
466. <a href="http://whereisandy.com">Andy Walker</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WALKER<br />
467. <a href="http://wardley.org/">Andy Wardley</a>  <a href="mailto:cpan@wardley.org">&lt;cpan@wardley.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABW">ABW</a><br />

468. <a href="http://www.lampsolutions.co.uk/">Andy Williams</a>  <a href="mailto:perl@lampsolutions.co.uk">&lt;perl@lampsolutions.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANWILL">ANWILL</a><br />
469. <a href="http://www.zonemaster.org">Andy Wolf</a>  <a href="mailto:zonemaster@users.sourceforge.net">&lt;zonemaster@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WOLF">WOLF</a><br />
470. <a href="http://www.kean.edu/~becka">Andy beck</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FLUFFYNJ<br />

471. Angel Nikolaev Kolev  <a href="mailto:meneldor@gmail.com">&lt;meneldor@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANIO">ANIO</a><br />
472. <a href="http://www.pallotron.net - http://www.vitadiunsysadmin.net">Angelo &quot;pallotron&quot; Failla</a>  <a href="mailto:pallotron &lt;at&gt; freaknet &lt;dot&gt; org">&lt;pallotron &lt;at&gt; freaknet &lt;dot&gt; org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PALLOTRON">PALLOTRON</a><br />

473. Angelo Lucia  <a href="mailto:angelo.lucia@email.it">&lt;angelo.lucia@email.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUCHA">LUCHA</a><br />
474. Angus Lees  <a href="mailto:gus@inodes.org">&lt;gus@inodes.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANGUSLEES">ANGUSLEES</a><br />
475. Angus Wood  <a href="mailto:angus@z-y-g-o.com">&lt;angus@z-y-g-o.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWOOD">AWOOD</a><br />

476. <a href="http://www.cs.virginia.edu/~an7s/">Anh Nguyen-Tuong</a>  <a href="mailto:nguyen@virginia.edu">&lt;nguyen@virginia.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANH">ANH</a><br />
477. Animator  <a href="mailto:pause@spam.wizbit.be">&lt;pause@spam.wizbit.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANIMATOR">ANIMATOR</a><br />
478. <a href="http://www.chatterjee.net/">Anirvan Chatterjee</a>  <a href="mailto:anirvan at cpan dot org">&lt;anirvan at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANIRVAN">ANIRVAN</a><br />

479. Ankit Agarwal  <a href="mailto:ankit.agarwal83@gmail.com">&lt;ankit.agarwal83@gmail.com&gt;</a> -- ANKITS<br />
480. Ankur Maheshbhai Patwa  <a href="mailto:patwa.ankur@gmail.com">&lt;patwa.ankur@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APATWA">APATWA</a><br />
481. Ann Barcomb  <a href="mailto:kudra@domaintje.com">&lt;kudra@domaintje.com&gt;</a> -- KUDRA<br />
482. Anna Durai  <a href="mailto:mayur.thakare@neilsoft.com">&lt;mayur.thakare@neilsoft.com&gt;</a> -- ANNADURAI<br />

483. <a href="http://popoludnica.pl">Anna Wiejak</a>  <a href="mailto:anias@popoludnica.pl">&lt;anias@popoludnica.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANIAS">ANIAS</a><br />
484. <a href="http://www.tu-berlin.de/~siegel">Anno Siegel</a>  <a href="mailto:siegel@zrz.tu-berlin.de">&lt;siegel@zrz.tu-berlin.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANNO">ANNO</a><br />
485. Anonymous  <a href="mailto:">&lt;&gt;</a> -- PETERPG<br />

486. Anonymous TSM dev. Team  <a href="mailto:sniper@nerim.net">&lt;sniper@nerim.net&gt;</a> -- SCHNYBZER<br />
487. <a href="http://www.ccc.uni-erlangen.de/clark/horn/">Anselm H. C. Horn</a>  <a href="mailto:Anselm.Horn@chemie.uni-erlangen.de">&lt;Anselm.Horn@chemie.uni-erlangen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AH/AHCHORN">AHCHORN</a><br />
488. <a href="http://www.anselms.net/">Anselm Lingnau</a>  <a href="mailto:anselm-cpan@anselms.net">&lt;anselm-cpan@anselms.net&gt;</a> -- ALINGNAU<br />

489. <a href="http://www.stanford.edu/~afn/">Antal Novak</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFN">AFN</a><br />
490. Antano Solar John  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOLARANT">SOLARANT</a><br />
491. <a href="http://www.suave.net/">Anthony Ball</a>  <a href="mailto:ant_cpan@suave.net">&lt;ant_cpan@suave.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUAVEANT">SUAVEANT</a><br />

492. Anthony Barbachan  <a href="mailto:barbacha@Hinako.AMBusiness.com">&lt;barbacha@Hinako.AMBusiness.com&gt;</a> -- BARBACHAN<br />
493. <a href="http://killa.net/">Anthony D. Urso</a>  <a href="mailto:anthonyu@cpan.org">&lt;anthonyu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANTHONYU">ANTHONYU</a><br />
494. <a href="http://www.delorenzo.ca/">Anthony DeLorenzo</a>  <a href="mailto:anthony.delorenzo@gmail.com">&lt;anthony.delorenzo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJDELORE">AJDELORE</a><br />

495. Anthony Decena  <a href="mailto:mindhacker69@gmail.com">&lt;mindhacker69@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MINDHACK">MINDHACK</a><br />
496. Anthony Edward Cooper  <a href="mailto:support@coosoft.plus.com">&lt;support@coosoft.plus.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AECOOPER">AECOOPER</a><br />
497. <a href="http://www.chovy.com">Anthony Ettinger</a>  <a href="mailto:">&lt;&gt;</a> -- ETTINGER<br />

498. <a href="http://2799.org/">Anthony Fisher</a>  <a href="mailto:perl@2799.org">&lt;perl@2799.org&gt;</a> -- AEF<br />
499. Anthony Fletcher  <a href="mailto:arif@cpan.org">&lt;arif@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARIF">ARIF</a><br />
500. <a href=" http://www.geocities.com/pipeline/dropzone/6294">Anthony Fryer</a>  <a href="mailto:apfryer@hotmail.com">&lt;apfryer@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AF/AFRYER">AFRYER</a><br />

501. <a href="http://www.anthonypersaud.com">Anthony G Persaud</a>  <a href="mailto:apersaud@cpan.org">&lt;apersaud@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APERSAUD">APERSAUD</a><br />
502. <a href="http://anthony.kilna.com">Anthony Kilna</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KILNA<br />
503. <a href="http://www.chime.ucl.ac.uk/~rmhiajp/">Anthony Peacock</a>  <a href="mailto:a.peacock@chime.ucl.ac.uk">&lt;a.peacock@chime.ucl.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJPEACOCK">AJPEACOCK</a><br />

504. Anthony Richardson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- YNOTMGMA<br />
505. <a href="http://phm.ucd.ie/">Anthony Staines</a>  <a href="mailto:anthony_staines@hotmail.com">&lt;anthony_staines@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASTAINES">ASTAINES</a><br />
506. <a href="http://www.sct.gu.edu.au/~anthony/">Anthony Thyssen</a>  <a href="mailto:anthony@cit.gu.edu.au">&lt;anthony@cit.gu.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANTHONY">ANTHONY</a><br />

507. <a href="http://www.uoregon.edu/~tkay">Anthony W. Kay</a>  <a href="mailto:awkay69@yahoo.com">&lt;awkay69@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWKAY">AWKAY</a><br />
508. <a href="http://blog.ant0ine.com">Antoine Imbert</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AIMBERT<br />
509. <a href="http://www.ihme.org/~anzuhan">Antoine Kalmbach</a>  <a href="mailto:anzu@mbnet.fi">&lt;anzu@mbnet.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANZUHAN">ANZUHAN</a><br />

510. <a href="http://www.graougraou.com/">Antoine Quint</a>  <a href="mailto:antoine@graougraou.com">&lt;antoine@graougraou.com&gt;</a> -- GRAOUTS<br />
511. <a href="http://atma7.com">Anton Belousov</a>  <a href="mailto:abel@cpan.org">&lt;abel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABEL">ABEL</a><br />
512. <a href="http://www.tobez.org/">Anton Berezin</a>  <a href="mailto:tobez@tobez.org">&lt;tobez@tobez.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRUBER">GRUBER</a><br />

513. Anton Burnashev  <a href="mailto:">&lt;&gt;</a> -- BURNASH<br />
514. <a href="http://ha4.fajno.net">Anton Tayanovskyy</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOYVO">TOYVO</a><br />
515. <a href="http://www.geocities.com/CapeCanaveral/Hangar/4794/index.html">Antonio Rosella</a>  <a href="mailto:anface@yahoo.com">&lt;anface@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANTRO">ANTRO</a><br />

516. <a href="http://people.softwarelivre.org/~terceiro/">Antonio S. de A. Terceiro</a>  <a href="mailto:terceiro@softwarelivre.org">&lt;terceiro@softwarelivre.org&gt;</a> -- TERCEIRO<br />
517. Antonio San Juan  <a href="mailto:tneovk@terra.es">&lt;tneovk@terra.es&gt;</a> -- SYSDEV<br />
518. <a href="http://tonyavril.free.fr">Antony Avril</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TONYAVRIL<br />

519. Antti Vähäkotamäki  <a href="mailto:antti@dicole.com">&lt;antti@dicole.com&gt;</a> -- AMV<br />
520. <a href="http://www.linux.lk/~anu/">Anuradha Weeraman</a>  <a href="mailto:anuradha@cpan.org">&lt;anuradha@cpan.org&gt;</a> -- ANURADHA<br />
521. <a href="http://jinxedstar.0ne.us">Apocalypse</a>  <a href="mailto:perl@0ne.us">&lt;perl@0ne.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APOCAL">APOCAL</a><br />

522. <a href="http://apriljayres.wordpress.com">April Ayres</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AJAYRES<br />
523. <a href="http://www.bluefeet.net">Aran Clary Deltac</a>  <a href="mailto:bluefeet@cpan.org">&lt;bluefeet@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLUEFEET">BLUEFEET</a><br />
524. <a href="http://blackwizard.pp.ru">Arapov Denis</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWIZARD">BWIZARD</a><br />

525. Aravinda PR  <a href="mailto:aravindapr@rediffmail.com">&lt;aravindapr@rediffmail.com&gt;</a> -- ARVINDPR<br />
526. <a href="http://www.archivista.ch">Archivista GmbH, Markus Stocker</a>  <a href="mailto:webmaster@archivista.ch">&lt;webmaster@archivista.ch&gt;</a> -- AVCPAN<br />
527. <a href="http://www.archivista.ch">Archivista GmbH, Urs Pfister</a>  <a href="mailto:webmaster@archivista.ch">&lt;webmaster@archivista.ch&gt;</a> -- AVB<br />

528. <a href="http://earth.hut.fi/ajolma.html">Ari Jolma</a>  <a href="mailto:ari.jolma@hut.fi">&lt;ari.jolma@hut.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AJ/AJOLMA">AJOLMA</a><br />
529. Ariel Brosh (PAUSE Custodial Account)  <a href="mailto:modules@perl.org">&lt;modules@perl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHOP">SCHOP</a><br />
530. Ariel Scolnicov  <a href="mailto:ariels_314159@yahoo.com">&lt;ariels_314159@yahoo.com&gt;</a> -- ARIELS<br />

531. Arjen Laarhoven  <a href="mailto:arjen@cpan.org">&lt;arjen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARJEN">ARJEN</a><br />
532. Arkady Grudzinsky  <a href="mailto:grudziar@linuxhightech.com">&lt;grudziar@linuxhightech.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRUDZIAR">GRUDZIAR</a><br />
533. <a href="www.molevol.org">Arlin Stoltzfus</a>  <a href="mailto:stoltzfu@umbi.umd.edu">&lt;stoltzfu@umbi.umd.edu&gt;</a> -- ARLIN<br />

534. <a href="www.sanger.ac.uk/~av1">Armand Valsesia</a>  <a href="mailto:">&lt;&gt;</a> -- ARMAND<br />
535. <a href="http://armin.emx.at/cddb/">Armin Obersteiner</a>  <a href="mailto:armin@xos.net">&lt;armin@xos.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FONKIE">FONKIE</a><br />
536. <a href="http://www.eecs.umich.edu/~addi/perl/">Arnar Mar Hrafnkelsson</a>  <a href="mailto:addi@umich.edu">&lt;addi@umich.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADDI">ADDI</a><br />

537. <a href="http://marseille.pm.org">Arnaud &quot;Arhuman&quot; Assad</a>  <a href="mailto:arhuman@hotmail.com">&lt;arhuman@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AASSAD">AASSAD</a><br />
538. <a href="http://www.schoenewald.de/~arndt/">Arndt Schönewald</a>  <a href="mailto:arndt@schoenewald.de">&lt;arndt@schoenewald.de&gt;</a> -- ARNDT<br />

539. Arne Claassen  <a href="mailto:cpan [at] droogindustries.com">&lt;cpan [at] droogindustries.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDETHER">SDETHER</a><br />
540. Arne Georg Gleditsch  <a href="mailto:argggh@cpan.org">&lt;argggh@cpan.org&gt;</a> -- ARGGGH<br />
541. <a href="http://www.laramies.com">Arne Gödeke</a>  <a href="mailto:el+cpan@goodadvice.pages.de">&lt;el+cpan@goodadvice.pages.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGOE">AGOE</a><br />

542. Arne Skjærholt  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ARNSHOLT<br />
543. <a href="http://bbop.org/perl">Arne Sommer</a>  <a href="mailto:perl@bbop.org">&lt;perl@bbop.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARNE">ARNE</a><br />
544. Arockia Dhas  <a href="mailto:dhascruz@gmail.com">&lt;dhascruz@gmail.com&gt;</a> -- DHASCRUZ<br />

545. Arseni Mouchinski  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARSENI<br />
546. Art Sackett  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ASACKETT<br />
547. Artem S. Vybornov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ARTY<br />
548. Arther Garrett  <a href="mailto:satalink@yahoo.com">&lt;satalink@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SATALINK">SATALINK</a><br />

549. Arthur Choung  <a href="mailto:arthur_choung@yahoo.com">&lt;arthur_choung@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACHOUNG">ACHOUNG</a><br />
550. <a href="http://www.digitalmages.com/">Arthur Corliss</a>  <a href="mailto:corliss@digitalmages.com">&lt;corliss@digitalmages.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORLISS">CORLISS</a><br />
551. Arthur Goldstein  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARTHUR">ARTHUR</a><br />

552. Arthur Keys  <a href="mailto:arthur_keys@hotmail.com">&lt;arthur_keys@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEYSPERL">KEYSPERL</a><br />
553. <a href="http://mind.sourceforge.net/perl.html">Arthur T. Murray</a>  <a href="mailto:mentifex@scn.org">&lt;mentifex@scn.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MENTIFEX">MENTIFEX</a><br />
554. <a href="http://crucially.livejournal.com">Artur Bergman</a>  <a href="mailto:abergman@cpan.org">&lt;abergman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABERGMAN">ABERGMAN</a><br />

555. Artur Penttinen  <a href="mailto:artur+perl.org@niif.spb.su">&lt;artur+perl.org@niif.spb.su&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARTO">ARTO</a><br />
556. <a href="http://www.martinezdevara.com">Arturo Martinez de Vara</a>  <a href="mailto:art@martinezdevara.com">&lt;art@martinezdevara.com&gt;</a> -- MARTINEZ<br />
557. <a href="http://h2o.sky.lt/">Artūras Šlajus</a>  <a href="mailto:x11@h2o.sky.lt">&lt;x11@h2o.sky.lt&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARTURAZ">ARTURAZ</a><br />

558. <a href="http://aruljohn.com">Arul John</a>  <a href="mailto:arulzz@yahoo.com">&lt;arulzz@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARUL">ARUL</a><br />
559. Arun Kumar U  <a href="mailto:u_arun@hotmail.com">&lt;u_arun@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UA/UARUN">UARUN</a><br />
560. Arun Prasad  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARUNBEAR">ARUNBEAR</a><br />

561. Arun Venkataraman  <a href="mailto:arvktr@gmail.com">&lt;arvktr@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARUN">ARUN</a><br />
562. Arved H Sandstrom  <a href="mailto:Arved_37@chebucto.ns.ca">&lt;Arved_37@chebucto.ns.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASANDSTRM">ASANDSTRM</a><br />
563. Arvind Ransaria  <a href="mailto:pushparvind@home.com">&lt;pushparvind@home.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANA">RANA</a><br />

564. Arvind Tripathy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATRIPPS">ATRIPPS</a><br />
565. <a href="http://www.aryeh.net/">Aryeh Goldsmith</a>  <a href="mailto:perlaim@aryeh.net">&lt;perlaim@aryeh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARYEH">ARYEH</a><br />
566. Asgeir Nilsen  <a href="mailto:asgeirn@cpan.org">&lt;asgeirn@cpan.org&gt;</a> -- ASGEIRN<br />

567. <a href="http://perlitist.com/">Ash Berlin</a>  <a href="mailto:ash@cpan.org">&lt;ash@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASH">ASH</a><br />
568. <a href="http://wildsparx.com/">Asher Blum</a>  <a href="mailto:asher@wildsparx.com">&lt;asher@wildsparx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABLUM">ABLUM</a><br />
569. <a href="http://www.netropolis.org/hash">Ashish Gulhati</a>  <a href="mailto:ashish@neomailbox.com">&lt;ashish@neomailbox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGUL">AGUL</a><br />

570. Ashish Kasturia  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASHOOOO">ASHOOOO</a><br />
571. <a href="http://www.astro.caltech.edu/~aam">Ashish Mahabal</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASCHIG">ASCHIG</a><br />
572. <a href="http://ashleypond.com/v/">Ashley Pond V — 바보 양키스</a>  <a href="mailto:ashley@cpan.org">&lt;ashley@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASHLEY">ASHLEY</a><br />

573. <a href="http://perlqt.sourceforge.net/">Ashley Winters</a>  <a href="mailto:awinters@users.sourceforge.net">&lt;awinters@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWIN">AWIN</a><br />
574. <a href="http://veggie.wesleyan.edu/trey/">Ashton Trey Belew</a>  <a href="mailto:abelew@wesleyan.edu">&lt;abelew@wesleyan.edu&gt;</a> -- ABELEW<br />
575. <a href="www.d.umn.edu/~nagl0033">Ashutosh Nagle</a>  <a href="mailto:nagl0033@d.umn.edu">&lt;nagl0033@d.umn.edu&gt;</a> -- ASHUTOSH<br />

576. <a href="http://www.polynomialtime.com/">Ashwin Dixit</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ASHWIN<br />
577. Asim Jalis  <a href="mailto:asimjalis@acm.org">&lt;asimjalis@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASIMJALIS">ASIMJALIS</a><br />
578. <a href="http://www.askbjoernhansen.com/">Ask Bjørn Hansen</a>  <a href="mailto:ask@perl.org">&lt;ask@perl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABH">ABH</a><br />

579. <a href="http://search.cpan.org/~abh/">Ask Bjørn Hansen</a>  <a href="mailto:ask@perl.org">&lt;ask@perl.org&gt;</a> -- ASK<br />
580. <a href="www.0x61736b.net">Ask Solem</a>  <a href="mailto:ask@0x61736b.net">&lt;ask@0x61736b.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASKSH">ASKSH</a><br />
581. <a href="tchorbadjiev.com">Assen Tchorbadjiev</a>  <a href="mailto:cpan@tchorbadjiev.com">&lt;cpan@tchorbadjiev.com&gt;</a> -- ASSENTCH<br />

582. Athanasios Douitsis  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADUITSIS">ADUITSIS</a><br />
583. Atsushi Kobayashi  <a href="mailto:nekokak@cpan.org">&lt;nekokak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEKOKAK">NEKOKAK</a><br />
584. Atsushi Kobayashi  <a href="mailto:akoba@nttv6.net">&lt;akoba@nttv6.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AK/AKOBA">AKOBA</a><br />

585. <a href="http://schwer.us">Augie Schwer</a>  <a href="mailto:augie.schwer@gmail.com">&lt;augie.schwer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AUGIE">AUGIE</a><br />
586. <a href="http://www.di.unipi.it/~augusto">Augusto Ciuffoletti</a>  <a href="mailto:augusto@di.unipi.it">&lt;augusto@di.unipi.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AUGUSTO">AUGUSTO</a><br />
587. <a href="http://aukjan.vanbelkum.nl">Aukjan van Belkum</a>  <a href="mailto:aukjan@cpan.org">&lt;aukjan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AUKJAN">AUKJAN</a><br />

588. Austin Kropp  <a href="mailto:kropp@cpan.org">&lt;kropp@cpan.org&gt;</a> -- KROPP<br />
589. Austin Schutz  <a href="mailto:tex@habit.com">&lt;tex@habit.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AUSCHUTZ">AUSCHUTZ</a><br />
590. Ave Wrigley  <a href="mailto:Ave.Wrigley@itn.co.uk">&lt;Ave.Wrigley@itn.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWRIGLEY">AWRIGLEY</a><br />

591. Averell Dalton  <a href="mailto:averell-spam@gmx.net">&lt;averell-spam@gmx.net&gt;</a> -- ADALTON<br />
592. Averyanov Ilya  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MOTONAROL<br />
593. <a href="http://www.finkel.org/avi/">Avi Finkel</a>  <a href="mailto:avi@finkel.org">&lt;avi@finkel.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVIF">AVIF</a><br />

594. <a href="http://www.aczoom.com/">Avinash Chopde</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVINASH">AVINASH</a><br />
595. <a href="http://noone.org/abe/">Axel Beckert</a>  <a href="mailto:abe+cpan@deuxchevaux.org">&lt;abe+cpan@deuxchevaux.org&gt;</a> -- ABE<br />
596. Axel Schwenke  <a href="mailto:axel.schwenke@gmx.net">&lt;axel.schwenke@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHWENKE">SCHWENKE</a><br />

597. Ayhan Ulusoy  <a href="mailto:aulusoy@cpan.org">&lt;aulusoy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AULUSOY">AULUSOY</a><br />
598. Azrul Azwar  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROEL<br />
599. <a href="http://www.0x743.com">B. Estrade</a>  <a href="mailto:estrabd@gmail.com">&lt;estrabd@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESTRABD">ESTRABD</a><br />

600. <a href="http://binkley.blogspot.com/">B. K. Oxley (binkley)</a>  <a href="mailto:binkley@alumni.rice.edu">&lt;binkley@alumni.rice.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BINKLEY">BINKLEY</a><br />
601. B. Watson  <a href="mailto:pauseNO@SPAMhardcoders.org">&lt;pauseNO@SPAMhardcoders.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWATSON">BWATSON</a><br />
602. <a href="http://www.bbc.co.uk/">BBC (British Broadcasting Corporation)</a>  <a href="mailto:cpan@bbc.co.uk">&lt;cpan@bbc.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBC">BBC</a><br />

603. <a href="http://www.bbc.co.uk/learning">BBC, Interactive Factual &amp; Learning</a>  <a href="mailto:">&lt;&gt;</a> -- BBCIFL<br />
604. <a href="http://bts.dietetique.coursdiderot.com/">BTS Diététique</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CDIDEROT<br />
605. Baden Hughes  <a href="mailto:baden@cpan.org">&lt;baden@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BADEN">BADEN</a><br />

606. <a href="http://balaji.ramasubramanian.googlepages.com/">Balaji Ramasubramanian</a>  <a href="mailto:balaji.ramasubramanian@gmail.com">&lt;balaji.ramasubramanian@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BALAJIRAM">BALAJIRAM</a><br />
607. Baldur Kristinsson  <a href="mailto:bk@mbl.is">&lt;bk@mbl.is&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BALDUR">BALDUR</a><br />
608. <a href="http://baltasar.cevc-topp.de/">Baltasar Cevc</a>  <a href="mailto:bcevc AT cpan D?T org">&lt;bcevc AT cpan D?T org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCEVC">BCEVC</a><br />

609. <a href="http://www.baltic-online.de/">Baltic Online Computer GmbH</a>  <a href="mailto:perl-dev@baltic-online.de">&lt;perl-dev@baltic-online.de&gt;</a> -- BALTIC<br />
610. <a href="http://baneharbinger.com/NCustom/">Bane Harbinger</a>  <a href="mailto:bane@baneharbinger.com">&lt;bane@baneharbinger.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHARB">BHARB</a><br />
611. <a href="http://barbie.missbarbell.co.uk">Barbie</a>  <a href="mailto:barbie@missbarbell.co.uk">&lt;barbie@missbarbell.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARBIE">BARBIE</a><br />

612. <a href="http://www.barriebremner.com/">Barrie Bremner</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BREMNERB">BREMNERB</a><br />
613. Barrie Slaymaker  <a href="mailto:barries@slaysys.com">&lt;barries@slaysys.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBS">RBS</a><br />
614. Barry King  <a href="mailto:wyrd@nospam.wyrdwright.com">&lt;wyrd@nospam.wyrdwright.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WY/WYRD">WYRD</a><br />

615. <a href="http://www.primebase.com/">Barry Leslie</a>  <a href="mailto:barry.leslie@PrimeBase.com">&lt;barry.leslie@PrimeBase.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRIMEBASE">PRIMEBASE</a><br />
616. <a href="www.hurontel.on.ca/~barryp/menu-mysql">Barry Pollock</a>  <a href="mailto:barryp@hurontel.on.ca">&lt;barryp@hurontel.on.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARRYP">BARRYP</a><br />
617. <a href="http://transfixedbutnotdead.com">Barry Walsh</a>  <a href="mailto:draegtun@cpan.org">&lt;draegtun@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRAEGTUN">DRAEGTUN</a><br />

618. Barry White  <a href="mailto:barry@whiteb.me.uk">&lt;barry@whiteb.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHITEB">WHITEB</a><br />
619. Bart Lateur  <a href="mailto:bart.lateur@pandora.be">&lt;bart.lateur@pandora.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARTL">BARTL</a><br />
620. <a href="http://www.lunatech.com/~schuller/">Bart Schuller</a>  <a href="mailto:cpan@smop.org">&lt;cpan@smop.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARTS">BARTS</a><br />

621. Bartosz Jakubski  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJAKUBSKI">BJAKUBSKI</a><br />
622. Baruch Ben-David  <a href="mailto:baruch@cpan.org">&lt;baruch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARUCH">BARUCH</a><br />
623. Bas Zoetekouw  <a href="mailto:bas@debian.org">&lt;bas@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAS">BAS</a><br />

624. Basant Kumar Kukreja  <a href="mailto:prayatn_gupta@yahoo.com">&lt;prayatn_gupta@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BASANTK">BASANTK</a><br />
625. Baskar S  <a href="mailto:baskar@india.ti.com">&lt;baskar@india.ti.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BASKAR">BASKAR</a><br />
626. <a href="www.youprocess.com">Bassem W. Jamaleddine</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXOU">MAXOU</a><br />

627. Bastian Angerstein  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AN/ANGERSTEI">ANGERSTEI</a><br />
628. <a href="http://www.geektown.de">Bastian Ballmann</a>  <a href="mailto:Crazydj@chaostal.de">&lt;Crazydj@chaostal.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAZYDJ">CRAZYDJ</a><br />
629. Bastian Blank  <a href="mailto:bastian+waldi=cpan.org@waldi.eu.org">&lt;bastian+waldi=cpan.org@waldi.eu.org&gt;</a> -- WALDI<br />

630. Batchrun Team  <a href="mailto:batchrun@pnl.gov">&lt;batchrun@pnl.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRTEAM">BRTEAM</a><br />
631. <a href="http://baynaa.blogspot.com">Bayanzul Lodoysamba</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BAYNAA<br />
632. <a href="http://purl.net/net/bshanks">Bayle Shanks</a>  <a href="mailto:see http://purl.net/net/bshanks for email addr">&lt;see http://purl.net/net/bshanks for email addr&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSHANKS">BSHANKS</a><br />

633. <a href="http://www.beadsland.com/">Beads Land</a>  <a href="mailto:beads@beadsland.com">&lt;beads@beadsland.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEADSLAND">BEADSLAND</a><br />
634. <a href="http://www.halogen.org/">Beau D. Simensen</a>  <a href="mailto:perl@halogen.org">&lt;perl@halogen.org&gt;</a> -- SIMENSEN<br />
635. Beau E. Cox  <a href="mailto:beaucox@hawaii.rr.com">&lt;beaucox@hawaii.rr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEAU">BEAU</a><br />

636. <a href="http://consulting.websterwood.com/">Behan Webster</a>  <a href="mailto:behanw AT websterwood DOT com">&lt;behanw AT websterwood DOT com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEHANW">BEHANW</a><br />
637. <a href="http://www.limey.net/~fiji">Ben Bennett</a>  <a href="mailto:fiji@limey.net">&lt;fiji@limey.net&gt;</a> -- FIJI<br />
638. Ben Bullock  <a href="mailto:benkasminbullock@gmail.com">&lt;benkasminbullock@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BK/BKB">BKB</a><br />

639. <a href="http://spod.cx">Ben Charlton</a>  <a href="mailto:benc@cpan.org">&lt;benc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENC">BENC</a><br />
640. <a href="http://oloryn.home.mindspring.com/">Ben Coleman</a>  <a href="mailto:oloryn@benshome.net">&lt;oloryn@benshome.net&gt;</a> -- OLORYN<br />
641. Ben Cornett  <a href="mailto:">&lt;&gt;</a> -- BCORNETT<br />

642. <a href="http://www.lightandmatter.com/">Ben Crowell</a>  <a href="mailto:b_crowell67@hotmail.com">&lt;b_crowell67@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCROWELL">BCROWELL</a><br />
643. Ben Daglish  <a href="mailto:bdaglish@cpan.org">&lt;bdaglish@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDAGLISH">BDAGLISH</a><br />
644. Ben Eastvold  <a href="mailto:beastvol@hotmail.com">&lt;beastvol@hotmail.com&gt;</a> -- BEASTVOL<br />

645. Ben Evans  <a href="mailto:bene@chiark.greenend.org.uk">&lt;bene@chiark.greenend.org.uk&gt;</a> -- BEVANS<br />
646. Ben Evans  <a href="mailto:ben@bpfh.net">&lt;ben@bpfh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KITTY">KITTY</a><br />
647. Ben Faga  <a href="mailto:faga@cshl.edu">&lt;faga@cshl.edu&gt;</a> -- MWZ<br />
648. <a href="http://www.gmod.org/cmap/">Ben Faga</a>  <a href="mailto:faga@cshl.edu">&lt;faga@cshl.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BF/BFAGA">BFAGA</a><br />

649. <a href="http://www.zaeon.com/">Ben Grimm</a>  <a href="mailto:bgrimm cpan.org">&lt;bgrimm cpan.org&gt;</a> -- BGRIMM<br />
650. <a href="http://www.modulo.org/">Ben H. Kram</a>  <a href="mailto:perl@modulo.org">&lt;perl@modulo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MODULO">MODULO</a><br />
651. <a href="http://www.benhammersley.com">Ben Hammersley</a>  <a href="mailto:ben@benhammersley.com">&lt;ben@benhammersley.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENHMM">BENHMM</a><br />

652. <a href="http://hildred.linux-dude.net/">Ben Hildred</a>  <a href="mailto:bhildred@peakpeak.net">&lt;bhildred@peakpeak.net&gt;</a> -- NUTSO<br />
653. <a href="http://benhumphreys.co.uk/">Ben Humphreys</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BHUMPH<br />
654. Ben Jacobs-Swearingen  <a href="mailto:daiyu@mail.utexas.edu">&lt;daiyu@mail.utexas.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAIYU">DAIYU</a><br />

655. <a href="http://qolc.net">Ben James Wheeler</a>  <a href="mailto:ben@qolc.net">&lt;ben@qolc.net&gt;</a> -- BJWHEELER<br />
656. <a href="http://projects.alkaloid.net">Ben Klang</a>  <a href="mailto:ben@alkaloid.net">&lt;ben@alkaloid.net&gt;</a> -- BKLANG<br />
657. <a href="http://www.voicetronix.com.au/">Ben Kramer</a>  <a href="mailto:support@voicetronix.com.au">&lt;support@voicetronix.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VO/VOICET">VOICET</a><br />

658. <a href="www.voicetronix.com.au">Ben Kramer</a>  <a href="mailto:ben.kramer@voicetronix.com.au">&lt;ben.kramer@voicetronix.com.au&gt;</a> -- BKRAMER<br />
659. <a href="http://www.apache-ssl.org/ben.html">Ben Laurie</a>  <a href="mailto:ben@algroup.co.uk">&lt;ben@algroup.co.uk&gt;</a> -- BEN<br />
660. Ben Lever  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BENLEVER<br />

661. Ben Lilley  <a href="mailto:blilley@hpu.edu">&lt;blilley@hpu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDLILLEY">BDLILLEY</a><br />
662. Ben Lindstrom  <a href="mailto:mouring@netnet.net">&lt;mouring@netnet.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENLI">BENLI</a><br />
663. <a href="http://www.benlund.co.uk/">Ben Lund</a>  <a href="mailto:ben@benlund.co.uk">&lt;ben@benlund.co.uk&gt;</a> -- BENLUND<br />

664. Ben Marcotte  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BMARCOTTE<br />
665. Ben Marsh  <a href="mailto:blm@woodheap.org">&lt;blm@woodheap.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLM">BLM</a><br />
666. <a href="http://www.webcentric-hosting.com">Ben Maynard</a>  <a href="mailto:cpan@geekserv.com">&lt;cpan@geekserv.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMAYNARD">BMAYNARD</a><br />

667. <a href="http://morrow.me.uk/">Ben Morrow</a>  <a href="mailto:ben@morrow.me.uk">&lt;ben@morrow.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMORROW">BMORROW</a><br />
668. Ben Norman  <a href="mailto:ben.norman@qmunity.net">&lt;ben.norman@qmunity.net&gt;</a> -- BENN<br />
669. Ben Pavon  <a href="mailto:ben.pavon@hsc.hac.com">&lt;ben.pavon@hsc.hac.com&gt;</a> -- BENPAVON<br />

670. Ben Petering  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BPETERING<br />
671. <a href="http://www.logiccloud.com/benprew">Ben Prew</a>  <a href="mailto:btp@cpan.org">&lt;btp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BT/BTP">BTP</a><br />
672. <a href="http://ben.reser.org">Ben Reser</a>  <a href="mailto:perl@reser.org">&lt;perl@reser.org&gt;</a> -- BRESER<br />

673. Ben Samuel  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SCOOBY<br />
674. <a href="http://www.foink.com">Ben Schmitz</a>  <a href="mailto:ben@foink.com">&lt;ben@foink.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSCHMITZ">BSCHMITZ</a><br />
675. <a href="http://www.schnopp.com">Ben Schnopp</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BSNOOP<br />

676. <a href="http://mycohq.com">Ben Sommer</a>  <a href="mailto:ben@mycohq.com">&lt;ben@mycohq.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOMMERB">SOMMERB</a><br />
677. Ben Sommer  <a href="mailto:ben@bensommer.com">&lt;ben@bensommer.com&gt;</a> -- BENSOMMER<br />
678. <a href="http://www.perlmonks.org/index.pl?node=tilly">Ben Tilly</a>  <a href="mailto:btilly at gmail dot com">&lt;btilly at gmail dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TILLY">TILLY</a><br />

679. Ben Yarber  <a href="mailto:yarber@paperweb.ws">&lt;yarber@paperweb.ws&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YA/YARBER">YARBER</a><br />
680. Bengt-Arne Fjellner  <a href="mailto:baf@cpan.org">&lt;baf@cpan.org&gt;</a> -- BAF<br />
681. <a href="http://www.limey.net/~fiji">Benjamin Bennett</a>  <a href="mailto:fiji@limey.net">&lt;fiji@limey.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBENNETT">BBENNETT</a><br />

682. <a href="http://www.boksa.de/">Benjamin Boksa</a>  <a href="mailto:benjamin@boksa.de">&lt;benjamin@boksa.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBOKSA">BBOKSA</a><br />
683. Benjamin Brodfuehrer  <a href="mailto:bcmb@wraithsys.net">&lt;bcmb@wraithsys.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCMB">BCMB</a><br />
684. Benjamin Elijah Griffin  <a href="mailto:eli+cpan@panix.com">&lt;eli+cpan@panix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELIJAH">ELIJAH</a><br />

685. <a href="http://www.nihongo.org/snowhare/">Benjamin Franz</a>  <a href="mailto:snowhare@nihongo.org">&lt;snowhare@nihongo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNOWHARE">SNOWHARE</a><br />
686. Benjamin Gieß  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BGI<br />
687. Benjamin Goldberg  <a href="mailto:goldbb@cpan.org">&lt;goldbb@cpan.org&gt;</a> -- GOLDBB<br />

688. <a href="http://www.benhare.org/">Benjamin Hare</a>  <a href="mailto:benh@cpan.org">&lt;benh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENH">BENH</a><br />
689. Benjamin Holzman  <a href="mailto:bholzman@earthlink.net">&lt;bholzman@earthlink.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHOLZMAN">BHOLZMAN</a><br />
690. Benjamin Kendinibilir  <a href="mailto:cpan@kendinibilir.de">&lt;cpan@kendinibilir.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BK/BKENDI">BKENDI</a><br />

691. Benjamin Kuit  <a href="mailto:bj@it.uts.edu.au">&lt;bj@it.uts.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJKUIT">BJKUIT</a><br />
692. Benjamin Low  <a href="mailto:b_d_low@yahoo.com.au">&lt;b_d_low@yahoo.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENL">BENL</a><br />
693. <a href="http://www.msi.umn.edu">Benjamin Lynch</a>  <a href="mailto:blynch@msi.umn.edu">&lt;blynch@msi.umn.edu&gt;</a> -- BLYNCH<br />

694. <a href="http://www.artcom.net/~karo/">Benjamin Pannier</a>  <a href="mailto:karo@artcom.net">&lt;karo@artcom.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPANNIER">BPANNIER</a><br />
695. <a href="http://1-up.net:81/mailman/listinfo/perl-video">Benjamin R. Ginter</a>  <a href="mailto:bginter@asicommunications.com">&lt;bginter@asicommunications.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRG">BRG</a><br />
696. <a href="http://blog.nur-eine-i.de">Benjamin Reitzammer</a>  <a href="mailto:cpan@nur-eine-i.de">&lt;cpan@nur-eine-i.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENJAMIN">BENJAMIN</a><br />

697. Benjamin Russell  <a href="mailto:ben_russell15@hotmail.com">&lt;ben_russell15@hotmail.com&gt;</a> -- BENRUSSEL<br />
698. <a href="http://cytzol.org">Benjamin Sago</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BSAGO<br />
699. <a href="http://www.benschmaus.com">Benjamin Schmaus</a>  <a href="mailto:pause@benschmaus.com">&lt;pause@benschmaus.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSCHMAU">BSCHMAU</a><br />

700. Benjamin Schuster-Böckler  <a href="mailto:bsb@sanger.ac.uk">&lt;bsb@sanger.ac.uk&gt;</a> -- SCHUBOE<br />
701. <a href="http://cabbage.org.uk/~bsmith/">Benjamin Smith</a>  <a href="mailto:bsmith@cpan.org">&lt;bsmith@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSMITH">BSMITH</a><br />
702. <a href="http://people.canoe.ca/bsugars">Benjamin Sugars</a>  <a href="mailto:bsugars@canoe.ca">&lt;bsugars@canoe.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSUGARS">BSUGARS</a><br />

703. Benjamin Thomas  <a href="mailto:">&lt;&gt;</a> -- BTHOMAS<br />
704. <a href="http://www.stupidfool.org/">Benjamin Trott</a>  <a href="mailto:cpan@stupidfool.org">&lt;cpan@stupidfool.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BT/BTROTT">BTROTT</a><br />
705. <a href="http://btucker.org">Benjamin Tucker</a>  <a href="mailto:cpan@btucker.net">&lt;cpan@btucker.net&gt;</a> -- BTUCKER<br />

706. <a href="http://www.usfca.edu/turner/">Benjamin Turner</a>  <a href="mailto:bjturner@mailcity.com">&lt;bjturner@mailcity.com&gt;</a> -- BJTURNER<br />
707. <a href="http://www.madcoder.net">Benjamin Ullian</a>  <a href="mailto:bullian@gmail.com">&lt;bullian@gmail.com&gt;</a> -- MADCODER<br />
708. <a href="http://www.just-another.net">Benjamin W. Smith</a>  <a href="mailto:defyance -=at=- just-another.net">&lt;defyance -=at=- just-another.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWSMITH">BWSMITH</a><br />

709. Benjamin Warfield  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWARFIELD">BWARFIELD</a><br />
710. <a href="http://bent.latency.net/">Bennett Todd</a>  <a href="mailto:bet@rahul.net">&lt;bet@rahul.net&gt;</a> -- BENT<br />
711. Benno Kardel  <a href="mailto:perlfan@justmail.de">&lt;perlfan@justmail.de&gt;</a> -- KARDEL<br />

712. Benny Millares  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMILLARES">BMILLARES</a><br />
713. <a href="http://www.flatlineconstruct.com">Benoit Beausejour</a>  <a href="mailto:bbeausej@pobox.com">&lt;bbeausej@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBEAUSEJ">BBEAUSEJ</a><br />
714. Benoit St-Pierre  <a href="mailto:bstpierre@cpan.org">&lt;bstpierre@cpan.org&gt;</a> -- BSTPIERRE<br />

715. <a href="perlog.pung96.net">Beomsu Chang</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PUNG<br />
716. Berik Visschers  <a href="mailto:berikv@xs4all.nl">&lt;berikv@xs4all.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BERIKV">BERIKV</a><br />
717. <a href="http://bddemir.com">Berk D. Demir</a>  <a href="mailto:BDD (at) CPAN (dot) ORG">&lt;BDD (at) CPAN (dot) ORG&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDD">BDD</a><br />

718. Bernard Kenik  <a href="mailto:bkenik@hotmail.com">&lt;bkenik@hotmail.com&gt;</a> -- BBIKER<br />
719. <a href="http://www.it-development.be/">Bernard Nauwelaerts</a>  <a href="mailto:bpgn@cpan.org">&lt;bpgn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPGN">BPGN</a><br />
720. Bernard Weiler  <a href="mailto:Bernard.Weiler@icn.siemens.de">&lt;Bernard.Weiler@icn.siemens.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWEILER">BWEILER</a><br />

721. <a href="http://blog.natless.net">Bernat Requesens</a>  <a href="mailto:brequesens@gmail.com">&lt;brequesens@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BREQUESEN">BREQUESEN</a><br />
722. Bernd Dulfer  <a href="mailto:dulfer@widd.de.spam.no">&lt;dulfer@widd.de.spam.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDULFER">BDULFER</a><br />
723. <a href="www.black-sheep-software.de">Bernhard Bauer</a>  <a href="mailto:cpan@black-sheep-software.de">&lt;cpan@black-sheep-software.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAUERB">BAUERB</a><br />

724. Bernhard Graf  <a href="mailto:cpan@movingtarget.de">&lt;cpan@movingtarget.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAF">GRAF</a><br />
725. Bernhard K. Weisshuhn  <a href="mailto:bkw@cpan.org">&lt;bkw@cpan.org&gt;</a> -- BKW<br />
726. <a href="http://use.perl.org/~Bernhard/journal/">Bernhard Schmalhofer</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSCHMAL">BSCHMAL</a><br />

727. <a href="xmlizer.biz">Bernhard Wagner</a>  <a href="mailto:">&lt;&gt;</a> -- BWAGNER<br />
728. Bernie Cosell  <a href="mailto:bernie@rev.net">&lt;bernie@rev.net&gt;</a> -- BCOSELL<br />
729. Berry Batist  <a href="mailto:berry@bytec0de.org">&lt;berry@bytec0de.org&gt;</a> -- BERRY<br />
730. Berthold Michel  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BHM<br />

731. Bertram Wegener  <a href="mailto:bertram@island.free.de">&lt;bertram@island.free.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEWEGEN">BEWEGEN</a><br />
732. <a href="http://teddyber.info/">Bertrand Carlier</a>  <a href="mailto:teddyber@cpan.org">&lt;teddyber@cpan.org&gt;</a> -- TEDDYBER<br />
733. <a href="http://loxosceles.org">Beth Skwarecki</a>  <a href="mailto:beth@loxosceles.org">&lt;beth@loxosceles.org&gt;</a> -- BETH<br />

734. Bharanee Rathnasabapathy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEEPFRYED">DEEPFRYED</a><br />
735. Bharat Patel  <a href="mailto:bbpatel@rediffmail.com">&lt;bbpatel@rediffmail.com&gt;</a> -- BBPATEL<br />
736. Biafra  <a href="mailto:biafra * pulhas.org">&lt;biafra * pulhas.org&gt;</a> -- BIAFRA<br />
737. <a href="http://www.webbird.de">Bianka Martinovic</a>  <a href="mailto:cpan@webbird.de">&lt;cpan@webbird.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAB">MAB</a><br />

738. <a href="http://members.tripod.com/~Biju3">Biju A</a>  <a href="mailto:bijuarjunan@mailcity.com">&lt;bijuarjunan@mailcity.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIJUA">BIJUA</a><br />
739. Bill Anderson  <a href="mailto:bill@anderson-ent.com">&lt;bill@anderson-ent.com&gt;</a> -- BANDERSON<br />
740. <a href="http://www.batkins.com/">Bill Atkins</a>  <a href="mailto:NOcpanSPAM@batkins.com">&lt;NOcpanSPAM@batkins.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BATKINS">BATKINS</a><br />

741. <a href="http://members.aol.com/Bbirthisel">Bill Birthisel</a>  <a href="mailto:wcbirthisel@alum.mit.edu">&lt;wcbirthisel@alum.mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBIRTH">BBIRTH</a><br />
742. Bill Bumgarner  <a href="mailto:bbum@friday.com">&lt;bbum@friday.com&gt;</a> -- BBUM<br />
743. <a href="http://www.celestial.com/">Bill Campbell</a>  <a href="mailto:bill@celestial.com">&lt;bill@celestial.com&gt;</a> -- BILLC<br />

744. Bill Catlan  <a href="mailto:wcatlan@cpan.org">&lt;wcatlan@cpan.org&gt;</a> -- WCATLAN<br />
745. <a href="http://www.ece.ucdavis.edu/~coffman/">Bill Coffman</a>  <a href="mailto:bill.coffman@gmail.com">&lt;bill.coffman@gmail.com&gt;</a> -- BCOFFMAN<br />
746. Bill Dueber  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DUEBERB<br />

747. Bill Fenner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FENNER<br />
748. Bill Moseley  <a href="mailto:mods@hank.org">&lt;mods@hank.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANK">HANK</a><br />
749. <a href="www.billn.net">Bill Nash</a>  <a href="mailto:billn@billn.net">&lt;billn@billn.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BILLN">BILLN</a><br />

750. <a href="http://tmtowtdi.com/">Bill Odom</a>  <a href="mailto:wnodom@intrasection.com">&lt;wnodom@intrasection.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WN/WNODOM">WNODOM</a><br />
751. Bill Petheram  <a href="mailto:petheram@acm.org">&lt;petheram@acm.org&gt;</a> -- BPETH<br />
752. Bill Raty  <a href="mailto:Bill_Raty@yahoo.com">&lt;Bill_Raty@yahoo.com&gt;</a> -- WRATY<br />

753. <a href="http://www.rational.com/">Bill Spurlin</a>  <a href="mailto:perlmod@rational.com">&lt;perlmod@rational.com&gt;</a> -- RATLCC<br />
754. <a href="http://www.marginalia.org">Bill Stilwell</a>  <a href="mailto:bill@marginalia.org">&lt;bill@marginalia.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSTILWELL">BSTILWELL</a><br />
755. Bill Walz  <a href="mailto:billwalz@gmail.com">&lt;billwalz@gmail.com&gt;</a> -- BILLWALZ<br />

756. <a href="http://bw.org/">Bill Weinman</a>  <a href="mailto:wew@bearnet.com">&lt;wew@bearnet.com&gt;</a> -- BILLW<br />
757. Bill Williams  <a href="mailto:biwillia@cisco.com">&lt;biwillia@cisco.com&gt;</a> -- BIWILLIA<br />
758. <a href="http://www.cowfish.org.uk">Billy Abbott</a>  <a href="mailto:cowfish@cpan.org">&lt;cowfish@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COWFISH">COWFISH</a><br />

759. Billy Bryant  <a href="mailto:bwb_jr@excite.com">&lt;bwb_jr@excite.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBRYANT">BBRYANT</a><br />
760. <a href="http://www.nadeauconsultants.com">Billy Nadeau</a>  <a href="mailto:bill@sanac.net">&lt;bill@sanac.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BILL">BILL</a><br />
761. Bino John  <a href="mailto:binojohn@xproteomics.com">&lt;binojohn@xproteomics.com&gt;</a> -- BINOJOHN<br />

762. Binoj M N  <a href="mailto:binoj.nair@gmail.com">&lt;binoj.nair@gmail.com&gt;</a> -- BINOJNAIR<br />
763. <a href="http://smitz.perlmonk.org/">Birger Alexander Schmitz</a>  <a href="mailto:el_smitz@hotmail.com">&lt;el_smitz@hotmail.com&gt;</a> -- SMITZ<br />
764. Bishoy Hanna  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BISHOYH<br />

765. <a href="http://ospetro.sf.net">Bjarne Steinsbo</a>  <a href="mailto:steinsbo@users.sourceforge.net">&lt;steinsbo@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEINSBO">STEINSBO</a><br />
766. Bjoern Holsten  <a href="mailto:bholsten@freenet.de">&lt;bholsten@freenet.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHOLSTEN">BHOLSTEN</a><br />
767. Bjorn Ardo  <a href="mailto:f98ba@efd.lth.se">&lt;f98ba@efd.lth.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJORNARDO">BJORNARDO</a><br />

768. Björn Grossmann  <a href="mailto:grossmann@cpan.org">&lt;grossmann@cpan.org&gt;</a> -- GROSSMANN<br />
769. <a href="http://bjoern.hoehrmann.de/">Björn Höhrmann</a>  <a href="mailto:bjoern@hoehrmann.de">&lt;bjoern@hoehrmann.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJOERN">BJOERN</a><br />
770. Björn Medin  <a href="mailto:b972@telia.com">&lt;b972@telia.com&gt;</a> -- BJM<br />

771. <a href="http://www.topicalizer.com/">Björn Wilmsmann</a>  <a href="mailto:bjoern@wilmsmann.de">&lt;bjoern@wilmsmann.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJOERNW">BJOERNW</a><br />
772. <a href="http://www.yes.no/">Bjørn Erik Jacobsen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BEJ<br />
773. Bjørn-Olav Strand  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BOLAV<br />

774. <a href="http://www.blackstar.co.uk/">BlackStar</a>  <a href="mailto:marty@blackstar.co.uk">&lt;marty@blackstar.co.uk&gt;</a> -- BLACKSTAR<br />
775. Blaine Cook  <a href="mailto:blaine@altern.org">&lt;blaine@altern.org&gt;</a> -- LATTICE<br />
776. Blaine Simpson  <a href="mailto:blaine.simpson@admc.com">&lt;blaine.simpson@admc.com&gt;</a> -- UNSAVED<br />

777. <a href="http://bsdz-perl.googlecode.com">Blair Sutton</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSDZ">BSDZ</a><br />
778. <a href="http://www.orcaware.com/">Blair Zajac</a>  <a href="mailto:blair@orcaware.com">&lt;blair@orcaware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BZ/BZAJAC">BZAJAC</a><br />
779. Blake A. Mitchell  <a href="mailto:bam@cpan.org">&lt;bam@cpan.org&gt;</a> -- BAM<br />

780. Bo Adler  <a href="mailto:thumper@ugcs.caltech.edu">&lt;thumper@ugcs.caltech.edu&gt;</a> -- BOADLER<br />
781. Bo Lindbergh  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLGL">BLGL</a><br />
782. Bo Zou  <a href="mailto:boxzou@yahoo.com">&lt;boxzou@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOXZOU">BOXZOU</a><br />
783. <a href="http://www.austinimprov.com/~apthorpe/">Bob Apthorpe</a>  <a href="mailto:apthorpe+cpan@cynistar.net">&lt;apthorpe+cpan@cynistar.net&gt;</a> -- APTHORPE<br />

784. <a href="http://www.sasknet.com/~dalgl/">Bob Dalgleish</a>  <a href="mailto:bob.dalgleish@sk.sympatico.ca">&lt;bob.dalgleish@sk.sympatico.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DALGL">DALGL</a><br />
785. <a href="http://www.bobfaist.com">Bob Faist</a>  <a href="mailto:bfaist@cpan.org">&lt;bfaist@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BF/BFAIST">BFAIST</a><br />
786. <a href="http://graphcomp.com/technologies">Bob Free</a>  <a href="mailto:bfree(at)graphcomp(dot)com">&lt;bfree(at)graphcomp(dot)com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BF/BFREE">BFREE</a><br />

787. Bob Friedman  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBF">BOBF</a><br />
788. <a href="http://www.zanshin.com/bobg/">Bob Glickstein</a>  <a href="mailto:bobg@zanshin.com">&lt;bobg@zanshin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBG">BOBG</a><br />
789. Bob Goldstein  <a href="mailto:bobg@uic.edu">&lt;bobg@uic.edu&gt;</a> -- BOBGOLD<br />

790. Bob Goolsby  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- OGB<br />
791. Bob Mathews  <a href="mailto:bobmathews@alumni.calpoly.edu">&lt;bobmathews@alumni.calpoly.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBMATH">BOBMATH</a><br />
792. Bob Nelson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RENELSON<br />
793. Bob Niederman  <a href="mailto:bobn@interaccess.com">&lt;bobn@interaccess.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBN">BOBN</a><br />

794. Bob O'Neill  <a href="mailto:bobo@cpan.org">&lt;bobo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBO">BOBO</a><br />
795. <a href="http://rgrjr.dyndns.org/">Bob Rogers</a>  <a href="mailto:rogers-perl6@rgrjr.dyndns.org">&lt;rogers-perl6@rgrjr.dyndns.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGRJR">RGRJR</a><br />
796. <a href="http://www.robertshowalter.com">Bob Showalter</a>  <a href="mailto:showaltb@gmail.com">&lt;showaltb@gmail.com&gt;</a> -- BSHOW<br />

797. Bob Sidebotham  <a href="mailto:rns@fore.com">&lt;rns@fore.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBSIDE">BOBSIDE</a><br />
798. Bob Stockdale  <a href="mailto:stocks@cpan.org">&lt;stocks@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STOCKS">STOCKS</a><br />
799. <a href="http://www.newportal.com/~btribit/">Bob Tribit</a>  <a href="mailto:btribit-cpan@newportal.com">&lt;btribit-cpan@newportal.com&gt;</a> -- BTRIBIT<br />

800. <a href="www.fourtheye.org">Bob Wilkinson</a>  <a href="mailto:bob@fourtheye.org">&lt;bob@fourtheye.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBW">BOBW</a><br />
801. <a href="http://rudy.mif.pg.gda.pl/~bogdro/inne/">Bogdan Drozdowski</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOGDRO">BOGDRO</a><br />
802. <a href="http://www.wiz.ro">Bogdan Lucaciu</a>  <a href="mailto:bogdan@wiz.ro">&lt;bogdan@wiz.ro&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOGDAN">BOGDAN</a><br />

803. Bohdan Shchepanskyy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SBR<br />
804. <a href="www.bobcik.info">Boleslav Bobcik</a>  <a href="mailto:bbobcik@gmail.com">&lt;bbobcik@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOLEK">BOLEK</a><br />
805. Boris Lantrewitz  <a href="mailto:lantrewi@do.isst.fhg.de">&lt;lantrewi@do.isst.fhg.de&gt;</a> -- BLANTREWI<br />

806. <a href="http://boris.reitman.name">Boris Reitman</a>  <a href="mailto:boris-dot-reitman-at-gmail-com">&lt;boris-dot-reitman-at-gmail-com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REITMAN">REITMAN</a><br />
807. Boris Shomodjvarac  <a href="mailto:">&lt;&gt;</a> -- SHOMODJ<br />
808. Boris Sukholitko  <a href="mailto:boriss@gmail.com">&lt;boriss@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOSU">BOSU</a><br />

809. Boris Zentner  <a href="mailto:bzm@2bz.de">&lt;bzm@2bz.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BORISZ">BORISZ</a><br />
810. <a href="www.dwelle.org">Bowen Dwelle</a>  <a href="mailto:bowen@dwelle.org">&lt;bowen@dwelle.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDWELLE">BDWELLE</a><br />
811. Boyd Duffee  <a href="mailto:boyd a cs punto keele punto ac punto uk">&lt;boyd a cs punto keele punto ac punto uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUFFEE">DUFFEE</a><br />

812. <a href="http://badkins.net/">Brad Adkins</a>  <a href="mailto:dbijcl@gmail.com">&lt;dbijcl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BADKINS">BADKINS</a><br />
813. <a href="http://www.bradapp.net/">Brad Appleton</a>  <a href="mailto:brad@bradapp.net">&lt;brad@bradapp.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRADAPP">BRADAPP</a><br />
814. Brad Baxter  <a href="mailto:bbaxter@cpan.org">&lt;bbaxter@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBAXTER">BBAXTER</a><br />

815. <a href="http://bereft.net/">Brad Bowman</a>  <a href="mailto:perl-cpan@bereft.net">&lt;perl-cpan@bereft.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOWMANBS">BOWMANBS</a><br />
816. Brad Cavanagh  <a href="mailto:b.cavanagh@jach.hawaii.edu">&lt;b.cavanagh@jach.hawaii.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRADC">BRADC</a><br />
817. <a href="http://www.bradchoate.com/">Brad Choate</a>  <a href="mailto:brad@bradchoate.com">&lt;brad@bradchoate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCHOATE">BCHOATE</a><br />

818. Brad Douglas  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRADD">BRADD</a><br />
819. <a href="http://www.bradfitz.com/">Brad Fitzpatrick</a>  <a href="mailto:brad@danga.com">&lt;brad@danga.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRADFITZ">BRADFITZ</a><br />
820. Brad Hughes  <a href="mailto:brad@tgsmc.com">&lt;brad@tgsmc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHUGHES">BHUGHES</a><br />

821. <a href="http://divisionbyzero.net">Brad Lhotsky</a>  <a href="mailto:brad@divisionbyzero.net">&lt;brad@divisionbyzero.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLHOTSKY">BLHOTSKY</a><br />
822. <a href="http://www.n8qq.com">Brad McConahay</a>  <a href="mailto:brad@n8qq.com">&lt;brad@n8qq.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRADMC">BRADMC</a><br />
823. <a href="http://home.earthlink.net/~bsturner/perl">Brad Turner</a>  <a href="mailto:bsturner@sprintparanet.com">&lt;bsturner@sprintparanet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSTURNER">BSTURNER</a><br />

824. Brad Yourth  <a href="mailto:yourthb@spjc.edu">&lt;yourthb@spjc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BY/BYOURTH">BYOURTH</a><br />
825. Bradley C Bailey  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCBAILEY">BCBAILEY</a><br />
826. <a href="http://bjdean.id.au/">Bradley Dean</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BJDEAN<br />

827. <a href="http://www.kitefamily.co.uk/">Bradley Derek Kite</a>  <a href="mailto:bradley-cpan@kitefamily.co.uk">&lt;bradley-cpan@kitefamily.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KITE">KITE</a><br />
828. <a href="http://www.tripaving.com">Bradley J. Gibby</a>  <a href="mailto:bradleygibby@programmer.net">&lt;bradleygibby@programmer.net&gt;</a> -- BGIBBY<br />
829. <a href="http://www.ebb.org/bkuhn">Bradley M. Kuhn</a>  <a href="mailto:bkuhn@ebb.org">&lt;bkuhn@ebb.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BK/BKUHN">BKUHN</a><br />

830. Brand Hilton  <a href="mailto:bhilton@pobox.com">&lt;bhilton@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHILTON">BHILTON</a><br />
831. <a href="http://www.brandonchecketts.com/">Brandon Checketts</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BRANDONC<br />
832. <a href="http://bfoz.net">Brandon Fosdick</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BF/BFOZ">BFOZ</a><br />

833. Brandon Gilmore  <a href="mailto:brandon@mg2.org">&lt;brandon@mg2.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BG/BGILMORE">BGILMORE</a><br />
834. <a href="www.handeland.org">Brandon Handeland</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BRANDON<br />
835. <a href="http://www.dtmf.com">Brandon L Black</a>  <a href="mailto:blblack@gmail.com">&lt;blblack@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLBLACK">BLBLACK</a><br />

836. <a href="http://www.golm.com/">Brandon L. Golm</a>  <a href="mailto:br@ndon.com">&lt;br@ndon.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOLM">GOLM</a><br />
837. <a href="escaphage.com">Brandon Neal Atkinson</a>  <a href="mailto:brandon.n.atkinson@gmail.com">&lt;brandon.n.atkinson@gmail.com&gt;</a> -- BATKINSON<br />
838. Brandon Prudent  <a href="mailto:xlacklusterx@hotmail.com">&lt;xlacklusterx@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPRUDENT">BPRUDENT</a><br />

839. Brandon Willis  <a href="mailto:brandon@silverorb.net">&lt;brandon@silverorb.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILLIS">WILLIS</a><br />
840. <a href="http://brandt.kurowski.net/">Brandt Kurowski</a>  <a href="mailto:brandt@kurowski.net">&lt;brandt@kurowski.net&gt;</a> -- KUROWSKI<br />
841. <a href="http://coffee.geek.nz">Brenda Wallace</a>  <a href="mailto:brenda@wallace.net.nz">&lt;brenda@wallace.net.nz&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHINY">SHINY</a><br />

842. Brendan Fagan  <a href="mailto:bits@csh.rit.edu">&lt;bits@csh.rit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BITS">BITS</a><br />
843. <a href="http://ussjoin.com">Brendan Francis O'Connor</a>  <a href="mailto:perl - at - ussjoin - dot - com">&lt;perl - at - ussjoin - dot - com&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/US/USSJOIN">USSJOIN</a><br />
844. <a href="http://www.brendangregg.com">Brendan Gregg</a>  <a href="mailto:brendan.gregg@tpg.com.au">&lt;brendan.gregg@tpg.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDGREGG">BDGREGG</a><br />

845. <a href="http://brendanleber.com/">Brendan Leber</a>  <a href="mailto:brendan.leber@gmail.com">&lt;brendan.leber@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLLYKING">HOLLYKING</a><br />
846. <a href="http://www.clueful.com.au/brendan/">Brendan Quinn</a>  <a href="mailto:brendan@clueful.com.au">&lt;brendan@clueful.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BQ/BQUINN">BQUINN</a><br />
847. <a href="http://www.goldenhammers.net">Brendan W. McAdams</a>  <a href="mailto:bwmcadams@gmail.com">&lt;bwmcadams@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWMCADAMS">BWMCADAMS</a><br />

848. Brenden Conte  <a href="mailto:conteb@cpan.org">&lt;conteb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CONTEB">CONTEB</a><br />
849. Brendt Wohlberg  <a href="mailto:wohl@cpan.org">&lt;wohl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WOHL">WOHL</a><br />
850. <a href="http://p1k3.com/">Brennen Pike Bearnes</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BRENNEN<br />

851. <a href="http://breno.org">Breno Colom</a>  <a href="mailto:brenocolom@gmail.com">&lt;brenocolom@gmail.com&gt;</a> -- BRENO<br />
852. Breno G. de Oliveira  <a href="mailto:garu@cpan.org">&lt;garu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARU">GARU</a><br />
853. Brent Alan Hughes  <a href="mailto:brent_hughes_@hotmail.com">&lt;brent_hughes_@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAHUGHES">BAHUGHES</a><br />

854. Brent B. Powers  <a href="mailto:cpan@B2Pi.com">&lt;cpan@B2Pi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPOWERS">BPOWERS</a><br />
855. <a href="http://www.brentdax.com/">Brent Dax</a>  <a href="mailto:brentdax@cpan.org">&lt;brentdax@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRENTDAX">BRENTDAX</a><br />
856. <a href="http://www.remnetworks.org">Brent Garber</a>  <a href="mailto:overlordq@gmail.com">&lt;overlordq@gmail.com&gt;</a> -- BGARBER<br />

857. <a href="http://bh.selfip.com">Brent Henry</a>  <a href="mailto:bsaajm@gmail.com">&lt;bsaajm@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSHENRY">BSHENRY</a><br />
858. Brent Hostetler  <a href="mailto:bch@cpan.org">&lt;bch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCH">BCH</a><br />
859. Brent Michalski  <a href="mailto:brent@perlguy.net">&lt;brent@perlguy.net&gt;</a> -- BRENT<br />

860. Brent Pedersen  <a href="mailto:bpederse@cpan.org">&lt;bpederse@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPEDERSE">BPEDERSE</a><br />
861. <a href="brentonchapin.homeip.net">Brenton Chapin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BK/BKCHAPIN">BKCHAPIN</a><br />
862. <a href="http://csml.som.ohio-state.edu/~aarden">Bret Aarden</a>  <a href="mailto:aarden.1@osu.edu">&lt;aarden.1@osu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AA/AARDEN">AARDEN</a><br />

863. Bret Hunter  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BHUNTER<br />
864. <a href="www.ckuru.com">Bret Weinraub</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LINTDOG<br />
865. <a href="http://simple.be/">Brett Hamilton</a>  <a href="mailto:open@simple.be">&lt;open@simple.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRETT">BRETT</a><br />

866. <a href="http://www.pricelab.biz">Brett Heinze</a>  <a href="mailto:heinze@pricelab.biz">&lt;heinze@pricelab.biz&gt;</a> -- HEINZEBA<br />
867. <a href="http://www.wgz.org/bwarden/">Brett T. Warden</a>  <a href="mailto:bwarden+pause@wgz.org">&lt;bwarden+pause@wgz.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWARDEN">BWARDEN</a><br />
868. <a href="http://briac.net/">Briac Pilpré</a>  <a href="mailto:briac@cpan.org">&lt;briac@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIAC">BRIAC</a><br />

869. <a href="http://tangent.org/~brian/">Brian Aker</a>  <a href="mailto:brian@tangent.org">&lt;brian@tangent.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KROW">KROW</a><br />
870. <a href="www.bxbd.net">Brian Bittman</a>  <a href="mailto:cpan@bxbd.net">&lt;cpan@bxbd.net&gt;</a> -- BXBD<br />
871. <a href="www.perljax.us">Brian C. Thomas</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BC/BCT">BCT</a><br />

872. Brian Cassidy  <a href="mailto:bricas@cpan.org">&lt;bricas@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRICAS">BRICAS</a><br />
873. <a href="http://www.shmoo.com/~bmc">Brian Caswell</a>  <a href="mailto:bmc@shmoo.com">&lt;bmc@shmoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMC">BMC</a><br />
874. Brian Conry  <a href="mailto:perl@theconrys.com">&lt;perl@theconrys.com&gt;</a> -- BCONRY<br />

875. Brian Cooke  <a href="mailto:mrkoffee@saltedsnail.com">&lt;mrkoffee@saltedsnail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRKOFFEE">MRKOFFEE</a><br />
876. Brian D  <a href="mailto:bdwor@cpan.org">&lt;bdwor@cpan.org&gt;</a> -- BDWOR<br />
877. <a href="http://applespider.com">Brian Dellert</a>  <a href="mailto:aspider@pobox.com">&lt;aspider@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPIDER">ASPIDER</a><br />

878. Brian Dowling  <a href="mailto:bjd-dev@bftg.net">&lt;bjd-dev@bftg.net&gt;</a> -- BDOWLING<br />
879. <a href="http://matatu.org/bduggan/">Brian Duggan</a>  <a href="mailto:bduggan@matatu.org">&lt;bduggan@matatu.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDUGGAN">BDUGGAN</a><br />
880. <a href="http://www.massassi.net/">Brian E. Lozier</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOZIER">LOZIER</a><br />

881. <a href="http://etapic.name">Brian Edwards</a>  <a href="mailto:brian.mabry.edwards@gmail.com">&lt;brian.mabry.edwards@gmail.com&gt;</a> -- BMEDWAR<br />
882. Brian Guarraci  <a href="mailto:bguarrac@hotmail.com">&lt;bguarrac@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BG/BGUARRACI">BGUARRACI</a><br />
883. <a href="http://www.ibc.wustl.edu/~brian">Brian H. Dunford-Shore</a>  <a href="mailto:brian@ibc.wustl.edu">&lt;brian@ibc.wustl.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIAN">BRIAN</a><br />

884. Brian Hann  <a href="mailto:">&lt;&gt;</a> -- BHANN<br />
885. Brian Hodges  <a href="mailto:bhodges@pelemele.com">&lt;bhodges@pelemele.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHODGES">BHODGES</a><br />
886. <a href="http://www.digitalco.com/staff/brian/">Brian Horakh</a>  <a href="mailto:brian@zoovy.com">&lt;brian@zoovy.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZO/ZOOVY">ZOOVY</a><br />

887. Brian Horan  <a href="mailto:bhoran@gate.net">&lt;bhoran@gate.net&gt;</a> -- BHORAN<br />
888. <a href="http://www.jepstone.net">Brian Jepson</a>  <a href="mailto:bjepson@jepstone.net">&lt;bjepson@jepstone.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJEPS">BJEPS</a><br />
889. <a href="http://www.vermonster.com">Brian Kaney</a>  <a href="mailto:bkaney@gmail.com">&lt;bkaney@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KANEY">KANEY</a><br />

890. <a href="http://www.vermonster.com">Brian Kaney</a>  <a href="mailto:brian@vermonster.com">&lt;brian@vermonster.com&gt;</a> -- BKANEY<br />
891. Brian Keck  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWKECK">BWKECK</a><br />
892. <a href="www.fullautosoftware.net">Brian Kelly</a>  <a href="mailto:Brian.Kelly@fullautosoftware.net">&lt;Brian.Kelly@fullautosoftware.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REEDFISH">REEDFISH</a><br />

893. Brian King  <a href="mailto:mrbbking@pobox.com">&lt;mrbbking@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BK/BKING">BKING</a><br />
894. Brian Knight  <a href="mailto:tforce@concentric.net">&lt;tforce@concentric.net&gt;</a> -- BKNIGHT<br />
895. Brian Knox  <a href="mailto:laotse@roninfoo.net">&lt;laotse@roninfoo.net&gt;</a> -- BRIANKNOX<br />
896. Brian Koontz  <a href="mailto:brian@pongonova.net">&lt;brian@pongonova.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAK">BAK</a><br />

897. <a href="http://webcoder.info/">Brian Lalonde</a>  <a href="mailto:brianiacus@yahoo.com">&lt;brianiacus@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIANL">BRIANL</a><br />
898. <a href="http://junior.apk.net/~bmames">Brian M. Ames</a>  <a href="mailto:bmames@apk.net">&lt;bmames@apk.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMAMES">BMAMES</a><br />
899. Brian McCauley  <a href="mailto:nobull67@gmail.com">&lt;nobull67@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOBULL">NOBULL</a><br />

900. <a href="mysite.verizon.net/vze6sgt9">Brian McGonigle</a>  <a href="mailto:brian.mcgonigle@verizon.net">&lt;brian.mcgonigle@verizon.net&gt;</a> -- BMCG<br />
901. <a href="http://www.idi-middleware.com">Brian Meekings</a>  <a href="mailto:meekings@idi-middleware.com">&lt;meekings@idi-middleware.com&gt;</a> -- BMEEKINGS<br />
902. Brian Millett  <a href="mailto:bpm@techapp.com">&lt;bpm@techapp.com&gt;</a> -- BMILLETT<br />

903. <a href="http://win32-gui-skin.sourceforge.net">Brian Millham</a>  <a href="mailto:bmillham@hughes.net">&lt;bmillham@hughes.net&gt;</a> -- BMILLHAM<br />
904. <a href="http://www.maz.org/">Brian Moseley</a>  <a href="mailto:cpan@maz.org">&lt;cpan@maz.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IX/IX">IX</a><br />
905. Brian Moyles  <a href="mailto:bmoyles@gmail.com">&lt;bmoyles@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMOYLES">BMOYLES</a><br />

906. <a href="http://brian.radiation.net/">Brian Ng</a>  <a href="mailto:brian@radiation.net">&lt;brian@radiation.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIANNG">BRIANNG</a><br />
907. Brian O'Connor  <a href="mailto:boconnor@ucla.edu">&lt;boconnor@ucla.edu&gt;</a> -- BOCONNOR<br />
908. Brian Olsen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GRIFF<br />

909. Brian Paulsen  <a href="mailto:brian@thePaulsens.com">&lt;brian@thePaulsens.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPAULSEN">BPAULSEN</a><br />
910. Brian Perez  <a href="mailto:brianlperez@yahoo.com">&lt;brianlperez@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEREZ">PEREZ</a><br />
911. Brian Phillips  <a href="mailto:bphillips@cpan.org">&lt;bphillips@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPHILLIPS">BPHILLIPS</a><br />

912. Brian Reichert  <a href="mailto:reichert@numachi.com">&lt;reichert@numachi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REICHERT">REICHERT</a><br />
913. <a href="http://www.cubik.ca/">Brian Richardson</a>  <a href="mailto:root@localhost">&lt;root@localhost&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJR">BJR</a><br />
914. Brian Shade  <a href="mailto:bshade@gmail.com">&lt;bshade@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSHADE">BSHADE</a><br />

915. <a href="http://palimpse.st/">Brian Smith</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CRIACOW<br />
916. Brian Szymanski  <a href="mailto:ski-cpan@allafrica.com">&lt;ski-cpan@allafrica.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIANSKI">BRIANSKI</a><br />
917. <a href="http://spuriousinterrupt.org/">Brian Tarricone</a>  <a href="mailto:bjt23@cornell.edu">&lt;bjt23@cornell.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BJ/BJT">BJT</a><br />

918. Brian Thomas  <a href="mailto:brian.thomas@gmail.com">&lt;brian.thomas@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRTHOMAS">BRTHOMAS</a><br />
919. <a href="http://www.nnaf.net/~briansp/">Brian W. Spolarich</a>  <a href="mailto:briansp@UU.NET">&lt;briansp@UU.NET&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRIANSP">BRIANSP</a><br />
920. Brian Webb  <a href="mailto:bwebb9@yahoo.com">&lt;bwebb9@yahoo.com&gt;</a> -- BWEBB<br />

921. <a href="http://solutions.altavista.com/">Brian Williams</a>  <a href="mailto:Brian.Williams@av.com">&lt;Brian.Williams@av.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BW/BWILLIAM">BWILLIAM</a><br />
922. Brice Mason  <a href="mailto:bricemason@gmail.com">&lt;bricemason@gmail.com&gt;</a> -- BRICE<br />
923. <a href="http://www.cs.umn.edu/~bthomson">Bridget McInnes</a>  <a href="mailto:bthomson@cs.umn.edu">&lt;bthomson@cs.umn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BT/BTMCINNES">BTMCINNES</a><br />

924. <a href="http://icd.cc.purdue.edu/~bseib">Broc Seib</a>  <a href="mailto:bseib@purdue.edu">&lt;bseib@purdue.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BROCSEIB">BROCSEIB</a><br />
925. <a href="http://thelackthereof.org/">Brock Wilcox</a>  <a href="mailto:awwaiid@thelackthereof.org">&lt;awwaiid@thelackthereof.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AW/AWWAIID">AWWAIID</a><br />
926. <a href="http://www.brong.net/">Bron Gondwana</a>  <a href="mailto:perlcode@brong.net">&lt;perlcode@brong.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRONG">BRONG</a><br />

927. BrowserUk  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BROWSERUK">BROWSERUK</a><br />
928. Bruce Campbell  <a href="mailto:beecee@cpan.zerlargal.org">&lt;beecee@cpan.zerlargal.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEECEE">BEECEE</a><br />
929. <a href="http://gtcs.com/~bruce">Bruce Gingery</a>  <a href="mailto:bgingery@gtcs.com">&lt;bgingery@gtcs.com&gt;</a> -- BGINGERY<br />

930. <a href="http://www.perlmonks.org/?node_id=154438">Bruce Gray</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BGRAY<br />
931. <a href="http://custard.demon.co.uk">Bruce James</a>  <a href="mailto:custard@cpan.org">&lt;custard@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CU/CUSTARD">CUSTARD</a><br />
932. Bruce Keeler  <a href="mailto:bjkcpan@drangle.com">&lt;bjkcpan@drangle.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUCEK">BRUCEK</a><br />

933. Bruce Mackay Axtens  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BOOST<br />
934. <a href="http://www.itdev.co.uk">Bruce Mitchell</a>  <a href="mailto:admin@itdev.co.uk">&lt;admin@itdev.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITDEV">ITDEV</a><br />
935. <a href="http://bran.curtin.edu.au/~morgan">Bruce Morgan</a>  <a href="mailto:morgan@networks.curtin.edu.au">&lt;morgan@networks.curtin.edu.au&gt;</a> -- BMORGAN<br />

936. <a href="http://xafs.org/BruceRavel">Bruce Ravel</a>  <a href="mailto:bravel@cpan.org">&lt;bravel@cpan.org&gt;</a> -- BRAVEL<br />
937. Bruce Robertson  <a href="mailto:brucer@theodolite.dyndns.org">&lt;brucer@theodolite.dyndns.org&gt;</a> -- BRUCER<br />
938. Bruce Schuck  <a href="mailto:bschuck@asgard-systems.com">&lt;bschuck@asgard-systems.com&gt;</a> -- BPSCHUCK<br />

939. <a href="brucevanallen.com">Bruce Van Allen</a>  <a href="mailto:bva@cruzio.com">&lt;bva@cruzio.com&gt;</a> -- BVA<br />
940. <a href="http://www.ebruni.it/">Bruni Emiliano</a>  <a href="mailto:info@ebruni.it">&lt;info@ebruni.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBRUNI">EBRUNI</a><br />
941. <a href="http://www.whack.org/~bruno/">Bruno Connelly</a>  <a href="mailto:bruno@whack.org">&lt;bruno@whack.org&gt;</a> -- BRUNO<br />

942. <a href="http://trac.project-builder.org">Bruno Cornec</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BCO<br />
943. Bruno Czekay  <a href="mailto:brunorc _at_ gmail.com">&lt;brunorc _at_ gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUNORC">BRUNORC</a><br />
944. Bruno Díaz Brière  <a href="mailto:brunodiaz@cpan.org">&lt;brunodiaz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUNODIAZ">BRUNODIAZ</a><br />

945. <a href="http://www.qmailwiki.org/User:Bnegrao">Bruno Negrao</a>  <a href="mailto:bnegrao AT gmail DOT com">&lt;bnegrao AT gmail DOT com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BN/BNEGRAO">BNEGRAO</a><br />
946. Bruno Postle  <a href="mailto:bruno@postle.net">&lt;bruno@postle.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPOSTLE">BPOSTLE</a><br />
947. Bruno Tavares  <a href="mailto:bmavt@cpan.org">&lt;bmavt@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BM/BMAVT">BMAVT</a><br />

948. <a href="http://mirrorshades.org">Bryan Allen</a>  <a href="mailto:bda@mirrorshades.net">&lt;bda@mirrorshades.net&gt;</a> -- BDA<br />
949. Bryan Backer  <a href="mailto:bryan_backer@hp.com">&lt;bryan_backer@hp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBACKER">BBACKER</a><br />
950. <a href="http://home.inwave.com/eija">Bryan Baldus</a>  <a href="mailto:eijabb@cpan.org">&lt;eijabb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EIJABB">EIJABB</a><br />

951. Bryan Bayerdorffer  <a href="mailto:bryan@meatspace.net">&lt;bryan@meatspace.net&gt;</a> -- COLMODE<br />
952. Bryan Burgers  <a href="mailto:mrborisguy@gmail.com">&lt;mrborisguy@gmail.com&gt;</a> -- BURGERS<br />
953. <a href="http://members.home.com/bcwarno/">Bryan C. Warnock</a>  <a href="mailto:bwarnock@capita.com">&lt;bwarnock@capita.com&gt;</a> -- WHAMMO<br />

954. Bryan Henderson  <a href="mailto:bryanh@giraffe-data.com">&lt;bryanh@giraffe-data.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GIRAFFED">GIRAFFED</a><br />
955. Bryan James Donlan  <a href="mailto:bdonlan@gmail.com">&lt;bdonlan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDONLAN">BDONLAN</a><br />
956. <a href="http://www.ling.uni-potsdam.de/~moocow">Bryan Jurish</a>  <a href="mailto:jurish@ling.uni-potsdam.de">&lt;jurish@ling.uni-potsdam.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOOCOW">MOOCOW</a><br />

957. <a href="http://www.bryantmcgill.com/Shazam_Perl_Module/">Bryant H. McGill</a>  <a href="mailto:mcgill@cpan.org">&lt;mcgill@cpan.org&gt;</a> -- MCGILL<br />
958. <a href="http://www.bryceharrington.org/">Bryce Harrington</a>  <a href="mailto:bryce--at--bryceharrington--dot--org">&lt;bryce--at--bryceharrington--dot--org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRYCE">BRYCE</a><br />
959. <a href="http://bryceporter.info/">Bryce Porter</a>  <a href="mailto:bryce.porter@gmail.com">&lt;bryce.porter@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BP/BPORTER">BPORTER</a><br />

960. Bryn Honeyman  <a href="mailto:Bryn.Honeyman@deh.gov.au">&lt;Bryn.Honeyman@deh.gov.au&gt;</a> -- HONEYMAN<br />
961. <a href="www.ursa-minor.me.uk">Buck Star</a>  <a href="mailto:secret@secret">&lt;secret@secret&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUCKSTER">BUCKSTER</a><br />
962. Buddy Burden  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BAREFOOT<br />

963. Budrica Petre Cosmin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- COSMIN<br />
964. <a href="http://www.bsi.bund.de/">Bundesamt für Sicherheit in der Informationstechnik</a>  <a href="mailto:bsi@cpan.org">&lt;bsi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BS/BSI">BSI</a><br />
965. <a href="http://gursoy.org/">Burak Gürsoy</a>  <a href="mailto:burak@cpan.org">&lt;burak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BURAK">BURAK</a><br />

966. <a href="http://io.nyswonger.org/burl">Burl Nyswonger</a>  <a href="mailto:Burl@Nyswonger.org">&lt;Burl@Nyswonger.org&gt;</a> -- BURL<br />
967. <a href="http://www.bugragedik.com">Buğra Gedık</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BGEDIK<br />
968. <a href="http://majordojo.com/">Byrne Reese</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BY/BYRNE">BYRNE</a><br />

969. <a href="http://www.archive.rhps.org/">Byron Brummer</a>  <a href="mailto:zenin@bawdycaste.org">&lt;zenin@bawdycaste.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZENIN">ZENIN</a><br />
970. Byron Darrah  <a href="mailto:bdarrah@pacbell.net">&lt;bdarrah@pacbell.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BD/BDARRAH">BDARRAH</a><br />
971. Bálint Szilakszi  <a href="mailto:szbalint@cpan.org">&lt;szbalint@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SZ/SZBALINT">SZBALINT</a><br />

972. C. Chad Wallace  <a href="mailto:cmdrwalrus@canada.com">&lt;cmdrwalrus@canada.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCWALLACE">CCWALLACE</a><br />
973. <a href="http://www.digitalkoma.com/church/">C. Church</a>  <a href="mailto:church@digitalkoma.com">&lt;church@digitalkoma.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHURCH">CHURCH</a><br />
974. C. Garrett Goebel  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGOEBEL">GGOEBEL</a><br />

975. C. McCohy  <a href="mailto:mccohy@kyberdigi.cz">&lt;mccohy@kyberdigi.cz&gt;</a> -- MCCOHY<br />
976. C.H. Kang  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AERO">AERO</a><br />
977. <a href="http://wp.colliertech.org/cj/">C.J. Adams-Collier</a>  <a href="mailto:cjac@colliertech.org">&lt;cjac@colliertech.org&gt;</a> -- CJCOLLIER<br />

978. <a href="http://www.iamcal.com/">Cal Henderson</a>  <a href="mailto:cal@iamcal.com">&lt;cal@iamcal.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IAMCAL">IAMCAL</a><br />
979. Caleb Crome  <a href="mailto:perl@crome.org">&lt;perl@crome.org&gt;</a> -- CALEB<br />
980. <a href="http://www.bklyn.org/">Caleb Epstein</a>  <a href="mailto:die-spammers-die@localhost.localnet">&lt;die-spammers-die@localhost.localnet&gt;</a> -- CAE<br />

981. <a href="http://www.cyberpomo.com/perl/">Calle Dybedahl</a>  <a href="mailto:calle@lysator.liu.se">&lt;calle@lysator.liu.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDYBED">CDYBED</a><br />
982. Calvin Mah  <a href="mailto:calvin.mah at gmail">&lt;calvin.mah at gmail&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CALVINM">CALVINM</a><br />
983. <a href="www.clueinc.net">Cameron Ashby</a>  <a href="mailto:cameron@clueinc.net">&lt;cameron@clueinc.net&gt;</a> -- CAMERON<br />

984. <a href="http://www.armory.com/~spectre/">Cameron Kaiser</a>  <a href="mailto:ckaiser@floodgap.com">&lt;ckaiser@floodgap.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CK/CKAISER">CKAISER</a><br />
985. Cameron Laird  <a href="mailto:claird@starbase.neosoft.com">&lt;claird@starbase.neosoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLAIRD">CLAIRD</a><br />
986. <a href="http://pownce.com/cmaussan/">Camille Maussang</a>  <a href="mailto:cmaussan@cpan.org">&lt;cmaussan@cpan.org&gt;</a> -- CMAUSSAN<br />

987. Cancel Account  <a href="mailto:vhgwlpar@mac.com">&lt;vhgwlpar@mac.com&gt;</a> -- RPEASE<br />
988. <a href="http://carey.geek.nz/">Carey Evans</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CEVANS">CEVANS</a><br />
989. Carey Tilden  <a href="mailto:revdiablo@wd39.com">&lt;revdiablo@wd39.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBTILDEN">CBTILDEN</a><br />

990. Carl Adler  <a href="mailto:carl_adler@idx.com">&lt;carl_adler@idx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARLADLER">CARLADLER</a><br />
991. <a href="http://www.inbe.net/~carl/">Carl Declerck</a>  <a href="mailto:carl@miskatonic.inbe.net">&lt;carl@miskatonic.inbe.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARL">CARL</a><br />
992. <a href="http://www.fireartist.com">Carl Franks</a>  <a href="mailto:cpan@fireartist.com">&lt;cpan@fireartist.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFRANKS">CFRANKS</a><br />

993. <a href="www.comets.com">Carl Friedberg</a>  <a href="mailto:friedberg@comets.com">&lt;friedberg@comets.com&gt;</a> -- FRIEDBERG<br />
994. <a href="www.comets.com">Carl Friedberg</a>  <a href="mailto:frida.fried@comets.com">&lt;frida.fried@comets.com&gt;</a> -- FRIDA<br />
995. <a href="http://isd.usc.edu/~hayter">Carl Hayter</a>  <a href="mailto:hayter@usc.edu">&lt;hayter@usc.edu&gt;</a> -- HAYTER<br />

996. Carl Joslin  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAJOSS">CAJOSS</a><br />
997. <a href="http://masak.org/carl/">Carl Mäsak</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MASAK<br />
998. Carl Räihä  <a href="mailto:carl.raiha at gmail.com">&lt;carl.raiha at gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAIHA">CRAIHA</a><br />

999. <a href="https://psyced.org/PSYC/">Carl v. Loesch</a>  <a href="mailto:root@localhost">&lt;root@localhost&gt;</a> -- LYNX<br />
1000. Carlos B Rios  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RIOSCB<br />
1001. Carlos B. Rios  <a href="mailto:rios@cpan.org">&lt;rios@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIOS">RIOS</a><br />

1002. <a href="www.rtir.es">Carlos Fuentes</a>  <a href="mailto:c.fuentesb@gmail.com">&lt;c.fuentesb@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARLOSFB">CARLOSFB</a><br />
1003. Carlos Garnacho Parro  <a href="mailto:carlosg@gnome.org">&lt;carlosg@gnome.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARNACHO">GARNACHO</a><br />
1004. <a href="http://www.quantumfx.com/">Carlos Ramirez</a>  <a href="mailto:carlos@quantumfx.com">&lt;carlos@quantumfx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAMIREZ">CRAMIREZ</a><br />

1005. Carlos Vicente  <a href="mailto:cvicente@cpan.org">&lt;cvicente@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CV/CVICENTE">CVICENTE</a><br />
1006. Carmo Crediney de Melo  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CCMELO<br />
1007. <a href="http://cassj.co.uk">Caroline Johnston</a>  <a href="mailto:cassjohnston@gmail.com">&lt;cassjohnston@gmail.com&gt;</a> -- CASSJ<br />

1008. Carter Lamb  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CLAMB<br />
1009. <a href="http://www.fluob.com/">Caryl GRENIER</a>  <a href="mailto:fluo@fluob.com">&lt;fluo@fluob.com&gt;</a> -- FLUOB<br />
1010. Case Larsen  <a href="mailto:clarsen@emf.net">&lt;clarsen@emf.net&gt;</a> -- CTLARSEN<br />

1011. <a href="http://www.cuvou.com/">Casey Kirsle</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIRSLE">KIRSLE</a><br />
1012. <a href="http://www.cplee.org">Casey Lee</a>  <a href="mailto:info@cplee.org">&lt;info@cplee.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPLEE">CPLEE</a><br />
1013. <a href="http://geeknest.com/">Casey West</a>  <a href="mailto:casey@geeknest.com">&lt;casey@geeknest.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTWETEN">CTWETEN</a><br />

1014. <a href="http://caseywest.com/">Casey West</a>  <a href="mailto:casey@geeknest.com">&lt;casey@geeknest.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CW/CWEST">CWEST</a><br />
1015. <a href="http://nereida.deioc.ull.es">Casiano Rodriguez-Leon</a>  <a href="mailto:casiano.rodriguez.leon@gmail.com">&lt;casiano.rodriguez.leon@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CASIANO">CASIANO</a><br />
1016. <a href="http://casper.warming.com">Casper Warming</a>  <a href="mailto:cwg@usr.bin.dk">&lt;cwg@usr.bin.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WARMING">WARMING</a><br />

1017. Cass W. Everitt  <a href="mailto:cass@Objectecture.com">&lt;cass@Objectecture.com&gt;</a> -- CWEVERITT<br />
1018. Cat Okita  <a href="mailto:cat@reptiles.org">&lt;cat@reptiles.org&gt;</a> -- CAT<br />
1019. Ce Zhang  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CEZHANG<br />
1020. Cees Hek  <a href="mailto:cees-perl@crtconsulting.ca">&lt;cees-perl@crtconsulting.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CEESHEK">CEESHEK</a><br />

1021. Chad A. Clark  <a href="mailto:c_clark@cpan.org">&lt;c_clark@cpan.org&gt;</a> -- CCLARK<br />
1022. <a href="http://www.open-exodus.net">Chad Granum</a>  <a href="mailto:exodist7@gmail.com">&lt;exodist7@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EX/EXODIST">EXODIST</a><br />
1023. Chad Hogan  <a href="mailto:chad.hogan[at]shaw.ca">&lt;chad.hogan[at]shaw.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHOGAN">CHOGAN</a><br />

1024. <a href="http://www.megatome.com/win32systeminfo">Chad Johnston</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJOHNSTON">CJOHNSTON</a><br />
1025. <a href="http://www.ncsa.uiuc.edu/~ckerner">Chad Kerner</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CK/CKERNER">CKERNER</a><br />
1026. <a href="http://www.chadlavy.com/">Chad Lavy</a>  <a href="mailto:chad@chadlavy.com">&lt;chad@chadlavy.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CN/CNLAVY">CNLAVY</a><br />

1027. Chad M. Johnson  <a href="mailto:perl_modules@johnsonsa.com">&lt;perl_modules@johnsonsa.com&gt;</a> -- CHADMJOHN<br />
1028. <a href="http://samo.org/~chad/">Chad Norwood</a>  <a href="mailto:chad@samo.org">&lt;chad@samo.org&gt;</a> -- SAMO<br />
1029. <a href="http://www.windmeadow.com">Chad Phillips</a>  <a href="mailto:chad@chadphillips.org">&lt;chad@chadphillips.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEMPALTE">TEMPALTE</a><br />

1030. Chad Wagner  <a href="mailto:chad.wagner@gmail.com">&lt;chad.wagner@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WAGNERCH">WAGNERCH</a><br />
1031. Chaddaï Fouché  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JEDAI<br />
1032. <a href="http://chady.net/">Chady Kassouf</a>  <a href="mailto:leviathan@cpan.org">&lt;leviathan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEVIATHAN">LEVIATHAN</a><br />

1033. Chae Lee  <a href="mailto:cglee@cpan.org">&lt;cglee@cpan.org&gt;</a> -- CGLEE<br />
1034. Chander Ganesan  <a href="mailto:cganesan@cpan.org">&lt;cganesan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGANESAN">CGANESAN</a><br />
1035. <a href="http://www.ics.uci.edu/~cliu1">Chang Liu</a>  <a href="mailto:liu@ics.uci.edu">&lt;liu@ics.uci.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHANG-LIU">CHANG-LIU</a><br />

1036. Channappa Pujar  <a href="mailto:pujar_perl@yahoo.com">&lt;pujar_perl@yahoo.com&gt;</a> -- PUJAR<br />
1037. Chaoji Li  <a href="mailto:lichaoji@gmail.com">&lt;lichaoji@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LITCHIE">LITCHIE</a><br />
1038. Charles Ayres  <a href="mailto:lunartear@cpan.org">&lt;lunartear@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUNARTEAR">LUNARTEAR</a><br />

1039. <a href="http://www.newman.upenn.edu/~bailey">Charles Bailey</a>  <a href="mailto:bailey@newman.upenn.edu">&lt;bailey@newman.upenn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBAIL">CBAIL</a><br />
1040. <a href="http://www.web-i18n.net/">Charles C. Fu</a>  <a href="mailto:perl@web-i18n.net">&lt;perl@web-i18n.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCWF">CCWF</a><br />
1041. <a href="http://nnflex.g0n.net">Charles Colbourn</a>  <a href="mailto:charlesc@g0n.net">&lt;charlesc@g0n.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCOLBOURN">CCOLBOURN</a><br />

1042. <a href="http://www.s1te.com/">Charles Day</a>  <a href="mailto:Charles.Day@s1te.com">&lt;Charles.Day@s1te.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARRACODE">BARRACODE</a><br />
1043. <a href="http://duphy4.physics.drexel.edu/~lane/">Charles Lane</a>  <a href="mailto:lane@duphy4.physics.drexel.edu">&lt;lane@duphy4.physics.drexel.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLANE">CLANE</a><br />
1044. Charles MINC  <a href="mailto:charles.minc@wanadoo.fr">&lt;charles.minc@wanadoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHESSKIT">CHESSKIT</a><br />

1045. <a href="http://www.cs.odu.edu/~cmorris">Charles Morris</a>  <a href="mailto:cmorris@cpan.org">&lt;cmorris@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMORRIS">CMORRIS</a><br />
1046. Charles N. Owens  <a href="mailto:czbsd@cpan.org">&lt;czbsd@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CZ/CZBSD">CZBSD</a><br />
1047. <a href="http://www.flickr.com/photos/charlestilford/">Charles Tilford</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TILFORDC<br />

1048. <a href="http://www.csua.berkeley.edu/~chucky/">Charles Ying</a>  <a href="mailto:cying@photonfx.com">&lt;cying@photonfx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CY/CYING">CYING</a><br />
1049. Charlie Garrison  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CNG<br />
1050. Charlie Piper  <a href="mailto:piper@dev-null.net">&lt;piper@dev-null.net&gt;</a> -- PIPER<br />

1051. <a href="http://www.antipope.org/charlie/">Charlie Stross</a>  <a href="mailto:charlie@antipope.org">&lt;charlie@antipope.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHSTROSS">CHSTROSS</a><br />
1052. Chart-Group  <a href="mailto:chart@fs.wettzell.de">&lt;chart@fs.wettzell.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHARTGRP">CHARTGRP</a><br />
1053. Chase Whitener  <a href="mailto:cwhitener@gmail.com">&lt;cwhitener@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAPOEIRAB">CAPOEIRAB</a><br />

1054. Chekuri Gautam  <a href="mailto:gautam.chekuri@nospam.tld">&lt;gautam.chekuri@nospam.tld&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGAUTAM">CGAUTAM</a><br />
1055. Chen Yirong (春江)  <a href="mailto:cyr.master@gmail.com">&lt;cyr.master@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHENYR">CHENYR</a><br />
1056. Cheng-Ju Kuo  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJUKUO">CJUKUO</a><br />

1057. <a href="http://blog.dragon2.net/">Cheng-Lung Sung (宋政隆)</a>  <a href="mailto:clsung@gmail.com">&lt;clsung@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLSUNG">CLSUNG</a><br />
1058. Chester Day  <a href="mailto:chesterday@netscape.net">&lt;chesterday@netscape.net&gt;</a> -- CHESTER<br />
1059. Chet Gray  <a href="mailto:chet D0T the D0T gray (a) gmail D0T com">&lt;chet D0T the D0T gray (a) gmail D0T com&gt;</a> -- CGRAY<br />

1060. Chetan Patil  <a href="mailto:cpatil@cpan.org">&lt;cpatil@cpan.org&gt;</a> -- CPATIL<br />
1061. Chetan Sarva  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CSARVA<br />
1062. <a href="http://www.clkao.org/">Chia-liang Kao (高嘉良)</a>  <a href="mailto:clkao@clkao.org">&lt;clkao@clkao.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLKAO">CLKAO</a><br />

1063. Chicheng Zhang  <a href="mailto:chichengzhang@hotmail.com">&lt;chichengzhang@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCZ">CCZ</a><br />
1064. <a href="http://engwar.com/">Chintana Wilamuna</a>  <a href="mailto:chintana@engwar.com">&lt;chintana@engwar.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHINTANA">CHINTANA</a><br />
1065. Chip Salzenberg  <a href="mailto:chip@pobox.com">&lt;chip@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHIPS">CHIPS</a><br />

1066. <a href="http://perl.pattern.net">Chip Turner</a>  <a href="mailto:cturner@pattern.net">&lt;cturner@pattern.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHIPT">CHIPT</a><br />
1067. Chirs Gu  <a href="mailto:gsgang@gmail.com">&lt;gsgang@gmail.com&gt;</a> -- GSGANG<br />
1068. <a href="http://www.herlpacker.co.uk/">Chisel Wright</a>  <a href="mailto:cpan@herlpacker.co.uk">&lt;cpan@herlpacker.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHISEL">CHISEL</a><br />

1069. <a href="http://nodnol.org/blog/">Chris Andrews</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISA">CHRISA</a><br />
1070. Chris Angell  <a href="mailto:chris@chrisangell.com">&lt;chris@chrisangell.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CANGELL">CANGELL</a><br />
1071. <a href="http://printf.net/">Chris Ball</a>  <a href="mailto:chris@pkl.net">&lt;chris@pkl.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRIS">CHRIS</a><br />

1072. <a href="http://www.themindofmadness.com">Chris Becker</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLBECKER">CLBECKER</a><br />
1073. Chris Brooks  <a href="mailto:cbrooks@cpan.org">&lt;cbrooks@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBROOKS">CBROOKS</a><br />
1074. <a href="http://chris.carline.org/">Chris Carline</a>  <a href="mailto:chris@carline.org">&lt;chris@carline.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISC">CHRISC</a><br />

1075. Chris Chittleborough  <a href="mailto:cchittleborough@yahoo.com.au">&lt;cchittleborough@yahoo.com.au&gt;</a> -- CCHITTLE<br />
1076. Chris Cobb  <a href="mailto:no dot spam at ccobb dot net">&lt;no dot spam at ccobb dot net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCOBB">CCOBB</a><br />
1077. <a href="http://bioperl.org">Chris Dagdigian</a>  <a href="mailto:dag@sonsorol.org">&lt;dag@sonsorol.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAFFI">CRAFFI</a><br />

1078. <a href="http://www.chrisdavaz.com">Chris Davaz</a>  <a href="mailto:cdavaz@gmail.com">&lt;cdavaz@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVAZ">DAVAZ</a><br />
1079. <a href="http://www.webcastinabox.com">Chris Dawson</a>  <a href="mailto:cdawson@webiphany.com">&lt;cdawson@webiphany.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDAWSON">CDAWSON</a><br />
1080. <a href="http://www-aig.jpl.nasa.gov/home/ctdean/">Chris Dean</a>  <a href="mailto:ctdean@aig.jpl.nasa.gov">&lt;ctdean@aig.jpl.nasa.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTDEAN">CTDEAN</a><br />

1081. Chris Denney  <a href="mailto:denney72@yahoo.co.uk">&lt;denney72@yahoo.co.uk&gt;</a> -- DENNEY<br />
1082. <a href="http://www.burningchrome.com/">Chris Dent</a>  <a href="mailto:cdent@burningchrome.com">&lt;cdent@burningchrome.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDENT">CDENT</a><br />
1083. Chris DiMartino  <a href="mailto:chris_dot_dimartino_at_gmail_dot_com">&lt;chris_dot_dimartino_at_gmail_dot_com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIMARTINO">DIMARTINO</a><br />

1084. <a href="http://chrisdolan.net/">Chris Dolan</a>  <a href="mailto:cpan+spam@chrisdolan.net">&lt;cpan+spam@chrisdolan.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDOLAN">CDOLAN</a><br />
1085. <a href="http://www.ChrisDrake.com">Chris Drake</a>  <a href="mailto:christopher@pobox.com">&lt;christopher@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDRAKE">CDRAKE</a><br />
1086. <a href="http://www.philburt.com/perl/">Chris Dunkle</a>  <a href="mailto:">&lt;&gt;</a> -- PHILBURT<br />

1087. Chris Dunlop  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CHRISRD<br />
1088. <a href="denver.pm.org">Chris Fedde</a>  <a href="mailto:chris@fedde.us">&lt;chris@fedde.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFEDDE">CFEDDE</a><br />
1089. <a href="http://www.panix.com/~cfuhrman/">Chris Fuhrman</a>  <a href="mailto:cfuhrman@panix.com">&lt;cfuhrman@panix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFUHRMAN">CFUHRMAN</a><br />

1090. Chris Grau  <a href="mailto:cgrau@cpan.org">&lt;cgrau@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGRAU">CGRAU</a><br />
1091. <a href="http://www.picusnet.com/users/hagn/">Chris Hagn</a>  <a href="mailto:Chris.Hagn@pobox.com">&lt;Chris.Hagn@pobox.com&gt;</a> -- CHAGN<br />
1092. Chris Hall  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMCH">GMCH</a><br />

1093. <a href="http://www.whapps.com">Chris Jacobson</a>  <a href="mailto:chris.jacobson@whapps.com">&lt;chris.jacobson@whapps.com&gt;</a> -- CHRISTJ<br />
1094. <a href="http://www.puzzlepiece.org">Chris Jenks</a>  <a href="mailto:jenkster@resonance.org">&lt;jenkster@resonance.org&gt;</a> -- JENKSTER<br />
1095. <a href="http://www.visi.com/~cpj1/">Chris Josephes</a>  <a href="mailto:cpj1@visi.com">&lt;cpj1@visi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISJ">CHRISJ</a><br />

1096. <a href="http://encryptio.com/">Chris Kastorff</a>  <a href="mailto:encryptio@gmail.com">&lt;encryptio@gmail.com&gt;</a> -- ENCRYPTIO<br />
1097. Chris Kimber  <a href="mailto:chris@ifdef.org">&lt;chris@ifdef.org&gt;</a> -- CKIMBER<br />
1098. Chris Leach  <a href="mailto:leachcj@bp.com">&lt;leachcj@bp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CX/CXL">CXL</a><br />

1099. Chris Leishman  <a href="mailto:nospam@leishman.org">&lt;nospam@leishman.org&gt;</a> -- MASKLIN<br />
1100. Chris Leishman  <a href="mailto:chris@leishman.org">&lt;chris@leishman.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLEISHMAN">CLEISHMAN</a><br />
1101. <a href="http://www.ex-parrot.com/~chris/">Chris Lightfoot</a>  <a href="mailto:cl-perl@ex-parrot.com">&lt;cl-perl@ex-parrot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CW/CWRL">CWRL</a><br />

1102. <a href="http://www.flirble.org/chrisy/">Chris Luke</a>  <a href="mailto:chrisy@flirble.org">&lt;chrisy@flirble.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISY">CHRISY</a><br />
1103. Chris Marshall  <a href="mailto:chm@cpan.org">&lt;chm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHM">CHM</a><br />
1104. <a href="http://ros.res.cmu.edu/">Chris Mason</a>  <a href="mailto:cmason@ros.res.cmu.edu">&lt;cmason@ros.res.cmu.edu&gt;</a> -- CMASON<br />

1105. Chris McEwan  <a href="mailto:mcewan@cpan.org">&lt;mcewan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCEWAN">MCEWAN</a><br />
1106. <a href="http://www.mytechs.com/">Chris Meyer</a>  <a href="mailto:chris@mytechs.com">&lt;chris@mytechs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEYERCJM">MEYERCJM</a><br />
1107. Chris Miller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CIMIL<br />

1108. <a href="http://www.bouncingchairs.net/">Chris Monson</a>  <a href="mailto:monpublic@gmail.com">&lt;monpublic@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIBLON">SHIBLON</a><br />
1109. Chris Mungall  <a href="mailto:cjm@fruitfly.org">&lt;cjm@fruitfly.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMUNGALL">CMUNGALL</a><br />
1110. Chris Myers  <a href="mailto:c.myers@its.uq.edu.au">&lt;c.myers@its.uq.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMYERS">CMYERS</a><br />

1111. <a href="http://pudge.net/">Chris Nandor</a>  <a href="mailto:cnandor@cpan.org">&lt;cnandor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CN/CNANDOR">CNANDOR</a><br />
1112. Chris Novakovic  <a href="mailto:chrisn@cpan.org">&lt;chrisn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISN">CHRISN</a><br />
1113. <a href="http://www.atnf.csiro.au/people/Chris.Phillips">Chris Phillips</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPHIL">CPHIL</a><br />

1114. <a href="http://chris.prather.org/">Chris Prather</a>  <a href="mailto:chris@prather.org">&lt;chris@prather.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERIGRIN">PERIGRIN</a><br />
1115. <a href="http://www.globalspin.com/">Chris Radcliff</a>  <a href="mailto:chris@globalspin.com">&lt;chris@globalspin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RADCLIFF">RADCLIFF</a><br />
1116. <a href="http://www.triv.org/">Chris Reinhardt</a>  <a href="mailto:perl@triv.org">&lt;perl@triv.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CREIN">CREIN</a><br />

1117. Chris Rigby  <a href="mailto:chris@savantnet.com">&lt;chris@savantnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIGBYC">RIGBYC</a><br />
1118. <a href="http://chrissimmons.ca">Chris Simmons</a>  <a href="mailto:simmons.chris@gmail.com">&lt;simmons.chris@gmail.com&gt;</a> -- CHRISS<br />
1119. <a href="http://www.chriskate.net">Chris Sutton</a>  <a href="mailto:chriskate@gmail.com">&lt;chriskate@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJS">CJS</a><br />

1120. <a href="http://cthompson.com/">Chris Thompson</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTHOM">CTHOM</a><br />
1121. <a href="http://christhorman.com/">Chris Thorman</a>  <a href="mailto:chthorman@cpan.org">&lt;chthorman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHTHORMAN">CHTHORMAN</a><br />
1122. <a href="http://www.metatrontech.com">Chris Travers</a>  <a href="mailto:chris.travers@gmail.com">&lt;chris.travers@gmail.com&gt;</a> -- EINHVERFR<br />

1123. <a href="http://chris.vertonghen.org/">Chris Vertonghen</a>  <a href="mailto:chrisv@cpan.org">&lt;chrisv@cpan.org&gt;</a> -- CHRISV<br />
1124. Chris Weyl  <a href="mailto:rsrchboy@cpan.org">&lt;rsrchboy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSRCHBOY">RSRCHBOY</a><br />
1125. Chris Whiting  <a href="mailto:chrisjcra@cpan.org">&lt;chrisjcra@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISJCRA">CHRISJCRA</a><br />

1126. <a href="http://www.gumbynet.org.uk/">Chris Williams</a>  <a href="mailto:chris@bingosnet.co.uk">&lt;chris@bingosnet.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BINGOS">BINGOS</a><br />
1127. <a href="http://www.cwinters.com/">Chris Winters</a>  <a href="mailto:chris@cwinters.com">&lt;chris@cwinters.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CW/CWINTERS">CWINTERS</a><br />
1128. <a href="http://www.pcc-online.net">Christiaan Kras</a>  <a href="mailto:ckras@cpan.org">&lt;ckras@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CK/CKRAS">CKRAS</a><br />

1129. <a href="http://www.elys.com">Christian B Hicks</a>  <a href="mailto:cbh275@yahoo.com">&lt;cbh275@yahoo.com&gt;</a> -- CBHICKS<br />
1130. Christian Barkey  <a href="mailto:christian.barkey@hvb.lu">&lt;christian.barkey@hvb.lu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBARKEY">CBARKEY</a><br />
1131. Christian Bartolomäus  <a href="mailto:bartolin@gmx.de">&lt;bartolin@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARTOLIN">BARTOLIN</a><br />

1132. Christian Borup  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BORUP">BORUP</a><br />
1133. <a href="http:///www.yoda-speak.org">Christian Brink</a>  <a href="mailto:cbrink@flylines.org">&lt;cbrink@flylines.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GREP">GREP</a><br />
1134. Christian Brink  <a href="mailto:cbrink@christianbrink.com">&lt;cbrink@christianbrink.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBRINK">CBRINK</a><br />

1135. Christian Cloutier  <a href="mailto:christian.cloutier@eds.com">&lt;christian.cloutier@eds.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCLOUTIER">CCLOUTIER</a><br />
1136. Christian Forster  <a href="mailto:boronk@boronk.de">&lt;boronk@boronk.de&gt;</a> -- BORONK<br />
1137. Christian Gernhardt  <a href="mailto:christian.gernhardt@web.de">&lt;christian.gernhardt@web.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGERNHAR">CGERNHAR</a><br />

1138. Christian Gilmore  <a href="mailto:cag@nospam.us.ibm.com">&lt;cag@nospam.us.ibm.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGILMORE">CGILMORE</a><br />
1139. Christian Glahn  <a href="mailto:phish@cpan.org">&lt;phish@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHISH">PHISH</a><br />
1140. <a href="http://www.resolute.com">Christian Goetze</a>  <a href="mailto:perl@resolute.com">&lt;perl@resolute.com&gt;</a> -- CHGOETZE<br />

1141. Christian Guine  <a href="mailto:c.guine@free.fr">&lt;c.guine@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGUINE">CGUINE</a><br />
1142. <a href="http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/">Christian H. Geuer-Pollmann</a>  <a href="mailto:geuer-pollmann@nue.et-inf.uni-siegen.de">&lt;geuer-pollmann@nue.et-inf.uni-siegen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHGEUER">CHGEUER</a><br />
1143. Christian Hansen  <a href="mailto:chansen@cpan.org">&lt;chansen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHANSEN">CHANSEN</a><br />

1144. <a href="www.itassistance.ch">Christian Hauser</a>  <a href="mailto:c.hauser@itassistance.ch">&lt;c.hauser@itassistance.ch&gt;</a> -- CHRISTIAN<br />
1145. <a href="cmlh.id.au">Christian Heinrich</a>  <a href="mailto:pause@cmlh.id.au">&lt;pause@cmlh.id.au&gt;</a> -- CMLH<br />
1146. <a href="http://wwwtech.de/">Christian Kruse</a>  <a href="mailto:ck1@wwwtech.de">&lt;ck1@wwwtech.de&gt;</a> -- CKRUSE<br />

1147. <a href="http://www.lackas.net/">Christian Lackas</a>  <a href="mailto:delta@lackas.net">&lt;delta@lackas.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DELTA">DELTA</a><br />
1148. <a href="http://www.clemburg.com/">Christian Lemburg</a>  <a href="mailto:lemburg@acm.org">&lt;lemburg@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLEMBURG">CLEMBURG</a><br />
1149. <a href="http://www.promessaging.com/">Christian Malter</a>  <a href="mailto:christian.malter@end2endmobile.com">&lt;christian.malter@end2endmobile.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ET/ETWOECMA">ETWOECMA</a><br />

1150. Christian Mueller  <a href="mailto:christian@webgraphik.de">&lt;christian@webgraphik.de&gt;</a> -- XMAN<br />
1151. Christian Mueller  <a href="mailto:post-christian@freenet.de">&lt;post-christian@freenet.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRMUE">CHRMUE</a><br />
1152. <a href="http://pearcec.com">Christian Pearce</a>  <a href="mailto:christian@pearcec.com">&lt;christian@pearcec.com&gt;</a> -- PEARCEC<br />

1153. Christian Reile  <a href="mailto:christian.reile@t-online.de">&lt;christian.reile@t-online.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRULENSOT">DRULENSOT</a><br />
1154. <a href="http://www.web42.com/">Christian Renz</a>  <a href="mailto:crenz@web42.com">&lt;crenz@web42.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRENZ">CRENZ</a><br />
1155. <a href="http://www.loria.fr/~rossi/">Christian Rossi</a>  <a href="mailto:rossi@loria.fr">&lt;rossi@loria.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROSSI">ROSSI</a><br />

1156. Christian Schultze  <a href="mailto:Christian_Schultze@b.maus.de">&lt;Christian_Schultze@b.maus.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRISCHU">CHRISCHU</a><br />
1157. Christian Soeller  <a href="mailto:soellermail@excite.com">&lt;soellermail@excite.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSOE">CSOE</a><br />
1158. <a href="http://www.hauser-wenz.de/">Christian Wenz</a>  <a href="mailto:cpan@hauser-wenz.de">&lt;cpan@hauser-wenz.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WE/WENZ">WENZ</a><br />

1159. Christian Werner  <a href="mailto:telcodev@gmail.com">&lt;telcodev@gmail.com&gt;</a> -- SALTBREEZ<br />
1160. <a href="http://www.chrwinter.de/index.php?Perlmodules">Christian Winter</a>  <a href="mailto:chrwin@cpan.org">&lt;chrwin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRWIN">CHRWIN</a><br />
1161. <a href="http://perl.bsdro.org/">Christian-Rolf Grün</a>  <a href="mailto:kiki (at) abc (dot) ro">&lt;kiki (at) abc (dot) ro&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIXX">KIXX</a><br />

1162. Christoph Appel  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APPEL">APPEL</a><br />
1163. Christoph Bußenius  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEPE">PEPE</a><br />
1164. Christoph Hartmann  <a href="mailto:hardy42@email.com">&lt;hardy42@email.com&gt;</a> -- HARDY<br />
1165. Christoph Holper  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CHCHCH<br />

1166. Christoph Huhn  <a href="mailto:">&lt;&gt;</a> -- CHUHN<br />
1167. Christoph T. Traxler  <a href="mailto:Christoph.T.Traxler@theo.physik.uni-giessen.de">&lt;Christoph.T.Traxler@theo.physik.uni-giessen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHTTRAX">CHTTRAX</a><br />
1168. <a href="http://home.inter.net/terhechte/">Christoph Terhechte</a>  <a href="mailto:terhech@snafu.de">&lt;terhech@snafu.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TERHECHTE">TERHECHTE</a><br />

1169. Christophe Beauregard  <a href="mailto:cpb@cpan.org">&lt;cpb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPB">CPB</a><br />
1170. Christophe Dehaudt  <a href="mailto:christophe@dehaudt.org">&lt;christophe@dehaudt.org&gt;</a> -- CDE<br />
1171. <a href="http://cri.ch">Christophe Gevrey</a>  <a href="mailto:gevrey+cpan@pobox.com">&lt;gevrey+cpan@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRI">CRI</a><br />

1172. Christophe Kalt  <a href="mailto:cpan@ote.taranis.org">&lt;cpan@ote.taranis.org&gt;</a> -- KALT<br />
1173. <a href="http://www.lebars.org/">Christophe Le Bars</a>  <a href="mailto:clb@cpan.org">&lt;clb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLB">CLB</a><br />
1174. Christophe Mertz  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMERTZ">CMERTZ</a><br />

1175. Christophe Wolfhugel  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRWOLF">CHRWOLF</a><br />
1176. <a href="http://www.arnold.se/">Christopher Arnold</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CHRISARN<br />
1177. <a href="http://www.esereno.com/">Christopher B Hamlin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CBHAMLIN<br />

1178. <a href="http://www.theperlprogrammer.com/">Christopher Berning</a>  <a href="mailto:webacres@yahoo.com">&lt;webacres@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBERNING">CBERNING</a><br />
1179. Christopher Boumenot  <a href="mailto:boumenot@gmail.com">&lt;boumenot@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOUMENOT">BOUMENOT</a><br />
1180. <a href="http://www.opendatagroup.com">Christopher Brown</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTBROWN">CTBROWN</a><br />

1181. Christopher Charles Cavnor  <a href="mailto:ccavnor@cpan.org">&lt;ccavnor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CC/CCAVNOR">CCAVNOR</a><br />
1182. Christopher Clark  <a href="mailto:perlmonkey@gmail.com">&lt;perlmonkey@gmail.com&gt;</a> -- CAUSTIN<br />
1183. <a href="http://nekohako.xware.cx/">Christopher Collins</a>  <a href="mailto:xfire@xware.cx">&lt;xfire@xware.cx&gt;</a> -- CCOLLINS<br />

1184. Christopher D. Malon  <a href="mailto:ofun@cpan.org">&lt;ofun@cpan.org&gt;</a> -- OFUN<br />
1185. Christopher Daniel Brown  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CDBROWN<br />
1186. <a href="http://bioperl.org">Christopher Fields</a>  <a href="mailto:cjfields@bioperl.org">&lt;cjfields@bioperl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJFIELDS">CJFIELDS</a><br />

1187. <a href="http://today.icantfocus.com/blog/">Christopher H. Laco</a>  <a href="mailto:claco@cpan.org">&lt;claco@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLACO">CLACO</a><br />
1188. Christopher Heschong  <a href="mailto:chris@wiw.org">&lt;chris@wiw.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HESCHONG">HESCHONG</a><br />
1189. <a href="http://www.fini.net/">Christopher Hicks</a>  <a href="mailto:chicks@chicks.net">&lt;chicks@chicks.net&gt;</a> -- CHICKS<br />

1190. <a href="http://blogs.unixfu.net/">Christopher Humphries</a>  <a href="mailto:chump@cpan.org">&lt;chump@cpan.org&gt;</a> -- CHUMP<br />
1191. <a href="http://www.cjmweb.net/">Christopher J. Madsen</a>  <a href="mailto:perl@cjmweb.net">&lt;perl@cjmweb.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJM">CJM</a><br />
1192. Christopher Jones  <a href="mailto:c.jones@ucl.ac.uk">&lt;c.jones@ucl.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CJ/CJONES">CJONES</a><br />

1193. Christopher Kois  <a href="mailto:cpkois@cpan.org">&lt;cpkois@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPKOIS">CPKOIS</a><br />
1194. <a href="http://treelogic-swe.com">Christopher M. Balz</a>  <a href="mailto:christophermbalz@stanfordalumni.org">&lt;christophermbalz@stanfordalumni.org&gt;</a> -- CBALZ<br />
1195. <a href="http://www.chrismaloney.com">Christopher Maloney</a>  <a href="mailto:dude@chrismaloney.com">&lt;dude@chrismaloney.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KL/KLORTHO">KLORTHO</a><br />

1196. <a href="http://www.chrismasto.com/">Christopher Masto</a>  <a href="mailto:chris@masto.com">&lt;chris@masto.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHRMASTO">CHRMASTO</a><br />
1197. Christopher Maujean  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CMAUJEAN<br />
1198. Christopher Nehren  <a href="mailto:apeiron@cpan.org">&lt;apeiron@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AP/APEIRON">APEIRON</a><br />

1199. Christopher Piggott  <a href="mailto:chrisp@rochester.rr.com">&lt;chrisp@rochester.rr.com&gt;</a> -- CPIGGOTT<br />
1200. <a href="http://www.winnetmag.com/WindowsSecurity/Article/ArticleID/39681/39681.html">Christopher Porter</a>  <a href="mailto:qube@quberoot.com">&lt;qube@quberoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QU/QUBE">QUBE</a><br />
1201. <a href="http://cbaker.org">Christopher R. Baker</a>  <a href="mailto:cbaker@cbaker.org">&lt;cbaker@cbaker.org&gt;</a> -- CBAKER<br />

1202. Christopher White  <a href="mailto:chrwhite2002@hotmail.com">&lt;chrwhite2002@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CW/CWHITE">CWHITE</a><br />
1203. Christopher Willmot  <a href="mailto:chris@willmot.co.uk">&lt;chris@willmot.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPWILLMOT">CPWILLMOT</a><br />
1204. <a href="http://www.artofmobile.com">Christopherus Goo</a>  <a href="mailto:software (at) artofmobile (dot) com">&lt;software (at) artofmobile (dot) com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOBILEART">MOBILEART</a><br />

1205. <a href="http://www.naming-schemes.org/">Chuck Hardin</a>  <a href="mailto:chardin@gmail.com">&lt;chardin@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHARDIN">CHARDIN</a><br />
1206. <a href="http://world.std.com/~choupt">Chuck Houpt</a>  <a href="mailto:choupt@world.std.com">&lt;choupt@world.std.com&gt;</a> -- CHOUPT<br />
1207. Chuck Ritter  <a href="mailto:critter@aixadm.org">&lt;critter@aixadm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRITTER">CRITTER</a><br />

1208. <a href="http://chunzi.org/blog">Chunzi</a>  <a href="mailto:chunzi@perlchina.org">&lt;chunzi@perlchina.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHUNZI">CHUNZI</a><br />
1209. Châteauvieux  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHATEAU">CHATEAU</a><br />
1210. <a href="http://www.surfar.nu/">Claes Jakobsson</a>  <a href="mailto:claes@surfar.nu">&lt;claes@surfar.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLAESJAC">CLAESJAC</a><br />

1211. Clark Cooper  <a href="mailto:clark@coopercc.net">&lt;clark@coopercc.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COOPERCL">COOPERCL</a><br />
1212. Claude Bocage  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BOCAGE<br />
1213. <a href="http://www.vonroesgen.com/">Claude von Roesgen</a>  <a href="mailto:claude_von_roesgen@intuit.com">&lt;claude_von_roesgen@intuit.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CV/CVONROES">CVONROES</a><br />

1214. <a href="http://intercal.freeshell.org/">Claudio Calvelli</a>  <a href="mailto:intercal666@gmail.com">&lt;intercal666@gmail.com&gt;</a> -- INTERCAL<br />
1215. <a href="http://www.claudiogarcia.com">Claudio Garcia</a>  <a href="mailto:claudio.garcia@stanfordalumni.org">&lt;claudio.garcia@stanfordalumni.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGARCIA">CGARCIA</a><br />
1216. <a href="http://www.classy.dk/hacks/">Claus Dahl</a>  <a href="mailto:cpan@classy.dk">&lt;cpan@classy.dk&gt;</a> -- CLAUSD<br />

1217. <a href="http://cfaerber.name">Claus Färber</a>  <a href="mailto:CFAERBER@cpan.org">&lt;CFAERBER@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFAERBER">CFAERBER</a><br />
1218. <a href="http://www.clausklein.de">Claus Klein</a>  <a href="mailto:claus.klein@arcormail.de">&lt;claus.klein@arcormail.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLAUSK">CLAUSK</a><br />
1219. Claus Schotten  <a href="mailto:schotten@gmx.de">&lt;schotten@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLMS">CLMS</a><br />

1220. <a href="http://www.wintermarket.net">Clayton Cottingham</a>  <a href="mailto:clayton@wintermarket.net">&lt;clayton@wintermarket.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRFROG">DRFROG</a><br />
1221. <a href="http://miso.wwa.com/~donley/">Clayton Donley</a>  <a href="mailto:donley@wwa.com">&lt;donley@wwa.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CD/CDONLEY">CDONLEY</a><br />
1222. <a href="http://www.matrix.ca/">Clayton L. Scott</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLSCOTT">CLSCOTT</a><br />

1223. <a href="http://clayton.oneill.net">Clayton O'Neill</a>  <a href="mailto:CMO@cpan.org">&lt;CMO@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMO">CMO</a><br />
1224. Clemens Gesell  <a href="mailto:clemens.gesell@vegatron.org">&lt;clemens.gesell@vegatron.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLEMENSG">CLEMENSG</a><br />
1225. Clemens Giegerich  <a href="mailto:clemens.giegerich@web.de">&lt;clemens.giegerich@web.de&gt;</a> -- GIEGERICH<br />

1226. <a href="http://www.clementebiondo.it/">Clemente Biondo</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBIONDO">CBIONDO</a><br />
1227. Clif Bratcher  <a href="mailto:cebratcher@gmail.com">&lt;cebratcher@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNEVINE">SNEVINE</a><br />
1228. Clif Harden  <a href="mailto:charden@pobox.com">&lt;charden@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHARDEN">CHARDEN</a><br />

1229. <a href="http://www.zynet.com/~caadams/perl/">Clifford A. Adams</a>  <a href="mailto:caadams@zynet.com">&lt;caadams@zynet.com&gt;</a> -- CAADAMS<br />
1230. <a href="http://tanglebones.googlepages.com">Clifford Hammerschmidt</a>  <a href="mailto:tanglebones@gmail.com">&lt;tanglebones@gmail.com&gt;</a> -- CLIFF<br />
1231. Clint Adams  <a href="mailto:schizo@debian.org">&lt;schizo@debian.org&gt;</a> -- CADAMS<br />

1232. Clint Edwards  <a href="mailto:cedwards@cpan.org">&lt;cedwards@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CEDWARDS">CEDWARDS</a><br />
1233. <a href="http://homepage.mac.com/hydo">Clint Moore</a>  <a href="mailto:clint@cpan.org">&lt;clint@cpan.org&gt;</a> -- CLINT<br />
1234. Clint Moore  <a href="mailto:cmoore@cpan.org">&lt;cmoore@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMOORE">CMOORE</a><br />

1235. <a href="http://www.traveljury.com">Clinton Gormley</a>  <a href="mailto:develop@traveljury.com">&lt;develop@traveljury.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRTECH">DRTECH</a><br />
1236. <a href="http://www.geeksalad.org/">Clinton Pierce</a>  <a href="mailto:clintp@geeksalad.org">&lt;clintp@geeksalad.org&gt;</a> -- CLINTP<br />
1237. Clinton Wolfe  <a href="mailto:clintoncwolfe@yahoo.com">&lt;clintoncwolfe@yahoo.com&gt;</a> -- CLWOLFE<br />

1238. <a href="http://web.archive.org/web/20040609115707/http://clint.idiomatic.org/">Clinton Wong</a>  <a href="mailto:clintdw at cpan dot org">&lt;clintdw at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLINTDW">CLINTDW</a><br />
1239. <a href="http://www.qa-iq.com">Clive Darke</a>  <a href="mailto:clive.darke@talk21.com">&lt;clive.darke@talk21.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLIVE">CLIVE</a><br />
1240. <a href="http://cliveholloway.net">Clive Holloway</a>  <a href="mailto:clive.holloway@gmail.com">&lt;clive.holloway@gmail.com&gt;</a> -- CHOLLOWAY<br />

1241. <a href="http://www.clotho.com/">Clotho Advanced Media</a>  <a href="mailto:cpan@clotho.com">&lt;cpan@clotho.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLOTHO">CLOTHO</a><br />
1242. Cláudio Valente  <a href="mailto:plank@cpan.org">&lt;plank@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLANK">PLANK</a><br />
1243. Cnation  <a href="mailto:cnation@cpan.org">&lt;cnation@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CN/CNATION">CNATION</a><br />

1244. Coalescent Technologies Inc.  <a href="mailto:boris@coalescent.net">&lt;boris@coalescent.net&gt;</a> -- CTI<br />
1245. <a href="http://coderepos.org/share">CodeRepos Committers</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CODEREPOS">CODEREPOS</a><br />
1246. <a href="http://divitu.com">Colin C. O. von Heuring</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- URSUS<br />

1247. <a href="http://www.fpsn.net">Colin Faber</a>  <a href="mailto:cfaber@fpsn.net">&lt;cfaber@fpsn.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFABER">CFABER</a><br />
1248. Colin Fine  <a href="mailto:colin.fine@pace.co.uk">&lt;colin.fine@pace.co.uk&gt;</a> -- COLINFINE<br />
1249. Colin Howarth  <a href="mailto:colin@muc.de">&lt;colin@muc.de&gt;</a> -- CHOWARTH<br />

1250. <a href="http://www.uoftfriends.com/~colin/">Colin Kong</a>  <a href="mailto:ckyc@users.sf.net">&lt;ckyc@users.sf.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CK/CKONG">CKONG</a><br />
1251. Colin Kuskie  <a href="mailto:ckuskie@cpan.org">&lt;ckuskie@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COLINK">COLINK</a><br />
1252. <a href="http://www.cs.umn.edu/~mcmillen">Colin McMillen</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COLINM">COLINM</a><br />

1253. Colin Meyer  <a href="mailto:cmeyer@helvella.org">&lt;cmeyer@helvella.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMEYER">CMEYER</a><br />
1254. Colin Muller  <a href="mailto:colin@durbanet.co.za">&lt;colin@durbanet.co.za&gt;</a> -- MULL<br />
1255. Colin O'Leary  <a href="mailto:colino@cpan.org">&lt;colino@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COLINO">COLINO</a><br />

1256. Colin Smith  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CSMITH<br />
1257. <a href="http://www.collinstarkweather.com/">Collin Starkweather</a>  <a href="mailto:collin.starkweather-at-colorado.edu">&lt;collin.starkweather-at-colorado.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STARKY">STARKY</a><br />
1258. <a href="http://oakwinter.com/code/">Collin Winter</a>  <a href="mailto:collin@cpan.org">&lt;collin@cpan.org&gt;</a> -- COLLIN<br />

1259. <a href="www.connected-uk.com">Connected-UK.com LLP</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CONNECTED<br />
1260. <a href="http://cordata.com">CorData</a>  <a href="mailto:eric@cordata.com">&lt;eric@cordata.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORDATA">CORDATA</a><br />
1261. Corbin &quot;Kip&quot; Kohn  <a href="mailto:crkohn@alumni.princeton.edu">&lt;crkohn@alumni.princeton.edu&gt;</a> -- MAGICIAN<br />

1262. <a href="http://www.ravencore.com/">Corey Henderson</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CORMANDER<br />
1263. Corey Wilson  <a href="mailto:cwilson@sbgnet.com">&lt;cwilson@sbgnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COREY">COREY</a><br />
1264. Cormac J. Mannion  <a href="mailto:cormac@posixnap.net">&lt;cormac@posixnap.net&gt;</a> -- CORMAC<br />

1265. Corris Randall  <a href="mailto:corris@cpan.org">&lt;corris@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORRIS">CORRIS</a><br />
1266. <a href="www.corwin.mpls.cx">Corwin Brust</a>  <a href="mailto:corwin@mpls.cx">&lt;corwin@mpls.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORWIN">CORWIN</a><br />
1267. <a href="http://www.onemogin.com">Cory 'G' Watson</a>  <a href="mailto:cpan@onemogin.com">&lt;cpan@onemogin.com&gt;</a> -- CORYG<br />

1268. <a href="http://corybennett.org">Cory Bennett</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CORYB<br />
1269. <a href="http://bbfu.perlmonk.org/">Cory Johns</a>  <a href="mailto:johnsca@cpan.org">&lt;johnsca@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNSCA">JOHNSCA</a><br />
1270. <a href="http://www.omands.com/recon">Cory Omand</a>  <a href="mailto:comand@cpan.org">&lt;comand@cpan.org&gt;</a> -- COMAND<br />

1271. Cory S. Ridgway  <a href="mailto:pragma@frys.com">&lt;pragma@frys.com&gt;</a> -- CSRIDGWAY<br />
1272. Cory Spencer  <a href="mailto:cspencer@sprocket.org">&lt;cspencer@sprocket.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSPENCER">CSPENCER</a><br />
1273. <a href="http://www.onemogin.com/blog/">Cory Watson</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GP/GPHAT">GPHAT</a><br />

1274. Cosimo Streppone  <a href="mailto:cosimo@cpan.org">&lt;cosimo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COSIMO">COSIMO</a><br />
1275. <a href="http://www.craft-works.co.jp/blog/">Craftworks</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CRAFTWORK<br />
1276. Craig A. Berry  <a href="mailto:cberry@cpan.org">&lt;cberry@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBERRY">CBERRY</a><br />

1277. <a href="http://www.theagricolas.org/craig/">Craig B. Agricola</a>  <a href="mailto:craig@theagricolas.org">&lt;craig@theagricolas.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AG/AGRICOCB">AGRICOCB</a><br />
1278. Craig Barratt  <a href="mailto:cbarratt@users.sourceforge.net">&lt;cbarratt@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBARRATT">CBARRATT</a><br />
1279. Craig Bourne  <a href="mailto:cbourne@cpan.org">&lt;cbourne@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBOURNE">CBOURNE</a><br />

1280. Craig Brian  <a href="mailto:support@shoephone.net">&lt;support@shoephone.net&gt;</a> -- SHOEPHONE<br />
1281. Craig Chamberlin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CCHAMBER<br />
1282. <a href="http://www.boulder.swri.edu/~deforest">Craig DeForest</a>  <a href="mailto:drzowie@gmail.com">&lt;drzowie@gmail.com&gt;</a> -- ZOWIE<br />

1283. <a href="http://www.craigdunn.org">Craig Dunn</a>  <a href="mailto:craig@craigdunn.org">&lt;craig@craigdunn.org&gt;</a> -- CDUNN<br />
1284. Craig Freter  <a href="mailto:craig@freter.com">&lt;craig@freter.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CF/CFRETER">CFRETER</a><br />
1285. Craig Grady  <a href="mailto:cgrady357@gmail.com">&lt;cgrady357@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CG/CGRADY">CGRADY</a><br />

1286. Craig Green  <a href="mailto:cagreen74@hotmail.com">&lt;cagreen74@hotmail.com&gt;</a> -- CRAIG<br />
1287. Craig Kadziolka  <a href="mailto:craigk@interia.pl">&lt;craigk@interia.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAIGK">CRAIGK</a><br />
1288. <a href="http://www.malachiarts.com/~craig">Craig L. Monson</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMONSON">CMONSON</a><br />

1289. <a href="http://pages.sbcglobal.net/craig.lawson">Craig Lawson</a>  <a href="mailto:craig.lawson@sbcglobal.net">&lt;craig.lawson@sbcglobal.net&gt;</a> -- CLAW<br />
1290. <a href="www.animalhead.com">Craig MacKenna</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MACKENNA<br />
1291. <a href="http://www.freeasphost.co.uk/">Craig Macdonald</a>  <a href="mailto:cpan@freeasphost.co.uk">&lt;cpan@freeasphost.co.uk&gt;</a> -- MACDEE<br />

1292. Craig Manley  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMANLEY">CMANLEY</a><br />
1293. <a href="http://www.highpoint.co.uk/~crb">Craig R. Belcham</a>  <a href="mailto:crb@highpoint.co.uk">&lt;crb@highpoint.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BELCHAM">BELCHAM</a><br />
1294. <a href="http://www.CraigRichards.com/">Craig Richards</a>  <a href="mailto:cpan@CraigRichards.com">&lt;cpan@CraigRichards.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RICHARDC">RICHARDC</a><br />

1295. Craig Spannring  <a href="mailto:cts@internetcds.com">&lt;cts@internetcds.com&gt;</a> -- SPANNRING<br />
1296. Craig Welch  <a href="mailto:Craig_Welch2@yahoo.com">&lt;Craig_Welch2@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CW/CWELCH">CWELCH</a><br />
1297. <a href="http://c-dot.co.uk">Crawford Currie</a>  <a href="mailto:cpan@c-dot.co.uk">&lt;cpan@c-dot.co.uk&gt;</a> -- CDOT<br />

1298. <a href="http://www.devsecure.com">Cris Bailiff</a>  <a href="mailto:c.bailiff+cpan@devsecure.com">&lt;c.bailiff+cpan@devsecure.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRISB">CRISB</a><br />
1299. <a href="http://www.codigolibre.cl">Cristian Vasquez Diaz</a>  <a href="mailto:cristian@codigolibre.cl">&lt;cristian@codigolibre.cl&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAVASQUEZ">CAVASQUEZ</a><br />
1300. Cristina Martins Nunes  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MEGA<br />

1301. <a href="http://www.imagemagick.org">Cristy</a>  <a href="mailto:cristy@mystic.es.dupont.com">&lt;cristy@mystic.es.dupont.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCRISTY">JCRISTY</a><br />
1302. <a href="http://www.conceptonline.com">Csongor Fagyal</a>  <a href="mailto:concept@conceptonline.hu">&lt;concept@conceptonline.hu&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FAGZAL">FAGZAL</a><br />
1303. Curt Evans  <a href="mailto:curt@net2business.com">&lt;curt@net2business.com&gt;</a> -- CURTEVANS<br />

1304. Curt Tilmes  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTILMES">CTILMES</a><br />
1305. Curt Timmerman  <a href="mailto:curt@curttimmerman.net">&lt;curt@curttimmerman.net&gt;</a> -- CTIMMER<br />
1306. <a href="http://users.easystreet.com/ovid/">Curtis &quot;Ovid&quot; Poe</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OV/OVID">OVID</a><br />

1307. <a href="http://www.mrperson.org/">Curtis Hawthorne</a>  <a href="mailto:mrperson@cpan.org">&lt;mrperson@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRPERSON">MRPERSON</a><br />
1308. Curtis J. Coleman  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CJCOLEMAN<br />
1309. Curtis Jewell  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSJEWELL">CSJEWELL</a><br />

1310. Curtis Leach  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLEACH">CLEACH</a><br />
1311. <a href="http://fultron.net">Curtis Lee Fulton</a>  <a href="mailto:curtisf at fultron dot net">&lt;curtisf at fultron dot net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CU/CURTISF">CURTISF</a><br />
1312. Cutter Brown  <a href="mailto:cutter@zlilo.com">&lt;cutter@zlilo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CU/CUTTER">CUTTER</a><br />

1313. Cyber Matt  <a href="mailto:no spam please">&lt;no spam please&gt;</a> -- CYBERMATT<br />
1314. <a href="www.cybersprocket.com">Cyber Sprocket Labs</a>  <a href="mailto:info@cybersprocket.com">&lt;info@cybersprocket.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSA">CSA</a><br />
1315. Cyprien Le Pannérer  <a href="mailto:cyplp@free.fr">&lt;cyplp@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CY/CYPLP">CYPLP</a><br />

1316. Cédric Bouvier  <a href="mailto:cbouvi@cpan.org">&lt;cbouvi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CB/CBOUVI">CBOUVI</a><br />
1317. Cédric Pellerin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CPELLERIN<br />
1318. D Belden K Lyman IV  <a href="mailto:dbkliv@NOSPAM-gmail.com">&lt;dbkliv@NOSPAM-gmail.com&gt;</a> -- BELDEN<br />
1319. <a href="http://crazyinsomniac.perlmonk.org/">D. H.</a>  <a href="mailto:crazyinsomniac@yahoo.com">&lt;crazyinsomniac@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/PODMASTER">PODMASTER</a><br />

1320. D. Hageman  <a href="mailto:dhageman@dracken.com">&lt;dhageman@dracken.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHAGEMAN">DHAGEMAN</a><br />
1321. <a href="http://tnsgroup.com/">D. Jasmine Merced</a>  <a href="mailto:djasmine@tnsgroup.com">&lt;djasmine@tnsgroup.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJASMINE">DJASMINE</a><br />
1322. D. Scott Barninger  <a href="mailto:daddy_frank@yahoo.com">&lt;daddy_frank@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARNINGER">BARNINGER</a><br />

1323. DAISUKE ABUI  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABUI">ABUI</a><br />
1324. <a href="http://svn.perl.org/modules/DBD-Pg/">DBD::Pg Developers</a>  <a href="mailto:dbd-pg@perl.org">&lt;dbd-pg@perl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBDPG">DBDPG</a><br />
1325. <a href="http://blog.nostalgeek.info">DE DOMMELIN Alexandre</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAOTSEU<br />

1326. <a href="http://www.pipetree.com/jabber/">DJ Adams</a>  <a href="mailto:dj.adams@pobox.com">&lt;dj.adams@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QM/QMACRO">QMACRO</a><br />
1327. <a href="http://gilmore.ael.be/~fdulau/WikiIndex.html">DULAUNOY Fabrice</a>  <a href="mailto:fabrice@dulaunoy.com">&lt;fabrice@dulaunoy.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FD/FDULAU">FDULAU</a><br />
1328. <a href="http://www.infinityperl.org">DUPUIS Arnaud</a>  <a href="mailto:dupuisarn@cpan.org">&lt;dupuisarn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUPUISARN">DUPUISARN</a><br />

1329. Da-Breegster  <a href="mailto:dabreegster@gmail.com">&lt;dabreegster@gmail.com&gt;</a> -- BREEGSTER<br />
1330. Daemmon Hughes  <a href="mailto:cpan@daemmonhughes.com">&lt;cpan@daemmonhughes.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHYTHMAN">RHYTHMAN</a><br />
1331. <a href="http://rorek.org/blog/">Dag Arneson</a>  <a href="mailto:dag at janrain.com">&lt;dag at janrain.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARNESOND">ARNESOND</a><br />

1332. Dagfinn Ilmari Mannsåker  <a href="mailto:ilmari+cpan@ilmari.org">&lt;ilmari+cpan@ilmari.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILMARI">ILMARI</a><br />
1333. Dagobert Michelsen  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAGOBERT">DAGOBERT</a><br />
1334. <a href="http://www.bayashi.net/">Dai Okabayashi</a>  <a href="mailto:bayashi@cpan.org">&lt;bayashi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAYASHI">BAYASHI</a><br />

1335. <a href="http://www.munica.com">Daini Xie</a>  <a href="mailto:dainix@munica.com">&lt;dainix@munica.com&gt;</a> -- DAINIX<br />
1336. <a href="http://www.endeworks.jp">Daisuke Maki</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMAKI">DMAKI</a><br />
1337. <a href="http://www.unknownplace.org/">Daisuke Murase</a>  <a href="mailto:typester@unknownplace.org">&lt;typester@unknownplace.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TY/TYPESTER">TYPESTER</a><br />

1338. Daisuke NISHISAKA  <a href="mailto:ouestcolline@gmail.com">&lt;ouestcolline@gmail.com&gt;</a> -- OUEST<br />
1339. Dale Amon  <a href="mailto:amon@vnl.com">&lt;amon@vnl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DALEAMON">DALEAMON</a><br />
1340. <a href="http://damian.conway.org">Damian Conway</a>  <a href="mailto:damian@conway.org">&lt;damian@conway.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCONWAY">DCONWAY</a><br />

1341. <a href="http://www.iplan.com.ar">Damian Nardelli</a>  <a href="mailto:dnardelli@iplan.com.ar">&lt;dnardelli@iplan.com.ar&gt;</a> -- NOKY<br />
1342. Damien Clark  <a href="mailto:damo.clarky@gmail.com">&lt;damo.clarky@gmail.com&gt;</a> -- CLARKD<br />
1343. Damien Forkner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DFORKNER<br />

1344. <a href="http://damien.krotkine.com">Damien Krotkine</a>  <a href="mailto:dams \at\ gentoo \dot\ org">&lt;dams \at\ gentoo \dot\ org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAMS">DAMS</a><br />
1345. Damien Stuart  <a href="mailto:dstuart@dstuart.org">&lt;dstuart@dstuart.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSTUART">DSTUART</a><br />
1346. Damion K. Wilson  <a href="mailto:dkw@rcm.bm">&lt;dkw@rcm.bm&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKWILSON">DKWILSON</a><br />

1347. <a href="www.mailermailer.com">Damjan Pelemis</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAMJANP">DAMJANP</a><br />
1348. <a href="http://www.allolex.net">Damon Allen Davison</a>  <a href="mailto:allolex@gmx.net">&lt;allolex@gmx.net&gt;</a> -- ALLOLEX<br />
1349. <a href="http://openjapan.cjb.net">Dan Bjorkegren</a>  <a href="mailto:dan_b@mail.com">&lt;dan_b@mail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANB">DANB</a><br />

1350. <a href="http://peeron.com">Dan Boger</a>  <a href="mailto:cpan@peeron.com">&lt;cpan@peeron.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZI/ZIGDON">ZIGDON</a><br />
1351. Dan Bol  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DANBOL<br />
1352. Dan Brook  <a href="mailto:mr.daniel.brook@gmail.com">&lt;mr.daniel.brook@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BROQ">BROQ</a><br />

1353. <a href="http://www.kavod.com">Dan Browning</a>  <a href="mailto:dan.browning@kavod.com">&lt;dan.browning@kavod.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBROWNING">DBROWNING</a><br />
1354. Dan Brumleve  <a href="mailto:dan_brumleve@yahoo.com">&lt;dan_brumleve@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUMLEVE">BRUMLEVE</a><br />
1355. <a href="http://www.danofsteel.com/Parser">Dan Campbell</a>  <a href="mailto:parser@danofsteel.com">&lt;parser@danofsteel.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLCKSMTH">BLCKSMTH</a><br />

1356. <a href="http://en.wikipedia.org/wiki/User_talk:ST47">Dan Collins</a>  <a href="mailto:EN.WP.ST47@gmail.com">&lt;EN.WP.ST47@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCOLLINS">DCOLLINS</a><br />
1357. <a href="http://www.geekuprising.com">Dan Collis Puro</a>  <a href="mailto:cpan@geekuprising.com">&lt;cpan@geekuprising.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJCP">DJCP</a><br />
1358. Dan Connelly  <a href="mailto:djconnel@ieee.org">&lt;djconnel@ieee.org&gt;</a> -- DJCONNEL<br />

1359. <a href="http://www.winternet.com/~dfrankow">Dan Frankowski</a>  <a href="mailto:dfrankow(at)winternet(dot)com">&lt;dfrankow(at)winternet(dot)com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFRANKOW">DFRANKOW</a><br />
1360. Dan Friedman  <a href="mailto:lamech@cpan.org">&lt;lamech@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAMECH">LAMECH</a><br />
1361. <a href="http://www.zblob.com/">Dan Goldwater</a>  <a href="mailto:dgold_at_zblob_dot_com">&lt;dgold_at_zblob_dot_com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DG/DGOLD">DGOLD</a><br />

1362. Dan Harasty  <a href="mailto:harasty@cpan.org">&lt;harasty@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HARASTY">HARASTY</a><br />
1363. <a href="http://www.trustcommerce.com/">Dan Helfman</a>  <a href="mailto:dan@trustcommerce.com">&lt;dan@trustcommerce.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WITTEN">WITTEN</a><br />
1364. Dan Horne  <a href="mailto:dhorne@cpan.org">&lt;dhorne@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHORNE">DHORNE</a><br />

1365. Dan Kirkwood  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DANK<br />
1366. <a href="http://www.dan.co.jp/">Dan Kogai</a>  <a href="mailto:dankogai@dan.co.jp">&lt;dankogai@dan.co.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANKOGAI">DANKOGAI</a><br />
1367. <a href="http://www.onautopilot.com/">Dan Kubb</a>  <a href="mailto:dan.kubb-cpan@onautopilot.com">&lt;dan.kubb-cpan@onautopilot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKUBB">DKUBB</a><br />

1368. Dan Lincoln  <a href="mailto:dan@galaxymall.com">&lt;dan@galaxymall.com&gt;</a> -- DLINCOLN<br />
1369. <a href="www.codeop.com">Dan McCormick</a>  <a href="mailto:dan@codeop.com">&lt;dan@codeop.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMCC">DMCC</a><br />
1370. <a href="http://moore.cx/dan/">Dan Moore</a>  <a href="mailto:dan@moore.cx">&lt;dan@moore.cx&gt;</a> -- DANMOORE<br />

1371. Dan Otterburn  <a href="mailto:dan.otterburn@gmail.com">&lt;dan.otterburn@gmail.com&gt;</a> -- OTTERBURN<br />
1372. <a href="http://www.danpemstein.com">Dan Pemstein</a>  <a href="mailto:dan@lcws.org">&lt;dan@lcws.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBP">DBP</a><br />
1373. <a href="http://www.gingerall.com/">Dan Pokorny</a>  <a href="mailto:dan@gingerall.cz">&lt;dan@gingerall.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPOKORNY">DPOKORNY</a><br />

1374. Dan Rowles  <a href="mailto:no_such_user@no_such_domain.com">&lt;no_such_user@no_such_domain.com&gt;</a> -- ROWLESD<br />
1375. <a href="http://www2.thecia.net/users/dfan/">Dan Schmidt</a>  <a href="mailto:dfan@alum.mit.edu">&lt;dfan@alum.mit.edu&gt;</a> -- DFAN<br />
1376. <a href="http://www.stahlke.org/dan">Dan Stahlke</a>  <a href="mailto:dan@gina.alaska.edu">&lt;dan@gina.alaska.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSTAHLKE">DSTAHLKE</a><br />

1377. Dan Steele  <a href="mailto:dsteele@perforce.com">&lt;dsteele@perforce.com&gt;</a> -- DSTEELE<br />
1378. <a href="http://www.sidhe.org/~dan/blog/">Dan Sugalski</a>  <a href="mailto:dan@sidhe.org">&lt;dan@sidhe.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSUGAL">DSUGAL</a><br />
1379. <a href="http://electricrain.com/daniel/">Dan Sully</a>  <a href="mailto:daniel@cpan.org">&lt;daniel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANIEL">DANIEL</a><br />

1380. Dan Thomas  <a href="mailto:dan@cpan.org">&lt;dan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAN">DAN</a><br />
1381. <a href="www.jumbuk.com">Dan Tyrrell</a>  <a href="mailto:dan@jumbuk.com">&lt;dan@jumbuk.com&gt;</a> -- DANT<br />
1382. Dan Urist  <a href="mailto:durist@frii.com">&lt;durist@frii.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DURIST">DURIST</a><br />

1383. Dan Winchester  <a href="mailto:dan@freelancers.net">&lt;dan@freelancers.net&gt;</a> -- DANW<br />
1384. <a href="http://www.ridmail.com">Dana French</a>  <a href="mailto:dfrench@mtxia.com">&lt;dfrench@mtxia.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFRENCH">DFRENCH</a><br />
1385. <a href="http://www.hudes.org">Dana Hudes</a>  <a href="mailto:dhudes@hudes.org">&lt;dhudes@hudes.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHUDES">DHUDES</a><br />

1386. <a href="http://dana.realms.org/">Dana M. Diederich</a>  <a href="mailto:diederich@gmail.com">&lt;diederich@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIEDERICH">DIEDERICH</a><br />
1387. Danal Estes  <a href="mailto:danal@earthling.net">&lt;danal@earthling.net&gt;</a> -- DANAL<br />
1388. <a href="http://tigris.id.au/">Danial Pearce</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIGRIS">TIGRIS</a><br />

1389. <a href="http://www.coder.com/">Daniel Allen</a>  <a href="mailto:da@coder.com">&lt;da@coder.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DALLEN">DALLEN</a><br />
1390. Daniel Ambar  <a href="mailto:dambar@alumni.brandeis.edu">&lt;dambar@alumni.brandeis.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAMBAR">DAMBAR</a><br />
1391. Daniel B. Boorstein  <a href="mailto:danboo@cpan.org">&lt;danboo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANBOO">DANBOO</a><br />

1392. Daniel Berger  <a href="mailto:djberg96@yahoo.com">&lt;djberg96@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJBERG">DJBERG</a><br />
1393. <a href="http://home.debitel.net/user/boesswetter/">Daniel Boesswetter</a>  <a href="mailto:boesswetter@peppermind.de">&lt;boesswetter@peppermind.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOEWE">BOEWE</a><br />
1394. Daniel Born  <a href="mailto:danborn@cpan.org">&lt;danborn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANBORN">DANBORN</a><br />

1395. Daniel Bretoi  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEBONAIR">DEBONAIR</a><br />
1396. <a href="http://db48x.net/">Daniel Brooks</a>  <a href="mailto:db48x@yahoo.com">&lt;db48x@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBROOKS">DBROOKS</a><br />
1397. Daniel Brunkhorst  <a href="mailto:daniel.brunkhorst@web.de">&lt;daniel.brunkhorst@web.de&gt;</a> -- BRUNKHI<br />

1398. <a href="www.youmouteki.com">Daniel Burke</a>  <a href="mailto:theburkeyuk@yahoo.co.uk">&lt;theburkeyuk@yahoo.co.uk&gt;</a> -- BURKEY<br />
1399. <a href="http://cpan.danonline.net">Daniel C. Axelrod</a>  <a href="mailto:cpan@danonline.net">&lt;cpan@danonline.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAXELROD">DAXELROD</a><br />
1400. Daniel Etzold  <a href="mailto:detzold@gmx.de">&lt;detzold@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DETZOLD">DETZOLD</a><br />

1401. Daniel Froz Costa  <a href="mailto:dfroz@users.sourceforge.net">&lt;dfroz@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFROZ">DFROZ</a><br />
1402. <a href="http://www.danielgardner.org/">Daniel Gardner</a>  <a href="mailto:da_S_niel@da_P_nie_A_lgard_M_ner.org">&lt;da_S_niel@da_P_nie_A_lgard_M_ner.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARDNER">GARDNER</a><br />
1403. Daniel Gilder  <a href="mailto:deg@cpan.org">&lt;deg@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEG">DEG</a><br />

1404. Daniel Grisinger  <a href="mailto:dgris@perrin.dimensional.com">&lt;dgris@perrin.dimensional.com&gt;</a> -- DGRIS<br />
1405. <a href="http://www.rastplats.se/">Daniel Gustafson</a>  <a href="mailto:daniel@hobbit.se">&lt;daniel@hobbit.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEGE">DEGE</a><br />
1406. <a href="http://www.uwm.edu/~dthable/">Daniel Hable</a>  <a href="mailto:dhable@uwm.edu">&lt;dhable@uwm.edu&gt;</a> -- DHABLE<br />

1407. <a href="http://www.kickidle.com/">Daniel Hagan</a>  <a href="mailto:daniel@kickidle.com">&lt;daniel@kickidle.com&gt;</a> -- DHAGAN<br />
1408. <a href="http://www.linnaean.org/~hag/">Daniel Hagerty</a>  <a href="mailto:hag@linnaean.org">&lt;hag@linnaean.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAG">HAG</a><br />
1409. Daniel Hüsch  <a href="mailto:daniel.huesch@gmail.com">&lt;daniel.huesch@gmail.com&gt;</a> -- IKANUSIM<br />

1410. Daniel J. Reidy  <a href="mailto:djr_pres@yahoo.com">&lt;djr_pres@yahoo.com&gt;</a> -- DREIDY<br />
1411. <a href="http://www.dwright.org">Daniel J. Wright</a>  <a href="mailto:Dan@DWright.Org">&lt;Dan@DWright.Org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWRIGHT">DWRIGHT</a><br />
1412. <a href="www.wigwamhq.org">Daniel Johnston</a>  <a href="mailto:cpn@wmelab.com">&lt;cpn@wmelab.com&gt;</a> -- DJOHNSTON<br />

1413. <a href="http://entropy.homelinux.org">Daniel Kasak</a>  <a href="mailto:dan@entropy.homelinux.org">&lt;dan@entropy.homelinux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKASAK">DKASAK</a><br />
1414. <a href="http://www.bizjournals.com/">Daniel Koch</a>  <a href="mailto:dkoch@cpan.org">&lt;dkoch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKOCH">DKOCH</a><br />
1415. Daniel Koffler  <a href="mailto:dkoffler@users.sourceforge.net">&lt;dkoffler@users.sourceforge.net&gt;</a> -- DKOFFLER<br />

1416. <a href="http://www.mobile-net.ch">Daniel Kuebler</a>  <a href="mailto:dkuebler@mobile-net.ch">&lt;dkuebler@mobile-net.ch&gt;</a> -- DKUEBLER<br />
1417. <a href="http://www.lafraia.com/">Daniel Lafraia</a>  <a href="mailto:lafraia@cpan.org">&lt;lafraia@cpan.org&gt;</a> -- LAFRAIA<br />
1418. <a href="http://possumism.net/">Daniel LeWarne</a>  <a href="mailto:possum at cpan dot org">&lt;possum at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POSSUM">POSSUM</a><br />

1419. <a href="http://myxo.css.msu.edu/danimal">Daniel Lenski</a>  <a href="mailto:moxfyre@geocities.com">&lt;moxfyre@geocities.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOXFYRE">MOXFYRE</a><br />
1420. <a href="http://www.danlo.com">Daniel Lo</a>  <a href="mailto:wilburlo@gmail.com">&lt;wilburlo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLO">DLO</a><br />
1421. <a href="http://sequential.org">Daniel M. Lipton</a>  <a href="mailto:pause@sequential.org">&lt;pause@sequential.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHOTO">PHOTO</a><br />

1422. Daniel M. Quinlan  <a href="mailto:danq@colorado.edu">&lt;danq@colorado.edu&gt;</a> -- DANMQ<br />
1423. <a href="http://www.netspace.org/~dmacks">Daniel Macks</a>  <a href="mailto:dmacks@netspace.org">&lt;dmacks@netspace.org&gt;</a> -- DMACKS<br />
1424. <a href="http://www.catfolks.net/dan">Daniel Mahoney</a>  <a href="mailto:dan@catfolks.net">&lt;dan@catfolks.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMAHONEY">DMAHONEY</a><br />

1425. <a href="http://www.simplemood.com">Daniel Muey</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMUEY">DMUEY</a><br />
1426. <a href="http://hackmysql.com/">Daniel Nichter</a>  <a href="mailto:perl@hackmysql.com">&lt;perl@hackmysql.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DN/DNICHTER">DNICHTER</a><br />
1427. <a href="http://www.berrange.com/">Daniel P. Berrangé</a>  <a href="mailto:dan@berrange.com">&lt;dan@berrange.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANBERR">DANBERR</a><br />

1428. <a href="http://lahontan.dynamical.org">Daniel P. Hembree</a>  <a href="mailto:danny-hembree@dynamical.org">&lt;danny-hembree@dynamical.org&gt;</a> -- HEMBREED<br />
1429. <a href="http://www.infoset.com/">Daniel Peder</a>  <a href="mailto:Daniel.Peder@INFOSET.cz">&lt;Daniel.Peder@INFOSET.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANPEDER">DANPEDER</a><br />
1430. Daniel Petit  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMPETIT">DMPETIT</a><br />

1431. <a href="http://makepp.sourceforge.net/">Daniel Pfeiffer</a>  <a href="mailto:occitan@esperanto.org">&lt;occitan@esperanto.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PF/PFEIFFER">PFEIFFER</a><br />
1432. Daniel Podolsky  <a href="mailto:tpaba@cpan.org">&lt;tpaba@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TP/TPABA">TPABA</a><br />
1433. <a href="http://www.ngenllc.com">Daniel R. Anderson</a>  <a href="mailto:dan@mathjunkies.com">&lt;dan@mathjunkies.com&gt;</a> -- VAUTRIN<br />

1434. <a href="http://support.linuxops.net">Daniel Remsburg</a>  <a href="mailto:nexen@cpan.org">&lt;nexen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEXEN">NEXEN</a><br />
1435. <a href="http://dren.ch/">Daniel Rench</a>  <a href="mailto:citric@cubicone.tmetic.com">&lt;citric@cubicone.tmetic.com&gt;</a> -- DRENCH<br />
1436. Daniel Ruoso  <a href="mailto:daniel@ruoso.com">&lt;daniel@ruoso.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRUOSO">DRUOSO</a><br />

1437. <a href="http://www.prairienet.org/~dslewart/">Daniel S. Lewart</a>  <a href="mailto:d-lewart@uiuc.edu">&lt;d-lewart@uiuc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSLEWART">DSLEWART</a><br />
1438. Daniel Schmeck  <a href="mailto:no_spam@schmeckzilla.de">&lt;no_spam@schmeckzilla.de&gt;</a> -- DANSCH<br />
1439. Daniel Schröer  <a href="mailto:schroeer@cpan.org">&lt;schroeer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHROEER">SCHROEER</a><br />

1440. Daniel Scott Sterling  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DSTERLING<br />
1441. Daniel Shane  <a href="mailto:daniel.shane@eicon.com">&lt;daniel.shane@eicon.com&gt;</a> -- DSHANE<br />
1442. Daniel Shane  <a href="mailto:lachinois@hotmail.com">&lt;lachinois@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRUNCHIE">CRUNCHIE</a><br />
1443. <a href="http://salmonriver.com/">Daniel Sherer</a>  <a href="mailto:perl@salmonriver.com">&lt;perl@salmonriver.com&gt;</a> -- DSHERER<br />

1444. <a href="http://www.anti-php.net/">Daniel Sirait</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DN/DNS">DNS</a><br />
1445. <a href="http://multinet24.de/">Daniel Speicher</a>  <a href="mailto:ds@multinet24.de">&lt;ds@multinet24.de&gt;</a> -- DSPEICHER<br />
1446. Daniel T. Staal  <a href="mailto:DStaal@usa.net">&lt;DStaal@usa.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSTAAL">DSTAAL</a><br />

1447. Daniel V. Klein  <a href="mailto:dan@klein.com">&lt;dan@klein.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DV/DVKLEIN">DVKLEIN</a><br />
1448. Daniel Westermann-Clark  <a href="mailto:danieltwc@cpan.org">&lt;danieltwc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANIELTWC">DANIELTWC</a><br />
1449. <a href="www.daniel-zinn.de">Daniel Zinn</a>  <a href="mailto:perl-public@qmic.de">&lt;perl-public@qmic.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QM/QMIC">QMIC</a><br />

1450. Daniel Zulla  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SCIO<br />
1451. Daniel de Oliveira Mantovani  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MANTOVANI<br />
1452. Daniele Ricci  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ICC<br />
1453. <a href="http://www.danijel.de">Danijel Milicevic</a>  <a href="mailto:info@danijel.de">&lt;info@danijel.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GABB">GABB</a><br />

1454. <a href="http://dapi.chaz.ru/">Danil Pismenny</a>  <a href="mailto:dapi@mail.ru">&lt;dapi@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAPI">DAPI</a><br />
1455. <a href="http://doulopolis.net">Dann Stayskal</a>  <a href="mailto:dann@cpan.org">&lt;dann@cpan.org&gt;</a> -- DANN<br />
1456. <a href="http://www.brians.org">Danny Brian</a>  <a href="mailto:dbrian@cpan.org">&lt;dbrian@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBRIAN">DBRIAN</a><br />

1457. Danny Lim  <a href="mailto:dcylim@hotmail.com">&lt;dcylim@hotmail.com&gt;</a> -- DLIM<br />
1458. <a href="http://www.sadinoff.com/">Danny Sadinoff</a>  <a href="mailto:danny-cpan@sadinoff.com">&lt;danny-cpan@sadinoff.com&gt;</a> -- DSADINOFF<br />
1459. Danny Van de Pol  <a href="mailto:daniel.van_de_pol@alcatel.be">&lt;daniel.van_de_pol@alcatel.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DV/DVDPOL">DVDPOL</a><br />

1460. <a href="http://www.dannywarren.com">Danny Warren</a>  <a href="mailto:perl@dannywarren.com">&lt;perl@dannywarren.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWARREN">DWARREN</a><br />
1461. <a href="http://senseis.xmp.net/?mAsterdam">Danny Werner</a>  <a href="mailto:mAsterdam@yahoo.com">&lt;mAsterdam@yahoo.com&gt;</a> -- MASTERDAM<br />
1462. <a href="http://www.i7.com.pl/soft/">Darek Adamkiewicz</a>  <a href="mailto:d.adamkiewicz@i7.com.pl">&lt;d.adamkiewicz@i7.com.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DADAMK">DADAMK</a><br />

1463. <a href="http://darianpatrick.com">Darian Anthony Patrick</a>  <a href="mailto:dapatrick@cpan.org">&lt;dapatrick@cpan.org&gt;</a> -- DAPATRICK<br />
1464. Darin McBride  <a href="mailto:dmcbride@cpan.org">&lt;dmcbride@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMCBRIDE">DMCBRIDE</a><br />
1465. <a href="http://www.ocf.berkeley.edu/~darin/">Darin McGill</a>  <a href="mailto:darin at ocf point berkeley point edu">&lt;darin at ocf point berkeley point edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DARIN">DARIN</a><br />

1466. <a href="http://eyck.forumakad.pl/">Dariush Pietrzak</a>  <a href="mailto:cpan@kuszelas.com">&lt;cpan@kuszelas.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EY/EYCK">EYCK</a><br />
1467. Dariusz Jackowski  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ASCENT<br />
1468. <a href="http://kaiserslautern.pm.org">Darko Obradovic</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OB/OBRADOVIC">OBRADOVIC</a><br />

1469. Darold Gilles  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAROLD">DAROLD</a><br />
1470. Darren Chamberlain  <a href="mailto:darren@cpan.org">&lt;darren@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DARREN">DARREN</a><br />
1471. <a href="http://www.DarrenDuncan.net/">Darren Duncan</a>  <a href="mailto:perl@DarrenDuncan.net">&lt;perl@DarrenDuncan.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUNCAND">DUNCAND</a><br />

1472. <a href="http://iterx.org/">Darren Graves</a>  <a href="mailto:darren@iterx.org">&lt;darren@iterx.org&gt;</a> -- DGRAVES<br />
1473. <a href="http://kulp.ch/">Darren Kulp</a>  <a href="mailto:kulp@cpan.org">&lt;kulp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KULP">KULP</a><br />
1474. <a href="http://www.daft.com/~torin/">Darren Stalder</a>  <a href="mailto:torin@daft.com">&lt;torin@daft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSTALDER">DSTALDER</a><br />

1475. Darryl Okahata  <a href="mailto:darrylo@sr.hp.com">&lt;darrylo@sr.hp.com&gt;</a> -- DMO<br />
1476. Daryl C. W. O'Shea  <a href="mailto:dos+cpan@dostech.ca">&lt;dos+cpan@dostech.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOS">DOS</a><br />
1477. DataBuilt, Inc.  <a href="mailto:cpan@databuilt.com">&lt;cpan@databuilt.com&gt;</a> -- DATABUILT<br />
1478. <a href="http://benefitslink.com/about.html">Dave Baker</a>  <a href="mailto:davebaker@benefitslink.com">&lt;davebaker@benefitslink.com&gt;</a> -- DBAKER<br />

1479. Dave Balmer Jr.  <a href="mailto:dbalmer@cpan.org">&lt;dbalmer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBALMER">DBALMER</a><br />
1480. Dave Beazley  <a href="mailto:dmb@asator.lanl.gov">&lt;dmb@asator.lanl.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBEAZLEY">DBEAZLEY</a><br />
1481. <a href="http://purl.org/net/dajobe/">Dave Beckett</a>  <a href="mailto:dave@dajobe.org">&lt;dave@dajobe.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJBECKETT">DJBECKETT</a><br />

1482. Dave Bialac  <a href="mailto:dbialac@yahoo.com">&lt;dbialac@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBIALAC">DBIALAC</a><br />
1483. <a href="http://brondsema.net/">Dave Brondsema</a>  <a href="mailto:dave@brondsema.net">&lt;dave@brondsema.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRONDSEM">BRONDSEM</a><br />
1484. <a href="http://davecardwell.co.uk/perl/">Dave Cardwell</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCARDWELL">DCARDWELL</a><br />

1485. <a href="http://www.rudedog.org/">Dave Carrigan</a>  <a href="mailto:dave@rudedog.org">&lt;dave@rudedog.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCARRIGAN">DCARRIGAN</a><br />
1486. <a href="http://www.pingtrip.com/">Dave Crawford</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCRAWFORD">DCRAWFORD</a><br />
1487. <a href="http://dave.org.uk/">Dave Cross</a>  <a href="mailto:dave@dave.org.uk">&lt;dave@dave.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVECROSS">DAVECROSS</a><br />

1488. <a href="http://blog.binmode.com">Dave Doyle</a>  <a href="mailto:dave.s.doyle@gmail.com">&lt;dave.s.doyle@gmail.com&gt;</a> -- DDOYLE<br />
1489. <a href="http://www.dribin.org/dave/">Dave Dribin</a>  <a href="mailto:ddribin@cpan.org">&lt;ddribin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DD/DDRIBIN">DDRIBIN</a><br />
1490. <a href="http://www.real-me.net/ddyer">Dave Dyer</a>  <a href="mailto:ddyer@real-me.net">&lt;ddyer@real-me.net&gt;</a> -- DDYER<br />

1491. Dave Faraldo  <a href="mailto:dfaraldo@cpan.org">&lt;dfaraldo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFARALDO">DFARALDO</a><br />
1492. Dave Hickling  <a href="mailto:dr_dave_cheese@yahoo.co.uk">&lt;dr_dave_cheese@yahoo.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHICKLING">DHICKLING</a><br />
1493. Dave Hinkle  <a href="mailto:dave@thehinkles.com">&lt;dave@thehinkles.com&gt;</a> -- DHINKLE<br />

1494. <a href="http://www.davehodgkinson.com/">Dave Hodgkinson</a>  <a href="mailto:daveh@hodgkinson.org">&lt;daveh@hodgkinson.org&gt;</a> -- DAVEHODG<br />
1495. <a href="http://www.biff.org.uk/dave/">Dave Holland</a>  <a href="mailto:dave@biff.org.uk">&lt;dave@biff.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVE">DAVE</a><br />
1496. Dave Hollenbeck  <a href="mailto:daveholl@frii.com">&lt;daveholl@frii.com&gt;</a> -- DAVEHOLL<br />

1497. <a href="http://www.homsher.com">Dave Homsher, II</a>  <a href="mailto:perl@homsher.com">&lt;perl@homsher.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOMSHERD">HOMSHERD</a><br />
1498. <a href="http://www.redsquirrel.com/dave/">Dave Hoover</a>  <a href="mailto:squirrel@cpan.org">&lt;squirrel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SQ/SQUIRREL">SQUIRREL</a><br />
1499. Dave Howorth  <a href="mailto:djh@cpan.org">&lt;djh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJH">DJH</a><br />

1500. Dave Mabe  <a href="mailto:dmabe@runningland.com">&lt;dmabe@runningland.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMABE">DMABE</a><br />
1501. <a href="http://www.davemessina.com">Dave Messina</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMESSINA">DMESSINA</a><br />
1502. Dave Moore  <a href="mailto:dave@epals.com">&lt;dave@epals.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVEM">DAVEM</a><br />

1503. Dave Nadler  <a href="mailto:nadler@ug.eds.com">&lt;nadler@ug.eds.com&gt;</a> -- DNAD<br />
1504. Dave Olszewski  <a href="mailto:dave dot o at pobox point com">&lt;dave dot o at pobox point com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CX/CXREG">CXREG</a><br />
1505. Dave Paris  <a href="mailto:a-mused@pobox.com">&lt;a-mused@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPARIS">DPARIS</a><br />

1506. <a href="http://net.doit.wisc.edu/~plonka/">Dave Plonka</a>  <a href="mailto:plonka@doit.wisc.edu">&lt;plonka@doit.wisc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLONKA">PLONKA</a><br />
1507. Dave Pointon  <a href="mailto:david.pointon@tesco.net">&lt;david.pointon@tesco.net&gt;</a> -- DPOINTON<br />
1508. Dave Roberts  <a href="mailto:dave@herouville.biz">&lt;dave@herouville.biz&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DROBERTS">DROBERTS</a><br />

1509. <a href="http://www.urth.org/">Dave Rolsky</a>  <a href="mailto:autarch@urth.org">&lt;autarch@urth.org&gt;</a> -- PGRIMES<br />
1510. <a href="http://www.urth.org/">Dave Rolsky</a>  <a href="mailto:autarch@urth.org">&lt;autarch@urth.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DROLSKY">DROLSKY</a><br />
1511. <a href="http://www.roth.net/">Dave Roth</a>  <a href="mailto:rothd@roth.net">&lt;rothd@roth.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVEROTH">DAVEROTH</a><br />

1512. Dave Schaefer  <a href="mailto:dschaefer@cpan.org">&lt;dschaefer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSCHAEFER">DSCHAEFER</a><br />
1513. Dave Sherohman  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSHEROH">DSHEROH</a><br />
1514. Dave Steiner  <a href="mailto:steiner@bakerst.rutgers.edu">&lt;steiner@bakerst.rutgers.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKS">DKS</a><br />

1515. Dave Trischuk  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DT/DTRISCHUK">DTRISCHUK</a><br />
1516. Dave Webb  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAVEWEBB<br />
1517. <a href="gorillamatrix.com">Dave Williams</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAVEGMX<br />

1518. <a href="http://david.rigaudiere.free.fr">David &quot;Sniper&quot; Rigaudiere</a>  <a href="mailto:SNIPER@cpan.org">&lt;SNIPER@cpan.org&gt;</a> -- SNIPER<br />
1519. David A. Christensen  <a href="mailto:David.A.Christensen [at] gmail [dot] com">&lt;David.A.Christensen [at] gmail [dot] com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCHRIS">DCHRIS</a><br />
1520. David A. Desrosiers  <a href="mailto:desrod@pilot-link.org">&lt;desrod@pilot-link.org&gt;</a> -- DESROD<br />

1521. <a href="http://mutationfinder.sourceforge.net">David A. Randolph</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RNDLPH<br />
1522. David Aguilar  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVVID">DAVVID</a><br />
1523. David Alan Pisoni  <a href="mailto:dpisoni@cpan.org">&lt;dpisoni@cpan.org&gt;</a> -- DPISONI<br />

1524. David Atchley  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DATCHLEY<br />
1525. <a href="https://sourceforge.net/projects/oedtk/">David Aunay</a>  <a href="mailto:edtk@free.fr">&lt;edtk@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAUNAY">DAUNAY</a><br />
1526. <a href="http://davidlbaird.blogspot.com/">David Baird</a>  <a href="mailto:davidlbaird@gmail.com">&lt;davidlbaird@gmail.com&gt;</a> -- DBAIRD<br />

1527. David Barth  <a href="mailto:dbarth@idealx.com">&lt;dbarth@idealx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBARTH">DBARTH</a><br />
1528. <a href="http://perlster.com">David Bartle</a>  <a href="mailto:captindave@gmail.com">&lt;captindave@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBARTLE">DBARTLE</a><br />
1529. <a href="http://www.sitesuite.com.au">David Baxter</a>  <a href="mailto:david@sitesuite.com.au">&lt;david@sitesuite.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDB">DAVIDB</a><br />

1530. <a href="http://www.bensoft.com/">David Bennett</a>  <a href="mailto:dbennett@cpan.org">&lt;dbennett@cpan.org&gt;</a> -- DBENNETT<br />
1531. <a href="http://www.mobygames.com/">David Berk</a>  <a href="mailto:dberk@mobygames.com">&lt;dberk@mobygames.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLIPKIN">FLIPKIN</a><br />
1532. David Blacka  <a href="mailto:david@blacka.com">&lt;david@blacka.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBLACKA">DBLACKA</a><br />

1533. <a href="http://www.acornsoft.info">David Blaszyk</a>  <a href="mailto:dblaszyk@mail-server.acornsoft.info">&lt;dblaszyk@mail-server.acornsoft.info&gt;</a> -- DBLASZYK<br />
1534. <a href="http://cs-people.bu.edu/dbonner/">David Bonner</a>  <a href="mailto:dbonner@cs.bu.edu">&lt;dbonner@cs.bu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBONNER">DBONNER</a><br />
1535. <a href="http://www.cleartool.com">David Boyce</a>  <a href="mailto:dsb@cpan.org">&lt;dsb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSB">DSB</a><br />

1536. <a href="http://www.mono.org/abs/tools/">David Brownlee</a>  <a href="mailto:abs@mono.org">&lt;abs@mono.org&gt;</a> -- ABS<br />
1537. <a href="http://riboclub.org/cgi-bin/mona/index.pl">David Brunelle</a>  <a href="mailto:david.brunelle@usherbrooke.ca">&lt;david.brunelle@usherbrooke.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVANZS">EVANZS</a><br />
1538. David Brunton  <a href="mailto:dbrunton@yahoo.com">&lt;dbrunton@yahoo.com&gt;</a> -- DBRUNTON<br />

1539. David Buchman  <a href="mailto:dbuchman@cpan.org">&lt;dbuchman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBUCHMAN">DBUCHMAN</a><br />
1540. David Burdick  <a href="mailto:dburdickNOSPAM@systemsbiology.org">&lt;dburdickNOSPAM@systemsbiology.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBURDICK">DBURDICK</a><br />
1541. David Bussenschutt  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUZZ">BUZZ</a><br />

1542. <a href="http://dsnyder.ws-e.com/">David C. Snyder</a>  <a href="mailto:dsnyder@ws-e.com">&lt;dsnyder@ws-e.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCS">DCS</a><br />
1543. David C. Worenklein  <a href="mailto:dcw@gcm.com">&lt;dcw@gcm.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WORENKD">WORENKD</a><br />
1544. <a href="http://porkrind.org">David Caldwell</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVID">DAVID</a><br />

1545. <a href="http://www.cantrell.org.uk/david">David Cantrell</a>  <a href="mailto:pause@barnyard.co.uk">&lt;pause@barnyard.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCANTRELL">DCANTRELL</a><br />
1546. David Carswell  <a href="mailto:cpan@carswell.info">&lt;cpan@carswell.info&gt;</a> -- CARSWELL<br />
1547. David Castro  <a href="mailto:apudcastro@entwash.org">&lt;apudcastro@entwash.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCASTRO">DCASTRO</a><br />

1548. <a href="http://www.sheetmusic.org.uk/">David Chan</a>  <a href="mailto:print join &quot;.&quot;, qw{david@sheetmusic org uk}">&lt;print join &quot;.&quot;, qw{david@sheetmusic org uk}&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIVEC">DIVEC</a><br />
1549. David Chester  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAVIDC<br />
1550. David Cho-Lerat  <a href="mailto:dcl@cpan.org">&lt;dcl@cpan.org&gt;</a> -- DCL<br />

1551. David Christensen  <a href="mailto:dwc@dwci.net">&lt;dwc@dwci.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWC">DWC</a><br />
1552. <a href="http://www.coppit.org/">David Coppit</a>  <a href="mailto:david@coppit.org">&lt;david@coppit.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCOPPIT">DCOPPIT</a><br />
1553. David Cramer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAVIDOV<br />

1554. <a href="http://xant.us/">David Davis</a>  <a href="mailto:xantus@cpan.org">&lt;xantus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XA/XANTUS">XANTUS</a><br />
1555. <a href="http://delikat.homeip.net/">David Delikat</a>  <a href="mailto:del1234-pause@usa.net">&lt;del1234-pause@usa.net&gt;</a> -- DAV<br />
1556. David Dick  <a href="mailto:ddick (at) cpan dot org">&lt;ddick (at) cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DD/DDICK">DDICK</a><br />

1557. <a href="http://dorward.me.uk">David Dorward</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DORWARD<br />
1558. <a href="http://david.weekly.org/">David E. Weekly</a>  <a href="mailto:david@weekly.org">&lt;david@weekly.org&gt;</a> -- DEW<br />
1559. David Emery  <a href="mailto:demery@skiddlydee.com">&lt;demery@skiddlydee.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEMERY">DEMERY</a><br />

1560. <a href="http://www.roaringpenguin.com">David F. Skoll</a>  <a href="mailto:dfs+pause@roaringpenguin.com">&lt;dfs+pause@roaringpenguin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSKOLL">DSKOLL</a><br />
1561. <a href="http://www.ferrance.com/">David Ferrance</a>  <a href="mailto:dave@ferrance.com">&lt;dave@ferrance.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FERRANCE">FERRANCE</a><br />
1562. <a href="http://fetter.org/">David Fetter</a>  <a href="mailto:david@fetter.org">&lt;david@fetter.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFETTER">DFETTER</a><br />

1563. <a href="http://www.perlmonks.net/?node_id=628995">David Fleck</a>  <a href="mailto:david dot fleck at mchsi dot com">&lt;david dot fleck at mchsi dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCFLECK">DCFLECK</a><br />
1564. <a href="http://www.convergence.cx">David Freedman</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DF/DFREEDMAN">DFREEDMAN</a><br />
1565. David Garamond  <a href="mailto:davidgaramond@gmail.com">&lt;davidgaramond@gmail.com&gt;</a> -- DGARAMOND<br />

1566. <a href="http://init0.org/~dgay">David Gay</a>  <a href="mailto:dgay@init0.org">&lt;dgay@init0.org&gt;</a> -- DGAY<br />
1567. David Glasser  <a href="mailto:glasser@mit.edu">&lt;glasser@mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLASSER">GLASSER</a><br />
1568. <a href="http://use.perl.org/~dagolden/journal/">David Golden</a>  <a href="mailto:dagolden@cpan.org">&lt;dagolden@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAGOLDEN">DAGOLDEN</a><br />

1569. <a href="http://www.davegreco.com">David Greco</a>  <a href="mailto:perl@davegreco.com">&lt;perl@davegreco.com&gt;</a> -- DGRECO<br />
1570. David Green  <a href="mailto:david.green@telus.net">&lt;david.green@telus.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLATO">PLATO</a><br />
1571. David Gregory  <a href="mailto:david.gregory@gdcanada.com">&lt;david.gregory@gdcanada.com&gt;</a> -- DGREGORY<br />

1572. David Grizzanti  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DG/DGRIZZANT">DGRIZZANT</a><br />
1573. David H. Adler  <a href="mailto:dha@panix.com">&lt;dha@panix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHA">DHA</a><br />
1574. <a href="http://qsb.ucmerced.edu/faculty/dardell/lab/">David H. Ardell</a>  <a href="mailto:dhard@cpan.org">&lt;dhard@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHARD">DHARD</a><br />

1575. David Hampton  <a href="mailto:hampton@employees.org">&lt;hampton@employees.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAMPTON">HAMPTON</a><br />
1576. <a href="http://davidhand.com/">David Hand</a>  <a href="mailto:cogent@cpan.org">&lt;cogent@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COGENT">COGENT</a><br />
1577. <a href="http://www.davideous.com/">David Harris</a>  <a href="mailto:dharris@drh.net">&lt;dharris@drh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHARRIS">DHARRIS</a><br />

1578. <a href="http://www.codechild.com">David Helkowski</a>  <a href="mailto:cpan@codechild.com">&lt;cpan@codechild.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CODECHILD">CODECHILD</a><br />
1579. David Hillman  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAHILLMA">DAHILLMA</a><br />
1580. <a href="http://www.cameltime.com/">David Hisel</a>  <a href="mailto:hiseldl@cameltime.com">&lt;hiseldl@cameltime.com&gt;</a> -- HISELDL<br />

1581. <a href="http://www.full-duplex.com">David Huggins</a>  <a href="mailto:dhuggins@full-duplex.com">&lt;dhuggins@full-duplex.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDIUS">DAVIDIUS</a><br />
1582. <a href="http://www.cs.cmu.edu/~dhuggins/">David Huggins-Daines</a>  <a href="mailto:dhd@pobox.com">&lt;dhd@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJHD">DJHD</a><br />
1583. David Hugh-Jones  <a href="mailto:hughjonesd@yahoo.co.uk">&lt;hughjonesd@yahoo.co.uk&gt;</a> -- DAVIDHJ<br />

1584. <a href="www.davidhuska.com">David Huska</a>  <a href="mailto:dhuska at g m a i l dot com">&lt;dhuska at g m a i l dot com&gt;</a> -- HUSKA<br />
1585. David Iberri  <a href="mailto:diberri@cpan.org">&lt;diberri@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIBERRI">DIBERRI</a><br />
1586. <a href="http://www.irvined.co.uk/">David Irvine</a>  <a href="mailto:david@glasgownet.com">&lt;david@glasgownet.com&gt;</a> -- IRVINED<br />

1587. David Ishmael  <a href="mailto:dishmael3@home.com">&lt;dishmael3@home.com&gt;</a> -- DISHMAEL<br />
1588. <a href="http://arabidopsis.info">David J Craigon</a>  <a href="mailto:david@arabidopsis.info">&lt;david@arabidopsis.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKIPPY">SKIPPY</a><br />
1589. David J Kyger  <a href="mailto:davidkyger &lt;at&gt; mac.com">&lt;davidkyger &lt;at&gt; mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKYGER">DKYGER</a><br />

1590. <a href="http://avitas.net/">David J Moore</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KUNWON<br />
1591. <a href="http://sdl.perl.org">David J. Goehrig</a>  <a href="mailto:dgoehrig@cpan.org">&lt;dgoehrig@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DG/DGOEHRIG">DGOEHRIG</a><br />
1592. David J. Kernen  <a href="mailto:DJKERNEN__NO_SOLICITING__@cpan.org">&lt;DJKERNEN__NO_SOLICITING__@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJKERNEN">DJKERNEN</a><br />

1593. <a href="davido.perlmonk.org">David J. Oswald</a>  <a href="mailto:davido@cpan.org">&lt;davido@cpan.org&gt;</a> -- DAVIDO<br />
1594. <a href="http://david.olrik.dk/">David Jack Olrik</a>  <a href="mailto:david@olrik.dk">&lt;david@olrik.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJO">DJO</a><br />
1595. <a href="http://hello.typepad.com/">David Jacobs</a>  <a href="mailto:djacobs@cs.oberlin.edu">&lt;djacobs@cs.oberlin.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJACOBS">DJACOBS</a><br />

1596. <a href="http://www.cs.toronto.edu/~james">David James</a>  <a href="mailto:splice@cpan.org">&lt;splice@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPLICE">SPLICE</a><br />
1597. <a href="www.telnic.org">David Jones</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DJTELNIC<br />
1598. <a href="http://www.dstorrs.com/">David K Storrs</a>  <a href="mailto:cpan@dstorrs.com">&lt;cpan@dstorrs.com&gt;</a> -- DSTORRS<br />

1599. David KOENIG  <a href="mailto:karhu@u.washington.edu">&lt;karhu@u.washington.edu&gt;</a> -- KARHU<br />
1600. David Kamholz  <a href="mailto:davekam at pobox dot com">&lt;davekam at pobox dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DK/DKAMHOLZ">DKAMHOLZ</a><br />
1601. <a href="http://hunt.cc/">David Kröber</a>  <a href="mailto:dk83@gmx.li">&lt;dk83@gmx.li&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAFFY">TAFFY</a><br />

1602. David L. Leigh  <a href="mailto:dleigh@sameasiteverwas.net">&lt;dleigh@sameasiteverwas.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLEIGH">DLEIGH</a><br />
1603. <a href="http://www.justanotherperlhacker.com">David Labatte</a>  <a href="mailto:buggyd@justanotherperlhacker.com">&lt;buggyd@justanotherperlhacker.com&gt;</a> -- BUGGYD<br />
1604. <a href="http://www.landgren.net/perl/">David Landgren</a>  <a href="mailto:david@landgren.net">&lt;david@landgren.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLAND">DLAND</a><br />

1605. <a href="http://dgl.cx/">David Leadbeater</a>  <a href="mailto:dgl@dgl.cx">&lt;dgl@dgl.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DG/DGL">DGL</a><br />
1606. David Liu  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDCYL">DAVIDCYL</a><br />
1607. <a href="http://MarginalHacks.com/">David Ljung Madison</a>  <a href="mailto:cpan.org@daveola.com">&lt;cpan.org@daveola.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVEOLA">DAVEOLA</a><br />

1608. David Lloyd  <a href="mailto:dmlloyd@flurg.com">&lt;dmlloyd@flurg.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMLLOYD">DMLLOYD</a><br />
1609. David Lowry  <a href="mailto:dlowry@bju.edu">&lt;dlowry@bju.edu&gt;</a> -- WDLOWRY<br />
1610. David Lundberg  <a href="mailto:dlundberg@acm.org">&lt;dlundberg@acm.org&gt;</a> -- DLUNDBERG<br />
1611. <a href="www.packet-security.com">David M Ros</a>  <a href="mailto:david@packet-security.com">&lt;david@packet-security.com&gt;</a> -- BAGARRE<br />

1612. <a href="http://www.tinypig.com">David M. Bradford</a>  <a href="mailto:dm_bradford@hotmail.com">&lt;dm_bradford@hotmail.com&gt;</a> -- DBRADFORD<br />
1613. <a href="http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Net%3A%3ASNMP">David M. Town</a>  <a href="mailto:dtown@cpan.org">&lt;dtown@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DT/DTOWN">DTOWN</a><br />
1614. David Manura  <a href="mailto:davidm.cpan@math2.org">&lt;davidm.cpan@math2.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMANURA">DMANURA</a><br />

1615. <a href="http://www.chezmarshall.com/">David Marshall</a>  <a href="mailto:marshall@chezmarshall.com">&lt;marshall@chezmarshall.com&gt;</a> -- MARSHALL<br />
1616. <a href="http://user.icx.net/~pengy/">David Martin</a>  <a href="mailto:penguipotamous@yahoo.com">&lt;penguipotamous@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTINDT">MARTINDT</a><br />
1617. David McAllister  <a href="mailto:perldave@gmail.com">&lt;perldave@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMAC">DMAC</a><br />

1618. <a href="http://www.mackers.com/">David McNamara</a>  <a href="mailto:user 'me' at domain 'mackers.com'">&lt;user 'me' at domain 'mackers.com'&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MACKERS">MACKERS</a><br />
1619. <a href="http://www.affy.com">David Medinets</a>  <a href="mailto:medined@planet.net">&lt;medined@planet.net&gt;</a> -- MEDINED<br />
1620. <a href="http://www.megginson.com/">David Megginson</a>  <a href="mailto:david@megginson.com">&lt;david@megginson.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMEGG">DMEGG</a><br />

1621. <a href="http://www.merrill-scm.com/">David Merrill</a>  <a href="mailto:dmerrill@merrill-scm.com">&lt;dmerrill@merrill-scm.com&gt;</a> -- DMERRILL<br />
1622. David Morel  <a href="mailto:david.morel@amakuru.net">&lt;david.morel@amakuru.net&gt;</a> -- DMOR<br />
1623. <a href="http://damog.net/">David Moreno</a>  <a href="mailto:david@axiombox.com">&lt;david@axiombox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAMOG">DAMOG</a><br />

1624. David Mott  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOTT">MOTT</a><br />
1625. <a href="http://www.idiom.com/~muir">David Muir Sharnoff</a>  <a href="mailto:muir@idiom.com">&lt;muir@idiom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUIR">MUIR</a><br />
1626. <a href="http://www.firstworks.com">David Muse</a>  <a href="mailto:david.muse@firstworks.com">&lt;david.muse@firstworks.com&gt;</a> -- MUSED<br />

1627. David Narayan  <a href="mailto:dnarayan@cpan.org">&lt;dnarayan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DN/DNARAYAN">DNARAYAN</a><br />
1628. David Naughton  <a href="mailto:naughton@cpan.org">&lt;naughton@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAUGHTON">NAUGHTON</a><br />
1629. David Naughton  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NIHILIAD<br />

1630. <a href="http://fastolfe.net/">David Nesting</a>  <a href="mailto:david@fastolfe.net">&lt;david@fastolfe.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NESTING">NESTING</a><br />
1631. <a href="http://davidnicol.com/perl">David Nicol</a>  <a href="mailto:davidnicol@gmail.com">&lt;davidnicol@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDNICO">DAVIDNICO</a><br />
1632. David Nolan  <a href="mailto:vitroth@cmu.edu">&lt;vitroth@cmu.edu&gt;</a> -- VITROTH<br />

1633. David North  <a href="mailto:rold5@tditx.com">&lt;rold5@tditx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DN/DNORTH">DNORTH</a><br />
1634. David O'Neill  <a href="mailto:dmo+pause@dmo.ca">&lt;dmo+pause@dmo.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DONEILL">DONEILL</a><br />
1635. <a href="www.obernet.com">David Oberholtzer</a>  <a href="mailto:daveo@obernet.com">&lt;daveo@obernet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVEO">DAVEO</a><br />

1636. David Oksner  <a href="mailto:dave-perl@case.net">&lt;dave-perl@case.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOKSNER">DOKSNER</a><br />
1637. <a href="http://www.midsomer.org/">David Owen</a>  <a href="mailto:dowen@midsomer.org">&lt;dowen@midsomer.org&gt;</a> -- DOWEN<br />
1638. David P.C. Wollmann  <a href="mailto:converter42@gmail.com">&lt;converter42@gmail.com&gt;</a> -- CONVERTER<br />

1639. <a href="http://www.holgerdanske.com/dpchrist/">David Paul Christensen</a>  <a href="mailto:dpchrist@holgerdanske.com">&lt;dpchrist@holgerdanske.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPCHRIST">DPCHRIST</a><br />
1640. <a href="http://davidphendra.blogspot.com">David Periang Hendra</a>  <a href="mailto:david.perianghendra@gmail.com">&lt;david.perianghendra@gmail.com&gt;</a> -- BONTI<br />
1641. <a href="http://avitar.net">David Peter Smith</a>  <a href="mailto:dsmith@avitar.net">&lt;dsmith@avitar.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVITARNET">AVITARNET</a><br />

1642. David Prantl  <a href="mailto:pause@davidprantl.de">&lt;pause@davidprantl.de&gt;</a> -- DPRANTL<br />
1643. <a href="http://www.preshweb.co.uk/">David Precious</a>  <a href="mailto:davidp@preshweb.co.uk">&lt;davidp@preshweb.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIGPRESH">BIGPRESH</a><br />
1644. <a href="http://www.zerofive.co.uk">David R. Baird</a>  <a href="mailto:cpan.zerofive@googlemail.com">&lt;cpan.zerofive@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVEBAIRD">DAVEBAIRD</a><br />

1645. <a href="http://www.boxen.net/">David Radunz</a>  <a href="mailto:dj@boxen.net">&lt;dj@boxen.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJR">DJR</a><br />
1646. David Ramsden  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RAMSDEND<br />
1647. David Ranvig  <a href="mailto:davidra@cpan.org">&lt;davidra@cpan.org&gt;</a> -- DAVIDRA<br />

1648. <a href="http://www.davidrecordon.com/">David Recordon</a>  <a href="mailto:david@sixapart.com">&lt;david@sixapart.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RECORDOND">RECORDOND</a><br />
1649. <a href="http://www.reitter-it-media.de/">David Reitter</a>  <a href="mailto:david.reitter@gmail.com">&lt;david.reitter@gmail.com&gt;</a> -- REITTER<br />
1650. <a href="http://www.davidrobins.net">David Robins</a>  <a href="mailto:dbrobins@cpan.org">&lt;dbrobins@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBROBINS">DBROBINS</a><br />

1651. David Romano  <a href="mailto:unobe@cpan.org">&lt;unobe@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNOBE">UNOBE</a><br />
1652. David Romero G.  <a href="mailto:romdav@gmail.com">&lt;romdav@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROMDAV">ROMDAV</a><br />
1653. <a href="http://www.umich.edu/~rusekd">David Rusek</a>  <a href="mailto:rusekd@cpan.org">&lt;rusekd@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUSEKD">RUSEKD</a><br />

1654. <a href="www.validlyodd.net">David S Lloyd</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DSLLOYD<br />
1655. David S. Day  <a href="mailto:dday@sc.rr.com">&lt;dday@sc.rr.com&gt;</a> -- DAVEDAY<br />
1656. <a href="http://david.schweikert.ch/">David Schweikert</a>  <a href="mailto:david_@_schweikert.ch">&lt;david_@_schweikert.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSCHWEI">DSCHWEI</a><br />

1657. David Scott  <a href="mailto:dragonstep@geocities.com">&lt;dragonstep@geocities.com&gt;</a> -- DAVOD<br />
1658. David Sewell  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DSEWELL<br />
1659. David Shao  <a href="mailto:shaodave@yahoo.com">&lt;shaodave@yahoo.com&gt;</a> -- DSHAO<br />
1660. David Shao Lin Zhuo  <a href="mailto:dzhuo@google.com">&lt;dzhuo@google.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DZ/DZHUO">DZHUO</a><br />

1661. David Shultz  <a href="mailto:dshultz@cpan.org">&lt;dshultz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSHULTZ">DSHULTZ</a><br />
1662. David Sitsky  <a href="mailto:sits@users.sourceforge.net">&lt;sits@users.sourceforge.net&gt;</a> -- SITS<br />
1663. <a href="http://www.hackyourlife.org/">David Snopek</a>  <a href="mailto:dsnopek@gmail.com">&lt;dsnopek@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSNOPEK">DSNOPEK</a><br />

1664. David Sobon  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSOBON">DSOBON</a><br />
1665. <a href="http://www.spadea.net">David Spadea</a>  <a href="mailto:dspadea@cpan.org">&lt;dspadea@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSPADEA">DSPADEA</a><br />
1666. David Spizzirro  <a href="mailto:dspizz@dspizz.com">&lt;dspizz@dspizz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSPIZZ">DSPIZZ</a><br />

1667. David Stults  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- STULTS<br />
1668. <a href="http://www.gnutelephony.org">David Sugar</a>  <a href="mailto:dyfet@gnutelephony.org">&lt;dyfet@gnutelephony.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DY/DYFET">DYFET</a><br />
1669. David Thomas  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DTHOMAS<br />

1670. David Tiberio  <a href="mailto:dtiberio5@hotmail.com">&lt;dtiberio5@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DT/DTIBERIO">DTIBERIO</a><br />
1671. David Trail  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NAPAIM<br />
1672. David Tulloh  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LORDLOD<br />
1673. David Warring  <a href="mailto:david-dot-warring@ gmail.org">&lt;david-dot-warring@ gmail.org&gt;</a> -- WARRINGD<br />

1674. <a href="http://dwestbrook.net">David Westbrook</a>  <a href="mailto:davidrw@cpan.org">&lt;davidrw@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDRW">DAVIDRW</a><br />
1675. <a href="http://www.justatheory.com/">David Wheeler</a>  <a href="mailto:david@justatheory.com">&lt;david@justatheory.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWHEELER">DWHEELER</a><br />
1676. David Whitcomb  <a href="mailto:whitcode@gmail.com">&lt;whitcode@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHITCODE">WHITCODE</a><br />

1677. <a href="http://www.bigsnow.org/">David Winters</a>  <a href="mailto:winters@bigsnow.org">&lt;winters@bigsnow.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWINTERS">DWINTERS</a><br />
1678. David Wood  <a href="mailto:dwood@cpan.org">&lt;dwood@cpan.org&gt;</a> -- DWOOD<br />
1679. <a href="http://www.youdzone.com">David Youd</a>  <a href="mailto:david@youdzone.com">&lt;david@youdzone.com&gt;</a> -- YOUD<br />

1680. David rees  <a href="mailto:dave@ubiqsoft.com">&lt;dave@ubiqsoft.com&gt;</a> -- REESD<br />
1681. Davide Bergamini  <a href="mailto:davidebe75@yahoo.it">&lt;davidebe75@yahoo.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDEBE">DAVIDEBE</a><br />
1682. Davide Conti  <a href="mailto:daconti@cpan.org">&lt;daconti@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DACONTI">DACONTI</a><br />

1683. Davide Migliavacca  <a href="mailto:shari@users.sourceforge.net">&lt;shari@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHARI">SHARI</a><br />
1684. Davide Minini  <a href="mailto:exapersgarden@libero.it">&lt;exapersgarden@libero.it&gt;</a> -- SAIPH<br />
1685. Davide Rambaldi  <a href="mailto:davide.rambaldi@gmail.com">&lt;davide.rambaldi@gmail.com&gt;</a> -- RAMBALDI<br />
1686. Davide Scola  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAVIDE<br />

1687. Davide Sousa  <a href="mailto:kevorkyan@cpan.org">&lt;kevorkyan@cpan.org&gt;</a> -- KEVORKYAN<br />
1688. <a href="http://davood.ozino.com">Davood Firoozian</a>  <a href="mailto:davood at ozino">&lt;davood at ozino&gt;</a> -- DAVOOD<br />
1689. <a href="http://www.panmedia.dk">Davíð Helgason</a>  <a href="mailto:david@panmedia.dk">&lt;david@panmedia.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIDH">DAVIDH</a><br />

1690. <a href="http://www.dawood.in">Dawood Sangameshwari</a>  <a href="mailto:dawood@dawood.in">&lt;dawood@dawood.in&gt;</a> -- DAWOOD<br />
1691. <a href="http://www.unto.net/">DeWitt Clinton</a>  <a href="mailto:dewitt@unto.net">&lt;dewitt@unto.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCLINTON">DCLINTON</a><br />
1692. <a href="http://www.presicient.com">Dean Arnold</a>  <a href="mailto:darnold@presicient.com">&lt;darnold@presicient.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DARNOLD">DARNOLD</a><br />

1693. Dean Brockhausen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BROCKMD">BROCKMD</a><br />
1694. <a href="http://www.ero.com">Dean Hudson</a>  <a href="mailto:dean@ero.com">&lt;dean@ero.com&gt;</a> -- DEANH<br />
1695. Dean Povey  <a href="mailto:povey@wedgetail.com">&lt;povey@wedgetail.com&gt;</a> -- DEAN<br />

1696. Dean Roehrich  <a href="mailto:roehrich@cray.com">&lt;roehrich@cray.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMR">DMR</a><br />
1697. Dean Wilson  <a href="mailto:dean.wilson@gmail.com">&lt;dean.wilson@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DW/DWILSON">DWILSON</a><br />
1698. Debenson (����־)  <a href="mailto:wlzper@163.com">&lt;wlzper@163.com&gt;</a> -- DEBENSON<br />

1699. <a href="http://www.csse.monash.edu.au/~debbiep/">Deborah Pickett</a>  <a href="mailto:debbiep@csse.monash.edu.au">&lt;debbiep@csse.monash.edu.au&gt;</a> -- DAP<br />
1700. <a href="deepaktripathi.blogspot.com">Deepak Tripathi</a>  <a href="mailto:de9pak@gmail.com">&lt;de9pak@gmail.com&gt;</a> -- DEEPAK<br />
1701. <a href="http://www.deian.net">Deian Stefan</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEIAN">DEIAN</a><br />

1702. <a href="http://www.babel.com.au/del/">Del Elson</a>  <a href="mailto:del@babel.com.au">&lt;del@babel.com.au&gt;</a> -- DEL<br />
1703. <a href="http://solutious.com/">Delano</a>  <a href="mailto:delano@cpan.org">&lt;delano@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DELANO">DELANO</a><br />
1704. <a href="lab.xpto.org">Delfim Machado</a>  <a href="mailto:pause.perl.org@dbcm.profundos.org">&lt;pause.perl.org@dbcm.profundos.org&gt;</a> -- DBCM<br />

1705. Delon Newman  <a href="mailto:delon {dot} newman {at} gmail {dot} com">&lt;delon {dot} newman {at} gmail {dot} com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DELON">DELON</a><br />
1706. Demetrios E. Paneras  <a href="mailto:dep@media.mit.edu">&lt;dep@media.mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEP">DEP</a><br />
1707. Denis Almeida Vieira Junior  <a href="mailto:davieiraATyouoleldotcomdotbr">&lt;davieiraATyouoleldotcomdotbr&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVIEIRA">DAVIEIRA</a><br />

1708. <a href="http://www.experiment4.com/">Denis Leconte</a>  <a href="mailto:denis_leconte@yahoo.com">&lt;denis_leconte@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLECONTE">DLECONTE</a><br />
1709. <a href="http://www.denispetrov.com/">Denis Petrov</a>  <a href="mailto:denispetrov@yahoo.com">&lt;denispetrov@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPETROV">DPETROV</a><br />
1710. <a href="http://www.robinland.com">Denis Pokataev</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CATONE">CATONE</a><br />

1711. <a href="http://dev.ixchanger.net">Denis S Chuprunov</a>  <a href="mailto:hord@cpan.org">&lt;hord@cpan.org&gt;</a> -- HORD<br />
1712. Dennis Gregorovic  <a href="mailto:dgregorovic@alum.mit.edu">&lt;dgregorovic@alum.mit.edu&gt;</a> -- DGREGORO<br />
1713. <a href="http://davh.dk">Dennis Haney</a>  <a href="mailto:davh@davh.dk">&lt;davh@davh.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CI/CINE">CINE</a><br />

1714. Dennis K. Paulsen  <a href="mailto:ctrondlp@cpan.org">&lt;ctrondlp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTRONDLP">CTRONDLP</a><br />
1715. Dennis Lynch  <a href="mailto:dennisl@computer.org">&lt;dennisl@computer.org&gt;</a> -- DENNISL<br />
1716. Dennis McCoy  <a href="mailto:perl -le &quot;print scalar reverse qq/moc.liamg\100sgnisumlrep/&quot;">&lt;perl -le &quot;print scalar reverse qq/moc.liamg\100sgnisumlrep/&quot;&gt;</a> -- DMCCOY<br />

1717. <a href="http://www.adotout.com/">Dennis Opacki</a>  <a href="mailto:dopacki@adotout.com">&lt;dopacki@adotout.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOPACKI">DOPACKI</a><br />
1718. <a href="http://www.spin.de/~straitjack/perl">Dennis Schmeller</a>  <a href="mailto:straitjack@spin.de">&lt;straitjack@spin.de&gt;</a> -- STRAITJAC<br />
1719. <a href="http://www.sutch.com/">Dennis Sutch</a>  <a href="mailto:dennis@sutch.com">&lt;dennis@sutch.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUTCH">SUTCH</a><br />

1720. <a href="http://www.funkplanet.com/dennis/">Dennis Taylor</a>  <a href="mailto:dennis@funkplanet.com">&lt;dennis@funkplanet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FIMM">FIMM</a><br />
1721. <a href="http://www.techweb.com">Dennis Watson</a>  <a href="mailto:dwatson@netguide.com">&lt;dwatson@netguide.com&gt;</a> -- DENWA<br />
1722. Dennis Xiao  <a href="mailto:dxiao@platform.com">&lt;dxiao@platform.com&gt;</a> -- DXIAO<br />

1723. Denys Vorobyov  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DENYSV">DENYSV</a><br />
1724. <a href="http://www.mathw.tcd.ie/~dbell/">Derek Bell</a>  <a href="mailto:dbell@maths.may.ie">&lt;dbell@maths.may.ie&gt;</a> -- DBELL<br />
1725. Derek Boonstra  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DEREKB<br />

1726. <a href="http://blog.friocorte.com">Derek Carter</a>  <a href="mailto:goozbach@friocorte.com">&lt;goozbach@friocorte.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOOZBACH">GOOZBACH</a><br />
1727. Derek Fedel  <a href="mailto:synikalNOSPAM@N0SPAM.gmail.com">&lt;synikalNOSPAM@N0SPAM.gmail.com&gt;</a> -- DDF<br />
1728. Derek Heinbach  <a href="mailto:dheinbach@cpan.org">&lt;dheinbach@cpan.org&gt;</a> -- DHEINBACH<br />

1729. <a href="http://www.megacity.org/">Derek J. Balling</a>  <a href="mailto:dredd@megacity.org">&lt;dredd@megacity.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DREDD">DREDD</a><br />
1730. <a href="http://www.pobox.com/~dereklane/">Derek Lane</a>  <a href="mailto:dereklane@pobox.com">&lt;dereklane@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLANE">DLANE</a><br />
1731. <a href="http://www.btinternet.com/~pope.family/">Derek Pope</a>  <a href="mailto:delboy">&lt;delboy&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DELBOY">DELBOY</a><br />

1732. <a href="http://ximbiot.com">Derek Price</a>  <a href="mailto:derek@ximbiot.com">&lt;derek@ximbiot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPRICE">DPRICE</a><br />
1733. Derek Thomson  <a href="mailto:dthomson@users.sourceforge.net">&lt;dthomson@users.sourceforge.net&gt;</a> -- DEREK<br />
1734. Dermot McNally  <a href="mailto:dermotm@gmail.com">&lt;dermotm@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DERMOT">DERMOT</a><br />

1735. <a href="http://www.glade.perl.connectfree.co.uk">Dermot Musgrove</a>  <a href="mailto:dermot.musgrove@virgin.net">&lt;dermot.musgrove@virgin.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMUSGR">DMUSGR</a><br />
1736. <a href="www.newdatum.com">Dermot Reynolds</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DREYNOLDS<br />
1737. Derrik Pates  <a href="mailto:dpates@dsdk12.net">&lt;dpates@dsdk12.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPATES">DPATES</a><br />

1738. <a href="members.shaw.ca/dclee/">Desmond Lee</a>  <a href="mailto:neener666@hotmail.com">&lt;neener666@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCLEE">DCLEE</a><br />
1739. <a href="http://www.ties.org/deven/">Deven T. Corzine</a>  <a href="mailto:deven@ties.org">&lt;deven@ties.org&gt;</a> -- DEVEN<br />
1740. <a href="http://www.theoldmonk.net/blog">Devendra Gera</a>  <a href="mailto:gera@cpan.org">&lt;gera@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GERA">GERA</a><br />

1741. <a href="http://www.codedright.net">Devin Austin</a>  <a href="mailto:devin.austin@gmail.com">&lt;devin.austin@gmail.com&gt;</a> -- DHOSS<br />
1742. <a href="http://www.devin.com">Devin Carraway</a>  <a href="mailto:cpan@nospam.devin.com">&lt;cpan@nospam.devin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DC/DCARRAWAY">DCARRAWAY</a><br />
1743. <a href="http://www.evilsoft.org/Software">Devon Jones</a>  <a href="mailto:soulcatcher@evilsoft.org">&lt;soulcatcher@evilsoft.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEVONJ">DEVONJ</a><br />

1744. Devon K. Curtis  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEVON">DEVON</a><br />
1745. Dexter Tad-y  <a href="mailto:dtady@cpan.org">&lt;dtady@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DT/DTADY">DTADY</a><br />
1746. <a href="http://hea-www.harvard.edu/~dj/">Diab Jerius</a>  <a href="mailto:djerius@cpan.org">&lt;djerius@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJERIUS">DJERIUS</a><br />

1747. Diane Benz  <a href="mailto:diane@ahc.umn.edu">&lt;diane@ahc.umn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBEN">DBEN</a><br />
1748. <a href="http://www.perltk.org">Didier Ladner</a>  <a href="mailto:didier@perltk.org">&lt;didier@perltk.org&gt;</a> -- DLADNER<br />
1749. <a href="http://diego.kuperman.com.ar">Diego Kuperman</a>  <a href="mailto:diego (here you put an at sign) freekeylabs.com">&lt;diego (here you put an at sign) freekeylabs.com&gt;</a> -- DIEGOK<br />

1750. Diego de Lima  <a href="mailto:diego_de_lima@hotmail.com">&lt;diego_de_lima@hotmail.com&gt;</a> -- DIEGO<br />
1751. Dietmar Hanisch  <a href="mailto:dietmar.hanisch@bertelsmann.de">&lt;dietmar.hanisch@bertelsmann.de&gt;</a> -- DHANISCH<br />
1752. <a href="http://www.altera.gr/dsouflis/">Dimitrios Souflis</a>  <a href="mailto:dsouflis@altera.gr">&lt;dsouflis@altera.gr&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSOUFLIS">DSOUFLIS</a><br />

1753. Diogo Miguel Constantino dos Santos  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DMCS<br />
1754. <a href="http://mangaru.bliker.com">Diogo Neves</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANGARU">MANGARU</a><br />
1755. <a href="http://www.member.com/~dion">Dion Almaer</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIONALM">DIONALM</a><br />

1756. <a href="http://dirk.eddelbuettel.com">Dirk Eddelbuettel</a>  <a href="mailto:edd@debian.org">&lt;edd@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDD">EDD</a><br />
1757. Dirk Langer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ORDOBAN<br />
1758. <a href="http://www.lindnerei.de">Dirk Lindner</a>  <a href="mailto:lze@cpan.org">&lt;lze@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LZ/LZE">LZE</a><br />

1759. <a href="http://www.tosti.com">Dirk Tostmann</a>  <a href="mailto:cpan@tosti.com">&lt;cpan@tosti.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOSTI">TOSTI</a><br />
1760. <a href="http://www.tobit.co.uk/">Dirk-Jan Koopman</a>  <a href="mailto:djk@tobit.co.uk">&lt;djk@tobit.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJK">DJK</a><br />
1761. <a href="http://www.padz.net/~djpadz">Dj Padzensky</a>  <a href="mailto:djpadz@padz.net">&lt;djpadz@padz.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJPADZ">DJPADZ</a><br />

1762. <a href="http://dma.org.ru/">Dmitri Alenitchev</a>  <a href="mailto:dma@dma.org.ru">&lt;dma@dma.org.ru&gt;</a> -- DMA<br />
1763. Dmitri Sologoubenko  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMITRYSOL">DMITRYSOL</a><br />
1764. <a href="http://web.njit.edu/~dxt22/">Dmitri Tikhonov</a>  <a href="mailto:dtikhonov@yahoo.com">&lt;dtikhonov@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMITRI">DMITRI</a><br />

1765. Dmitriy Dontsov  <a href="mailto:mit@cpan.org">&lt;mit@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIT">MIT</a><br />
1766. <a href="http://www.comprice.ru/cmapuk/">Dmitriy Repin</a>  <a href="mailto:cmapuk@comprice.ru">&lt;cmapuk@comprice.ru&gt;</a> -- CTAPUK<br />
1767. Dmitriy Ryaboy  <a href="mailto:">&lt;&gt;</a> -- DVRYABOY<br />

1768. <a href="http://www.bashlov.ru">Dmitry Bashlov</a>  <a href="mailto:gorlum@bashlov.ru">&lt;gorlum@bashlov.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BASHLOV">BASHLOV</a><br />
1769. <a href="www.yasp.com">Dmitry Dorofeev</a>  <a href="mailto:dima@yasp.com">&lt;dima@yasp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEEMON">DEEMON</a><br />
1770. <a href="http://debian.org">Dmitry E. Oboukhov</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- UNERA<br />

1771. <a href="http://www.inp.nsk.su/~fedorov">Dmitry Fedorov</a>  <a href="mailto:dm.fedorov@gmail.com">&lt;dm.fedorov@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FEDOROV">FEDOROV</a><br />
1772. <a href="http://due.sunnysite.net/rhizo/">Dmitry Karabanov</a>  <a href="mailto:rhizo@cpan.org">&lt;rhizo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHIZO">RHIZO</a><br />
1773. <a href="http://www.karasik.eu.org">Dmitry Karasik</a>  <a href="mailto:dmitry@karasik.eu.org">&lt;dmitry@karasik.eu.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARASIK">KARASIK</a><br />

1774. <a href="http://kazimirov.com/">Dmitry Kazimirov</a>  <a href="mailto:kazimirov@cpan.org">&lt;kazimirov@cpan.org&gt;</a> -- KAZIMIROV<br />
1775. <a href="http://dklab.ru/">Dmitry Koteroff</a>  <a href="mailto:pause@dklab.ru">&lt;pause@dklab.ru&gt;</a> -- KOTEROFF<br />
1776. <a href="http://dklab.ru">Dmitry Koterov</a>  <a href="mailto:pause@koterov.ru">&lt;pause@koterov.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOTEROV">KOTEROV</a><br />

1777. <a href="http://perl.dp.ua">Dmitry Nikolayev</a>  <a href="mailto:dmitry@cpan.org">&lt;dmitry@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMITRY">DMITRY</a><br />
1778. Dmitry Ovsyanko  <a href="mailto:do_@pochta.ru">&lt;do_@pochta.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMOW">DMOW</a><br />
1779. Dmitry Rubinstein  <a href="mailto:dimrub@icomverse.com">&lt;dimrub@icomverse.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIMRUB">DIMRUB</a><br />

1780. Dmitry Sagaev  <a href="mailto:zurik@mail.ru">&lt;zurik@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSAMZA">DSAMZA</a><br />
1781. Dmitry Smal  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NUF<br />
1782. Dmitry V. Kolvakh  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEU">KEU</a><br />

1783. <a href="http://yarylo.sytes.net">Dmytro Kovalov</a>  <a href="mailto:kov@tokyo.email.ne.jp">&lt;kov@tokyo.email.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMYTRO">DMYTRO</a><br />
1784. <a href="http://softvisio.com">Dmytro Zagashev</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ZDM<br />
1785. <a href="http://www.rot13.org/~dpavlin/">Dobrica Pavlinusic</a>  <a href="mailto:dpavlin@rot13.org">&lt;dpavlin@rot13.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DP/DPAVLIN">DPAVLIN</a><br />

1786. <a href="http://digilander.libero.it/bash/">Domenico Delle Side</a>  <a href="mailto:dds@cpan.org">&lt;dds@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DD/DDS">DDS</a><br />
1787. Domingo Alcázar Larrea  <a href="mailto:domingo.alcazar@gmail.com">&lt;domingo.alcazar@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DALCAZAR">DALCAZAR</a><br />
1788. <a href="http://www.erpoutsourcing.net/dma.html">Domingo Areola</a>  <a href="mailto:dareola@gmail.com">&lt;dareola@gmail.com&gt;</a> -- DAREOLA<br />

1789. DominiX  <a href="mailto:dominix@mail.pf">&lt;dominix@mail.pf&gt;</a> -- DOMINIX<br />
1790. Dominic Dunlop  <a href="mailto:domo@computer.org">&lt;domo@computer.org&gt;</a> -- DOMO<br />
1791. <a href="http://www.larted.org.uk/~dom/">Dominic Hargreaves</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOM">DOM</a><br />

1792. <a href="http://happygiraffe.net/blog/">Dominic Mitchell</a>  <a href="mailto:cpan@happygiraffe.net">&lt;cpan@happygiraffe.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HD/HDM">HDM</a><br />
1793. <a href="http://perl.dominicneumann.de/">Dominic Neumann</a>  <a href="mailto:dominicn@cpan.org">&lt;dominicn@cpan.org&gt;</a> -- DOMINICN<br />
1794. <a href="http://www.inverse.ca">Dominik Gehl</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DGEHL<br />

1795. <a href="http://www.pervasive.jku.at/About_Us/Staff/Hochreiter/index.php">Dominik Hochreiter</a>  <a href="mailto:dominik@soft.uni-linz.ac.at">&lt;dominik@soft.uni-linz.ac.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KALELE">KALELE</a><br />
1796. <a href="http://www.depairet.de">Dominik Sander</a>  <a href="mailto:dominik+cpan@goodadvice.pages.de">&lt;dominik+cpan@goodadvice.pages.de&gt;</a> -- DSANDER<br />
1797. Dominique Dumont  <a href="mailto:dominique dot dumont at hp dot com">&lt;dominique dot dumont at hp dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DD/DDUMONT">DDUMONT</a><br />

1798. Dominique Faure  <a href="mailto:dfaure@cpan.org">&lt;dfaure@cpan.org&gt;</a> -- DFAURE<br />
1799. <a href="http://www.cru.fr">Dominique Launay</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOUMBZH">DOUMBZH</a><br />
1800. Dominique Quatravaux  <a href="mailto:dominique@quatravaux.org">&lt;dominique@quatravaux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOMQ">DOMQ</a><br />

1801. <a href="http://perl.4pro.net">Domizio Demichelis</a>  <a href="mailto:perl.4pro.net">&lt;perl.4pro.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOMIZIO">DOMIZIO</a><br />
1802. <a href="http://www.donarmstrong.com">Don Armstrong</a>  <a href="mailto:don@donarmstrong.com">&lt;don@donarmstrong.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DON">DON</a><br />
1803. Don Badrak  <a href="mailto:dbadrak@census.gov">&lt;dbadrak@census.gov&gt;</a> -- DBADRAK<br />

1804. <a href="http://www.drakeconsult.com/">Don Drake</a>  <a href="mailto:don@drakeconsult.com">&lt;don@drakeconsult.com&gt;</a> -- DONDRAKE<br />
1805. <a href="http://owensnet.com/">Don Owens</a>  <a href="mailto:dowens@cpan.org">&lt;dowens@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOWENS">DOWENS</a><br />
1806. Don Schwarz  <a href="mailto:dons@cpan.org">&lt;dons@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DONS">DONS</a><br />

1807. <a href="http://www.donshanks.com">Don Shanks</a>  <a href="mailto:donshank &lt;at&gt; cpan.org">&lt;donshank &lt;at&gt; cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DONSHANK">DONSHANK</a><br />
1808. Don Silvia  <a href="mailto:don.silvia+pause@gmail.com">&lt;don.silvia+pause@gmail.com&gt;</a> -- DSILVIA<br />
1809. Donald B. Guy  <a href="mailto:dguy@cpan.org">&lt;dguy@cpan.org&gt;</a> -- DGUY<br />

1810. <a href="http://www.psyon.org">Donald Becker</a>  <a href="mailto:psyon@psyon.org">&lt;psyon@psyon.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSYON">PSYON</a><br />
1811. <a href="http://chronos-tachyon.net/">Donald King</a>  <a href="mailto:donald.king@chronos-tachyon.net">&lt;donald.king@chronos-tachyon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLKING">DLKING</a><br />
1812. <a href="www.donatoaz.com.br">Donato Azevedo</a>  <a href="mailto:donatoaz@gmail.com">&lt;donatoaz@gmail.com&gt;</a> -- DONATOAZ<br />

1813. <a href="http://code.google.com/p/dongxu/">Dongxu Ma &lt;马东旭&gt;</a>  <a href="mailto:dongxu.ma@gmail.com">&lt;dongxu.ma@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DONGXU">DONGXU</a><br />
1814. Dorian Taylor  <a href="mailto:dorian@cpan.org">&lt;dorian@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DORIAN">DORIAN</a><br />
1815. Doug &quot;Sirilyan&quot; Sheppard  <a href="mailto:sirilyan@link.ca">&lt;sirilyan@link.ca&gt;</a> -- DSHEPP<br />

1816. <a href="http://www.bagley.org/~doug/contact.shtml">Doug Bagley</a>  <a href="mailto:cpan-devnull@bagley.org">&lt;cpan-devnull@bagley.org&gt;</a> -- DOUGB<br />
1817. <a href="http://commctrl.com">Doug Bell</a>  <a href="mailto:doug@commctrl.com">&lt;doug@commctrl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAWKALOOG">HAWKALOOG</a><br />
1818. Doug Bloebaum  <a href="mailto:bloebaum@dma.org">&lt;bloebaum@dma.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLABES">BLABES</a><br />

1819. Doug Breshears  <a href="mailto:breshear@eonet.com">&lt;breshear@eonet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DB/DBRESH">DBRESH</a><br />
1820. Doug Feuerbach  <a href="mailto:df.cpan@feuerbach.net">&lt;df.cpan@feuerbach.net&gt;</a> -- FEUERBACH<br />
1821. Doug Gorley  <a href="mailto:dgorley@cpan.org">&lt;dgorley@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DG/DGORLEY">DGORLEY</a><br />

1822. <a href="http://www.dougthug.com/">Doug Gruber</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOUGTHUG">DOUGTHUG</a><br />
1823. Doug Luce  <a href="mailto:doug@pause.con.com">&lt;doug@pause.con.com&gt;</a> -- DOUGLUCE<br />
1824. Doug MacEachern  <a href="mailto:dougm@pobox.com">&lt;dougm@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOUGM">DOUGM</a><br />

1825. Doug Morris  <a href="mailto:HDMorrisusa at excite dot com">&lt;HDMorrisusa at excite dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MORRISNIH">MORRISNIH</a><br />
1826. <a href="http://dougmunsinger.com">Doug Munsinger</a>  <a href="mailto:munsinger@cpan.org">&lt;munsinger@cpan.org&gt;</a> -- MUNSINGER<br />
1827. Doug Neil  <a href="mailto:doug@nuts.freeuk.com">&lt;doug@nuts.freeuk.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DN/DNEIL">DNEIL</a><br />

1828. <a href="http://www.lingo1.com">Doug Power</a>  <a href="mailto:douglingo@aol.com">&lt;douglingo@aol.com&gt;</a> -- DPLINGO<br />
1829. Doug Thayer  <a href="mailto:dlt_email-cpan@yahoo.com">&lt;dlt_email-cpan@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DT/DTHAY">DTHAY</a><br />
1830. <a href="dougtreder.com">Doug Treder</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DTREDER<br />

1831. Doug Welzel  <a href="mailto:dwelzel@yahoo.com">&lt;dwelzel@yahoo.com&gt;</a> -- DWELZEL<br />
1832. Douglas Burke  <a href="mailto:djburke@cpan.org">&lt;djburke@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DJ/DJBURKE">DJBURKE</a><br />
1833. <a href="http://somethingdoug.com">Douglas Christopher Wilson</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DOUGDUDE<br />

1834. Douglas Creager  <a href="mailto:dcreager@mit.edu">&lt;dcreager@mit.edu&gt;</a> -- DCREAGER<br />
1835. Douglas E. Wegscheid  <a href="mailto:dwegscheid@qtm.net">&lt;dwegscheid@qtm.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEWEG">DEWEG</a><br />
1836. Douglas H. Ray  <a href="mailto:dougray@NO.cpan.SPAM.org.MAPSSPAM">&lt;dougray@NO.cpan.SPAM.org.MAPSSPAM&gt;</a> -- DOUGRAY<br />
1837. Douglas Hunt  <a href="mailto:dhunt@ucar.edu">&lt;dhunt@ucar.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHUNT">DHUNT</a><br />

1838. Douglas Hunter  <a href="mailto:dug@plusthree.com">&lt;dug@plusthree.com&gt;</a> -- DUG<br />
1839. <a href="http://home.earthlink.net/~djreitme">Douglas J. Reitmeier</a>  <a href="mailto:djreitme@eartlhink.net">&lt;djreitme@eartlhink.net&gt;</a> -- REITMEIE<br />
1840. Douglas K. Fischer  <a href="mailto:fischerdk@earthlink.net">&lt;fischerdk@earthlink.net&gt;</a> -- DKF<br />

1841. Douglas Lankshear  <a href="mailto:DougL@ActiveState.com">&lt;DougL@ActiveState.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOUGL">DOUGL</a><br />
1842. <a href="http://www.unixlore.net">Douglas Maxwell</a>  <a href="mailto:doug@unixlore.net">&lt;doug@unixlore.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMAXWELL">DMAXWELL</a><br />
1843. <a href="http://www.dougsparling.com/">Douglas Sparling</a>  <a href="mailto:doug@dougsparling.com">&lt;doug@dougsparling.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DS/DSPARLING">DSPARLING</a><br />

1844. Douglas Wilson  <a href="mailto:dougw at cpan dot org">&lt;dougw at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOUGW">DOUGW</a><br />
1845. Dov Levenglick  <a href="mailto:levengli@yahoo.com">&lt;levengli@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEVENGLI">LEVENGLI</a><br />
1846. Dovier Antonio Ripoll Méndez  <a href="mailto:daripoll@estudiantes.uci.cu">&lt;daripoll@estudiantes.uci.cu&gt;</a> -- DOVIER<br />

1847. Dr Bean  <a href="mailto:drbean, then at (@), then cpan, then a dot (.), last org">&lt;drbean, then at (@), then cpan, then a dot (.), last org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRBEAN">DRBEAN</a><br />
1848. <a href="www.svenbaum.cx">Dr Sven Baum</a>  <a href="mailto:sven@turbo10.com">&lt;sven@turbo10.com&gt;</a> -- SVENBAUM<br />
1849. <a href="http://www.patwardhan.org/">Dr. Ardan Patwardhan</a>  <a href="mailto:ardan@patwardhan.org">&lt;ardan@patwardhan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARDAN">ARDAN</a><br />

1850. Dr. Curtis L. Greer  <a href="mailto:">&lt;&gt;</a> -- CURTLG<br />
1851. Dr. James Freeman  <a href="mailto:jfreeman@cpan.org">&lt;jfreeman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFREEMAN">JFREEMAN</a><br />
1852. Dr. Jason L. Sonnenberg  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSONNENB">JSONNENB</a><br />
1853. <a href="http://tangra.si.umich.edu/clair/clairlib">Dragomir Radev</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RADEV<br />

1854. Dragos Constantinescu  <a href="mailto:dragos@venus.nipne.ro">&lt;dragos@venus.nipne.ro&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRAGOS">DRAGOS</a><br />
1855. <a href="http://dinomite.net">Drew Stephens</a>  <a href="mailto:dinomite@cpan.org">&lt;dinomite@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DINOMITE">DINOMITE</a><br />
1856. <a href="http://www.drewtaylor.com/">Drew Taylor</a>  <a href="mailto:drew@drewtaylor.com">&lt;drew@drewtaylor.com&gt;</a> -- DTAYLOR<br />

1857. <a href="www.dghda.com">Duane Griffin</a>  <a href="mailto:duaneg@dghda.com">&lt;duaneg@dghda.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUANEG">DUANEG</a><br />
1858. <a href="www.downhomewebdesign.com">Duane Hinkley</a>  <a href="mailto:designit@down-home.net">&lt;designit@down-home.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOWNHOM">DOWNHOM</a><br />
1859. <a href="http://www.pimpsoft.com">Duane King</a>  <a href="mailto:dking@pimpsoft.com">&lt;dking@pimpsoft.com&gt;</a> -- DKING<br />

1860. <a href="http://www.wyldebeast-wunderliebe.com">Duco Dokter</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DD/DDOKTER">DDOKTER</a><br />
1861. Duncan Ferguson  <a href="mailto:duncan.ferguson@egg.com">&lt;duncan.ferguson@egg.com&gt;</a> -- NAGGIMAN<br />
1862. Duncan Ferguson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUNCS">DUNCS</a><br />

1863. <a href="http://www.adytumsolutions.com">Duncan McGreggor</a>  <a href="mailto:oubiwann@myrealbox.com">&lt;oubiwann@myrealbox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OU/OUBIWANN">OUBIWANN</a><br />
1864. Duncan Segrest  <a href="mailto:cpan@GigaGeek.info">&lt;cpan@GigaGeek.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GIGAGEEK">GIGAGEEK</a><br />
1865. <a href="http://dusty.hey.nu/">Dusty Wilson</a>  <a href="mailto:&lt;myfirstname&gt;at&lt;megagram&gt;dotcom">&lt;&lt;myfirstname&gt;at&lt;megagram&gt;dotcom&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILSOND">WILSOND</a><br />

1866. <a href="http://duzy.info">Duzy Chan(詹欣铭)</a>  <a href="mailto:duzy@cpan.org">&lt;duzy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUZY">DUZY</a><br />
1867. Dwayne Turley  <a href="mailto:pocomokeguy@comcast.net">&lt;pocomokeguy@comcast.net&gt;</a> -- DTURLEY<br />
1868. <a href="http://www.djos.org">Dylan Djos Martin</a>  <a href="mailto:dmartin@cpan.org">&lt;dmartin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DM/DMARTIN">DMARTIN</a><br />

1869. <a href="http://dylan.doxey.org/">Dylan Doxey</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DY/DYLAN">DYLAN</a><br />
1870. <a href="http://www.basepair.org">Dylan Ferreira</a>  <a href="mailto:perl@basepair.org">&lt;perl@basepair.org&gt;</a> -- DFERREIRA<br />
1871. Dylan House  <a href="mailto:dylan.house@alltel.com">&lt;dylan.house@alltel.com&gt;</a> -- NDHOUSE<br />

1872. <a href="http://dylan.hardison.net">Dylan William Hardison</a>  <a href="mailto:dylanwh@tampabay.rr.com">&lt;dylanwh@tampabay.rr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DH/DHARDISON">DHARDISON</a><br />
1873. <a href="http://mahatma.pp.ru">Dzianis Kahanovich</a>  <a href="mailto:mahatma@eu.by">&lt;mahatma@eu.by&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAHATMA">MAHATMA</a><br />
1874. E. M.  <a href="mailto:emodeller@cpan.org">&lt;emodeller@cpan.org&gt;</a> -- EMODELLER<br />

1875. <a href="www.sjsoft.org">E. V. Stolyarenko</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJSOFT">SJSOFT</a><br />
1876. E.R. Uber  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ERUBER<br />
1877. <a href="http://www.tiac.net/users/sqltech">ED BARLOW</a>  <a href="mailto:sqltech@tiac.net">&lt;sqltech@tiac.net&gt;</a> -- EBARLOW<br />

1878. <a href="http://epipe.com/">EPIPE Communications</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EP/EPIPE">EPIPE</a><br />
1879. <a href="http://www.eamondaly.com/">Eamon Daly</a>  <a href="mailto:eamon@eamondaly.com">&lt;eamon@eamondaly.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDALY">EDALY</a><br />
1880. <a href="http://earlruby.org/">Earl C. Ruby III</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ERUBY<br />

1881. <a href="http://holaservers.com/opensource.html">Earl Cahill</a>  <a href="mailto:earlcpan@gmail.com">&lt;earlcpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EARL">EARL</a><br />
1882. <a href="http://www.earlhood.com/">Earl Hood</a>  <a href="mailto:ehood@cpan.org">&lt;ehood@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EH/EHOOD">EHOOD</a><br />
1883. <a href="http://purl.oclc.org/net/earlemartin/">Earle Martin</a>  <a href="mailto:gro.edolnwod @ lrep">&lt;gro.edolnwod @ lrep&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMARTIN">EMARTIN</a><br />

1884. <a href="http://downlode.org/">Earle Martin</a>  <a href="mailto:perl then at then downlode then dot then org">&lt;perl then at then downlode then dot then org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEX">HEX</a><br />
1885. <a href="http://membled.com/">Ed Avis</a>  <a href="mailto:ed@membled.com">&lt;ed@membled.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDAVIS">EDAVIS</a><br />
1886. <a href="www.e-things.org">Ed Blanchfield</a>  <a href="mailto:ed@e-things.org">&lt;ed@e-things.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDB">EDB</a><br />

1887. <a href="http://www.edcallahan.com">Ed Callahan</a>  <a href="mailto:cpan@edcallahan.com">&lt;cpan@edcallahan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CALLAHAN">CALLAHAN</a><br />
1888. <a href="http://www.halley.cc/ed/">Ed Halley</a>  <a href="mailto:ed@halley.cc">&lt;ed@halley.cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HALLEY">HALLEY</a><br />
1889. Ed Hartnett  <a href="mailto:ejh@idcomm.com">&lt;ejh@idcomm.com&gt;</a> -- EHARTNETT<br />

1890. Ed Loehr  <a href="mailto:cpan@bluepolka.net">&lt;cpan@bluepolka.net&gt;</a> -- EFL<br />
1891. Ed Price  <a href="mailto:edp@panix.com">&lt;edp@panix.com&gt;</a> -- EDP<br />
1892. <a href="http://www.darkmist.net/~schallee">Ed Schaller</a>  <a href="mailto:schallee@darkmist.net">&lt;schallee@darkmist.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHALLEE">SCHALLEE</a><br />

1893. <a href="http://www.inkdroid.org">Ed Summers</a>  <a href="mailto:ehs@pobox.com">&lt;ehs@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESUMMERS">ESUMMERS</a><br />
1894. <a href="http://opensource.avajadi.org">Eddie Olsson</a>  <a href="mailto:avajadi@cpan.org">&lt;avajadi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AV/AVAJADI">AVAJADI</a><br />
1895. Eddy  <a href="mailto:evil.legacy@gmail.com">&lt;evil.legacy@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QU/QUATRIX">QUATRIX</a><br />

1896. Eden Cardim  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDENC">EDENC</a><br />
1897. Edgar A. Bering  <a href="mailto:trizor@cpan.org">&lt;trizor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TR/TRIZOR">TRIZOR</a><br />
1898. <a href="http://www.flatlinerict.nl">Edgar Klerks</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EKLERKS<br />

1899. <a href="www.jaburo.net">Edgar R. Ngwenya</a>  <a href="mailto:engwenya@yahoo.com">&lt;engwenya@yahoo.com&gt;</a> -- JABURO<br />
1900. Edgar Whipple  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MRWHIPPLE<br />
1901. Edgars Bināns  <a href="mailto:ebinans@gmail.com">&lt;ebinans@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WASX">WASX</a><br />

1902. <a href="http://www.bawue.de/~mergl/">Edmund Mergl</a>  <a href="mailto:E.Mergl@bawue.de">&lt;E.Mergl@bawue.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MERGL">MERGL</a><br />
1903. <a href="http://www.ecclestoad.co.uk">Edmund von der Burg</a>  <a href="mailto:evdb@ecclestoad.co.uk">&lt;evdb@ecclestoad.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVDB">EVDB</a><br />
1904. <a href="http://www.canebas.org/~elagache/">Edouard Lagache</a>  <a href="mailto:elagache@yahoo.com">&lt;elagache@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELAGACHE">ELAGACHE</a><br />

1905. Eduardo N. Hering  <a href="mailto:enh-pause@gabuleu.com">&lt;enh-pause@gabuleu.com&gt;</a> -- ENHERING<br />
1906. Eduardo Perez  <a href="mailto:edpeur@gmail.com">&lt;edpeur@gmail.com&gt;</a> -- EPEREZ<br />
1907. Eduardo Rangel Thompson  <a href="mailto:erangel@gmail.com">&lt;erangel@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERANGEL">ERANGEL</a><br />
1908. <a href="http://www.edsantiago.com/">Eduardo Santiago Muñoz</a>  <a href="mailto:pause@edsantiago.com">&lt;pause@edsantiago.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESM">ESM</a><br />

1909. <a href="http://www.primaesoft.tananet.net">Edvaldo silva de Almeida Jr</a>  <a href="mailto:edvaldoalmeida@linuxmail.org">&lt;edvaldoalmeida@linuxmail.org&gt;</a> -- LONEWOLF<br />
1910. <a href="http://www.kmett.com/">Edward A. Kmett</a>  <a href="mailto:harmless@mich.com">&lt;harmless@mich.com&gt;</a> -- EKMETT<br />
1911. <a href="http://edwardbetts.com/">Edward Betts</a>  <a href="mailto:edward@debian.org">&lt;edward@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDWARD">EDWARD</a><br />

1912. <a href="http://www.radiumhahn.com/perl">Edward C. Kubaitis</a>  <a href="mailto:ted@radiumhahn.com">&lt;ted@radiumhahn.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEDK">TEDK</a><br />
1913. <a href="http://www.ethercube.net">Edward Fancher</a>  <a href="mailto:ed.fancher@laposte.net">&lt;ed.fancher@laposte.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EF/EFANCHE">EFANCHE</a><br />
1914. Edward Guiness  <a href="mailto:EdwardGatcpan.org">&lt;EdwardGatcpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDWARDG">EDWARDG</a><br />

1915. Edward Heffernan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EHEFFERN<br />
1916. Edward J. Allen III  <a href="mailto:ealleniii _ at _ cpan _dot_ org">&lt;ealleniii _ at _ cpan _dot_ org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EALLENIII">EALLENIII</a><br />
1917. <a href="http://biomoby.org">Edward Kawas</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EK/EKAWAS">EKAWAS</a><br />

1918. <a href="http://www.zeroaltitude.org">Edward L. Abrams</a>  <a href="mailto:edward.abrams@corp.terralycos.com">&lt;edward.abrams@corp.terralycos.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZEROALTI">ZEROALTI</a><br />
1919. Edward L. Haletky  <a href="mailto:elh@astroarch.com">&lt;elh@astroarch.com&gt;</a> -- ELH<br />
1920. Edward Liu  <a href="mailto:dhliu@solar.csie.ntu.edu.tw">&lt;dhliu@solar.csie.ntu.edu.tw&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDLIU">EDLIU</a><br />

1921. <a href="http://www.bese.it/~segv">Edward Marco Baringer</a>  <a href="mailto:mb at bese dot it">&lt;mb at bese dot it&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEGV">SEGV</a><br />
1922. Edward Peschko  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ESP<br />
1923. <a href="http://www.outoforder.cc/">Edward Rudd</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UR/URKLE">URKLE</a><br />

1924. Edward WIJAYA  <a href="mailto:ewijaya@singnet.com.sg">&lt;ewijaya@singnet.com.sg&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EW/EWIJAYA">EWIJAYA</a><br />
1925. <a href="http://www.nsrc.nus.sg/STAFF/edward">Edward Walker</a>  <a href="mailto:ewalker@platform.com">&lt;ewalker@platform.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EW/EWALKER">EWALKER</a><br />
1926. Edward Wildgoose  <a href="mailto:cpan@wildgooses.com">&lt;cpan@wildgooses.com&gt;</a> -- WILDGOOSE<br />

1927. Edward Zborowski  <a href="mailto:edwardz@gmail.com">&lt;edwardz@gmail.com&gt;</a> -- NIBZE<br />
1928. <a href="http://grokmonkey.blogspot.com/">Edwin Pratomo</a>  <a href="mailto:epratomo@acm.org">&lt;epratomo@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDPRATOMO">EDPRATOMO</a><br />
1929. Egor Shipovalov  <a href="mailto:egor_pause@pragmaticware.com">&lt;egor_pause@pragmaticware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EG/EGORSH">EGORSH</a><br />

1930. Ehsan.Emadzadeh  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EH/EHSANE">EHSANE</a><br />
1931. <a href="http://perl-seiten.privat.t-online.de">Eike Grote</a>  <a href="mailto:eike.grote@consol.de">&lt;eike.grote@consol.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EIKEG">EIKEG</a><br />
1932. <a href="http://home.broadpark.no/~eroheim/">Einar Roheim</a>  <a href="mailto:eiro@cpan.org">&lt;eiro@cpan.org&gt;</a> -- EIRO<br />

1933. <a href="http://perlmonks.org/?node=Sidhekin">Eirik Berg Hanssen</a>  <a href="mailto:ebhanssen@allverden.no">&lt;ebhanssen@allverden.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBHANSSEN">EBHANSSEN</a><br />
1934. Eitan Schuler  <a href="mailto:schuler.eitan@gmail.com">&lt;schuler.eitan@gmail.com&gt;</a> -- EITANS<br />
1935. <a href="http://www.df4or.de/software/civperl.html">Ekki Plicht</a>  <a href="mailto:CENSORED please see website">&lt;CENSORED please see website&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EK/EKKIP">EKKIP</a><br />

1936. <a href="http://chaos.wustl.edu/~elaine">Elaine M. Ashton</a>  <a href="mailto:hfb@cpan.org">&lt;hfb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HF/HFB">HFB</a><br />
1937. <a href="http://www.nastynerds.com">Eldar Marcussen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARCUSSEN<br />
1938. <a href="http://www.arilou.org">Eleneldil G. Arilou</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ARILOU<br />

1939. <a href="http://tkltrans.sf.net">Eleonora</a>  <a href="mailto:eleonora@cpan.org">&lt;eleonora@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELEONORA">ELEONORA</a><br />
1940. Elfyn McBratney  <a href="mailto:beu@gentoo.org">&lt;beu@gentoo.org&gt;</a> -- EMCB<br />
1941. Eli Billauer  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BILLAUER">BILLAUER</a><br />

1942. Elias Wimmer  <a href="mailto:elias.wimmer@gmail.com">&lt;elias.wimmer@gmail.com&gt;</a> -- ELIAS<br />
1943. Elisa Jasinska  <a href="mailto:elisa@cpan.org">&lt;elisa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELISA">ELISA</a><br />
1944. Elizabeth Grace Frank-Backman  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ELISHEVA<br />
1945. Elizabeth Mattijsen  <a href="mailto:liz@dijkmat.nl">&lt;liz@dijkmat.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELIZABETH">ELIZABETH</a><br />

1946. <a href="http://gratuitous.net/~elliotf/">Elliot Foster</a>  <a href="mailto:elliotf@gratuitous.net">&lt;elliotf@gratuitous.net&gt;</a> -- ELLIOTF<br />
1947. <a href="http://galumph.com">Elliot Shank</a>  <a href="mailto:perl@galumph.com">&lt;perl@galumph.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELLIOTJS">ELLIOTJS</a><br />
1948. Elmar Schalueck  <a href="mailto:Elmar.Schalueck@rz.ruhr-uni-bochum.de">&lt;Elmar.Schalueck@rz.ruhr-uni-bochum.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELMAR">ELMAR</a><br />

1949. Emanuele Zeppieri  <a href="mailto:emazep@cpan.org">&lt;emazep@cpan.org&gt;</a> -- EMAZEP<br />
1950. Emerson Mills  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SONNY<br />
1951. Emir Imamagic  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EIMAMAGI<br />
1952. Emma Tonkin  <a href="mailto:cselt@users.sourceforge.net">&lt;cselt@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSELT">CSELT</a><br />

1953. Emmanuel Di Pretoro  <a href="mailto:manu@bjornoya.net">&lt;manu@bjornoya.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDIPRETO">EDIPRETO</a><br />
1954. Emmanuel Elango  <a href="mailto:emmanuel {dot] e {at] gmx {dot] net">&lt;emmanuel {dot] e {at] gmx {dot] net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMMANUEL">EMMANUEL</a><br />
1955. Emmanuel Lacour  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELACOUR">ELACOUR</a><br />

1956. Emmanuel Rodriguez  <a href="mailto:emmanuel.rodriguez@gmail.com">&lt;emmanuel.rodriguez@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POTYL">POTYL</a><br />
1957. <a href="http://log.emmanuelebassi.net">Emmanuele Bassi</a>  <a href="mailto:emmanuele@emmanuelebassi.net">&lt;emmanuele@emmanuelebassi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBASSI">EBASSI</a><br />
1958. <a href="http://www.sozlukcu.org/">Engin Gündüz</a>  <a href="mailto:gunduz_engin@&lt;nospam&gt;.yahoo.com">&lt;gunduz_engin@&lt;nospam&gt;.yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENGIN">ENGIN</a><br />

1959. Enno Derksen  <a href="mailto:enno@att.com">&lt;enno@att.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENNO">ENNO</a><br />
1960. Enrico Sorcinelli  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENRYS">ENRYS</a><br />
1961. <a href="http://www.geocities.com/ecastillac">Enrique Castilla Contreras</a>  <a href="mailto:ecastillacontreras@yahoo.es">&lt;ecastillacontreras@yahoo.es&gt;</a> -- BADAJOZ<br />

1962. <a href="http://www.geocities.com/ecastillac">Enrique Castilla Contreras</a>  <a href="mailto:ecastillacontreras@yahoo.es">&lt;ecastillacontreras@yahoo.es&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EC/ECASTILLA">ECASTILLA</a><br />
1963. <a href="http://www.haboogo.com">Enrique Nell</a>  <a href="mailto:perl_nell@telefonica.net">&lt;perl_nell@telefonica.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENELL">ENELL</a><br />
1964. Eriam Schaffter  <a href="mailto:eriam@cpan.org">&lt;eriam@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERIAM">ERIAM</a><br />

1965. Eric A. Miller  <a href="mailto:eric -at- jeneric.org">&lt;eric -at- jeneric.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMILLER">EMILLER</a><br />
1966. <a href="http://www.zarko.org/">Eric A. Zarko</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EZARKO<br />
1967. <a href="http://afaik.us">Eric Anderson</a>  <a href="mailto:fidus@cpan.org">&lt;fidus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FIDUS">FIDUS</a><br />

1968. <a href="http://openthought.net/">Eric Andreychek</a>  <a href="mailto:eric@openthought.net">&lt;eric@openthought.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERIC">ERIC</a><br />
1969. Eric Arnold  <a href="mailto:Eric.Arnold@corp.sun.com">&lt;Eric.Arnold@corp.sun.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERICA">ERICA</a><br />
1970. Eric Bartley  <a href="mailto:bartley@purdue.edu">&lt;bartley@purdue.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARTLEY">BARTLEY</a><br />

1971. Eric Boesch  <a href="mailto:ericboesch@gmail.com">&lt;ericboesch@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOESCH">BOESCH</a><br />
1972. <a href="http://www.omsdev.com">Eric Bohlman</a>  <a href="mailto:ebohlman@omsdev.com">&lt;ebohlman@omsdev.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBOHLMAN">EBOHLMAN</a><br />
1973. <a href="sil.biochem.uiowa.edu">Eric Brown</a>  <a href="mailto:eric-n-brown@uiowa.edu">&lt;eric-n-brown@uiowa.edu&gt;</a> -- ENB<br />

1974. <a href="http://www.softwarestudio.org">Eric Busboom</a>  <a href="mailto:ericbusboom@yahoo.com">&lt;ericbusboom@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBUSBOOM">EBUSBOOM</a><br />
1975. Eric Busto  <a href="mailto:ebusto AT nvidia.com">&lt;ebusto AT nvidia.com&gt;</a> -- EBUSTO<br />
1976. Eric C. Weaver  <a href="mailto:weav@sigma.net">&lt;weav@sigma.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WE/WEAV">WEAV</a><br />

1977. Eric Clark  <a href="mailto:eclark@hoser.com">&lt;eclark@hoser.com&gt;</a> -- ECLARK<br />
1978. Eric David Johnson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EDJ<br />
1979. Eric Estabrooks  <a href="mailto:eric@urbanrage.com">&lt;eric@urbanrage.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EE/EESTABROO">EESTABROO</a><br />
1980. Eric Fifer  <a href="mailto:efifer@dircon.co.uk">&lt;efifer@dircon.co.uk&gt;</a> -- EFIFER<br />

1981. <a href="http://www.fixler.com/">Eric Fixler</a>  <a href="mailto:fix@fixler.com">&lt;fix@fixler.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FIXLER">FIXLER</a><br />
1982. <a href="http://www.folley.net/">Eric Folley</a>  <a href="mailto:eric@folley.net">&lt;eric@folley.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EF/EFOLLEY">EFOLLEY</a><br />
1983. Eric Frazier  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EFRAZ<br />

1984. <a href="http://www.ericgarland.com">Eric Garland</a>  <a href="mailto:cpan@ericgarland.com">&lt;cpan@ericgarland.com&gt;</a> -- EGARLAND<br />
1985. Eric Germann  <a href="mailto:ekgermann@cctec.com">&lt;ekgermann@cctec.com&gt;</a> -- EKG<br />
1986. Eric Hacker  <a href="mailto:pause@erichacker.com">&lt;pause@erichacker.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HACKER">HACKER</a><br />

1987. <a href="http://www.anvilon.com">Eric Hammond</a>  <a href="mailto:eric dash cpan at thinksome dot com">&lt;eric dash cpan at thinksome dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESH">ESH</a><br />
1988. <a href="eric.harris-braun.com">Eric Harris-Braun</a>  <a href="mailto:eric_perl@harris-braun.com">&lt;eric_perl@harris-braun.com&gt;</a> -- ZIPPY<br />
1989. <a href="http://www.ericherrera.com">Eric Herrera</a>  <a href="mailto:herrera@cpan.org">&lt;herrera@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HERRERA">HERRERA</a><br />

1990. Eric Hodges  <a href="mailto:eric256@gmail.com">&lt;eric256@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERICJH">ERICJH</a><br />
1991. <a href="http://www.cyvon.com">Eric J Schultz</a>  <a href="mailto:">&lt;&gt;</a> -- ESCH<br />
1992. Eric J. Roode  <a href="mailto:eric.roode.cpan@gmail.com">&lt;eric.roode.cpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROODE">ROODE</a><br />

1993. <a href="http://www.vilos.com">Eric Johanson</a>  <a href="mailto:perl@cubesearch.com">&lt;perl@cubesearch.com&gt;</a> -- ERICJ<br />
1994. <a href="http://www.evilkitten.org/~kageneko/">Eric Kidder</a>  <a href="mailto:kageneko@evilkitten.org">&lt;kageneko@evilkitten.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAGENEKO">KAGENEKO</a><br />
1995. Eric Kolve  <a href="mailto:ekolve@comcast.net">&lt;ekolve@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EAK">EAK</a><br />

1996. <a href="http://www.nd.edu/~emorgan/">Eric Lease Morgan</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMORGAN">EMORGAN</a><br />
1997. <a href="http://ostromscience.com">Eric Lowell Ostrom</a>  <a href="mailto:perl@ostromscience.com">&lt;perl@ostromscience.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OS/OSTROM">OSTROM</a><br />
1998. Eric Mahurin  <a href="mailto:">&lt;&gt;</a> -- EMAHURIN<br />

1999. Eric Maki  <a href="mailto:fish-cpan-public@uc.org">&lt;fish-cpan-public@uc.org&gt;</a> -- FISHBOT<br />
2000. <a href="http://www.anglesanddangles.com">Eric Matthews</a>  <a href="mailto:webmaster@anglesanddangles.com">&lt;webmaster@anglesanddangles.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERICM">ERICM</a><br />
2001. <a href="http://inet.uni-c.dk/~ericejn/">Eric Negaard</a>  <a href="mailto:lmdejn@lmd.ericsson.se">&lt;lmdejn@lmd.ericsson.se&gt;</a> -- ENEGAARD<br />

2002. <a href="whynot@pozharski.name">Eric Pozharski</a>  <a href="mailto:whynot@pozharski.name">&lt;whynot@pozharski.name&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHYNOT">WHYNOT</a><br />
2003. Eric R. Meyers  <a href="mailto:Eric.R.Meyers@gmail.com">&lt;Eric.R.Meyers@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERMEYERS">ERMEYERS</a><br />
2004. <a href="http://eric_rollins.home.mindspring.com">Eric Rollins</a>  <a href="mailto:rollins@acm.org">&lt;rollins@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/EROLLINS">EROLLINS</a><br />

2005. Eric Rybski  <a href="mailto:rybskej@yahoo.com">&lt;rybskej@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RY/RYBSKEJ">RYBSKEJ</a><br />
2006. <a href="http://www.ccil.org/~esr">Eric S. Raymond</a>  <a href="mailto:esr@snark.thyrsus.com">&lt;esr@snark.thyrsus.com&gt;</a> -- ESR<br />
2007. Eric Sammer  <a href="mailto:esammer@cpan.org">&lt;esammer@cpan.org&gt;</a> -- ESAMMER<br />

2008. Eric Stith  <a href="mailto:cpan.publish@thelunarempire.net">&lt;cpan.publish@thelunarempire.net&gt;</a> -- ESTITH<br />
2009. Eric Thelin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ETHELIN<br />
2010. <a href="http://ethul.com">Eric Thul</a>  <a href="mailto:tollan83@yahoo.com">&lt;tollan83@yahoo.com&gt;</a> -- ETHUL<br />

2011. Eric Waters  <a href="mailto:ewaters@uarc.com">&lt;ewaters@uarc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EW/EWATERS">EWATERS</a><br />
2012. <a href="http://scratchcomputing.com">Eric Wilhelm</a>  <a href="mailto:ewilhelm at cpan dot org">&lt;ewilhelm at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EW/EWILHELM">EWILHELM</a><br />
2013. <a href="www.nagatemplar.org">Eric Willisson</a>  <a href="mailto:nagatemplar@gmail.com">&lt;nagatemplar@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERICW">ERICW</a><br />

2014. Eric Windisch  <a href="mailto:eric@windisch.us">&lt;eric@windisch.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EW/EWINDISCH">EWINDISCH</a><br />
2015. Eric Winter  <a href="mailto:Eric.L.Winter.1@gsfc.nasa.gov">&lt;Eric.L.Winter.1@gsfc.nasa.gov&gt;</a> -- ELWINTER<br />
2016. Eric Young  <a href="mailto:eay@mincom.oz.au">&lt;eay@mincom.oz.au&gt;</a> -- EAYNG<br />
2017. Erich Douglass  <a href="mailto:">&lt;&gt;</a> -- EDOUGLASS<br />

2018. Erich Morisse  <a href="mailto:erich+cpan@morisse.com">&lt;erich+cpan@morisse.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMORISSE">EMORISSE</a><br />
2019. Erich Roncarolo  <a href="mailto:erich-roncarolo@users.sourceforge.net">&lt;erich-roncarolo@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERICH">ERICH</a><br />
2020. Erich Strelow  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESTRELOW">ESTRELOW</a><br />

2021. <a href="http://www.psb.ugent.be/~erant/">Erick Antezana</a>  <a href="mailto:erant @ psb.ugent.be.">&lt;erant @ psb.ugent.be.&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EASR">EASR</a><br />
2022. <a href="http://jeb.ca">Erick Bourgeois</a>  <a href="mailto:erick@jeb.ca">&lt;erick@jeb.ca&gt;</a> -- EJB<br />
2023. <a href="http://perl.arix.com/">Erick Calder</a>  <a href="mailto:ecalder@cpan.org">&lt;ecalder@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EC/ECALDER">ECALDER</a><br />

2024. <a href="http://erik.arneson.org/">Erik Arneson</a>  <a href="mailto:erik@aarg.net">&lt;erik@aarg.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EARNESON">EARNESON</a><br />
2025. <a href="http://www.documentroot.com">Erik Aronesty</a>  <a href="mailto:earonesty@cpan.org">&lt;earonesty@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EA/EARONESTY">EARONESTY</a><br />
2026. Erik Bachmann  <a href="mailto:">&lt;&gt;</a> -- BACHMANN<br />

2027. <a href="http://www.bosrup.com/">Erik Bosrup</a>  <a href="mailto:erik@bosrup.com">&lt;erik@bosrup.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBOSRUP">EBOSRUP</a><br />
2028. <a href="http://www.ecocode.net">Erik Colson</a>  <a href="mailto:eco@ecocode.net">&lt;eco@ecocode.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EC/ECOCODE">ECOCODE</a><br />
2029. Erik E. Rantapaa  <a href="mailto:rantapaa@math.umn.edu">&lt;rantapaa@math.umn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANT">RANT</a><br />

2030. Erik Elliott Erwitt  <a href="mailto:erike@cpan.org">&lt;erike@cpan.org&gt;</a> -- ERIKE<br />
2031. Erik F. Kastner  <a href="mailto:kastner@gmail.com">&lt;kastner@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KASTNER">KASTNER</a><br />
2032. Erik Hollensbe  <a href="mailto:erik@hollensbe.org">&lt;erik@hollensbe.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERIKH">ERIKH</a><br />

2033. <a href="nexeme.com">Erik Lynch</a>  <a href="mailto:erik@nexeme.com">&lt;erik@nexeme.com&gt;</a> -- ELYNCH<br />
2034. <a href="http://www.ravelgrane.com/">Erik Ray</a>  <a href="mailto:eray@oreilly.com">&lt;eray@oreilly.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERIKRAY">ERIKRAY</a><br />
2035. <a href="www.ejox.nl">Erik Vrolijk</a>  <a href="mailto:fungus@cpan.org">&lt;fungus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FU/FUNGUS">FUNGUS</a><br />

2036. Erik Wasser  <a href="mailto:erik.wasser@iquer.net">&lt;erik.wasser@iquer.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FU/FUZZ">FUZZ</a><br />
2037. <a href="http://www.sommarskog.se/">Erland Sommarskog</a>  <a href="mailto:esquel@sommarskog.se">&lt;esquel@sommarskog.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOMMAR">SOMMAR</a><br />
2038. <a href="http://www.virtualitas.net/perl/">Ernest Lergon</a>  <a href="mailto:ernest@virtualitas.net">&lt;ernest@virtualitas.net&gt;</a> -- LERGON<br />

2039. <a href="http://erngui.com">Ernesto Guisado</a>  <a href="mailto:erngui@cpan.org">&lt;erngui@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERNGUI">ERNGUI</a><br />
2040. <a href="www.ernie.org">Ernie Hershey</a>  <a href="mailto:pause@ernie.org">&lt;pause@ernie.org&gt;</a> -- EHERSHEY<br />
2041. <a href="http://lunker.5u.com/">Ernie Lundqvist</a>  <a href="mailto:ernie_lundqvist@hotmail.com">&lt;ernie_lundqvist@hotmail.com&gt;</a> -- LUNKER<br />

2042. <a href="http://dienstleistung-kultur.de">Ernst-J. Johnsdorf</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ERNESTO<br />
2043. <a href="http://erwan.lemonnier.se">Erwan Lemonnier</a>  <a href="mailto:erwan@cpan.org">&lt;erwan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERWAN">ERWAN</a><br />
2044. <a href="http://www.zeegee.com/">Eryq</a>  <a href="mailto:eryq@zeegee.com">&lt;eryq@zeegee.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/ERYQ">ERYQ</a><br />

2045. <a href="http://zerodogg.iamaturtle.org">Eskild Hustvedt</a>  <a href="mailto:zerodogg [-A-T-] gm@il [D0T] com">&lt;zerodogg [-A-T-] gm@il [D0T] com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZERODOGG">ZERODOGG</a><br />
2046. Espen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ESPIZO<br />
2047. <a href="http://allanon.elfhame.net/">Ethan Fischer</a>  <a href="mailto:pause@ethan.elfhame.net">&lt;pause@ethan.elfhame.net&gt;</a> -- EFISCHER<br />

2048. <a href="http://www.etilem.net">Etienne (Et!L3W) LEMEE</a>  <a href="mailto:http://www.etilem.net/contact/">&lt;http://www.etilem.net/contact/&gt;</a> -- ETILEM<br />
2049. <a href="http://viriato.isr.ist.utl.pt/~etienne/">Etienne Grossmann</a>  <a href="mailto:etienne@isr.ist.utl.pt">&lt;etienne@isr.ist.utl.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EG/EGROSS">EGROSS</a><br />
2050. Etienne Robillard  <a href="mailto:erob@cpan.org">&lt;erob@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ER/EROB">EROB</a><br />

2051. <a href="http://kes.net.ua">Eugen Konkov</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KES">KES</a><br />
2052. Eugen Sobchenko  <a href="mailto:ejs@cpan.org">&lt;ejs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EJ/EJS">EJS</a><br />
2053. Eugene Bogush  <a href="mailto:b_eugene@ukr.net">&lt;b_eugene@ukr.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EU/EUG">EUG</a><br />

2054. <a href="www.ensembl.org">Eugene Bragin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EBRAGIN<br />
2055. <a href="http://www.eekim.com/">Eugene Eric Kim</a>  <a href="mailto:eekim@blueoxen.org">&lt;eekim@blueoxen.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EE/EEKIM">EEKIM</a><br />
2056. Eugene Grigoriev  <a href="mailto:eugene.grigoriev@gmail.com">&lt;eugene.grigoriev@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIZUR">SIZUR</a><br />

2057. Eugene Kulesha  <a href="mailto:kulesha@gmail.com">&lt;kulesha@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSET">JSET</a><br />
2058. Eugene Y. Jen  <a href="mailto:eugene.y.jen@gmail.com">&lt;eugene.y.jen@gmail.com&gt;</a> -- EYYJEN<br />
2059. Eugene van der Pijll  <a href="mailto:pijll@gmx.net">&lt;pijll@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIJLL">PIJLL</a><br />

2060. Eugeny Zhabasov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JACKAL<br />
2061. European Bob  <a href="mailto:bob@wolfwall.com">&lt;bob@wolfwall.com&gt;</a> -- EUROBOB<br />
2062. Evan A. Zacks  <a href="mailto:e-cpan@zacks.org">&lt;e-cpan@zacks.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZACKSE">ZACKSE</a><br />
2063. <a href="evancarroll.com">Evan Carroll</a>  <a href="mailto:me+cpan@evancarroll.com">&lt;me+cpan@evancarroll.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EC/ECARROLL">ECARROLL</a><br />

2064. <a href="http://perlmonks.org/?node=EvanK">Evan Kaufman</a>  <a href="mailto:evank@cpan.org">&lt;evank@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVANK">EVANK</a><br />
2065. <a href="frap.net">Evan Miller</a>  <a href="mailto:eam@frap.net">&lt;eam@frap.net&gt;</a> -- EAM<br />
2066. Evangelo Prodromou  <a href="mailto:evangelo@endcontsw.com">&lt;evangelo@endcontsw.com&gt;</a> -- EVANPRO<br />

2067. <a href="http://evan.prodromou.san-francisco.ca.us/">Evangelo Prodromou</a>  <a href="mailto:evan@prodromou.san-francisco.ca.us">&lt;evan@prodromou.san-francisco.ca.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVAN">EVAN</a><br />
2068. Evdokimov Denis  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GREEN<br />
2069. Even Holen  <a href="mailto:evenh+pause@pvv.ntnu.no">&lt;evenh+pause@pvv.ntnu.no&gt;</a> -- HOLROY<br />

2070. Evgeny Nifontov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIF">NIF</a><br />
2071. Evilio José del Río Silván  <a href="mailto:edelrio@cmima.csic.es">&lt;edelrio@cmima.csic.es&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EJ/EJDRS">EJDRS</a><br />
2072. <a href="http://bio.perl.org/">Ewan Birney</a>  <a href="mailto:birney@sanger.ac.uk">&lt;birney@sanger.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIRNEY">BIRNEY</a><br />

2073. <a href="http://www.c4-security.com">Eyal Udassin</a>  <a href="mailto:eyaludassin@cpan.com">&lt;eyaludassin@cpan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UD/UDASSIN">UDASSIN</a><br />
2074. Ezra Pagel  <a href="mailto:ezra@cpan.org">&lt;ezra@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EZ/EZRA">EZRA</a><br />
2075. <a href="http://www.ezrakilty.net">Ezra elias kilty Cooper</a>  <a href="mailto:ezra@ezrakilty.net">&lt;ezra@ezrakilty.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EZ/EZRAKILTY">EZRAKILTY</a><br />

2076. FARKAS Árpád  <a href="mailto:arpadf@cpan.org">&lt;arpadf@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARPADF">ARPADF</a><br />
2077. <a href="http://www.netvibes.com/cfilippe">FILIPPELLI Christophe</a>  <a href="mailto:cfilippe@cpan.org">&lt;cfilippe@cpan.org&gt;</a> -- CFILIPPE<br />
2078. <a href="http://hacker-x-hacker.blogspot.com">FUJIMURA Yuki</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FU/FUJIMURA">FUJIMURA</a><br />

2079. FUJIWARA Shunichiro  <a href="mailto:fujiwara.shunichiro@gmail.com">&lt;fujiwara.shunichiro@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FU/FUJIWARA">FUJIWARA</a><br />
2080. <a href="http://cascavel.pm.org/~frighetti/">Fabiano Reese Righetti</a>  <a href="mailto:frighetti@cpan.org">&lt;frighetti@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRIGHETTI">FRIGHETTI</a><br />
2081. <a href="http://www-rocq.inria.fr/codes/Fabien.Galand/index.en.html">Fabien GALAND</a>  <a href="mailto:galand@cpan.org">&lt;galand@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GALAND">GALAND</a><br />

2082. Fabien Potencier  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FABPOT">FABPOT</a><br />
2083. Fabien Tassin  <a href="mailto:fta+cpan@sofaraway.org">&lt;fta+cpan@sofaraway.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FT/FTASSIN">FTASSIN</a><br />
2084. <a href="http://www.pivari.com/">Fabrizio Pivari</a>  <a href="mailto:fabrizio@pivari.com">&lt;fabrizio@pivari.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FP/FPIVARI">FPIVARI</a><br />

2085. <a href="http://wss.hypermart.net/">Faisal Nasim</a>  <a href="mailto:swiftkid@bigfoot.com">&lt;swiftkid@bigfoot.com&gt;</a> -- FAISAL<br />
2086. <a href="http://parsedparticiple.org/">Faiz Kazi</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FAIZ">FAIZ</a><br />
2087. Falco Nikolas  <a href="mailto:nfalco79@libero.it">&lt;nfalco79@libero.it&gt;</a> -- NFALCO<br />

2088. <a href="http://www.cnblogs.com/thomas/">Fang.changnian</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XI/XIONGYING">XIONGYING</a><br />
2089. <a href="http://honda-metropolitan.montanajeepchrysler.cn/kendall-maroone-nissan.htm">Fanos</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FANOS<br />
2090. Father Chrysostomos  <a href="mailto:$_ = 'spro^^*%*^6ut#@&amp;$%*c&gt;#!^!#&amp;!pan.org'; y/a-z.@//cd; print">&lt;$_ = 'spro^^*%*^6ut#@&amp;$%*c&gt;#!^!#&amp;!pan.org'; y/a-z.@//cd; print&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPROUT">SPROUT</a><br />

2091. <a href="http://www.thinkervine.com/blog/">Faycal CHRAIBI</a>  <a href="mailto:fays@cpan.org">&lt;fays@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FAYS">FAYS</a><br />
2092. <a href="http://www.fayland.org/">Fayland 林</a>  <a href="mailto:fayland@cpan.org">&lt;fayland@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FAYLAND">FAYLAND</a><br />
2093. Federico Galassi  <a href="mailto:federico@serversidestudio.it">&lt;federico@serversidestudio.it&gt;</a> -- FGALASSI<br />

2094. <a href="http://geocities.com/felixdaru">Felix Liberman</a>  <a href="mailto:felix.liberman [at] gmail.com">&lt;felix.liberman [at] gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FELIXL">FELIXL</a><br />
2095. Felix Sebastian Gallo  <a href="mailto:fsg@ultranet.com">&lt;fsg@ultranet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FS/FSG">FSG</a><br />
2096. <a href="http://www.math.fu-berlin.de/~leitner/">Felix von Leitner</a>  <a href="mailto:leitner@math.fu-berlin.de">&lt;leitner@math.fu-berlin.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLEITNER">FLEITNER</a><br />

2097. Fen Labalme  <a href="mailto:fen@cpan.org">&lt;fen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FEN">FEN</a><br />
2098. <a href="http://prantl.host.sk">Ferdinand Prantl</a>  <a href="mailto:prantl@host.sk">&lt;prantl@host.sk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRANTL">PRANTL</a><br />
2099. <a href="http://www.fergaldaly.com/">Fergal Daly</a>  <a href="mailto:fergal@esatclear.ie">&lt;fergal@esatclear.ie&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FD/FDALY">FDALY</a><br />

2100. <a href="http://nocturno.nsk.pt">Fernando A. P. Gomes</a>  <a href="mailto:fapg@nsk.pt">&lt;fapg@nsk.pt&gt;</a> -- FAPG<br />
2101. <a href="http://perl-e.org">Fernando Correa de Oliveira</a>  <a href="mailto:fco@cpan.org">&lt;fco@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FC/FCO">FCO</a><br />
2102. <a href="http://www.pedestalsoftware.com">Fernando Trias</a>  <a href="mailto:fernando@pedestalsoftware.com">&lt;fernando@pedestalsoftware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TR/TRIAS">TRIAS</a><br />

2103. FigAnim  <a href="mailto:fred.per1@free.fr">&lt;fred.per1@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FIGANIM">FIGANIM</a><br />
2104. Fila Kolodny  <a href="mailto:fila@ibi.com">&lt;fila@ibi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FK/FKOLODNY">FKOLODNY</a><br />
2105. <a href="http://blog.fdutra.org">Filipe Dutra</a>  <a href="mailto:mopy@cpan.org">&lt;mopy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOPY">MOPY</a><br />

2106. <a href="http://informatics.indiana.edu/fil/">Filippo Menczer</a>  <a href="mailto:fmenczer@gmail.com">&lt;fmenczer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FM/FMENCZER">FMENCZER</a><br />
2107. Firas Zureiqat  <a href="mailto:firasz@hotmail.com">&lt;firasz@hotmail.com&gt;</a> -- FIRASZ<br />
2108. <a href="http://www.exentrica.it">Flavio Fanton</a>  <a href="mailto:flazan@exentrica.it">&lt;flazan@exentrica.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLAZAN">FLAZAN</a><br />

2109. <a href="http://www.polettix.it/">Flavio Poletti</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POLETTIX">POLETTIX</a><br />
2110. Florent Angly  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FANGLY<br />
2111. Florian Endler  <a href="mailto:endler@cpan.org">&lt;endler@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EN/ENDLER">ENDLER</a><br />

2112. <a href="http://verplant.org/">Florian Forster</a>  <a href="mailto:octopus@nospam.verplant.org">&lt;octopus@nospam.verplant.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OC/OCTO">OCTO</a><br />
2113. Florian Goslich  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FG/FGOSLICH">FGOSLICH</a><br />
2114. Florian Greb  <a href="mailto:greb@cpan.org">&lt;greb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GREB">GREB</a><br />

2115. Florian Hatat  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FLH<br />
2116. <a href="http://www.laudatio.com/wordpress">Florian Helmberger</a>  <a href="mailto:florian@cpan.org">&lt;florian@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLORIAN">FLORIAN</a><br />
2117. Florian Merges  <a href="mailto:fmerges@cpan.org">&lt;fmerges@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FM/FMERGES">FMERGES</a><br />

2118. <a href="http://perldition.org/">Florian Ragwitz</a>  <a href="mailto:rafl@debian.org">&lt;rafl@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLORA">FLORA</a><br />
2119. <a href="http://www.ipct.pucrs.br/flavio/">Flávio Soibelmann Glock</a>  <a href="mailto:fglock@gmail.com">&lt;fglock@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FG/FGLOCK">FGLOCK</a><br />
2120. <a href="http://www.abstractfactory.org/">Forrest Cahoon</a>  <a href="mailto:forrest@cpan.org">&lt;forrest@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FORREST">FORREST</a><br />

2121. Forrest W. Christian  <a href="mailto:forrestc@imach.com">&lt;forrestc@imach.com&gt;</a> -- FORRESTC<br />
2122. <a href="http://opensource.fotango.com/">Fotango Ltd</a>  <a href="mailto:cpan@fotango.com">&lt;cpan@fotango.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FOTANGO">FOTANGO</a><br />
2123. Franc Carter  <a href="mailto:franc.carter@gmail.com">&lt;franc.carter@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANC">FRANC</a><br />

2124. Francesc Guasch  <a href="mailto:frankie@etsetb.upc.edu">&lt;frankie@etsetb.upc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANKIE">FRANKIE</a><br />
2125. Francesco Cecconi  <a href="mailto:fcecconi@cpan.org">&lt;fcecconi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FC/FCECCONI">FCECCONI</a><br />
2126. <a href="http://francesco.webinit.com/">Francesco Pasqualini</a>  <a href="mailto:f.pasqualini@cpsinformatica.it">&lt;f.pasqualini@cpsinformatica.it&gt;</a> -- FPAS<br />

2127. <a href="http://indev.insu.com/">Francis J. Lacoste</a>  <a href="mailto:frajulac@contre.com">&lt;frajulac@contre.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRAJULAC">FRAJULAC</a><br />
2128. <a href="http://users.telenet.be/fvd/">Francis van Dun</a>  <a href="mailto:francis.vandun@pandora.be">&lt;francis.vandun@pandora.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FV/FVANDUN">FVANDUN</a><br />
2129. <a href="http://80.26.42.188/">Francisco M. Marzoa Alonso</a>  <a href="mailto:fmmmarzoa@gmx.net">&lt;fmmmarzoa@gmx.net&gt;</a> -- MARZOA<br />

2130. Franck Cuny  <a href="mailto:franck@lumberjaph.net">&lt;franck@lumberjaph.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANCKC">FRANCKC</a><br />
2131. <a href="www.coredump.fr.to">Franck Dubois</a>  <a href="mailto:franckdubois@ifrance.com">&lt;franckdubois@ifrance.com&gt;</a> -- RAFAEL<br />
2132. <a href="http://www.reckon.co.uk/staff/franck/">Franck Latrémolière</a>  <a href="mailto:f.latremoliere@reckon.co.uk">&lt;f.latremoliere@reckon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RECKON">RECKON</a><br />

2133. <a href="www.smartech.pf">Franck PORCHER</a>  <a href="mailto:fporcher@smartech.pf">&lt;fporcher@smartech.pf&gt;</a> -- FPORCHER<br />
2134. <a href="http://www.cim.mcgill.ca/~franco/Home.html">Franco Callari</a>  <a href="mailto:franco@cim.mcgill.ca">&lt;franco@cim.mcgill.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANCOC">FRANCOC</a><br />
2135. <a href="http://www.azolia.fr">Francois Colombier</a>  <a href="mailto:francois.colombier@free.fr">&lt;francois.colombier@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRACOLO">FRACOLO</a><br />

2136. Francois Desarmenien  <a href="mailto:francois@fdesar.net">&lt;francois@fdesar.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FD/FDESAR">FDESAR</a><br />
2137. <a href="http://fperrad.googlepages.com/home">Francois Perrad</a>  <a href="mailto:francois.perrad@gadz.org">&lt;francois.perrad@gadz.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERRAD">PERRAD</a><br />
2138. <a href="www.cydone.com">Francois Perron</a>  <a href="mailto:fxfx@cydone.com">&lt;fxfx@cydone.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FX/FXFX">FXFX</a><br />

2139. Frank Antonsen  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FANTONSEN">FANTONSEN</a><br />
2140. <a href="http://frankypelvis.com/Win32/Filetime.html">Frank Bardelli</a>  <a href="mailto:thunders@bestweb.net">&lt;thunders@bestweb.net&gt;</a> -- THUNDERS<br />
2141. Frank Brehm  <a href="mailto:frank.brehm@gmx.de">&lt;frank.brehm@gmx.de&gt;</a> -- ALFRED<br />

2142. <a href="www.dbnet.com.au">Frank Carnovale</a>  <a href="mailto:info@dbnet.com.au">&lt;info@dbnet.com.au&gt;</a> -- FRANKC<br />
2143. Frank Carroll  <a href="mailto:frank@carroll.tv">&lt;frank@carroll.tv&gt;</a> -- CARROLL<br />
2144. Frank Cizmich  <a href="mailto:gato_negro_9@yahoo.com">&lt;gato_negro_9@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANKMAN">FRANKMAN</a><br />

2145. Frank Cox  <a href="mailto:frank.l.cox@gmail.com">&lt;frank.l.cox@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRANKCOX">FRANKCOX</a><br />
2146. Frank Dupont  <a href="mailto:biker_cpan@hotmail.com">&lt;biker_cpan@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIKER">BIKER</a><br />
2147. Frank Förster  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GFIREBALL<br />

2148. <a href="http://fgerlach.com">Frank Gerlach</a>  <a href="mailto:frankgerlach@gmail.com">&lt;frankgerlach@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FG/FGERLACH">FGERLACH</a><br />
2149. Frank Grieshaber  <a href="mailto:wenamun@freenet.de">&lt;wenamun@freenet.de&gt;</a> -- WENAMUN<br />
2150. Frank Gutierrez  <a href="mailto:">&lt;&gt;</a> -- FRANKG<br />

2151. <a href="http://www.xpix.de">Frank Herrmann</a>  <a href="mailto:xpix@netzwert.ag">&lt;xpix@netzwert.ag&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XP/XPIX">XPIX</a><br />
2152. <a href="http://www.rmi.net/~fholtry">Frank Holtry</a>  <a href="mailto:fholtry@lucent.com">&lt;fholtry@lucent.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FH/FHOLTRY">FHOLTRY</a><br />
2153. <a href="http://www.ns.array.ca/~frank">Frank Ian Smith</a>  <a href="mailto:frank@ns.array.ca">&lt;frank@ns.array.ca&gt;</a> -- FIS<br />

2154. Frank J Wojcik  <a href="mailto:fwojcik+cpan@besh.com">&lt;fwojcik+cpan@besh.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FW/FWOJCIK">FWOJCIK</a><br />
2155. <a href="http://www.neverending.org/~ftobin/">Frank J. Tobin</a>  <a href="mailto:ftobin@cpan.org">&lt;ftobin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FT/FTOBIN">FTOBIN</a><br />
2156. Frank Koenen  <a href="mailto:fkoenen@vonworld.com">&lt;fkoenen@vonworld.com&gt;</a> -- FKOENEN<br />

2157. <a href="http://www.fseitz.de/">Frank Seitz</a>  <a href="mailto:cpan [at] fseitz [dot] de">&lt;cpan [at] fseitz [dot] de&gt;</a> -- FSEITZ<br />
2158. Frank Speiser  <a href="mailto:">&lt;&gt;</a> -- FSPEISER<br />
2159. <a href="http://www.wiles.org/">Frank Wiles</a>  <a href="mailto:frank@wiles.org">&lt;frank@wiles.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FW/FWILES">FWILES</a><br />

2160. <a href="www.frazi.de">Frank Zimmer</a>  <a href="mailto:cpan@frazi.de">&lt;cpan@frazi.de&gt;</a> -- FRAZI<br />
2161. <a href="http://www.smbc.de">Frank-Peter Reich</a>  <a href="mailto:fpreich@cpan.org">&lt;fpreich@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FP/FPREICH">FPREICH</a><br />
2162. <a href="www.studiobondurri.net">Franz Bond</a>  <a href="mailto:info@studiobondrri.net">&lt;info@studiobondrri.net&gt;</a> -- STUDIOB<br />

2163. Franz Prilmeier  <a href="mailto:prilmeie@acm.org">&lt;prilmeie@acm.org&gt;</a> -- PRILMEIE<br />
2164. Franz Schaefer  <a href="mailto:schaefer@mond.at">&lt;schaefer@mond.at&gt;</a> -- MOND<br />
2165. François Fauteux  <a href="mailto:ffauteux@cpan.org">&lt;ffauteux@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FF/FFAUTEUX">FFAUTEUX</a><br />
2166. <a href="http://www.nexus-is.ca">François Machabée</a>  <a href="mailto:info@nexus-is.ca">&lt;info@nexus-is.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FM/FMACHABEE">FMACHABEE</a><br />

2167. Frazer Irving  <a href="mailto:SPAM@clumsyjedi.com">&lt;SPAM@clumsyjedi.com&gt;</a> -- CLMSYJEDI<br />
2168. Fred Condo  <a href="mailto:cpan@condo.chico.ca.us">&lt;cpan@condo.chico.ca.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FJ/FJC">FJC</a><br />
2169. <a href="http://f2.org/fred/">Fred Curtis</a>  <a href="mailto:fred@f2.org">&lt;fred@f2.org&gt;</a> -- FRED<br />

2170. <a href="http://www.redhotpenguin.com">Fred Moyer</a>  <a href="mailto:fred@redhotpenguin.com">&lt;fred@redhotpenguin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHRED">PHRED</a><br />
2171. <a href="http://www.anydata.co.uk/">Fred Youhanaie</a>  <a href="mailto:fredy@cpan.org">&lt;fredy@cpan.org&gt;</a> -- FREDY<br />
2172. <a href="http://fvue.nl">Freddy Vulto</a>  <a href="mailto:fvulto@gmail.com">&lt;fvulto@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FV/FVULTO">FVULTO</a><br />

2173. Frederic Chauveau  <a href="mailto:fmc@pasteur.fr">&lt;fmc@pasteur.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FM/FMC">FMC</a><br />
2174. Frederic Soriano  <a href="mailto:fsoriano@cpan.org">&lt;fsoriano@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FS/FSORIANO">FSORIANO</a><br />
2175. <a href="http://www.opengroup.org/~fjh/">Frederick Hirsch</a>  <a href="mailto:fjh@alum.mit.edu">&lt;fjh@alum.mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FJ/FJH">FJH</a><br />

2176. <a href="http://fred.eti.br">Frederico Recsky</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RECSKY<br />
2177. Frederik Ramm  <a href="mailto:frederik@remote.org">&lt;frederik@remote.org&gt;</a> -- FRAMM<br />
2178. Frey Kuo  <a href="mailto:frey@engineer.com">&lt;frey@engineer.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FK/FKUO">FKUO</a><br />

2179. Fritz Mehner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEHNER">MEHNER</a><br />
2180. <a href="http://www.fbriere.net">Frédéric Brière</a>  <a href="mailto:fbriere@fbriere.net">&lt;fbriere@fbriere.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FB/FBRIERE">FBRIERE</a><br />
2181. <a href="http://www.gam3.net/">G. Allen Morris III</a>  <a href="mailto:gam3-pause@gam3.net">&lt;gam3-pause@gam3.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAM">GAM</a><br />

2182. <a href="http://www.anomaly.org/wade/">G. Wade Johnson</a>  <a href="mailto:wade@anomaly.org">&lt;wade@anomaly.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWADEJ">GWADEJ</a><br />
2183. GNU too  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GN/GNUTOO">GNUTOO</a><br />
2184. <a href="http://sgrommier.free.fr/perl">GROMMIER Sébastien</a>  <a href="mailto:sgrommier@free.fr">&lt;sgrommier@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GROMMIER">GROMMIER</a><br />

2185. GUNYARA-KUN  <a href="mailto:gunya@cpan.org">&lt;gunya@cpan.org&gt;</a> -- GUNYA<br />
2186. <a href="http://www.forum2.org/gaal/">Gaal Yahas</a>  <a href="mailto:gaal@forum2.org">&lt;gaal@forum2.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAAL">GAAL</a><br />
2187. <a href="http://n.ethz.ch/student/cselleg/">Gabor Cselle</a>  <a href="mailto:gaborcselle@yahoo.de">&lt;gaborcselle@yahoo.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CS/CSELLEG">CSELLEG</a><br />

2188. <a href="http://www.chwhat.com">Gabriel Horner</a>  <a href="mailto:cldwalker@chwhat.com">&lt;cldwalker@chwhat.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOZO">BOZO</a><br />
2189. Gabriel Millerd  <a href="mailto:gmillerd@gmail.com">&lt;gmillerd@gmail.com&gt;</a> -- GMILLERD<br />
2190. Gabriele Mambrini  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GMAMBRO<br />

2191. Gaby Vanhegan  <a href="mailto:gaby@vanhegan.com">&lt;gaby@vanhegan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GABY">GABY</a><br />
2192. <a href="http://galencharlton.com/">Galen Charlton</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GMCHARLT<br />
2193. Gareth D. Rees  <a href="mailto:garethr@cre.canon.co.uk">&lt;garethr@cre.canon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GD/GDR">GDR</a><br />

2194. <a href="http://www.thermeoneurope.com">Gareth Kirwan</a>  <a href="mailto:gbjk@thermeoneurope.com">&lt;gbjk@thermeoneurope.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBJK">GBJK</a><br />
2195. Garrett D'Amore  <a href="mailto:garrett@yavin.org">&lt;garrett@yavin.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GD/GDAMORE">GDAMORE</a><br />
2196. <a href="http://asdf.blogs.com/">Garrett Rooney</a>  <a href="mailto:rooneg@electricjellyfish.net">&lt;rooneg@electricjellyfish.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROONEG">ROONEG</a><br />

2197. Garth Douglass  <a href="mailto:garth@rubberband.org">&lt;garth@rubberband.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARTHD">GARTHD</a><br />
2198. Garth Sainio  <a href="mailto:gsainio@gmail.com">&lt;gsainio@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSAINIO">GSAINIO</a><br />
2199. <a href="http://www.perijove.com">Garth Winter Webb</a>  <a href="mailto:garth@perijove.com">&lt;garth@perijove.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARTH">GARTH</a><br />

2200. Gary Algier  <a href="mailto:gaa@ulticom.com">&lt;gaa@ulticom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GALGIER">GALGIER</a><br />
2201. Gary Ashton-Jones  <a href="mailto:gary@ashton-jones.com.au">&lt;gary@ashton-jones.com.au&gt;</a> -- GARYAJ<br />
2202. Gary Gurevich  <a href="mailto:garygurevich at gmail">&lt;garygurevich at gmail&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGUREVICH">GGUREVICH</a><br />

2203. <a href="http://lnc.usc.edu/~holt/">Gary Holt</a>  <a href="mailto:holt-pause@gholt.net">&lt;holt-pause@gholt.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLT">HOLT</a><br />
2204. <a href="http://www.systemics.com/">Gary Howland</a>  <a href="mailto:gary@hotlava.com">&lt;gary@hotlava.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARY">GARY</a><br />
2205. Gary Jackson  <a href="mailto:bargle@umiacs.umd.edu">&lt;bargle@umiacs.umd.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARGLE">BARGLE</a><br />

2206. Gary Kennedy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GARYK<br />
2207. Gary Puckering  <a href="mailto:jgpuckering@rogers.com">&lt;jgpuckering@rogers.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PU/PUCKERING">PUCKERING</a><br />
2208. Gary Richardson  <a href="mailto:gary.richardson@marketingtips.com">&lt;gary.richardson@marketingtips.com&gt;</a> -- GRICH<br />
2209. <a href="http://www.codejester.net/">Gary Samson</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SAMSON<br />

2210. <a href="http://engr.georgefox.edu">Gary Spivey</a>  <a href="mailto:spivey@ieee.org">&lt;spivey@ieee.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSPIVEY">GSPIVEY</a><br />
2211. <a href="www.gauravkumar.org">Gaurav Kumar</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GAURAVK<br />
2212. <a href="http://www.ggvaidya.com/">Gaurav Vaidya</a>  <a href="mailto:gaurav@cpan.org">&lt;gaurav@cpan.org&gt;</a> -- GAURAV<br />

2213. <a href="http://brock-family.org/gavin">Gavin Brock</a>  <a href="mailto:gbrock@cpan.org">&lt;gbrock@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBROCK">GBROCK</a><br />
2214. <a href="http://jodrell.net/">Gavin Brown</a>  <a href="mailto:gbrown@cpan.org">&lt;gbrown@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBROWN">GBROWN</a><br />
2215. <a href="http://www.openfusion.net/">Gavin Carr</a>  <a href="mailto:gavin@openfusion.com.au">&lt;gavin@openfusion.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAVINC">GAVINC</a><br />

2216. <a href="http://www.estey.com">Gavin Estey</a>  <a href="mailto:gav@japh.org">&lt;gav@japh.org&gt;</a> -- GAV<br />
2217. <a href="http://www.suretecsystems.com">Gavin Henry</a>  <a href="mailto:ghenry@perl.me.uk">&lt;ghenry@perl.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GH/GHENRY">GHENRY</a><br />
2218. <a href="www.minitutorials.com">Gavin McDonald</a>  <a href="mailto:brightoncomputers@&lt;nospam&gt;.brightontown.com.au">&lt;brightoncomputers@&lt;nospam&gt;.brightontown.com.au&gt;</a> -- GAVIN<br />

2219. <a href="http://www.kodekoan.com">Gavin Mogan</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HALKEYE<br />
2220. <a href="http://genetics.stanford.edu/~sherlock">Gavin Sherlock</a>  <a href="mailto:sherlock@genome.stanford.edu">&lt;sherlock@genome.stanford.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHERLOCK">SHERLOCK</a><br />
2221. Gawdi Azem  <a href="mailto:cpan@azem.de">&lt;cpan@azem.de&gt;</a> -- AZEMGI<br />

2222. Ge Peng  <a href="mailto:tigerpeng2001@yahoo.com">&lt;tigerpeng2001@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIGERPERL">TIGERPERL</a><br />
2223. <a href="http://blog.gslin.org/">Gea-Suan Lin</a>  <a href="mailto:gslin@cpan.org">&lt;gslin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSLIN">GSLIN</a><br />
2224. <a href="http://www.dba-village.com">Geert De Paep</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PIER<br />

2225. <a href="http://www.sci.kun.nl/sigma/Persoonlijk/egonw/xslt/">Geert Josten</a>  <a href="mailto:gjosten@sci.kun.nl">&lt;gjosten@sci.kun.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSTEN">JOSTEN</a><br />
2226. <a href="http://ology.net/">Gene Boggs</a>  <a href="mailto:gene@cpan.org">&lt;gene@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GENE">GENE</a><br />
2227. <a href="http://www.smalltime.com">Gene Cutler</a>  <a href="mailto:gene_perl@smalltime.com">&lt;gene_perl@smalltime.com&gt;</a> -- GENEPERL<br />

2228. Gene Cutler  <a href="mailto:gene_perl@smalltime.com">&lt;gene_perl@smalltime.com&gt;</a> -- GENECUT<br />
2229. Gene Gallistel  <a href="mailto:gravalo@uwm.edu">&lt;gravalo@uwm.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAVALO">GRAVALO</a><br />
2230. <a href="http://home.xnet.com/~selkovjr/ElectricArc/">Gene Selkov, Jr.</a>  <a href="mailto:selkovjr@mcs.anl.gov">&lt;selkovjr@mcs.anl.gov&gt;</a> -- SELKOVJR<br />

2231. Gene Spafford  <a href="mailto:spaf@cs.purdue.edu">&lt;spaf@cs.purdue.edu&gt;</a> -- GSPAF<br />
2232. Gene Sullivan  <a href="mailto:gsullivan@cpan.org">&lt;gsullivan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSULLIVAN">GSULLIVAN</a><br />
2233. Genji Schmeder  <a href="mailto:genji@jps.net">&lt;genji@jps.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GENJISCH">GENJISCH</a><br />

2234. <a href="http://www.vizdom.com/">Gennis Emerson</a>  <a href="mailto:gemerson@vizdom.com">&lt;gemerson@vizdom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VIZDOM">VIZDOM</a><br />
2235. <a href="http://experts-exchange.com/M_349686.html">Geo Tiger</a>  <a href="mailto:geotiger2001@yahoo.com">&lt;geotiger2001@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEOTIGER">GEOTIGER</a><br />
2236. Geoff Cant  <a href="mailto:nem@rep.ly.net.nz">&lt;nem@rep.ly.net.nz&gt;</a> -- ARCHAELUS<br />

2237. <a href="www.hiivesystems.com">Geoff McQueen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GMCQUEEN<br />
2238. <a href="http://www.laxan.com/">Geoff Richards</a>  <a href="mailto:geoff@laxan.com">&lt;geoff@laxan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEOFFR">GEOFFR</a><br />
2239. Geoff Russell  <a href="mailto:geoff@austrics.com.au">&lt;geoff@austrics.com.au&gt;</a> -- GJRUSSEL<br />

2240. Geoff Simmons  <a href="mailto:gsimmons@cpan.org">&lt;gsimmons@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSIMMONS">GSIMMONS</a><br />
2241. Geoffrey Broadwell  <a href="mailto:habusan2@sprynet.com">&lt;habusan2@sprynet.com&gt;</a> -- GJB<br />
2242. Geoffrey Gallaway  <a href="mailto:pause@geoffeg.org">&lt;pause@geoffeg.org&gt;</a> -- GEOFFEG<br />
2243. <a href="http://geoffhutchison.net/">Geoffrey Hutchison</a>  <a href="mailto:perl@geoffhutchison.net">&lt;perl@geoffhutchison.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GH/GHUTCHIS">GHUTCHIS</a><br />

2244. Geoffrey Leach  <a href="mailto:geoff@hughes.net">&lt;geoff@hughes.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLEACH">GLEACH</a><br />
2245. Geoffrey Rommel  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GROMMEL">GROMMEL</a><br />
2246. <a href="http://www.geoffreyspear.com/">Geoffrey Spear</a>  <a href="mailto:gspear@cpan.org">&lt;gspear@cpan.org&gt;</a> -- GSPEAR<br />

2247. Geoffrey Young  <a href="mailto:geoff@cpan.org">&lt;geoff@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEOFF">GEOFF</a><br />
2248. <a href="http:://www.westfalen.de/hugo/">Georg Bauer</a>  <a href="mailto:gb@hugo.westfalen.de">&lt;gb@hugo.westfalen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBAUER">GBAUER</a><br />
2249. Georg Moritz  <a href="mailto:gm@cruft.de">&lt;gm@cruft.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHMEM">SHMEM</a><br />

2250. <a href="http://www.gaf3.com/">George A. Fitch III</a>  <a href="mailto:gaf3@gaf3.com">&lt;gaf3@gaf3.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAFFER">GAFFER</a><br />
2251. <a href="http://www.tifaware.com/">George A. Theall</a>  <a href="mailto:theall@tifaware.com">&lt;theall@tifaware.com&gt;</a> -- GTHEALL<br />
2252. <a href="http://www.verisign.com/">George Campbell</a>  <a href="mailto:gcampbell-at-verisign-dot-com">&lt;gcampbell-at-verisign-dot-com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GC/GCAMPBELL">GCAMPBELL</a><br />

2253. George Chlipala  <a href="mailto:chips underscore g at ameritech dot net">&lt;chips underscore g at ameritech dot net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHLIGE">CHLIGE</a><br />
2254. George D. Gal  <a href="mailto:george@vsecurity.com">&lt;george@vsecurity.com&gt;</a> -- GGAL<br />
2255. <a href="http://agl.indrasweb.com/html/">George E Worroll Jr</a>  <a href="mailto:geworrolljr@optonline.net">&lt;geworrolljr@optonline.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWORROLL">GWORROLL</a><br />

2256. George Hartzell  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HARTZELL">HARTZELL</a><br />
2257. George J. Nazarey Jr.  <a href="mailto:gnazarey@naz.com">&lt;gnazarey@naz.com&gt;</a> -- GNAZAREY<br />
2258. George Kevin Hathorn  <a href="mailto:geokevhat@cpan.org">&lt;geokevhat@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEOKEVHAT">GEOKEVHAT</a><br />

2259. <a href="http://www.nistorica.ro">George Nistorică</a>  <a href="mailto:george@upg-ploiesti.ro">&lt;george@upg-ploiesti.ro&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UL/ULTRADM">ULTRADM</a><br />
2260. <a href="www.xorgate.com">George Sanderson</a>  <a href="mailto:Perler@Xorgate.com">&lt;Perler@Xorgate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANDERSON">SANDERSON</a><br />
2261. <a href="http://www.omniti.com/~george/">George Schlossnagle</a>  <a href="mailto:george@omniti.com">&lt;george@omniti.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSCHLOSS">GSCHLOSS</a><br />

2262. <a href="http://fluxoid.ru/">George Yashin</a>  <a href="mailto:fluxoid@cpan.org">&lt;fluxoid@cpan.org&gt;</a> -- FLUXOID<br />
2263. Gerad Welch  <a href="mailto:welch.119@osu.edu">&lt;welch.119@osu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWELCH">GWELCH</a><br />
2264. <a href="http://www.channelping.com/">Gerald Gold</a>  <a href="mailto:gold@channelping.com">&lt;gold@channelping.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOLD">GOLD</a><br />

2265. <a href="http://perl.apache.org/embperl/">Gerald Richter</a>  <a href="mailto:richter@ecos.de">&lt;richter@ecos.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRICHTER">GRICHTER</a><br />
2266. <a href="http://www.ctron.com/~hickey">Gerard Hickey</a>  <a href="mailto:hickey@ctron.com">&lt;hickey@ctron.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEHIC">GEHIC</a><br />
2267. <a href="http://www.infoflex.com/">Gerard Menicucci</a>  <a href="mailto:gerard@infoflex.com">&lt;gerard@infoflex.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INFOFLEX">INFOFLEX</a><br />

2268. Gerd Knops  <a href="mailto:gerti@BITart.com">&lt;gerti@BITart.com&gt;</a> -- GKNOPS<br />
2269. Gerda Shank  <a href="mailto:gshank@cpan.org">&lt;gshank@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSHANK">GSHANK</a><br />
2270. <a href="http://bonehunter.rulez.org/">Gergely Nagy</a>  <a href="mailto:algernon@bonehunter.rulez.org">&lt;algernon@bonehunter.rulez.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALGERNON">ALGERNON</a><br />

2271. Gerhard Gonter  <a href="mailto:g.gonter@ieee.org">&lt;g.gonter@ieee.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGONTER">GGONTER</a><br />
2272. Gerhard Gossen  <a href="mailto:gerhard@cpan.org">&lt;gerhard@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GERHARD">GERHARD</a><br />
2273. <a href="www.gs68.de">Gerhard Spitzlsperger</a>  <a href="mailto:gerhard.spitzlsperger@gs68.de">&lt;gerhard.spitzlsperger@gs68.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSPI">GSPI</a><br />

2274. Germain Garand  <a href="mailto:germain@ebooksfrance.com">&lt;germain@ebooksfrance.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGARAND">GGARAND</a><br />
2275. <a href="http://havranek.at/gernot/">Gernot Havranek</a>  <a href="mailto:gernot@havranek.at">&lt;gernot@havranek.at&gt;</a> -- HAVI<br />
2276. Gerrit P. Haase  <a href="mailto:gerrit@cpan.org">&lt;gerrit@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GERRIT">GERRIT</a><br />

2277. <a href="http://www.leanox.com">Gerry  Lawrence</a>  <a href="mailto:gwlperl@gmail.com">&lt;gwlperl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWL">GWL</a><br />
2278. Gert Burger  <a href="mailto:gburger@cs.up.ac.za">&lt;gburger@cs.up.ac.za&gt;</a> -- GBURGER<br />
2279. <a href="http://www.nightmedia.net/">Gheorghe Chesler</a>  <a href="mailto:office@nightmedia.net">&lt;office@nightmedia.net&gt;</a> -- GEORG<br />

2280. Giacomo Cerrai  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GC/GCERRAI">GCERRAI</a><br />
2281. <a href="www.meocci.it">Gian Lorenzo Meocci</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GLMEOCCI<br />
2282. Gian Maria Gamboni  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMG">GMG</a><br />

2283. <a href="http://www.thenautilus.net/">Gianni Ceccarelli</a>  <a href="mailto:dakkar@thenautilus.net">&lt;dakkar@thenautilus.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAKKAR">DAKKAR</a><br />
2284. <a href="http://www.gidon.com/">Gidon Wise</a>  <a href="mailto:perl@gidon.com">&lt;perl@gidon.com&gt;</a> -- GIDON<br />
2285. Gifford Birchley  <a href="mailto:gifford@devnik.com">&lt;gifford@devnik.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRB">GRB</a><br />

2286. <a href="http://www.producto-valvo.com">Gil Cohen</a>  <a href="mailto:gcohen@producto-valvo.com">&lt;gcohen@producto-valvo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GC/GCOHEN">GCOHEN</a><br />
2287. <a href="http://www.exit109.com/~ghealton/">Gilbert Healton</a>  <a href="mailto:gilbert@healton.net">&lt;gilbert@healton.net&gt;</a> -- GHEALTON<br />
2288. <a href="http://www.shebang.nl/">Gilion Goudsmit</a>  <a href="mailto:cpan@shebang.nl">&lt;cpan@shebang.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGOUDSMIT">GGOUDSMIT</a><br />

2289. <a href="http://www.ungi.net/">Gilles Maire</a>  <a href="mailto:Gilles.Maire@ungi.net">&lt;Gilles.Maire@ungi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAIRE">MAIRE</a><br />
2290. Gilles POLART-DONAT  <a href="mailto:gpolart@free.fr">&lt;gpolart@free.fr&gt;</a> -- GPOLART<br />
2291. <a href="http://storulis.ten.lt">Gintaras Raslanas</a>  <a href="mailto:storulis@takas.lt">&lt;storulis@takas.lt&gt;</a> -- STORULIS<br />

2292. Giovanni S Marzot  <a href="mailto:marz@users.sourceforge.net">&lt;marz@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSM">GSM</a><br />
2293. Girish Venkatachalam  <a href="mailto:girish1729@yahoo.com">&lt;girish1729@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VG/VGIRISH">VGIRISH</a><br />
2294. Gisbert W. Selke  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GWS<br />

2295. <a href="http://gisle.aas.no">Gisle Aas</a>  <a href="mailto:gisle@ActiveState.com">&lt;gisle@ActiveState.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAAS">GAAS</a><br />
2296. <a href="http://mamatux.dk">Gitte Wange Olrik</a>  <a href="mailto:mamatux@cpan.org">&lt;mamatux@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAMATUX">MAMATUX</a><br />
2297. <a href="http://www.giuliomotta.com/">Giulio Motta</a>  <a href="mailto:giulienk@cpan.org">&lt;giulienk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GIULIENK">GIULIENK</a><br />

2298. <a href="http://www.pigmalion.info">Giuseppe De Sio</a>  <a href="mailto:dev@pigmalion.info">&lt;dev@pigmalion.info&gt;</a> -- PIGMALION<br />
2299. Giuseppe Maxia  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMAX">GMAX</a><br />
2300. <a href="http://maniwheel.elnet.ru">Gleb Galkin</a>  <a href="mailto:maniwheel@elnet.ru">&lt;maniwheel@elnet.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANIWHEEL">MANIWHEEL</a><br />

2301. Glen Small  <a href="mailto:perl.dev@cyberex.org.uk">&lt;perl.dev@cyberex.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLENSMALL">GLENSMALL</a><br />
2302. Glenn E. Bailey III  <a href="mailto:aaazhyd@yahoo.com">&lt;aaazhyd@yahoo.com&gt;</a> -- GBAILEY<br />
2303. Glenn Fowler  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CEBJYRE<br />
2304. <a href="http://nevcal.com/">Glenn Linderman</a>  <a href="mailto:perl@nevcal.com">&lt;perl@nevcal.com&gt;</a> -- GURUGLENN<br />

2305. <a href="http://www.gmlewis.com">Glenn M. Lewis</a>  <a href="mailto:glenn@gmlewis.com">&lt;glenn@gmlewis.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMLEWIS">GMLEWIS</a><br />
2306. Glenn Wood  <a href="mailto:glenwood@alumni.caltech.edu">&lt;glenwood@alumni.caltech.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLENNWOOD">GLENNWOOD</a><br />
2307. <a href="http://www.unixcoder.org">Gligor Daniel Marius</a>  <a href="mailto:unixmarius@gmail.com">&lt;unixmarius@gmail.com&gt;</a> -- MOSSAD<br />

2308. <a href="http://geniek.net">Goldin Evgeny</a>  <a href="mailto:geniek@netvision.net.il">&lt;geniek@netvision.net.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GENIE">GENIE</a><br />
2309. Gonzalo Barco  <a href="mailto:$_='gbarcouyxpublic@gmail.com'; tr/x/\./;">&lt;$_='gbarcouyxpublic@gmail.com'; tr/x/\./;&gt;</a> -- GBARCO<br />
2310. <a href="http://orniere-du-globe.net">Gonéri LE BOUDER</a>  <a href="mailto:goneri@rulezlan.org">&lt;goneri@rulezlan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GONERI">GONERI</a><br />

2311. Gordon Dewis  <a href="mailto:gordon@pinetree.org">&lt;gordon@pinetree.org&gt;</a> -- GDEWIS<br />
2312. <a href="http://www.spaceless.com">Gordon Fletcher</a>  <a href="mailto:gordon@spaceless.com">&lt;gordon@spaceless.com&gt;</a> -- GFLETCHER<br />
2313. <a href="http://fig.org/gord/">Gordon Matzigkeit</a>  <a href="mailto:gord@fig.org">&lt;gord@fig.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GORD">GORD</a><br />

2314. Gordon McCreight  <a href="mailto:cpan.to.gordon@mccreight.com">&lt;cpan.to.gordon@mccreight.com&gt;</a> -- GMCC<br />
2315. <a href="http://www.e-smith.org">Gordon Rowell</a>  <a href="mailto:bugs@e-smith.com">&lt;bugs@e-smith.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MITEL">MITEL</a><br />
2316. <a href="http://mizzy.org/">Gosuke Miyashita</a>  <a href="mailto:gosukenator@gmail.com">&lt;gosukenator@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIZZY">MIZZY</a><br />

2317. Gourav Sengupta  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GOURAV<br />
2318. <a href="http://www.virtuasites.com.br/">Graciliano Monteiro Passos</a>  <a href="mailto:gmpassos@cpan.org">&lt;gmpassos@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMPASSOS">GMPASSOS</a><br />
2319. <a href="http://www.pobox.com/~gbarr">Graham Barr</a>  <a href="mailto:gbarr@pobox.com">&lt;gbarr@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBARR">GBARR</a><br />

2320. Graham Crookham  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAHAMC">GRAHAMC</a><br />
2321. Graham Jenkins  <a href="mailto:grahjenk@hotmail.com">&lt;grahjenk@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAHJENK">GRAHJENK</a><br />
2322. Graham Seaman  <a href="mailto:graham@opencollector.org">&lt;graham@opencollector.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSEAMAN">GSEAMAN</a><br />

2323. Graham TerMarsch  <a href="mailto:cpan@howlingfrog.com">&lt;cpan@howlingfrog.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GT/GTERMARS">GTERMARS</a><br />
2324. Grant DeGraw  <a href="mailto:">&lt;&gt;</a> -- DEGRAW<br />
2325. <a href="http://www.grantgrueninger.com/">Grant Grueninger</a>  <a href="mailto:grantg@spamarrest.com">&lt;grantg@spamarrest.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRANTG">GRANTG</a><br />

2326. <a href="http://www.mclean.net.nz/">Grant McLean</a>  <a href="mailto:grantm@cpan.org">&lt;grantm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRANTM">GRANTM</a><br />
2327. Graydon Hoare  <a href="mailto:graydon@groveware.com">&lt;graydon@groveware.com&gt;</a> -- GHOARE<br />
2328. Greg Anderson  <a href="mailto:greg@ftp.netgate.net">&lt;greg@ftp.netgate.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAND">GAND</a><br />

2329. <a href="http://home.hiwaay.net/~gbacon/">Greg Bacon</a>  <a href="mailto:gbacon@hiwaay.net">&lt;gbacon@hiwaay.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBACON">GBACON</a><br />
2330. <a href="http://www.fuaim.com/cpan/">Greg Bossert</a>  <a href="mailto:bossert@fuaim.com">&lt;bossert@fuaim.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBOSS">GBOSS</a><br />
2331. Greg Coulombe  <a href="mailto:Greg.Coulombe@ualberta.ca">&lt;Greg.Coulombe@ualberta.ca&gt;</a> -- GCOULOMB<br />

2332. <a href="http://cken.chi.groogroo.com/">Greg Fast</a>  <a href="mailto:gdf@speakeasy.net">&lt;gdf@speakeasy.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GREGFAST">GREGFAST</a><br />
2333. Greg George  <a href="mailto:gng@cpan.org">&lt;gng@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GN/GNG">GNG</a><br />
2334. <a href="http://www.eod.com/">Greg Knauss</a>  <a href="mailto:greg@eod.com">&lt;greg@eod.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GK/GKNAUSS">GKNAUSS</a><br />

2335. <a href="http://www.greglondon.com">Greg London</a>  <a href="mailto:DELETEALLCAPSemail@greglondon.com">&lt;DELETEALLCAPSemail@greglondon.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSLONDON">GSLONDON</a><br />
2336. <a href="http://www.mccarroll.org.uk/~gem/">Greg McCarroll</a>  <a href="mailto:greg@mccarroll.org.uk">&lt;greg@mccarroll.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GM/GMCCAR">GMCCAR</a><br />
2337. <a href="http://www.caida.org/">Greg Raph</a>  <a href="mailto:graph@caida.org">&lt;graph@caida.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAIDAPERL">CAIDAPERL</a><br />

2338. Greg Sabino Mullane  <a href="mailto:greg@turnstep.com">&lt;greg@turnstep.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TU/TURNSTEP">TURNSTEP</a><br />
2339. <a href="http://starship.python.net/~gward/">Greg Ward</a>  <a href="mailto:gward@python.net">&lt;gward@python.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWARD">GWARD</a><br />
2340. <a href="www.empowermentconsulting.com">Gregary A. Hendricks</a>  <a href="mailto:gregaryh@gmail.com">&lt;gregaryh@gmail.com&gt;</a> -- GREGARYH<br />

2341. <a href="ftp://fruitfly.berkeley.edu/pub/bioTk/">Gregg Helt</a>  <a href="mailto:gregg@fruitfly.berkeley.edu">&lt;gregg@fruitfly.berkeley.edu&gt;</a> -- GREGG<br />
2342. Gregor Goldbach  <a href="mailto:ggoldbach@cpan.org">&lt;ggoldbach@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GG/GGOLDBACH">GGOLDBACH</a><br />
2343. <a href="http://www.blackangel.net/stigmata/">Gregor Mosheh</a>  <a href="mailto:stigmata@blackangel.net">&lt;stigmata@blackangel.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STIGMATA">STIGMATA</a><br />

2344. <a href="http://www.focusresearch.com/gregor/">Gregor N. Purdy</a>  <a href="mailto:gregor@focusresearch.com">&lt;gregor@focusresearch.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GREGOR">GREGOR</a><br />
2345. <a href="http://gregory.pp.ru">Gregory A. Rozanoff</a>  <a href="mailto:rozanoff@gmail.com">&lt;rozanoff@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GREGORY">GREGORY</a><br />
2346. <a href="http://chaoticset.perlmonk.org/">Gregory Baumgardner</a>  <a href="mailto:orderedra@javamonk.org (except it's chaoticset and perl)">&lt;orderedra@javamonk.org (except it's chaoticset and perl)&gt;</a> -- CHAOTIC<br />

2347. <a href="www.webzavod.ru">Gregory Belenky</a>  <a href="mailto:greg@webzavod.ru">&lt;greg@webzavod.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRISHACE">GRISHACE</a><br />
2348. <a href="http://gregoryclass.com">Gregory Class</a>  <a href="mailto:gclass@gregoryclass.com">&lt;gclass@gregoryclass.com&gt;</a> -- GCLASS<br />
2349. Gregory Jones  <a href="mailto:grjones@cpan.org">&lt;grjones@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRJONES">GRJONES</a><br />

2350. Gregory N Best Olszewski  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GNO<br />
2351. <a href="http://www.tcscs.com">Gregory S. Youngblood</a>  <a href="mailto:zeta@cpan.org">&lt;zeta@cpan.org&gt;</a> -- ZETA<br />
2352. <a href="http://www.planetmind.net">Gregory W. Willson</a>  <a href="mailto:greg@planetmind.net">&lt;greg@planetmind.net&gt;</a> -- PLANET<br />

2353. <a href="http://kasei.us/">Gregory Williams</a>  <a href="mailto:gwilliams@cpan.org">&lt;gwilliams@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWILLIAMS">GWILLIAMS</a><br />
2354. <a href="www.gregorytoomey.com">Gregoty Toomey</a>  <a href="mailto:gmtoomey@gregorytoomey.com">&lt;gmtoomey@gregorytoomey.com&gt;</a> -- GREGT<br />
2355. Grei Zhang  <a href="mailto:greijohn@yahoo.com.cn">&lt;greijohn@yahoo.com.cn&gt;</a> -- GREIZHANG<br />

2356. <a href="http://gryphonshafer.com">Gryphon Shafer</a>  <a href="mailto:gryphon@cpan.org">&lt;gryphon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRYPHON">GRYPHON</a><br />
2357. Grégory Vanuxem  <a href="mailto:vanuxemg@yahoo.fr">&lt;vanuxemg@yahoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELLIPSE">ELLIPSE</a><br />
2358. Guardian Media Group Regional Digital  <a href="mailto:webmaster@gmgrd.co.uk">&lt;webmaster@gmgrd.co.uk&gt;</a> -- GMGRD<br />

2359. <a href="http://perldev.leader.it/">Guido Brugnara</a>  <a href="mailto:gdo@perldev.leader.it">&lt;gdo@perldev.leader.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUGNARA">BRUGNARA</a><br />
2360. Guido Carls  <a href="mailto:gcarls@cpan.org">&lt;gcarls@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GC/GCARLS">GCARLS</a><br />
2361. Guido Flohr  <a href="mailto:gufl0000@stud.uni-sb.de">&lt;gufl0000@stud.uni-sb.de&gt;</a> -- GFLOHR<br />

2362. <a href="http://www.imperia.net/">Guido Flohr</a>  <a href="mailto:guido@imperia.net">&lt;guido@imperia.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GUIDO">GUIDO</a><br />
2363. <a href="http://tuxgraphics.org/~guido/">Guido Socher</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GUS">GUS</a><br />
2364. <a href="http://guillaume.filion.org/">Guillaume Filion</a>  <a href="mailto:guillaume@filion.org">&lt;guillaume@filion.org&gt;</a> -- GFK<br />

2365. Guillaume Fougnies  <a href="mailto:guillaume@eulerian.com">&lt;guillaume@eulerian.com&gt;</a> -- GUILLAUME<br />
2366. <a href="http://www.zarb.org/~guillomovitch">Guillaume Rousse</a>  <a href="mailto:grousse@cpan.org">&lt;grousse@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GROUSSE">GROUSSE</a><br />
2367. <a href="http://www.sabouraud.net">Guillaume SABOURAUD</a>  <a href="mailto:gsa@cpan.org">&lt;gsa@cpan.org&gt;</a> -- GSA<br />

2368. <a href="http://groditi.vox.com/">Guillermo Roditi</a>  <a href="mailto:groditi@gmail.com">&lt;groditi@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRODITI">GRODITI</a><br />
2369. Gulin Mikhail  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SIGIZ<br />
2370. <a href="http://www-rcf.usc.edu/~gully">Gully APC Burns</a>  <a href="mailto:GullyAPCBurns@yahoo.com">&lt;GullyAPCBurns@yahoo.com&gt;</a> -- GULLY<br />

2371. <a href="http://www.gunnar.cc/">Gunnar Hjalmarsson</a>  <a href="mailto:cpan@gunnar.cc">&lt;cpan@gunnar.cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GUNNAR">GUNNAR</a><br />
2372. Gunnar Strand  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GUSTRA<br />
2373. <a href="http://www.gwolf.org">Gunnar Wolf</a>  <a href="mailto:gwolf@gwolf.org">&lt;gwolf@gwolf.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWOLF">GWOLF</a><br />

2374. <a href="http://www.extropia.com/">Gunther Birznieks</a>  <a href="mailto:gunther@extropia.com">&lt;gunther@extropia.com&gt;</a> -- GUNTHER<br />
2375. <a href="http://www.xsrv.net/oss">Gunther Voet</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILDCHILD">WILDCHILD</a><br />
2376. <a href="ftp://ftp.linux.activestate.com/pub/staff/gsar/">Gurusamy Sarathy</a>  <a href="mailto:gsar@cpan.org">&lt;gsar@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GS/GSAR">GSAR</a><br />

2377. Gustaf Bjorksten  <a href="mailto:gustaf@cmetech.com.au">&lt;gustaf@cmetech.com.au&gt;</a> -- FOOBARD<br />
2378. <a href="http://ek.dk/">Gustav Kristoffer Ek</a>  <a href="mailto:stoffer@netcetera.dk">&lt;stoffer@netcetera.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GK/GKE">GKE</a><br />
2379. <a href="http://www.schaffter.com/">Gustav Schaffter</a>  <a href="mailto:schaffter_cpan@hotmail.com">&lt;schaffter_cpan@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHAFFTER">SCHAFFTER</a><br />

2380. <a href="http://blog.gnustavo.com/">Gustavo Leite de Mendonça Chaves</a>  <a href="mailto:gnustavo@cpan.org">&lt;gnustavo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GN/GNUSTAVO">GNUSTAVO</a><br />
2381. <a href="http://mombe.org/">Guy Antony Halse</a>  <a href="mailto:ghalse@cpan.org">&lt;ghalse@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GH/GHALSE">GHALSE</a><br />
2382. Guy Davies  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GDAV<br />

2383. Guy Decoux  <a href="mailto:decoux@moulon.inra.fr">&lt;decoux@moulon.inra.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GUYDX">GUYDX</a><br />
2384. <a href="http://archive.ast.cam.ac.uk/">Guy Rixon</a>  <a href="mailto:gtr@ast.cam.ac.uk">&lt;gtr@ast.cam.ac.uk&gt;</a> -- GRIXON<br />
2385. Guy W. Hulbert  <a href="mailto:">&lt;&gt;</a> -- GWHULBERT<br />

2386. Guy Williams  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WILLIAMSG<br />
2387. Gyan Kapur  <a href="mailto:gkapur@myrealbox.com">&lt;gkapur@myrealbox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GK/GKAPUR">GKAPUR</a><br />
2388. <a href="http://www.praxis-sw.com/">Gyepi Sam</a>  <a href="mailto:gyepi@cpan.org">&lt;gyepi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GY/GYEPI">GYEPI</a><br />

2389. <a href="http://www.vmunix.com/~gabor/">Gábor Egressy</a>  <a href="mailto:gabor@vmunix.com">&lt;gabor@vmunix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GABOR">GABOR</a><br />
2390. <a href="http://kirra.net/">Göran Thyni</a>  <a href="mailto:goran@kirra.net">&lt;goran@kirra.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GT/GTHYNI">GTHYNI</a><br />
2391. <a href="http://windowsir.blogspot.com">H. Carvey</a>  <a href="mailto:keydet89@yahoo.com">&lt;keydet89@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HC/HCARVEY">HCARVEY</a><br />

2392. <a href="http://www.lunenburg.org/">H. Wade Minter</a>  <a href="mailto:minter@lunenburg.org">&lt;minter@lunenburg.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MINTER">MINTER</a><br />
2393. <a href="http://tux.nl">H.Merijn Brand</a>  <a href="mailto:h.m.brand@xs4all.nl">&lt;h.m.brand@xs4all.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HM/HMBRAND">HMBRAND</a><br />
2394. HAYASHI, Shinpei  <a href="mailto:shinpei@cpan.org">&lt;shinpei@cpan.org&gt;</a> -- SHINPEI<br />

2395. HBS Labs  <a href="mailto:hbslabs@cpan.org">&lt;hbslabs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HB/HBSLABS">HBSLABS</a><br />
2396. <a href="http://yasu.asuka.net/">HIRATA Yasuyuki</a>  <a href="mailto:yasu@asuka.net">&lt;yasu@asuka.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIRATA">HIRATA</a><br />
2397. <a href="http://d.hatena.ne.jp/hirose31/">HIROSE Masaaki</a>  <a href="mailto:hirose31@gmail.com">&lt;hirose31@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIROSE">HIROSE</a><br />

2398. Ha Quach  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LASTRONIN<br />
2399. <a href="http://www.macgyver.org/">Habeeb J. Dihu</a>  <a href="mailto:macgyver@tos.net">&lt;macgyver@tos.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MACGYVER">MACGYVER</a><br />
2400. Hack Sung Lee  <a href="mailto:hslee@ind.alcatel.com">&lt;hslee@ind.alcatel.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HS/HSLEE">HSLEE</a><br />

2401. <a href="http://www.imasy.or.jp/~ume/">Hajimu Umemoto</a>  <a href="mailto:ume@mahoroba.org">&lt;ume@mahoroba.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UM/UMEMOTO">UMEMOTO</a><br />
2402. <a href="http://hobbe.ub2.lu.se/~hakan/sig.html">Hakan Ardo</a>  <a href="mailto:hakan@debian.org">&lt;hakan@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAKANARDO">HAKANARDO</a><br />
2403. <a href="http://www.protechtraining.com">Hal F. Gottfried</a>  <a href="mailto:hgottfried@protechtraining.com">&lt;hgottfried@protechtraining.com&gt;</a> -- HGOTTFR<br />

2404. <a href="http://www.halssoftware.com/">Hal Finkel</a>  <a href="mailto:half@halssoftware.com">&lt;half@halssoftware.com&gt;</a> -- HFINKEL<br />
2405. Hal Pomeranz  <a href="mailto:pomeranz@netcom.com">&lt;pomeranz@netcom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HALPOM">HALPOM</a><br />
2406. Hangil Chang  <a href="mailto:hchang-tky@umin.ac.jp">&lt;hchang-tky@umin.ac.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANGIL">HANGIL</a><br />

2407. Hanno Mueller  <a href="mailto:hmueller@mail.kabel.de">&lt;hmueller@mail.kabel.de&gt;</a> -- HMUELLER<br />
2408. Hanno Stock  <a href="mailto:hanno.stock@gmx.net">&lt;hanno.stock@gmx.net&gt;</a> -- HANSTO<br />
2409. Hans A. Kestler  <a href="mailto:hans.kestler@uni-ulm.de">&lt;hans.kestler@uni-ulm.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAKESTLER">HAKESTLER</a><br />
2410. <a href="http://hdp.pobox.com/">Hans Dieter Pearcey</a>  <a href="mailto:hdp@cpan.org">&lt;hdp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HD/HDP">HDP</a><br />

2411. <a href="http://www.toneel.demon.nl/perl">Hans Jeuken</a>  <a href="mailto:haje@toneel.demon.nl">&lt;haje@toneel.demon.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANJE">HANJE</a><br />
2412. Hans Jorgen Helgesen  <a href="mailto:hans_helgesen@hotmail.com">&lt;hans_helgesen@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HJ/HJHELGE">HJHELGE</a><br />
2413. <a href="www.fruitsoft.de">Hans Müller</a>  <a href="mailto:perl@fruitsoft.de">&lt;perl@fruitsoft.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRUITSOFT">FRUITSOFT</a><br />

2414. <a href="http://www.oesterholt.net">Hans Oesterholt-Dijkema</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OE/OESTERHOL">OESTERHOL</a><br />
2415. <a href="http://hans.opensource.cl/">Hans Poo</a>  <a href="mailto:hans@opensource.cl">&lt;hans@opensource.cl&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANSPOO">HANSPOO</a><br />
2416. <a href="http://degraaff.org/">Hans de Graaff</a>  <a href="mailto:hans@degraaff.org">&lt;hans@degraaff.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJDG">JJDG</a><br />

2417. <a href="hanskohls.co.uk">Hans-Helmut Kohls</a>  <a href="mailto:hanshk@msn.com">&lt;hanshk@msn.com&gt;</a> -- HANSHK<br />
2418. <a href="www.pollux.franken.de">Hans-Juergen Beie</a>  <a href="mailto:hjb@pollux.franken.de">&lt;hjb@pollux.franken.de&gt;</a> -- HJB<br />
2419. Hans-Peter Werner  <a href="mailto:hp.werner@web.de">&lt;hp.werner@web.de&gt;</a> -- HPWERNER<br />

2420. <a href="http://purl.org/net/hansjoerg.pehofer/">Hansjörg Pehofer</a>  <a href="mailto:hansjoerg.pehofer@uibk.ac.at">&lt;hansjoerg.pehofer@uibk.ac.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZEYA">ZEYA</a><br />
2421. Harald Albers  <a href="mailto:albers@cpan.org">&lt;albers@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALBERS">ALBERS</a><br />
2422. Harald Bartel  <a href="mailto:harald.bartel@prozentor.de">&lt;harald.bartel@prozentor.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HB/HBARTEL">HBARTEL</a><br />

2423. Harald Mattern  <a href="mailto:webmaster@tsmweb.de">&lt;webmaster@tsmweb.de&gt;</a> -- HMATT<br />
2424. Haranatha B Movva  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HMOVVA<br />
2425. Hariharan Ragavendran  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HARIHARAN<br />
2426. <a href="http://mywebpages.comcast.net/nearthelimit">Harley Helterhoff</a>  <a href="mailto:nearthelimit@comcast.net">&lt;nearthelimit@comcast.net&gt;</a> -- WANKER<br />

2427. Harlin Hamilton  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HARLINH">HARLINH</a><br />
2428. Harlin L. Hamilton Jr.  <a href="mailto:harlinh@cadence.com">&lt;harlinh@cadence.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HL/HLHAMILT">HLHAMILT</a><br />
2429. <a href="http://my.mopilot.com/2knowme/">Harmonie Tara-Lynne Smith/Ramjewan</a>  <a href="mailto:aphunknbreak@aol.com">&lt;aphunknbreak@aol.com&gt;</a> -- HARMONIE<br />

2430. <a href="http://lanceerplaats.nl/PowerEdge/RAC/">Harold van Oostrom</a>  <a href="mailto:haoo@lanceerplaats.nl">&lt;haoo@lanceerplaats.nl&gt;</a> -- HAOO<br />
2431. <a href="http://www.hjackson.org">Harry Jackson</a>  <a href="mailto:harry@hjackson.org">&lt;harry@hjackson.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HARRY">HARRY</a><br />
2432. Hartmut Camphausen  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HC/HCAMP">HCAMP</a><br />

2433. <a href="http://www.gfz-potsdam.de/~palm/">Hartmut Palm</a>  <a href="mailto:palm@gfz-potsdam.de">&lt;palm@gfz-potsdam.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HP/HPALM">HPALM</a><br />
2434. Hartmut Vogler  <a href="mailto:_NOSPAM_hartmut.vogler@t-systems.com_NO_SPAM_">&lt;_NOSPAM_hartmut.vogler@t-systems.com_NO_SPAM_&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITGURU">ITGURU</a><br />
2435. <a href="http://simplic.it/">Hartog de Mik</a>  <a href="mailto:coffeeaddict@simplic.it">&lt;coffeeaddict@simplic.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SINISTER">SINISTER</a><br />

2436. <a href="http://hasant.wordpress.com">Hasanuddin Tamir</a>  <a href="mailto:hasantamir@yahoo.com">&lt;hasantamir@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HASANT">HASANT</a><br />
2437. <a href="http://www.openeafdss.gr/">Hasiotis Nikos</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HASIOTIS">HASIOTIS</a><br />
2438. <a href="http://occasionallyhuman.net">Hayden Stainsby</a>  <a href="mailto:perl@caffeineconcepts.com">&lt;perl@caffeineconcepts.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HD/HDS">HDS</a><br />

2439. Hazen Babcock  <a href="mailto:hbabcockos1@mac.com">&lt;hbabcockos1@mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HB/HBABCOCK">HBABCOCK</a><br />
2440. <a href="http://www.tls.cena.fr/~boubaker/">Heddy Boubaker</a>  <a href="mailto:boubaker@tls.cena.fr">&lt;boubaker@tls.cena.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOUBAKER">BOUBAKER</a><br />
2441. <a href="http://aprs.fi/">Heikki Hannikainen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HESSU">HESSU</a><br />

2442. Heiko Eißfeldt  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HEXCODER<br />
2443. Heiko Jansen  <a href="mailto:hjansen@cpan.org">&lt;hjansen@cpan.org&gt;</a> -- HJANSEN<br />
2444. <a href="http://www.heinzelnisse.info/wiki/Heiko">Heiko Klein</a>  <a href="mailto:Heiko.Klein@gmx.net">&lt;Heiko.Klein@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEIKOK">HEIKOK</a><br />

2445. <a href="http://www.schlittermann.de">Heiko Schlittermann</a>  <a href="mailto:hs@schlittermann.de">&lt;hs@schlittermann.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEIKO">HEIKO</a><br />
2446. <a href="http://www.ceosg.de">Heiko Wundram</a>  <a href="mailto:ceosg@t-online.de">&lt;ceosg@t-online.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEIKOWU">HEIKOWU</a><br />
2447. Helen Cook  <a href="mailto:hvc@cpan.org">&lt;hvc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HV/HVC">HVC</a><br />

2448. <a href="http://www.codefabrik.de">Helmut Ebelt</a>  <a href="mailto:hebelt@cpan.org">&lt;hebelt@cpan.org&gt;</a> -- HEBELT<br />
2449. <a href="http://www.jsteeb.de">Helmut Steeb</a>  <a href="mailto:helmut_steeb@losung.de">&lt;helmut_steeb@losung.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HS/HSTEEB">HSTEEB</a><br />
2450. <a href="http://www.bitbetrieb.de">Helmut Weber</a>  <a href="mailto:">&lt;&gt;</a> -- HWEBER<br />

2451. Helmut Wollmersdorfer  <a href="mailto:helmut@wollmersdorfer.at">&lt;helmut@wollmersdorfer.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WOLLMERS">WOLLMERS</a><br />
2452. <a href="http://www.ldl48.org/">Hendrik Van Belleghem</a>  <a href="mailto:hendrik.vanbelleghem@gmail.com">&lt;hendrik.vanbelleghem@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEATNIK">BEATNIK</a><br />
2453. <a href="http://www.widexl.com/">Henk Boonstra</a>  <a href="mailto:widexl@widexl.com">&lt;widexl@widexl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MONO">MONO</a><br />

2454. Henk van Oers  <a href="mailto:hvo.pm@xs4all.nl">&lt;hvo.pm@xs4all.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HV/HVOERS">HVOERS</a><br />
2455. Henning Follmann  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HFOLLMANN<br />
2456. <a href="http://www.netalive.org/swsu/">Henning Koch</a>  <a href="mailto:cpan@netalive.org">&lt;cpan@netalive.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HK/HKOCH">HKOCH</a><br />

2457. Henning Manske  <a href="mailto:hma@cpan.org">&lt;hma@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HM/HMA">HMA</a><br />
2458. <a href="www.henning-mersch.de">Henning Mersch</a>  <a href="mailto:visit-henning-mersch.de4Contact@localhost">&lt;visit-henning-mersch.de4Contact@localhost&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HM/HMERSCH">HMERSCH</a><br />
2459. Henning Michael Møller Just  <a href="mailto:hmn@datagraf.dk">&lt;hmn@datagraf.dk&gt;</a> -- HMNIELSEN<br />

2460. Henri Asseily  <a href="mailto:hasseily@cpan.org">&lt;hasseily@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HASSEILY">HASSEILY</a><br />
2461. <a href="http://www.cmresource.info">Henrik Joensson</a>  <a href="mailto:henrik7205@hotmail.com">&lt;henrik7205@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HENKE">HENKE</a><br />
2462. Henrik Mårtensson  <a href="mailto:henrik.martensson@bostream.nu">&lt;henrik.martensson@bostream.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEMA">HEMA</a><br />

2463. <a href="http://www.topconcepts.de">Henrik Steffen</a>  <a href="mailto:steffen@city-map.de">&lt;steffen@city-map.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HENRIKS">HENRIKS</a><br />
2464. Henrik Strom  <a href="mailto:henrik@computer.org">&lt;henrik@computer.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HENRIK">HENRIK</a><br />
2465. Henrik Tougaard  <a href="mailto:dbd.ingres@gmail.com">&lt;dbd.ingres@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HT/HTOUG">HTOUG</a><br />

2466. Henrique M. Ribeiro Dias  <a href="mailto:hdias@aesbuc.pt">&lt;hdias@aesbuc.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HD/HDIAS">HDIAS</a><br />
2467. Henry (Hank) Berry Ivy, Jr.  <a href="mailto:hankivy@hot.rr.com">&lt;hankivy@hot.rr.com&gt;</a> -- HANKIVY<br />
2468. <a href="http://www.maztravel.com/perl/">Henry Laxen</a>  <a href="mailto:nadine.and.henry@pobox.com">&lt;nadine.and.henry@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAXEN">LAXEN</a><br />

2469. <a href="http://kephra.sourceforge.net">Herbert Breunung</a>  <a href="mailto:sir_lichtkind@sourceforge.net">&lt;sir_lichtkind@sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LICHTKIND">LICHTKIND</a><br />
2470. <a href="www.mindstep.com">Hervé Masson</a>  <a href="mailto:">&lt;&gt;</a> -- RVMINDSTP<br />
2471. Hideaki Tanaka  <a href="mailto:">&lt;&gt;</a> -- DRAWNBOY<br />

2472. <a href="http://blog.hide-k.net/">Hideo Kimura a.k.a. hidek</a>  <a href="mailto:hide@cpan.org">&lt;hide@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIDE">HIDE</a><br />
2473. Hideyo Imazu  <a href="mailto:himazu@gmail.com">&lt;himazu@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIMAZU">HIMAZU</a><br />
2474. <a href="www.hiivesystems.com">Hiive Systems</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HIIVE<br />

2475. <a href="http://acc.csueastbay.edu/~hholz/">Hilary Holz</a>  <a href="mailto:hholz@cpan.org">&lt;hholz@cpan.org&gt;</a> -- HHOLZ<br />
2476. Hildo Biersma  <a href="mailto:Hildo.Biersma@gmail.com">&lt;Hildo.Biersma@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HB/HBIERSMA">HBIERSMA</a><br />
2477. Hilko Bengen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HB/HBENGEN">HBENGEN</a><br />

2478. <a href="http://www.hinnerk-altenburg.de/">Hinnerk Altenburg</a>  <a href="mailto:hinnerk@cpan.org">&lt;hinnerk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HINNERK">HINNERK</a><br />
2479. Hinrik Örn Sigurðsson  <a href="mailto:hinrik.sig@gmail.com">&lt;hinrik.sig@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HINRIK">HINRIK</a><br />
2480. <a href="http://subtech.g.hatena.ne.jp/motemen/">Hironao OOTSUBO</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MOTEMEN<br />

2481. Hironori Yoshida  <a href="mailto:yoshida@cpan.org">&lt;yoshida@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YO/YOSHIDA">YOSHIDA</a><br />
2482. Hiroo HAYASHI  <a href="mailto:hiroo.hayashi@computer.org">&lt;hiroo.hayashi@computer.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAYASHI">HAYASHI</a><br />
2483. <a href="http://norainu.net/mt/">Hiroshi Sakai</a>  <a href="mailto:ziguzagu@cpan.org">&lt;ziguzagu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZI/ZIGUZAGU">ZIGUZAGU</a><br />

2484. <a href="http://as-is.net/blog/">Hirotaka Ogawa</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- OGAWA<br />
2485. <a href="http://piano.gs/perl/">Hiroyuki Kobayasi</a>  <a href="mailto:kobayasi@cpan.org">&lt;kobayasi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOBAYASI">KOBAYASI</a><br />
2486. <a href="http://hryk.info/">Hiroyuki Nakamura</a>  <a href="mailto:hryk@cpan.org">&lt;hryk@cpan.org&gt;</a> -- HRYK<br />

2487. Hiroyuki Yamanaka  <a href="mailto:hiroyukim@gmail.com">&lt;hiroyukim@gmail.com&gt;</a> -- HIROYUKI<br />
2488. <a href="http://d.hatena.ne.jp/tana83/">Hisao Tanabe</a>  <a href="mailto:tanabe@cpan.org">&lt;tanabe@cpan.org&gt;</a> -- TANABE<br />
2489. <a href="http://d.hatena.ne.jp/amachang">Hitoshi Amano</a>  <a href="mailto:seijro@gmail.com">&lt;seijro@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITWARRIOR">ITWARRIOR</a><br />

2490. Ho-jung Yoon  <a href="mailto:amorette(AT)cpan.org">&lt;amorette(AT)cpan.org&gt;</a> -- AMORETTE<br />
2491. <a href="http://www.ornithopter.jp/">Hogeist</a>  <a href="mailto:mahito@cpan.org">&lt;mahito@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAHITO">MAHITO</a><br />
2492. Holger Jahn  <a href="mailto:perl@holgilein.de">&lt;perl@holgilein.de&gt;</a> -- HOLGILEIN<br />

2493. <a href="http://www.jhweiss.de/">Holger Weiß</a>  <a href="mailto:holger@jhweiss.de">&lt;holger@jhweiss.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLGER">HOLGER</a><br />
2494. Holger von Rhein  <a href="mailto:lortas@freenet.de">&lt;lortas@freenet.de&gt;</a> -- LORTAS<br />
2495. Hon Wejun  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOOO">HOOO</a><br />

2496. <a href="http://dahlia.kr/">Hong, MinHee (洪民憙)</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DAHLIA<br />
2497. Hong-Yi Chen  <a href="mailto:gaod@cpan.org">&lt;gaod@cpan.org&gt;</a> -- GAOD<br />
2498. Horst Alfred Mutterer  <a href="mailto:alfredo1@bluemail.ch">&lt;alfredo1@bluemail.ch&gt;</a> -- ALFREDO<br />

2499. Howard Arons  <a href="mailto:hlarons@yahoo.com">&lt;hlarons@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HL/HLARONS">HLARONS</a><br />
2500. <a href="http://wotsit.thingy.com/haj/">Howard Jones</a>  <a href="mailto:howie@thingy.com">&lt;howie@thingy.com&gt;</a> -- HOWIE<br />
2501. <a href="http://www.egbok.com/">Howard Owen</a>  <a href="mailto:hbo@egbok.com">&lt;hbo@egbok.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOWEN">HOWEN</a><br />

2502. <a href="http://keli.dk">Hrafnkell Freyr Hlöðversson</a>  <a href="mailto:info at keli dot dk">&lt;info at keli dot dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HR/HRAFNKELL">HRAFNKELL</a><br />
2503. <a href="http://www.husoft.com/">Huascar Tejeda</a>  <a href="mailto:me@husoft.com">&lt;me@husoft.com&gt;</a> -- HUSOFT<br />
2504. <a href="http://depesz.com/">Hubert depesz Lubaczewski</a>  <a href="mailto:depesz@depesz.com">&lt;depesz@depesz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEPESZ">DEPESZ</a><br />

2505. <a href="http://www.campaignfoundations.com/">Hugh Esco</a>  <a href="mailto:hesco@campaignfoundations.com">&lt;hesco@campaignfoundations.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HESCO">HESCO</a><br />
2506. <a href="http://alumni.engin.umich.edu/~kennedyh/">Hugh Kennedy</a>  <a href="mailto:kennedyh@engin.umich.edu">&lt;kennedyh@engin.umich.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KENNEDYH">KENNEDYH</a><br />
2507. <a href="http://www.sdragons.com/">Hugh S. Myers</a>  <a href="mailto:hsmyers@sdragons.com">&lt;hsmyers@sdragons.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HS/HSMYERS">HSMYERS</a><br />

2508. <a href="http://spaces.msn.com/hugo1019">Hugo Chien</a>  <a href="mailto:hugo.chien@gmail.com">&lt;hugo.chien@gmail.com&gt;</a> -- HUGOCHIEN<br />
2509. <a href="http://www.neurospaces.org/">Hugo Cornelis</a>  <a href="mailto:hugo.cornelis@gmail.com">&lt;hugo.cornelis@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORNELIS">CORNELIS</a><br />
2510. Hugo Costa  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HUGOCOSTA<br />

2511. <a href="http://hugo.vulcano.cl">Hugo Salgado Hernández</a>  <a href="mailto:hsalgado@vulcano.cl">&lt;hsalgado@vulcano.cl&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HU/HUGUEI">HUGUEI</a><br />
2512. <a href="http://wwwhome.cs.utwente.nl/~terdoest">Hugo WL ter Doest</a>  <a href="mailto:terdoest@cs.utwente.nl">&lt;terdoest@cs.utwente.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TERDOEST">TERDOEST</a><br />
2513. <a href="http://funkybeat.blogspot.com/">Hugo Zanghi</a>  <a href="mailto:hugo.zanghi@cpan.org">&lt;hugo.zanghi@cpan.org&gt;</a> -- ZANGHIHU<br />

2514. Hugo van der Sanden  <a href="mailto:hv@crypt.org">&lt;hv@crypt.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HV/HVDS">HVDS</a><br />
2515. Hui Zhou  <a href="mailto:hzhou@hzsolution.net">&lt;hzhou@hzsolution.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HZ/HZHOU">HZHOU</a><br />
2516. Hui Zhou  <a href="mailto:hejiagan@yahoo.com">&lt;hejiagan@yahoo.com&gt;</a> -- COOLEDIT<br />

2517. Humberto Massa Guimarães  <a href="mailto:humbertomassa@gmail.com">&lt;humbertomassa@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASSA">MASSA</a><br />
2518. <a href="http://archangelq.net">Hunter Thomas</a>  <a href="mailto:perldev@archangelq.net">&lt;perldev@archangelq.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HT/HTHOMAS">HTHOMAS</a><br />
2519. Huub Peters  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HPETERS<br />

2520. Huw Rogers  <a href="mailto:balkanaan@users.sourceforge.net">&lt;balkanaan@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HR/HROGERS">HROGERS</a><br />
2521. <a href="http://www.perlmania.or.kr/~hs">HyeonSeung Kim</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KH/KHS">KHS</a><br />
2522. <a href="http://lunatic.no/">Håkon Nessjøen</a>  <a href="mailto:haakon.nessjoen@_gmail_">&lt;haakon.nessjoen@_gmail_&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUNATIC">LUNATIC</a><br />

2523. <a href="http://www.cie.unam.mx/xml/sacad/uc/hdcg/">Héctor Daniel Cortés González</a>  <a href="mailto:hdcg@cie.unam.mx">&lt;hdcg@cie.unam.mx&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HD/HDANIEL">HDANIEL</a><br />
2524. <a href="http://www.ibm.com/software/data/db2/perl/">IBM OpenDev</a>  <a href="mailto:opendev@us.ibm.com">&lt;opendev@us.ibm.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IB/IBMTORDB2">IBMTORDB2</a><br />
2525. <a href="http://www.rational.com/">IBM Rational Software</a>  <a href="mailto:perlmod@rational.com">&lt;perlmod@rational.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RATL">RATL</a><br />

2526. <a href="http://shebang.jp/src/cpan/">IKEBE Tomohiro</a>  <a href="mailto:ikebe@shebang.jp">&lt;ikebe@shebang.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IK/IKEBE">IKEBE</a><br />
2527. INA Lintaro  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TARAO">TARAO</a><br />
2528. INABA Hitoshi  <a href="mailto:ina@cpan.org">&lt;ina@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INA">INA</a><br />

2529. IP2Location dot Com  <a href="mailto:ip2location@gmail.com">&lt;ip2location@gmail.com&gt;</a> -- IPLOC<br />
2530. <a href="http://www.ip2location.com">IP2Location.com</a>  <a href="mailto:cpan@ip2location.com">&lt;cpan@ip2location.com&gt;</a> -- IPTOLOC<br />
2531. ITO Nobuaki  <a href="mailto:banb@cpan.org">&lt;banb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BANB">BANB</a><br />

2532. Iain Campbell  <a href="mailto:">&lt;&gt;</a> -- ICAM<br />
2533. <a href="http://www.deepsea.force9.co.uk/">Iain Tatch</a>  <a href="mailto:cpan@deepsea.force9.co.uk">&lt;cpan@deepsea.force9.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IAINT">IAINT</a><br />
2534. Iain Truskett (see Andy Lester)  <a href="mailto:spoon@cpan.org">&lt;spoon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPOON">SPOON</a><br />

2535. <a href="http://members.optusnet.com.au/~iwade">Iain Wade</a>  <a href="mailto:iwade@optusnet.com.au">&lt;iwade@optusnet.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IW/IWADE">IWADE</a><br />
2536. Ian Anderson  <a href="mailto:andersij@mcmaster.ca">&lt;andersij@mcmaster.ca&gt;</a> -- IANDERSO<br />
2537. <a href="http://www.tekuiti.co.uk/">Ian Bissett</a>  <a href="mailto:bisscuitt@gmail.com">&lt;bisscuitt@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BISSCUITT">BISSCUITT</a><br />

2538. Ian Boreham  <a href="mailto:ianb@ot.com.au">&lt;ianb@ot.com.au&gt;</a> -- IANB<br />
2539. Ian Brayshaw  <a href="mailto:ian@onemore.org">&lt;ian@onemore.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IB/IBB">IBB</a><br />
2540. Ian Burrell  <a href="mailto:ianburrell@gmail.com">&lt;ianburrell@gmail.com&gt;</a> -- IBURRELL<br />
2541. Ian Cabell  <a href="mailto:wiccantn@yahoo.com">&lt;wiccantn@yahoo.com&gt;</a> -- IANCABELL<br />

2542. <a href="http://www.abc-rallying.co.uk">Ian Clark</a>  <a href="mailto:perl@abc-rallying.co.uk">&lt;perl@abc-rallying.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICLARK">ICLARK</a><br />
2543. Ian Clatworthy  <a href="mailto:ianc@mincom.co">&lt;ianc@mincom.co&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IANC">IANC</a><br />
2544. Ian Docherty  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICYDEE">ICYDEE</a><br />

2545. Ian Docherty  <a href="mailto:pause@iandocherty.com">&lt;pause@iandocherty.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICD">ICD</a><br />
2546. <a href="http://www.cs.wustl.edu/~flan/">Ian Flanigan</a>  <a href="mailto:flan@cs.wustl.edu">&lt;flan@cs.wustl.edu&gt;</a> -- IFLAN<br />
2547. Ian Guthrie  <a href="mailto:IGuthrie@aol.com">&lt;IGuthrie@aol.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IG/IGUTHRIE">IGUTHRIE</a><br />

2548. <a href="http://holsman.net">Ian Holsman</a>  <a href="mailto:lists@holsman.net">&lt;lists@holsman.net&gt;</a> -- IHOLSMAN<br />
2549. Ian Kallen  <a href="mailto:spidaman@arachna.com">&lt;spidaman@arachna.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IK/IKALLEN">IKALLEN</a><br />
2550. <a href="http://iank.org/">Ian Kilgore</a>  <a href="mailto:iank@cpan.org">&lt;iank@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IANK">IANK</a><br />

2551. <a href="http://ian.kluft.com/">Ian Kluft</a>  <a href="mailto:ikluft-cpan@thunder.sbay.org">&lt;ikluft-cpan@thunder.sbay.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IK/IKLUFT">IKLUFT</a><br />
2552. Ian Knopke  <a href="mailto:ian.knopke@mail.mcgill.ca">&lt;ian.knopke@mail.mcgill.ca&gt;</a> -- KNOPKE<br />
2553. <a href="http://langworth.com/">Ian Langworth ☠</a>  <a href="mailto:ian@cpan.org">&lt;ian@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IAN">IAN</a><br />

2554. <a href="http://www.indecorous.com/">Ian Malpass</a>  <a href="mailto:ian-cpan@indecorous.com">&lt;ian-cpan@indecorous.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IM/IMALPASS">IMALPASS</a><br />
2555. Ian Phillipps  <a href="mailto:ian@dial.pipex.com">&lt;ian@dial.pipex.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IA/IANPX">IANPX</a><br />
2556. Ian Robertson  <a href="mailto:iroberts+perl@red-bean.com">&lt;iroberts+perl@red-bean.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IR/IROBERTS">IROBERTS</a><br />

2557. Ian Roddis  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- IANRODDIS<br />
2558. <a href="http://cathdb.info">Ian Sillitoe</a>  <a href="mailto:isillitoe@cpan.org">&lt;isillitoe@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISILLITOE">ISILLITOE</a><br />
2559. <a href="ianstanley@mac.com">Ian Stanley</a>  <a href="mailto:ianstanley@mac.com">&lt;ianstanley@mac.com&gt;</a> -- ICK<br />

2560. <a href="http://www.bilstone.co.uk/parser">Ian Steel</a>  <a href="mailto:ian@bilstone.co.uk">&lt;ian@bilstone.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISTEEL">ISTEEL</a><br />
2561. Ian Stuart  <a href="mailto:ian.stuart@ed.ac.uk">&lt;ian.stuart@ed.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIZ">KIZ</a><br />
2562. Ian Tegebo  <a href="mailto:ian.tegebo@gmail.com">&lt;ian.tegebo@gmail.com&gt;</a> -- ITEGEBO<br />

2563. Ian Tyndall  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITYNDALL">ITYNDALL</a><br />
2564. <a href="http://ian.warford.ca/">Ian William Douglas Warford</a>  <a href="mailto:iwarford@gmail.com">&lt;iwarford@gmail.com&gt;</a> -- IWDW<br />
2565. Ian Zimmerman  <a href="mailto:dee9Eize@yahoo.com">&lt;dee9Eize@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THEDEVIL">THEDEVIL</a><br />

2566. <a href="nullnerds.wordpress.com">Iberê Kuntz</a>  <a href="mailto:bones AT cpan.org">&lt;bones AT cpan.org&gt;</a> -- BONES<br />
2567. <a href="http://logicsense.hypermart.net/">Idan Robbins</a>  <a href="mailto:aqutiv@softhome.net">&lt;aqutiv@softhome.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AQ/AQUTIV">AQUTIV</a><br />
2568. <a href="http://www.idelfuschini.it">Idel Fuschini</a>  <a href="mailto:idel@idelfuschini.it">&lt;idel@idelfuschini.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IF/IFUSCHINI">IFUSCHINI</a><br />

2569. <a href="http://www.ido50.org">Ido Perelmutter</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- IDOPEREL<br />
2570. Ido Trivizki  <a href="mailto:trivizki@bigfoot.com">&lt;trivizki@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITRIVIZKI">ITRIVIZKI</a><br />
2571. Ignasi Roca Carrió  <a href="mailto:ignasi.roca@fujitsu-siemens.com">&lt;ignasi.roca@fujitsu-siemens.com&gt;</a> -- IRC<br />

2572. Igor André Pereira Neves  <a href="mailto:neves.igor@gmail.com">&lt;neves.igor@gmail.com&gt;</a> -- MOO<br />
2573. <a href="http://web.quick.cz/ichladil">Igor Chladil</a>  <a href="mailto:ichladil@quick.cz">&lt;ichladil@quick.cz&gt;</a> -- ICHLADIL<br />
2574. <a href="http://igor.chudov.com/">Igor Chudov</a>  <a href="mailto:ichudov@algebra.com">&lt;ichudov@algebra.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICHUDOV">ICHUDOV</a><br />

2575. Igor Gariev  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARIEV">GARIEV</a><br />
2576. Igor Myroshnichenko  <a href="mailto:igorm@cpan.org">&lt;igorm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IG/IGORM">IGORM</a><br />
2577. <a href="http://home.sinn.ru/~gosha/perl-scripts/">Igor Okunev</a>  <a href="mailto:pause@prv.mts-nn.ru">&lt;pause@prv.mts-nn.ru&gt;</a> -- IOK<br />

2578. <a href="http://plisco.ru/soft">Igor Plisco</a>  <a href="mailto:igor [at] plisco [dot] ru">&lt;igor [at] plisco [dot] ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLISCO">PLISCO</a><br />
2579. Igor Sanchez-Puls  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QU/QUEVLAR">QUEVLAR</a><br />
2580. Igor Sutton  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IZ/IZUT">IZUT</a><br />

2581. <a href="www.imath.kiev.ua/~vlasenko">Igor Yu. Vlasenko</a>  <a href="mailto:vlasenko@imath.kiev.ua">&lt;vlasenko@imath.kiev.ua&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VIY">VIY</a><br />
2582. Ikuhiro IHARA  <a href="mailto:tsukue@gmail.com">&lt;tsukue@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IH/IHARA">IHARA</a><br />
2583. Ilene Jones  <a href="mailto:ijones.spam@cpan.org">&lt;ijones.spam@cpan.org&gt;</a> -- IJONES<br />

2584. <a href="http://nurey.com">Ilia Lobsanov</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILIAL">ILIAL</a><br />
2585. <a href="http://lazaridis.com">Ilias Lazaridis</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAZARIDIS<br />
2586. Ilja Tabachnik  <a href="mailto:billy@arnis-bsl.com">&lt;billy@arnis-bsl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILJATABAC">ILJATABAC</a><br />

2587. <a href="http://www.sci.fi/~iltzu/">Ilmari Karonen</a>  <a href="mailto:perl@itz.pp.sci.fi">&lt;perl@itz.pp.sci.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILTZU">ILTZU</a><br />
2588. Ilya Butakov  <a href="mailto:butilw@gmail.com">&lt;butilw@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUTILW">BUTILW</a><br />
2589. <a href="http://i72.by.ru/eng/">Ilya Chelpanov</a>  <a href="mailto:chelpanov@mail.ru">&lt;chelpanov@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICHE">ICHE</a><br />

2590. Ilya Etingof  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYA">ILYA</a><br />
2591. Ilya Ketris  <a href="mailto:ilya@gde.to">&lt;ilya@gde.to&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IK/IKETRIS">IKETRIS</a><br />
2592. <a href="www.stork.ru">Ilya Lityuga</a>  <a href="mailto:glucky@inbox.ru">&lt;glucky@inbox.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYALIT">ILYALIT</a><br />

2593. <a href="http://martynov.org">Ilya Martynov</a>  <a href="mailto:ilya@martynov.org">&lt;ilya@martynov.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYAM">ILYAM</a><br />
2594. <a href="http://web.masterskaya.ru/">Ilya Obshadko</a>  <a href="mailto:x-fire@mail.ru">&lt;x-fire@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XF/XFIRE">XFIRE</a><br />
2595. Ilya Soldatkin  <a href="mailto:arc@tcen.ru">&lt;arc@tcen.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYAS">ILYAS</a><br />

2596. Ilya Sterin  <a href="mailto:isterin@hotmail.com">&lt;isterin@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISTERIN">ISTERIN</a><br />
2597. <a href="http://www.bungisoft.com">Ilya Verlinsky</a>  <a href="mailto:cpan.ilya@bungisoft.com">&lt;cpan.ilya@bungisoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYAVERL">ILYAVERL</a><br />
2598. <a href="http://www.ilyaz.org/software/perl">Ilya Zakharevich</a>  <a href="mailto:cpan@ilyaz.org">&lt;cpan@ilyaz.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IL/ILYAZ">ILYAZ</a><br />

2599. <a href="http://cs.stanford.edu/people/ihaque/">Imran Haque</a>  <a href="mailto:ihaque@cs.stanford.edu">&lt;ihaque@cs.stanford.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IH/IHAQUE">IHAQUE</a><br />
2600. <a href="http://lala.c64.org/">Imre Olajos, Jr.</a>  <a href="mailto:lala@c64.org">&lt;lala@c64.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LALA">LALA</a><br />
2601. <a href="http://www.azolia.fr">Informatique montpellier</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- AZOLIA<br />

2602. <a href="http://home.welfen-netz.com/IngoGerlach/">Ingo Gerlach</a>  <a href="mailto:IngoGerlach@welfen-netz.com">&lt;IngoGerlach@welfen-netz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IG/IGERLACH">IGERLACH</a><br />
2603. Ingo Macherius  <a href="mailto:Ingo.Macherius@tu-clausthal.de">&lt;Ingo.Macherius@tu-clausthal.de&gt;</a> -- INGOMACH<br />
2604. <a href="http://j-jayz-z.de">Ingo Walz</a>  <a href="mailto:ingo@j-jayz-z.de">&lt;ingo@j-jayz-z.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IW/IWALZ">IWALZ</a><br />

2605. <a href="http://dewarim.de">Ingo Wiarda</a>  <a href="mailto:perl@dewarim.de">&lt;perl@dewarim.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IW/IWIARDA">IWIARDA</a><br />
2606. <a href="http://www.loria.fr/~falk">Ingrid Falk</a>  <a href="mailto:ingrid dot falk at loria dot fr">&lt;ingrid dot falk at loria dot fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INGRIF">INGRIF</a><br />
2607. <a href="http://ingy.net">Ingy döt Net</a>  <a href="mailto:INGY@cpan.org">&lt;INGY@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INGY">INGY</a><br />

2608. <a href="http://apollohq.webalias.com">Intimidat0r</a>  <a href="mailto:">&lt;&gt;</a> -- APOLLO<br />
2609. Ioan Jones  <a href="mailto:ioan.jones@gmail.com">&lt;ioan.jones@gmail.com&gt;</a> -- IOANJ<br />
2610. Ioannis Tambouras  <a href="mailto:inputrc@yahoo.com">&lt;inputrc@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IO/IOANNIS">IOANNIS</a><br />

2611. Ionut Turturica  <a href="mailto:jonozzz@yahoo.com">&lt;jonozzz@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONOZZZ">JONOZZZ</a><br />
2612. Ira Joseph Woodhead  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IW/IWOODHEAD">IWOODHEAD</a><br />
2613. Isaac Lin  <a href="mailto:perl at projects dot carrotpatch-remove-this dot org">&lt;perl at projects dot carrotpatch-remove-this dot org&gt;</a> -- ISAACL<br />
2614. <a href="http://freeshell.in/~ike">Isaac Praveen</a>  <a href="mailto:isaac@deeproot.co.in">&lt;isaac@deeproot.co.in&gt;</a> -- ICY<br />

2615. Isabelle Cabrera  <a href="mailto:icabrera@cpan.org">&lt;icabrera@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICABRERA">ICABRERA</a><br />
2616. Isabelle Hernandez  <a href="mailto:isabelle@cpan.org">&lt;isabelle@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISABELLE">ISABELLE</a><br />
2617. <a href="http://d.hatena.ne.jp/fbis/">Ittetsu Miyazaki</a>  <a href="mailto:ittetsu.miyazaki@gmail.com">&lt;ittetsu.miyazaki@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIYAZAKI">MIYAZAKI</a><br />

2618. <a href="http://www.Perl-Expert.com">Itzik Lerner</a>  <a href="mailto:lerner@Perl-Expert.com">&lt;lerner@Perl-Expert.com&gt;</a> -- PERLXPERT<br />
2619. <a href="http://xray.sai.msu.ru/~ivan">Ivan  Panchenko</a>  <a href="mailto:ivan@sai.msu.ru">&lt;ivan@sai.msu.ru&gt;</a> -- IVANPAN<br />
2620. <a href="http://ivan.serezhkin.com">Ivan B. Serezhkin</a>  <a href="mailto:ivan@serezhkin.com">&lt;ivan@serezhkin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VA/VANY">VANY</a><br />

2621. <a href="www.drinchev.com">Ivan Drinchev</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DRINCHEV<br />
2622. Ivan Fomichev  <a href="mailto:ifomichev@cpan.org">&lt;ifomichev@cpan.org&gt;</a> -- IFOMICHEV<br />
2623. Ivan Heffner  <a href="mailto:iheffner@gmail.com">&lt;iheffner@gmail.com&gt;</a> -- IHEFFNER<br />

2624. <a href="http://www.420.am/">Ivan Kohler</a>  <a href="mailto:ivan-pause@420.am">&lt;ivan-pause@420.am&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IV/IVAN">IVAN</a><br />
2625. <a href="www.cyber-indian.com">Ivan M Nanev</a>  <a href="mailto:cyber_indian@hotmail.com">&lt;cyber_indian@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CY/CYBER">CYBER</a><br />
2626. <a href="http://www.rhythm.com/~ivan/">Ivan Neulander</a>  <a href="mailto:ivan@rhythm.com">&lt;ivan@rhythm.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INEULANDE">INEULANDE</a><br />

2627. Ivan Ponomarev  <a href="mailto:ivangl@unicom.tomica.ru">&lt;ivangl@unicom.tomica.ru&gt;</a> -- JUPITER<br />
2628. <a href="http://www.ordecon.com/">Ivan Stojiæ</a>  <a href="mailto:devnull@element.hr">&lt;devnull@element.hr&gt;</a> -- IVANS<br />
2629. <a href="http://ivan.tubert.org/">Ivan Tubert-Brohman</a>  <a href="mailto:itub@cpan.org">&lt;itub@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITUB">ITUB</a><br />

2630. <a href="http://docperl.sourceforge.net/">Ivan Wills</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IV/IVANWILLS">IVANWILLS</a><br />
2631. Ivan Yat-Cheung Wong 黃溢章  <a href="mailto:email@ivanwong.info">&lt;email@ivanwong.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IV/IVANWONG">IVANWONG</a><br />
2632. <a href="http://mentors.debian.net/~eim/">Ivo Marino</a>  <a href="mailto:eim@cpan.org">&lt;eim@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EIM">EIM</a><br />

2633. Ivo Zdravkov  <a href="mailto:ivoz@starmail.com">&lt;ivoz@starmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IV/IVOZ">IVOZ</a><br />
2634. Ivor Williams  <a href="mailto:ivorw-cpan@xemaps.com">&lt;ivorw-cpan@xemaps.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IV/IVORW">IVORW</a><br />
2635. <a href="http://www.garnadi.org">Iwan Garnadi</a>  <a href="mailto:">&lt;&gt;</a> -- GARNADI<br />

2636. <a href="http://infotech.s27.xrea.com">Izumi Kawashima</a>  <a href="mailto:infotech@hotmail.co.jp">&lt;infotech@hotmail.co.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XO/XOR">XOR</a><br />
2637. J. David Blackstone  <a href="mailto:jdavidb@cpan.org">&lt;jdavidb@cpan.org&gt;</a> -- JDAVIDB<br />
2638. J. David Boyd  <a href="mailto:jdavidboyd@acm.org">&lt;jdavidboyd@acm.org&gt;</a> -- JDBOYD<br />

2639. <a href="http://pootpoot.com/~dlowe/">J. David Lowe</a>  <a href="mailto:j.david.lowe@gmail.com">&lt;j.david.lowe@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLOWE">DLOWE</a><br />
2640. <a href="http://www.2jnetworks.com/~jhorner/">J. J. Horner</a>  <a href="mailto:jjhorner@bellsouth.net">&lt;jjhorner@bellsouth.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJHORNER">JJHORNER</a><br />
2641. <a href="http://blojj.blogalia.com">J. J. Merelo-Guervós</a>  <a href="mailto:jmerelo (at) geneura.ugr.es">&lt;jmerelo (at) geneura.ugr.es&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMERELO">JMERELO</a><br />

2642. J. M. Davitt  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JDAV<br />
2643. J. Michael Mahan  <a href="mailto:mahanm@nextwork.rose-hulman.edu">&lt;mahanm@nextwork.rose-hulman.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMAHAN">JMAHAN</a><br />
2644. J. Murphy  <a href="mailto:maint@arsperl.org">&lt;maint@arsperl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMURPHY">JMURPHY</a><br />

2645. J. Murray  <a href="mailto:perlsmith@gmail.com">&lt;perlsmith@gmail.com&gt;</a> -- JMURRAY<br />
2646. J. Scotte Barkan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JSBARKAN<br />
2647. <a href="http://www.coldhardcode.com">J. Shirley</a>  <a href="mailto:jshirley+cpan@gmail.com">&lt;jshirley+cpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSHIRLEY">JSHIRLEY</a><br />

2648. <a href="http://huizen.dto.tudelft.nl/devries">J.A. de Vries</a>  <a href="mailto:j.a.devries@dto.tudelft.nl">&lt;j.a.devries@dto.tudelft.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JADEV">JADEV</a><br />
2649. <a href="http://www.arbs.demon.co.uk/">J.J. Green</a>  <a href="mailto:j.j.green@sheffield.ac.uk">&lt;j.j.green@sheffield.ac.uk&gt;</a> -- JJGREEN<br />
2650. J.P. Williams  <a href="mailto:jpwilliams@unt.edu">&lt;jpwilliams@unt.edu&gt;</a> -- TATTOOJP<br />

2651. JIQINGYAO  <a href="mailto:jiqingyao@gmail.com">&lt;jiqingyao@gmail.com&gt;</a> -- JQYAO<br />
2652. JIm Babbington  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JBABBING<br />
2653. JP Fricker  <a href="mailto:jpfricker@cpan.org">&lt;jpfricker@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPFRICKER">JPFRICKER</a><br />
2654. <a href="http://www.plainblack.com/">JT Smith</a>  <a href="mailto:jt_at_plainblack_dot_com">&lt;jt_at_plainblack_dot_com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIZEN">RIZEN</a><br />

2655. <a href="http://www.juniper.net/">JUNOScript team</a>  <a href="mailto:support@juniper.net">&lt;support@juniper.net&gt;</a> -- JNPR<br />
2656. <a href="http://www.pardus.nl">Jaap Karssenberg</a>  <a href="mailto:pardus@cpan.org">&lt;pardus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PARDUS">PARDUS</a><br />
2657. <a href="http://www.xperience-automatisering.nl">Jaap Voets</a>  <a href="mailto:narked@xperience-automatisering.nl">&lt;narked@xperience-automatisering.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NARKED">NARKED</a><br />

2658. <a href="http://www.artymiak.com">Jacek Artymiak</a>  <a href="mailto:jacek@devguide.net">&lt;jacek@devguide.net&gt;</a> -- JARTYMIAK<br />
2659. Jacek Wołkowicz  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JACEK<br />
2660. <a href="http://cgi.sfu.ca/~jdbates/moin/moin.cgi">Jack Bates</a>  <a href="mailto:ms419@freezone.co.uk">&lt;ms419@freezone.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JABLKO">JABLKO</a><br />

2661. Jack Bilemjian  <a href="mailto:jck000@gmail.com">&lt;jck000@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JACKB">JACKB</a><br />
2662. Jack Dunnigan  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUNNIGANJ">DUNNIGANJ</a><br />
2663. <a href="http://www.JavaPerformanceTuning.com/">Jack Shirazi</a>  <a href="mailto:jack@JavaPerformanceTuning.com">&lt;jack@JavaPerformanceTuning.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JACKS">JACKS</a><br />

2664. Jack Stone  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JWJS<br />
2665. Jacky Chang  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYOKI">KYOKI</a><br />
2666. JackyCheng  <a href="mailto:zengtaocool@msn.com">&lt;zengtaocool@msn.com&gt;</a> -- JACKTAO<br />
2667. Jacob Boswell  <a href="mailto:linuxninja@s56.net">&lt;linuxninja@s56.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINNIN">LINNIN</a><br />

2668. <a href="http://coz-i-can.blogspot.com">Jacob Broido</a>  <a href="mailto:jacob@proxsol.com">&lt;jacob@proxsol.com&gt;</a> -- YASHA<br />
2669. <a href="http://www.math.ttu.edu/~kesinger">Jacob C. Kesinger</a>  <a href="mailto:kesinger@math.ttu.edu">&lt;kesinger@math.ttu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KESINGER">KESINGER</a><br />
2670. Jacob Davies  <a href="mailto:jacob@well.com">&lt;jacob@well.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CROMIS">CROMIS</a><br />

2671. <a href="http://technosorcery.net">Jacob Helwig</a>  <a href="mailto:jhelwig@cpan.org">&lt;jhelwig@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHELWIG">JHELWIG</a><br />
2672. <a href="http://math.univ-angers.fr/~charbonnel">Jacquelin Charbonnel</a>  <a href="mailto:jacquelin.charbonnel at math.cnrs.fr">&lt;jacquelin.charbonnel at math.cnrs.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JACQUELIN">JACQUELIN</a><br />
2673. <a href="www.oxado.com">Jacques Caron</a>  <a href="mailto:jc@oxado.com">&lt;jc@oxado.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCARON">JCARON</a><br />

2674. <a href="http://golem.ph.utexas.edu/~distler/">Jacques Distler</a>  <a href="mailto:distler@golem.ph.utexas.edu">&lt;distler@golem.ph.utexas.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DISTLER">DISTLER</a><br />
2675. <a href="http://www.ird.fr/us191/">Jacques Grelet</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JGRELET<br />
2676. <a href="www.supcik.org">Jacques Supcik</a>  <a href="mailto:jacques@supcik.org">&lt;jacques@supcik.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUPCIK">SUPCIK</a><br />

2677. Jacqui Caren  <a href="mailto:jacqui.caren@ntlworld.com">&lt;jacqui.caren@ntlworld.com&gt;</a> -- JAX<br />
2678. <a href="http://www.riven.net/~moose/">Jade E. Deane</a>  <a href="mailto:moose@riven.net">&lt;moose@riven.net&gt;</a> -- JADEDEANE<br />
2679. <a href="http://perlipse.googlecode.com">Jae Gangemi</a>  <a href="mailto:jgangemi@gmail.com">&lt;jgangemi@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAE">JAE</a><br />

2680. <a href="http://www.interact.net.uk/">Jagdeep S. Sandhu</a>  <a href="mailto:Jag@interact.net.uk">&lt;Jag@interact.net.uk&gt;</a> -- JAGS<br />
2681. <a href="http://bioportal.weizmann.ac.il/staff/jaime_prilusky.html">Jaime Prilusky</a>  <a href="mailto:Jaime.Prilusky@weizmann.ac.il">&lt;Jaime.Prilusky@weizmann.ac.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRILUSKYJ">PRILUSKYJ</a><br />
2682. <a href="http://www.jaked.org/">Jake Donham</a>  <a href="mailto:jaked@well.com">&lt;jaked@well.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAKE">JAKE</a><br />

2683. <a href="http://3.rdrail.net">Jake Luciani</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TJAKE<br />
2684. <a href="http://www.orqwood.dk">Jakob Schmidt</a>  <a href="mailto:sumus@orqwood.dk">&lt;sumus@orqwood.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUMUS">SUMUS</a><br />
2685. Jakob Voß  <a href="mailto:jakob.voss@gbv.de">&lt;jakob.voss@gbv.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VO/VOJ">VOJ</a><br />

2686. Jakub Spicak  <a href="mailto:jakub.spicak@deltaes.cz">&lt;jakub.spicak@deltaes.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSPICAK">JSPICAK</a><br />
2687. <a href="http://www.dm.unipi.it/~jama">Jama Musse Jama</a>  <a href="mailto:jama@tecsiel.it">&lt;jama@tecsiel.it&gt;</a> -- JMUSSE<br />
2688. <a href="http://opensource.fotango.com">James A Duncan</a>  <a href="mailto:jduncan@fotango.com">&lt;jduncan@fotango.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDUNCAN">JDUNCAN</a><br />

2689. <a href="http://www.pcxperience.org/">James A. Pattie</a>  <a href="mailto:james@pcxperience.com">&lt;james@pcxperience.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESP">JAMESP</a><br />
2690. James B. Bowlin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BITJAM<br />
2691. James Baker  <a href="mailto:spambait@nospam.hindenburg.org">&lt;spambait@nospam.hindenburg.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESB">JAMESB</a><br />

2692. James Beninger  <a href="mailto:clan_lambda@hotmail.com">&lt;clan_lambda@hotmail.com&gt;</a> -- JBENINGER<br />
2693. James Briggs  <a href="mailto:james@rf.net">&lt;james@rf.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBRIGGS">JBRIGGS</a><br />
2694. <a href="http://www.james.rcpt.to/">James Bromberger</a>  <a href="mailto:james@rcpt.to">&lt;james@rcpt.to&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEB">JEB</a><br />

2695. James Chen  <a href="mailto:chenj@seas.ucla.edu">&lt;chenj@seas.ucla.edu&gt;</a> -- JCHEN<br />
2696. James Conerly  <a href="mailto:jconerly@cpan.org">&lt;jconerly@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCONERLY">JCONERLY</a><br />
2697. James Couball  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JCOUBALL<br />
2698. <a href="www.periscan.com">James Dennis</a>  <a href="mailto:cpan@periscan.com">&lt;cpan@periscan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDENNIS">JDENNIS</a><br />

2699. <a href="www.roostereggs.com">James E Jurach Jr.</a>  <a href="mailto:muaddib@erf.net">&lt;muaddib@erf.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JURACH">JURACH</a><br />
2700. James E Keenan  <a href="mailto:jkeenan@cpan.org">&lt;jkeenan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKEENAN">JKEENAN</a><br />
2701. James E. Quinlan  <a href="mailto:jim2101024@comcast.net">&lt;jim2101024@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JQ/JQUINLAN">JQUINLAN</a><br />

2702. <a href="http://www.grayproductions.net/">James Edward Gray II</a>  <a href="mailto:james@grayproductions.net">&lt;james@grayproductions.net&gt;</a> -- JGRAY<br />
2703. James Farrell  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JFARRELL<br />
2704. James FitzGibbon  <a href="mailto:JFITZ@cpan.org">&lt;JFITZ@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFITZ">JFITZ</a><br />

2705. <a href="http://www.jmf2.com/">James Freeman</a>  <a href="mailto:jmfreeman@attbi.com">&lt;jmfreeman@attbi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMFREEMAN">JMFREEMAN</a><br />
2706. <a href="http://www.base6.com/">James Furness</a>  <a href="mailto:furn@base6.com">&lt;furn@base6.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFURNESS">JFURNESS</a><br />
2707. <a href="http://www.jamesgottlieb.com/">James G Smith</a>  <a href="mailto:cpan@jamesmith.com">&lt;cpan@jamesmith.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSMITH">JSMITH</a><br />

2708. <a href="http://ljcomputing.net">James G Willmore</a>  <a href="mailto:owner@ljcomputing.net">&lt;owner@ljcomputing.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILLMOJG">WILLMOJG</a><br />
2709. <a href="http://www.gnuinter.net">James Golovich</a>  <a href="mailto:james@gnuinter.net">&lt;james@gnuinter.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESGOL">JAMESGOL</a><br />
2710. James Halstead  <a href="mailto:jch111@btintnernet.com">&lt;jch111@btintnernet.com&gt;</a> -- BIGGLES<br />

2711. <a href="http://www.hgsc.bcm.tmc.edu/~harley">James Harley Gorrell</a>  <a href="mailto:harley@bcm.tmc.edu">&lt;harley@bcm.tmc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HARLEY">HARLEY</a><br />
2712. James Hickie  <a href="mailto:cpan@jameshickie.org">&lt;cpan@jameshickie.org&gt;</a> -- JRH<br />
2713. James Hugman  <a href="mailto:jameshugman AT email.com">&lt;jameshugman AT email.com&gt;</a> -- JHUG<br />

2714. James Kiser  <a href="mailto:james.kiser@gmail.com">&lt;james.kiser@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKISER">JKISER</a><br />
2715. <a href="http://www.jameslaver.com/">James Laver</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ELPENGUIN<br />
2716. James Lavery  <a href="mailto:jlavery@bigfoot.com">&lt;jlavery@bigfoot.com&gt;</a> -- JLAVERY<br />

2717. <a href="http://www.geocities.com/nawkboy/resumes/resumeHTS.html">James Lee Carpenter</a>  <a href="mailto:nawkboy@yahoo.com">&lt;nawkboy@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARPENTER">CARPENTER</a><br />
2718. James Loope  <a href="mailto:cronus@benzsalvage.com">&lt;cronus@benzsalvage.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRONUS">CRONUS</a><br />
2719. <a href="http://www.domaincentric.com">James Lundeen</a>  <a href="mailto:lundeen@cpan.org">&lt;lundeen@cpan.org&gt;</a> -- LUNDEEN<br />

2720. James Macfarlane  <a href="mailto:jmacfarla@cpan.org">&lt;jmacfarla@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMACFARLA">JMACFARLA</a><br />
2721. <a href="http://www.mancz.com">James Mancz</a>  <a href="mailto:perl@mancz.com">&lt;perl@mancz.com&gt;</a> -- JMANCZ<br />
2722. <a href="http://www.jmarshall.com/">James Marshall</a>  <a href="mailto:james@jmarshall.com">&lt;james@jmarshall.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSM">JSM</a><br />

2723. <a href="http://perlmonks.org/?node=theorbtwo">James Mastros</a>  <a href="mailto:james@mastros.biz">&lt;james@mastros.biz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMASTROS">JMASTROS</a><br />
2724. <a href="http://www.perlservices.net/en/library.shtml">James Melanson</a>  <a href="mailto:jim@perlservices.com">&lt;jim@perlservices.com&gt;</a> -- JMELANSON<br />
2725. <a href="pulpie.ath.cx">James Michael</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- THEFISHY<br />

2726. <a href="http://introspector.sourceforge.net">James Michael DuPont</a>  <a href="mailto:mdupont777@yahoo.com">&lt;mdupont777@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDUPONT">MDUPONT</a><br />
2727. James Moore  <a href="mailto:james@banshee.com">&lt;james@banshee.com&gt;</a> -- JAMESM<br />
2728. James Moosmann  <a href="mailto:pdf_ad@carolina.rr.com">&lt;pdf_ad@carolina.rr.com&gt;</a> -- JMOOSMANN<br />

2729. <a href="http://www.intercode.com.au/jmorris/">James Morris</a>  <a href="mailto:jmorris@intercode.com.au">&lt;jmorris@intercode.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMORRIS">JMORRIS</a><br />
2730. James Muir  <a href="mailto:hemlock@vtlink.net">&lt;hemlock@vtlink.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEMLOCK">HEMLOCK</a><br />
2731. <a href="http://lee.k12.nc.us/~joden/lcss/tech_tracker">James Olin Oden</a>  <a href="mailto:joden@lee.k12.nc.us">&lt;joden@lee.k12.nc.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESODEN">JAMESODEN</a><br />

2732. James Pavlick  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPAVLICK">JPAVLICK</a><br />
2733. James Peregrino  <a href="mailto:jperegrino@post.harvard.edu">&lt;jperegrino@post.harvard.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPEREGR">JPEREGR</a><br />
2734. James Polera  <a href="mailto:polera@cpan.org">&lt;polera@cpan.org&gt;</a> -- POLERA<br />

2735. <a href="http://www.squish.net/">James Ponder</a>  <a href="mailto:james@squish.net">&lt;james@squish.net&gt;</a> -- SQUISH<br />
2736. <a href="http://jamespo.org.uk/">James Powell</a>  <a href="mailto:perl@N0SPAM.jamespo.org.uk">&lt;perl@N0SPAM.jamespo.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESPO">JAMESPO</a><br />
2737. <a href="http://www.jamesrallen.com/">James R. Allen II</a>  <a href="mailto:james@jamesrallen.com">&lt;james@jamesrallen.com&gt;</a> -- JALLEN<br />

2738. <a href="http://romana.now.ie/">James Raftery</a>  <a href="mailto:james@now.ie">&lt;james@now.ie&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRAFTERY">JRAFTERY</a><br />
2739. James Robson  <a href="mailto:gilad@arbingersys.com">&lt;gilad@arbingersys.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GILAD">GILAD</a><br />
2740. <a href="http://www.ronanweb.co.uk/">James Ronan</a>  <a href="mailto:james@ronanweb.co.uk">&lt;james@ronanweb.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESR">JAMESR</a><br />

2741. James Rouzier  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROUZIER<br />
2742. <a href="halo3.net">James Russo</a>  <a href="mailto:jr@halo3.net">&lt;jr@halo3.net&gt;</a> -- JAR<br />
2743. <a href="http://www.netjs.com">James Shimada</a>  <a href="mailto:[jshimada (a t) netjs ( d o t ) com]">&lt;[jshimada (a t) netjs ( d o t ) com]&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSHIMADA">JSHIMADA</a><br />

2744. James Spahlinger  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NIXEAGLE<br />
2745. <a href="http://www.twitchy.net">James Spurin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FUNKJAMES<br />
2746. <a href="http://www.krontor.net/">James Tavares</a>  <a href="mailto:perl@james.tavares.name">&lt;perl@james.tavares.name&gt;</a> -- JTAVARES<br />

2747. <a href="http://www.biocompute.net/">James Thompson</a>  <a href="mailto:james.michael.thompson@gmail.com">&lt;james.michael.thompson@gmail.com&gt;</a> -- JTHOMPSON<br />
2748. <a href="http://www.bigfoot.com/~jtillman/">James Tillman</a>  <a href="mailto:jtillman@bigfoot.com">&lt;jtillman@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTILLMAN">JTILLMAN</a><br />
2749. <a href="http://www.jamestolley.com/">James Tolley</a>  <a href="mailto:james@bitperfect.com">&lt;james@bitperfect.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMES">JAMES</a><br />

2750. James Truesdale  <a href="mailto:jtruesdale@primary.net">&lt;jtruesdale@primary.net&gt;</a> -- TRUESDALE<br />
2751. <a href="http://www.hardening-linux.com">James Turnbull</a>  <a href="mailto:james@lovedthanlost.net">&lt;james@lovedthanlost.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMTUR">JAMTUR</a><br />
2752. <a href="http://www.blackbear.com/">James Turner</a>  <a href="mailto:james@csmonitor.com">&lt;james@csmonitor.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTURNER">JTURNER</a><br />

2753. <a href="http://brutalhugs.com">James Vasile</a>  <a href="mailto:jvasile@cpan.org">&lt;jvasile@cpan.org&gt;</a> -- JVASILE<br />
2754. <a href="http://jamesthompson.us">James W. Thompson, II</a>  <a href="mailto:jwthompson2@gmail.com">&lt;jwthompson2@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMESTHOM">JAMESTHOM</a><br />
2755. James Wade  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WADE<br />

2756. James Wiley  <a href="mailto:jwileysd@gmail.com">&lt;jwileysd@gmail.com&gt;</a> -- JWILEY<br />
2757. <a href="http://blogs.loveandnature.co.za/www/mothman/">James Wright</a>  <a href="mailto:james2vegas@aim.com">&lt;james2vegas@aim.com&gt;</a> -- JWRIGHT<br />
2758. James.Q.Li  <a href="mailto:shijialee@cpan.org">&lt;shijialee@cpan.org&gt;</a> -- SHIJIALEE<br />

2759. <a href="http://www.compostmagic.org.uk/">Jamie Andrews</a>  <a href="mailto:jamie@linuxufo.org">&lt;jamie@linuxufo.org&gt;</a> -- JANDREWS<br />
2760. Jamie Andrews  <a href="mailto:jamie@linuxufo.com">&lt;jamie@linuxufo.com&gt;</a> -- VORSPRUNG<br />
2761. <a href="http://www.white-mountain.org/jamie/">Jamie Flournoy</a>  <a href="mailto:jamie@white-mountain.org">&lt;jamie@white-mountain.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFLOURNOY">JFLOURNOY</a><br />

2762. Jamie Geyer  <a href="mailto:jgeyer14@gmail.com">&lt;jgeyer14@gmail.com&gt;</a> -- JGEYER<br />
2763. <a href="http://genome.arizona.edu/~jamie">Jamie Hatfield</a>  <a href="mailto:jamie@genome.arizona.edu">&lt;jamie@genome.arizona.edu&gt;</a> -- JHATFIEL<br />
2764. <a href="http://www.geniegate.com/">Jamie Hoglund</a>  <a href="mailto:nospam@geniegate.com">&lt;nospam@geniegate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMHOGLUND">JMHOGLUND</a><br />

2765. Jamie Krasnoo  <a href="mailto:modules@myeboard.com">&lt;modules@myeboard.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKRASNOO">JKRASNOO</a><br />
2766. <a href="http://www.letual.net">Jamie Le Tual</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JLETUAL<br />
2767. <a href="http://mccarthy.vg/">Jamie McCarthy</a>  <a href="mailto:jamie@mccarthy.vg">&lt;jamie@mccarthy.vg&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMCC">JAMCC</a><br />

2768. <a href="http://popdog.dyndns.org/">Jamie O'Shaughnessy</a>  <a href="mailto:jamieo@yahoo.com">&lt;jamieo@yahoo.com&gt;</a> -- JOS<br />
2769. <a href="http://thelightness.blogspot.com">Jamie Tatum</a>  <a href="mailto:jtatum@gmail.com">&lt;jtatum@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTATUM">JTATUM</a><br />
2770. <a href="http://sysmonblog.co.uk">Jamie Williams</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SYSMON<br />

2771. Jamshaid Faisal  <a href="mailto:j.faisal@gmail.com">&lt;j.faisal@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMSHAID">JAMSHAID</a><br />
2772. <a href="http://www.fi.muni.cz/~kas">Jan &quot;Yenya&quot; Kasprzak</a>  <a href="mailto:kas@informatics.muni.cz">&lt;kas@informatics.muni.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YE/YENYA">YENYA</a><br />

2773. Jan Aerts  <a href="mailto:aerts.jan@advalvas.be">&lt;aerts.jan@advalvas.be&gt;</a> -- AERTS<br />
2774. <a href="http://www.topicmapping.com">Jan Algermissen</a>  <a href="mailto:algermissen@acm.org">&lt;algermissen@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALGER">ALGER</a><br />
2775. <a href="http://www.dittberner.info/">Jan Dittberner</a>  <a href="mailto:jan@dittberner.info">&lt;jan@dittberner.info&gt;</a> -- JANDD<br />

2776. Jan Dubois  <a href="mailto:jand@activestate.com">&lt;jand@activestate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDB">JDB</a><br />
2777. <a href="http://www.delinquent.de/">Jan Harders</a>  <a href="mailto:jan@thejway.de">&lt;jan@thejway.de&gt;</a> -- JAN<br />
2778. <a href="http://flodhest.net">Jan Henning Thorsen</a>  <a href="mailto:pm@flodhest.net">&lt;pm@flodhest.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EIDOLON">EIDOLON</a><br />

2779. Jan Holčapek  <a href="mailto:holcapek@gmail.com">&lt;holcapek@gmail.com&gt;</a> -- JHOLCAP<br />
2780. <a href="http://www.ucw.cz/~bulb/">Jan Hudec</a>  <a href="mailto:bulb+cpan@ucw.cz">&lt;bulb+cpan@ucw.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BULB">BULB</a><br />
2781. <a href="http://home.cern.ch/iven">Jan Iven</a>  <a href="mailto:jan.iven@cern.ch">&lt;jan.iven@cern.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAIV">JAIV</a><br />

2782. <a href="http://jenda.krynicky.cz">Jan Krynicky</a>  <a href="mailto:Jenda@Krynicky.cz">&lt;Jenda@Krynicky.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JENDA">JENDA</a><br />
2783. Jan L. Peterson  <a href="mailto:jlp+cpan@peterson.ath.cx">&lt;jlp+cpan@peterson.ath.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANP">JANP</a><br />
2784. <a href="http://www.jan-merker.de">Jan Merker</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MERKER<br />

2785. <a href="http://www.fi.muni.cz/~adelton/">Jan Pazdziora</a>  <a href="mailto:adelton@fi.muni.cz">&lt;adelton@fi.muni.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANPAZ">JANPAZ</a><br />
2786. Jan Pomikálek  <a href="mailto:xpomikal@fi.muni.cz">&lt;xpomikal@fi.muni.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANPOM">JANPOM</a><br />
2787. <a href="http://pajout.eu">Jan Poslušný</a>  <a href="mailto:pajout@cpan.org">&lt;pajout@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAJOUT">PAJOUT</a><br />

2788. <a href="http://www.jschreiber.com">Jan Schreiber</a>  <a href="mailto:cpan@jschreiber.com">&lt;cpan@jschreiber.com&gt;</a> -- JSCHREIB<br />
2789. <a href="http://www.willamowius.de/perl.html">Jan Willamowius</a>  <a href="mailto:jan@willamowius.de">&lt;jan@willamowius.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANW">JANW</a><br />
2790. <a href="http://www.fys.ku.dk/~revsbech">Jan-Erik Rodriguez Revsbech</a>  <a href="mailto:Jan-Erik.Revsbech@cern.ch">&lt;Jan-Erik.Revsbech@cern.ch&gt;</a> -- REVSBECH<br />

2791. <a href="http://www.xs4all.nl/~johnpc/">Jan-Pieter Cornet</a>  <a href="mailto:johnpc@xs4all.nl">&lt;johnpc@xs4all.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPC">JPC</a><br />
2792. Janek Schleicher  <a href="mailto:bigj@kamelfreund.de">&lt;bigj@kamelfreund.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIGJ">BIGJ</a><br />
2793. <a href="http://www.dante.org.uk/~janos">Janos Mohacsi</a>  <a href="mailto:janos.mohacsi@dante.org.uk">&lt;janos.mohacsi@dante.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOHACSI">MOHACSI</a><br />

2794. <a href="http://www.jerzyk.com/">Janusz Harkot</a>  <a href="mailto:jh@jerzyk.com">&lt;jh@jerzyk.com&gt;</a> -- JERZYK<br />
2795. <a href="http://www-rohan.sdsu.edu/~cleaver/software/">Japheth Cleaver</a>  <a href="mailto:cleaver@rohan.sdsu.edu">&lt;cleaver@rohan.sdsu.edu&gt;</a> -- JCCLEAVER<br />
2796. <a href="http://www.akspace.com/">Jared Clarke</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTCLARKE">JTCLARKE</a><br />

2797. <a href="http://jared.wordzoo.com/">Jared Rhine</a>  <a href="mailto:jared@wordzoo.com">&lt;jared@wordzoo.com&gt;</a> -- JARED<br />
2798. <a href="http://cante.net/~jaalto">Jari Aalto</a>  <a href="mailto:jari.aalto@cante.net">&lt;jari.aalto@cante.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JARIAALTO">JARIAALTO</a><br />
2799. <a href="http://iki.fi/jhi/">Jarkko Hietaniemi</a>  <a href="mailto:jhi@iki.fi">&lt;jhi@iki.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHI">JHI</a><br />

2800. <a href="http://www-astro.physics.ox.ac.uk/~jarle/">Jarle Brinchmann</a>  <a href="mailto:jarle.brinchmann@wolfson.ox.ac.uk">&lt;jarle.brinchmann@wolfson.ox.ac.uk&gt;</a> -- JARLE<br />
2801. <a href="http://www.rubensteintech.com/">Jaron Rubenstein</a>  <a href="mailto:jaron-cpan@rubensteintech.com">&lt;jaron-cpan@rubensteintech.com&gt;</a> -- JRUBEN<br />
2802. Jarret Glasscock  <a href="mailto:glasscock_cpan@mac.com">&lt;glasscock_cpan@mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLASSCOCK">GLASSCOCK</a><br />

2803. Jarrod Overson  <a href="mailto:jsoverson@googlemail.com">&lt;jsoverson@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSOVERSON">JSOVERSON</a><br />
2804. <a href="http://www.kivela.net/jaska/">Jaska Kivelä</a>  <a href="mailto:jaska@kivela.net">&lt;jaska@kivela.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASKA">JASKA</a><br />
2805. <a href="http://www.devnetinc.com">Jason A. Crome</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CROMEDOME">CROMEDOME</a><br />

2806. <a href="http://oddgeek.info/">Jason A. Dour</a>  <a href="mailto:jad@cpan.org">&lt;jad@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAD">JAD</a><br />
2807. Jason Adams  <a href="mailto:jadams@nyscul.org">&lt;jadams@nyscul.org&gt;</a> -- JASON<br />
2808. Jason B. Alonso  <a href="mailto:jalonso@mit.edu">&lt;jalonso@mit.edu&gt;</a> -- JALONSO<br />

2809. Jason B. Burrell  <a href="mailto:jburrell@users.sourceforge.net">&lt;jburrell@users.sourceforge.net&gt;</a> -- JAYBEE<br />
2810. Jason Balicki  <a href="mailto:kodak@frontierhomemortgage.com">&lt;kodak@frontierhomemortgage.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KODAK">KODAK</a><br />
2811. <a href="http://www.frogboy.net">Jason Blakey</a>  <a href="mailto:jblakey@frogboy.net">&lt;jblakey@frogboy.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBLAKEY">JBLAKEY</a><br />

2812. Jason Bodnar  <a href="mailto:jason@shakabuku.org">&lt;jason@shakabuku.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBODNAR">JBODNAR</a><br />
2813. Jason Burnett  <a href="mailto:jason@jnj.org">&lt;jason@jnj.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBURNETT">JBURNETT</a><br />
2814. <a href="http://li14-48.members.linode.com">Jason Byrd</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MADBOSUN<br />

2815. Jason Carling  <a href="mailto:thebladerunner@hotmail.com">&lt;thebladerunner@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCARLING">JCARLING</a><br />
2816. <a href="http://www.jasonclifford.com/">Jason Clifford</a>  <a href="mailto:pause@jason.ukpost.com">&lt;pause@jason.ukpost.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CL/CLIFFORDJ">CLIFFORDJ</a><br />
2817. <a href="http://www.jasons.org/">Jason Costomiris</a>  <a href="mailto:jcostom@hotmail.com">&lt;jcostom@hotmail.com&gt;</a> -- JCOSTOM<br />

2818. Jason David McManus  <a href="mailto:QOS@cpan.org">&lt;QOS@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QO/QOS">QOS</a><br />
2819. <a href="http://www.openinformatics.com/">Jason E. Stewart</a>  <a href="mailto:jasons@cpan.org">&lt;jasons@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASONS">JASONS</a><br />
2820. <a href="http://open-ils.org/">Jason Etheridge</a>  <a href="mailto:phasefx@cpan.org">&lt;phasefx@cpan.org&gt;</a> -- PHASEFX<br />

2821. Jason Felds  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WOLFMAN">WOLFMAN</a><br />
2822. Jason Foust  <a href="mailto:jmfoust@jasonfoust.com">&lt;jmfoust@jasonfoust.com&gt;</a> -- JMFOUST<br />
2823. Jason Fox  <a href="mailto:lvregent@yahoo.com">&lt;lvregent@yahoo.com&gt;</a> -- LVREGENT<br />
2824. Jason Fried  <a href="mailto:rev.daemon+cpan@gmail.com">&lt;rev.daemon+cpan@gmail.com&gt;</a> -- FRIED<br />

2825. <a href="http://halls.lug-nut.com/jayce/">Jason Hall</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JAYCE<br />
2826. <a href="http://jsnby.is-a-geek.com">Jason Hancock</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSNBY">JSNBY</a><br />
2827. <a href="http://www.verysimple.com/scripts/">Jason Hinkle</a>  <a href="mailto:jake67890@hotmail.com">&lt;jake67890@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHINKLE">JHINKLE</a><br />

2828. Jason Hitt  <a href="mailto:jhitt@illumasys.com">&lt;jhitt@illumasys.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHITT">JHITT</a><br />
2829. <a href="www.rawsoftware.com">Jason Holland</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MY/MYBOXEN">MYBOXEN</a><br />
2830. <a href="http://www.incantations.net/~jason">Jason Hudgins</a>  <a href="mailto:jasonlee@spy.net">&lt;jasonlee@spy.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHUDGE">JHUDGE</a><br />

2831. Jason Johnson  <a href="mailto:jbjohns@libsource.com">&lt;jbjohns@libsource.com&gt;</a> -- JBJOHNS<br />
2832. Jason Kastner  <a href="mailto:jkastner@oboe.calpoly.edu">&lt;jkastner@oboe.calpoly.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKAST">JKAST</a><br />
2833. Jason King  <a href="mailto:elephant@cpan.org">&lt;elephant@cpan.org&gt;</a> -- ELEPHANT<br />
2834. <a href="http://www.jasonkohles.com/">Jason Kohles</a>  <a href="mailto:cpan@jasonkohles.com">&lt;cpan@jasonkohles.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASONK">JASONK</a><br />

2835. <a href="http://www.korksoft.com">Jason Korkin</a>  <a href="mailto:nospam@korksoft.com">&lt;nospam@korksoft.com&gt;</a> -- JKORKIN<br />
2836. <a href="http://www.froebe.net/blog">Jason L. Froebe</a>  <a href="mailto:jason@froebe.net">&lt;jason@froebe.net&gt;</a> -- JFROEBE<br />
2837. <a href="(down at the moment)">Jason L. Schwab</a>  <a href="mailto:jlschwab@cpan.org">&lt;jlschwab@cpan.org&gt;</a> -- JLSCHWAB<br />

2838. Jason Lavold  <a href="mailto:jlavold@asu.edu">&lt;jlavold@asu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLAVOLD">JLAVOLD</a><br />
2839. Jason Leane  <a href="mailto:alphamethyl@mac.com">&lt;alphamethyl@mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOCG">DOCG</a><br />
2840. Jason Lee  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEEJA">LEEJA</a><br />

2841. Jason Levitt  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLEV">JLEV</a><br />
2842. Jason Long  <a href="mailto:jason@long.name">&lt;jason@long.name&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASLONG">JASLONG</a><br />
2843. <a href="http://www.q7.com/~jason/">Jason M. Mills</a>  <a href="mailto:jmmills at cpan.org">&lt;jmmills at cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMMILLS">JMMILLS</a><br />

2844. <a href="http://j.asonmay.net">Jason May</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JASONMAY<br />
2845. <a href="http://www.jmac.org/">Jason McIntosh</a>  <a href="mailto:jmac@jmac.org">&lt;jmac@jmac.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMAC">JMAC</a><br />
2846. Jason McManus  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INFIDEL">INFIDEL</a><br />

2847. <a href="http://www.d.umn.edu/~mich0212/">Jason Michelizzi</a>  <a href="mailto:jmichelizzi+remove@gmail.com">&lt;jmichelizzi+remove@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASONM">JASONM</a><br />
2848. <a href="http://www.sober.com/perl/modules/">Jason Moore</a>  <a href="mailto:jmoore@sober.com">&lt;jmoore@sober.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMOORE">JMOORE</a><br />
2849. Jason Morriss  <a href="mailto:lifo 101 somewhere at gmail.com">&lt;lifo 101 somewhere at gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LIFO">LIFO</a><br />

2850. Jason Purdy  <a href="mailto:Jason@Purdy.INFO">&lt;Jason@Purdy.INFO&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PU/PURDY">PURDY</a><br />
2851. Jason R Poole  <a href="mailto:jason@quanack.com">&lt;jason@quanack.com&gt;</a> -- QUANACK<br />
2852. <a href="http://people.csail.mit.edu/~jrennie/">Jason Rennie</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRENNIE">JRENNIE</a><br />

2853. <a href="http://jagerman.com">Jason Rhinelander</a>  <a href="mailto:jagerman@jagerman.com">&lt;jagerman@jagerman.com&gt;</a> -- JAGERMAN<br />
2854. <a href="zer.homelinux.com">Jason Richmond</a>  <a href="mailto:zerhash@cpan.org">&lt;zerhash@cpan.org&gt;</a> -- ZERHASH<br />
2855. Jason Roth  <a href="mailto:jroth2@gmail.com">&lt;jroth2@gmail.com&gt;</a> -- ETC<br />

2856. <a href="http://lightconsulting.com/~thalakan/code.html">Jason Spence</a>  <a href="mailto:thalakan@lightconsulting.com">&lt;thalakan@lightconsulting.com&gt;</a> -- THALAKAN<br />
2857. <a href="http://bioperl.org/">Jason Stajich</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- STAJICH<br />
2858. <a href="http://omega.uta.edu/~jthardy/">Jason T Hardy</a>  <a href="mailto:jthardy@uta.edu">&lt;jthardy@uta.edu&gt;</a> -- JTHARDY<br />

2859. <a href="http://www.hpc.uh.edu/majordomo/">Jason Tibbitts</a>  <a href="mailto:tibbs@hpc.uh.edu">&lt;tibbs@hpc.uh.edu&gt;</a> -- TIBBS<br />
2860. <a href="http://jason.tiltastech.com/">Jason Titus</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTITUS">JTITUS</a><br />
2861. <a href="http://www.jtoy.net">Jason Toy (朱仲光)</a>  <a href="mailto:toy@cpan.org">&lt;toy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOY">TOY</a><br />

2862. Jason W. May  <a href="mailto:jmay@pobox.com">&lt;jmay@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMAY">JMAY</a><br />
2863. Jason Witt  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JASONW<br />
2864. Jason Woodward  <a href="mailto:woodwardj at jaos dot org">&lt;woodwardj at jaos dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAOS">JAOS</a><br />

2865. Jason Yates  <a href="mailto:jaywhy@gmail.com">&lt;jaywhy@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAYWHY">JAYWHY</a><br />
2866. Jason Zurawski  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ZURAWSKI<br />
2867. <a href="http://www.cs.auckland.ac.nz/~jas">Jasvir Nagra</a>  <a href="mailto:jas@cs.auckland.ac.nz">&lt;jas@cs.auckland.ac.nz&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNAGRA">JNAGRA</a><br />

2868. <a href="http://javier.rodriguez.org.mx/">Javier Arturo Rodríguez Gutiérrez</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JAVIER<br />
2869. Javier Gonzalez  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JGONZALEZ<br />
2870. <a href="http://www.xintec.com">Javier Gutierrez</a>  <a href="mailto:javi@gmx.net">&lt;javi@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRJONES">MRJONES</a><br />

2871. Javier Herrero  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHERRERO">JHERRERO</a><br />
2872. Javier Palacios  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JAVIERPB<br />
2873. Javier Pérez Montes  <a href="mailto:el.maquinas@terra.es">&lt;el.maquinas@terra.es&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NERVENET">NERVENET</a><br />
2874. Javier Viveros  <a href="mailto:smetafora@hotmail.com">&lt;smetafora@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALPOETA">MALPOETA</a><br />

2875. Javier lopez  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SUPERL<br />
2876. <a href="http://jay.bonci.com">Jay Bonci</a>  <a href="mailto:jay@bonci.com">&lt;jay@bonci.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAYBONCI">JAYBONCI</a><br />
2877. Jay Buffington  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAYBUFF">JAYBUFF</a><br />

2878. Jay Flowers  <a href="mailto:jay_flowers@chcsii.com">&lt;jay_flowers@chcsii.com&gt;</a> -- JFLOWERS<br />
2879. <a href="http://jays.net">Jay Hannah</a>  <a href="mailto:jay@jays.net">&lt;jay@jays.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHANNAH">JHANNAH</a><br />
2880. Jay Jacobs  <a href="mailto:jayj@cpan.org">&lt;jayj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAYJ">JAYJ</a><br />

2881. Jay Jarvinen  <a href="mailto:jjarvinen@cpan.org">&lt;jjarvinen@cpan.org&gt;</a> -- JJARVINEN<br />
2882. Jay Kuri  <a href="mailto:jayk@cpan.org">&lt;jayk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAYK">JAYK</a><br />
2883. <a href="http://www.infonium.ca/">Jay Lawrence</a>  <a href="mailto:jlawrenc@cpan.org">&lt;jlawrenc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLAWRENC">JLAWRENC</a><br />

2884. <a href="http://www.vermonster.com">Jay Powers</a>  <a href="mailto:jay@vermonster.com">&lt;jay@vermonster.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPOWERS">JPOWERS</a><br />
2885. Jay Rogers  <a href="mailto:jay@rgrs.com">&lt;jay@rgrs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JROGERS">JROGERS</a><br />
2886. <a href="http://jay.scherrer.com">Jay Scherrer</a>  <a href="mailto:jay@scherrer.com">&lt;jay@scherrer.com&gt;</a> -- GIMPIT<br />

2887. <a href="http://www.soffian.org/jay/">Jay Soffian</a>  <a href="mailto:jay-cpan@soffian.org">&lt;jay-cpan@soffian.org&gt;</a> -- JSOFFIAN<br />
2888. Jay Strauss  <a href="mailto:tws_at_heyjay_dot_com">&lt;tws_at_heyjay_dot_com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSTRAUSS">JSTRAUSS</a><br />
2889. <a href="http://www.geocities.com/jaywheeler.geo/">Jay Wheeler</a>  <a href="mailto:JayWheeler@Geocities.com">&lt;JayWheeler@Geocities.com&gt;</a> -- JWGEO<br />

2890. Jaye Speaks  <a href="mailto:jspeaks@yahoo.com">&lt;jspeaks@yahoo.com&gt;</a> -- JSPEAKS<br />
2891. Jean Carlo  <a href="mailto:jeansc16@bol.com.br">&lt;jeansc16@bol.com.br&gt;</a> -- JEAN<br />
2892. Jean Forget  <a href="mailto:J2N-FORGET@wanadoo.fr">&lt;J2N-FORGET@wanadoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFORGET">JFORGET</a><br />
2893. Jean Galineau  <a href="mailto:jean.galineau@francetelecom.com">&lt;jean.galineau@francetelecom.com&gt;</a> -- JGL<br />

2894. Jean Tavernier  <a href="mailto:jj.tavernier@gmail.com">&lt;jj.tavernier@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTAVERNI">JTAVERNI</a><br />
2895. Jean-Baptiste Nivoit  <a href="mailto:jbnivoit@hotmail.com">&lt;jbnivoit@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBNIVOIT">JBNIVOIT</a><br />
2896. Jean-Christian HASSLER  <a href="mailto:hasslerjeanchristian@gmail.com">&lt;hasslerjeanchristian@gmail.com&gt;</a> -- JCHASSLER<br />

2897. Jean-Christophe Kermagoret  <a href="mailto:jck@BabelObjects.Org">&lt;jck@BabelObjects.Org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KERMAGO">KERMAGO</a><br />
2898. <a href="http://jczeus.com">Jean-Christophe Zeus</a>  <a href="mailto:jczeus@googlemail.com">&lt;jczeus@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCZEUS">JCZEUS</a><br />
2899. <a href="http://www.tebbal.demon.co.uk">Jean-Claude Tebbal</a>  <a href="mailto:jct@tebbal.demon.co.uk">&lt;jct@tebbal.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCTEBBAL">JCTEBBAL</a><br />

2900. Jean-François PARIS  <a href="mailto:mjediyoda@free.fr">&lt;mjediyoda@free.fr&gt;</a> -- ROUGE<br />
2901. <a href="http://www.soundobjectlogic.com">Jean-Louis Leroy</a>  <a href="mailto:jll@soundobjectlogic.com">&lt;jll@soundobjectlogic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLLEROY">JLLEROY</a><br />
2902. <a href="http://www.bribes.org/perl/">Jean-Louis Morel</a>  <a href="mailto:jl_morel@bribes.org">&lt;jl_morel@bribes.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLMOREL">JLMOREL</a><br />

2903. <a href="http://www.suricate.net/">Jean-Marc Pennel</a>  <a href="mailto:jmp@noos.fr">&lt;jmp@noos.fr&gt;</a> -- JMPENNEL<br />
2904. <a href="http://jean.marie.gouarne.online.fr">Jean-Marie Gouarné</a>  <a href="mailto:jmgdoc@cpan.org">&lt;jmgdoc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMGDOC">JMGDOC</a><br />
2905. <a href="http://abusus.lost-oasis.net/">Jean-Marie Renouard</a>  <a href="mailto:jmrenouard@gmail.com">&lt;jmrenouard@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRAUONER">DRAUONER</a><br />

2906. Jean-Michel Fayard  <a href="mailto:jmfayard@gmail.com">&lt;jmfayard@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMFAYARD">JMFAYARD</a><br />
2907. <a href="http://ykoz.net/">Jean-Michel Hiver</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHIVER">JHIVER</a><br />
2908. Jean-Michel Marcastel  <a href="mailto:">&lt;&gt;</a> -- DONM<br />

2909. <a href="http://www.faeryscape.com">Jean-Michel Vilomet</a>  <a href="mailto:jmichel@faeryscape.com">&lt;jmichel@faeryscape.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMVILOMET">JMVILOMET</a><br />
2910. Jean-Noël SIMONNET  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JNSIMONN<br />
2911. <a href="http://www.durrios.com">Jean-Philippe Durrios</a>  <a href="mailto:jpdurrios@yahoo.com">&lt;jpdurrios@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPDURRIOS">JPDURRIOS</a><br />

2912. Jean-Pierre Vidal  <a href="mailto:jpvidal@cpan.org">&lt;jpvidal@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPVIDAL">JPVIDAL</a><br />
2913. Jeesmon Jacob  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JEESMON<br />
2914. Jeff Almond  <a href="mailto:Jeff@prospecthouse.net">&lt;Jeff@prospecthouse.net&gt;</a> -- PDLMAN<br />
2915. Jeff Anderson  <a href="mailto:jeaander@gmail.com">&lt;jeaander@gmail.com&gt;</a> -- JEAANDER<br />

2916. <a href="http://www.pvrcanada.com">Jeff Anderson</a>  <a href="mailto:jeff@pvrcanada.com">&lt;jeff@pvrcanada.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JETTRA">JETTRA</a><br />
2917. <a href="http://jbisbee.multiply.com/">Jeff Bisbee</a>  <a href="mailto:jbisbee@cpan.org">&lt;jbisbee@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBISBEE">JBISBEE</a><br />
2918. Jeff Childers  <a href="mailto:arcnon@sbcglobal.net">&lt;arcnon@sbcglobal.net&gt;</a> -- ARCNON<br />

2919. <a href="http://www.slimcd.com/">Jeff Craton</a>  <a href="mailto:perlhakr@bellsouth.net">&lt;perlhakr@bellsouth.net&gt;</a> -- TRACKONE<br />
2920. <a href="http://www.spudzeppelin.com/">Jeff D. Almeida</a>  <a href="mailto:spud@spudzeppelin.com">&lt;spud@spudzeppelin.com&gt;</a> -- SPUD<br />
2921. Jeff Dutton  <a href="mailto:jeff_dutton@hotmail.com">&lt;jeff_dutton@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDUTTON">JDUTTON</a><br />

2922. Jeff Finucane  <a href="mailto:jeff-cpan@weasellips.com">&lt;jeff-cpan@weasellips.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEF">JEF</a><br />
2923. Jeff Goff  <a href="mailto:drforr@pobox.com">&lt;drforr@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGOFF">JGOFF</a><br />
2924. Jeff Higham  <a href="mailto:">&lt;&gt;</a> -- UNIXNOMAD<br />
2925. Jeff Hobbs  <a href="mailto:jeffh@activestate.com">&lt;jeffh@activestate.com&gt;</a> -- HOBBS<br />

2926. <a href="http://www.smashing.org">Jeff Horwitz</a>  <a href="mailto:jeff@smashing.org">&lt;jeff@smashing.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHORWITZ">JHORWITZ</a><br />
2927. Jeff Kim  <a href="mailto:dohyun@hollow.org">&lt;dohyun@hollow.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKIM">JKIM</a><br />
2928. Jeff Klein  <a href="mailto:jeffrey.klein@priorityhealth.com">&lt;jeffrey.klein@priorityhealth.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KL/KLEINJ">KLEINJ</a><br />

2929. <a href="http://claimid.com/kubina">Jeff Kubina</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KUBINA<br />
2930. Jeff Lathan  <a href="mailto:lathan@pobox.com">&lt;lathan@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLATHAN">JLATHAN</a><br />
2931. Jeff Lavallee  <a href="mailto:jeff at zeroclue dot com">&lt;jeff at zeroclue dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLAVALLEE">JLAVALLEE</a><br />

2932. Jeff Lowrey  <a href="mailto:">&lt;&gt;</a> -- JLOWREY<br />
2933. <a href="http://www.bignose.ca">Jeff MacDonald</a>  <a href="mailto:bignose@gmail.com">&lt;bignose@gmail.com&gt;</a> -- BIGNOSE<br />
2934. Jeff McCarrell  <a href="mailto:jwm@emptech.com">&lt;jwm@emptech.com&gt;</a> -- MCCARRELL<br />
2935. <a href="http://www.afn.org/~riffer/">Jeff Mercer</a>  <a href="mailto:riffer@vaxer.net">&lt;riffer@vaxer.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIFFER">RIFFER</a><br />

2936. <a href="http://www.mock.com">Jeff Mock</a>  <a href="mailto:jeff@mock.com">&lt;jeff@mock.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFFMOCK">JEFFMOCK</a><br />
2937. Jeff Murphy  <a href="mailto:jcmurphy@smurfland.cit.buffalo.edu">&lt;jcmurphy@smurfland.cit.buffalo.edu&gt;</a> -- JCMURPHY<br />
2938. <a href="http://developer.ebay.com">Jeff Nokes</a>  <a href="mailto:perl@ebay.com">&lt;perl@ebay.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EB/EBAY">EBAY</a><br />

2939. <a href="http://www.hollow.org/~jeffnor/">Jeff Norusis</a>  <a href="mailto:jeffnor@hollow.org">&lt;jeffnor@hollow.org&gt;</a> -- JNORUSIS<br />
2940. Jeff Ohrt  <a href="mailto:ohrt@johrt.com">&lt;ohrt@johrt.com&gt;</a> -- OHRT<br />
2941. <a href="http://www.seiyuu.com/okamoto">Jeff Okamoto</a>  <a href="mailto:okamoto@corp.hp.com">&lt;okamoto@corp.hp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OK/OKAMOTO">OKAMOTO</a><br />

2942. Jeff Pace  <a href="mailto:jpace@cpan.org">&lt;jpace@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPACE">JPACE</a><br />
2943. <a href="http://home.arcor.de/pangj/">Jeff Pang</a>  <a href="mailto:JeffHua@aol.com">&lt;JeffHua@aol.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PANGJ">PANGJ</a><br />
2944. <a href="http://japhy.perlmonk.org/">Jeff Pinyan</a>  <a href="mailto:japhy.734+CPAN@gmail.com">&lt;japhy.734+CPAN@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PINYAN">PINYAN</a><br />

2945. <a href="http://www.jeffrodriguez.com">Jeff Rodriguez</a>  <a href="mailto:jeff@jeffrodriguez.com">&lt;jeff@jeffrodriguez.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JROD">JROD</a><br />
2946. <a href="http://cscsun1.larc.nasa.gov/~beowulf/index.html">Jeff Rowe</a>  <a href="mailto:j.p.rowe@larc.nasa.gov">&lt;j.p.rowe@larc.nasa.gov&gt;</a> -- JROWE<br />
2947. Jeff T. Parsons  <a href="mailto:bynari8@gmail.com">&lt;bynari8@gmail.com&gt;</a> -- JTP<br />

2948. Jeff Urlwin  <a href="mailto:jurlwin@bellatlantic.net">&lt;jurlwin@bellatlantic.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JURL">JURL</a><br />
2949. Jeff Walter  <a href="mailto:jeffw@404ster.com">&lt;jeffw@404ster.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFFW">JEFFW</a><br />
2950. <a href="http://www.tcp4me.com">Jeff Weisberg</a>  <a href="mailto:jaw+pause@tcp4me.com">&lt;jaw+pause@tcp4me.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAW">JAW</a><br />

2951. Jeff Wright  <a href="mailto:devos@jwdomain.com">&lt;devos@jwdomain.com&gt;</a> -- JWDOMAIN<br />
2952. <a href="http://yoak.com/">Jeff Yoak</a>  <a href="mailto:jeff@yoak.com">&lt;jeff@yoak.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFFY">JEFFY</a><br />
2953. <a href="http://www.theblobshop.com">Jeff Younker</a>  <a href="mailto:jeff@math.uh.edu">&lt;jeff@math.uh.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFF">JEFF</a><br />

2954. <a href="http://www.vpservices.com/jeff/">Jeff Zucker</a>  <a href="mailto:jeff@vpservices.com">&lt;jeff@vpservices.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JZ/JZUCKER">JZUCKER</a><br />
2955. Jefferson Kirkland  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JLK<br />
2956. <a href="http://www.saturn5.com/~jwb">Jeffrey Baker</a>  <a href="mailto:jwbaker@acm.org">&lt;jwbaker@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBAKER">JBAKER</a><br />

2957. Jeffrey Black  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JEFFBLACK<br />
2958. <a href="http://www.borlik.net/">Jeffrey Borlik</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BORLIK">BORLIK</a><br />
2959. <a href="http://freemedsoftware.org/">Jeffrey Buchbinder</a>  <a href="mailto:jeff@freemedsoftware.org">&lt;jeff@freemedsoftware.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RT/RTFIREFLY">RTFIREFLY</a><br />

2960. <a href="http://www.genezzo.com">Jeffrey Cohen</a>  <a href="mailto:jcohen@cpan.org">&lt;jcohen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCOHEN">JCOHEN</a><br />
2961. Jeffrey Edward Pikul  <a href="mailto:jpikul@linux.ca">&lt;jpikul@linux.ca&gt;</a> -- JPIKUL<br />
2962. <a href="http://regex.info">Jeffrey Friedl</a>  <a href="mailto:jfriedl@yahoo.com">&lt;jfriedl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFRIEDL">JFRIEDL</a><br />

2963. <a href="http://unlocalhost.com/XHTML_Table/">Jeffrey Hayes Anderson</a>  <a href="mailto:captvanhalen@yahoo.com">&lt;captvanhalen@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFFA">JEFFA</a><br />
2964. <a href="http://www.hotsos.com">Jeffrey Holt</a>  <a href="mailto:jeff.holt@hotsos.com">&lt;jeff.holt@hotsos.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLHOLT">JLHOLT</a><br />
2965. Jeffrey Horn  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HORN<br />

2966. <a href="http://www.sctconsulting.com/~jeffh">Jeffrey Hulten</a>  <a href="mailto:jeffh@sctconsulting.com">&lt;jeffh@sctconsulting.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEFFH">JEFFH</a><br />
2967. <a href="www.redhawk.org  AND gwc.sourceforge.net">Jeffrey J. Welty</a>  <a href="mailto:jeff@redhawk.org">&lt;jeff@redhawk.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WE/WELTYJJ">WELTYJJ</a><br />
2968. Jeffrey Kegler  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKEGL">JKEGL</a><br />

2969. <a href="http://xtype.perlmonk.org">Jeffrey Kern</a>  <a href="mailto:xtype-at-knowfear-dot-net">&lt;xtype-at-knowfear-dot-net&gt;</a> -- XTYPE<br />
2970. Jeffrey Ratcliffe  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RATCLIFFE">RATCLIFFE</a><br />
2971. Jeffrey Ray Hallock  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JHALLOCK<br />

2972. <a href="http://perlcritic.org">Jeffrey Ryan Thalhammer</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THALJEF">THALJEF</a><br />
2973. Jeffrey Watkins  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RHYTHM<br />
2974. <a href="http://samba.org/~jelmer/">Jelmer Vernooij</a>  <a href="mailto:jelmer@samba.org">&lt;jelmer@samba.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CT/CTRLSOFT">CTRLSOFT</a><br />

2975. Jenny Dickinson  <a href="mailto:bugs@jennys.info">&lt;bugs@jennys.info&gt;</a> -- JENNY<br />
2976. <a href="http://www.speech.kth.se/~edlund/">Jens Edlund</a>  <a href="mailto:edlund@speech.kth.se">&lt;edlund@speech.kth.se&gt;</a> -- JENS<br />
2977. <a href="http://www.atomix.de">Jens Gassmann</a>  <a href="mailto:jegade@cpan.org">&lt;jegade@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEGADE">JEGADE</a><br />

2978. Jens Helberg  <a href="mailto:jens.helberg@de.bosch.com">&lt;jens.helberg@de.bosch.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHELBERG">JHELBERG</a><br />
2979. Jens Heunemann  <a href="mailto:heunemann@web.de">&lt;heunemann@web.de&gt;</a> -- JENSH<br />
2980. <a href="www.jjoseph.de">Jens Joseph</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JENSJ<br />

2981. <a href="http://perldude.de/">Jens Luedicke</a>  <a href="mailto:jens.luedicke@gmail.com">&lt;jens.luedicke@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JENSL">JENSL</a><br />
2982. <a href="http://www.rehsack.de/">Jens Rehsack</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REHSACK">REHSACK</a><br />
2983. <a href="http://toerring.de">Jens Thoms Törring</a>  <a href="mailto:jt@toerring.de">&lt;jt@toerring.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTT">JTT</a><br />

2984. Jens Vegeby  <a href="mailto:jens@vegeby.nu">&lt;jens@vegeby.nu&gt;</a> -- SLOBBAN<br />
2985. <a href="http://www.helios.de">Jens-Uwe Mager</a>  <a href="mailto:jum@helios.de">&lt;jum@helios.de&gt;</a> -- JUM<br />
2986. <a href="http://jeremiahfoster.com">Jeremiah Foster</a>  <a href="mailto:jeremiah@cpan.org">&lt;jeremiah@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEREMIAH">JEREMIAH</a><br />

2987. <a href="http://www.perlreason.com">Jeremiah Jordan</a>  <a href="mailto:jjordan@perlreason.com">&lt;jjordan@perlreason.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJORDAN">JJORDAN</a><br />
2988. Jeremiah Lee  <a href="mailto:texasjdl@yahoo.com">&lt;texasjdl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDLEE">JDLEE</a><br />
2989. Jeremiah Mahler  <a href="mailto:jmahler@pacbell.net">&lt;jmahler@pacbell.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JERI">JERI</a><br />

2990. Jeremie Klein  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRM">GRM</a><br />
2991. <a href="http://jeremie.com/">Jeremie Miller</a>  <a href="mailto:jer@jeremie.com">&lt;jer@jeremie.com&gt;</a> -- JEREMIE<br />
2992. Jeremy Blain  <a href="mailto:cowboyatheart@gmail.com">&lt;cowboyatheart@gmail.com&gt;</a> -- COWBOY<br />

2993. <a href="http://www.jerf.org/">Jeremy Bowers</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JERF<br />
2994. Jeremy Cortner  <a href="mailto:jcortner-at-cvol-dot-net">&lt;jcortner-at-cvol-dot-net&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OP/OPHIUCI">OPHIUCI</a><br />
2995. <a href="www.mobile-o.com">Jeremy D. Brooks</a>  <a href="mailto:jbrooks@mobile-o.com">&lt;jbrooks@mobile-o.com&gt;</a> -- JERBROO<br />

2996. <a href="http://jeremy.zawodny.com/">Jeremy D. Zawodny</a>  <a href="mailto:Jeremy@Zawodny.com">&lt;Jeremy@Zawodny.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JZ/JZAWODNY">JZAWODNY</a><br />
2997. <a href="http://www.ellman.freeserve.co.uk/">Jeremy Ellman</a>  <a href="mailto:jeremy at ellman dot freeserve dot  co dot uk">&lt;jeremy at ellman dot freeserve dot  co dot uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JELLMAN">JELLMAN</a><br />
2998. <a href="http://use.perl.org/~jfluhmann">Jeremy Fluhmann</a>  <a href="mailto:fluhmann@gmail.com">&lt;fluhmann@gmail.com&gt;</a> -- JFLUHMANN<br />

2999. <a href="http://www.evoscript.org">Jeremy G. Bishop</a>  <a href="mailto:jeremy@evolution.com">&lt;jeremy@evolution.com&gt;</a> -- JGBISHOP<br />
3000. Jeremy Gilbert  <a href="mailto:jgilbert@gtemail.net">&lt;jgilbert@gtemail.net&gt;</a> -- JGILB<br />
3001. Jeremy Howard  <a href="mailto:j+cpan@no_spam_please_howard.fm">&lt;j+cpan@no_spam_please_howard.fm&gt;</a> -- HOWARD<br />

3002. <a href="http://www.gweep.net/~jer/">Jeremy Johnson</a>  <a href="mailto:jer@gweep.net">&lt;jer@gweep.net&gt;</a> -- USAGIJER<br />
3003. <a href="http://www.jeremyjones.com/">Jeremy Jones</a>  <a href="mailto:jjones@cpan.org">&lt;jjones@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJONES">JJONES</a><br />
3004. <a href="http://students.washington.edu/~jgk/perl.html">Jeremy Kahn</a>  <a href="mailto:kahn@cpan.org">&lt;kahn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAHN">KAHN</a><br />

3005. <a href="http://jeremy.kister.net/">Jeremy Kister</a>  <a href="mailto:pause.perl.org_@t_jeremykister.com">&lt;pause.perl.org_@t_jeremykister.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKISTER">JKISTER</a><br />
3006. <a href="http://scriptkitchen.com/">Jeremy Kitchen</a>  <a href="mailto:kitchen@scriptkitchen.com">&lt;kitchen@scriptkitchen.com&gt;</a> -- KITCHEN<br />
3007. Jeremy Madea  <a href="mailto:jdm@pobox.com">&lt;jdm@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEREMY">JEREMY</a><br />

3008. <a href="http://sial.org/">Jeremy Mates</a>  <a href="mailto:jmates@sial.org">&lt;jmates@sial.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMATES">JMATES</a><br />
3009. <a href="http://www.bitflood.org/~jmuhlich/">Jeremy Muhlich</a>  <a href="mailto:jmuhlich at bitflood.org">&lt;jmuhlich at bitflood.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMUHLICH">JMUHLICH</a><br />
3010. Jeremy Nixon  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNIXON">JNIXON</a><br />

3011. <a href="http://jepri.perlmonk.org/">Jeremy Price</a>  <a href="mailto:jeremy.price@member.sage-au.org.au">&lt;jeremy.price@member.sage-au.org.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEPRICE">JEPRICE</a><br />
3012. <a href="www.jkslade.net">Jeremy Slade</a>  <a href="mailto:jeremy@jkslade.net">&lt;jeremy@jkslade.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGS">JGS</a><br />
3013. <a href="http://www.wadsack-allen.com/digitalgroup/">Jeremy Wadsack</a>  <a href="mailto:jeremy.wadsack@gmail.com">&lt;jeremy.wadsack@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WADG">WADG</a><br />

3014. <a href="http://jeremy.marzhillstudios.com/">Jeremy Wall</a>  <a href="mailto:jeremy@marzhillstudios.com">&lt;jeremy@marzhillstudios.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZAPHAR">ZAPHAR</a><br />
3015. Jeremy Walton  <a href="mailto:rahly@evhallion.com">&lt;rahly@evhallion.com&gt;</a> -- JEREMYW<br />
3016. <a href="http://www.geocities.com/macfaqnl">Jeroen Elassaiss-Schaap</a>  <a href="mailto:ceejeenl@yahoo.com">&lt;ceejeenl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEROENES">JEROENES</a><br />

3017. Jerome Baum  <a href="mailto:">&lt;&gt;</a> -- GRATEMYL<br />
3018. <a href="http://www.eteve.net/">Jerome Eteve</a>  <a href="mailto:jeromeAteteveDotnet">&lt;jeromeAteteveDotnet&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JETEVE">JETEVE</a><br />
3019. Jerome Quelin  <a href="mailto:jquelin@cpan.org">&lt;jquelin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JQ/JQUELIN">JQUELIN</a><br />

3020. Jerome V. Braun  <a href="mailto:jerome.braun@kmri.com">&lt;jerome.braun@kmri.com&gt;</a> -- JVB<br />
3021. <a href="http://www.pthbb.org/">Jerrad Pierce</a>  <a href="mailto:jpierce@cpan.org">&lt;jpierce@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPIERCE">JPIERCE</a><br />
3022. Jerry D. Hedden  <a href="mailto:jdhedden@cpan.org">&lt;jdhedden@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDHEDDEN">JDHEDDEN</a><br />

3023. Jerry LeVan  <a href="mailto:levan@eagle.eku.edu">&lt;levan@eagle.eku.edu&gt;</a> -- JLEVAN<br />
3024. Jerry Nichols  <a href="mailto:jnichols13@yahoo.com">&lt;jnichols13@yahoo.com&gt;</a> -- JNICHOLS<br />
3025. Jerry Veldhuis  <a href="mailto:jerry@matilda.com">&lt;jerry@matilda.com&gt;</a> -- JERRYV<br />
3026. <a href="http://xdash.jabberstudio.org">Jerzy Wachowiak</a>  <a href="mailto:jerzy.wachowiak@wp.pl">&lt;jerzy.wachowiak@wp.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWACH">JWACH</a><br />

3027. Jesper Dalberg  <a href="mailto:jesper@jdn.dk">&lt;jesper@jdn.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDALBERG">JDALBERG</a><br />
3028. <a href="http://www.adsl-optimizer.dk/">Jesper Dangaard Brouer</a>  <a href="mailto:hawk@cpan.org">&lt;hawk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAWK">HAWK</a><br />
3029. <a href="http://www.printf.dk">Jesper Nøhr</a>  <a href="mailto:jesper@noehr.org">&lt;jesper@noehr.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DECIUS">DECIUS</a><br />

3030. Jess Robinson  <a href="mailto:cpan@desert-island.me.uk">&lt;cpan@desert-island.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JROBINSON">JROBINSON</a><br />
3031. <a href="http://pobox.com/~jesse.brown/">Jesse Brown</a>  <a href="mailto:jbrown@cpan.org">&lt;jbrown@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBROWN">JBROWN</a><br />
3032. Jesse Cheung  <a href="mailto:">&lt;&gt;</a> -- JESSEG<br />

3033. <a href="http://www.erlbaum.net/">Jesse Erlbaum</a>  <a href="mailto:jesse@erlbaum.net">&lt;jesse@erlbaum.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JERLBAUM">JERLBAUM</a><br />
3034. Jesse Luehrs  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOY">DOY</a><br />
3035. Jesse N. Glick  <a href="mailto:jglick@sig.bsh.com">&lt;jglick@sig.bsh.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGLICK">JGLICK</a><br />

3036. Jesse Porter  <a href="mailto:porterje@cpan.org">&lt;porterje@cpan.org&gt;</a> -- PORTERJE<br />
3037. <a href="http://jaspax.com">Jesse S. Bangs</a>  <a href="mailto:jaspax@cpan.org">&lt;jaspax@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASPAX">JASPAX</a><br />
3038. Jesse Sheidlower  <a href="mailto:jester@panix.com">&lt;jester@panix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JESTER">JESTER</a><br />

3039. Jesse Shy  <a href="mailto:jesseshy@gmail.com">&lt;jesseshy@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSHY">JSHY</a><br />
3040. <a href="http://www.jessestay.com">Jesse Stay</a>  <a href="mailto:jesse@thestays.org">&lt;jesse@thestays.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JESSESTAY">JESSESTAY</a><br />
3041. <a href="http://www.bestpractical.com">Jesse Vincent</a>  <a href="mailto:jesse+cpan@fsck.com">&lt;jesse+cpan@fsck.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JESSE">JESSE</a><br />

3042. <a href="http://jes5199.com">Jesse Wolfe</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JESFIVE<br />
3043. Jessica Michelle Severin  <a href="mailto:jessica.severin@gmail.com">&lt;jessica.severin@gmail.com&gt;</a> -- JMS<br />
3044. <a href="http://www.x25.org/">Jessica Quaintance</a>  <a href="mailto:j@x25.org">&lt;j@x25.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JESSICAQ">JESSICAQ</a><br />

3045. Jesús Quiroga Martín de Valmaseda  <a href="mailto:jquiroga@jquiroga.com">&lt;jquiroga@jquiroga.com&gt;</a> -- JQUIROGA<br />
3046. <a href="http://www.jevinskie.com">Jevin Sweval</a>  <a href="mailto:jevinsweval@removemegmail.com">&lt;jevinsweval@removemegmail.com&gt;</a> -- JSWEVAL<br />
3047. Jez Hancock  <a href="mailto:">&lt;&gt;</a> -- JEZHANCO<br />
3048. Jiaxiaolong  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TIMJIA<br />

3049. Jim Bacon  <a href="mailto:jim@nortx.com">&lt;jim@nortx.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOFTX">BOFTX</a><br />
3050. Jim Brandt  <a href="mailto:cbrandt@cpan.org">&lt;cbrandt@cpan.org&gt;</a> -- CBRANDT<br />
3051. Jim Cromie  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCROMIE">JCROMIE</a><br />
3052. Jim Dixon  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JDDIXON<br />

3053. <a href="http://www.inmet.gov.br/~jedwards">Jim Edwards</a>  <a href="mailto:inmet@altavista.com">&lt;inmet@altavista.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEDWARDS">JEDWARDS</a><br />
3054. <a href="http://jimfl.tensegrity.net">Jim Flanagan</a>  <a href="mailto:jimfl@tensegrity.net">&lt;jimfl@tensegrity.net&gt;</a> -- JIMFL<br />
3055. Jim Garrison  <a href="mailto:jhg@acm.org">&lt;jhg@acm.org&gt;</a> -- JGARRISON<br />

3056. <a href="http://www.thegarvin.com">Jim Garvin</a>  <a href="mailto:jg.perl@thegarvin.com">&lt;jg.perl@thegarvin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGARVIN">JGARVIN</a><br />
3057. <a href="jim.gibson.org">Jim Gibson</a>  <a href="mailto:Jim@Gibson.org">&lt;Jim@Gibson.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGIBSON">JGIBSON</a><br />
3058. <a href="www.imap-partners.net">Jim Hickstein</a>  <a href="mailto:jxh@imap-partners.net">&lt;jxh@imap-partners.net&gt;</a> -- JXH<br />

3059. <a href="http://www.cise.ufl.edu/~jfh/">Jim Hranicky</a>  <a href="mailto:jfh@cise.ufl.edu">&lt;jfh@cise.ufl.edu&gt;</a> -- HRANICKY<br />
3060. Jim Krajewski  <a href="mailto:jkraj@echosoft.com">&lt;jkraj@echosoft.com&gt;</a> -- JKRAJ<br />
3061. Jim Lambert  <a href="mailto:jlambert@brandeis.edu">&lt;jlambert@brandeis.edu&gt;</a> -- JIMLAMBRT<br />

3062. <a href="http://cs.marlboro.edu">Jim Mahoney</a>  <a href="mailto:mahoney@marlboro.edu">&lt;mahoney@marlboro.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMAHONEY">JMAHONEY</a><br />
3063. Jim Martinez  <a href="mailto:pause@bigbigorg.org">&lt;pause@bigbigorg.org&gt;</a> -- JIM<br />
3064. Jim McDonnell  <a href="mailto:jim_mcdonnell_@hotmail.com">&lt;jim_mcdonnell_@hotmail.com&gt;</a> -- MARIAN<br />

3065. Jim Meyer  <a href="mailto:purp@cpan.org">&lt;purp@cpan.org&gt;</a> -- PURP<br />
3066. Jim Meyering  <a href="mailto:jim@meyering.net">&lt;jim@meyering.net&gt;</a> -- MEYERING<br />
3067. Jim Mozley  <a href="mailto:jim@greenboots.org">&lt;jim@greenboots.org&gt;</a> -- SWAMPY<br />
3068. Jim Pirzyk  <a href="mailto:pirzyk@freebsd.org">&lt;pirzyk@freebsd.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIRZYK">PIRZYK</a><br />

3069. Jim Pravetz  <a href="mailto:jpravetz@adobe.com">&lt;jpravetz@adobe.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPRAVETZ">JPRAVETZ</a><br />
3070. <a href="http://home.att.net/~jreprogle/">Jim Reprogle</a>  <a href="mailto:jreprogle@worldnet.att.net">&lt;jreprogle@worldnet.att.net&gt;</a> -- JREPROGLE<br />
3071. <a href="http://home.hiwaay.net/~jimes">Jim Scarborough</a>  <a href="mailto:jimes@hiwaay.net">&lt;jimes@hiwaay.net&gt;</a> -- JIMS<br />

3072. Jim Schneider  <a href="mailto:perl@jrcsdevelopment.com">&lt;perl@jrcsdevelopment.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSCHNEID">JSCHNEID</a><br />
3073. <a href="http://www.tqis.com/">Jim Schueler</a>  <a href="mailto:jschueler@tqis.com">&lt;jschueler@tqis.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TQ/TQISJIM">TQISJIM</a><br />
3074. <a href="http://irover.org/">Jim Smyser</a>  <a href="mailto:jsmyser@bigfoot.com">&lt;jsmyser@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSMYSER">JSMYSER</a><br />

3075. <a href="http://www.jimandkoka.com/">Jim Thomason</a>  <a href="mailto:jim@jimandkoka.com">&lt;jim@jimandkoka.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JIMT">JIMT</a><br />
3076. <a href="http://arctic.org/~trockij/">Jim Trocki</a>  <a href="mailto:trockij@linux.kernel.org">&lt;trockij@linux.kernel.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TR/TROCKIJ">TROCKIJ</a><br />
3077. <a href="http://home.mesh.net/turnerjw/jim">Jim Turner</a>  <a href="mailto:turnerjw784@yahoo.com">&lt;turnerjw784@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TU/TURNERJW">TURNERJW</a><br />

3078. Jim Walker  <a href="mailto:jim@reclaw.com">&lt;jim@reclaw.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RECLAW">RECLAW</a><br />
3079. <a href="http://trainedmonkey.com/">Jim Winstead</a>  <a href="mailto:jimw-removetoemail@trainedmonkey.com">&lt;jimw-removetoemail@trainedmonkey.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JIMW">JIMW</a><br />
3080. Jim Woodgate  <a href="mailto:woody@realtime.net">&lt;woody@realtime.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WOODY">WOODY</a><br />

3081. Jimi Mikusi  <a href="mailto:jimbox-cpan@doubleprecision.com">&lt;jimbox-cpan@doubleprecision.com&gt;</a> -- JIMBOX<br />
3082. <a href="http://webu.co.uk/">Jimi-Carlo Bukowski-Wills</a>  <a href="mailto:jimicarlo@gmail.com">&lt;jimicarlo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JIMI">JIMI</a><br />
3083. Jing Kang - 康 小靖  <a href="mailto:kxj@hotmail.com">&lt;kxj@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KX/KXJ">KXJ</a><br />

3084. <a href="http://spiritloose.net/">Jiro Nishiguchi</a>  <a href="mailto:jiro@cpan.org">&lt;jiro@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JIRO">JIRO</a><br />
3085. Jiří Václavík  <a href="mailto:jiri.vaclaNOSPAMvik@gmail.com">&lt;jiri.vaclaNOSPAMvik@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIHIK">HIHIK</a><br />
3086. <a href="http://www.svlife.com">Jm Valera</a>  <a href="mailto:imjm@svlife.com">&lt;imjm@svlife.com&gt;</a> -- NEVDULL<br />

3087. <a href="http://www.seibert-media.net">Jo Seibert</a>  <a href="mailto:joseibert@cpan.org">&lt;joseibert@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSEIBERT">JOSEIBERT</a><br />
3088. <a href="http://www.zooleika.org.uk">Jo Walsh</a>  <a href="mailto:jo@london.pm.org">&lt;jo@london.pm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZO/ZOOLEIKA">ZOOLEIKA</a><br />
3089. <a href="http://www.heute-morgen.de">Joachim Zobel</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JZ/JZOBEL">JZOBEL</a><br />

3090. Joao Fonseca  <a href="mailto:joao_g_fonseca@yahoo.com">&lt;joao_g_fonseca@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPAF">JPAF</a><br />
3091. Joaquin Ferrero  <a href="mailto:explorer@joaquinferrero.com">&lt;explorer@joaquinferrero.com&gt;</a> -- EXPLORER<br />
3092. <a href="http://www.mondongo.com.ar">Joaquín Pérez</a>  <a href="mailto:joaquin@mondongo.com.ar">&lt;joaquin@mondongo.com.ar&gt;</a> -- MONDONGO<br />

3093. <a href="jobva.nl">Job van Achterberg</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JKVA<br />
3094. <a href="http://www.jochen-lillich.de">Jochen Lillich</a>  <a href="mailto:geewiz@cpan.org">&lt;geewiz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEEWIZ">GEEWIZ</a><br />
3095. <a href="http://www.legasthenie-ist-keine-schande.de/">Jochen Schneider</a>  <a href="mailto:jochen.schneider@mediaways.net">&lt;jochen.schneider@mediaways.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOCHEN">JOCHEN</a><br />

3096. Jochen Schrör  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JSCHROER<br />
3097. Jochen Stenzel  <a href="mailto:perl@jochen-stenzel.de">&lt;perl@jochen-stenzel.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSTENZEL">JSTENZEL</a><br />
3098. <a href="ftp://ftp.funet.fi/pub/languages/perl/CPAN/authors/id/JWIED">Jochen Wiedmann</a>  <a href="mailto:jwied@cpan.org">&lt;jwied@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWIED">JWIED</a><br />

3099. Jody Belka  <a href="mailto:">&lt;&gt;</a> -- YODA<br />
3100. Jody Belka  <a href="mailto:knew@cpan.org">&lt;knew@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNEW">KNEW</a><br />
3101. Jody Biggs  <a href="mailto:bigbiggsj@yahoo.com">&lt;bigbiggsj@yahoo.com&gt;</a> -- JBIGGS<br />
3102. Jody Clements  <a href="mailto:jody@dascii.com">&lt;jody@dascii.com&gt;</a> -- JCLEMENTS<br />

3103. <a href="infohio.mecdc.org:3000">Joe Atzberger</a>  <a href="mailto:atzberger@mecdc.org">&lt;atzberger@mecdc.org&gt;</a> -- ATZ<br />
3104. <a href="http://www.netaxs.com/~joc/">Joe Casadonte</a>  <a href="mailto:joc@netaxs.com">&lt;joc@netaxs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOCASA">JOCASA</a><br />
3105. <a href="http://urltoys.com/">Joe Drago</a>  <a href="mailto:joe@urltoys.com">&lt;joe@urltoys.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDRAGO">JDRAGO</a><br />

3106. <a href="http://www.draxil.uklinux.net/hip">Joe Higton</a>  <a href="mailto:joe@draxil.uklinux.net">&lt;joe@draxil.uklinux.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRAXIL">DRAXIL</a><br />
3107. Joe Hildebrand  <a href="mailto:joe.hildebrand@twcable.com">&lt;joe.hildebrand@twcable.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOEHIL">JOEHIL</a><br />
3108. Joe Hourcle  <a href="mailto:oneiros@annoying.org">&lt;oneiros@annoying.org&gt;</a> -- ONEIROS<br />

3109. Joe Ingersoll  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RALF<br />
3110. <a href="www.joekamphaus.net">Joe Kamphaus</a>  <a href="mailto:joekamphaus@hotmail.com">&lt;joekamphaus@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKAMPHAUS">JKAMPHAUS</a><br />
3111. Joe Mason  <a href="mailto:demented_freak666@hotmail.com">&lt;demented_freak666@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INSANEART">INSANEART</a><br />

3112. <a href="http://ibiblio.org/mcmahon/">Joe McMahon</a>  <a href="mailto:mcmahon@cpan.org">&lt;mcmahon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCMAHON">MCMAHON</a><br />
3113. <a href="http://zentara.net">Joe Milosch</a>  <a href="mailto:zentara@zentara.net">&lt;zentara@zentara.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZT/ZTK">ZTK</a><br />
3114. Joe Minieri  <a href="mailto:jminieri@mindspring.com">&lt;jminieri@mindspring.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMINIERI">JMINIERI</a><br />

3115. Joe P. Hayes  <a href="mailto:joephayes@yahoo.com">&lt;joephayes@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOEPHAYES">JOEPHAYES</a><br />
3116. <a href="http://www.apache.org/~joes/">Joe Schaefer</a>  <a href="mailto:apreq-dev@httpd.apache.org">&lt;apreq-dev@httpd.apache.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOESUF">JOESUF</a><br />
3117. Joe Slagel  <a href="mailto:slagel@geospiza.com">&lt;slagel@geospiza.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSLAGEL">JSLAGEL</a><br />

3118. Joe Spears  <a href="mailto:jlspea01@pacbell.net">&lt;jlspea01@pacbell.net&gt;</a> -- JLSPEARS<br />
3119. Joe Yates  <a href="mailto:lucian.arboraeus@virgilio.it">&lt;lucian.arboraeus@virgilio.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOEYATES">JOEYATES</a><br />
3120. Joel Becker  <a href="mailto:jlbec@ocala.cs.miami.edu">&lt;jlbec@ocala.cs.miami.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLBEC">JLBEC</a><br />

3121. Joel Bernstein  <a href="mailto:rataxis@cpan.org">&lt;rataxis@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RATAXIS">RATAXIS</a><br />
3122. Joel C. Maslak  <a href="mailto:jmaslak@antelope.net">&lt;jmaslak@antelope.net&gt;</a> -- JMASLAK<br />
3123. Joel Noble  <a href="mailto:jnoble@mediaone.com">&lt;jnoble@mediaone.com&gt;</a> -- JNOBLE<br />
3124. <a href="http://www.piquan.org/~joelh/">Joel Ray Holveck</a>  <a href="mailto:piquan.org!joelh">&lt;piquan.org!joelh&gt;</a> -- JOELH<br />

3125. Joel Roth  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GANGLION">GANGLION</a><br />
3126. <a href="http://salvador.pm.org/">Joenio Marques da Costa</a>  <a href="mailto:joenio@cpan.org">&lt;joenio@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOENIO">JOENIO</a><br />
3127. Joep Gommers  <a href="mailto:joep.gommers@gmail.com">&lt;joep.gommers@gmail.com&gt;</a> -- JGOMMERS<br />

3128. Joerg Meltzer  <a href="mailto:joerg@joergmeltzer.de">&lt;joerg@joergmeltzer.de&gt;</a> -- JMELTZER<br />
3129. <a href="http://home.wtal.de/the_swordsman">Joerg Nouvertne</a>  <a href="mailto:joerg.nouvertne@web.de">&lt;joerg.nouvertne@web.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWORDSMAN">SWORDSMAN</a><br />
3130. Joeri Van der Vloet  <a href="mailto:">&lt;&gt;</a> -- VDV<br />

3131. Joey Hess  <a href="mailto:joey@kitenet.net">&lt;joey@kitenet.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOEY">JOEY</a><br />
3132. Joey Karalius  <a href="mailto:">&lt;&gt;</a> -- JKARALIUS<br />
3133. <a href="http://burati.com/">Johan Burati</a>  <a href="mailto:johan@burati.com">&lt;johan@burati.com&gt;</a> -- JBURATI<br />

3134. <a href="http://www.jdegraeve.be/modules">Johan De Graeve</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DGRAEVEJ<br />
3135. Johan Holmberg  <a href="mailto:holmberg@iar.se">&lt;holmberg@iar.se&gt;</a> -- HOLMBERG<br />
3136. <a href="http://www.redantigua.com">Johan Kuuse</a>  <a href="mailto:johan@kuu.se">&lt;johan@kuu.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KUUSE">KUUSE</a><br />

3137. <a href="http://www.DarSerMan.com">Johan Lindström</a>  <a href="mailto:johanl[ÄT]DarSerMan.com">&lt;johanl[ÄT]DarSerMan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHANL">JOHANL</a><br />
3138. Johan Lodin  <a href="mailto:lodin@cpan.org">&lt;lodin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LODIN">LODIN</a><br />
3139. <a href="http://www.reinalda.net/software.html">Johan Reinalda</a>  <a href="mailto:johan at reinalda dot net">&lt;johan at reinalda dot net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHAN">JOHAN</a><br />

3140. <a href="http://www.borago.net/">Johan Schön</a>  <a href="mailto:schoen@cpan.org">&lt;schoen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHOEN">SCHOEN</a><br />
3141. <a href="http://www.tektonica.com">Johan Van den Brande</a>  <a href="mailto:johan (at) vandenbrande (dot) com">&lt;johan (at) vandenbrande (dot) com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHANVDB">JOHANVDB</a><br />
3142. Johan Viklund  <a href="mailto:">&lt;&gt;</a> -- VIKLUND<br />

3143. <a href="http://www.squirrel.nl/people/jvromans">Johan Vromans</a>  <a href="mailto:jv@cpan.org">&lt;jv@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JV/JV">JV</a><br />
3144. <a href="http://www.oefai.at/~juffi/">Johannes Fürnkranz</a>  <a href="mailto:juffi@oefai.at">&lt;juffi@oefai.at&gt;</a> -- JUFFI<br />
3145. <a href="http://www.pqpq.de">Johannes Plunien</a>  <a href="mailto:plu@pqpq.de">&lt;plu@pqpq.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLU">PLU</a><br />

3146. <a href="http://freigeist.org">Johannes Ziemke</a>  <a href="mailto:&quot;guess from my name and my homepage&quot;">&lt;&quot;guess from my name and my homepage&quot;&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FISH">FISH</a><br />
3147. <a href="http://japh.lapoutre.com/">Johannes la Poutré</a>  <a href="mailto:japh AT lapoutre D0T com">&lt;japh AT lapoutre D0T com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLAPOUTRE">JLAPOUTRE</a><br />
3148. <a href="http://www.earlham.edu/~littejo/">John &quot;Rowan&quot; Littell</a>  <a href="mailto:littejo@earlham.edu">&lt;littejo@earlham.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRLITTELL">JRLITTELL</a><br />

3149. <a href="http://ccgb.umn.edu/~crow">John A. Crow</a>  <a href="mailto:crow@ccgb.umn.edu">&lt;crow@ccgb.umn.edu&gt;</a> -- CROWJA<br />
3150. <a href="http://dot.ucop.edu/home/jak/">John A. Kunze</a>  <a href="mailto:jak@ucop.edu">&lt;jak@ucop.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAK">JAK</a><br />
3151. <a href="http://www.crc.ca/FreeWRL/">John A. Stewart</a>  <a href="mailto:john.stewart@crc.ca">&lt;john.stewart@crc.ca&gt;</a> -- JSTEWART<br />

3152. <a href="http://www.aston.ac.uk/~willijar">John A.R. Williams</a>  <a href="mailto:J.A.R.Williams@aston.ac.uk">&lt;J.A.R.Williams@aston.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JARW">JARW</a><br />
3153. <a href="http://www.retina.net/~jna">John Adams</a>  <a href="mailto:jna@retina.net">&lt;jna@retina.net&gt;</a> -- JADAMS<br />
3154. John Adams  <a href="mailto:jadams01@sprynet.com">&lt;jadams01@sprynet.com&gt;</a> -- ADAMSJ<br />

3155. <a href="www.johnalden.co.uk">John Alden</a>  <a href="mailto:johna@cpan.org">&lt;johna@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNA">JOHNA</a><br />
3156. John Allwine  <a href="mailto:jallwine86@yahoo.com">&lt;jallwine86@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JALLWINE">JALLWINE</a><br />
3157. <a href="http://www.johnatkins.net/">John Atkins</a>  <a href="mailto:john@johnatkins.net">&lt;john@johnatkins.net&gt;</a> -- SHRS<br />

3158. <a href="http://www.freebsd.org/~jha">John Aughey</a>  <a href="mailto:jha@aughey.com">&lt;jha@aughey.com&gt;</a> -- JHA<br />
3159. John Baleshiski  <a href="mailto:john@axissite.com">&lt;john@axissite.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BALESHI">BALESHI</a><br />
3160. <a href="john.ballem@gmail.com">John Ballem</a>  <a href="mailto:jpb@cpan.org">&lt;jpb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPB">JPB</a><br />

3161. John Barbee  <a href="mailto:barbee@veribox.net">&lt;barbee@veribox.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARBEE">BARBEE</a><br />
3162. John Bazik  <a href="mailto:jbazik@cpan.org">&lt;jbazik@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBAZIK">JBAZIK</a><br />
3163. <a href="http://github.com/beppu">John Beppu</a>  <a href="mailto:beppu@cpan.org">&lt;beppu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEPPU">BEPPU</a><br />

3164. <a href="http://www.berthels.co.uk">John Berthels</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JBERT<br />
3165. <a href="http://johnbokma.com/perl/">John Bokma</a>  <a href="mailto:via+pause@johnbokma.com">&lt;via+pause@johnbokma.com&gt;</a> -- JOHNBOKMA<br />
3166. <a href="http://www.johnborwick.com">John Borwick</a>  <a href="mailto:borwicjh@wfu.edu">&lt;borwicjh@wfu.edu&gt;</a> -- BORWICK<br />

3167. <a href="http://www.southwestern.edu/~johnk">John C. Koen</a>  <a href="mailto:johnk@southwestern.edu">&lt;johnk@southwestern.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNKOEN">JOHNKOEN</a><br />
3168. <a href="webpages.charter.net">John C. Norton</a>  <a href="mailto:jcnorton@charter.net">&lt;jcnorton@charter.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCNORTON">JCNORTON</a><br />
3169. <a href="http://members.cox.net/quillan/">John C. Quillan</a>  <a href="mailto:quillan@cox.net">&lt;quillan@cox.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JQ/JQUILLAN">JQUILLAN</a><br />

3170. <a href="http://john.phunnel.org">John Cappiello</a>  <a href="mailto:jcap@cpan.org">&lt;jcap@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCAP">JCAP</a><br />
3171. <a href="http://www.cavanaughs.org">John Cavanaugh</a>  <a href="mailto:cavanaughwww-public@yahoo.com">&lt;cavanaughwww-public@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAVANAUGH">CAVANAUGH</a><br />
3172. John Cerney  <a href="mailto:j-cerney1@raytheon.com">&lt;j-cerney1@raytheon.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CERNEY">CERNEY</a><br />

3173. John Clutterbuck  <a href="mailto:johnc@cpan.org">&lt;johnc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNC">JOHNC</a><br />
3174. <a href="http://www.clyman.com/">John Clyman</a>  <a href="mailto:module-support@clyman.com">&lt;module-support@clyman.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCLYMAN">JCLYMAN</a><br />
3175. <a href="http://www.kript.net">John Constable</a>  <a href="mailto:cpan@kript.net">&lt;cpan@kript.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRIPT">KRIPT</a><br />

3176. John Creasey  <a href="mailto:creaseyfam@hotmail.com">&lt;creaseyfam@hotmail.com&gt;</a> -- JCREASEY<br />
3177. <a href="http://www.cse.psu.edu/~groenvel/">John D Groenveld</a>  <a href="mailto:groenveld@acm.org">&lt;groenveld@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGROENVEL">JGROENVEL</a><br />
3178. <a href="http://www.frotzware.com">John D. Fa'atuai</a>  <a href="mailto:frotz@acm.org">&lt;frotz@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FROTZ">FROTZ</a><br />

3179. John D. Overmars  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OV/OVERMARS">OVERMARS</a><br />
3180. John D. Shearer  <a href="mailto:jshearer@netguy.org">&lt;jshearer@netguy.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSHEARER">JSHEARER</a><br />
3181. John Dallman  <a href="mailto:jgd@cix.compulink.co.uk">&lt;jgd@cix.compulink.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDALLMAN">JDALLMAN</a><br />

3182. John Douglas Porter  <a href="mailto:jdporter@cpan.org">&lt;jdporter@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDPORTER">JDPORTER</a><br />
3183. <a href="http://www.devstack.com">John Drago</a>  <a href="mailto:jdrago_999@yahoo.com">&lt;jdrago_999@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHND">JOHND</a><br />
3184. John E Allen  <a href="mailto:allen.john.e@gmail.com">&lt;allen.john.e@gmail.com&gt;</a> -- JEALLEN<br />

3185. John Eaglesham  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEAGLE">JEAGLE</a><br />
3186. John Eichler  <a href="mailto:John@CertifyIt.com">&lt;John@CertifyIt.com&gt;</a> -- JBE<br />
3187. <a href="http://www.jevonline.com/jev/index.html">John Erjavec V</a>  <a href="mailto:pause@jevonline.com">&lt;pause@jevonline.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEV">JEV</a><br />

3188. John Faichney  <a href="mailto:faichney@b2bscene.com">&lt;faichney@b2bscene.com&gt;</a> -- FAICHNEY<br />
3189. <a href="http://radio.weblogs.com/0133680/">John Fraser</a>  <a href="mailto:raptnor@yahoo.com">&lt;raptnor@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAPTNOR">RAPTNOR</a><br />
3190. John Gamble  <a href="mailto:jgamble@cpan.org">&lt;jgamble@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGAMBLE">JGAMBLE</a><br />

3191. John Gardiner Myers  <a href="mailto:jgmyers@proofpoint.com">&lt;jgmyers@proofpoint.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGMYERS">JGMYERS</a><br />
3192. <a href="http://www.corkball.net">John Garvin</a>  <a href="mailto:jpg@corkball.net">&lt;jpg@corkball.net&gt;</a> -- CORKBALL<br />
3193. <a href="http://www.webbysoft.com">John Gorman</a>  <a href="mailto:jgorman@webbysoft.com">&lt;jgorman@webbysoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGORMAN">JGORMAN</a><br />

3194. John Goulah  <a href="mailto:jgoulah@cpan.org">&lt;jgoulah@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGOULAH">JGOULAH</a><br />
3195. John Green  <a href="mailto:cpan@giggled.org">&lt;cpan@giggled.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNG">JOHNG</a><br />
3196. <a href="http://daringfireball.net/">John Gruber</a>  <a href="mailto:gruber@fedora.net">&lt;gruber@fedora.net&gt;</a> -- JGRUBER<br />

3197. <a href="http://www.cc.utah.edu/~nahaj/">John Halleck</a>  <a href="mailto:John.Halleck@utah.edu">&lt;John.Halleck@utah.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HALLECK">HALLECK</a><br />
3198. <a href="http://www.ps.uci.edu/~jhkim/Home.html">John Hanju Kim</a>  <a href="mailto:jhkim@fnal.gov">&lt;jhkim@fnal.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHKIM">JHKIM</a><br />
3199. <a href="http://www.aotea.org/john/">John Harrison</a>  <a href="mailto:japh@in-ta.net">&lt;japh@in-ta.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNGH">JOHNGH</a><br />

3200. John Hart  <a href="mailto:jhart[PLUS]mail@cs.tufts.edu (Replace the plus with '+')">&lt;jhart[PLUS]mail@cs.tufts.edu (Replace the plus with '+')&gt;</a> -- JHART<br />
3201. <a href="http://www.isi.edu/~johnh/">John Heidemann</a>  <a href="mailto:johnh@isi.edu">&lt;johnh@isi.edu&gt;</a> -- JOHNH<br />
3202. John Horner  <a href="mailto:bounce@johnhorner.nu">&lt;bounce@johnhorner.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CODYP">CODYP</a><br />

3203. John Hughes  <a href="mailto:jphughesjr@gmail.com">&lt;jphughesjr@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHUGHES">JHUGHES</a><br />
3204. John Imrie  <a href="mailto:john@imrie37.fsnet.co.uk">&lt;john@imrie37.fsnet.co.uk&gt;</a> -- JIMRIE<br />
3205. John J. Trammell  <a href="mailto:johntrammell@gmail.com">&lt;johntrammell@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTRAMMELL">JTRAMMELL</a><br />

3206. <a href="www.jjmb.com">John Jason Brzozowski</a>  <a href="mailto:mail.cpan@jjmb.com">&lt;mail.cpan@jjmb.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJMB">JJMB</a><br />
3207. John K. Sterling  <a href="mailto:sterling@covalent.net">&lt;sterling@covalent.net&gt;</a> -- STERLING<br />
3208. <a href="http://www.johnkeiser.com">John Keiser</a>  <a href="mailto:john@johnkeiser.com">&lt;john@johnkeiser.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKEISER">JKEISER</a><br />

3209. <a href="http://perl.dystanhays.com/jnk/">John Kirk</a>  <a href="mailto:johnkirk@dystanhays.com">&lt;johnkirk@dystanhays.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNK">JNK</a><br />
3210. <a href="http://www.jagunet.com/~kodis">John Kodis</a>  <a href="mailto:kodis@jagunet.com">&lt;kodis@jagunet.com&gt;</a> -- JKODIS<br />
3211. <a href="http://aharp.ittns.northwestern.edu">John Kristoff</a>  <a href="mailto:jtk@northwestern.edu">&lt;jtk@northwestern.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTK">JTK</a><br />

3212. <a href="http://www.johnlabovitz.com/hacks/">John Labovitz</a>  <a href="mailto:johnl@johnlabovitz.com">&lt;johnl@johnlabovitz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLABOVITZ">JLABOVITZ</a><br />
3213. <a href="http://www.johnlapeyre.com">John Lapeyre</a>  <a href="mailto:lapeyre@physics.arizona.edu">&lt;lapeyre@physics.arizona.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLAPEYRE">JLAPEYRE</a><br />
3214. <a href="http://www.blurbco.com/~gork/">John Laur</a>  <a href="mailto:johnl@blurbco.com">&lt;johnl@blurbco.com&gt;</a> -- GORK<br />

3215. <a href="http://www.sweetbeard.com/">John Lifsey</a>  <a href="mailto:nebulous@crashed.net">&lt;nebulous@crashed.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEBULOUS">NEBULOUS</a><br />
3216. John M Vinopal  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMV">JMV</a><br />
3217. <a href="http://www.dlugosz.com/">John M. Dlugosz</a>  <a href="mailto:john@dlugosz.com">&lt;john@dlugosz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLUGOSZ">DLUGOSZ</a><br />

3218. <a href="http://people.netscape.com/kristian/nsPerl/">John M. Kristian</a>  <a href="mailto:kristian@netscape.com">&lt;kristian@netscape.com&gt;</a> -- KRISTIAN<br />
3219. John M. Redford  <a href="mailto:garrow@cpan,org">&lt;garrow@cpan,org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARROW">GARROW</a><br />
3220. John Macdonald  <a href="mailto:john@perlwolf.com">&lt;john@perlwolf.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMM">JMM</a><br />

3221. <a href="http://groups.google.com/group/spreadsheet-writeexcel">John McNamara</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMCNAMARA">JMCNAMARA</a><br />
3222. John Millaway  <a href="mailto:millaway@acm.org">&lt;millaway@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MILLAWAY">MILLAWAY</a><br />
3223. John Mongan  <a href="mailto:jmongan@mccammon.uc-spamguard-sd.edu">&lt;jmongan@mccammon.uc-spamguard-sd.edu&gt;</a> -- JMONGAN<br />

3224. John Monteiro  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SATRAC<br />
3225. John Napiorkowski  <a href="mailto:jjnapiork@cpan.org">&lt;jjnapiork@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJNAPIORK">JJNAPIORK</a><br />
3226. <a href="http://www.neystadt.org/john/">John Neystadt</a>  <a href="mailto:john@neystadt.org">&lt;john@neystadt.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNEYSTADT">JNEYSTADT</a><br />

3227. John Nicholas Whitley  <a href="mailto:">&lt;&gt;</a> -- JOHNW<br />
3228. <a href="http://www.sonic.net/~jpnolan">John Nolan</a>  <a href="mailto:jpnolan@sonic.net">&lt;jpnolan@sonic.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNOLAN">JNOLAN</a><br />
3229. <a href="http://www.versatilia.com/">John O'Rourke</a>  <a href="mailto:john-perl@o-rourke.org">&lt;john-perl@o-rourke.org&gt;</a> -- JOROURKE<br />

3230. John Obie  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JKOBIE<br />
3231. John P. Linderman  <a href="mailto:jpl@research.att.com">&lt;jpl@research.att.com&gt;</a> -- JPL<br />
3232. John Peacock  <a href="mailto:jpeacock@cpan.org">&lt;jpeacock@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPEACOCK">JPEACOCK</a><br />
3233. John Pendleton  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JOHNP<br />

3234. <a href="http://www.ima.umn.edu/~pliam">John Pliam</a>  <a href="mailto:johnpliam@yahoo.com">&lt;johnpliam@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLIAM">PLIAM</a><br />
3235. <a href="http://ejohn.org/">John Resig</a>  <a href="mailto:jeresig@gmail.com">&lt;jeresig@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JERESIG">JERESIG</a><br />
3236. <a href="http://mx.grulic.org.ar/~john/">John Rowland Lenton</a>  <a href="mailto:john@vialibre.org.ar">&lt;john@vialibre.org.ar&gt;</a> -- JLENTON<br />

3237. <a href="http://genehack.org">John SJ Anderson</a>  <a href="mailto:genehack@genehack.org">&lt;genehack@genehack.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GENEHACK">GENEHACK</a><br />
3238. John Sargent  <a href="mailto:jbg@cpan.org">&lt;jbg@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBG">JBG</a><br />
3239. <a href="http://arstechnica.com/staff/fatbits.ars">John Siracusa</a>  <a href="mailto:siracusa@gmail.com">&lt;siracusa@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSIRACUSA">JSIRACUSA</a><br />

3240. John Smirnios  <a href="mailto:smirnios@sybase.com">&lt;smirnios@sybase.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMIRNIOS">SMIRNIOS</a><br />
3241. John Smith  <a href="mailto:ekaf69@hotmail.com">&lt;ekaf69@hotmail.com&gt;</a> -- JSMITTY<br />
3242. John Stoffel  <a href="mailto:john@wpi.edu">&lt;john@wpi.edu&gt;</a> -- JSTOF<br />
3243. <a href="http://john-edwin-tobey.org">John Tobey</a>  <a href="mailto:jtobey@john-edwin-tobey.org">&lt;jtobey@john-edwin-tobey.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JT/JTOBEY">JTOBEY</a><br />

3244. <a href="http://odin.mdacc.tmc.edu/">John Venier</a>  <a href="mailto:venier@mdanderson.org">&lt;venier@mdanderson.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JV/JVENIER">JVENIER</a><br />
3245. <a href="http://www.essenz.com/">John Von Essen</a>  <a href="mailto:john@essenz.com">&lt;john@essenz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESSENZ">ESSENZ</a><br />
3246. <a href="www.johnwang.com">John Wang</a>  <a href="mailto:johncwang@gmail.com">&lt;johncwang@gmail.com&gt;</a> -- JWANG<br />

3247. John Watson  <a href="mailto:jwatson@cnj.digex.net">&lt;jwatson@cnj.digex.net&gt;</a> -- JWAT<br />
3248. <a href="http://oneworld.new-era.com/johnw">John Wiegley</a>  <a href="mailto:johnw@oneworld.new-era.com">&lt;johnw@oneworld.new-era.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWIEGLEY">JWIEGLEY</a><br />
3249. John Williams  <a href="mailto:williams@tni.com">&lt;williams@tni.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWILLIAMS">JWILLIAMS</a><br />

3250. <a href="wingeronline.com">John Winger</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WINGMAN">WINGMAN</a><br />
3251. <a href="http://www.biomechs.nl/">John van Zantvoort</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JVZ<br />
3252. <a href="http://www.geocities.com/typopl">Johnny Lee</a>  <a href="mailto:typo_pl@hotmail.com">&lt;typo_pl@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TY/TYPO">TYPO</a><br />

3253. <a href="http://moretrix.com/">Johnny Morano</a>  <a href="mailto:jmorano@moretrix.com">&lt;jmorano@moretrix.com&gt;</a> -- INSANIAC<br />
3254. Johnny Shen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHENJ">SHENJ</a><br />
3255. Johnson Johnsonson  <a href="mailto:jugarnjax@hotmail.com">&lt;jugarnjax@hotmail.com&gt;</a> -- MORGENEGG<br />

3256. <a href="http://nixbox.com">Jolyon Terwilliger</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JTNIX<br />
3257. <a href="http://perl.jonallen.info">Jon Allen</a>  <a href="mailto:jj@jonallen.info">&lt;jj@jonallen.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONALLEN">JONALLEN</a><br />
3258. <a href="www.icogitate.com/~perl">Jon Bjornstad</a>  <a href="mailto:jon@icogitate.com">&lt;jon@icogitate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONBJ">JONBJ</a><br />

3259. <a href="http://www.thebooklocator.com/">Jon Brandon</a>  <a href="mailto:jon@powells.com">&lt;jon@powells.com&gt;</a> -- JONJAY<br />
3260. <a href="http://jonblog.com">Jon Brookes</a>  <a href="mailto:jon@ajblog.co.uk">&lt;jon@ajblog.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNBROOKES">JNBROOKES</a><br />
3261. Jon Connell  <a href="mailto:masaccio@cpan.org">&lt;masaccio@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASACCIO">MASACCIO</a><br />

3262. <a href="http://www.geocities.com/jlericson/">Jon Ericson</a>  <a href="mailto:Jon.Ericson@jpl.nasa.gov">&lt;Jon.Ericson@jpl.nasa.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JERICSON">JERICSON</a><br />
3263. <a href="http://jwenet.net">Jon Eveland</a>  <a href="mailto:jweveland@cpan.org">&lt;jweveland@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWEVELAND">JWEVELAND</a><br />
3264. <a href="http://www.jonh.net/">Jon Howell</a>  <a href="mailto:jonh@jonh.net">&lt;jonh@jonh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHOWELL">JHOWELL</a><br />

3265. <a href="http://www.endpoint.com/">Jon Jensen</a>  <a href="mailto:jon@endpoint.com">&lt;jon@endpoint.com&gt;</a> -- JONJ<br />
3266. Jon Nangle  <a href="mailto:pause@spacecadet.org">&lt;pause@spacecadet.org&gt;</a> -- JPNANGLE<br />
3267. <a href="http://tpj.com">Jon Orwant</a>  <a href="mailto:orwant@media.mit.edu">&lt;orwant@media.mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONO">JONO</a><br />

3268. <a href="http://www.snowdrift.org/computers/perl">Jon Peterson</a>  <a href="mailto:jon@snowdrift.org">&lt;jon@snowdrift.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPETERSON">JPETERSON</a><br />
3269. Jon Salz  <a href="mailto:jsalz-pautzo@mail.jsalz.net">&lt;jsalz-pautzo@mail.jsalz.net&gt;</a> -- JSALZ<br />
3270. <a href="http://notes.jschutz.net">Jon Schutz</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJSCHUTZ">JJSCHUTZ</a><br />

3271. Jon Stevenson  <a href="mailto:jonstevenson@fireflyuk.net">&lt;jonstevenson@fireflyuk.net&gt;</a> -- CADEN<br />
3272. <a href="http://jon.aslund.org">Jon Åslund</a>  <a href="mailto:nobpobe02 AT sneakemail com">&lt;nobpobe02 AT sneakemail com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOOON">JOOON</a><br />
3273. <a href="http://usr.bin.dk/~jonasbn/">Jonas B. Nielsen</a>  <a href="mailto:jonasbn@cpan.org">&lt;jonasbn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONASBN">JONASBN</a><br />

3274. Jonas Galhordas Duarte Alves  <a href="mailto:jgda@cpan.org">&lt;jgda@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGDA">JGDA</a><br />
3275. <a href="http://nex.scrapping.cc/">Jonas Kramer</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JKR<br />
3276. <a href="http://nex.scrapping.cc/">Jonas Kramer</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKRAMER">JKRAMER</a><br />

3277. <a href="http://paranormal.se/myself/en/index.html">Jonas Liljegren</a>  <a href="mailto:jonas@paranormal.se">&lt;jonas@paranormal.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONAS">JONAS</a><br />
3278. <a href="http://www.coyote.org/~jonas/">Jonas Öberg</a>  <a href="mailto:jonas@gnu.org">&lt;jonas@gnu.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONASO">JONASO</a><br />
3279. <a href="http://www.tapodi.net/~jda/">Jonathan Auer</a>  <a href="mailto:jda@tapodi.net">&lt;jda@tapodi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAUER">JAUER</a><br />

3280. <a href="http://www-cs-students.stanford.edu/~jonb">Jonathan Bailey</a>  <a href="mailto:jonb@cs.stanford.edu">&lt;jonb@cs.stanford.edu&gt;</a> -- JONB<br />
3281. Jonathan Brown  <a href="mailto:jcb123@gmail.com">&lt;jcb123@gmail.com&gt;</a> -- JONBROWN<br />
3282. <a href="http://www.buhacoff.net">Jonathan Buhacoff</a>  <a href="mailto:jonathan@buhacoff.net">&lt;jonathan@buhacoff.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBUHACOFF">JBUHACOFF</a><br />

3283. <a href="http://www.earth.li/~jon/">Jonathan Chin</a>  <a href="mailto:jon-pause-public@earth.li">&lt;jon-pause-public@earth.li&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCHIN">JCHIN</a><br />
3284. Jonathan Cua  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JCUA<br />
3285. Jonathan DePeri  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JDEPERI<br />

3286. Jonathan E. Cihlar  <a href="mailto:cihl0001@umn.edu">&lt;cihl0001@umn.edu&gt;</a> -- JCIHLAR<br />
3287. Jonathan Edwards  <a href="mailto:jone@cpan.org">&lt;jone@cpan.org&gt;</a> -- JONE<br />
3288. <a href="http://www.pobox.com/~eisen">Jonathan Eisenzopf</a>  <a href="mailto:eisen@pobox.com">&lt;eisen@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EISEN">EISEN</a><br />

3289. Jonathan Epstein  <a href="mailto:Jonathan_Epstein@nih.gov">&lt;Jonathan_Epstein@nih.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAEPSTEIN">JAEPSTEIN</a><br />
3290. <a href="www.jpaton.com">Jonathan Euan Paton</a>  <a href="mailto:jonathan-cpan@jpaton.com">&lt;jonathan-cpan@jpaton.com&gt;</a> -- JPATON<br />
3291. Jonathan Eunice  <a href="mailto:jeunice@illuminata.com">&lt;jeunice@illuminata.com&gt;</a> -- JEUNICE<br />

3292. Jonathan Harris  <a href="mailto:jhar@spamcop.net">&lt;jhar@spamcop.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHAR">JHAR</a><br />
3293. Jonathan J. Miner  <a href="mailto:cpan@jjminer.org">&lt;cpan@jjminer.org&gt;</a> -- MINER<br />
3294. <a href="http://stuff.mit.edu/~jik/">Jonathan Kamens</a>  <a href="mailto:jik@kamens.brookline.ma.us">&lt;jik@kamens.brookline.ma.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JIK">JIK</a><br />

3295. <a href="http://blog.dvdlookup.org">Jonathan Kaus</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JLKAUS<br />
3296. Jonathan Kelfer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JKELFER<br />
3297. <a href="http://home.earthlink.net/~jleffler">Jonathan Leffler</a>  <a href="mailto:j.leffler@acm.org">&lt;j.leffler@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNL">JOHNL</a><br />

3298. <a href="http://www.leto.net/">Jonathan Leto</a>  <a href="mailto:jonathan@leto.net">&lt;jonathan@leto.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LETO">LETO</a><br />
3299. Jonathan Lloyd  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLLOYD">JLLOYD</a><br />
3300. <a href="http://wypug.pm.org/">Jonathan M. Hollin</a>  <a href="mailto:darkblue [at] cpan.org">&lt;darkblue [at] cpan.org&gt;</a> -- DARKBLUE<br />

3301. Jonathan March  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JMARCH<br />
3302. <a href="http://stej.com/perl">Jonathan Meyer</a>  <a href="mailto:http://stej.com/perl">&lt;http://stej.com/perl&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEJ">STEJ</a><br />
3303. Jonathan Moore  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JONFM<br />

3304. Jonathan R. Finger  <a href="mailto:jonathan_finger@hotmail.com">&lt;jonathan_finger@hotmail.com&gt;</a> -- JFINGER<br />
3305. Jonathan R. Warden  <a href="mailto:john@newchester.com">&lt;john@newchester.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOHNWRDN">JOHNWRDN</a><br />
3306. Jonathan Ringstad  <a href="mailto:elektronenvolt@quantentunnel.de">&lt;elektronenvolt@quantentunnel.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHOPPIX">WHOPPIX</a><br />

3307. <a href="http://www.jrock.us/">Jonathan Rockway</a>  <a href="mailto:jrockway@cpan.org">&lt;jrockway@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JROCKWAY">JROCKWAY</a><br />
3308. <a href="http://jesnetplus.com">Jonathan Sailor</a>  <a href="mailto:reversethis-&gt;moc@sulptensej@roliasj">&lt;reversethis-&gt;moc@sulptensej@roliasj&gt;</a> -- JSAILOR<br />
3309. <a href="www.divisionbyzero.com">Jonathan Schatz</a>  <a href="mailto:bluelines@divisionbyzero.com">&lt;bluelines@divisionbyzero.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLUELINES">BLUELINES</a><br />

3310. <a href="http://www.pobox.com/~duff">Jonathan Scott Duff</a>  <a href="mailto:duff@pobox.com">&lt;duff@pobox.com&gt;</a> -- DUFF<br />
3311. Jonathan Segal  <a href="mailto:jsegal [@t] iname [d.t] com">&lt;jsegal [@t] iname [d.t] com&gt;</a> -- JSEGAL<br />
3312. Jonathan Steinert  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HACHI">HACHI</a><br />

3313. <a href="http://www.gellyfish.co.uk/">Jonathan Stowe</a>  <a href="mailto:jns@gellyfish.co.uk">&lt;jns@gellyfish.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSTOWE">JSTOWE</a><br />
3314. Jonathan Swartz  <a href="mailto:swartz@pobox.com">&lt;swartz@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSWARTZ">JSWARTZ</a><br />
3315. <a href="http://jonathan.tweed.name/">Jonathan Tweed</a>  <a href="mailto:jonathan@tweed.name">&lt;jonathan@tweed.name&gt;</a> -- JTWEED<br />

3316. <a href="2xlp.com">Jonathan Vanasco</a>  <a href="mailto:cpan@2xlp.com">&lt;cpan@2xlp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JV/JVANASCO">JVANASCO</a><br />
3317. Jonathan Waxman  <a href="mailto:jowaxman@law.upenn.edu">&lt;jowaxman@law.upenn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMRYS">EMRYS</a><br />
3318. <a href="http://www.jnthn.net/">Jonathan Worthington</a>  <a href="mailto:jnthn@jnthn.net">&lt;jnthn@jnthn.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONATHAN">JONATHAN</a><br />

3319. Jonathan Yu  <a href="mailto:frequency@cpan.org">&lt;frequency@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FREQUENCY">FREQUENCY</a><br />
3320. <a href="http://www.worm.sh">Joner Cyrre Worm</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WORM">WORM</a><br />
3321. <a href="http://biosophy.org/">Jong Park</a>  <a href="mailto:jong@biosophy.org">&lt;jong@biosophy.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONG">JONG</a><br />

3322. <a href="http://jeen.tistory.com">Jong-jin Lee</a>  <a href="mailto:jeen@perl.kr">&lt;jeen@perl.kr&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEEN">JEEN</a><br />
3323. <a href="http://www.perl.or.kr/">Jongpil Jeon</a>  <a href="mailto:blueabi@hanmail.net">&lt;blueabi@hanmail.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPJEON">JPJEON</a><br />
3324. <a href="http://www.bloonix.de/">Jonny Schulz</a>  <a href="mailto:jschulz.cpan@bloonix.de">&lt;jschulz.cpan@bloonix.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLOONIX">BLOONIX</a><br />

3325. <a href="http://jonty.co.uk">Jonty Wareing</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JONTY<br />
3326. <a href="http://www.exotica.org.uk">Jools Smyth</a>  <a href="mailto:buzz [at] exotica.org.uk">&lt;buzz [at] exotica.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EX/EXOBUZZ">EXOBUZZ</a><br />
3327. <a href="http://appsrc.freehostia.com/">Joon Hee</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JHUNI<br />

3328. <a href="http://zeekat.nl/">Joost Diepenmaat</a>  <a href="mailto:jdiepen@cpan.org">&lt;jdiepen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDIEPEN">JDIEPEN</a><br />
3329. <a href="http://www.netmonger.net/~jordan/">Jordan Coleman</a>  <a href="mailto:">&lt;&gt;</a> -- COLEMAN<br />
3330. <a href="http://jmadler.org/">Jordan M. Adler</a>  <a href="mailto:JMADLER@cpan.org">&lt;JMADLER@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMADLER">JMADLER</a><br />

3331. <a href="http://genome.ucla.edu/~jordan">Jordan Mendler</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JMENDLER<br />
3332. <a href="http://www.csh.rit.edu/~psionic/">Jordan Sissel</a>  <a href="mailto:psionic+cpan@csh.rit.edu">&lt;psionic+cpan@csh.rit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSIONIC">PSIONIC</a><br />
3333. <a href="http://www.condalis.net/">Jorge Duarte Rodríguez</a>  <a href="mailto:jorge@condalis.net">&lt;jorge@condalis.net&gt;</a> -- JDUARTER<br />

3334. <a href="http://www.joval.info">Jorge Valdes</a>  <a href="mailto:jorge@joval.info">&lt;jorge@joval.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOVAL">JOVAL</a><br />
3335. <a href="http://dwim.org">Jos Boumans</a>  <a href="mailto:kane@cpan.org">&lt;kane@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KANE">KANE</a><br />
3336. Jose A. Rodriguez  <a href="mailto:Jose.Rodriguez+cpan@ac.upc.edu">&lt;Jose.Rodriguez+cpan@ac.upc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSERODR">JOSERODR</a><br />

3337. Jose Gervasio Moises Madera  <a href="mailto:spm@visualplace.com">&lt;spm@visualplace.com&gt;</a> -- MOSES<br />
3338. <a href="http://www.di.uminho.pt/~jj">Jose Joao Dias de Almeida</a>  <a href="mailto:jj@di.uminho.pt">&lt;jj@di.uminho.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJOAO">JJOAO</a><br />
3339. <a href="http://www.pplusdomain.net/">Jose Luis Martinez Torres</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLMARTIN">JLMARTIN</a><br />

3340. <a href="http://www.algarve-digital.pt/">Jose Machado</a>  <a href="mailto:jacm@algarve.com">&lt;jacm@algarve.com&gt;</a> -- JACM<br />
3341. <a href="http://joseweeks.com">Jose Marti Weeks</a>  <a href="mailto:jose@joseweeks.com">&lt;jose@joseweeks.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSEWEEKS">JOSEWEEKS</a><br />
3342. Jose Mtanous  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TJUGO<br />

3343. <a href="jezra.com">Josef Ezra</a>  <a href="mailto:jezra@cpan.org">&lt;jezra@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEZRA">JEZRA</a><br />
3344. Josef Schönbrunner  <a href="mailto:j.schoenbrunner@schule.at">&lt;j.schoenbrunner@schule.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHOEJO">SCHOEJO</a><br />
3345. Joseph A. White  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWHITE">JWHITE</a><br />

3346. <a href="http://www.jannino.com/">Joseph Annino</a>  <a href="mailto:jannino@jannino.com">&lt;jannino@jannino.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANNINO">JANNINO</a><br />
3347. Joseph Barker  <a href="mailto:jbarker@telocity.com">&lt;jbarker@telocity.com&gt;</a> -- JBARKER<br />
3348. Joseph Benzakoun  <a href="mailto:alamaz@wanadoo.fr">&lt;alamaz@wanadoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALAMAZ">ALAMAZ</a><br />

3349. <a href="http://obsidianrook.com/map/">Joseph Brenner</a>  <a href="mailto:doom@kzsu.stanford.edu">&lt;doom@kzsu.stanford.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOOM">DOOM</a><br />
3350. <a href="http://www.interguru.com/mailconv.htm">Joseph Davidson</a>  <a href="mailto:jdavidson@interguru.com">&lt;jdavidson@interguru.com&gt;</a> -- INTEGURU<br />
3351. <a href="http://www.interguru.com/mailconv.htm">Joseph Davidson</a>  <a href="mailto:jhd-at-interguru.com">&lt;jhd-at-interguru.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INTERGURU">INTERGURU</a><br />

3352. <a href="http://www.stadiumdistrict.com/DTC/">Joseph Devlin</a>  <a href="mailto:jdevlin@stadiumdistrict.com">&lt;jdevlin@stadiumdistrict.com&gt;</a> -- JDEVLIN<br />
3353. <a href="http://www.XTRsystems.com/">Joseph DiVerdi</a>  <a href="mailto:diverdi@XTRsystems.com">&lt;diverdi@XTRsystems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIVERDI">DIVERDI</a><br />
3354. <a href="http://www.encyclopediadramatica.com/">Joseph Evers</a>  <a href="mailto:joseph.evers@gmail.com">&lt;joseph.evers@gmail.com&gt;</a> -- BANTOWN<br />

3355. Joseph F. Ryan  <a href="mailto:ryan.311@osu.edu">&lt;ryan.311@osu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRYAN">JRYAN</a><br />
3356. Joseph H. Buehler  <a href="mailto:jhpb@sarto.gaithersburg.md.us">&lt;jhpb@sarto.gaithersburg.md.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHPB">JHPB</a><br />
3357. Joseph Huckaby  <a href="mailto:jhuckaby at cpan dot org">&lt;jhuckaby at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHUCKABY">JHUCKABY</a><br />

3358. Joseph J. Egan  <a href="mailto:joseph_egan@hotmail.com">&lt;joseph_egan@hotmail.com&gt;</a> -- JEGAN<br />
3359. Joseph Kline  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GIZMO<br />
3360. <a href="http://scalableinformatics.com">Joseph Landman</a>  <a href="mailto:landman@scalableinformatics.com">&lt;landman@scalableinformatics.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LANDMAN">LANDMAN</a><br />

3361. <a href="http://www.5sigma.com/joseph">Joseph N. Hall</a>  <a href="mailto:jnh@cpan.org">&lt;jnh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JN/JNH">JNH</a><br />
3362. <a href="http://digitalbullet.net">Joseph Ronie</a>  <a href="mailto:phocuser@yahoo.com">&lt;phocuser@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHOCUS">PHOCUS</a><br />
3363. <a href="http://www.skrovan.com/joe">Joseph Skrovan</a>  <a href="mailto:junk@skrovan.com">&lt;junk@skrovan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKROVAN">SKROVAN</a><br />

3364. <a href="http://omega0.xepher.net">Joseph Strom</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JS/JSTROM">JSTROM</a><br />
3365. <a href="http://www.kafsemo.org/">Joseph Walton</a>  <a href="mailto:joe@kafsemo.org">&lt;joe@kafsemo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSEPHW">JOSEPHW</a><br />
3366. <a href="http://www.gnacademy.org/">Joseph Wang</a>  <a href="mailto:gna@gnacademy.org">&lt;gna@gnacademy.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GN/GNALABS">GNALABS</a><br />

3367. <a href="http://multipart-mixed.com">Josh Carter</a>  <a href="mailto:josh@multipart-mixed.com">&lt;josh@multipart-mixed.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCARTER">JCARTER</a><br />
3368. <a href="http://www.jmglov.net/">Josh Glover</a>  <a href="mailto:cpan@jmglov.net">&lt;cpan@jmglov.net&gt;</a> -- JMGLOV<br />
3369. <a href="http://www.hackforfood.com/">Josh Goldberg</a>  <a href="mailto:josh at 3io&lt;d_o t&gt;com">&lt;josh at 3io&lt;d_o t&gt;com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGOLDBERG">JGOLDBERG</a><br />

3370. Josh Goldenhar  <a href="mailto:joshuag29@comcast.net">&lt;joshuag29@comcast.net&gt;</a> -- JOSHUAG<br />
3371. <a href="http://www.gunsett.com">Josh Gunsett</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GUNSETT<br />
3372. <a href="http://joshheumann.com">Josh Heumann</a>  <a href="mailto:cpan@joshheumann.com">&lt;cpan@joshheumann.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEUMANN">HEUMANN</a><br />

3373. <a href="http://www.joshisanerd.com/">Josh Myer</a>  <a href="mailto:josh@joshisanerd.com">&lt;josh@joshisanerd.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBM">JBM</a><br />
3374. <a href="http://joshr.com/">Josh Rabinowitz</a>  <a href="mailto:joshr-proc-nicesleep@joshr.com">&lt;joshr-proc-nicesleep@joshr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSHR">JOSHR</a><br />
3375. Josh Schulte  <a href="mailto:josh_schulte@yahoo.com">&lt;josh_schulte@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHULTE">SCHULTE</a><br />

3376. <a href="http://php.indiana.edu/~jwalgenb/">Josh Walgenbach</a>  <a href="mailto:jwalgenb@indiana.edu">&lt;jwalgenb@indiana.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWALGENB">JWALGENB</a><br />
3377. <a href="http://www.hitchhiker.org/~josh/">Josh Wilmes</a>  <a href="mailto:perl@hitchhiker.org">&lt;perl@hitchhiker.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSH">JOSH</a><br />
3378. <a href="http://www.fruhead.com">Josh Woodward</a>  <a href="mailto:joshw@yahoo-inc.com">&lt;joshw@yahoo-inc.com&gt;</a> -- JOSHW<br />

3379. <a href="http://jambe.japh.nu/">Joshua Boschert</a>  <a href="mailto:joshua_boschert@aismail.wustl.edu">&lt;joshua_boschert@aismail.wustl.edu&gt;</a> -- JAMBE<br />
3380. <a href="http://www.crapflingingmonkey.com">Joshua Braegger</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ARNIE<br />
3381. <a href="http://www.chamas.com">Joshua Chamas</a>  <a href="mailto:josh dot chamas (at) gmail.com">&lt;josh dot chamas (at) gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHAMAS">CHAMAS</a><br />

3382. Joshua Colvin  <a href="mailto:jco@acm.org">&lt;jco@acm.org&gt;</a> -- JCO<br />
3383. <a href="http://www.spl0it.org">Joshua D. Abraham</a>  <a href="mailto:jabra@cpan.org">&lt;jabra@cpan.org&gt;</a> -- JABRA<br />
3384. Joshua Daniel Rotenberg  <a href="mailto:joshrotenberg@gmail.com">&lt;joshrotenberg@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDR">JDR</a><br />

3385. Joshua Douglas  <a href="mailto:joshua.douglas@wizardfrog.com">&lt;joshua.douglas@wizardfrog.com&gt;</a> -- JDOUGLAS<br />
3386. <a href="http://liblime.com">Joshua Ferraro</a>  <a href="mailto:jmf@liblime.com">&lt;jmf@liblime.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KADOS">KADOS</a><br />
3387. Joshua Gatcomb  <a href="mailto:Limbic_Region_2000@Yahoo.com">&lt;Limbic_Region_2000@Yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGATCOMB">JGATCOMB</a><br />

3388. Joshua Gitlin  <a href="mailto:joshua.gitlin@gmail.com">&lt;joshua.gitlin@gmail.com&gt;</a> -- JGITLIN<br />
3389. <a href="http://www.roughtrade.net/">Joshua Goodall</a>  <a href="mailto:joshua@roughtrade.net">&lt;joshua@roughtrade.net&gt;</a> -- JGOODALL<br />
3390. Joshua Harding  <a href="mailto:xjharding@elitemail.org">&lt;xjharding@elitemail.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHARDING">JHARDING</a><br />

3391. Joshua Hoblitt  <a href="mailto:jhoblitt@cpan.org">&lt;jhoblitt@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHOBLITT">JHOBLITT</a><br />
3392. <a href="http://www.public-dns.org">Joshua I. Miller</a>  <a href="mailto:unrtstRMSPAM@gmail.com">&lt;unrtstRMSPAM@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNRTST">UNRTST</a><br />
3393. <a href="http://keroes.com">Joshua Keroes</a>  <a href="mailto:joshua@cpan.org">&lt;joshua@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSHUA">JOSHUA</a><br />

3394. <a href="www.qbangsolutions.com">Joshua Kuo</a>  <a href="mailto:josh.kuo@qbangsolutions.com">&lt;josh.kuo@qbangsolutions.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOSHKUO">JOSHKUO</a><br />
3395. Joshua Lande  <a href="mailto:">&lt;&gt;</a> -- JOLANDE<br />
3396. Joshua M. Thompson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JMT<br />

3397. <a href="http://www.solutionsforprogress.com">Joshua Marcus</a>  <a href="mailto:systems@thebenefitbank.com">&lt;systems@thebenefitbank.com&gt;</a> -- SOLFOPRO<br />
3398. <a href="http://perlcast.com">Joshua McAdams</a>  <a href="mailto:joshua-dot-mcadams-at-gmail-dot-com">&lt;joshua-dot-mcadams-at-gmail-dot-com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMCADA">JMCADA</a><br />
3399. <a href="http://openheartlogic.org">Joshua Nathaniel Pritikin</a>  <a href="mailto:jpritikin@pobox.com">&lt;jpritikin@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JP/JPRIT">JPRIT</a><br />

3400. <a href="http://www.sivro.net">Joshua Orvis</a>  <a href="mailto:jorvis@cpan.org">&lt;jorvis@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JORVIS">JORVIS</a><br />
3401. Joshua Pollack  <a href="mailto:jpollack@gmail.com">&lt;jpollack@gmail.com&gt;</a> -- JPOLLACK<br />
3402. <a href="www.cybertron.cc">Joshua Rubin</a>  <a href="mailto:Joshua.Rubin@Colorado.EDU">&lt;Joshua.Rubin@Colorado.EDU&gt;</a> -- RUBINJ<br />

3403. Joshua Soles  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBSOLES">JBSOLES</a><br />
3404. <a href="http://perlmonks.org/?node=diotalevi">Joshua ben Jore</a>  <a href="mailto:jjore@cpan.org">&lt;jjore@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JJ/JJORE">JJORE</a><br />
3405. <a href="http://www.josiahbryan.com/">Josiah Bryan</a>  <a href="mailto:jbryan@josiahbryan.com">&lt;jbryan@josiahbryan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JB/JBRYAN">JBRYAN</a><br />

3406. Jost Krieger  <a href="mailto:Jost.Krieger+pppause@ruhr-uni-bochum.de">&lt;Jost.Krieger+pppause@ruhr-uni-bochum.de&gt;</a> -- JOST<br />
3407. <a href="http://jose-castro.org/">José Alves de Castro</a>  <a href="mailto:cog@cpan.org">&lt;cog@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COG">COG</a><br />
3408. <a href="http://www.bureado.com.ve/">José Miguel Parrella Romero</a>  <a href="mailto:bureado@cpan.org">&lt;bureado@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUREADO">BUREADO</a><br />

3409. José Pedro Oliveira  <a href="mailto:jpo@di.uminho.pt">&lt;jpo@di.uminho.pt&gt;</a> -- JPO<br />
3410. José Pinheiro Neta  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CAO<br />
3411. <a href="radarlibre.blogspot.com">José Rey</a>  <a href="mailto:josereylistas@gmail.com">&lt;josereylistas@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JREY">JREY</a><br />

3412. José Santos  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANTOS">SANTOS</a><br />
3413. José Vicente Núñez Zuleta  <a href="mailto:josevnz@users.sourceforge.net">&lt;josevnz@users.sourceforge.net&gt;</a> -- JOSEVNZ<br />
3414. <a href="http://jouke.pvoice.org">Jouke Visser</a>  <a href="mailto:jouke@cpan.org">&lt;jouke@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOUKE">JOUKE</a><br />

3415. Jozef Kutej  <a href="mailto:jozef@kutej.net">&lt;jozef@kutej.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKUTEJ">JKUTEJ</a><br />
3416. João Fernando Ferreira  <a href="mailto:joao@cpan.org">&lt;joao@cpan.org&gt;</a> -- JOAO<br />
3417. João Gomes  <a href="mailto:">&lt;&gt;</a> -- JRG<br />
3418. <a href="http://sourceforge.net/projects/perl-gps/">João Pedro Gonçalves</a>  <a href="mailto:joaop@co.sapo.pt">&lt;joaop@co.sapo.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOAOP">JOAOP</a><br />

3419. Juan C. Muller  <a href="mailto:jcmuller at gmail dot com">&lt;jcmuller at gmail dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCMULLER">JCMULLER</a><br />
3420. Juan Camacho  <a href="mailto:PAUSE@camachofamily.com">&lt;PAUSE@camachofamily.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCAMACHO">JCAMACHO</a><br />
3421. <a href="http://wwww.juanfernando.com.mx">Juan Fernando Mora Muñoz</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JMORA<br />

3422. <a href="http://www.nuevearepas.com">Juan J Natera</a>  <a href="mailto:naterajj@yahoo.com">&lt;naterajj@yahoo.com&gt;</a> -- NATERAJJ<br />
3423. <a href="http://www.microbotica.es">Juan José San Martín</a>  <a href="mailto:jsanmartin@gmail.com">&lt;jsanmartin@gmail.com&gt;</a> -- PECO<br />
3424. <a href="http://www.juanreyero.com">Juan M. García-Reyero</a>  <a href="mailto:joanmg@gmail.com">&lt;joanmg@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JOANMG">JOANMG</a><br />

3425. Juan Schwindt  <a href="mailto:jsch@cpan.org">&lt;jsch@cpan.org&gt;</a> -- JSCH<br />
3426. Judd Taylor  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CJTAYLOR<br />
3427. Judith Lebzelter  <a href="mailto:judith@osdl.org">&lt;judith@osdl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JUDITH">JUDITH</a><br />
3428. <a href="http://juerd.nl/">Juerd Waalboer</a>  <a href="mailto:spamcollector_cpan@juerd.nl">&lt;spamcollector_cpan@juerd.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JUERD">JUERD</a><br />

3429. <a href="http://www.gmd.de/People/Christoffel">Juergen Christoffel</a>  <a href="mailto:jc@gmd.de">&lt;jc@gmd.de&gt;</a> -- JCHRIS<br />
3430. <a href="www.postbabel.com">Juguang XIAO, 肖聚光</a>  <a href="mailto:juguang@gmail.com">&lt;juguang@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JUGUANG">JUGUANG</a><br />
3431. Jules Bean  <a href="mailto:jules@jellybean.co.uk">&lt;jules@jellybean.co.uk&gt;</a> -- JULES<br />

3432. Julian Fondren  <a href="mailto:ayrnieu@gmail.com">&lt;ayrnieu@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AY/AYRNIEU">AYRNIEU</a><br />
3433. <a href="http://www.proscriptum.com">Julian Lishev</a>  <a href="mailto:julian@proscriptum.com">&lt;julian@proscriptum.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JL/JLISHEV">JLISHEV</a><br />
3434. <a href="http://www.mehnle.net">Julian Mehnle</a>  <a href="mailto:julian@mehnle.net">&lt;julian@mehnle.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMEHNLE">JMEHNLE</a><br />

3435. Julian Onions  <a href="mailto:julianonions@yahoo.no-spam-co.uk">&lt;julianonions@yahoo.no-spam-co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONIONS">JONIONS</a><br />
3436. Julien CROUZET  <a href="mailto:jucrouzet@free.fr">&lt;jucrouzet@free.fr&gt;</a> -- JUCROUZET<br />
3437. <a href="http://vedge.org/">Julien Nadeau</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- VEDGE<br />

3438. <a href="http://pom.clacbec.net/">Julien Quint (Pom)</a>  <a href="mailto:pom@graougraou.com">&lt;pom@graougraou.com&gt;</a> -- POM<br />
3439. Julio Fraire Domínguez  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFRAIRE">JFRAIRE</a><br />
3440. Julius C. Duque  <a href="mailto:jcduque@lycos.com">&lt;jcduque@lycos.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JC/JCDUQUE">JCDUQUE</a><br />

3441. <a href="http://julian.porta.sh">Julián Porta</a>  <a href="mailto:julian.porta@gmail.com">&lt;julian.porta@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/PORTA">PORTA</a><br />
3442. <a href="http://www.shanon.co.jp/">Jun Shimizu</a>  <a href="mailto:bayside@cpan.org">&lt;bayside@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAYSIDE">BAYSIDE</a><br />
3443. Jung Pyo Hong  <a href="mailto:gisa@junghong.com">&lt;gisa@junghong.com&gt;</a> -- HONG<br />

3444. <a href="http://en.yummy.stripper.jp/">Junichiro Tobe</a>  <a href="mailto:junichiro@cpan.org">&lt;junichiro@cpan.org&gt;</a> -- JUNICHIRO<br />
3445. <a href="http://www.juniper.net">Junos Development</a>  <a href="mailto:trostler@juniper.net">&lt;trostler@juniper.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JU/JUNOS">JUNOS</a><br />
3446. <a href="http://d.hatena.ne.jp/jkondo/">Junya Kondo</a>  <a href="mailto:jkondo@hatena.ne.jp">&lt;jkondo@hatena.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JK/JKONDO">JKONDO</a><br />

3447. Justin Archie  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JTARCHIE<br />
3448. Justin Balthrop  <a href="mailto:juddhuck@gmail.com">&lt;juddhuck@gmail.com&gt;</a> -- JUDD<br />
3449. Justin DeVuyst  <a href="mailto:justin@devuyst.com">&lt;justin@devuyst.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JD/JDV">JDV</a><br />
3450. <a href="http://www.mirwin.net">Justin Gallardo</a>  <a href="mailto:jirwin@cpan.org">&lt;jirwin@cpan.org&gt;</a> -- JIRWIN<br />

3451. Justin Guenther  <a href="mailto:jguenther@cpan.org">&lt;jguenther@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JG/JGUENTHER">JGUENTHER</a><br />
3452. <a href="http://www.lolofie.com/justin">Justin Lolofie</a>  <a href="mailto:justin@lolofie.com">&lt;justin@lolofie.com&gt;</a> -- JLOLOFIE<br />
3453. <a href="http://jmason.org/">Justin Mason</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMASON">JMASON</a><br />

3454. Justin Michael Bauman  <a href="mailto:Saint_Marck2@yahoo.com">&lt;Saint_Marck2@yahoo.com&gt;</a> -- SAINTMARK<br />
3455. <a href="http://justin.phq.org">Justin S. Leitgeb</a>  <a href="mailto:justin@phq.org">&lt;justin@phq.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEITGEBJ">LEITGEBJ</a><br />
3456. <a href="http://dadamailproject.com">Justin Simoni</a>  <a href="mailto:perl@justinsimoni.com">&lt;perl@justinsimoni.com&gt;</a> -- JJSIMONI<br />

3457. <a href="http://www.datademons.com/">Justin Wheeler</a>  <a href="mailto:cpan@datademons.com">&lt;cpan@datademons.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWHEELER">JWHEELER</a><br />
3458. <a href="http://rodney.alert.sk/">Ján 'Kozo' Vajda</a>  <a href="mailto:Jan.Vajda@alert.sk">&lt;Jan.Vajda@alert.sk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOZO">KOZO</a><br />
3459. <a href="http://fenal.org/">Jérôme Fenal</a>  <a href="mailto:jfenal@free.fr">&lt;jfenal@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JF/JFENAL">JFENAL</a><br />

3460. <a href="http://Patterner.de">Jörg Plate</a>  <a href="mailto:plate@psyche.kn-bremen.de">&lt;plate@psyche.kn-bremen.de&gt;</a> -- PSYCHE<br />
3461. <a href="http://patterner.de">Jörg Plate</a>  <a href="mailto:plate@patterner.de">&lt;plate@patterner.de&gt;</a> -- PATTERNER<br />
3462. <a href="http://ich.bin.kein.hoschi.de/">Jörg Walter</a>  <a href="mailto:jwalt-spam@garni.ch">&lt;jwalt-spam@garni.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JW/JWALT">JWALT</a><br />

3463. Jörg Ziefle  <a href="mailto:ziefle@cpan.org">&lt;ziefle@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZI/ZIEFLE">ZIEFLE</a><br />
3464. Jörgen Hägg  <a href="mailto:jorgen.hagg@axis.com">&lt;jorgen.hagg@axis.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JH/JHAGG">JHAGG</a><br />
3465. <a href="http://www.exit1.org/">Jörn Reder</a>  <a href="mailto:joern@zyn.de">&lt;joern@zyn.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRED">JRED</a><br />

3466. Jürgen Peters  <a href="mailto:taulmaril@cpan.org">&lt;taulmaril@cpan.org&gt;</a> -- TAULMARIL<br />
3467. Jürgen Weigert  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- JNW<br />
3468. Jürgen von Brietzke  <a href="mailto:juergen.von.brietzke@t-online.de">&lt;juergen.von.brietzke@t-online.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JV/JVBSOFT">JVBSOFT</a><br />
3469. K Cody  <a href="mailto:kcody@jilcraft.com">&lt;kcody@jilcraft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCODY">KCODY</a><br />

3470. <a href="http://www.shadowcatsystems.co.uk">K. James Cheetham</a>  <a href="mailto:jamie at shadowcatsystems dot co dot uk">&lt;jamie at shadowcatsystems dot co dot uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PENGUIN">PENGUIN</a><br />
3471. <a href="http://www.ip2location.com">K.L. LIEW</a>  <a href="mailto:hexasoft@gmail.com">&lt;hexasoft@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOCATION">LOCATION</a><br />
3472. KAI WANG  <a href="mailto:tumorimmunology@yahoo.com">&lt;tumorimmunology@yahoo.com&gt;</a> -- TUMORIM<br />

3473. KAMALAKANNAN  <a href="mailto:skamalakannan@yahoo.com">&lt;skamalakannan@yahoo.com&gt;</a> -- RACHANA<br />
3474. <a href="http://fushihara.net/">KAN Fushihara</a>  <a href="mailto:kan@mobilefactory.jp">&lt;kan@mobilefactory.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKIHOSHI">MIKIHOSHI</a><br />
3475. <a href="http://haro.jp/">KAWABATA Kazumichi</a>  <a href="mailto:kawabata@cpan.org">&lt;kawabata@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAWABATA">KAWABATA</a><br />

3476. <a href="http://www.k12u.org/">KAWAMOTO Minoru</a>  <a href="mailto:minoru-cpan@k12u.org">&lt;minoru-cpan@k12u.org&gt;</a> -- MINORU<br />
3477. <a href="http://takefumi.com/">KIMURA, takefumi</a>  <a href="mailto:takefumi@takefumi.com">&lt;takefumi@takefumi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAKEFUMI">TAKEFUMI</a><br />
3478. KOBAYASI, Hiroaki  <a href="mailto:hkoba@users.sourceforge.jp">&lt;hkoba@users.sourceforge.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HK/HKOBA">HKOBA</a><br />

3479. <a href="http://ido.nu/kuma/">KUMAGAI Kentaro</a>  <a href="mailto:ku-cpan@ido.nu">&lt;ku-cpan@ido.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KUMA">KUMA</a><br />
3480. Ka-Wai Mak  <a href="mailto:kwmak@cpan.org">&lt;kwmak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWMAK">KWMAK</a><br />
3481. <a href="www.jasonic.dk">Kaare Rasmussen</a>  <a href="mailto:kaare at jasonic dot dk">&lt;kaare at jasonic dot dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAARE">KAARE</a><br />

3482. Kaelin Colclasure  <a href="mailto:kaelin@acm.org">&lt;kaelin@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAELIN">KAELIN</a><br />
3483. Kai Diefenbach  <a href="mailto:usenet@diefenba.ch">&lt;usenet@diefenba.ch&gt;</a> -- DEEPCREEK<br />
3484. <a href="http://www.westfalen.de/khms/">Kai Henningsen</a>  <a href="mailto:kai-cpan@khms.westfalen.de">&lt;kai-cpan@khms.westfalen.de&gt;</a> -- KAIH<br />

3485. <a href="http://wilker.info">Kai Wilker</a>  <a href="mailto:kai.wilker@googlemail.com">&lt;kai.wilker@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAIW">KAIW</a><br />
3486. <a href="http://www.in2home.org">Kai-Hsiang Chuang</a>  <a href="mailto:in2@in2home.org">&lt;in2@in2home.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INTWO">INTWO</a><br />
3487. <a href="http://www.earth.li/~kake/">Kake L Pugh</a>  <a href="mailto:kake@earth.li">&lt;kake@earth.li&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAKE">KAKE</a><br />

3488. Kal El  <a href="mailto:kalel@cpan.org">&lt;kalel@cpan.org&gt;</a> -- KALEL<br />
3489. <a href="http://www.synchroedit.com/">Kalle Alm</a>  <a href="mailto:spam@enrogue.com">&lt;spam@enrogue.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KALLEWOOF">KALLEWOOF</a><br />
3490. <a href="http://kato.iki.fi/">Kalle Hallivuori</a>  <a href="mailto:kato@iki.fi">&lt;kato@iki.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KORPIQ">KORPIQ</a><br />

3491. Kamil Jakubovic  <a href="mailto:jake@host.sk">&lt;jake@host.sk&gt;</a> -- JAKEX<br />
3492. Kamil Renczewski  <a href="mailto:kamillo@megapolis.pl">&lt;kamillo@megapolis.pl&gt;</a> -- KAMILLO<br />
3493. <a href="http://uglyman.vip.sina.com">Kane Zeng</a>  <a href="mailto:wintera.zeng@gmail.com">&lt;wintera.zeng@gmail.com&gt;</a> -- KANEZENG<br />

3494. <a href="http://www.wirebird.com/">Karen Cravens</a>  <a href="mailto:silver@phoenyx.net">&lt;silver@phoenyx.net&gt;</a> -- GAMEHAWK<br />
3495. <a href="etheridge.ca">Karen Etheridge</a>  <a href="mailto:karen@etheridge.ca">&lt;karen@etheridge.ca&gt;</a> -- ETHER<br />
3496. Karim A. Nassar  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNASSAR">KNASSAR</a><br />

3497. Karl Erisman  <a href="mailto:kerisman@cpan.org">&lt;kerisman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KERISMAN">KERISMAN</a><br />
3498. <a href="http://www.red-bean.com/~kfogel">Karl Fogel</a>  <a href="mailto:kfogel@red-bean.com">&lt;kfogel@red-bean.com&gt;</a> -- KFOGEL<br />
3499. Karl Gaissmaier  <a href="mailto:karl.gaissmaier at uni-ulm.de">&lt;karl.gaissmaier at uni-ulm.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAISSMAI">GAISSMAI</a><br />

3500. Karl Glazebrook  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KG/KGB">KGB</a><br />
3501. <a href="www.new-aeon.com">Karl Gustav B. Holz</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KHOLZ<br />
3502. Karl Lohner  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KL/KLOHNER">KLOHNER</a><br />

3503. Karl Moens  <a href="mailto:karl.moens(at)pandora.be">&lt;karl.moens(at)pandora.be&gt;</a> -- COUNTZERO<br />
3504. <a href="http://sweetness.ath.cx">Karl Ostmo</a>  <a href="mailto:kostmo@gmail.com">&lt;kostmo@gmail.com&gt;</a> -- KOSTMO<br />
3505. Karl Rune Nilsen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KRN<br />

3506. Karl Schilke (&quot;Rat&quot;)  <a href="mailto:rat-nospam@eli.net">&lt;rat-nospam@eli.net&gt;</a> -- RAT<br />
3507. <a href="http://karlward.com">Karl Ward</a>  <a href="mailto:karlward@cpan.org">&lt;karlward@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARLWARD">KARLWARD</a><br />
3508. <a href="http://ailleurs.org/">Karl Y. Pradène</a>  <a href="mailto:knotty@ailleurs.org">&lt;knotty@ailleurs.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNOTTY">KNOTTY</a><br />

3509. <a href="http://ibeatgarry.com">Karlheinz Zöchling</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARGAMEL">GARGAMEL</a><br />
3510. Karlon West  <a href="mailto:karlon@netcom.com">&lt;karlon@netcom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARLON">KARLON</a><br />
3511. <a href="http://www.designlab.de/">Karsten Pawlik</a>  <a href="mailto:netsrak@cpan.org">&lt;netsrak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NETSRAK">NETSRAK</a><br />

3512. Karthik Krishnamurthy  <a href="mailto:karthik.k@extremix.net">&lt;karthik.k@extremix.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARTHIKK">KARTHIKK</a><br />
3513. Karthik Krishnamurthy  <a href="mailto:karthik.k@extremix.net">&lt;karthik.k@extremix.net&gt;</a> -- KARTHIK<br />
3514. Karthik Umashankar  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KARTHIKU<br />
3515. Karthikeyan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KRAJARAM<br />

3516. Karthikeyan Rajaram  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KARIR<br />
3517. <a href="http://smartdebugger.blogspot.com/">Karthikeyan Rajaram</a>  <a href="mailto:karthi_ir@yahoo.com">&lt;karthi_ir@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAMAN">KRAMAN</a><br />
3518. Karthikeyan Rajaram  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RAJARAM<br />

3519. <a href="http://www.repsak.de/">Kasper Dziurdz</a>  <a href="mailto:kasper@cpan.org">&lt;kasper@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KASPER">KASPER</a><br />
3520. Katherine Doubek  <a href="mailto:kadoubek@gmail.com">&lt;kadoubek@gmail.com&gt;</a> -- KADOUBEK<br />
3521. Katherine Gurdziel  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GURD<br />

3522. <a href="http://www.katspace.com/">Kathryn Andersen</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUBYKAT">RUBYKAT</a><br />
3523. Kathryn Schmitt  <a href="mailto:kass.schmitt@gmail.com">&lt;kass.schmitt@gmail.com&gt;</a> -- KASS<br />
3524. Kay Roepke  <a href="mailto:kay_cpan@dolphin-services.de">&lt;kay_cpan@dolphin-services.de&gt;</a> -- KROEPKE<br />

3525. <a href="http://www.quai.no">Kay Sindre Bærulfsen</a>  <a href="mailto:cpan@uten.net">&lt;cpan@uten.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAYSB">KAYSB</a><br />
3526. <a href="http://blog.kzfmix.com">Kazufumi Ohkawa</a>  <a href="mailto:kerolinq@gmail.com">&lt;kerolinq@gmail.com&gt;</a> -- KZFM<br />
3527. <a href="http://gaou.net">Kazuharu Arakawa</a>  <a href="mailto:gaou@spitz.net">&lt;gaou@spitz.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAOU">GAOU</a><br />

3528. Kazuhiko Yamakura  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YA/YAMAKURA">YAMAKURA</a><br />
3529. Kazuhiro Nishikawa  <a href="mailto:kazuhiro.nishikawa@gmail.com">&lt;kazuhiro.nishikawa@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NISHIKAWA">NISHIKAWA</a><br />
3530. Kazuhiro Oinuma  <a href="mailto:oinume@gmail.com">&lt;oinume@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OI/OINUME">OINUME</a><br />

3531. <a href="http://blog.yappo.jp/">Kazuhiro Osawa</a>  <a href="mailto:ko@yappo.ne.jp">&lt;ko@yappo.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YA/YAPPO">YAPPO</a><br />
3532. <a href="http://seratch.net">Kazuhiro Sera</a>  <a href="mailto:webmaster@seratch.net">&lt;webmaster@seratch.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SERA">SERA</a><br />
3533. Kazuhiro Shibuya  <a href="mailto:k42uh1r0@gmail.com">&lt;k42uh1r0@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIBUYA">SHIBUYA</a><br />

3534. <a href="http://shimi.info/">Kazuhito Shimizu</a>  <a href="mailto:kazuhito.shimizu@gmail.com">&lt;kazuhito.shimizu@gmail.com&gt;</a> -- SHIMI<br />
3535. <a href="http://labs.cybozu.co.jp/blog/kazuhoatwork/">Kazuho Oku</a>  <a href="mailto:kazuhooku@gmail.com">&lt;kazuhooku@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAZUHO">KAZUHO</a><br />
3536. <a href="http://cyberlib.enterbrainz.com/">Kazuma Shiraiwa</a>  <a href="mailto:cyberlib@gmail.com">&lt;cyberlib@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIRAIWA">SHIRAIWA</a><br />

3537. Kazunari Komoriya  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOMORIYA">KOMORIYA</a><br />
3538. <a href="http://wiki.bit-hive.com/tomizoo/">Kazuyoshi Tomita</a>  <a href="mailto:kztomita@cpan.org">&lt;kztomita@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KZ/KZTOMITA">KZTOMITA</a><br />
3539. Kee Hinckley  <a href="mailto:nazgul-cpan@marrowbones.com">&lt;nazgul-cpan@marrowbones.com&gt;</a> -- NAZGUL<br />

3540. <a href="http://crew.emstone.com/~keedi">Keedi Kim</a>  <a href="mailto:keedi@cpan.org">&lt;keedi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEEDI">KEEDI</a><br />
3541. <a href="http://outflux.net/">Kees Cook</a>  <a href="mailto:cook-cpan@outflux.net">&lt;cook-cpan@outflux.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COOK">COOK</a><br />
3542. <a href="http://kees.pink-frog.com">Kees Jan Hermans</a>  <a href="mailto:kees&amp;pink-frog. com">&lt;kees&amp;pink-frog. com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KJ/KJH">KJH</a><br />

3543. <a href="http://www.sodan.org/~knagano/">Keiichiro Nagano</a>  <a href="mailto:knagano@sodan.org">&lt;knagano@sodan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNAGANO">KNAGANO</a><br />
3544. <a href="http://d.hatena.ne.jp/keisukefukuda">Keisuke Fukuda</a>  <a href="mailto:fukuda@cpan.org">&lt;fukuda@cpan.org&gt;</a> -- FUKUDA<br />
3545. <a href="http://suan.hustle.ne.jp/">Keisuke Kuramata</a>  <a href="mailto:winter_mo_machine-gun@hotmail.co.jp">&lt;winter_mo_machine-gun@hotmail.co.jp&gt;</a> -- KEISUKE<br />

3546. <a href="http://casey.jp">Keisuke Nagashima</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CASEY<br />
3547. Keitaro Miyazaki  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KM/KMIYAZAKI">KMIYAZAKI</a><br />
3548. <a href="http://www.develop.com/kbrown">Keith Brown</a>  <a href="mailto:kbrown@develop.com">&lt;kbrown@develop.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBROWN">KBROWN</a><br />

3549. <a href="http://www.spheniscidae.co.uk/perl/">Keith Burdis</a>  <a href="mailto:keith@rucus.ru.ac.za">&lt;keith@rucus.ru.ac.za&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBURDIS">KBURDIS</a><br />
3550. Keith C. Ivey  <a href="mailto:keith@iveys.org">&lt;keith@iveys.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCIVEY">KCIVEY</a><br />
3551. Keith Corlett  <a href="mailto:kco85390@bigpond.net.au">&lt;kco85390@bigpond.net.au&gt;</a> -- CORLETTK<br />

3552. <a href="http://nearlyfree.org">Keith Grennan</a>  <a href="mailto:kgrennan@cpan.org">&lt;kgrennan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KG/KGRENNAN">KGRENNAN</a><br />
3553. <a href="http://keith.lbox.org/">Keith Hoerling</a>  <a href="mailto:keith@hoerling.com">&lt;keith@hoerling.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KH/KHOERLING">KHOERLING</a><br />
3554. Keith Ito  <a href="mailto:kito@cs.stanford.edu">&lt;kito@cs.stanford.edu&gt;</a> -- KITO<br />

3555. <a href="http://www.luna.co.uk/~kpwatson">Keith Watson</a>  <a href="mailto:kpwatson@luna.co.uk">&lt;kpwatson@luna.co.uk&gt;</a> -- KPWATSON<br />
3556. Kelly F Hickel  <a href="mailto:kfh@mqsoftware.com">&lt;kfh@mqsoftware.com&gt;</a> -- KFHICKEL<br />
3557. <a href="http://Ken.Coar.Org/">Ken A L Coar</a>  <a href="mailto:ROUS@Sourcery.Org">&lt;ROUS@Sourcery.Org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROUS">ROUS</a><br />

3558. Ken Barber  <a href="mailto:ken@bob.sh">&lt;ken@bob.sh&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBARBER">KBARBER</a><br />
3559. <a href="http://www.vulpes.com/">Ken Fox</a>  <a href="mailto:kfox@vulpes.com">&lt;kfox@vulpes.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KENFOX">KENFOX</a><br />
3560. <a href="http://hagan.louisville.edu/">Ken Hagan</a>  <a href="mailto:ken.hagan+no.spam+@louisville.edu">&lt;ken.hagan+no.spam+@louisville.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAGANK">HAGANK</a><br />

3561. <a href="http://invent3k.external.hp.com/~KEN.HIRSCH/">Ken Hirsch</a>  <a href="mailto:kahirsch@cpan.org">&lt;kahirsch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAHIRSCH">KAHIRSCH</a><br />
3562. <a href="cn.pm.org">Ken Liu</a>  <a href="mailto:netken@vip.163.com">&lt;netken@vip.163.com&gt;</a> -- NETKEN<br />
3563. Ken MacFarlane  <a href="mailto:kenmacf@cpan.org">&lt;kenmacf@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KENMACF">KENMACF</a><br />

3564. <a href="http://www.bitsko.slc.ut.us/">Ken MacLeod</a>  <a href="mailto:ken@bitsko.slc.ut.us">&lt;ken@bitsko.slc.ut.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KM/KMACLEOD">KMACLEOD</a><br />
3565. Ken Prows  <a href="mailto:perl@xev.net">&lt;perl@xev.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEN">KEN</a><br />
3566. Ken Railey  <a href="mailto:ken_railey@yahoo.com">&lt;ken_railey@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAILEY">KRAILEY</a><br />

3567. Ken Schumack  <a href="mailto:Schumack@cpan.org">&lt;Schumack@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHUMACK">SCHUMACK</a><br />
3568. <a href="http://ttul.org/~ksimpson">Ken Simpson</a>  <a href="mailto:ksimpson@ttul.org">&lt;ksimpson@ttul.org&gt;</a> -- TTUL<br />
3569. <a href="http://webs.to/ken/">Ken Takata</a>  <a href="mailto:kentkt@anet.ne.jp">&lt;kentkt@anet.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KT/KTAKATA">KTAKATA</a><br />

3570. <a href="http://d.hatena.ne.jp/ya_ken/">Ken Takeshige</a>  <a href="mailto:ken.takeshige@gmail.com">&lt;ken.takeshige@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAKESHIGE">TAKESHIGE</a><br />
3571. <a href="http://www.mathforum.org/~ken/">Ken Williams</a>  <a href="mailto:kwilliams@cpan.org">&lt;kwilliams@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWILLIAMS">KWILLIAMS</a><br />
3572. Ken Youens-Clark  <a href="mailto:kclark@cpan.org">&lt;kclark@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCLARK">KCLARK</a><br />

3573. <a href="http://ppm.tcool.org/">Kenichi Ishigaki</a>  <a href="mailto:ishigaki@cpan.org">&lt;ishigaki@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISHIGAKI">ISHIGAKI</a><br />
3574. Kenjiro Hirakawa  <a href="mailto:kenjiro@kenjiro.net">&lt;kenjiro@kenjiro.net&gt;</a> -- KENJIRO<br />
3575. <a href="http://techparc.hypermart.net/">Kenn Ross</a>  <a href="mailto:airbag_kr@go.com">&lt;airbag_kr@go.com&gt;</a> -- KROSS<br />

3576. Kennedy Clark  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HK/HKCLARK">HKCLARK</a><br />
3577. <a href="http://numeric.adr.com/Perl/Perl5Modules.html">Kenneth Albanowski</a>  <a href="mailto:kjahds@kjahds.com">&lt;kjahds@kjahds.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KJ/KJALB">KJALB</a><br />
3578. <a href="http://www.gsaa.com/rets">Kenneth Alexander Holm III</a>  <a href="mailto:rets@meta3.com">&lt;rets@meta3.com&gt;</a> -- KENHOLM<br />

3579. <a href="www.existentialbitchslap.org">Kenneth Atkins</a>  <a href="mailto:kenatk@gmail.com">&lt;kenatk@gmail.com&gt;</a> -- WHITEOWL<br />
3580. Kenneth Auger  <a href="mailto:auger@computer.org">&lt;auger@computer.org&gt;</a> -- AUGER<br />
3581. <a href="http://perl.sensei.nu">Kenneth Ekdahl</a>  <a href="mailto:sensei@sensei.nu">&lt;sensei@sensei.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SENSEI">SENSEI</a><br />

3582. Kenneth Flegal  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KFLEGAL<br />
3583. Kenneth Gonsalves  <a href="mailto:lawgon@thenilgiris.com">&lt;lawgon@thenilgiris.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAWGON">LAWGON</a><br />
3584. Kenneth Ingham  <a href="mailto:cpan@i-pi.com">&lt;cpan@i-pi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INGHAM">INGHAM</a><br />

3585. <a href="http://www.bayareabiofuel.com/">Kenneth Kron</a>  <a href="mailto:kron-pause@aikido.com">&lt;kron-pause@aikido.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KK/KKRON">KKRON</a><br />
3586. Kenneth L. Hamer  <a href="mailto:perl@script-kitty.org">&lt;perl@script-kitty.org&gt;</a> -- KHAMER<br />
3587. Kenneth Ölwing  <a href="mailto:knth@cpan.org">&lt;knth@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNTH">KNTH</a><br />

3588. Kenny Gatdula  <a href="mailto:kennyg@pobox.com">&lt;kennyg@pobox.com&gt;</a> -- KENNYG<br />
3589. Kenny Thomas  <a href="mailto:adminkt@flint.umich.edu">&lt;adminkt@flint.umich.edu&gt;</a> -- KTHOMAS<br />
3590. Kenshin YAMADA  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KENSHIN<br />
3591. <a href="http://www.kentcowgill.org">Kent Cowgill</a>  <a href="mailto:kent@c2group.net">&lt;kent@c2group.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCOWGILL">KCOWGILL</a><br />

3592. <a href="http://kentarok.org/">Kentaro Kuribayashi</a>  <a href="mailto:kentaro@cpan.org">&lt;kentaro@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KENTARO">KENTARO</a><br />
3593. Kester Allen  <a href="mailto:kester@gmail.com">&lt;kester@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KESTER">KESTER</a><br />
3594. <a href="http://www.cs.cmu.edu/~lenzo">Kevin A. Lenzo</a>  <a href="mailto:lenzo@yetanother.org">&lt;lenzo@yetanother.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LENZO">LENZO</a><br />

3595. <a href="http://www.thoughtworthy.com/">Kevin A. McGrail</a>  <a href="mailto:KevinAMcGrail-CPAN@mcgrail.com">&lt;KevinAMcGrail-CPAN@mcgrail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KM/KMCGRAIL">KMCGRAIL</a><br />
3596. <a href="http://sunsite.unc.edu/kevina/perl/">Kevin Atkinson</a>  <a href="mailto:kevina@clark.net">&lt;kevina@clark.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEVINA">KEVINA</a><br />
3597. Kevin Barter  <a href="mailto:kbarter@cpan.org">&lt;kbarter@cpan.org&gt;</a> -- KBARTER<br />

3598. Kevin C. Krinke  <a href="mailto:kckrinke@opendoorsoftware.com">&lt;kckrinke@opendoorsoftware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCK">KCK</a><br />
3599. <a href="http://kevinsnet.com">Kevin C. Leacock</a>  <a href="mailto:kevin@kevinsnet.com">&lt;kevin@kevinsnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CM/CMANTITO">CMANTITO</a><br />
3600. Kevin C. McGrath  <a href="mailto:kmcgrath@baknet.com">&lt;kmcgrath@baknet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KM/KMCGRATH">KMCGRATH</a><br />

3601. Kevin Ehlers  <a href="mailto:kevin@cpan.org">&lt;kevin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEVIN">KEVIN</a><br />
3602. Kevin Falcone  <a href="mailto:cpan@jibsheet.com">&lt;cpan@jibsheet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FALCONE">FALCONE</a><br />
3603. <a href="http://www.fink.com/">Kevin Fink</a>  <a href="mailto:kevin-pause@fink.com">&lt;kevin-pause@fink.com&gt;</a> -- KEVINFINK<br />

3604. <a href="http://www.goess.org/">Kevin Goess</a>  <a href="mailto:cpan@goess.org">&lt;cpan@goess.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KG/KGOESS">KGOESS</a><br />
3605. Kevin Greene  <a href="mailto:kevin@weblab.com">&lt;kevin@weblab.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KG/KGREENE">KGREENE</a><br />
3606. <a href="http://underprint.com/~kamelkev">Kevin Hatim Kamel</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAMELKEV">KAMELKEV</a><br />

3607. <a href="http://www.kjdtech.com">Kevin J. D'Aquila</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KDAQ<br />
3608. <a href="http://www.justanyone.com/">Kevin J. Rice</a>  <a href="mailto:kevin@justanyone.com">&lt;kevin@justanyone.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEVINRICE">KEVINRICE</a><br />
3609. <a href="http://www.kjwcode.com">Kevin J. Woolley</a>  <a href="mailto:kjwcode@cpan.org">&lt;kjwcode@cpan.org&gt;</a> -- KJWCODE<br />

3610. <a href="http://www.pobox.com/~kjj">Kevin Johnson</a>  <a href="mailto:kjj@pobox.com">&lt;kjj@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KJ/KJOHNSON">KJOHNSON</a><br />
3611. Kevin Jones  <a href="mailto:kevinj@cpan.org">&lt;kevinj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEVINJ">KEVINJ</a><br />
3612. Kevin Kinnell  <a href="mailto:kejoki@netdoor.com">&lt;kejoki@netdoor.com&gt;</a> -- KEJOKI<br />

3613. Kevin L. Caswick  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CASWK<br />
3614. Kevin L. Esteb  <a href="mailto:kesteb@wsipc.org">&lt;kesteb@wsipc.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KESTEB">KESTEB</a><br />
3615. <a href="http://www.kevlindev.com">Kevin Lindsey</a>  <a href="mailto:kevin@kevlindev.com">&lt;kevin@kevlindev.com&gt;</a> -- KEVLINDEV<br />

3616. <a href="http://www.digicat.org/">Kevin M. Counts</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- COUNTSKM<br />
3617. <a href="http://b9.com">Kevin M. Rosenberg</a>  <a href="mailto:kevin@rosenberg.net">&lt;kevin@rosenberg.net&gt;</a> -- KMR<br />
3618. <a href="http://www.umich.edu/~clunis/">Kevin McGowan</a>  <a href="mailto:clunis@umich.edu">&lt;clunis@umich.edu&gt;</a> -- CLUNIS<br />

3619. Kevin Meltzer  <a href="mailto:kmeltz@cpan.org">&lt;kmeltz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KM/KMELTZ">KMELTZ</a><br />
3620. Kevin Michael Vail  <a href="mailto:kevin@vaildc.net">&lt;kevin@vaildc.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KV/KVAIL">KVAIL</a><br />
3621. Kevin Montuori  <a href="mailto:cpan@mconsultancy.us">&lt;cpan@mconsultancy.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MONTUORI">MONTUORI</a><br />

3622. Kevin Old  <a href="mailto:kevin@kevinold.com">&lt;kevin@kevinold.com&gt;</a> -- KOLD<br />
3623. <a href="www.tiros.net">Kevin Pfeiffer</a>  <a href="mailto:kpfeiffer@cpan.org">&lt;kpfeiffer@cpan.org&gt;</a> -- KPFEIFFER<br />
3624. <a href="http://www.bestpractical.com">Kevin Riggle</a>  <a href="mailto:kevinr@bestpractical.com">&lt;kevinr@bestpractical.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEVINR">KEVINR</a><br />

3625. Kevin Ruggles  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KRUGGLE<br />
3626. Kevin Ruscoe  <a href="mailto:kevin@sapphireoflondon.org">&lt;kevin@sapphireoflondon.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRUSCOE">KRUSCOE</a><br />
3627. Kevin Ryde  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRYDE">KRYDE</a><br />

3628. <a href="http://borel.slu.edu/">Kevin Scannell</a>  <a href="mailto:scannell@cpan.org">&lt;scannell@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCANNELL">SCANNELL</a><br />
3629. Kevin Shea  <a href="mailto:PAUSE@terapanera.com">&lt;PAUSE@terapanera.com&gt;</a> -- KEVJSHEA<br />
3630. <a href="http://kevinspencer.org">Kevin Spencer</a>  <a href="mailto:kev.spencer@gmail.com">&lt;kev.spencer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSPENCER">KSPENCER</a><br />

3631. <a href="blog.tewk.com">Kevin Tew</a>  <a href="mailto:tewk@tewk.com">&lt;tewk@tewk.com&gt;</a> -- TEWK<br />
3632. Kevin William Henwood  <a href="mailto:Khen1950fx@aol.com">&lt;Khen1950fx@aol.com&gt;</a> -- SKI<br />
3633. Kevin Wittmer  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWITTMER">KWITTMER</a><br />

3634. <a href="www.buzznet.com">Kevin Woolery</a>  <a href="mailto:kevin@buzznet.com">&lt;kevin@buzznet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWOOLERY">KWOOLERY</a><br />
3635. Kfir Ozer  <a href="mailto:ufk2000@gmail.com">&lt;ufk2000@gmail.com&gt;</a> -- UFK<br />
3636. Khemir Nadim  <a href="mailto:nkh@cpen.com">&lt;nkh@cpen.com&gt;</a> -- NADIM<br />

3637. <a href="http://islandinthenet.com">Khürt Williams</a>  <a href="mailto:khurt@islandinthenet.com">&lt;khurt@islandinthenet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KH/KHURT">KHURT</a><br />
3638. Kian Win Ong  <a href="mailto:cpan@bulk.squeakyblue.com">&lt;cpan@bulk.squeakyblue.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIANWIN">KIANWIN</a><br />
3639. Kieren Diment  <a href="mailto:diment@gmail.com">&lt;diment@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZARQUON">ZARQUON</a><br />

3640. <a href="http://texttheater.de">Kilian Evang</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KEVANG<br />
3641. <a href="http://www.killianfaughnan.com">Killian Faughnan</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KFAUGHNAN<br />
3642. Kim Ahlström  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIMAHL">KIMAHL</a><br />

3643. Kim Rutherford  <a href="mailto:cpan@xenu.org.uk">&lt;cpan@xenu.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIM">KIM</a><br />
3644. Kim Ryan  <a href="mailto:kimryan nospam@cpan.org">&lt;kimryan nospam@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIMRYAN">KIMRYAN</a><br />
3645. <a href="http://www.scheibel.co.uk/">Kim Scheibel</a>  <a href="mailto:kscheibel@cpan.org">&lt;kscheibel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSCHEIBEL">KSCHEIBEL</a><br />

3646. <a href="http://www.hovi.org/">Kimmo R. M. Hovi</a>  <a href="mailto:kimmormh@cpan.org">&lt;kimmormh@cpan.org&gt;</a> -- KIMMORMH<br />
3647. Kimmo Valtonen  <a href="mailto:Kimmo.Valtonen@hiit.fi">&lt;Kimmo.Valtonen@hiit.fi&gt;</a> -- KVALTONE<br />
3648. Kin man, Cheung  <a href="mailto:gordon_1971@yahoo.com">&lt;gordon_1971@yahoo.com&gt;</a> -- KINMAN<br />

3649. King  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KCHAN<br />
3650. <a href="http://totalcinema.com/">Kip Hampton</a>  <a href="mailto:khampton@totalcinema.com">&lt;khampton@totalcinema.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KH/KHAMPTON">KHAMPTON</a><br />
3651. <a href="http://www.cyberspace.org/~amonarch">Kirill Frolov</a>  <a href="mailto:amonarch@cyberspace.org">&lt;amonarch@cyberspace.org&gt;</a> -- AMONARCH<br />

3652. <a href="http://www.robobunny.com">Kirk Baucom</a>  <a href="mailto:kbaucom@schizoid.com">&lt;kbaucom@schizoid.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBAUCOM">KBAUCOM</a><br />
3653. Kirk Bocek  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBOCEK">KBOCEK</a><br />
3654. Kirk Patton  <a href="mailto:kirk_patton@yahoo.com">&lt;kirk_patton@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KP/KPATTON">KPATTON</a><br />

3655. <a href="http://infotrope.net">Kirrily 'Skud' Robert</a>  <a href="mailto:perl@infotrope.net">&lt;perl@infotrope.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKUD">SKUD</a><br />
3656. Kirsten Jones  <a href="mailto:synedra@gmail.com">&lt;synedra@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SY/SYNEDRA">SYNEDRA</a><br />
3657. Kirstin Bettiol  <a href="mailto:kirstinbettiol@gmail.com">&lt;kirstinbettiol@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIRSTINB">KIRSTINB</a><br />

3658. <a href="http://www.kitdekat.com">Kit DeKat</a>  <a href="mailto:kitdekat_yh@yahoo.com">&lt;kitdekat_yh@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KITDEKAT">KITDEKAT</a><br />
3659. <a href="http://www.clownswilleatyou.com/">Kit Peters</a>  <a href="mailto:perl@clownswilleatyou.com">&lt;perl@clownswilleatyou.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KP/KPETERS">KPETERS</a><br />
3660. Kiyoshi Aman  <a href="mailto:kiyoshi.aman@gmail.com">&lt;kiyoshi.aman@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AE/AERDAN">AERDAN</a><br />

3661. <a href="http://kfo.ath.cx">Kjartan Flåm Ohr</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KFO<br />
3662. Kjetil Fikkan  <a href="mailto:kjetil@fikkan.org">&lt;kjetil@fikkan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KACCV">KACCV</a><br />
3663. <a href="http://www.kjetil.kjernsmo.net/">Kjetil Kjernsmo</a>  <a href="mailto:kjetilk@cpan.org">&lt;kjetilk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KJ/KJETILK">KJETILK</a><br />

3664. Kjetil Skotheim  <a href="mailto:kjetil.skotheim@usit.uio.no">&lt;kjetil.skotheim@usit.uio.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KJ/KJETIL">KJETIL</a><br />
3665. Klaas-Jan Stol  <a href="mailto:parrotcode@gmail.com">&lt;parrotcode@gmail.com&gt;</a> -- KJS<br />
3666. Klas Lindfors  <a href="mailto:klas.lindfors@it.su.se">&lt;klas.lindfors@it.su.se&gt;</a> -- KLLIN<br />
3667. Klaus Eichner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KEICHNER">KEICHNER</a><br />

3668. <a href="http://www.ethgen.de/">Klaus Ethgen</a>  <a href="mailto:Klaus@Ethgen.de">&lt;Klaus@Ethgen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KETHGEN">KETHGEN</a><br />
3669. Klaus Ita  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KOKI<br />
3670. Klaus Wittrock  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WITTROCK">WITTROCK</a><br />

3671. Knut Arne Bjørndal  <a href="mailto:bob@cakebox.net">&lt;bob@cakebox.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOBKARE">BOBKARE</a><br />
3672. <a href="http://hovenko.no/">Knut-Olav Hoven</a>  <a href="mailto:knut-olav@hoven.ws">&lt;knut-olav@hoven.ws&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOVENKO">HOVENKO</a><br />
3673. <a href="http://snortum.net">Knute Snortum</a>  <a href="mailto:knute@trinityproject.org">&lt;knute@trinityproject.org&gt;</a> -- KSNORTUM<br />

3674. Koen Dejonghe  <a href="mailto:koen@fietsoverland.com">&lt;koen@fietsoverland.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOEN">KOEN</a><br />
3675. Koichi Taniguchi  <a href="mailto:taniguchi@livedoor.jp">&lt;taniguchi@livedoor.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TANIGUCHI">TANIGUCHI</a><br />
3676. <a href="http://romerun.romerun.com/">Komtanoo  Pinpimai</a>  <a href="mailto:romerun@romerun.com">&lt;romerun@romerun.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROMERUN">ROMERUN</a><br />

3677. <a href="http://clear-m.narod.ru/">Kononov Alexey</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ALXPLDEV<br />
3678. <a href="konstantin.antselovich.com">Konstantin Antselovich</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KONSTANT<br />
3679. <a href="http://ecy.web.ur.ru">Konstantin Doulepov</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KD/KDOULEPOV">KDOULEPOV</a><br />

3680. <a href="http://konstantin.shemyak.com">Konstantin Shemyak</a>  <a href="mailto:konstantin@shemyak.com">&lt;konstantin@shemyak.com&gt;</a> -- SHEMYAK<br />
3681. Konstantin Weiner  <a href="mailto:cpan@omnigram.com">&lt;cpan@omnigram.com&gt;</a> -- WEINERK<br />
3682. <a href="http://users.raketnet.nl/koos_pol/default.htm">Koos Pol</a>  <a href="mailto:koos_pol@NO.raketnet.JUNK.nl.MAIL">&lt;koos_pol@NO.raketnet.JUNK.nl.MAIL&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KP/KPOL">KPOL</a><br />

3683. <a href="http://idefix.net/~koos/">Koos van den Hout</a>  <a href="mailto:koos@kzdoos.xs4all.nl">&lt;koos@kzdoos.xs4all.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOOS">KOOS</a><br />
3684. Korsani  <a href="mailto:korsani@free.fr">&lt;korsani@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KORSANI">KORSANI</a><br />
3685. Kostyuk Oleg  <a href="mailto:cub.uanic@gmail.com">&lt;cub.uanic@gmail.com&gt;</a> -- CUB<br />

3686. Kota Sakoda  <a href="mailto:cohtan@cpan.org">&lt;cohtan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COHTAN">COHTAN</a><br />
3687. <a href="http://masutaro.jp/">Kotaro MASUDA</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MASUTARO<br />
3688. <a href="http://pobox.com/~kragen/">Kragen Javier Sitaker</a>  <a href="mailto:kragen@pobox.com">&lt;kragen@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAGEN">KRAGEN</a><br />

3689. Kremmydas Dimitrios  <a href="mailto:dimikrem@cpan.org">&lt;dimikrem@cpan.org&gt;</a> -- DIMIKREM<br />
3690. <a href="http://reality.sgi.com/employees/krishna">Krishna Shamu Sethuraman</a>  <a href="mailto:krishpl@shamu.corp.sgi.com">&lt;krishpl@shamu.corp.sgi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRISHPL">KRISHPL</a><br />
3691. <a href="http://www.indexing.ca/kristi/">Kristi</a>  <a href="mailto:kristi@indexing.ca">&lt;kristi@indexing.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRISTI">KRISTI</a><br />

3692. <a href="http://www.kfsw.de/">Kristian Fischer</a>  <a href="mailto:me@kfsw.de">&lt;me@kfsw.de&gt;</a> -- PAPILLION<br />
3693. <a href="twitter.com/bmxkris">Kristian Flint</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BMXKRIS<br />
3694. <a href="http://www.cs.auc.dk/~torp">Kristian Torp</a>  <a href="mailto:torp@cs.auc.dk">&lt;torp@cs.auc.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KT/KTORP">KTORP</a><br />

3695. Kristian Truelsen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TRUELSEN<br />
3696. Kristina Nairn  <a href="mailto:knairn@nairnzone.com">&lt;knairn@nairnzone.com&gt;</a> -- KNAIRN<br />
3697. Kristofer Hölzer  <a href="mailto:khoelzer@cpan.org">&lt;khoelzer@cpan.org&gt;</a> -- KHOELZER<br />
3698. <a href="http://www.wikia.com/">Krzysztof Krzyżaniak</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KRZKRZ<br />

3699. Krzysztof Suchomski  <a href="mailto:krzysztof.suchomski@gmail.com">&lt;krzysztof.suchomski@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IZ/IZI">IZI</a><br />
3700. Kuang-che Wu (吳光哲)  <a href="mailto:kcwu@csie.org">&lt;kcwu@csie.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCWU">KCWU</a><br />
3701. Kuldeep Chitrakar  <a href="mailto:kuldeepchitrakar@gmail.com">&lt;kuldeepchitrakar@gmail.com&gt;</a> -- KULDEEP<br />

3702. Kultawat Chandarkeo  <a href="mailto:kultawat@hotmail.com">&lt;kultawat@hotmail.com&gt;</a> -- KULTAWAT<br />
3703. Kunal Jaiswal  <a href="mailto:kunal.jaiswal@yahoo.com">&lt;kunal.jaiswal@yahoo.com&gt;</a> -- NICKS<br />
3704. Kurt D. Starsinic  <a href="mailto:kstar at cpan dot org">&lt;kstar at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSTAR">KSTAR</a><br />
3705. <a href="http://tengil.org/">Kurt George Gjerde</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KG/KGJERDE">KGJERDE</a><br />

3706. <a href="http://www.neurogames.net">Kurt Kincaid</a>  <a href="mailto:sifukurt@yahoo.com">&lt;sifukurt@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIFUKURT">SIFUKURT</a><br />
3707. Kurt Schellpeper  <a href="mailto:krs@cpan.org">&lt;krs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRS">KRS</a><br />
3708. <a href="http://www.kurtstephens.com/">Kurt Stephens</a>  <a href="mailto:ks.perl@kurtstephens.com">&lt;ks.perl@kurtstephens.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSTEPHENS">KSTEPHENS</a><br />

3709. Kurt W. Whitsel  <a href="mailto:kurtwhitsel@yahoo.com">&lt;kurtwhitsel@yahoo.com&gt;</a> -- KWHITSEL<br />
3710. <a href="http://www.kurtwilms.com">Kurt Wilms</a>  <a href="mailto:wilms(at)cs(dot)umn(dot)edu">&lt;wilms(at)cs(dot)umn(dot)edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWILMS">KWILMS</a><br />
3711. <a href="www.pepsdesign.com">Kurtis P Stephens</a>  <a href="mailto:kstep@pepsdesign.com">&lt;kstep@pepsdesign.com&gt;</a> -- KSTEP<br />

3712. <a href="http://allafrica.com/staff/kwindla/">Kwindla Hultman Kramer</a>  <a href="mailto:kwindla@allafrica.com">&lt;kwindla@allafrica.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KW/KWINDLA">KWINDLA</a><br />
3713. Kyle Dawkins  <a href="mailto:kyle@centralparksoftware.com">&lt;kyle@centralparksoftware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYLED">KYLED</a><br />
3714. <a href="http://www.amberarcher.com">Kyle Downey</a>  <a href="mailto:kdowney@amberarcher.com">&lt;kdowney@amberarcher.com&gt;</a> -- KDOWNEY<br />

3715. Kyle Hamar  <a href="mailto:kylehamar@yahoo.com">&lt;kylehamar@yahoo.com&gt;</a> -- KHAMAR<br />
3716. Kyle Hasselbacher  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYLE">KYLE</a><br />
3717. <a href="http://www.neverlight.com/~mortis">Kyle R. Burton</a>  <a href="mailto:kyle.burton@gmail.com">&lt;kyle.burton@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRBURTON">KRBURTON</a><br />

3718. <a href="http://www.kylesch.net">Kyle Schlansker</a>  <a href="mailto:kylesch+cpanpub@gmail.com">&lt;kylesch+cpanpub@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYLESCH">KYLESCH</a><br />
3719. Kynan Delorey  <a href="mailto:k.delorey@jach.hawaii.edu">&lt;k.delorey@jach.hawaii.edu&gt;</a> -- KYNAN<br />
3720. <a href="http://hail2u.net/">Kyo Nagashima</a>  <a href="mailto:kyo@hail2u.net">&lt;kyo@hail2u.net&gt;</a> -- KYO<br />

3721. <a href="http:/www.artotal.com">LE MEILLEUR</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ALIRZO<br />
3722. Lalit Parate  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LALIT<br />
3723. Lamprecht Christoph  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAMPRECHT">LAMPRECHT</a><br />

3724. Lance E Sloan  <a href="mailto:lsloan-pause001@umich.edu">&lt;lsloan-pause001@umich.edu&gt;</a> -- LSLOAN<br />
3725. <a href="http://upt.org/lane">Lane Davis</a>  <a href="mailto:cpanpublic@upt.org">&lt;cpanpublic@upt.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LD/LDAVIS">LDAVIS</a><br />
3726. Larry Leszczynski  <a href="mailto:larryl@cpan.org">&lt;larryl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LARRYL">LARRYL</a><br />

3727. Larry Shatzer, Jr.  <a href="mailto:larrysh@cpan.org">&lt;larrysh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LARRYSH">LARRYSH</a><br />
3728. Larry Wall. Author of Perl. Busy man.  <a href="mailto:larry@wall.org">&lt;larry@wall.org&gt;</a> -- LWALL<br />
3729. Lars Balker Rasmussen  <a href="mailto:lars@balker.dk">&lt;lars@balker.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBR">LBR</a><br />

3730. Lars Dɪᴇᴄᴋᴏᴡ 迪拉斯  <a href="mailto:daxim@cpan.org">&lt;daxim@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAXIM">DAXIM</a><br />
3731. <a href="http://www.satanic.dk/">Lars G. T. Jørgensen</a>  <a href="mailto:larsj@diku.dk">&lt;larsj@diku.dk&gt;</a> -- LARSGT<br />
3732. Lars Hartmann  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHLUMPF">SCHLUMPF</a><br />

3733. Lars Kruse  <a href="mailto:allgemein@sumpfralle.de">&lt;allgemein@sumpfralle.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUMPFRALL">SUMPFRALL</a><br />
3734. Lars Lundberg  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LARSLUND">LARSLUND</a><br />
3735. Lars Nygaard  <a href="mailto:lars.nygaard@iln.uio.no">&lt;lars.nygaard@iln.uio.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LARSNYG">LARSNYG</a><br />

3736. <a href="www.skjaerlund.dk/lars">Lars Skjærlund</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LARSSKJ<br />
3737. Lars Thegler  <a href="mailto:lars@thegler.dk">&lt;lars@thegler.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LT/LTHEGLER">LTHEGLER</a><br />
3738. Lars Thon  <a href="mailto:lars@aeluros.com">&lt;lars@aeluros.com&gt;</a> -- LARSTHON<br />

3739. Laszlo Molnar  <a href="mailto:molnarl@cdata.tvnet.hu">&lt;molnarl@cdata.tvnet.hu&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LM/LMOLNAR">LMOLNAR</a><br />
3740. Laura Kassner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LABEKA<br />
3741. Laura Miller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LOZ<br />
3742. Laurent Bendavid  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBENDAVID">LBENDAVID</a><br />

3743. Laurent Dami  <a href="mailto:laurent dami *AT* free fr">&lt;laurent dami *AT* free fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAMI">DAMI</a><br />
3744. Laurent GAUTROT  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LGAUTROT<br />
3745. Laurent Hoss  <a href="mailto:laurent.hoss@gmx.net">&lt;laurent.hoss@gmx.net&gt;</a> -- LHOSS<br />
3746. <a href="http://perso.club-internet.fr/rocherl/">Laurent Rocher</a>  <a href="mailto:lrocher@cpan.org">&lt;lrocher@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LR/LROCHER">LROCHER</a><br />

3747. Laurent Simonneau  <a href="mailto:l.simonneau@free.fr">&lt;l.simonneau@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LS/LSIM">LSIM</a><br />
3748. Laurent Wacrenier  <a href="mailto:lwa@teaser.fr">&lt;lwa@teaser.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LW/LWA">LWA</a><br />
3749. <a href="http://ltierney.demon.co.uk">Lawrence Tierney</a>  <a href="mailto:lord0@hotmail.co.uk">&lt;lord0@hotmail.co.uk&gt;</a> -- LORDO<br />

3750. Laye Suen (孫 磊)  <a href="mailto:cpan.laye@gmail.com">&lt;cpan.laye@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAYE">LAYE</a><br />
3751. <a href="http://br.geocities.com./lgcdutra/">Leandro Guimarães Faria Corcete DUTRA</a>  <a href="mailto:leandro@dutra.fastmail.fm">&lt;leandro@dutra.fastmail.fm&gt;</a> -- LEANDRO<br />
3752. <a href="http://www.tobehurd.org">Lee Aylward</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEEDO">LEEDO</a><br />

3753. Lee Carmichael  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LCARMICH<br />
3754. Lee Eakin  <a href="mailto:leakin@dfw.nostrum.com">&lt;leakin@dfw.nostrum.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEAKIN">LEAKIN</a><br />
3755. <a href="http://www.learnperl.org">Lee Engel</a>  <a href="mailto:lee@kode.co.za">&lt;lee@kode.co.za&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LENGEL">LENGEL</a><br />

3756. Lee McLoughlin  <a href="mailto:lmjm@icparc.ic.ac.uk">&lt;lmjm@icparc.ic.ac.uk&gt;</a> -- LMJM<br />
3757. <a href="http://leeland.net/myperlmodules.html">Lee Pumphret</a>  <a href="mailto:perl@leeland.net">&lt;perl@leeland.net&gt;</a> -- SHOTGUN<br />
3758. Lee R. Toman  <a href="mailto:leetoman@eznet.net">&lt;leetoman@eznet.net&gt;</a> -- ZOGZAPPER<br />

3759. Lee Semel  <a href="mailto:lee@semel.net">&lt;lee@semel.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LH/LHS">LHS</a><br />
3760. <a href="http://www.LeeGoddard.net/">Lee ♫ Goddard</a>  <a href="mailto:lgoddard--at--cpan.org">&lt;lgoddard--at--cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LG/LGODDARD">LGODDARD</a><br />
3761. Leendert Bottelberghs  <a href="mailto:lbottel@cpan.org">&lt;lbottel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBOTTEL">LBOTTEL</a><br />

3762. Lei Zhang  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ZHANGL<br />
3763. <a href="http://sourceforge.net/projects/tidyview">Leif Eriksen</a>  <a href="mailto:leif.eriksen@hpa.com.au">&lt;leif.eriksen@hpa.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEIF">LEIF</a><br />
3764. Leif Gustafson  <a href="mailto:jdeluise@cpan.org">&lt;jdeluise@cpan.org&gt;</a> -- JDELUISE<br />

3765. <a href="http://www.ogre.com/~leif/">Leif Hedstrom</a>  <a href="mailto:leif@ogre.com">&lt;leif@ogre.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEIFHED">LEIFHED</a><br />
3766. <a href="http://devel.it.su.se">Leif Johansson</a>  <a href="mailto:leifj@it.su.se">&lt;leifj@it.su.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEIFJ">LEIFJ</a><br />
3767. <a href="http://bilbo.hobbiton.org/">Leif Pedersen</a>  <a href="mailto:bilbo@hobbiton.org">&lt;bilbo@hobbiton.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BILBO">BILBO</a><br />

3768. <a href="http://www.antisocialgeniuses.com">Leigh Metcalf</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LM/LMETCALF">LMETCALF</a><br />
3769. <a href="http://protoplasmic.org">Leland Johnson</a>  <a href="mailto:">&lt;&gt;</a> -- LJOHNSON<br />
3770. <a href="http://cogent.net/lencharest/">Len Charest</a>  <a href="mailto:len@cogent.net">&lt;len@cogent.net&gt;</a> -- LKCJR<br />

3771. Lennart Borgman  <a href="mailto:Lennart.Borgman@draco.se.astra.com">&lt;Lennart.Borgman@draco.se.astra.com&gt;</a> -- LBORGMAN<br />
3772. Lennart Staflin  <a href="mailto:lenst@lysator.liu.se">&lt;lenst@lysator.liu.se&gt;</a> -- LSTAF<br />
3773. Lennert Ouwerkerk  <a href="mailto:lennert@kabelfoon.nl">&lt;lennert@kabelfoon.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LENNERTO">LENNERTO</a><br />
3774. Lenny Brenner  <a href="mailto:lenny@cpan.org">&lt;lenny@cpan.org&gt;</a> -- LENNY<br />

3775. <a href="http://springtimesoft.com">Lenz Gschwendtner</a>  <a href="mailto:norbu@cpan.org">&lt;norbu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NORBU">NORBU</a><br />
3776. Leo Albert Jackson Jr  <a href="mailto:lajjr7115@gmail.com">&lt;lajjr7115@gmail.com&gt;</a> -- LAJJR<br />
3777. Leo Antunes  <a href="mailto:costela@gmail.com">&lt;costela@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COSTELA">COSTELA</a><br />

3778. <a href="http://www.ziptie.org/">Leo Bayer</a>  <a href="mailto:lbayer@cpan.org">&lt;lbayer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBAYER">LBAYER</a><br />
3779. Leo Cacciari  <a href="mailto:hobbit@cpan.org">&lt;hobbit@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOBBIT">HOBBIT</a><br />
3780. <a href="http://leocharre.com">Leo Charre</a>  <a href="mailto:leocharre@cpan.org">&lt;leocharre@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEOCHARRE">LEOCHARRE</a><br />

3781. <a href="http://leo.cuckoo.org/projects/">Leo Lapworth</a>  <a href="mailto:LLAP@cuckoo.org">&lt;LLAP@cuckoo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LL/LLAP">LLAP</a><br />
3782. Leo Manfredi  <a href="mailto:manfredi@cpan.org">&lt;manfredi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANFREDI">MANFREDI</a><br />
3783. <a href="http://eatworms.swmed.edu/~leon/">Leon Avery</a>  <a href="mailto:leon@eatworms.swmed.edu">&lt;leon@eatworms.swmed.edu&gt;</a> -- LEON<br />

3784. Leon Cowle  <a href="mailto:leon@leolizma.com">&lt;leon@leolizma.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LC/LCOWLE">LCOWLE</a><br />
3785. Leon Timmermans  <a href="mailto:fawaka@gmail.com">&lt;fawaka@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEONT">LEONT</a><br />
3786. Leonard Miller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- OLEGM<br />

3787. <a href="http://www.pobox.com/~lbudney">Leonard R Budney</a>  <a href="mailto:lbudney@pobox.com">&lt;lbudney@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUDNEY">BUDNEY</a><br />
3788. <a href="http://www.lgrinberg.org">Leonid Grinberg</a>  <a href="mailto:lgrinberg@gmail.com">&lt;lgrinberg@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAHAFAHA">HAHAFAHA</a><br />
3789. Leonov A Petr  <a href="mailto:gojpeg@gmail.com">&lt;gojpeg@gmail.com&gt;</a> -- LEONOVPA<br />

3790. Leopold Tötsch  <a href="mailto:lt@toetsch.at">&lt;lt@toetsch.at&gt;</a> -- LTOETSCH<br />
3791. <a href="http://www.did7.of.pl">Lepenkov Sergey</a>  <a href="mailto:minus@mail333.com">&lt;minus@mail333.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AB/ABALAMA">ABALAMA</a><br />
3792. <a href="http://www.lesandchris.com/">Les Howard</a>  <a href="mailto:lhoward@spamcop.net">&lt;lhoward@spamcop.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LH/LHOWARD">LHOWARD</a><br />

3793. Les Peters  <a href="mailto:les.peters@gmail.com">&lt;les.peters@gmail.com&gt;</a> -- LPETERS<br />
3794. Leslie D. Paul  <a href="mailto:Leslie.D.Paul@bankofamerica.com">&lt;Leslie.D.Paul@bankofamerica.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LESPAUL">LESPAUL</a><br />
3795. <a href="http://www.pobox.com/~deus_x">Leslie Michael Orchard</a>  <a href="mailto:deus_x@pobox.com">&lt;deus_x@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEUSX">DEUSX</a><br />

3796. Lester Crossman Hall  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INVENTOR">INVENTOR</a><br />
3797. <a href="http://www.10east.com/~hightowe">Lester Hightower</a>  <a href="mailto:hightowe@10east.com">&lt;hightowe@10east.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HIGHTOWE">HIGHTOWE</a><br />
3798. Levon Barker  <a href="mailto:levon_barker@yahoo.ca">&lt;levon_barker@yahoo.ca&gt;</a> -- LEVONB<br />

3799. <a href="http://www.emulationzone.org/projects/metalix/">Lewis AS Bassett</a>  <a href="mailto:Lolbassett@aol.com">&lt;Lolbassett@aol.com&gt;</a> -- METALIX<br />
3800. <a href="http://www.perlfect.org">Li Cheng</a>  <a href="mailto:lob4tt@gmail.com">&lt;lob4tt@gmail.com&gt;</a> -- LICH<br />
3801. Lian Wan Situ  <a href="mailto:lwsitu@cpan.org">&lt;lwsitu@cpan.org&gt;</a> -- LWSITU<br />

3802. <a href="xpanel.com">Lilian Rudenco</a>  <a href="mailto:info@xpanel.com">&lt;info@xpanel.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XP/XPANEL">XPANEL</a><br />
3803. Lilo Huang  <a href="mailto:lilohuang@kuso.cc">&lt;lilohuang@kuso.cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KENWU">KENWU</a><br />
3804. <a href="http://linas.org">Linas Vepstas</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINAS">LINAS</a><br />

3805. Lincoln A Baxter  <a href="mailto:lab@lincolnbaxter.com.MAKE.ME.VALID">&lt;lab@lincolnbaxter.com.MAKE.ME.VALID&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBAXTER">LBAXTER</a><br />
3806. Lincoln Baxter, III  <a href="mailto:lb3perl@gmail.com.MAKE.THIS.VALID">&lt;lb3perl@gmail.com.MAKE.THIS.VALID&gt;</a> -- LINCOLNB<br />
3807. <a href="http://stein.cshl.edu">Lincoln D. Stein</a>  <a href="mailto:lstein@cshl.edu">&lt;lstein@cshl.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LD/LDS">LDS</a><br />

3808. Linda A Walsh  <a href="mailto:pause@tlinx.org">&lt;pause@tlinx.org&gt;</a> -- LAWALSH<br />
3809. Linda Julien  <a href="mailto:leira@cpan.org">&lt;leira@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEIRA">LEIRA</a><br />
3810. <a href="http://lornlab.org">Lindolfo Rodrigues de Oliveira Neto</a>  <a href="mailto:lorn at perl dot org dot br">&lt;lorn at perl dot org dot br&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LORN">LORN</a><br />

3811. <a href="http://dropfknuck.net">Lionel Mehl</a>  <a href="mailto:blade@dropfknuck.net">&lt;blade@dropfknuck.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLADE">BLADE</a><br />
3812. <a href="http://www.pcscperl.org/">Lionel Victor</a>  <a href="mailto:lionel.victor@free.fr">&lt;lionel.victor@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TC/TCHINCHOW">TCHINCHOW</a><br />
3813. Lior Abitbol  <a href="mailto:LiorPA2004@hotmail.com">&lt;LiorPA2004@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LABITBOL">LABITBOL</a><br />

3814. Liraz Siri  <a href="mailto:liraz_siri@usa.net">&lt;liraz_siri@usa.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LIRAZ">LIRAZ</a><br />
3815. Lloyd Richardson  <a href="mailto:lloyd@drlabs.org">&lt;lloyd@drlabs.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LL/LLOYDR">LLOYDR</a><br />
3816. <a href="http://www.template-toolkit.ru/">Lobanov Igor</a>  <a href="mailto:master@lio.ur.ru">&lt;master@lio.ur.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LIOL">LIOL</a><br />

3817. <a href="http://www.senga.org/">Loic Dachary</a>  <a href="mailto:loic@senga.org">&lt;loic@senga.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LD/LDACHARY">LDACHARY</a><br />
3818. Lokkju  <a href="mailto:lokkju@lokkju.com">&lt;lokkju@lokkju.com&gt;</a> -- LOKKJU<br />
3819. <a href="http://members.xoom.com/stinsonl2/">Lorance Stinson</a>  <a href="mailto:lorance@madlinux.cx">&lt;lorance@madlinux.cx&gt;</a> -- MADLINUX<br />

3820. Lord Infernale  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INFERNALE">INFERNALE</a><br />
3821. Lorenz Domke  <a href="mailto:lorenz.domke@gmx.de">&lt;lorenz.domke@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LD/LDOMKE">LDOMKE</a><br />
3822. Lorenzo Becchi  <a href="mailto:lbecchi@cpan.org">&lt;lbecchi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBECCHI">LBECCHI</a><br />

3823. Lorenzo Canovi  <a href="mailto:lorenzo@lcanovi.com">&lt;lorenzo@lcanovi.com&gt;</a> -- KANNA<br />
3824. Lorenzo Cappelletti  <a href="mailto:lorenzo.cappelletti@email.it">&lt;lorenzo.cappelletti@email.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOLO">LOLO</a><br />
3825. Lorenzo Luconi Trombacchi  <a href="mailto:lorenzo.luconi@iit.cnr.it">&lt;lorenzo.luconi@iit.cnr.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LL/LLT">LLT</a><br />

3826. Loïc Dreux  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LOICDREUX<br />
3827. <a href="http://luben.unixsol.org">Luben Karavelov</a>  <a href="mailto:luben@unixsol.org">&lt;luben@unixsol.org&gt;</a> -- KARAVELOV<br />
3828. <a href="http://v3.sk/~lkundrak/">Lubomir Rintel</a>  <a href="mailto:lkundrak at cpan">&lt;lkundrak at cpan&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LK/LKUNDRAK">LKUNDRAK</a><br />

3829. Luc St-Louis  <a href="mailto:lucs@cpan.org">&lt;lucs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUCS">LUCS</a><br />
3830. Luc Van Tilborgh  <a href="mailto:lvt@ockham.be">&lt;lvt@ockham.be&gt;</a> -- LUVANTI<br />
3831. Luca Fini  <a href="mailto:lfini@arcetri.astro.it">&lt;lfini@arcetri.astro.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LF/LFINI">LFINI</a><br />

3832. Luciano Miguel Ferreira Rocha  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- STRANGE<br />
3833. Lucien Van Elsen  <a href="mailto:lucienve@gmail.com">&lt;lucienve@gmail.com&gt;</a> -- LVANELSEN<br />
3834. Luigino Masarati  <a href="mailto:lmasarati@hotmail.com">&lt;lmasarati@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LM/LMASARA">LMASARA</a><br />
3835. <a href="http://www.andrew.cmu.edu/user/lchavez/">Luis Chavez</a>  <a href="mailto:lchavez@andrew.cmu.edu">&lt;lchavez@andrew.cmu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LC/LCHAVEZ">LCHAVEZ</a><br />

3836. Luis E. G. Ontanon  <a href="mailto:luis.ontanon@gmail.com">&lt;luis.ontanon@gmail.com&gt;</a> -- LEGO<br />
3837. Luis Henrique Cassis Fagundes  <a href="mailto:lhfagundes@gmail.com">&lt;lhfagundes@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LF/LFAGUNDES">LFAGUNDES</a><br />
3838. Luis León Cárdenas Graide  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LUXOSTEIN<br />
3839. Luis Moreno  <a href="mailto:luis@cantv.net">&lt;luis@cantv.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEMP">LEMP</a><br />

3840. <a href="http://www.bitbistro.com/~champs/">Luis Motta Campos</a>  <a href="mailto:lmc@cpan.org">&lt;lmc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LM/LMC">LMC</a><br />
3841. <a href="http://mipagina.cantv.net/lem/">Luis Muñoz</a>  <a href="mailto:luismunoz@cpan.org">&lt;luismunoz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUISMUNOZ">LUISMUNOZ</a><br />
3842. Lukas C. Faulstich  <a href="mailto:faulstic@inf.fu-berlin.de">&lt;faulstic@inf.fu-berlin.de&gt;</a> -- FAULSTIC<br />

3843. Lukas Fiker  <a href="mailto:lfiker@email.cz">&lt;lfiker@email.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUFI">LUFI</a><br />
3844. Lukas Mai  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAUKE">MAUKE</a><br />
3845. <a href="http://sgn.cornell.edu">Lukas Mueller</a>  <a href="mailto:lam87@cornell.edu">&lt;lam87@cornell.edu&gt;</a> -- LMUELLER<br />

3846. <a href="http://pixie.madstop.com">Luke A. Kanies</a>  <a href="mailto:luke@madstop.com">&lt;luke@madstop.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOOSIFER">LOOSIFER</a><br />
3847. <a href="http://awesnob.com">Luke Closs</a>  <a href="mailto:cpan@5thplane.com">&lt;cpan@5thplane.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUKEC">LUKEC</a><br />
3848. <a href="http://luke.dashjr.org">Luke Dashjr</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DASHJR<br />

3849. <a href="http://girasquid.com">Luke Hutscal</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GIRASQUID<br />
3850. Luke Meyer  <a href="mailto:luke@daeron.com">&lt;luke@daeron.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LM/LMEYER">LMEYER</a><br />
3851. <a href="http://luqui.org/">Luke Palmer</a>  <a href="mailto:lrpalmer@gmail.com">&lt;lrpalmer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LP/LPALMER">LPALMER</a><br />

3852. <a href="http://luke.petre.net">Luke Petre</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LPETRE<br />
3853. <a href="http://www.neuro-tech.net/">Luke Reeves</a>  <a href="mailto:luke@neuro-tech.net">&lt;luke@neuro-tech.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LR/LREEVES">LREEVES</a><br />
3854. <a href="http://lukeross.name/">Luke Ross</a>  <a href="mailto:lukeross@gmail.com">&lt;lukeross@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUKEROSS">LUKEROSS</a><br />

3855. Luke Saunders  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LS/LSAUNDERS">LSAUNDERS</a><br />
3856. <a href="http://lucassmith.name">Luke Smith</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRPROLIX">DRPROLIX</a><br />
3857. <a href="http://triple.aeoth.net">Luke Triantafyllidis</a>  <a href="mailto:ltriant@cpan.org">&lt;ltriant@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LT/LTRIANT">LTRIANT</a><br />

3858. <a href="http://uts.cc.utexas.edu/~lyl/">Luke Y. Lu</a>  <a href="mailto:ylu@mail.utexas.edu">&lt;ylu@mail.utexas.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YL/YLU">YLU</a><br />
3859. <a href="http://lukhnos.org">Lukhnos D. Liu</a>  <a href="mailto:lukhnos@gmail.com">&lt;lukhnos@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUKHNOS">LUKHNOS</a><br />
3860. <a href="http://tanecni-olomouc.cz/lzap">Lukáš Zapletal</a>  <a href="mailto:">&lt;&gt;</a> -- LZAP<br />

3861. <a href="http://free.prohosting.com/~lupe">Lupe Christoph</a>  <a href="mailto:lupe@lupe-christoph.de">&lt;lupe@lupe-christoph.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUPE">LUPE</a><br />
3862. <a href="http://www.stratcom.com/plan9/perl.html">Luther Huffman</a>  <a href="mailto:lutherh@stratcom.com">&lt;lutherh@stratcom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUTHERH">LUTHERH</a><br />
3863. <a href="http://braceta.com">Luís Azevedo</a>  <a href="mailto:braceta@cpan.org">&lt;braceta@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRACETA">BRACETA</a><br />

3864. Lyle Hayhurst  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOZIN">SOZIN</a><br />
3865. <a href="http://www.cosmicperl.com">Lyle Hopkins</a>  <a href="mailto:cosmicnet@cpan.org">&lt;cosmicnet@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COSMICNET">COSMICNET</a><br />
3866. Lyo Kato  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LY/LYOKATO">LYOKATO</a><br />

3867. <a href="http://www.astray.com/">Léon Brocard</a>  <a href="mailto:leon@astray.com">&lt;leon@astray.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LB/LBROCARD">LBROCARD</a><br />
3868. <a href="www.mcarterbrown.com">M Carter Brown</a>  <a href="mailto:me@mcarterbrown.com">&lt;me@mcarterbrown.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARTER">CARTER</a><br />
3869. M. Kristall  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MSK<br />

3870. M. Lavondes  <a href="mailto:pauamma@cpan.org">&lt;pauamma@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAUAMMA">PAUAMMA</a><br />
3871. <a href="www.dm-book.com">M. Scott Roth</a>  <a href="mailto:scott@dm-book.com">&lt;scott@dm-book.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSROTH">MSROTH</a><br />
3872. <a href="http://www.rslt.nl">M.C. Deurloo</a>  <a href="mailto:m.c.deurloo@rslt.nl">&lt;m.c.deurloo@rslt.nl&gt;</a> -- WIZARD<br />

3873. <a href="www.geocities.com/netpai">M.K.Pai</a>  <a href="mailto:madhavprasad.pai@gmail.com">&lt;madhavprasad.pai@gmail.com&gt;</a> -- PAI<br />
3874. MAEKAWA Tsuyoshi  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- XCEZX<br />
3875. <a href="http://use.perl.org/~tokuhirom/journal/">MATSUNO★Tokuhiro</a>  <a href="mailto:tokuhirom+cpan@gmail.com">&lt;tokuhirom+cpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOKUHIROM">TOKUHIROM</a><br />

3876. <a href="http://www.honeyclient.org/trac">MITRE Honeyclient Project</a>  <a href="mailto:honeyclient@mitre.org">&lt;honeyclient@mitre.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MITREHC">MITREHC</a><br />
3877. MIYAMUKO Katsuyuki  <a href="mailto:miyamuko@mtb.biglobe.ne.jp">&lt;miyamuko@mtb.biglobe.ne.jp&gt;</a> -- MIYAMUKO<br />
3878. MIZUTANI, Tociyuki  <a href="mailto:tociyuki@gmail.com">&lt;tociyuki@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOCIYUKI">TOCIYUKI</a><br />

3879. MOCK  <a href="mailto:mock@mailchannels.com">&lt;mock@mailchannels.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOCK">MOCK</a><br />
3880. MOHAMED PARVEZ  <a href="mailto:parvez@gmail.com">&lt;parvez@gmail.com&gt;</a> -- PARVEZ<br />
3881. MOHAMMED HAARIS  <a href="mailto:noobiont@sify.com">&lt;noobiont@sify.com&gt;</a> -- NOOBIONT<br />
3882. <a href="http://www.2nms.com">Maarten Wallraf</a>  <a href="mailto:perl@2nms.com">&lt;perl@2nms.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWALLRAF">MWALLRAF</a><br />

3883. <a href="http://www.thedumbterminal.co.uk">MacGyveR</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DUMB<br />
3884. Maciej 'agaran' Pijanka  <a href="mailto:maciej.pijanka@pld-linux.org">&lt;maciej.pijanka@pld-linux.org&gt;</a> -- MPIJANKA<br />
3885. <a href="http://www.idlewords.com">Maciej Ceglowski</a>  <a href="mailto:developer@ceglowski.com">&lt;developer@ceglowski.com&gt;</a> -- MACIEJ<br />

3886. <a href="http://www.idlewords.com">Maciej Ceglowski</a>  <a href="mailto:mceglows@middlebury.edu">&lt;mceglows@middlebury.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCEGLOWS">MCEGLOWS</a><br />
3887. Maciej Pijanka  <a href="mailto:maciej.pijanka@gmail.com">&lt;maciej.pijanka@gmail.com&gt;</a> -- AGARAN<br />
3888. Macpaul Lin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MACPAUL<br />

3889. <a href="http://x42.com/">Magnus Bodin</a>  <a href="mailto:magnus-cpan@bodin.org">&lt;magnus-cpan@bodin.org&gt;</a> -- BODIN<br />
3890. <a href="http://www.lysator.liu.se/~mace/">Magnus Cedergren</a>  <a href="mailto:datorer.program@esplanaden.lysator.liu.se">&lt;datorer.program@esplanaden.lysator.liu.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAGNUS">MAGNUS</a><br />
3891. Magnus Håkansson  <a href="mailto:magnus@mbox604.swipnet.se">&lt;magnus@mbox604.swipnet.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAGH">MAGH</a><br />

3892. Magnus Pålsson  <a href="mailto:magu@cpan.org">&lt;magu@cpan.org&gt;</a> -- MAGU<br />
3893. <a href="http://ducts.27b-6.de">Magnus Schmidt</a>  <a href="mailto:pause.perl.org.nospam@27b-6.de">&lt;pause.perl.org.nospam@27b-6.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMLOWRIE">SAMLOWRIE</a><br />
3894. <a href="http://www.d.umn.edu/~joshi031/">Mahesh Joshi</a>  <a href="mailto:joshi031@d.umn.edu">&lt;joshi031@d.umn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JM/JMAHESH">JMAHESH</a><br />

3895. Mahesh Tailor  <a href="mailto:tsm@seesop.us">&lt;tsm@seesop.us&gt;</a> -- TSMPERL<br />
3896. <a href="http://www.martini.nu/">Mahlon E. Smith</a>  <a href="mailto:mahlon@martini.nu">&lt;mahlon@martini.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAHLON">MAHLON</a><br />
3897. Main Brain  <a href="mailto:mainbrain@yandex.ru">&lt;mainbrain@yandex.ru&gt;</a> -- MAINBRAIN<br />

3898. <a href="http://www.donzoko.net/">Makamaka Hannyaharamitu</a>  <a href="mailto:makamaka@cpan.org">&lt;makamaka@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAKAMAKA">MAKAMAKA</a><br />
3899. Makio Tsukamoto  <a href="mailto:tsukamoto@gmail.com">&lt;tsukamoto@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSUKAMOTO">TSUKAMOTO</a><br />
3900. Makis Marmaridis  <a href="mailto:makis@scm.uws.edu.au">&lt;makis@scm.uws.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAKIS">MAKIS</a><br />

3901. Maksim Khrapov  <a href="mailto:khrapov@sbcglobal.net">&lt;khrapov@sbcglobal.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKHRAPOV">MKHRAPOV</a><br />
3902. <a href="www.malaybasu.net">Malay Kumar Basu</a>  <a href="mailto:malay@bioinformatics.org">&lt;malay@bioinformatics.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALAY">MALAY</a><br />
3903. Malcolm Beattie  <a href="mailto:mbeattie@clueful.co.uk">&lt;mbeattie@clueful.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MICB">MICB</a><br />

3904. <a href="nisoftware.com">Malcolm Dew-Jones</a>  <a href="mailto:yf110@victoria.tc.ca">&lt;yf110@victoria.tc.ca&gt;</a> -- MDEWJONES<br />
3905. Malcolm H. Nooning  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MN/MNOONING">MNOONING</a><br />
3906. <a href="http://www.liminalflux.net/perl/contact.html">Malcolm J Harwood</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJH">MJH</a><br />

3907. <a href="http://msquadrat.de/">Malte S. Stretz</a>  <a href="mailto:mss@cpan.org">&lt;mss@cpan.org&gt;</a> -- MSS<br />
3908. Malte Ubl  <a href="mailto:ubl@schaffhausen.de">&lt;ubl@schaffhausen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALTEU">MALTEU</a><br />
3909. Manish Ahluwalia  <a href="mailto:&lt;my firstname&gt;.&lt;my lastname&gt;@gmail.com">&lt;&lt;my firstname&gt;.&lt;my lastname&gt;@gmail.com&gt;</a> -- MANISH<br />

3910. Manish Saxena  <a href="mailto:manish_sax@yahoo.com">&lt;manish_sax@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HU/HUGHES">HUGHES</a><br />
3911. Manni Heumann  <a href="mailto:cpan@lxxi.org">&lt;cpan@lxxi.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANNI">MANNI</a><br />
3912. Manoj Gupta  <a href="mailto:manojkumargupta@gmail.com">&lt;manojkumargupta@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANOJKG">MANOJKG</a><br />

3913. Manoj Shimpi  <a href="mailto:manoj_shimpi@hotmail.com">&lt;manoj_shimpi@hotmail.com&gt;</a> -- MSHIMPI<br />
3914. Manpreet Singh  <a href="mailto:manpreet@cpan.org">&lt;manpreet@cpan.org&gt;</a> -- MANPREET<br />
3915. Manuel Batista  <a href="mailto:batista.man@neu.edu">&lt;batista.man@neu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBATISTA">MBATISTA</a><br />
3916. Manuel Gebele  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GEBELE">GEBELE</a><br />

3917. Manuel Renz  <a href="mailto:manuel.removethis@email.de">&lt;manuel.removethis@email.de&gt;</a> -- MRENZ<br />
3918. <a href="http://www.dfb.unipi.it">Manuel Ricci</a>  <a href="mailto:ricci@dfb.unipi.it">&lt;ricci@dfb.unipi.it&gt;</a> -- MANUEL<br />
3919. <a href="http://rabade.net">Manuel Rábade</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MIG<br />

3920. <a href="http://www.inovativ-consult.ro">Manuel Subredu</a>  <a href="mailto:diablo@iasi.roedu.net">&lt;diablo@iasi.roedu.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIABLO">DIABLO</a><br />
3921. Manuel Valente  <a href="mailto:manuel.valente@gmail.com">&lt;manuel.valente@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANU">MANU</a><br />
3922. <a href="www.marc-s.de">Marc - Sebastian Lucksch</a>  <a href="mailto:perl@marc-s.de">&lt;perl@marc-s.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALUKU">MALUKU</a><br />

3923. <a href="http://home.attbi.com/~mwaitkin/">Marc Aitkin</a>  <a href="mailto:mwaitkin@attbi.com">&lt;mwaitkin@attbi.com&gt;</a> -- MAITKIN<br />
3924. Marc Aslett  <a href="mailto:aslett@cpan.org">&lt;aslett@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASLETT">ASLETT</a><br />
3925. Marc Beyer  <a href="mailto:japh@tirwhan.org">&lt;japh@tirwhan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARCB">MARCB</a><br />

3926. <a href="marcbrockschmidt.de">Marc Brockschmidt</a>  <a href="mailto:he+cpan@marcbrockschmidt.de">&lt;he+cpan@marcbrockschmidt.de&gt;</a> -- MMJB<br />
3927. <a href="www.olkid.com">Marc C. Bailey</a>  <a href="mailto:mcbailey@csupomona.edu">&lt;mcbailey@csupomona.edu&gt;</a> -- OLKID<br />
3928. <a href="http://truffle.penguinpowered.com/">Marc D. Spencer</a>  <a href="mailto:marcs@pobox.com">&lt;marcs@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSPENCER">MSPENCER</a><br />

3929. <a href="http://www.nerdcircus.org">Marc Dougherty</a>  <a href="mailto:ks12gcm02[REMOVEME]@sneakemail.com">&lt;ks12gcm02[REMOVEME]@sneakemail.com&gt;</a> -- MUNCUS<br />
3930. Marc Girod  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGI">MGI</a><br />
3931. <a href="http://www.precipice.org/">Marc Hedlund</a>  <a href="mailto:marc@precipice.org">&lt;marc@precipice.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGH">MGH</a><br />

3932. Marc Koderer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKODERER">MKODERER</a><br />
3933. <a href="http://www.melange-it.com">Marc Lambrichs</a>  <a href="mailto:marc.lambrichs@melange-it.com">&lt;marc.lambrichs@melange-it.com&gt;</a> -- MARC<br />
3934. <a href="http://www.inf.ethz.ch/~langhein/">Marc Langheinrich</a>  <a href="mailto:marclang@cpan.org">&lt;marclang@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARCLANG">MARCLANG</a><br />

3935. <a href="http://software.schmorp.de/">Marc Lehmann</a>  <a href="mailto:schmorp@schmorp.de">&lt;schmorp@schmorp.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLEHMANN">MLEHMANN</a><br />
3936. <a href="http://www.entropy.ch">Marc Liyanage</a>  <a href="mailto:reg.cpan@entropy.ch">&lt;reg.cpan@entropy.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LIYANAGE">LIYANAGE</a><br />
3937. <a href="www.doorways.org">Marc M. Adkins</a>  <a href="mailto:Perl@Doorways.org">&lt;Perl@Doorways.org&gt;</a> -- RANXEROX<br />

3938. <a href="http://www.majcher.com/">Marc Majcher</a>  <a href="mailto:pause@majcher.com">&lt;pause@majcher.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAJCHER">MAJCHER</a><br />
3939. Marc Mettes  <a href="mailto:marcs_perl@yahoo.com">&lt;marcs_perl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMETTES">MMETTES</a><br />
3940. Marc Mims  <a href="mailto:mmims@cpan.org">&lt;mmims@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMIMS">MMIMS</a><br />

3941. Marc Paquette  <a href="mailto:Marc.Paquette@crim.ca">&lt;Marc.Paquette@crim.ca&gt;</a> -- MARCP<br />
3942. <a href="http://petemar1.perlmonk.org">Marc Peters</a>  <a href="mailto:petemar1@hotmail.com">&lt;petemar1@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPETERS">MPETERS</a><br />
3943. Marc Prewitt  <a href="mailto:mprewitt@chelsea.net">&lt;mprewitt@chelsea.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPREWITT">MPREWITT</a><br />

3944. <a href="http://www.zoozle.org/">Marc Qantins</a>  <a href="mailto:qantins@googlemail.com">&lt;qantins@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QA/QANTINS">QANTINS</a><br />
3945. Marc Riddle  <a href="mailto:marcriddle@yahoo.com">&lt;marcriddle@yahoo.com&gt;</a> -- MRIDDLE<br />
3946. <a href="http://mbrooks.info">Marc S. Brooks</a>  <a href="mailto:mbrooks@cpan.org">&lt;mbrooks@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBROOKS">MBROOKS</a><br />

3947. <a href="http://ganderbay.net/">Marc Schumann</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WURBLZAP<br />
3948. Marc Sebastian Pelzer  <a href="mailto:mpelzer@NOSPAMgmailNOSPAM.com">&lt;mpelzer@NOSPAMgmailNOSPAM.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPELZER">MPELZER</a><br />
3949. Marc Slagle  <a href="mailto:marc.slagle@online-rewards.com">&lt;marc.slagle@online-rewards.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSLAGLE">MSLAGLE</a><br />

3950. <a href="http://www.interunion.ca">Marc Tardif</a>  <a href="mailto:mtardif@interunion.ca">&lt;mtardif@interunion.ca&gt;</a> -- INTMKTG<br />
3951. <a href="http://www-oss.fnal.gov/~mengel">Marc W. Mengel</a>  <a href="mailto:mengel@fnal.gov">&lt;mengel@fnal.gov&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MENGEL">MENGEL</a><br />
3952. <a href="http://hanekomu.at/blog/">Marcel Grünauer == hanekomu (跳ね込む)</a>  <a href="mailto:marcel@cpan.org">&lt;marcel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARCEL">MARCEL</a><br />

3953. Marcel Weber  <a href="mailto:mmweber@ncpro.com">&lt;mmweber@ncpro.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMWEBER">MMWEBER</a><br />
3954. Marcelo Rodrigues  <a href="mailto:marcelo@cpan.org">&lt;marcelo@cpan.org&gt;</a> -- MARCELO<br />
3955. <a href="http://www.capitalnet.com/~marcin">Marcin Kolbuszewski</a>  <a href="mailto:marcin@capitalnet.com">&lt;marcin@capitalnet.com&gt;</a> -- MARCIN<br />

3956. <a href="http://www.hakore.com">Marcin Krzyżanowski</a>  <a href="mailto:krzak@cpan.org">&lt;krzak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRZAK">KRZAK</a><br />
3957. Marco A P D'Andrade  <a href="mailto:mda@embratel.net.br">&lt;mda@embratel.net.br&gt;</a> -- MDA<br />
3958. <a href="http://www.unixmonkeys.com/amnesiac">Marco Antonio Manzo</a>  <a href="mailto:marcoam@perl.org.mx">&lt;marcoam@perl.org.mx&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMNESIAC">AMNESIAC</a><br />

3959. Marco Antonio Valenzuela Escárcega  <a href="mailto:marcos@cpan.org">&lt;marcos@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARCOS">MARCOS</a><br />
3960. <a href="http://www.postcogito.org">Marco Carnut</a>  <a href="mailto:kiko@tempest.com.br">&lt;kiko@tempest.com.br&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KC/KCARNUT">KCARNUT</a><br />
3961. <a href="http://thediracsea.org">Marco Dalla Stella</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAL">KRAL</a><br />

3962. Marco Fontani  <a href="mailto:mfontani@cpan.org">&lt;mfontani@cpan.org&gt;</a> -- MFONTANI<br />
3963. Marco Gazerro  <a href="mailto:gazerro@open2b.com">&lt;gazerro@open2b.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAZERRO">GAZERRO</a><br />
3964. <a href="http://brasil.pm.org">Marco Lima</a>  <a href="mailto:mago@rio.pm.org">&lt;mago@rio.pm.org&gt;</a> -- MAGO<br />

3965. <a href="http://www.clicktk.eu">Marco Marazzi</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMARCO">MMARCO</a><br />
3966. Marco Marongiu  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRONTO">BRONTO</a><br />
3967. Marco Moreno  <a href="mailto:Marco.Moreno@pobox.com">&lt;Marco.Moreno@pobox.com&gt;</a> -- MMORENO<br />

3968. <a href="http://www.magick-source.net">Marco Neves</a>  <a href="mailto:mpneves@camelot.co.pt">&lt;mpneves@camelot.co.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEVES">NEVES</a><br />
3969. <a href="https://www.sdn.sap.com/irj/sdn/maxdb">Marco Paskamp</a>  <a href="mailto:marco.paskamp@sap.com">&lt;marco.paskamp@sap.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXDB">MAXDB</a><br />
3970. <a href="http://www.nemux.org">Marco Romano</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEMUX">NEMUX</a><br />

3971. Marco Schrieck  <a href="mailto:marco.schrieck@gmx.de">&lt;marco.schrieck@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHRIECK">SCHRIECK</a><br />
3972. Marco Wise  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARCO<br />
3973. <a href="http://www.linux.it/~md/">Marco d'Itri</a>  <a href="mailto:md@linux.it">&lt;md@linux.it&gt;</a> -- MDI<br />

3974. <a href="http://www.nettuning.biz/">Marcos Legido Hernández</a>  <a href="mailto:lain@nettuning.biz">&lt;lain@nettuning.biz&gt;</a> -- LAINMLH<br />
3975. <a href="http://www.beranek.de">Marcus Beranek</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BERA">BERA</a><br />
3976. Marcus Harnisch  <a href="mailto:marcus.harnisch@gmx.net">&lt;marcus.harnisch@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHARNISCH">MHARNISCH</a><br />

3977. Marcus Holland-Moritz  <a href="mailto:mhx-cpan@gmx.net">&lt;mhx-cpan@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHX">MHX</a><br />
3978. Marcus Pries  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MPRIES<br />
3979. <a href="http://marcusramberg.livejournal.com">Marcus Ramberg</a>  <a href="mailto:mramberg@cpan.org">&lt;mramberg@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRAMBERG">MRAMBERG</a><br />

3980. <a href="http://perl.thiesen.org">Marcus Thiesen</a>  <a href="mailto:marcus@cpan.org">&lt;marcus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARCUS">MARCUS</a><br />
3981. Marcus Watkins  <a href="mailto:marwatk@us.ibm.com">&lt;marwatk@us.ibm.com&gt;</a> -- MARWATK<br />
3982. <a href="http://saftsack.fs.uni-bayreuth.de/~marek/">Marek Rouchal</a>  <a href="mailto:Marek.Rouchal@gmx.net">&lt;Marek.Rouchal@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAREKR">MAREKR</a><br />

3983. Mariana Alvaro  <a href="mailto:mariana@alvaro.com.ar">&lt;mariana@alvaro.com.ar&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALVARO">MALVARO</a><br />
3984. Mariano Wahlmann  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DICHI<br />
3985. Marino Andres  <a href="mailto:andres@erasme.org">&lt;andres@erasme.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IG/IGREC">IGREC</a><br />

3986. Mario Domgörgen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDOM">MDOM</a><br />
3987. <a href="http://www.codehack.org/">Mario Fürderer</a>  <a href="mailto:mariof@cpan.org">&lt;mariof@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARIOF">MARIOF</a><br />
3988. <a href="https://sourceforge.net/projects/pequel/">Mario Gaffiero</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAFFIE">GAFFIE</a><br />

3989. <a href="http://manno.name">Mario Manno</a>  <a href="mailto:mm-p.ause@manno.name">&lt;mm-p.ause@manno.name&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MANNO">MANNO</a><br />
3990. Mario Russo  <a href="mailto:marioism@yahoo.com">&lt;marioism@yahoo.com&gt;</a> -- MLRU<br />
3991. Mario Silva  <a href="mailto:mario.silva@verticalone.pt">&lt;mario.silva@verticalone.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSILVA">MSILVA</a><br />

3992. <a href="http://www.chengfu.net/">Mario Witte</a>  <a href="mailto:mwitte@cpan.org">&lt;mwitte@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWITTE">MWITTE</a><br />
3993. Marisa Fernanda Pereira Brites  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARISABT<br />
3994. Marius Larsen Jøhndal  <a href="mailto:mariuslj@cpan.org">&lt;mariuslj@cpan.org&gt;</a> -- MARIUSLJ<br />

3995. Mariusz Czułada  <a href="mailto:manieq@idea.net.pl">&lt;manieq@idea.net.pl&gt;</a> -- MPCZ<br />
3996. <a href="http://www.wm7d.net/">Mark A. Downing</a>  <a href="mailto:mdowning@wm7d.net">&lt;mdowning@wm7d.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDOWNING">MDOWNING</a><br />
3997. <a href="http://mah.everybody.org/weblog/">Mark A. Hershberger</a>  <a href="mailto:mah@everybody.org">&lt;mah@everybody.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAHEX">MAHEX</a><br />

3998. Mark A. Imbriaco  <a href="mailto:mark.imbriaco@pobox.com">&lt;mark.imbriaco@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKIM">MARKIM</a><br />
3999. <a href="http://sporkstorms.org">Mark A. Stratman</a>  <a href="mailto:mark@sporkstorms.org">&lt;mark@sporkstorms.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSTRAT">MSTRAT</a><br />
4000. Mark Adamson  <a href="mailto:mark@nb.net">&lt;mark@nb.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AD/ADAMSON">ADAMSON</a><br />

4001. <a href="http://www.byte-me.org/~mallen/">Mark Allen</a>  <a href="mailto:mrallen1@yahoo.com">&lt;mrallen1@yahoo.com&gt;</a> -- MALLEN<br />
4002. <a href="http://www.emer.net">Mark Anderson</a>  <a href="mailto:markemer@cpan.org">&lt;markemer@cpan.org&gt;</a> -- MARKEMER<br />
4003. <a href="http://mark.atwood.name/">Mark Atwood</a>  <a href="mailto:me@mark.atwood.name">&lt;me@mark.atwood.name&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRA">MRA</a><br />

4004. <a href="http://mark.aufflick.com/">Mark Aufflick</a>  <a href="mailto:mark@aufflick.com">&lt;mark@aufflick.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AUFFLICK">AUFFLICK</a><br />
4005. Mark Badolato  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BADO<br />
4006. <a href="http://mark.beihoffer.com">Mark Beihoffer</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DRAGONFLY<br />

4007. Mark Biggar  <a href="mailto:mark.a.biggar@attbi.com">&lt;mark.a.biggar@attbi.com&gt;</a> -- MARKB<br />
4008. Mark Blythe  <a href="mailto:mblythe@cpan.org">&lt;mblythe@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBLYTHE">MBLYTHE</a><br />
4009. Mark Canup  <a href="mailto:markcanup@pobox.com">&lt;markcanup@pobox.com&gt;</a> -- MJCANUP<br />
4010. Mark Clements  <a href="mailto:markdclements@yahoo.co.uk">&lt;markdclements@yahoo.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BADGERSRC">BADGERSRC</a><br />

4011. Mark Constable  <a href="mailto:markc@goldcoast.org">&lt;markc@goldcoast.org&gt;</a> -- MARKC<br />
4012. <a href="http://www.workzoo.com/">Mark D. Maunder</a>  <a href="mailto:mark@workzoo.com">&lt;mark@workzoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAUNDER">MAUNDER</a><br />
4013. <a href="http://www.feep.net/~roth/">Mark D. Roth</a>  <a href="mailto:roth@feep.net">&lt;roth@feep.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROTH">ROTH</a><br />

4014. Mark Daglish  <a href="mailto:mark-daglish@blueyonder.co.uk">&lt;mark-daglish@blueyonder.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKD">MARKD</a><br />
4015. Mark Dilger  <a href="mailto:dilger@cpan.org">&lt;dilger@cpan.org&gt;</a> -- DILGER<br />
4016. <a href="http://www.wxperl.co.uk">Mark Dootson</a>  <a href="mailto:mdootson@cpan.org">&lt;mdootson@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDOOTSON">MDOOTSON</a><br />

4017. <a href="http://www.zzo.com">Mark Ethan Trostler</a>  <a href="mailto:mark@zzo.com">&lt;mark@zzo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/METZZO">METZZO</a><br />
4018. Mark Ferris  <a href="mailto:mferris@cpan.org">&lt;mferris@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFERRIS">MFERRIS</a><br />
4019. Mark Filipovic  <a href="mailto:markfi@cpan.org">&lt;markfi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKFI">MARKFI</a><br />

4020. <a href="http://www.twoshortplanks.com/">Mark Fowler</a>  <a href="mailto:mark@twoshortplanks.com">&lt;mark@twoshortplanks.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKF">MARKF</a><br />
4021. Mark Freeman  <a href="mailto:mccf-removethis-@teradrome.com">&lt;mccf-removethis-@teradrome.com&gt;</a> -- MFREE<br />
4022. Mark Fuller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFULLER">MFULLER</a><br />

4023. <a href="http://www.glines.org/">Mark Glines</a>  <a href="mailto:mark!glines,org">&lt;mark!glines,org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IN/INFINOID">INFINOID</a><br />
4024. <a href="http://www.peculiarities.com">Mark Grimes</a>  <a href="mailto:mgrimes@cpan.org">&lt;mgrimes@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGRIMES">MGRIMES</a><br />
4025. Mark Griskey  <a href="mailto:mark@linuxhardware.net">&lt;mark@linuxhardware.net&gt;</a> -- GRISKEY<br />

4026. <a href="http://www.markh.com/">Mark Hazen</a>  <a href="mailto:perl@markh.com">&lt;perl@markh.com&gt;</a> -- MHAZEN<br />
4027. <a href="http://www.scriptdolphin.org">Mark Hedges</a>  <a href="mailto:$you*##figure#&amp;@it*$out:#&amp;*!!hedges!#*!#scriptdolphin*#@^#*org**#&amp;">&lt;$you*##figure#&amp;@it*$out:#&amp;*!!hedges!#*!#scriptdolphin*#@^#*org**#&amp;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKLE">MARKLE</a><br />

4028. <a href="www.hofstetter.at">Mark Hofstetter</a>  <a href="mailto:cpan@hofstetter.at">&lt;cpan@hofstetter.at&gt;</a> -- MARK<br />
4029. <a href="http://www.cyberporte.com">Mark Howe</a>  <a href="mailto:melonman@cpan.org">&lt;melonman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MELONMAN">MELONMAN</a><br />
4030. <a href="http://bushnet.demon.co.uk/">Mark J Bush</a>  <a href="mailto:Mark.Bush@bushnet.demon.co.uk">&lt;Mark.Bush@bushnet.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKBUSH">MARKBUSH</a><br />

4031. Mark J Hewitt  <a href="mailto:m.hewitt@computer.org">&lt;m.hewitt@computer.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJHEWITT">MJHEWITT</a><br />
4032. <a href="http://www.wikitravel.org">Mark Jaroski</a>  <a href="mailto:markj@cpan.org">&lt;markj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKJ">MARKJ</a><br />
4033. <a href="http://perl.plover.com/">Mark Jason Dominus (陶敏修)</a>  <a href="mailto:mjd@plover.com">&lt;mjd@plover.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJD">MJD</a><br />

4034. <a href="www.markjeffreyleeds.com">Mark Jeffrey Leeds</a>  <a href="mailto:mail@doc99.com">&lt;mail@doc99.com&gt;</a> -- MJLEEDS<br />
4035. <a href="http://www.markmueller.com/">Mark K Mueller</a>  <a href="mailto:mkmueller (at) cpan .org">&lt;mkmueller (at) cpan .org&gt;</a> -- MKMUELLER<br />
4036. Mark Kennedy  <a href="mailto:mtk@ny.ubs.com">&lt;mtk@ny.ubs.com&gt;</a> -- MARKK<br />

4037. <a href="http://asarian-host.net/">Mark Kramer</a>  <a href="mailto:admin@asarian-host.net">&lt;admin@asarian-host.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASARIAN">ASARIAN</a><br />
4038. Mark Lawrence  <a href="mailto:nomad@null.net">&lt;nomad@null.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLAWREN">MLAWREN</a><br />
4039. <a href="http://mark-fisher.home.mindspring.com/">Mark Leighton Fisher</a>  <a href="mailto:mark-fisher@mindspring.com">&lt;mark-fisher@mindspring.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLFISHER">MLFISHER</a><br />

4040. Mark Mabry  <a href="mailto:mmabry@cpan.org">&lt;mmabry@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMABRY">MMABRY</a><br />
4041. Mark Mc Keown  <a href="mailto:mark.mckeown@manchester.ac.uk">&lt;mark.mckeown@manchester.ac.uk&gt;</a> -- ZZCGUMK<br />
4042. Mark McConnell  <a href="mailto:mischke@squeekyclean.net">&lt;mischke@squeekyclean.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MISCHKE">MISCHKE</a><br />

4043. <a href="http://mark.mielke.cc/">Mark Mielke</a>  <a href="mailto:mark@mark.mielke.cc">&lt;mark@mark.mielke.cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKM">MARKM</a><br />
4044. <a href="http://www.lapcrew.com">Mark Mitchell</a>  <a href="mailto:mark@lapcrew.com">&lt;mark@lapcrew.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CARCUS">CARCUS</a><br />
4045. Mark Morgan  <a href="mailto:makk384@gmail.com">&lt;makk384@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMORGAN">MMORGAN</a><br />

4046. Mark Ng  <a href="mailto:markn+cpan@cs.mu.oz.au">&lt;markn+cpan@cs.mu.oz.au&gt;</a> -- MARKNG<br />
4047. <a href="http://www.tcu-inc.com">Mark Nielsen</a>  <a href="mailto:junk@tcu-inc.com">&lt;junk@tcu-inc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIELSEN">NIELSEN</a><br />
4048. Mark Nodine  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NODINE">NODINE</a><br />

4049. <a href="http://marknormanfrancis.com/">Mark Norman Francis</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MNF<br />
4050. Mark O'Connor  <a href="mailto:mark@myspotontheweb.com">&lt;mark@myspotontheweb.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKO">MARKO</a><br />
4051. <a href="http://dragon.me.queensu.ca/olesen/">Mark Olesen</a>  <a href="mailto:">&lt;&gt;</a> -- OLESEN<br />

4052. <a href="http://mark.overmeer.net">Mark Overmeer</a>  <a href="mailto:mark@overmeer.net">&lt;mark@overmeer.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKOV">MARKOV</a><br />
4053. Mark P Sullivan  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSULLIVA">MSULLIVA</a><br />
4054. Mark Palmer  <a href="mailto:palmer300@yahoo.com">&lt;palmer300@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRPALMER">MRPALMER</a><br />

4055. <a href="http://markpasc.org/">Mark Paschal</a>  <a href="mailto:markpasc@markpasc.org">&lt;markpasc@markpasc.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKPASC">MARKPASC</a><br />
4056. Mark Pease  <a href="mailto:pease@cpan.org">&lt;pease@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEASE">PEASE</a><br />
4057. Mark Peter Mansell  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MPMANSELL<br />

4058. <a href="http://www.mlp-consulting.com.au">Mark Pfeiffer</a>  <a href="mailto:cpan@mlp-consulting.com.au">&lt;cpan@mlp-consulting.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKPF">MARKPF</a><br />
4059. Mark Prior  <a href="mailto:mrp@connect.com.au">&lt;mrp@connect.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKPRIOR">MARKPRIOR</a><br />
4060. Mark R. Kaehny  <a href="mailto:kaehny@execpc.com">&lt;kaehny@execpc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRKAE">MRKAE</a><br />

4061. Mark Ralf Thomson  <a href="mailto:Mark-Thomson@gmx.net">&lt;Mark-Thomson@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOMSON">THOMSON</a><br />
4062. Mark Reynolds  <a href="mailto:msreynolds@yahoo.com">&lt;msreynolds@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REYNOLDS">REYNOLDS</a><br />
4063. Mark Rogaski  <a href="mailto:mrogaski@cpan.org">&lt;mrogaski@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MROGASKI">MROGASKI</a><br />

4064. <a href="http://www.bangor.ac.uk/~issa0e">Mark Rowlands</a>  <a href="mailto:m.rowlands@bangor.ac.uk">&lt;m.rowlands@bangor.ac.uk&gt;</a> -- MROWLANDS<br />
4065. <a href="http://www.markbach.com/">Mark Schonbach</a>  <a href="mailto:cpan at my username dot com">&lt;cpan at my username dot com&gt;</a> -- MARKBACH<br />
4066. Mark Shelor  <a href="mailto:mshelor@cpan.org">&lt;mshelor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSHELOR">MSHELOR</a><br />

4067. <a href="http://www.xb95.com/">Mark Smith</a>  <a href="mailto:mark@xb95.com">&lt;mark@xb95.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKSMITH">MARKSMITH</a><br />
4068. <a href="http://www.slmn.org/">Mark Solomon</a>  <a href="mailto:msolomon@seva.net">&lt;msolomon@seva.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSOLOMON">MSOLOMON</a><br />
4069. Mark Southern  <a href="mailto:msouthern@cpan.org">&lt;msouthern@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSOUTHERN">MSOUTHERN</a><br />

4070. Mark Steele  <a href="mailto:msteele@belent.com">&lt;msteele@belent.com&gt;</a> -- MSTEELE<br />
4071. Mark Stinson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MSTINSON<br />
4072. <a href="http://mark.stosberg.com/">Mark Stosberg</a>  <a href="mailto:mark@summersault.com">&lt;mark@summersault.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKSTOS">MARKSTOS</a><br />

4073. <a href="http://www.qtrac.eu">Mark Summerfield</a>  <a href="mailto:summer@qtrac.eu">&lt;summer@qtrac.eu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUMMER">SUMMER</a><br />
4074. Mark Swayne  <a href="mailto:mark.swayne@charter.net">&lt;mark.swayne@charter.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAOTOAD">DAOTOAD</a><br />
4075. <a href="http://www.markthomas.org">Mark Thomas</a>  <a href="mailto:mark@markthomas.org">&lt;mark@markthomas.org&gt;</a> -- MTHOMAS<br />

4076. <a href="http://mark.tiefenbruck.org/">Mark Tiefenbruck</a>  <a href="mailto:pythagosaurus@gmail.com">&lt;pythagosaurus@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDASH">MDASH</a><br />
4077. Mark Tiramani  <a href="mailto:markjt@fredo.co.uk">&lt;markjt@fredo.co.uk&gt;</a> -- MTIRAMANI<br />
4078. <a href="http://www.veltzer.net">Mark Veltzer</a>  <a href="mailto:mark@veltzer.net">&lt;mark@veltzer.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VE/VELTZER">VELTZER</a><br />

4079. Mark Wardell  <a href="mailto:mwardell@cpan.org">&lt;mwardell@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWARDELL">MWARDELL</a><br />
4080. Mark Warren  <a href="mailto:mwarren42@gmail.com">&lt;mwarren42@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWARREN">MWARREN</a><br />
4081. <a href="http://www.mjwilcox.com">Mark Wilcox</a>  <a href="mailto:mark@mjwilcox.com">&lt;mark@mjwilcox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEWILCOX">MEWILCOX</a><br />

4082. Mark Winder  <a href="mailto:markwin@cpan.org">&lt;markwin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKWIN">MARKWIN</a><br />
4083. Mark Wong  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKWKM">MARKWKM</a><br />
4084. Marko Asplund  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASPA">ASPA</a><br />

4085. <a href="www.markus.org">Markus Baertschi</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARKUSB">MARKUSB</a><br />
4086. <a href="http://www.oberhumer.com/">Markus F.X.J. Oberhumer</a>  <a href="mailto:cpan@oberhumer.com">&lt;cpan@oberhumer.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFX">MFX</a><br />
4087. <a href="http://www.relix.de">Markus Heller</a>  <a href="mailto:markus@relix.de">&lt;markus@relix.de&gt;</a> -- HELLERM<br />

4088. <a href="http://www.hollihazhomepage.net/">Markus Holzer</a>  <a href="mailto:holli.holzer@googlemail.com">&lt;holli.holzer@googlemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLLI">HOLLI</a><br />
4089. <a href="http://weirdoz.net">Markus Koppenberger</a>  <a href="mailto:koppi@weirdoz.net">&lt;koppi@weirdoz.net&gt;</a> -- KOPPI<br />
4090. <a href="http://www.linke.de">Markus Linke</a>  <a href="mailto:markus.linke@linke.de">&lt;markus.linke@linke.de&gt;</a> -- LINMAR<br />

4091. Markus Mahlberg  <a href="mailto:mahlberg@cpan.org">&lt;mahlberg@cpan.org&gt;</a> -- MAHLBERG<br />
4092. Markus Riester  <a href="mailto:mriester@gmx.de">&lt;mriester@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LIMAONE">LIMAONE</a><br />
4093. <a href="http://www.oaklett.org">Markus Siebeneicher</a>  <a href="mailto:siebeneicher@oaklett.org">&lt;siebeneicher@oaklett.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSIEB">MSIEB</a><br />

4094. Markus Spann  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SPANNMAN<br />
4095. Markus Vilhelm Seppälä  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NMMSEP<br />
4096. Markus W. Spring  <a href="mailto:markus.w.spring@gmx.net">&lt;markus.w.spring@gmx.net&gt;</a> -- MSPRING<br />
4097. <a href="http://www.fatalmind.com/">Markus Winand</a>  <a href="mailto:mws@cpan.org">&lt;mws@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWS">MWS</a><br />

4098. Marlon Bailey  <a href="mailto:mbailey@cpan.org">&lt;mbailey@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBAILEY">MBAILEY</a><br />
4099. <a href="http://www.revdev.at">Maroš Kollár</a>  <a href="mailto:maros@cpan.org">&lt;maros@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAROS">MAROS</a><br />
4100. Mart Sõmermaa  <a href="mailto:mrts@cpan.org">&lt;mrts@cpan.org&gt;</a> -- MRTS<br />

4101. Martial Rioux  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MRX<br />
4102. Martien Verbruggen  <a href="mailto:mverb@cpan.org">&lt;mverb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MV/MVERB">MVERB</a><br />
4103. Martijn Koster  <a href="mailto:mak@surfski.webcrawler.com">&lt;mak@surfski.webcrawler.com&gt;</a> -- MAK<br />
4104. Martijn van Beers  <a href="mailto:martijn@cpan.org">&lt;martijn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTIJN">MARTIJN</a><br />

4105. <a href="http://foodfight.org/">Martijn van de Streek</a>  <a href="mailto:martijn@foodfight.org">&lt;martijn@foodfight.org&gt;</a> -- MSTREEK<br />
4106. <a href="http://www.sandcrawler.com/SWB/cpan-modules.html">Martin 'Kingpin' Thurn</a>  <a href="mailto:mthurn@verizon.net">&lt;mthurn@verizon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MT/MTHURN">MTHURN</a><br />
4107. <a href="http://www.fabiani.net/">Martin 'Strat' Fabiani</a>  <a href="mailto:cpan@fabiani.net">&lt;cpan@fabiani.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRAT">STRAT</a><br />

4108. <a href="http://www.schmetterling.nu/perl/">Martin Ackermann</a>  <a href="mailto:ackermann@schmetterling.nu">&lt;ackermann@schmetterling.nu&gt;</a> -- ACKI<br />
4109. Martin Andrew Ellis  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARTINELL<br />
4110. <a href="http://martin.atkins.me.uk/">Martin Atkins</a>  <a href="mailto:mart@degeneration.co.uk">&lt;mart@degeneration.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MART">MART</a><br />

4111. Martin Bartlett  <a href="mailto:martin@nitram.demon.co.uk">&lt;martin@nitram.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTINB">MARTINB</a><br />
4112. <a href="http://www.cynops.de">Martin Bartosch</a>  <a href="mailto:mbartosch@cpan.org">&lt;mbartosch@cpan.org&gt;</a> -- MBARTOSCH<br />
4113. Martin Becker  <a href="mailto:becker-cpan@cozap.com">&lt;becker-cpan@cozap.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHASCH">MHASCH</a><br />

4114. Martin Berends  <a href="mailto:mberends@flashmail.com">&lt;mberends@flashmail.com&gt;</a> -- MBERENDS<br />
4115. Martin Bissegger  <a href="mailto:martin.bissegger@gmail.com">&lt;martin.bissegger@gmail.com&gt;</a> -- MABI<br />
4116. <a href="http://www.comnex.net">Martin Boeck</a>  <a href="mailto:martin.boeck@comnex.net">&lt;martin.boeck@comnex.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBOECK">MBOECK</a><br />

4117. Martin Brech  <a href="mailto:Martin.Brech@erl11.siemens.de">&lt;Martin.Brech@erl11.siemens.de&gt;</a> -- MBRECH<br />
4118. Martin Bright  <a href="mailto:martin@boojum.org.uk">&lt;martin@boojum.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJBRIGHT">MJBRIGHT</a><br />
4119. Martin Budden  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJBUDDEN">MJBUDDEN</a><br />

4120. <a href="http://www.martin.busik.de">Martin Bušík</a>  <a href="mailto:martin.busik@busik.de">&lt;martin.busik@busik.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBUSIK">MBUSIK</a><br />
4121. <a href="http://theqif.net/">Martin D. Robertson</a>  <a href="mailto:mansionhouseprojects@googlemail.com">&lt;mansionhouseprojects@googlemail.com&gt;</a> -- ZUQIF<br />
4122. <a href="http://martin.edenhofer.de/">Martin Edenhofer</a>  <a href="mailto:me+cpan@bogen.net">&lt;me+cpan@bogen.net&gt;</a> -- MARTINI<br />

4123. Martin Fowler  <a href="mailto:martin.fowler@gmail.com">&lt;martin.fowler@gmail.com&gt;</a> -- ACESAVER<br />
4124. Martin Frank  Hohmann-Marriott  <a href="mailto:martin.hohmann-marriott@asu.edu">&lt;martin.hohmann-marriott@asu.edu&gt;</a> -- MAUSER<br />
4125. Martin Grigorov  <a href="mailto:marting@cpan.org">&lt;marting@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTING">MARTING</a><br />
4126. <a href="http://martin.sluka.de/">Martin H. Sluka</a>  <a href="mailto:martin@sluka.de">&lt;martin@sluka.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FA/FANY">FANY</a><br />

4127. <a href="http://martinh.net/">Martin Hamilton</a>  <a href="mailto:m@martinh.net">&lt;m@martinh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHAMILTON">MHAMILTON</a><br />
4128. Martin Hosken  <a href="mailto:martin_hosken@sil.org">&lt;martin_hosken@sil.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHOSKEN">MHOSKEN</a><br />
4129. Martin J Evans  <a href="mailto:martin.evans@easysoft.com">&lt;martin.evans@easysoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJEVANS">MJEVANS</a><br />

4130. Martin Jackson  <a href="mailto:mhjacks@swbell.net">&lt;mhjacks@swbell.net&gt;</a> -- MHJACKS<br />
4131. Martin Kamara  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KAMARA<br />
4132. Martin Kammerhofer  <a href="mailto:mkamm@gmx.net">&lt;mkamm@gmx.net&gt;</a> -- MKAMM<br />
4133. <a href="http://mkweb.bcgsc.ca">Martin Krzywinski</a>  <a href="mailto:martink@bcgsc.ca">&lt;martink@bcgsc.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTINK">MARTINK</a><br />

4134. Martin Kutter  <a href="mailto:kutterma@users.sourceforge.net">&lt;kutterma@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKUTTER">MKUTTER</a><br />
4135. <a href="http://martin.scim.net/">Martin Langhoff</a>  <a href="mailto:martin@scim.net">&lt;martin@scim.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTIN">MARTIN</a><br />
4136. Martin Lee  <a href="mailto:mlee@messagelabs.com">&lt;mlee@messagelabs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGLEE">MGLEE</a><br />

4137. <a href="http://the.earth.li/~martin/">Martin Ling</a>  <a href="mailto:martin-cpan@earth.li">&lt;martin-cpan@earth.li&gt;</a> -- MLING<br />
4138. <a href="http://www.martin.lorensen.dk/">Martin Lorensen</a>  <a href="mailto:lorensen@cpan.org">&lt;lorensen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LORENSEN">LORENSEN</a><br />
4139. <a href="http://www.non-prophet.org">Martin McCarthy</a>  <a href="mailto:marty@non-prophet.org">&lt;marty@non-prophet.org&gt;</a> -- MARTY<br />

4140. Martin McGrath  <a href="mailto:mcgrath.martin@gmail.com">&lt;mcgrath.martin@gmail.com&gt;</a> -- MARTO<br />
4141. Martin Owens  <a href="mailto:doctormo@gmail.com">&lt;doctormo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOCTORMO">DOCTORMO</a><br />
4142. Martin Paczynski  <a href="mailto:Martin.Paczynski@tufts.edu">&lt;Martin.Paczynski@tufts.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NITRAM">NITRAM</a><br />

4143. Martin Peter  <a href="mailto:empi@post.cz">&lt;empi@post.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EM/EMPI">EMPI</a><br />
4144. <a href="http://www.mrjc.com/">Martin R.J. Cleaver</a>  <a href="mailto:Martin.Cleaver@BCS.org.uk">&lt;Martin.Cleaver@BCS.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRJC">MRJC</a><br />
4145. Martin Reimann  <a href="mailto:mr@erbits.com">&lt;mr@erbits.com&gt;</a> -- MREIMANN<br />

4146. <a href="grg.ath.cx">Martin Sarfy</a>  <a href="mailto:msarfy@seznam.cz">&lt;msarfy@seznam.cz&gt;</a> -- MSARFY<br />
4147. <a href="http://www.scharrer-online.de/">Martin Scharrer</a>  <a href="mailto:martin@scharrer-online.de">&lt;martin@scharrer-online.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHARRER">MSCHARRER</a><br />
4148. <a href="http://www.scsy.de/">Martin Schmitt</a>  <a href="mailto:mas@scsy.de">&lt;mas@scsy.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHMITT">MSCHMITT</a><br />

4149. <a href="http://www.schmuker.de/">Martin Schmuker</a>  <a href="mailto:martin@schmuker.de">&lt;martin@schmuker.de&gt;</a> -- SCHMUKER<br />
4150. <a href="http://wwwwbs.cs.tu-berlin.de/~schwartz/perl/">Martin Schwartz</a>  <a href="mailto:martin@nacho.de">&lt;martin@nacho.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHWARTZ">MSCHWARTZ</a><br />
4151. Martin Senger  <a href="mailto:tulsoft@cpan.org">&lt;tulsoft@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TU/TULSOFT">TULSOFT</a><br />

4152. Martin Skrowonneck  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MARSKO<br />
4153. <a href="www.evilninja.org">Martin Stenberg</a>  <a href="mailto:bumby at evilninja dot org">&lt;bumby at evilninja dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BU/BUMBY">BUMBY</a><br />
4154. Martin Tomes  <a href="mailto:cpan@tomes.org.uk">&lt;cpan@tomes.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTINTO">MARTINTO</a><br />

4155. Martin VanWinkle  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MAVANWIN<br />
4156. <a href="http://vms.pdv-systeme.de/users/martinv/">Martin Vorländer</a>  <a href="mailto:mvorl@cpan.org">&lt;mvorl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MV/MVORL">MVORL</a><br />
4157. <a href="http://www.dur.ac.uk/~dcs0mpw/">Martin Ward</a>  <a href="mailto:Martin.Ward@durham.ac.uk">&lt;Martin.Ward@durham.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWARD">MWARD</a><br />

4158. Martin Wilderoth  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARWIL">MARWIL</a><br />
4159. Martin von Oertzen  <a href="mailto:maletin@cpan.org">&lt;maletin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MALETIN">MALETIN</a><br />
4160. Martin-Louis Bright  <a href="mailto:mlbright@Gmail.com">&lt;mlbright@Gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTYLOO">MARTYLOO</a><br />

4161. Marty Brandon  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MBRANDON<br />
4162. <a href="http://beavercreekconsulting.com/">Marty Kube</a>  <a href="mailto:martykube@yahoo.com">&lt;martykube@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARTYKUBE">MARTYKUBE</a><br />
4163. <a href="http://face2interface.com/">Marty Landman</a>  <a href="mailto:mlandman@face2interface.com">&lt;mlandman@face2interface.com&gt;</a> -- MLANDMAN<br />

4164. <a href="http://face2interface.com">Marty Landman</a>  <a href="mailto:mlandman@face2interface.com">&lt;mlandman@face2interface.com&gt;</a> -- MARTIAN<br />
4165. <a href="http://www.mob-rule.com/counties/">Marty O'Brien</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MOB<br />
4166. <a href="http://martian.org/marty/">Marty Pauley</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KASEI">KASEI</a><br />

4167. Martyn J. Pearce  <a href="mailto:fluffy@cpan.org">&lt;fluffy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLUFFY">FLUFFY</a><br />
4168. <a href="http://www.mwpnet.com/">Martyn Peck</a>  <a href="mailto:mwp@mwpnet.com">&lt;mwp@mwpnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPECK">MPECK</a><br />
4169. <a href="http://dollyfish.net.nz">Martyn Smith</a>  <a href="mailto:msmith@cpan.org">&lt;msmith@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSMITH">MSMITH</a><br />

4170. <a href="http://www.rectangular.com/">Marvin Humphrey</a>  <a href="mailto:marvin@rectangular.com">&lt;marvin@rectangular.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CREAMYG">CREAMYG</a><br />
4171. <a href="http://www.kosho.org/">Masaaki NABESHIMA</a>  <a href="mailto:nabe*kosho.org (*-&gt;@)">&lt;nabe*kosho.org (*-&gt;@)&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NABESHIMA">NABESHIMA</a><br />

4172. Masafumi Yoshida  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HAOSAN<br />
4173. <a href="http://www.megabbs.com/~nihen/blog/">Masahiro Chiba</a>  <a href="mailto:nihen@megabbs.com">&lt;nihen@megabbs.com&gt;</a> -- CHIBA<br />
4174. Masahiro Funakoshi  <a href="mailto:masap@cpan.org">&lt;masap@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASAP">MASAP</a><br />

4175. Masahiro Funakoshi  <a href="mailto:mfunakoshi+cpan@gmail.com">&lt;mfunakoshi+cpan@gmail.com&gt;</a> -- MAIDO<br />
4176. <a href="http://blog.nomadscafe.jp/">Masahiro Nagano</a>  <a href="mailto:kazeburo@gmail.com">&lt;kazeburo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAZEBURO">KAZEBURO</a><br />
4177. Masahito Ikuta  <a href="mailto:cooldaemon+cpan@gmail.com">&lt;cooldaemon+cpan@gmail.com&gt;</a> -- IKUTA<br />

4178. <a href="http://blog.hansode.org/">Masahito Yoshida</a>  <a href="mailto:masahito@cpan.org">&lt;masahito@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASAHITO">MASAHITO</a><br />
4179. <a href="http://maaash.jp/">Masakazu Ohtsuka</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASH">MASH</a><br />
4180. Masanori Hara  <a href="mailto:massa.hara@gmail.com">&lt;massa.hara@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASANORIH">MASANORIH</a><br />

4181. <a href="http://www.masaokitamura.com">Masao Kitamura</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MASAO<br />
4182. <a href="http://d.hatena.ne.jp/masartz/">Masaru Hoshino</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MASARTZ<br />
4183. <a href="http://egg.bomcity.com/">Masatoshi Mizuno</a>  <a href="mailto:mizuno@bomcity.com">&lt;mizuno@bomcity.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUSHE">LUSHE</a><br />

4184. Masayoshi Sekimura  <a href="mailto:sekimura@gmail.com">&lt;sekimura@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEKIMURA">SEKIMURA</a><br />
4185. Masayuki Komori  <a href="mailto:scope@bb.din.or.jp">&lt;scope@bb.din.or.jp&gt;</a> -- DGSCOPE<br />
4186. Mason Loring Bliss  <a href="mailto:mason@blisses.org">&lt;mason@blisses.org&gt;</a> -- MASON<br />
4187. Masque  <a href="mailto:masque@cpan.org">&lt;masque@cpan.org&gt;</a> -- MASQUE<br />

4188. <a href="http://www.openca.org/openca">Massimiliano Pala</a>  <a href="mailto:madwolf@openca.org">&lt;madwolf@openca.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MADWOLF">MADWOLF</a><br />
4189. Mat Black  <a href="mailto:matblack@cpan.org">&lt;matblack@cpan.org&gt;</a> -- MATBLACK<br />
4190. <a href="http://www.black-fish.org/">Mat Sutcliffe</a>  <a href="mailto:o k t a l at g m x dot c o dot u k">&lt;o k t a l at g m x dot c o dot u k&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OK/OKTAL">OKTAL</a><br />

4191. Mateu X. Hunter  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MATEU<br />
4192. <a href="http://extarbot.net">Mathew Fenton</a>  <a href="mailto:matthewfenton@hotmail.co.uk">&lt;matthewfenton@hotmail.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFENTON">MFENTON</a><br />
4193. Mathew John Harrison  <a href="mailto:mharriso@rna.bio.mq.edu.au">&lt;mharriso@rna.bio.mq.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJHARR">MJHARR</a><br />

4194. <a href="members.optusnet.com.au/mathew">Mathew Robertson</a>  <a href="mailto:mathew@users.sf.net">&lt;mathew@users.sf.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATHEW">MATHEW</a><br />
4195. Mathias Herberts  <a href="mailto:PAUSE@iroise.net">&lt;PAUSE@iroise.net&gt;</a> -- HERBERTS<br />
4196. <a href="http://www.pfy.nu">Mathias Jansson</a>  <a href="mailto:matja@cpan.org">&lt;matja@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATJA">MATJA</a><br />

4197. Mathias Weidner  <a href="mailto:mathias@weidner.in-bad-schmiedeberg.de">&lt;mathias@weidner.in-bad-schmiedeberg.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAMAWE">MAMAWE</a><br />
4198. <a href="http://mat.cc/">Mathieu Arnold</a>  <a href="mailto:mat@cpan.org">&lt;mat@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAT">MAT</a><br />
4199. <a href="http://www.mathieu.gagnon.name/">Mathieu Gagnon</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GAGNONM">GAGNONM</a><br />

4200. <a href="http://www.eulerian.com">Mathieu Jondet</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJONDET">MJONDET</a><br />
4201. <a href="http://kisoku.net">Mathieu Sauve-Frankel</a>  <a href="mailto:msf@kisoku.net">&lt;msf@kisoku.net&gt;</a> -- MSF<br />
4202. <a href="http://blog.matiu.com.ar">Matias Alejo Garcia</a>  <a href="mailto:matiu@cpan.org">&lt;matiu@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATIU">MATIU</a><br />

4203. Matija Grabnar  <a href="mailto:matija+pause@serverflow.com">&lt;matija+pause@serverflow.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGRABNAR">MGRABNAR</a><br />
4204. <a href="http://www.matijs.net/">Matijs van Zuijlen</a>  <a href="mailto:matijs@matijs.net">&lt;matijs@matijs.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MV/MVZ">MVZ</a><br />
4205. <a href="http://www.eigenstate.net/">Matisse Enzer</a>  <a href="mailto:matisse@spamcop.net">&lt;matisse@spamcop.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATISSE">MATISSE</a><br />

4206. <a href="http://www.docs.uu.se/~matkin/">Mats Kindahl</a>  <a href="mailto:mats@kindahl.net">&lt;mats@kindahl.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATKIN">MATKIN</a><br />
4207. <a href="m-austin.net">Matt Auatin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MATT<br />
4208. Matt Beato  <a href="mailto:pause.spam@mattworld.net">&lt;pause.spam@mattworld.net&gt;</a> -- MBEATO<br />

4209. Matt Carter  <a href="mailto:m@ttcarter.com">&lt;m@ttcarter.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCARTER">MCARTER</a><br />
4210. <a href="http://eekeek.org">Matt Cashner</a>  <a href="mailto:eek+cpan@eekeek.org">&lt;eek+cpan@eekeek.org&gt;</a> -- MCASHNER<br />
4211. <a href="http://www.bodgit-n-scarper.com/">Matt Dainty</a>  <a href="mailto:matt@bodgit-n-scarper.com">&lt;matt@bodgit-n-scarper.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTD">MATTD</a><br />

4212. Matt DiMeo  <a href="mailto:mdimeo@cpan.org">&lt;mdimeo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDIMEO">MDIMEO</a><br />
4213. Matt Diephouse  <a href="mailto:matt@diephouse.com">&lt;matt@diephouse.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDIEP">MDIEP</a><br />
4214. <a href="http://identity.sourceforge.net/">Matt Ficken</a>  <a href="mailto:mattficken@users.sourceforge.net">&lt;mattficken@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLICK">SLICK</a><br />

4215. Matt Follett  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MFOLLETT<br />
4216. Matt Galisa  <a href="mailto:mrdelayer@gmail.com">&lt;mrdelayer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRDELAYER">MRDELAYER</a><br />
4217. Matt Harrington  <a href="mailto:japh@underdogma.net">&lt;japh@underdogma.net&gt;</a> -- NARSE<br />
4218. Matt Hempel  <a href="mailto:matt@aestus.net">&lt;matt@aestus.net&gt;</a> -- MHEMPEL<br />

4219. <a href="http://www.baldrickframework.org/">Matt Hucke</a>  <a href="mailto:hucke@cynico.net">&lt;hucke@cynico.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HU/HUCKE">HUCKE</a><br />
4220. Matt J. Avitable  <a href="mailto:Matthew DOT Avitable AT gmail DOT com">&lt;Matthew DOT Avitable AT gmail DOT com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJA">MJA</a><br />
4221. Matt Kennedy  <a href="mailto:matt@jumpline.com">&lt;matt@jumpline.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKENNEDY">MKENNEDY</a><br />

4222. Matt Knopp  <a href="mailto:mhat@netlag.com">&lt;mhat@netlag.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHAT">MHAT</a><br />
4223. Matt Koscica  <a href="mailto:matt.koscica@gmail.com">&lt;matt.koscica@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTK">MATTK</a><br />
4224. <a href="http://mkruse.netexpress.net/">Matt Kruse</a>  <a href="mailto:mkruse@netexpress.net">&lt;mkruse@netexpress.net&gt;</a> -- MKRUSE<br />

4225. Matt LeBlanc  <a href="mailto:">&lt;&gt;</a> -- MLEBLANC<br />
4226. <a href="http://mml.name/">Matt Liggett</a>  <a href="mailto:mml@pobox.com">&lt;mml@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MML">MML</a><br />
4227. <a href="http://www.mattlightner.com">Matt Lightner</a>  <a href="mailto:mlightner@site5.com">&lt;mlightner@site5.com&gt;</a> -- MLIGHTNER<br />

4228. <a href="http://www.rshtech.com/">Matt Luker</a>  <a href="mailto:perl.mail@redstarhackers.com">&lt;perl.mail@redstarhackers.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLUKER">MLUKER</a><br />
4229. <a href="http://www.mcgintech.com">Matt McGinnis</a>  <a href="mailto:matt_mc_ginnis@yahoo.com">&lt;matt_mc_ginnis@yahoo.com&gt;</a> -- MATTMCG<br />
4230. <a href="http://www.askmenoquestions.co.uk/">Matt Mitchell</a>  <a href="mailto:squidgeybidge@askmenoquestions.co.uk">&lt;squidgeybidge@askmenoquestions.co.uk&gt;</a> -- MJM<br />

4231. <a href="http://metalsponge.net/">Matt Mitchell</a>  <a href="mailto:matt@metalsponge.net">&lt;matt@metalsponge.net&gt;</a> -- MMITCHELL<br />
4232. <a href="http://www.trout.me.uk/">Matt S Trout</a>  <a href="mailto:perl-stuff@trout.me.uk">&lt;perl-stuff@trout.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSTROUT">MSTROUT</a><br />
4233. <a href="http://mzsanford.perlmonk.org">Matt Sanford</a>  <a href="mailto:mzsanford@cpan.org">&lt;mzsanford@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MZ/MZSANFORD">MZSANFORD</a><br />

4234. Matt Seddon  <a href="mailto:beware_the_beast_for_he_hosts@hotmail.com">&lt;beware_the_beast_for_he_hosts@hotmail.com&gt;</a> -- MATTS<br />
4235. Matt Sergeant  <a href="mailto:msergeant@cpan.org">&lt;msergeant@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSERGEANT">MSERGEANT</a><br />
4236. Matt Shaw  <a href="mailto:scarce@nbnet.nb.ca">&lt;scarce@nbnet.nb.ca&gt;</a> -- GRIPE<br />
4237. Matt Sickler  <a href="mailto:">&lt;&gt;</a> -- IMMUTE<br />

4238. <a href="http://www.tnpi.net/">Matt Simerson</a>  <a href="mailto:msimerson@cpan.org">&lt;msimerson@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSIMERSON">MSIMERSON</a><br />
4239. <a href="http://www.mojotoad.com/sisk/">Matt Sisk</a>  <a href="mailto:sisk@mojotoad.com">&lt;sisk@mojotoad.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSISK">MSISK</a><br />
4240. Matt Spear  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BATZ">BATZ</a><br />

4241. Matt Vella  <a href="mailto:the_mcv@yahoo.com">&lt;the_mcv@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCVELLA">MCVELLA</a><br />
4242. <a href="http://www.mattsscripts.co.uk/">Matt Wilson</a>  <a href="mailto:mattw@mattsscripts.co.uk">&lt;mattw@mattsscripts.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWILSON">MWILSON</a><br />
4243. <a href="http://www.ensembl.org">Matt Wood</a>  <a href="mailto:mjw@cpan.org">&lt;mjw@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJW">MJW</a><br />

4244. <a href="http://www.nothink.org">Matteo Cantoni</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCANTONI">MCANTONI</a><br />
4245. <a href="http://matteocorti.ch">Matteo Corti</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CORTI<br />
4246. Matthew Allum  <a href="mailto:breakfast@10.am">&lt;breakfast@10.am&gt;</a> -- MALLUM<br />

4247. <a href="http://www.t8o.org/~mca1001/">Matthew Astley</a>  <a href="mailto:mca1001@users.sourceforge.net">&lt;mca1001@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCAST">MCAST</a><br />
4248. Matthew Braid  <a href="mailto:moloko@uq.net.au">&lt;moloko@uq.net.au&gt;</a> -- MDBGRIZ<br />
4249. <a href="http://colondot.net/">Matthew Byng-Maddick</a>  <a href="mailto:mbm+cpan@colondot.net">&lt;mbm+cpan@colondot.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTBM">MATTBM</a><br />

4250. <a href="http://www.newtoncomputing.co.uk/">Matthew C. Newton</a>  <a href="mailto:perl03@takethisout.newtoncomputing.co.uk">&lt;perl03@takethisout.newtoncomputing.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCNEWTON">MCNEWTON</a><br />
4251. Matthew Crosby  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MCROSBY<br />
4252. <a href="http://www.mdarwin.ca">Matthew Darwin</a>  <a href="mailto:matthew@mdarwin.ca">&lt;matthew@mdarwin.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDARWIN">MDARWIN</a><br />

4253. <a href="http://boycie.net">Matthew Emes</a>  <a href="mailto:memes@cpan.org">&lt;memes@cpan.org&gt;</a> -- MEMES<br />
4254. <a href="http://matthewgream.net">Matthew Gream</a>  <a href="mailto:matthew.gream@pobox.com">&lt;matthew.gream@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGREAM">MGREAM</a><br />
4255. Matthew Green  <a href="mailto:mrg@mame.mu.oz.au">&lt;mrg@mame.mu.oz.au&gt;</a> -- MRG<br />

4256. Matthew Henroid  <a href="mailto:">&lt;&gt;</a> -- HENROID<br />
4257. <a href="http://www.arasphere.net">Matthew Hodgson</a>  <a href="mailto:matthew@arasphere.net">&lt;matthew@arasphere.net&gt;</a> -- MHODGSON<br />
4258. <a href="http://hiddenrealms.org">Matthew Horsfall</a>  <a href="mailto:WolfSage@cpan.org">&lt;WolfSage@cpan.org&gt;</a> -- WOLFSAGE<br />

4259. <a href="http://hattmoward.org">Matthew Howard</a>  <a href="mailto:zorrak@ductape.net">&lt;zorrak@ductape.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHOWARD">MHOWARD</a><br />
4260. <a href="http://www.mkosmo.net">Matthew J. Kosmoski</a>  <a href="mailto:kosmo@cpan.org">&lt;kosmo@cpan.org&gt;</a> -- KOSMO<br />
4261. <a href="http://www.simulia.com">Matthew J. Studley</a>  <a href="mailto:mjfs@cpan.org">&lt;mjfs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJFS">MJFS</a><br />

4262. <a href="http://luther.ca">Matthew Laird</a>  <a href="mailto:perl@luther.ca">&lt;perl@luther.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAIRDM">LAIRDM</a><br />
4263. Matthew Lange  <a href="mailto:mmlange@cpan.org">&lt;mmlange@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMLANGE">MMLANGE</a><br />
4264. Matthew Lawrence  <a href="mailto:matt.lawrence@virgin.net">&lt;matt.lawrence@virgin.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTLAW">MATTLAW</a><br />

4265. <a href="http://lewinski.org">Matthew Lewinski</a>  <a href="mailto:matthew@lewinski.org">&lt;matthew@lewinski.org&gt;</a> -- MLEWINSK<br />
4266. <a href="http://BlueT.org">Matthew Lien - 練喆明</a>  <a href="mailto:bluet@bluet.org">&lt;bluet@bluet.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLUET">BLUET</a><br />
4267. Matthew Lineen  <a href="mailto:matthew@lineen.com">&lt;matthew@lineen.com&gt;</a> -- MLINEEN<br />

4268. <a href="http://www.worldwidemart.com/scripts/">Matthew M. Wright</a>  <a href="mailto:mattw@worldwidemart.com">&lt;mattw@worldwidemart.com&gt;</a> -- MATTW<br />
4269. <a href="http://www.geek.ca">Matthew MacKenzie</a>  <a href="mailto:matt@geek.ca">&lt;matt@geek.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTMK">MATTMK</a><br />
4270. <a href="http://www.mallardcorp.com">Matthew Mallard</a>  <a href="mailto:perl@mallardcorp.com">&lt;perl@mallardcorp.com&gt;</a> -- MMALLARD<br />

4271. <a href="http://www.mcgillis.org">Matthew McGillis</a>  <a href="mailto:mmcgillis@cpan.org">&lt;mmcgillis@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMCGILLIS">MMCGILLIS</a><br />
4272. <a href="http://mattdm.org/">Matthew Miller</a>  <a href="mailto:mattdm@mattdm.org">&lt;mattdm@mattdm.org&gt;</a> -- MATTDM<br />
4273. <a href="http://morrow.jypsis.com">Matthew Morrow</a>  <a href="mailto:morrow@cpan.org">&lt;morrow@cpan.org&gt;</a> -- MORROW<br />

4274. <a href="http://mrmuskrat.perlmonk.org">Matthew Musgrove</a>  <a href="mailto:mmusgrove@cpan.org">&lt;mmusgrove@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMUSGROVE">MMUSGROVE</a><br />
4275. Matthew Nikols  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- IMATTJN<br />
4276. Matthew O'Connor  <a href="mailto:moconnor@cpan.org">&lt;moconnor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOCONNOR">MOCONNOR</a><br />

4277. Matthew O. Persico  <a href="mailto:persicom@cpan.org">&lt;persicom@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERSICOM">PERSICOM</a><br />
4278. <a href="http://www.gopitts.net">Matthew Pitts</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- INVINITY<br />
4279. Matthew Pocock  <a href="mailto:mrp@sanger.ac.uk">&lt;mrp@sanger.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPOCOCK">MPOCOCK</a><br />

4280. Matthew Pressly  <a href="mailto:mpressly@claborn.net">&lt;mpressly@claborn.net&gt;</a> -- MPRESSLY<br />
4281. <a href="http://lostsouls.org">Matthew R. Sheahan</a>  <a href="mailto:chaos@cpan.org">&lt;chaos@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHAOS">CHAOS</a><br />
4282. <a href="www.xndev.com">Matthew Robert Heusser</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MHEUSSER<br />

4283. Matthew Robinson  <a href="mailto:matt@zensunni.org">&lt;matt@zensunni.org&gt;</a> -- MROBINSON<br />
4284. <a href="http://www.zevils.com/">Matthew Sachs</a>  <a href="mailto:matthewg@zevils.com">&lt;matthewg@zevils.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTHEWG">MATTHEWG</a><br />
4285. Matthew Schick  <a href="mailto:schickm@gmail.com">&lt;schickm@gmail.com&gt;</a> -- SCHICKM<br />

4286. Matthew Shilbla  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MSHIBLA<br />
4287. <a href="http://www.crosswire.com">Matthew Sibley</a>  <a href="mailto:matt@crosswire.com">&lt;matt@crosswire.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CROSSWIRE">CROSSWIRE</a><br />
4288. <a href="http://www.evoscript.org">Matthew Simon Cavalletto</a>  <a href="mailto:simonm@cavalletto.org">&lt;simonm@cavalletto.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVO">EVO</a><br />

4289. <a href="http://www.mss.cx">Matthew Steven Smith</a>  <a href="mailto:cpan@mss.cx">&lt;cpan@mss.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMIFFY">SMIFFY</a><br />
4290. <a href="http://www.sorbs.net/">Matthew Sullivan (change cpan to cpanreal on the front of the email address)</a>  <a href="mailto:cpan@sorbs.net">&lt;cpan@sorbs.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SORBS">SORBS</a><br />
4291. Matthew Thomas  <a href="mailto:mathomas@jhu.edu">&lt;mathomas@jhu.edu&gt;</a> -- MATHOMAS<br />

4292. Matthew Walker  <a href="mailto:perl@walker.wattle.id.au">&lt;perl@walker.wattle.id.au&gt;</a> -- MWALKER<br />
4293. Matthew Wickline  <a href="mailto:m_pause@wickline.org">&lt;m_pause@wickline.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WICKLINE">WICKLINE</a><br />
4294. Matthew Wilson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WILSON<br />
4295. Matthias Bauer  <a href="mailto:matthiasb@acm.org">&lt;matthiasb@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BAUERM">BAUERM</a><br />

4296. Matthias Beebe  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBEEBE">MBEEBE</a><br />
4297. <a href="http://www.linguistik.uni-erlangen.de/~msbethke/">Matthias Bethke</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBETHKE">MBETHKE</a><br />
4298. Matthias Bloch  <a href="mailto:mbp@cpan.org">&lt;mbp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBP">MBP</a><br />

4299. <a href="http://www.rainboxx.de">Matthias Dietrich</a>  <a href="mailto:perl@rainboxx.de">&lt;perl@rainboxx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDIETRICH">MDIETRICH</a><br />
4300. <a href="http://www.imunixx.de">Matthias Eckardt</a>  <a href="mailto:matthias.eckardt@imunixx.de">&lt;matthias.eckardt@imunixx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EC/ECKARDT">ECKARDT</a><br />
4301. <a href="http://www.mafr.de">Matthias Friedrich</a>  <a href="mailto:matt@mafr.de">&lt;matt@mafr.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAFR">MAFR</a><br />

4302. Matthias Hilbig  <a href="mailto:necmas@gmx.de">&lt;necmas@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BI/BIGHIL">BIGHIL</a><br />
4303. Matthias Pitzl  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NEPOS<br />
4304. Matthias Pusch  <a href="mailto:mjp@nurfuerspam.de">&lt;mjp@nurfuerspam.de&gt;</a> -- MPUSCH<br />
4305. <a href="http://parasew.sonance.net">Matthias Tarasiewicz</a>  <a href="mailto:parasew@gmx.net">&lt;parasew@gmx.net&gt;</a> -- PARASEW<br />

4306. <a href="http://err.ethz.ch/~neeri">Matthias Ulrich Neeracher</a>  <a href="mailto:neeri@iis.ee.ethz.ch">&lt;neeri@iis.ee.ethz.ch&gt;</a> -- NEERI<br />
4307. Matthias Wienand  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTHIASW">MATTHIASW</a><br />
4308. Matthias Zeichmann  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MATTHIAS<br />

4309. <a href="http://mdamerose.free.fr">Matthieu Damerose</a>  <a href="mailto:klm4543FDSFDSQ@gmail.com">&lt;klm4543FDSFDSQ@gmail.com&gt;</a> -- DAMO<br />
4310. <a href="http://www.nubz.org/">Matthijs van Duin</a>  <a href="mailto:xmath-no-spam@nospam.cpan.org">&lt;xmath-no-spam@nospam.cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XM/XMATH">XMATH</a><br />
4311. <a href="http://www.barbon.org/web/">Mattia Barbon</a>  <a href="mailto:mbarbon@users.sourceforge.net">&lt;mbarbon@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBARBON">MBARBON</a><br />

4312. <a href="http://www.holmlund.se/mattias/">Mattias Holmlund</a>  <a href="mailto:u108@m1.holmlund.se">&lt;u108@m1.holmlund.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTIASH">MATTIASH</a><br />
4313. Maurice Aubrey  <a href="mailto:maurice@cpan.org">&lt;maurice@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAURICE">MAURICE</a><br />
4314. Maurice Makaay  <a href="mailto:maurice@gitaar.net">&lt;maurice@gitaar.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMAKAAY">MMAKAAY</a><br />

4315. <a href="www.eldorado.org.br">Mauro Ribeiro</a>  <a href="mailto:cmmi.consulting@gmail.com">&lt;cmmi.consulting@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THUNDERA">THUNDERA</a><br />
4316. <a href="http://smurfbane.org">Maverick</a>  <a href="mailto:maverick@smurfbane.org">&lt;maverick@smurfbane.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAVERICK">MAVERICK</a><br />
4317. <a href="http://www.mlb.com/">Max Afonov</a>  <a href="mailto:maxa@cpan.org">&lt;maxa@cpan.org&gt;</a> -- MAXA<br />

4318. <a href="http://www.warped.org/">Max Baker</a>  <a href="mailto:max -at- warped.org">&lt;max -at- warped.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXB">MAXB</a><br />
4319. Max Chang  <a href="mailto:endymion79@yahoo.com">&lt;endymion79@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCHANG">MCHANG</a><br />
4320. <a href="http://max.kanat.us/">Max Kanat-Alexander</a>  <a href="mailto:mkanat@cpan.org">&lt;mkanat@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKANAT">MKANAT</a><br />

4321. <a href="http://www.thing.net/">Max Kossatz</a>  <a href="mailto:kossatz@thing.at">&lt;kossatz@thing.at&gt;</a> -- MKOSSATZ<br />
4322. Max Maischein  <a href="mailto:corion@cpan.org">&lt;corion@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CORION">CORION</a><br />
4323. Max Muzi  <a href="mailto:maxim@comm2000.it">&lt;maxim@comm2000.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXM">MAXM</a><br />

4324. <a href="http://www.webwizarddesign.com/">Max Schubert</a>  <a href="mailto:maxschube@cpan.org">&lt;maxschube@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXSCHUBE">MAXSCHUBE</a><br />
4325. Max Zuber  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MAX<br />
4326. Maxim  Grigoriev  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPG">MPG</a><br />

4327. <a href="http://www.zmaximum.ru">Maxim Kashliak</a>  <a href="mailto:maxico@softhome.net">&lt;maxico@softhome.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAXICO">MAXICO</a><br />
4328. <a href="http://cloudconnected.org/~mxey/">Maximilian Gaß</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MXEY<br />
4329. Maximillian Jahn  <a href="mailto:jahn@netzmanufaktur.com">&lt;jahn@netzmanufaktur.com&gt;</a> -- MJAHN<br />

4330. <a href="http://www.geocities.com/mayur_prakash">Mayur Prakash Srivastava</a>  <a href="mailto:mayur_prakash@rediffmail.com">&lt;mayur_prakash@rediffmail.com&gt;</a> -- MAYUR<br />
4331. <a href="http://sourceforge.net/projects/mturksdk-perl/">Mechanical Turk</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MT/MTURK">MTURK</a><br />
4332. <a href="www.riunx.com/~meirm">Meir Michanie</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MEIRM<br />

4333. Mekles  <a href="mailto:mekles@centrum.cz">&lt;mekles@centrum.cz&gt;</a> -- JMH<br />
4334. <a href="http://www.cgiexpo.com/mniles/">Melissa Niles</a>  <a href="mailto:mniles@cgiexpo.com">&lt;mniles@cgiexpo.com&gt;</a> -- MNILES<br />
4335. Melvin Smith  <a href="mailto:melvin.smith@mindspring.com">&lt;melvin.smith@mindspring.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MELVIN">MELVIN</a><br />

4336. <a href="http://www.mengwong.com/software/perl/">Meng Weng Wong</a>  <a href="mailto:mengwong@pobox.com">&lt;mengwong@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FREESIDE">FREESIDE</a><br />
4337. <a href="http://menno.b10m.net/perl/">Menno Blom</a>  <a href="mailto:blom@cpan.org">&lt;blom@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BL/BLOM">BLOM</a><br />
4338. <a href="http://www.iloquent.com/src">Merijn Broeren</a>  <a href="mailto:merijnb@cpan.org">&lt;merijnb@cpan.org&gt;</a> -- MERIJNB<br />

4339. <a href="http://merlin.org/">Merlin Hughes</a>  <a href="mailto:merlin.cpan@merlin.org">&lt;merlin.cpan@merlin.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MERLIN">MERLIN</a><br />
4340. Merten Falk  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEVESENIN">NEVESENIN</a><br />
4341. <a href="http://www.nachbaur.com/">Michael A. Nachbaur</a>  <a href="mailto:mike@nachbaur.com">&lt;mike@nachbaur.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NACHBAUR">NACHBAUR</a><br />

4342. <a href="http://www.cafepress.com/perlgear">Michael Accardo</a>  <a href="mailto:mikeaccardo@yahoo.com">&lt;mikeaccardo@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACCARDO">ACCARDO</a><br />
4343. <a href="http://tendentious.org/">Michael Alan Dorman</a>  <a href="mailto:mdorman@debian.org">&lt;mdorman@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDORMAN">MDORMAN</a><br />
4344. Michael Anton Dines Zedeler  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MADZ">MADZ</a><br />

4345. Michael Aquilina  <a href="mailto:aquilina@cpan.org">&lt;aquilina@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AQ/AQUILINA">AQUILINA</a><br />
4346. Michael Attenborough  <a href="mailto:michaelattenborough_at_yahoo_dot_co_dot_uk@say.it">&lt;michaelattenborough_at_yahoo_dot_co_dot_uk@say.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MY/MYKL">MYKL</a><br />
4347. Michael Axiak  <a href="mailto:mike@axiak.net">&lt;mike@axiak.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AX/AXIAK">AXIAK</a><br />

4348. <a href="http://www.mbstevens.com">Michael B Stevens</a>  <a href="mailto:webmaster@mbstevens.com">&lt;webmaster@mbstevens.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBSTE">MBSTE</a><br />
4349. <a href="http://www.cipherdyne.org/">Michael B. Rash</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRASH">MRASH</a><br />
4350. Michael Bekaert  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CERATITES">CERATITES</a><br />

4351. <a href="http://www.rattler.kiev.ua/">Michael Bochkaryov</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RATTLER<br />
4352. <a href="http://www.monkeywalk.com/mhb">Michael Burkhardt</a>  <a href="mailto:mhb@monkeywalk.com">&lt;mhb@monkeywalk.com&gt;</a> -- MIHOBU<br />
4353. <a href="http://www.mirwin.net/">Michael Burns</a>  <a href="mailto:maburns@gmail.com">&lt;maburns@gmail.com&gt;</a> -- MBURNS<br />

4354. Michael Böker  <a href="mailto:mmbk@cpan.org">&lt;mmbk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMBK">MMBK</a><br />
4355. <a href="http://michael.toren.net/">Michael C. Toren</a>  <a href="mailto:mct@toren.net">&lt;mct@toren.net&gt;</a> -- MCT<br />
4356. <a href="http://michaelpc.com">Michael CH Vu</a>  <a href="mailto:mvu8912@yahoo.com.tw">&lt;mvu8912@yahoo.com.tw&gt;</a> -- MICVU<br />

4357. Michael Cameron Wehner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MCWEHNER<br />
4358. Michael Carman  <a href="mailto:mjcarman@home.com">&lt;mjcarman@home.com&gt;</a> -- CARMAN<br />
4359. Michael Carman  <a href="mailto:mjcarman@mchsi.com">&lt;mjcarman@mchsi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJCARMAN">MJCARMAN</a><br />
4360. Michael Chamberlain  <a href="mailto:mac@prather.org">&lt;mac@prather.org&gt;</a> -- MAC<br />

4361. Michael Chapman  <a href="mailto:cpan@very.puzzling.org">&lt;cpan@very.puzzling.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCHAPMAN">MCHAPMAN</a><br />
4362. <a href="http://mkching.homeip.net/">Michael Ching</a>  <a href="mailto:mching@cpan.org">&lt;mching@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCHING">MCHING</a><br />
4363. <a href="www.ivorycity.com">Michael Collins</a>  <a href="mailto:michaelcollins@ivorycity.com">&lt;michaelcollins@ivorycity.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COLLINS">COLLINS</a><br />

4364. <a href="http://www.copito.org/perl">Michael Cope</a>  <a href="mailto:cope@cpan.org">&lt;cope@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/COPE">COPE</a><br />
4365. <a href="http://www.webkist.com/">Michael Cramer</a>  <a href="mailto:cramer@webkist.com">&lt;cramer@webkist.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAMER">CRAMER</a><br />
4366. Michael Curtis  <a href="mailto:mike@beatbot.com">&lt;mike@beatbot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCURTIS">MCURTIS</a><br />

4367. <a href="http://www.cnet.com/">Michael D. Dowling</a>  <a href="mailto:michaeld@cnet.com">&lt;michaeld@cnet.com&gt;</a> -- MICHAELD<br />
4368. Michael D. Ivey  <a href="mailto:mdi@iveyandbrown.com">&lt;mdi@iveyandbrown.com&gt;</a> -- IVEY<br />
4369. Michael D. Richards  <a href="mailto:mrichards@cpan.org">&lt;mrichards@cpan.org&gt;</a> -- MRICHARDS<br />

4370. <a href="http://www.scotclimb.org.uk/biography.shtml">Michael De La Rue</a>  <a href="mailto:TRY VIA HOMEPAGE">&lt;TRY VIA HOMEPAGE&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEDLR">MIKEDLR</a><br />
4371. <a href="http://www.quarghost.com/">Michael De Soto</a>  <a href="mailto:desoto@cpan.org">&lt;desoto@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DESOTO">DESOTO</a><br />
4372. <a href="http://www.undef.de/">Michael Diekmann</a>  <a href="mailto:midi@cpan.org">&lt;midi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIDI">MIDI</a><br />

4373. <a href="http://edmonson.paunix.org">Michael Edmonson</a>  <a href="mailto:mnedmonson@gmail.com">&lt;mnedmonson@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ED/EDMONSON">EDMONSON</a><br />
4374. <a href="http://www.cs.washington.edu/homes/mernst/">Michael Ernst</a>  <a href="mailto:mernst@cs.washington.edu">&lt;mernst@cs.washington.edu&gt;</a> -- MERNST<br />
4375. <a href="http://www.tecspy.com/">Michael Erskine</a>  <a href="mailto:msemtd@yahoo.co.uk">&lt;msemtd@yahoo.co.uk&gt;</a> -- MSERSKINE<br />

4376. Michael Firestone  <a href="mailto:mikfire@gmail.com">&lt;mikfire@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKFIRE">MIKFIRE</a><br />
4377. <a href="http://www.Michael-Forman.com">Michael Forman マイケル フォマン</a>  <a href="mailto:Michael.Forman@Colorado.EDU">&lt;Michael.Forman@Colorado.EDU&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FORMAN">FORMAN</a><br />
4378. Michael Fowler  <a href="mailto:michael@shoebox.net">&lt;michael@shoebox.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFOWLER">MFOWLER</a><br />

4379. Michael Frankl  <a href="mailto:mfrankl@seibert-media.net">&lt;mfrankl@seibert-media.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MF/MFRANKL">MFRANKL</a><br />
4380. <a href="http://www.math.yorku.ca/SCS/friendly.html">Michael Friendly</a>  <a href="mailto:friendly@yorku.ca">&lt;friendly@yorku.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLF">MLF</a><br />
4381. <a href="http://fross.org/">Michael Fross</a>  <a href="mailto:michael@fross.org">&lt;michael@fross.org&gt;</a> -- FROSTY<br />

4382. <a href="http://www.fuhr.org/~mfuhr/">Michael Fuhr</a>  <a href="mailto:mike@fuhr.org">&lt;mike@fuhr.org&gt;</a> -- MFUHR<br />
4383. <a href="http://www.pobox.com/~schwern">Michael G Schwern</a>  <a href="mailto:mschwern@cpan.org">&lt;mschwern@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHWERN">MSCHWERN</a><br />
4384. <a href="http://www.eecs.tufts.edu/~mgilfix/">Michael Gilfix</a>  <a href="mailto:mgilfix@eecs.tufts.edu">&lt;mgilfix@eecs.tufts.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGILFIX">MGILFIX</a><br />

4385. <a href="http://www.occamstoothbrush.com/perl/">Michael Graham</a>  <a href="mailto:mag-perl@occamstoothbrush.com">&lt;mag-perl@occamstoothbrush.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGRAHAM">MGRAHAM</a><br />
4386. <a href="http://www.devEiate.org/">Michael Granger</a>  <a href="mailto:ged-cpan@faeriemud.org">&lt;ged-cpan@faeriemud.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GE/GED">GED</a><br />
4387. <a href="http://www.eng.cam.ac.uk/~mjg17/">Michael Gray</a>  <a href="mailto:mjg17@cam.ac.uk">&lt;mjg17@cam.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJG">MJG</a><br />

4388. <a href="http://michael.thegrebs.com">Michael Greb</a>  <a href="mailto:michael@thegrebs.com">&lt;michael@thegrebs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEGRB">MIKEGRB</a><br />
4389. <a href="http://mike.mg2.org">Michael Gregorowicz</a>  <a href="mailto:mike@mg2.org">&lt;mike@mg2.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGREGORO">MGREGORO</a><br />
4390. <a href="http://www.dailyvoid.com/">Michael Grubb</a>  <a href="mailto:mgrubb@cpan.org">&lt;mgrubb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGRUBB">MGRUBB</a><br />

4391. <a href="http://m.hallgren.free.fr/">Michael Hallgren</a>  <a href="mailto:m.hallgren@free.fr">&lt;m.hallgren@free.fr&gt;</a> -- MHALLGREN<br />
4392. Michael Heckman  <a href="mailto:cpan@heckman.net">&lt;cpan@heckman.net&gt;</a> -- MHECKMAN<br />
4393. <a href="http://www.ndrix.com">Michael Hendricks</a>  <a href="mailto:michael@ndrix.org">&lt;michael@ndrix.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MN/MNDRIX">MNDRIX</a><br />

4394. Michael Henson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MHENSON<br />
4395. Michael Hollifield  <a href="mailto:mehollifield@magnalinea.com">&lt;mehollifield@magnalinea.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLLIFM">HOLLIFM</a><br />
4396. Michael Hooreman  <a href="mailto:michael AT hooreman.be">&lt;michael AT hooreman.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHOOREMAN">MHOOREMAN</a><br />

4397. <a href="http://www.radix.net/~herveus/">Michael Houghton</a>  <a href="mailto:herveus@radix.net">&lt;herveus@radix.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HERVEUS">HERVEUS</a><br />
4398. <a href="http://www.geocities.com/m_howell123">Michael Howell</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIDDLE">RIDDLE</a><br />
4399. Michael Hoy  <a href="mailto:hoymich@cpan.org">&lt;hoymich@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOYMICH">HOYMICH</a><br />

4400. Michael Hoyt  <a href="mailto:mphoyt@comcast.net">&lt;mphoyt@comcast.net&gt;</a> -- MHOYT<br />
4401. Michael J. Flickinger  <a href="mailto:mjflick@cpan.org">&lt;mjflick@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJFLICK">MJFLICK</a><br />
4402. <a href="http://www.onperl.org/">Michael J. Mathews</a>  <a href="mailto:mmathews@cpan.org">&lt;mmathews@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMATHEWS">MMATHEWS</a><br />

4403. <a href="http://pilcrow.madison.wi.us">Michael J. Pomraning</a>  <a href="mailto:mjp-cpan@pilcrow.madison.wi.us">&lt;mjp-cpan@pilcrow.madison.wi.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJP">MJP</a><br />
4404. <a href="http://j-e-b.net">Michael Jacob</a>  <a href="mailto:jacob@j-e-b.net">&lt;jacob@j-e-b.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JACOB">JACOB</a><br />
4405. Michael K. Neylon  <a href="mailto:mneylon-cpan@masemware.com">&lt;mneylon-cpan@masemware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MN/MNEYLON">MNEYLON</a><br />

4406. Michael Kaelbling  <a href="mailto:mjkaelbling2001@yahoo.com">&lt;mjkaelbling2001@yahoo.com&gt;</a> -- KLBLNGMJ<br />
4407. <a href="http://www.katmonkey.com/">Michael Katkin</a>  <a href="mailto:mkatmonkey@yahoo.com">&lt;mkatmonkey@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KATMONKEY">KATMONKEY</a><br />
4408. <a href="http://www.archlug.org/kwiki/Mike">Michael King</a>  <a href="mailto:mike808@users.sourceforge.net">&lt;mike808@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEKING">MIKEKING</a><br />

4409. <a href="http://www.copyleft.de/">Michael Koehne</a>  <a href="mailto:kraehe@copyleft.de">&lt;kraehe@copyleft.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KR/KRAEHE">KRAEHE</a><br />
4410. Michael Kospach  <a href="mailto:mike.perl@gmx.at">&lt;mike.perl@gmx.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEK">MIKEK</a><br />
4411. Michael Krause  <a href="mailto:KrauseM@gmx.net">&lt;KrauseM@gmx.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKRA">MIKRA</a><br />

4412. Michael Kroh  <a href="mailto:mikekroh@gmail.com">&lt;mikekroh@gmail.com&gt;</a> -- KROH<br />
4413. <a href="http://pepl.info/">Michael Kröll</a>  <a href="mailto:pepl@cpan.org">&lt;pepl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEPL">PEPL</a><br />
4414. Michael Kulakov  <a href="mailto:mkul@zenon.net">&lt;mkul@zenon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MK/MKUL">MKUL</a><br />

4415. Michael Langner  <a href="mailto:">&lt;&gt;</a> -- MILA<br />
4416. <a href="http://legart.dk/">Michael Legart</a>  <a href="mailto:michael@legart.dk">&lt;michael@legart.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEGART">LEGART</a><br />
4417. Michael Lum  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUM">LUM</a><br />

4418. Michael M-O  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MIKEWHOO<br />
4419. <a href="http://copland.udel.edu/~maraist">Michael Maraist</a>  <a href="mailto:maraist@hotmail.com">&lt;maraist@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARAIST">MARAIST</a><br />
4420. Michael Mattie  <a href="mailto:codermattie@gmail.com">&lt;codermattie@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MATTIE">MATTIE</a><br />

4421. <a href="http://www.invlogic.com">Michael McLagan</a>  <a href="mailto:mmclagan@invlogic.com">&lt;mmclagan@invlogic.com&gt;</a> -- MMCLAGAN<br />
4422. <a href="http://www.pied.com/">Michael Neil Felzien</a>  <a href="mailto:cgi-tax@pied.com">&lt;cgi-tax@pied.com&gt;</a> -- PIED<br />
4423. <a href="http://digitaltorque.ca">Michael P. Soulier</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSOULIER">MSOULIER</a><br />

4424. <a href="http://www.discomsys.com/~mps">Michael P. Sullivan</a>  <a href="mailto:mps@discomsys.com">&lt;mps@discomsys.com&gt;</a> -- MSULLIVAN<br />
4425. Michael Parker  <a href="mailto:parkerm@pobox.com">&lt;parkerm@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PARKER">PARKER</a><br />
4426. <a href="http://www.peppler.org">Michael Peppler</a>  <a href="mailto:mpeppler@peppler.org">&lt;mpeppler@peppler.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEWP">MEWP</a><br />

4427. Michael Peters  <a href="mailto:wonko@cpan.org">&lt;wonko@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WO/WONKO">WONKO</a><br />
4428. <a href="http://www.dynalabs.de/mxp/">Michael Piotrowski</a>  <a href="mailto:mxp@dynalabs.de">&lt;mxp@dynalabs.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPIOTR">MPIOTR</a><br />
4429. Michael Plugge  <a href="mailto:m.plugge@hs-mannheim.de">&lt;m.plugge@hs-mannheim.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MICHEL">MICHEL</a><br />

4430. Michael Potter  <a href="mailto:megamic@cpan.org">&lt;megamic@cpan.org&gt;</a> -- MEGAMIC<br />
4431. Michael R, Smith  <a href="mailto:michael.smith24@comcast.com">&lt;michael.smith24@comcast.com&gt;</a> -- WARREN<br />
4432. <a href="dtn://davisnetworks.com/">Michael R. Davis</a>  <a href="mailto:account=&gt;perl,tld=&gt;com,domain=&gt;michaelrdavis">&lt;account=&gt;perl,tld=&gt;com,domain=&gt;michaelrdavis&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRDVT">MRDVT</a><br />

4433. Michael R. Wolf  <a href="mailto:MichaelRWolf@att.net">&lt;MichaelRWolf@att.net&gt;</a> -- MRWOLF<br />
4434. <a href="http://www.riceclan.org/~michael/perl/">Michael Rice</a>  <a href="mailto:michael@riceclan.org">&lt;michael@riceclan.org&gt;</a> -- MRICE<br />
4435. <a href="http://michaelrice.org">Michael Rice</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ERRR<br />

4436. <a href="http://www.golfinohio.com">Michael Ridinger</a>  <a href="mailto:info@golfinohio.com">&lt;info@golfinohio.com&gt;</a> -- RIDINGER<br />
4437. <a href="http://www.vivtek.com/wftk.html">Michael Roberts</a>  <a href="mailto:wftk@vivtek.com">&lt;wftk@vivtek.com&gt;</a> -- MICHAEL<br />
4438. <a href="http://www.spamcannibal.org/">Michael Robinton</a>  <a href="mailto:michael@bizsystems.com">&lt;michael@bizsystems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKER">MIKER</a><br />

4439. <a href="http://lacklustre.net/">Michael Ryan</a>  <a href="mailto:michael-cpan@lacklustre.net">&lt;michael-cpan@lacklustre.net&gt;</a> -- MJR<br />
4440. Michael Ryan Stephens  <a href="mailto:mrstephens11@aol.com">&lt;mrstephens11@aol.com&gt;</a> -- SACIK<br />
4441. Michael S. Tsirkin  <a href="mailto:pausepublic at misha dot eml dot cc">&lt;pausepublic at misha dot eml dot cc&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MISHA">MISHA</a><br />

4442. <a href="http://www.brainbench.com/transcript.jsp?pid=9867">Michael Samanov</a>  <a href="mailto:mike@vlink.ru">&lt;mike@vlink.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNCLE">UNCLE</a><br />
4443. Michael Scherer  <a href="mailto:misc@zarb.org">&lt;misc@zarb.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MISC">MISC</a><br />
4444. <a href="http://perlmeister.com">Michael Schilli</a>  <a href="mailto:m@perlmeister.com">&lt;m@perlmeister.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHILLI">MSCHILLI</a><br />

4445. Michael Schlüter  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHLUE">MSCHLUE</a><br />
4446. Michael Schout  <a href="mailto:mschout@gkg.net">&lt;mschout@gkg.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCHOUT">MSCHOUT</a><br />
4447. Michael Schröder  <a href="mailto:mls@suse.de">&lt;mls@suse.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ML/MLS">MLS</a><br />

4448. <a href="http://myke.trecento.com">Michael Scott Cuthbert</a>  <a href="mailto:cuthbert@nber.org">&lt;cuthbert@nber.org&gt;</a> -- CUTHBERT<br />
4449. Michael Shields  <a href="mailto:shields@crosslink.net">&lt;shields@crosslink.net&gt;</a> -- MSHLD<br />
4450. <a href="http://wicket.no-ip.com">Michael Shipper</a>  <a href="mailto:mshipper@yahoo.com">&lt;mshipper@yahoo.com&gt;</a> -- AKALINUX<br />

4451. Michael Smith  <a href="mailto:mjs@iii.co.uk">&lt;mjs@iii.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJS">MJS</a><br />
4452. <a href="http://snoyman.com">Michael Snoyman</a>  <a href="mailto:michael.snoyman@ucla.edu">&lt;michael.snoyman@ucla.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNOYBERG">SNOYBERG</a><br />
4453. Michael Sokolov  <a href="mailto:sokolov at ifactory daht com">&lt;sokolov at ifactory daht com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOKOLOV">SOKOLOV</a><br />

4454. Michael Sorens  <a href="mailto:msorens@softhome.net">&lt;msorens@softhome.net&gt;</a> -- MSORENS<br />
4455. <a href="michael-sprick.de">Michael Sprick</a>  <a href="mailto:msprick@gmx.de">&lt;msprick@gmx.de&gt;</a> -- MSPRICK<br />
4456. <a href="http://www.gnurds.org/">Michael Stemle</a>  <a href="mailto:mikes@gnurds.org">&lt;mikes@gnurds.org&gt;</a> -- GNURD<br />

4457. <a href="http://smart-home-blog.com">Michael Stepanov</a>  <a href="mailto:stepanov.michael@gmail.com">&lt;stepanov.michael@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEPANOV">STEPANOV</a><br />
4458. Michael Stevens  <a href="mailto:mstevens@etla.org">&lt;mstevens@etla.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSTEVENS">MSTEVENS</a><br />
4459. <a href="http://beebo.org/">Michael Stillwell</a>  <a href="mailto:mjs@beebo.org">&lt;mjs@beebo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STILLWELL">STILLWELL</a><br />

4460. <a href="http://www.syndor.com/">Michael Stump</a>  <a href="mailto:alfalpha@syndor.com">&lt;alfalpha@syndor.com&gt;</a> -- ALFALPHA<br />
4461. Michael Sullivan  <a href="mailto:perldude@mac.com">&lt;perldude@mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SULLIVAN">SULLIVAN</a><br />
4462. Michael Swearingen  <a href="mailto:stypnow@cpan.org">&lt;stypnow@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STYPNOW">STYPNOW</a><br />

4463. Michael Tomuschat  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOMUSCHAT">TOMUSCHAT</a><br />
4464. Michael Trowbridge  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MT/MTROWBRI">MTROWBRI</a><br />
4465. Michael W Barnhart  <a href="mailto:mbarn@cidr.jhmi.edu">&lt;mbarn@cidr.jhmi.edu&gt;</a> -- MWB<br />

4466. Michael W. Bombardieri  <a href="mailto:bombardierix@gmail.com">&lt;bombardierix@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOMB">BOMB</a><br />
4467. <a href="http://www.phys.jyu.fi/homepages/walter/Physik">Michael Walter</a>  <a href="mailto:Michael.Walter@phys.jyu.fi">&lt;Michael.Walter@phys.jyu.fi&gt;</a> -- MIWALTER<br />
4468. Michael Wardman  <a href="mailto:wardy@cpan.org">&lt;wardy@cpan.org&gt;</a> -- WARDY<br />

4469. Michael Warwick  <a href="mailto:">&lt;&gt;</a> -- MWARWICK<br />
4470. Michael Witthaut  <a href="mailto:kikkertuin@gmx.de">&lt;kikkertuin@gmx.de&gt;</a> -- WITTHAUT<br />
4471. Michael Wojcikiewicz  <a href="mailto:theothermike@gmail.com">&lt;theothermike@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MICHAELW">MICHAELW</a><br />
4472. Michael Young  <a href="mailto:mhyoung@ucsd.edu">&lt;mhyoung@ucsd.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHYOUNG">MHYOUNG</a><br />

4473. Michael Zehrer  <a href="mailto:zehrer@zepan.org">&lt;zehrer@zepan.org&gt;</a> -- MZEHRER<br />
4474. Michal Cumpl  <a href="mailto:micu@cpan.org">&lt;micu@cpan.org&gt;</a> -- MICU<br />
4475. Michal Jaegermann  <a href="mailto:michal@ellpspace.math.ualberta.ca">&lt;michal@ellpspace.math.ualberta.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJAEG">MJAEG</a><br />
4476. Michal Ratajsky  <a href="mailto:incoming@tiscali.cz">&lt;incoming@tiscali.cz&gt;</a> -- MRATA<br />

4477. <a href="http://www.sabren.net/">Michal Wallace</a>  <a href="mailto:sabren@manifestation.com">&lt;sabren@manifestation.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SABREN">SABREN</a><br />
4478. <a href="http://odyniec.net/">Michał Wojciechowski</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ODYNIEC<br />
4479. <a href="http://pagesperso.erasme.org/michel">Michel Blanc</a>  <a href="mailto:mb@erasme.org">&lt;mb@erasme.org&gt;</a> -- LEUCOS<br />

4480. <a href="www.kosys-cottbus.de">Michel Bretschneider</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EMBIX<br />
4481. <a href="http://www.xmltwig.com">Michel Rodriguez</a>  <a href="mailto:xmltwig@gmail.com">&lt;xmltwig@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIROD">MIROD</a><br />
4482. <a href="http://www.cattlegrid.info/">Michele Beltrame</a>  <a href="mailto:arthas@cpan.org">&lt;arthas@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARTHAS">ARTHAS</a><br />

4483. Michele Dell'Aquila  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MIDELLAQ<br />
4484. Michele Ongaro  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MICHELEO<br />
4485. Michelle Agnew  <a href="mailto:cpan@michelleagnew.com">&lt;cpan@michelleagnew.com&gt;</a> -- MAGNEW<br />
4486. Michiel Ootjers  <a href="mailto:michiel@cpan.org">&lt;michiel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MICHIEL">MICHIEL</a><br />

4487. Michiel de Boer  <a href="mailto:locsmif@cpan.org">&lt;locsmif@cpan.org&gt;</a> -- LOCSMIF<br />
4488. Michiya Honda  <a href="mailto:pia@cpan.org">&lt;pia@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIA">PIA</a><br />
4489. <a href="http://members.home.com/mickv">Mick Villeneuve</a>  <a href="mailto:mickv@home.com">&lt;mickv@home.com&gt;</a> -- MRMICK<br />

4490. <a href="http://expert.cc.purdue.edu/~midh">Midh Mulpuri</a>  <a href="mailto:midh@excite.com">&lt;midh@excite.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIDH">MIDH</a><br />
4491. Miguel A. Rivera  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARR">MARR</a><br />
4492. Miguel Angelo Lapa Duarte  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MALDUARTE<br />

4493. Miguel Pignatelli  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOTIF">MOTIF</a><br />
4494. Miguel R. Corazao  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MCORAZAO<br />
4495. <a href="http://www.simplicidade.com">Miguel Santinho</a>  <a href="mailto:cpan@simplicidade.com">&lt;cpan@simplicidade.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSANTINHO">MSANTINHO</a><br />

4496. <a href="http://www.dynarch.com/">Mihai Bazon</a>  <a href="mailto:mihai.bazon@gmail.com">&lt;mihai.bazon@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MISHOO">MISHOO</a><br />
4497. <a href="http://denixtech.net/">Mihai Secasiu</a>  <a href="mailto:symx@cpan.org">&lt;symx@cpan.org&gt;</a> -- SYMX<br />
4498. Mike Arms  <a href="mailto:marms@sandia.gov">&lt;marms@sandia.gov&gt;</a> -- MARMS<br />

4499. <a href="http://mikebaas.org">Mike Baas</a>  <a href="mailto:mike@mikebaas.org">&lt;mike@mikebaas.org&gt;</a> -- MBAAS<br />
4500. Mike Blackwell  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEB">MIKEB</a><br />
4501. Mike Blazer  <a href="mailto:blazer@peterlink.ru">&lt;blazer@peterlink.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MB/MBLAZ">MBLAZ</a><br />

4502. Mike Canann  <a href="mailto:mike_canann@yahoo.com">&lt;mike_canann@yahoo.com&gt;</a> -- MCANANN<br />
4503. <a href="http://www.hostingservices.net/mikec">Mike Carpenter</a>  <a href="mailto:mikec@internet-software.com">&lt;mikec@internet-software.com&gt;</a> -- MIKEC<br />
4504. <a href="http://pachogrande.com/">Mike Carr</a>  <a href="mailto:mcarr@pachogrande.com">&lt;mcarr@pachogrande.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCARR">MCARR</a><br />

4505. <a href="http://mlcastle.net/">Mike Castleman</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MLCASTLE<br />
4506. Mike Eldridge  <a href="mailto:diz@cpan.org">&lt;diz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIZ">DIZ</a><br />
4507. <a href="http://phydeaux.org/">Mike Fletcher</a>  <a href="mailto:fletch+cpan@phydeaux.org">&lt;fletch+cpan@phydeaux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLETCH">FLETCH</a><br />

4508. Mike Fragassi  <a href="mailto:frag@ripco.com">&lt;frag@ripco.com&gt;</a> -- FRAG<br />
4509. <a href="http://www.friedo.com/">Mike Friedman</a>  <a href="mailto:friedo@friedo.com">&lt;friedo@friedo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRIEDO">FRIEDO</a><br />
4510. <a href="http://www.straphanger.org/~mgammon">Mike Gammon</a>  <a href="mailto:mgammon@interport.net">&lt;mgammon@interport.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MG/MGAMMON">MGAMMON</a><br />

4511. <a href="http://mike.genso-it.com/">Mike Gendreyzig</a>  <a href="mailto:migen@cpan.org">&lt;migen@cpan.org&gt;</a> -- MIGEN<br />
4512. <a href="http://www.easyperl.com/">Mike Giles</a>  <a href="mailto:modules@easyperl.com">&lt;modules@easyperl.com&gt;</a> -- MIKEG<br />
4513. <a href="http://rmgiroux.com">Mike Giroux</a>  <a href="mailto:rmgiroux@gmail.com">&lt;rmgiroux@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMGIROUX">RMGIROUX</a><br />

4514. Mike Glover  <a href="mailto:glover@credit.erin.utoronto.ca">&lt;glover@credit.erin.utoronto.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLOVER">GLOVER</a><br />
4515. <a href="http://www.u.arizona.edu/~hammond/">Mike Hammond</a>  <a href="mailto:hammond@u.arizona.edu">&lt;hammond@u.arizona.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAMMOND">HAMMOND</a><br />
4516. Mike Hawkins  <a href="mailto:mike.hawkins@awe.co.uk">&lt;mike.hawkins@awe.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HAWKINSM">HAWKINSM</a><br />

4517. <a href="http://www.perusion.com/">Mike Heins</a>  <a href="mailto:mikeh@perusion.net">&lt;mikeh@perusion.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEH">MIKEH</a><br />
4518. Mike Hoolehan  <a href="mailto:mike@sycamore.us">&lt;mike@sycamore.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHOOLEHAN">MHOOLEHAN</a><br />
4519. Mike Jackson  <a href="mailto:jacksonm@cpan.org">&lt;jacksonm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JACKSONM">JACKSONM</a><br />

4520. <a href="http://www.mikesroom.org">Mike Jewell</a>  <a href="mailto:moj@ecs.soton.ac.uk">&lt;moj@ecs.soton.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MJ/MJEWELL">MJEWELL</a><br />
4521. <a href="http://www.mc.manchester.ac.uk/about/people/mike.jones">Mike Jones</a>  <a href="mailto:mike.jones@manchester.ac.uk">&lt;mike.jones@manchester.ac.uk&gt;</a> -- MIKEJ<br />
4522. <a href="http://www.pioto.org/">Mike Kelly</a>  <a href="mailto:pioto@pioto.org">&lt;pioto@pioto.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIOTO">PIOTO</a><br />

4523. Mike Kniaziewicz  <a href="mailto:mkniazic@coat.com">&lt;mkniazic@coat.com&gt;</a> -- MIKHAILK<br />
4524. Mike Kugler  <a href="mailto:mike@infosystem.com">&lt;mike@infosystem.com&gt;</a> -- MKUGLER<br />
4525. <a href="http://perl.jall.org/">Mike Lambert</a>  <a href="mailto:perl-pause@jall.org">&lt;perl-pause@jall.org&gt;</a> -- MLAMBERT<br />

4526. Mike MacKenzie  <a href="mailto:mackenziespamcatcher@yahoo.com">&lt;mackenziespamcatcher@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MACKENZIE">MACKENZIE</a><br />
4527. Mike Machado  <a href="mailto:mike@metrobeam.com">&lt;mike@metrobeam.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMACHADO">MMACHADO</a><br />
4528. <a href="http://www.open.com.au/">Mike McCauley</a>  <a href="mailto:mikem@open.com.au">&lt;mikem@open.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEM">MIKEM</a><br />

4529. <a href="http://www.2bit.net/">Mike Miller</a>  <a href="mailto:mrmike@2bit.net">&lt;mrmike@2bit.net&gt;</a> -- MRMIKE<br />
4530. <a href="http://www.software.ibm.com/data/db2/perl">Mike Moran</a>  <a href="mailto:mhm@cpan.org">&lt;mhm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MH/MHM">MHM</a><br />
4531. <a href="http://www.koha.org">Mike Mylonas</a>  <a href="mailto:koha@dragon-is.co.nz">&lt;koha@dragon-is.co.nz&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOHA">KOHA</a><br />

4532. Mike O'Regan  <a href="mailto:moregan@flr.follett.com">&lt;moregan@flr.follett.com&gt;</a> -- MOREGAN<br />
4533. Mike Owens  <a href="mailto:mike.owens@state.nm.us">&lt;mike.owens@state.nm.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEO">MIKEO</a><br />
4534. Mike Peachey  <a href="mailto:zordrak@cpan.org">&lt;zordrak@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZO/ZORDRAK">ZORDRAK</a><br />

4535. Mike Perez  <a href="mailto:spam@spam.spam.spam">&lt;spam@spam.spam.spam&gt;</a> -- MPEREZ<br />
4536. <a href="www.haverstickconsulting.com">Mike Prunty</a>  <a href="mailto:mike.prunty@haverstickconsulting.com">&lt;mike.prunty@haverstickconsulting.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPRUNTY">MPRUNTY</a><br />
4537. <a href="http://fonolo.com">Mike Pultz</a>  <a href="mailto:pause@fonolo.com">&lt;pause@fonolo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MP/MPULTZ">MPULTZ</a><br />

4538. Mike Randall  <a href="mailto:randall@ku.edu">&lt;randall@ku.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRANDALL">MRANDALL</a><br />
4539. Mike Rosulek  <a href="mailto:mike@mikero.com">&lt;mike@mikero.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROSULEK">ROSULEK</a><br />
4540. <a href="http://esilibrary.com">Mike Rylander</a>  <a href="mailto:mrylander@gmail.com">&lt;mrylander@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKERY">MIKERY</a><br />

4541. Mike Schroeder  <a href="mailto:mike-cpan@donorware.com">&lt;mike-cpan@donorware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKE">MIKE</a><br />
4542. Mike Scott  <a href="mailto:michael underscore scott at mac dot com">&lt;michael underscore scott at mac dot com&gt;</a> -- MIKESCOTT<br />
4543. <a href="http://www.shoyher.com">Mike Shoykher</a>  <a href="mailto:mike@shoyher.com">&lt;mike@shoyher.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSHOYHER">MSHOYHER</a><br />

4544. <a href="http://limaromeo.dyndns.org/">Mike Sierra</a>  <a href="mailto:letmespellitoutforyou@gmail.com">&lt;letmespellitoutforyou@gmail.com&gt;</a> -- SIERRA<br />
4545. <a href="http://cts.sourceforge.net">Mike Simkins</a>  <a href="mailto:sourceforge@g7obs.net">&lt;sourceforge@g7obs.net&gt;</a> -- MSIMKINS<br />
4546. Mike Smith  <a href="mailto:mike@a0qprkvwh4.mdms.org">&lt;mike@a0qprkvwh4.mdms.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDMS">MDMS</a><br />

4547. Mike Smith  <a href="mailto:perlfu@gmail.com">&lt;perlfu@gmail.com&gt;</a> -- REFLUX<br />
4548. <a href="http://www.fulcrum.org/personal/msouth">Mike South</a>  <a href="mailto:msouth@fulcrum.org">&lt;msouth@fulcrum.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSOUTH">MSOUTH</a><br />
4549. <a href="http://www.stok.ca/~mike/">Mike Stok</a>  <a href="mailto:mike+pause@stok.ca">&lt;mike+pause@stok.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKESTOK">MIKESTOK</a><br />

4550. <a href="http://www.combustiblefruit.org/">Mike Szczerban</a>  <a href="mailto:mike@aspect.net">&lt;mike@aspect.net&gt;</a> -- MIKESZCZ<br />
4551. <a href="http://www.miketaylor.org.uk/">Mike Taylor</a>  <a href="mailto:perl@miketaylor.org.uk">&lt;perl@miketaylor.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIRK">MIRK</a><br />
4552. Mike Wesemann  <a href="mailto:mwx@gmx.de">&lt;mwx@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MW/MWX">MWX</a><br />

4553. Mike Wong  <a href="mailto:mike_w3@pacbell.net">&lt;mike_w3@pacbell.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKEWONG">MIKEWONG</a><br />
4554. <a href="http://www.wyer.org/mike/">Mike Wyer</a>  <a href="mailto:mike@wyer.org">&lt;mike@wyer.org&gt;</a> -- MWYER<br />
4555. <a href="http://migo.sixbit.org/">Mikhael Goikhman</a>  <a href="mailto:migo@homemail.com">&lt;migo@homemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIGO">MIGO</a><br />

4556. <a href="http://qdbm.sourceforge.net/">Mikio Hirabayashi</a>  <a href="mailto:mikio@users.sourceforge.net">&lt;mikio@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKIO">MIKIO</a><br />
4557. <a href="http://www.pasti.iki.fi/">Mikko Lipasti</a>  <a href="mailto:">&lt;&gt;</a> -- PASTI<br />
4558. Miklós Fazekas  <a href="mailto:mfazekas@szemafor.com">&lt;mfazekas@szemafor.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOGA">BOGA</a><br />

4559. <a href="http://www.idocs.com/miko/">Miko O'Sullivan</a>  <a href="mailto:miko@idocs.com">&lt;miko@idocs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKO">MIKO</a><br />
4560. <a href="http://www.perlscript.com">Milan Adamovsky</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MILAN">MILAN</a><br />
4561. <a href="http://www.milansorm.cz/">Milan Sorm</a>  <a href="mailto:sorm@uikt.mendelu.cz">&lt;sorm@uikt.mendelu.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MILSO">MILSO</a><br />

4562. <a href="http://staff.washington.edu/mcrawfor">Miles Crawford</a>  <a href="mailto:mcrawfor@cpan.org">&lt;mcrawfor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCRAWFOR">MCRAWFOR</a><br />
4563. <a href="http://alma.ch/perl">Milivoj Ivkovic</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIVKOVIC">MIVKOVIC</a><br />
4564. <a href="http://mina.naguib.ca">Mina Naguib</a>  <a href="mailto:mina.cpan@naguib.ca">&lt;mina.cpan@naguib.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MN/MNAGUIB">MNAGUIB</a><br />

4565. Mindtrust, LLC (Missouri, USA)  <a href="mailto:david@mindtrustllc.com">&lt;david@mindtrustllc.com&gt;</a> -- MINDTRUST<br />
4566. <a href="http://www.mingyi.org">Mingyi Liu</a>  <a href="mailto:mingyiliu@yahoo.com">&lt;mingyiliu@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MINGYILIU">MINGYILIU</a><br />
4567. Miorel-Lucian Palii  <a href="mailto:mlpalii@gmail.com">&lt;mlpalii@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIOREL">MIOREL</a><br />

4568. Mirko Westermeier  <a href="mailto:mail@memowe.de">&lt;mail@memowe.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MEMOWE">MEMOWE</a><br />
4569. <a href="http://shiar.org/">Mischa POSLAWSKY</a>  <a href="mailto:perl@shiar.org">&lt;perl@shiar.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIAR">SHIAR</a><br />
4570. <a href="http://happiland.net">Mischa Spiegelmock</a>  <a href="mailto:revmischa@cpan.org">&lt;revmischa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REVMISCHA">REVMISCHA</a><br />

4571. <a href="http://www.deepsky.com/~misaka/">Mishka Gorodnitzky</a>  <a href="mailto:misaka@pobox.com">&lt;misaka@pobox.com&gt;</a> -- MISAKA<br />
4572. Mohammad Mahmoud Khajah  <a href="mailto:mmkhajah@syr.edu">&lt;mmkhajah@syr.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MM/MMKHAJAH">MMKHAJAH</a><br />
4573. <a href="http://www.basirat.com">Mohsen Basirat</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MBAS<br />

4574. Mons Anderson  <a href="mailto:mons@cpan.org">&lt;mons@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MONS">MONS</a><br />
4575. <a href="http://www.gonefishing.org">Monte Mitzelfelt</a>  <a href="mailto:monte-cpan@gonefishing.org">&lt;monte-cpan@gonefishing.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMITZ">RMITZ</a><br />
4576. <a href="http://home.swbell.net/mscroggi">Monty Scroggins</a>  <a href="mailto:Monty@MasterMindsConsulting.com">&lt;Monty@MasterMindsConsulting.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSCROGGIN">MSCROGGIN</a><br />

4577. <a href="http://www.codeflow.net">Moon Lee</a>  <a href="mailto:moon-cpan@oompa.net">&lt;moon-cpan@oompa.net&gt;</a> -- MOON<br />
4578. <a href="http://umbc.edu/~mabzug1">Mordechai Abzug</a>  <a href="mailto:mabzug1@gl.umbc.edu">&lt;mabzug1@gl.umbc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MORTY">MORTY</a><br />
4579. <a href="http://perlgeek.de/">Moritz Lenz</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MORITZ">MORITZ</a><br />

4580. Moritz Onken  <a href="mailto:onken@houseofdesign.de">&lt;onken@houseofdesign.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERLER">PERLER</a><br />
4581. <a href="http://formengine.freesources.org">Moritz Sinn</a>  <a href="mailto:moritz@freesources.org">&lt;moritz@freesources.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MORNI">MORNI</a><br />
4582. <a href="http://purl.org/net/morten/">Morten Frederiksen</a>  <a href="mailto:morten@mfd-consult.dk">&lt;morten@mfd-consult.dk&gt;</a> -- MORTENF<br />

4583. <a href="http://sickel.net">Morten Sickel</a>  <a href="mailto:cpan@sickel.net">&lt;cpan@sickel.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSICKEL">MSICKEL</a><br />
4584. Moshe Kamensky  <a href="mailto:kamensky@cpan.org">&lt;kamensky@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KAMENSKY">KAMENSKY</a><br />
4585. Mosienko Stanislav  <a href="mailto:web.perldev@gmail.com">&lt;web.perldev@gmail.com&gt;</a> -- OCEANLAB<br />

4586. <a href="http://www.betacomp.com/">Mukund Deshmukh</a>  <a href="mailto:betacomp_ngp@sancharnet.in">&lt;betacomp_ngp@sancharnet.in&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUKUND">MUKUND</a><br />
4587. <a href="http://home.earthlink.net/~mumia.w.18.spam/">Mumia Wotse</a>  <a href="mailto:paduille.4061.mumia.w+nospam.cpan@earthlink.net">&lt;paduille.4061.mumia.w+nospam.cpan@earthlink.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUMIAW">MUMIAW</a><br />
4588. <a href="http://www.industrial.de/muenalan">Murat Ünalan</a>  <a href="mailto:muenalan@cpan.org">&lt;muenalan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUENALAN">MUENALAN</a><br />

4589. <a href="http://www.nesbitt.ca/">Murray Nesbitt</a>  <a href="mailto:murray@cpan.org">&lt;murray@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MURRAY">MURRAY</a><br />
4590. Murugavel Ramachandran  <a href="mailto:blsrm@yahoo.com">&lt;blsrm@yahoo.com&gt;</a> -- BLSRM<br />
4591. <a href="http://b.domaindlx.com/murugavel">Murugavel Ramachandran</a>  <a href="mailto:Murugavel.Ramachandran@gmail.com">&lt;Murugavel.Ramachandran@gmail.com&gt;</a> -- MURUGAVEL<br />

4592. Murugesan Kandasamy  <a href="mailto:kmuru_somu@rediffmail.com">&lt;kmuru_somu@rediffmail.com&gt;</a> -- MURUGU<br />
4593. <a href="http://www.room535.org/">Myron Turner</a>  <a href="mailto:mturner@fish4parking.com">&lt;mturner@fish4parking.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TU/TURNERMM">TURNERMM</a><br />
4594. Márton Németh  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NM/NMARCI">NMARCI</a><br />

4595. <a href="http://collections.nhm.org/code/">N. Dean Pentcheff</a>  <a href="mailto:dean2@biol.sc.edu">&lt;dean2@biol.sc.edu&gt;</a> -- PENTCHEFF<br />
4596. <a href="http://spiderboy.net/">N. Hao Ching</a>  <a href="mailto:spiderboy@cpan.org">&lt;spiderboy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPIDERBOY">SPIDERBOY</a><br />
4597. <a href="http://www.mouns.net/devel/">N. S. Mouniée</a>  <a href="mailto:mouns@freesurf.fr">&lt;mouns@freesurf.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOUNS">MOUNS</a><br />

4598. <a href="http://www.yukinobu.jp/tdiary/">NAGAYASU Yukinobu</a>  <a href="mailto:nagayasu@yukinobu.jp">&lt;nagayasu@yukinobu.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YU/YUKINOBU">YUKINOBU</a><br />
4599. NAKAGAWA Masaki  <a href="mailto:masaki@cpan.org">&lt;masaki@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASAKI">MASAKI</a><br />
4600. <a href="http://airemix.com/">NARUSE, Yui</a>  <a href="mailto:naruse@airemix.com">&lt;naruse@airemix.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NARUSE">NARUSE</a><br />

4601. NCPL  <a href="mailto:yvdhove@users.sourceforge.net">&lt;yvdhove@users.sourceforge.net&gt;</a> -- NCPL<br />
4602. NISHIGAYA, Yuki (西ヶ谷有輝)  <a href="mailto:nishigaya@cpan.org">&lt;nishigaya@cpan.org&gt;</a> -- NISHIGAYA<br />
4603. <a href="http://www.daionet.gr.jp/~knok/">NOKUBI Takatsugu</a>  <a href="mailto:knok@daionet.gr.jp">&lt;knok@daionet.gr.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNOK">KNOK</a><br />

4604. Nag Nelluri  <a href="mailto:nnelluri@arinc.com">&lt;nnelluri@arinc.com&gt;</a> -- NNAG<br />
4605. Nagaraju Kancherla  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAMP<br />
4606. <a href="http://d.hatena.ne.jp/bonar">Nakano Kyohei</a>  <a href="mailto:bonamonchy@gmail.com">&lt;bonamonchy@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BONAR">BONAR</a><br />

4607. Nandu Shah  <a href="mailto:nandu.shah@gmail.com">&lt;nandu.shah@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NANDU">NANDU</a><br />
4608. <a href="http://nyarla.net/">Naoki Okamura</a>  <a href="mailto:thotep@nyarla.net">&lt;thotep@nyarla.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NY/NYARLA">NYARLA</a><br />
4609. <a href="http://e8y.net/">Naoki Tomita</a>  <a href="mailto:tomita@cpan.org">&lt;tomita@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOMITA">TOMITA</a><br />

4610. Naoki URAI  <a href="mailto:naoki_urai@yahoo.co.jp">&lt;naoki_urai@yahoo.co.jp&gt;</a> -- NAOKIURAI<br />
4611. Naoto Ishikawa  <a href="mailto:toona@edge.jp">&lt;toona@edge.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOONA">TOONA</a><br />
4612. <a href="http://d.hatena.ne.jp/naoya_t/">Naoya &quot;naochan&quot; Tozuka</a>  <a href="mailto:naoyat@naochan.com">&lt;naoyat@naochan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAOYAT">NAOYAT</a><br />

4613. <a href="http://d.hatena.ne.jp/naoya/">Naoya Ito</a>  <a href="mailto:naoya@bloghackers.net">&lt;naoya@bloghackers.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAOYA">NAOYA</a><br />
4614. Naoya Tsutsumi  <a href="mailto:ntsutsumi@cpan.org">&lt;ntsutsumi@cpan.org&gt;</a> -- NTSUTSUMI<br />
4615. Naoyuki Ito  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NAOYUKI<br />

4616. <a href="http://calculus.jp">Naoyuki Okumura</a>  <a href="mailto:">&lt;&gt;</a> -- AGREW<br />
4617. <a href="http://www.cs.wisc.edu/~nmueller">Nate Mueller</a>  <a href="mailto:nate@cs.wisc.edu">&lt;nate@cs.wisc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NM/NMUELLER">NMUELLER</a><br />
4618. <a href="http://www.natemurray.com">Nate Murray</a>  <a href="mailto:nate@natemurray.com">&lt;nate@natemurray.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JASHMENN">JASHMENN</a><br />

4619. <a href="http://www.dangerrabbit.com">Nate Wiger</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWIGER">NWIGER</a><br />
4620. <a href="http://polynate.net/">Nathan Bailey</a>  <a href="mailto:nate@cpan.org">&lt;nate@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NATE">NATE</a><br />
4621. Nathan Byrd  <a href="mailto:nathan@byrd.net">&lt;nathan@byrd.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NB/NBYRD">NBYRD</a><br />

4622. Nathan E. Bessette  <a href="mailto:coruscate@cpan.org">&lt;coruscate@cpan.org&gt;</a> -- CORUSCATE<br />
4623. <a href="http://www.bright.net/~jonadab/">Nathan Eady</a>  <a href="mailto:jonadab@bright.net">&lt;jonadab@bright.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JO/JONADAB">JONADAB</a><br />
4624. Nathan Gray  <a href="mailto:kolibrie@graystudios.org">&lt;kolibrie@graystudios.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOLIBRIE">KOLIBRIE</a><br />

4625. Nathan Jay Olson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NJO<br />
4626. Nathan Lewis  <a href="mailto:nathanlewis42@yahoo.co.uk">&lt;nathanlewis42@yahoo.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NATHANL">NATHANL</a><br />
4627. <a href="http://nmcfarl.org/">Nathan McFarland</a>  <a href="mailto:nathan.mcfarland@nmcfarl.org">&lt;nathan.mcfarland@nmcfarl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NM/NMCFARL">NMCFARL</a><br />

4628. <a href="chinstrap.net">Nathan Morris</a>  <a href="mailto:nathan@chinstrap.net">&lt;nathan@chinstrap.net&gt;</a> -- NMORRIS<br />
4629. <a href="http://www.umr.edu/~nneul/">Nathan Neulinger</a>  <a href="mailto:nneul@umr.edu">&lt;nneul@umr.edu&gt;</a> -- NNEUL<br />
4630. <a href="http://wang-fu.org/">Nathan Poznick</a>  <a href="mailto:kraken at wang-fu dot org">&lt;kraken at wang-fu dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POZNICK">POZNICK</a><br />

4631. <a href="http://www.remix.net">Nathan Ramella</a>  <a href="mailto:nar@hush.com">&lt;nar@hush.com&gt;</a> -- NAR<br />
4632. <a href="http://www.mad-dragon.com">Nathan Ross</a>  <a href="mailto:johnmarchii@earthlink.net">&lt;johnmarchii@earthlink.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MORGOTHII">MORGOTHII</a><br />
4633. <a href="http://lotech.org">Nathan Shafer</a>  <a href="mailto:nate-pause@lotech.org">&lt;nate-pause@lotech.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NS/NSHAFER">NSHAFER</a><br />

4634. <a href="http://www.fiveprime.org">Nathan Siemers</a>  <a href="mailto:noscpan@fiveprime.org">&lt;noscpan@fiveprime.org&gt;</a> -- SIEMERSN<br />
4635. <a href="http://nathan.torkington.com/">Nathan Torkington</a>  <a href="mailto:nathan@torkington.com">&lt;nathan@torkington.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GN/GNAT">GNAT</a><br />
4636. Nathan V. Patwardhan  <a href="mailto:nvp@ora.com">&lt;nvp@ora.com&gt;</a> -- NVPAT<br />

4637. Nathan Waddell  <a href="mailto:arafeandur@gmail.com">&lt;arafeandur@gmail.com&gt;</a> -- RAVENHALL<br />
4638. <a href="http://granicus.if.org/~nw/">Nathan Wagner</a>  <a href="mailto:nw@hydaspes.if.org">&lt;nw@hydaspes.if.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WAGNER">WAGNER</a><br />
4639. Nathanael Obermayer  <a href="mailto:natom-pause@smi2le.net">&lt;natom-pause@smi2le.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NATHANAEL">NATHANAEL</a><br />

4640. Nathaniel Christen  <a href="mailto:nchri016@uottawa.ca">&lt;nchri016@uottawa.ca&gt;</a> -- POMEROL<br />
4641. Nathaniel Christen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NATHANIEL<br />
4642. Nathaniel Heinrichs  <a href="mailto:nheinric@cpan.org">&lt;nheinric@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NH/NHEINRIC">NHEINRIC</a><br />
4643. <a href="http://bumppo.net">Nathaniel Irons</a>  <a href="mailto:ndi-cpan@bumppo.net">&lt;ndi-cpan@bumppo.net&gt;</a> -- IRONS<br />

4644. <a href="www.urth.org/~ngraham">Nathaniel J. Graham</a>  <a href="mailto:broom@cpan.org">&lt;broom@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BROOM">BROOM</a><br />
4645. <a href="http://ncicb.nci.nih.gov/">National Cancer Institute Center for Bioinformatics</a>  <a href="mailto:rokicki k at mail dot NIH dot GOV">&lt;rokicki k at mail dot NIH dot GOV&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NC/NCICB">NCICB</a><br />
4646. <a href="http://slip-shod.blogspot.com">Naunidh Singh Chadha</a>  <a href="mailto:naunidh [at] gmail [dot] com">&lt;naunidh [at] gmail [dot] com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAUNIDH">NAUNIDH</a><br />

4647. Navneet Kumar  <a href="mailto:navneet_k@hotmail.com">&lt;navneet_k@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAVNEET">NAVNEET</a><br />
4648. <a href="http://bike-nomad.com/perl/">Ned Konz</a>  <a href="mailto:nedkonz@cpan.org">&lt;nedkonz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEDKONZ">NEDKONZ</a><br />
4649. Neels Jordaan  <a href="mailto:neels@law.com">&lt;neels@law.com&gt;</a> -- NEELSJ<br />

4650. <a href="http://neil-neely.blogspot.com">Neil A. Neely</a>  <a href="mailto:neil@neely.cx">&lt;neil@neely.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEELY">NEELY</a><br />
4651. <a href="http://www.webbedfeet.net.nz/">Neil Bertram</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NBERTRAM<br />
4652. <a href="http://www.neilbowers.org/">Neil Bowers</a>  <a href="mailto:neil@bowers.com">&lt;neil@bowers.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEILB">NEILB</a><br />

4653. <a href="http://www.greyhavens.org.uk">Neil Hemingway</a>  <a href="mailto:hemingway@cpan.org">&lt;hemingway@cpan.org&gt;</a> -- HEMINGWAY<br />
4654. <a href="http://www.physiol.ox.ac.uk/~njh/">Neil Hoggarth</a>  <a href="mailto:njh@kernighan.demon.co.uk">&lt;njh@kernighan.demon.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOGGARTH">HOGGARTH</a><br />
4655. Neil Jensen  <a href="mailto:njensen@habaneros.com">&lt;njensen@habaneros.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NJ/NJENSEN">NJENSEN</a><br />

4656. <a href="http://www.rosbif.org">Neil Lombardo</a>  <a href="mailto:pause.cpan@rosbif.org">&lt;pause.cpan@rosbif.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOMBARDO">LOMBARDO</a><br />
4657. <a href="http://i.am/nrp">Neil Padgen</a>  <a href="mailto:nrp@i.am">&lt;nrp@i.am&gt;</a> -- NPADGEN<br />
4658. <a href="http://strathesk.blogspot.com/">Neil Skilling</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NSKILLING<br />

4659. <a href="http://ttul.org/~nwatkiss">Neil Watkiss</a>  <a href="mailto:nwatkiss@ttul.org">&lt;nwatkiss@ttul.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEILW">NEILW</a><br />
4660. <a href="http://people.debian.org/~codehelp/">Neil Williams</a>  <a href="mailto:codehelp@debian.org">&lt;codehelp@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CO/CODEHELP">CODEHELP</a><br />
4661. Neil Winton  <a href="mailto:winton_neil@jpmorgan.com">&lt;winton_neil@jpmorgan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWINT">NWINT</a><br />

4662. Nelson Elhage  <a href="mailto:nelhage@mit.edu">&lt;nelhage@mit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NELHAGE">NELHAGE</a><br />
4663. <a href="www.perl.org.br">Nelson Ferraz</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NF/NFERRAZ">NFERRAZ</a><br />
4664. <a href="http://www.emptec.com/">Nem W Schlecht</a>  <a href="mailto:nem@emptec.com">&lt;nem@emptec.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NE/NEMWS">NEMWS</a><br />

4665. NetSnake  <a href="mailto:netsnakecn@163.com">&lt;netsnakecn@163.com&gt;</a> -- NETSNAKE<br />
4666. <a href="http://netcomics.sourceforge.net/">Netcomics Development Team</a>  <a href="mailto:netcomics-devel@lists.sf.net">&lt;netcomics-devel@lists.sf.net&gt;</a> -- NETCOMICS<br />
4667. Nevinitsin Yury  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YU/YURAN">YURAN</a><br />

4668. <a href="http://iteaha.us/">Nguon Hao Ching</a>  <a href="mailto:hao at iteaha us">&lt;hao at iteaha us&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IT/ITEAHAUS">ITEAHAUS</a><br />
4669. <a href="http://angel.net/~nic/">Nic Wolff</a>  <a href="mailto:nic@angel.net">&lt;nic@angel.net&gt;</a> -- NICWOLFF<br />
4670. <a href="http://www.silasthemonk.org.uk">Nicholas Bamber</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SILASMONK">SILASMONK</a><br />

4671. <a href="http://www.cogulus.com">Nicholas C. Baker</a>  <a href="mailto:nickbaker@cogulus.com">&lt;nickbaker@cogulus.com&gt;</a> -- NICKBAKER<br />
4672. <a href="http://www.ccl4.org/~nick/">Nicholas Clark</a>  <a href="mailto:nwc10+please+use+perlbug+for+perl+queries@colon.colondot.net">&lt;nwc10+please+use+perlbug+for+perl+queries@colon.colondot.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWCLARK">NWCLARK</a><br />
4673. Nicholas DeClario  <a href="mailto:ndeclari@gmail.com">&lt;ndeclari@gmail.com&gt;</a> -- NDECLARI<br />

4674. Nicholas G Caratzas  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NICKC<br />
4675. <a href="http://www.socklabs.com">Nicholas Gerakines</a>  <a href="mailto:nick@socklabs.com">&lt;nick@socklabs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOCK">SOCK</a><br />
4676. <a href="www.creativearts.com.au">Nicholas Gledhill</a>  <a href="mailto:nick@creativearts.com.au">&lt;nick@creativearts.com.au&gt;</a> -- NGLEDHILL<br />

4677. <a href="http://www.aelius.com/njh/">Nicholas J Humfrey</a>  <a href="mailto:njh@cpan.org">&lt;njh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NJ/NJH">NJH</a><br />
4678. <a href="http://mrnick.binary9.net/">Nicholas J. Leon</a>  <a href="mailto:nicholas@binary9.net">&lt;nicholas@binary9.net&gt;</a> -- NJLEON<br />
4679. <a href="http://">Nicholas K. Alberto</a>  <a href="mailto:sflex@cpan.org">&lt;sflex@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SF/SFLEX">SFLEX</a><br />

4680. Nicholas Knouf  <a href="mailto:nknouf@mimeme.net">&lt;nknouf@mimeme.net&gt;</a> -- NKNOUF<br />
4681. <a href="http://www.abstractwankery.com">Nicholas Melnick</a>  <a href="mailto:nick [aatt] abstract wankery period com">&lt;nick [aatt] abstract wankery period com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NM/NMELNICK">NMELNICK</a><br />
4682. Nicholas Perez  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NP/NPEREZ">NPEREZ</a><br />

4683. Nicholas R. Delorme  <a href="mailto:nic@nicdelorme.com">&lt;nic@nicdelorme.com&gt;</a> -- LYTREAN<br />
4684. Nicholas Sushkin  <a href="mailto:nsushkin@users.sourceforge.net">&lt;nsushkin@users.sourceforge.net&gt;</a> -- NSUSHKIN<br />
4685. <a href="http://zoic.org/sharkey/">Nick 'Sharkey' Moore</a>  <a href="mailto:sharkey+cpan@zoic.org">&lt;sharkey+cpan@zoic.org&gt;</a> -- SHARKEY<br />

4686. <a href="http://www.nickb.org/">Nick Balthaser</a>  <a href="mailto:me@nickb.org">&lt;me@nickb.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NICKB">NICKB</a><br />
4687. <a href="http://nick.cleaton.net/">Nick Cleaton</a>  <a href="mailto:nick@cleaton.net">&lt;nick@cleaton.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NC/NCLEATON">NCLEATON</a><br />
4688. <a href="http://nms.lcs.mit.edu/~feamster/">Nick Feamster</a>  <a href="mailto:feamster@lcs.mit.edu">&lt;feamster@lcs.mit.edu&gt;</a> -- FEAMSTER<br />

4689. Nick Gianniotis  <a href="mailto:nico@acm.org">&lt;nico@acm.org&gt;</a> -- NICO<br />
4690. <a href="http://www.netability.ie/">Nick Hilliard</a>  <a href="mailto:nick-perl@netability.ie">&lt;nick-perl@netability.ie&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NICKH">NICKH</a><br />
4691. <a href="www.egyptus.co.uk">Nick Humphries</a>  <a href="mailto:cpan@egyptus.co.uk">&lt;cpan@egyptus.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EG/EGYPTUS">EGYPTUS</a><br />

4692. <a href="http://pause.perl.org">Nick Ing-Simmons (PAUSE Custodial Account)</a>  <a href="mailto:ni-s@cpan.org">&lt;ni-s@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NI-S">NI-S</a><br />
4693. Nick Jensen  <a href="mailto:hardcode@cpan.org">&lt;hardcode@cpan.org&gt;</a> -- HARDCODE<br />
4694. Nick Kostirya  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNI">KNI</a><br />

4695. Nick Makarov  <a href="mailto:nmakarov at horizondatasys dot com">&lt;nmakarov at horizondatasys dot com&gt;</a> -- NMAKAROV<br />
4696. <a href="http://www.marden.org">Nick Marden</a>  <a href="mailto:nick@marden.org">&lt;nick@marden.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NM/NMARDEN">NMARDEN</a><br />
4697. Nick Patch  <a href="mailto:n [ĉe] atemoya [punkto] net">&lt;n [ĉe] atemoya [punkto] net&gt;</a> -- NIKOLAO<br />

4698. <a href="http://www.peskett.co.uk">Nick Peskett</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NP/NPESKETT">NPESKETT</a><br />
4699. Nick Phillips  <a href="mailto:nwp@lemon-computing.com">&lt;nwp@lemon-computing.com&gt;</a> -- LEMON<br />
4700. <a href="http://scifi.squawk.com/njs.html">Nick Simicich</a>  <a href="mailto:njs+paus@scifi.squawk.com">&lt;njs+paus@scifi.squawk.com&gt;</a> -- NJS<br />

4701. Nick Stoianov  <a href="mailto:cpanperl@yahoo.com">&lt;cpanperl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CP/CPANPERL">CPANPERL</a><br />
4702. <a href="http://www.fuckout.de">Nick Sutterer</a>  <a href="mailto:">&lt;&gt;</a> -- NIX<br />
4703. <a href="http://www.tonkinresolutions.com/">Nick Tonkin</a>  <a href="mailto:publicn@tonkinresolutions.com">&lt;publicn@tonkinresolutions.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TONKIN">TONKIN</a><br />

4704. <a href="http://quietmint.com/">Nick Venturella</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NICK">NICK</a><br />
4705. <a href="http://noseynick.org/">Nick Waterman</a>  <a href="mailto:pause@noseynick.org">&lt;pause@noseynick.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOSEYNICK">NOSEYNICK</a><br />
4706. Nick Wellnhofer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NWELLNHOF<br />

4707. <a href="http://www.ghostwheel.demon.co.uk/njw">Nick Williams</a>  <a href="mailto:nwilliams@ghostwheel.demon.co.uk">&lt;nwilliams@ghostwheel.demon.co.uk&gt;</a> -- NWILLIAMS<br />
4708. Nick Woolley  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NP/NPW">NPW</a><br />
4709. <a href="http://nab.kiev.ua/">Nickolay Briginets</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NAB<br />

4710. <a href="http://resume.nickola.ru">Nickolay Kovalev</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NICKOLA">NICKOLA</a><br />
4711. Nico Erfurth  <a href="mailto:masta-cpan@perlgolf.de">&lt;masta-cpan@perlgolf.de&gt;</a> -- MASTA<br />
4712. <a href="http://users.dimi.uniud.it/~nicola.vitacolonna/">Nicola Vitacolonna</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VITA">VITA</a><br />

4713. <a href="http://perlgirl.org.uk">Nicola Worthington</a>  <a href="mailto:nicolaw@cpan.org">&lt;nicolaw@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NICOLAW">NICOLAW</a><br />
4714. <a href="http://www.math.uio.no/~janl/">Nicolai Langfeldt</a>  <a href="mailto:janl@math.uio.no">&lt;janl@math.uio.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANL">JANL</a><br />
4715. <a href="http://www.mouarf.org/">Nicolas Bareil</a>  <a href="mailto:nbareil@mouarf.org">&lt;nbareil@mouarf.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NB/NBAREIL">NBAREIL</a><br />

4716. Nicolas Catania  <a href="mailto:nicolas_catania@yahoo.com">&lt;nicolas_catania@yahoo.com&gt;</a> -- NIKO<br />
4717. <a href="http://www.teaser.fr/~nchuche/">Nicolas Chuche</a>  <a href="mailto:nchuche@barna.be">&lt;nchuche@barna.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NC/NCHUCHE">NCHUCHE</a><br />
4718. Nicolas Georges  <a href="mailto:xlat@cpan.org">&lt;xlat@cpan.org&gt;</a> -- XLAT<br />

4719. <a href="http://www.madrognon.net">Nicolas Herry</a>  <a href="mailto:k@madrognon.net">&lt;k@madrognon.net&gt;</a> -- KAFKA<br />
4720. <a href="http://cpc.freeshell.org/">Nicolas Lidzborski</a>  <a href="mailto:cpan.20.cpc@spamgourmet.com">&lt;cpan.20.cpc@spamgourmet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NL/NLIDZ">NLIDZ</a><br />
4721. <a href="http://lapcs.univ-lyon1.fr/~nthiery/">Nicolas M. Thiéry</a>  <a href="mailto:nthiery@users.sf.net">&lt;nthiery@users.sf.net&gt;</a> -- NTHIERYA<br />

4722. Nicolas Mendoza  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NICOMEN<br />
4723. <a href="http://www.meynet.ch">Nicolas Meynet</a>  <a href="mailto:perl@meynet.ch">&lt;perl@meynet.ch&gt;</a> -- NITRO<br />
4724. <a href="http://monnet.to/">Nicolas Monnet</a>  <a href="mailto:nico@nospam.altiva.fr">&lt;nico@nospam.altiva.fr&gt;</a> -- NMONNET<br />

4725. Nicolas Rennert  <a href="mailto:nicolas@rennert.fr">&lt;nicolas@rennert.fr&gt;</a> -- RENNERT<br />
4726. <a href="www.rineau.eu">Nicolas Rineau</a>  <a href="mailto:nicolas@rineau.eu">&lt;nicolas@rineau.eu&gt;</a> -- NRINEAU<br />
4727. <a href="http://www.eleves.ens.fr:8080/home/nthiery/">Nicolas Thiéry</a>  <a href="mailto:Nicolas.Thiery@ens.fr">&lt;Nicolas.Thiery@ens.fr&gt;</a> -- NTHIERY<br />

4728. <a href="www.daansystems.com">Niek Albers</a>  <a href="mailto:nieka@daansystems.com">&lt;nieka@daansystems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAAN">DAAN</a><br />
4729. <a href="http://perlboy.net">Niels van Dijke</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERLBOY">PERLBOY</a><br />
4730. <a href="www.stanford.edu/~nigam">Nigam Shah</a>  <a href="mailto:drnigam@hotmail.com">&lt;drnigam@hotmail.com&gt;</a> -- NIGAM<br />

4731. <a href="http://www.wiggly.org/">Nigel A Rantor</a>  <a href="mailto:perl@wiggly.org">&lt;perl@wiggly.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WIGGLY">WIGGLY</a><br />
4732. <a href="http://trexy.com">Nigel Hamilton</a>  <a href="mailto:nigel@trexy.com">&lt;nigel@trexy.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIGE">NIGE</a><br />
4733. Nigel Metheringham  <a href="mailto:nigel.metheringham@gmail.com">&lt;nigel.metheringham@gmail.com&gt;</a> -- NIGELM<br />

4734. Nigel Wetters Gourlay  <a href="mailto:nwetters@cpan.org">&lt;nwetters@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWETTERS">NWETTERS</a><br />
4735. Nigel Wright  <a href="mailto:nwright@hmc.edu">&lt;nwright@hmc.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWRIGHT">NWRIGHT</a><br />
4736. <a href="http://www.x-tac.net">Nightcat</a>  <a href="mailto:nightcat@crocker.com">&lt;nightcat@crocker.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINC">LINC</a><br />

4737. <a href="http://www.freebsd.org/~nik/">Nik Clayton</a>  <a href="mailto:nik@ngo.org.uk">&lt;nik@ngo.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIKC">NIKC</a><br />
4738. <a href="www.nikogura.com">Nik Ogura</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VA/VAYDE">VAYDE</a><br />
4739. Nikhil  <a href="mailto:mnikhil@gmail.com">&lt;mnikhil@gmail.com&gt;</a> -- MNIKHIL<br />

4740. <a href="http://www.funonphone.com">Nikhil Talwar</a>  <a href="mailto:nikhil@swastikgroup.com">&lt;nikhil@swastikgroup.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIKHILTAL">NIKHILTAL</a><br />
4741. <a href="savin.go2serve.net">Nikita Savin</a>  <a href="mailto:nikita@savin.go2serve.net">&lt;nikita@savin.go2serve.net&gt;</a> -- ASDF<br />
4742. <a href="http://www.sw-id.de/">Niklas Bichinger</a>  <a href="mailto:niklas@groelaz.org">&lt;niklas@groelaz.org&gt;</a> -- LUKE<br />

4743. Nikolas Coukouma  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NIKOLASCO<br />
4744. <a href="http://www.rath.org/">Nikolaus Rath</a>  <a href="mailto:Nikolaus@rath.org">&lt;Nikolaus@rath.org&gt;</a> -- NIKRATIO<br />
4745. <a href="http://nikolay.bg/">Nikolay Bachiyski</a>  <a href="mailto:nb@nikolay.bg">&lt;nb@nikolay.bg&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIKOLAY">NIKOLAY</a><br />

4746. Nikolay Kuznetsov  <a href="mailto:obogrew@hotmail.com">&lt;obogrew@hotmail.com&gt;</a> -- OBOGREW<br />
4747. <a href="http://corba-mico.sourceforge.net">Nikolay Logvinov</a>  <a href="mailto:logvinon@mail.ru">&lt;logvinon@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOGVINON">LOGVINON</a><br />
4748. Nikolay Pelov  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIKIP">NIKIP</a><br />

4749. Nilesh Hiray  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SAHAAB<br />
4750. <a href="http://www.eicndhcpd.ch/">Nils Reichen</a>  <a href="mailto:nreichen@eicndhcpd.ch">&lt;nreichen@eicndhcpd.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NR/NREICHEN">NREICHEN</a><br />
4751. <a href="http://www.xn--rockbro-r2a.de">Nils Reiter</a>  <a href="mailto:reiter@cpan.org">&lt;reiter@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REITER">REITER</a><br />

4752. Nilson Santos Figueiredo Júnior  <a href="mailto:nilsonsfj@cpan.org">&lt;nilsonsfj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NILSONSFJ">NILSONSFJ</a><br />
4753. <a href="http://www.pengas.com">Nir Pengas</a>  <a href="mailto:pengas@cpan.org">&lt;pengas@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PENGAS">PENGAS</a><br />
4754. Nirave Kadakia  <a href="mailto:kadakia@hotmail.com">&lt;kadakia@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NIRAVE">NIRAVE</a><br />

4755. Nishant Kakani  <a href="mailto:nishantkakani@hotmail.com">&lt;nishantkakani@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NISHANT">NISHANT</a><br />
4756. Nitin Harale  <a href="mailto:nitin.harale@yahoo.com">&lt;nitin.harale@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NH/NHARALE">NHARALE</a><br />
4757. Nito Martinez  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NITO">NITO</a><br />

4758. Noah Rankins  <a href="mailto:pause.255.kscript@spamgourmet.com">&lt;pause.255.kscript@spamgourmet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KS/KSCRIPT">KSCRIPT</a><br />
4759. <a href="http://onastick.net/">Noah Robin</a>  <a href="mailto:noah@cpan.org">&lt;noah@cpan.org&gt;</a> -- NOAH<br />
4760. Nobody  <a href="mailto:kopernekus@yahoo.com">&lt;kopernekus@yahoo.com&gt;</a> -- CRACKEL<br />

4761. Nobuhiro Iwamatsu  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- IWAMATSU<br />
4762. <a href="http://soffritto.org/">Nobuo Danjou</a>  <a href="mailto:nobuo.danjou@gmail.com">&lt;nobuo.danjou@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANJOU">DANJOU</a><br />
4763. <a href="http://d.hatena.ne.jp/lesamoureuses/">Nobuo Kumagai</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MONMON<br />

4764. <a href="www.cercaziende.it/cgi-bin/review.cgi?ID=51499">Nocera Informatica srl</a>  <a href="mailto:f.bondurri@tiscali.it">&lt;f.bondurri@tiscali.it&gt;</a> -- FBONDURRI<br />
4765. <a href="http://bondurri.users.micso.net/">Nocera Informatica srl</a>  <a href="mailto:f.bondurri@tiscali.it">&lt;f.bondurri@tiscali.it&gt;</a> -- BONFOG<br />
4766. <a href="www.burton-krahn.com">Noel Burton-Krahn</a>  <a href="mailto:noel@burton-krahn.com">&lt;noel@burton-krahn.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOELBK">NOELBK</a><br />

4767. Noel Geren  <a href="mailto:ngeren@myprivacy.ca">&lt;ngeren@myprivacy.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NG/NGEREN">NGEREN</a><br />
4768. <a href="www.lgmedia.com.au">Noel Sharrock</a>  <a href="mailto:nsharrok@lgmedia.com.au">&lt;nsharrok@lgmedia.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NS/NSHARROCK">NSHARROCK</a><br />
4769. <a href="http://www.devasap.com">Nola Stowe</a>  <a href="mailto:cpan-nola@devasap.com">&lt;cpan-nola@devasap.com&gt;</a> -- NOLA<br />

4770. None  <a href="mailto:">&lt;&gt;</a> -- YEGG<br />
4771. NorBERT Csongrádi  <a href="mailto:bert@cpan.org">&lt;bert@cpan.org&gt;</a> -- BERT<br />
4772. Norbert Buchmüller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MENDEL<br />
4773. <a href="http://www.MPA-Garching.MPG.DE/~nog">Norbert Gruener</a>  <a href="mailto:nog@MPA-Garching.MPG.DE">&lt;nog@MPA-Garching.MPG.DE&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOG">NOG</a><br />

4774. Norbert Gövert  <a href="mailto:goevert@ls6.cs.uni-dortmund.de">&lt;goevert@ls6.cs.uni-dortmund.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOEVERT">GOEVERT</a><br />
4775. <a href="http://www.selfish.org/">Norbert Hartl</a>  <a href="mailto:noha@cpan.org">&lt;noha@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOHA">NOHA</a><br />
4776. Norbert Volf  <a href="mailto:volf@bata.cz">&lt;volf@bata.cz&gt;</a> -- NRBRT<br />

4777. <a href="http://dwende.net">Norbinn Rodrigo</a>  <a href="mailto:nrodrigo@dwende.net">&lt;nrodrigo@dwende.net&gt;</a> -- NRODRIGO<br />
4778. <a href="http://www.real-unreal.info/">Noritaka Okabe</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NORITAKA<br />
4779. Norman Nunley, Jr  <a href="mailto:nnunley@gmail.com">&lt;nnunley@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NN/NNUNLEY">NNUNLEY</a><br />

4780. <a href="http://nwalsh.com/">Norman Walsh</a>  <a href="mailto:ndw@nwalsh.com">&lt;ndw@nwalsh.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NW/NWALSH">NWALSH</a><br />
4781. Novikov Artem Gennadievich  <a href="mailto:novikovag@gmail.com">&lt;novikovag@gmail.com&gt;</a> -- NOVIKOV<br />
4782. Nuno Carvalho  <a href="mailto:mestre.smash@gmail.com">&lt;mestre.smash@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMASH">SMASH</a><br />

4783. <a href="http://nunonunes.org/">Nuno Filipe Monteiro Nunes</a>  <a href="mailto:nfmnunes@cpan.org">&lt;nfmnunes@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NF/NFMNUNES">NFMNUNES</a><br />
4784. Nuno Martins  <a href="mailto:nuno@hubz.net">&lt;nuno@hubz.net&gt;</a> -- ZBUH<br />
4785. <a href="http://algos.inesc-id.pt/~ndm/">Nuno Miguel Dias Mendes</a>  <a href="mailto:nuno@ilinx.net">&lt;nuno@ilinx.net&gt;</a> -- NNMEN<br />

4786. <a href="http://www.xmlperl.com/">Nyk Cowham</a>  <a href="mailto:nyk@cowham.net">&lt;nyk@cowham.net&gt;</a> -- NCOWHAM<br />
4787. Nélio Nunes  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NELIO<br />
4788. <a href="http://isle.wumpus.org/">O'Shaughnessy Evans</a>  <a href="mailto:shaug-cpan@wumpus.org">&lt;shaug-cpan@wumpus.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OE/OEVANS">OEVANS</a><br />

4789. <a href="http://kokogiko.net/">OHTSUKA Ko-hei</a>  <a href="mailto:nene@kokogiko.net">&lt;nene@kokogiko.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOKOGIKO">KOKOGIKO</a><br />
4790. <a href="http://www.shiojiri.ne.jp/%7Ecrouton/">OZAWA Sakuro</a>  <a href="mailto:crouton@po.shiojiri.ne.jp">&lt;crouton@po.shiojiri.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OZ/OZAWA">OZAWA</a><br />
4791. Obiora Embry  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OE/OEMBRY">OEMBRY</a><br />

4792. Octavian Râşniţă  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEDDY">TEDDY</a><br />
4793. <a href="http://www.raz.co.il">Oded S. Resnik</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAZINF">RAZINF</a><br />
4794. Odin Kröger  <a href="mailto:okroeger@cpan.org">&lt;okroeger@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OK/OKROEGER">OKROEGER</a><br />

4795. Odintsov Pavel  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NR/NRG">NRG</a><br />
4796. Ofer Nave  <a href="mailto:ofer@netapt.com">&lt;ofer@netapt.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OD/ODIGITY">ODIGITY</a><br />
4797. Ofer Shaked  <a href="mailto:oferpn@yahoo.com">&lt;oferpn@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OF/OFER">OFER</a><br />

4798. Ofey Aikon  <a href="mailto:ofey.aikon@gmail.com">&lt;ofey.aikon@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OF/OFEYAIKON">OFEYAIKON</a><br />
4799. Ogloblin Eugene  <a href="mailto:ogloblin@mail.ru">&lt;ogloblin@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IG/IGVA">IGVA</a><br />
4800. Oguz Mut  <a href="mailto:mutoguz@gmail.com">&lt;mutoguz@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUTOGUZ">MUTOGUZ</a><br />

4801. <a href="http://home.sinn.ru/~gosha/perl-scripts/">Okunev Igor</a>  <a href="mailto:pause@prv.mts-nn.ru">&lt;pause@prv.mts-nn.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOSHA">GOSHA</a><br />
4802. <a href="http://www.wundercounter.com">Olaf Alders</a>  <a href="mailto:olaf@wundersolutions.com">&lt;olaf@wundersolutions.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OA/OALDERS">OALDERS</a><br />
4803. <a href="http://buwen.de/">Olaf Buwen</a>  <a href="mailto:obulon@localhost">&lt;obulon@localhost&gt;</a> -- OBULON<br />

4804. <a href="http://www.net-dns.org/">Olaf Kolkman</a>  <a href="mailto:olaf@net-dns.org">&lt;olaf@net-dns.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLAF">OLAF</a><br />
4805. <a href="http://www.sixtease.net/">Oldřich Krůza</a>  <a href="mailto:Sixtease+cpan@gmail.com">&lt;Sixtease+cpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIXTEASE">SIXTEASE</a><br />
4806. Ole Petter Ronningen  <a href="mailto:olepr@online.no">&lt;olepr@online.no&gt;</a> -- OLEPR<br />

4807. <a href="www.vanilla.no">Ole Øyvind Hove</a>  <a href="mailto:oleo-cpan@vanilla.no">&lt;oleo-cpan@vanilla.no&gt;</a> -- OLEO<br />
4808. <a href="http://beta.math.spbu.ru/~prof/">Oleg A. Paraschenko</a>  <a href="mailto:olpa@cpan.org">&lt;olpa@cpan.org&gt;</a> -- OLPA<br />
4809. <a href="http://pro.setun.net">Oleg Alexeenkov</a>  <a href="mailto:pro@cpan.org">&lt;pro@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRO">PRO</a><br />

4810. Oleg Kobyakovskiy  <a href="mailto:ok.perl@gmail.com">&lt;ok.perl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLEKO">OLEKO</a><br />
4811. <a href="http://www.lib.tpu.ru/~oleg">Oleg Kolobov</a>  <a href="mailto:oleg@lib.tpu.ru">&lt;oleg@lib.tpu.ru&gt;</a> -- OKOLOBOV<br />
4812. Oleg Prokopyev  <a href="mailto:riiki@cpan.org">&lt;riiki@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIIKI">RIIKI</a><br />

4813. <a href="http://www.linkedin.com/in/sheroleg">Oleg Sher</a>  <a href="mailto:o_apparition@hotmail.com">&lt;o_apparition@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLEGSHER">OLEGSHER</a><br />
4814. Oliver Ebenhöh  <a href="mailto:oliver.ebenhoeh@rz.hu-berlin.de">&lt;oliver.ebenhoeh@rz.hu-berlin.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OX/OXE">OXE</a><br />
4815. <a href="http://linux-kernel.at/">Oliver Falk</a>  <a href="mailto:oliver@linux-kernel.at">&lt;oliver@linux-kernel.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OP/OPITZ">OPITZ</a><br />

4816. <a href="http://www.xshare.com/">Oliver Fischer</a>  <a href="mailto:plexus@snafu.de">&lt;plexus@snafu.de&gt;</a> -- PLEXUS<br />
4817. <a href="http://users.ox.ac.uk/~oliver">Oliver Gorwits</a>  <a href="mailto:oliver.gorwits@oucs.ox.ac.uk">&lt;oliver.gorwits@oucs.ox.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLIVER">OLIVER</a><br />
4818. Oliver M. Kellogg  <a href="mailto:okellogg@users.sourceforge.net">&lt;okellogg@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OM/OMKELLOGG">OMKELLOGG</a><br />

4819. <a href="http://www.42.nu/~oli/">Oliver Maul</a>  <a href="mailto:oli@42.nu">&lt;oli@42.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLIMAUL">OLIMAUL</a><br />
4820. Oliver Meyer  <a href="mailto:">&lt;&gt;</a> -- OLIVERM<br />
4821. <a href="http://www.sourcentral.org/">Oliver Paukstadt</a>  <a href="mailto:cpan@sourcentral.org">&lt;cpan@sourcentral.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSTADT">PSTADT</a><br />

4822. Oliver Steenbuck  <a href="mailto:cpan@hexren.net">&lt;cpan@hexren.net&gt;</a> -- OSTEENBU<br />
4823. <a href="http://www.blibbleblobble.co.uk/">Oliver White</a>  <a href="mailto:perl_questions@blibbleblobble.co.uk">&lt;perl_questions@blibbleblobble.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OW/OWHITE">OWHITE</a><br />
4824. Olivier 'dolmen' Mengué  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOLMEN">DOLMEN</a><br />

4825. Olivier ARCHER  <a href="mailto:olivier.archer@ifremer.fr">&lt;olivier.archer@ifremer.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OA/OARCHER">OARCHER</a><br />
4826. Olivier Bouteille  <a href="mailto:olivier.bouteille@free.fr">&lt;olivier.bouteille@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLIBOU">OLIBOU</a><br />
4827. <a href="olivier.gelux.ch">Olivier Evalet</a>  <a href="mailto:evaleto@gelux.ch">&lt;evaleto@gelux.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EV/EVALETO">EVALETO</a><br />

4828. Olivier Kaloudoff  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- KALOU<br />
4829. Olivier Poitrey  <a href="mailto:rs-pause@rhapsodyk.net">&lt;rs-pause@rhapsodyk.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSOLIV">RSOLIV</a><br />
4830. <a href="http://www.cru.fr">Olivier Salaün</a>  <a href="mailto:os@cru.fr">&lt;os@cru.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OS/OSALAUN">OSALAUN</a><br />

4831. Olivier Schwander  <a href="mailto:iderrick@cpan.org">&lt;iderrick@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/ID/IDERRICK">IDERRICK</a><br />
4832. <a href="http://nanardon.zarb.org">Olivier Thauvin</a>  <a href="mailto:nanardon@nanardon.zarb.org">&lt;nanardon@nanardon.zarb.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NANARDON">NANARDON</a><br />
4833. <a href="http://www.w3.org/People/olivier/">Olivier Thereaux</a>  <a href="mailto:ot@w3.org">&lt;ot@w3.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLIVIERT">OLIVIERT</a><br />

4834. <a href="http://www.endforward.nl">Olle de Zwart</a>  <a href="mailto:olle@endforward.nl">&lt;olle@endforward.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OD/ODEZWART">ODEZWART</a><br />
4835. Ollie Ready  <a href="mailto:cpan@kwaping.com">&lt;cpan@kwaping.com&gt;</a> -- KWAPING<br />
4836. <a href="http://www.oligarchy.co.uk/">Olly Betts</a>  <a href="mailto:olly@survex.com">&lt;olly@survex.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OL/OLLY">OLLY</a><br />

4837. <a href="maximus.spi-net.org/~atg">Ondřej Vostal</a>  <a href="mailto:ondra@elfove.cz">&lt;ondra@elfove.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATG">ATG</a><br />
4838. Onur Aslan  <a href="mailto:onur@cpan.org">&lt;onur@cpan.org&gt;</a> -- ONUR<br />
4839. <a href="http://www.opera.com">Opera Software ASA</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OP/OPERA">OPERA</a><br />

4840. <a href="www.ben-kiki.org/oren">Oren Ben-Kiki</a>  <a href="mailto:oren@ben-kiki.org">&lt;oren@ben-kiki.org&gt;</a> -- ORENBK<br />
4841. <a href="www.codesanity.com">Oren Nachman</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NACHMORE<br />
4842. <a href="http://icecode.com">Orien Vandenbergh</a>  <a href="mailto:perl@icecode.com">&lt;perl@icecode.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OR/ORIEN">ORIEN</a><br />

4843. Orion Montoya  <a href="mailto:orion@diderot.uchicago.edu">&lt;orion@diderot.uchicago.edu&gt;</a> -- ORION<br />
4844. <a href="http://ufal.mff.cuni.cz/~smrz/">Otakar Smrž</a>  <a href="mailto:otakar.smrz@mff.cuni.cz">&lt;otakar.smrz@mff.cuni.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMRZ">SMRZ</a><br />
4845. <a href="http://www.middlebury.edu/~otisg/">Otis Gospodnetic</a>  <a href="mailto:Otis.Gospodnetic@middlebury.edu">&lt;Otis.Gospodnetic@middlebury.edu&gt;</a> -- OTISG<br />

4846. <a href="http://www.cosy.sbg.ac.at/~lendl/">Otmar Lendl</a>  <a href="mailto:lendl@cpan.org">&lt;lendl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LENDL">LENDL</a><br />
4847. Otto Hirr  <a href="mailto:otto.hirr@olabinc.com">&lt;otto.hirr@olabinc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OT/OTTO">OTTO</a><br />
4848. <a href="http://www.zoot.org.uk/">Owen Cliffe</a>  <a href="mailto:zoot@zoot.org.uk">&lt;zoot@zoot.org.uk&gt;</a> -- ZOOT<br />

4849. <a href="http://www.crl.com/~ocrow">Owen Crow</a>  <a href="mailto:ocrow@crl.com">&lt;ocrow@crl.com&gt;</a> -- OCROW<br />
4850. <a href="http://www.delong.com/">Owen DeLong</a>  <a href="mailto:owen@delong.com">&lt;owen@delong.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OW/OWEN">OWEN</a><br />
4851. <a href="http://people.redhat.com/otaylor/">Owen Taylor</a>  <a href="mailto:otaylor@redhat.com">&lt;otaylor@redhat.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OT/OTAYLOR">OTAYLOR</a><br />

4852. P Kent  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PK/PKENT">PKENT</a><br />
4853. P Kent (BBC)  <a href="mailto:">&lt;&gt;</a> -- BBCPKENT<br />
4854. P. Verbaarschott  <a href="mailto:razor_mail@yahoo.com">&lt;razor_mail@yahoo.com&gt;</a> -- WIZEAZZ<br />
4855. <a href="http://poizon.net.ru">P.A. Kuptsov</a>  <a href="mailto:poizon_here@mail.ru">&lt;poizon_here@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AZ/AZJADFTRE">AZJADFTRE</a><br />

4856. <a href="http://www.fecundity.com/">P.D. Magnus</a>  <a href="mailto:pmagnus@fecundity.com">&lt;pmagnus@fecundity.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMAGNUS">PMAGNUS</a><br />
4857. PADMARAJ K.SHANKAR  <a href="mailto:kumar_shankarp@hotmail.com">&lt;kumar_shankarp@hotmail.com&gt;</a> -- RAJKPRI<br />
4858. <a href="http://www.petsmart.com">PETsMART.com</a>  <a href="mailto:anthonyp@petsmart.com">&lt;anthonyp@petsmart.com&gt;</a> -- PSCM<br />

4859. PL  <a href="mailto:codeur_@altern.org">&lt;codeur_@altern.org&gt;</a> -- KOTOTAMA<br />
4860. Pablo Averbuj  <a href="mailto:cpan@vanitude.com">&lt;cpan@vanitude.com&gt;</a> -- PAVERBUJ<br />
4861. Pablo Daniel Cano  <a href="mailto:canpaniel@cpan.org">&lt;canpaniel@cpan.org&gt;</a> -- CANPANIEL<br />
4862. Paddy Newman  <a href="mailto:pnewman@cpan.org">&lt;pnewman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PN/PNEWMAN">PNEWMAN</a><br />

4863. Paige Marie DePol  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EIDOLA<br />
4864. <a href="http://users.forthnet.gr/ath/louridas/">Panagiotis Louridas</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOURIDAS">LOURIDAS</a><br />
4865. Pankaj Agarwal  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GPANKAJ<br />

4866. <a href="http://blog.linosx.com">Pankaj Jain</a>  <a href="mailto:pjain@cpan.org">&lt;pjain@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJAIN">PJAIN</a><br />
4867. Pankaj kumar  <a href="mailto:kumar18@cs.purdue.edu">&lt;kumar18@cs.purdue.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PK/PKUMAR">PKUMAR</a><br />
4868. Panu Ervamaa  <a href="mailto:pnu@cpan.org">&lt;pnu@cpan.org&gt;</a> -- PNU<br />

4869. <a href="www.confor.it">Paolo Gaggia</a>  <a href="mailto:p.gaggia@confor.it">&lt;p.gaggia@confor.it&gt;</a> -- GAGGINO<br />
4870. Paolo Molaro  <a href="mailto:lupus@debian.org">&lt;lupus@debian.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUPUS">LUPUS</a><br />
4871. <a href="http://aigheararch.homeip.net/">Paris Sinclair</a>  <a href="mailto:pariss@efn.org">&lt;pariss@efn.org&gt;</a> -- PSINCLAIR<br />

4872. <a href="http://optimmysql.blogspot.com">Parvesh Garg</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PARVESH<br />
4873. Pascal Fleury  <a href="mailto:fleury@users.sourceforge.net">&lt;fleury@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PF/PFLEURY">PFLEURY</a><br />
4874. Pascal Gloor  <a href="mailto:spale@cpan.org">&lt;spale@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPALE">SPALE</a><br />

4875. <a href="http://rigaux.org/">Pascal Rigaux</a>  <a href="mailto:tmp@rigaux.org">&lt;tmp@rigaux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIXEL">PIXEL</a><br />
4876. Pasha Sadri  <a href="mailto:psadri@yahoo-inc.com">&lt;psadri@yahoo-inc.com&gt;</a> -- PASHA<br />
4877. <a href="http://www.psychogenic.com">Pat Deegan</a>  <a href="mailto:pause@psychogenic.com">&lt;pause@psychogenic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PD/PDEEGAN">PDEEGAN</a><br />

4878. <a href="http://www.dachte.org">Pat Gunn</a>  <a href="mailto:pgunn@dachte.org">&lt;pgunn@dachte.org&gt;</a> -- PGUNN<br />
4879. Pat Martin  <a href="mailto:pat@bronco.advance.com">&lt;pat@bronco.advance.com&gt;</a> -- PATM<br />
4880. <a href="http://pasp.de">Patric Sperling</a>  <a href="mailto:perl@pasp.de">&lt;perl@pasp.de&gt;</a> -- PASP<br />

4881. <a href="http://www.gomor.org/">Patrice Auffret</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOMOR">GOMOR</a><br />
4882. Patrice Freydiere  <a href="mailto:frett@free.fr">&lt;frett@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRETT">FRETT</a><br />
4883. Patrick Bernard  <a href="mailto:perl@kilargo.com">&lt;perl@kilargo.com&gt;</a> -- TRICK<br />

4884. <a href="http://www.wi-bw.tfh-wildau.de/~pboettch/">Patrick Boettcher</a>  <a href="mailto:patrick.boettcher@desy.de">&lt;patrick.boettcher@desy.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBOETTCH">PBOETTCH</a><br />
4885. <a href="http://www.webdav.org/perldav/">Patrick Collins</a>  <a href="mailto:pcollins@cpan.org">&lt;pcollins@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCOLLINS">PCOLLINS</a><br />
4886. Patrick Devine  <a href="mailto:patrick@cpan.org">&lt;patrick@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PATRICK">PATRICK</a><br />

4887. Patrick Devlin  <a href="mailto:pdevlin@cpan.org">&lt;pdevlin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PD/PDEVLIN">PDEVLIN</a><br />
4888. <a href="http://patspam.com">Patrick Donelan</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PDONELAN<br />
4889. <a href="http://grazr.com">Patrick Galbraith</a>  <a href="mailto:patg@patg.net">&lt;patg@patg.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAPTTOFU">CAPTTOFU</a><br />

4890. Patrick Hochstenbach  <a href="mailto:Patrick.Hochstenbach@UGent.be">&lt;Patrick.Hochstenbach@UGent.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOCHSTEN">HOCHSTEN</a><br />
4891. Patrick J. Hennessey  <a href="mailto:spectre at not yet dot come">&lt;spectre at not yet dot come&gt;</a> -- SPECTRE<br />
4892. <a href="http://www.kaeding.name">Patrick Kaeding</a>  <a href="mailto:pkaeding@ccs.neu.edu">&lt;pkaeding@ccs.neu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PK/PKAEDING">PKAEDING</a><br />

4893. Patrick LeBoutillier  <a href="mailto:patl@cpan.org">&lt;patl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PATL">PATL</a><br />
4894. Patrick Mevzek  <a href="mailto:patrick+cpan@patoche.org">&lt;patrick+cpan@patoche.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMEVZEK">PMEVZEK</a><br />
4895. Patrick Michael Kane  <a href="mailto:modus-cpan@pr.es.to">&lt;modus-cpan@pr.es.to&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMKANE">PMKANE</a><br />

4896. <a href="http://solstice.eplt.washington.edu">Patrick Michaud</a>  <a href="mailto:vegitron@gmail.com">&lt;vegitron@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMICHAUD">PMICHAUD</a><br />
4897. Patrick Mulvany  <a href="mailto:paddy@firedrake.org">&lt;paddy@firedrake.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNDERMINE">UNDERMINE</a><br />
4898. Patrick R. Michaud  <a href="mailto:pmichaud@pobox.com">&lt;pmichaud@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMIC">PMIC</a><br />

4899. <a href="http://cpan.org/authors/id/P/PR/PRYAN/">Patrick Ryan</a>  <a href="mailto:perl@pryan.org">&lt;perl@pryan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRYAN">PRYAN</a><br />
4900. Patrick Schoo  <a href="mailto:pschoo@playbeing.com">&lt;pschoo@playbeing.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSCHOO">PSCHOO</a><br />
4901. <a href="http://www.packi.ch">Patrick Stählin</a>  <a href="mailto:packi@cpan.org">&lt;packi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PACKI">PACKI</a><br />

4902. Patrick Tully  <a href="mailto:ptully@avatartechnology.com">&lt;ptully@avatartechnology.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTULLY">PTULLY</a><br />
4903. <a href="http://queequeg.gsu.edu/pwb">Patrick W. Bryant</a>  <a href="mailto:pbryant@gsu.edu">&lt;pbryant@gsu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBRYANT">PBRYANT</a><br />
4904. <a href="http://www.metajournal.net/">Patrick Walton</a>  <a href="mailto:pwalton@metajournal.net">&lt;pwalton@metajournal.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PW/PWALTON">PWALTON</a><br />

4905. <a href="http://www.lsi.upc.es/~lambert">Patrik Lambert</a>  <a href="mailto:lambert@lsi.upc.es">&lt;lambert@lsi.upc.es&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLAMBERT">PLAMBERT</a><br />
4906. <a href="http://www.blipp.com/pawal/">Patrik Wallström</a>  <a href="mailto:pawal@blipp.com">&lt;pawal@blipp.com&gt;</a> -- PAWAL<br />
4907. Patryk Dwórznik  <a href="mailto:dwuziu@bzium.net">&lt;dwuziu@bzium.net&gt;</a> -- DWUZIU<br />

4908. Paul Archer  <a href="mailto:paul@paularcher.org">&lt;paul@paularcher.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PARCHER">PARCHER</a><br />
4909. Paul Arthur  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FL/FLOWERYSO">FLOWERYSO</a><br />
4910. <a href="http://www.csupomona.edu/~henson/">Paul B. Henson</a>  <a href="mailto:henson@acm.org">&lt;henson@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHENSON">PHENSON</a><br />

4911. <a href="http://paulbaker.net/">Paul Baker</a>  <a href="mailto:cpan@paulbaker.net">&lt;cpan@paulbaker.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBAKER">PBAKER</a><br />
4912. <a href="http://glasnost.itcarlow.ie/~barryp/index.html">Paul Barry</a>  <a href="mailto:barrypj@cpan.org">&lt;barrypj@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARRYPJ">BARRYPJ</a><br />
4913. <a href="http://paul.boin.org">Paul Boin</a>  <a href="mailto:paul@boin.org">&lt;paul@boin.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBOIN">PBOIN</a><br />

4914. Paul Boldra  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BOLDRA<br />
4915. Paul Bournival  <a href="mailto:paulb@cajun.nu">&lt;paulb@cajun.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULB">PAULB</a><br />
4916. Paul C Casto  <a href="mailto:castop@hotmailNOSPAM.com">&lt;castop@hotmailNOSPAM.com&gt;</a> -- PCASTO<br />
4917. Paul Cameron  <a href="mailto:cameronpm@gmail.moo.com">&lt;cameronpm@gmail.moo.com&gt;</a> -- PAULC<br />

4918. <a href="http://kemitix.net/">Paul Campbell</a>  <a href="mailto:kemitix@gmail.com">&lt;kemitix@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCAMPBELL">PCAMPBELL</a><br />
4919. Paul Cochrane  <a href="mailto:paultcochrane@gmail.com">&lt;paultcochrane@gmail.com&gt;</a> -- PTC<br />
4920. <a href="http://www.cs.rpi.edu/~lallip/perl/fall05">Paul D. Lalli</a>  <a href="mailto:lallip@cs.rpi.edu">&lt;lallip@cs.rpi.edu&gt;</a> -- LALLIP<br />

4921. <a href="http://jackhammer.org">Paul David Tinsley</a>  <a href="mailto:pdt@jackhammer.org">&lt;pdt@jackhammer.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTINSLEY">PTINSLEY</a><br />
4922. Paul Driver  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FR/FRODWITH">FRODWITH</a><br />
4923. <a href="http://www.leonerd.org.uk">Paul Evans</a>  <a href="mailto:leonerd@leonerd.org.uk">&lt;leonerd@leonerd.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEVANS">PEVANS</a><br />

4924. Paul Franceus  <a href="mailto:paul@raba.com">&lt;paul@raba.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PF/PFRANCEUS">PFRANCEUS</a><br />
4925. <a href="http://perso.enstimac.fr/~gaborit/">Paul Gaborit</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POLGAB">POLGAB</a><br />
4926. <a href="http://tardate.blogspot.com">Paul Gallagher</a>  <a href="mailto:gallagher.paul@gmail.com">&lt;gallagher.paul@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULPG">PAULPG</a><br />

4927. Paul Gampe  <a href="mailto:pgampe@users.sourceforge.net">&lt;pgampe@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULG">PAULG</a><br />
4928. Paul Golds  <a href="mailto:Paul.Golds@GMail.com">&lt;Paul.Golds@GMail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOLT">MOLT</a><br />
4929. Paul Goracke  <a href="mailto:paulg@singlestep.com">&lt;paulg@singlestep.com&gt;</a> -- PGOR<br />

4930. Paul Grinberg  <a href="mailto:gri6507@yahoo.com">&lt;gri6507@yahoo.com&gt;</a> -- GRI<br />
4931. <a href="http://www.isrcomputing.com">Paul Grinberg</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PG/PGRINBERG">PGRINBERG</a><br />
4932. <a href="www.owfs.org">Paul H Alfille</a>  <a href="mailto:paul.alfille@gmail.com">&lt;paul.alfille@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AL/ALFILLE">ALFILLE</a><br />

4933. Paul Harrington  <a href="mailto:phrrngtn@panix.com">&lt;phrrngtn@panix.com&gt;</a> -- PJJH<br />
4934. <a href="http://www.olimpus.com/">Paul Hodel</a>  <a href="mailto:paul@olimpus.com">&lt;paul@olimpus.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HODEL">HODEL</a><br />
4935. <a href="http://hoffmancommapaul.com/">Paul Hoffman</a>  <a href="mailto:nkuitse@cpan.org">&lt;nkuitse@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NK/NKUITSE">NKUITSE</a><br />

4936. Paul J. Brzezinski  <a href="mailto:pinkus@gmail.com">&lt;pinkus@gmail.com&gt;</a> -- HZLNT<br />
4937. <a href="http://homepage.mac.com/pauljlucas/">Paul J. Lucas</a>  <a href="mailto:">&lt;&gt;</a> -- CPJL<br />
4938. <a href="http://pauljacobs.net">Paul Jacobs</a>  <a href="mailto:paul@pauljacobs.net">&lt;paul@pauljacobs.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJACOBS">PJACOBS</a><br />

4939. <a href="http://perltraining.com.au/">Paul Jamieson Fenwick</a>  <a href="mailto:pjf@perltraining.com.au">&lt;pjf@perltraining.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJF">PJF</a><br />
4940. <a href="http://www.pjcj.net">Paul Johnson</a>  <a href="mailto:paul@pjcj.net">&lt;paul@pjcj.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJCJ">PJCJ</a><br />
4941. Paul Johnston  <a href="mailto:pcj@inxar.org">&lt;pcj@inxar.org&gt;</a> -- ICKHABOD<br />

4942. <a href="http://www.soaplite.com/">Paul Kulchenko</a>  <a href="mailto:paulclinger@yahoo.com">&lt;paulclinger@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KULCHENKO">KULCHENKO</a><br />
4943. <a href="http://www.easynet.com.hk/~paul">Paul Lam</a>  <a href="mailto:paul@easynet.com.hk">&lt;paul@easynet.com.hk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULLAM">PAULLAM</a><br />
4944. <a href="http://www.inuus.com/">Paul Lindner</a>  <a href="mailto:plindner@inuus.com">&lt;plindner@inuus.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINDNER">LINDNER</a><br />

4945. <a href="http://www.voltagenoir.org">Paul M. Hirsch</a>  <a href="mailto:pauldoom@cpan.org">&lt;pauldoom@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULDOOM">PAULDOOM</a><br />
4946. <a href="http://paulm.com/">Paul Makepeace</a>  <a href="mailto:pause.perl.org@paulm.com">&lt;pause.perl.org@paulm.com&gt;</a> -- PAULM<br />
4947. Paul Marquess  <a href="mailto:pmqs@cpan.org">&lt;pmqs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMQS">PMQS</a><br />

4948. Paul McGoldrick  <a href="mailto:cpan@perl.zil.la">&lt;cpan@perl.zil.la&gt;</a> -- PMCG<br />
4949. <a href="apfli.sourceforge.net">Paul Meier</a>  <a href="mailto:twix@freakmail.de">&lt;twix@freakmail.de&gt;</a> -- TWIX<br />
4950. <a href="https://voltar.org/PerlModules">Paul Miller</a>  <a href="mailto:jettero@cpan.org">&lt;jettero@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JETTERO">JETTERO</a><br />

4951. <a href="http://husk.org/perl/">Paul Mison</a>  <a href="mailto:cpan@husk.org">&lt;cpan@husk.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMISON">PMISON</a><br />
4952. Paul Moore  <a href="mailto:pf_moore@yahoo.co.uk">&lt;pf_moore@yahoo.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMOORE">PMOORE</a><br />
4953. <a href="http://www.printwhatyouthink.co.uk">Paul Orrock</a>  <a href="mailto:paulo@digitalcraftsmen.net">&lt;paulo@digitalcraftsmen.net&gt;</a> -- PAULO<br />

4954. Paul Prince  <a href="mailto:princep@charter.net">&lt;princep@charter.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TECH">TECH</a><br />
4955. <a href="http://jones.ling.indiana.edu/~prrodrig/">Paul Rodrigues</a>  <a href="mailto:prrodrig@indiana.edu">&lt;prrodrig@indiana.edu&gt;</a> -- PRRODRIG<br />
4956. Paul Ruscher  <a href="mailto:ruscher@met.fsu.edu">&lt;ruscher@met.fsu.edu&gt;</a> -- RUSCHER<br />

4957. Paul Russell  <a href="mailto:parussell+cpan@yahoo.com">&lt;parussell+cpan@yahoo.com&gt;</a> -- PARUSSEL<br />
4958. <a href="http://archpollux.no-ip.org/">Paul Sandulescu</a>  <a href="mailto:pollux@cpan.org">&lt;pollux@cpan.org&gt;</a> -- POLLUX<br />
4959. Paul Schinder  <a href="mailto:schinder@pobox.com">&lt;schinder@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHINDER">SCHINDER</a><br />

4960. <a href="http://www.touchpowder.com/">Paul Schnell</a>  <a href="mailto:pschnell@touchpowder.com">&lt;pschnell@touchpowder.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSCHNELL">PSCHNELL</a><br />
4961. <a href="http://seamons.com/">Paul Seamons</a>  <a href="mailto:perl@seamons.com">&lt;perl@seamons.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHANDOM">RHANDOM</a><br />
4962. Paul Sharpe  <a href="mailto:paul@miraclefish.com">&lt;paul@miraclefish.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSHARPE">PSHARPE</a><br />

4963. <a href="http://zooid.org/~paul">Paul Shields</a>  <a href="mailto:">&lt;&gt;</a> -- SHIELDS<br />
4964. Paul Sisson  <a href="mailto:psisson@cpan.org">&lt;psisson@cpan.org&gt;</a> -- PSISSON<br />
4965. <a href="http://www.cs.cornell.edu/stodghil/">Paul Stodghill</a>  <a href="mailto:stodghil@cs.cornell.edu">&lt;stodghil@cs.cornell.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STODGHIL">STODGHIL</a><br />

4966. <a href="http://branewave.com">Paul Sturm</a>  <a href="mailto:sturm@branewave.com">&lt;sturm@branewave.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STURM">STURM</a><br />
4967. <a href="http://blog.whatfettle.com">Paul Sumner Downey</a>  <a href="mailto:paul.downey@whatfettle.com">&lt;paul.downey@whatfettle.com&gt;</a> -- PSD<br />
4968. Paul Talacko  <a href="mailto:gnuruandstuff@yahoo.co.uk">&lt;gnuruandstuff@yahoo.co.uk&gt;</a> -- PTALACKO<br />

4969. <a href="http://www.timmins.net">Paul Timmins</a>  <a href="mailto:paul@timmins.net">&lt;paul@timmins.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTIMMINS">PTIMMINS</a><br />
4970. Paul Trader  <a href="mailto:fliptop@peacecomputers.com">&lt;fliptop@peacecomputers.com&gt;</a> -- FLIPTOP<br />
4971. <a href="http://www.digitaltrickery.com/">Paul Tweedy</a>  <a href="mailto:paul@digitaltrickery.com">&lt;paul@digitaltrickery.com&gt;</a> -- GRENDELUK<br />

4972. Paul Visscher  <a href="mailto:paulv@cpan.org">&lt;paulv@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAULV">PAULV</a><br />
4973. Paul Walmsley  <a href="mailto:paul-cpan@booyaka.com">&lt;paul-cpan@booyaka.com&gt;</a> -- PAULW<br />
4974. <a href="http://jeune.us/">Paul Wankadia</a>  <a href="mailto:junyer@gmx.net">&lt;junyer@gmx.net&gt;</a> -- JUNYER<br />

4975. <a href="http://www.ex-parrot.com/~pdw/">Paul Warren</a>  <a href="mailto:pdw@ex-parrot.com">&lt;pdw@ex-parrot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PD/PDWARREN">PDWARREN</a><br />
4976. <a href="http://www.probulletin.com">Paul Wilson</a>  <a href="mailto:paul@cpan.org">&lt;paul@cpan.org&gt;</a> -- PAUL<br />
4977. <a href="http://www.pbnj-solutions.com">Paul Winkeler</a>  <a href="mailto:pwinkeler@pbnj-solutions.com">&lt;pwinkeler@pbnj-solutions.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DU/DUTCHMAN">DUTCHMAN</a><br />

4978. Paul van Eldijk  <a href="mailto:rev_1318@hotmail.com">&lt;rev_1318@hotmail.com&gt;</a> -- PAVEL<br />
4979. <a href="http://www.paulavalenca.org">Paula Valenca</a>  <a href="mailto:phantas@cpan.org">&lt;phantas@cpan.org&gt;</a> -- PHANTAS<br />
4980. Paulo Castro  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PECASTRO<br />

4981. Paulo Custodio  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSCUST">PSCUST</a><br />
4982. Paulo Dutra  <a href="mailto:">&lt;&gt;</a> -- BONANZA<br />
4983. <a href="http://davinchi.name">Pavel Boldin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAVINCHI">DAVINCHI</a><br />

4984. <a href="http://www.gingerall.cz/~pavel/index.html">Pavel Hlavnicka</a>  <a href="mailto:cpanuser@seznam.cz">&lt;cpanuser@seznam.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAVELH">PAVELH</a><br />
4985. Pavel Kudinov  <a href="mailto:cpan.pavel@kudinov.name">&lt;cpan.pavel@kudinov.name&gt;</a> -- KUDINOV<br />
4986. Pavel Smirnov  <a href="mailto:huge@ax.ru">&lt;huge@ax.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSMIRNOV">PSMIRNOV</a><br />

4987. Pavel Sokol  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SOKOL<br />
4988. Pavel V. Kaygorodov  <a href="mailto:pasha@inasan.ru">&lt;pasha@inasan.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KP/KPV">KPV</a><br />
4989. Pawan Kumar (पवन कुमार)  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HAWAHAWAI<br />
4990. <a href="http://www.pawelski.org/">Pawel Szymczykowski</a>  <a href="mailto:cpan@makenai.net">&lt;cpan@makenai.net&gt;</a> -- PAWEL<br />

4991. <a href="http://bbkr.org">Paweł (bbkr) Pabian</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBKR">BBKR</a><br />
4992. Paweł Murias  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PMURIAS<br />
4993. Payan Canaran  <a href="mailto:pcanaran@cpan.org">&lt;pcanaran@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCANARAN">PCANARAN</a><br />

4994. <a href="http://peder.at.ifi.uio.no/perl/">Peder Stray</a>  <a href="mailto:pederst@cpan.org">&lt;pederst@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEDERST">PEDERST</a><br />
4995. <a href="http://pedrofigueiredo.org/">Pedro Figueiredo</a>  <a href="mailto:me+pause@pedrofigueiredo.org">&lt;me+pause@pedrofigueiredo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PF/PFIG">PFIG</a><br />
4996. <a href="http://pedro.larroy.com">Pedro Larroy Tovar</a>  <a href="mailto:piotr%takethisout.larroy.com">&lt;piotr%takethisout.larroy.com&gt;</a> -- PIOTR<br />

4997. <a href="http://sweet.ua.pt/~leite/">Pedro Leite</a>  <a href="mailto:leite@ua.pt">&lt;leite@ua.pt&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEITE">LEITE</a><br />
4998. <a href="http://www.simplicidade.org/notes/">Pedro Melo</a>  <a href="mailto:melo@cpan.org">&lt;melo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MELO">MELO</a><br />
4999. <a href="http://perlent.blogspot.com/">Penfold</a>  <a href="mailto:mike@altrion.org">&lt;mike@altrion.org&gt;</a> -- PENFOLD<br />

5000. <a href="http://tomten.kol14.com">Per Bolmstedt</a>  <a href="mailto:tomten@C64.org">&lt;tomten@C64.org&gt;</a> -- TOMTEN<br />
5001. Per Einar Ellefsen  <a href="mailto:pereinar@oslo.online.no">&lt;pereinar@oslo.online.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEREINAR">PEREINAR</a><br />
5002. Per Henrik Johansen  <a href="mailto:per.henrik.johansen@gmail.com">&lt;per.henrik.johansen@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERHENRIK">PERHENRIK</a><br />

5003. <a href="www.reedtz.com">Per Reedtz Thomsen</a>  <a href="mailto:pthomsen@reedtz.com">&lt;pthomsen@reedtz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTHOMSEN">PTHOMSEN</a><br />
5004. Perl XML Community  <a href="mailto:perl-xml-dahut@lists.sourceforge.net">&lt;perl-xml-dahut@lists.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAHUT">DAHUT</a><br />
5005. <a href="http://www.perlchina.org/">PerlChina Team</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PERLCHINA<br />

5006. Peroli Sivaprakasam  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PEROLI<br />
5007. Perrin Harkins  <a href="mailto:perrin@elem.com">&lt;perrin@elem.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERRIN">PERRIN</a><br />
5008. <a href="http://www.petamem.com">PetaMem</a>  <a href="mailto:info#AT#petamem#DOT#com">&lt;info#AT#petamem#DOT#com&gt;</a> -- PETAMEM<br />

5009. Petar Shangov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSHANGOV">PSHANGOV</a><br />
5010. Pete Barlow  <a href="mailto:petebarlow123@hotmail.com">&lt;petebarlow123@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBARLOW">PBARLOW</a><br />
5011. <a href="http://www.yesbutno.com/pete">Pete Berlin</a>  <a href="mailto:pberlin &lt;+&gt; cpan.org">&lt;pberlin &lt;+&gt; cpan.org&gt;</a> -- PBERLIN<br />

5012. <a href="http://absolutbsd.org/">Pete Fritchman</a>  <a href="mailto:petef@absolutbsd.org">&lt;petef@absolutbsd.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETEF">PETEF</a><br />
5013. <a href="http://www.skydancer.org.uk/">Pete Jordan</a>  <a href="mailto:japh@skydancer.org.uk">&lt;japh@skydancer.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJORDAN">PJORDAN</a><br />
5014. <a href="http://www.petekrawczyk.com/">Pete Krawczyk</a>  <a href="mailto:petek@bsod.net">&lt;petek@bsod.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETEK">PETEK</a><br />

5015. <a href="http://scw.us">Pete M. Wilson</a>  <a href="mailto:PMW-Pause@gamewood.net">&lt;PMW-Pause@gamewood.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILSONPM">WILSONPM</a><br />
5016. Pete Ratzlaff  <a href="mailto:pratzlaff@cfa.harvard.edu">&lt;pratzlaff@cfa.harvard.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRATZLAFF">PRATZLAFF</a><br />
5017. Peter A. Bowen  <a href="mailto:peter@bowenfamily.org">&lt;peter@bowenfamily.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBOWEN">PBOWEN</a><br />

5018. <a href="http://peter.boku.net/">Peter A. Eisch</a>  <a href="mailto:peter@boku.net">&lt;peter@boku.net&gt;</a> -- PEISCH<br />
5019. <a href="http://www.stumbler.org/peter.htm">Peter Alvaro</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PALVARO">PALVARO</a><br />
5020. Peter Banik  <a href="mailto:peterzen@cpan.org">&lt;peterzen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERZEN">PETERZEN</a><br />

5021. <a href="http://Y99k.com/">Peter Barabas</a>  <a href="mailto:z0d [@] artifact [.] hu">&lt;z0d [@] artifact [.] hu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BARABAS">BARABAS</a><br />
5022. <a href="http://www.angryox.com/">Peter Beckman</a>  <a href="mailto:beckman@angryox.com">&lt;beckman@angryox.com&gt;</a> -- OOGLEK<br />
5023. Peter Behroozi  <a href="mailto:behroozi@www.pls.uni.edu">&lt;behroozi@www.pls.uni.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BEHROOZI">BEHROOZI</a><br />

5024. <a href="http://www.pjb.com.au/comp">Peter Billam</a>  <a href="mailto:contact.html@pjb.com.au">&lt;contact.html@pjb.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJB">PJB</a><br />
5025. <a href="http://homepages.ihug.com.au/~magorach/">Peter Brown</a>  <a href="mailto:magorach@ihug.com.au">&lt;magorach@ihug.com.au&gt;</a> -- MAGORACH<br />
5026. Peter Chines  <a href="mailto:pchines@gmail.com">&lt;pchines@gmail.com&gt;</a> -- PCHINES<br />

5027. <a href="http://www.retroactive.nu">Peter Clark</a>  <a href="mailto:ninjaz@webexpress.com">&lt;ninjaz@webexpress.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NINJAZ">NINJAZ</a><br />
5028. <a href="http://www.flatline.org.uk/">Peter Clay</a>  <a href="mailto:pete-cpan@flatline.org.uk">&lt;pete-cpan@flatline.org.uk&gt;</a> -- PJC<br />
5029. <a href="http://www.cpandas.org/">Peter Corlett</a>  <a href="mailto:abuse@cabal.org.uk">&lt;abuse@cabal.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOOLI">MOOLI</a><br />

5030. <a href="http://www.dragonstaff.co.uk">Peter Edwards</a>  <a href="mailto:peterdragon@users.sourceforge.net">&lt;peterdragon@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEDWARDS">PEDWARDS</a><br />
5031. <a href="http://grim.ath.cx/">Peter Eichman</a>  <a href="mailto:peichman@chesapeake.net">&lt;peichman@chesapeake.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEICHMAN">PEICHMAN</a><br />
5032. Peter Ernst  <a href="mailto:pernst@cpan.org">&lt;pernst@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PERNST">PERNST</a><br />

5033. <a href="http://tbe.net/~pete/">Peter Farabaugh</a>  <a href="mailto:peter.farabaugh@aris.com">&lt;peter.farabaugh@aris.com&gt;</a> -- PETE<br />
5034. Peter Flanigan  <a href="mailto:Support@RoxSoft.co.uk">&lt;Support@RoxSoft.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJFL">PJFL</a><br />
5035. Peter Forty  <a href="mailto:forty@cpan.org">&lt;forty@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FO/FORTY">FORTY</a><br />

5036. <a href="http://www.zeta.org.au/~peterm">Peter G. Martin</a>  <a href="mailto:peterm@zeta.org.au">&lt;peterm@zeta.org.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PG/PGMART">PGMART</a><br />
5037. <a href="http://www.computerhandlung.de/">Peter Gießner</a>  <a href="mailto:cardb@planet-elektronik.de">&lt;cardb@planet-elektronik.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEGI">PEGI</a><br />
5038. <a href="http://www.castlelink.co.uk/">Peter Goode/Castle Links Ltd</a>  <a href="mailto:peter@castlelink.co.uk">&lt;peter@castlelink.co.uk&gt;</a> -- CASTLE<br />

5039. <a href="www.pg-consultants.com">Peter Gordon</a>  <a href="mailto:peter@pg-consultants.com">&lt;peter@pg-consultants.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERG">PETERG</a><br />
5040. <a href="None at the moment">Peter Guzis</a>  <a href="mailto:pguzis@cpan.org">&lt;pguzis@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PG/PGUZIS">PGUZIS</a><br />
5041. <a href="http://purl.org/net/phli/">Peter H. Li</a>  <a href="mailto:phli@cpan.org">&lt;phli@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHLI">PHLI</a><br />

5042. Peter Hanely  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HA/HANELYP">HANELYP</a><br />
5043. Peter Haworth  <a href="mailto:pmh@edison.ioppublishing.com">&lt;pmh@edison.ioppublishing.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMH">PMH</a><br />
5044. <a href="http://peterhi.dyndns.org/">Peter Hickman</a>  <a href="mailto:peterhi@ntlworld.com">&lt;peterhi@ntlworld.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERHI">PETERHI</a><br />

5045. <a href="http://www.pmade.org">Peter J Jones</a>  <a href="mailto:pjones@cpan.org">&lt;pjones@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJONES">PJONES</a><br />
5046. Peter J. Braam  <a href="mailto:braam@cs.cmu.edu">&lt;braam@cs.cmu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRAAM">BRAAM</a><br />
5047. <a href="http://www.hjp.at/">Peter J. Holzer</a>  <a href="mailto:hjp@hjp.at">&lt;hjp@hjp.at&gt;</a> -- HJP<br />

5048. Peter J. Stewart  <a href="mailto:p.stewart@comcast.net">&lt;p.stewart@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSTEWART">PSTEWART</a><br />
5049. Peter Jaquiery  <a href="mailto:grandpa@cpan.org">&lt;grandpa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRANDPA">GRANDPA</a><br />
5050. Peter Jirak  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PJIRAK<br />

5051. <a href="http://home.online.no/~pjacklam">Peter John Acklam</a>  <a href="mailto:pjacklam@online.no">&lt;pjacklam@online.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJACKLAM">PJACKLAM</a><br />
5052. Peter John Edwards  <a href="mailto:cpan@pjedwards.co.uk">&lt;cpan@pjedwards.co.uk&gt;</a> -- STIGPJE<br />
5053. Peter Joseph Speltz  <a href="mailto:peterspeltz@cafes.net">&lt;peterspeltz@cafes.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSPELTZ">PSPELTZ</a><br />

5054. <a href="http://peknet.com/">Peter Karman</a>  <a href="mailto:perl@peknet.com">&lt;perl@peknet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KA/KARMAN">KARMAN</a><br />
5055. Peter Kioko  <a href="mailto:peterkioko@bigfoot.com">&lt;peterkioko@bigfoot.com&gt;</a> -- KIOKO<br />
5056. <a href="http://www.peterknowles.com">Peter Knowles</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PKNOWLES<br />

5057. <a href="http://zditr1.arcs.ac.at/~peter">Peter Kutschera</a>  <a href="mailto:peter@zditr1.arcs.ac.at">&lt;peter@zditr1.arcs.ac.at&gt;</a> -- PKUTS<br />
5058. Peter Kwan  <a href="mailto:pkwan@advsofteng.com">&lt;pkwan@advsofteng.com&gt;</a> -- PKWAN<br />
5059. <a href="http://www.berghold.net">Peter L. Berghold</a>  <a href="mailto:Peter@Berghold.Net">&lt;Peter@Berghold.Net&gt;</a> -- COWDAWG<br />

5060. Peter Lamberg  <a href="mailto:p-pause@lodju.dyndns.org">&lt;p-pause@lodju.dyndns.org&gt;</a> -- PELAM<br />
5061. Peter Liscovius  <a href="mailto:peterdd@users.sourceforge.net">&lt;peterdd@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LISCOVIUS">LISCOVIUS</a><br />
5062. Peter Lister  <a href="mailto:p.lister@cranfield.ac.uk">&lt;p.lister@cranfield.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLISTER">PLISTER</a><br />

5063. <a href="http://www.plusplus.com.au">Peter Lovett</a>  <a href="mailto:">&lt;&gt;</a> -- PETERL<br />
5064. <a href="www.bluecampaigns.com">Peter Lytle</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PLYTLE<br />
5065. Peter Mains  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PMAINS<br />

5066. <a href="http://peter.makholm.net">Peter Makholm</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMAKHOLM">PMAKHOLM</a><br />
5067. <a href="http://www.phase-one.com.au/">Peter Marelas</a>  <a href="mailto:maral@phase-one.com.au">&lt;maral@phase-one.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARAL">MARAL</a><br />
5068. <a href="http://www.openphase.com">Peter Marshall</a>  <a href="mailto:mitd@mitd.com">&lt;mitd@mitd.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERM">PETERM</a><br />

5069. <a href="http://www.pmcdermott.com/">Peter McDermott</a>  <a href="mailto:peter@pmcdermott.com">&lt;peter@pmcdermott.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERMCD">PETERMCD</a><br />
5070. <a href="http://peter.michaux.ca">Peter Michaux</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMICHAUX">PMICHAUX</a><br />
5071. <a href="http://www.cwru.edu/home/pem.html">Peter Murray</a>  <a href="mailto:pem@po.cwru.edu">&lt;pem@po.cwru.edu&gt;</a> -- PEM<br />

5072. <a href="http://www.mavit.org.uk">Peter Oliver</a>  <a href="mailto:cpan.org@mavit.org.uk">&lt;cpan.org@mavit.org.uk&gt;</a> -- MAVIT<br />
5073. Peter Paris  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUTETIUS">LUTETIUS</a><br />
5074. <a href="http://www.ringlet.net/~roam/">Peter Pentchev</a>  <a href="mailto:roam@ringlet.net">&lt;roam@ringlet.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROAM">ROAM</a><br />

5075. <a href="http://www.technomat.hu/">Peter Popovics</a>  <a href="mailto:pop@technomat.hu">&lt;pop@technomat.hu&gt;</a> -- OSTRICH<br />
5076. <a href="http://www.best.com/~pvhp/">Peter Prymmer</a>  <a href="mailto:pvhp@best.com">&lt;pvhp@best.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PV/PVHP">PVHP</a><br />
5077. Peter Rabbitson  <a href="mailto:devel@rabbit.us">&lt;devel@rabbit.us&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIBASUSHI">RIBASUSHI</a><br />

5078. Peter Reif  <a href="mailto:peter.reif@wien.gv.at">&lt;peter.reif@wien.gv.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERGAL">PETERGAL</a><br />
5079. <a href="http://www.datahedron.com/">Peter Rowell</a>  <a href="mailto:pause@p1.spammenot.org">&lt;pause@p1.spammenot.org&gt;</a> -- PROWELL<br />
5080. Peter S. Housel  <a href="mailto:housel@acm.org">&lt;housel@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOUSEL">HOUSEL</a><br />

5081. <a href="http://www.connix.com/~psantoro">Peter Santoro</a>  <a href="mailto:peter@pscomp.com">&lt;peter@pscomp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSANTORO">PSANTORO</a><br />
5082. <a href="http://www.psdt.com/">Peter Scott</a>  <a href="mailto:pjs@cpan.org">&lt;pjs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PJ/PJS">PJS</a><br />
5083. <a href="http://www.organic.com/Staff/seibel/">Peter Seibel</a>  <a href="mailto:seibel@organic.com">&lt;seibel@organic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSEIBEL">PSEIBEL</a><br />

5084. <a href="http://grou.ch">Peter Sergeant</a>  <a href="mailto:cpan@clueball.com">&lt;cpan@clueball.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SARGIE">SARGIE</a><br />
5085. Peter Sinnott  <a href="mailto:link@redbrick.dcu.ie">&lt;link@redbrick.dcu.ie&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSINNOTT">PSINNOTT</a><br />
5086. Peter Somu  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SOMUP<br />

5087. <a href="http://peterstuifzand.nl">Peter Stuifzand</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STUIFZAND">STUIFZAND</a><br />
5088. <a href="http://tandlers.de/peter/">Peter Tandler</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTANDLER">PTANDLER</a><br />
5089. Peter Thatcher  <a href="mailto:peterthatcher@yahoo.com">&lt;peterthatcher@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETER">PETER</a><br />

5090. Peter Tillemans  <a href="mailto:pti@pandora.be">&lt;pti@pandora.be&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTILL">PTILL</a><br />
5091. <a href="http://timofejew.com/">Peter Timofejew</a>  <a href="mailto:peter@timofejew.com">&lt;peter@timofejew.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTIMOF">PTIMOF</a><br />
5092. Peter Tschipper  <a href="mailto:blueskies@entirety.ca">&lt;blueskies@entirety.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPIRITSKY">SPIRITSKY</a><br />

5093. <a href="http://netreg.org">Peter Valian</a>  <a href="mailto:valianp@gmail.com">&lt;valianp@gmail.com&gt;</a> -- VALIANP<br />
5094. <a href="http://vereshagin.org">Peter Vereshagin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VE/VERESC">VERESC</a><br />
5095. <a href="http://pwo.de/">Peter W. Osel</a>  <a href="mailto:pwo@guug.de">&lt;pwo@guug.de&gt;</a> -- PWO<br />

5096. <a href="http://www.spacefuture.com/">Peter Wainwright</a>  <a href="mailto:peter@cybrid.net">&lt;peter@cybrid.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PETERW">PETERW</a><br />
5097. <a href="http://www.axomic.com">Peter Walsham</a>  <a href="mailto:peter@axomic.com">&lt;peter@axomic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WALSHAM">WALSHAM</a><br />
5098. Peter Weatherdon  <a href="mailto:peterw@cdnorthamerica.com">&lt;peterw@cdnorthamerica.com&gt;</a> -- PETERWN<br />

5099. Peter Wirdemo  <a href="mailto:peter_wirdemo@hotmail.com">&lt;peter_wirdemo@hotmail.com&gt;</a> -- PWIRDEMO<br />
5100. <a href="http://www.vagnerr.com/">Peter Wise</a>  <a href="mailto:cpan@vagnerr.com">&lt;cpan@vagnerr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VA/VAGNERR">VAGNERR</a><br />
5101. <a href="http://sitetechie.com">Peter de Vos</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SITETECH<br />

5102. <a href="http://www.catonmat.net">Peteris Krumins</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PKRUMINS<br />
5103. Petr  <a href="mailto:petr.smejkal@seznam.cz">&lt;petr.smejkal@seznam.cz&gt;</a> -- PSMEJKAL<br />
5104. <a href="http://pasky.or.cz/">Petr Baudis</a>  <a href="mailto:pasky@ucw.cz">&lt;pasky@ucw.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PASKY">PASKY</a><br />

5105. <a href="http://www.gingerall.com/">Petr Cimprich</a>  <a href="mailto:petr@gingerall.cz">&lt;petr@gingerall.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCIMPRICH">PCIMPRICH</a><br />
5106. <a href="http://www.kubanek.net/">Petr Kubanek</a>  <a href="mailto:petr@kubanek.net">&lt;petr@kubanek.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PK/PKUBANEK">PKUBANEK</a><br />
5107. <a href="http://ufal.mff.cuni.cz/pajas">Petr Pajas</a>  <a href="mailto:pajas@matfyz.cz">&lt;pajas@matfyz.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAJAS">PAJAS</a><br />

5108. <a href="http://www.suteren.net">Petr Vraník</a>  <a href="mailto:hpa@suteren.net">&lt;hpa@suteren.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HP/HPA">HPA</a><br />
5109. Petr Šmejkal  <a href="mailto:petr.smejkal@seznam.cz">&lt;petr.smejkal@seznam.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PS/PSME">PSME</a><br />
5110. <a href="http://moxliukas.esu.as">Petras Kudaras</a>  <a href="mailto:moxliukas@delfi.lt">&lt;moxliukas@delfi.lt&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KUDARASP">KUDARASP</a><br />

5111. <a href="http://code.google.com/p/perlhobby/">Petrea Corneliu Stefan</a>  <a href="mailto:dark_woodss@yahoo.com">&lt;dark_woodss@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WS/WSDOOKADR">WSDOOKADR</a><br />
5112. <a href="http://bubblehouse.org">Phil Christensen</a>  <a href="mailto:pchriste@cpan.org">&lt;pchriste@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCHRISTE">PCHRISTE</a><br />
5113. Phil Hadley  <a href="mailto:phil_hadley@yahoo.com">&lt;phil_hadley@yahoo.com&gt;</a> -- PHADLEY<br />

5114. <a href="http://owl.phy.queensu.ca/~phil/exiftool/">Phil Harvey</a>  <a href="mailto:phil at owl.phy.queensu.ca">&lt;phil at owl.phy.queensu.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EX/EXIFTOOL">EXIFTOOL</a><br />
5115. <a href="http://www.perkpartners.com/~phil/">Phil Lobbes</a>  <a href="mailto:phil at perkpartners dot com">&lt;phil at perkpartners dot com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PL/PLOBBES">PLOBBES</a><br />
5116. <a href="http://www.massyn.net">Phil Massyn</a>  <a href="mailto:massyn@gmail.com">&lt;massyn@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MASSYN">MASSYN</a><br />

5117. Phil Middleton  <a href="mailto:ninjas.are.really.really.cool@wow.com">&lt;ninjas.are.really.really.cool@wow.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIDDLETO">MIDDLETO</a><br />
5118. Phil Mitchell  <a href="mailto:philip_not_this_part@hulmail.harvard.edu">&lt;philip_not_this_part@hulmail.harvard.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILMI">PHILMI</a><br />
5119. <a href="http://www.linkedin.com/in/prlawrence">Phil R Lawrence</a>  <a href="mailto:prl ~AT~ cpan ~DOT~ org">&lt;prl ~AT~ cpan ~DOT~ org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRL">PRL</a><br />

5120. <a href="http://www.mrflip.com/">Philip (Flip) Kromer</a>  <a href="mailto:flipATmrflip.com">&lt;flipATmrflip.com&gt;</a> -- FLIP<br />
5121. <a href="http://www.mobilemaps.com">Philip Abrahamson</a>  <a href="mailto:philip.abrahamson.REMOVE_TO_SEND@mobilemaps.com">&lt;philip.abrahamson.REMOVE_TO_SEND@mobilemaps.com&gt;</a> -- PJA<br />
5122. <a href="http://www.parallax.co.uk/~philipa">Philip Aston</a>  <a href="mailto:philipa@parallax.co.uk">&lt;philipa@parallax.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILIPA">PHILIPA</a><br />

5123. Philip Collins  <a href="mailto:collins_p@yahoo.com">&lt;collins_p@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMC">PMC</a><br />
5124. Philip Crow  <a href="mailto:crow.phil@gmail.com">&lt;crow.phil@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILCROW">PHILCROW</a><br />
5125. Philip Dye  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PHDYE<br />

5126. Philip Garrett  <a href="mailto:cpan@pgarrett.net">&lt;cpan@pgarrett.net&gt;</a> -- PHILIP<br />
5127. Philip Guenther  <a href="mailto:guenther+cpan@sendmail.com">&lt;guenther+cpan@sendmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PG/PGUEN">PGUEN</a><br />
5128. Philip Gwyn  <a href="mailto:perl@pied.nu">&lt;perl@pied.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GW/GWYN">GWYN</a><br />

5129. <a href="http://line-ed.sourceforge.net">Philip Hazelden</a>  <a href="mailto:weirdofreak@gmail.com">&lt;weirdofreak@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILIPH">PHILIPH</a><br />
5130. <a href="http://p6m7g8.net">Philip M. Gollucci</a>  <a href="mailto:pgollucci@p6m7g8.com">&lt;pgollucci@p6m7g8.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PG/PGOLLUCCI">PGOLLUCCI</a><br />
5131. Philip Mak  <a href="mailto:pmak@aaanime.net">&lt;pmak@aaanime.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMAK">PMAK</a><br />

5132. <a href="http://mikal.org">Philip Mikal</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILIPM">PHILIPM</a><br />
5133. Philip Monsen  <a href="mailto:philip.monsen@gmail.com">&lt;philip.monsen@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICERIDER">ICERIDER</a><br />
5134. <a href="http://pne.livejournal.com/">Philip Newton</a>  <a href="mailto:pne@cpan.org">&lt;pne@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PN/PNE">PNE</a><br />

5135. Philip Putnam  <a href="mailto:drew@camelsoup.com">&lt;drew@camelsoup.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PP/PPUTNAM">PPUTNAM</a><br />
5136. Philip R Brenan  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRBRENAN">PRBRENAN</a><br />
5137. <a href="http://www.stoev.org">Philip Stoev</a>  <a href="mailto:philip@stoev.org">&lt;philip@stoev.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILIPS">PHILIPS</a><br />

5138. Philip W. Dalrymple III  <a href="mailto:pwd@mdtsoft.com">&lt;pwd@mdtsoft.com&gt;</a> -- PWD<br />
5139. Philipp Friedrich  <a href="mailto:philipp@void.at">&lt;philipp@void.at&gt;</a> -- PHF<br />
5140. <a href="http://www.futureware.at/">Philipp Gühring</a>  <a href="mailto:pg@futureware.at">&lt;pg@futureware.at&gt;</a> -- SOURCERER<br />

5141. <a href="hagbard.isa-geek.org">Philipp Hackbarth</a>  <a href="mailto:hagbard@t-online.de">&lt;hagbard@t-online.de&gt;</a> -- HAGBARD<br />
5142. <a href="http://www.beyondcode.org">Philipp K. Janert</a>  <a href="mailto:perl at beyondcode dot org">&lt;perl at beyondcode dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANERT">JANERT</a><br />
5143. Philipp Marek  <a href="mailto:philipp.pause@marek.priv.at">&lt;philipp.pause@marek.priv.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PM/PMAREK">PMAREK</a><br />

5144. <a href="http://www.bruhat.net/">Philippe Bruhat (BooK)</a>  <a href="mailto:book@cpan.org">&lt;book@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOOK">BOOK</a><br />
5145. <a href="http://www.oceanes.fr/~database/isampm.htm">Philippe Chane You Kaye</a>  <a href="mailto:philippe.cyk@wanadoo.fr">&lt;philippe.cyk@wanadoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CY/CYK">CYK</a><br />
5146. <a href="http://nothing94.250x.com">Philippe Cote</a>  <a href="mailto:philippe.cote@usherbrooke.ca">&lt;philippe.cote@usherbrooke.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHCOTE">PHCOTE</a><br />

5147. Philippe Froidevaux  <a href="mailto:miles@users.sourceforge.net">&lt;miles@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MILES">MILES</a><br />
5148. <a href="http://gozer.ectoplasm.org/">Philippe M. Chiasson</a>  <a href="mailto:gozer@cpan.org">&lt;gozer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOZER">GOZER</a><br />
5149. Philippe Marguinaud  <a href="mailto:pmarguinaud@hotmail.com">&lt;pmarguinaud@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHILOU">PHILOU</a><br />

5150. Philippe Verdret  <a href="mailto:pverdret@caramail.com">&lt;pverdret@caramail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PV/PVERD">PVERD</a><br />
5151. Phill Wolf  <a href="mailto:pbwolf@cpan.org">&lt;pbwolf@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PB/PBWOLF">PBWOLF</a><br />
5152. Phillip D Cawhorn  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CAWHORNPD<br />

5153. Phillip Moore  <a href="mailto:pmoore6448@gmail.com">&lt;pmoore6448@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WP/WPMOORE">WPMOORE</a><br />
5154. <a href="http://www.crescendo.net/~phil/">Phillip Pollard</a>  <a href="mailto:bennie@cpan.org">&lt;bennie@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BENNIE">BENNIE</a><br />
5155. <a href="http://www.TZoNE.ORG/~vandry/">Phillip Vandry</a>  <a href="mailto:vandry@TZoNE.ORG">&lt;vandry@TZoNE.ORG&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PV/PVANDRY">PVANDRY</a><br />

5156. Pier Hegeman  <a href="mailto:pier_hegeman@yahoo.co.jp">&lt;pier_hegeman@yahoo.co.jp&gt;</a> -- HEGEMANP<br />
5157. Pierre Denis  <a href="mailto:pierre@itrelease.net">&lt;pierre@itrelease.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PD/PDENIS">PDENIS</a><br />
5158. <a href="http://www.edd.fr">Pierre Lazard</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PLAZARD<br />

5159. Pierre Marchal  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PIERRE<br />
5160. Pierre Neyron  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NPF<br />
5161. Pierre Smolarek  <a href="mailto:smolarek@cpan.org">&lt;smolarek@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMOLAREK">SMOLAREK</a><br />
5162. <a href="http://arcanes.fr.eu.org/~pierre/moi/">Pierre Thierry</a>  <a href="mailto:nowhere.man@levallois.eu.org">&lt;nowhere.man@levallois.eu.org&gt;</a> -- MOINEFOU<br />

5163. <a href="http://le-gall.net/pierrick">Pierrick LE GALL</a>  <a href="mailto:pierrick_trash@le-gall.net">&lt;pierrick_trash@le-gall.net&gt;</a> -- PLEGALL<br />
5164. Piers Cawley  <a href="mailto:pdcawley@bofh.org.uk">&lt;pdcawley@bofh.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PD/PDCAWLEY">PDCAWLEY</a><br />
5165. <a href="http://www.piersharding.com">Piers Harding</a>  <a href="mailto:piers at cpan dot org">&lt;piers at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIERS">PIERS</a><br />

5166. <a href="http://www.geocities.com/ping07642/">Ping Liang</a>  <a href="mailto:ping07642@netscape.net">&lt;ping07642@netscape.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PING">PING</a><br />
5167. Piotr Czarny  <a href="mailto:picz@sifira.dk">&lt;picz@sifira.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PICZ">PICZ</a><br />
5168. Piotr Fusik  <a href="mailto:fox@scene.pl">&lt;fox@scene.pl&gt;</a> -- PFUSIK<br />

5169. <a href="http://www.gbshouse.com">Piotr Ginalski</a>  <a href="mailto:office@gbshouse.com">&lt;office@gbshouse.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GB/GBSHOUSE">GBSHOUSE</a><br />
5170. <a href="www.piotrkaluski.com">Piotr Kaluski</a>  <a href="mailto:pkaluski@piotrkaluski.com">&lt;pkaluski@piotrkaluski.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PK/PKALUSKI">PKALUSKI</a><br />
5171. <a href="http://www.klaban.torun.pl">Piotr Klaban</a>  <a href="mailto:makler@man.torun.pl">&lt;makler@man.torun.pl&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAKLER">MAKLER</a><br />

5172. <a href="http://people.debian.org/~dexter/perl/">Piotr Roszatycki</a>  <a href="mailto:piotr.roszatycki@gmail.com">&lt;piotr.roszatycki@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DEXTER">DEXTER</a><br />
5173. Pip Stuart  <a href="mailto:Pip@CPAN.Org">&lt;Pip@CPAN.Org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PI/PIP">PIP</a><br />
5174. <a href="http://www.inforders.com">Plamen Nenov</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PNENOV<br />

5175. PlatformISV  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LS/LSFISV">LSFISV</a><br />
5176. <a href="http://www.edepot.com/phl.html">Po-Han Lin</a>  <a href="mailto:pohanl@yahoo.com">&lt;pohanl@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PO/POHANL">POHANL</a><br />
5177. Prakash Kailasa  <a href="mailto:pk-cpan@kailasa.net">&lt;pk-cpan@kailasa.net&gt;</a> -- PRAKASH<br />

5178. Prasad J.P.  <a href="mailto:jp_prasads@excite.com">&lt;jp_prasads@excite.com&gt;</a> -- PRASADJP<br />
5179. Prasad Poruporuthan  <a href="mailto:prasad@cpan.org">&lt;prasad@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRASAD">PRASAD</a><br />
5180. Prasad Ullal  <a href="mailto:prasad.ullal@iit.edu">&lt;prasad.ullal@iit.edu&gt;</a> -- ULLAPRA<br />
5181. Prasanna Kumaravel  <a href="mailto:kprasanna79@gmail.com">&lt;kprasanna79@gmail.com&gt;</a> -- PRASANNAK<br />

5182. Prashant Shewale  <a href="mailto:pvshewale@gmail.com">&lt;pvshewale@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRASHANT">PRASHANT</a><br />
5183. <a href="http://everest.eng.ohio-state.edu/~pereira/">Pratap Pereira</a>  <a href="mailto:pereira@ee.eng.ohio-state.edu">&lt;pereira@ee.eng.ohio-state.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRATP">PRATP</a><br />
5184. <a href="http://www.d.umn.edu/~rave0029/">Pratheepan Raveendranathan</a>  <a href="mailto:rave0029@d.umn.edu">&lt;rave0029@d.umn.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRATH">PRATH</a><br />

5185. <a href="http://www.qiksearch.com/">Premshree Pillai</a>  <a href="mailto:jsfx@rediffmail.com">&lt;jsfx@rediffmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PREMSHREE">PREMSHREE</a><br />
5186. Presley H. Cannady  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- REVPREZ<br />
5187. <a href="http://bannister.us/">Preston L. Bannister</a>  <a href="mailto:preston@bannister.us">&lt;preston@bannister.us&gt;</a> -- PRESTON<br />

5188. Priezt  <a href="mailto:priezt@sohu.com">&lt;priezt@sohu.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PRIEZT">PRIEZT</a><br />
5189. <a href="http://www.stiqs.org">Pritchard Musonda</a>  <a href="mailto:stiqs@blackhills.net">&lt;stiqs@blackhills.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STIQS">STIQS</a><br />
5190. <a href="http://profrequency.com">Pro ƒrequency</a>  <a href="mailto:support@profrequency.com">&lt;support@profrequency.com&gt;</a> -- JEROMEMCK<br />

5191. <a href="http://www.profero.com/">Profero Ltd.</a>  <a href="mailto:cpan@profero.com">&lt;cpan@profero.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PR/PROFERO">PROFERO</a><br />
5192. Pronichev Alexander  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DYKER<br />
5193. Przemek Czerkas  <a href="mailto:pczerkas@gmail.com">&lt;pczerkas@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PC/PCZERKAS">PCZERKAS</a><br />

5194. Przemysław Wesołek  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PW/PWES">PWES</a><br />
5195. <a href="http://www.pythian.com">Pythian Remote DBA</a>  <a href="mailto:pause-at-pythian.com">&lt;pause-at-pythian.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PY/PYTHIAN">PYTHIAN</a><br />
5196. Pásztor György  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GYU<br />

5197. Pål Rune Sørensen Tuv  <a href="mailto:paal@cpan.org">&lt;paal@cpan.org&gt;</a> -- PAAL<br />
5198. <a href="http://www.inf.bme.hu/~pts/">Péter Szabó</a>  <a href="mailto:pts@fazekas.hu">&lt;pts@fazekas.hu&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PT/PTS">PTS</a><br />
5199. Qiang Li  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- QIANGLI<br />

5200. Qing-Jie Zhou  <a href="mailto:qjzhou@hotmail.com">&lt;qjzhou@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QJ/QJZHOU">QJZHOU</a><br />
5201. Quanah Gibson-Mount  <a href="mailto:mishikal@yahoo.com">&lt;mishikal@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MISHIKAL">MISHIKAL</a><br />
5202. <a href="http://fairpath.com/">Quinn Weaver</a>  <a href="mailto:quinn@fairpath.com">&lt;quinn@fairpath.com&gt;</a> -- QUINN<br />

5203. <a href="http://bernard.gondwana.com.au">R Bernard Davison</a>  <a href="mailto:rbdavison@cpan.org">&lt;rbdavison@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBDAVISON">RBDAVISON</a><br />
5204. <a href="http://users.marshall.edu/~bailey9/">R. Andrew Bailey</a>  <a href="mailto:bailey9@marshall.edu">&lt;bailey9@marshall.edu&gt;</a> -- RAAB<br />
5205. <a href="http://www.PlatypiVentures.com/">R. Geoffrey Avery</a>  <a href="mailto:rGeoffrey@PlatypiVentures.com">&lt;rGeoffrey@PlatypiVentures.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGEOFFREY">RGEOFFREY</a><br />

5206. R. Kyle Murphy  <a href="mailto:orclev@gmail.com">&lt;orclev@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OR/ORCLEV">ORCLEV</a><br />
5207. <a href="http://owen.sj.ca.us/rkowen/indexF.html">R.K. Owen</a>  <a href="mailto:rkowen@cpan.org">&lt;rkowen@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKOWEN">RKOWEN</a><br />
5208. RAVI SASTRY KADALI  <a href="mailto:ravisastryk@gmail.com">&lt;ravisastryk@gmail.com&gt;</a> -- RAKADALI<br />

5209. <a href="http://mtl.recruit.co.jp/">RECRUIT Media Technology Labs</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MT/MTL">MTL</a><br />
5210. <a href="http://www.ripe.net">RIPE NCC</a>  <a href="mailto:swbugs@ripe.net">&lt;swbugs@ripe.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIPENCC">RIPENCC</a><br />
5211. <a href="http://www.wuxtry.com">Rachel McGregor Rawlings</a>  <a href="mailto:rachel@wuxtry.com">&lt;rachel@wuxtry.com&gt;</a> -- RRAWLINGS<br />

5212. <a href="http://rachel.nmcfarl.org">Rachel Richard</a>  <a href="mailto:rachel@nmcfarl.org">&lt;rachel@nmcfarl.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RACHEL">RACHEL</a><br />
5213. <a href="http://radiantmatrix.org/">RadiantMatrix</a>  <a href="mailto:">&lt;&gt;</a> -- RADIANT<br />
5214. Radoslav Nedyalkov  <a href="mailto:rnedyalkov@gmail.com">&lt;rnedyalkov@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RADOS">RADOS</a><br />

5215. Radosław Pociecha  <a href="mailto:radoslaw.pociecha@gmail.com">&lt;radoslaw.pociecha@gmail.com&gt;</a> -- RADPOC<br />
5216. <a href="http://radek.cc/">Radosław Zieliński</a>  <a href="mailto:radek@pld-linux.org">&lt;radek@pld-linux.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RADEK">RADEK</a><br />
5217. Rafael Corvalan  <a href="mailto:">&lt;&gt;</a> -- RCORVALAN<br />

5218. Rafael Kaufmann  <a href="mailto:rnedal@olimpo.com.br">&lt;rnedal@olimpo.com.br&gt;</a> -- KAUFMANN<br />
5219. Rafael Kitover  <a href="mailto:rkitover@io.com">&lt;rkitover@io.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKITOVER">RKITOVER</a><br />
5220. Rafael Martinez Torres  <a href="mailto:rafael.martinez@novagnet.com">&lt;rafael.martinez@novagnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MONDEJAR">MONDEJAR</a><br />

5221. Rafael R. Sevilla  <a href="mailto:sevillar@team.ph.inter.net">&lt;sevillar@team.ph.inter.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIDO">DIDO</a><br />
5222. <a href="http://consttype.org/">Rafaël Garcia-Suarez</a>  <a href="mailto:rgarciasuarez@gmail.com">&lt;rgarciasuarez@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGARCIA">RGARCIA</a><br />
5223. Rafał Pocztarski  <a href="mailto:rfl@cpan.org">&lt;rfl@cpan.org&gt;</a> -- RFL<br />

5224. Ragavendar Swamisai  <a href="mailto:surag_780@yahoo.com">&lt;surag_780@yahoo.com&gt;</a> -- RAGA<br />
5225. Raghuram Pranadarthy Haran  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RAGHURAM<br />
5226. <a href="http://pandur.org/">Rainer Jung</a>  <a href="mailto:rj.cpan@gmail.com">&lt;rj.cpan@gmail.com&gt;</a> -- RJUNG<br />

5227. Rainer Weikusat  <a href="mailto:rainer.weikusat@sncag.com">&lt;rainer.weikusat@sncag.com&gt;</a> -- RWKST<br />
5228. Raino Pikkarainen  <a href="mailto:raino.pikkarainen@saunalahti.fi">&lt;raino.pikkarainen@saunalahti.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPIKKARA">RPIKKARA</a><br />
5229. Rajappa Iyer  <a href="mailto:rsi@earthling.net">&lt;rsi@earthling.net&gt;</a> -- RSI<br />
5230. Rajendra Gokhale  <a href="mailto:pause@creato.org">&lt;pause@creato.org&gt;</a> -- RVGOKHALE<br />

5231. <a href="http://www.dsmit.com/perl">Rajesh Vaidheeswarran</a>  <a href="mailto:rv@gnu.org">&lt;rv@gnu.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVAIDH">RVAIDH</a><br />
5232. <a href="http://www.rajiv.org/">Rajiv Pant</a>  <a href="mailto:betul@rajiv.org">&lt;betul@rajiv.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BETUL">BETUL</a><br />
5233. <a href="http://geocities.com/rkjism">Rajkumar Jain</a>  <a href="mailto:rkjism@yahoo.com">&lt;rkjism@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKJISM">RKJISM</a><br />

5234. Rakesh Alex  <a href="mailto:rakesh.alex@gmail.com">&lt;rakesh.alex@gmail.com&gt;</a> -- RAKESH<br />
5235. Rakesh Kumar Shardiwal  <a href="mailto:rakesh.shardiwal@gmail.com">&lt;rakesh.shardiwal@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHARDIWAL">SHARDIWAL</a><br />
5236. <a href="www.rengels.de">Ralf Engels</a>  <a href="mailto:ralf-engels@gmx.de">&lt;ralf-engels@gmx.de&gt;</a> -- ENGELS<br />

5237. <a href="http://www.engelschall.com/">Ralf S. Engelschall</a>  <a href="mailto:rse@engelschall.com">&lt;rse@engelschall.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSE">RSE</a><br />
5238. Ralph Grothe  <a href="mailto:ragro@cpan.org">&lt;ragro@cpan.org&gt;</a> -- RAGRO<br />
5239. Ralph Padron  <a href="mailto:whoelse@elitedigital.net">&lt;whoelse@elitedigital.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHOELSE">WHOELSE</a><br />

5240. Ramakrishnan Subramanian  <a href="mailto:ramki.s@gmail.com">&lt;ramki.s@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRAMKI">SRAMKI</a><br />
5241. Raman.P  <a href="mailto:raamanp@yahoo.co.in">&lt;raamanp@yahoo.co.in&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAMAN">RAMAN</a><br />
5242. Ramana Mokkapati  <a href="mailto:mvr707@yahoo.com">&lt;mvr707@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MV/MVR">MVR</a><br />

5243. Ramesh Thangamani  <a href="mailto:ramesh.thangamani@yahoo.co.in">&lt;ramesh.thangamani@yahoo.co.in&gt;</a> -- RTHANGAM<br />
5244. <a href="http://www.ramin.uklinux.net/">Ramin Charles Nakisa</a>  <a href="mailto:rSaPmAiMn1n2a3k4i5s6a@yahoo.com">&lt;rSaPmAiMn1n2a3k4i5s6a@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAKISA">NAKISA</a><br />
5245. <a href="http://www.pinjax.com/">Ramki Balasubramanian</a>  <a href="mailto:ramki_b@acm.org">&lt;ramki_b@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAMKI">RAMKI</a><br />

5246. Ramon Casha  <a href="mailto:rcasha!megabyte.net">&lt;rcasha!megabyte.net&gt;</a> -- RCASHA<br />
5247. <a href="http://www.perl.org.il">Ran Eilam</a>  <a href="mailto:ran.eilam@gmail.com">&lt;ran.eilam@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EI/EILARA">EILARA</a><br />
5248. <a href="http://www.stonehenge.com/merlyn/">Randal L. Schwartz</a>  <a href="mailto:merlyn@stonehenge.com">&lt;merlyn@stonehenge.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/ME/MERLYN">MERLYN</a><br />

5249. Randal Lathrop  <a href="mailto:lathrop@gocougs.wsu.edu">&lt;lathrop@gocougs.wsu.edu&gt;</a> -- RLATHROP<br />
5250. Randall Hansen  <a href="mailto:randall@sonofhans.net">&lt;randall@sonofhans.net&gt;</a> -- LEGLESS<br />
5251. <a href="http://rlucas.net/">Randall Lucas</a>  <a href="mailto:rlucas@tercent.com">&lt;rlucas@tercent.com&gt;</a> -- RLUCAS<br />

5252. <a href="http://perlstalker.vuser.org/">Randall Smith</a>  <a href="mailto:perlstalker@vuser.org">&lt;perlstalker@vuser.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSMITH">RSMITH</a><br />
5253. Randy Harmon  <a href="mailto:rjharmon0316@yahoo.com">&lt;rjharmon0316@yahoo.com&gt;</a> -- RJHARMON<br />
5254. Randy J Ray  <a href="mailto:rjray@blackperl.com">&lt;rjray@blackperl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJRAY">RJRAY</a><br />

5255. <a href="http://hs1.hst.msu.edu/~randy/">Randy Jay Yarger</a>  <a href="mailto:randyyarger@hotmail.com">&lt;randyyarger@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANDY">RANDY</a><br />
5256. <a href="http://theoryx5.uwinnipeg.ca/">Randy Kobes</a>  <a href="mailto:r.kobes@uwinnipeg.ca">&lt;r.kobes@uwinnipeg.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKOBES">RKOBES</a><br />
5257. <a href="http://www.hamline.edu/~rcmaas/">Randy Maas</a>  <a href="mailto:randym@acm.org">&lt;randym@acm.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANDYM">RANDYM</a><br />

5258. Randy Viosca  <a href="mailto:viosca@cpan.org">&lt;viosca@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VIOSCA">VIOSCA</a><br />
5259. Randy W. Sims  <a href="mailto:RandyS@ThePierianSpring.org">&lt;RandyS@ThePierianSpring.org&gt;</a> -- RANDYS<br />
5260. Randy W. Sims  <a href="mailto:randys@thepierianspring.org">&lt;randys@thepierianspring.org&gt;</a> -- RWS<br />
5261. Rani Pinchuk  <a href="mailto:rani at cpan dot org">&lt;rani at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANI">RANI</a><br />

5262. Ranjib Dey  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RDEYS<br />
5263. Raoul Zwart  <a href="mailto:rlzwart@cpan.org">&lt;rlzwart@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RL/RLZWART">RLZWART</a><br />
5264. Raphael Bouskila  <a href="mailto:raph2@videotron.ca">&lt;raph2@videotron.ca&gt;</a> -- RAPH<br />
5265. Raphael Gommeaux  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAF">RAF</a><br />

5266. Raphael Kraus  <a href="mailto:belfry@cpan.org">&lt;belfry@cpan.org&gt;</a> -- BELFRY<br />
5267. Raphael Kraus  <a href="mailto:">&lt;&gt;</a> -- RAPHAEL<br />
5268. Raphael Manfredi  <a href="mailto:Raphael_Manfredi@pobox.com">&lt;Raphael_Manfredi@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAM">RAM</a><br />
5269. Raphael Schmitt  <a href="mailto:zeus02@bluewin.ch">&lt;zeus02@bluewin.ch&gt;</a> -- DARTH<br />

5270. <a href="http://projects.debianfr.net/">Raphaël 'SurcouF' Bordet</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SURCOUF<br />
5271. <a href="http://www.perl-auvergne.com">Raphaël ROULET</a>  <a href="mailto:raphael@perl-auvergne.com">&lt;raphael@perl-auvergne.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CASTOR">CASTOR</a><br />
5272. <a href="http://www.swi.com.br/~chaos/">Raul Dias</a>  <a href="mailto:raul@dias.com.br">&lt;raul@dias.com.br&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSD">RSD</a><br />

5273. <a href="http://www.jonichu.com/">Raul Joni Chu</a>  <a href="mailto:rjchu@hightowersoftware.com">&lt;rjchu@hightowersoftware.com&gt;</a> -- RJCHU<br />
5274. <a href="http://www.brinzer.net/">Ray Brinzer</a>  <a href="mailto:ray@brinzer.net">&lt;ray@brinzer.net&gt;</a> -- BRINZER<br />
5275. Ray Finch  <a href="mailto:rdf@cpan.org">&lt;rdf@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDF">RDF</a><br />

5276. Ray Graham, Jr.  <a href="mailto:rgraham69@hotmail.com">&lt;rgraham69@hotmail.com&gt;</a> -- RGRAHAM<br />
5277. Ray Gwinn  <a href="mailto:">&lt;&gt;</a> -- RAYGWINN<br />
5278. <a href="http://9pnet.com:2080/~rayt/">Ray Tsang/臧瑞國</a>  <a href="mailto:rayt@9pnet.com">&lt;rayt@9pnet.com&gt;</a> -- RAYT<br />
5279. <a href="http://www.pserc.cornell.edu/ray/">Ray Zimmerman</a>  <a href="mailto:rz10@cornell.edu">&lt;rz10@cornell.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZM/ZMAN">ZMAN</a><br />

5280. Raymond Val  <a href="mailto:rgval.cpan@gmail.com">&lt;rgval.cpan@gmail.com&gt;</a> -- RGVAL<br />
5281. Razvan-Daniel Mihai  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RAZVANM<br />
5282. <a href="http://www.accidia.net">Re Alberto</a>  <a href="mailto:kerberus@accidia.net">&lt;kerberus@accidia.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KERBERUS">KERBERUS</a><br />

5283. <a href="http://www.hunt.dev.fas.harvard.edu/">Rebecca A Hunt</a>  <a href="mailto:rahunt@nospam.mtholyoke.edu">&lt;rahunt@nospam.mtholyoke.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAHUNT">RAHUNT</a><br />
5284. <a href="http://www.redtreesystems.com">Red Tree Systems, LLC</a>  <a href="mailto:pdfapi2simple@redtreesystems.com">&lt;pdfapi2simple@redtreesystems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REDTREE">REDTREE</a><br />
5285. Redvers Davies  <a href="mailto:red@criticalintegration.com">&lt;red@criticalintegration.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RED">RED</a><br />

5286. <a href="http://harts.net/reece">Reece Hart</a>  <a href="mailto:reece@harts.net">&lt;reece@harts.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REECE">REECE</a><br />
5287. <a href="http://www.thesmbexchange.com/">Reed Sandberg</a>  <a href="mailto:reed_sandberg@yahoo.com">&lt;reed_sandberg@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSANDBERG">RSANDBERG</a><br />
5288. <a href="http://ist.uwaterloo.ca/~reggers/">Reg Quinton</a>  <a href="mailto:reggers@ist.uwaterloo.ca">&lt;reggers@ist.uwaterloo.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REGGERS">REGGERS</a><br />

5289. Reid Augustin  <a href="mailto:plugh@hello--excise-this--six.com">&lt;plugh@hello--excise-this--six.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REID">REID</a><br />
5290. <a href="http://members.aon.at/rpagitsch">Reinhard Pagitsch</a>  <a href="mailto:rpirpag@gmx.at">&lt;rpirpag@gmx.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPAGITSCH">RPAGITSCH</a><br />
5291. <a href="http://rurban.xarch.at/">Reini Urban</a>  <a href="mailto:rurban@x-ray.at">&lt;rurban@x-ray.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RURBAN">RURBAN</a><br />

5292. <a href="http://goreliance.com/">Reliance Technology Consultants, Inc.</a>  <a href="mailto:support@goreliance.com">&lt;support@goreliance.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RELIANCE">RELIANCE</a><br />
5293. Remy Chibois  <a href="mailto:rchibois@free.fr">&lt;rchibois@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCHIBOIS">RCHIBOIS</a><br />
5294. Renan Valente Rangel  <a href="mailto:rvr@cpan.org">&lt;rvr@cpan.org&gt;</a> -- RVR<br />

5295. Renata Musan Rasmussen  <a href="mailto:renata@rasmussen.tdcadsl.dk">&lt;renata@rasmussen.tdcadsl.dk&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TR/TRICKY">TRICKY</a><br />
5296. <a href="http://www.omninux.com">Renaud Drousies</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDROUSIES">RDROUSIES</a><br />
5297. <a href="http://www.blinkensisters.org">Rene Schickbauer</a>  <a href="mailto:cavac@magicbooks.org">&lt;cavac@magicbooks.org&gt;</a> -- CAVAC<br />

5298. Rene Uittenbogaard  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUITTENB">RUITTENB</a><br />
5299. Renee Baecker  <a href="mailto:module@renee-baecker.de">&lt;module@renee-baecker.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RENEEB">RENEEB</a><br />
5300. Reserved Account  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PAUSE<br />
5301. Reserved Local Account  <a href="mailto:adam@ali.as">&lt;adam@ali.as&gt;</a> -- LOCAL<br />

5302. <a href="http://www.infocopter.com/perl/">Reto Schär</a>  <a href="mailto:retoh@cpan.org">&lt;retoh@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/RETOH">RETOH</a><br />
5303. Reuben Montehermoso  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DRIPLOCK<br />
5304. <a href="http://www.lerner.co.il/">Reuven M. Lerner</a>  <a href="mailto:reuven@lerner.co.il">&lt;reuven@lerner.co.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REUVEN">REUVEN</a><br />

5305. <a href="http://sneak.datavibe.net">Rev. Jeffrey Paul</a>  <a href="mailto:sneak@datavibe.net">&lt;sneak@datavibe.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNEAK">SNEAK</a><br />
5306. Reza Naima  <a href="mailto:reza@reza.net">&lt;reza@reza.net&gt;</a> -- RNAIMA<br />
5307. Rhesa Rozendaal  <a href="mailto:rhesa@cpan.org">&lt;rhesa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHESA">RHESA</a><br />

5308. <a href="http://perlmonks.org/?node_id=31063">Rhet Turnbull</a>  <a href="mailto:rhettbull+cpan@gmail.com">&lt;rhettbull+cpan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHETTBULL">RHETTBULL</a><br />
5309. Riad Wahby  <a href="mailto:rwahby@cpan.org">&lt;rwahby@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RW/RWAHBY">RWAHBY</a><br />
5310. Ribamar Santarosa  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIBAMAR">RIBAMAR</a><br />

5311. Ricardo Filipe Liquito Balinha  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- BALINHA<br />
5312. <a href="http://www.mitologica.com.br/">Ricardo Luiz Filipo</a>  <a href="mailto:ricardo_filipo@yahoo.com.br">&lt;ricardo_filipo@yahoo.com.br&gt;</a> -- MONSENHOR<br />
5313. <a href="www.prestech.net/projetos/postmmon">Ricardo Malafaia Senra Barros</a>  <a href="mailto:ricardo@prestech.net">&lt;ricardo@prestech.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMALAFAIA">RMALAFAIA</a><br />

5314. <a href="http://rjbs.manxome.org/">Ricardo SIGNES</a>  <a href="mailto:rjbs@cpan.org">&lt;rjbs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJBS">RJBS</a><br />
5315. Ricardo Vazquez Armenta  <a href="mailto:rvazquez_a@yahoo.com">&lt;rvazquez_a@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVAZ">RVAZ</a><br />
5316. <a href="http://www.infodrome.net/~brujah/">Riccardo Cambiassi</a>  <a href="mailto:brujah@infodrome.net">&lt;brujah@infodrome.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRUJAH">BRUJAH</a><br />

5317. Riccardo Murri  <a href="mailto:riccardomurri@yahoo.it">&lt;riccardomurri@yahoo.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMURRI">RMURRI</a><br />
5318. Rich Bishop  <a href="mailto:rjb@cpan.org">&lt;rjb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJB">RJB</a><br />
5319. <a href="http://www.rcbowen.com/">Rich Bowen</a>  <a href="mailto:rbowen@rcbowen.com">&lt;rbowen@rcbowen.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBOW">RBOW</a><br />

5320. <a href="http://owl.me.uk/">Rich Daley</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- OWL<br />
5321. <a href="http://www.testingrange.com">Rich Gibson</a>  <a href="mailto:rich@testingrange.com">&lt;rich@testingrange.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGIBSON">RGIBSON</a><br />
5322. <a href="http://www.cellularStatistics.com">Rich Haney</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPHANEY">RPHANEY</a><br />

5323. <a href="http://www.lafferty.ca/">Rich Lafferty</a>  <a href="mailto:rich+cpan@lafferty.ca">&lt;rich+cpan@lafferty.ca&gt;</a> -- LAFFERTY<br />
5324. Rich Paul  <a href="mailto:cpan@rich-paul.net">&lt;cpan@rich-paul.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPAUL">RPAUL</a><br />
5325. <a href="http://www.rjaldridge.com">Richard Aldridge</a>  <a href="mailto:rja@rjaldridge.com">&lt;rja@rjaldridge.com&gt;</a> -- RJA<br />

5326. <a href="http://www.richardanderson.org">Richard Anderson</a>  <a href="mailto:cpan_pause(AT)richardanderson(DOT)org">&lt;cpan_pause(AT)richardanderson(DOT)org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RANDERSON">RANDERSON</a><br />
5327. Richard Baldwin  <a href="mailto:baldwinr@monolithss.com">&lt;baldwinr@monolithss.com&gt;</a> -- BALDWINR<br />
5328. <a href="http://sir.woody.hackswell.com">Richard Balint</a>  <a href="mailto:hackswell&lt;@&gt;gmail&lt;DOT&gt;com">&lt;hackswell&lt;@&gt;gmail&lt;DOT&gt;com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARCHFOOL">ARCHFOOL</a><br />

5329. Richard Blevins  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RABUSPA">RABUSPA</a><br />
5330. <a href="http://www.richardbowen.com/">Richard Bowen</a>  <a href="mailto:bowen@cpan.org">&lt;bowen@cpan.org&gt;</a> -- BOWEN<br />
5331. Richard Burkholder Jr.  <a href="mailto:rlb_jr@hotmail.com">&lt;rlb_jr@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RL/RLBJR">RLBJR</a><br />

5332. <a href="http://www.cstr.ed.ac.uk/~rjc/">Richard Caley</a>  <a href="mailto:R.Caley@ed.ac.uk">&lt;R.Caley@ed.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCALEY">RCALEY</a><br />
5333. <a href="http://unixbeard.net/~richardc/">Richard Clamp</a>  <a href="mailto:richardc@unixbeard.net">&lt;richardc@unixbeard.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCLAMP">RCLAMP</a><br />
5334. <a href="http://www.envisionext.com">Richard Clarke</a>  <a href="mailto:cpan@icespirit.com">&lt;cpan@icespirit.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICESPIRIT">ICESPIRIT</a><br />

5335. <a href="http://www.1gig.net">Richard D. Jackson</a>  <a href="mailto:richardj@1gig.net">&lt;richardj@1gig.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RICHARDJ">RICHARDJ</a><br />
5336. <a href="http://homepages.nildram.co.uk/~phekda/richdawe/">Richard Dawe</a>  <a href="mailto:richdawe@cpan.org">&lt;richdawe@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RICHDAWE">RICHDAWE</a><br />
5337. Richard DeSimine  <a href="mailto:richd@centralsoft.com">&lt;richd@centralsoft.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DESIMINER">DESIMINER</a><br />

5338. Richard Dice  <a href="mailto:rdice@pobox.com">&lt;rdice@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDICE">RDICE</a><br />
5339. Richard Dobson  <a href="mailto:r.j.dobson@qmul.ac.uk">&lt;r.j.dobson@qmul.ac.uk&gt;</a> -- RICH<br />
5340. <a href="http://www.obulous.org/">Richard F. Rebel</a>  <a href="mailto:rebel@obulous.org">&lt;rebel@obulous.org&gt;</a> -- REBEL<br />

5341. <a href="http://www.rfi.net/">Richard Foley</a>  <a href="mailto:richard.foley@rfi.net">&lt;richard.foley@rfi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RF/RFOLEY">RFOLEY</a><br />
5342. <a href="http://www.richardharman.com">Richard G Harman Jr</a>  <a href="mailto:perl-cpan@richardharman.com">&lt;perl-cpan@richardharman.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHARMAN">RHARMAN</a><br />
5343. Richard Gerber  <a href="mailto:richardgerber@yahoo.com">&lt;richardgerber@yahoo.com&gt;</a> -- GERBERRI<br />

5344. <a href="www.giffordonline.net">Richard Gifford</a>  <a href="mailto:richard@opiate.fsnet.co.uk">&lt;richard@opiate.fsnet.co.uk&gt;</a> -- RGIFFORD<br />
5345. <a href="http://www.nirostasis.net">Richard Giliam</a>  <a href="mailto:nirosys@nirostasis.net">&lt;nirosys@nirostasis.net&gt;</a> -- RGILIAM<br />
5346. Richard Graves  <a href="mailto:rgraves@vysystems.net">&lt;rgraves@vysystems.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGRAVES">RGRAVES</a><br />

5347. Richard Harris  <a href="mailto:rich@rdharris.org">&lt;rich@rdharris.org&gt;</a> -- RHARRIS<br />
5348. Richard Harris  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RJH<br />
5349. Richard Holden  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AC/ACIDDEATH">ACIDDEATH</a><br />
5350. Richard Holm  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FYNTE<br />

5351. <a href="http://www.plextk.org">Richard Hundt</a>  <a href="mailto:richard NO SPAM AT protea-systems.com">&lt;richard NO SPAM AT protea-systems.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHUNDT">RHUNDT</a><br />
5352. <a href="http://www.annexia.org/">Richard Jones</a>  <a href="mailto:rich@annexia.org">&lt;rich@annexia.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RW/RWMJ">RWMJ</a><br />
5353. <a href="http://richardkeen.net">Richard Keen</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RKEEN<br />

5354. <a href="http://kilgoreSolutions.com/">Richard Kilgore</a>  <a href="mailto:rick_kilgore@yahoo.com">&lt;rick_kilgore@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKILGORE">RKILGORE</a><br />
5355. <a href="www.optres.com">Richard L Garris</a>  <a href="mailto:rlgarris@pacbell.net">&lt;rlgarris@pacbell.net&gt;</a> -- RLGARRIS<br />
5356. <a href="http://lena.franken.de/">Richard Lippmann</a>  <a href="mailto:horshack@lisa.franken.de">&lt;horshack@lisa.franken.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HORSHACK">HORSHACK</a><br />

5357. <a href="http://www.kandarian.com">Richard M. Kandarian</a>  <a href="mailto:richard@kandarian.com">&lt;richard@kandarian.com&gt;</a> -- RMK<br />
5358. <a href="http://richih.org">Richard Michael Hartmann</a>  <a href="mailto:richih-cpan@net.in.tum.de">&lt;richih-cpan@net.in.tum.de&gt;</a> -- RICHIH<br />
5359. <a href="http://www.michaudsolutions.com/">Richard Michaud</a>  <a href="mailto:rmichaud@michaudsolutions.com">&lt;rmichaud@michaudsolutions.com&gt;</a> -- RMICHAUD<br />

5360. <a href="http://www.richmore.com/">Richard More</a>  <a href="mailto:perl@richmore.com">&lt;perl@richmore.com&gt;</a> -- RMORE<br />
5361. <a href="http://www.csworks.com/">Richard Munroe</a>  <a href="mailto:munroe@csworks.com">&lt;munroe@csworks.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUNROER">MUNROER</a><br />
5362. <a href="http://www.nuttall.uk.net/richard">Richard Nuttall</a>  <a href="mailto:richard@nuttall.uk.net">&lt;richard@nuttall.uk.net&gt;</a> -- NUTTALL<br />

5363. Richard Palmer  <a href="mailto:rdp@cpan.org">&lt;rdp@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDP">RDP</a><br />
5364. Richard Panman  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPANMAN">RPANMAN</a><br />
5365. Richard Rader  <a href="mailto:richard.rader@vlsi.com">&lt;richard.rader@vlsi.com&gt;</a> -- RADER<br />

5366. <a href="http://www.floatingatoll.nu/">Richard Soderberg</a>  <a href="mailto:rsoderberg@gmail.com">&lt;rsoderberg@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSOD">RSOD</a><br />
5367. <a href="http://www.richardsonnen.com/">Richard Sonnen</a>  <a href="mailto:sonnen@richardsonnen.com">&lt;sonnen@richardsonnen.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SONNEN">SONNEN</a><br />
5368. Richard Sutherland  <a href="mailto:rvsutherland@yahoo.com">&lt;rvsutherland@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVSUTHERL">RVSUTHERL</a><br />

5369. Richard Vireday  <a href="mailto:richard@vireday.com">&lt;richard@vireday.com&gt;</a> -- RVIREDAY<br />
5370. <a href="http://fruiture.de/">Richard Voss</a>  <a href="mailto:info@fruiture.de">&lt;info@fruiture.de&gt;</a> -- FRUIT<br />
5371. Richard W. Norton  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RWTNORTON<br />

5372. Richard Walker  <a href="mailto:richard@cpan.org">&lt;richard@cpan.org&gt;</a> -- RICHARD<br />
5373. Richard Zilavec  <a href="mailto:pause@linistrator.com">&lt;pause@linistrator.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RZ/RZILAVEC">RZILAVEC</a><br />
5374. Rick Delaney  <a href="mailto:rick@bort.ca">&lt;rick@bort.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DELANEY">DELANEY</a><br />

5375. Rick Esterling  <a href="mailto:rickest@yahoo.com">&lt;rickest@yahoo.com&gt;</a> -- RICKEST<br />
5376. Rick Evans  <a href="mailto:uncleelvis@netscape.net">&lt;uncleelvis@netscape.net&gt;</a> -- UNCLELVIS<br />
5377. Rick Frankel  <a href="mailto:cpan@rickster.com">&lt;cpan@rickster.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RF/RFRANKEL">RFRANKEL</a><br />
5378. Rick Mangi  <a href="mailto:rmangi@tgix.com">&lt;rmangi@tgix.com&gt;</a> -- RMANGI<br />

5379. Rick Measham  <a href="mailto:rickm@cpan.org">&lt;rickm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RICKM">RICKM</a><br />
5380. Rick Myers  <a href="mailto:jrm@cpan.org">&lt;jrm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JR/JRM">JRM</a><br />
5381. <a href="http://shadowspar.dyndns.org/rick/">Rick Scott</a>  <a href="mailto:rick@shadowspar.dyndns.org">&lt;rick@shadowspar.dyndns.org&gt;</a> -- RICK<br />

5382. Rick Smith  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OD/ODO">ODO</a><br />
5383. Ricki Stern  <a href="mailto:rickistern1@yahoo.com">&lt;rickistern1@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RICKI">RICKI</a><br />
5384. <a href="http://www.tertius.net.au/~rb/">Ricky Buchanan</a>  <a href="mailto:rb@tertius.net.au">&lt;rb@tertius.net.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOSSAMER">GOSSAMER</a><br />

5385. <a href="http://www.pommetab.com">Rija Ménagé</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIJA">RIJA</a><br />
5386. Rijkers  <a href="mailto:">&lt;&gt;</a> -- RIJK<br />
5387. Rik Harris  <a href="mailto:rik.harris@fulcrum.com.au">&lt;rik.harris@fulcrum.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RIK">RIK</a><br />

5388. <a href="http://www.fs-output.com">Rintaro Ishizaki</a>  <a href="mailto:rintaro@cpan.org">&lt;rintaro@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RI/RINTARO">RINTARO</a><br />
5389. <a href="http://www.geocities.com/rizapn">Riza Purwo Nugroho</a>  <a href="mailto:rizapn@ratelindo.co.id">&lt;rizapn@ratelindo.co.id&gt;</a> -- RIZAPN<br />
5390. <a href="http://www.geekymedia.com">Rizwan Kassim</a>  <a href="mailto:rizwank@geekymedia.com">&lt;rizwank@geekymedia.com&gt;</a> -- RIZWANK<br />

5391. Rizwan Majeed  <a href="mailto:rizwanmajeed@mail.com">&lt;rizwanmajeed@mail.com&gt;</a> -- AFARIZWAN<br />
5392. Rob Anderson  <a href="mailto:cpan@robanderson.net">&lt;cpan@robanderson.net&gt;</a> -- RJAND<br />
5393. Rob Bloodgood  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDB">RDB</a><br />
5394. <a href="http://freeware.roobik.com/">Rob Brown</a>  <a href="mailto:bbb@cpan.org">&lt;bbb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BB/BBB">BBB</a><br />

5395. Rob Casey  <a href="mailto:rob.casey@bluebottle.com">&lt;rob.casey@bluebottle.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBAU">ROBAU</a><br />
5396. Rob Colantuoni  <a href="mailto:rgc@oss.buffalo.edu">&lt;rgc@oss.buffalo.edu&gt;</a> -- RGC<br />
5397. Rob Dixon  <a href="mailto:rob@dixon.nildram.co.uk">&lt;rob@dixon.nildram.co.uk&gt;</a> -- ROB<br />
5398. <a href="http://www.rahji.com">Rob Duarte</a>  <a href="mailto:perl@rahji.com">&lt;perl@rahji.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDUARTE">RDUARTE</a><br />

5399. Rob Duncan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROBD<br />
5400. <a href="http://www.salmonella.org">Rob Edwards</a>  <a href="mailto:redwards@salmonella.org">&lt;redwards@salmonella.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINSALROB">LINSALROB</a><br />
5401. <a href="http://www.geekthing.com/~robf/">Rob Fugina</a>  <a href="mailto:robf@geekthing.com">&lt;robf@geekthing.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBF">ROBF</a><br />

5402. Rob Giseburt  <a href="mailto:rob@heavyhosting.net">&lt;rob@heavyhosting.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GISEBURT">GISEBURT</a><br />
5403. Rob Janes  <a href="mailto:arjay@cpan.org">&lt;arjay@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AR/ARJAY">ARJAY</a><br />
5404. Rob Kinyon  <a href="mailto:rob.kinyon@gmail.com">&lt;rob.kinyon@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKINYON">RKINYON</a><br />

5405. Rob Lee  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBL">ROBL</a><br />
5406. <a href="http://MobileOnlineBusiness.com.au">Rob Manson</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBMAN">ROBMAN</a><br />
5407. <a href="http://robm.fastmail.fm">Rob Mueller</a>  <a href="mailto:cpan@robm.fastmail.fm">&lt;cpan@robm.fastmail.fm&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBM">ROBM</a><br />

5408. Rob Partington  <a href="mailto:pause-spam@frottage.org">&lt;pause-spam@frottage.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJP">RJP</a><br />
5409. Rob Seegel  <a href="mailto:RobSeegel@comcast.net">&lt;RobSeegel@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCS">RCS</a><br />
5410. Rob Seegel  <a href="mailto:RobSeegel@comcast.net">&lt;RobSeegel@comcast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCSEEGE">RCSEEGE</a><br />

5411. Rob Symes  <a href="mailto:rob@robsymes.com">&lt;rob@robsymes.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSYMES">RSYMES</a><br />
5412. Rob Thomas  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- XROBAU<br />
5413. Rob Woolfson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROBWOLF<br />
5414. <a href="http://www.fon.hum.uva.nl/rob/">Rob van Son</a>  <a href="mailto:R.J.J.H.vanSon@uva.nl">&lt;R.J.J.H.vanSon@uva.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBVANSON">ROBVANSON</a><br />

5415. <a href="http://shiva.wox.org/">Robbert-Jan Roos</a>  <a href="mailto:rj@shiva.wox.org">&lt;rj@shiva.wox.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJROOS">RJROOS</a><br />
5416. <a href="http://robbiebow.co.uk">Robbie Bow</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBBIEBOW">ROBBIEBOW</a><br />
5417. <a href="http://www.robbywalker.name">Robby Walker</a>  <a href="mailto:robby.walker+PAUSE@gmail.com">&lt;robby.walker+PAUSE@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBWALKER">ROBWALKER</a><br />

5418. <a href="http://474.at/">Robert 'phaylon' Sedlacek</a>  <a href="mailto:rs@474.at">&lt;rs@474.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHAYLON">PHAYLON</a><br />
5419. <a href="http://roal.anet.at/">Robert Allerstorfer</a>  <a href="mailto:roal@cpan.org">&lt;roal@cpan.org&gt;</a> -- ROAL<br />
5420. Robert Antczak  <a href="mailto:rantczak@home.com">&lt;rantczak@home.com&gt;</a> -- RANTCZAK<br />

5421. <a href="http://rbach.priv.at/">Robert Bachmann</a>  <a href="mailto:">&lt;&gt;</a> -- RBACH<br />
5422. <a href="http://kill.devc.at/">Robert Barta</a>  <a href="mailto:drrho@cpan.org">&lt;drrho@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRRHO">DRRHO</a><br />
5423. <a href="http://i.want.more.disorder.com/">Robert Bedell</a>  <a href="mailto:zen@tischer.net">&lt;zen@tischer.net&gt;</a> -- ODDFELLOW<br />

5424. Robert Bihlmeyer  <a href="mailto:robbe@orcus.priv.at">&lt;robbe@orcus.priv.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBBE">ROBBE</a><br />
5425. <a href="http://www.robertblackwell.com">Robert Blackwell</a>  <a href="mailto:robert@robertblackwell.com">&lt;robert@robertblackwell.com&gt;</a> -- RBLACKWE<br />
5426. <a href="http://openserv.org">Robert Bohne</a>  <a href="mailto:rbo@cpan.org">&lt;rbo@cpan.org&gt;</a> -- RBO<br />

5427. <a href="http://www.rlb3.com">Robert Boone</a>  <a href="mailto:rlb@cpan.org">&lt;rlb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RL/RLB">RLB</a><br />
5428. <a href="http://www.concordant-thought.com/personal/robert/">Robert Braddock</a>  <a href="mailto:robert@concordant-thought.com">&lt;robert@concordant-thought.com&gt;</a> -- XETHAIR<br />
5429. Robert Chitoiu  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHITOIUP">CHITOIUP</a><br />

5430. <a href="http://www.bobnet.co.uk/">Robert Cornell</a>  <a href="mailto:bob@bobnet.co.uk">&lt;bob@bobnet.co.uk&gt;</a> -- BOBNET<br />
5431. <a href="http://www.logicalchaos.org">Robert Creager</a>  <a href="mailto:Pause@LogicalChaos.org">&lt;Pause@LogicalChaos.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCREAGER">RCREAGER</a><br />
5432. Robert Davis  <a href="mailto:mujiburgerproductions@yahoo.com">&lt;mujiburgerproductions@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUJI">MUJI</a><br />

5433. <a href="www.ipsek.net">Robert Drake</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RDRAKE<br />
5434. <a href="http://home.comcast.net/~eaglestone">Robert Eaglestone</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJE">RJE</a><br />
5435. Robert Eden  <a href="mailto:reden@cpan.org">&lt;reden@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REDEN">REDEN</a><br />

5436. <a href="http://www.robertpearse.com">Robert Eric Pearse</a>  <a href="mailto:pearse@robertpearse.com">&lt;pearse@robertpearse.com&gt;</a> -- PEARSE<br />
5437. <a href="http://enfranchisedmind.com/blog">Robert Fischer</a>  <a href="mailto:chia@cpan.org">&lt;chia@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHIA">CHIA</a><br />
5438. Robert Freimuth  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RFREIMUTH<br />

5439. <a href="http://robert.thegeakes.co.uk/">Robert Geake</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RGEAKE<br />
5440. <a href="http://avalon.albuquerque.nm.us/">Robert Goff</a>  <a href="mailto:robert@goff.com">&lt;robert@goff.com&gt;</a> -- RAGOFF<br />
5441. <a href="http://www.robertscloset.com">Robert Graff</a>  <a href="mailto:rgraff@robertscloset.com">&lt;rgraff@robertscloset.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGRAFF">RGRAFF</a><br />

5442. Robert Grimes  <a href="mailto:buu@erxz.com">&lt;buu@erxz.com&gt;</a> -- BUU<br />
5443. Robert Großmayer  <a href="mailto:robert.grossmayer@gmx.net">&lt;robert.grossmayer@gmx.net&gt;</a> -- RRG<br />
5444. Robert Hanson  <a href="mailto:rhanson@blast.net">&lt;rhanson@blast.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHANSON">RHANSON</a><br />
5445. <a href="http://www.Muc-Net.de/">Robert Hase</a>  <a href="mailto:Tivoli.RHase@Muc-Net.de">&lt;Tivoli.RHase@Muc-Net.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHASE">RHASE</a><br />

5446. Robert Hicks  <a href="mailto:sigzero@gmail.com">&lt;sigzero@gmail.com&gt;</a> -- SIGZERO<br />
5447. Robert Hiller  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HILLER<br />
5448. <a href="http://www.informatik.uni-muenchen.de/~hofer">Robert Hofer</a>  <a href="mailto:hofer@informatik.uni-muenchen.de">&lt;hofer@informatik.uni-muenchen.de&gt;</a> -- RHOFER<br />

5449. Robert Hunter  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RHUNTER<br />
5450. <a href="http://www.rjlee.dyndns.org/">Robert J Lee</a>  <a href="mailto:pause@rjlee.dyndns.org">&lt;pause@rjlee.dyndns.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJLEE">RJLEE</a><br />
5451. Robert J Seymour  <a href="mailto:rseymour@rseymour.com">&lt;rseymour@rseymour.com&gt;</a> -- RJS<br />

5452. Robert J. McKay  <a href="mailto:robert@mckay.com">&lt;robert@mckay.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMCKAY">RMCKAY</a><br />
5453. <a href="http://robertjamesclay.homeip.net">Robert James Clay</a>  <a href="mailto:sysop@rocasa.org">&lt;sysop@rocasa.org&gt;</a> -- JAME<br />
5454. <a href="http://www.cvsroot.org">Robert Jenks</a>  <a href="mailto:rjenks@cvsroot.org">&lt;rjenks@cvsroot.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJENKS">RJENKS</a><br />

5455. <a href="http://www.craic.com">Robert Jones</a>  <a href="mailto:jones@craic.com">&lt;jones@craic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CR/CRAIC">CRAIC</a><br />
5456. <a href="http://www.timesink.de/perl/">Robert Joop</a>  <a href="mailto:~yaph/cpan/pause/{nospam}/08-02-26@rainbow.in-berlin.de">&lt;~yaph/cpan/pause/{nospam}/08-02-26@rainbow.in-berlin.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJOOP">RJOOP</a><br />
5457. Robert Jordan  <a href="mailto:robertj@gmx.net">&lt;robertj@gmx.net&gt;</a> -- AMMMA<br />

5458. <a href="http://mayhem-chaos.net">Robert Kaye</a>  <a href="mailto:rob@eorbit.net">&lt;rob@eorbit.net&gt;</a> -- RKAYE<br />
5459. Robert Kiesling  <a href="mailto:rkies@cpan.org">&lt;rkies@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKIES">RKIES</a><br />
5460. Robert Kiessling  <a href="mailto:tmda-kw-pause.293ae0@ro.bert.de">&lt;tmda-kw-pause.293ae0@ro.bert.de&gt;</a> -- JOSEBA<br />

5461. Robert King  <a href="mailto:rmk@probsd.net">&lt;rmk@probsd.net&gt;</a> -- RKING<br />
5462. <a href="http://bravo9.com">Robert Krimen</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKRIMEN">RKRIMEN</a><br />
5463. Robert L Hicks  <a href="mailto:robert.hicks@gmail.com">&lt;robert.hicks@gmail.com&gt;</a> -- RHICKS<br />

5464. Robert Lacroix  <a href="mailto:ralacroix@hydro.mb.ca">&lt;ralacroix@hydro.mb.ca&gt;</a> -- RALACR<br />
5465. <a href="http://bigrob.ath.cx">Robert Landrum</a>  <a href="mailto:perl@bigrob.ath.cx">&lt;perl@bigrob.ath.cx&gt;</a> -- RLANDRUM<br />
5466. Robert Laughlin  <a href="mailto:robert@galaxysys.com">&lt;robert@galaxysys.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RL/RLAUGHLIN">RLAUGHLIN</a><br />

5467. <a href="http://santafeswing.com">Robert Leach</a>  <a href="mailto:robleach@la.unm.edu">&lt;robleach@la.unm.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBLEACH">ROBLEACH</a><br />
5468. <a href="http://bozzio.the-lehrs.com/">Robert Lehr</a>  <a href="mailto:bozzio@the-lehrs.com">&lt;bozzio@the-lehrs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOZZIO">BOZZIO</a><br />
5469. <a href="http://www.infiniteinfo.com">Robert Locke</a>  <a href="mailto:rlocke@infiniteinfo.com">&lt;rlocke@infiniteinfo.com&gt;</a> -- RLOCKE<br />

5470. Robert Loomans  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RLOOMANS<br />
5471. Robert Mah  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RMAH<br />
5472. <a href="http://www.robmay.me.uk/">Robert May</a>  <a href="mailto:robertmay@cpan.org">&lt;robertmay@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBERTMAY">ROBERTMAY</a><br />

5473. <a href="http://cataclysm.cx/">Robert Norris</a>  <a href="mailto:rob@cataclysm.cx">&lt;rob@cataclysm.cx&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBN">ROBN</a><br />
5474. Robert Olson  <a href="mailto:olson@mcs.anl.gov">&lt;olson@mcs.anl.gov&gt;</a> -- RDO<br />
5475. Robert Powers  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BA/BATMAN">BATMAN</a><br />

5476. <a href="http://www.robertprice.co.uk/">Robert Price</a>  <a href="mailto:rprice@cpan.org">&lt;rprice@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPRICE">RPRICE</a><br />
5477. <a href="http://robertdell.dyndns.org/sites/">Robert R. Dell</a>  <a href="mailto:dellr@mac.nospam.com">&lt;dellr@mac.nospam.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XY/XYZZY">XYZZY</a><br />
5478. Robert Ransbottom  <a href="mailto:rirans@comcast.net">&lt;rirans@comcast.net&gt;</a> -- RIR<br />

5479. Robert Rothenberg  <a href="mailto:rrwo@cpan.org">&lt;rrwo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RR/RRWO">RRWO</a><br />
5480. Robert S. Heckel Jr.  <a href="mailto:bheckel@s/SPAM/gmail/.com">&lt;bheckel@s/SPAM/gmail/.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BH/BHECKEL">BHECKEL</a><br />
5481. <a href="http://rob.muhlestein.net">Robert S. Muhlestein</a>  <a href="mailto:rmuhle@cpan.org">&lt;rmuhle@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMUHLE">RMUHLE</a><br />

5482. Robert Seifer  <a href="mailto:kismet@mangband.org">&lt;kismet@mangband.org&gt;</a> -- KISMET<br />
5483. Robert Spier  <a href="mailto:rspier@cpan.org">&lt;rspier@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSPIER">RSPIER</a><br />
5484. <a href="http://www.MascaraSnake.com">Robert Starr</a>  <a href="mailto:rstarr@MascaraSnake.com">&lt;rstarr@MascaraSnake.com&gt;</a> -- RSTARR<br />

5485. <a href="http://developer.mimer.com">Robert Sundström</a>  <a href="mailto:robert.sundstrom@upright.se">&lt;robert.sundstrom@upright.se&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIMER">MIMER</a><br />
5486. <a href="www.unix-beratung.de">Robert Urban</a>  <a href="mailto:urban@unix-beratung.de">&lt;urban@unix-beratung.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBURBAN">ROBURBAN</a><br />
5487. Robert Wenner  <a href="mailto:rwenner@cpan.org">&lt;rwenner@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RW/RWENNER">RWENNER</a><br />

5488. <a href="http://machorro.net/roberto">Roberto Machorro</a>  <a href="mailto:rob@machorro.net">&lt;rob@machorro.net&gt;</a> -- ROBMAC<br />
5489. <a href="http://www.robertoalamos.com">Roberto Álamos Moreno</a>  <a href="mailto:ralamosm@cpan.org">&lt;ralamosm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RALAMOSM">RALAMOSM</a><br />
5490. <a href="http://www.infusedlight.net">Robin Bank</a>  <a href="mailto:robin@infusedlight.net">&lt;robin@infusedlight.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBINBANK">ROBINBANK</a><br />

5491. Robin Barker  <a href="mailto:RMB1@npl.co.uk">&lt;RMB1@npl.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMBARKER">RMBARKER</a><br />
5492. <a href="http://berjon.com/">Robin Berjon</a>  <a href="mailto:robin.berjon@gmail,com">&lt;robin.berjon@gmail,com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBERJON">RBERJON</a><br />
5493. <a href="http://robinclarke.net">Robin Clarke</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCL">RCL</a><br />

5494. Robin Darby  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROBINDAR<br />
5495. <a href="http://www.orbis-terrarum.net/">Robin H. Johnson</a>  <a href="mailto:robbat2@gentoo.org">&lt;robbat2@gentoo.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBBAT">ROBBAT</a><br />
5496. Robin Houston  <a href="mailto:robin-cpan@kitsite.com">&lt;robin-cpan@kitsite.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROBIN">ROBIN</a><br />

5497. <a href="http://www.ta-sa.org/">Robin Redeker</a>  <a href="mailto:elmex@ta-sa.org">&lt;elmex@ta-sa.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELMEX">ELMEX</a><br />
5498. <a href="http://www.cinepaint.org">Robin Rowe</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROBINROWE<br />
5499. <a href="http://www.repdoint.org.uk">Robin Szemeti</a>  <a href="mailto:robin-pause@redpoint.org.uk">&lt;robin-pause@redpoint.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSZEMETI">RSZEMETI</a><br />

5500. <a href="http://kb3ien.us">Robin-David Hammond</a>  <a href="mailto:CPAN@KB3IEN.US.">&lt;CPAN@KB3IEN.US.&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KB/KBXXXIEN">KBXXXIEN</a><br />
5501. <a href="http://poe.perl.org/">Rocco Caputo</a>  <a href="mailto:rcaputo@pobox.com">&lt;rcaputo@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCAPUTO">RCAPUTO</a><br />
5502. <a href="http://www.gnu.org/software/libcdio">Rocky Bernstein</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROCKY">ROCKY</a><br />

5503. <a href="http://www.argumentum.de">Roderich Schupp</a>  <a href="mailto:schupp@argumentum.de">&lt;schupp@argumentum.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSCHUPP">RSCHUPP</a><br />
5504. <a href="http://www.argon.org/~roderick/">Roderick Schertler</a>  <a href="mailto:roderick@argon.org">&lt;roderick@argon.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROSCH">ROSCH</a><br />
5505. Rodger V. Anderson  <a href="mailto:rva@rmci.net">&lt;rva@rmci.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVA">RVA</a><br />

5506. <a href="www.chronosilence.org">Rodin Lyasoff</a>  <a href="mailto:codesherpa@lyasoff.com">&lt;codesherpa@lyasoff.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/RODIN">RODIN</a><br />
5507. Rodney Broom  <a href="mailto:perl@rbroom.com">&lt;perl@rbroom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBROOM">RBROOM</a><br />
5508. Rodney Rindels  <a href="mailto:rrindels@gmail.com">&lt;rrindels@gmail.com&gt;</a> -- RRINDELS<br />

5509. <a href="http://www.laas.fr/~ortalo/">Rodolphe Ortalo</a>  <a href="mailto:ortalo@laas.fr">&lt;ortalo@laas.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OR/ORTALO">ORTALO</a><br />
5510. Rodrigo M. M. Habib Gregori  <a href="mailto:rodrigo.gregori@siemens.com">&lt;rodrigo.gregori@siemens.com&gt;</a> -- RMMHG<br />
5511. <a href="http://www.cce.ufsc.br/~fernandesrp">Rodrigo Panchiniak Fernandes</a>  <a href="mailto:fernandes@cpan.org">&lt;fernandes@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FERNANDES">FERNANDES</a><br />

5512. Rodrigo Vallejo  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MPLUS<br />
5513. Roel van der Steen  <a href="mailto:roel-perl@st2x.net">&lt;roel-perl@st2x.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RST">RST</a><br />
5514. <a href="http://www.iosea.com/">Roger A Hall</a>  <a href="mailto:roger@iosea.com">&lt;roger@iosea.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROGERHALL">ROGERHALL</a><br />

5515. Roger Burton West  <a href="mailto:roger@nospam.firedrake.org">&lt;roger@nospam.firedrake.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FIREDRAKE">FIREDRAKE</a><br />
5516. Roger Faust  <a href="mailto:roger_faust@bluewin.ch">&lt;roger_faust@bluewin.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RF/RFAUST">RFAUST</a><br />
5517. Roger Lee  <a href="mailto:roger@cpan.org">&lt;roger@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROGER">ROGER</a><br />

5518. <a href="http://psyphi.net/">Roger Pettett</a>  <a href="mailto:rmp@psyphi.net">&lt;rmp@psyphi.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPETTETT">RPETTETT</a><br />
5519. Roger Southwick  <a href="mailto:">&lt;&gt;</a> -- ROGERS<br />
5520. Rogerio Saran  <a href="mailto:rsaran@csf.com.br">&lt;rsaran@csf.com.br&gt;</a> -- RSARAN<br />

5521. <a href="http://rohan.almeida.in">Rohan Almeida</a>  <a href="mailto:rohan@almeida.in">&lt;rohan@almeida.in&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROHAN">ROHAN</a><br />
5522. <a href="http://www.rohitmishra.com">Rohit Mishra</a>  <a href="mailto:mishra.rohit@gmail.com">&lt;mishra.rohit@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROHITM">ROHITM</a><br />
5523. Rohit Sharma  <a href="mailto:rohit.sharma@usa.net">&lt;rohit.sharma@usa.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SROHIT">SROHIT</a><br />

5524. Roland Angerer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RANGERER<br />
5525. <a href="http://www.fff.at/">Roland BAUER</a>  <a href="mailto:rb-cpan@fff.at">&lt;rb-cpan@fff.at&gt;</a> -- RBAUER<br />
5526. Roland Giersig  <a href="mailto:RGiersig@cpan.org">&lt;RGiersig@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGIERSIG">RGIERSIG</a><br />

5527. Roland Huß  <a href="mailto:roland@cpan.org">&lt;roland@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROLAND">ROLAND</a><br />
5528. Roland Kapl  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKAPL">RKAPL</a><br />
5529. <a href="http://www.brabbel.net">Roland Lammel</a>  <a href="mailto:lammel@cpan.org">&lt;lammel@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LAMMEL">LAMMEL</a><br />

5530. Roland Minner  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RMINNER<br />
5531. <a href="http://www.roland-moriz.de/">Roland Moriz</a>  <a href="mailto:rmoriz@cpan.org">&lt;rmoriz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMORIZ">RMORIZ</a><br />
5532. Roland Walker  <a href="mailto:walker@ncbi.nlm.nih.gov">&lt;walker@ncbi.nlm.nih.gov&gt;</a> -- RWALKER<br />

5533. <a href="http://www.xs4all.nl/~ipenburg">Roland van Ipenburg</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IP/IPENBURG">IPENBURG</a><br />
5534. <a href="http://www.ultranet.com/~nelson/">Rolf Harold Nelson</a>  <a href="mailto:rolf@usa.healthnet.org">&lt;rolf@usa.healthnet.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHNELSON">RHNELSON</a><br />
5535. Rolf Krahl  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROTKRAUT">ROTKRAUT</a><br />

5536. Rollin C. Thomas  <a href="mailto:rcthomas3000 at gmail.com">&lt;rcthomas3000 at gmail.com&gt;</a> -- RCTHOMAS<br />
5537. <a href="http://game-life-boundless.blogspot.com/">Roman A. Milovanov</a>  <a href="mailto:romick@lipetsk.ru">&lt;romick@lipetsk.ru&gt;</a> -- ROMICK<br />
5538. Roman Ardern-Corris  <a href="mailto:spam_in@3legs.com">&lt;spam_in@3legs.com&gt;</a> -- ROMAN<br />

5539. Roman Baumer  <a href="mailto:rba@cpan.org">&lt;rba@cpan.org&gt;</a> -- RBA<br />
5540. <a href="www.daniel.cz">Roman Daniel</a>  <a href="mailto:roman.daniel@gtsnovera.cz">&lt;roman.daniel@gtsnovera.cz&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DANIELR">DANIELR</a><br />
5541. Roman F.  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ROMANF<br />

5542. <a href="http://amk.lg.ua/~ra">Roman Kosenko</a>  <a href="mailto:ra@amk.lg.ua">&lt;ra@amk.lg.ua&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RA">RA</a><br />
5543. <a href="http://www.komkon.org/~romm/">Roman Parparov</a>  <a href="mailto:romm@empire.tau.acil">&lt;romm@empire.tau.acil&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROMM">ROMM</a><br />
5544. <a href="http://roman.plessl.info">Roman Plessl</a>  <a href="mailto:rplessl@cpan.org">&lt;rplessl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPLESSL">RPLESSL</a><br />

5545. Roman Vašíček  <a href="mailto:rvasicek@cpan.org">&lt;rvasicek@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVASICEK">RVASICEK</a><br />
5546. Romel Rivas  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RRIVAS<br />
5547. Ron Hill  <a href="mailto:rkhill@cpan.org">&lt;rkhill@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKHILL">RKHILL</a><br />

5548. Ron Isaacson  <a href="mailto:isaacson@cpan.org">&lt;isaacson@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IS/ISAACSON">ISAACSON</a><br />
5549. <a href="http://savage.net.au/index.html">Ron Savage</a>  <a href="mailto:ron@savage.net.au">&lt;ron@savage.net.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSAVAGE">RSAVAGE</a><br />
5550. <a href="http://www.broadcom.com">Ron Squiers</a>  <a href="mailto:ron@broadcom.com">&lt;ron@broadcom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RS/RSQUIERS">RSQUIERS</a><br />

5551. <a href="http://home.planet.nl/~radejong/index.html">Ron de Jong</a>  <a href="mailto:radejong@planet.nl">&lt;radejong@planet.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RADEJONG">RADEJONG</a><br />
5552. <a href="http://www.rblasch.org/">Ronald Blaschke</a>  <a href="mailto:ron@rblasch.org">&lt;ron@rblasch.org&gt;</a> -- RBLASCH<br />
5553. <a href="http://www.ronaldlens.com">Ronald F. Lens</a>  <a href="mailto:ronald@ronaldlens.com">&lt;ronald@ronaldlens.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RF/RFLENS">RFLENS</a><br />

5554. <a href="http://www.18james.com/">Ronald Florence</a>  <a href="mailto:ron@18james.com">&lt;ron@18james.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RF/RFLORENCE">RFLORENCE</a><br />
5555. Ronald J. Kimball  <a href="mailto:rjk-cpan@tamias.net">&lt;rjk-cpan@tamias.net&gt;</a> -- CHIPMUNK<br />
5556. <a href="http://iama.rrecktek.com">Ronald P. Reck</a>  <a href="mailto:rreck@iama.rrecktek.com">&lt;rreck@iama.rrecktek.com&gt;</a> -- RRECK<br />

5557. <a href="http://www.software-path.com/">Ronald Schmidt</a>  <a href="mailto:RonaldXS@software-path.com">&lt;RonaldXS@software-path.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/RONALDWS">RONALDWS</a><br />
5558. Ronald van der Pol  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVDP">RVDP</a><br />
5559. <a href="http://www.roitsystems.com/">Ronan Oger</a>  <a href="mailto:ronan@cpan.org">&lt;ronan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/RONAN">RONAN</a><br />

5560. <a href="http://www.waider.ie/">Ronan Waide</a>  <a href="mailto:waider+spam@waider.ie">&lt;waider+spam@waider.ie&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WA/WAIDER">WAIDER</a><br />
5561. <a href="http://www.rootroute.com/cpan">Rootroute CRD-CPAN</a>  <a href="mailto:cpan@rootroute.com">&lt;cpan@rootroute.com&gt;</a> -- ROOTROUTE<br />
5562. Rory Macdonald  <a href="mailto:rory.macdonald@gmail.com">&lt;rory.macdonald@gmail.com&gt;</a> -- RORY<br />

5563. <a href="http://www.rozallin.co.uk">Rosellyne Thompson</a>  <a href="mailto:rsjthompson@gmail.com">&lt;rsjthompson@gmail.com&gt;</a> -- ROZALLIN<br />
5564. Ross Esposito  <a href="mailto:resposito@symantec.com">&lt;resposito@symantec.com&gt;</a> -- XGUNNERX<br />
5565. Ross Ferguson  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FERGUSOR">FERGUSOR</a><br />

5566. <a href="http://www.lonsteins.com/">Ross Lonstein</a>  <a href="mailto:rlonstein@pobox.com">&lt;rlonstein@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TECHNIK">TECHNIK</a><br />
5567. <a href="http://neces.com/">Ross McFarland</a>  <a href="mailto:rmcfarla@neces.com">&lt;rmcfarla@neces.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMCFARLA">RMCFARLA</a><br />
5568. Roumen Semov  <a href="mailto:rumcho _at yahoo.com">&lt;rumcho _at yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUMCHO">RUMCHO</a><br />

5569. <a href="www.gseven.org">Roy Corey</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- XERHINO<br />
5570. <a href="http://www.thetoybox.org/">Roy Hooper</a>  <a href="mailto:help@thetoybox.org">&lt;help@thetoybox.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHOOPER">RHOOPER</a><br />
5571. Roy Ivy III  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RIVY<br />

5572. Roy Johnson  <a href="mailto:royone@yahoo.com">&lt;royone@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJOHNSON">RJOHNSON</a><br />
5573. <a href="http://kavio.net">Roy Mäkikara</a>  <a href="mailto:nbr@shpongle.com">&lt;nbr@shpongle.com&gt;</a> -- NBR<br />
5574. Roy Zimmer  <a href="mailto:">&lt;&gt;</a> -- ZIMMERR<br />

5575. <a href="xmedia.zero-lan.net">Ruben Vareljyan</a>  <a href="mailto:admin@nur.am">&lt;admin@nur.am&gt;</a> -- GNOME<br />
5576. Rudolf Polzer  <a href="mailto:rpolzer@durchnull.de">&lt;rpolzer@durchnull.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPOLZER">RPOLZER</a><br />
5577. Rudy Lippan  <a href="mailto:rlippan@remotelinux.com">&lt;rlippan@remotelinux.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUDY">RUDY</a><br />

5578. Ruey-Cheng Chen  <a href="mailto:rueycheng@gmail.com">&lt;rueycheng@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUEYCHENG">RUEYCHENG</a><br />
5579. Rufus Cable  <a href="mailto:rcp@rcable.co.uk">&lt;rcp@rcable.co.uk&gt;</a> -- RCABLE<br />
5580. <a href="http://www.npl.uiuc.edu/~yangrz/">Ruizhe Yang</a>  <a href="mailto:razor@cpan.org">&lt;razor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAZOR">RAZOR</a><br />

5581. <a href="http://www.henssel.dk/">Run Henssel</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RH/RHENSSEL">RHENSSEL</a><br />
5582. Ruslan (Ted) Kharitonov  <a href="mailto:ted@redreset.com">&lt;ted@redreset.com&gt;</a> -- TED<br />
5583. Ruslan U. Zakirov  <a href="mailto:Ruslan.Zakirov@gmail.com">&lt;Ruslan.Zakirov@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUZ">RUZ</a><br />

5584. <a href="http://www.eyrie.org/~eagle/">Russ Allbery</a>  <a href="mailto:rra@stanford.edu">&lt;rra@stanford.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RR/RRA">RRA</a><br />
5585. <a href="http://www.techbench.net/perl/netfilter">Russ Mennie</a>  <a href="mailto:russm@techbench.net">&lt;russm@techbench.net&gt;</a> -- RMENNIE<br />
5586. Russ Tremain  <a href="mailto:russtman@gmail.com">&lt;russtman@gmail.com&gt;</a> -- RUSST<br />

5587. Russell B Cecala  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CE/CECALA">CECALA</a><br />
5588. <a href="http://russ.glaue.org">Russell E Glaue</a>  <a href="mailto:rglaue@gmail.com">&lt;rglaue@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RG/RGLAUE">RGLAUE</a><br />
5589. Russell Graham  <a href="mailto:russgraham@gmail.com">&lt;russgraham@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RW/RWG">RWG</a><br />

5590. Russell Harrison  <a href="mailto:rch@cpan.org">&lt;rch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCH">RCH</a><br />
5591. <a href="http://www.s8n.net/">Russell Heilling</a>  <a href="mailto:chewtoy@s8n.net">&lt;chewtoy@s8n.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CH/CHEWTOY">CHEWTOY</a><br />
5592. <a href="www.starcaller.com">Russell Jurney</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RJURNEY<br />

5593. Russell Kackley  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKACKLEY">RKACKLEY</a><br />
5594. <a href="http://appwrap.org/">Russell Lundberg</a>  <a href="mailto:lundberg.russell@gmail.com">&lt;lundberg.russell@gmail.com&gt;</a> -- LUNDO<br />
5595. <a href="http://www.russell.matbouli.org/">Russell Matbouli</a>  <a href="mailto:pause-spam@russell.matbouli.org">&lt;pause-spam@russell.matbouli.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/ID/IDORU">IDORU</a><br />

5596. <a href="http://www.duskglow.com">Russell Miller</a>  <a href="mailto:rmiller@duskglow.com">&lt;rmiller@duskglow.com&gt;</a> -- RMILLER<br />
5597. Russell Mosemann  <a href="mailto:mose@ns.cune.edu">&lt;mose@ns.cune.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RM/RMOSE">RMOSE</a><br />
5598. Russell Pettway  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUSSELLP">RUSSELLP</a><br />

5599. <a href="http://parallel.hpc.unsw.edu.au/">Russell Standish</a>  <a href="mailto:R.Standish@unsw.edu.au">&lt;R.Standish@unsw.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RK/RKS">RKS</a><br />
5600. <a href="http://www.best.com/~quong">Russell W Quong</a>  <a href="mailto:quong@best.com">&lt;quong@best.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Q/QU/QUONG">QUONG</a><br />
5601. <a href="http://www.infogears.com">Rusty Conover</a>  <a href="mailto:rconover@infogears.com">&lt;rconover@infogears.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RC/RCONOVER">RCONOVER</a><br />

5602. <a href="http://rustyp.freeshell.org">Rusty Phillips</a>  <a href="mailto:rustyp@freeshell.org">&lt;rustyp@freeshell.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUSTYP">RUSTYP</a><br />
5603. Rusty W. Shanklin  <a href="mailto:rusty.shanklin@pikevillehospital.org">&lt;rusty.shanklin@pikevillehospital.org&gt;</a> -- RSHANKLIN<br />
5604. Rutger Vos  <a href="mailto:rvos@interchange.ubc.ca">&lt;rvos@interchange.ubc.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RV/RVOSA">RVOSA</a><br />

5605. <a href="http://ry4an.org/">Ry4an Brase</a>  <a href="mailto:ry4an DASH cpan AT ry4an DOT org">&lt;ry4an DASH cpan AT ry4an DOT org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RB/RBRASE">RBRASE</a><br />
5606. <a href="http://web.mit.edu/iceman/www">Ryan Adams</a>  <a href="mailto:Rippa300ZXTT@hotmail.com">&lt;Rippa300ZXTT@hotmail.com&gt;</a> -- RADAMS<br />
5607. <a href="www.ryan.dietrich.net">Ryan Alan Dietrich</a>  <a href="mailto:ryan@dietrich.net">&lt;ryan@dietrich.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RD/RDIETRICH">RDIETRICH</a><br />

5608. <a href="http://www.endymion.com/">Ryan Alyn Porter</a>  <a href="mailto:rap@endymion.com">&lt;rap@endymion.com&gt;</a> -- RAP<br />
5609. <a href="http://malander.undrgnd.net">Ryan Bastic</a>  <a href="mailto:xmalander@yahoo.com">&lt;xmalander@yahoo.com&gt;</a> -- MALANDER<br />
5610. <a href="http://ryanc.org/">Ryan Castellucci</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RYANC<br />

5611. Ryan D Johnson  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RDJ<br />
5612. <a href="http://www.zenspider.com/">Ryan Davis</a>  <a href="mailto:spam-perl@zenspider.com">&lt;spam-perl@zenspider.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZENSPIDER">ZENSPIDER</a><br />
5613. <a href="http://www.detz.net">Ryan Detzel</a>  <a href="mailto:detz@cpan.org">&lt;detz@cpan.org&gt;</a> -- DETZ<br />

5614. Ryan Eatmon  <a href="mailto:reatmon@mail.com">&lt;reatmon@mail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RE/REATMON">REATMON</a><br />
5615. Ryan Erwin  <a href="mailto:ryan@web.oakley.com">&lt;ryan@web.oakley.com&gt;</a> -- ERWIN<br />
5616. <a href="http://www.gigabee.com/">Ryan Fischer</a>  <a href="mailto:ryan@gigabee.com">&lt;ryan@gigabee.com&gt;</a> -- RYAN<br />

5617. <a href="http://ryan.ignore.us">Ryan Gerry</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- GERRYSTER<br />
5618. <a href="www.livesite.net">Ryan Gies</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RY/RYANGIES">RYANGIES</a><br />
5619. Ryan Golhar  <a href="mailto:golharam@umdnj.edu">&lt;golharam@umdnj.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GOLHARAM">GOLHARAM</a><br />

5620. Ryan Hunt  <a href="mailto:info@ryanhunt.info">&lt;info@ryanhunt.info&gt;</a> -- RYANHUNT<br />
5621. Ryan J Rose  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RYANROSE<br />
5622. <a href="http://panoptic.com/rking">Ryan King</a>  <a href="mailto:rking@panoptic.com">&lt;rking@panoptic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KING">KING</a><br />

5623. Ryan McGuigan  <a href="mailto:ryan@cardweb.com">&lt;ryan@cardweb.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RY/RYANM">RYANM</a><br />
5624. <a href="http://www.thejamescompany.com">Ryan Parr</a>  <a href="mailto:ryanparr@thejamescompany.com">&lt;ryanparr@thejamescompany.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RY/RYANPARR">RYANPARR</a><br />
5625. Ryan Perry  <a href="mailto:rperry@womenshealth.com">&lt;rperry@womenshealth.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NAMOTCO">NAMOTCO</a><br />

5626. <a href="http://ttul.org/~rrsadler/">Ryan Sadler</a>  <a href="mailto:rrsadler@ttul.org">&lt;rrsadler@ttul.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RR/RRS">RRS</a><br />
5627. Ryan Voots  <a href="mailto:simcop2387@yahoo.com">&lt;simcop2387@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMCOP">SIMCOP</a><br />
5628. Ryo Okamoto  <a href="mailto:ryochin@cpan.org">&lt;ryochin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RY/RYOCHIN">RYOCHIN</a><br />

5629. Ryohei Isoya  <a href="mailto:isoya@cpan.org">&lt;isoya@cpan.org&gt;</a> -- ISOYA<br />
5630. <a href="http://d.hatena.ne.jp/amari3/">Ryoji Tanida</a>  <a href="mailto:amarisan@cpan.org">&lt;amarisan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AM/AMARISAN">AMARISAN</a><br />
5631. <a href="http://riywo.com">Ryosuke IWANAGA</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RIYWO<br />

5632. <a href="http://d.hatena.ne.jp/dragon3">Ryuzo Yamamoto</a>  <a href="mailto:ryuzo.yamamoto@gmail.com">&lt;ryuzo.yamamoto@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YA/YAMAMOTO">YAMAMOTO</a><br />
5633. Rúben Fonseca  <a href="mailto:fonseka@gmail.com">&lt;fonseka@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROOT">ROOT</a><br />
5634. Rüdiger Peusquens  <a href="mailto:rudy@peusquens.net">&lt;rudy@peusquens.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RP/RPQS">RPQS</a><br />

5635. <a href="http://www.sbmkpm.com/">S Balamurugan</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SB/SBALA">SBALA</a><br />
5636. <a href="http://www.creationfactor.net">S I Warhurst</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWARHURST">SWARHURST</a><br />
5637. S. Kerr  <a href="mailto:kerr@cpan.org">&lt;kerr@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KE/KERR">KERR</a><br />

5638. <a href="http://zac.sprackett.com">S. Zachariah Sprackett</a>  <a href="mailto:zacs@cpan.org">&lt;zacs@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZACS">ZACS</a><br />
5639. S.Gopi  <a href="mailto:sekargopi@yahoo.com">&lt;sekargopi@yahoo.com&gt;</a> -- GOPI<br />
5640. S.Murali Krishnan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMKZONE">SMKZONE</a><br />

5641. SADAHIRO Tomoyuki  <a href="mailto:SADAHIRO@cpan.org">&lt;SADAHIRO@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SADAHIRO">SADAHIRO</a><br />
5642. <a href="http://www.sanface.com">SANFACE Sofware</a>  <a href="mailto:sanface@sanface.com">&lt;sanface@sanface.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANFACE">SANFACE</a><br />
5643. SASAO Takahiro  <a href="mailto:tsasao@gmail.com">&lt;tsasao@gmail.com&gt;</a> -- SASAO<br />

5644. <a href="http://paina.jp/">SATO Taisuke</a>  <a href="mailto:paina@wide.ad.jp">&lt;paina@wide.ad.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PAINA">PAINA</a><br />
5645. SK  <a href="mailto:">&lt;&gt;</a> -- KALNINS<br />
5646. Sachin Sebastian  <a href="mailto:sachinjsk@cpan.org">&lt;sachinjsk@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SACHINJSK">SACHINJSK</a><br />

5647. <a href="http://sagar.freeshell.org/">Sagar R. Shah</a>  <a href="mailto:srshah@cpan.org">&lt;srshah@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRSHAH">SRSHAH</a><br />
5648. Sagiv Barhoom  <a href="mailto:sagivba@gmail.com">&lt;sagivba@gmail.com&gt;</a> -- SAGIVBA<br />
5649. <a href="http://www.d.umn.edu/~kohli003">Saiyam Kohli</a>  <a href="mailto:saiyam_kohli@yahoo.com">&lt;saiyam_kohli@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOHLIS">KOHLIS</a><br />

5650. Sal Zhong (仲伟祥)  <a href="mailto:zhongxiang721@gamil.com">&lt;zhongxiang721@gamil.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAL">SAL</a><br />
5651. Salvador Fandiño García  <a href="mailto:salva@cpan.org">&lt;salva@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SALVA">SALVA</a><br />
5652. Salvador Ortiz  <a href="mailto:sog@msg.com.mx">&lt;sog@msg.com.mx&gt;</a> -- SORTIZ<br />

5653. Salvatore Domenick Desiano  <a href="mailto:sdd@cpan.org">&lt;sdd@cpan.org&gt;</a> -- SDD<br />
5654. Salvatore E. ScottoDiLuzio  <a href="mailto:sal.scotto@gmail.com">&lt;sal.scotto@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSCOTTO">SSCOTTO</a><br />
5655. <a href="http://foo.no/">Salve J. Nilsen</a>  <a href="mailto:sjn@cpan.org">&lt;sjn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJN">SJN</a><br />

5656. Sam Bashton  <a href="mailto:sam@bashton.com">&lt;sam@bashton.com&gt;</a> -- SBASHTON<br />
5657. <a href="http://www.arcs.com">Sam Bazzi</a>  <a href="mailto:sam@arcs.com">&lt;sam@arcs.com&gt;</a> -- SAMBAZZI<br />
5658. Sam Bazzi  <a href="mailto:sam_bazzi@yahoo.com">&lt;sam_bazzi@yahoo.com&gt;</a> -- SBAZZI<br />

5659. <a href="http://www.qheadquarters.com">Sam Cole</a>  <a href="mailto:samcoleSPAM@qheadquarters.com">&lt;samcoleSPAM@qheadquarters.com&gt;</a> -- UNKNOWNQ<br />
5660. <a href="http://www.samcorl.com">Sam Corl</a>  <a href="mailto:sam@samcorl.com">&lt;sam@samcorl.com&gt;</a> -- SAMCORL<br />
5661. <a href="http://www.illusori.co.uk/">Sam Graham</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SG/SGRAHAM">SGRAHAM</a><br />

5662. <a href="http://sam.holden.id.au/">Sam Holden</a>  <a href="mailto:sholden@cs.usyd.edu.au">&lt;sholden@cs.usyd.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHOLDEN">SHOLDEN</a><br />
5663. <a href="http://daemoninc.com">Sam Horrocks</a>  <a href="mailto:sam@daemoninc.com">&lt;sam@daemoninc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HORROCKS">HORROCKS</a><br />
5664. <a href="http://www.illuminated.co.uk/">Sam Kington</a>  <a href="mailto:sam@illuminated.co.uk">&lt;sam@illuminated.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKINGTON">SKINGTON</a><br />

5665. <a href="http://sam.tregar.com">Sam Tregar</a>  <a href="mailto:sam@tregar.com">&lt;sam@tregar.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMTREGAR">SAMTREGAR</a><br />
5666. <a href="http://www.courier-mta.org">Sam Varshavchik</a>  <a href="mailto:sam@email-scan.com">&lt;sam@email-scan.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MR/MRSAM">MRSAM</a><br />
5667. <a href="http://sam.vilain.net/">Sam Vilain</a>  <a href="mailto:sam@vilain.net">&lt;sam@vilain.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMV">SAMV</a><br />

5668. SamHeller  <a href="mailto:sheller@marlboro.edu">&lt;sheller@marlboro.edu&gt;</a> -- SAMHELLER<br />
5669. <a href="http://www.iki.fi/si/">Sami Itkonen</a>  <a href="mailto:si@iki.fi">&lt;si@iki.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAIT">SAIT</a><br />
5670. <a href="http://www.noam.fi">Sami Lehtimäki</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ARACKHAEN<br />

5671. <a href="http://www.iki.fi/sp">Sami Poikonen</a>  <a href="mailto:sp@iki.fi">&lt;sp@iki.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAPAPO">SAPAPO</a><br />
5672. <a href="http://www.bacus.pt/Net_SSLeay/index.html">Sampo Kellomaki</a>  <a href="mailto:sampo@iki.fi">&lt;sampo@iki.fi&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMPO">SAMPO</a><br />
5673. <a href="www.SoftwareDiamonds.com">Samson Monaco Tutankhamen</a>  <a href="mailto:support@SoftwareDiamonds.com">&lt;support@SoftwareDiamonds.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOFTDIA">SOFTDIA</a><br />

5674. <a href="http://www.debain.org">Samuel Abels</a>  <a href="mailto:cpan@debain.org">&lt;cpan@debain.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMUEL">SAMUEL</a><br />
5675. <a href="http://devel.dob.sk">Samuel Behan</a>  <a href="mailto:samsk[on]cpan[dot]org">&lt;samsk[on]cpan[dot]org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMSK">SAMSK</a><br />
5676. <a href="http://www.takkle.com">Samuel Kaufman</a>  <a href="mailto:skaufman@cpan.org">&lt;skaufman@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKAUFMAN">SKAUFMAN</a><br />

5677. Samuel Lauber  <a href="mailto:sam124@operamail.com">&lt;sam124@operamail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAMUELL">SAMUELL</a><br />
5678. <a href="http://csandeep.googlepages.com/">Sandeep Chayapathi</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- CSANDEEP<br />
5679. <a href="http://Sander.vanZoest.com/">Sander van Zoest</a>  <a href="mailto:svanzoest@cpan.org">&lt;svanzoest@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SV/SVANZOEST">SVANZOEST</a><br />

5680. Sandor Patocs  <a href="mailto:sandorpatocs@netscape.net">&lt;sandorpatocs@netscape.net&gt;</a> -- SPATOCS<br />
5681. <a href="http://whippet.stanford.edu/~ssklar/">Sandor W. Sklar</a>  <a href="mailto:ssklar@cpan.org">&lt;ssklar@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSKLAR">SSKLAR</a><br />
5682. <a href="http://www.isoftware.com.br">Sandro Dias Pinto Vitenti</a>  <a href="mailto:sandro@isoftware.com.br">&lt;sandro@isoftware.com.br&gt;</a> -- SVITENTI<br />

5683. Sanford Morton  <a href="mailto:smorton@pobox.com">&lt;smorton@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMORTON">SMORTON</a><br />
5684. Sanjaysen Palash  <a href="mailto:palash_bksys@yahoo.com">&lt;palash_bksys@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEN">SEN</a><br />
5685. <a href="http://www.suaava.com">Sanjit Rath</a>  <a href="mailto:sanjit [.] rath [@] gmail.com">&lt;sanjit [.] rath [@] gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANJIT">SANJIT</a><br />

5686. Sanjoga Sahu  <a href="mailto:sanjogsahu@yahoo.com">&lt;sanjogsahu@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANJOGA">SANJOGA</a><br />
5687. <a href="http://sankorobinson.com/">Sanko Robinson</a>  <a href="mailto:sanko@cpan.org">&lt;sanko@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SANKO">SANKO</a><br />
5688. Santu Nandy  <a href="mailto:santu.nandy@gmail.com">&lt;santu.nandy@gmail.com&gt;</a> -- SANTU<br />

5689. <a href="http://tealseal.com">Sara Starre</a>  <a href="mailto:theperlgirl@yahoo.com">&lt;theperlgirl@yahoo.com&gt;</a> -- PERLGIRL<br />
5690. Saradhi N C  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- NCS<br />
5691. <a href="http://sascha.dibbern.info">Sascha Dibbern</a>  <a href="mailto:sascha@dibbern.info">&lt;sascha@dibbern.info&gt;</a> -- SADIB<br />

5692. <a href="http://www.intertivity.com">Sascha Kiefer</a>  <a href="mailto:perl@intertivityNOSP4M.com">&lt;perl@intertivityNOSP4M.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/ES/ESSKAR">ESSKAR</a><br />
5693. Sascha Krueger  <a href="mailto:">&lt;&gt;</a> -- SAKRU<br />
5694. Sascha Volkenandt  <a href="mailto:sascha@akv-soft.de">&lt;sascha@akv-soft.de&gt;</a> -- VOLKE<br />

5695. Sasha Mukhin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- EVAL<br />
5696. Satanail  <a href="mailto:satanail_spb@mail333.com">&lt;satanail_spb@mail333.com&gt;</a> -- SATANAIL<br />
5697. <a href="http://satoru.net">Satoru Yano</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAYANO">SAYANO</a><br />

5698. <a href="http://yellowstore.blogspot.com/">Satoshi Azuma</a>  <a href="mailto:ytnobody@gmail.com">&lt;ytnobody@gmail.com&gt;</a> -- YTURTLE<br />
5699. <a href="http://www.cybergarage.org">Satoshi Konno</a>  <a href="mailto:skonno@cybergarage.org">&lt;skonno@cybergarage.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKONNO">SKONNO</a><br />
5700. Satoshi Ohkubo  <a href="mailto:s.ohkubo@gmail.com">&lt;s.ohkubo@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BO/BOXPHERE">BOXPHERE</a><br />

5701. Satoshi Tanimoto  <a href="mailto:tanimoto@cpan.org">&lt;tanimoto@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TANIMOTO">TANIMOTO</a><br />
5702. Satyen Dave  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SDAVE<br />
5703. <a href="http://www.iit.edu/~upadsau">Saurabh Upadhyay</a>  <a href="mailto:">&lt;&gt;</a> -- SRBU<br />

5704. Sawyer X  <a href="mailto:xsawyerx [AT] cpan [DOT] org">&lt;xsawyerx [AT] cpan [DOT] org&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XS/XSAWYERX">XSAWYERX</a><br />
5705. Schaubroeck Tony  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SMURF<br />
5706. <a href="http://gl00on.net">Schneelocke</a>  <a href="mailto:pubperl@gl00on.net">&lt;pubperl@gl00on.net&gt;</a> -- SCHNEE<br />

5707. Schumann Serge  <a href="mailto:serge.schumann@mail.ru">&lt;serge.schumann@mail.ru&gt;</a> -- SCHUMANN<br />
5708. Schuyler Erle  <a href="mailto:schuyler@nocat.net">&lt;schuyler@nocat.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDERLE">SDERLE</a><br />
5709. Scot Woodward  <a href="mailto:nutwing@wigwamhq.org">&lt;nutwing@wigwamhq.org&gt;</a> -- WINGNUT<br />
5710. Scott  <a href="mailto:Phoenixl@aol.com">&lt;Phoenixl@aol.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PH/PHOENIXL">PHOENIXL</a><br />

5711. <a href="http://www.geocities.com/dr_saaron">Scott Aaron</a>  <a href="mailto:dr_saaron@yahoo.com">&lt;dr_saaron@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DR/DRSAARON">DRSAARON</a><br />
5712. Scott Beck  <a href="mailto:sbeck@gossamer-threads.com">&lt;sbeck@gossamer-threads.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SABECK">SABECK</a><br />
5713. <a href="http://www.streamsoftware.com">Scott Berkholz</a>  <a href="mailto:scottb@streamsoftware.com">&lt;scottb@streamsoftware.com&gt;</a> -- SBERKHOLZ<br />

5714. Scott Bolte  <a href="mailto:projs+perl@niss.com">&lt;projs+perl@niss.com&gt;</a> -- SBOLTE<br />
5715. <a href="http://www.sboss.net/">Scott Boss</a>  <a href="mailto:scott at sboss dot net">&lt;scott at sboss dot net&gt;</a> -- SBOSS<br />
5716. Scott Bronson  <a href="mailto:bronson@rinspin.com">&lt;bronson@rinspin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BR/BRONSON">BRONSON</a><br />

5717. <a href="http://www.gmod.org/">Scott Cain</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCAIN">SCAIN</a><br />
5718. Scott Cassidy  <a href="mailto:scottlc@cpan.org">&lt;scottlc@cpan.org&gt;</a> -- SCOTTLC<br />
5719. Scott Connelly  <a href="mailto:ssc@cpan.org">&lt;ssc@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSC">SSC</a><br />

5720. Scott Cruzen  <a href="mailto:Trental400@yahoo.com">&lt;Trental400@yahoo.com&gt;</a> -- SIC<br />
5721. <a href="http://scottlee.net/">Scott E. Lee</a>  <a href="mailto:ScottLee@pobox.com">&lt;ScottLee@pobox.com&gt;</a> -- SCOTTLEE<br />
5722. <a href="http://www.daxal.com/">Scott Edwards</a>  <a href="mailto:cpan@foss.daxal.com">&lt;cpan@foss.daxal.com&gt;</a> -- SUPAPLEX<br />

5723. Scott Elcomb  <a href="mailto:psema4@gmail.com">&lt;psema4@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SELCOMB">SELCOMB</a><br />
5724. <a href="http://www.suspectclass.com/~sgifford/">Scott Gifford</a>  <a href="mailto:sgifford@suspectclass.com">&lt;sgifford@suspectclass.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GI/GIFF">GIFF</a><br />
5725. <a href="http://www.scripted.com/">Scott Guelich</a>  <a href="mailto:scott@scripted.com">&lt;scott@scripted.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GU/GUELICH">GUELICH</a><br />

5726. Scott Guthridge  <a href="mailto:pdx_scooter@yahoo.com">&lt;pdx_scooter@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOOTER">SCOOTER</a><br />
5727. <a href="http://www.msu.edu/user/harris41">Scott Harrison</a>  <a href="mailto:sharrison@users.sourceforge.net">&lt;sharrison@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHARRISON">SHARRISON</a><br />
5728. <a href="http://www.sitening.com/">Scott Holdren</a>  <a href="mailto:scott@sitening.com">&lt;scott@sitening.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPLOTCHY">SPLOTCHY</a><br />

5729. <a href="http://www.pobox.com/~shutton/">Scott Hutton</a>  <a href="mailto:shutton@pobox.com">&lt;shutton@pobox.com&gt;</a> -- SHUTTON<br />
5730. Scott K MacPherson  <a href="mailto:skmacphe@cpan.org">&lt;skmacphe@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKMACPHE">SKMACPHE</a><br />
5731. <a href="http://www.simpit.com/">Scott Kahler</a>  <a href="mailto:scottk@uclick.com">&lt;scottk@uclick.com&gt;</a> -- INFERNO<br />

5732. Scott Lanning  <a href="mailto:slanning@cpan.org">&lt;slanning@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLANNING">SLANNING</a><br />
5733. <a href="http://cluon.com/lawrence">Scott Lawrence Statton</a>  <a href="mailto:lawrence@cluon.com">&lt;lawrence@cluon.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLSTAT">SLSTAT</a><br />
5734. <a href="www.littlefish.ca">Scott Mazur</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUZAM">RUZAM</a><br />

5735. <a href="http://www.blisted.org/">Scott McCoy</a>  <a href="mailto:tag@cpan.org">&lt;tag@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAG">TAG</a><br />
5736. Scott McOlash  <a href="mailto:s.mcolash@ieee.org">&lt;s.mcolash@ieee.org&gt;</a> -- SMCOLASH<br />
5737. <a href="http://kungfuftr.com/">Scott McWhirter</a>  <a href="mailto:scott-cpan@NOSPAMkungfuftr.com">&lt;scott-cpan@NOSPAMkungfuftr.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KU/KUNGFUFTR">KUNGFUFTR</a><br />

5738. Scott McWhirter  <a href="mailto:konobi@cpan.org">&lt;konobi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KONOBI">KONOBI</a><br />
5739. <a href="mxplus.org">Scott Nelson</a>  <a href="mailto:scottn@he.net">&lt;scottn@he.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTN">SCOTTN</a><br />
5740. <a href="http://levitator.org/">Scott Parks</a>  <a href="mailto:junk@levitator.org">&lt;junk@levitator.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPARKS">SPARKS</a><br />

5741. Scott Parsons  <a href="mailto:sparsons@cpan.org">&lt;sparsons@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPARSONS">SPARSONS</a><br />
5742. <a href="http://linux.dd.com.au/">Scott Penrose</a>  <a href="mailto:scottp@dd.com.au">&lt;scottp@dd.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTT">SCOTT</a><br />
5743. Scott Peshak  <a href="mailto:speshak@gmail.com">&lt;speshak@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPESHAK">SPESHAK</a><br />

5744. <a href="http://redcloudresearch.blogspot.com">Scott Peterson</a>  <a href="mailto:peterson146@yahoo.com">&lt;peterson146@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RA/RAVENOR">RAVENOR</a><br />
5745. <a href="http://www.webdragon.net/">Scott R. Godin</a>  <a href="mailto:nospam@webdragon.net">&lt;nospam@webdragon.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SG/SGODIN">SGODIN</a><br />
5746. <a href="www.srkconsulting.com">Scott R. Keszler</a>  <a href="mailto:keszler@srkconsulting.com">&lt;keszler@srkconsulting.com&gt;</a> -- KESZLER<br />

5747. Scott Renner  <a href="mailto:srenner@mandtbank.com">&lt;srenner@mandtbank.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SARENNER">SARENNER</a><br />
5748. <a href="http://www.soulcage.net">Scott Scecina</a>  <a href="mailto:scotts@inmind.com">&lt;scotts@inmind.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTS">SCOTTS</a><br />
5749. Scott Schneider  <a href="mailto:sschneid@gmail.com">&lt;sschneid@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSCHNEID">SSCHNEID</a><br />

5750. Scott Smith  <a href="mailto:sakoht (at cpan.org)">&lt;sakoht (at cpan.org)&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAKOHT">SAKOHT</a><br />
5751. Scott Sotka  <a href="mailto:ssotka@barracudanetworks.com">&lt;ssotka@barracudanetworks.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSOTKA">SSOTKA</a><br />
5752. <a href="http://industrial-linux.org">Scott Thomason</a>  <a href="mailto:scott@thomasons.org">&lt;scott@thomasons.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTHOM">SCOTTHOM</a><br />

5753. <a href="http://www.dfw.net/~scottvr">Scott VanRavenswaay</a>  <a href="mailto:scottvr@netcomi.com">&lt;scottvr@netcomi.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTVR">SCOTTVR</a><br />
5754. <a href="http://illogics.org/">Scott Walters</a>  <a href="mailto:scott@illogics.org">&lt;scott@illogics.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWALTERS">SWALTERS</a><br />
5755. <a href="http://scott.wiersdorf.org/perl/">Scott Wiersdorf</a>  <a href="mailto:scott@mailblock.net">&lt;scott@mailblock.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTW">SCOTTW</a><br />

5756. <a href="www.rantster.com">Scott Zuyderduyn</a>  <a href="mailto:scottzed@hotmail.com">&lt;scottzed@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOTTZED">SCOTTZED</a><br />
5757. <a href="http://scottyallen.com">Scotty Allen</a>  <a href="mailto:scotty@scottyallen.com">&lt;scotty@scottyallen.com&gt;</a> -- SCOTTY<br />
5758. <a href="http://www.spots.ab.ca/~whytwolf/">Sean Campbell</a>  <a href="mailto:whytwolf@spots.ab.ca">&lt;whytwolf@spots.ab.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHYTEWOLF">WHYTEWOLF</a><br />

5759. <a href="http://dague.net/sean">Sean Dague</a>  <a href="mailto:sean@NdOaSgPuAeM.net">&lt;sean@NdOaSgPuAeM.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDAGUE">SDAGUE</a><br />
5760. Sean Davis  <a href="mailto:sdavis2@mail.nih.gov">&lt;sdavis2@mail.nih.gov&gt;</a> -- SRDAVIS<br />
5761. Sean DeZurik  <a href="mailto:sdezurik@bellsouth.net">&lt;sdezurik@bellsouth.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDEZURIK">SDEZURIK</a><br />

5762. <a href="http://pop3client.dowds.net">Sean Dowd</a>  <a href="mailto:pop3client-USEMYCPANADDRESSFORHELP@dowds.net">&lt;pop3client-USEMYCPANADDRESSFORHELP@dowds.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDOWD">SDOWD</a><br />
5763. Sean Egan  <a href="mailto:seanegan@bigfoot.com">&lt;seanegan@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEGAN">SEGAN</a><br />
5764. Sean Healy  <a href="mailto:jalopeura@hotmail.com">&lt;jalopeura@hotmail.com&gt;</a> -- JALOPEURA<br />

5765. <a href="http://www.panix.com/~shull/karma">Sean Hull</a>  <a href="mailto:sean.hull@pobox.com">&lt;sean.hull@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHULL">SHULL</a><br />
5766. <a href="http://seanbo.perlmonk.org/">Sean L. Ryle</a>  <a href="mailto:sryle@nospam.com">&lt;sryle@nospam.com&gt;</a> -- SEANBO<br />
5767. <a href="http://www.toaster.net/~slazar/">Sean Lazar</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SLAZAR<br />

5768. <a href="http://cluefactory.com">Sean Levy</a>  <a href="mailto:snl.pause@mailnull.com">&lt;snl.pause@mailnull.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATTILA">ATTILA</a><br />
5769. <a href="http://interglacial.com/~sburke/">Sean M. Burke</a>  <a href="mailto:sburke@cpan.org">&lt;sburke@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SB/SBURKE">SBURKE</a><br />
5770. <a href="http://www-personal.umich.edu/~mcafee/perl/">Sean McAfee</a>  <a href="mailto:mcafee@umich.edu">&lt;mcafee@umich.edu&gt;</a> -- MCAFEE<br />

5771. Sean McCune  <a href="mailto:sean@redhandsoftware.com">&lt;sean@redhandsoftware.com&gt;</a> -- MCC<br />
5772. Sean McMurray  <a href="mailto:cpan@xolo-web.com">&lt;cpan@xolo-web.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMCMURRAY">SMCMURRAY</a><br />
5773. Sean Meisner  <a href="mailto:please don't spam smeisner at cpan dot org">&lt;please don't spam smeisner at cpan dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMEISNER">SMEISNER</a><br />

5774. Sean Mostafavi  <a href="mailto:seanm@undersea.net">&lt;seanm@undersea.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MO/MOSTAFAVI">MOSTAFAVI</a><br />
5775. <a href="http://www.seanodonnell.com">Sean O'Donnell</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SODONNELL<br />
5776. Sean O'Rourke  <a href="mailto:seano@cpan.org">&lt;seano@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEANO">SEANO</a><br />

5777. <a href="http://www.grendels-den.org/">Sean P. Quinlan</a>  <a href="mailto:sean@quinlan.org">&lt;sean@quinlan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEANQ">SEANQ</a><br />
5778. <a href="http://www.bluedot.net/">Sean P. Scanlon</a>  <a href="mailto:sscanlon@cpan.org">&lt;sscanlon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSCANLON">SSCANLON</a><br />
5779. <a href="http://www.halcyon.com/spug/">Seattle Perl Users' Group</a>  <a href="mailto:spug-list@pm.org">&lt;spug-list@pm.org&gt;</a> -- SPUG<br />

5780. <a href="http://www.nederhost.nl/">Sebastiaan Hoogeveen</a>  <a href="mailto:pause-zebaz@nederhost.nl">&lt;pause-zebaz@nederhost.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZE/ZEBAZ">ZEBAZ</a><br />
5781. Sebastian Basilio  <a href="mailto:buddhahead@gmail.com">&lt;buddhahead@gmail.com&gt;</a> -- SILI<br />
5782. Sebastian Carl-Magnus Cato  <a href="mailto:h._cat@hotmail.com">&lt;h._cat@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCATO">SCATO</a><br />

5783. <a href="http://www.zoozle.net/">Sebastian Enger</a>  <a href="mailto:bigfish82@gmail.com">&lt;bigfish82@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SENGER">SENGER</a><br />
5784. Sebastian Freund  <a href="mailto:cpan@sensefactory.de">&lt;cpan@sensefactory.de&gt;</a> -- FREUND<br />
5785. Sebastian Holmqvist  <a href="mailto:">&lt;&gt;</a> -- ZAPHER<br />

5786. Sebastian Knapp  <a href="mailto:sk@computer-leipzig.com">&lt;sk@computer-leipzig.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKNPP">SKNPP</a><br />
5787. <a href="http://labs.kraih.com">Sebastian Riedel</a>  <a href="mailto:sri@labs.kraih.com">&lt;sri@labs.kraih.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRI">SRI</a><br />
5788. Sebastian Schmidt  <a href="mailto:yath@yath.eu.org">&lt;yath@yath.eu.org&gt;</a> -- YATH<br />

5789. Sebastian Schwarz  <a href="mailto:sjsz@cpan.org">&lt;sjsz@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJSZ">SJSZ</a><br />
5790. <a href="http://blog.u2m.nl/">Sebastian Stellingwerff</a>  <a href="mailto:sebastian.cpan@web.expr42.net">&lt;sebastian.cpan@web.expr42.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEBASTIAN">SEBASTIAN</a><br />
5791. <a href="http://perlhacker.org">Sebastian Stumpf</a>  <a href="mailto:sepp@perlhacker.org">&lt;sepp@perlhacker.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEPP">SEPP</a><br />

5792. Sebastian Thürrschmidt  <a href="mailto:thuerrschmidt@gmail.com">&lt;thuerrschmidt@gmail.com&gt;</a> -- THUERRSCH<br />
5793. Sebastian Willert  <a href="mailto:willert@gmail.com">&lt;willert@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WI/WILLERT">WILLERT</a><br />
5794. <a href="http://sourceforge.net/projects/pluglemonsympa">Sebastien DIAZ</a>  <a href="mailto:sebastien.diaz@gmail.com">&lt;sebastien.diaz@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEBDIAZ">SEBDIAZ</a><br />

5795. Sebastien Thebert  <a href="mailto:sebthebert@free.fr">&lt;sebthebert@free.fr&gt;</a> -- STHEBERT<br />
5796. Sebastião Alves Barata  <a href="mailto:Sebastiao.Barata@gamil.com">&lt;Sebastiao.Barata@gamil.com&gt;</a> -- SAB<br />
5797. Secret Squirrel  <a href="mailto:">&lt;&gt;</a> -- AQUACADE<br />
5798. Sedlak Anton  <a href="mailto:ased@cce.cz">&lt;ased@cce.cz&gt;</a> -- ASED<br />

5799. Seiji Sasazuka  <a href="mailto:sasazuka@gmail.com">&lt;sasazuka@gmail.com&gt;</a> -- SASAZUKA<br />
5800. Seiki Koga  <a href="mailto:koga@beard-bear.com">&lt;koga@beard-bear.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KO/KOGA">KOGA</a><br />
5801. Sendu Bala  <a href="mailto:bix@sendu.me.uk">&lt;bix@sendu.me.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SENDU">SENDU</a><br />

5802. Seneca Cunningham  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TETRAGON<br />
5803. Senthilkumar R  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SENTHIL<br />
5804. Sergei A. Fedorov  <a href="mailto:zmij@cpan.org">&lt;zmij@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZM/ZMIJ">ZMIJ</a><br />
5805. <a href="http://www.tapor.com/">Sergei A. Nemarov</a>  <a href="mailto:inpause@tapor.com">&lt;inpause@tapor.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNEMAROV">SNEMAROV</a><br />

5806. Sergei Golubchik  <a href="mailto:sergii@pisem.net">&lt;sergii@pisem.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SERG">SERG</a><br />
5807. Sergei Tsarev  <a href="mailto:spam@hole.com">&lt;spam@hole.com&gt;</a> -- STSAREV<br />
5808. <a href="www.actualscript.com">Sergei Zaytsev</a>  <a href="mailto:szaytsev@hotmail.com">&lt;szaytsev@hotmail.com&gt;</a> -- SEZAY<br />

5809. Sergey  <a href="mailto:vladislav@cpan.org">&lt;vladislav@cpan.org&gt;</a> -- VLADISLAV<br />
5810. Sergey Aleynikov  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- RANDIR<br />
5811. <a href="http://bor.org.ua">Sergey Borodich</a>  <a href="mailto:bor@univ.kiev.ua">&lt;bor@univ.kiev.ua&gt;</a> -- BOR<br />

5812. <a href="http://www.sergeychernyshev.com/">Sergey Chernyshev</a>  <a href="mailto:sergeyche@cpan.org">&lt;sergeyche@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SERGEYCHE">SERGEYCHE</a><br />
5813. <a href="http://www.sergey.com">Sergey Gribov</a>  <a href="mailto:sergey@sergey.com">&lt;sergey@sergey.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SERGEY">SERGEY</a><br />
5814. Sergey Kotenko  <a href="mailto:graykot@gmail.com">&lt;graykot@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAYKOT">GRAYKOT</a><br />

5815. Sergey Leonovich  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SLEONOV<br />
5816. <a href="http://martynoff.info">Sergey Martynoff</a>  <a href="mailto:martynoff@cpan.org">&lt;martynoff@cpan.org&gt;</a> -- MARTYNOFF<br />
5817. <a href="http://javascript.cooldev.com">Sergey Nosenko</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- DARKNOS<br />

5818. Sergey Redin  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TEAK<br />
5819. <a href="http://eportal.sourceforge.net">Sergey Rusakov</a>  <a href="mailto:rusakov_sa@users.sourceforge.net">&lt;rusakov_sa@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RU/RUSAKOV">RUSAKOV</a><br />
5820. <a href="http://www.rybalko.org">Sergey Rybalko</a>  <a href="mailto:sergey@rybalko.org">&lt;sergey@rybalko.org&gt;</a> -- IGSTAR<br />

5821. Sergey Sinkovskiy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GL/GLORYBOX">GLORYBOX</a><br />
5822. Sergey Skvortsov  <a href="mailto:skv@protey.ru">&lt;skv@protey.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GD/GDSL">GDSL</a><br />
5823. <a href="http://www.pyaticom.ru">Sergey Tomoulevitch</a>  <a href="mailto:phoinix.public@gmail.com">&lt;phoinix.public@gmail.com&gt;</a> -- TMULEVICH<br />

5824. Sergey V. Kolychev  <a href="mailto:ksv@al.lg.ua">&lt;ksv@al.lg.ua&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKOLYCHEV">SKOLYCHEV</a><br />
5825. <a href="http://weg.ee.usyd.edu.au/people/sergio">Sergio FRESCHI</a>  <a href="mailto:sfreschi@ieee.org">&lt;sfreschi@ieee.org&gt;</a> -- SFRESCHI<br />
5826. Sergio Gelato  <a href="mailto:gelato@oort.ap.sissa.it">&lt;gelato@oort.ap.sissa.it&gt;</a> -- SGEL<br />

5827. <a href="http://trouchelle.com/">Serguei Trouchelle</a>  <a href="mailto:stro@railways.dp.ua">&lt;stro@railways.dp.ua&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRO">STRO</a><br />
5828. Seth Burgess  <a href="mailto:sjburges@gimp.org">&lt;sjburges@gimp.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJBURGES">SJBURGES</a><br />
5829. <a href="http://www.pdamusic.com/">Seth David Johnson</a>  <a href="mailto:seth@pdamusic.com">&lt;seth@pdamusic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SETHJ">SETHJ</a><br />

5830. Seth Gordon  <a href="mailto:sgordon@kenan.com">&lt;sgordon@kenan.com&gt;</a> -- SETHG<br />
5831. Seth L. Blumberg  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- METAL<br />
5832. <a href="http://github.com/sethviebrock/">Seth Viebrock</a>  <a href="mailto:seth.viebrock+cpan@gmail.com">&lt;seth.viebrock+cpan@gmail.com&gt;</a> -- SVIEBROCK<br />

5833. Sevastian Foglia  <a href="mailto:sevastian@email.it">&lt;sevastian@email.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEVA">SEVA</a><br />
5834. <a href="http://www.jerboaa.org">Severin Gehwolf</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JERBOAA">JERBOAA</a><br />
5835. <a href="http://users.rcn.com/seyhan">Seyhan Ersoy</a>  <a href="mailto:seyhan@rcn.com">&lt;seyhan@rcn.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEYHAN">SEYHAN</a><br />

5836. <a href="http://hamid.morva.net/">Seyyed Hamid Reza Hashemi Golpayegani</a>  <a href="mailto:hamid@morva.net">&lt;hamid@morva.net&gt;</a> -- HAMID<br />
5837. <a href="http://www.whatever3d.com">Seán Cannon</a>  <a href="mailto:sean@aquest.com">&lt;sean@aquest.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DODGER">DODGER</a><br />
5838. Shahbaz Javeed  <a href="mailto:sjaveed@gmail.com">&lt;sjaveed@gmail.com&gt;</a> -- SJAVEED<br />

5839. Shahir F Laskar  <a href="mailto:sflaskar@gmail.com">&lt;sflaskar@gmail.com&gt;</a> -- SAHIR<br />
5840. Shan Jiang  <a href="mailto:">&lt;&gt;</a> -- JIANGS<br />
5841. Shane Allen  <a href="mailto:opiate-at-gmail-dot-com">&lt;opiate-at-gmail-dot-com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OP/OPIATE">OPIATE</a><br />
5842. <a href="http://srl.livejournal.com">Shane Landrum</a>  <a href="mailto:srl@cpan.org">&lt;srl@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRL">SRL</a><br />

5843. <a href="http://www.themacs.com/">Shane McCarron</a>  <a href="mailto:shane@themacs.com">&lt;shane@themacs.com&gt;</a> -- SPM<br />
5844. <a href="http://speeves.erikin.com">Shannon Eric Peevey</a>  <a href="mailto:speeves@erikin.com">&lt;speeves@erikin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPEEVES">SPEEVES</a><br />
5845. <a href="http://www.ipwebdev.com">Shannon Speechley</a>  <a href="mailto:shannon@ipwebdev.com">&lt;shannon@ipwebdev.com&gt;</a> -- SHANNON<br />

5846. <a href="http://www.sharypov.ru/">Sharypov Alexey</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SHV<br />
5847. Shaun Dawson  <a href="mailto:scdawson@gmail.com">&lt;scdawson@gmail.com&gt;</a> -- SHAUN<br />
5848. Shaun Fryer  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SF/SFRYER">SFRYER</a><br />

5849. <a href="http://l8nite.net/">Shaun Guth</a>  <a href="mailto:pause@l8nite.net">&lt;pause@l8nite.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHAUNGUTH">SHAUNGUTH</a><br />
5850. Shawn Boyette  <a href="mailto:mdxi@cpan.org">&lt;mdxi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MD/MDXI">MDXI</a><br />
5851. <a href="http://sartak.org/">Shawn M Moore</a>  <a href="mailto:sartak@gmail.com">&lt;sartak@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SARTAK">SARTAK</a><br />

5852. <a href="perlhelp.com">Shawn McKinley</a>  <a href="mailto:shawn@perlhelp.com">&lt;shawn@perlhelp.com&gt;</a> -- KURGAN<br />
5853. Shawn P. Wallace  <a href="mailto:shawn@as220.org">&lt;shawn@as220.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHAWNPW">SHAWNPW</a><br />
5854. <a href="http://www.networkapp.com">Shawn Poulson</a>  <a href="mailto:spoulson@networkapp.com">&lt;spoulson@networkapp.com&gt;</a> -- SPOULSON<br />

5855. <a href="http://www.sackheads.org/~ssoriche">Shawn Sorichetti</a>  <a href="mailto:ssoriche@gmail.com">&lt;ssoriche@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSORICHE">SSORICHE</a><br />
5856. Shawn Van Ittersum  <a href="mailto:cpan@vantech.com">&lt;cpan@vantech.com&gt;</a> -- SHAWNVAN<br />
5857. Shawn Zabel  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZABEL">ZABEL</a><br />

5858. Shay Harding  <a href="mailto:sharding@ccbill.com">&lt;sharding@ccbill.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHAYH">SHAYH</a><br />
5859. Sheldon McKay  <a href="mailto:mckays@cshl.edu">&lt;mckays@cshl.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMCKAY">SMCKAY</a><br />
5860. Sheridan C. Rawlins  <a href="mailto:scr14@cornell.edu">&lt;scr14@cornell.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCR">SCR</a><br />

5861. Sherm Pendley  <a href="mailto:">&lt;&gt;</a> -- SHERM<br />
5862. Sherwin Daganato  <a href="mailto:sherwind@gmail.com">&lt;sherwind@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHERWIN">SHERWIN</a><br />
5863. <a href="http://www.artosaur.com/">Sherzod Ruzmetov</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHERZODR">SHERZODR</a><br />

5864. <a href="http://www.anarres.org/">Shevek</a>  <a href="mailto:cpan@anarres.org">&lt;cpan@anarres.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHEVEK">SHEVEK</a><br />
5865. <a href="http://www.tamacom.com/~shigio/">Shigio Yamaguchi</a>  <a href="mailto:shigio@tamacom.com">&lt;shigio@tamacom.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIGIO">SHIGIO</a><br />
5866. <a href="http://seika.ath.cx">Shingo Kikugawa</a>  <a href="mailto:4n5@agr.kyushu-u.ac.jp">&lt;4n5@agr.kyushu-u.ac.jp&gt;</a> -- SNGJOKEN<br />

5867. <a href="http://rananim.ie.u-ryukyu.ac.jp/kono/software-e.html">Shinji KONO</a>  <a href="mailto:kono@ie.u-ryukyu.ac.jp">&lt;kono@ie.u-ryukyu.ac.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIKONO">SHIKONO</a><br />
5868. Shisheng Li  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- LAZYBONE<br />
5869. Shishir Gundavaram  <a href="mailto:shishir@oreilly.com">&lt;shishir@oreilly.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHGUN">SHGUN</a><br />

5870. <a href="http://www.shlomifish.org/">Shlomi Fish</a>  <a href="mailto:shlomif@iglu.org.il">&lt;shlomif@iglu.org.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHLOMIF">SHLOMIF</a><br />
5871. <a href="http://cs.haifa.ac.il/~shlomo/">Shlomo Yona</a>  <a href="mailto:shlomoy@cpan.org">&lt;shlomoy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHLOMOY">SHLOMOY</a><br />
5872. <a href="http://www.semuel.co.il">Shmuel Fomberg</a>  <a href="mailto:owner@semuel.co.il">&lt;owner@semuel.co.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SE/SEMUELF">SEMUELF</a><br />

5873. <a href="http://www.securenetshop.com/">Shopping Cart</a>  <a href="mailto:sns@cpan.org">&lt;sns@cpan.org&gt;</a> -- SNS<br />
5874. <a href="http://deathmarch.orz.hm/">Shota Takayama</a>  <a href="mailto:shot@bindstorm.jp">&lt;shot@bindstorm.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHOT">SHOT</a><br />
5875. Shraddha Pai  <a href="mailto:pai@cshl.edu">&lt;pai@cshl.edu&gt;</a> -- SPAI<br />

5876. Shree Vaithilingam  <a href="mailto:blueguard@gmail.com">&lt;blueguard@gmail.com&gt;</a> -- BLUEGUARD<br />
5877. Shu Xiao  <a href="mailto:sxiao@cisco.com">&lt;sxiao@cisco.com&gt;</a> -- CTCSHAW<br />
5878. <a href="http://tan.homeip.net">Shufeng Tan</a>  <a href="mailto:shufengtan@gmail.com">&lt;shufengtan@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TANGENT">TANGENT</a><br />

5879. <a href="http://www.huque.com/~shuque/">Shumon Huque</a>  <a href="mailto:perl-modules@huque.com">&lt;perl-modules@huque.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHUQUE">SHUQUE</a><br />
5880. <a href="http://www.cs.utah.edu/~sidd">Siddharth Patwardhan</a>  <a href="mailto:sidd@cs.utah.edu">&lt;sidd@cs.utah.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SID">SID</a><br />
5881. <a href="http://www.smalhotra.org">Sidharth Malhotra</a>  <a href="mailto:sxm124@cwru.edu">&lt;sxm124@cwru.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMALHOTRA">SMALHOTRA</a><br />

5882. Simeon Warner  <a href="mailto:simeon@cs.cornell.edu">&lt;simeon@cs.cornell.edu&gt;</a> -- SIMEON<br />
5883. <a href="http://www.hacknix.net">Simon Adlem</a>  <a href="mailto:simon@hacknix.net">&lt;simon@hacknix.net&gt;</a> -- RUNE<br />
5884. <a href="http://hitherto.net">Simon Batistoni</a>  <a href="mailto:simon@hitherto.net">&lt;simon@hitherto.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HI/HITHERTO">HITHERTO</a><br />

5885. Simon Berg  <a href="mailto:karl@it.kth.se">&lt;karl@it.kth.se&gt;</a> -- KSB<br />
5886. <a href="http://puzzworks.com/">Simon Bertrang</a>  <a href="mailto:simon.bertrang@puzzworks.com">&lt;simon.bertrang@puzzworks.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JANUS">JANUS</a><br />
5887. <a href="http://www.bpfh.net/">Simon Burr</a>  <a href="mailto:simes@bpfh.net">&lt;simes@bpfh.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMES">SIMES</a><br />

5888. <a href="http://reality.sgi.com/sc/">Simon Cooper</a>  <a href="mailto:sc@sgi.com">&lt;sc@sgi.com&gt;</a> -- SCOOPER<br />
5889. Simon Cozens  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMON">SIMON</a><br />
5890. Simon David Clinch  <a href="mailto:simon@sermode.com">&lt;simon@sermode.com&gt;</a> -- SIMONC<br />

5891. Simon Day  <a href="mailto:cpan@simonday.info">&lt;cpan@simonday.info&gt;</a> -- SIMM<br />
5892. Simon Drabble  <a href="mailto:sdrabble@cpan.org">&lt;sdrabble@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDRABBLE">SDRABBLE</a><br />
5893. <a href="http://www.browsing.co.uk/">Simon Elliott</a>  <a href="mailto:cpan@browsing.co.uk">&lt;cpan@browsing.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/E/EL/ELLIOTT">ELLIOTT</a><br />

5894. <a href="http://www.simonflack.com">Simon Flack</a>  <a href="mailto:sf AT flacks.net">&lt;sf AT flacks.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMONFLK">SIMONFLK</a><br />
5895. <a href="http://www.bbc.co.uk/learning">Simon Flack (BBC)</a>  <a href="mailto:-">&lt;-&gt;</a> -- BBCSIMONF<br />
5896. Simon J. Hardy-Francis  <a href="mailto:simonhf@cpan.org">&lt;simonhf@cpan.org&gt;</a> -- SIMONHF<br />

5897. Simon Johnston  <a href="mailto:sjohnsto@rational.com">&lt;sjohnsto@rational.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMONJ">SIMONJ</a><br />
5898. <a href="http://simon.kittle.info/">Simon Kittle</a>  <a href="mailto:">&lt;&gt;</a> -- SKIT<br />
5899. <a href="www.winor.com">Simon Liu</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PASSOS<br />

5900. Simon Matthews  <a href="mailto:sam@applicity.co.uk">&lt;sam@applicity.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAM">SAM</a><br />
5901. <a href="http://www.ccso.co.uk">Simon McCaughey</a>  <a href="mailto:simonmcc@ccso.co.uk">&lt;simonmcc@ccso.co.uk&gt;</a> -- SIMONMCC<br />
5902. <a href="http://www.mullis.co.uk/">Simon Mullis</a>  <a href="mailto:simon-cpan@mullis.co.uk">&lt;simon-cpan@mullis.co.uk&gt;</a> -- SMULLIS<br />

5903. <a href="http://so.bi.umist.ac.uk/">Simon Oliver</a>  <a href="mailto:Simon.Oliver@umist.ac.uk">&lt;Simon.Oliver@umist.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOLIVER">SOLIVER</a><br />
5904. <a href="http://unitycode.org">Simon P. Ditner</a>  <a href="mailto:simon-cpan@unitycode.org">&lt;simon-cpan@unitycode.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPDITNER">SPDITNER</a><br />
5905. Simon Parsons  <a href="mailto:caillte@ityen.freeserve.co.uk">&lt;caillte@ityen.freeserve.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAILLTE">CAILLTE</a><br />

5906. <a href="www.coderesult.co.uk">Simon Paulger</a>  <a href="mailto:simonjpaulger@hotmail.com">&lt;simonjpaulger@hotmail.com&gt;</a> -- SPAULGER<br />
5907. <a href="http://nomis80.org">Simon Perreault</a>  <a href="mailto:nomis80@nomis80.org">&lt;nomis80@nomis80.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMONP">SIMONP</a><br />
5908. <a href="http://www.simonproctor.com">Simon Proctor</a>  <a href="mailto:cpan@simonproctor.com">&lt;cpan@simonproctor.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPROCTOR">SPROCTOR</a><br />

5909. <a href="www.unisolve.com.au">Simon Taylor</a>  <a href="mailto:simon@unisolve.com.au">&lt;simon@unisolve.com.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNISOLVE">UNISOLVE</a><br />
5910. <a href="http://legba.ifrc.mcw.edu/~simont/">Simon Twigger</a>  <a href="mailto:simont@mcw.edu">&lt;simont@mcw.edu&gt;</a> -- STWIGGER<br />
5911. Simon Whitaker  <a href="mailto:swhitaker@cpan.org">&lt;swhitaker@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWHITAKER">SWHITAKER</a><br />

5912. Simon Wilcox  <a href="mailto:perl@digitalcraftsmen.net">&lt;perl@digitalcraftsmen.net&gt;</a> -- SWILCOX<br />
5913. <a href="http://www.thegestalt.org/simon/">Simon Wistow</a>  <a href="mailto:simonw@cpan.org">&lt;simonw@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMONW">SIMONW</a><br />
5914. Simone Cesano  <a href="mailto:scesano@cpan.org">&lt;scesano@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCESANO">SCESANO</a><br />

5915. <a href="http://www.simplewire.com/">Simplewire</a>  <a href="mailto:sdk@simplewire.com">&lt;sdk@simplewire.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROOTLEVEL">ROOTLEVEL</a><br />
5916. Singh T. Junior  <a href="mailto:singhtjunior@gmail.com">&lt;singhtjunior@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSINGH">TSINGH</a><br />
5917. <a href="people.freenet.de/sini">Sinisa Susnjar</a>  <a href="mailto:sini@cpan.org">&lt;sini@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SINI">SINI</a><br />

5918. Sir Robert Burbridge  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SIRROBERT<br />
5919. Sisyphus  <a href="mailto:sisyphus@cpan.org">&lt;sisyphus@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SISYPHUS">SISYPHUS</a><br />
5920. Siva Bala Murugan  <a href="mailto:sivas_mp@yahoo.com">&lt;sivas_mp@yahoo.com&gt;</a> -- SMURUGAN<br />
5921. <a href="http://dazjorz.com">Sjors Gielen</a>  <a href="mailto:dazjorz@dazjorz.com">&lt;dazjorz@dazjorz.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAZJORZ">DAZJORZ</a><br />

5922. <a href="http://rbe.homeip.net">Skaman Sam Tyler</a>  <a href="mailto:skamansam@gmail.com">&lt;skamansam@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKAMANSAM">SKAMANSAM</a><br />
5923. <a href="http://users.outlook.net/~sbizyaye/dynagzip/">Slava Bizyayev</a>  <a href="mailto:sbizyaye@outlook.net">&lt;sbizyaye@outlook.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLAVA">SLAVA</a><br />
5924. <a href="http://laffer.sf.net">Slavej Karadjov</a>  <a href="mailto:slaff@linux-bg.org">&lt;slaff@linux-bg.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLAFF">SLAFF</a><br />

5925. <a href="http://www.rezic.de/eserte/">Slaven Rezić</a>  <a href="mailto:slaven@rezic.de">&lt;slaven@rezic.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SREZIC">SREZIC</a><br />
5926. Smart Monkey  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- PURL<br />
5927. <a href="http://www.smartworker.org/">SmartWorker folks at HBE</a>  <a href="mailto:gozer@hbesoftware.com">&lt;gozer@hbesoftware.com&gt;</a> -- SMARTWORK<br />

5928. Smylers  <a href="mailto:smylers@cpan.org">&lt;smylers@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMYLERS">SMYLERS</a><br />
5929. <a href="www.whizdog.com">Snehanshu Shah</a>  <a href="mailto:sshah@whizdog.com">&lt;sshah@whizdog.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WH/WHIZDOG">WHIZDOG</a><br />
5930. <a href="http://6dev.net">Sofian Brabez</a>  <a href="mailto:sbz@cpan.org">&lt;sbz@cpan.org&gt;</a> -- SBZ<br />

5931. Solli Moreira Honorio  <a href="mailto:shonorio@gmail.com">&lt;shonorio@gmail.com&gt;</a> -- SHONORIO<br />
5932. Solomon White  <a href="mailto:solomon_white@hotmail.com">&lt;solomon_white@hotmail.com&gt;</a> -- SOLO<br />
5933. Soren Mou Jakobsen  <a href="mailto:asdf@diku.dk">&lt;asdf@diku.dk&gt;</a> -- SMJAKOBS<br />
5934. <a href="http://d.hatena.ne.jp/hao_yayoi/">Soshi Tamura</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- HAOYAYOI<br />

5935. <a href="http://www.DotCom.fr/max">Soulé Maxime</a>  <a href="mailto:max@dotcom.fr">&lt;max@dotcom.fr&gt;</a> -- SMAXIME<br />
5936. Spee Fourie  <a href="mailto:fouri_s@mtn.co.za">&lt;fouri_s@mtn.co.za&gt;</a> -- CANONB<br />
5937. <a href="http://spencerogden.com">Spencer Ogden</a>  <a href="mailto:spencer@spencerogden.com">&lt;spencer@spencerogden.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJO">SJO</a><br />

5938. <a href="http://orb.dynalias.net/~spider/">Spider Boardman</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPIDB">SPIDB</a><br />
5939. <a href="http://www.tealseal.com/">Spider Mills</a>  <a href="mailto:perl_rocks@hotmail.com">&lt;perl_rocks@hotmail.com&gt;</a> -- TEALSEAL<br />
5940. <a href="http://idaru.blogspot.com">Spiros Denaxas</a>  <a href="mailto:s.denaxas@gmail.com">&lt;s.denaxas@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDEN">SDEN</a><br />

5941. <a href="www.languagesemantics.com">Sreekanth Kocharlakota</a>  <a href="mailto:conflictanalyzer@gmail.com">&lt;conflictanalyzer@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SREEKANTH">SREEKANTH</a><br />
5942. <a href="www.sriramrajagopalan.de">Sriram Rajagopalan</a>  <a href="mailto:rj_sri@yahoo.com">&lt;rj_sri@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RJ/RJSRI">RJSRI</a><br />
5943. Sriram Srinivasan  <a href="mailto:sriram@weblogic.com">&lt;sriram@weblogic.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRIRAM">SRIRAM</a><br />

5944. Stacy Lacy  <a href="mailto:stacy-lacy@worldnet.att.net">&lt;stacy-lacy@worldnet.att.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STLACY">STLACY</a><br />
5945. <a href="http://www.arc.ab.ca/vr/opengl">Stan Melax</a>  <a href="mailto:melax@bioware.com">&lt;melax@bioware.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STANM">STANM</a><br />
5946. Stan Sander  <a href="mailto:harvested@sblan.net">&lt;harvested@sblan.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STSANDER">STSANDER</a><br />

5947. Stan Sawa  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- ECTO<br />
5948. <a href="http://sharat.co.il/frodo/">Stanislav Malyshev</a>  <a href="mailto:frodo@sharat.co.il">&lt;frodo@sharat.co.il&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMALYSHEV">SMALYSHEV</a><br />
5949. Stanley Hopcroft  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOPCROFTS">HOPCROFTS</a><br />

5950. <a href="http://stason.org">Stas Bekman</a>  <a href="mailto:stas@stason.org">&lt;stas@stason.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STAS">STAS</a><br />
5951. Stas Grabois  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STSI">STSI</a><br />
5952. Stas Ukolov  <a href="mailto:ukoloff@cpan.org">&lt;ukoloff@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UK/UKOLOFF">UKOLOFF</a><br />

5953. <a href="http://www.stathy.com/">Stathy G. Touloumis</a>  <a href="mailto:stathy-pause@stathy.com">&lt;stathy-pause@stathy.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STATHY">STATHY</a><br />
5954. Stefan Baumann  <a href="mailto:s.baumann@uptime.at">&lt;s.baumann@uptime.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEFAN">STEFAN</a><br />
5955. <a href="http://www.fischerlaender.net">Stefan Fischerländer</a>  <a href="mailto:cpan@fischerlaender.de">&lt;cpan@fischerlaender.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SF/SFI">SFI</a><br />

5956. <a href="http://www.linuxia.de/">Stefan Hornburg</a>  <a href="mailto:racke@linuxia.de">&lt;racke@linuxia.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HORNBURG">HORNBURG</a><br />
5957. <a href="http://www.maygill.com/oobuilder">Stefan Loones</a>  <a href="mailto:cpan@maygill.com">&lt;cpan@maygill.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MAYGILL">MAYGILL</a><br />
5958. <a href="http://www.merten-home.de/">Stefan Merten</a>  <a href="mailto:smerten@oekonux.de">&lt;smerten@oekonux.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMERTEN">SMERTEN</a><br />

5959. Stefan Michel  <a href="mailto:smichel@cpan.org">&lt;smichel@cpan.org&gt;</a> -- SMICHEL<br />
5960. Stefan O'Rear  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOREAR">SOREAR</a><br />
5961. <a href="http://purl.net/stefan_ram/">Stefan Ram</a>  <a href="mailto:ram@zedat.fu-berlin.de">&lt;ram@zedat.fu-berlin.de&gt;</a> -- STEFANRAM<br />

5962. Stefan Reddig  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SREAGLE">SREAGLE</a><br />
5963. Stefan Seifert  <a href="mailto:nine@cpan.org">&lt;nine@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NI/NINE">NINE</a><br />
5964. Stefan Talpalaru  <a href="mailto:stefantalpalaru@yahoo.com">&lt;stefantalpalaru@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEFANT">STEFANT</a><br />

5965. <a href="http://www.oesiman.de">Stefan Traby</a>  <a href="mailto:stefan@hello-penguin.com">&lt;stefan@hello-penguin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OE/OESI">OESI</a><br />
5966. Stefan Trcek  <a href="mailto:web-2006-robot@web.de">&lt;web-2006-robot@web.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRCEK">STRCEK</a><br />
5967. Stefan Wolf  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SWOLF<br />

5968. Stefan Zasada  <a href="mailto:sjz@NOSPAM.zasada.co.uk">&lt;sjz@NOSPAM.zasada.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJZASADA">SJZASADA</a><br />
5969. Stefano Bettelli  <a href="mailto:bettelli@cpan.org">&lt;bettelli@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/B/BE/BETTELLI">BETTELLI</a><br />
5970. <a href="http://www.madeinlinux.com/">Stefano Corsi</a>  <a href="mailto:ippo@madeinlinux.com">&lt;ippo@madeinlinux.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IP/IPPO">IPPO</a><br />

5971. <a href="http://larsen.perlmonk.org">Stefano Rodighiero</a>  <a href="mailto:larsen@perl.it">&lt;larsen@perl.it&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LA/LARSEN">LARSEN</a><br />
5972. <a href="http://www.engelschall.com/u/sb/download/">Steffen Beyer</a>  <a href="mailto:sb@engelschall.com">&lt;sb@engelschall.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STBEY">STBEY</a><br />
5973. <a href="http://www.reactor.de/">Steffen Beyer</a>  <a href="mailto:sbeyer@reactor.de">&lt;sbeyer@reactor.de&gt;</a> -- BECS<br />

5974. Steffen Goeldner  <a href="mailto:sgoeldner@cpan.org">&lt;sgoeldner@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SG/SGOELDNER">SGOELDNER</a><br />
5975. Steffen Heinrich  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SHE<br />
5976. Steffen Kaiser  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKA">SKA</a><br />

5977. <a href="http://steffen-mueller.net">Steffen Müller</a>  <a href="mailto:smueller@cpan.org">&lt;smueller@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMUELLER">SMUELLER</a><br />
5978. <a href="http://renormalist.net">Steffen Schwigon</a>  <a href="mailto:schwigon@cpan.org">&lt;schwigon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHWIGON">SCHWIGON</a><br />
5979. Steffen Ullrich  <a href="mailto:Steffen_Ullrich@genua.de">&lt;Steffen_Ullrich@genua.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SULLR">SULLR</a><br />

5980. <a href="http://www.steffen-winkler.de/perl_cpan.htm">Steffen Winkler</a>  <a href="mailto:cpan@steffen-winkler.de">&lt;cpan@steffen-winkler.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEFFENW">STEFFENW</a><br />
5981. <a href="http://www.nonplus.net/">Stepan Riha</a>  <a href="mailto:sriha@cpan.org">&lt;sriha@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRIHA">SRIHA</a><br />
5982. <a href="http://www.codefusion.co.za">Stephan Buys</a>  <a href="mailto:sbproxy@icon.co.za">&lt;sbproxy@icon.co.za&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEPHANB">STEPHANB</a><br />

5983. Stephan Hadinger  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHADINGER">SHADINGER</a><br />
5984. <a href="http://www.heuel.org/">Stephan Heuel</a>  <a href="mailto:perl@heuel.org">&lt;perl@heuel.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HE/HEUEL">HEUEL</a><br />
5985. Stephane Chmielewski  <a href="mailto:snck@free.fr">&lt;snck@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNCK">SNCK</a><br />

5986. Stephane Tougard  <a href="mailto:elair@darea.fr">&lt;elair@darea.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STOUGARD">STOUGARD</a><br />
5987. <a href="http://www.r4k.net/">Stephanie Wehner</a>  <a href="mailto:_@r4k.net">&lt;_@r4k.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AT/ATRAK">ATRAK</a><br />
5988. Stephen A Cavilia  <a href="mailto:sac7352@rit.edu">&lt;sac7352@rit.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SACAVILIA">SACAVILIA</a><br />

5989. <a href="http://www.linkedin.com/in/spadkins">Stephen Adkins</a>  <a href="mailto:spadkins@gmail.com">&lt;spadkins@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPADKINS">SPADKINS</a><br />
5990. <a href="http://www.stephenbee.com">Stephen Bee</a>  <a href="mailto:stephenbee@gmail.com">&lt;stephenbee@gmail.com&gt;</a> -- SBEE<br />
5991. Stephen C. Losen  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCL">SCL</a><br />

5992. <a href="http://www.ls26.net/">Stephen Cardie</a>  <a href="mailto:stephenca@cpan.org">&lt;stephenca@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEPHENCA">STEPHENCA</a><br />
5993. Stephen Cochran  <a href="mailto:stephen.a.cochran@dartmouth.du">&lt;stephen.a.cochran@dartmouth.du&gt;</a> -- ANGUS<br />
5994. Stephen Couchman  <a href="mailto:guildms@users.sourceforge.net">&lt;guildms@users.sourceforge.net&gt;</a> -- FLAME<br />

5995. Stephen D. Wells  <a href="mailto:wellsNOSPAM@cedarnet.org">&lt;wellsNOSPAM@cedarnet.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YX/YXES">YXES</a><br />
5996. Stephen Deken  <a href="mailto:stephen.deken@gmail.com">&lt;stephen.deken@gmail.com&gt;</a> -- SDEKEN<br />
5997. <a href="http://popcorn.cx/">Stephen Edmonds</a>  <a href="mailto:">&lt;&gt;</a> -- SEDMONDS<br />

5998. <a href="http://people.healthquiz.com/sfarrell/">Stephen Farrell</a>  <a href="mailto:steve@farrell.org">&lt;steve@farrell.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SF/SFARRELL">SFARRELL</a><br />
5999. Stephen G. Lenk  <a href="mailto:slenk@emich.edu">&lt;slenk@emich.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLENK">SLENK</a><br />
6000. Stephen G. Miano  <a href="mailto:stevem@mindspring.com">&lt;stevem@mindspring.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SG/SGMIANO">SGMIANO</a><br />

6001. Stephen Hardisty  <a href="mailto:moowahaha@hotmail.com">&lt;moowahaha@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVEHA">STEVEHA</a><br />
6002. <a href="http://www.exitwound.org">Stephen Hargrove</a>  <a href="mailto:stephen at exitwound dot org">&lt;stephen at exitwound dot org&gt;</a> -- SHARGROVE<br />
6003. Stephen Hildrey  <a href="mailto:steve@uptime.org.uk">&lt;steve@uptime.org.uk&gt;</a> -- SHILDREY<br />

6004. Stephen Howard  <a href="mailto:stephen@enterity.com">&lt;stephen@enterity.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOWARS">HOWARS</a><br />
6005. Stephen J. Scheck  <a href="mailto:code@neurosphere.com">&lt;code@neurosphere.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSCHECK">SSCHECK</a><br />
6006. Stephen J. Sprague  <a href="mailto:stephen.sprague@morganstanley.com">&lt;stephen.sprague@morganstanley.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPRAGST">SPRAGST</a><br />

6007. Stephen Lau  <a href="mailto:stevel@sun.com">&lt;stevel@sun.com&gt;</a> -- STEVEL<br />
6008. <a href="www.ltsun.com">Stephen Lawrence Blum</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- STEPHENLB<br />
6009. Stephen M. Youndt  <a href="mailto:smy@cpan.org">&lt;smy@cpan.org&gt;</a> -- SMY<br />

6010. <a href="http://www.unixtown.com">Stephen Martin</a>  <a href="mailto:stephen@unixtown.com">&lt;stephen@unixtown.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/U/UN/UNIXTOWN">UNIXTOWN</a><br />
6011. <a href="http://www.stevemartina.com/">Stephen Martina</a>  <a href="mailto:sm108@hotmail.com">&lt;sm108@hotmail.com&gt;</a> -- SMART<br />
6012. Stephen McCamant  <a href="mailto:smcc@CSUA.Berkeley.EDU">&lt;smcc@CSUA.Berkeley.EDU&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMCCAM">SMCCAM</a><br />

6013. <a href="http://www.swmcc.com/">Stephen McCullough</a>  <a href="mailto:cpan@swmcc.com">&lt;cpan@swmcc.com&gt;</a> -- SWMCC<br />
6014. Stephen Mose Aaskov  <a href="mailto:stephen@netuni.dk">&lt;stephen@netuni.dk&gt;</a> -- SAA<br />
6015. <a href="http://www.perlmonks.org/index.pl?node=stephen">Stephen Nelson</a>  <a href="mailto:senelson@tdl.com">&lt;senelson@tdl.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEPHEN">STEPHEN</a><br />

6016. <a href="http://www.lehigh.edu/sol0">Stephen O. Lidie</a>  <a href="mailto:sol0@Lehigh.EDU">&lt;sol0@Lehigh.EDU&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LU/LUSOL">LUSOL</a><br />
6017. Stephen Oberholtzer  <a href="mailto:stevie-cpan AT qrpff.net">&lt;stevie-cpan AT qrpff.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVIEO">STEVIEO</a><br />
6018. <a href="http://ostermiller.org/">Stephen Ostermiller</a>  <a href="mailto:http://ostermiller.org/contact.pl?regarding=perl">&lt;http://ostermiller.org/contact.pl?regarding=perl&gt;</a> -- OSTERMILL<br />

6019. <a href="http://jthome.jthome.com/~spp/">Stephen P Potter</a>  <a href="mailto:spp@colltech.com">&lt;spp@colltech.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPP">SPP</a><br />
6020. <a href="http://www.pandich.com">Stephen Pandich</a>  <a href="mailto:steve@pandich.com">&lt;steve@pandich.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PA/PANDICH">PANDICH</a><br />
6021. <a href="http://patter.mine.nu/">Stephen Patterson</a>  <a href="mailto:steve@patter.mine.nu">&lt;steve@patter.mine.nu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRPATT">SRPATT</a><br />

6022. <a href="http://www.jadevine.org.uk">Stephen Quinney</a>  <a href="mailto:sjq-perl@jadevine.org.uk">&lt;sjq-perl@jadevine.org.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJQUINNEY">SJQUINNEY</a><br />
6023. <a href="http://www.scaffidi.net">Stephen R. Scaffidi</a>  <a href="mailto:sscaffidi@cpan.org">&lt;sscaffidi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSCAFFIDI">SSCAFFIDI</a><br />
6024. <a href="http://www.skrhoton.com">Stephen Rhoton</a>  <a href="mailto:srhoton@cmu.edu">&lt;srhoton@cmu.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRHOTON">SRHOTON</a><br />

6025. Stephen Riehm  <a href="mailto:Stephen.Riehm@pc-plus.de">&lt;Stephen.Riehm@pc-plus.de&gt;</a> -- SRIEHM<br />
6026. Stephen Steneker  <a href="mailto:stennie@cpan.org">&lt;stennie@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STENNIE">STENNIE</a><br />
6027. <a href="http://www.stephensykes.us">Stephen Sykes</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SASYKES">SASYKES</a><br />

6028. <a href="http://www.thorley.biz">Stephen Thorley</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVEAU">STEVEAU</a><br />
6029. Stephen Vance  <a href="mailto:cpan@vance.com">&lt;cpan@vance.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRVANCE">SRVANCE</a><br />
6030. Stephen Zander  <a href="mailto:gibreel@pobox.com">&lt;gibreel@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRZ">SRZ</a><br />

6031. <a href="http://www.edwardbear.org/blog">Sterling Hughes</a>  <a href="mailto:sterling@edwardbear.org">&lt;sterling@edwardbear.org&gt;</a> -- SHUGHES<br />
6032. Sterling Levell  <a href="mailto:sterlperl@netzero.net">&lt;sterlperl@netzero.net&gt;</a> -- STERLPERL<br />
6033. Steuermann Liouville  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STLLE">STLLE</a><br />

6034. <a href="http://www.iinteractive.com">Stevan Little</a>  <a href="mailto:stevan.little@iinteractive.com">&lt;stevan.little@iinteractive.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVAN">STEVAN</a><br />
6035. <a href="http://0xdeadbeef.net/~sfink">Steve A Fink</a>  <a href="mailto:sfink@cpan.org">&lt;sfink@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SF/SFINK">SFINK</a><br />
6036. <a href="http://wordtothewise.com/">Steve Atkins</a>  <a href="mailto:">&lt;&gt;</a> -- SATKINS<br />

6037. <a href="http://ambrielconsulting.com/">Steve Baker</a>  <a href="mailto:sjb@ambrielconsulting.com">&lt;sjb@ambrielconsulting.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJBAKER">SJBAKER</a><br />
6038. <a href="http://unideal.net">Steve Berry</a>  <a href="mailto:growler@unideal.net">&lt;growler@unideal.net&gt;</a> -- SBERRY<br />
6039. Steve Campbell  <a href="mailto:steve@computurn.com">&lt;steve@computurn.com&gt;</a> -- STEVEC<br />

6040. Steve Chervitz  <a href="mailto:sac@neomorphic.com">&lt;sac@neomorphic.com&gt;</a> -- STCHER<br />
6041. Steve Clark  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SMALLPOND<br />
6042. <a href="http://www.simplicate.ca">Steve Comrie</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- STEVECO<br />

6043. <a href="http://www.steve.gb.com">Steve Cook</a>  <a href="mailto:steve@steve.gb.com">&lt;steve@steve.gb.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOOK">SCOOK</a><br />
6044. <a href="http://www.unidata.ucar.edu/packages/netcdf-perl/">Steve Emmerson</a>  <a href="mailto:support@unidata.ucar.edu">&lt;support@unidata.ucar.edu&gt;</a> -- SEMM<br />
6045. <a href="http://www.visi.com/~sgrantz">Steve Grantz</a>  <a href="mailto:sgrantz@visi.com">&lt;sgrantz@visi.com&gt;</a> -- SGRANTZ<br />

6046. Steve Grazzini  <a href="mailto:grazz@pobox.com">&lt;grazz@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GR/GRAZZ">GRAZZ</a><br />
6047. Steve Hancock  <a href="mailto:shancock7078@bigfoot.com">&lt;shancock7078@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHANCOCK">SHANCOCK</a><br />
6048. <a href="http://www.nullspace.com/">Steve Harris</a>  <a href="mailto:perl@nullspace.com">&lt;perl@nullspace.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHARRIS">SHARRIS</a><br />

6049. <a href="http://tsort.info/music/">Steve Hawtin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SJHAWTIN<br />
6050. Steve Hay  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHAY">SHAY</a><br />
6051. <a href="http://www.zbh.uni-hamburg.de/wurst/">Steve Hoffmann; Nasir Mahmood; Thomas Margraf; Gundolf Schenk; Tina Stehr; Andrew Torda</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WU/WURST">WURST</a><br />

6052. <a href="http://www.vecna.org">Steve Huff</a>  <a href="mailto:hakamadare@users.sourceforge.net">&lt;hakamadare@users.sourceforge.net&gt;</a> -- SHUFF<br />
6053. <a href="http://redmonk.net">Steve Ivy</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SIVY<br />
6054. <a href="http://www.ambrosia.plus.com">Steve James</a>  <a href="mailto:s@james.bigfoot@com">&lt;s@james.bigfoot@com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STE">STE</a><br />

6055. Steve Kane  <a href="mailto:skane@cse.psu.edu">&lt;skane@cse.psu.edu&gt;</a> -- SKANE<br />
6056. <a href="http://www.cs.indiana.edu/~kinzler/">Steve Kinzler</a>  <a href="mailto:kinzler@cs.indiana.edu">&lt;kinzler@cs.indiana.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KINZLER">KINZLER</a><br />
6057. <a href="http://www.polarbearcub.ru/">Steve L. Kuznetsov</a>  <a href="mailto:skuzn@inbox.ru">&lt;skuzn@inbox.ru&gt;</a> -- SKUZN<br />

6058. Steve Mathias  <a href="mailto:smathias1@qwest.net">&lt;smathias1@qwest.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SL/SLMATH">SLMATH</a><br />
6059. <a href="http://www.z33.org/">Steve McKay</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MC/MCKAY">MCKAY</a><br />
6060. <a href="http://justsomeguy.com">Steve McNabb</a>  <a href="mailto:smcnabb@cpan.org">&lt;smcnabb@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMCNABB">SMCNABB</a><br />

6061. <a href="http://www.fisharerojo.org">Steve Peters</a>  <a href="mailto:steve at fisharerojo dot org">&lt;steve at fisharerojo dot org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMPETERS">SMPETERS</a><br />
6062. Steve Piantadosi  <a href="mailto:guidopian@yahoo.com">&lt;guidopian@yahoo.com&gt;</a> -- GUIDOPIAN<br />
6063. Steve Pillinger  <a href="mailto:S.M.Pillinger@cs.bham.ac.uk">&lt;S.M.Pillinger@cs.bham.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMPILL">SMPILL</a><br />

6064. <a href="http://staticfree.info/">Steve Pomeroy</a>  <a href="mailto:xavier-cpan@staticfree.info">&lt;xavier-cpan@staticfree.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/X/XA/XAVIER">XAVIER</a><br />
6065. <a href="http://www.sdprice.plus.com/">Steve Price</a>  <a href="mailto:cpan@sdprice.plus.com">&lt;cpan@sdprice.plus.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDPRICE">SDPRICE</a><br />
6066. <a href="http://www.spurkis.org/">Steve Purkis</a>  <a href="mailto:spurkis @[at]@ cpan.dot.org">&lt;spurkis @[at]@ cpan.dot.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SP/SPURKIS">SPURKIS</a><br />

6067. Steve Robbibaro  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SAR<br />
6068. Steve Roberts  <a href="mailto:junk@mediaone.com">&lt;junk@mediaone.com&gt;</a> -- SMRBRTS<br />
6069. <a href="http://HauntedMines.org">Steve Roscio</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/R/RO/ROSCIO">ROSCIO</a><br />

6070. Steve Rubin  <a href="mailto:ser@tch.org">&lt;ser@tch.org&gt;</a> -- SER<br />
6071. <a href="http://www.deeden.co.uk/">Steve Rushe</a>  <a href="mailto:steve-cpan@deeden.co.uk">&lt;steve-cpan@deeden.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SR/SRUSHE">SRUSHE</a><br />
6072. <a href="http://www.paul.rutgers.edu/~sanbeg/">Steve Sanbeg</a>  <a href="mailto:sanbeg@cs.rutgers.edu">&lt;sanbeg@cs.rutgers.edu&gt;</a> -- SANBEG<br />

6073. <a href="http://icdweb.cc.purdue.edu/~ssanty/">Steve Santy</a>  <a href="mailto:ssanty@purdue.edu">&lt;ssanty@purdue.edu&gt;</a> -- SSANTY<br />
6074. <a href="http://www.netcomuk.co.uk/~pariah/">Steve Sherwood</a>  <a href="mailto:pariah@netcomuk.co.uk">&lt;pariah@netcomuk.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHERWOOD">SHERWOOD</a><br />
6075. <a href="http://www.steveshipway.org/software">Steve Shipway</a>  <a href="mailto:s.shipway@auckland.ac.nz">&lt;s.shipway@auckland.ac.nz&gt;</a> -- CHESHIRE<br />

6076. Steve Shoopak  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHOOP">SHOOP</a><br />
6077. <a href="http://www.deefs.net">Steve Simms</a>  <a href="mailto:tracker-cpan@deefs.net">&lt;tracker-cpan@deefs.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSIMMS">SSIMMS</a><br />
6078. <a href="http://www.pheran.com/">Steve Snodgrass</a>  <a href="mailto:ssnodgra@pheran.com">&lt;ssnodgra@pheran.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SS/SSNODGRA">SSNODGRA</a><br />

6079. <a href="www.softlife.com">Steve Thames</a>  <a href="mailto:steve@softlife.com">&lt;steve@softlife.com&gt;</a> -- SMTHAMES<br />
6080. <a href="http://www.library.adelaide.edu.au/~sthomas/">Steve Thomas</a>  <a href="mailto:stephen.thomas@adelaide.edu.au">&lt;stephen.thomas@adelaide.edu.au&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STHOMAS">STHOMAS</a><br />
6081. <a href="http://www.stevegt.com">Steve Traugott</a>  <a href="mailto:stevegt@TerraLuna.Org">&lt;stevegt@TerraLuna.Org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVEGT">STEVEGT</a><br />

6082. <a href="http://perlworks.com">Steve Troxel</a>  <a href="mailto:troxelso@nswccd.navy.mil">&lt;troxelso@nswccd.navy.mil&gt;</a> -- TROXEL<br />
6083. Steve W Bonds  <a href="mailto:u5rhsiz02@sneakemail.com">&lt;u5rhsiz02@sneakemail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SB/SBONDS">SBONDS</a><br />
6084. Steve Wartik  <a href="mailto:swartik@ida.org">&lt;swartik@ida.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWARTIK">SWARTIK</a><br />

6085. <a href="http://www.empress.com">Steve Williams</a>  <a href="mailto:swilliam@empress.com">&lt;swilliam@empress.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWILLIAM">SWILLIAM</a><br />
6086. <a href="http://plumeria.vmth.ucdavis.edu/~saintly/">Steve Zeck</a>  <a href="mailto:saintly@innocent.com">&lt;saintly@innocent.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SZ/SZECK">SZECK</a><br />
6087. Steve pointer  <a href="mailto:spointer@cpan.org">&lt;spointer@cpan.org&gt;</a> -- SPOINTER<br />

6088. Steven Brenner  <a href="mailto:S.E.Brenner@bioc.cam.ac.uk">&lt;S.E.Brenner@bioc.cam.ac.uk&gt;</a> -- SEB<br />
6089. <a href="http://pyro.eu.org/">Steven Chamberlain</a>  <a href="mailto:steven@pyro.eu.org">&lt;steven@pyro.eu.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVENC">STEVENC</a><br />
6090. Steven Cotton  <a href="mailto:cotton@cpan.org">&lt;cotton@cpan.org&gt;</a> -- COTTON<br />

6091. Steven Harris  <a href="mailto:sharris001@hotmail.com">&lt;sharris001@hotmail.com&gt;</a> -- SBHARR<br />
6092. Steven Hessing  <a href="mailto:stevenh@xsmail.com">&lt;stevenh@xsmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVENH">STEVENH</a><br />
6093. <a href="http://mshiltonj.com/">Steven Hilton</a>  <a href="mailto:mshiltonj[at]mshiltonj[dot]com">&lt;mshiltonj[at]mshiltonj[dot]com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MS/MSHILTONJ">MSHILTONJ</a><br />

6094. <a href="www.darksleep.com">Steven J. Owens</a>  <a href="mailto:puff@darksleep.com">&lt;puff@darksleep.com&gt;</a> -- PUFF<br />
6095. Steven Johnson  <a href="mailto:cmmdrdata@sbcglobal.net">&lt;cmmdrdata@sbcglobal.net&gt;</a> -- NEVETS<br />
6096. <a href="http://www.baldmt.com/~knight/">Steven Knight</a>  <a href="mailto:knight@baldmt.com">&lt;knight@baldmt.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KN/KNIGHT">KNIGHT</a><br />

6097. <a href="http://www.exit2shell.com/~skreuzer">Steven Kreuzer</a>  <a href="mailto:skreuzer@cpan.org">&lt;skreuzer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKREUZER">SKREUZER</a><br />
6098. Steven L Jenkins  <a href="mailto:steven.jenkins@gmail.com">&lt;steven.jenkins@gmail.com&gt;</a> -- SJENKINS<br />
6099. Steven L. Kunz  <a href="mailto:skunz@iastate.edu">&lt;skunz@iastate.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKUNZ">SKUNZ</a><br />

6100. Steven Lembark  <a href="mailto:lembark@wrkhors.com">&lt;lembark@wrkhors.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEMBARK">LEMBARK</a><br />
6101. Steven Manross  <a href="mailto:perl@manross.net">&lt;perl@manross.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMANROSS">SMANROSS</a><br />
6102. <a href="http://world.std.com/~swmcd/steven/">Steven McDougall</a>  <a href="mailto:swmcd@world.std.com">&lt;swmcd@world.std.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWMCD">SWMCD</a><br />

6103. Steven Pitchford  <a href="mailto:">&lt;&gt;</a> -- LILSTEVEY<br />
6104. <a href="http://www.silug.org/~steve/">Steven Pritchard</a>  <a href="mailto:steve@silug.org">&lt;steve@silug.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STEVE">STEVE</a><br />
6105. Steven R. Moody  <a href="mailto:steve.moody@philips.com">&lt;steve.moody@philips.com&gt;</a> -- SRMOODY<br />

6106. <a href="http://www.reids4fun.com">Steven Reid</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SLREID<br />
6107. Steven Rubin  <a href="mailto:steven@ssrubin.com">&lt;steven@ssrubin.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MU/MUNCHIE">MUNCHIE</a><br />
6108. <a href="http://stsc.refcnt.org/cpan/">Steven Schubiger (stsc)</a>  <a href="mailto:schubiger@cpan.org">&lt;schubiger@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHUBIGER">SCHUBIGER</a><br />

6109. <a href="http://www.carr.lib.md.us/~stevensl/">Steven Slegel</a>  <a href="mailto:stevensl@ccpl.carr.lib.md.us">&lt;stevensl@ccpl.carr.lib.md.us&gt;</a> -- STEVENSL<br />
6110. Steven Smith  <a href="mailto:sjs@sonic.net">&lt;sjs@sonic.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SJ/SJSMITH">SJSMITH</a><br />
6111. <a href="http://home.comcast.net/~tolkin.family/">Steven Tolkin</a>  <a href="mailto:steve.tolkin@fmr.com">&lt;steve.tolkin@fmr.com&gt;</a> -- STOLKIN<br />

6112. Steven Van Vooren  <a href="mailto:Steven.VanVooren@gmail.com">&lt;Steven.VanVooren@gmail.com&gt;</a> -- SVV<br />
6113. Steven Weinberger  <a href="mailto:perl@psycomp.com">&lt;perl@psycomp.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/W/WE/WEINBERG">WEINBERG</a><br />
6114. <a href="http://brautaset.org">Stig Brautaset</a>  <a href="mailto:stig@brautaset.org">&lt;stig@brautaset.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STIG">STIG</a><br />

6115. Stig H. Jacobsen  <a href="mailto:shj@cpan.org">&lt;shj@cpan.org&gt;</a> -- SHJ<br />
6116. Stinkiaglio Confungi  <a href="mailto:whatever1968@zwallet.com">&lt;whatever1968@zwallet.com&gt;</a> -- STINKY<br />
6117. <a href="http://www.straytoaster.co.uk/">Stray Taoist</a>  <a href="mailto:mwk@straytoaster.co.uk">&lt;mwk@straytoaster.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRYTOAST">STRYTOAST</a><br />

6118. Struan Bartlett  <a href="mailto:">&lt;&gt;</a> -- STRUANB<br />
6119. <a href="http://exo.org.uk/">Struan Donald</a>  <a href="mailto:struan@cpan.org">&lt;struan@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRUAN">STRUAN</a><br />
6120. <a href="rswsystems.com">Strzelecki Łukasz</a>  <a href="mailto:flagg@onet.eu">&lt;flagg@onet.eu&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/ST/STRZELEC">STRZELEC</a><br />

6121. <a href="www.dvsm.co.uk">Stuart Butler</a>  <a href="mailto:stubox2005-subs@yahoo.co.uk">&lt;stubox2005-subs@yahoo.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DV/DVSM">DVSM</a><br />
6122. <a href="http://www.kyzer.me.uk/">Stuart Caie</a>  <a href="mailto:kyzer@4u.net">&lt;kyzer@4u.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYZ">KYZ</a><br />
6123. Stuart Clark  <a href="mailto:stuart.clark@Jahingo.com">&lt;stuart.clark@Jahingo.com&gt;</a> -- STUARTC<br />

6124. Stuart Cooper  <a href="mailto:stuart.cooper@gmail.com">&lt;stuart.cooper@gmail.com&gt;</a> -- STUCOOPER<br />
6125. Stuart Dodds  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SJFD<br />
6126. Stuart Lory  <a href="mailto:lorys@access.victoria.bc.ca">&lt;lorys@access.victoria.bc.ca&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LORY">LORY</a><br />
6127. Stuart Slade  <a href="mailto:stuarts@mobilestreams.com">&lt;stuarts@mobilestreams.com&gt;</a> -- SWSLADE<br />

6128. <a href="http://www.comp.rgu.ac.uk/staff/sw/">Stuart Watt</a>  <a href="mailto:S.N.K.Watt@rgu.ac.uk">&lt;S.N.K.Watt@rgu.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SN/SNKWATT">SNKWATT</a><br />
6129. Stuart Young  <a href="mailto:youngcpan@gmail.com">&lt;youngcpan@gmail.com&gt;</a> -- YOUNG<br />
6130. <a href="http://www.studiobondurri.net">StudioBondurri</a>  <a href="mailto:f.bondurri@tiscali.it">&lt;f.bondurri@tiscali.it&gt;</a> -- BONDURRI<br />

6131. <a href="http://www.sakana.fr/blog/">Stéphane KATTOOR</a>  <a href="mailto:skattoor@cpan.org">&lt;skattoor@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKATTOOR">SKATTOOR</a><br />
6132. Stéphane Payrard  <a href="mailto:stef@payrard.net">&lt;stef@payrard.net&gt;</a> -- STEF<br />
6133. Stéphane Peiry  <a href="mailto:peiry@cpan.org">&lt;peiry@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PE/PEIRY">PEIRY</a><br />

6134. Subba Reddy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MSREDDY<br />
6135. Sudha Kashyap  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SKASHYAP<br />
6136. Sudip Khanna  <a href="mailto:khan0178@d.umn.edu">&lt;khan0178@d.umn.edu&gt;</a> -- SUDIP<br />
6137. Sudre Cyril  <a href="mailto:cyril.sudre@laposte.net">&lt;cyril.sudre@laposte.net&gt;</a> -- MACFLY<br />

6138. Sue Spence  <a href="mailto:sue_cpan@pennine.com">&lt;sue_cpan@pennine.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUE">SUE</a><br />
6139. <a href="http://jamadam.com/dev/blog/">Sugama Keita</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JA/JAMADAM">JAMADAM</a><br />
6140. Suhanov Vadim  <a href="mailto:suhanov_vadim@mail.ru">&lt;suhanov_vadim@mail.ru&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LESV">LESV</a><br />

6141. <a href="sujaisworld.com">SujaiSojan</a>  <a href="mailto:sujai@logicsupport.com">&lt;sujai@logicsupport.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUJAI">SUJAI</a><br />
6142. Sullivan Beck  <a href="mailto:sbeck@cpan.org">&lt;sbeck@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SB/SBECK">SBECK</a><br />
6143. <a href="http://www.sun.com">Sun CPAN Module Support</a>  <a href="mailto:cpan-support@sun.com">&lt;cpan-support@sun.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUNCPAN">SUNCPAN</a><br />

6144. Sun Yi Ming  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SYM<br />
6145. Sung-Hun Kim  <a href="mailto:simkin@gmx.de">&lt;simkin@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SI/SIMKIN">SIMKIN</a><br />
6146. Sunil S  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SU/SUNILS">SUNILS</a><br />
6147. Suraj Jacob  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SARGE<br />

6148. <a href="www.sonic.net/~suresh">Suresh Govindachar</a>  <a href="mailto:cat(initial, last_name)at(yahoo)">&lt;cat(initial, last_name)at(yahoo)&gt;</a> -- SURESHG<br />
6149. Suresh K. Hosamani  <a href="mailto:hsuresh@novell.com">&lt;hsuresh@novell.com&gt;</a> -- HSURESH<br />
6150. Suresh R  <a href="mailto:sureshram00@gmail.com">&lt;sureshram00@gmail.com&gt;</a> -- SURESHRAM<br />

6151. <a href="http://www.pobox.com/~sooz/">Susan Lee Wilson</a>  <a href="mailto:sooz@pobox.com">&lt;sooz@pobox.com&gt;</a> -- SOOZ<br />
6152. Suslov Maxim  <a href="mailto:maxx@cpan.org">&lt;maxx@cpan.org&gt;</a> -- MAXX<br />
6153. Svante Sörmark  <a href="mailto:svinto@cpan.org">&lt;svinto@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SV/SVINTO">SVINTO</a><br />

6154. <a href="http://home.org.au">Sven Dowideit</a>  <a href="mailto:SvenDowideit@home.org.au">&lt;SvenDowideit@home.org.au&gt;</a> -- SDOWIDEIT<br />
6155. <a href="http://www.zen.org/~sven/">Sven Heinicke</a>  <a href="mailto:sven@zen.org">&lt;sven@zen.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SV/SVENH">SVENH</a><br />
6156. <a href="http://www.prantello.de/">Sven Kleese</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GO/GONZO">GONZO</a><br />

6157. Sven Neuhaus  <a href="mailto:sven@ping.de">&lt;sven@ping.de&gt;</a> -- SVEN<br />
6158. <a href="http://cf.ccmr.cornell.edu/~sven">Sven Pedersen</a>  <a href="mailto:sven.pedersen.NOSPAM@gmail.com">&lt;sven.pedersen.NOSPAM@gmail.com&gt;</a> -- SVENTECH<br />
6159. Sven Verdoolaege  <a href="mailto:skimo@kotnet.org">&lt;skimo@kotnet.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SK/SKIMO">SKIMO</a><br />

6160. <a href="http://seofilter.org">Svetoslav Marinov</a>  <a href="mailto:slavi at slavi dot biz">&lt;slavi at slavi dot biz&gt;</a> -- LORDSPACE<br />
6161. Swen Schillig  <a href="mailto:schillig@web.de">&lt;schillig@web.de&gt;</a> -- SWEN<br />
6162. <a href="http://www.sweth.net/legal/disc.html">Sweth Chandramouli</a>  <a href="mailto:sweth+pause@sweth.net">&lt;sweth+pause@sweth.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SW/SWETH">SWETH</a><br />

6163. Syamala Tadigadapa  <a href="mailto:syamalarao@hotmail.com">&lt;syamalarao@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SY/SYAMAL">SYAMAL</a><br />
6164. Sylvain &quot;Skarsnik&quot; Colinet  <a href="mailto:skarsnik@nyo.fr">&lt;skarsnik@nyo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCOLINET">SCOLINET</a><br />
6165. <a href="www.dlux.hu">Szabó, Balázs</a>  <a href="mailto:dlux@dlux.hu">&lt;dlux@dlux.hu&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DL/DLUX">DLUX</a><br />

6166. <a href="http://www.computacao.uvanet.br">Sávio Menezes Sampaio</a>  <a href="mailto:saviox__no__linuxmail.org">&lt;saviox__no__linuxmail.org&gt;</a> -- BRASIL<br />
6167. <a href="http://www.maddingue.org/">Sébastien Aperghis-Tramoni</a>  <a href="mailto:maddingue@free.fr">&lt;maddingue@free.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SA/SAPER">SAPER</a><br />
6168. <a href="http://www.indexoo.fr">Sébastien Darribere-Pleyt</a>  <a href="mailto:s.darribere@indexoo.fr">&lt;s.darribere@indexoo.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SD/SDP">SDP</a><br />

6169. Sébastien Millet  <a href="mailto:sebastien.millet2@libertysurf.fr">&lt;sebastien.millet2@libertysurf.fr&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SM/SMILLET">SMILLET</a><br />
6170. <a href="http://www.opcenter.de/">Sönke J. Peters</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOENKE">SOENKE</a><br />
6171. <a href="http://intrepid.perlmonk.org/">Sören Andersen</a>  <a href="mailto:somian munge-AT-munge pobox *DOT*com">&lt;somian munge-AT-munge pobox *DOT*com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SO/SOMIAN">SOMIAN</a><br />

6172. Sören Laird Sörries  <a href="mailto:perl@myobj.com">&lt;perl@myobj.com&gt;</a> -- RELAIS<br />
6173. T. Alex Beamish  <a href="mailto:talexb@gmail.com">&lt;talexb@gmail.com&gt;</a> -- TALEXB<br />
6174. <a href="http://thetalkspot.com/">T. K. Harris</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TKHARRIS<br />

6175. T. Linden  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TL/TLINDEN">TLINDEN</a><br />
6176. <a href="http://www.jeek.net/">T.J. Eckman</a>  <a href="mailto:jeek@jeek.net">&lt;jeek@jeek.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JEEK">JEEK</a><br />
6177. <a href="http://maxmind.com">T.J. Mather</a>  <a href="mailto:tjmather@maxmind.com">&lt;tjmather@maxmind.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TJ/TJMATHER">TJMATHER</a><br />

6178. T.J. Yang  <a href="mailto:">&lt;&gt;</a> -- TJYANG<br />
6179. TH  <a href="mailto:easy@cpan.org">&lt;easy@cpan.org&gt;</a> -- EASY<br />
6180. TK Chuah  <a href="mailto:teongkee@gmail.com">&lt;teongkee@gmail.com&gt;</a> -- TEONGKEE<br />
6181. <a href="http://hibinokoto.jp/">TRAVAIL</a>  <a href="mailto:travail@cpan.org">&lt;travail@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TR/TRAVAIL">TRAVAIL</a><br />

6182. <a href="http://www.drk7,jp/">TSUNODA Kazuya</a>  <a href="mailto:drk@drk7.jp">&lt;drk@drk7.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSUNODA">TSUNODA</a><br />
6183. <a href="www.tty.nl">TTY Internet Solutions</a>  <a href="mailto:cpan@tty.nl">&lt;cpan@tty.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TT/TTY">TTY</a><br />
6184. Tad McClellan  <a href="mailto:tad@rehabitation.com">&lt;tad@rehabitation.com&gt;</a> -- TADMC<br />

6185. Tai Nguyen  <a href="mailto:dumbtai@gmail.com">&lt;dumbtai@gmail.com&gt;</a> -- BASENJI<br />
6186. <a href="http://rakugaki.org/">Taisuke Yamada</a>  <a href="mailto:tyamadajp@list.rakugaki.org">&lt;tyamadajp@list.rakugaki.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAIY">TAIY</a><br />
6187. <a href="http://d.hatena.ne.jp/mizuno_takaaki/">Takaaki Mizuno</a>  <a href="mailto:cpan@takaaki.info">&lt;cpan@takaaki.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NA/NANZOU">NANZOU</a><br />

6188. <a href="http://d.hatena.ne.jp/thorikawa/">Takahiro Horikawa</a>  <a href="mailto:thorikawa@cpan.org">&lt;thorikawa@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THORIKAWA">THORIKAWA</a><br />
6189. Takashi Saeki  <a href="mailto:tsaeki@yf7.so-net.ne.jp">&lt;tsaeki@yf7.so-net.ne.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAKASHI">TAKASHI</a><br />
6190. <a href="http://comewalk.com/">Takatsugu Shigeta</a>  <a href="mailto:takatsugu.shigeta@gmail.com">&lt;takatsugu.shigeta@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHIGETA">SHIGETA</a><br />

6191. <a href="http://www.kumicho.net/">Takayuki Ikeda/池田隆之</a>  <a href="mailto:takayuki_777@msn.com">&lt;takayuki_777@msn.com&gt;</a> -- TAKAYUKI<br />
6192. <a href="http://www.motionbros.com/">Takeo Suzuki</a>  <a href="mailto:takeo@cpan.org">&lt;takeo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAKEO">TAKEO</a><br />
6193. <a href="http://teahut.sakura.ne.jp/b/">Takeru INOUE</a>  <a href="mailto:takeru.inoue+perl@gmail.com">&lt;takeru.inoue+perl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAKERU">TAKERU</a><br />

6194. <a href="http://www.watanabe.arch.waseda.ac.jp/member/1992/kim/MacPerl/default.html">Takeshi Kimura</a>  <a href="mailto:kimura@cpan.org">&lt;kimura@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KI/KIMURA">KIMURA</a><br />
6195. <a href="http://www.koba206.com">Takeshi Kobayashi (小林剛士)</a>  <a href="mailto:koba206@gmail.com">&lt;koba206@gmail.com&gt;</a> -- KOBAYASHI<br />
6196. Takeshi Miki  <a href="mailto:tmiki1009@gmail.com">&lt;tmiki1009@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIKI">MIKI</a><br />

6197. <a href="http://seagirl.jp">Takuho Yoshizu</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- SEAGIRL<br />
6198. Takuya Ichikawa  <a href="mailto:ichi@cpan.org">&lt;ichi@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/I/IC/ICHI">ICHI</a><br />
6199. <a href="http://28go.jp/">Takuya Iida</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TAC<br />

6200. <a href="http://serennz.sakura.ne.jp/">Takuya Otani</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TAKKYUN<br />
6201. Tan D Nguyen  <a href="mailto:tdn@cpan.org">&lt;tdn@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TN/TNGUYEN">TNGUYEN</a><br />
6202. <a href="www.betonmarkets.com">Tan Wei Chong</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- WEICHONG<br />

6203. Tanaka Makoto  <a href="mailto:tanaka.makoto@gmail.com">&lt;tanaka.makoto@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAMAKOTO">TAMAKOTO</a><br />
6204. Taneli Kaivola  <a href="mailto:dist-ihme-org">&lt;dist-ihme-org&gt;</a> -- DIST<br />
6205. <a href="http://myneid.gothcafe.com/">Tanguy de Courson</a>  <a href="mailto:tanguy@decourson.com">&lt;tanguy@decourson.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MY/MYNEID">MYNEID</a><br />

6206. <a href="http://wtl.wayfarer.org/">Tanner Lovelace</a>  <a href="mailto:lovelace@cpan.org">&lt;lovelace@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOVELACE">LOVELACE</a><br />
6207. Tapas Ranjan Behera  <a href="mailto:beherat@yahoo.com">&lt;beherat@yahoo.com&gt;</a> -- TAPASRB<br />
6208. <a href="http://www.eccentricity.org/">Tara Andrews</a>  <a href="mailto:aurum@cpan.org">&lt;aurum@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AU/AURUM">AURUM</a><br />

6209. <a href="http://oelbsk.org">Tarek Ahmed</a>  <a href="mailto:bloerch@oelbsk.org">&lt;bloerch@oelbsk.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAREKA">TAREKA</a><br />
6210. Tarik Alkasab  <a href="mailto:tarik@alkasab.com">&lt;tarik@alkasab.com&gt;</a> -- TALKASAB<br />
6211. Tariq Dennison  <a href="mailto:tariqdennison@yahoo.com">&lt;tariqdennison@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DE/DENNISON">DENNISON</a><br />

6212. <a href="http://blog.33rpm.jp">Taro Funaki</a>  <a href="mailto:t@33rpm.jp">&lt;t@33rpm.jp&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAWAN">TAWAN</a><br />
6213. Taro Kawagishi  <a href="mailto:tarok@acm.org">&lt;tarok@acm.org&gt;</a> -- TAROK<br />
6214. Taro Nishino  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TNISHINO<br />

6215. <a href="http://www.geocities.com/tasminahmad/">Tasmin Ahmad</a>  <a href="mailto:tasminahmad@hotmail.com">&lt;tasminahmad@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TASMIN">TASMIN</a><br />
6216. <a href="http://www-users.rwth-aachen.de/tassilo.parseval">Tassilo von Parseval</a>  <a href="mailto:tassilo.parseval@post.rwth-aachen.de">&lt;tassilo.parseval@post.rwth-aachen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VP/VPARSEVAL">VPARSEVAL</a><br />
6217. Tatoute Michel  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TATOUTE<br />

6218. <a href="http://bulknews.net/me">Tatsuhiko Miyagawa</a>  <a href="mailto:miyagawa@bulknews.net">&lt;miyagawa@bulknews.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MI/MIYAGAWA">MIYAGAWA</a><br />
6219. <a href="http://yanonet.jp/">Tatsuhiro YANO</a>  <a href="mailto:">&lt;&gt;</a> -- TYANO<br />
6220. Tatuya Noda  <a href="mailto:topia@cpan.org">&lt;topia@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOPIA">TOPIA</a><br />

6221. Tavin Cole  <a href="mailto:tavin@cpan.org">&lt;tavin@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAVIN">TAVIN</a><br />
6222. Taylor Carpenter  <a href="mailto:taylor@codecafe.com">&lt;taylor@codecafe.com&gt;</a> -- TAYLOR<br />
6223. <a href="http://surfvi.com/~ota">Ted Anderson</a>  <a href="mailto:otaka@cpan.org">&lt;otaka@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/O/OT/OTAKA">OTAKA</a><br />

6224. Ted Ashton  <a href="mailto:ashted@uga.edu">&lt;ashted@uga.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/A/AS/ASHTED">ASHTED</a><br />
6225. <a href="http://www.slysystems.com">Ted Elwartowski</a>  <a href="mailto:perldev@slysystems.com">&lt;perldev@slysystems.com&gt;</a> -- XELWARTO<br />
6226. <a href="http://www.d.umn.edu/~tpederse/">Ted Pedersen</a>  <a href="mailto:duluthted@gmail.com">&lt;duluthted@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TP/TPEDERSE">TPEDERSE</a><br />

6227. <a href="http://bloodgate.com/">Tels</a>  <a href="mailto:nospam-abuse@bloodgate.com">&lt;nospam-abuse@bloodgate.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TELS">TELS</a><br />
6228. Teodor Zlatanov  <a href="mailto:tzz-cpan@lifelogs.com">&lt;tzz-cpan@lifelogs.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEODOR">TEODOR</a><br />
6229. Terence Denzil Monteiro  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TERENCEMO">TERENCEMO</a><br />

6230. <a href="http://neutri.no/">Terje Bless</a>  <a href="mailto:link@cpan.org">&lt;link@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LI/LINK">LINK</a><br />
6231. <a href="http://www.pvv.ntnu.no/~terjebr">Terje Bråten</a>  <a href="mailto:TerjeBr@broadpark.no">&lt;TerjeBr@broadpark.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TERJE">TERJE</a><br />
6232. <a href="http://www.metaperl.org">Terrence Brannon</a>  <a href="mailto:metaperl@gmail.com">&lt;metaperl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TB/TBONE">TBONE</a><br />

6233. Terry Gaetz  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TGAETZ<br />
6234. Terry Michaels  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MAGOO<br />
6235. <a href="http://TransWebTools.com">Terry Tompkins</a>  <a href="mailto:Tompkins@TransWebTools.com">&lt;Tompkins@TransWebTools.com&gt;</a> -- TRANSWEBT<br />

6236. <a href="http://www.weissman.org/">Terry Weissman</a>  <a href="mailto:terry@weissman.org">&lt;terry@weissman.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TERRY">TERRY</a><br />
6237. <a href="http://d.hatena.ne.jp/nTeTs/">Tetsunari Nozaki</a>  <a href="mailto:nozzzzz@gmail.com">&lt;nozzzzz@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/N/NO/NOZZZZZ">NOZZZZZ</a><br />
6238. <a href="http://homepage.mac.com/tkurita/scriptfactory/">Tetsuro KURITA</a>  <a href="mailto:scriptfactory@mac.com">&lt;scriptfactory@mac.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TK/TKURITA">TKURITA</a><br />

6239. Tetsuya Tabayashi  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TABAYASHI<br />
6240. <a href="http://hikoboshi.org/">Tetsuya Toyoda</a>  <a href="mailto:cpan@hikoboshi.org">&lt;cpan@hikoboshi.org&gt;</a> -- AQL<br />
6241. <a href="http://webwheel.nl/">Teun van Eijsden</a>  <a href="mailto:teun@chello.nl">&lt;teun@chello.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEUN">TEUN</a><br />

6242. <a href="www.groundclutter.com">Thad Parker</a>  <a href="mailto:groundclutter@gmail.como">&lt;groundclutter@gmail.como&gt;</a> -- TCP<br />
6243. <a href="http://arabidopsis.info">Thale Cress</a>  <a href="mailto:arabidopsis@arabidopsis.info">&lt;arabidopsis@arabidopsis.info&gt;</a> -- THALIANA<br />
6244. Thanh Dao  <a href="mailto:daot@us.ibm.com">&lt;daot@us.ibm.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DA/DAOT">DAOT</a><br />

6245. <a href="http://www.arx.net/">Thanos Chatziathanassiou</a>  <a href="mailto:tchatzi@arx.gr">&lt;tchatzi@arx.gr&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TC/TCHATZI">TCHATZI</a><br />
6246. <a href="www.elumen.net">Theo Lengyel</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIRT">DIRT</a><br />
6247. <a href="http://www.taletn.com/">Theo Niessink</a>  <a href="mailto:niessink@martinic.nl">&lt;niessink@martinic.nl&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TALE">TALE</a><br />

6248. <a href="http://www.lethargy.org/~jesus/">Theo Schlossnagle</a>  <a href="mailto:jesus@omniti.com">&lt;jesus@omniti.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JE/JESUS">JESUS</a><br />
6249. <a href="http://www.kluge.net/~felicity/">Theo Van Dinter</a>  <a href="mailto:felicity@kluge.net">&lt;felicity@kluge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FE/FELICITY">FELICITY</a><br />
6250. <a href="http://theo.me.uk/">Theo Zourzouvillys</a>  <a href="mailto:theo@crazygreek.co.uk">&lt;theo@crazygreek.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZO/ZOZO">ZOZO</a><br />

6251. <a href="http://www.theronlewis.com/">Theron Lewis</a>  <a href="mailto:theronl@gmail.com">&lt;theronl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/K/KY/KYPREOS">KYPREOS</a><br />
6252. <a href="http://www.maluco.com.br/">Thiago Berlitz Rondon</a>  <a href="mailto:thiago.rondon@gmail.com">&lt;thiago.rondon@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TB/TBR">TBR</a><br />
6253. <a href="http://www.virtuasites.com.br">Thiago de Souza Vieira</a>  <a href="mailto:tsv@terra.com.br">&lt;tsv@terra.com.br&gt;</a> -- TSV<br />

6254. <a href="http://www-lipn.univ-paris13.fr/~hamon/">Thierry Hamon</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THHAMON">THHAMON</a><br />
6255. <a href="http://mandrivalinux.org">Thierry Vignaud</a>  <a href="mailto:tvignaud@mandriva.com">&lt;tvignaud@mandriva.com&gt;</a> -- TVI<br />
6256. <a href="http://perlmonks.thepen.com/409485.html">Thilo Planz</a>  <a href="mailto:thilo@cpan.org">&lt;thilo@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THILO">THILO</a><br />

6257. Thilo Stapff  <a href="mailto:thilo.stapff@t-online.de">&lt;thilo.stapff@t-online.de&gt;</a> -- TSTAPFF<br />
6258. Thirumal Kandasamy  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- THIRUMAL<br />
6259. <a href="http://www.rparts.us">Thomas A. Lowery</a>  <a href="mailto:talowery@gmail.com">&lt;talowery@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TL/TLOWERY">TLOWERY</a><br />

6260. Thomas Ammitzbøll-Bach  <a href="mailto:tabac+cpan@uu.dk">&lt;tabac+cpan@uu.dk&gt;</a> -- TABAC<br />
6261. Thomas Bekel  <a href="mailto:tbekel@cpan.org">&lt;tbekel@cpan.org&gt;</a> -- TBEKEL<br />
6262. <a href="http://www.gymel.com/">Thomas Berger</a>  <a href="mailto:ThB@gymel.com">&lt;ThB@gymel.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THB">THB</a><br />

6263. Thomas Bolioli  <a href="mailto:Thomas_Bolioli@alumni.adelphi.edu">&lt;Thomas_Bolioli@alumni.adelphi.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TB/TBOLIOLI">TBOLIOLI</a><br />
6264. <a href="http://www.boutell.com">Thomas Boutell</a>  <a href="mailto:boutell@boutell.com">&lt;boutell@boutell.com&gt;</a> -- TBOUTELL<br />
6265. <a href="http://lucreti.us">Thomas Burke</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TBURKE<br />

6266. Thomas Busch  <a href="mailto:tbusch@cpan.org">&lt;tbusch@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TB/TBUSCH">TBUSCH</a><br />
6267. <a href="http://www.th-dorner.de">Thomas Dorner</a>  <a href="mailto:td030523@th-dorner.de">&lt;td030523@th-dorner.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DORNER">DORNER</a><br />
6268. <a href="http://www.drillich.de/it">Thomas Drillich</a>  <a href="mailto:th@drillich.de">&lt;th@drillich.de&gt;</a> -- TDRILLICH<br />

6269. Thomas Drugeon  <a href="mailto:tdrugeon@cpan.org">&lt;tdrugeon@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TD/TDRUGEON">TDRUGEON</a><br />
6270. <a href="http://thomas.eibner.dk/">Thomas Eibner</a>  <a href="mailto:thomas@cpan.org">&lt;thomas@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOMAS">THOMAS</a><br />
6271. Thomas Erskine  <a href="mailto:thomaserskine@yahoo.com">&lt;thomaserskine@yahoo.com&gt;</a> -- TERSKINE<br />

6272. <a href="http://www.thomas-fahle.de">Thomas Fahle</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TOMFAHLE<br />
6273. <a href="http://www.cip.physik.uni-muenchen.de/~tf">Thomas Fischbacher</a>  <a href="mailto:tf@cip.physik.uni-muenchen.de">&lt;tf@cip.physik.uni-muenchen.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/F/FI/FISCH">FISCH</a><br />
6274. Thomas Fjellstrom  <a href="mailto:tfjellstromSPAMME@shaw.ca">&lt;tfjellstromSPAMME@shaw.ca&gt;</a> -- TFJELL<br />

6275. Thomas Flasche  <a href="mailto:flasche@webit.de">&lt;flasche@webit.de&gt;</a> -- FALSE<br />
6276. <a href="http://tagged.sourceforge.net">Thomas Geffert</a>  <a href="mailto:thg@users.sourceforge.net">&lt;thg@users.sourceforge.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOGEE">THOGEE</a><br />
6277. <a href="www.gutzmann.com">Thomas Gutzmann</a>  <a href="mailto:thomas.gutzmann@gutzmann.com">&lt;thomas.gutzmann@gutzmann.com&gt;</a> -- GUTZMANN<br />

6278. Thomas Hall  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TMHALL<br />
6279. Thomas Hartman  <a href="mailto:thomashartman1 at gmail dot... um... you know...  com">&lt;thomashartman1 at gmail dot... um... you know...  com&gt;</a> -- THARTMAN<br />
6280. Thomas Hladish  <a href="mailto:tjhladish@cpan.org">&lt;tjhladish@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TJ/TJHLADISH">TJHLADISH</a><br />
6281. <a href="http://internet24.de">Thomas Jacob</a>  <a href="mailto:jacob@internet24.de">&lt;jacob@internet24.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOR">THOR</a><br />

6282. <a href="http://www.kishel.net">Thomas Kishel</a>  <a href="mailto:tkishel+perl@gmail.com">&lt;tkishel+perl@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TK/TKISHEL">TKISHEL</a><br />
6283. <a href="http://domm.plix.at/">Thomas Klausner</a>  <a href="mailto:domm@cpan.org">&lt;domm@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DO/DOMM">DOMM</a><br />
6284. Thomas Kongevold Adamcik  <a href="mailto:adamcik@cpan.org">&lt;adamcik@cpan.org&gt;</a> -- ADAMCIK<br />

6285. Thomas Kratz  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOMK">TOMK</a><br />
6286. Thomas L. Shinnick  <a href="mailto:tshinnic@gmail.com">&lt;tshinnic@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSHINNIC">TSHINNIC</a><br />
6287. Thomas Lenz  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- THOLEN<br />
6288. <a href="http://www.lothosoft.ch/thomas">Thomas Lochmatter</a>  <a href="mailto:cpan@lothosoft.ch">&lt;cpan@lothosoft.ch&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LO/LOCHMATT">LOCHMATT</a><br />

6289. <a href="http://www.saltstorm.net/">Thomas Loo</a>  <a href="mailto:tloo@cpan.org">&lt;tloo@cpan.org&gt;</a> -- TLOO<br />
6290. Thomas M. Browder, Jr.  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TBROWDER<br />
6291. Thomas Malt  <a href="mailto:thomas.malt@linpro.no">&lt;thomas.malt@linpro.no&gt;</a> -- MALT<br />

6292. <a href="http://tnet.no/">Thomas Martinsen</a>  <a href="mailto:tech@tnet.no">&lt;tech@tnet.no&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TECHIE">TECHIE</a><br />
6293. <a href="http://www.tmaterna.com">Thomas Materna</a>  <a href="mailto:tmaterna@tmaterna.com">&lt;tmaterna@tmaterna.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TM/TMATERNA">TMATERNA</a><br />
6294. Thomas McGlynn  <a href="mailto:">&lt;&gt;</a> -- TMCGLYNN<br />

6295. <a href="http://nbpfaus.net/~pfau/">Thomas Pfau</a>  <a href="mailto:pfau@nbpfaus.net">&lt;pfau@nbpfaus.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/P/PF/PFAUT">PFAUT</a><br />
6296. Thomas Pietrzykowski  <a href="mailto:thomas@pietrzykowski.de">&lt;thomas@pietrzykowski.de&gt;</a> -- TOMPIE<br />
6297. <a href="http://apt4g.a3nyc.com">Thomas Riemer</a>  <a href="mailto:triemer@apt4g.a3nyc.com">&lt;triemer@apt4g.a3nyc.com&gt;</a> -- TRIEMER<br />

6298. <a href="http://members.nextra.at/hfbuch/edoc/">Thomas Schmickl</a>  <a href="mailto:schmickl@nextra.at">&lt;schmickl@nextra.at&gt;</a> -- SCHMICKL<br />
6299. <a href="http://www.schnuecker.de">Thomas Schnücker</a>  <a href="mailto:thomas@schnuecker.de">&lt;thomas@schnuecker.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHNUECK">SCHNUECK</a><br />
6300. <a href="http://www.tschuett.de">Thomas Schuett</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SC/SCHUETT">SCHUETT</a><br />

6301. <a href="http://thomas-sibley.com">Thomas Sibley</a>  <a href="mailto:tsibley@cpan.org">&lt;tsibley@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSIBLEY">TSIBLEY</a><br />
6302. <a href="http://tstanley.perlmonk.org">Thomas Stanley</a>  <a href="mailto:Thomas_J_Stanley@msn.com">&lt;Thomas_J_Stanley@msn.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSTANLEY">TSTANLEY</a><br />
6303. <a href="http://marnanel.org">Thomas Thurman</a>  <a href="mailto:tthurman@gnome.org">&lt;tthurman@gnome.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/M/MA/MARNANEL">MARNANEL</a><br />

6304. Thomas Tuechler  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TTUECHLER<br />
6305. <a href="http://xml4biz.de/cpan/CMS/">Thomas Walloschke</a>  <a href="mailto:thw@cpan.org">&lt;thw@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THW">THW</a><br />
6306. <a href="http://usemacperl.webjump.com/index.html">Thomas Wegner</a>  <a href="mailto:toms_email@gmx.de">&lt;toms_email@gmx.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWEGNER">TWEGNER</a><br />

6307. <a href="http://beeblebrox.net">Thomas Weibel</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOM">THOM</a><br />
6308. Thomas Wenrich  <a href="mailto:wenrich@ping.at">&lt;wenrich@ping.at&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWENRICH">TWENRICH</a><br />
6309. <a href="http://blog.widmann.org.uk/">Thomas Widmann</a>  <a href="mailto:twid@cpan.org">&lt;twid@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWID">TWID</a><br />

6310. <a href="http://gedankenkonstrukt.de/">Thomas Wittek</a>  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWITTEK">TWITTEK</a><br />
6311. Thomas Yandell  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/V/VI/VIPERCODE">VIPERCODE</a><br />
6312. Thomasik  <a href="mailto:cpan@ums.thomasik.com">&lt;cpan@ums.thomasik.com&gt;</a> -- MATH<br />

6313. Thorben Jändling  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TREVELYAN<br />
6314. <a href="http://www.mip.ou.dk/~ravn">Thorbjoern Ravn Andersen</a>  <a href="mailto:ravn@mip.ou.dk">&lt;ravn@mip.ou.dk&gt;</a> -- RAVN<br />
6315. Thorsten Drobnik  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/C/CA/CAMELCASE">CAMELCASE</a><br />

6316. Thorsten Klein  <a href="mailto:cpan@perlwizard.de">&lt;cpan@perlwizard.de&gt;</a> -- TKLEIN<br />
6317. Thorsten Nickel  <a href="mailto:kungfuhasi@profikiller.net">&lt;kungfuhasi@profikiller.net&gt;</a> -- TNICKEL<br />
6318. Thorsten Schwander  <a href="mailto:Thorsten.Schwander@gmail.com">&lt;Thorsten.Schwander@gmail.com&gt;</a> -- TSCHWAND<br />
6319. Thuan-Jin Kee  <a href="mailto:jin.kee@gmail.com">&lt;jin.kee@gmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/J/JI/JINKEE">JINKEE</a><br />

6320. Tiago Faro Pedroso  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- FARO<br />
6321. <a href="http://www.perdoc.com">Tiago Stock</a>  <a href="mailto:tstock@cpan.org">&lt;tstock@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSTOCK">TSTOCK</a><br />
6322. Tibor Nagy  <a href="mailto:buldozer88@hotmail.com">&lt;buldozer88@hotmail.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIBI">TIBI</a><br />

6323. Tilo Renz  <a href="mailto:tilo.renz@student.uni-ulm.de">&lt;tilo.renz@student.uni-ulm.de&gt;</a> -- TRZ<br />
6324. <a href="http://hepunx.rl.ac.uk/~adye/homepage.html">Tim Adye</a>  <a href="mailto:T.J.Adye@rl.ac.uk">&lt;T.J.Adye@rl.ac.uk&gt;</a> -- ADYE<br />
6325. Tim Ayers  <a href="mailto:tim@quaday.com">&lt;tim@quaday.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TA/TAYERS">TAYERS</a><br />

6326. <a href="http://www.ecs.soton.ac.uk/~tdb01r/">Tim Brody</a>  <a href="mailto:tdb01r@ecs.soton.ac.uk">&lt;tdb01r@ecs.soton.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMBRODY">TIMBRODY</a><br />
6327. <a href="http://www.tim.bunce.name">Tim Bunce</a>  <a href="mailto:Tim.Bunce@pobox.com">&lt;Tim.Bunce@pobox.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMB">TIMB</a><br />
6328. <a href="http://www.timbu.org/">Tim Burlowski</a>  <a href="mailto:timbu@timbu.org">&lt;timbu@timbu.org&gt;</a> -- TIMBU<br />

6329. <a href="http://alum.mit.edu/www/tbc/hacks">Tim Chambers</a>  <a href="mailto:timc+cpan+071124@divide.net">&lt;timc+cpan+071124@divide.net&gt;</a> -- TBC<br />
6330. Tim Coggins  <a href="mailto:tcoggins@cpan.org">&lt;tcoggins@cpan.org&gt;</a> -- TCOGGINS<br />
6331. <a href="http://www.ky4j.net">Tim Gimmel</a>  <a href="mailto:perl@gimmel.org">&lt;perl@gimmel.org&gt;</a> -- TGIMMEL<br />

6332. <a href="http://www.star.le.ac.uk/~tjg/">Tim Goodwin</a>  <a href="mailto:tjg@star.le.ac.uk">&lt;tjg@star.le.ac.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMPX">TIMPX</a><br />
6333. Tim Hammerquist  <a href="mailto:timmy@cpan.org">&lt;timmy@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMMY">TIMMY</a><br />
6334. Tim Harsch  <a href="mailto:harschware@yahoo.com">&lt;harschware@yahoo.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THARSCH">THARSCH</a><br />

6335. Tim Howell  <a href="mailto:tim@fefcful.org">&lt;tim@fefcful.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THOWELL">THOWELL</a><br />
6336. <a href="http://www.jach.hawaii.edu/~timj/">Tim Jenness</a>  <a href="mailto:t.jenness@jach.hawaii.edu">&lt;t.jenness@jach.hawaii.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TJ/TJENNESS">TJENNESS</a><br />
6337. <a href="http://tojo2000.com/blog/blog.htm">Tim Johnson</a>  <a href="mailto:tojo2000@tojo2000.com">&lt;tojo2000@tojo2000.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOJO">TOJO</a><br />

6338. <a href="http://www.timkeefer.com">Tim Keefer</a>  <a href="mailto:tkeefer@cpan.org">&lt;tkeefer@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TK/TKEEFER">TKEEFER</a><br />
6339. <a href="http://www.teachmeperl.com">Tim Maher</a>  <a href="mailto:yumpy@consultix-inc.com">&lt;yumpy@consultix-inc.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/Y/YU/YUMPY">YUMPY</a><br />
6340. Tim McIntyre  <a href="mailto:tmac@transport.com">&lt;tmac@transport.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TM/TMAC">TMAC</a><br />

6341. <a href="http://www.schmerg.com/">Tim Meadowcroft</a>  <a href="mailto:cpan@schmerg.com">&lt;cpan@schmerg.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMM">TIMM</a><br />
6342. <a href="http://sourceforge.net/projects/file-skeleton/">Tim Nelson</a>  <a href="mailto:wayland@smartchat.net.au">&lt;wayland@smartchat.net.au&gt;</a> -- WAYLAND<br />
6343. Tim Nowaczyk  <a href="mailto:zimage@gmail.com">&lt;zimage@gmail.com&gt;</a> -- ZIMAGE<br />

6344. Tim Peoples  <a href="mailto:peoples@cpan.org">&lt;peoples@cpan.org&gt;</a> -- PEOPLES<br />
6345. Tim Potter  <a href="mailto:tpot@samba.org">&lt;tpot@samba.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMPOTTER">TIMPOTTER</a><br />
6346. <a href="http://retout.co.uk/">Tim Retout</a>  <a href="mailto:diocles@cpan.org">&lt;diocles@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/D/DI/DIOCLES">DIOCLES</a><br />

6347. <a href="http://www.killfile.org/~tskirvin/">Tim Skirvin</a>  <a href="mailto:tskirvin@killfile.org">&lt;tskirvin@killfile.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSKIRVIN">TSKIRVIN</a><br />
6348. <a href="http://www.lemonia.org/ti/">Tim Sweetman</a>  <a href="mailto:tim_sweetman@bigfoot.com">&lt;tim_sweetman@bigfoot.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TD/TDS">TDS</a><br />
6349. Tim Vroom  <a href="mailto:vroom@blockstackers.com">&lt;vroom@blockstackers.com&gt;</a> -- VROOM<br />

6350. <a href="http://www.krellis.org/">Tim Wilde</a>  <a href="mailto:pause@krellis.org">&lt;pause@krellis.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWILDE">TWILDE</a><br />
6351. <a href="http://www.wumpus-cave.net">Timm Murray</a>  <a href="mailto:tmurray.NO@MEAT.wumpus-cave.net">&lt;tmurray.NO@MEAT.wumpus-cave.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TM/TMURRAY">TMURRAY</a><br />
6352. Timo Schneider  <a href="mailto:timo.schneider@s2004.tu-chemnitz.de">&lt;timo.schneider@s2004.tu-chemnitz.de&gt;</a> -- TIMOS<br />

6353. <a href="http://dephine.org/">Timo Valeri Junolainen</a>  <a href="mailto:sigin@dephine.org">&lt;sigin@dephine.org&gt;</a> -- SIGIN<br />
6354. <a href="http://www.timaoutloud.org/">Timothy Appnel</a>  <a href="mailto:tima@cpan.org">&lt;tima@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TIMA">TIMA</a><br />
6355. Timothy G. Zander  <a href="mailto:timothy.zander@alum.rpi.edu">&lt;timothy.zander@alum.rpi.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/Z/ZA/ZANDET">ZANDET</a><br />

6356. Timothy Garafola  <a href="mailto:timothy.garafola@cnet.com">&lt;timothy.garafola@cnet.com&gt;</a> -- <a href="/pub/PAUSE/authors/id/G/GA/GARAFOLA">GARAFOLA</a><br />
6357. Timothy Hinchcliffe  <a href="mailto:pause@spidererrol.co.uk">&lt;pause@spidererrol.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THINCH">THINCH</a><br />
6358. <a href="http://www.designingknights.com">Timothy R. Winters</a>  <a href="mailto:timothy@designingknights.com">&lt;timothy@designingknights.com&gt;</a> -- SPIRITFIR<br />

6359. Timothée Foucart  <a href="mailto:timothee.foucart@apinc.org">&lt;timothee.foucart@apinc.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TF/TFOUCART">TFOUCART</a><br />
6360. <a href="http://myakinin.com">Timur Myakinin</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- MYAKININ<br />
6361. Timur Shtatland  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/S/SH/SHTATLAND">SHTATLAND</a><br />

6362. <a href="http://www.tinita.de/projects/perl/en">Tina Müller</a>  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TI/TINITA">TINITA</a><br />
6363. <a href="http://www.td.org.uit.no/~tobias">Tobias Brox</a>  <a href="mailto:tobix@irctos.org">&lt;tobix@irctos.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBIX">TOBIX</a><br />
6364. <a href="http://www.starenterprise.com">Tobias Eichner</a>  <a href="mailto:tobias@starenterprise.com">&lt;tobias@starenterprise.com&gt;</a> -- TOBIASTAR<br />

6365. Tobias Gruetzmacher  <a href="mailto:tobias-perl@23.gs">&lt;tobias-perl@23.gs&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBIAS">TOBIAS</a><br />
6366. Tobias Herbert  <a href="mailto:">&lt;&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBI">TOBI</a><br />
6367. <a href="http://blog.nupfel.de/">Tobias Kirschstein</a>  <a href="mailto:lev@cpan.org">&lt;lev@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/L/LE/LEV">LEV</a><br />

6368. <a href="http://www.funkreich.de">Tobias Kremer</a>  <a href="mailto:cpan@funkreich.de">&lt;cpan@funkreich.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TK/TKREMER">TKREMER</a><br />
6369. <a href="http://www.freehal.org">Tobias Schulz</a>  <a href="mailto:info@tobias-schulz.info">&lt;info@tobias-schulz.info&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TS/TSCHULZ">TSCHULZ</a><br />
6370. <a href="http://www.to-st.de">Tobias Stoeber</a>  <a href="mailto:stoeber@physik.tu-clausthal.de">&lt;stoeber@physik.tu-clausthal.de&gt;</a> -- TOST<br />

6371. <a href="http://www.fukurama.org">Tobias Tacke</a>  <a href="mailto:cpan@tobias-tacke.de">&lt;cpan@tobias-tacke.de&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBIWAN">TOBIWAN</a><br />
6372. Tobias Vancura  <a href="mailto:tvancura@altavista.net">&lt;tvancura@altavista.net&gt;</a> -- TVANCURA<br />
6373. <a href="http://dryft.net/">Toby Corkindale</a>  <a href="mailto:cpan@corkindale.net">&lt;cpan@corkindale.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TJ/TJC">TJC</a><br />

6374. Toby Deitrich  <a href="mailto:tdeitrich@cpan.org">&lt;tdeitrich@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TD/TDEITRICH">TDEITRICH</a><br />
6375. <a href="http://tobyinkster.co.uk">Toby Inkster</a>  <a href="mailto:mail@tobyinkster.co.uk">&lt;mail@tobyinkster.co.uk&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBYINK">TOBYINK</a><br />
6376. <a href="http://www.tobiasly.com/">Toby Johnson</a>  <a href="mailto:toby@tobiasly.com">&lt;toby@tobiasly.com&gt;</a> -- TOBIASLY<br />

6377. <a href="http://www.ovod-everett.org/~toby/">Toby Ovod-Everett</a>  <a href="mailto:toby@ovod-everett.org">&lt;toby@ovod-everett.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TE/TEVERETT">TEVERETT</a><br />
6378. <a href="www.wildfire.dircon.co.uk">Toby Thurston</a>  <a href="mailto:toby@cpan.org">&lt;toby@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TO/TOBY">TOBY</a><br />
6379. <a href="http://todbot.com/">Tod E. Kurt</a>  <a href="mailto:tod@todbot.com">&lt;tod@todbot.com&gt;</a> -- TODBOT<br />

6380. Tod Hagan  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TOD<br />
6381. Todd A. Green  <a href="mailto:tagreen@mhsnetworks.net">&lt;tagreen@mhsnetworks.net&gt;</a> -- TODDAG<br />
6382. <a href="http://www.pflugerville.org/bradfute">Todd Bradfute</a>  <a href="mailto:bradfute@pflugerville.org">&lt;bradfute@pflugerville.org&gt;</a> -- TBRADFUTE<br />

6383. Todd Caine  <a href="mailto:tcaine@cpan.org">&lt;tcaine@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TC/TCAINE">TCAINE</a><br />
6384. Todd Chapman  <a href="mailto:todd@chaka.net">&lt;todd@chaka.net&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HT/HTCHAPMAN">HTCHAPMAN</a><br />
6385. <a href="http://toddot.net/">Todd Harris</a>  <a href="mailto:harris@cshl.edu">&lt;harris@cshl.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TW/TWH">TWH</a><br />

6386. Todd Hepler  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TH/THEPLER">THEPLER</a><br />
6387. Todd Holbrook  <a href="mailto:holbrook@cpan.org">&lt;holbrook@cpan.org&gt;</a> -- <a href="/pub/PAUSE/authors/id/H/HO/HOLBROOK">HOLBROOK</a><br />
6388. Todd Littlefield  <a href="mailto:CENSORED">&lt;CENSORED&gt;</a> -- TSL<br />

6389. Todd Merritt  <a href="mailto:tmerritt@email.arizona.edu">&lt;tmerritt@email.arizona.edu&gt;</a> -- <a href="/pub/PAUSE/authors/id/T/TM/TMERRITT">TMERRITT</a><br />
6390. Todd 