package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Pink;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'rose' => 0x00392601, # 0,57,38,1
  'bisque' => 0x000b1700, # 0,11,23,0
  'cherry' => 0x004e370d, # 0,78,55,13
  'chair' => 0x00172000, # 0,23,32,0
  'eggshell' => 0x00080b01, # 0,8,11,1
  'nymph thigh' => 0x00090600, # 0,9,6,0
  'raspberry' => 0x004e4016, # 0,78,64,22
  'fuchsia' => 0x004b2a01, # 0,75,42,1
  'heliotrope' => 0x0d370000, # 13,55,0,0
  'watermelon' => 0x00292500, # 0,41,37,0
  'magenta' => 0x00640000, # 0,100,0,0
  'dark magenta' => 0x00640032, # 0,100,0,50
  'magenta fuchsia' => 0x00642f0e, # 0,100,47,14
  'purple' => 0x002e0011, # 0,46,0,17
  'fishing' => 0x00191c01, # 0,25,28,1
  'brooms rose' => 0x002e1b17, # 0,46,27,23
  'candy pink' => 0x004a2502, # 0,74,37,2
  'pink' => 0x00191100, # 0,25,17,0
  'mountbatten pink' => 0x01180028, # 0,280,0,40
  'tea rose' => 0x002f3a00, # 0,47,58,0
  'hot pink' => 0x00643200, # 0,100,50,0
  'salmon' => 0x002b4203, # 0,43,66,3
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (pink)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Pink - CMYK colors from http://toutes-les-couleurs.com/ (pink)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Pink (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
