package Alien::NLopt;

# ABSTRACT: Build and Install the NLopt library

use v5.12;
use strict;
use warnings;

our $VERSION = 'v2.7.1.1';

use base qw( Alien::Base );

1;

#
# This file is part of Alien-NLopt
#
# This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory metacpan

=head1 NAME

Alien::NLopt - Build and Install the NLopt library

=head1 VERSION

version v2.7.1.1

=head1 SYNOPSIS

  use Alien::NLopt;

=head1 DESCRIPTION

This module finds or builds the I<NLopt> library.

=head1 USAGE

Please see L<Alien::Build::Manual::AlienUser> (or equivalently on L<metacpan|https://metacpan.org/pod/distribution/Alien-Build/lib/Alien/Build/Manual/AlienUser.pod>).

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-alien-nlopt@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=Alien-NLopt>

=head2 Source

Source is available at

  https://gitlab.com/djerius/alien-nlopt

and may be cloned from

  https://gitlab.com/djerius/alien-nlopt.git

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
