
=Active contents

Document parts can be generated \I<dynamically>. This is done by evaluating a \I<condition>,
\I<embedded> or \I<included> \B<Perl> code \I<at translation time>.

@|
active part   | description | example
condition     | A paragraph type to control inclusion of all subsequent source parts before the next condition. | \C<? $PerlPoint->{targetLanguage} eq "HTML">
embedded Perl | Perl code embedded into \C<\\EMBED> and \C<\\END_EMBED> tags, marked as Perl by tag option \C<lang> set to \C<"perl">. The code is expected to return a string which will be interpreted as \B<PerlPoint>. | \C<This document was generated by perl \\EMBED{lang=perl}$]\\END_EMBED.>
included Perl | Perl code read from a file via an \C<\\INCLUDE> tag, marked as Perl by tag option \C<type> set to \C<"perl">. File contents is evaluated like embedded Perl. | \C<\\INCLUDE{type=perl file="included.pl"}>

  As an introduction example of the active contents feature,
  here is a report about this document: it was generated
  at \EMBED{lang=perl}my @t=(localtime)[3, 4, 5]; sprintf("%d.%d.%d", $t[0], $t[1]+1, $t[2]+1900); \END_EMBED.


==What it is for

Well, honestly spoken, I'm looking forward to the usage people will make of this feature.
But I can already imagine things like

* document parts included depending on the target language (an article could
  possibly provide more informations than presentation sheets), the time of
  presentation generation (informations may be confidental until a certain
  point; or imagine exercises - solutions may be presented in a second step)
  or depending on the system state;

* automatic documentation of system parts (directories, partitions, or share
  a generic PerlPoint source which will produce a presentation automatically
  adapted to the target system);

* integration of sources provided in a format different to PerlPoint, automatically
  translated and integrated;

* including statistics and images made on the fly on base of whatever data
  Perl can access;

* grabbing presentation data from the web or a server;

* let Perl generate a presentation of complex data instead of having to write
  the PerlPoint yourself;

* and more ...


==An example

The following files were found where and when this presentation was built:

\EMBED{lang=perl}

# read /tmp
opendir(D, '.');
my @snapshot=map {my $size=(stat($_))[7]; [$_, defined $size ? $size : 0]} sort readdir(D);
closedir(D);

# supply the listing as a table
join(
     # row separator
     "\n",

     # initial lines (to make sure the table paragraph is recognized)
     ('') x 2,

     # table opener
     '@|',

     # headline
     "filename | file size",

     # data, sorted
     map {join(' | ', @$_)} @snapshot,

     # closing empty line
     '',
    );

\END_EMBED


==Security

Security is kept by running active contents in a safe environment via a \B<Safe>
object. This way every translator can implement its own grade of security,
allowing only such operations which seem to be uncritical to the author.

Nevertheless, the necessary security grade may vary. Imagine a downloaded presentation source
and a self written document. But even with own presentations it seems to be good
advice to never translate a presentation with root permissions.

If active contents is disabled at all, all related PerlPoint elements (conditions,
embedded and included code) are ignored.

Please refer to the specific translators documentation. Implementations can vary
from generally disabled active contents to user configurable security settings.


==Sharing data between active parts

All active contents shares the same \B<Safe> object which means that it is executed \I<in
the same Perl namespace> (which usually happens to appear as \C<main::>, please see the
translators documentation for details). As a consequece, several parts can interact with
each other by variables and functions.

Note that the active parts are evaluated in the order they appear in the PerlPoint source.

<<EOE

\EMBED{lang=perl}

sub fileCount
  {
   # get number of files
   opendir(D, '.');
   my @fileNr=readdir(D);
   my $fileNr=@fileNr;
   closedir(D);

   # supply result
   $fileNr;
  }

# scan directory
$filesFound=fileCount;

'';

\END_EMBED

The following condition evaluates the number of files found by the previously
executed code:

// conditional hints
? $filesFound>10000000000

=Using directories

The number of files in your directory let us add additional suggestions:

...

// back to main document
? 1

Now we can use the previously declared function again: there are
\EMBED{lang=perl}fileCount\END_EMBED files in the current directory.

EOE


==Using document variables

PerlPoint variables are \I<no> active contents. Even when active contents is
disabled completely, variables will still work. Nevertheless, their \I<values>
are \I<copied> into the namespace of active contents.

That means you can read every PerlPoint variable in active parts.

<<EOE

  $var=10

  The variables value on PerlPoint side is $var. On Perl side,
  it is \EMBED{lang=perl}$main::var\END_EMBED as well.

EOE

Note that the variables are only \I<copied>. They may be modified on Perl side
but without effect to PerlPoint.

<<EOE

  $var=10

  The variables value on PerlPoint side is $var. On Perl side,
  it is \EMBED{lang=perl}$main::var*=100\END_EMBED now. But this does not
  affect PerlPoint which still sees a value of $var.

EOE

Further more, whenever a variable is set on PerlPoint side, the Perl side
value is updated which overwrites all modifications eventually made.

You may have noticed that the variables were accessed by their fully qualified names
in the examples above. This was done because PerlPoint variables are evaluated \I<first>
- before the code is passed to perl. By using the fully qualified name which is unknown
to PerlPoint this replacement is suppressed. Alternatively, \C<\\$var> may be written.


==Accessing base data

Base data like the target language is provided by a global pseudo hash reference
variable \C<\B<$PerlPoint>> (which belongs to the namespace of the \B<Safe> object).
Please see specific translator documentations for a list of passed data. By
convention, this hash provides the target language and user settings at least:

  // include the following to HTML documents only
  ? $PerlPoint->{targetLanguage} eq 'HTML'

  // include the following depending on command
  ? $PerlPoint->{userSettings}{special}

Active contents can modify the provided data but changes will \I<expire> when a code
snippet is executed completely.

<<EOE

  // active contents modifying base data
  \EMBED{lang=perl}
     $PerlPoint->{targetLanguage}='modified';
  \END_EMBED

  // base data is automatically restored now,
  // so the condition checks the original value
  ? $PerlPoint->{targetLanguage} eq 'HTML'

EOE


==Known problems

Dealing with the \B<Safe> module is not as easy as it seems at first sight.

* Specifying permitted operations can be a longer task. Please have
  a look at the manpages of \C<Safe> and \C<Opcode>.

* Sorting by a subroutine seems to fail - \C<$a> and \C<$b> are always undefined.

* Using modules is a challenge, especially with compiled parts.

Maybe I only need advice because I just started to use \C<Safe>. If you know
how to manage these tasks, please let me know.