#!perl -T

use Test::Most import => ['!pass'];
use Plack::Test;
use HTTP::Request::Common;

{

    package Minifytest;
    use Dancer2;
    use Dancer2::Plugin::Minify;

    get '/' => sub {
        minify( css => <<'END');
/* this is a comment to be removed */
p {
    display: none;
}
END
    };

}

my $PT = Plack::Test->create( Minifytest->to_app );

#plan tests => 5;
my $R = $PT->request( GET '/' );
ok $R->is_success;
my $css = $R->content;
note $css;
unlike $css, qr{/\*.*\*/}s, 'comments removed';
unlike $css, qr{\s},        'whitespaces removed';
done_testing;
