## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Cache::Static::CDB.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: DTA static cache

##==============================================================================
## Package
##==============================================================================
package DTA::CAB::Analyzer::Cache::Static::CDB;
use DTA::CAB::Analyzer ':child';
use DTA::CAB::Analyzer::Dict::JsonCDB;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Dict::JsonCDB);

##--------------------------------------------------------------
## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Dict::JsonCDB, DTA::CAB::Analyzer::Dict::Json
sub new {
  my $that = shift;
  my $dic = $that->SUPER::new(
			      ##-- overrides
			      label => 'static',

			      #typeKeys=>[qw(eqphox errid exlex f lts mlatin morph msafe pnd rw xlit)],
			      typeKeys => undef, ##-- auto-scanned on ensureLoaded() if not defined here

			      analyzeCode =>join("\n",
						 (
						  'return if (!defined($val=$dhash->{'
						  #._am_xlit('$_')
						  .'$_->{text}'
						  .'}));'
						 ),
						 '$val=$jxs->decode($val);',
						 '@$_{keys %$val}=values %$val;',
						),

			      ##-- user args
			      @_
			     );

  ##-- set type keys from DTA::CAB::Chain::DTA if possible and not already set
  #$dic->{typeKeys} = [DTA::CAB::Chain::DTA->new->typeKeys()] if (!$dic->{typeKeys} && DTA::CAB::Chain::DTA->can('new'));
  return $dic;
}

##--------------------------------------------------------------
## @keys = $anl->typeKeys(\%opts)
##  + get type keys
##  + default respects $opts->{"${key}_enabled"}
sub typeKeys {
  return qw() if (!$_[0]{typeKeys});
  return grep {!defined($_[1]{"${_}_enabled"}) || $_[1]{"${_}enabled"}} @{$_[0]{typeKeys}};
}

##--------------------------------------------------------------
## $bool = $dic->ensureLoaded()
##  + ensures analyzer data is loaded from default files
sub ensureLoaded {
  my $dic = shift;
  my $rc = $dic->SUPER::ensureLoaded(@_) || return undef;

  ##-- maybe scan for embedded keys
  if (!defined($dic->{typeKeys}) && $dic->{dbf} && $dic->{dbf}{tied}) {
    $dic->info("scanning CDB file for sub-keys...");
    my $tied  = $dic->{dbf}{tied};
    my %jkeys = qw();
    my $jxs   = $dic->jsonxs;
    my ($t,$js,$j);
    for ($t=$tied->FIRSTKEY; defined($t); $t=$tied->NEXTKEY($t)) {
      $js = $tied->FETCH($t);
      $j  = $jxs->decode($js);
      @jkeys{keys %$j} = qw() if ((ref($j)||'') eq 'HASH');
    }
    $dic->{typeKeys} = [sort keys %jkeys];
    $dic->info("scanned sub-keys {", join(',', @{$dic->{typeKeys}}), "}");
  }

  return $rc;
}

##--------------------------------------------------------------
## $prefix = $dict->analyzePre()
sub analyzePre {
  my $dic = shift;
  return $dic->DTA::CAB::Analyzer::Dict::JsonCDB::analyzePre(@_);#.' my $tied=tied($dhash);';
}


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Cache::Static - Static cache using DTA::CAB::Analyzer::Dict::JsonDB

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Cache::Static::CDB;
 
 $exlex = DTA::CAB::Analyzer::Cache::Static::CDB->new(%args);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Cache::Static::CDB
is a just a wrapper for
L<DTA::CAB::Analyzer::Dict::JsonCDB|DTA::CAB::Analyzer::Dict::JsonCDB>
which sets the following default options:

 label => 'exlex',                   ##-- analysis label
 typeKeys => [qw(exlex pnd errid)]   ##-- type-wise analysis keys

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut


=cut
