package Locales::DB::Language::pt_pt;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::pt_pt::VERSION = '0.09';

$Locales::DB::Language::pt_pt::cldr_version = '2.0';

%Locales::DB::Language::pt_pt::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Idioma\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ e\ \{1\}",
            'end'    => "\{0\}\ e\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Região\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "não\:n",
        'yesstr' => "sim\:s"
    },
);

%Locales::DB::Language::pt_pt::code_to_name = (
    'aa'     => 'afar',
    'ab'     => 'abcázio',
    'ace'    => 'achém',
    'ach'    => 'acoli',
    'ada'    => 'adangme',
    'ady'    => 'adigue',
    'ae'     => 'avéstico',
    'af'     => 'afrikaans',
    'afa'    => "idioma\ afro\-asiático",
    'afh'    => 'afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'ainu',
    'ak'     => 'akan',
    'akk'    => 'acadiano',
    'ale'    => 'aleúte',
    'alg'    => "idioma\ algonquiano",
    'alt'    => "altai\ do\ sul",
    'am'     => 'amárico',
    'an'     => 'aragonês',
    'ang'    => "inglês\ arcaico",
    'anp'    => 'angika',
    'apa'    => "idioma\ apache",
    'ar'     => 'árabe',
    'arc'    => 'aramaico',
    'arn'    => 'araucano',
    'arp'    => 'arapaho',
    'art'    => "idioma\ artifical",
    'arw'    => 'arauaqui',
    'as'     => 'assamês',
    'asa'    => 'asa',
    'ast'    => 'asturiano',
    'ath'    => "idioma\ atabascano",
    'aus'    => "idioma\ australiano",
    'av'     => 'avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'aimara',
    'az'     => 'Azerbaijano',
    'ba'     => 'bashkir',
    'bad'    => 'banda',
    'bai'    => "bamileke\ Languages",
    'bal'    => 'balúchi',
    'ban'    => 'balinês',
    'bas'    => 'basa',
    'bat'    => "idioma\ báltico",
    'be'     => "bielo\-russo",
    'bej'    => 'beja',
    'bem'    => 'bemba',
    'ber'    => 'berbere',
    'bez'    => 'bez',
    'bg'     => 'búlgaro',
    'bh'     => 'biari',
    'bho'    => 'bhojpuri',
    'bi'     => 'bislamá',
    'bik'    => 'bikol',
    'bin'    => 'bini',
    'bla'    => 'siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengali',
    'bnt'    => 'banto',
    'bo'     => 'tibetano',
    'br'     => 'bretão',
    'bra'    => 'braj',
    'brx'    => 'bodo',
    'bs'     => 'bósnio',
    'btk'    => 'bataque',
    'bua'    => 'buriat',
    'bug'    => 'Buginese',
    'byn'    => 'blin',
    'ca'     => 'catalão',
    'cad'    => 'caddo',
    'cai'    => "idioma\ indígena\ centro\-americano",
    'car'    => 'caribe',
    'cau'    => "idioma\ caucásico",
    'cay'    => 'Cayuga',
    'cch'    => 'atsam',
    'ce'     => 'chechene',
    'ceb'    => 'cebuano',
    'cel'    => "idioma\ céltico",
    'cgg'    => 'Chiga',
    'ch'     => 'chamorro',
    'chb'    => 'chibcha',
    'chg'    => 'chagatai',
    'chk'    => 'chuukese',
    'chm'    => 'mari',
    'chn'    => "jargão\ chinook",
    'cho'    => 'choctaw',
    'chp'    => 'chipewyan',
    'chr'    => 'cherokee',
    'chy'    => 'cheiene',
    'cmc'    => "idioma\ chamic",
    'co'     => 'córsico',
    'cop'    => 'copta',
    'cpe'    => "crioulo\ ou\ pidgin\ do\ inglês",
    'cpf'    => "crioulo\ ou\ pidgin\ do\ francês",
    'cpp'    => "crioulo\ ou\ pidgin\ do\ português",
    'cr'     => 'cree',
    'crh'    => "turco\ da\ Crimeia",
    'crp'    => "crioulo\ ou\ pidgin",
    'cs'     => 'checo',
    'csb'    => 'kashubian',
    'cu'     => "eslavo\ eclesiástico",
    'cus'    => "idioma\ cuchita",
    'cv'     => 'chuvash',
    'cy'     => 'galês',
    'da'     => 'dinamarquês',
    'dak'    => 'dacota',
    'dar'    => 'dargwa',
    'dav'    => 'Taita',
    'day'    => 'dayak',
    'de'     => 'alemão',
    'de_at'  => "alemão\ austríaco",
    'de_ch'  => "Alto\ Alemão\ Suíço",
    'del'    => 'delaware',
    'den'    => 'slave',
    'dgr'    => 'dogrib',
    'din'    => 'dinka',
    'dje'    => 'Zarma',
    'doi'    => 'dogri',
    'dra'    => "idioma\ dravítico",
    'dsb'    => "sérvio\ baixo",
    'dua'    => 'duala',
    'dum'    => "holandês\ médio",
    'dv'     => 'divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'diula',
    'dz'     => 'dzonga',
    'ebu'    => 'embu',
    'ee'     => 'eve',
    'efi'    => 'efique',
    'egy'    => "egípcio\ clássico",
    'eka'    => 'ekajuk',
    'el'     => 'grego',
    'elx'    => 'elamite',
    'en'     => 'inglês',
    'en_au'  => "inglês\ australiano",
    'en_ca'  => "inglês\ canadense",
    'en_gb'  => "Inglês\ Britânico",
    'en_us'  => "Inglês\ \(EUA\)",
    'enm'    => "inglês\ medieval",
    'eo'     => 'esperanto',
    'es'     => 'espanhol',
    'es_419' => "espanhol\ latino\-americano",
    'es_es'  => "espanhol\ ibérico",
    'et'     => 'estónio',
    'eu'     => 'basco',
    'ewo'    => 'ewondo',
    'fa'     => 'persa',
    'fan'    => 'fangue',
    'fat'    => 'fanti',
    'ff'     => 'fula',
    'fi'     => 'finlandês',
    'fil'    => 'filipino',
    'fiu'    => "idioma\ ugro\-finês",
    'fj'     => 'fijiano',
    'fo'     => 'feroês',
    'fon'    => 'fom',
    'fr'     => 'francês',
    'fr_ca'  => "francês\ canadense",
    'fr_ch'  => "francês\ suíço",
    'frm'    => "francês\ medieval",
    'fro'    => "francês\ arcaico",
    'frr'    => "frísio\ setentrional",
    'frs'    => "frísio\ oriental",
    'fur'    => 'friulano',
    'fy'     => "frísio\ ocidental",
    'ga'     => 'irlandês',
    'gaa'    => 'ga',
    'gay'    => 'gayo',
    'gba'    => 'gbaia',
    'gd'     => "gaélico\ escocês",
    'gem'    => "idioma\ germânico",
    'gez'    => 'geez',
    'gil'    => 'gilbertês',
    'gl'     => 'galego',
    'gmh'    => "alemão\ medieval\ alto",
    'gn'     => 'guarani',
    'goh'    => "alemão\ arcaico\ alto",
    'gon'    => 'gondi',
    'gor'    => 'gorontalo',
    'got'    => 'gótico',
    'grb'    => 'grebo',
    'grc'    => "grego\ clássico",
    'gsw'    => "alemão\ da\ Suíça",
    'gu'     => 'guzerate',
    'guz'    => 'Gusii',
    'gv'     => 'manx',
    'gwi'    => 'gwichʼin',
    'ha'     => 'hauçá',
    'hai'    => 'haida',
    'haw'    => 'havaiano',
    'he'     => 'hebraico',
    'hi'     => 'Hindi',
    'hil'    => 'hiligaynon',
    'him'    => 'himachali',
    'hit'    => 'hitita',
    'hmn'    => 'hmong',
    'ho'     => "hiri\ motu",
    'hr'     => 'croata',
    'hsb'    => "sorbiano\ superior",
    'ht'     => 'haitiano',
    'hu'     => 'húngaro',
    'hup'    => 'hupa',
    'hy'     => 'arménio',
    'hz'     => 'herero',
    'ia'     => 'interlíngua',
    'iba'    => 'Iban',
    'id'     => 'indonésio',
    'ie'     => 'interlingue',
    'ig'     => 'igbo',
    'ii'     => "sichuan\ yi",
    'ijo'    => 'ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'ilocano',
    'inc'    => "idioma\ índico",
    'ine'    => "idioma\ indo\-europeu",
    'inh'    => 'inguche',
    'io'     => 'ido',
    'ira'    => 'iraniano',
    'iro'    => "idioma\ iroquês",
    'is'     => 'islandês',
    'it'     => 'italiano',
    'iu'     => 'inuktitut',
    'ja'     => 'japonês',
    'jbo'    => 'lojban',
    'jmc'    => 'Machame',
    'jpr'    => "judaico\-persa",
    'jrb'    => "judaico\-arábico",
    'jv'     => 'jv',
    'ka'     => 'georgiano',
    'kaa'    => "kara\-kalpak",
    'kab'    => 'kabyle',
    'kac'    => 'kachin',
    'kaj'    => 'jju',
    'kam'    => 'kamba',
    'kar'    => 'karen',
    'kaw'    => 'kawi',
    'kbd'    => 'kabardiano',
    'kcg'    => 'tyap',
    'kde'    => 'Makonde',
    'kea'    => "cabo\-verdiano",
    'kfo'    => 'koro',
    'kg'     => 'congolês',
    'kha'    => 'khasi',
    'khi'    => 'khoisan',
    'kho'    => 'khotanês',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'quicuio',
    'kj'     => 'kuanyama',
    'kk'     => 'cazaque',
    'kl'     => 'groenlandês',
    'kln'    => 'Kalenjin',
    'km'     => 'cmer',
    'kmb'    => 'quimbundo',
    'kn'     => 'canarês',
    'ko'     => 'coreano',
    'kok'    => 'concani',
    'kos'    => 'kosraean',
    'kpe'    => 'kpelle',
    'kr'     => 'canúri',
    'krc'    => "karachay\-balkar",
    'krl'    => "idioma\ carélio",
    'kro'    => 'kru',
    'kru'    => 'kurukh',
    'ks'     => 'caxemira',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'curdo',
    'kum'    => 'kumyk',
    'kut'    => 'kutenai',
    'kv'     => 'komi',
    'kw'     => 'córnico',
    'ky'     => 'quirguiz',
    'la'     => 'latim',
    'lad'    => 'ladino',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'lamba',
    'lb'     => 'luxemburguês',
    'lez'    => 'lezghiano',
    'lg'     => 'luganda',
    'li'     => 'limburguês',
    'ln'     => 'lingala',
    'lo'     => 'laosiano',
    'lol'    => 'mongo',
    'loz'    => 'lozi',
    'lt'     => 'lituano',
    'lu'     => "luba\-catanga",
    'lua'    => "luba\-lulua",
    'lui'    => 'luiseno',
    'lun'    => 'lunda',
    'luo'    => 'luo',
    'lus'    => 'lushai',
    'luy'    => 'luy',
    'lv'     => 'letão',
    'mad'    => 'madurês',
    'mag'    => 'magahi',
    'mai'    => 'maithili',
    'mak'    => 'makasar',
    'man'    => 'mandinga',
    'map'    => 'austronésio',
    'mas'    => 'massai',
    'mdf'    => 'mocsa',
    'mdr'    => 'mandar',
    'men'    => 'mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'malgaxe',
    'mga'    => "irlandês\,\ medieval\ \(900\-1200\)",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'marshalês',
    'mi'     => 'maori',
    'mic'    => 'miquemaque',
    'min'    => 'minangkabau',
    'mis'    => "idiomas\ diversos",
    'mk'     => 'macedónio',
    'mkh'    => "idioma\ mon\-khmer",
    'ml'     => 'malaiala',
    'mn'     => 'mongol',
    'mnc'    => 'manchu',
    'mni'    => 'manipuri',
    'mno'    => "idioma\ manobo",
    'mo'     => 'moldávio',
    'moh'    => 'mohawk',
    'mos'    => 'mossi',
    'mr'     => 'marata',
    'ms'     => 'malaio',
    'mt'     => 'maltês',
    'mua'    => 'Mundang',
    'mul'    => "idiomas\ múltiplos",
    'mun'    => "idiomas\ munda",
    'mus'    => 'creek',
    'mwl'    => 'mirandês',
    'mwr'    => 'marwari',
    'my'     => 'birmanês',
    'myn'    => 'maia',
    'myv'    => 'erzya',
    'na'     => 'nauruano',
    'nah'    => 'Nauatle',
    'nai'    => "idioma\ indígena\ norte\-americano",
    'nap'    => 'napolitano',
    'naq'    => 'Nama',
    'nb'     => "bokmål\ norueguês",
    'nd'     => "ndebele\ do\ norte",
    'nds'    => "baixo\ alemão",
    'ne'     => 'nepali',
    'new'    => 'newari',
    'ng'     => 'dongo',
    'nia'    => 'nias',
    'nic'    => "nigeriano\ \-\ cordofano",
    'niu'    => 'niueano',
    'nl'     => 'holandês',
    'nl_be'  => 'Flamengo',
    'nmg'    => 'Kwasio',
    'nn'     => "nynorsk\ norueguês",
    'no'     => 'norueguês',
    'nog'    => 'nogai',
    'non'    => "norse\,\ old",
    'nqo'    => "n\'ko",
    'nr'     => "ndebele\ do\ sul",
    'nso'    => "soto\ setentrional",
    'nub'    => "idioma\ núbio",
    'nus'    => 'Nuer',
    'nv'     => 'navajo',
    'nwc'    => "newari\ clássico",
    'ny'     => 'nianja',
    'nym'    => 'nyamwezi',
    'nyn'    => 'nyankole',
    'nyo'    => 'nyoro',
    'nzi'    => 'nzima',
    'oc'     => 'provençal',
    'oj'     => 'ojibwa',
    'om'     => 'oromo',
    'or'     => 'oriya',
    'os'     => 'ossético',
    'osa'    => 'osage',
    'ota'    => "turco\ otomano",
    'oto'    => "idioma\ otomano",
    'pa'     => 'panjabi',
    'paa'    => "idioma\ papuano",
    'pag'    => 'pangasinã',
    'pal'    => 'pálavi',
    'pam'    => 'pampanga',
    'pap'    => 'papiamento',
    'pau'    => 'palauano',
    'peo'    => "persa\ arcaico\ \(aprox\.\ 600\-400\ a\.C\.\)",
    'phi'    => "idioma\ filipino",
    'phn'    => 'fenício',
    'pi'     => 'páli',
    'pl'     => 'polaco',
    'pon'    => 'pohnpeian',
    'pra'    => "idioma\ prácito",
    'pro'    => "provençal\,\ arcaico\ \(até\ 1500\)",
    'ps'     => 'Pastó',
    'pt'     => 'português',
    'pt_br'  => "português\ do\ Brasil",
    'pt_pt'  => "português\ europeu",
    'qu'     => 'quíchua',
    'raj'    => 'rajastani',
    'rap'    => 'rapanui',
    'rar'    => 'rarotongano',
    'rm'     => 'Romanche',
    'rn'     => 'rundi',
    'ro'     => 'romeno',
    'roa'    => "idioma\ românico",
    'rof'    => 'rombo',
    'rom'    => 'romanês',
    'ru'     => 'russo',
    'rup'    => 'aromeno',
    'rw'     => 'kinyarwanda',
    'rwk'    => 'rwa',
    'sa'     => 'sânscrito',
    'sad'    => 'sandawe',
    'sah'    => 'iacuto',
    'sai'    => "idioma\ indígeno\ sul\-americano",
    'sal'    => "salishan\ languages",
    'sam'    => "aramaico\ samaritano",
    'saq'    => 'Samburu',
    'sas'    => 'sasak',
    'sat'    => 'santali',
    'sbp'    => 'Sangu',
    'sc'     => 'sardo',
    'scn'    => 'siciliano',
    'sco'    => 'escocês',
    'sd'     => 'sindi',
    'se'     => "sami\ do\ norte",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'selkup',
    'sem'    => "idioma\ semítico",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => "irlandês\ arcaico",
    'sgn'    => "linguages\ de\ sinais",
    'sh'     => "servo\-croata",
    'shi'    => 'Tachelhit',
    'shn'    => 'shan',
    'si'     => 'cingalês',
    'sid'    => 'sidamo',
    'sio'    => "idioma\ sioux",
    'sit'    => "idioma\ sino\-tibetano",
    'sk'     => 'eslovaco',
    'sl'     => 'esloveno',
    'sla'    => "idioma\ eslavo",
    'sm'     => 'samoano',
    'sma'    => "sami\ do\ sul",
    'smi'    => "idioma\ sami",
    'smj'    => "lule\ sami",
    'smn'    => "inari\ sami",
    'sms'    => "skolt\ sami",
    'sn'     => 'shona',
    'snk'    => 'soninquê',
    'so'     => 'somali',
    'sog'    => 'sogdiano',
    'son'    => 'songai',
    'sq'     => 'albanês',
    'sr'     => 'sérvio',
    'srn'    => "idioma\ surinamês",
    'srr'    => 'serere',
    'ss'     => 'swati',
    'ssa'    => "idioma\ nilo\-sariano",
    'ssy'    => 'Saho',
    'st'     => "soto\ do\ sul",
    'su'     => 'sundanês',
    'suk'    => 'sukuma',
    'sus'    => 'sosso',
    'sux'    => 'sumério',
    'sv'     => 'sueco',
    'sw'     => 'suaili',
    'swb'    => "língua\ comoriana",
    'swc'    => "Congo\ Swahili",
    'syc'    => "siríaco\ clássico",
    'syr'    => 'siríaco',
    'ta'     => 'Tâmil',
    'tai'    => "idioma\ tailândes",
    'te'     => 'telugu',
    'tem'    => 'timne',
    'teo'    => 'Teso',
    'ter'    => 'tereno',
    'tet'    => 'Tétum',
    'tg'     => 'tajique',
    'th'     => 'tailandês',
    'ti'     => 'tigrínia',
    'tig'    => 'tigré',
    'tiv'    => 'tiv',
    'tk'     => 'turcomano',
    'tkl'    => 'toquelauano',
    'tl'     => 'tagalogue',
    'tlh'    => 'klingon',
    'tli'    => 'tlinguite',
    'tmh'    => 'tamaxeque',
    'tn'     => 'tswana',
    'to'     => 'tonga',
    'tog'    => 'toganês',
    'tpi'    => "tok\ pisin",
    'tr'     => 'turco',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'tsimshian',
    'tt'     => 'tatar',
    'tum'    => 'tumbuka',
    'tup'    => "idioma\ tupi",
    'tut'    => "idioma\ altaico",
    'tvl'    => 'tuvaluano',
    'tw'     => 'twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'taitiano',
    'tyv'    => 'tuviniano',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'udmurt',
    'ug'     => 'Uigur',
    'uga'    => 'ugarítico',
    'uk'     => 'ucraniano',
    'umb'    => 'umbundu',
    'und'    => "idioma\ inválido\ ou\ desconhecido",
    'ur'     => 'urdu',
    'uz'     => 'usbeque',
    'vai'    => 'vai',
    've'     => 'venda',
    'vi'     => 'vietnamita',
    'vo'     => 'volapuque',
    'vot'    => 'votic',
    'vun'    => 'Vunjo',
    'wa'     => 'valão',
    'wae'    => 'walser',
    'wak'    => "idioma\ wakashan",
    'wal'    => 'walamo',
    'war'    => 'waray',
    'was'    => 'washo',
    'wen'    => "idioma\ sórbio",
    'wo'     => 'uólofe',
    'xal'    => 'kalmyk',
    'xh'     => 'xosa',
    'xog'    => 'Soga',
    'yao'    => 'yao',
    'yap'    => 'yapese',
    'yav'    => 'Yangben',
    'yi'     => 'iídiche',
    'yo'     => 'ioruba',
    'ypk'    => "idioma\ iúpique",
    'yue'    => 'cantonês',
    'za'     => 'zhuang',
    'zap'    => 'zapoteca',
    'zbl'    => "símbolos\ blis",
    'zen'    => 'zenaga',
    'zh'     => 'chinês',
    'znd'    => 'zande',
    'zu'     => 'zulu',
    'zun'    => 'zunhi',
    'zxx'    => "sem\ conteúdo\ linguístico",
    'zza'    => 'zazaki',
);

%Locales::DB::Language::pt_pt::name_to_code = (
    'abcázio'                        => 'ab',
    'acadiano'                        => 'akk',
    'achém'                          => 'ace',
    'acoli'                           => 'ach',
    'adangme'                         => 'ada',
    'adigue'                          => 'ady',
    'afar'                            => 'aa',
    'afrihili'                        => 'afh',
    'afrikaans'                       => 'af',
    'aghem'                           => 'agq',
    'aimara'                          => 'ay',
    'ainu'                            => 'ain',
    'akan'                            => 'ak',
    'albanês'                        => 'sq',
    'alemão'                         => 'de',
    'alemãoarcaicoalto'              => 'goh',
    'alemãoaustríaco'               => 'de_at',
    'alemãodasuíça'                => 'gsw',
    'alemãomedievalalto'             => 'gmh',
    'aleúte'                         => 'ale',
    'altaidosul'                      => 'alt',
    'altoalemãosuíço'              => 'de_ch',
    'amárico'                        => 'am',
    'angika'                          => 'anp',
    'aragonês'                       => 'an',
    'aramaico'                        => 'arc',
    'aramaicosamaritano'              => 'sam',
    'arapaho'                         => 'arp',
    'arauaqui'                        => 'arw',
    'araucano'                        => 'arn',
    'arménio'                        => 'hy',
    'aromeno'                         => 'rup',
    'asa'                             => 'asa',
    'assamês'                        => 'as',
    'asturiano'                       => 'ast',
    'atsam'                           => 'cch',
    'austronésio'                    => 'map',
    'avaric'                          => 'av',
    'avéstico'                       => 'ae',
    'awadhi'                          => 'awa',
    'azerbaijano'                     => 'az',
    'bafia'                           => 'ksf',
    'baixoalemão'                    => 'nds',
    'balinês'                        => 'ban',
    'balúchi'                        => 'bal',
    'bambara'                         => 'bm',
    'bamilekelanguages'               => 'bai',
    'banda'                           => 'bad',
    'banto'                           => 'bnt',
    'basa'                            => 'bas',
    'basco'                           => 'eu',
    'bashkir'                         => 'ba',
    'bataque'                         => 'btk',
    'beja'                            => 'bej',
    'bemba'                           => 'bem',
    'bengali'                         => 'bn',
    'berbere'                         => 'ber',
    'bez'                             => 'bez',
    'bhojpuri'                        => 'bho',
    'biari'                           => 'bh',
    'bielorusso'                      => 'be',
    'bikol'                           => 'bik',
    'bini'                            => 'bin',
    'birmanês'                       => 'my',
    'bislamá'                        => 'bi',
    'blin'                            => 'byn',
    'bodo'                            => 'brx',
    'bokmålnorueguês'               => 'nb',
    'braj'                            => 'bra',
    'bretão'                         => 'br',
    'buginese'                        => 'bug',
    'buriat'                          => 'bua',
    'bósnio'                         => 'bs',
    'búlgaro'                        => 'bg',
    'caboverdiano'                    => 'kea',
    'caddo'                           => 'cad',
    'canarês'                        => 'kn',
    'cantonês'                       => 'yue',
    'canúri'                         => 'kr',
    'caribe'                          => 'car',
    'catalão'                        => 'ca',
    'caxemira'                        => 'ks',
    'cayuga'                          => 'cay',
    'cazaque'                         => 'kk',
    'cebuano'                         => 'ceb',
    'centralmoroccotamazight'         => 'tzm',
    'chagatai'                        => 'chg',
    'chamorro'                        => 'ch',
    'chechene'                        => 'ce',
    'checo'                           => 'cs',
    'cheiene'                         => 'chy',
    'cherokee'                        => 'chr',
    'chibcha'                         => 'chb',
    'chiga'                           => 'cgg',
    'chinês'                         => 'zh',
    'chipewyan'                       => 'chp',
    'choctaw'                         => 'cho',
    'chuukese'                        => 'chk',
    'chuvash'                         => 'cv',
    'cingalês'                       => 'si',
    'cmer'                            => 'km',
    'colognian'                       => 'ksh',
    'concani'                         => 'kok',
    'congolês'                       => 'kg',
    'congoswahili'                    => 'swc',
    'copta'                           => 'cop',
    'coreano'                         => 'ko',
    'cree'                            => 'cr',
    'creek'                           => 'mus',
    'crioulooupidgin'                 => 'crp',
    'crioulooupidgindofrancês'       => 'cpf',
    'crioulooupidgindoinglês'        => 'cpe',
    'crioulooupidgindoportuguês'     => 'cpp',
    'croata'                          => 'hr',
    'curdo'                           => 'ku',
    'córnico'                        => 'kw',
    'córsico'                        => 'co',
    'dacota'                          => 'dak',
    'dargwa'                          => 'dar',
    'dayak'                           => 'day',
    'delaware'                        => 'del',
    'dinamarquês'                    => 'da',
    'dinka'                           => 'din',
    'diula'                           => 'dyu',
    'divehi'                          => 'dv',
    'dogri'                           => 'doi',
    'dogrib'                          => 'dgr',
    'dongo'                           => 'ng',
    'duala'                           => 'dua',
    'dzonga'                          => 'dz',
    'efique'                          => 'efi',
    'egípcioclássico'               => 'egy',
    'ekajuk'                          => 'eka',
    'elamite'                         => 'elx',
    'embu'                            => 'ebu',
    'erzya'                           => 'myv',
    'escocês'                        => 'sco',
    'eslavoeclesiástico'             => 'cu',
    'eslovaco'                        => 'sk',
    'esloveno'                        => 'sl',
    'espanhol'                        => 'es',
    'espanholibérico'                => 'es_es',
    'espanhollatinoamericano'         => 'es_419',
    'esperanto'                       => 'eo',
    'estónio'                        => 'et',
    'eve'                             => 'ee',
    'ewondo'                          => 'ewo',
    'fangue'                          => 'fan',
    'fanti'                           => 'fat',
    'fenício'                        => 'phn',
    'feroês'                         => 'fo',
    'fijiano'                         => 'fj',
    'filipino'                        => 'fil',
    'finlandês'                      => 'fi',
    'flamengo'                        => 'nl_be',
    'fom'                             => 'fon',
    'francês'                        => 'fr',
    'francêsarcaico'                 => 'fro',
    'francêscanadense'               => 'fr_ca',
    'francêsmedieval'                => 'frm',
    'francêssuíço'                 => 'fr_ch',
    'friulano'                        => 'fur',
    'frísioocidental'                => 'fy',
    'frísiooriental'                 => 'frs',
    'frísiosetentrional'             => 'frr',
    'fula'                            => 'ff',
    'ga'                              => 'gaa',
    'galego'                          => 'gl',
    'galês'                          => 'cy',
    'gayo'                            => 'gay',
    'gaélicoescocês'                => 'gd',
    'gbaia'                           => 'gba',
    'geez'                            => 'gez',
    'georgiano'                       => 'ka',
    'gilbertês'                      => 'gil',
    'gondi'                           => 'gon',
    'gorontalo'                       => 'gor',
    'grebo'                           => 'grb',
    'grego'                           => 'el',
    'gregoclássico'                  => 'grc',
    'groenlandês'                    => 'kl',
    'guarani'                         => 'gn',
    'gusii'                           => 'guz',
    'guzerate'                        => 'gu',
    'gwichʼin'                       => 'gwi',
    'gótico'                         => 'got',
    'haida'                           => 'hai',
    'haitiano'                        => 'ht',
    'hauçá'                         => 'ha',
    'havaiano'                        => 'haw',
    'hebraico'                        => 'he',
    'herero'                          => 'hz',
    'hiligaynon'                      => 'hil',
    'himachali'                       => 'him',
    'hindi'                           => 'hi',
    'hirimotu'                        => 'ho',
    'hitita'                          => 'hit',
    'hmong'                           => 'hmn',
    'holandês'                       => 'nl',
    'holandêsmédio'                 => 'dum',
    'hupa'                            => 'hup',
    'húngaro'                        => 'hu',
    'iacuto'                          => 'sah',
    'iban'                            => 'iba',
    'idiomaafroasiático'             => 'afa',
    'idiomaalgonquiano'               => 'alg',
    'idiomaaltaico'                   => 'tut',
    'idiomaapache'                    => 'apa',
    'idiomaartifical'                 => 'art',
    'idiomaatabascano'                => 'ath',
    'idiomaaustraliano'               => 'aus',
    'idiomabáltico'                  => 'bat',
    'idiomacarélio'                  => 'krl',
    'idiomacaucásico'                => 'cau',
    'idiomachamic'                    => 'cmc',
    'idiomacuchita'                   => 'cus',
    'idiomacéltico'                  => 'cel',
    'idiomadravítico'                => 'dra',
    'idiomaeslavo'                    => 'sla',
    'idiomafilipino'                  => 'phi',
    'idiomagermânico'                => 'gem',
    'idiomaindoeuropeu'               => 'ine',
    'idiomaindígenacentroamericano'  => 'cai',
    'idiomaindígenanorteamericano'   => 'nai',
    'idiomaindígenosulamericano'     => 'sai',
    'idiomainválidooudesconhecido'   => 'und',
    'idiomairoquês'                  => 'iro',
    'idiomaiúpique'                  => 'ypk',
    'idiomamanobo'                    => 'mno',
    'idiomamonkhmer'                  => 'mkh',
    'idiomanilosariano'               => 'ssa',
    'idiomanúbio'                    => 'nub',
    'idiomaotomano'                   => 'oto',
    'idiomapapuano'                   => 'paa',
    'idiomaprácito'                  => 'pra',
    'idiomaromânico'                 => 'roa',
    'idiomasami'                      => 'smi',
    'idiomasdiversos'                 => 'mis',
    'idiomasemítico'                 => 'sem',
    'idiomasinotibetano'              => 'sit',
    'idiomasioux'                     => 'sio',
    'idiomasmunda'                    => 'mun',
    'idiomasmúltiplos'               => 'mul',
    'idiomasurinamês'                => 'srn',
    'idiomasórbio'                   => 'wen',
    'idiomatailândes'                => 'tai',
    'idiomatupi'                      => 'tup',
    'idiomaugrofinês'                => 'fiu',
    'idiomawakashan'                  => 'wak',
    'idiomaíndico'                   => 'inc',
    'ido'                             => 'io',
    'igbo'                            => 'ig',
    'ijo'                             => 'ijo',
    'ilocano'                         => 'ilo',
    'inarisami'                       => 'smn',
    'indonésio'                      => 'id',
    'inglês'                         => 'en',
    'inglêsarcaico'                  => 'ang',
    'inglêsaustraliano'              => 'en_au',
    'inglêsbritânico'               => 'en_gb',
    'inglêscanadense'                => 'en_ca',
    'inglêseua'                      => 'en_us',
    'inglêsmedieval'                 => 'enm',
    'inguche'                         => 'inh',
    'interlingue'                     => 'ie',
    'interlíngua'                    => 'ia',
    'inuktitut'                       => 'iu',
    'inupiaq'                         => 'ik',
    'ioruba'                          => 'yo',
    'iraniano'                        => 'ira',
    'irlandês'                       => 'ga',
    "irlandês\,medieval9001200"      => 'mga',
    'irlandêsarcaico'                => 'sga',
    'islandês'                       => 'is',
    'italiano'                        => 'it',
    'iídiche'                        => 'yi',
    'japonês'                        => 'ja',
    'jargãochinook'                  => 'chn',
    'jju'                             => 'kaj',
    'jolafonyi'                       => 'dyo',
    'judaicoarábico'                 => 'jrb',
    'judaicopersa'                    => 'jpr',
    'jv'                              => 'jv',
    'kabardiano'                      => 'kbd',
    'kabyle'                          => 'kab',
    'kachin'                          => 'kac',
    'kalenjin'                        => 'kln',
    'kalmyk'                          => 'xal',
    'kamba'                           => 'kam',
    'karachaybalkar'                  => 'krc',
    'karakalpak'                      => 'kaa',
    'karen'                           => 'kar',
    'kashubian'                       => 'csb',
    'kawi'                            => 'kaw',
    'khasi'                           => 'kha',
    'khoisan'                         => 'khi',
    'khotanês'                       => 'kho',
    'kinyarwanda'                     => 'rw',
    'klingon'                         => 'tlh',
    'komi'                            => 'kv',
    'koro'                            => 'kfo',
    'kosraean'                        => 'kos',
    'koyraborosenni'                  => 'ses',
    'koyrachiini'                     => 'khq',
    'kpelle'                          => 'kpe',
    'kru'                             => 'kro',
    'kuanyama'                        => 'kj',
    'kumyk'                           => 'kum',
    'kurukh'                          => 'kru',
    'kutenai'                         => 'kut',
    'kwasio'                          => 'nmg',
    'ladino'                          => 'lad',
    'lahnda'                          => 'lah',
    'lamba'                           => 'lam',
    'langi'                           => 'lag',
    'laosiano'                        => 'lo',
    'latim'                           => 'la',
    'letão'                          => 'lv',
    'lezghiano'                       => 'lez',
    'limburguês'                     => 'li',
    'lingala'                         => 'ln',
    'linguagesdesinais'               => 'sgn',
    'lituano'                         => 'lt',
    'lojban'                          => 'jbo',
    'lozi'                            => 'loz',
    'lubacatanga'                     => 'lu',
    'lubalulua'                       => 'lua',
    'luganda'                         => 'lg',
    'luiseno'                         => 'lui',
    'lulesami'                        => 'smj',
    'lunda'                           => 'lun',
    'luo'                             => 'luo',
    'lushai'                          => 'lus',
    'luxemburguês'                   => 'lb',
    'luy'                             => 'luy',
    'línguacomoriana'                => 'swb',
    'macedónio'                      => 'mk',
    'machame'                         => 'jmc',
    'madurês'                        => 'mad',
    'magahi'                          => 'mag',
    'maia'                            => 'myn',
    'maithili'                        => 'mai',
    'makasar'                         => 'mak',
    'makhuwameetto'                   => 'mgh',
    'makonde'                         => 'kde',
    'malaiala'                        => 'ml',
    'malaio'                          => 'ms',
    'malgaxe'                         => 'mg',
    'maltês'                         => 'mt',
    'manchu'                          => 'mnc',
    'mandar'                          => 'mdr',
    'mandinga'                        => 'man',
    'manipuri'                        => 'mni',
    'manx'                            => 'gv',
    'maori'                           => 'mi',
    'marata'                          => 'mr',
    'mari'                            => 'chm',
    'marshalês'                      => 'mh',
    'marwari'                         => 'mwr',
    'massai'                          => 'mas',
    'mende'                           => 'men',
    'meru'                            => 'mer',
    'minangkabau'                     => 'min',
    'miquemaque'                      => 'mic',
    'mirandês'                       => 'mwl',
    'mocsa'                           => 'mdf',
    'mohawk'                          => 'moh',
    'moldávio'                       => 'mo',
    'mongo'                           => 'lol',
    'mongol'                          => 'mn',
    'morisyen'                        => 'mfe',
    'mossi'                           => 'mos',
    'mundang'                         => 'mua',
    'nama'                            => 'naq',
    'napolitano'                      => 'nap',
    'nauatle'                         => 'nah',
    'nauruano'                        => 'na',
    'navajo'                          => 'nv',
    'ndebeledonorte'                  => 'nd',
    'ndebeledosul'                    => 'nr',
    'nepali'                          => 'ne',
    'newari'                          => 'new',
    'newariclássico'                 => 'nwc',
    'nianja'                          => 'ny',
    'nias'                            => 'nia',
    'nigerianocordofano'              => 'nic',
    'niueano'                         => 'niu',
    'nko'                             => 'nqo',
    'nogai'                           => 'nog',
    "norse\,old"                      => 'non',
    'norueguês'                      => 'no',
    'nuer'                            => 'nus',
    'nyamwezi'                        => 'nym',
    'nyankole'                        => 'nyn',
    'nynorsknorueguês'               => 'nn',
    'nyoro'                           => 'nyo',
    'nzima'                           => 'nzi',
    'ojibwa'                          => 'oj',
    'oriya'                           => 'or',
    'oromo'                           => 'om',
    'osage'                           => 'osa',
    'ossético'                       => 'os',
    'palauano'                        => 'pau',
    'pampanga'                        => 'pam',
    'pangasinã'                      => 'pag',
    'panjabi'                         => 'pa',
    'papiamento'                      => 'pap',
    'pastó'                          => 'ps',
    'persa'                           => 'fa',
    "persaarcaicoaprox\.600400a\.c\." => 'peo',
    'pohnpeian'                       => 'pon',
    'polaco'                          => 'pl',
    'português'                      => 'pt',
    'portuguêsdobrasil'              => 'pt_br',
    'portuguêseuropeu'               => 'pt_pt',
    'provençal'                      => 'oc',
    "provençal\,arcaicoaté1500"     => 'pro',
    'pálavi'                         => 'pal',
    'páli'                           => 'pi',
    'quicuio'                         => 'ki',
    'quimbundo'                       => 'kmb',
    'quirguiz'                        => 'ky',
    'quíchua'                        => 'qu',
    'rajastani'                       => 'raj',
    'rapanui'                         => 'rap',
    'rarotongano'                     => 'rar',
    'romanche'                        => 'rm',
    'romanês'                        => 'rom',
    'rombo'                           => 'rof',
    'romeno'                          => 'ro',
    'rundi'                           => 'rn',
    'russo'                           => 'ru',
    'rwa'                             => 'rwk',
    'saho'                            => 'ssy',
    'salishanlanguages'               => 'sal',
    'samburu'                         => 'saq',
    'samidonorte'                     => 'se',
    'samidosul'                       => 'sma',
    'samoano'                         => 'sm',
    'sandawe'                         => 'sad',
    'sango'                           => 'sg',
    'sangu'                           => 'sbp',
    'santali'                         => 'sat',
    'sardo'                           => 'sc',
    'sasak'                           => 'sas',
    'selkup'                          => 'sel',
    'semconteúdolinguístico'        => 'zxx',
    'sena'                            => 'seh',
    'seneca'                          => 'see',
    'serere'                          => 'srr',
    'servocroata'                     => 'sh',
    'shambala'                        => 'ksb',
    'shan'                            => 'shn',
    'shona'                           => 'sn',
    'sichuanyi'                       => 'ii',
    'siciliano'                       => 'scn',
    'sidamo'                          => 'sid',
    'siksika'                         => 'bla',
    'sindi'                           => 'sd',
    'siríaco'                        => 'syr',
    'siríacoclássico'               => 'syc',
    'skoltsami'                       => 'sms',
    'slave'                           => 'den',
    'soga'                            => 'xog',
    'sogdiano'                        => 'sog',
    'somali'                          => 'so',
    'songai'                          => 'son',
    'soninquê'                       => 'snk',
    'sorbianosuperior'                => 'hsb',
    'sosso'                           => 'sus',
    'sotodosul'                       => 'st',
    'sotosetentrional'                => 'nso',
    'suaili'                          => 'sw',
    'sueco'                           => 'sv',
    'sukuma'                          => 'suk',
    'sumério'                        => 'sux',
    'sundanês'                       => 'su',
    'swati'                           => 'ss',
    'sânscrito'                      => 'sa',
    'sérvio'                         => 'sr',
    'sérviobaixo'                    => 'dsb',
    'símbolosblis'                   => 'zbl',
    'tachelhit'                       => 'shi',
    'tagalogue'                       => 'tl',
    'tailandês'                      => 'th',
    'taita'                           => 'dav',
    'taitiano'                        => 'ty',
    'tajique'                         => 'tg',
    'tamaxeque'                       => 'tmh',
    'taroko'                          => 'trv',
    'tasawaq'                         => 'twq',
    'tatar'                           => 'tt',
    'telugu'                          => 'te',
    'tereno'                          => 'ter',
    'teso'                            => 'teo',
    'tibetano'                        => 'bo',
    'tigré'                          => 'tig',
    'tigrínia'                       => 'ti',
    'timne'                           => 'tem',
    'tiv'                             => 'tiv',
    'tlinguite'                       => 'tli',
    'toganês'                        => 'tog',
    'tokpisin'                        => 'tpi',
    'tonga'                           => 'to',
    'toquelauano'                     => 'tkl',
    'tsimshian'                       => 'tsi',
    'tsonga'                          => 'ts',
    'tswana'                          => 'tn',
    'tumbuka'                         => 'tum',
    'turco'                           => 'tr',
    'turcodacrimeia'                  => 'crh',
    'turcomano'                       => 'tk',
    'turcootomano'                    => 'ota',
    'tuvaluano'                       => 'tvl',
    'tuviniano'                       => 'tyv',
    'twi'                             => 'tw',
    'tyap'                            => 'kcg',
    'tâmil'                          => 'ta',
    'tétum'                          => 'tet',
    'ucraniano'                       => 'uk',
    'udmurt'                          => 'udm',
    'ugarítico'                      => 'uga',
    'uigur'                           => 'ug',
    'umbundu'                         => 'umb',
    'urdu'                            => 'ur',
    'usbeque'                         => 'uz',
    'uólofe'                         => 'wo',
    'vai'                             => 'vai',
    'valão'                          => 'wa',
    'venda'                           => 've',
    'vietnamita'                      => 'vi',
    'volapuque'                       => 'vo',
    'votic'                           => 'vot',
    'vunjo'                           => 'vun',
    'walamo'                          => 'wal',
    'walser'                          => 'wae',
    'waray'                           => 'war',
    'washo'                           => 'was',
    'xosa'                            => 'xh',
    'yangben'                         => 'yav',
    'yao'                             => 'yao',
    'yapese'                          => 'yap',
    'zande'                           => 'znd',
    'zapoteca'                        => 'zap',
    'zarma'                           => 'dje',
    'zazaki'                          => 'zza',
    'zenaga'                          => 'zen',
    'zhuang'                          => 'za',
    'zulu'                            => 'zu',
    'zunhi'                           => 'zun',
    'árabe'                          => 'ar',
);

1;
