#!/usr/bin/pugs

use v6;
use Test;

plan 21;

{
	my %hash; eval '%hash = enum «:Mon(1) Tue Wed Thu Fri Sat Sun»';

	#is((%hash<Mon Tue Wed Thu Fri Sat Sun>) »eq« (1 .. 7)), "enum generated correct sequence");
	is(%hash<Mon>, 1, "first value ok", :todo);
	is(%hash<Thu>, 4, "fourth value ok", :todo);
	is(%hash<Sun>, 7, "last value ok", :todo);
};

{
	my %hash; eval '%hash = enum «:Two(2) Three Four»';

	#is((%hash<Two Three Four>) »eq« (2 .. 4)), "enum generated correct sequence");
	is(%hash<Two>, 2, "first value ok", :todo);
	is(%hash<Three>, 3, "second value ok", :todo);
	is(%hash<Four>, 4, "last value ok", :todo);
};

my %hash;

lives_ok { %hash = enum <<:Sun(1) :Mon(2) :Tue(3) :Wed(4) :Thu(5) :Fri(6) :Sat(7)>>; }, 'specifying keys and values works...', :todo<feature>;

is %hash.keys, <Sun Mon Tue Wed Thu Fri Sat>, '...and the right keys are assigned', :todo<feature>;

is %hash<Sun Mon Tue Wed Thu Fri Sat>, 1..7, '...and the right values are assigned', :todo<feature>;

%hash = ();

lives_ok { %hash = enum <<:Sun(1) Mon Tue Wed Thu Fri Sat>>; }, 'specifying a value for only the first key works...', :todo<feature>;

is %hash.keys, <Sun Mon Tue Wed Thu Fri Sat>, '...and the right keys are assigned', :todo<feature>;

is %hash<Sun Mon Tue Wed Thu Fri Sat>, 1..7, '...and the right values are assigned', :todo<feature>;

%hash = ();

lives_ok { %hash = enum «:Sun(1) Mon Tue Wed Thu Fri Sat»; }, 'french quotes work...', :todo<feature>;

is %hash.keys, <Sun Mon Tue Wed Thu Fri Sat>, '...and the right keys are assigned', :todo<feature>;

is %hash<Sun Mon Tue Wed Thu Fri Sat>, 1..7, '...and the right values are assigned', :todo<feature>;

%hash = ();

lives_ok { %hash = enum <<:Sun(1) Mon Tue :Wed(4) Thu Fri Sat>>; }, 'specifying continuous values in the middle works...', :todo<feature>;

is %hash.keys, <Sun Mon Tue Wed Thu Fri Sat>, '...and the right keys are assigned', :todo<feature>;

is %hash<Sun Mon Tue Wed Thu Fri Sat>, 1..7, '...and the right values are assigned', :todo<feature>;

%hash = ();

lives_ok { %hash = enum <<:Sun(1) Mon Tue :Wed(5) Thu Fri Sat>>; }, 'specifying different values in the middle works...', :todo<feature>;

is %hash.keys, <Sun Mon Tue Wed Thu Fri Sat>, '...and the right keys are assigned', :todo<feature>;

is %hash<Sun Mon Tue Wed Thu Fri Sat>, (1, 2, 3, 5, 6, 7, 8), '...and the right values are assigned', :todo<feature>;

%hash = ();

