# Generated by default/object.tt
package Paws::MediaConvert::Av1Settings;
  use Moose;
  has AdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'adaptiveQuantization', traits => ['NameInRequest']);
  has FramerateControl => (is => 'ro', isa => 'Str', request_name => 'framerateControl', traits => ['NameInRequest']);
  has FramerateConversionAlgorithm => (is => 'ro', isa => 'Str', request_name => 'framerateConversionAlgorithm', traits => ['NameInRequest']);
  has FramerateDenominator => (is => 'ro', isa => 'Int', request_name => 'framerateDenominator', traits => ['NameInRequest']);
  has FramerateNumerator => (is => 'ro', isa => 'Int', request_name => 'framerateNumerator', traits => ['NameInRequest']);
  has GopSize => (is => 'ro', isa => 'Num', request_name => 'gopSize', traits => ['NameInRequest']);
  has MaxBitrate => (is => 'ro', isa => 'Int', request_name => 'maxBitrate', traits => ['NameInRequest']);
  has NumberBFramesBetweenReferenceFrames => (is => 'ro', isa => 'Int', request_name => 'numberBFramesBetweenReferenceFrames', traits => ['NameInRequest']);
  has QvbrSettings => (is => 'ro', isa => 'Paws::MediaConvert::Av1QvbrSettings', request_name => 'qvbrSettings', traits => ['NameInRequest']);
  has RateControlMode => (is => 'ro', isa => 'Str', request_name => 'rateControlMode', traits => ['NameInRequest']);
  has Slices => (is => 'ro', isa => 'Int', request_name => 'slices', traits => ['NameInRequest']);
  has SpatialAdaptiveQuantization => (is => 'ro', isa => 'Str', request_name => 'spatialAdaptiveQuantization', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::Av1Settings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::Av1Settings object:

  $service_obj->Method(Att1 => { AdaptiveQuantization => $value, ..., SpatialAdaptiveQuantization => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::Av1Settings object:

  $result = $service_obj->Method(...);
  $result->Att1->AdaptiveQuantization

=head1 DESCRIPTION

Required when you set Codec, under VideoDescriptionE<gt>CodecSettings
to the value AV1.

=head1 ATTRIBUTES


=head2 AdaptiveQuantization => Str

Specify the strength of any adaptive quantization filters that you
enable. The value that you choose here applies to Spatial adaptive
quantization (spatialAdaptiveQuantization).


=head2 FramerateControl => Str

If you are using the console, use the Framerate setting to specify the
frame rate for this output. If you want to keep the same frame rate as
the input video, choose Follow source. If you want to do frame rate
conversion, choose a frame rate from the dropdown list or choose
Custom. The framerates shown in the dropdown list are decimal
approximations of fractions. If you choose Custom, specify your frame
rate as a fraction. If you are creating your transcoding job
specification as a JSON file without the console, use FramerateControl
to specify which value the service uses for the frame rate for this
output. Choose INITIALIZE_FROM_SOURCE if you want the service to use
the frame rate from the input. Choose SPECIFIED if you want the service
to use the frame rate you specify in the settings FramerateNumerator
and FramerateDenominator.


=head2 FramerateConversionAlgorithm => Str

Choose the method that you want MediaConvert to use when increasing or
decreasing the frame rate. We recommend using drop duplicate
(DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
30 fps. For numerically complex conversions, you can use interpolate
(INTERPOLATE) to avoid stutter. This results in a smooth picture, but
might introduce undesirable video artifacts. For complex frame rate
conversions, especially if your source video has already been converted
from its original cadence, use FrameFormer (FRAMEFORMER) to do
motion-compensated interpolation. FrameFormer chooses the best
conversion method frame by frame. Note that using FrameFormer increases
the transcoding time and incurs a significant add-on cost.


=head2 FramerateDenominator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateDenominator to specify the denominator of this
fraction. In this example, use 1001 for the value of
FramerateDenominator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 FramerateNumerator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateNumerator to specify the numerator of this
fraction. In this example, use 24000 for the value of
FramerateNumerator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 GopSize => Num

Specify the GOP length (keyframe interval) in frames. With AV1,
MediaConvert doesn't support GOP length in seconds. This value must be
greater than zero and preferably equal to 1 + ((numberBFrames + 1) *
x), where x is an integer value.


=head2 MaxBitrate => Int

Maximum bitrate in bits/second. For example, enter five megabits per
second as 5000000. Required when Rate control mode is QVBR.


=head2 NumberBFramesBetweenReferenceFrames => Int

Specify from the number of B-frames, in the range of 0-15. For AV1
encoding, we recommend using 7 or 15. Choose a larger number for a
lower bitrate and smaller file size; choose a smaller number for better
video quality.


=head2 QvbrSettings => L<Paws::MediaConvert::Av1QvbrSettings>

Settings for quality-defined variable bitrate encoding with the AV1
codec. Required when you set Rate control mode to QVBR. Not valid when
you set Rate control mode to a value other than QVBR, or when you don't
define Rate control mode.


=head2 RateControlMode => Str

'With AV1 outputs, for rate control mode, MediaConvert supports only
quality-defined variable bitrate (QVBR). You can''t use CBR or VBR.'


=head2 Slices => Int

Specify the number of slices per picture. This value must be 1, 2, 4,
8, 16, or 32. For progressive pictures, this value must be less than or
equal to the number of macroblock rows. For interlaced pictures, this
value must be less than or equal to half the number of macroblock rows.


=head2 SpatialAdaptiveQuantization => Str

Keep the default value, Enabled (ENABLED), to adjust quantization
within each frame based on spatial variation of content complexity.
When you enable this feature, the encoder uses fewer bits on areas that
can sustain more distortion with no noticeable visual degradation and
uses more bits on areas where any small distortion will be noticeable.
For example, complex textured blocks are encoded with fewer bits and
smooth textured blocks are encoded with more bits. Enabling this
feature will almost always improve your video quality. Note, though,
that this feature doesn't take into account where the viewer's
attention is likely to be. If viewers are likely to be focusing their
attention on a part of the screen with a lot of complex texture, you
might choose to disable this feature. Related setting: When you enable
spatial adaptive quantization, set the value for Adaptive quantization
(adaptiveQuantization) depending on your content. For homogeneous
content, such as cartoons and video games, set it to Low. For content
with a wider variety of textures, set it to High or Higher.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

