# Generated by default/object.tt
package Paws::Quicksight::DataSourceCredentials;
  use Moose;
  has CopySourceArn => (is => 'ro', isa => 'Str');
  has CredentialPair => (is => 'ro', isa => 'Paws::Quicksight::CredentialPair');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::DataSourceCredentials

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::DataSourceCredentials object:

  $service_obj->Method(Att1 => { CopySourceArn => $value, ..., CredentialPair => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::DataSourceCredentials object:

  $result = $service_obj->Method(...);
  $result->Att1->CopySourceArn

=head1 DESCRIPTION

Data source credentials. This is a variant type structure. For this
structure to be valid, only one of the attributes can be non-null.

=head1 ATTRIBUTES


=head2 CopySourceArn => Str

The Amazon Resource Name (ARN) of a data source that has the credential
pair that you want to use. When C<CopySourceArn> is not null, the
credential pair from the data source in the ARN is used as the
credentials for the C<DataSourceCredentials> structure.


=head2 CredentialPair => L<Paws::Quicksight::CredentialPair>

Credential pair. For more information, see CredentialPair.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

