#!/usr/bin/perl

package eBay::API::XML::Call::LeaveFeedback;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LeaveFeedback.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::LeaveFeedback

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::LeaveFeedback inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackRequestType;
use eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'LeaveFeedback';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackResponseType';
}

#
# input properties
#

=head2 setCommentText()

Textual comment that explains, clarifies, or justifies the feedback
score specified in CommentType.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setCommentText {
   my $self   = shift;
   my $sCommentText = shift;
   $self->getRequestDataType()->setCommentText($sCommentText);
}

=head2 setCommentType()

Score for the feedback being left. May be Positive, Neutral, or
Negative.
<br><br>
<span class="tablenote"><b>Note:</b>
Beginning in May 2008, sellers can no longer leave neutral or negative
feedback for buyers. Buyers can no longer leave neutral or negative feedback
within 7 days from the end of the transaction for active PowerSellers who
have been on eBay for 12 months.
</span>

  RequiredInput: Yes
  AllValuesExcept: Withdrawn, IndependentlyWithdrawn
#    Argument: 'ns:CommentTypeCodeType'

=cut
       
sub setCommentType {
   my $self   = shift;
   my $sCommentType = shift;
   $self->getRequestDataType()->setCommentType($sCommentType);
}

=head2 setItemID()

The ID of an item. Specify the ID for the item of
the transaction of the users. The transaction must not have been
created more than 90 days before your attempt to leave feedback.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setSellerItemRatingDetailArray()

Container for detailed seller ratings (DSRs).
If a buyer is providing DSRs, they are specified in this container.
Sellers have access to the number of ratings they've received, as well as
to the averages of the DSRs they've received in each
DSR area (i.e., to the average of ratings in the item-description area, etc.).
By March 2007, the DSR feature will be available on the United Kingdom site
and on the following other sites: AU (site ID 15), BEFR (site ID 23),
BENL (site ID 123), FR (site ID 71), IE (site ID 205), IN (site ID 203),
IT (site ID 101), and PL (site ID 212).
In Summer 2007, the DSR feature will be available on the other
API-enabled country sites, including the US site (site ID 0).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DetailedSellerRatings
Title: Detailed Seller Ratings

  RequiredInput: No
#    Argument: 'ns:ItemRatingDetailArrayType'

=cut
       
sub setSellerItemRatingDetailArray {
   my $self   = shift;
   my $pSellerItemRatingDetailArray = shift;
   $self->getRequestDataType()->setSellerItemRatingDetailArray($pSellerItemRatingDetailArray);
}

=head2 setTargetUser()

Specifies the recipient user about whom the feedback is being left.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut
       
sub setTargetUser {
   my $self   = shift;
   my $pTargetUser = shift;
   $self->getRequestDataType()->setTargetUser($pTargetUser);
}

=head2 setTransactionID()

The item purchase transaction from the listing specified in ItemID for
which the feedback is being left. Required if the listing identified in
ItemID was a multi-item listing (Dutch auction or multi-item fixed-price
listing).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#

=head2 getFeedbackID()

The ID of the feedback that has been left.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getFeedbackID {
   my $self = shift;
   return $self->getResponseDataType()->getFeedbackID();
}





1;   
