# This file is encoded in UTF-8.
die "This file is not encoded in UTF-8.\n" if 'あ' ne "\xe3\x81\x82";
die "This script is for perl only. You are using $^X.\n" if $^X =~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use UTF8::R2;
use vars qw(@test);

tie my %r2, 'UTF8::R2';

BEGIN {
    $SIG{__WARN__} = sub {
        local($_) = @_;
        /\AIllegal hex digit ignored at /                      ? return :
        /\AIllegal hexadecimal digit '\|' ignored at /         ? return :
        /\AIllegal hexadecimal digit '\{' ignored at /         ? return :
        /\AUnrecognized escape \\h passed through at /         ? return :
        /\AUnrecognized escape \\v passed through at /         ? return :
        /\AUnrecognized escape \\R passed through at /         ? return :
        /\AUnrecognized escape \\H passed through at /         ? return :
        /\AUnrecognized escape \\V passed through at /         ? return :
        /\A\\C is deprecated in regex; marked by <-- HERE in / ? return :
        warn $_[0];
    };
}

@test = (
# 1
    sub { ("あい12ABC" =~ $r2{qr/./})                         },
    sub { ("あい12ABC" =~ $r2{qr/./})      && ($& eq 'あ')    },
    sub { ("あい12ABC" =~ $r2{qr/.{2}/})   && ($& eq 'あい')  },
    sub { ("あい12ABC" =~ $r2{qr/.{2}/})   && ($` eq '')      },
    sub { ("あい12ABC" =~ $r2{qr/.{2}/})   && ($' eq '12ABC') },
    sub { ("あい12ABC" =~ $r2{qr/(.{3})/}) && ($1 eq 'あい1') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 11
    sub { not ("あい12ABC" !~ $r2{qr/./})                         },
    sub { not ("あい12ABC" !~ $r2{qr/./})      && ($& eq 'あ')    },
    sub { not ("あい12ABC" !~ $r2{qr/.{2}/})   && ($& eq 'あい')  },
    sub { not ("あい12ABC" !~ $r2{qr/.{2}/})   && ($` eq '')      },
    sub { not ("あい12ABC" !~ $r2{qr/.{2}/})   && ($' eq '12ABC') },
    sub { not ("あい12ABC" !~ $r2{qr/(.{3})/}) && ($1 eq 'あい1') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 21
    sub { "0" =~ $r2{qr/[\d]/} },
    sub { "1" =~ $r2{qr/[\d]/} },
    sub { "2" =~ $r2{qr/[\d]/} },
    sub { "3" =~ $r2{qr/[\d]/} },
    sub { "4" =~ $r2{qr/[\d]/} },
    sub { "5" =~ $r2{qr/[\d]/} },
    sub { "6" =~ $r2{qr/[\d]/} },
    sub { "7" =~ $r2{qr/[\d]/} },
    sub { "8" =~ $r2{qr/[\d]/} },
    sub { "9" =~ $r2{qr/[\d]/} },
# 31
    sub { not ("A" =~ $r2{qr/[\d]/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 41
    sub { "A" =~ $r2{qr/[\w]/} },
    sub { "B" =~ $r2{qr/[\w]/} },
    sub { "C" =~ $r2{qr/[\w]/} },
    sub { "D" =~ $r2{qr/[\w]/} },
    sub { "E" =~ $r2{qr/[\w]/} },
    sub { "F" =~ $r2{qr/[\w]/} },
    sub { "G" =~ $r2{qr/[\w]/} },
    sub { "H" =~ $r2{qr/[\w]/} },
    sub { "I" =~ $r2{qr/[\w]/} },
    sub { "J" =~ $r2{qr/[\w]/} },
# 51
    sub { "K" =~ $r2{qr/[\w]/} },
    sub { "L" =~ $r2{qr/[\w]/} },
    sub { "M" =~ $r2{qr/[\w]/} },
    sub { "N" =~ $r2{qr/[\w]/} },
    sub { "O" =~ $r2{qr/[\w]/} },
    sub { "P" =~ $r2{qr/[\w]/} },
    sub { "Q" =~ $r2{qr/[\w]/} },
    sub { "R" =~ $r2{qr/[\w]/} },
    sub { "S" =~ $r2{qr/[\w]/} },
    sub { "T" =~ $r2{qr/[\w]/} },
# 61
    sub { "U" =~ $r2{qr/[\w]/} },
    sub { "V" =~ $r2{qr/[\w]/} },
    sub { "W" =~ $r2{qr/[\w]/} },
    sub { "X" =~ $r2{qr/[\w]/} },
    sub { "Y" =~ $r2{qr/[\w]/} },
    sub { "Z" =~ $r2{qr/[\w]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 71
    sub { "a" =~ $r2{qr/[\w]/} },
    sub { "b" =~ $r2{qr/[\w]/} },
    sub { "c" =~ $r2{qr/[\w]/} },
    sub { "d" =~ $r2{qr/[\w]/} },
    sub { "e" =~ $r2{qr/[\w]/} },
    sub { "f" =~ $r2{qr/[\w]/} },
    sub { "g" =~ $r2{qr/[\w]/} },
    sub { "h" =~ $r2{qr/[\w]/} },
    sub { "i" =~ $r2{qr/[\w]/} },
    sub { "j" =~ $r2{qr/[\w]/} },
# 81
    sub { "k" =~ $r2{qr/[\w]/} },
    sub { "l" =~ $r2{qr/[\w]/} },
    sub { "m" =~ $r2{qr/[\w]/} },
    sub { "n" =~ $r2{qr/[\w]/} },
    sub { "o" =~ $r2{qr/[\w]/} },
    sub { "p" =~ $r2{qr/[\w]/} },
    sub { "q" =~ $r2{qr/[\w]/} },
    sub { "r" =~ $r2{qr/[\w]/} },
    sub { "s" =~ $r2{qr/[\w]/} },
    sub { "t" =~ $r2{qr/[\w]/} },
# 91
    sub { "u" =~ $r2{qr/[\w]/} },
    sub { "v" =~ $r2{qr/[\w]/} },
    sub { "w" =~ $r2{qr/[\w]/} },
    sub { "x" =~ $r2{qr/[\w]/} },
    sub { "y" =~ $r2{qr/[\w]/} },
    sub { "z" =~ $r2{qr/[\w]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 101
    sub { "0" =~ $r2{qr/[\w]/} },
    sub { "1" =~ $r2{qr/[\w]/} },
    sub { "2" =~ $r2{qr/[\w]/} },
    sub { "3" =~ $r2{qr/[\w]/} },
    sub { "4" =~ $r2{qr/[\w]/} },
    sub { "5" =~ $r2{qr/[\w]/} },
    sub { "6" =~ $r2{qr/[\w]/} },
    sub { "7" =~ $r2{qr/[\w]/} },
    sub { "8" =~ $r2{qr/[\w]/} },
    sub { "9" =~ $r2{qr/[\w]/} },
# 111
    sub { "_" =~ $r2{qr/[\w]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 121
    sub { not ("あ" =~ $r2{qr/[\w]/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 131
    sub {     ("\t"   =~ $r2{qr/[\s]/}) },
    sub {     ("\n"   =~ $r2{qr/[\s]/}) },
    sub { not ("\x0B" =~ $r2{qr/[\s]/}) },
    sub {     ("\f"   =~ $r2{qr/[\s]/}) },
    sub {     ("\r"   =~ $r2{qr/[\s]/}) },
    sub {     ("\x20" =~ $r2{qr/[\s]/}) },
    sub { not ("\x85" =~ $r2{qr/[\s]/}) },
    sub { not ("\xA0" =~ $r2{qr/[\s]/}) },
    sub {1},
    sub {1},
# 141
    sub { ($] < 5.010) or     ("\t"   =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\n"   =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\x0B" =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\f"   =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\r"   =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or     ("\x20" =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\x85" =~ $r2{qr/[\h]/}) },
    sub { ($] < 5.010) or not ("\xA0" =~ $r2{qr/[\h]/}) },
    sub {1},
    sub {1},
# 151
    sub { ($] < 5.010) or not ("\t"   =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or     ("\n"   =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or     ("\x0B" =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or     ("\f"   =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or     ("\r"   =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or not ("\x20" =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or not ("\x85" =~ $r2{qr/[\v]/}) },
    sub { ($] < 5.010) or not ("\xA0" =~ $r2{qr/[\v]/}) },
    sub {1},
    sub {1},
# 161
    sub { 1 or eval q{ not (""   =~ $r2{qr/[\C]/})                                           }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/[\C]/})                                           }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/[\C]/})   && ($& eq "\xE3")                       }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/[\C]/})   && ($& eq "\xE3") && ($' eq "\x81\x82") }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/([\C])/})                                         }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/([\C])/}) && ($1 eq "\xE3")                       }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/([\C])/}) && ($1 eq "\xE3") && ($' eq "\x81\x82") }},
    sub {1},
    sub {1},
    sub {1},
# 171
    sub { 1 or eval q{     ("あ" =~ $r2{qr/[\N]/})                   }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/[\N]/})   && ($& eq 'あ') }},
    sub { 1 or eval q{     ("あ" =~ $r2{qr/([\N])/}) && ($1 eq 'あ') }},
    sub { 1 or eval q{ not ("\n" =~ $r2{qr/[\N]/})                   }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 181
    sub { 1 or eval q{ not ("あ"   =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\r\n" =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\r\n" =~ $r2{qr/[\R]/})   && ($& eq "\r\n") }},
    sub { 1 or eval q{     ("\r\n" =~ $r2{qr/([\R])/}) && ($1 eq "\r\n") }},
    sub { 1 or eval q{ not ("\t"   =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\n"   =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\x0B" =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\f"   =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{     ("\r"   =~ $r2{qr/[\R]/})                     }},
    sub { 1 or eval q{ not ("\x20" =~ $r2{qr/[\R]/})                     }},
# 191
    sub { 1 or eval q{ not ("\x85" =~ $r2{qr/[\R]/})   }},
    sub { 1 or eval q{ not ("\xA0" =~ $r2{qr/[\R]/})   }},
    sub { 1 or eval q{ not ("\r\n" =~ $r2{qr/[\R]\n/}) }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 201
    sub { "0" !~ $r2{qr/[\D]/} },
    sub { "1" !~ $r2{qr/[\D]/} },
    sub { "2" !~ $r2{qr/[\D]/} },
    sub { "3" !~ $r2{qr/[\D]/} },
    sub { "4" !~ $r2{qr/[\D]/} },
    sub { "5" !~ $r2{qr/[\D]/} },
    sub { "6" !~ $r2{qr/[\D]/} },
    sub { "7" !~ $r2{qr/[\D]/} },
    sub { "8" !~ $r2{qr/[\D]/} },
    sub { "9" !~ $r2{qr/[\D]/} },
# 211
    sub { not ("A" !~ $r2{qr/[\D]/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 221
    sub { "A" !~ $r2{qr/[\W]/} },
    sub { "B" !~ $r2{qr/[\W]/} },
    sub { "C" !~ $r2{qr/[\W]/} },
    sub { "D" !~ $r2{qr/[\W]/} },
    sub { "E" !~ $r2{qr/[\W]/} },
    sub { "F" !~ $r2{qr/[\W]/} },
    sub { "G" !~ $r2{qr/[\W]/} },
    sub { "H" !~ $r2{qr/[\W]/} },
    sub { "I" !~ $r2{qr/[\W]/} },
    sub { "J" !~ $r2{qr/[\W]/} },
# 231
    sub { "K" !~ $r2{qr/[\W]/} },
    sub { "L" !~ $r2{qr/[\W]/} },
    sub { "M" !~ $r2{qr/[\W]/} },
    sub { "N" !~ $r2{qr/[\W]/} },
    sub { "O" !~ $r2{qr/[\W]/} },
    sub { "P" !~ $r2{qr/[\W]/} },
    sub { "Q" !~ $r2{qr/[\W]/} },
    sub { "R" !~ $r2{qr/[\W]/} },
    sub { "S" !~ $r2{qr/[\W]/} },
    sub { "T" !~ $r2{qr/[\W]/} },
# 241
    sub { "U" !~ $r2{qr/[\W]/} },
    sub { "V" !~ $r2{qr/[\W]/} },
    sub { "W" !~ $r2{qr/[\W]/} },
    sub { "X" !~ $r2{qr/[\W]/} },
    sub { "Y" !~ $r2{qr/[\W]/} },
    sub { "Z" !~ $r2{qr/[\W]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 251
    sub { "a" !~ $r2{qr/[\W]/} },
    sub { "b" !~ $r2{qr/[\W]/} },
    sub { "c" !~ $r2{qr/[\W]/} },
    sub { "d" !~ $r2{qr/[\W]/} },
    sub { "e" !~ $r2{qr/[\W]/} },
    sub { "f" !~ $r2{qr/[\W]/} },
    sub { "g" !~ $r2{qr/[\W]/} },
    sub { "h" !~ $r2{qr/[\W]/} },
    sub { "i" !~ $r2{qr/[\W]/} },
    sub { "j" !~ $r2{qr/[\W]/} },
# 261
    sub { "k" !~ $r2{qr/[\W]/} },
    sub { "l" !~ $r2{qr/[\W]/} },
    sub { "m" !~ $r2{qr/[\W]/} },
    sub { "n" !~ $r2{qr/[\W]/} },
    sub { "o" !~ $r2{qr/[\W]/} },
    sub { "p" !~ $r2{qr/[\W]/} },
    sub { "q" !~ $r2{qr/[\W]/} },
    sub { "r" !~ $r2{qr/[\W]/} },
    sub { "s" !~ $r2{qr/[\W]/} },
    sub { "t" !~ $r2{qr/[\W]/} },
# 271
    sub { "u" !~ $r2{qr/[\W]/} },
    sub { "v" !~ $r2{qr/[\W]/} },
    sub { "w" !~ $r2{qr/[\W]/} },
    sub { "x" !~ $r2{qr/[\W]/} },
    sub { "y" !~ $r2{qr/[\W]/} },
    sub { "z" !~ $r2{qr/[\W]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 281
    sub { "0" !~ $r2{qr/[\W]/} },
    sub { "1" !~ $r2{qr/[\W]/} },
    sub { "2" !~ $r2{qr/[\W]/} },
    sub { "3" !~ $r2{qr/[\W]/} },
    sub { "4" !~ $r2{qr/[\W]/} },
    sub { "5" !~ $r2{qr/[\W]/} },
    sub { "6" !~ $r2{qr/[\W]/} },
    sub { "7" !~ $r2{qr/[\W]/} },
    sub { "8" !~ $r2{qr/[\W]/} },
    sub { "9" !~ $r2{qr/[\W]/} },
# 291
    sub { "_" !~ $r2{qr/[\W]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 301
    sub { not ("あ" !~ $r2{qr/[\W]/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 311
    sub {     ("\t"   !~ $r2{qr/[\S]/}) },
    sub {     ("\n"   !~ $r2{qr/[\S]/}) },
    sub { not ("\x0B" !~ $r2{qr/[\S]/}) },
    sub {     ("\f"   !~ $r2{qr/[\S]/}) },
    sub {     ("\r"   !~ $r2{qr/[\S]/}) },
    sub {     ("\x20" !~ $r2{qr/[\S]/}) },
    sub { not ("\x85" !~ $r2{qr/[\S]/}) },
    sub { not ("\xA0" !~ $r2{qr/[\S]/}) },
    sub {1},
    sub {1},
# 321
    sub { ($] < 5.010) or     ("\t"   !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\n"   !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\x0B" !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\f"   !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\r"   !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or     ("\x20" !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\x85" !~ $r2{qr/[\H]/}) },
    sub { ($] < 5.010) or not ("\xA0" !~ $r2{qr/[\H]/}) },
    sub {1},
    sub {1},
# 331
    sub { ($] < 5.010) or not ("\t"   !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or     ("\n"   !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or     ("\x0B" !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or     ("\f"   !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or     ("\r"   !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or not ("\x20" !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or not ("\x85" !~ $r2{qr/[\V]/}) },
    sub { ($] < 5.010) or not ("\xA0" !~ $r2{qr/[\V]/}) },
    sub {1},
    sub {1},
# 341
    sub { "\b" =~ $r2{qr/[\b]/} },
    sub { "]"  =~ $r2{qr/[\]]/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 351
    sub {             ("あAいう12" =~ $r2{qr/[いう]/})                      },
    sub {             ("あAいう12" =~ $r2{qr/[いう]/})    && ($& eq 'い')   },
    sub {             ("あAいう12" =~ $r2{qr/([いう])/})  && ($1 eq 'い')   },
    sub {             ("あAいう12" =~ $r2{qr/[いう]+/})   && ($& eq 'いう') },
    sub {             ("あAいう12" =~ $r2{qr/([いう]+)/}) && ($1 eq 'いう') },
    sub { my $i='い'; ("あAいう12" =~ $r2{qr/[${i}う]/})  && ($& eq 'い')   },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 361
    sub {                       ("あAいう12" =~ $r2{qr/[^いう]/})                     },
    sub { ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/[^いう]/})    && ($& eq 'あ')  },
    sub { ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/([^いう])/})  && ($1 eq 'あ')  },
    sub { ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/[^いう]+/})   && ($& eq 'あA') },
    sub { ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/([^いう]+)/}) && ($1 eq 'あA') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 371
    sub {                               not ("あAいう12" =~ $r2{qr/[えお]/})                    },
    sub {                                   ("あAいう12" =~ $r2{qr/[^えお]/})                   },
    sub {             ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/[^えお]/})   && ($& eq 'あ') },
    sub {             ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/([^えお])/}) && ($1 eq 'あ') },
    sub { my $e='え'; ($] =~ /\A5\.006/) or ("あAいう12" =~ $r2{qr/[^${e}お]/}) && ($& eq 'あ') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 381
    sub { "\x00"             =~ $r2{qr/[\x{00}]/}       },
    sub { "\x7F"             =~ $r2{qr/[\x{7F}]/}       },
    sub { "\xC2\x80"         =~ $r2{qr/[\x{C280}]/}     },
    sub { "\xDF\xBA"         =~ $r2{qr/[\x{DFBA}]/}     },
    sub { "\xE0\xA0\x80"     =~ $r2{qr/[\x{E0A080}]/}   },
    sub { "\xE0\xBF\x9A"     =~ $r2{qr/[\x{E0BF9A}]/}   },
    sub { return 'SKIP'; }, # "\xF0\x90\x80\x80" =~ $r2{qr/[\x{F0908080}]/} # avoid: Use of code point 0xF0908080 is not allowed; the permissible max is 0x7FFFFFFF
    sub { return 'SKIP'; }, # "\xF0\x90\xB9\xBE" =~ $r2{qr/[\x{F090B9BE}]/} # avoid: Use of code point 0xF0908080 is not allowed; the permissible max is 0x7FFFFFFF
    sub {1},
    sub {1},
# 391
    sub { ($] < 5.008) or eval q{ "\x00"             =~ $r2{qr/[\x{00}-\x{7F}]/}             } },
    sub { ($] < 5.008) or eval q{ "\x7F"             =~ $r2{qr/[\x{00}-\x{7F}]/}             } },
    sub { ($] < 5.008) or eval q{ "\xC2\x80"         =~ $r2{qr/[\x{C280}-\x{DFBA}]/}         } },
    sub { ($] < 5.008) or eval q{ "\xDF\xBA"         =~ $r2{qr/[\x{C280}-\x{DFBA}]/}         } },
    sub { ($] < 5.008) or eval q{ "\xE0\xA0\x80"     =~ $r2{qr/[\x{E0A080}-\x{E0BF9A}]/}     } },
    sub { ($] < 5.008) or eval q{ "\xE0\xBF\x9A"     =~ $r2{qr/[\x{E0A080}-\x{E0BF9A}]/}     } },
    sub { return 'SKIP'; }, # "\xF0\x90\x80\x80" =~ $r2{qr/[\x{F0908080}-\x{F090B9BE}]/} # avoid: Use of code point 0xF0908080 is not allowed; the permissible max is 0x7FFFFFFF
    sub { return 'SKIP'; }, # "\xF0\x90\xB9\xBE" =~ $r2{qr/[\x{F0908080}-\x{F090B9BE}]/} # avoid: Use of code point 0xF0908080 is not allowed; the permissible max is 0x7FFFFFFF
    sub {1},
    sub {1},
#
);

$|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" } ok($_->()) for @test;

__END__
