# Generated by default/object.tt
package Paws::AmplifyBackend::CreateTokenRespObj;
  use Moose;
  has AppId => (is => 'ro', isa => 'Str', request_name => 'appId', traits => ['NameInRequest'], required => 1);
  has ChallengeCode => (is => 'ro', isa => 'Str', request_name => 'challengeCode', traits => ['NameInRequest'], required => 1);
  has SessionId => (is => 'ro', isa => 'Str', request_name => 'sessionId', traits => ['NameInRequest'], required => 1);
  has Ttl => (is => 'ro', isa => 'Str', request_name => 'ttl', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::CreateTokenRespObj

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::CreateTokenRespObj object:

  $service_obj->Method(Att1 => { AppId => $value, ..., Ttl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::CreateTokenRespObj object:

  $result = $service_obj->Method(...);
  $result->Att1->AppId

=head1 DESCRIPTION

The response object for this operation.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AppId => Str

The app ID.


=head2 B<REQUIRED> ChallengeCode => Str

One-time challenge code for authenticating into the Amplify Admin UI.


=head2 B<REQUIRED> SessionId => Str

A unique ID provided when creating a new challenge token.


=head2 B<REQUIRED> Ttl => Str

The expiry time for the one-time generated token code.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

