# Generated by default/object.tt
package Paws::CloudFront::CachePolicyConfig;
  use Moose;
  has Comment => (is => 'ro', isa => 'Str');
  has DefaultTTL => (is => 'ro', isa => 'Int');
  has MaxTTL => (is => 'ro', isa => 'Int');
  has MinTTL => (is => 'ro', isa => 'Int', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has ParametersInCacheKeyAndForwardedToOrigin => (is => 'ro', isa => 'Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::CachePolicyConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::CachePolicyConfig object:

  $service_obj->Method(Att1 => { Comment => $value, ..., ParametersInCacheKeyAndForwardedToOrigin => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::CachePolicyConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Comment

=head1 DESCRIPTION

A cache policy configuration.

This configuration determines the following:

=over

=item *

The values that CloudFront includes in the cache key. These values can
include HTTP headers, cookies, and URL query strings. CloudFront uses
the cache key to find an object in its cache that it can return to the
viewer.

=item *

The default, minimum, and maximum time to live (TTL) values that you
want objects to stay in the CloudFront cache.

=back

The headers, cookies, and query strings that are included in the cache
key are automatically included in requests that CloudFront sends to the
origin. CloudFront sends a request when it canE<rsquo>t find a valid
object in its cache that matches the requestE<rsquo>s cache key. If you
want to send values to the origin but I<not> include them in the cache
key, use C<OriginRequestPolicy>.

=head1 ATTRIBUTES


=head2 Comment => Str

A comment to describe the cache policy. The comment cannot be longer
than 128 characters.


=head2 DefaultTTL => Int

The default amount of time, in seconds, that you want objects to stay
in the CloudFront cache before CloudFront sends another request to the
origin to see if the object has been updated. CloudFront uses this
value as the objectE<rsquo>s time to live (TTL) only when the origin
does I<not> send C<Cache-Control> or C<Expires> headers with the
object. For more information, see Managing How Long Content Stays in an
Edge Cache (Expiration)
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
in the I<Amazon CloudFront Developer Guide>.

The default value for this field is 86400 seconds (one day). If the
value of C<MinTTL> is more than 86400 seconds, then the default value
for this field is the same as the value of C<MinTTL>.


=head2 MaxTTL => Int

The maximum amount of time, in seconds, that objects stay in the
CloudFront cache before CloudFront sends another request to the origin
to see if the object has been updated. CloudFront uses this value only
when the origin sends C<Cache-Control> or C<Expires> headers with the
object. For more information, see Managing How Long Content Stays in an
Edge Cache (Expiration)
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
in the I<Amazon CloudFront Developer Guide>.

The default value for this field is 31536000 seconds (one year). If the
value of C<MinTTL> or C<DefaultTTL> is more than 31536000 seconds, then
the default value for this field is the same as the value of
C<DefaultTTL>.


=head2 B<REQUIRED> MinTTL => Int

The minimum amount of time, in seconds, that you want objects to stay
in the CloudFront cache before CloudFront sends another request to the
origin to see if the object has been updated. For more information, see
Managing How Long Content Stays in an Edge Cache (Expiration)
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
in the I<Amazon CloudFront Developer Guide>.


=head2 B<REQUIRED> Name => Str

A unique name to identify the cache policy.


=head2 ParametersInCacheKeyAndForwardedToOrigin => L<Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin>

The HTTP headers, cookies, and URL query strings to include in the
cache key. The values included in the cache key are automatically
included in requests that CloudFront sends to the origin.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

