# Generated by default/object.tt
package Paws::DMS::AvailabilityZone;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::AvailabilityZone

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::AvailabilityZone object:

  $service_obj->Method(Att1 => { Name => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::AvailabilityZone object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

The name of an Availability Zone for use during database migration.
C<AvailabilityZone> is an optional parameter to the
C<CreateReplicationInstance>
(https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationInstance.html)
operation, and itE<rsquo>s value relates to the AWS Region of an
endpoint. For example, the availability zone of an endpoint in the
us-east-1 region might be us-east-1a, us-east-1b, us-east-1c, or
us-east-1d.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the Availability Zone.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

