# Generated by default/object.tt
package Paws::GlobalAccelerator::PortOverride;
  use Moose;
  has EndpointPort => (is => 'ro', isa => 'Int');
  has ListenerPort => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::PortOverride

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::PortOverride object:

  $service_obj->Method(Att1 => { EndpointPort => $value, ..., ListenerPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::PortOverride object:

  $result = $service_obj->Method(...);
  $result->Att1->EndpointPort

=head1 DESCRIPTION

Override specific listener ports used to route traffic to endpoints
that are part of an endpoint group. For example, you can create a port
override in which the listener receives user traffic on ports 80 and
443, but your accelerator routes that traffic to ports 1080 and 1443,
respectively, on the endpoints.

For more information, see Port overrides
(https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
in the I<AWS Global Accelerator Developer Guide>.

=head1 ATTRIBUTES


=head2 EndpointPort => Int

The endpoint port that you want a listener port to be mapped to. This
is the port on the endpoint, such as the Application Load Balancer or
Amazon EC2 instance.


=head2 ListenerPort => Int

The listener port that you want to map to a specific endpoint port.
This is the port that user traffic arrives to the Global Accelerator
on.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

