# Generated by default/object.tt
package Paws::RedshiftData::StatementData;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has QueryParameters => (is => 'ro', isa => 'ArrayRef[Paws::RedshiftData::SqlParameter]');
  has QueryString => (is => 'ro', isa => 'Str');
  has SecretArn => (is => 'ro', isa => 'Str');
  has StatementName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has UpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RedshiftData::StatementData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RedshiftData::StatementData object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RedshiftData::StatementData object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

The SQL statement to run.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The date and time (UTC) the statement was created.


=head2 B<REQUIRED> Id => Str

The SQL statement identifier. This value is a universally unique
identifier (UUID) generated by Amazon Redshift Data API.


=head2 QueryParameters => ArrayRef[L<Paws::RedshiftData::SqlParameter>]

The parameters used in a SQL statement.


=head2 QueryString => Str

The SQL statement.


=head2 SecretArn => Str

The name or Amazon Resource Name (ARN) of the secret that enables
access to the database.


=head2 StatementName => Str

The name of the SQL statement.


=head2 Status => Str

The status of the SQL statement. An example is the that the SQL
statement finished.


=head2 UpdatedAt => Str

The date and time (UTC) that the statement metadata was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RedshiftData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

