# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsTaskDefinitionDetails;
  use Moose;
  has ContainerDefinitions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails]');
  has Cpu => (is => 'ro', isa => 'Str');
  has ExecutionRoleArn => (is => 'ro', isa => 'Str');
  has Family => (is => 'ro', isa => 'Str');
  has InferenceAccelerators => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionInferenceAcceleratorsDetails]');
  has IpcMode => (is => 'ro', isa => 'Str');
  has Memory => (is => 'ro', isa => 'Str');
  has NetworkMode => (is => 'ro', isa => 'Str');
  has PidMode => (is => 'ro', isa => 'Str');
  has PlacementConstraints => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionPlacementConstraintsDetails]');
  has ProxyConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionProxyConfigurationDetails');
  has RequiresCompatibilities => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has TaskRoleArn => (is => 'ro', isa => 'Str');
  has Volumes => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionVolumesDetails]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsTaskDefinitionDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsTaskDefinitionDetails object:

  $service_obj->Method(Att1 => { ContainerDefinitions => $value, ..., Volumes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsTaskDefinitionDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ContainerDefinitions

=head1 DESCRIPTION

details about a task definition. A task definition describes the
container and volume definitions of an Amazon Elastic Container Service
task.

=head1 ATTRIBUTES


=head2 ContainerDefinitions => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails>]

The container definitions that describe the containers that make up the
task.


=head2 Cpu => Str

The number of CPU units used by the task.


=head2 ExecutionRoleArn => Str

The ARN of the task execution role that grants the container agent
permission to make API calls on behalf of the container user.


=head2 Family => Str

The name of a family that this task definition is registered to.


=head2 InferenceAccelerators => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionInferenceAcceleratorsDetails>]

The Elastic Inference accelerators to use for the containers in the
task.


=head2 IpcMode => Str

The IPC resource namespace to use for the containers in the task.


=head2 Memory => Str

The amount (in MiB) of memory used by the task.


=head2 NetworkMode => Str

The Docker networking mode to use for the containers in the task.


=head2 PidMode => Str

The process namespace to use for the containers in the task.


=head2 PlacementConstraints => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionPlacementConstraintsDetails>]

The placement constraint objects to use for tasks.


=head2 ProxyConfiguration => L<Paws::SecurityHub::AwsEcsTaskDefinitionProxyConfigurationDetails>

The configuration details for the App Mesh proxy.


=head2 RequiresCompatibilities => ArrayRef[Str|Undef]

The task launch types that the task definition was validated against.


=head2 TaskRoleArn => Str

The short name or ARN of the IAM role that grants containers in the
task permission to call AWS API operations on your behalf.


=head2 Volumes => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionVolumesDetails>]

The data volume definitions for the task.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

